/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3HA5_AMB567MK01_H_
#define _SS_DSI_SMART_DIMMING_S6E3HA5_AMB567MK01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

/* 6.5*4194304 */
#define VREG0_REF_6P5 27262976
/* 6.4*4194304 */
#define VREG0_REF_6P4 26843546
/* 6.3*4194304 */
#define VREG0_REF_6P3 26424115
/* 6.2*4194304 */
#define VREG0_REF_6P2 26004685

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP+1];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* V0,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static int vt_coefficient[] = {
   	  0,  12,  24,  36,
	 48,  60,  72,  84,
	 96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
 	{0x80, 0x80, 0x80},		/* V1 */
 	{0x80, 0x80, 0x80},		/* V7 */
 	{0x80, 0x80, 0x80},		/* V11 */
 	{0x80, 0x80, 0x80},		/* V23 */
 	{0x80, 0x80, 0x80},		/* V35 */
 	{0x80, 0x80, 0x80},		/* V51 */
 	{0x80, 0x80, 0x80},		/* V87 */
 	{0x80, 0x80, 0x80},		/* V151 */
 	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

/* 443 is made but not used */
static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* HERO2 revA */
static unsigned int base_luminance_grace_revA[LUMINANCE_MAX][2] = {
	{2, 	119},
	{3, 	119},
	{4, 	119},
	{5, 	119},
	{6, 	119},
	{7, 	119},
	{8, 	119},
	{9, 	119},
	{10,	119},
	{11,	119},
	{12,	119},
	{13,	119},
	{14,	119},
	{15,	119},
	{16,	119},
	{17,	119},
	{19,	119},
	{20,	119},
	{21,	119},
	{22,	119},
	{24,	119},
	{25,	119},
	{27,	119},
	{29,	119},
	{30,	119},
	{32,	119},
	{34,	119},
	{37,	119},
	{39,	119},
	{41,	119},
	{44,	119},
	{47,	119},
	{50,	119},
	{53,	119},
	{56,	119},
	{60,	119},
	{64,	119},
	{68,	125},
	{72,	131},
	{77,	140},
	{82,	147},
	{87,	157},
	{93,	166},
	{98,	174},
	{105,	186},
	{111,	195},
	{119,	207},
	{126,	217},
	{134,	228},
	{143,	241},
	{152,	252},
	{162,	268},
	{172,	280},
	{183,	292},
	{195,	292},
	{207,	292},
	{220,	292},
	{234,	292},
	{249,	300},
	{265,	316},
	{282,	328},
	{300,	344},
	{316,	358},
	{333,	374},
	{350,	392},
	{357,	395},
	{365,	402},
	{372,	402},
	{380,	402},
	{387,	402},
	{395,	402},
	{403,	409},
	{412,	416},
	{420,	420},
};

static int gradation_offset_grace_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 9, 16, 25, 33, 37, 40, 40, 40},
	{0, 9, 15, 23, 29, 33, 37, 37, 37},
	{0, 8, 13, 21, 25, 28, 32, 32, 32},
	{0, 7, 11, 19, 22, 25, 29, 29, 29},
	{0, 7, 11, 18, 21, 25, 29, 29, 29},
	{0, 6, 9, 17, 20, 23, 27, 27, 27},
	{0, 6, 9, 15, 18, 21, 25, 25, 25},
	{0, 6, 8, 14, 17, 20, 23, 24, 24},
	{0, 5, 7, 14, 16, 19, 22, 23, 23},
	{0, 5, 7, 12, 15, 18, 21, 22, 22},
	{0, 5, 6, 12, 15, 17, 20, 22, 22},
	{0, 5, 6, 11, 14, 16, 19, 21, 21},
	{0, 5, 6, 11, 14, 16, 19, 21, 21},
	{0, 5, 6, 10, 13, 15, 18, 20, 20},
	{0, 5, 6, 10, 12, 14, 17, 20, 20},
	{0, 4, 5, 9, 11, 13, 16, 19, 19},
	{0, 5, 6, 9, 11, 13, 16, 20, 20},
	{0, 5, 6, 9, 10, 12, 15, 18, 18},
	{0, 5, 5, 8, 10, 12, 15, 18, 18},
	{0, 5, 5, 8, 9, 11, 14, 18, 18},
	{0, 4, 4, 7, 8, 10, 13, 16, 17},
	{0, 4, 4, 7, 8, 10, 13, 16, 17},
	{0, 4, 4, 7, 8, 10, 12, 15, 16},
	{0, 3, 3, 6, 7, 8, 10, 14, 16},
	{0, 3, 3, 6, 7, 8, 10, 14, 16},
	{0, 3, 3, 5, 6, 8, 10, 14, 16},
	{0, 3, 3, 5, 6, 7, 9, 13, 15},
	{0, 3, 3, 5, 6, 7, 9, 13, 15},
	{0, 2, 2, 4, 5, 7, 9, 13, 15},
	{0, 3, 3, 4, 5, 6, 8, 11, 11},
	{0, 3, 3, 4, 4, 5, 7, 10, 10},
	{0, 3, 2, 3, 4, 5, 6, 9, 9},
	{0, 3, 3, 3, 3, 4, 5, 8, 8},
	{0, 3, 2, 3, 3, 4, 5, 8, 9},
	{0, 2, 2, 3, 3, 4, 5, 8, 9},
	{0, 2, 1, 3, 3, 3, 4, 7, 8},
	{0, 2, 1, 2, 2, 2, 3, 6, 7},
	{0, 1, 1, 2, 3, 3, 4, 6, 6},
	{0, 2, 1, 3, 3, 3, 4, 6, 6},
	{0, 2, 1, 3, 3, 3, 4, 6, 6},
	{0, 0, 0, 2, 2, 3, 4, 7, 7},
	{0, 2, 1, 2, 2, 3, 3, 6, 6},
	{0, 1, 1, 2, 1, 2, 3, 5, 5},
	{0, 1, 1, 2, 2, 2, 3, 5, 6},
	{0, 2, 1, 2, 1, 2, 2, 4, 4},
	{0, 1, 1, 2, 2, 2, 3, 5, 5},
	{0, 0, 2, 2, 2, 2, 2, 4, 4},
	{0, 0, 2, 2, 2, 2, 2, 4, 5},
	{0, 1, 2, 2, 2, 2, 3, 4, 4},
	{0, 0, 2, 2, 2, 2, 2, 4, 5},
	{0, 0, 2, 2, 1, 1, 2, 4, 5},
	{0, 0, 0, 2, 2, 2, 2, 3, 5},
	{0, 1, 1, 1, 1, 2, 2, 3, 5},
	{0, 1, 1, 0, 0, 1, 1, 2, 2},
	{0, 0, 2, 1, 0, 1, 1, 2, 3},
	{0, 0, 1, 1, 0, 0, 0, 2, 3},
	{0, 1, 0, 1, 0, 1, 0, 1, 3},
	{0, 1, 1, 0, 0, 0, 0, 1, 2},
	{0, 0, 1, 0, 0, 0, 0, 1, 2},
	{0, 0, 1, 0, 0, 0, 0, 1, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 2},
	{0, 1, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 1, 0, 0, 1, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
};

static int rgb_offset_grace_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-10, 0, -12, -3, 1, -4, -5, 0, -5, -13, 0, -14, -22, -1, -22, -10, 0, -17, -8, 1, -15, -8, 1, -15, -8, 1, -15},
	{-8, 0, -9, -3, 0, -4, -6, 0, -6, -12, 0, -14, -20, 0, -20, -15, -1, -20, -12, -2, -18, -12, -2, -18, -12, -2, -18},
	{-6, 0, -7, -3, 0, -4, -5, 0, -5, -13, 0, -14, -18, 1, -19, -11, 0, -17, -11, 1, -19, -11, 1, -19, -11, 1, -19},
	{-5, 0, -7, -3, 0, -3, -3, 0, -4, -12, 0, -13, -15, 1, -19, -10, 2, -15, -14, 1, -22, -14, 1, -22, -14, 1, -22},
	{-4, 0, -5, -2, 0, -3, -3, 1, -4, -11, 0, -12, -15, 1, -20, -11, -1, -17, -15, 1, -22, -15, 1, -22, -15, 1, -22},
	{-3, 0, -5, -2, 0, -2, -3, 0, -3, -11, 0, -13, -17, -1, -21, -11, 2, -17, -18, -1, -24, -18, -1, -24, -18, -1, -24},
	{-3, 0, -4, -2, 0, -2, -2, 0, -3, -10, 1, -11, -13, 1, -18, -12, 1, -17, -17, -1, -24, -26, -9, -6, -26, -9, -6},
	{-2, 0, -3, -1, 0, -2, -4, 0, -3, -9, 1, -10, -13, 1, -18, -12, 1, -18, -15, 1, -23, -18, -2, 1, -18, -2, 1},
	{-2, 0, -3, -1, 1, -1, -2, 0, -3, -9, 0, -10, -12, 2, -17, -11, 0, -19, -15, 2, -23, -12, 3, 6, -12, 3, 6},
	{-1, 0, -3, -1, 1, -1, -2, 0, -2, -7, 1, -10, -12, 1, -17, -11, -1, -19, -15, -1, -23, -15, 3, 1, -15, 3, 1},
	{-1, 0, -2, -1, 1, -1, -1, 0, -2, -9, 0, -10, -13, 0, -19, -8, 1, -17, -13, 1, -22, -16, 0, -1, -16, 0, -1},
	{0, 0, -2, -2, 1, -1, -1, 0, -2, -8, 0, -9, -12, 0, -16, -8, 2, -17, -12, 1, -23, 15, 4, 2, 15, 4, 2},
	{0, 0, -2, -2, 0, -1, -1, 0, -2, -7, 0, -8, -13, -1, -18, -9, 2, -18, -13, 2, -23, 17, 2, -2, 17, 2, -2},
	{0, 0, -2, -1, 0, -1, -1, 0, -1, -6, 1, -7, -13, -1, -18, -10, 0, -17, -11, 3, -22, 15, 2, -4, 15, 2, -4},
	{0, 0, -1, -2, 0, -1, 0, 0, -2, -7, 0, -7, -10, 2, -15, -10, 0, -19, -12, 3, -24, 11, -1, -8, -36, -25, -50},
	{0, 0, -2, -1, 0, -1, -1, 0, -1, -5, 1, -6, -10, 2, -14, -10, -1, -19, -13, 4, -23, 7, -3, -11, 7, -3, -11},
	{2, 0, 0, -3, 0, -2, 0, 0, -1, -7, 0, -7, -10, 0, -14, -10, 0, -19, -17, 0, -26, -18, -1, -41, -29, -19, -42},
	{1, 0, 0, 0, 2, 0, -1, -1, -2, -6, 1, -6, -9, 2, -12, -9, -1, -17, -13, 3, -23, -17, 4, -39, -13, -7, -27},
	{1, 0, 0, 0, 1, 0, -3, -1, -3, -4, 1, -5, -11, 0, -13, -11, -2, -19, -17, 0, -26, -18, 1, -42, -9, -4, -23},
	{1, 0, 0, -1, 1, -1, -1, 0, -1, -4, 1, -5, -9, 2, -12, -10, -1, -16, -18, -2, -28, -22, -1, -45, -5, -1, -19},
	{1, 0, 0, -1, 0, -2, -1, 0, 1, -4, 1, -5, -8, 2, -12, -10, -1, -15, -20, -3, -31, -18, 4, -41, -3, -2, -17},
	{1, 0, 1, 0, 1, -1, -1, 0, 0, -5, 0, -6, -8, 1, -11, -10, -1, -16, -19, -2, -28, -18, 2, -43, 1, 1, -13},
	{1, 0, 0, 1, 2, 1, -2, -1, -1, -4, 0, -5, -9, -1, -13, -12, -3, -16, -15, 2, -25, -17, 4, -42, 4, 4, -9},
	{1, 0, 0, -1, 0, 0, 0, 0, -1, -4, 0, -4, -7, 1, -10, -6, 3, -11, -16, 2, -26, -22, -3, -47, -2, 0, -14},
	{1, 0, 0, 1, 2, 2, -2, 0, -1, -3, -1, -5, -8, 0, -11, -5, 3, -9, -16, 2, -25, -22, -3, -47, -2, 0, -12},
	{1, 0, 0, 1, 2, 1, 0, 0, 1, -3, 0, -4, -8, 0, -10, -9, -1, -14, -20, -1, -28, -25, -5, -50, 1, 3, -8},
	{1, 0, 0, 0, 1, 0, -1, -1, -1, -1, 2, -1, -8, -1, -10, -6, 2, -11, -17, 0, -25, -23, -5, -49, -1, 0, -11},
	{1, 0, 1, -1, 0, -2, -1, -1, 1, -3, 0, -4, -8, -2, -11, -6, 2, -9, -19, -4, -27, -27, -5, -49, -47, -2, -27},
	{1, 0, 0, 0, 0, 0, 1, 0, 0, -3, -1, -4, -7, -1, -10, -10, -3, -13, -23, -5, -27, -27, -5, -49, -40, 4, -20},
	{1, 0, 0, -1, 0, 0, 0, 0, 0, -2, 0, -3, -7, -2, -10, -5, 3, -8, -19, -3, -25, -17, 4, -39, -25, -14, -36},
	{1, 0, 0, 1, 1, 1, -1, 0, 0, -2, 0, -2, -3, 1, -7, -6, 1, -8, -18, -2, -22, -18, 5, -41, -21, -5, -17},
	{0, 0, 0, 0, 0, -1, 1, -1, 0, -1, 1, 0, -5, -1, -9, -6, 0, -8, -10, 6, -14, -19, 5, -42, -17, -1, -12},
	{1, 0, 0, 0, 1, 1, 0, -1, 0, -1, 1, -1, -2, 2, -4, -4, 1, -7, -7, 7, -12, -19, 4, -42, -13, 4, -8},
	{1, 0, 0, 0, 0, 1, 0, -1, 0, -1, 1, -2, -2, 1, -4, -5, 1, -7, -9, 4, -13, -22, 2, -45, -17, -4, -15},
	{1, 0, 0, 0, -1, 0, 0, -1, 0, -2, -1, -3, -2, 1, -4, -6, -2, -8, -8, 5, -10, -26, -2, -48, 2, -1, -12},
	{1, 0, 0, 2, 1, 2, -2, -2, -3, -2, 0, -1, -2, 1, -3, -1, 3, -4, -4, 7, -7, -29, -4, -49, 7, 3, -9},
	{1, 0, 0, 1, 1, 1, 1, 0, 0, -3, -1, -2, 1, 3, -1, -1, 3, -3, 0, 9, -3, -30, -4, -50, 12, 6, -5},
	{1, 0, 1, -1, 0, -1, 1, -1, 0, 0, 1, 0, -3, -2, -5, -2, 2, -3, -4, 3, -7, -22, 3, -40, -16, -12, -36},
	{2, 0, 0, 0, 1, 1, -1, -2, -1, -1, 0, 0, -2, -2, -6, -1, 1, -3, -4, 5, -6, -19, 7, -37, -13, -9, -32},
	{2, 0, 1, -1, 0, 1, 1, 0, 0, -1, -1, -2, -3, -2, -5, 2, 5, 0, -10, -2, -10, -14, 8, -32, -7, -7, -25},
	{2, 0, 0, 0, 0, 0, 0, -1, 0, 1, 1, 1, -3, -2, -5, -3, -2, -5, -9, 1, -9, -26, -3, -41, 0, -3, -23},
	{1, 0, 0, 1, 2, 1, 1, 0, 2, -1, 0, -1, -1, 0, -3, -1, 1, -2, -5, 5, -4, -29, -4, -39, 3, 0, -21},
	{2, 0, 0, 0, 1, 0, 2, 1, 2, -1, 1, -1, -2, -1, -4, 1, 2, 0, -6, 1, -5, -21, 6, -30, 12, 4, -16},
	{1, 0, -1, 1, 1, 2, 2, 1, 2, 1, 1, 0, -2, 0, -3, -4, -3, -5, -2, 5, -3, -25, 3, -33, 1, -4, -25},
	{1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, -3, 2, 3, 1, -1, 6, -1, -12, 9, -23, 1, -7, -22},
	{0, 0, -1, 0, 0, 0, 3, 2, 3, 0, 1, -1, -1, 0, -1, -2, -1, -3, -8, -2, -6, -14, 7, -24, 7, 0, -22},
	{2, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, -1, 1, -2, -3, -3, -4, 0, 6, 1, -13, 8, -20, 11, 5, -19},
	{1, 0, -1, 0, -1, 0, 0, -1, 1, -1, 1, -1, -2, -3, -3, 2, 2, 0, -3, 3, -1, -22, 3, -23, 2, 2, -17},
	{2, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, -2, -2, -3, -1, 0, -2, -7, -2, -6, -14, 4, -19, 13, 5, -14},
	{1, 0, -1, 1, 0, 2, 0, 0, -1, 0, 0, 2, -2, -2, -3, 3, 3, 1, -3, 4, 0, -20, -1, -24, 1, -2, -23},
	{0, 0, -1, 0, 0, 0, 1, 1, 3, -1, 0, -1, 0, 1, 0, 2, 2, 1, -6, 0, -2, -23, -4, -26, 4, 1, -19},
	{1, 0, -1, 1, 1, 2, 0, 1, 0, -1, 0, 0, 0, -1, -3, -3, -2, -2, -6, 1, -3, -18, 1, -18, -5, -1, -25},
	{0, 0, -1, 2, 2, 2, 0, 0, 1, 1, 1, 2, -1, 0, -3, -2, -2, -2, -3, 4, -1, -21, -2, -20, -2, 2, -21},
	{0, 0, -1, 2, 2, 2, 2, 1, 1, 0, 1, 2, 1, 2, 0, -2, -2, -2, -5, 0, -4, -11, 5, -8, 18, 6, -11},
	{1, 0, 0, -1, 0, -1, 2, 1, 2, 0, 0, 1, 1, 1, 0, -2, -2, -1, -8, -3, -6, -8, 9, -5, 6, -1, -20},
	{0, 0, -1, -1, -1, 0, 0, 0, -1, 1, 0, 3, 1, 1, 0, 3, 3, 2, -3, 1, 1, -16, 0, -13, 12, 5, -12},
	{0, 0, -1, 2, 2, 2, 0, 0, 0, 0, -1, 0, 1, 1, 2, -2, -3, -2, 0, 3, 3, -7, 9, -4, 2, -4, -20},
	{0, 0, -1, 2, 2, 2, 1, 0, 2, 0, 0, -1, -1, 0, 0, 2, 0, 1, -1, 1, 2, -11, 6, -7, 14, 5, -10},
	{1, 0, 0, 0, 0, 1, 1, 0, 2, 0, 0, -1, 0, 0, 1, 4, 2, 4, -3, -2, -1, -13, 3, -9, 11, 5, -4},
	{0, 0, -1, 0, 0, 1, 0, 1, 0, 1, 0, 2, 1, 1, 0, 0, -2, 0, 1, 1, 2, -11, 4, -6, 7, 2, -7},
	{0, 0, 0, -2, -1, -1, 2, 0, 1, -1, 0, 0, 1, 0, 1, -3, -4, -3, -2, -1, -1, -16, -2, -7, 2, 1, -11},
	{0, 0, -1, 1, 2, 2, -1, -1, -1, 2, 1, 2, -1, 0, 0, 0, -1, 0, 2, 3, 3, -3, 0, -2, 9, 5, 3},
	{0, 0, -1, -2, -1, -2, 2, 1, 2, 1, 0, 2, 0, 0, -1, -1, -3, -1, -8, -4, -4, 3, 6, 6, 9, 5, 2},
	{0, 0, 0, -1, -1, -2, 4, 4, 5, -2, -3, -3, -1, -1, 0, -4, -6, -3, -4, -1, -1, 0, 3, 4, -5, -3, -9},
	{0, 0, 0, -3, -2, -2, 3, 1, 2, 0, 0, 0, -1, 0, 0, -1, -3, -1, -8, -4, -4, 3, 6, 8, 8, 6, 1},
	{0, 0, -1, -2, -2, -2, 1, 0, 1, -1, -1, 0, -1, 0, 0, -5, -6, -4, -4, -1, 0, -7, -2, 0, -1, 3, -6},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

/************
 *	  HMT   *
 ************/

static unsigned int base_luminance_reverse_hmt_single[][2] = {
	{10,	48},
	{11,	53},
	{12,	59},
	{13,	64},
	{14,	69},
	{15,	73},
	{16,	78},
	{17,	83},
	{19,	92},
	{20,	95},
	{21,	100},
	{22,	104},
	{23,	108},
	{25,	117},
	{27,	125},
	{29,	132},
	{31,	143},
	{33,	151},
	{35,	160},
	{37,	167},
	{39,	177},
	{41,	183},
	{44,	195},
	{47,	208},
	{50,	220},
	{53,	229},
	{56,	244},
	{60,	256},
	{64,	267},
	{68,	281},
	{72,	291},
	{77,	229},
	{82,	242},
	{87,	255},
	{93,	268},
	{99,	281},
	{105,	295},
};

static int gradation_offset_reverse_hmt_single[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, -1, -1, 2, 4, 5, 6, 8, 8},
	{0, -2, -1, 0, 4, 6, 7, 7, 8},
	{0, -3, -1, 0, 4, 5, 6, 8, 8},
	{0, -4, -1, 0, 4, 4, 6, 7, 8},
	{0, -4, -1, 0, 4, 5, 6, 8, 9},
	{0, -4, -1, 0, 3, 4, 6, 8, 9},
	{0, -3, -1, 0, 3, 4, 6, 8, 9},
	{0, -4, -1, 0, 4, 4, 5, 7, 8},
	{0, -3, -1, 0, 3, 4, 6, 7, 8},
	{0, -2, -2, 0, 3, 4, 6, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 8},
	{0, -2, -1, 0, 2, 4, 5, 8, 8},
	{0, -1, -1, 0, 2, 4, 4, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 9},
	{0, -1, -1, 0, 3, 4, 6, 7, 9},
	{0, -1, -1, 0, 3, 4, 4, 7, 8},
	{0, -1, 0, 0, 3, 4, 5, 8, 8},
	{0, -2, -1, 2, 3, 4, 4, 7, 8},
	{0, -1, 0, 2, 3, 4, 4, 7, 8},
	{0, -2, 0, 3, 3, 4, 5, 7, 8},
	{0, -2, 0, 2, 3, 4, 4, 7, 8},
	{0, -2, 0, 3, 4, 4, 4, 7, 8},
	{0, -2, 0, 3, 3, 3, 4, 6, 9},
	{0, -2, 0, 4, 4, 4, 4, 7, 8},
	{0, -2, 2, 3, 4, 4, 5, 7, 8},
	{0, -2, 2, 3, 4, 4, 4, 7, 8},
	{0, -1, 3, 4, 4, 4, 5, 7, 8},
	{0, 0, 4, 4, 4, 4, 4, 6, 8},
	{0, 0, 4, 5, 4, 4, 5, 7, 9},
	{0, 0, 5, 5, 4, 4, 4, 7, 9},
	{0, -3, 0, 2, 2, 0, 3, 4, 4},
	{0, -3, 0, 3, 0, 2, 2, 4, 4},
	{0, -3, 0, 2, 0, 2, 3, 4, 4},
	{0, -2, 0, 3, 2, 0, 2, 3, 4},
	{0, -2, 2, 3, 2, 3, 2, 3, 4},
	{0, -1, 3, 3, 3, 2, 2, 4, 4},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-1, 0, 0, -1, 0, -1, -3, 0, -3, -5, 2, -6, -7, 6, -12, -11, 7, -16, -22, 11, -22, -28, 12, -26, 6, -12, 1},
	{0, 0, 0, -1, 0, -1, -2, 0, -3, -5, 3, -6, -7, 5, -10, -9, 6, -12, -20, 10, -20, -27, 14, -30, 10, -8, 1},
	{-1, 0, 0, -1, 0, 0, -2, 0, -3, -6, 2, -6, -6, 5, -10, -10, 6, -14, -19, 9, -20, -30, 12, -26, 12, -6, -2},
	{0, 0, 0, -2, 0, -1, -1, 0, -2, -5, 2, -6, -6, 5, -10, -8, 7, -14, -19, 9, -19, -28, 14, -29, 12, -6, -2},
	{0, 0, 0, -2, 0, 0, 0, 0, -2, -5, 2, -5, -7, 4, -10, -9, 6, -13, -15, 8, -16, -30, 14, -30, 2, 0, -2},
	{-1, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -5, -7, 4, -10, -9, 5, -12, -16, 8, -17, -27, 14, -30, 0, 0, -4},
	{-2, 0, -1, 0, 0, 1, -1, 0, -1, -5, 2, -6, -4, 4, -8, -9, 6, -12, -14, 8, -17, -28, 14, -30, 0, 0, -4},
	{-1, 0, 0, 0, 0, 0, -1, 0, -2, -3, 2, -4, -5, 4, -9, -8, 5, -11, -15, 9, -18, -25, 14, -28, 2, 2, -4},
	{0, 0, 0, -2, 0, 0, -1, 0, -2, -3, 2, -5, -6, 4, -8, -7, 6, -12, -12, 7, -14, -31, 16, -32, 2, 2, -4},
	{-1, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -5, -6, 3, -8, -8, 5, -10, -13, 7, -16, -31, 16, -34, 2, 3, -4},
	{0, 0, 0, -2, 0, 0, 0, 0, -1, -3, 2, -4, -6, 3, -7, -7, 4, -10, -15, 8, -17, -34, 16, -34, 1, 2, -5},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -2, 2, -4, -6, 3, -8, -8, 5, -11, -11, 8, -16, -29, 15, -32, 6, 8, -1},
	{0, 0, 0, -1, 0, 1, 0, 0, 0, -2, 2, -4, -5, 3, -7, -6, 4, -9, -15, 8, -18, -25, 12, -26, 6, 8, -1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -4, 3, -7, -7, 4, -10, -14, 8, -17, -25, 13, -27, 6, 8, -1},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -4, 1, -4, -5, 3, -6, -6, 4, -10, -12, 7, -15, -30, 14, -30, -6, 0, -9},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -5, 2, -6, -5, 4, -9, -10, 6, -13, -27, 15, -31, -6, 1, -9},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -3, -6, 2, -6, -5, 4, -8, -13, 8, -17, -28, 14, -30, -4, 1, -7},
	{0, 0, 0, 0, 0, 1, 0, 0, -1, -4, 1, -4, -6, 2, -6, -4, 4, -8, -11, 7, -15, -24, 12, -26, -4, 1, -8},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 1, -2, -5, 2, -6, -5, 3, -8, -11, 7, -16, -25, 12, -26, -5, 0, -8},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -2, 1, -2, -4, 2, -5, -5, 3, -8, -12, 7, -16, -26, 13, -26, -4, 2, -8},
	{0, 0, 0, 0, 0, 0, -1, 0, -1, -2, 1, -3, -4, 2, -4, -5, 3, -7, -11, 6, -14, -26, 13, -28, -4, 0, -10},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, -2, 0, -2, -4, 2, -6, -6, 3, -7, -10, 6, -14, -26, 14, -28, -4, 0, -10},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -2, -2, 2, -4, -6, 3, -7, -9, 7, -14, -26, 13, -28, -7, -1, -13},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -2, -4, 2, -4, -4, 3, -6, -8, 6, -12, -28, 14, -30, -6, -1, -13},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -4, -5, 3, -6, -9, 6, -13, -21, 12, -24, -6, -1, -12},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -2, -4, 1, -4, -4, 2, -5, -9, 5, -12, -22, 13, -26, -6, 3, -11},
	{1, 0, 0, 0, 0, 1, 0, 0, 0, -4, 0, -2, -2, 2, -4, -4, 2, -5, -8, 5, -11, -23, 12, -26, -5, 5, -11},
	{2, 0, 0, 0, 0, 1, -1, 0, 0, -2, 0, -2, -2, 2, -4, -6, 2, -6, -6, 4, -10, -23, 13, -27, -5, 6, -11},
	{1, 0, 1, 0, 0, 1, 0, 0, 0, -3, 0, -2, -3, 1, -3, -5, 2, -6, -7, 5, -10, -22, 13, -27, -5, 6, -10},
	{1, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -1, -3, 1, -4, -4, 2, -5, -8, 4, -10, -17, 11, -23, -5, 6, -10},
	{1, 0, 1, 0, 0, 0, 0, 0, 0, -2, 0, -1, -2, 1, -3, -4, 2, -5, -8, 4, -10, -17, 11, -23, -5, 6, -10},
	{0, 0, 0, 0, 0, 2, -1, 0, 0, -1, 0, -1, -2, 1, -3, -1, 2, -4, -3, 2, -6, -13, 10, -20, -5, 4, -9},
	{0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, -2, 1, -3, -2, 1, -4, -4, 3, -8, -12, 9, -20, -3, 4, -9},
	{0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, -2, 1, -3, -1, 1, -3, -4, 3, -7, -12, 10, -21, -4, 4, -11},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, -1, -1, 1, -2, -2, 1, -3, -4, 3, -7, -12, 10, -22, -4, 4, -12},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, -2, 1, -2, -2, 1, -3, -3, 3, -7, -10, 10, -20, -7, 0, -15},
	{0, 0, 0, 1, 0, 1, 0, 0, 0, -2, 0, -1, -1, 1, -2, -2, 1, -3, -4, 2, -6, -9, 8, -18, -8, 9, -18},
};
#endif
