/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3HA3_AMS567JA01_H_
#define _SS_DSI_SMART_DIMMING_S6E3HA3_AMS567JA01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3, panel_rev;
static int hero;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

/* 6.6*4194304 */
#define VREG0_REF_6P6 27682406
/* 6.4*4194304 */
#define VREG0_REF_6P4 26843546
/* 6.3*4194304 */
#define VREG0_REF_6P3 26424115
/* 6.2*4194304 */
#define VREG0_REF_6P2 26004685

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V3 = 1,
	V11 = 2,
	V23 = 3,
	V35 = 4,
	V51 = 5,
	V87 = 6,
	V151 = 7,
	V203 = 8,
	V255 = 9,
	V_MAX,
};

enum {
	VT_HMT = 0,
	V0_HMT = 1,
	V3_HMT = 2,
	V11_HMT = 3,
	V23_HMT = 4,
	V35_HMT = 5,
	V51_HMT = 6,
	V87_HMT = 7,
	V151_HMT = 8,
	V203_HMT = 9,
	V255_HMT = 10,
	V_MAX_HMT,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V3",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

static char V_LIST_HMT[V_MAX_HMT][5] = {
	"VT",
	"V0",
	"V3",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];
	int RGB_OUTPUT_HMT[V_MAX_HMT][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP+1];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* V0,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 3, 11, 23, 35, 51, 87, 151, 203, 255};

static int vt_coefficient[] = {
   	  0,  12,  24,  36,
	 48,  60,  72,  84,
	 96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
 	{0x80, 0x80, 0x80},		/* V3 */
 	{0x80, 0x80, 0x80},		/* V11 */
 	{0x80, 0x80, 0x80},		/* V23 */
 	{0x80, 0x80, 0x80},		/* V35 */
 	{0x80, 0x80, 0x80},		/* V51 */
 	{0x80, 0x80, 0x80},		/* V87 */
 	{0x80, 0x80, 0x80},		/* V151 */
 	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{64, 320},		/* V3 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

static int fraction_hmt[V_MAX_HMT][2] = {
/* {numerator, denominator} */
	{0, 860},		/* VT */
	{0, 256},		/* V0 */
	{64, 320},		/* V3 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

/* 443 is made but not used */
static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

static unsigned int base_luminance_revA[LUMINANCE_MAX][2] = {
	{2, 520093696},
	{3, 520093696},
	{4, 520093696},
	{5, 520093696},
	{6, 520093696},
	{7, 520093696},
	{8, 520093696},
	{9, 520093696},
	{10,	520093696},
	{11,	520093696},
	{12,	520093696},
	{13,	520093696},
	{14,	520093696},
	{15,	520093696},
	{16,	520093696},
	{17,	520093696},
	{19,	520093696},
	{20,	520093696},
	{21,	520093696},
	{22,	520093696},
	{24,	520093696},
	{25,	520093696},
	{27,	520093696},
	{29,	520093696},
	{30,	520093696},
	{32,	520093696},
	{34,	520093696},
	{37,	520093696},
	{39,	520093696},
	{41,	520093696},
	{44,	520093696},
	{47,	520093696},
	{50,	520093696},
	{53,	520093696},
	{56,	520093696},
	{60,	520093696},
	{64,	520093696},
	{68,	520093696},
	{72,	520093696},
	{77,	541065216},
	{82,	578813952},
	{87,	612368384},
	{93,	658505728},
	{98,	696254464},
	{105,	734003200},
	{111,	771751936},
	{119,	822083584},
	{126,	868220928},
	{134,	910163968},
	{143,	960495616},
	{152,	1027604480},
	{162,	1082130432},
	{172,	1145044992},
	{183,	1157627904},
	{195,	1157627904},
	{207,	1157627904},
	{220,	1157627904},
	{234,	1157627904},
	{249,	1237319680},
	{265,	1304428544},
	{282,	1367343104},
	{300,	1438646272},
	{316,	1505755136},
	{333,	1581252608},
	{350,	1631584256},
	{357,	1669332992},
	{365,	1686110208},
	{372,	1686110208},
	{380,	1686110208},
	{387,	1686110208},
	{395,	1686110208},
	{403,	1707081728},
	{412,	1732247552},
	{420,	1761607680},
};

static int gradation_offset_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 7,	9,	13, 17, 20, 21, 19, 7},
	{0, 6,	8,	13, 15, 17, 19, 20, 18},
	{0, 6,	7,	12, 13, 15, 18, 20, 18},
	{0, 6,	7,	12, 13, 14, 17, 19, 20},
	{0, 6,	8,	12, 13, 14, 17, 19, 22},
	{0, 5,	6,	10, 11, 13, 15, 18, 18},
	{0, 5,	6,	10, 11, 12, 14, 17, 18},
	{0, 5,	5,	10, 11, 12, 14, 17, 17},
	{0, 5,	5,	9,	10, 11, 13, 16, 18},
	{0, 5,	5,	8,	9,	11, 13, 15, 18},
	{0, 4,	5,	7,	9,	10, 12, 15, 18},
	{0, 4,	5,	8,	9,	10, 12, 15, 18},
	{0, 4,	4,	7,	8,	9,	11, 14, 16},
	{0, 4,	4,	7,	7,	9,	11, 13, 19},
	{0, 4,	3,	6,	7,	8,	10, 13, 17},
	{0, 4,	4,	6,	7,	8,	10, 13, 16},
	{0, 4,	3,	5,	6,	8,	10, 13, 16},
	{0, 4,	3,	5,	6,	8,	9,	12, 18},
	{0, 4,	2,	5,	5,	8,	9,	12, 16},
	{0, 4,	2,	5,	6,	7,	9,	12, 15},
	{0, 4,	2,	5,	5,	7,	9,	11, 16},
	{0, 4,	2,	4,	5,	6,	8,	11, 12},
	{0, 4,	3,	4,	4,	6,	8,	10, 16},
	{0, 4,	2,	4,	4,	6,	7,	10, 12},
	{0, 4,	2,	3,	4,	6,	7,	10, 12},
	{0, 3,	2,	4,	4,	5,	7,	9,	13},
	{0, 3,	2,	3,	4,	5,	7,	9,	12},
	{0, 3,	2,	3,	4,	5,	6,	9,	9},
	{0, 3,	2,	3,	3,	4,	6,	8,	9},
	{0, 3,	2,	3,	3,	4,	5,	7,	12},
	{0, 3,	1,	2,	3,	4,	5,	7,	9},
	{0, 3,	1,	3,	3,	4,	5,	7,	6},
	{0, 3,	1,	2,	2,	3,	4,	6,	7},
	{0, 3,	1,	2,	2,	3,	4,	6,	5},
	{1, 4,	2,	3,	3,	3,	4,	6,	6},
	{0, 3,	1,	2,	2,	3,	4,	5,	7},
	{0, 3,	1,	2,	2,	2,	4,	5,	5},
	{0, 3,	1,	1,	2,	2,	3,	4,	8},
	{0, 3,	1,	2,	2,	2,	3,	4,	4},
	{0, 3,	1,	2,	1,	3,	3,	4,	4},
	{0, 4,	3,	2,	1,	2,	3,	4,	5},
	{0, 3,	2,	2,	1,	2,	3,	4,	6},
	{0, 3,	3,	3,	1,	3,	3,	4,	4},
	{0, 2,	3,	3,	1,	2,	3,	4,	5},
	{0, 2,	3,	3,	1,	2,	3,	4,	5},
	{0, 2,	4,	3,	2,	3,	3,	4,	7},
	{0, 2,	3,	3,	2,	2,	3,	4,	6},
	{0, 1,	3,	2,	2,	2,	2,	3,	6},
	{0, 2,	4,	3,	2,	2,	2,	3,	6},
	{0, 1,	4,	4,	2,	2,	3,	4,	3},
	{0, 2,	4,	3,	3,	2,	3,	4,	2},
	{0, 1,	4,	3,	2,	2,	3,	4,	3},
	{0, 3,	4,	4,	3,	2,	2,	3,	5},
	{2, 4,	5,	4,	2,	2,	2,	3,	4},
	{0, 2,	4,	3,	2,	2,	2,	3,	0},
	{0, 1,	3,	2,	1,	2,	2,	2,	2},
	{0, 1,	4,	2,	1,	2,	2,	2,	2},
	{0, 1,	3,	2,	1,	1,	1,	1,	2},
	{0, 1,	2,	2,	1,	1,	1,	2,	0},
	{0, 1,	2,	1,	1,	1,	1,	2,	0},
	{0, 1,	2,	2,	1,	0,	0,	1,	0},
	{0, 1,	2,	1,	0,	0,	0,	0,	2},
	{0, 1,	1,	1,	1,	0,	0,	1,	0},
	{0, 1,	1,	1,	0,	0,	0,	1,	0},
	{0, 0,	0,	0,	-1, 0,	0,	0,	0},
	{0, 1,	0,	0,	0,	0,	0,	0,	0},
	{0, 1,	0,	0,	0,	0,	0,	-1, 1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	-1, -1, -1, -1, 0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-7,	0,	-4, -2, 0,	-2, 0,	1,	-1, -2, 2,	-4, -3, 3,	-9, -5, 3,	-8, -1, 3,	-5, 4,	1,	-1},
	{-5,	1,	-2, -2, 0,	-2, -1, 0,	-2, -3, 1,	-5, 0,	3,	-6, -3, 3,	-6, -2, 3,	-8, 4,	1,	-1},
	{-4,	1,	-2, -1, 0,	-1, -2, 1,	-2, -2, 1,	-3, 0,	2,	-8, -2, 3,	-7, -2, 3,	-7, 0,	3,	-6},
	{-5,	0,	-2, -1, 0,	-1, -1, 1,	-2, -2, 1,	-3, -1, 2,	-8, -1, 3,	-6, -1, 3,	-7, 0,	4,	-8},
	{-3,	1,	-1, -1, 0,	-1, -2, 0,	-2, -2, 1,	-4, -1, 2,	-8, -1, 2,	-7, -2, 2,	-8, 4,	3,	-8},
	{-2,	1,	0,	-1, 0,	-1, -1, 1,	-1, -2, 1,	-4, -1, 2,	-7, 0,	2,	-6, -1, 2,	-10,	2,	3,	-8},
	{-3,	0,	-1, -1, 0,	-1, -2, 0,	-2, -2, 1,	-3, 1,	2,	-6, 0,	3,	-7, 1,	3,	-8, 1,	2,	-10},
	{-3,	0,	-1, 0,	0,	0,	-2, 0,	-2, -3, 0,	-3, -1, 1,	-7, 1,	2,	-8, 1,	3,	-7, 2,	3,	-10},
	{-2,	0,	0,	-1, 0,	-1, -1, 0,	-1, -3, 0,	-3, 0,	2,	-6, 0,	2,	-8, 1,	3,	-9, 2,	2,	-9},
	{-2,	0,	0,	-1, 0,	-1, -1, 0,	-1, -3, 0,	-4, 1,	2,	-6, -1, 2,	-8, 1,	3,	-8, 7,	4,	-8},
	{-2,	0,	0,	0,	0,	0,	-1, 0,	-1, -2, 1,	-2, -1, 1,	-6, 0,	2,	-8, 0,	2,	-9, 3,	3,	-10},
	{-1,	0,	1,	-1, 0,	-1, -1, 0,	-1, -3, 0,	-3, 1,	2,	-6, -1, 2,	-8, 0,	2,	-9, 2,	2,	-11},
	{0, 0,	1,	-1, 0,	0,	-1, 0,	-1, -3, 0,	-2, 0,	2,	-6, 0,	2,	-8, 1,	3,	-7, 4,	3,	-10},
	{0, 0,	2,	-1, 0,	-1, -1, 0,	-1, -3, 0,	-2, 2,	2,	-5, 1,	2,	-6, 1,	3,	-7, 7,	4,	-11},
	{1, 0,	2,	-1, 0,	0,	-1, 0,	-1, -3, 0,	-3, 1,	2,	-4, 0,	2,	-8, 2,	3,	-9, 5,	4,	-9},
	{1, 0,	2,	-1, 0,	0,	-1, 0,	-1, -2, 0,	-2, 0,	1,	-5, 0,	2,	-8, 2,	3,	-9, 5,	4,	-9},
	{2, 0,	3,	-1, 0,	-1, -1, 0,	0,	-1, 0,	-1, 0,	1,	-5, 1,	2,	-6, -1, 2,	-11,	4,	2,	-12},
	{2, 0,	3,	0,	0,	0,	-2, 0,	-1, -1, 0,	-1, 1,	1,	-4, 0,	2,	-6, 2,	3,	-11,	6,	4,	-10},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 1,	1,	-5, -2, 0,	-8, 1,	3,	-11,	7,	4,	-10},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 0,	-5, 1,	2,	-7, 2,	3,	-9, 4,	3,	-12},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 0,	0,	-5, 0,	1,	-6, -3, 3,	-9, 9,	4,	-13},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 0,	1,	-5, 0,	1,	-6, 1,	3,	-9, 5,	3,	-10},
	{2, 0,	3,	0,	0,	0,	-1, 0,	0,	-1, 0,	-1, 0,	1,	-4, -1, 1,	-6, 1,	2,	-9, 6,	4,	-13},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 0,	1,	-3, -1, 1,	-5, 1,	2,	-11,	5,	3,	-11},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 1,	1,	-3, 0,	1,	-4, 0,	2,	-10,	4,	2,	-13},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	0,	1,	-3, -1, 1,	-6, 1,	2,	-8, 4,	4,	-14},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	0,	0,	-4, -2, 0,	-6, 1,	2,	-8, 4,	4,	-14},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3, -2, 1,	-5, 1,	2,	-9, 2,	1,	-12},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	1,	1,	-3, 0,	1,	-3, 1,	2,	-7, 3,	4,	-14},
	{2, 0,	3,	-1, 0,	0,	1,	0,	0,	0,	0,	1,	1,	1,	-3, -1, 1,	-4, 2,	2,	-7, 5,	4,	-14},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	-3, -2, 0,	-4, 3,	2,	-6, 4,	4,	-13},
	{2, 0,	3,	-1, 0,	0,	1,	0,	0,	0,	0,	1,	1,	1,	-2, -1, 0,	-4, 2,	1,	-6, 2,	3,	-13},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	1,	2,	1,	-1, -1, 0,	-4, 2,	2,	-5, 4,	3,	-13},
	{2, 0,	3,	-1, 0,	0,	1,	0,	0,	0,	0,	1,	1,	0,	-2, -1, 0,	-3, 3,	2,	-4, 2,	3,	-13},
	{2, 0,	3,	-1, 0,	0,	2,	0,	1,	-1, 0,	0,	1,	0,	-2, -1, 0,	-4, 2,	1,	-6, 2,	4,	-12},
	{2, 0,	3,	-1, 0,	0,	1,	0,	0,	0,	0,	1,	2,	0,	-1, -2, 0,	-3, 3,	1,	-4, 3,	3,	-14},
	{2, 0,	3,	-1, 0,	0,	2,	0,	1,	-1, 0,	0,	2,	0,	-1, -2, 0,	-3, 1,	0,	-5, 3,	3,	-13},
	{2, 0,	3,	-1, 0,	0,	2,	0,	1,	0,	0,	1,	0,	0,	-1, -2, 0,	-4, 2,	1,	-4, 4,	4,	-14},
	{2, 0,	3,	-1, 0,	0,	1,	0,	0,	0,	0,	1,	2,	0,	0,	-1, 0,	-3, 1,	1,	-4, 4,	4,	-12},
	{3, 0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	1,	2,	0,	0,	-1, 0,	-2, 2,	1,	-4, 4,	4,	-11},
	{3, 0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	-1, 0,	0,	-2, 2,	1,	-3, 4,	4,	-12},
	{3, 0,	4,	0,	0,	0,	0,	0,	0,	1,	0,	2,	2,	0,	-1, -2, 0,	-3, 3,	1,	-2, 3,	4,	-12},
	{2, 0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	-1, 0,	0,	-2, 0,	0,	-4, 3,	3,	-11},
	{3, 0,	4,	0,	0,	0,	1,	0,	0,	-1, 0,	0,	2,	0,	1,	-1, 0,	-2, 0,	0,	-4, 3,	3,	-11},
	{2, 0,	3,	1,	0,	1,	0,	0,	0,	0,	0,	1,	1,	0,	-1, -1, 0,	-2, 3,	1,	-3, 2,	3,	-11},
	{2, 0,	4,	0,	0,	0,	-1, 0,	0,	1,	0,	1,	1,	0,	-1, 0,	0,	-1, 1,	0,	-4, 3,	3,	-10},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	0,	-1, 0,	-2, 1,	0,	-3, 1,	2,	-10},
	{1, 0,	2,	3,	0,	2,	0,	0,	0,	0,	0,	1,	0,	0,	-1, 0,	0,	-1, 0,	0,	-3, 2,	2,	-10},
	{3, 0,	3,	0,	0,	0,	0,	0,	1,	2,	0,	2,	1,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	2,	-9},
	{3, 0,	3,	1,	0,	1,	-2, 0,	0,	0,	0,	0,	1,	0,	0,	0,	0,	0,	-1, 0,	-3, 2,	2,	-7},
	{2, 0,	2,	1,	0,	0,	0,	0,	1,	0,	0,	1,	1,	0,	0,	0,	0,	-1, 0,	0,	-2, 3,	2,	-7},
	{2, 0,	2,	1,	0,	2,	0,	0,	0,	0,	0,	1,	1,	0,	0,	-1, 0,	-2, 1,	0,	-1, 3,	2,	-6},
	{2, 0,	2,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	-1, 1,	0,	-2, 3,	2,	-7},
	{2, 0,	2,	0,	0,	1,	1,	0,	1,	-1, 0,	0,	0,	0,	0,	1,	0,	-1, 1,	0,	-2, 2,	1,	-6},
	{2, 0,	2,	0,	0,	1,	0,	0,	1,	1,	0,	0,	0,	0,	0,	1,	0,	-1, 1,	0,	-1, 3,	1,	-4},
	{2, 0,	2,	0,	0,	0,	1,	0,	1,	0,	0,	0,	2,	0,	2,	-1, 0,	-2, 1,	0,	-1, 1,	1,	-5},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	1,	0,	1,	1,	0,	1,	0,	0,	-1, 1,	0,	-1, 2,	1,	-3},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	1,	0,	1,	1,	0,	1,	0,	0,	0,	2,	0,	0,	1,	1,	-4},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	0,	2,	0,	-1, 0,	0,	-3},
	{1, 0,	1,	1,	0,	1,	0,	0,	0,	1,	0,	2,	0,	0,	0,	0,	0,	-1, 0,	0,	-1, 0,	0,	-3},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	-1, 1,	0,	-1, 0,	0,	-2},
	{1, 0,	0,	1,	0,	1,	0,	0,	0,	1,	0,	1,	-1, 0,	0,	1,	0,	0,	1,	0,	-1, 0,	0,	-2},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	0,	0,	0,	1,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	-1, -1, 0,	-1, 1,	-1, 0},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	1,	0,	0,	-1, 0,	0,	0,	2,	0,	1},
	{1, 0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1, 0,	0,	1,	0,	0,	0,	0,	0,	1,	-1, 0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1, 0,	0,	1,	0,	0,	0,	0,	0,	1,	0,	1},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	1,	-1, 0,	0,	1,	0,	0,	0,	0,	0,	1,	-1, 1},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	1,	-1, 0,	0,	1,	0,	0,	0,	0,	0,	0,	-1, 0},
	{1, 0,	1,	-1, 0,	-1, 1,	0,	1,	0,	0,	0,	1,	0,	2,	1,	0,	-1, 0,	0,	0,	1,	0,	2},
	{0, 0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 1,	0,	1},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	0,	0},
	{0, 0,	0,	-1, 0,	-1, 1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static unsigned int base_luminance_revC[LUMINANCE_MAX][2] = {
	{2, 562036736},
	{3, 562036736},
	{4, 562036736},
	{5, 562036736},
	{6, 562036736},
	{7, 562036736},
	{8, 562036736},
	{9, 562036736},
	{10,	562036736},
	{11,	562036736},
	{12,	562036736},
	{13,	562036736},
	{14,	562036736},
	{15,	562036736},
	{16,	562036736},
	{17,	562036736},
	{19,	562036736},
	{20,	562036736},
	{21,	562036736},
	{22,	562036736},
	{24,	562036736},
	{25,	562036736},
	{27,	562036736},
	{29,	562036736},
	{30,	562036736},
	{32,	562036736},
	{34,	562036736},
	{37,	562036736},
	{39,	562036736},
	{41,	562036736},
	{44,	562036736},
	{47,	562036736},
	{50,	562036736},
	{53,	562036736},
	{56,	562036736},
	{60,	562036736},
	{64,	562036736},
	{68,	562036736},
	{72,	562036736},
	{77,	587202560},
	{82,	633339904},
	{87,	650117120},
	{93,	692060160},
	{98,	725614592},
	{105,	767557632},
	{111,	805306368},
	{119,	851443712},
	{126,	893386752},
	{134,	931135488},
	{143,	998244352},
	{152,	1027604480},
	{162,	1098907648},
	{172,	1161822208},
	{183,	1224736768},
	{195,	1224736768},
	{207,	1224736768},
	{220,	1224736768},
	{234,	1224736768},
	{249,	1249902592},
	{265,	1321205760},
	{282,	1384120320},
	{300,	1455423488},
	{316,	1530920960},
	{333,	1589641216},
	{350,	1660944384},
	{357,	1681915904},
	{365,	1694498816},
	{372,	1694498816},
	{380,	1694498816},
	{387,	1694498816},
	{395,	1694498816},
	{403,	1715470336},
	{412,	1736441856},
	{420,	1761607680},

};

static int gradation_offset_revC[LUMINANCE_MAX][9] = {
	/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 8,	13, 18, 22, 25, 30, 33, 35},
	{0, 7,	11, 15, 18, 21, 25, 29, 31},
	{0, 7,	11, 15, 17, 20, 24, 28, 30},
	{0, 7,	10, 15, 17, 19, 23, 27, 29},
	{0, 7,	10, 15, 16, 18, 22, 26, 28},
	{0, 7,	10, 15, 16, 18, 21, 25, 27},
	{0, 7,	9,	14, 15, 17, 20, 24, 25},
	{0, 6,	9,	13, 15, 15, 18, 22, 24},
	{0, 6,	8,	12, 14, 14, 17, 21, 23},
	{0, 6,	8,	12, 13, 13, 17, 21, 23},
	{0, 6,	7,	11, 13, 13, 16, 20, 22},
	{0, 6,	7,	11, 13, 13, 16, 19, 21},
	{0, 6,	7,	10, 12, 12, 15, 18, 20},
	{0, 6,	7,	10, 12, 12, 15, 18, 20},
	{0, 6,	7,	10, 11, 11, 14, 17, 19},
	{0, 5,	6,	9,	11, 11, 13, 16, 18},
	{0, 5,	5,	8,	10, 10, 12, 15, 17},
	{0, 5,	5,	8,	9,	9,	12, 15, 17},
	{0, 5,	5,	8,	8,	8,	10, 14, 16},
	{0, 5,	5,	8,	8,	8,	10, 14, 16},
	{0, 5,	5,	7,	8,	8,	10, 14, 16},
	{0, 5,	5,	7,	8,	8,	10, 14, 16},
	{0, 5,	5,	6,	7,	7,	9,	13, 15},
	{0, 5,	5,	6,	7,	7,	9,	13, 15},
	{0, 5,	4,	6,	7,	7,	9,	13, 14},
	{0, 5,	4,	6,	7,	7,	9,	13, 14},
	{0, 5,	4,	6,	7,	7,	9,	12, 14},
	{0, 5,	4,	5,	6,	6,	8,	11, 13},
	{0, 4,	4,	5,	6,	5,	7,	10, 12},
	{0, 4,	3,	5,	5,	5,	7,	10, 12},
	{0, 4,	3,	4,	5,	5,	7,	10, 11},
	{0, 4,	3,	4,	5,	4,	6,	9,	10},
	{0, 4,	3,	4,	5,	4,	6,	8,	10},
	{0, 4,	3,	4,	4,	4,	5,	7,	9},
	{0, 4,	3,	3,	4,	3,	5,	7,	9},
	{0, 4,	3,	3,	4,	3,	5,	7,	9},
	{0, 4,	3,	3,	3,	3,	4,	6,	8},
	{0, 4,	3,	3,	3,	2,	4,	6,	8},
	{0, 4,	3,	3,	3,	2,	4,	5,	7},
	{0, 3,	2,	3,	3,	3,	3,	6,	8},
	{0, 2,	2,	2,	2,	3,	4,	6,	8},
	{0, 2,	2,	2,	1,	2,	3,	5,	7},
	{0, 2,	2,	3,	2,	2,	3,	4,	7},
	{0, 3,	4,	3,	3,	3,	3,	5,	7},
	{0, 2,	3,	3,	2,	2,	2,	4,	7},
	{0, 2,	4,	4,	3,	2,	3,	4,	7},
	{0, 1,	4,	4,	2,	2,	3,	4,	6},
	{0, 1,	4,	4,	2,	2,	2,	3,	6},
	{0, 2,	4,	4,	3,	3,	3,	3,	5},
	{0, 1,	4,	4,	4,	4,	4,	4,	5},
	{0, 2,	5,	3,	3,	2,	2,	3,	4},
	{0, 2,	5,	3,	2,	2,	2,	3,	4},
	{0, 2,	4,	3,	2,	2,	2,	2,	4},
	{0, 1,	3,	2,	2,	2,	1,	2,	4},
	{0, 1,	3,	2,	1,	2,	1,	2,	4},
	{0, 1,	3,	2,	1,	1,	1,	2,	3},
	{0, 1,	2,	2,	1,	1,	1,	1,	3},
	{0, 1,	2,	2,	1,	1,	1,	1,	2},
	{0, 1,	3,	2,	2,	1,	1,	1,	2},
	{0, 1,	2,	1,	1,	1,	1,	1,	2},
	{0, 1,	2,	1,	1,	1,	0,	0,	2},
	{0, 1,	1,	1,	1,	1,	1,	0,	1},
	{0, 1,	1,	1,	0,	1,	0,	0,	1},
	{0, 0,	1,	1,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	-1, -1, -1, 0,	2},
	{0, 0,	0,	1,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	-1, 0},
	{0, 0,	0,	-1, -1, -1, -1, -1, 0},
	{0, 0,	0,	-1, -1, -1, -1, -1, 0},
	{0, 0,	0,	-1, -1, -1, -1, -1, 0},
	{0, 0,	0,	-1, -1, -1, -1, -1, 0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revC[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-10,	0,	-8, -2, 0,	-1, -3, 0,	-2, -12,	0,	-3, -17,	0,	-6, -15,	0,	-6, -10,	1,	-8, -10,	1,	-10},
	{-8,	0,	-7, -2, 0,	-1, -3, 1,	-2, -7, 0,	-2, -15,	1,	-6, -13,	0,	-4, -11,	0,	-11,	-13,	2,	-11},
	{-6,	0,	-6, -1, 0,	-1, -3, 1,	-2, -8, 0,	-3, -11,	1,	-5, -13,	0,	-5, -12,	0,	-10,	-13,	0,	-14},
	{-5,	0,	-5, -1, 0,	-1, -3, 1,	-2, -7, 1,	-4, -11,	1,	-5, -11,	0,	-5, -12,	0,	-9, -14,	1,	-16},
	{-4,	0,	-4, -1, 0,	-1, -1, 1,	-1, -8, 1,	-5, -8, 2,	-4, -10,	0,	-6, -11,	0,	-8, -14,	0,	-16},
	{-4,	0,	-4, -1, 0,	-1, -1, 0,	-1, -8, 0,	-6, -10,	1,	-6, -9, 0,	-5, -10,	0,	-10,	-14,	2,	-15},
	{-3,	0,	-3, -1, 0,	-1, -1, 0,	-1, -6, 0,	-5, -10,	1,	-6, -10,	0,	-7, -9, 1,	-8, -15,	1,	-15},
	{-1,	0,	-2, -2, 0,	-1, -1, 0,	-1, -7, 0,	-6, -7, 0,	-5, -8, 3,	-5, -8, 3,	-7, -15,	1,	-15},
	{-1,	0,	-2, -1, 0,	0,	-1, 0,	-1, -5, 0,	-5, -8, 0,	-6, -6, 3,	-5, -8, 3,	-7, -14,	2,	-16},
	{-1,	0,	-2, -1, 0,	0,	-1, 0,	-1, -4, 0,	-4, -7, 1,	-6, -7, 3,	-5, -9, 0,	-9, -15,	2,	-16},
	{0, 0,	-1, -1, 0,	0,	-1, 0,	-1, -5, 0,	-5, -7, 1,	-6, -7, 2,	-6, -5, 3,	-7, -14,	2,	-16},
	{0, 0,	-1, -1, 0,	0,	-1, 0,	-1, -4, 0,	-4, -7, 0,	-7, -7, 2,	-6, -6, 2,	-8, -10,	5,	-14},
	{0, 0,	-1, 0,	0,	1,	-1, 0,	-1, -3, 0,	-3, -8, 0,	-7, -5, 3,	-5, -6, 4,	-7, -10,	4,	-13},
	{1, 0,	0,	-1, 0,	0,	0,	0,	0,	-3, 0,	-3, -8, 0,	-7, -6, 2,	-6, -5, 3,	-8, -10,	4,	-13},
	{1, 0,	0,	0,	0,	1,	-1, 0,	-1, -3, 0,	-3, -6, 0,	-6, -3, 3,	-5, -4, 2,	-7, -10,	5,	-14},
	{2, 0,	1,	-1, 0,	0,	0,	0,	0,	-3, 0,	-4, -7, 0,	-7, -3, 3,	-5, -2, 5,	-6, -10,	5,	-14},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	-2, 0,	-3, -6, 0,	-6, -2, 3,	-3, -3, 4,	-8, -7, 5,	-14},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -6, 1,	-6, -1, 4,	-3, -5, 2,	-9, -7, 4,	-15},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -3, 3,	-4, -1, 4,	-3, -1, 5,	-7, -7, 4,	-14},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -3, 3,	-4, -1, 4,	-2, -2, 4,	-8, -8, 3,	-15},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -5, 2,	-5, -1, 4,	-2, -3, 3,	-8, -9, 1,	-17},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -5, 1,	-5, -2, 4,	-2, -3, 3,	-8, -9, 0,	-18},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	0,	0,	-2, -4, 1,	-5, -2, 4,	-2, -5, 2,	-9, -8, 3,	-15},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	0,	0,	-1, -4, 1,	-6, -3, 3,	-2, -5, 1,	-9, -12,	1,	-19},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	-1, 0,	-2, -3, 1,	-5, -3, 3,	-2, -6, 1,	-9, -12,	1,	-18},
	{3, 0,	2,	0,	0,	1,	1,	0,	1,	-2, 0,	-3, -4, 0,	-5, -4, 2,	-3, -6, 0,	-10,	-11,	0,	-17},
	{3, 0,	2,	0,	0,	1,	1,	0,	1,	-2, 0,	-3, -3, 0,	-5, -5, 1,	-3, -6, 0,	-9, -8, 3,	-17},
	{3, 0,	2,	0,	0,	1,	1,	0,	1,	-1, 0,	-1, -3, 0,	-5, -4, 2,	-2, -5, 0,	-8, -7, 4,	-16},
	{3, 0,	2,	0,	0,	1,	1,	0,	1,	-1, 0,	-1, -3, 0,	-5, -1, 4,	1,	-3, 2,	-8, -7, 3,	-15},
	{4, 0,	3,	0,	0,	1,	0,	0,	0,	-1, 0,	-1, -3, 0,	-4, 0,	3,	0,	-5, 1,	-8, -6, 1,	-17},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	-1, 0,	-2, -3, 0,	-4, -1, 2,	-1, -5, 0,	-8, -8, 0,	-18},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	-1, 0,	-2, -3, 0,	-4, 2,	4,	2,	-4, 1,	-6, -8, 1,	-19},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	-1, -3, 0,	-4, 1,	3,	1,	-5, 0,	-7, -4, 6,	-14},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	-1, -3, 0,	-4, 0,	2,	0,	-1, 4,	-4, -2, 6,	-13},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	0,	-2, 0,	-3, 2,	4,	2,	-3, 0,	-6, -4, 5,	-14},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	0,	-2, 0,	-3, 1,	3,	2,	-3, 0,	-5, -6, 2,	-17},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	0,	-1, 0,	-2, -1, 1,	1,	0,	3,	-4, -4, 4,	-15},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	0,	0,	0,	-1, 0,	-2, 2,	4,	3,	-1, 0,	-4, -8, 1,	-18},
	{4, 0,	3,	0,	0,	1,	1,	0,	1,	1,	0,	1,	-1, 0,	-2, 1,	2,	1,	-2, 1,	-4, -1, 5,	-13},
	{3, 0,	3,	1,	0,	1,	1,	0,	1,	0,	0,	-1, -1, 0,	-2, -1, 0,	0,	1,	3,	-3, -8, 0,	-16},
	{3, 0,	3,	1,	0,	1,	1,	0,	2,	1,	0,	0,	-1, 0,	-3, -1, 0,	-1, -2, 1,	-4, -5, 2,	-15},
	{3, 0,	3,	1,	0,	1,	1,	0,	1,	1,	0,	0,	0,	0,	-1, -1, 0,	0,	1,	3,	-2, -5, 3,	-13},
	{3, 0,	2,	1,	0,	1,	1,	0,	1,	1,	0,	1,	-1, 0,	-2, -1, 0,	0,	-1, 1,	-3, -3, 6,	-11},
	{3, 0,	2,	1,	0,	1,	-1, 0,	1,	1,	0,	0,	0,	0,	-1, 0,	0,	-1, 2,	3,	-1, -9, 0,	-15},
	{3, 0,	2,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	-1, -1, 0,	0,	2,	3,	0,	-5, 3,	-11},
	{3, 0,	2,	0,	0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	-1, -1, 0,	0,	-1, 1,	-2, -2, 6,	-9},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	-1, -1, 0,	0,	-1, 1,	-2, -4, 5,	-8},
	{3, 0,	2,	0,	0,	1,	0,	0,	1,	1,	0,	1,	0,	0,	-1, 0,	0,	1,	1,	2,	0,	-4, 4,	-8},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	-1, -1, 0,	1,	-1, 0,	-2, -5, 4,	-8},
	{3, 0,	2,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	-1, 0,	-2, -5, 4,	-8},
	{3, 0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	-1, -1, 0,	1,	-1, 2,	-1, -4, 3,	-6},
	{3, 0,	1,	0,	0,	1,	0,	0,	0,	2,	0,	2,	0,	0,	-1, -2, 0,	0,	-3, 0,	-2, -7, 0,	-8},
	{4, 0,	2,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	-2, 0,	-2, -4, 4,	-5},
	{2, 0,	1,	1,	0,	1,	0,	0,	0,	1,	0,	2,	0,	0,	-1, -1, 0,	1,	0,	1,	-1, -4, 3,	-4},
	{2, 0,	1,	1,	0,	1,	0,	0,	0,	1,	0,	2,	0,	0,	-1, -1, 0,	0,	-1, 1,	-1, -5, 2,	-4},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	-2, 0,	-2, -7, 1,	-4},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	-2, 0,	-2, -6, 3,	-4},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	-2, 0,	-2, -7, 2,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

/************
 *	  HMT   *
 ************/

static unsigned int base_luminance_reverse_hmt_single_revA[][2] = {
	{10,	201326592},
	{11,	218103808},
	{12,	243269632},
	{13,	264241152},
	{14,	281018368},
	{15,	301989888},
	{16,	318767104},
	{17,	339738624},
	{19,	373293056},
	{20,	394264576},
	{21,	406847488},
	{22,	432013312},
	{23,	448790528},
	{25,	486539264},
	{27,	515899392},
	{29,	549453824},
	{31,	578813952},
	{33,	612368384},
	{35,	650117120},
	{37,	683671552},
	{39,	717225984},
	{41,	738197504},
	{44,	788529152},
	{47,	826277888},
	{50,	876609536},
	{53,	922746880},
	{56,	964689920},
	{60,	1010827264},
	{64,	1082130432},
	{68,	1145044992},
	{72,	1199570944},
	{77,	910163968},
	{82,	952107008},
	{87,	1006632960},
	{93,	1065353216},
	{99,	1136656384},
	{105,	1195376640},
};

static int gradation_offset_reverse_hmt_single_revA[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	2,	3,	4,	5,	6,	8,	10, 4},
	{0,	1,	3,	4,	6,	7,	9,	2,	1},
	{0,	1,	3,	4,	5,	7,	8,	10, 2},
	{0,	0,	2,	3,	6,	7,	8,	2,	0},
	{0,	0,	3,	3,	5,	6,	8,	1,	7},
	{0,	-1, 2,	3,	4,	7,	8,	3,	5},
	{0,	-1, 2,	3,	5,	6,	8,	10, 1},
	{0,	1,	2,	3,	5,	6,	8,	1,	0},
	{0,	1,	2,	3,	5,	6,	7,	9,	2},
	{0,	2,	2,	3,	4,	5,	8,	10, 10},
	{0,	1,	2,	3,	5,	6,	8,	3,	0},
	{0,	2,	1,	3,	4,	6,	7,	10, 10},
	{0,	1,	1,	3,	5,	5,	7,	1,	2},
	{0,	2,	1,	3,	4,	6,	7,	9,	1},
	{0,	2,	2,	3,	4,	6,	7,	9,	1},
	{0,	3,	1,	4,	4,	5,	7,	1,	2},
	{0,	3,	2,	3,	4,	6,	6,	9,	0},
	{0,	3,	2,	4,	4,	5,	7,	9,	4},
	{0,	3,	4,	4,	4,	6,	7,	1,	4},
	{0,	3,	4,	4,	4,	5,	6,	8,	1},
	{0,	3,	3,	5,	5,	6,	7,	9,	0},
	{0,	4,	4,	5,	4,	5,	7,	9,	10},
	{0,	4,	5,	5,	5,	6,	7,	9,	2},
	{0,	4,	6,	5,	6,	6,	7,	9,	4},
	{0,	4,	6,	5,	4,	5,	6,	8,	3},
	{0,	4,	6,	6,	6,	6,	7,	9,	4},
	{0,	5,	7,	6,	6,	6,	7,	9,	11},
	{0,	4,	7,	6,	6,	6,	7,	9,	0},
	{0,	5,	8,	7,	6,	6,	7,	9,	10},
	{0,	5,	7,	6,	6,	6,	7,	9,	1},
	{0,	5,	7,	5,	6,	5,	7,	8,	10},
	{0,	3,	5,	4,	3,	3,	4,	5,	7},
	{0,	4,	5,	5,	3,	3,	4,	5,	7},
	{0,	4,	6,	5,	3,	4,	3,	5,	6},
	{0,	5,	6,	5,	3,	3,	4,	6,	5},
	{0,	5,	6,	5,	4,	4,	4,	5,	6},
	{0,	4,	6,	5,	4,	3,	4,	5,	6},
};

static int rgb_offset_reverse_hmt_single_revA[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-1,	0,	-1, -1, 0,	-1, -1, 0,	0,	-3, 2,	-4, -3, 4,	-8, -3, 4,	-8, -1, 3,	-7, 0,	3,	-8},
	{-1,	0,	-1, 0,	0,	0,	-2, 0,	-2, -2, 1,	-3, -3, 3,	-7, -4, 3,	-8, 0,	2,	-6, -4, -12,	26},
	{-1,	0,	-1, 0,	0,	0,	-2, 0,	-2, -2, 1,	-3, -5, 3,	-8, -4, 3,	-7, 0,	3,	-8, 0,	3,	-7},
	{-2,	0,	-1, 0,	0,	-1, -1, 0,	-1, -2, 1,	-3, -3, 3,	-7, -4, 4,	-8, 0,	3,	-8, -1, 0,	0},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, -1, 1,	-3, -5, 3,	-7, -3, 4,	-8, -1, 2,	-6, -3, -1, 4},
	{-1,	0,	-1, -1, 0,	0,	-2, 0,	-2, -1, 1,	-2, -4, 3,	-7, -4, 3,	-7, 0,	3,	-7, 0,	0,	0},
	{0, 0,	0,	0,	0,	-1, -2, 0,	0,	-1, 1,	-3, -3, 3,	-7, -4, 3,	-7, -1, 3,	-7, 0,	4,	-9},
	{-1,	0,	-1, 0,	0,	0,	-2, 0,	-2, -2, 0,	-2, -1, 3,	-6, -5, 3,	-8, -2, 3,	-8, 0,	0,	0},
	{-1,	0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -3, 2,	-6, -4, 3,	-7, -1, 3,	-8, 1,	4,	-8},
	{0, 0,	0,	-1, 0,	0,	0,	0,	-1, -2, 1,	-3, -3, 2,	-6, -5, 3,	-8, 0,	2,	-6, 0,	4,	-9},
	{0, 0,	0,	0,	0,	0,	-1, 0,	-1, -2, 0,	-2, -3, 2,	-6, -3, 3,	-6, -2, 3,	-8, 30, 0,	0},
	{0, 0,	0,	-1, 0,	-1, -1, 0,	-1, -1, 1,	-2, -3, 2,	-6, -4, 3,	-7, -2, 3,	-8, 1,	3,	-8},
	{0, 0,	0,	0,	0,	-1, -2, 0,	-1, -2, 0,	-2, -2, 2,	-4, -5, 3,	-8, -1, 4,	-8, -2, 2,	-6},
	{-1,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 1,	-2, -3, 2,	-5, -4, 3,	-6, -3, 3,	-7, -1, 4,	-10},
	{0, 0,	0,	-2, 0,	-1, 0,	0,	-1, -2, 0,	-1, -2, 2,	-5, -4, 3,	-6, -2, 3,	-8, 0,	4,	-10},
	{0, 0,	1,	1,	0,	0,	-1, 0,	-2, -3, 0,	-2, -1, 2,	-4, -5, 2,	-6, -3, 4,	-8, 1,	0,	0},
	{0, 0,	0,	0,	0,	0,	-1, 0,	-1, -2, 0,	-1, -1, 2,	-4, -4, 3,	-6, -3, 4,	-8, 0,	4,	-10},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -1, 2,	-4, -5, 2,	-6, -3, 3,	-8, 0,	5,	-11},
	{0, 0,	0,	0,	0,	0,	-1, 0,	-1, -2, 0,	-1, -2, 2,	-4, -4, 2,	-6, -3, 3,	-8, 3,	0,	-1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -2, 2,	-4, -4, 2,	-6, -2, 3,	-7, 0,	5,	-10},
	{0, 0,	0,	0,	0,	0,	0,	0,	-1, -2, 0,	-1, -3, 1,	-4, -4, 2,	-5, -3, 3,	-8, 0,	5,	-10},
	{0, 0,	0,	0,	0,	0,	-1, 0,	-1, -1, 0,	-1, -2, 1,	-3, -4, 2,	-5, -3, 3,	-8, 0,	4,	-9},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -2, 1,	-4, -4, 2,	-5, -2, 3,	-7, -1, 5,	-11},
	{0, 0,	0,	0,	0,	0,	0,	0,	-1, -2, 0,	-1, -2, 1,	-4, -3, 2,	-5, -3, 3,	-8, 0,	5,	-11},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	-1, 1,	-3, -3, 2,	-5, -3, 3,	-8, -1, 5,	-11},
	{1, 0,	0,	0,	0,	0,	-2, 0,	-2, -1, 0,	-1, -2, 1,	-3, -4, 2,	-6, -3, 3,	-7, -1, 5,	-10},
	{1, 0,	0,	0,	0,	0,	-1, 0,	0,	-2, 0,	-2, -2, 1,	-3, -2, 1,	-4, -4, 3,	-8, 0,	5,	-10},
	{0, 0,	0,	0,	0,	1,	0,	0,	0,	-2, 0,	-1, -2, 1,	-3, -2, 2,	-5, -3, 2,	-6, -1, 5,	-11},
	{2, 0,	0,	0,	0,	0,	-2, 0,	-1, -1, 0,	-1, -2, 1,	-2, -1, 2,	-4, -4, 3,	-7, -1, 5,	-10},
	{1, 0,	0,	0,	0,	0,	-1, 0,	0,	-1, 0,	-1, -2, 1,	-3, -2, 1,	-4, -4, 2,	-6, -2, 5,	-10},
	{2, 0,	1,	0,	0,	0,	-1, 0,	0,	-2, 0,	-1, -1, 1,	-2, -2, 2,	-4, -3, 2,	-5, -1, 5,	-11},
	{1, 0,	1,	0,	0,	0,	0,	0,	-1, 0,	0,	0,	-1, 1,	-2, -4, 1,	-4, -1, 2,	-4, 2,	4,	-8},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	-1, 0,	-2, -3, 1,	-3, -2, 2,	-6, 2,	4,	-8},
	{1, 0,	1,	0,	0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-2, -3, 1,	-3, -2, 2,	-4, 3,	4,	-8},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -1, 0,	-1, -2, 1,	-3, -3, 2,	-5, 2,	3,	-7},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -2, 0,	-2, -1, 1,	-3, -2, 2,	-4, 0,	3,	-8},
	{1, 0,	1,	0,	0,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -2, 2,	-4, 0,	3,	-8},
};

static unsigned int base_luminance_reverse_hmt_single_revC[][2] = {
	{10, 213909504},
	{11, 234881024},
	{12, 239075328},
	{13, 260046848},
	{14, 285212672},
	{15, 301989888},
	{16, 318767104},
	{17, 343932928},
	{19, 373293056},
	{20, 394264576},
	{21, 415236096},
	{22, 436207616},
	{23, 448790528},
	{25, 478150656},
	{27, 520093696},
	{29, 541065216},
	{31, 578813952},
	{33, 616562688},
	{35, 650117120},
	{37, 683671552},
	{39, 725614592},
	{41, 754974720},
	{44, 796917760},
	{47, 847249408},
	{50, 889192448},
	{53, 939524096},
	{56, 989855744},
	{60, 1052770304},
	{64, 1115684864},
	{68, 1174405120},
	{72, 1233125376},
	{77, 914358272},
	{82, 968884224},
	{87, 1019215872},
	{93, 1082130432},
	{99, 1149239296},
	{105, 1216348160},
};

static int gradation_offset_reverse_hmt_single_revC[][9] = {
	{0, 1, 0, 2, 3, 5, 6, 4, -1},
	{0, 0, 1, 2, 3, 4, 6, 1, -1},
	{0, 1, 2, 3, 4, 5, 6, 7, 0},
	{0, -1, 2, 3, 4, 5, 7, 1, -1},
	{0, -1, 1, 2, 4, 5, 6, 0, 0},
	{0, -1, 1, 3, 3, 5, 6, 0, 0},
	{0, -1, 2, 3, 4, 4, 6, 8, 0},
	{0, 0, 1, 3, 4, 5, 6, 7, 0},
	{0, 0, 2, 3, 4, 4, 6, 0, 2},
	{0, 1, 2, 3, 3, 4, 6, 0, 3},
	{0, 1, 2, 3, 4, 4, 6, 8, 4},
	{0, 2, 1, 2, 3, 4, 6, 2, 7},
	{0, 2, 2, 2, 4, 4, 6, 8, 1},
	{0, 3, 2, 3, 4, 5, 6, 1, 1},
	{0, 3, 1, 3, 4, 5, 6, 7, 1},
	{0, 4, 3, 4, 4, 5, 6, 1, 0},
	{0, 4, 3, 4, 4, 5, 5, 8, 0},
	{0, 3, 3, 4, 4, 4, 6, 8, 1},
	{0, 3, 4, 4, 4, 5, 6, 0, 11},
	{0, 2, 4, 4, 4, 4, 5, 7, 9},
	{0, 2, 4, 4, 5, 5, 6, 8, 0},
	{0, 2, 4, 5, 4, 5, 5, 7, 2},
	{0, 2, 4, 5, 4, 4, 5, 8, 9},
	{0, 2, 5, 5, 5, 5, 6, 8, 0},
	{0, 1, 5, 5, 4, 4, 5, 7, 9},
	{0, 3, 6, 6, 5, 4, 5, 7, 0},
	{0, 3, 6, 5, 4, 5, 5, 7, 0},
	{0, 4, 6, 6, 5, 5, 6, 8, 8},
	{0, 3, 7, 7, 5, 5, 5, 7, 8},
	{0, 3, 7, 6, 5, 6, 6, 7, 8},
	{0, 4, 7, 6, 6, 6, 6, 7, 9},
	{0, 1, 4, 4, 3, 3, 3, 4, 6},
	{0, 3, 6, 4, 4, 3, 3, 4, 6},
	{0, 2, 5, 4, 3, 3, 3, 4, 5},
	{0, 2, 5, 5, 4, 3, 3, 5, 5},
	{0, 3, 5, 5, 3, 3, 3, 4, 5},
	{0, 3, 5, 5, 3, 3, 2, 4, 5},
};

static int rgb_offset_reverse_hmt_single_revC[][RGB_COMPENSATION] = {
	{0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -5, -5, 2, -5, -3, 2, -5, -5, 4, -8, 0, 3, -8},
	{-1, 0, -1, 0, 0, 0, 0, 0, -1, -3, 1, -4, -4, 2, -5, -3, 3, -6, -3, 3, -6, -4, -12, 26},
	{-1, 0, 0, 0, 0, 0, 0, 0, -2, -3, 1, -4, -3, 2, -5, -3, 2, -5, -6, 4, -9, 1, 4, -8},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -4, -4, 2, -5, -4, 2, -5, -5, 3, -7, -1, 0, 0},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -2, 2, -4, -3, 2, -4, -6, 3, -8, -3, -1, 4},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -3, -4, 2, -5, -4, 2, -5, -5, 3, -7, 0, 0, 0},
	{0, 0, 1, -1, 0, 0, 0, 0, 0, -1, 1, -3, -3, 2, -4, -6, 2, -6, -7, 3, -8, -2, 4, -9},
	{0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 1, -4, -3, 2, -5, -4, 2, -4, -4, 3, -7, -3, 5, -11},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -3, -3, 2, -4, -3, 2, -5, -5, 3, -6, 1, 4, -8},
	{0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 1, -2, -3, 2, -4, -3, 1, -3, -5, 3, -8, 0, 4, -9},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -3, -3, 2, -4, -3, 2, -4, -5, 2, -6, -7, 5, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -2, -3, 2, -4, -3, 2, -4, -5, 2, -6, 1, 3, -8},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -3, -4, 1, -4, -4, 2, -4, -5, 3, -7, -10, 5, -12},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -2, -3, 2, -4, -3, 1, -4, -5, 3, -7, -1, 4, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -3, 2, -4, -2, 2, -4, -4, 2, -6, -11, 6, -13},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -4, -3, 1, -3, -4, 2, -6, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, -2, -2, 2, -4, -3, 1, -4, -4, 3, -6, -9, 5, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 1, -3, -4, 1, -4, -4, 2, -5, -9, 5, -12},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 1, -4, -4, 1, -4, -5, 2, -6, 3, 0, -1},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 0, -1, -3, 1, -3, -4, 1, -4, -4, 2, -6, -6, 5, -11},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 0, -2, -2, 1, -4, -3, 1, -3, -6, 2, -6, -7, 4, -10},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 1, -3, -2, 1, -4, -4, 2, -5, -7, 6, -12},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -3, 1, -4, -1, 1, -3, -6, 2, -6, -6, 4, -9},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -2, 1, -3, -3, 1, -4, -3, 2, -5, -8, 4, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 1, -2, -3, 2, -4, -2, 2, -4, -7, 4, -10},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -3, -3, 1, -4, -2, 2, -4, -9, 5, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, -2, 1, -4, -2, 2, -5, -9, 5, -11},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 1, -2, -2, 1, -4, -3, 2, -5, -7, 4, -10},
	{0, 0, 1, 0, 0, 0, -1, 0, -1, -1, 0, -1, -1, 0, -2, -1, 1, -2, -3, 2, -5, -6, 4, -10},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -2, -2, 1, -4, -1, 2, -4, -9, 5, -10},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, -2, 0, -1, -1, 0, -2, -1, 1, -3, -3, 2, -4, -7, 5, -10},
	{0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -1, 1, -2, -2, 2, -4, -3, 3, -8},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 1, -2, -2, 1, -4, -4, 4, -9},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, 1, -2, -2, 1, -3, -5, 4, -9},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -1, 1, -2, -3, 1, -4, -2, 3, -6},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, -3, 1, -4, -4, 3, -8},
	{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, -3, 1, -3, -5, 3, -8},
};

#endif
