/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3FA5_AMS420MS01_H_
#define _SS_DSI_SMART_DIMMING_S6E3FA5_AMS420MS01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3, panel_rev;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

/* 6.9*4194304 */
#define VREG0_REF_6P9 28940698
/* 6.5*4194304 */
#define VREG0_REF_6P5 27262976
/* 6.4*4194304 */
#define VREG0_REF_6P4 26843546
/* 6.3*4194304 */
#define VREG0_REF_6P3 26424115
/* 6.2*4194304 */
#define VREG0_REF_6P2 26004685

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP+1];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* V0,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static int vt_coefficient[] = {
   	  0,  12,  24,  36,
	 48,  60,  72,  84,
	 96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
 	{0x80, 0x80, 0x80},		/* V1 */
 	{0x80, 0x80, 0x80},		/* V7 */
 	{0x80, 0x80, 0x80},		/* V11 */
 	{0x80, 0x80, 0x80},		/* V23 */
 	{0x80, 0x80, 0x80},		/* V35 */
 	{0x80, 0x80, 0x80},		/* V51 */
 	{0x80, 0x80, 0x80},		/* V87 */
 	{0x80, 0x80, 0x80},		/* V151 */
 	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{129, 860},		/* V255 */
};

/* 443 is made but not used */
static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* revA */
static unsigned int base_luminance_revA[LUMINANCE_MAX][2] = {
	{2, 	118},
	{3, 	118},
	{4, 	118},
	{5, 	118},
	{6, 	118},
	{7, 	118},
	{8, 	118},
	{9, 	118},
	{10,	118},
	{11,	118},
	{12,	118},
	{13,	118},
	{14,	118},
	{15,	118},
	{16,	118},
	{17,	118},
	{19,	118},
	{20,	118},
	{21,	118},
	{22,	118},
	{24,	118},
	{25,	118},
	{27,	118},
	{29,	118},
	{30,	118},
	{32,	118},
	{34,	118},
	{37,	118},
	{39,	118},
	{41,	118},
	{44,	118},
	{47,	118},
	{50,	118},
	{53,	118},
	{56,	118},
	{60,	118},
	{64,	118},
	{68,	119},
	{72,	121},
	{77,	127},
	{82,	135},
	{87,	149},
	{93,	157},
	{98,	159},
	{105,	168},
	{111,	179},
	{119,	193},
	{126,	200},
	{134,	210},
	{143,	220},
	{152,	235},
	{162,	246},
	{172,	254},
	{183,	281},
	{195,	281},
	{207,	281},
	{220,	281},
	{234,	281},
	{249,	286},
	{265,	300},
	{282,	322},
	{300,	335},
	{316,	351},
	{333,	374},
	{350,	388},
	{357,	388},
	{365,	406},
	{372,	406},
	{380,	406},
	{387,	406},
	{395,	406},
	{403,	409},
	{412,	413},
	{420,	420},
};

static int gradation_offset_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{12, 19, 22, 23, 24, 25, 27, 30, 45},
	{11, 17, 19, 20, 21, 22, 24, 26, 40},
	{10, 16, 17, 17, 18, 19, 20, 23, 37},
	{10, 14, 15, 16, 16, 17, 18, 20, 35},
	{10, 13, 14, 14, 15, 16, 17, 18, 34},
	{9, 12, 13, 13, 14, 15, 16, 18, 33},
	{9, 12, 13, 13, 14, 15, 16, 17, 32},
	{9, 12, 13, 13, 14, 15, 15, 16, 31},
	{8, 11, 12, 12, 13, 14, 15, 16, 30},
	{7, 10, 10, 11, 12, 12, 15, 16, 29},
	{5, 9,	9,	10, 11, 12, 14, 15, 29},
	{5, 8,	8,	9,	10, 11, 14, 15, 28},
	{4, 8,	7,	9,	10, 11, 14, 15, 28},
	{4, 8,	7,	9,	10, 11, 14, 15, 27},
	{4, 7,	6,	8,	9,	10, 13, 14, 27},
	{4, 7,	6,	7,	9,	10, 13, 14, 27},
	{3, 7,	5,	7,	9,	10, 13, 14, 25},
	{3, 6,	6,	7,	8,	10, 13, 14, 23},
	{3, 6,	5,	6,	8,	9,	12, 13, 20},
	{3, 6,	5,	6,	8,	9,	12, 13, 19},
	{3, 6,	4,	5,	7,	8,	11, 12, 18},
	{3, 6,	4,	5,	7,	8,	10, 12, 18},
	{3, 6,	4,	5,	6,	8,	10, 12, 17},
	{3, 6,	4,	4,	5,	7,	9,	11, 17},
	{3, 6,	4,	4,	5,	7,	9,	11, 17},
	{3, 6,	4,	4,	5,	6,	8,	10, 16},
	{3, 6,	4,	3,	4,	6,	8,	10, 16},
	{3, 3,	1,	1,	3,	4,	6,	9,	15},
	{0, 4,	1,	1,	3,	4,	6,	9,	15},
	{0, 3,	0,	1,	3,	4,	6,	9,	14},
	{0, 3,	0,	1,	2,	3,	5,	8,	13},
	{0, 3,	0,	1,	2,	3,	4,	7,	13},
	{0, 3,	0,	0,	2,	2,	4,	7,	12},
	{0, 3,	0,	0,	2,	2,	4,	6,	12},
	{0, 2,	0,	0,	1,	2,	3,	5,	10},
	{0, 3,	0,	0,	1,	1,	3,	5,	10},
	{0, 0,	-2, -2, 0,	0,	2,	3,	10},
	{0, 2,	1,	-1, 1,	2,	2,	3,	6},
	{0, 3,	1,	-1, 1,	1,	2,	3,	5},
	{0, 4,	2,	0,	1,	1,	2,	3,	5},
	{0, 3,	2,	1,	1,	1,	3,	3,	5},
	{0, 0,	0,	-1, 0,	0,	2,	4,	4},
	{0, 0,	0,	-1, 0,	1,	1,	3,	4},
	{0, 2,	3,	1,	1,	0,	2,	3,	4},
	{0, 2,	3,	1,	0,	1,	2,	3,	5},
	{0, 1,	1,	1,	0,	1,	2,	3,	5},
	{0, -1, 1,	0,	0,	0,	1,	3,	5},
	{0, 0,	2,	0,	0,	1,	2,	3,	5},
	{0, 2,	3,	1,	0,	0,	1,	2,	4},
	{0, 1,	2,	2,	1,	1,	2,	3,	4},
	{0, -1, 3,	0,	0,	1,	1,	3,	4},
	{0, 0,	2,	1,	1,	0,	1,	3,	4},
	{0, 2,	3,	2,	1,	1,	2,	3,	4},
	{0, 1,	2,	1,	0,	1,	1,	2,	3},
	{0, -1, 2,	1,	0,	1,	1,	2,	3},
	{0, 1,	2,	1,	-1, 0,	1,	1,	3},
	{0, -1, 2,	1,	-1, 0,	0,	1,	3},
	{0, -1, 2,	0,	-1, 0,	0,	0,	2},
	{0, -1, 1,	-1, 0,	-1, 0,	0,	2},
	{0, -2, 1,	0,	0,	0,	0,	0,	1},
	{0, -1, 0,	-1, -1, 0,	-1, 0,	1},
	{0, 1,	0,	0,	-1, -1, 0,	0,	1},
	{0, 1,	0,	-1, -1, -1, 0,	0,	1},
	{0, -2, -1, -1, -1, -1, -1, 0,	2},
	{0, -1, -1, -1, -1, -1, 0,	0,	2},
	{0, 0,	0,	-1, -1, -1, 0,	0,	2},
	{0, -3, -1, -2, -2, -1, -1, 0,	2},
	{0, -1, -1, -2, -1, -1, -1, 0,	2},
	{0, 0,	-1, -2, -2, -1, -1, -1, 2},
	{0, 0,	-2, -2, -2, -1, -1, -1, 2},
	{0, -2, -2, -2, -2, -1, -1, -1, 1},
	{0, -3, -3, -2, -2, -1, -1, -1, 1},
	{0, 0,	-1, -1, -2, -1, -1, -1, 1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-9,	0,	-4, -5, -1, -2, -6, 0,	-2, -10,	0,	-8, -18,	-1, -6, -19,	-1, -4, -16,	-1, -5, -10,	0,	-9, -12,	10, 0},
	{-8,	0,	-3, -4, -1, -2, -4, 1,	-2, -9, 0,	-7, -17,	-1, -6, -16,	1,	-5, -14,	0,	-5, -9, 0,	-9, -1, -1, -1},
	{-8,	0,	-3, -2, 0,	-2, -4, 0,	-2, -8, 0,	-7, -16,	-1, -6, -15,	0,	-6, -13,	0,	-5, -11,	0,	-10,	1,	1,	1},
	{-7,	0,	-2, -2, 0,	-3, -3, 0,	-2, -7, 0,	-7, -14,	0,	-5, -13,	0,	-6, -12,	0,	-6, -6, -1, -10,	-16,	2,	-2},
	{-7,	0,	-2, -1, 0,	-1, -3, 0,	-2, -6, -1, -6, -14,	0,	-5, -13,	0,	-6, -12,	0,	-6, -11,	-1, -11,	-8, 2,	-3},
	{-6,	0,	-2, -2, 0,	-1, -2, 0,	-2, -6, -1, -6, -13,	1,	-5, -12,	0,	-7, -12,	-1, -7, -6, 2,	-11,	-1, -1, -1},
	{-6,	0,	-2, -1, 0,	-1, -2, 0,	-2, -5, -1, -6, -12,	0,	-5, -12,	0,	-7, -11,	1,	-7, -12,	-1, -12,	-1, -1, -1},
	{-6,	0,	-2, -1, 0,	-1, -2, 0,	-2, -4, -1, -6, -11,	0,	-4, -12,	1,	-7, -10,	0,	-8, -9, -2, -10,	1,	2,	0},
	{-4,	0,	-2, 0,	0,	-1, -1, 0,	-2, -4, -1, -6, -9, -1, -6, -10,	0,	-8, -9, 0,	-8, -5, 1,	-10,	-1, -1, -1},
	{-4,	0,	-1, 0,	0,	-1, -3, 0,	-3, -3, 1,	-5, -8, -1, -4, -11,	-1, -9, -8, 0,	-9, -5, 2,	-9, -6, -2, -5},
	{-3,	0,	-1, -1, 0,	-2, -1, 0,	-2, -2, 1,	-5, -8, -1, -7, -9, 1,	-9, -7, 0,	-9, -9, -1, -9, 3,	3,	2},
	{-3,	0,	-1, 0,	0,	-1, -1, 0,	-2, -2, 0,	-5, -7, 1,	-7, -11,	-2, -9, -6, 2,	-10,	-9, -1, -9, -1, -1, -1},
	{-2,	0,	-1, -1, 0,	-2, -1, 0,	-2, -1, 1,	-5, -7, 0,	-8, -8, 0,	-9, -6, 0,	-11,	-8, -1, -8, 3,	3,	3},
	{-2,	0,	-1, 0,	0,	-1, -2, 0,	-3, -2, 0,	-6, -5, 0,	-7, -9, 1,	-10,	-7, 0,	-11,	-9, -1, -8, -1, -1, -1},
	{0, 0,	-1, -2, 0,	-2, 0,	0,	-1, -1, 0,	-4, -5, 0,	-7, -6, 1,	-9, -6, -1, -13,	-9, -1, -10,	3,	3,	3},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, 0,	1,	-4, -4, 0,	-8, -6, 1,	-8, -7, -1, -13,	-8, -1, -10,	-2, 1,	-3},
	{-1,	0,	0,	-2, 0,	-2, 0,	0,	-1, -1, 0,	-5, -3, 0,	-8, -7, 1,	-8, -9, -2, -12,	-7, 1,	-12,	-1, -1, -1},
	{1, 0,	2,	-2, 0,	0,	0,	0,	-1, -1, 0,	-2, -3, -1, -9, -10,	0,	-7, -8, -1, -8, -8, 2,	-12,	-6, -2, -6},
	{-1,	0,	0,	-2, 0,	-2, -1, 0,	-2, 2,	0,	-2, -2, 0,	-9, -10,	0,	-9, -6, 1,	-10,	-11,	-3, -20,	-1, 2,	-2},
	{-1,	0,	0,	-1, 0,	-2, -1, 0,	-1, 0,	0,	-3, -4, -1, -9, -5, 0,	-9, -8, 0,	-11,	-6, 0,	-17,	-5, 2,	-3},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, 0,	0,	-3, -4, -1, -9, -7, 0,	-8, -9, 0,	-13,	-7, 1,	-18,	1,	2,	-2},
	{-2,	0,	-1, 0,	0,	-1, 0,	0,	0,	-1, 0,	-4, -5, -1, -7, -2, 2,	-6, -9, -1, -13,	-7, 2,	-18,	-1, -1, -2},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, 0,	0,	-3, -3, 0,	-7, -4, 0,	-8, -7, 2,	-11,	-6, 1,	-16,	-6, -3, -7},
	{-2,	0,	-1, 0,	0,	0,	0,	0,	-1, -1, 0,	-2, -2, 1,	-5, -6, -1, -8, -6, 2,	-10,	-11,	-4, -17,	-1, 3,	-2},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, 1,	0,	-1, -2, 1,	-6, -6, -1, -8, -8, 0,	-12,	-5, 1,	-17,	-5, -4, -7},
	{-1,	0,	0,	-1, 0,	-1, 0,	0,	0,	-1, 0,	-2, -3, -1, -7, -1, 2,	-5, -6, 0,	-10,	-6, 1,	-19,	-7, -3, -8},
	{-1,	0,	0,	-1, 0,	-1, -1, 0,	-1, 1,	1,	-1, -2, 0,	-4, -6, -2, -9, -7, -1, -11,	-6, 0,	-19,	-1, 3,	-3},
	{-2,	0,	-1, 0,	0,	0,	1,	0,	0,	0,	0,	-2, -2, 0,	-3, -5, 0,	-6, -3, 1,	-8, -8, -3, -16,	0,	3,	-3},
	{-4,	0,	-3, -1, 0,	-1, 0,	0,	0,	1,	0,	-1, -4, -1, -4, -3, 0,	-5, -5, 0,	-9, -4, 2,	-17,	-6, -4, -10},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	-1, 0,	0,	-1, -4, -2, -5, -4, 0,	-5, -5, -1, -9, -5, 1,	-18,	1,	2,	-4},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	0,	-1, -1, -3, 0,	2,	-1, -5, -1, -6, -3, 0,	-7, -6, 1,	-15,	0,	2,	-5},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	0,	0,	-1, -2, -1, 1,	-2, -5, -2, -6, -1, 4,	-3, -8, -1, -15,	-7, -4, -10},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	0,	1,	0,	-1, -4, -2, -4, 0,	2,	-2, -5, 0,	-6, -10,	-3, -14,	0,	2,	-4},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	0,	1,	0,	-1, -4, -2, -4, -2, 0,	-3, -5, -1, -7, -4, 2,	-13,	0,	2,	-5},
	{-4,	0,	-3, -1, 0,	-1, 0,	1,	0,	0,	-1, -2, 0,	2,	0,	-6, -3, -6, -1, 2,	-3, -6, 2,	-12,	0,	2,	-5},
	{-5,	0,	-4, -1, 0,	-1, 0,	0,	0,	1,	0,	0,	-1, 1,	-2, 2,	1,	-1, -9, -3, -8, -9, 0,	-12,	-1, 1,	-6},
	{-5,	0,	-4, -1, 0,	0,	1,	1,	1,	2,	1,	0,	-1, -1, -3, 0,	2,	-2, -6, -4, -7, -4, 3,	-11,	2,	1,	-3},
	{-5,	0,	-4, 0,	0,	0,	0,	0,	-1, 2,	1,	1,	0,	1,	-1, -4, -3, -4, -3, 1,	-3, -3, 2,	-11,	1,	0,	-5},
	{-3,	1,	-3, -1, 0,	-1, 0,	0,	0,	2,	1,	1,	-1, 0,	-1, -1, 0,	-2, -3, 0,	-3, -4, 2,	-11,	2,	0,	-4},
	{-3,	1,	-3, 0,	0,	0,	0,	0,	-1, 1,	0,	0,	-1, -1, -3, 3,	3,	2,	-4, 0,	-3, -6, 0,	-13,	0,	0,	-5},
	{-3,	0,	-3, -1, 0,	0,	0,	0,	0,	0,	-1, -1, -1, -1, -2, 1,	1,	-1, -5, -1, -4, -1, 5,	-8, 0,	0,	-4},
	{-4,	0,	-3, 0,	0,	0,	-1, 0,	-1, 2,	-1, 0,	0,	1,	-2, 0,	1,	-1, -3, -1, -4, -10,	-2, -15,	5,	6,	2},
	{-4,	0,	-3, 0,	0,	1,	0,	0,	0,	2,	1,	1,	-2, -1, -2, 0,	0,	-1, 1,	2,	-1, -12,	-3, -17,	-3, -1, -7},
	{-3,	0,	-1, 3,	0,	1,	0,	0,	0,	2,	1,	3,	-1, -1, -3, 3,	2,	1,	-5, -4, -6, -8, 0,	-13,	6,	6,	2},
	{-3,	1,	-2, 0,	0,	0,	-1, -1, -1, 1,	0,	0,	0,	1,	0,	0,	0,	-2, -1, -1, -4, -8, 0,	-13,	-4, -1, -8},
	{-3,	0,	-2, 1,	0,	1,	-1, 0,	0,	1,	0,	0,	-1, 1,	-1, -1, -2, -3, 1,	3,	0,	-9, -2, -14,	-4, -1, -8},
	{-2,	1,	-1, 0,	0,	0,	0,	0,	-1, 0,	0,	0,	0,	0,	0,	2,	1,	-1, 0,	2,	-1, -9, -2, -14,	-5, -2, -9},
	{-3,	1,	-2, 0,	0,	0,	-1, -1, -1, 1,	1,	1,	-1, -1, -2, 1,	0,	-1, -2, -1, -3, -5, 2,	-10,	-4, -2, -8},
	{-2,	1,	-1, -1, -1, -1, 1,	1,	0,	0,	0,	0,	1,	1,	0,	1,	1,	0,	-1, 0,	-2, -5, 1,	-10,	-6, -3, -10},
	{-2,	1,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, 1,	1,	1,	-3, -2, -4, -7, -2, -12,	1,	3,	-3},
	{-2,	0,	-1, 1,	0,	1,	-2, -1, -2, 1,	1,	1,	0,	-1, 0,	-1, 0,	-3, 1,	1,	-1, -8, -3, -13,	0,	3,	-3},
	{-1,	0,	-1, -1, 0,	0,	0,	0,	0,	-1, 0,	0,	0,	0,	-1, 2,	2,	1,	1,	0,	-2, -8, -3, -13,	0,	3,	-3},
	{-1,	0,	-1, 0,	0,	1,	-1, 0,	-1, 0,	-1, -1, 0,	0,	-1, 0,	0,	0,	-2, -1, -3, -4, 0,	-9, -1, 2,	-4},
	{-2,	-1, -1, 1,	0,	1,	0,	0,	0,	1,	1,	1,	1,	0,	0,	-1, 0,	1,	1,	2,	1,	-5, -1, -9, -1, 2,	-4},
	{-1,	0,	-1, 0,	0,	1,	-2, -1, -1, 1,	1,	0,	0,	-1, -1, -1, -1, -1, 0,	1,	0,	-6, -2, -9, -2, 1,	-5},
	{-1,	0,	-1, -1, 0,	-1, 0,	0,	0,	1,	1,	0,	1,	1,	0,	0,	0,	1,	-4, -3, -4, -1, 3,	-4, -2, 1,	-3},
	{-1,	0,	-1, 0,	0,	1,	-2, -1, -1, 1,	1,	0,	1,	1,	0,	-1, -1, 0,	3,	2,	2,	-8, -4, -10,	-2, 0,	-3},
	{-1,	0,	-1, 0,	0,	1,	-2, -1, -1, 1,	1,	1,	0,	-1, -1, -1, -1, 0,	1,	1,	0,	-3, 0,	-3, -1, 0,	-3},
	{-1,	1,	-1, 0,	0,	0,	-1, 0,	0,	2,	0,	1,	-1, -1, -1, 1,	0,	1,	1,	1,	1,	-3, -1, -3, -3, -2, -5},
	{-1,	0,	-1, 0,	0,	1,	-1, 0,	-1, 2,	0,	0,	1,	0,	0,	0,	-1, 0,	-1, 0,	0,	1,	3,	1,	-3, -2, -5},
	{0, 0,	0,	-1, 0,	0,	-1, 1,	0,	2,	0,	0,	0,	-1, -1, -2, -1, -1, 3,	2,	3,	1,	2,	1,	-4, -2, -5},
	{0, 1,	0,	-1, 0,	0,	-1, 0,	0,	2,	0,	0,	0,	0,	0,	1,	2,	2,	-3, -3, -3, -3, 1,	-2, 6,	3,	4},
	{0, 0,	0,	-1, 0,	0,	-1, 0,	0,	3,	1,	1,	0,	-1, -1, 0,	1,	1,	-1, 0,	0,	-2, 0,	-2, 5,	3,	4},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, -1, -1, 0,	0,	0,	-1, -1, -1, 5,	4,	4,	-3, 0,	-3, -6, -4, -6},
	{1, 1,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	1,	2,	2,	-2, -2, -3, 3,	3,	1,	-8, -3, -6},
	{1, 1,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	1,	1,	1,	-1, -1, -1, 1,	3,	0,	-7, -4, -6},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

/* revC */
static unsigned int base_luminance_revC[LUMINANCE_MAX][2] = {
	{2,		113},
	{3,		113},
	{4,		113},
	{5,		113},
	{6,		113},
	{7,		113},
	{8,		113},
	{9,		113},
	{10,	113},
	{11,	113},
	{12,	113},
	{13,	113},
	{14,	113},
	{15,	113},
	{16,	113},
	{17,	113},
	{19,	113},
	{20,	113},
	{21,	113},
	{22,	113},
	{24,	113},
	{25,	113},
	{27,	113},
	{29,	113},
	{30,	113},
	{32,	113},
	{34,	113},
	{37,	113},
	{39,	113},
	{41,	113},
	{44,	113},
	{47,	113},
	{50,	113},
	{53,	113},
	{56,	113},
	{60,	113},
	{64,	113},
	{68,	116},
	{72,	121},
	{77,	127},
	{82,	138},
	{87,	146},
	{93,	153},
	{98,	163},
	{105,	175},
	{111,	184},
	{119,	195},
	{126,	207},
	{134,	217},
	{143,	230},
	{152,	243},
	{162,	258},
	{172,	275},
	{183,	289},
	{195,	289},
	{207,	289},
	{220,	289},
	{234,	289},
	{249,	292},
	{265,	310},
	{282,	326},
	{300,	342},
	{316,	359},
	{333,	376},
	{350,	396},
	{357,	403},
	{365,	405},
	{372,	405},
	{380,	405},
	{387,	405},
	{395,	405},
	{403,	407},
	{412,	413},
	{420,	420},
};

static int gradation_offset_revC[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	6,	10,	16,	20,	24,	27,	30,	31},
	{0,	6,	9,	14,	17,	20,	22,	26,	27},
	{0,	5,	7,	12,	14,	16,	19,	23,	24},
	{0,	5,	6,	11,	13,	14,	17,	21,	22},
	{0,	4,	5,	10,	12,	14,	17,	21,	22},
	{0,	4,	5,	10,	12,	14,	17,	21,	22},
	{0,	4,	5,	10,	12,	14,	17,	21,	22},
	{0,	4,	5,	9,	12,	14,	17,	21,	22},
	{0,	4,	5,	9,	12,	14,	17,	21,	22},
	{0,	4,	5,	9,	12,	14,	17,	21,	22},
	{0,	4,	4,	8,	11,	13,	16,	20,	21},
	{0,	4,	4,	8,	11,	13,	16,	20,	21},
	{0,	4,	4,	8,	10,	12,	15,	19,	20},
	{0,	4,	3,	7,	9,	12,	15,	19,	20},
	{0,	4,	3,	6,	9,	11,	14,	18,	19},
	{0,	3,	3,	6,	9,	11,	14,	18,	19},
	{0,	3,	3,	6,	8,	10,	13,	17,	18},
	{0,	3,	3,	6,	8,	10,	13,	17,	18},
	{0,	3,	3,	5,	7,	9,	12,	16,	17},
	{0,	3,	2,	5,	7,	9,	12,	16,	17},
	{0,	3,	2,	3,	6,	8,	10,	14,	15},
	{0,	3,	2,	3,	6,	8,	10,	14,	15},
	{0,	3,	2,	3,	5,	7,	9,	13,	14},
	{0,	3,	2,	3,	5,	7,	9,	13,	14},
	{0,	2,	2,	3,	5,	7,	9,	13,	14},
	{0,	2,	2,	3,	5,	6,	8,	12,	13},
	{0,	3,	2,	3,	5,	6,	8,	12,	13},
	{0,	3,	2,	2,	4,	5,	7,	11,	12},
	{0,	3,	2,	2,	4,	5,	7,	10,	11},
	{0,	2,	1,	2,	4,	5,	7,	10,	11},
	{0,	2,	1,	2,	4,	4,	6,	10,	11},
	{0,	2,	1,	2,	4,	4,	6,	9,	10},
	{0,	2,	1,	2,	3,	3,	5,	8,	9},
	{0,	2,	1,	1,	3,	3,	5,	8,	9},
	{0,	2,	1,	1,	2,	3,	4,	7,	8},
	{0,	2,	1,	1,	2,	3,	4,	7,	8},
	{0,	2,	2,	1,	2,	2,	4,	6,	7},
	{0,	2,	2,	1,	2,	2,	3,	5,	7},
	{0,	3,	2,	2,	2,	2,	3,	5,	7},
	{0,	3,	2,	2,	2,	2,	3,	5,	7},
	{0,	2,	3,	2,	2,	2,	3,	6,	7},
	{0,	2,	2,	2,	1,	2,	3,	5,	6},
	{0,	2,	3,	2,	2,	2,	3,	5,	6},
	{0,	2,	3,	2,	2,	2,	3,	5,	7},
	{0,	1,	3,	2,	2,	2,	3,	5,	7},
	{0,	0,	3,	3,	2,	2,	2,	4,	6},
	{0,	0,	3,	2,	2,	1,	2,	4,	6},
	{0,	0,	3,	2,	2,	1,	2,	4,	6},
	{0,	0,	3,	3,	2,	1,	2,	3,	5},
	{0,	0,	3,	2,	2,	1,	2,	3,	5},
	{0,	0,	3,	2,	1,	1,	1,	3,	5},
	{0,	0,	3,	2,	2,	2,	2,	4,	5},
	{0,	1,	3,	2,	1,	1,	2,	3,	5},
	{0,	1,	3,	2,	1,	1,	2,	3,	5},
	{0,	0,	2,	2,	0,	0,	1,	2,	4},
	{0,	0,	2,	2,	0,	0,	1,	2,	4},
	{0,	0,	2,	1,	0,	0,	1,	1,	3},
	{0,	0,	2,	1,	0,	0,	1,	1,	3},
	{0,	0,	2,	1,	1,	0,	0,	1,	3},
	{0,	0,	2,	1,	1,	0,	1,	1,	2},
	{0,	0,	2,	1,	1,	0,	0,	0,	2},
	{0,	1,	1,	1,	0,	0,	0,	0,	2},
	{0,	1,	1,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	-1,	-1,	-1,	0,	1},
	{0,	1,	0,	1,	0,	0,	0,	0,	2},
	{0,	1,	1,	0,	0,	0,	0,	0,	2},
	{0,	1,	1,	0,	0,	0,	0,	0,	2},
	{0,	1,	1,	-1,	-1,	-1,	-1,	-1,	1},
	{0,	1,	1,	-1,	-1,	-1,	-1,	-1,	1},
	{0,	1,	1,	-1,	-1,	-1,	-1,	-1,	1},
	{0,	1,	0,	-1,	-1,	-1,	-1,	-1,	1},
	{0,	0,	-1,	-1,	-1,	-1,	-1,	-1,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revC[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-8,	0,	-6,	-4,	0,	-3,	-5,	0,	-3,	-11,	1,	-7,	-19,	-1,	-10,	-19,	-1,	-7,	-16,	0,	-5,	-11,	0,	-8,	-6,	0,	2},
	{-6,	0,	-5,	-2,	1,	-2,	-4,	0,	-2,	-10,	1,	-6,	-18,	-1,	-9,	-17,	-1,	-7,	-17,	1,	-9,	-13,	-2,	-9,	-4,	-1,	-1},
	{-5,	0,	-4,	-2,	0,	-2,	-3,	0,	-2,	-10,	0,	-7,	-15,	0,	-8,	-17,	-1,	-6,	-18,	0,	-7,	-15,	-2,	-10,	-5,	-2,	-3},
	{-4,	0,	-3,	-2,	0,	-2,	-2,	0,	-2,	-9,	0,	-7,	-14,	-1,	-8,	-18,	0,	-6,	-18,	-1,	-7,	-15,	-2,	-12,	-5,	-2,	-4},
	{-4,	0,	-3,	-2,	0,	-2,	-1,	0,	-1,	-8,	0,	-6,	-11,	1,	-8,	-15,	-1,	-7,	-15,	-1,	-9,	-15,	0,	-12,	-4,	-1,	-3},
	{-3,	0,	-3,	-1,	0,	-1,	-2,	0,	-2,	-7,	0,	-5,	-8,	1,	-9,	-14,	-1,	-8,	-15,	0,	-8,	-12,	1,	-12,	-4,	0,	-5},
	{-2,	0,	-2,	-1,	0,	-1,	-2,	0,	-2,	-7,	0,	-6,	-8,	1,	-8,	-9,	-1,	-8,	-14,	0,	-9,	-12,	1,	-13,	-7,	1,	-5},
	{-2,	0,	-2,	-1,	0,	-1,	-1,	0,	-1,	-5,	1,	-6,	-9,	1,	-9,	-8,	0,	-8,	-12,	1,	-9,	-14,	1,	-15,	-7,	1,	-3},
	{-2,	0,	-2,	-1,	0,	-1,	-1,	0,	-1,	-5,	0,	-6,	-7,	1,	-9,	-8,	0,	-9,	-12,	2,	-10,	-12,	1,	-15,	-8,	2,	-3},
	{-1,	0,	-1,	-1,	0,	-1,	-1,	0,	-1,	-4,	1,	-5,	-7,	0,	-10,	-5,	0,	-12,	-13,	2,	-9,	-11,	3,	-12,	-7,	1,	-4},
	{-1,	0,	-1,	-1,	0,	-1,	-1,	0,	-1,	-5,	1,	-5,	-6,	0,	-9,	-7,	0,	-9,	-11,	2,	-11,	-12,	2,	-15,	-8,	1,	-4},
	{-1,	0,	-1,	0,	0,	-1,	-1,	0,	-1,	-6,	0,	-5,	-7,	0,	-9,	-4,	0,	-11,	-11,	1,	-11,	-16,	1,	-15,	-8,	1,	-4},
	{-1,	0,	-1,	0,	0,	-1,	0,	0,	0,	-5,	0,	-5,	-4,	1,	-8,	-9,	2,	-9,	-11,	1,	-11,	-15,	1,	-16,	-9,	0,	-4},
	{0,	0,	0,	-1,	0,	-1,	0,	0,	-1,	-4,	0,	-5,	-6,	0,	-7,	-5,	1,	-11,	-11,	0,	-12,	-15,	0,	-18,	-9,	0,	-4},
	{0,	0,	0,	-1,	0,	-1,	0,	0,	0,	-4,	1,	-5,	-5,	0,	-7,	-8,	1,	-10,	-9,	1,	-12,	-13,	2,	-17,	-7,	0,	-4},
	{0,	0,	0,	-1,	0,	-1,	0,	0,	0,	-4,	0,	-4,	-6,	0,	-8,	-5,	1,	-10,	-9,	0,	-13,	-14,	1,	-17,	-7,	0,	-4},
	{0,	0,	0,	0,	0,	0,	-1,	-1,	-1,	-4,	0,	-4,	-5,	1,	-7,	-6,	1,	-9,	-8,	0,	-11,	-14,	1,	-20,	-7,	1,	-4},
	{1,	0,	1,	-1,	0,	-1,	-1,	-1,	-1,	-4,	0,	-4,	-4,	0,	-7,	-6,	1,	-9,	-8,	0,	-11,	-13,	0,	-19,	-7,	1,	-6},
	{1,	0,	1,	0,	0,	-1,	-1,	0,	0,	-2,	0,	-3,	-3,	0,	-7,	-6,	1,	-8,	-11,	0,	-13,	-13,	2,	-20,	-7,	3,	-4},
	{1,	0,	1,	0,	0,	-1,	-1,	1,	0,	-2,	0,	-3,	-4,	0,	-7,	-2,	0,	-9,	-11,	0,	-13,	-15,	0,	-17,	-4,	1,	-4},
	{1,	0,	1,	0,	0,	-1,	-1,	1,	0,	-1,	0,	-2,	-3,	0,	-6,	-4,	0,	-8,	-10,	2,	-12,	-11,	3,	-18,	-4,	2,	-3},
	{1,	0,	1,	0,	0,	-1,	-1,	1,	0,	-1,	0,	-2,	-4,	0,	-6,	-3,	-1,	-9,	-10,	2,	-13,	-12,	3,	-16,	-4,	1,	-4},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-2,	0,	-2,	-2,	2,	-5,	-3,	-1,	-7,	-9,	3,	-11,	-10,	3,	-19,	-4,	2,	-4},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-2,	0,	-2,	-3,	1,	-5,	-3,	-1,	-7,	-11,	1,	-13,	-11,	2,	-20,	-4,	2,	-4},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-2,	0,	-2,	-3,	0,	-5,	-6,	0,	-6,	-11,	0,	-14,	-11,	2,	-21,	-4,	2,	-5},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-1,	0,	-1,	-3,	0,	-5,	-5,	0,	-8,	-7,	2,	-10,	-12,	1,	-21,	-4,	1,	-7},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-1,	0,	-1,	-2,	0,	-4,	-4,	0,	-7,	-9,	0,	-12,	-13,	-1,	-22,	-2,	1,	-7},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-2,	0,	-2,	-2,	0,	-3,	-2,	0,	-6,	-8,	1,	-11,	-10,	1,	-21,	-1,	0,	-5},
	{1,	0,	1,	1,	0,	0,	-1,	0,	-1,	-2,	0,	-2,	-2,	0,	-3,	-2,	0,	-6,	-8,	0,	-9,	-10,	3,	-23,	-1,	2,	-3},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	0,	-2,	-2,	0,	-3,	-2,	0,	-6,	-8,	-1,	-9,	-11,	2,	-23,	-6,	2,	-7},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	0,	-2,	-1,	0,	-2,	-2,	0,	-6,	-8,	0,	-8,	-13,	-2,	-23,	-7,	0,	-10},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	0,	-2,	-1,	0,	-2,	-1,	0,	-5,	-8,	0,	-7,	-11,	1,	-22,	-6,	1,	-8},
	{1,	0,	1,	0,	0,	0,	1,	0,	1,	-1,	0,	-2,	0,	0,	-3,	-1,	1,	-4,	-7,	1,	-6,	-10,	2,	-24,	-6,	1,	-7},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	0,	-1,	0,	0,	-2,	0,	0,	-4,	-7,	0,	-6,	-11,	1,	-23,	-6,	0,	-10},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	0,	0,	0,	1,	0,	-2,	0,	0,	-3,	-6,	2,	-5,	-11,	1,	-21,	-6,	1,	-9},
	{1,	0,	1,	0,	0,	0,	1,	0,	0,	-1,	0,	-1,	1,	0,	-1,	0,	0,	-3,	-6,	1,	-5,	-11,	0,	-20,	-7,	-1,	-13},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	-1,	0,	0,	-3,	-6,	-1,	-5,	-10,	2,	-23,	-5,	1,	-9},
	{1,	0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	1,	0,	-1,	0,	0,	-3,	-6,	-1,	-4,	-11,	1,	-23,	-6,	1,	-10},
	{1,	0,	1,	-1,	0,	0,	1,	0,	0,	-1,	-1,	-1,	1,	0,	-1,	0,	0,	-2,	-5,	1,	-4,	-9,	1,	-22,	-6,	0,	-11},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	-1,	0,	0,	-2,	-4,	0,	-3,	-10,	0,	-22,	-5,	0,	-12},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	-1,	0,	0,	-2,	-4,	-1,	-3,	-11,	-2,	-22,	-6,	-2,	-15},
	{1,	0,	1,	0,	0,	0,	1,	0,	0,	0,	0,	1,	2,	0,	-1,	0,	0,	-2,	-5,	0,	-4,	-9,	3,	-20,	-4,	0,	-11},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	1,	0,	0,	1,	0,	-1,	-4,	0,	-4,	-10,	2,	-19,	-5,	-1,	-13},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	-1,	1,	0,	-2,	-7,	-1,	-4,	-11,	-1,	-19,	-8,	-2,	-16},
	{1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	1,	0,	-1,	-4,	0,	-4,	-11,	0,	-18,	-8,	-3,	-18},
	{1,	0,	1,	1,	0,	1,	-1,	0,	-1,	0,	0,	0,	0,	0,	-1,	1,	0,	-1,	-4,	0,	-3,	-8,	3,	-15,	-7,	-2,	-15},
	{1,	0,	1,	1,	0,	1,	-1,	0,	-1,	0,	0,	1,	0,	0,	-1,	1,	0,	-1,	-4,	0,	-3,	-9,	3,	-16,	-5,	-3,	-14},
	{1,	0,	1,	1,	0,	0,	0,	0,	-1,	0,	0,	0,	0,	0,	0,	1,	0,	-1,	-4,	0,	-3,	-10,	0,	-15,	-5,	2,	-14},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	0,	0,	0,	1,	0,	0,	1,	0,	-1,	-4,	0,	-3,	-8,	3,	-13,	-5,	-2,	-11},
	{1,	0,	1,	0,	0,	1,	0,	0,	0,	0,	0,	-1,	0,	0,	0,	1,	0,	-1,	-3,	0,	-2,	-7,	3,	-12,	-5,	-3,	-12},
	{1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	1,	0,	0,	-3,	0,	-2,	-9,	1,	-12,	-4,	-3,	-11},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3,	0,	-2,	-10,	0,	-12,	-2,	0,	-11},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	1,	0,	0,	-1,	1,	0,	0,	-3,	0,	-2,	-9,	0,	-12,	-3,	1,	-10},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	0,	0,	1,	0,	0,	0,	1,	0,	0,	-3,	0,	-2,	-9,	0,	-11,	-3,	0,	-10},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	1,	0,	0,	3,	0,	1,	-2,	1,	0,	-9,	0,	-11,	-2,	2,	-6},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	1,	0,	0,	3,	0,	1,	-2,	0,	0,	-9,	0,	-10,	-3,	1,	-6},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	0,	0,	-1,	3,	0,	1,	-2,	0,	0,	-7,	2,	-7,	0,	2,	-3},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	0,	0,	-1,	3,	0,	1,	-2,	0,	0,	-7,	0,	-7,	-1,	1,	-4},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

/************
 *	  HMT   *
 ************/

static unsigned int base_luminance_reverse_hmt_single[][2] = {
	{10,	48},
	{11,	53},
	{12,	59},
	{13,	64},
	{14,	69},
	{15,	73},
	{16,	78},
	{17,	83},
	{19,	92},
	{20,	95},
	{21,	100},
	{22,	104},
	{23,	108},
	{25,	117},
	{27,	125},
	{29,	132},
	{31,	143},
	{33,	151},
	{35,	160},
	{37,	167},
	{39,	177},
	{41,	183},
	{44,	195},
	{47,	208},
	{50,	220},
	{53,	229},
	{56,	244},
	{60,	256},
	{64,	267},
	{68,	281},
	{72,	291},
	{77,	229},
	{82,	242},
	{87,	255},
	{93,	268},
	{99,	281},
	{105,	295},
};

static int gradation_offset_reverse_hmt_single[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, -1, -1, 2, 4, 5, 6, 8, 8},
	{0, -2, -1, 0, 4, 6, 7, 7, 8},
	{0, -3, -1, 0, 4, 5, 6, 8, 8},
	{0, -4, -1, 0, 4, 4, 6, 7, 8},
	{0, -4, -1, 0, 4, 5, 6, 8, 9},
	{0, -4, -1, 0, 3, 4, 6, 8, 9},
	{0, -3, -1, 0, 3, 4, 6, 8, 9},
	{0, -4, -1, 0, 4, 4, 5, 7, 8},
	{0, -3, -1, 0, 3, 4, 6, 7, 8},
	{0, -2, -2, 0, 3, 4, 6, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 8},
	{0, -2, -1, 0, 2, 4, 5, 8, 8},
	{0, -1, -1, 0, 2, 4, 4, 7, 8},
	{0, -2, -2, 0, 3, 4, 5, 7, 9},
	{0, -1, -1, 0, 3, 4, 6, 7, 9},
	{0, -1, -1, 0, 3, 4, 4, 7, 8},
	{0, -1, 0, 0, 3, 4, 5, 8, 8},
	{0, -2, -1, 2, 3, 4, 4, 7, 8},
	{0, -1, 0, 2, 3, 4, 4, 7, 8},
	{0, -2, 0, 3, 3, 4, 5, 7, 8},
	{0, -2, 0, 2, 3, 4, 4, 7, 8},
	{0, -2, 0, 3, 4, 4, 4, 7, 8},
	{0, -2, 0, 3, 3, 3, 4, 6, 9},
	{0, -2, 0, 4, 4, 4, 4, 7, 8},
	{0, -2, 2, 3, 4, 4, 5, 7, 8},
	{0, -2, 2, 3, 4, 4, 4, 7, 8},
	{0, -1, 3, 4, 4, 4, 5, 7, 8},
	{0, 0, 4, 4, 4, 4, 4, 6, 8},
	{0, 0, 4, 5, 4, 4, 5, 7, 9},
	{0, 0, 5, 5, 4, 4, 4, 7, 9},
	{0, -3, 0, 2, 2, 0, 3, 4, 4},
	{0, -3, 0, 3, 0, 2, 2, 4, 4},
	{0, -3, 0, 2, 0, 2, 3, 4, 4},
	{0, -2, 0, 3, 2, 0, 2, 3, 4},
	{0, -2, 2, 3, 2, 3, 2, 3, 4},
	{0, -1, 3, 3, 3, 2, 2, 4, 4},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-1, 0, 0, -1, 0, -1, -3, 0, -3, -5, 2, -6, -7, 6, -12, -11, 7, -16, -22, 11, -22, -28, 12, -26, 6, -12, 1},
	{0, 0, 0, -1, 0, -1, -2, 0, -3, -5, 3, -6, -7, 5, -10, -9, 6, -12, -20, 10, -20, -27, 14, -30, 10, -8, 1},
	{-1, 0, 0, -1, 0, 0, -2, 0, -3, -6, 2, -6, -6, 5, -10, -10, 6, -14, -19, 9, -20, -30, 12, -26, 12, -6, -2},
	{0, 0, 0, -2, 0, -1, -1, 0, -2, -5, 2, -6, -6, 5, -10, -8, 7, -14, -19, 9, -19, -28, 14, -29, 12, -6, -2},
	{0, 0, 0, -2, 0, 0, 0, 0, -2, -5, 2, -5, -7, 4, -10, -9, 6, -13, -15, 8, -16, -30, 14, -30, 2, 0, -2},
	{-1, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -5, -7, 4, -10, -9, 5, -12, -16, 8, -17, -27, 14, -30, 0, 0, -4},
	{-2, 0, -1, 0, 0, 1, -1, 0, -1, -5, 2, -6, -4, 4, -8, -9, 6, -12, -14, 8, -17, -28, 14, -30, 0, 0, -4},
	{-1, 0, 0, 0, 0, 0, -1, 0, -2, -3, 2, -4, -5, 4, -9, -8, 5, -11, -15, 9, -18, -25, 14, -28, 2, 2, -4},
	{0, 0, 0, -2, 0, 0, -1, 0, -2, -3, 2, -5, -6, 4, -8, -7, 6, -12, -12, 7, -14, -31, 16, -32, 2, 2, -4},
	{-1, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -5, -6, 3, -8, -8, 5, -10, -13, 7, -16, -31, 16, -34, 2, 3, -4},
	{0, 0, 0, -2, 0, 0, 0, 0, -1, -3, 2, -4, -6, 3, -7, -7, 4, -10, -15, 8, -17, -34, 16, -34, 1, 2, -5},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -2, 2, -4, -6, 3, -8, -8, 5, -11, -11, 8, -16, -29, 15, -32, 6, 8, -1},
	{0, 0, 0, -1, 0, 1, 0, 0, 0, -2, 2, -4, -5, 3, -7, -6, 4, -9, -15, 8, -18, -25, 12, -26, 6, 8, -1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -4, 3, -7, -7, 4, -10, -14, 8, -17, -25, 13, -27, 6, 8, -1},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -4, 1, -4, -5, 3, -6, -6, 4, -10, -12, 7, -15, -30, 14, -30, -6, 0, -9},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -5, 2, -6, -5, 4, -9, -10, 6, -13, -27, 15, -31, -6, 1, -9},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -3, -6, 2, -6, -5, 4, -8, -13, 8, -17, -28, 14, -30, -4, 1, -7},
	{0, 0, 0, 0, 0, 1, 0, 0, -1, -4, 1, -4, -6, 2, -6, -4, 4, -8, -11, 7, -15, -24, 12, -26, -4, 1, -8},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 1, -2, -5, 2, -6, -5, 3, -8, -11, 7, -16, -25, 12, -26, -5, 0, -8},
	{0, 0, 0, -1, 0, 0, 0, 0, 0, -2, 1, -2, -4, 2, -5, -5, 3, -8, -12, 7, -16, -26, 13, -26, -4, 2, -8},
	{0, 0, 0, 0, 0, 0, -1, 0, -1, -2, 1, -3, -4, 2, -4, -5, 3, -7, -11, 6, -14, -26, 13, -28, -4, 0, -10},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, -2, 0, -2, -4, 2, -6, -6, 3, -7, -10, 6, -14, -26, 14, -28, -4, 0, -10},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -2, -2, 2, -4, -6, 3, -7, -9, 7, -14, -26, 13, -28, -7, -1, -13},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -2, -4, 2, -4, -4, 3, -6, -8, 6, -12, -28, 14, -30, -6, -1, -13},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -4, -5, 3, -6, -9, 6, -13, -21, 12, -24, -6, -1, -12},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -2, -4, 1, -4, -4, 2, -5, -9, 5, -12, -22, 13, -26, -6, 3, -11},
	{1, 0, 0, 0, 0, 1, 0, 0, 0, -4, 0, -2, -2, 2, -4, -4, 2, -5, -8, 5, -11, -23, 12, -26, -5, 5, -11},
	{2, 0, 0, 0, 0, 1, -1, 0, 0, -2, 0, -2, -2, 2, -4, -6, 2, -6, -6, 4, -10, -23, 13, -27, -5, 6, -11},
	{1, 0, 1, 0, 0, 1, 0, 0, 0, -3, 0, -2, -3, 1, -3, -5, 2, -6, -7, 5, -10, -22, 13, -27, -5, 6, -10},
	{1, 0, 0, 0, 0, 1, 0, 0, 0, -2, 0, -1, -3, 1, -4, -4, 2, -5, -8, 4, -10, -17, 11, -23, -5, 6, -10},
	{1, 0, 1, 0, 0, 0, 0, 0, 0, -2, 0, -1, -2, 1, -3, -4, 2, -5, -8, 4, -10, -17, 11, -23, -5, 6, -10},
	{0, 0, 0, 0, 0, 2, -1, 0, 0, -1, 0, -1, -2, 1, -3, -1, 2, -4, -3, 2, -6, -13, 10, -20, -5, 4, -9},
	{0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, -2, 1, -3, -2, 1, -4, -4, 3, -8, -12, 9, -20, -3, 4, -9},
	{0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, -2, 1, -3, -1, 1, -3, -4, 3, -7, -12, 10, -21, -4, 4, -11},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, -1, -1, 1, -2, -2, 1, -3, -4, 3, -7, -12, 10, -22, -4, 4, -12},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, -2, 1, -2, -2, 1, -3, -3, 3, -7, -10, 10, -20, -7, 0, -15},
	{0, 0, 0, 1, 0, 1, 0, 0, 0, -2, 0, -1, -1, 1, -2, -2, 1, -3, -4, 2, -6, -9, 8, -18, -8, 9, -18},
};
#endif
