/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_ANA38401_AMS968HH01_H_
#define _SS_DSI_SMART_DIMMING_ANA38401_AMS968HH01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

#define LUMINANCE_MAX 65
#define GAMMA_SET_MAX 33
#define BIT_SHIFT 22
/*
	it means BIT_SHIFT is 22.  pow(2,BIT_SHIFT) is 4194304.
	BIT_SHIFT is used for right bit shfit
*/
#define BIT_SHFIT_MUL 4194304

#define GRAY_SCALE_MAX 256

/* 6.8 * 4194304 */
#define ANA34801_VREG0_REF_L 28521267
/* 1.5 * 4194304 */
#define ANA34801_VREG0_REF_H 6291456


/*VT V0,V3,V11,V23,V35,V51,V87,V151,V203,V255*/
#define ARRAY_MAX 11

/* PANEL DEPENDENT THINGS */
#define MAX_CANDELA 360
#define MIN_CANDELA	2

/*
*	ID 0x20
*/
#define V255_300CD_R_MSB_20 0x01
#define V255_300CD_R_LSB_20 0x00

#define V255_300CD_G_MSB_20 0x01
#define V255_300CD_G_LSB_20 0x00

#define V255_300CD_B_MSB_20 0x01
#define V255_300CD_B_LSB_20 0x00

#define V203_300CD_R_20 0x80
#define V203_300CD_G_20 0x80
#define V203_300CD_B_20 0x80

#define V151_300CD_R_20 0x80
#define V151_300CD_G_20 0x80
#define V151_300CD_B_20 0x80

#define V87_300CD_R_20 0x80
#define V87_300CD_G_20 0x80
#define V87_300CD_B_20 0x80

#define V51_300CD_R_20 0x80
#define V51_300CD_G_20 0x80
#define V51_300CD_B_20 0x80

#define V35_300CD_R_20 0x80
#define V35_300CD_G_20 0x80
#define V35_300CD_B_20 0x80

#define V23_300CD_R_20 0x80
#define V23_300CD_G_20 0x80
#define V23_300CD_B_20 0x80

#define V11_300CD_R_20 0x80
#define V11_300CD_G_20 0x80
#define V11_300CD_B_20 0x80

#define V3_300CD_R_20 0x80
#define V3_300CD_G_20 0x80
#define V3_300CD_B_20 0x80

#define VT_300CD_R_20 0x00
#define VT_300CD_G_20 0x00
#define VT_300CD_B_20 0x00

#define HBM_INTERPOLATION_STEP 8

enum {
	V1_INDEX = 0,
	V3_INDEX = 1,
	V11_INDEX = 2,
	V23_INDEX = 3,
	V35_INDEX = 4,
	V51_INDEX = 5,
	V87_INDEX = 6,
	V151_INDEX = 7,
	V203_INDEX = 8,
	V255_INDEX = 9,
};

struct GAMMA_LEVEL {
	int level_0;
	int level_1;
	int level_3;
	int level_11;
	int level_23;
	int level_35;
	int level_51;
	int level_87;
	int level_151;
	int level_203;
	int level_255;
} __packed;

struct RGB_OUTPUT_VOLTARE {
	struct GAMMA_LEVEL R_VOLTAGE;
	struct GAMMA_LEVEL G_VOLTAGE;
	struct GAMMA_LEVEL B_VOLTAGE;
} __packed;

struct GRAY_VOLTAGE {
	/*
		This voltage value use 14bit right shit
		it means voltage is divied by 16384.
	*/
	int R_Gray;
	int G_Gray;
	int B_Gray;
} __packed;

struct GRAY_SCALE {
	struct GRAY_VOLTAGE TABLE[GRAY_SCALE_MAX];
	struct GRAY_VOLTAGE VT_TABLE;
} __packed;

/*V0,V1,V3,V11,V23,V35,V51,V87,V151,V203,V255*/

struct MTP_SET {
	char OFFSET_255_MSB;
	char OFFSET_255_LSB;
	char OFFSET_203;
	char OFFSET_151;
	char OFFSET_87;
	char OFFSET_51;
	char OFFSET_35;
	char OFFSET_23;
	char OFFSET_11;
	char OFFSET_3;
	char OFFSET_1;
} __packed;

struct MTP_OFFSET {
	struct MTP_SET R_OFFSET;
	struct MTP_SET G_OFFSET;
	struct MTP_SET B_OFFSET;
} __packed;

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	struct MTP_OFFSET MTP_ORIGN;
	struct MTP_OFFSET MTP;
	struct RGB_OUTPUT_VOLTARE RGB_OUTPUT;
	struct GRAY_SCALE GRAY;

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP];
	char *hbm_payload;
	int hbm_brightness_level;
} __packed;

static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {378, 395, 413, 430, 448, 465, 483, 500};

#define CANDELA_MAX_TABLE 64
#define RGB_COMPENSATION 24

static int candela_table[][2] = {
	{2, 0},
	{3, 1},
	{4, 2},
	{5, 3},
	{6, 4},
	{7, 5},
	{8, 6},
	{9, 7},
	{10, 8},
	{11, 9},
	{12, 10},
	{13, 11},
	{14, 12},
	{15, 13},
	{16, 14},
	{17, 15},
	{19, 16},
	{20, 17},
	{21, 18},
	{22, 19},
	{24, 20},
	{25, 21},
	{27, 22},
	{29, 23},
	{30, 24},
	{32, 25},
	{34, 26},
	{37, 27},
	{39, 28},
	{41, 29},
	{44, 30},
	{47, 31},
	{50, 32},
	{53, 33},
	{56, 34},
	{60, 35},
	{64, 36},
	{68, 37},
	{72, 38},
	{77, 39},
	{82, 40},
	{87, 41},
	{93, 42},
	{98, 43},
	{105, 44},
	{111, 45},
	{119, 46},
	{126, 47},
	{134, 48},
	{143, 49},
	{152, 50},
	{162, 51},
	{172, 52},
	{183, 53},
	{195, 54},
	{207, 55},
	{220, 56},
	{234, 57},
	{249, 58},
	{265, 59},
	{282, 60},
	{300, 61},
	{316, 62},
	{333, 63},
	{360, 64},
};


static int base_luminance_revA[][2] = {
	{2, 112},
	{3, 112},
	{4, 112},
	{5, 112},
	{6, 112},
	{7, 112},
	{8, 112},
	{9, 112},
	{10, 112},
	{11, 112},
	{12, 112},
	{13, 112},
	{14, 112},
	{15, 112},
	{16, 112},
	{17, 112},
	{19, 112},
	{20, 112},
	{21, 112},
	{22, 112},
	{24, 112},
	{25, 112},
	{27, 112},
	{29, 112},
	{30, 112},
	{32, 112},
	{34, 112},
	{37, 112},
	{39, 112},
	{41, 112},
	{44, 112},
	{47, 112},
	{50, 112},
	{53, 112},
	{56, 112},
	{60, 112},
	{64, 112},
	{68, 112},
	{72, 112},
	{77, 120},
	{82, 127},
	{87, 135},
	{93, 143},
	{98, 152},
	{105, 162},
	{111, 170},
	{119, 181},
	{126, 192},
	{134, 203},
	{143, 216},
	{152, 227},
	{162, 240},
	{172, 254},
	{183, 254},
	{195, 254},
	{207, 254},
	{220, 254},
	{234, 254},
	{249, 254},
	{265, 272},
	{282, 288},
	{300, 307},
	{316, 321},
	{333, 336},
	{360, 360},
};

static int gradation_offset_revA[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V3 */
	{0, 8, 16, 26, 35, 41, 45, 47, 49,},/*2 CD*/
	{0, 7, 14, 21, 28, 30, 36, 40, 42,},/*3 CD*/
	{0, 6, 10, 16, 18, 22, 27, 31, 34,},/*4 CD*/
	{0, 5, 9, 14, 17, 20, 25, 29, 31,},/*5 CD*/
	{0, 5, 9, 13, 16, 19, 23, 27, 28,},/*6 CD*/
	{0, 5, 8, 11, 13, 15, 19, 24, 26,},/*7 CD*/
	{0, 5, 7, 10, 11, 14, 17, 21, 23,},/*8 CD*/
	{0, 5, 7, 9, 10, 11, 15, 19, 22,},/*9 CD*/
	{0, 4, 6, 8, 9, 10, 13, 17, 19,},/*10 CD*/
	{0, 4, 6, 7, 9, 10, 13, 17, 18,},/*11 CD*/
	{0, 4, 6, 7, 8, 10, 13, 17, 17,},/*12 CD*/
	{0, 4, 6, 7, 8, 10, 13, 16, 16,},/*13 CD*/
	{0, 4, 5, 6, 7, 9, 12, 15, 16,},/*14 CD*/
	{0, 4, 5, 6, 6, 8, 11, 14, 15,},/*15 CD*/
	{0, 4, 5, 6, 6, 7, 10, 14, 14,},/*16 CD*/
	{0, 4, 5, 6, 6, 7, 10, 14, 14,},/*17 CD*/
	{0, 4, 5, 6, 6, 7, 10, 13, 13,},/*19 CD*/
	{0, 4, 4, 5, 5, 6, 9, 12, 12,},/*20 CD*/
	{0, 4, 4, 5, 5, 6, 9, 12, 12,},/*21 CD*/
	{0, 4, 4, 5, 5, 6, 8, 11, 12,},/*22 CD*/
	{0, 4, 4, 4, 4, 5, 8, 11, 12,},/*24 CD*/
	{0, 4, 4, 4, 4, 5, 8, 11, 12,},/*25 CD*/
	{0, 4, 4, 4, 4, 5, 7, 10, 12,},/*27 CD*/
	{0, 4, 4, 4, 4, 5, 7, 10, 11,},/*29 CD*/
	{0, 4, 4, 4, 4, 4, 7, 9, 11,},/*30 CD*/
	{0, 3, 4, 4, 4, 4, 7, 9, 11,},/*32 CD*/
	{0, 3, 4, 4, 4, 4, 6, 8, 11,},/*34 CD*/
	{0, 3, 4, 4, 4, 4, 6, 8, 11,},/*37 CD*/
	{0, 3, 4, 4, 3, 4, 6, 8, 10,},/*39 CD*/
	{0, 3, 4, 4, 3, 3, 5, 8, 9,},/*41 CD*/
	{0, 3, 3, 4, 3, 3, 5, 7, 9,},/*44 CD*/
	{0, 3, 3, 3, 3, 3, 5, 7, 8,},/*47 CD*/
	{0, 3, 3, 3, 3, 3, 5, 7, 8,},/*50 CD*/
	{0, 3, 3, 3, 3, 2, 5, 6, 8,},/*53 CD*/
	{0, 3, 3, 3, 3, 2, 5, 6, 7,},/*56 CD*/
	{0, 3, 3, 3, 3, 2, 4, 6, 6,},/*60 CD*/
	{0, 3, 3, 3, 2, 2, 4, 6, 6,},/*64 CD*/
	{0, 2, 2, 3, 2, 2, 4, 5, 6,},/*68 CD*/
	{0, 2, 2, 3, 2, 2, 4, 5, 5,},/*72 CD*/
	{0, 3, 3, 3, 2, 2, 3, 5, 5,},/*77 CD*/
	{0, 3, 4, 2, 2, 2, 3, 5, 5,},/*82 CD*/
	{0, 1, 3, 3, 2, 3, 3, 4, 5,},/*87 CD*/
	{0, 3, 4, 3, 2, 2, 3, 4, 5,},/*93 CD*/
	{0, 1, 4, 3, 2, 2, 3, 4, 4,},/*98 CD*/
	{0, 1, 3, 3, 2, 3, 3, 5, 4,},/*105 CD*/
	{0, 1, 3, 4, 2, 2, 3, 4, 2,},/*111 CD*/
	{0, 2, 4, 4, 2, 2, 3, 4, 2,},/*119 CD*/
	{0, 2, 4, 4, 2, 2, 3, 4, 2,},/*126 CD*/
	{0, 2, 4, 3, 2, 2, 2, 4, 2,},/*134 CD*/
	{0, 1, 3, 3, 2, 2, 3, 4, 2,},/*143 CD*/
	{0, 2, 4, 4, 2, 2, 2, 3, 2,},/*152 CD*/
	{0, 1, 3, 3, 2, 2, 2, 3, 2,},/*162 CD*/
	{0, 2, 4, 3, 2, 2, 1, 3, 1,},/*172 CD*/
	{0, 2, 4, 3, 2, 2, 1, 3, 1,},/*183 CD*/
	{0, 1, 3, 2, 1, 1, 1, 2, 1,},/*195 CD*/
	{0, 1, 3, 2, 1, 1, 1, 2, 1,},/*207 CD*/
	{0, 1, 2, 2, 1, 1, 0, 1, 1,},/*220 CD*/
	{0, 1, 2, 1, 1, 1, 0, 1, 0,},/*234 CD*/
	{0, 0, 1, 1, 0, 0, 0, 0, 0,},/*249 CD*/
	{0, -1, -1, 1, 0, 0, 0, 1, 0,},/*262 CD*/
	{0, 0, 0, 0, 1, 0, 0, 0, 0,},/*285 CD*/
	{0, -1, 0, 0, 0, -1, -1, 0, 0,},/*300 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0,},/*316 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0,},/*333 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0 ,},/*360 CD*/
};

static int rgb_offset_revA[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-5, 0, 0, -3, 0, -3, -7, 0, -4, -6, 3, -5, -5, 2, -7, -3, 0, -5, 0, 0, -4, -3, 0, -7,},/*2 CD*/
	{-3, 0, 0, -2, 0, -1, -6, 0, -3, -6, 2, -5, -5, 3, -7, -3, 2, -4, -2, 0, -4, -4, 0, -6,},/*3 CD*/
	{-1, 0, 1, -1, 0, 0, -5, 0, -3, -6, 2, -4, -5, 3, -6, -4, 2, -4, -2, 1, -5, -4, 1, -6,},/*4 CD*/
	{-1, 0, 1, -1, 0, 0, -5, 0, -3, -5, 2, -3, -5, 2, -6, -3, 2, -3, -2, 1, -4, -4, 1, -6,},/*5 CD*/
	{0, 0, 1, -1, 0, 0, -4, 0, -2, -5, 1, -4, -6, 3, -6, -3, 2, -4, -2, 2, -4, -3, 0, -6,},/*6 CD*/
	{0, 0, 1, -1, 0, 0, -3, 0, -1, -5, 1, -4, -6, 3, -5, -4, 2, -5, 0, 2, -5, -3, 0, -6,},/*7 CD*/
	{0, 0, 1, -1, 0, 0, -1, 0, -1, -5, 1, -4, -6, 4, -6, -4, 2, -4, -1, 2, -3, -2, 0, -4,},/*8 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -4, 1, -3, -6, 4, -6, -4, 2, -3, -1, 2, -3, -2, 0, -5,},/*9 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -2, 1, -3, -7, 4, -6, -4, 2, -3, -1, 2, -3, -2, 0, -4,},/*10 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -2, 1, -3, -7, 3, -6, -4, 2, -3, -1, 2, -3, -2, 0, -4,},/*11 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -2, 1, -3, -7, 3, -6, -4, 2, -3, -1, 1, -3, -2, 0, -4,},/*12 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -2, 1, -3, -6, 2, -5, -5, 2, -3, -1, 2, -3, -2, 0, -4,},/*13 CD*/
	{0, 0, 1, 0, 0, 0, -2, 0, 0, -2, 1, -2, -6, 3, -6, -5, 2, -3, -1, 2, -3, -2, 1, -4,},/*14 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -3, 1, -2, -6, 2, -5, -5, 2, -3, -1, 2, -3, -2, 1, -4,},/*15 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -3, 1, -2, -6, 2, -5, -5, 1, -3, -1, 2, -2, -2, 2, -4,},/*16 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -1, 1, -2, -6, 2, -5, -5, 1, -4, 0, 2, -2, -1, 2, -4,},/*17 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -2, 0, -2, -6, 2, -4, -5, 1, -4, 0, 2, -2, -1, 3, -5,},/*19 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -1, 0, -2, -5, 2, -4, -5, 1, -4, 0, 2, -2, -1, 4, -5,},/*20 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -1, 0, -2, -5, 1, -4, -5, 1, -4, 0, 2, -2, -1, 4, -5,},/*21 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -5, 1, -4, -3, 1, -3, 0, 2, -2, -1, 4, -5,},/*22 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -5, 1, -4, -3, 1, -3, 0, 2, -2, -1, 4, -5,},/*24 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -5, 1, -4, -3, 1, -3, -1, 2, -2, -1, 3, -5,},/*25 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -4, 1, -4, -3, 1, -3, -1, 2, -3, -1, 4, -6,},/*27 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -3, 1, -3, -3, 1, -2, -1, 2, -3, -1, 4, -6,},/*29 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -3, 1, -3, -3, 0, -2, -1, 2, -3, -1, 4, -6,},/*30 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -3, 1, -3, -3, 0, -2, -1, 1, -4, -1, 4, -7,},/*32 CD*/
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -3, 1, -3, -2, 0, -2, -2, 1, -4, -1, 4, -7,},/*34 CD*/
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -3, 1, -3, -2, 0, -1, -2, 1, -4, -1, 4, -7,},/*37 CD*/
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -3, 1, -3, -2, 0, -1, -2, 1, -4, -1, 4, -7,},/*39 CD*/
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, 1, -2, -2, 0, -1, -2, 1, -4, -2, 4, -8,},/*41 CD*/
	{1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 1, -2, -3, 0, -1, -2, 1, -4, -2, 4, -8,},/*44 CD*/
	{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, 1, -3, -3, 0, -1, -2, 1, -4, -3, 4, -8,},/*47 CD*/
	{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, 1, -3, -3, 0, -1, -2, 1, -4, -3, 3, -9,},/*50 CD*/
	{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 1, -2, -4, 0, -1, -2, 0, -4, -4, 3, -9,},/*53 CD*/
	{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 1, -2, -4, 0, -1, -2, 0, -4, -4, 3, -9,},/*56 CD*/
	{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 1, -2, -4, 0, -2, -2, 0, -4, -5, 3, -9,},/*60 CD*/
	{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, -1, 0, -2, -4, 0, -2, -2, 0, -4, -5, 3, -9,},/*64 CD*/
	{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, -1, 0, -2, -4, 1, -3, -2, 1, -4, -5, 5, -11,},/*68 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -3, 1, -2, -2, 1, -4, -5, 5, -10,},/*72 CD*/
	{1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, -2, -2, 1, -2, -2, 1, -3, -5, 5, -10,},/*77 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, -1, -4, 1, -3, -3, 1, -4, -4, 5, -10,},/*82 CD*/
	{1, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, -2, -3, 1, -2, -3, 1, -3, -5, 5, -11,},/*87 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, -3, 1, -2, -4, 1, -4, -4, 5, -10,},/*93 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -2, 1, -2, -3, 1, -3, -5, 5, -10,},/*98 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, -3, 1, -4, -4, 4, -9,},/*105 CD*/
	{0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -2, -2, 1, -3, -5, 4, -10,},/*111 CD*/
	{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -2, 0, -2, -3, 1, -2, -3, 4, -8,},/*119 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -2, 0, -2, -3, 1, -2, -4, 4, -8,},/*126 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -2, 0, -2, -3, 1, -3, -4, 4, -8,},/*134 CD*/
	{0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, -2, 0, -2, -3, 1, -3, -5, 3, -8,},/*143 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -4, 1, -2, -4, 3, -8,},/*152 CD*/
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -3, 0, -2, -5, 3, -8,},/*162 CD*/
	{-1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -4, 1, -2, -4, 3, -7,},/*172 CD*/
	{-1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -4, 0, -2, -3, 2, 6,},/*183 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, -2, -3, 2, -5,},/*195 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, -2, -3, 1, -4,},/*207 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -2, -3, 1, -4,},/*216 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -4, 1, -4,},/*234 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*249 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*265 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*282 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*300 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*316 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*333 CD*/
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},/*360 CD*/
	};
#endif
