#include <linux/init.h>
#include <linux/printk.h> 
#ifdef CONFIG_RELOCATABLE_KERNEL
#include <asm/page.h>
#endif

/* Keep this on top */
#ifdef CONFIG_RELOCATABLE_KERNEL
static const char
builtime_crypto_hmac[128][32] __attribute__((aligned(PAGE_SIZE))) = {{0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			   0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f}};
#else
static const char
builtime_crypto_hmac[] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			   0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f};
#endif



const int first_crypto_rodata = 10;
int       first_crypto_data   = 20;


void first_crypto_text (void) __attribute__((unused));
void first_crypto_text (void)
{
}


#ifdef CONFIG_RELOCATABLE_KERNEL

#define KERNEL_KASLR_16K_ALGIN

#ifdef  KERNEL_KASLR_16K_ALGIN
#define KASLR_FIRST_SLOT	(0x80080000)
#if defined(CONFIG_GRACEQLTE_RAM_6G)
#define KASLR_FIRST_SLOT_6G	(0x40080000)
#endif
#define KASLR_ALIGN	(0x4000)
#else 
#define KASLR_FIRST_SLOT	(0x85000000)
#if defined(CONFIG_GRACEQLTE_RAM_6G)
#define KASLR_FIRST_SLOT_6G	(0x45000000)
#endif
#define KASLR_ALIGN	(0x200000)
#endif

const char *
get_builtime_crypto_hmac (void)
{
	extern u64 *__boot_kernel_offset; 
	u64 *kernel_addr = (u64 *) &__boot_kernel_offset;
	u64 offset = 0;
	u64 idx = 0;
#if defined(CONFIG_GRACEQLTE_RAM_6G)
	if(ddr_size_6g == 1) {
		offset = kernel_addr[1]  + kernel_addr[0] - (u64) KASLR_FIRST_SLOT_6G;
	} else {
		offset = kernel_addr[1]  + kernel_addr[0] - (u64) KASLR_FIRST_SLOT;
	}
#else
		offset = kernel_addr[1]  + kernel_addr[0] - (u64) KASLR_FIRST_SLOT;
#endif		

	idx = (offset / KASLR_ALIGN);  
	return builtime_crypto_hmac[idx];
}
#else
const char *
get_builtime_crypto_hmac (void)
{
	return builtime_crypto_hmac;
}
#endif 


void __init first_crypto_init(void) __attribute__((unused));
void __init first_crypto_init(void)
{
}

void __exit first_crypto_exit(void) __attribute__((unused));
void __exit first_crypto_exit(void)
{
}
