/* Object identifiers (OIDs) used by strongSwan
 * Copyright (C) 2003-2008 Andreas Steffen, Hochschule fuer Technik Rapperswil
 * 
 * This file has been automatically generated by the script oid.pl
 * Do not edit manually!
 */

#include <utils/utils.h>

#ifndef OID_H_
#define OID_H_

typedef struct {
    u_char octet;
    u_int  next;
    u_int  down;
    u_int  level;
    const u_char *name;
} oid_t;

extern const oid_t oid_names[];

#define OID_UNKNOWN							-1
#define OID_NAME_DISTINGUISHER				6
#define OID_PILOT_USERID					16
#define OID_PILOT_DOMAIN_COMPONENT			17
#define OID_COMMON_NAME						20
#define OID_SURNAME							21
#define OID_SERIAL_NUMBER					22
#define OID_COUNTRY							23
#define OID_LOCALITY						24
#define OID_STATE_OR_PROVINCE				25
#define OID_ORGANIZATION					26
#define OID_ORGANIZATION_UNIT				27
#define OID_TITLE							28
#define OID_DESCRIPTION						29
#define OID_USER_CERTIFICATE				30
#define OID_NAME							31
#define OID_GIVEN_NAME						32
#define OID_INITIALS						33
#define OID_UNIQUE_IDENTIFIER				34
#define OID_DN_QUALIFIER					35
#define OID_ROLE							36
#define OID_SUBJECT_KEY_ID					39
#define OID_KEY_USAGE						40
#define OID_SUBJECT_ALT_NAME				42
#define OID_BASIC_CONSTRAINTS				44
#define OID_CRL_NUMBER						45
#define OID_CRL_REASON_CODE					46
#define OID_DELTA_CRL_INDICATOR				49
#define OID_ISSUING_DIST_POINT				50
#define OID_NAME_CONSTRAINTS				52
#define OID_CRL_DISTRIBUTION_POINTS			53
#define OID_CERTIFICATE_POLICIES			54
#define OID_ANY_POLICY						55
#define OID_POLICY_MAPPINGS					56
#define OID_AUTHORITY_KEY_ID				57
#define OID_POLICY_CONSTRAINTS				58
#define OID_EXTENDED_KEY_USAGE				59
#define OID_FRESHEST_CRL					61
#define OID_INHIBIT_ANY_POLICY				62
#define OID_TARGET_INFORMATION				63
#define OID_NO_REV_AVAIL					64
#define OID_CAMELLIA128_CBC					75
#define OID_CAMELLIA192_CBC					76
#define OID_CAMELLIA256_CBC					77
#define OID_RSA_ENCRYPTION					90
#define OID_MD2_WITH_RSA					91
#define OID_MD5_WITH_RSA					92
#define OID_SHA1_WITH_RSA					93
#define OID_RSAES_OAEP						94
#define OID_SHA256_WITH_RSA					97
#define OID_SHA384_WITH_RSA					98
#define OID_SHA512_WITH_RSA					99
#define OID_SHA224_WITH_RSA					100
#define OID_PBE_MD5_DES_CBC					102
#define OID_PBE_SHA1_DES_CBC				103
#define OID_PBKDF2							104
#define OID_PBES2							105
#define OID_PKCS7_DATA						107
#define OID_PKCS7_SIGNED_DATA				108
#define OID_PKCS7_ENVELOPED_DATA			109
#define OID_PKCS7_SIGNED_ENVELOPED_DATA		110
#define OID_PKCS7_DIGESTED_DATA				111
#define OID_PKCS7_ENCRYPTED_DATA			112
#define OID_EMAIL_ADDRESS					114
#define OID_UNSTRUCTURED_NAME				115
#define OID_PKCS9_CONTENT_TYPE				116
#define OID_PKCS9_MESSAGE_DIGEST			117
#define OID_PKCS9_SIGNING_TIME				118
#define OID_CHALLENGE_PASSWORD				120
#define OID_UNSTRUCTURED_ADDRESS			121
#define OID_EXTENSION_REQUEST				122
#define OID_X509_CERTIFICATE				125
#define OID_PBE_SHA1_RC4_128				129
#define OID_PBE_SHA1_RC4_40					130
#define OID_PBE_SHA1_3DES_CBC				131
#define OID_PBE_SHA1_3DES_2KEY_CBC			132
#define OID_PBE_SHA1_RC2_CBC_128			133
#define OID_PBE_SHA1_RC2_CBC_40				134
#define OID_P12_KEY_BAG						137
#define OID_P12_PKCS8_KEY_BAG				138
#define OID_P12_CERT_BAG					139
#define OID_P12_CRL_BAG						140
#define OID_MD2								144
#define OID_MD5								145
#define OID_3DES_EDE_CBC					147
#define OID_EC_PUBLICKEY					151
#define OID_C2PNB163V1						154
#define OID_C2PNB163V2						155
#define OID_C2PNB163V3						156
#define OID_C2PNB176W1						157
#define OID_C2PNB191V1						158
#define OID_C2PNB191V2						159
#define OID_C2PNB191V3						160
#define OID_C2PNB191V4						161
#define OID_C2PNB191V5						162
#define OID_C2PNB208W1						163
#define OID_C2PNB239V1						164
#define OID_C2PNB239V2						165
#define OID_C2PNB239V3						166
#define OID_C2PNB239V4						167
#define OID_C2PNB239V5						168
#define OID_C2PNB272W1						169
#define OID_C2PNB304W1						170
#define OID_C2PNB359V1						171
#define OID_C2PNB368W1						172
#define OID_C2PNB431R1						173
#define OID_PRIME192V1						175
#define OID_PRIME192V2						176
#define OID_PRIME192V3						177
#define OID_PRIME239V1						178
#define OID_PRIME239V2						179
#define OID_PRIME239V3						180
#define OID_PRIME256V1						181
#define OID_ECDSA_WITH_SHA1					183
#define OID_ECDSA_WITH_SHA224				185
#define OID_ECDSA_WITH_SHA256				186
#define OID_ECDSA_WITH_SHA384				187
#define OID_ECDSA_WITH_SHA512				188
#define OID_MS_SMARTCARD_LOGON				202
#define OID_USER_PRINCIPAL_NAME				203
#define OID_STRONGSWAN						209
#define OID_BLISS_PUBLICKEY					214
#define OID_BLISS_I							216
#define OID_BLISS_II						217
#define OID_BLISS_III						218
#define OID_BLISS_IV						219
#define OID_BLISS_WITH_SHA512				221
#define OID_TCGID							228
#define OID_BLOWFISH_CBC					232
#define OID_AUTHORITY_INFO_ACCESS			276
#define OID_IP_ADDR_BLOCKS					278
#define OID_POLICY_QUALIFIER_CPS			280
#define OID_POLICY_QUALIFIER_UNOTICE		281
#define OID_SERVER_AUTH						283
#define OID_CLIENT_AUTH						284
#define OID_OCSP_SIGNING					291
#define OID_XMPP_ADDR						297
#define OID_AUTHENTICATION_INFO				301
#define OID_ACCESS_IDENTITY					302
#define OID_CHARGING_IDENTITY				303
#define OID_GROUP							304
#define OID_OCSP							307
#define OID_BASIC							308
#define OID_NONCE							309
#define OID_CRL								310
#define OID_RESPONSE						311
#define OID_NO_CHECK						312
#define OID_ARCHIVE_CUTOFF					313
#define OID_SERVICE_LOCATOR					314
#define OID_CA_ISSUERS						315
#define OID_IKE_INTERMEDIATE				320
#define OID_DES_CBC							324
#define OID_SHA1							325
#define OID_SHA1_WITH_RSA_OIW				326
#define OID_ECGDSA_PUBKEY					345
#define OID_ECGDSA_SIG_WITH_RIPEMD160		348
#define OID_ECGDSA_SIG_WITH_SHA1			349
#define OID_ECGDSA_SIG_WITH_SHA224			350
#define OID_ECGDSA_SIG_WITH_SHA256			351
#define OID_ECGDSA_SIG_WITH_SHA384			352
#define OID_ECGDSA_SIG_WITH_SHA512			353
#define OID_SECT163K1						376
#define OID_SECT163R1						377
#define OID_SECT239K1						378
#define OID_SECT113R1						379
#define OID_SECT113R2						380
#define OID_SECT112R1						381
#define OID_SECT112R2						382
#define OID_SECT160R1						383
#define OID_SECT160K1						384
#define OID_SECT256K1						385
#define OID_SECT163R2						386
#define OID_SECT283K1						387
#define OID_SECT283R1						388
#define OID_SECT131R1						389
#define OID_SECT131R2						390
#define OID_SECT193R1						391
#define OID_SECT193R2						392
#define OID_SECT233K1						393
#define OID_SECT233R1						394
#define OID_SECT128R1						395
#define OID_SECT128R2						396
#define OID_SECT160R2						397
#define OID_SECT192K1						398
#define OID_SECT224K1						399
#define OID_SECT224R1						400
#define OID_SECT384R1						401
#define OID_SECT521R1						402
#define OID_SECT409K1						403
#define OID_SECT409R1						404
#define OID_SECT571K1						405
#define OID_SECT571R1						406
#define OID_AES128_CBC						415
#define OID_AES128_GCM						416
#define OID_AES128_CCM						417
#define OID_AES192_CBC						418
#define OID_AES192_GCM						419
#define OID_AES192_CCM						420
#define OID_AES256_CBC						421
#define OID_AES256_GCM						422
#define OID_AES256_CCM						423
#define OID_SHA256							425
#define OID_SHA384							426
#define OID_SHA512							427
#define OID_SHA224							428
#define OID_NS_REVOCATION_URL				442
#define OID_NS_CA_REVOCATION_URL			443
#define OID_NS_CA_POLICY_URL				444
#define OID_NS_COMMENT						445
#define OID_EMPLOYEE_NUMBER					448
#define OID_PKI_MESSAGE_TYPE				454
#define OID_PKI_STATUS						455
#define OID_PKI_FAIL_INFO					456
#define OID_PKI_SENDER_NONCE				457
#define OID_PKI_RECIPIENT_NONCE				458
#define OID_PKI_TRANS_ID					459
#define OID_TPM_MANUFACTURER				465
#define OID_TPM_MODEL						466
#define OID_TPM_VERSION						467
#define OID_TPM_ID_LABEL					468

#define OID_MAX								469

#endif /* OID_H_ */
