
//#define HIGH_CURRENT_MODE  //high current for improving the performance
#if (RTV_SRC_CLK_FREQ_KHz == 19200)
static const U16 g_atBW_TABLE_CKSYN[MAX_NUM_RTV_BW_MODE_TYPE][9] = 
{
/*RTV_BW_MODE_5MHZ*/	{0x05,0x80, 0x01,0x01,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_6MHZ*/	{0x05,0x80, 0x01,0x01,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_7MHZ*/	{0x05,0x80, 0x01,0x01,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_8MHZ*/    {0x05,0x80, 0x01,0x01,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_430KHZ*/  {0x04,0x5A, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_500KHZ*/  {0x0A,0x7B, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_571KHZ*/  {0x14,0xAB, 0x00,0x00,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_768KHZ*/	{0x06,0x48, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x0D},
/*RTV_BW_MODE_1290KHZ*/ {0x05,0x24, 0x00,0x00,0x2E,0x13,0x0E,0x01,0x0D}
};
#elif (RTV_SRC_CLK_FREQ_KHz == 32000)
static const U16 g_atBW_TABLE_CKSYN[MAX_NUM_RTV_BW_MODE_TYPE][9] = 
{
/*RTV_BW_MODE_5MHZ*/	{0x19,0x180,0x01,0x01,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_6MHZ*/	{0x19,0x180,0x01,0x01,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_7MHZ*/	{0x19,0x180,0x01,0x01,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_8MHZ*/    {0x19,0x180,0x01,0x01,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_430KHZ*/  {0x04,0x36, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_500KHZ*/  {0x0A,0x7B, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_571KHZ*/  {0x14,0xAB, 0x00,0x00,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_768KHZ*/	{0x06,0x48, 0x01,0x00,0x2E,0x13,0x0E,0x01,0x29},
/*RTV_BW_MODE_1290KHZ*/ {0x05,0x24, 0x00,0x00,0x2E,0x13,0x0E,0x01,0x29}
};
#else 
#error " RTV_SRC_CLK_FREQ_KHz is not correct"
#endif

static const UINT g_atBW_TABLE_IIR[MAX_NUM_RTV_BW_MODE_TYPE][14] = 
{
/*RTV_BW_MODE_5MHZ*/	{0x02,0xBB83E,0x436A1,0xC12C0,0xC3472,0x43762,0xC1CD3,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x398FD},
/*RTV_BW_MODE_6MHZ*/	{0x02,0x3F019,0x43426,0xC108E,0xC3063,0x43405,0xC1C85,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3B1B1},
/*RTV_BW_MODE_7MHZ*/	{0x02,0x416DF,0x43084,0xBFBDC,0xC1331,0x41CF0,0xC1C18,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3B78B}, //19.2MHz
/*RTV_BW_MODE_8MHZ*/    {0x02,0x41F50,0x41B43,0xBF8A5,0xBF1E8,0x413E4,0xC1BEC,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3BDB2},  //19.2MHz IIR
/*RTV_BW_MODE_430KHZ*/  {0x02,0x43721,0x43400,0xBFDE1,0x3D238,0x4329D,0xC1965,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x371E2},  
/*RTV_BW_MODE_500KHZ*/  {0x03,0x435CF,0x43466,0xC1185,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3B27E}, 
/*RTV_BW_MODE_571KHZ*/  {0x02,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000},
/*RTV_BW_MODE_768KHZ*/	{0x02,0xC17A9,0x437A7,0xC1414,0xC38C3,0x439AA,0xC1DD4,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3B394},
/*RTV_BW_MODE_1290KHZ*/ {0x02,0xC37D0,0x43989,0xC1523,0xBF6D4,0x43B26,0xC1DFB,0x43000,0x43000,0x43000,0x43000,0x43000,0x43000,0x3732E}
};

static const U8 g_atBW_TABLE_BBA[MAX_NUM_RTV_BW_MODE_TYPE][7] = 
{
/*RTV_BW_MODE_5MHZ*/	{0x2D,0x20,0x03,0x03,0x02,0x02,0x01},
/*RTV_BW_MODE_6MHZ*/	{0x2D,0x20,0x03,0x03,0x02,0x02,0x01},
/*RTV_BW_MODE_7MHZ*/	{0x28,0x19,0x03,0x03,0x02,0x02,0x02},
/*RTV_BW_MODE_8MHZ*/    {0x22,0x13,0x03,0x03,0x02,0x02,0x03},
/*RTV_BW_MODE_430KHZ*/  {0x9C,0x15,0x00,0x03,0x00,0x00,0x00},
/*RTV_BW_MODE_500KHZ*/  {0xBF,0x20,0x03,0x03,0x02,0x02,0x00},
/*RTV_BW_MODE_571KHZ*/  {0xBF,0x20,0x03,0x03,0x02,0x02,0x00},
/*RTV_BW_MODE_768KHZ*/	{0xBF,0x20,0x03,0x03,0x02,0x02,0x00},
/*RTV_BW_MODE_1290KHZ*/ {0xBF,0x20,0x03,0x03,0x02,0x02,0x00}
};

static const U8 g_atBW_TABLE_ADC[MAX_NUM_RTV_BW_MODE_TYPE][47] = 
{
/*RTV_BW_MODE_5MHZ*/	{0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x0A,0x20,0x1F,0x12,0x20,0x13,0x20,0x00,0x00,0x00,0x02,0x35,0x49,0x49,0x4A,0x4A,0x4A,0x4A,0x4A,0x4A,0x12,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_6MHZ*/	{0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x0A,0x20,0x1F,0x12,0x20,0x13,0x20,0x00,0x00,0x00,0x02,0x35,0x4F,0x4F,0x4A,0x4A,0x4A,0x4A,0x4A,0x4A,0x12,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_7MHZ*/	{0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x0A,0x20,0x1F,0x12,0x20,0x13,0x20,0x00,0x00,0x00,0x02,0x35,0x4F,0x4F,0x4A,0x4A,0x4A,0x4A,0x4A,0x4A,0x12,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_8MHZ*/    {0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x0A,0x20,0x1F,0x12,0x20,0x13,0x20,0x00,0x00,0x00,0x02,0x35,0x4F,0x4F,0x4A,0x4A,0x4A,0x4A,0x4A,0x4A,0x12,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x10,0x1F,0x1F,0x1F,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_430KHZ*/  {0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x08,0x20,0x03,0x08,0x20,0x08,0x20,0x00,0x00,0x00,0x00,0x09,0x23,0x23,0x21,0x21,0x21,0x21,0x21,0x21,0x12,0x10,0x0E,0x0E,0x0E,0x10,0x0E,0x0E,0x0E,0x10,0x0E,0x0E,0x0E,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_500KHZ*/  {0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x08,0x20,0x03,0x08,0x20,0x08,0x20,0x00,0x00,0x00,0x00,0x06,0x20,0x20,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x12,0x10,0x0D,0x0D,0x0D,0x10,0x0D,0x0D,0x0D,0x10,0x0D,0x0D,0x0D,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_571KHZ*/  {0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x0B,0x20,0x05,0x0B,0x20,0x0B,0x20,0x00,0x00,0x00,0x00,0x0F,0x2B,0x2B,0x29,0x29,0x29,0x29,0x29,0x29,0x12,0x10,0x11,0x11,0x11,0x10,0x11,0x11,0x11,0x10,0x11,0x11,0x11,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_768KHZ*/	{0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x08,0x20,0x03,0x08,0x20,0x08,0x20,0x00,0x00,0x00,0x00,0x06,0x20,0x20,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x12,0x10,0x0D,0x0D,0x0D,0x10,0x0D,0x0D,0x0D,0x10,0x0D,0x0D,0x0D,0x30,0x30,0x30,0x18,0x00,0x00},
/*RTV_BW_MODE_1290KHZ*/ {0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x08,0x20,0x04,0x08,0x20,0x08,0x20,0x00,0x00,0x00,0x00,0x03,0x1F,0x1F,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x12,0x10,0x0C,0x0C,0x0C,0x10,0x0C,0x0C,0x0C,0x10,0x0C,0x0C,0x0C,0x30,0x30,0x30,0x18,0x00,0x00}
};
/////////////////////////LNA Setting//////////////////////////////////////////
static const U8 g_atLNA_TABLE[20][29] = 
{
#ifdef HIGH_CURRENT_MODE
/* 80 - 90*/ {0x07,0x02,0x0A,0x03,0x03,0x07,0x00,0x00,0x0F,0x00,0x03,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/* 90 - 100*/{0x07,0x02,0x0A,0x03,0x02,0x07,0x00,0x00,0x0F,0x00,0x03,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/*100 - 110*/{0x07,0x02,0x0A,0x03,0x02,0x07,0x00,0x00,0x0F,0x00,0x02,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/*170 - 180*/{0x0B,0x02,0x10,0x03,0x05,0x00,0x05,0x02,0x07,0x00,0x03,0x04,0x3F,0x08,0x1F,0x2F,0x3F,0x12,0x14,0x02,0x3F,0x0C,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*180 - 190*/{0x0B,0x02,0x10,0x03,0x04,0x00,0x04,0x02,0x06,0x00,0x03,0x04,0x3F,0x08,0x1F,0x14,0x3F,0x12,0x14,0x02,0x3F,0x0C,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*190 - 200*/{0x0B,0x02,0x10,0x03,0x04,0x00,0x03,0x01,0x04,0x00,0x02,0x04,0x3F,0x08,0x1F,0x14,0x1F,0x0F,0x0F,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*200 - 210*/{0x0B,0x02,0x10,0x03,0x03,0x00,0x03,0x01,0x02,0x00,0x02,0x04,0x3F,0x0A,0x1F,0x11,0x1F,0x0F,0x0F,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*210 - 220*/{0x09,0x02,0x10,0x03,0x03,0x00,0x02,0x01,0x00,0x00,0x01,0x04,0x1E,0x0C,0x1F,0x0D,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*220 - 230*/{0x09,0x02,0x10,0x03,0x03,0x00,0x02,0x01,0x00,0x00,0x01,0x04,0x1E,0x0C,0x1F,0x0D,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*230 - 240*/{0x09,0x02,0x10,0x03,0x02,0x00,0x01,0x01,0x0F,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*240 - 250*/{0x09,0x02,0x10,0x03,0x02,0x00,0x01,0x01,0x0E,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*250 - 320*/{0x09,0x02,0x10,0x03,0x02,0x00,0x00,0x01,0x0E,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*470 - 510*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x01,0x00,0x01,0x00,0x00/*0x0F*/,0x06,0x0B,0x05,0x3F,0x3F,0x00/*0x0A*/,0x00/*0x06*/,0x3F,0x3F,0x07,0x03,0x3F,0x3F,0x05,0x03,0x3F,0x3F,0x05,0x02,0x02},
/*510 - 540*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x00/*0x07*/,0x06,0x07,0x05,0x3F,0x2F,0x00/*0x0A*/,0x00/*0x05*/,0x3F,0x3F,0x07,0x03,0x3F,0x3F,0x04,0x03,0x3F,0x3F,0x04,0x02,0x02},
/*540 - 560*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x00/*0x05*/,0x06,0x03,0x05,0x3F,0x1F,0x00/*0x0A*/,0x00/*0x04*/,0x3F,0x0F,0x03,0x02,0x3F,0x3F,0x04,0x03,0x0F,0x0F,0x03,0x01,0x02},
/*560 - 600*/{0x1F/*0x0D*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x00/*0x03*/,0x06,0x03,0x05,0x2F,0x16,0x00/*0x09*/,0x00/*0x02*/,0x3F,0x0F,0x03,0x02,0x1F,0x08,0x02,0x00,0x0F,0x0F,0x02,0x00,0x02},
/*600 - 630*/{0x1F/*0x0D*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x00/*0x01*/,0x06,0x00,0x05,0x1F,0x0C,0x00/*0x08*/,0x00/*0x00*/,0x3F,0x00,0x00,0x00,0x1F,0x08,0x02,0x00,0x00,0x10,0x01,0x00,0x02},
/*630 - 710*/{0x1F/*0x0D*/,0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00/*0x00*/,0x06,0x00,0x05,0x15,0x00,0x00/*0x06*/,0x00/*0x00*/,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x02},
/*710 - 810*/{0x1F/*0x0F*/,0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00/*0x00*/,0x06,0x00,0x05,0x15,0x00,0x00/*0x00*/,0x00/*0x00*/,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x02},
/*810 - 880*/{0x1F/*0x14*/,0x02,0x16,0x03,0x00,0x00,0x00,0x00,0x00/*0x00*/,0x06,0x00,0x05,0x09,0x00,0x00/*0x00*/,0x00/*0x00*/,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x02}
#else
/*80  - 90*/ {0x07,0x02,0x0A,0x03,0x03,0x07,0x00,0x00,0x0F,0x00,0x03,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/*90  - 100*/{0x07,0x02,0x0A,0x03,0x02,0x07,0x00,0x00,0x0F,0x00,0x03,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/*100 - 110*/{0x07,0x02,0x0A,0x03,0x02,0x07,0x00,0x00,0x0F,0x00,0x02,0x03,0x1F,0x00,0x00,0x00,0x1F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},
/*170 - 180*/{0x0B,0x02,0x10,0x03,0x05,0x00,0x05,0x02,0x07,0x00,0x03,0x04,0x3F,0x08,0x1F,0x2F,0x3F,0x12,0x14,0x02,0x3F,0x0C,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*180 - 190*/{0x0B,0x02,0x10,0x03,0x04,0x00,0x04,0x02,0x06,0x00,0x03,0x04,0x3F,0x08,0x1F,0x14,0x3F,0x12,0x14,0x02,0x3F,0x0C,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*190 - 200*/{0x0B,0x02,0x10,0x03,0x04,0x00,0x03,0x01,0x04,0x00,0x02,0x04,0x3F,0x08,0x1F,0x14,0x1F,0x0F,0x0F,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*200 - 210*/{0x0B,0x02,0x10,0x03,0x03,0x00,0x03,0x01,0x02,0x00,0x02,0x04,0x3F,0x0A,0x1F,0x11,0x1F,0x0F,0x0F,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*210 - 220*/{0x09,0x02,0x10,0x03,0x03,0x00,0x02,0x01,0x00,0x00,0x01,0x04,0x1E,0x0C,0x1F,0x0D,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*220 - 230*/{0x09,0x02,0x10,0x03,0x03,0x00,0x02,0x01,0x00,0x00,0x01,0x04,0x1E,0x0C,0x1F,0x0D,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*230 - 240*/{0x09,0x02,0x10,0x03,0x02,0x00,0x01,0x01,0x0F,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*240 - 250*/{0x09,0x02,0x10,0x03,0x02,0x00,0x01,0x01,0x0E,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*250 - 320*/{0x09,0x02,0x10,0x03,0x02,0x00,0x00,0x01,0x0E,0x00,0x01,0x04,0x12,0x0C,0x1F,0x0C,0x19,0x0C,0x03,0x02,0x14,0x07,0x1F,0x0F,0x03,0x3F,0x0F,0x0F,0x01},
/*470 - 510*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x01,0x00,0x01,0x00,0x0F,0x06,0x0B,0x05,0x3F,0x3F,0x00/*0x0A*/,0x06,0x3F,0x3F,0x07,0x03,0x3F,0x3F,0x05,0x03,0x3F,0x3F,0x05,0x02,0x02},
/*510 - 540*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x07,0x06,0x07,0x05,0x3F,0x2F,0x00/*0x0A*/,0x05,0x3F,0x3F,0x07,0x03,0x3F,0x3F,0x04,0x03,0x3F,0x3F,0x04,0x02,0x02},
/*540 - 560*/{0x1F/*0x0F*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x05,0x06,0x03,0x05,0x3F,0x1F,0x00/*0x0A*/,0x04,0x3F,0x0F,0x03,0x02,0x3F,0x3F,0x04,0x03,0x0F,0x0F,0x03,0x01,0x02},
/*560 - 600*/{0x1F/*0x0D*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x03,0x06,0x03,0x05,0x2F,0x16,0x00/*0x09*/,0x02,0x3F,0x0F,0x03,0x02,0x1F,0x08,0x02,0x00,0x0F,0x0F,0x02,0x00,0x02},
/*600 - 630*/{0x1F/*0x0D*/,0x02,0x0B,0x03,0x00,0x00,0x00,0x00,0x01,0x06,0x00,0x05,0x1F,0x0C,0x00/*0x08*/,0x00,0x3F,0x00,0x00,0x00,0x1F,0x08,0x02,0x00,0x00,0x10,0x01,0x00,0x02},
/*630 - 710*/{0x1F/*0x0D*/,0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x05,0x15,0x00,0x00/*0x06*/,0x00,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x02},
/*710 - 810*/{0x1F/*0x0F*/,0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x05,0x15,0x00,0x00/*0x00*/,0x00,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x02},
/*810 - 880*/{0x1F/*0x14*/,0x02,0x16,0x03,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x05,0x09,0x00,0x00/*0x00*/,0x00,0x3F,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x02}

#endif
};

/////////////////////OFDM Configuration////////////////////////////////////////
#if (RTV_SRC_CLK_FREQ_KHz == 19200)
#if defined(RTV_ISDBT_ENABLE)
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_6MHz[] = {
/*8*/    {0x00, 0x06, 0x78, 0x2E, 0x0D,0x10410410,0x1B6C8B43,0x208208,0x41},
/*9*/    {0x00, 0x04, 0x5A, 0x2E, 0x0D,0x0E72AE47,0x18607BCA,0x1CE55C,0x39},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x6C5C1B17,0x00000000,0x0D8B83,0x1B},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x68068068,0x00000000,0x0D00D0,0x1A},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x65965965,0x00000000,0x0CB2CB,0x19} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_7MHz[] = {
/*8*/    {0x00, 0x06, 0x78, 0x2E, 0x0D,0x12F684BD,0x1B6C8B43,0x25ED09,0x4B},
/*9*/    {0x00, 0x04, 0x5A, 0x2E, 0x0D,0x10DB20A8,0x18607BCA,0x21B641,0x43},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x7E6B74F0,0x00000000,0x0FCD6E,0x1F},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x795CEB24,0x00000000,0x0F2B9D,0x1E},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x7684BDA1,0x00000000,0x0ED097,0x1D} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_8MHz[] = {
/*8*/    {0x00, 0x06, 0x78, 0x2E, 0x0D,0x15AC056B,0x1B6C8B43,0x2B580A,0x56},
/*9*/    {0x00, 0x04, 0x5A, 0x2E, 0x0D,0x13439309,0x18607BCA,0x268726,0x4D},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x907ACEC9,0x00000000,0x120F59,0x24},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x8AB355E0,0x00000000,0x11566A,0x22},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x877321DC,0x00000000,0x10EE64,0x21} 
};
#endif
#if defined(RTV_DVBT_ENABLE)
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_5MHz[] = {
/*8*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x4C30C30C,0x00000000,0x098618,0x13},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x49249249,0x00000000,0x092492,0x12},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x476DB6DB,0x00000000,0x08EDB6,0x11} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_6MHz[] = {
/*8*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x5B6DB6DB,0x00000000,0x0B6DB6,0x16},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x57C57C57,0x00000000,0x0AF8AF,0x15},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x55B6DB6D,0x00000000,0x0AB6DB,0x15} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_7MHz[] = {
/*8*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x6AAAAAAA,0x00000000,0x0D5555,0x1A},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x66666666,0x00000000,0x0CCCCC,0x19},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x64000000,0x00000000,0x0C8000,0x19} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_8MHz[] = {
/*8*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/    {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x78, 0x2E, 0x0D,0x79E79E79,0x00000000,0x0F3CF3,0x1E},
/*20.0*/ {0x08, 0x05, 0x7D, 0x2E, 0x0D,0x75075075,0x00000000,0x0EA0EA,0x1D},
/*20.48*/{0x08, 0x05, 0x80, 0x2E, 0x0D,0x72492492,0x00000000,0x0E4924,0x1C} 
};
#endif
#elif (RTV_SRC_CLK_FREQ_KHz == 32000)
#if defined(RTV_ISDBT_ENABLE)
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_6MHz[] = {
/*8*/	 {0x00, 0x06, 0x48, 0x2E, 0x29,0x10410410,0x1B6C8B43,0x208208,0x41},
/*9*/	 {0x00, 0x04, 0x36, 0x2E, 0x29,0x0E72AE47,0x18607BCA,0x1CE55C,0x39},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x6C5C1B17,0x00000000,0x0D8B83,0x1B},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x68068068,0x00000000,0x0D00D0,0x1A},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x65965965,0x00000000,0x0CB2CB,0x19} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_7MHz[] = {
/*8*/	 {0x00, 0x06, 0x48, 0x2E, 0x29,0x12F684BD,0x1B6C8B43,0x25ED09,0x4B},
/*9*/	 {0x00, 0x04, 0x36, 0x2E, 0x29,0x10DB20A8,0x18607BCA,0x21B641,0x43},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x7E6B74F0,0x00000000,0x0FCD6E,0x1F},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x795CEB24,0x00000000,0x0F2B9D,0x1E},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x7684BDA1,0x00000000,0x0ED097,0x1D} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_ISDBT_8MHz[] = {
/*8*/	 {0x00, 0x06, 0x48, 0x2E, 0x29,0x15AC056B,0x1B6C8B43,0x2B580A,0x56},
/*9*/	 {0x00, 0x04, 0x36, 0x2E, 0x29,0x13439309,0x18607BCA,0x268726,0x4D},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x907ACEC9,0x00000000,0x120F59,0x24},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x8AB355E0,0x00000000,0x11566A,0x22},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x877321DC,0x00000000,0x10EE64,0x21} 
};
#endif
#if defined(RTV_DVBT_ENABLE)
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_5MHz[] = {
/*8*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x4C30C30C,0x00000000,0x098618,0x13},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x49249249,0x00000000,0x092492,0x12},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x476DB6DB,0x00000000,0x08EDB6,0x11} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_6MHz[] = {
/*8*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x5B6DB6DB,0x00000000,0x0B6DB6,0x16},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x57C57C57,0x00000000,0x0AF8AF,0x15},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x55B6DB6D,0x00000000,0x0AB6DB,0x15} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_7MHz[] = {
/*8*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x6AAAAAAA,0x00000000,0x0D5555,0x1A},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x66666666,0x00000000,0x0CCCCC,0x19},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x64000000,0x00000000,0x0C8000,0x19} 
};
static const struct RTV_ADC_CFG_INFO g_atAdcCfgTbl_DVBT_8MHz[] = {
/*8*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*9*/	 {0x00, 0x00, 0x00, 0x00, 0x00,0x00000000,0x00000000,0x000000,0x00},
/*19.2*/ {0x08, 0x05, 0x48, 0x2E, 0x29,0x79E79E79,0x00000000,0x0F3CF3,0x1E},
/*20.0*/ {0x08, 0x05, 0x4B, 0x2E, 0x29,0x75075075,0x00000000,0x0EA0EA,0x1D},
/*20.48*/{0x08, 0x19, 0x80, 0x6E, 0x29,0x72492492,0x00000000,0x0E4924,0x1C} 
};
#endif

#else 
	#error " RTV_SRC_CLK_FREQ_KHz is not correct"
#endif

