/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1679, 1710, 1692, 1692, 1680},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1024, 261, 100, 78, 66},
				{1006, 266, 106, 82, 69},
				{1007, 269, 106, 82, 69},
				{976, 279, 111, 86, 73},
				{952, 283, 116, 90, 76},
				{931, 284, 122, 94, 79},
				{918, 277, 129, 100, 83},
				{917, 267, 135, 105, 87},
				{918, 261, 127, 105, 88},
				{929, 261, 106, 86, 74},
				{958, 264, 103, 83, 72},
				{1016, 270, 108, 88, 76},
				{1117, 280, 113, 91, 82},
				{1280, 296, 118, 94, 86},
				{1532, 328, 123, 96, 80},
				{2122, 411, 125, 92, 76},
				{3608, 710, 127, 92, 77},
				{6522, 1101, 130, 92, 77},
				{12172, 1544, 140, 91, 76},
				{19425, 2203, 164, 93, 76},
				{29742, 3007, 194, 98, 78},
				{40856, 4089, 220, 101, 81},
				{58153, 6107, 271, 106, 83},
				{84171, 9408, 378, 113, 84},
				{120055, 13909, 545, 122, 86},
				{176691, 19678, 797, 132, 87},
				{245818, 27215, 1196, 151, 86},
				{333293, 37866, 1962, 213, 88},
				{456301, 53683, 3346, 418, 97},
				{607971, 77884, 5445, 923, 115}
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4387, 4385, 4379, 4373, 4363},
				{4297, 4310, 4311, 4308, 4299},
				{4217, 4242, 4249, 4248, 4239},
				{4141, 4177, 4188, 4187, 4180},
				{4071, 4114, 4128, 4129, 4122},
				{4007, 4054, 4073, 4073, 4068},
				{3950, 3995, 4022, 4023, 4018},
				{3903, 3941, 3976, 3977, 3974},
				{3862, 3895, 3924, 3930, 3927},
				{3828, 3857, 3873, 3877, 3878},
				{3802, 3826, 3839, 3843, 3843},
				{3782, 3801, 3814, 3817, 3818},
				{3765, 3781, 3794, 3796, 3797},
				{3749, 3766, 3777, 3778, 3779},
				{3733, 3752, 3765, 3763, 3757},
				{3715, 3733, 3750, 3745, 3734},
				{3696, 3705, 3726, 3722, 3710},
				{3679, 3683, 3695, 3693, 3683},
				{3663, 3669, 3669, 3669, 3660},
				{3651, 3660, 3656, 3656, 3649},
				{3646, 3655, 3652, 3653, 3646},
				{3641, 3649, 3648, 3650, 3643},
				{3636, 3642, 3644, 3646, 3640},
				{3630, 3634, 3640, 3642, 3635},
				{3621, 3624, 3634, 3636, 3630},
				{3608, 3612, 3623, 3624, 3618},
				{3590, 3592, 3600, 3598, 3589},
				{3557, 3554, 3557, 3553, 3544},
				{3497, 3495, 3497, 3493, 3485},
				{3411, 3414, 3416, 3414, 3408},
				{3300, 3300, 3300, 3300, 3300}
	}
};

struct bms_battery_data samsung_1720mAH_data = {
	.fcc				= 1720,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 159
};
