/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, -10, 0, 25, 40, 60},
	.y		= {1486, 1492, 1500, 1505, 1505, 1503},
	.cols	= 6
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 6,
	.row_entries		= {-20, -10, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1058, 615, 327, 100, 71, 56},
				{999, 586, 328, 100, 71, 57},
				{1000, 587, 329, 104, 74, 58},
				{952, 561, 325, 108, 77, 61},
				{936, 528, 322, 113, 80, 63},
				{931, 513, 308, 115, 80, 63},
				{959, 500, 290, 119, 82, 65},
				{1021, 491, 278, 123, 87, 68},
				{1083, 489, 271, 112, 89, 72},
				{1195, 528, 264, 95, 69, 58},
				{1328, 581, 272, 95, 69, 58},
				{1478, 621, 314, 96, 72, 60},
				{1655, 651, 364, 97, 74, 64},
				{1890, 682, 406, 102, 74, 66},
				{2188, 717, 448, 114, 77, 64},
				{2661, 753, 493, 124, 79, 61},
				{3515, 795, 530, 132, 80, 62},
				{4689, 870, 543, 138, 82, 63},
				{6051, 1002, 544, 145, 82, 61},
				{7039, 1092, 535, 152, 84, 64},
				{7278, 1048, 516, 152, 84, 65},
				{6823, 1037, 524, 161, 87, 66},
				{7785, 1140, 542, 171, 93, 69},
				{9246, 1280, 562, 180, 100, 71},
				{11418, 1465, 587, 187, 106, 72},
				{14862, 1723, 618, 189, 109, 74},
				{19890, 2097, 654, 187, 112, 78},
				{27494, 2691, 763, 191, 120, 84},
				{36191, 3568, 1014, 200, 124, 89},
				{45425, 5625, 1683, 265, 157, 123},
					}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 6,
	.temp		= {-20, -10, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4328, 4326, 4326, 4320, 4313, 4303},
				{4172, 4207, 4224, 4239, 4238, 4233},
				{4081, 4127, 4149, 4173, 4174, 4171},
				{3994, 4063, 4087, 4114, 4117, 4117},
				{3927, 3993, 4037, 4067, 4072, 4073},
				{3869, 3942, 3987, 4024, 4028, 4028},
				{3836, 3895, 3935, 3983, 3985, 3983},
				{3815, 3853, 3890, 3944, 3945, 3943},
				{3795, 3816, 3851, 3896, 3906, 3906},
				{3774, 3799, 3816, 3848, 3851, 3851},
				{3750, 3785, 3792, 3819, 3823, 3823},
				{3725, 3769, 3780, 3797, 3801, 3801},
				{3697, 3752, 3769, 3779, 3783, 3783},
				{3664, 3733, 3758, 3768, 3768, 3768},
				{3627, 3709, 3744, 3762, 3758, 3751},
				{3586, 3673, 3726, 3750, 3743, 3730},
				{3539, 3619, 3690, 3724, 3719, 3708},
				{3492, 3580, 3645, 3685, 3686, 3677},
				{3447, 3552, 3603, 3655, 3659, 3653},
				{3409, 3532, 3574, 3646, 3651, 3647},
				{3388, 3522, 3563, 3642, 3647, 3642},
				{3366, 3511, 3550, 3638, 3642, 3638},
				{3340, 3498, 3538, 3632, 3637, 3632},
				{3310, 3481, 3523, 3624, 3630, 3625},
				{3277, 3459, 3506, 3611, 3618, 3609},
				{3242, 3428, 3482, 3582, 3589, 3573},
				{3202, 3389, 3442, 3530, 3537, 3519},
				{3156, 3339, 3383, 3457, 3467, 3446},
				{3105, 3267, 3301, 3363, 3369, 3342},
				{3052, 3155, 3186, 3223, 3219, 3183},
				{3000, 3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data Samsung_8x10_Logan_CTC_1500mAh_data = {
	.fcc				= 1500,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 247
};
