/*
 * es515-access.h  --  ES515 Soc Audio access values
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _ES515_ACCESS_H
#define _ES515_ACCESS_H

#include "escore.h"

#define ES_API_WORD(upper, lower) ((upper << 16) | lower)

static struct escore_api_access es515_api_access[ES_API_ADDR_MAX] = {
	[ES_MIC_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0002),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0003),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0004),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_TARGET_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0005),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_NOISE_FLOOR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_SNR_IMPROVEMENT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0007),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_VEQ_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0009),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_OUT_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x000d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_NOISE_SUPPRESS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x000e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_STS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0010) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0010),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_STS_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0011) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0011),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_SPEAKER_VOLUME] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0012) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0012),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIDETONE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0015) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0015),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIDETONE_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0016) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0016),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_COMFORT_NOISE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x001a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x001a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_COMFORT_NOISE_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x001b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x001b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_ALGORITHM_RESET] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x001c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x001c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_POST_EQ] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x001f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x001f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_POST_EQ] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0020) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0020),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_CNG] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0023) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0023),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_VEQ_NOISE_ESTIMATION_ADJUSTMENT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0024) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0024),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_SLEW_RATE_UP] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0026) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0026),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_SLEW_RATE_DOWN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0027) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0027),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0028) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0028),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_TARGET_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0029) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0029),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_NOISE_FLOOR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x002a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x002a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_SNR_IMPROVEMENT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x002b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x002b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_SLEW_RATE_UP] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x002c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x002c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_SLEW_RATE_DOWN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x002d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x002d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_CNG_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x002e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x002e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_MBC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0030) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0030),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_MBC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0031) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0031),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_ESE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0034) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0034),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_NS_ADAPTATION_SPEED] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0039) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0039),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_SNR_ESTIMATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x003a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x003a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_VEQ_MAX_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x003d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x003d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_GUARDBAND] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x003e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x003e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_GUARDBAND] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x003f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x003f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_OUT_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0040) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0040),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_IN_LIMITER_MAX_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0042) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0042),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_NS_ADAPTATION_SPEED] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0043) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0043),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AEC_VARIABLE_ECHO_REF_DELAY] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0047) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0047),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_NOISE_SUPPRESS_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x004b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x004b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_NOISE_SUPPRESS_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x004c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x004c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_CNG] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x004d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x004d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_CNG_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x004e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x004e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TX_AGC_MAX_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0100) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0100),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_RX_AGC_MAX_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0102) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0102),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_API_VERSION_LO] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1001),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_API_VERSION_HI] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1002),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_AV_PROCESSOR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1003),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_AV_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1003),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_PRESET] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1005),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STEREO_WIDTH] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_AV_DIGITAL_OUT_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1007),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_TDMBC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1008),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_AV_OUT_LIMIT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1009),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STEREO_WIDENING] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STAT_NS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STAT_NS_SUPPRESS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STAT_NS_ADAP_SPEED] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_STAT_NS_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVLALON_STAT_NS_MAX_NOISE_ENERGY] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x100f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x100f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_VBB] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1010) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1010),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_VBB_STRENGTH] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1011) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1011),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1012) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1012),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND1_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1013) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1013),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND2_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1014) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1014),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND3_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1015) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1015),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND4_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1016) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1016),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND5_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1017) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1017),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND6_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1018) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1018),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND7_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1019) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1019),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND8_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND9_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ_GRAPHIC_BAND10_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_TDDRC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_TDDRC_STRENGTH] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_LIMITER] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x101f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x101f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_AVALON_EQ] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x1020) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1020),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2000),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_OUT_HEADROOM_LIMITER] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2001),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2002),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_IN_HEADROOM_LIMITER] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2004),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_COMFORT_NOISE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_COMFORT_NOISE_LEVEL] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2007),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_VQOS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2008),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_POSITION_SUPPRESS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2009),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_OUT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_SPEECH_TARGET] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_SNR_IMPROVE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_NOISE_FLOOR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_MAX_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200e),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_UP_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x200f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x200f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_DOWN_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2010) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2010),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_AGC_GUARDBAND] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2011) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2011),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_POST_EQ_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2013) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2013),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_NARRATOR_MBC_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2014) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2014),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_BEAM_WIDTH] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2015) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2015),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_OUT] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2016) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2016),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_SPEECH_TARGET] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2017) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2017),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_SNR_IMPROVE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2018) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2018),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_NOISE_FLOOR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2019) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2019),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_MAX_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x201a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x201a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_UP_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x201b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x201b),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_DOWN_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x201c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x201c),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_AGC_GUARDBAND] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x201d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x201d),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_VQOS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x201f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x201f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_POST_EQ_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2020) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2020),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIRAC_SCENE_MBC_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x2021) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2021),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_API_VERSION_LO] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3001),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_API_VERSION_HI] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3002),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_ENABLE_BEEP_SYS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3003),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_ENABLE_GEN_BEEP] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3005),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_GEN_BEEP_ON] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_GEN_BEEP_FREQ1] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3007),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_GEN_BEEP_FREQ2] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3008),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_GEN_BEEP_PAN_LR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x3009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x3009),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_TONE_PARAM_GEN_BEEP_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x300a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x300a),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DEREVERB_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0053) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0053),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DEREVERB_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0054) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0054),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_BWE_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x004f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x004f),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_BWE_HIGH_BAND_GAIN] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0050) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0050),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_BWE_MAX_SNR] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0051) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0051),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_BWE_POST_EQ_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x0052) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0052),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_WORD_LEN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a00) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a00),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a01) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a01),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_TX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a02) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a02),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_RX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a03) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a03),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_LATCH_EDGE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a04) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a04),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_ENDIAN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a05) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a05),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_TRISTATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a06) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a06),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_AUDIO_PORT_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a07) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a07),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_TDM_ENABLED] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a08) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a08),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_CLOCK_CONTROL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a09) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a09),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_DATA_JUSTIFICATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a0a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a0a),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTA_FS_DURATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0a0b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0a0b),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_WORD_LEN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b00) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b00),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b01) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b01),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_TX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b02) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b02),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_RX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b03) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b03),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_LATCH_EDGE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b04) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b04),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_ENDIAN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b05) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b05),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_TRISTATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b06) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b06),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_AUDIO_PORT_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b07) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b07),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_TDM_ENABLED] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b08) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b08),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_CLOCK_CONTROL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b09) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b09),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_DATA_JUSTIFICATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b0a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b0a),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTB_FS_DURATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0b0b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0b0b),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_WORD_LEN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c00) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c00),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c01) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c01),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_TX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c02) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c02),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_RX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c03) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c03),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_LATCH_EDGE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c04) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c04),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_ENDIAN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c05) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c05),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_TRISTATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c06) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c06),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_AUDIO_PORT_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c07) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c07),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_TDM_ENABLED] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c08) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c08),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_CLOCK_CONTROL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c09) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c09),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_DATA_JUSTIFICATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c0a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c0a),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTC_FS_DURATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0c0b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0c0b),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_WORD_LEN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d00) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d00),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d01) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d01),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_TX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d02) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d02),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_RX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d03) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d03),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_LATCH_EDGE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d04) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d04),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_ENDIAN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d05) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d05),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_TRISTATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d06) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d06),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_AUDIO_PORT_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d07) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d07),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_TDM_ENABLED] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d08) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d08),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_CLOCK_CONTROL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d09) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d09),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_DATA_JUSTIFICATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d0a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d0a),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORTD_FS_DURATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0d0b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0d0b),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SLIMBUS_LINK_MULTI_CHANNEL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0900) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0900),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_POWER_STATE] = {
		.read_msg = { ES_API_WORD(0x800f, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9010, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 6,
	},
	[ES_STREAMING] = {
		.read_msg = { ES_API_WORD(0x8025, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8025, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES_FE_STREAMING] = {
		.read_msg = { ES_API_WORD(0x8028, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8028, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 8,
	},
	[ES_PRESET] = {
		.read_msg = { ES_API_WORD(0x8031, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9031, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 2047,
	},
	[ES_ALGO_STATS] = {
		.read_msg = { ES_API_WORD(0x8042, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8042, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_ALGO_PROCESSING] = {
		.read_msg = { ES_API_WORD(0x8043, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x801c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_ALGO_SAMPLE_RATE] = {
		.read_msg = { ES_API_WORD(0x804b, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x804c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES_SMOOTH_RATE] = {
		.read_msg = { ES_API_WORD(0x804d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x804e, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_CHANGE_STATUS] = {
		.read_msg = { ES_API_WORD(0x804f, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x804f, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_DIGITAL_PASS_THROUGH] = {
		.read_msg = { ES_API_WORD(0x8052, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8052, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DATA_PATH] = {
		.read_msg = { ES_API_WORD(0x805b, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x805a, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_ALGORITHM] = {
		.read_msg = { ES_API_WORD(0x805d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x805c, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_MIX_SAMPLE_RATE] = {
		.read_msg = { ES_API_WORD(0x8065, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x805e, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 5,
	},
	[ES_SIGNAL_RMS_PORTA_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTA_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0001) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTA_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0002) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTA_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0003) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTB_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0004) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTB_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0005) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTB_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0006) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTB_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0007) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTC_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0008) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTC_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x0009) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTC_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000a) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTC_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000b) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTD_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000c) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTD_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000d) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTD_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000e) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_RMS_PORTD_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8013, 0x000f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8013, 0x000f) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTA_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTA_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0001) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTA_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0002) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTA_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0003) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTB_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0004) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTB_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0005) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTB_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0006) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTB_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0007) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTC_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0008) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTC_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x0009) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTC_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000a) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTC_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000b) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTD_DIN_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000c) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000c) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTD_DIN_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000d) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000d) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTD_DOUT_LEFT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000e) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000e) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SIGNAL_PEAK_PORTD_DOUT_RIGHT] = {
		.read_msg = { ES_API_WORD(0x8014, 0x000f) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8014, 0x000f) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_DIGITAL_GAIN_PRIMARY] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0100) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_SECONDARY] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0200) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_TERTIARY] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0300) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_QUAD] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0400) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_FEIN] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0500) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDIN1] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0600) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDIN2] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0700) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDIN3] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0800) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDIN4] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0900) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_UITONE1] = {
		.read_msg = { ES_API_WORD(0x801D, 0x000A) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0a00) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_UITONE2] = {
		.read_msg = { ES_API_WORD(0x801D, 0x000B) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x0b00) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_CSOUT] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0010) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_FEOUT1] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0011) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1100) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_FEOUT2] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0012) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1200) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDOUT1] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0013) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1300) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDOUT2] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0014) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1400) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDOUT3] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0015) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1500) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_DIGITAL_GAIN_AUDOUT4] = {
		.read_msg = { ES_API_WORD(0x801D, 0x0016) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8015, 0x1600) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_PORTA_TIMING] = {
		.read_msg = { ES_API_WORD(0x8059, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8058, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_PORTB_TIMING] = {
		.read_msg = { ES_API_WORD(0x8059, 0x1000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8058, 0x1000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_PORTC_TIMING] = {
		.read_msg = { ES_API_WORD(0x8059, 0x2000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8058, 0x2000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_PORTD_TIMING] = {
		.read_msg = { ES_API_WORD(0x8059, 0x3000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8058, 0x3000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_FLUSH] = {
		.read_msg = { ES_API_WORD(0x805A, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8059, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 0,
	},
	[ES_FW_FIRST_CHAR] = {
		.read_msg = { ES_API_WORD(0x8020, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8020, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_FW_NEXT_CHAR] = {
		.read_msg = { ES_API_WORD(0x8021, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8021, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_EVENT_RESPONSE] = {
		.read_msg = { ES_API_WORD(0x801a, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x901a, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_VOICE_SENSE_ENABLE] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_VOICE_SENSE_SET_KEYWORD] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_VOICE_SENSE_EVENT] = {
		.read_msg = { ES_API_WORD(0x806d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 2,
	},
	[ES_VOICE_SENSE_TRAINING_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5003),
				   ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000)
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 2,
	},
	[ES_VOICE_SENSE_TRAINING_RECORD] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_VOICE_SENSE_TRAINING_STATUS] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_VOICE_SENSE_DEMO_ENABLE] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_GET_SYS_INTERRUPT_STATUS] = {
		.read_msg = { ES_API_WORD(0x8053, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8053, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 0,
	},
	[ES_CLEAR_SYS_INTERRUPT_STATUS] = {
		.read_msg = { ES_API_WORD(0x8057, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8057, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 0x3FFF,
	},
	[ES_ACCESSORY_DET_CONFIG] = {
		.read_msg = { ES_API_WORD(0x8055, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8056, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_ACCESSORY_DET_STATUS] = {
		.read_msg = { ES_API_WORD(0x8054, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8054, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_DETECTION_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f30) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f30),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_SERIAL_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f31) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f31),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_PARALLEL_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f32) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f32),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_DETECTION_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f33) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f33),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 3,
	},
	[ES_BUTTON_PRESS_SETTLING_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f34) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f34),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 7,
	},
	[ES_BUTTON_BOUNCE_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f35) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f35),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 11,
	},
	[ES_BUTTON_DETECTION_LONG_PRESS_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f36) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f36),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 15,
	},
};

#endif /* _ES_ACCESS_H */
