/*
 * =================================================================
 *
 *       Filename:  smart_mtp_2p2_gamma.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Author: jb09.kim
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/

#ifndef _SMART_MTP_2P2_GAMMA_H_
#define _SMART_MTP_2P2_GAMMA_H_

/*
*		index : 0 ~ 255
*		((index/255)^2.25)*4194304
*/
static int candela_coeff_2p25[] = {
0 ,
16 ,
77 ,
191 ,
365 ,
603 ,
909 ,
1287 ,
1737 ,
2265 ,
2870 ,
3557 ,
4326 ,
5180 ,
6120 ,
7147 ,
8264 ,
9472 ,
10772 ,
12166 ,
13654 ,
15238 ,
16920 ,
18700 ,
20579 ,
22558 ,
24640 ,
26823 ,
29111 ,
31502 ,
33999 ,
36602 ,
39313 ,
42131 ,
45058 ,
48095 ,
51242 ,
54500 ,
57871 ,
61354 ,
64950 ,
68661 ,
72486 ,
76427 ,
80485 ,
84659 ,
88951 ,
93361 ,
97890 ,
102538 ,
107307 ,
112196 ,
117207 ,
122339 ,
127594 ,
132972 ,
138474 ,
144100 ,
149850 ,
155726 ,
161728 ,
167856 ,
174111 ,
180493 ,
187003 ,
193642 ,
200410 ,
207306 ,
214333 ,
221490 ,
228778 ,
236198 ,
243749 ,
251432 ,
259248 ,
267197 ,
275280 ,
283497 ,
291848 ,
300335 ,
308956 ,
317714 ,
326607 ,
335637 ,
344804 ,
354109 ,
363552 ,
373132 ,
382852 ,
392710 ,
402708 ,
412846 ,
423123 ,
433542 ,
444101 ,
454802 ,
465645 ,
476629 ,
487757 ,
499027 ,
510440 ,
521996 ,
533697 ,
545542 ,
557532 ,
569666 ,
581946 ,
594372 ,
606943 ,
619661 ,
632526 ,
645537 ,
658696 ,
672003 ,
685457 ,
699060 ,
712812 ,
726713 ,
740763 ,
754962 ,
769312 ,
783811 ,
798462 ,
813263 ,
828215 ,
843319 ,
858575 ,
873983 ,
889543 ,
905256 ,
921122 ,
937141 ,
953314 ,
969640 ,
986121 ,
1002756 ,
1019547 ,
1036492 ,
1053592 ,
1070848 ,
1088260 ,
1105828 ,
1123552 ,
1141433 ,
1159472 ,
1177667 ,
1196020 ,
1214531 ,
1233200 ,
1252027 ,
1271013 ,
1290157 ,
1309461 ,
1328924 ,
1348547 ,
1368330 ,
1388273 ,
1408376 ,
1428640 ,
1449066 ,
1469652 ,
1490400 ,
1511309 ,
1532380 ,
1553614 ,
1575010 ,
1596569 ,
1618291 ,
1640176 ,
1662224 ,
1684436 ,
1706812 ,
1729352 ,
1752057 ,
1774926 ,
1797960 ,
1821160 ,
1844524 ,
1868054 ,
1891750 ,
1915612 ,
1939641 ,
1963836 ,
1988197 ,
2012726 ,
2037422 ,
2062285 ,
2087316 ,
2112514 ,
2137881 ,
2163416 ,
2189120 ,
2214993 ,
2241034 ,
2267245 ,
2293625 ,
2320175 ,
2346894 ,
2373784 ,
2400844 ,
2428074 ,
2455476 ,
2483048 ,
2510791 ,
2538706 ,
2566792 ,
2595050 ,
2623480 ,
2652082 ,
2680857 ,
2709804 ,
2738924 ,
2768217 ,
2797684 ,
2827323 ,
2857137 ,
2887124 ,
2917285 ,
2947621 ,
2978131 ,
3008815 ,
3039675 ,
3070709 ,
3101919 ,
3133304 ,
3164865 ,
3196601 ,
3228514 ,
3260603 ,
3292868 ,
3325310 ,
3357929 ,
3390724 ,
3423697 ,
3456847 ,
3490175 ,
3523680 ,
3557364 ,
3591225 ,
3625265 ,
3659483 ,
3693881 ,
3728456 ,
3763211 ,
3798146 ,
3833259 ,
3868552 ,
3904025 ,
3939678 ,
3975512 ,
4011525 ,
4047719 ,
4084094 ,
4120649 ,
4157386 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^2.1)*4194304
*/
static int candela_coeff_2p1[] = {
0 ,
37 ,
159 ,
372 ,
681 ,
1088 ,
1596 ,
2206 ,
2920 ,
3740 ,
4666 ,
5700 ,
6842 ,
8095 ,
9458 ,
10932 ,
12519 ,
14219 ,
16032 ,
17960 ,
20003 ,
22161 ,
24435 ,
26826 ,
29334 ,
31959 ,
34703 ,
37566 ,
40547 ,
43648 ,
46868 ,
50209 ,
53671 ,
57254 ,
60958 ,
64784 ,
68732 ,
72803 ,
76997 ,
81313 ,
85753 ,
90317 ,
95006 ,
99818 ,
104755 ,
109818 ,
115005 ,
120318 ,
125757 ,
131322 ,
137013 ,
142831 ,
148776 ,
154848 ,
161047 ,
167374 ,
173828 ,
180411 ,
187122 ,
193961 ,
200929 ,
208026 ,
215252 ,
222608 ,
230093 ,
237708 ,
245453 ,
253328 ,
261333 ,
269469 ,
277736 ,
286133 ,
294662 ,
303322 ,
312113 ,
321036 ,
330091 ,
339278 ,
348597 ,
358049 ,
367633 ,
377350 ,
387199 ,
397182 ,
407298 ,
417547 ,
427930 ,
438446 ,
449096 ,
459880 ,
470798 ,
481851 ,
493038 ,
504359 ,
515815 ,
527406 ,
539132 ,
550993 ,
562989 ,
575121 ,
587389 ,
599792 ,
612330 ,
625005 ,
637816 ,
650763 ,
663847 ,
677067 ,
690423 ,
703917 ,
717547 ,
731314 ,
745218 ,
759260 ,
773438 ,
787755 ,
802209 ,
816800 ,
831530 ,
846397 ,
861403 ,
876546 ,
891828 ,
907249 ,
922807 ,
938505 ,
954341 ,
970316 ,
986430 ,
1002684 ,
1019076 ,
1035608 ,
1052279 ,
1069089 ,
1086039 ,
1103129 ,
1120359 ,
1137729 ,
1155238 ,
1172888 ,
1190678 ,
1208609 ,
1226679 ,
1244891 ,
1263243 ,
1281735 ,
1300369 ,
1319143 ,
1338059 ,
1357115 ,
1376313 ,
1395652 ,
1415132 ,
1434754 ,
1454518 ,
1474423 ,
1494470 ,
1514659 ,
1534989 ,
1555462 ,
1576077 ,
1596834 ,
1617734 ,
1638776 ,
1659960 ,
1681287 ,
1702756 ,
1724369 ,
1746124 ,
1768022 ,
1790063 ,
1812247 ,
1834574 ,
1857045 ,
1879658 ,
1902416 ,
1925316 ,
1948361 ,
1971549 ,
1994881 ,
2018356 ,
2041976 ,
2065739 ,
2089646 ,
2113698 ,
2137894 ,
2162234 ,
2186719 ,
2211348 ,
2236121 ,
2261039 ,
2286102 ,
2311310 ,
2336662 ,
2362159 ,
2387801 ,
2413589 ,
2439521 ,
2465599 ,
2491822 ,
2518190 ,
2544704 ,
2571363 ,
2598168 ,
2625118 ,
2652214 ,
2679456 ,
2706844 ,
2734378 ,
2762058 ,
2789883 ,
2817855 ,
2845973 ,
2874238 ,
2902649 ,
2931206 ,
2959909 ,
2988759 ,
3017756 ,
3046900 ,
3076190 ,
3105627 ,
3135211 ,
3164942 ,
3194820 ,
3224845 ,
3255017 ,
3285336 ,
3315803 ,
3346417 ,
3377178 ,
3408087 ,
3439143 ,
3470347 ,
3501699 ,
3533198 ,
3564846 ,
3596641 ,
3628584 ,
3660675 ,
3692913 ,
3725301 ,
3757836 ,
3790519 ,
3823351 ,
3856331 ,
3889459 ,
3922736 ,
3956162 ,
3989736 ,
4023459 ,
4057330 ,
4091350 ,
4125519 ,
4159837 ,
4194304 ,

};
/*
*		index : 0 ~ 255
*		((index/255)^2.05)*4194304
*/
static int candela_coeff_2p05[] = {
0 ,
49 ,
202 ,
465 ,
838 ,
1325 ,
1925 ,
2641 ,
3472 ,
4420 ,
5486 ,
6670 ,
7972 ,
9394 ,
10935 ,
12596 ,
14378 ,
16281 ,
18305 ,
20450 ,
22718 ,
25107 ,
27620 ,
30255 ,
33013 ,
35895 ,
38900 ,
42029 ,
45282 ,
48660 ,
52162 ,
55788 ,
59540 ,
63417 ,
67419 ,
71547 ,
75801 ,
80180 ,
84685 ,
89317 ,
94075 ,
98960 ,
103971 ,
109110 ,
114375 ,
119767 ,
125287 ,
130934 ,
136709 ,
142611 ,
148642 ,
154800 ,
161087 ,
167501 ,
174044 ,
180716 ,
187516 ,
194445 ,
201502 ,
208689 ,
216004 ,
223449 ,
231023 ,
238727 ,
246559 ,
254522 ,
262614 ,
270836 ,
279187 ,
287669 ,
296281 ,
305023 ,
313895 ,
322897 ,
332030 ,
341294 ,
350688 ,
360212 ,
369868 ,
379654 ,
389571 ,
399620 ,
409799 ,
420110 ,
430551 ,
441125 ,
451829 ,
462665 ,
473633 ,
484732 ,
495963 ,
507326 ,
518821 ,
530448 ,
542206 ,
554097 ,
566120 ,
578275 ,
590563 ,
602982 ,
615535 ,
628219 ,
641037 ,
653987 ,
667069 ,
680285 ,
693633 ,
707114 ,
720728 ,
734475 ,
748355 ,
762368 ,
776514 ,
790794 ,
805207 ,
819753 ,
834433 ,
849246 ,
864193 ,
879273 ,
894487 ,
909835 ,
925316 ,
940932 ,
956681 ,
972564 ,
988581 ,
1004732 ,
1021017 ,
1037436 ,
1053990 ,
1070678 ,
1087500 ,
1104456 ,
1121547 ,
1138772 ,
1156132 ,
1173626 ,
1191255 ,
1209018 ,
1226917 ,
1244949 ,
1263117 ,
1281420 ,
1299857 ,
1318430 ,
1337137 ,
1355979 ,
1374957 ,
1394069 ,
1413317 ,
1432700 ,
1452218 ,
1471872 ,
1491661 ,
1511585 ,
1531644 ,
1551840 ,
1572170 ,
1592636 ,
1613238 ,
1633976 ,
1654849 ,
1675858 ,
1697002 ,
1718283 ,
1739699 ,
1761251 ,
1782939 ,
1804763 ,
1826724 ,
1848820 ,
1871052 ,
1893420 ,
1915925 ,
1938566 ,
1961343 ,
1984256 ,
2007306 ,
2030492 ,
2053814 ,
2077273 ,
2100869 ,
2124600 ,
2148469 ,
2172474 ,
2196616 ,
2220894 ,
2245309 ,
2269861 ,
2294549 ,
2319375 ,
2344337 ,
2369436 ,
2394672 ,
2420045 ,
2445555 ,
2471202 ,
2496986 ,
2522908 ,
2548966 ,
2575161 ,
2601494 ,
2627964 ,
2654571 ,
2681316 ,
2708198 ,
2735217 ,
2762373 ,
2789667 ,
2817099 ,
2844668 ,
2872374 ,
2900219 ,
2928200 ,
2956320 ,
2984577 ,
3012971 ,
3041504 ,
3070174 ,
3098982 ,
3127928 ,
3157011 ,
3186233 ,
3215592 ,
3245090 ,
3274725 ,
3304498 ,
3334410 ,
3364459 ,
3394647 ,
3424973 ,
3455436 ,
3486038 ,
3516779 ,
3547657 ,
3578674 ,
3609829 ,
3641123 ,
3672554 ,
3704125 ,
3735833 ,
3767680 ,
3799666 ,
3831790 ,
3864052 ,
3896454 ,
3928993 ,
3961672 ,
3994489 ,
4027444 ,
4060539 ,
4093772 ,
4127144 ,
4160655 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^2.0)*4194304
*/
static int candela_coeff_2p0[] = {
0 ,
65 ,
258 ,
581 ,
1032 ,
1613 ,
2322 ,
3161 ,
4128 ,
5225 ,
6450 ,
7805 ,
9288 ,
10901 ,
12643 ,
14513 ,
16513 ,
18641 ,
20899 ,
23286 ,
25801 ,
28446 ,
31219 ,
34122 ,
37154 ,
40314 ,
43604 ,
47023 ,
50570 ,
54247 ,
58053 ,
61987 ,
66051 ,
70244 ,
74565 ,
79016 ,
83596 ,
88305 ,
93142 ,
98109 ,
103205 ,
108429 ,
113783 ,
119266 ,
124878 ,
130618 ,
136488 ,
142487 ,
148615 ,
154872 ,
161257 ,
167772 ,
174416 ,
181189 ,
188091 ,
195121 ,
202281 ,
209570 ,
216988 ,
224535 ,
232211 ,
240015 ,
247949 ,
256012 ,
264204 ,
272525 ,
280975 ,
289554 ,
298262 ,
307099 ,
316064 ,
325159 ,
334383 ,
343736 ,
353218 ,
362829 ,
372569 ,
382438 ,
392436 ,
402563 ,
412819 ,
423204 ,
433718 ,
444361 ,
455133 ,
466034 ,
477064 ,
488223 ,
499511 ,
510928 ,
522474 ,
534149 ,
545953 ,
557886 ,
569948 ,
582139 ,
594459 ,
606908 ,
619486 ,
632193 ,
645029 ,
657995 ,
671089 ,
684312 ,
697664 ,
711145 ,
724755 ,
738494 ,
752362 ,
766359 ,
780486 ,
794741 ,
809125 ,
823638 ,
838280 ,
853051 ,
867952 ,
882981 ,
898139 ,
913426 ,
928842 ,
944388 ,
960062 ,
975865 ,
991797 ,
1007859 ,
1024049 ,
1040368 ,
1056816 ,
1073394 ,
1090100 ,
1106935 ,
1123899 ,
1140993 ,
1158215 ,
1175566 ,
1193046 ,
1210656 ,
1228394 ,
1246261 ,
1264258 ,
1282383 ,
1300637 ,
1319021 ,
1337533 ,
1356174 ,
1374945 ,
1393844 ,
1412873 ,
1432030 ,
1451316 ,
1470732 ,
1490276 ,
1509949 ,
1529752 ,
1549683 ,
1569744 ,
1589933 ,
1610252 ,
1630699 ,
1651275 ,
1671981 ,
1692815 ,
1713779 ,
1734871 ,
1756093 ,
1777443 ,
1798923 ,
1820531 ,
1842269 ,
1864135 ,
1886131 ,
1908255 ,
1930509 ,
1952891 ,
1975403 ,
1998043 ,
2020813 ,
2043711 ,
2066739 ,
2089895 ,
2113181 ,
2136596 ,
2160139 ,
2183812 ,
2207613 ,
2231544 ,
2255603 ,
2279792 ,
2304110 ,
2328556 ,
2353132 ,
2377837 ,
2402670 ,
2427633 ,
2452724 ,
2477945 ,
2503295 ,
2528773 ,
2554381 ,
2580118 ,
2605983 ,
2631978 ,
2658102 ,
2684355 ,
2710736 ,
2737247 ,
2763887 ,
2790655 ,
2817553 ,
2844580 ,
2871736 ,
2899020 ,
2926434 ,
2953977 ,
2981649 ,
3009449 ,
3037379 ,
3065438 ,
3093626 ,
3121943 ,
3150388 ,
3178963 ,
3207667 ,
3236500 ,
3265462 ,
3294552 ,
3323772 ,
3353121 ,
3382599 ,
3412206 ,
3441942 ,
3471807 ,
3501800 ,
3531923 ,
3562175 ,
3592556 ,
3623066 ,
3653705 ,
3684473 ,
3715370 ,
3746396 ,
3777550 ,
3808834 ,
3840247 ,
3871789 ,
3903460 ,
3935260 ,
3967189 ,
3999247 ,
4031434 ,
4063750 ,
4096195 ,
4128769 ,
4161472 ,
4194304 ,

};

/*
*		index : 0 ~ 255
*		((index/255)^1.95)*4194304
*/
static int candela_coeff_1p95[] = {
0 ,
85 ,
329 ,
725 ,
1270 ,
1963 ,
2801 ,
3783 ,
4908 ,
6176 ,
7584 ,
9133 ,
10822 ,
12650 ,
14617 ,
16722 ,
18964 ,
21344 ,
23861 ,
26514 ,
29303 ,
32228 ,
35288 ,
38484 ,
41814 ,
45278 ,
48877 ,
52610 ,
56476 ,
60476 ,
64609 ,
68875 ,
73274 ,
77805 ,
82469 ,
87265 ,
92193 ,
97252 ,
102444 ,
107766 ,
113220 ,
118805 ,
124521 ,
130368 ,
136345 ,
142453 ,
148691 ,
155059 ,
161557 ,
168186 ,
174944 ,
181831 ,
188848 ,
195995 ,
203271 ,
210675 ,
218209 ,
225872 ,
233664 ,
241584 ,
249633 ,
257810 ,
266116 ,
274549 ,
283111 ,
291802 ,
300620 ,
309565 ,
318639 ,
327840 ,
337169 ,
346625 ,
356209 ,
365920 ,
375758 ,
385723 ,
395816 ,
406035 ,
416381 ,
426854 ,
437454 ,
448180 ,
459033 ,
470012 ,
481118 ,
492349 ,
503708 ,
515192 ,
526802 ,
538539 ,
550401 ,
562390 ,
574504 ,
586744 ,
599109 ,
611600 ,
624217 ,
636959 ,
649826 ,
662819 ,
675938 ,
689181 ,
702549 ,
716043 ,
729662 ,
743405 ,
757274 ,
771267 ,
785385 ,
799628 ,
813996 ,
828488 ,
843105 ,
857846 ,
872712 ,
887702 ,
902817 ,
918056 ,
933419 ,
948906 ,
964517 ,
980253 ,
996112 ,
1012096 ,
1028203 ,
1044434 ,
1060789 ,
1077268 ,
1093871 ,
1110597 ,
1127447 ,
1144420 ,
1161517 ,
1178738 ,
1196082 ,
1213549 ,
1231140 ,
1248854 ,
1266691 ,
1284652 ,
1302735 ,
1320942 ,
1339272 ,
1357725 ,
1376301 ,
1395000 ,
1413822 ,
1432766 ,
1451834 ,
1471024 ,
1490337 ,
1509773 ,
1529331 ,
1549012 ,
1568816 ,
1588742 ,
1608791 ,
1628962 ,
1649255 ,
1669671 ,
1690209 ,
1710870 ,
1731653 ,
1752558 ,
1773585 ,
1794735 ,
1816006 ,
1837400 ,
1858916 ,
1880553 ,
1902313 ,
1924194 ,
1946198 ,
1968323 ,
1990571 ,
2012940 ,
2035430 ,
2058043 ,
2080777 ,
2103633 ,
2126610 ,
2149709 ,
2172930 ,
2196272 ,
2219736 ,
2243321 ,
2267028 ,
2290855 ,
2314805 ,
2338875 ,
2363067 ,
2387380 ,
2411815 ,
2436370 ,
2461047 ,
2485845 ,
2510764 ,
2535804 ,
2560965 ,
2586247 ,
2611650 ,
2637174 ,
2662819 ,
2688585 ,
2714472 ,
2740480 ,
2766608 ,
2792857 ,
2819227 ,
2845718 ,
2872329 ,
2899061 ,
2925913 ,
2952887 ,
2979980 ,
3007195 ,
3034530 ,
3061985 ,
3089561 ,
3117257 ,
3145073 ,
3173010 ,
3201068 ,
3229245 ,
3257543 ,
3285961 ,
3314500 ,
3343159 ,
3371937 ,
3400836 ,
3429856 ,
3458995 ,
3488254 ,
3517634 ,
3547133 ,
3576752 ,
3606492 ,
3636351 ,
3666331 ,
3696430 ,
3726649 ,
3756988 ,
3787447 ,
3818025 ,
3848724 ,
3879542 ,
3910479 ,
3941537 ,
3972714 ,
4004011 ,
4035428 ,
4066964 ,
4098620 ,
4130395 ,
4162290 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.9)*4194304
*/
static int candela_coeff_1p9[] = {
0 ,
112 ,
419 ,
905 ,
1564 ,
2389 ,
3378 ,
4528 ,
5836 ,
7300 ,
8917 ,
10688 ,
12609 ,
14680 ,
16900 ,
19267 ,
21780 ,
24439 ,
27243 ,
30190 ,
33281 ,
36513 ,
39887 ,
43403 ,
47058 ,
50853 ,
54788 ,
58861 ,
63072 ,
67420 ,
71906 ,
76528 ,
81287 ,
86181 ,
91210 ,
96375 ,
101674 ,
107107 ,
112674 ,
118374 ,
124207 ,
130174 ,
136272 ,
142503 ,
148865 ,
155359 ,
161984 ,
168741 ,
175627 ,
182644 ,
189791 ,
197068 ,
204475 ,
212011 ,
219676 ,
227469 ,
235392 ,
243442 ,
251621 ,
259928 ,
268362 ,
276924 ,
285613 ,
294429 ,
303372 ,
312442 ,
321638 ,
330960 ,
340409 ,
349983 ,
359683 ,
369508 ,
379459 ,
389535 ,
399737 ,
410062 ,
420513 ,
431088 ,
441787 ,
452611 ,
463558 ,
474630 ,
485825 ,
497144 ,
508586 ,
520151 ,
531840 ,
543651 ,
555585 ,
567642 ,
579822 ,
592123 ,
604548 ,
617094 ,
629762 ,
642552 ,
655464 ,
668498 ,
681653 ,
694929 ,
708327 ,
721845 ,
735485 ,
749246 ,
763127 ,
777129 ,
791252 ,
805495 ,
819858 ,
834342 ,
848945 ,
863669 ,
878512 ,
893475 ,
908558 ,
923761 ,
939082 ,
954524 ,
970084 ,
985764 ,
1001562 ,
1017480 ,
1033516 ,
1049671 ,
1065945 ,
1082337 ,
1098848 ,
1115477 ,
1132224 ,
1149090 ,
1166074 ,
1183175 ,
1200395 ,
1217732 ,
1235187 ,
1252760 ,
1270450 ,
1288257 ,
1306182 ,
1324225 ,
1342384 ,
1360661 ,
1379054 ,
1397565 ,
1416193 ,
1434937 ,
1453798 ,
1472775 ,
1491869 ,
1511080 ,
1530407 ,
1549850 ,
1569410 ,
1589086 ,
1608877 ,
1628785 ,
1648809 ,
1668948 ,
1689204 ,
1709575 ,
1730061 ,
1750664 ,
1771381 ,
1792215 ,
1813163 ,
1834227 ,
1855406 ,
1876700 ,
1898109 ,
1919633 ,
1941273 ,
1963027 ,
1984895 ,
2006879 ,
2028977 ,
2051190 ,
2073517 ,
2095959 ,
2118515 ,
2141186 ,
2163970 ,
2186869 ,
2209883 ,
2233010 ,
2256251 ,
2279606 ,
2303075 ,
2326658 ,
2350355 ,
2374165 ,
2398090 ,
2422127 ,
2446278 ,
2470543 ,
2494921 ,
2519413 ,
2544018 ,
2568736 ,
2593567 ,
2618511 ,
2643568 ,
2668739 ,
2694022 ,
2719418 ,
2744928 ,
2770549 ,
2796284 ,
2822131 ,
2848091 ,
2874164 ,
2900349 ,
2926646 ,
2953056 ,
2979578 ,
3006213 ,
3032960 ,
3059819 ,
3086790 ,
3113873 ,
3141068 ,
3168376 ,
3195795 ,
3223326 ,
3250969 ,
3278724 ,
3306590 ,
3334568 ,
3362658 ,
3390859 ,
3419172 ,
3447597 ,
3476133 ,
3504780 ,
3533538 ,
3562408 ,
3591389 ,
3620482 ,
3649685 ,
3679000 ,
3708426 ,
3737962 ,
3767610 ,
3797369 ,
3827238 ,
3857218 ,
3887310 ,
3917511 ,
3947824 ,
3978247 ,
4008781 ,
4039425 ,
4070180 ,
4101046 ,
4132021 ,
4163107 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.85)*4194304
*/
static int candela_coeff_1p85[] = {
0 ,
148 ,
534 ,
1130 ,
1925 ,
2908 ,
4075 ,
5420 ,
6939 ,
8628 ,
10485 ,
12507 ,
14691 ,
17036 ,
19539 ,
22199 ,
25014 ,
27983 ,
31104 ,
34376 ,
37798 ,
41368 ,
45086 ,
48950 ,
52960 ,
57115 ,
61413 ,
65854 ,
70437 ,
75162 ,
80027 ,
85031 ,
90175 ,
95458 ,
100878 ,
106435 ,
112130 ,
117960 ,
123925 ,
130026 ,
136261 ,
142630 ,
149132 ,
155768 ,
162535 ,
169435 ,
176467 ,
183629 ,
190922 ,
198346 ,
205899 ,
213582 ,
221394 ,
229335 ,
237405 ,
245602 ,
253927 ,
262379 ,
270958 ,
279664 ,
288496 ,
297455 ,
306539 ,
315748 ,
325082 ,
334542 ,
344125 ,
353834 ,
363665 ,
373621 ,
383700 ,
393902 ,
404227 ,
414675 ,
425245 ,
435937 ,
446751 ,
457687 ,
468744 ,
479922 ,
491221 ,
502641 ,
514181 ,
525842 ,
537622 ,
549523 ,
561543 ,
573682 ,
585940 ,
598318 ,
610814 ,
623429 ,
636162 ,
649014 ,
661983 ,
675071 ,
688276 ,
701598 ,
715037 ,
728594 ,
742268 ,
756058 ,
769965 ,
783988 ,
798127 ,
812383 ,
826754 ,
841241 ,
855844 ,
870562 ,
885395 ,
900343 ,
915406 ,
930584 ,
945877 ,
961284 ,
976805 ,
992440 ,
1008190 ,
1024053 ,
1040030 ,
1056121 ,
1072325 ,
1088642 ,
1105072 ,
1121616 ,
1138272 ,
1155041 ,
1171923 ,
1188917 ,
1206024 ,
1223242 ,
1240573 ,
1258016 ,
1275570 ,
1293237 ,
1311015 ,
1328904 ,
1346905 ,
1365017 ,
1383240 ,
1401574 ,
1420019 ,
1438574 ,
1457240 ,
1476017 ,
1494904 ,
1513902 ,
1533009 ,
1552227 ,
1571554 ,
1590992 ,
1610539 ,
1630196 ,
1649962 ,
1669838 ,
1689822 ,
1709917 ,
1730120 ,
1750432 ,
1770853 ,
1791383 ,
1812022 ,
1832769 ,
1853624 ,
1874588 ,
1895660 ,
1916841 ,
1938129 ,
1959526 ,
1981030 ,
2002642 ,
2024362 ,
2046190 ,
2068125 ,
2090167 ,
2112317 ,
2134574 ,
2156938 ,
2179409 ,
2201987 ,
2224672 ,
2247463 ,
2270362 ,
2293367 ,
2316478 ,
2339696 ,
2363021 ,
2386451 ,
2409988 ,
2433631 ,
2457380 ,
2481235 ,
2505195 ,
2529262 ,
2553434 ,
2577711 ,
2602095 ,
2626583 ,
2651177 ,
2675876 ,
2700681 ,
2725590 ,
2750605 ,
2775725 ,
2800949 ,
2826278 ,
2851712 ,
2877251 ,
2902894 ,
2928642 ,
2954494 ,
2980451 ,
3006511 ,
3032676 ,
3058945 ,
3085319 ,
3111796 ,
3138377 ,
3165062 ,
3191850 ,
3218743 ,
3245739 ,
3272838 ,
3300042 ,
3327348 ,
3354758 ,
3382271 ,
3409887 ,
3437607 ,
3465429 ,
3493355 ,
3521384 ,
3549515 ,
3577749 ,
3606086 ,
3634526 ,
3663068 ,
3691713 ,
3720460 ,
3749310 ,
3778262 ,
3807317 ,
3836473 ,
3865732 ,
3895093 ,
3924556 ,
3954121 ,
3983788 ,
4013556 ,
4043427 ,
4073399 ,
4103473 ,
4133648 ,
4163925 ,
4194304 ,
};

/*
*		index : 0 ~ 255
*		((index/255)^1.8)*4194304
*/
static int candela_coeff_1p8[] = {
0 ,
195 ,
680 ,
1412 ,
2369 ,
3540 ,
4915 ,
6487 ,
8250 ,
10198 ,
12328 ,
14635 ,
17116 ,
19769 ,
22590 ,
25577 ,
28728 ,
32040 ,
35512 ,
39142 ,
42928 ,
46869 ,
50962 ,
55207 ,
59603 ,
64147 ,
68840 ,
73679 ,
78663 ,
83792 ,
89065 ,
94480 ,
100036 ,
105734 ,
111571 ,
117547 ,
123661 ,
129912 ,
136301 ,
142825 ,
149484 ,
156278 ,
163206 ,
170267 ,
177461 ,
184786 ,
192244 ,
199831 ,
207550 ,
215397 ,
223374 ,
231480 ,
239714 ,
248076 ,
256564 ,
265180 ,
273921 ,
282789 ,
291782 ,
300899 ,
310141 ,
319508 ,
328998 ,
338611 ,
348347 ,
358205 ,
368185 ,
378288 ,
388511 ,
398856 ,
409321 ,
419907 ,
430612 ,
441437 ,
452381 ,
463445 ,
474627 ,
485927 ,
497345 ,
508881 ,
520535 ,
532305 ,
544192 ,
556196 ,
568317 ,
580553 ,
592905 ,
605372 ,
617954 ,
630652 ,
643464 ,
656390 ,
669431 ,
682585 ,
695853 ,
709235 ,
722730 ,
736337 ,
750057 ,
763890 ,
777835 ,
791892 ,
806061 ,
820341 ,
834733 ,
849236 ,
863850 ,
878574 ,
893409 ,
908354 ,
923410 ,
938575 ,
953850 ,
969234 ,
984728 ,
1000331 ,
1016043 ,
1031863 ,
1047792 ,
1063830 ,
1079975 ,
1096229 ,
1112590 ,
1129059 ,
1145636 ,
1162320 ,
1179111 ,
1196009 ,
1213013 ,
1230124 ,
1247342 ,
1264666 ,
1282096 ,
1299632 ,
1317274 ,
1335022 ,
1352875 ,
1370833 ,
1388897 ,
1407065 ,
1425339 ,
1443717 ,
1462199 ,
1480787 ,
1499478 ,
1518273 ,
1537173 ,
1556176 ,
1575283 ,
1594494 ,
1613808 ,
1633225 ,
1652746 ,
1672369 ,
1692096 ,
1711925 ,
1731856 ,
1751890 ,
1772027 ,
1792266 ,
1812607 ,
1833049 ,
1853594 ,
1874240 ,
1894988 ,
1915838 ,
1936788 ,
1957840 ,
1978993 ,
2000247 ,
2021602 ,
2043057 ,
2064614 ,
2086270 ,
2108027 ,
2129885 ,
2151842 ,
2173899 ,
2196057 ,
2218314 ,
2240671 ,
2263127 ,
2285683 ,
2308339 ,
2331093 ,
2353947 ,
2376900 ,
2399952 ,
2423102 ,
2446351 ,
2469699 ,
2493146 ,
2516690 ,
2540334 ,
2564075 ,
2587914 ,
2611852 ,
2635887 ,
2660020 ,
2684251 ,
2708579 ,
2733005 ,
2757529 ,
2782149 ,
2806867 ,
2831682 ,
2856594 ,
2881603 ,
2906709 ,
2931912 ,
2957211 ,
2982607 ,
3008099 ,
3033688 ,
3059373 ,
3085154 ,
3111031 ,
3137004 ,
3163073 ,
3189238 ,
3215499 ,
3241856 ,
3268308 ,
3294855 ,
3321498 ,
3348236 ,
3375070 ,
3401999 ,
3429022 ,
3456141 ,
3483355 ,
3510663 ,
3538066 ,
3565564 ,
3593156 ,
3620843 ,
3648625 ,
3676500 ,
3704470 ,
3732534 ,
3760692 ,
3788945 ,
3817291 ,
3845731 ,
3874265 ,
3902892 ,
3931613 ,
3960428 ,
3989336 ,
4018337 ,
4047432 ,
4076620 ,
4105902 ,
4135276 ,
4164744 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.75)*4194304
*/
static int candela_coeff_1p75[] = {
0 ,
258 ,
867 ,
1763 ,
2916 ,
4309 ,
5929 ,
7765 ,
9809 ,
12054 ,
14495 ,
17126 ,
19943 ,
22941 ,
26118 ,
29470 ,
32993 ,
36686 ,
40545 ,
44569 ,
48755 ,
53100 ,
57604 ,
62264 ,
67079 ,
72046 ,
77165 ,
82433 ,
87850 ,
93414 ,
99124 ,
104978 ,
110975 ,
117115 ,
123396 ,
129818 ,
136378 ,
143076 ,
149912 ,
156884 ,
163991 ,
171233 ,
178608 ,
186116 ,
193757 ,
201529 ,
209431 ,
217463 ,
225625 ,
233915 ,
242333 ,
250878 ,
259550 ,
268347 ,
277271 ,
286318 ,
295491 ,
304786 ,
314205 ,
323747 ,
333411 ,
343196 ,
353102 ,
363129 ,
373276 ,
383542 ,
393928 ,
404432 ,
415055 ,
425795 ,
436653 ,
447627 ,
458719 ,
469926 ,
481249 ,
492688 ,
504241 ,
515909 ,
527692 ,
539588 ,
551597 ,
563720 ,
575955 ,
588303 ,
600763 ,
613335 ,
626018 ,
638812 ,
651717 ,
664733 ,
677858 ,
691094 ,
704439 ,
717893 ,
731456 ,
745128 ,
758908 ,
772796 ,
786793 ,
800896 ,
815107 ,
829425 ,
843849 ,
858380 ,
873017 ,
887761 ,
902609 ,
917564 ,
932623 ,
947787 ,
963057 ,
978430 ,
993908 ,
1009490 ,
1025175 ,
1040964 ,
1056857 ,
1072852 ,
1088950 ,
1105151 ,
1121455 ,
1137860 ,
1154368 ,
1170977 ,
1187688 ,
1204501 ,
1221414 ,
1238429 ,
1255544 ,
1272760 ,
1290076 ,
1307493 ,
1325009 ,
1342626 ,
1360342 ,
1378157 ,
1396072 ,
1414085 ,
1432198 ,
1450409 ,
1468719 ,
1487127 ,
1505633 ,
1524238 ,
1542940 ,
1561739 ,
1580637 ,
1599631 ,
1618723 ,
1637912 ,
1657198 ,
1676580 ,
1696059 ,
1715634 ,
1735305 ,
1755072 ,
1774936 ,
1794895 ,
1814949 ,
1835099 ,
1855344 ,
1875685 ,
1896120 ,
1916650 ,
1937275 ,
1957995 ,
1978808 ,
1999716 ,
2020719 ,
2041815 ,
2063005 ,
2084288 ,
2105665 ,
2127136 ,
2148700 ,
2170357 ,
2192107 ,
2213950 ,
2235886 ,
2257914 ,
2280035 ,
2302248 ,
2324553 ,
2346951 ,
2369440 ,
2392022 ,
2414695 ,
2437459 ,
2460316 ,
2483263 ,
2506302 ,
2529432 ,
2552653 ,
2575965 ,
2599367 ,
2622860 ,
2646444 ,
2670118 ,
2693883 ,
2717737 ,
2741682 ,
2765717 ,
2789841 ,
2814055 ,
2838359 ,
2862753 ,
2887236 ,
2911808 ,
2936469 ,
2961219 ,
2986059 ,
3010987 ,
3036004 ,
3061110 ,
3086304 ,
3111587 ,
3136958 ,
3162417 ,
3187964 ,
3213600 ,
3239323 ,
3265134 ,
3291033 ,
3317020 ,
3343094 ,
3369256 ,
3395505 ,
3421841 ,
3448265 ,
3474775 ,
3501372 ,
3528057 ,
3554828 ,
3581686 ,
3608630 ,
3635661 ,
3662778 ,
3689982 ,
3717271 ,
3744647 ,
3772109 ,
3799657 ,
3827291 ,
3855011 ,
3882816 ,
3910707 ,
3938683 ,
3966745 ,
3994892 ,
4023124 ,
4051442 ,
4079844 ,
4108332 ,
4136905 ,
4165562 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.7)*4194304
*/
static int candela_coeff_1p7[] = {
0 ,
340 ,
1105 ,
2201 ,
3590 ,
5246 ,
7152 ,
9294 ,
11663 ,
14248 ,
17043 ,
20041 ,
23235 ,
26622 ,
30197 ,
33954 ,
37892 ,
42005 ,
46292 ,
50748 ,
55372 ,
60161 ,
65112 ,
70223 ,
75492 ,
80917 ,
86496 ,
92227 ,
98109 ,
104140 ,
110318 ,
116642 ,
123111 ,
129722 ,
136476 ,
143370 ,
150403 ,
157574 ,
164882 ,
172326 ,
179905 ,
187618 ,
195463 ,
203441 ,
211549 ,
219787 ,
228155 ,
236651 ,
245274 ,
254024 ,
262900 ,
271901 ,
281027 ,
290276 ,
299648 ,
309142 ,
318758 ,
328495 ,
338352 ,
348329 ,
358425 ,
368640 ,
378972 ,
389422 ,
399989 ,
410671 ,
421470 ,
432383 ,
443411 ,
454554 ,
465809 ,
477178 ,
488660 ,
500254 ,
511959 ,
523776 ,
535704 ,
547742 ,
559890 ,
572147 ,
584514 ,
596989 ,
609572 ,
622264 ,
635062 ,
647968 ,
660981 ,
674100 ,
687325 ,
700656 ,
714092 ,
727632 ,
741278 ,
755027 ,
768881 ,
782838 ,
796898 ,
811061 ,
825327 ,
839695 ,
854165 ,
868736 ,
883409 ,
898183 ,
913058 ,
928033 ,
943108 ,
958284 ,
973558 ,
988932 ,
1004406 ,
1019978 ,
1035648 ,
1051417 ,
1067284 ,
1083248 ,
1099310 ,
1115469 ,
1131725 ,
1148078 ,
1164527 ,
1181073 ,
1197715 ,
1214452 ,
1231285 ,
1248213 ,
1265236 ,
1282354 ,
1299567 ,
1316874 ,
1334275 ,
1351770 ,
1369359 ,
1387041 ,
1404817 ,
1422686 ,
1440648 ,
1458702 ,
1476849 ,
1495088 ,
1513419 ,
1531842 ,
1550357 ,
1568964 ,
1587661 ,
1606450 ,
1625330 ,
1644300 ,
1663361 ,
1682512 ,
1701754 ,
1721085 ,
1740507 ,
1760018 ,
1779618 ,
1799308 ,
1819087 ,
1838955 ,
1858911 ,
1878956 ,
1899090 ,
1919312 ,
1939622 ,
1960020 ,
1980506 ,
2001079 ,
2021740 ,
2042488 ,
2063324 ,
2084246 ,
2105255 ,
2126351 ,
2147534 ,
2168802 ,
2190157 ,
2211598 ,
2233126 ,
2254738 ,
2276437 ,
2298221 ,
2320090 ,
2342045 ,
2364084 ,
2386209 ,
2408418 ,
2430712 ,
2453091 ,
2475554 ,
2498101 ,
2520732 ,
2543447 ,
2566246 ,
2589129 ,
2612095 ,
2635145 ,
2658278 ,
2681495 ,
2704794 ,
2728176 ,
2751641 ,
2775189 ,
2798820 ,
2822532 ,
2846327 ,
2870205 ,
2894164 ,
2918206 ,
2942329 ,
2966534 ,
2990820 ,
3015188 ,
3039637 ,
3064168 ,
3088780 ,
3113472 ,
3138246 ,
3163100 ,
3188035 ,
3213051 ,
3238147 ,
3263324 ,
3288580 ,
3313917 ,
3339334 ,
3364831 ,
3390407 ,
3416064 ,
3441799 ,
3467615 ,
3493509 ,
3519483 ,
3545537 ,
3571669 ,
3597880 ,
3624170 ,
3650539 ,
3676986 ,
3703512 ,
3730117 ,
3756800 ,
3783561 ,
3810400 ,
3837317 ,
3864313 ,
3891386 ,
3918537 ,
3945766 ,
3973072 ,
4000456 ,
4027917 ,
4055455 ,
4083071 ,
4110764 ,
4138534 ,
4166380 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.65)*4194304
*/
static int candela_coeff_1p65[] = {
0 ,
449 ,
1408 ,
2749 ,
4418 ,
6385 ,
8626 ,
11124 ,
13867 ,
16841 ,
20039 ,
23451 ,
27072 ,
30894 ,
34912 ,
39122 ,
43518 ,
48096 ,
52853 ,
57785 ,
62888 ,
68160 ,
73598 ,
79199 ,
84961 ,
90880 ,
96956 ,
103186 ,
109567 ,
116098 ,
122777 ,
129603 ,
136573 ,
143687 ,
150942 ,
158336 ,
165870 ,
173541 ,
181347 ,
189289 ,
197364 ,
205571 ,
213909 ,
222378 ,
230975 ,
239701 ,
248553 ,
257531 ,
266635 ,
275862 ,
285213 ,
294686 ,
304281 ,
313996 ,
323831 ,
333785 ,
343858 ,
354048 ,
364355 ,
374778 ,
385317 ,
395971 ,
406738 ,
417619 ,
428613 ,
439719 ,
450937 ,
462266 ,
473705 ,
485255 ,
496913 ,
508680 ,
520556 ,
532539 ,
544629 ,
556826 ,
569129 ,
581538 ,
594052 ,
606671 ,
619394 ,
632221 ,
645151 ,
658184 ,
671320 ,
684557 ,
697897 ,
711337 ,
724878 ,
738520 ,
752261 ,
766103 ,
780043 ,
794082 ,
808220 ,
822456 ,
836789 ,
851220 ,
865748 ,
880373 ,
895094 ,
909911 ,
924824 ,
939832 ,
954935 ,
970132 ,
985424 ,
1000810 ,
1016290 ,
1031864 ,
1047530 ,
1063289 ,
1079141 ,
1095086 ,
1111122 ,
1127249 ,
1143469 ,
1159779 ,
1176180 ,
1192672 ,
1209254 ,
1225927 ,
1242689 ,
1259540 ,
1276481 ,
1293511 ,
1310630 ,
1327837 ,
1345132 ,
1362516 ,
1379987 ,
1397546 ,
1415193 ,
1432926 ,
1450746 ,
1468653 ,
1486647 ,
1504726 ,
1522892 ,
1541143 ,
1559480 ,
1577902 ,
1596410 ,
1615002 ,
1633679 ,
1652440 ,
1671286 ,
1690216 ,
1709230 ,
1728327 ,
1747508 ,
1766772 ,
1786120 ,
1805550 ,
1825063 ,
1844658 ,
1864336 ,
1884096 ,
1903938 ,
1923862 ,
1943867 ,
1963954 ,
1984122 ,
2004371 ,
2024701 ,
2045112 ,
2065603 ,
2086175 ,
2106827 ,
2127559 ,
2148371 ,
2169263 ,
2190234 ,
2211285 ,
2232415 ,
2253624 ,
2274912 ,
2296278 ,
2317723 ,
2339247 ,
2360849 ,
2382529 ,
2404287 ,
2426124 ,
2448037 ,
2470028 ,
2492097 ,
2514243 ,
2536466 ,
2558766 ,
2581143 ,
2603596 ,
2626126 ,
2648733 ,
2671416 ,
2694174 ,
2717009 ,
2739920 ,
2762906 ,
2785968 ,
2809106 ,
2832319 ,
2855607 ,
2878970 ,
2902407 ,
2925920 ,
2949508 ,
2973170 ,
2996906 ,
3020717 ,
3044601 ,
3068560 ,
3092593 ,
3116700 ,
3140880 ,
3165134 ,
3189461 ,
3213862 ,
3238335 ,
3262882 ,
3287502 ,
3312195 ,
3336960 ,
3361798 ,
3386709 ,
3411692 ,
3436747 ,
3461874 ,
3487074 ,
3512345 ,
3537688 ,
3563103 ,
3588589 ,
3614148 ,
3639777 ,
3665478 ,
3691250 ,
3717093 ,
3743007 ,
3768991 ,
3795047 ,
3821173 ,
3847370 ,
3873637 ,
3899975 ,
3926383 ,
3952861 ,
3979409 ,
4006027 ,
4032715 ,
4059473 ,
4086300 ,
4113197 ,
4140163 ,
4167199 ,
4194304 ,
};
/*
*		index : 0 ~ 255
*		((index/255)^1.6)*4194304
*/
static int candela_coeff_1p6[] = {
0 ,
592 ,
1794 ,
3432 ,
5439 ,
7772 ,
10405 ,
13315 ,
16487 ,
19906 ,
23561 ,
27443 ,
31542 ,
35851 ,
40365 ,
45076 ,
49979 ,
55070 ,
60344 ,
65796 ,
71424 ,
77223 ,
83190 ,
89322 ,
95617 ,
102070 ,
108681 ,
115446 ,
122363 ,
129429 ,
136644 ,
144004 ,
151508 ,
159154 ,
166941 ,
174866 ,
182928 ,
191125 ,
199457 ,
207921 ,
216517 ,
225242 ,
234096 ,
243078 ,
252185 ,
261418 ,
270775 ,
280254 ,
289856 ,
299578 ,
309419 ,
319380 ,
329459 ,
339654 ,
349966 ,
360393 ,
370934 ,
381589 ,
392356 ,
403236 ,
414226 ,
425327 ,
436538 ,
447858 ,
459286 ,
470822 ,
482465 ,
494214 ,
506069 ,
518029 ,
530094 ,
542262 ,
554533 ,
566907 ,
579384 ,
591962 ,
604641 ,
617420 ,
630300 ,
643278 ,
656356 ,
669532 ,
682807 ,
696178 ,
709647 ,
723212 ,
736874 ,
750631 ,
764483 ,
778430 ,
792471 ,
806607 ,
820836 ,
835157 ,
849572 ,
864079 ,
878678 ,
893368 ,
908149 ,
923022 ,
937984 ,
953037 ,
968180 ,
983411 ,
998732 ,
1014141 ,
1029639 ,
1045225 ,
1060898 ,
1076659 ,
1092506 ,
1108440 ,
1124461 ,
1140568 ,
1156760 ,
1173038 ,
1189401 ,
1205849 ,
1222382 ,
1238998 ,
1255699 ,
1272484 ,
1289352 ,
1306303 ,
1323337 ,
1340453 ,
1357652 ,
1374933 ,
1392296 ,
1409740 ,
1427266 ,
1444873 ,
1462561 ,
1480329 ,
1498178 ,
1516106 ,
1534115 ,
1552203 ,
1570371 ,
1588617 ,
1606943 ,
1625347 ,
1643830 ,
1662391 ,
1681031 ,
1699748 ,
1718542 ,
1737414 ,
1756363 ,
1775389 ,
1794492 ,
1813672 ,
1832928 ,
1852260 ,
1871668 ,
1891152 ,
1910711 ,
1930346 ,
1950055 ,
1969840 ,
1989700 ,
2009634 ,
2029643 ,
2049726 ,
2069883 ,
2090114 ,
2110418 ,
2130796 ,
2151248 ,
2171773 ,
2192370 ,
2213041 ,
2233784 ,
2254599 ,
2275487 ,
2296447 ,
2317479 ,
2338583 ,
2359759 ,
2381006 ,
2402324 ,
2423714 ,
2445174 ,
2466706 ,
2488308 ,
2509981 ,
2531724 ,
2553537 ,
2575421 ,
2597374 ,
2619397 ,
2641490 ,
2663653 ,
2685884 ,
2708185 ,
2730555 ,
2752994 ,
2775502 ,
2798079 ,
2820724 ,
2843437 ,
2866219 ,
2889068 ,
2911986 ,
2934971 ,
2958025 ,
2981145 ,
3004334 ,
3027589 ,
3050912 ,
3074302 ,
3097758 ,
3121282 ,
3144872 ,
3168529 ,
3192252 ,
3216041 ,
3239897 ,
3263819 ,
3287806 ,
3311860 ,
3335979 ,
3360163 ,
3384413 ,
3408729 ,
3433109 ,
3457555 ,
3482066 ,
3506642 ,
3531282 ,
3555987 ,
3580756 ,
3605590 ,
3630489 ,
3655451 ,
3680478 ,
3705568 ,
3730723 ,
3755941 ,
3781223 ,
3806568 ,
3831977 ,
3857449 ,
3882984 ,
3908583 ,
3934245 ,
3959969 ,
3985756 ,
4011606 ,
4037519 ,
4063494 ,
4089532 ,
4115631 ,
4141794 ,
4168018 ,
4194304 ,
};

static int s6e63m0_candela_coeff[] = {
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
0 ,
1 ,
1 ,
1 ,
2 ,
2 ,
3 ,
4 ,
5 ,
6 ,
8 ,
11 ,
13 ,
16 ,
20 ,
24 ,
29 ,
35 ,
41 ,
49 ,
58 ,
67 ,
78 ,
89 ,
103 ,
118 ,
135 ,
153 ,
173 ,
199 ,
223 ,
238 ,
252 ,
272 ,
291 ,
308 ,
326 ,
340 ,
360 ,
382 ,
402 ,
419 ,
443 ,
467 ,
494 ,
516 ,
538 ,
568 ,
592 ,
615 ,
640 ,
670 ,
693 ,
718 ,
748 ,
780 ,
812 ,
836 ,
869 ,
901 ,
929 ,
961 ,
991 ,
1025 ,
1063 ,
1096 ,
1130 ,
1164 ,
1199 ,
1235 ,
1274 ,
1316 ,
1350 ,
1394 ,
1435 ,
1473 ,
1515 ,
1553 ,
1596 ,
1640 ,
1680 ,
1720 ,
1761 ,
1806 ,
1854 ,
1902 ,
1944 ,
1992 ,
2042 ,
2087 ,
2141 ,
2188 ,
2236 ,
2291 ,
2339 ,
2388 ,
2437 ,
2488 ,
2538 ,
2590 ,
2645 ,
2699 ,
2759 ,
2815 ,
2867 ,
2924 ,
2982 ,
3036 ,
3095 ,
3158 ,
3220 ,
3283 ,
3341 ,
3403 ,
3468 ,
3534 ,
3592 ,
3659 ,
3722 ,
3785 ,
3857 ,
3922 ,
3987 ,
4053 ,
4120 ,
4188 ,
4260 ,
4329 ,
4405 ,
4478 ,
4551 ,
4625 ,
4695 ,
4769 ,
4844 ,
4916 ,
4989 ,
5062 ,
5135 ,
5206 ,
5282 ,
5366 ,
5445 ,
5522 ,
5604 ,
5686 ,
5764 ,
5844 ,
5923 ,
6004 ,
6085 ,
6167 ,
6249 ,
6332 ,
6419 ,
6505 ,
6593 ,
6680 ,
6764 ,
6854 ,
6943 ,
7030 ,
7113 ,
7196 ,
7284 ,
7379 ,
7472 ,
7566 ,
7660 ,
7752 ,
7847 ,
7943 ,
8036 ,
8130 ,
8224 ,
8319 ,
8416 ,
8514 ,
8618 ,
8719 ,
8815 ,
8916 ,
9019 ,
9117 ,
9216 ,
9316 ,
9421 ,
9530 ,
9637 ,
9742 ,
9853 ,
9962 ,
10066 ,
10173 ,
10284 ,
10391 ,
10500 ,
10610 ,
10721 ,
10831 ,
10937 ,
11050 ,
11161 ,
11268 ,
11375 ,
11495 ,
11610 ,
11724 ,
11840 ,
11956 ,
12073 ,
12183 ,
12300 ,
12420 ,
12540 ,
12665 ,
12786 ,
12907 ,
13028 ,
13149 ,
13271 ,
13394 ,
13521 ,
13644 ,
13770 ,
13894 ,
14021 ,
14147 ,
14271 ,
14395 ,
14527 ,
14661 ,
14795 ,
14930 ,
15066 ,
15199 ,
15331 ,
15465 ,
15596 ,
15727 ,
15859 ,
15991 ,
16124 ,
16258 ,
16384 ,
};

static int s6e63m0_curve_2p2[] = {
0 ,
1 ,
3 ,
7 ,
12 ,
20 ,
30 ,
43 ,
57 ,
74 ,
94 ,
116 ,
181 ,
261 ,
357 ,
470 ,
638 ,
873 ,
1149 ,
1505 ,
1948 ,
2462 ,
3187 ,
4014 ,
4947 ,
5998 ,
7322 ,
8790 ,
10406 ,
12406 ,
14785 ,
17393 ,
20233 ,
23309 ,
26624 ,
30843 ,
35530 ,
40580 ,
45998 ,
51943 ,
59567 ,
66992 ,
71281 ,
75715 ,
81627 ,
87360 ,
92307 ,
97789 ,
101994 ,
107916 ,
114544 ,
120609 ,
125563 ,
132753 ,
139989 ,
148171 ,
154830 ,
161459 ,
170491 ,
177474 ,
184610 ,
191900 ,
200851 ,
208025 ,
215268 ,
224525 ,
233995 ,
243502 ,
250903 ,
260832 ,
270407 ,
278624 ,
288448 ,
297172 ,
307582 ,
318888 ,
328847 ,
338973 ,
349266 ,
359728 ,
370358 ,
382346 ,
394839 ,
405107 ,
418139 ,
430542 ,
442024 ,
454514 ,
466020 ,
478816 ,
491918 ,
503929 ,
516097 ,
528425 ,
541772 ,
556091 ,
570614 ,
583274 ,
597584 ,
612685 ,
626209 ,
642334 ,
656324 ,
670784 ,
687212 ,
701724 ,
716402 ,
731246 ,
746256 ,
761433 ,
776925 ,
793649 ,
809625 ,
827588 ,
844406 ,
860145 ,
877239 ,
894489 ,
910729 ,
928472 ,
947330 ,
966066 ,
985002 ,
1002167 ,
1020903 ,
1040415 ,
1060129 ,
1077595 ,
1097643 ,
1116505 ,
1135562 ,
1157162 ,
1176573 ,
1196160 ,
1215924 ,
1235865 ,
1256295 ,
1278087 ,
1298760 ,
1321576 ,
1343524 ,
1365222 ,
1387352 ,
1408362 ,
1430792 ,
1453323 ,
1474871 ,
1496592 ,
1518486 ,
1540554 ,
1561718 ,
1584466 ,
1609667 ,
1633642 ,
1656693 ,
1681320 ,
1705704 ,
1729303 ,
1753078 ,
1777031 ,
1801161 ,
1825469 ,
1849954 ,
1874618 ,
1899643 ,
1925558 ,
1951427 ,
1977817 ,
2003972 ,
2029340 ,
2056321 ,
2083012 ,
2108920 ,
2133761 ,
2158798 ,
2185215 ,
2213663 ,
2241712 ,
2269787 ,
2298149 ,
2325479 ,
2354122 ,
2383050 ,
2410925 ,
2438977 ,
2467207 ,
2495613 ,
2524928 ,
2554282 ,
2585355 ,
2615560 ,
2644608 ,
2674730 ,
2705583 ,
2735171 ,
2764934 ,
2794872 ,
2826365 ,
2859063 ,
2891124 ,
2922619 ,
2955919 ,
2988470 ,
3019761 ,
3052021 ,
3085226 ,
3117156 ,
3150042 ,
3183115 ,
3216377 ,
3249187 ,
3281038 ,
3314853 ,
3348429 ,
3380335 ,
3412468 ,
3448603 ,
3482883 ,
3517348 ,
3551998 ,
3586833 ,
3621854 ,
3654959 ,
3690035 ,
3725943 ,
3761880 ,
3799549 ,
3835852 ,
3871969 ,
3908271 ,
3944757 ,
3981429 ,
4018286 ,
4056410 ,
4093256 ,
4130995 ,
4168337 ,
4206323 ,
4244164 ,
4281201 ,
4318413 ,
4358189 ,
4398275 ,
4438561 ,
4479048 ,
4519735 ,
4559566 ,
4599306 ,
4639620 ,
4678786 ,
4718131 ,
4757656 ,
4797361 ,
4837246 ,
4877311 ,
4915200 ,
};
/*
*		index : 0 ~ 255
*		300 is max CANDELA
*		(300*((index/255)^2.2))*4194304
*/

static int curve_2p2[] = {
0 ,
6388 ,
29353 ,
71624 ,
134873 ,
220357 ,
329098 ,
461964 ,
619713 ,
803020 ,
1012495 ,
1248696 ,
1512138 ,
1803301 ,
2122631 ,
2470549 ,
2847454 ,
3253722 ,
3689710 ,
4155762 ,
4652204 ,
5179349 ,
5737499 ,
6326944 ,
6947963 ,
7600826 ,
8285794 ,
9003120 ,
9753050 ,
10535820 ,
11351664 ,
12200805 ,
13083463 ,
13999852 ,
14950179 ,
15934647 ,
16953457 ,
18006801 ,
19094869 ,
20217847 ,
21375916 ,
22569256 ,
23798041 ,
25062441 ,
26362625 ,
27698758 ,
29071001 ,
30479515 ,
31924454 ,
33405974 ,
34924225 ,
36479355 ,
38071511 ,
39700838 ,
41367477 ,
43071568 ,
44813248 ,
46592654 ,
48409918 ,
50265174 ,
52158550 ,
54090177 ,
56060179 ,
58068682 ,
60115810 ,
62201685 ,
64326426 ,
66490152 ,
68692982 ,
70935031 ,
73216413 ,
75537243 ,
77897632 ,
80297691 ,
82737529 ,
85217255 ,
87736977 ,
90296800 ,
92896829 ,
95537168 ,
98217920 ,
100939187 ,
103701070 ,
106503668 ,
109347080 ,
112231405 ,
115156738 ,
118123177 ,
121130816 ,
124179749 ,
127270070 ,
130401872 ,
133575246 ,
136790283 ,
140047074 ,
143345708 ,
146686273 ,
150068858 ,
153493549 ,
156960434 ,
160469597 ,
164021124 ,
167615100 ,
171251607 ,
174930730 ,
178652550 ,
182417150 ,
186224610 ,
190075011 ,
193968433 ,
197904956 ,
201884658 ,
205907617 ,
209973911 ,
214083618 ,
218236813 ,
222433573 ,
226673974 ,
230958090 ,
235285995 ,
239657764 ,
244073471 ,
248533188 ,
253036987 ,
257584941 ,
262177122 ,
266813599 ,
271494445 ,
276219729 ,
280989522 ,
285803891 ,
290662907 ,
295566638 ,
300515151 ,
305508515 ,
310546796 ,
315630062 ,
320758379 ,
325931813 ,
331150430 ,
336414294 ,
341723472 ,
347078027 ,
352478024 ,
357923526 ,
363414597 ,
368951300 ,
374533698 ,
380161853 ,
385835828 ,
391555684 ,
397321482 ,
403133283 ,
408991150 ,
414895141 ,
420845316 ,
426841737 ,
432884462 ,
438973551 ,
445109062 ,
451291054 ,
457519585 ,
463794714 ,
470116498 ,
476484994 ,
482900260 ,
489362353 ,
495871330 ,
502427245 ,
509030157 ,
515680120 ,
522377190 ,
529121423 ,
535912873 ,
542751595 ,
549637644 ,
556571074 ,
563551939 ,
570580293 ,
577656189 ,
584779680 ,
591950821 ,
599169663 ,
606436259 ,
613750661 ,
621112922 ,
628523094 ,
635981228 ,
643487375 ,
651041588 ,
658643916 ,
666294411 ,
673993123 ,
681740103 ,
689535401 ,
697379067 ,
705271151 ,
713211701 ,
721200769 ,
729238402 ,
737324649 ,
745459560 ,
753643183 ,
761875566 ,
770156758 ,
778486806 ,
786865759 ,
795293664 ,
803770568 ,
812296518 ,
820871563 ,
829495748 ,
838169120 ,
846891726 ,
855663612 ,
864484825 ,
873355410 ,
882275413 ,
891244881 ,
900263857 ,
909332389 ,
918450520 ,
927618297 ,
936835763 ,
946102963 ,
955419943 ,
964786746 ,
974203416 ,
983669998 ,
993186536 ,
1002753073 ,
1012369653 ,
1022036319 ,
1031753115 ,
1041520083 ,
1051337267 ,
1061204710 ,
1071122454 ,
1081090542 ,
1091109016 ,
1101177919 ,
1111297292 ,
1121467178 ,
1131687618 ,
1141958655 ,
1152280329 ,
1162652683 ,
1173075757 ,
1183549592 ,
1194074231 ,
1204649713 ,
1215276079 ,
1225953371 ,
1236681628 ,
1247460891 ,
1258291200 ,
};

/*
*		index : 0 ~ 255
*		300 is max CANDELA
*		(300*((index/255)^1.9))*4194304
*/

static int curve_1p9[] = {
0 ,
33679 ,
125693 ,
271572 ,
469104 ,
716800 ,
1013543 ,
1358442 ,
1750757 ,
2189856 ,
2675191 ,
3206276 ,
3782676 ,
4403999 ,
5069885 ,
5780005 ,
6534055 ,
7331752 ,
8172832 ,
9057048 ,
9984166 ,
10953968 ,
11966246 ,
13020801 ,
14117447 ,
15256005 ,
16436304 ,
17658181 ,
18921479 ,
20226047 ,
21571741 ,
22958422 ,
24385955 ,
25854212 ,
27363066 ,
28912397 ,
30502088 ,
32132025 ,
33802097 ,
35512199 ,
37262226 ,
39052078 ,
40881655 ,
42750863 ,
44659607 ,
46607799 ,
48595348 ,
50622169 ,
52688176 ,
54793289 ,
56937425 ,
59120507 ,
61342457 ,
63603200 ,
65902662 ,
68240771 ,
70617456 ,
73032647 ,
75486277 ,
77978278 ,
80508585 ,
83077133 ,
85683861 ,
88328704 ,
91011604 ,
93732499 ,
96491330 ,
99288041 ,
102122574 ,
104994872 ,
107904882 ,
110852548 ,
113837817 ,
116860637 ,
119920957 ,
123018724 ,
126153889 ,
129326402 ,
132536214 ,
135783278 ,
139067546 ,
142388971 ,
145747507 ,
149143109 ,
152575731 ,
156045330 ,
159551861 ,
163095281 ,
166675549 ,
170292621 ,
173946456 ,
177637013 ,
181364252 ,
185128132 ,
188928614 ,
192765659 ,
196639227 ,
200549282 ,
204495785 ,
208478698 ,
212497985 ,
216553609 ,
220645535 ,
224773725 ,
228938146 ,
233138761 ,
237375537 ,
241648439 ,
245957433 ,
250302486 ,
254683564 ,
259100634 ,
263553665 ,
268042623 ,
272567477 ,
277128195 ,
281724746 ,
286357099 ,
291025223 ,
295729087 ,
300468663 ,
305243919 ,
310054825 ,
314901354 ,
319783476 ,
324701161 ,
329654381 ,
334643109 ,
339667315 ,
344726973 ,
349822054 ,
354952532 ,
360118378 ,
365319567 ,
370556071 ,
375827865 ,
381134921 ,
386477214 ,
391854718 ,
397267408 ,
402715258 ,
408198243 ,
413716337 ,
419269517 ,
424857757 ,
430481033 ,
436139320 ,
441832596 ,
447560835 ,
453324015 ,
459122111 ,
464955101 ,
470822960 ,
476725667 ,
482663198 ,
488635531 ,
494642642 ,
500684511 ,
506761113 ,
512872429 ,
519018435 ,
525199109 ,
531414431 ,
537664379 ,
543948931 ,
550268067 ,
556621765 ,
563010004 ,
569432764 ,
575890024 ,
582381763 ,
588907962 ,
595468600 ,
602063657 ,
608693113 ,
615356949 ,
622055143 ,
628787678 ,
635554533 ,
642355690 ,
649191128 ,
656060830 ,
662964775 ,
669902945 ,
676875321 ,
683881886 ,
690922619 ,
697997503 ,
705106519 ,
712249650 ,
719426877 ,
726638181 ,
733883547 ,
741162954 ,
748476386 ,
755823826 ,
763205255 ,
770620657 ,
778070013 ,
785553308 ,
793070523 ,
800621642 ,
808206648 ,
815825524 ,
823478253 ,
831164819 ,
838885205 ,
846639395 ,
854427372 ,
862249121 ,
870104624 ,
877993866 ,
885916830 ,
893873502 ,
901863864 ,
909887901 ,
917945598 ,
926036939 ,
934161908 ,
942320490 ,
950512670 ,
958738431 ,
966997760 ,
975290640 ,
983617057 ,
991976996 ,
1000370441 ,
1008797379 ,
1017257794 ,
1025751671 ,
1034278995 ,
1042839753 ,
1051433930 ,
1060061511 ,
1068722482 ,
1077416829 ,
1086144537 ,
1094905592 ,
1103699981 ,
1112527688 ,
1121388701 ,
1130283005 ,
1139210586 ,
1148171431 ,
1157165525 ,
1166192856 ,
1175253410 ,
1184347173 ,
1193474131 ,
1202634272 ,
1211827582 ,
1221054047 ,
1230313654 ,
1239606391 ,
1248932244 ,
1258291200 ,
};

/*
*		index : 0 ~ 255
*		((index/255)^2.2)*4194304
*/
static int candela_coeff_2p2[] = {
0 ,
21 ,
98 ,
239 ,
450 ,
735 ,
1097 ,
1540 ,
2066 ,
2677 ,
3375 ,
4162 ,
5040 ,
6011 ,
7075 ,
8235 ,
9492 ,
10846 ,
12299 ,
13853 ,
15507 ,
17264 ,
19125 ,
21090 ,
23160 ,
25336 ,
27619 ,
30010 ,
32510 ,
35119 ,
37839 ,
40669 ,
43612 ,
46666 ,
49834 ,
53115 ,
56512 ,
60023 ,
63650 ,
67393 ,
71253 ,
75231 ,
79327 ,
83541 ,
87875 ,
92329 ,
96903 ,
101598 ,
106415 ,
111353 ,
116414 ,
121598 ,
126905 ,
132336 ,
137892 ,
143572 ,
149377 ,
155309 ,
161366 ,
167551 ,
173862 ,
180301 ,
186867 ,
193562 ,
200386 ,
207339 ,
214421 ,
221634 ,
228977 ,
236450 ,
244055 ,
251791 ,
259659 ,
267659 ,
275792 ,
284058 ,
292457 ,
300989 ,
309656 ,
318457 ,
327393 ,
336464 ,
345670 ,
355012 ,
364490 ,
374105 ,
383856 ,
393744 ,
403769 ,
413932 ,
424234 ,
434673 ,
445251 ,
455968 ,
466824 ,
477819 ,
488954 ,
500230 ,
511645 ,
523201 ,
534899 ,
546737 ,
558717 ,
570839 ,
583102 ,
595509 ,
608057 ,
620749 ,
633583 ,
646561 ,
659683 ,
672949 ,
686359 ,
699913 ,
713612 ,
727456 ,
741445 ,
755580 ,
769860 ,
784287 ,
798859 ,
813578 ,
828444 ,
843457 ,
858616 ,
873924 ,
889379 ,
904981 ,
920732 ,
936632 ,
952680 ,
968876 ,
985222 ,
1001717 ,
1018362 ,
1035156 ,
1052100 ,
1069195 ,
1086439 ,
1103835 ,
1121381 ,
1139078 ,
1156927 ,
1174927 ,
1193078 ,
1211382 ,
1229838 ,
1248446 ,
1267206 ,
1286119 ,
1305186 ,
1324405 ,
1343778 ,
1363304 ,
1382984 ,
1402818 ,
1422806 ,
1442948 ,
1463245 ,
1483697 ,
1504304 ,
1525065 ,
1545982 ,
1567055 ,
1588283 ,
1609668 ,
1631208 ,
1652904 ,
1674757 ,
1696767 ,
1718934 ,
1741257 ,
1763738 ,
1786376 ,
1809172 ,
1832125 ,
1855237 ,
1878506 ,
1901934 ,
1925521 ,
1949266 ,
1973169 ,
1997232 ,
2021454 ,
2045836 ,
2070376 ,
2095077 ,
2119937 ,
2144958 ,
2170139 ,
2195480 ,
2220981 ,
2246644 ,
2272467 ,
2298451 ,
2324597 ,
2350904 ,
2377372 ,
2404003 ,
2430795 ,
2457749 ,
2484865 ,
2512144 ,
2539585 ,
2567189 ,
2594956 ,
2622886 ,
2650979 ,
2679235 ,
2707655 ,
2736239 ,
2764986 ,
2793897 ,
2822972 ,
2852212 ,
2881616 ,
2911185 ,
2940918 ,
2970816 ,
3000880 ,
3031108 ,
3061502 ,
3092061 ,
3122786 ,
3153677 ,
3184733 ,
3215956 ,
3247345 ,
3278900 ,
3310622 ,
3342510 ,
3374566 ,
3406788 ,
3439177 ,
3471734 ,
3504458 ,
3537349 ,
3570408 ,
3603635 ,
3637030 ,
3670593 ,
3704324 ,
3738224 ,
3772292 ,
3806529 ,
3840934 ,
3875509 ,
3910253 ,
3945165 ,
3980247 ,
4015499 ,
4050920 ,
4086511 ,
4122272 ,
4158203 ,
4194304 ,

};

/*
*		index : 0 ~ 255
*		((index/255)^2.15)*4194304
*/
static int candela_coeff_2p15[] = {
0 ,
28 ,
125 ,
298 ,
553 ,
894 ,
1323 ,
1843 ,
2456 ,
3164 ,
3968 ,
4871 ,
5873 ,
6976 ,
8180 ,
9488 ,
10901 ,
12418 ,
14042 ,
15773 ,
17612 ,
19560 ,
21618 ,
23786 ,
26065 ,
28456 ,
30959 ,
33576 ,
36307 ,
39152 ,
42112 ,
45188 ,
48381 ,
51690 ,
55116 ,
58660 ,
62323 ,
66105 ,
70006 ,
74027 ,
78168 ,
82430 ,
86813 ,
91318 ,
95945 ,
100694 ,
105567 ,
110563 ,
115682 ,
120926 ,
126294 ,
131788 ,
137406 ,
143150 ,
149020 ,
155017 ,
161140 ,
167390 ,
173768 ,
180273 ,
186906 ,
193668 ,
200558 ,
207578 ,
214726 ,
222005 ,
229413 ,
236951 ,
244620 ,
252420 ,
260351 ,
268413 ,
276607 ,
284933 ,
293391 ,
301981 ,
310705 ,
319561 ,
328550 ,
337673 ,
346930 ,
356321 ,
365846 ,
375506 ,
385300 ,
395229 ,
405294 ,
415494 ,
425830 ,
436302 ,
446910 ,
457654 ,
468535 ,
479553 ,
490708 ,
502001 ,
513431 ,
524998 ,
536704 ,
548547 ,
560530 ,
572650 ,
584910 ,
597308 ,
609846 ,
622523 ,
635340 ,
648296 ,
661393 ,
674630 ,
688007 ,
701525 ,
715183 ,
728983 ,
742923 ,
757005 ,
771229 ,
785594 ,
800101 ,
814750 ,
829542 ,
844476 ,
859552 ,
874771 ,
890133 ,
905639 ,
921288 ,
937080 ,
953015 ,
969095 ,
985319 ,
1001686 ,
1018199 ,
1034855 ,
1051656 ,
1068602 ,
1085693 ,
1102929 ,
1120311 ,
1137838 ,
1155510 ,
1173328 ,
1191293 ,
1209403 ,
1227659 ,
1246062 ,
1264612 ,
1283308 ,
1302151 ,
1321140 ,
1340277 ,
1359562 ,
1378994 ,
1398573 ,
1418300 ,
1438175 ,
1458198 ,
1478369 ,
1498688 ,
1519156 ,
1539772 ,
1560537 ,
1581451 ,
1602514 ,
1623726 ,
1645087 ,
1666598 ,
1688258 ,
1710068 ,
1732028 ,
1754138 ,
1776398 ,
1798807 ,
1821368 ,
1844078 ,
1866940 ,
1889952 ,
1913115 ,
1936429 ,
1959894 ,
1983510 ,
2007278 ,
2031197 ,
2055268 ,
2079490 ,
2103864 ,
2128391 ,
2153069 ,
2177900 ,
2202883 ,
2228018 ,
2253306 ,
2278747 ,
2304341 ,
2330088 ,
2355987 ,
2382040 ,
2408246 ,
2434606 ,
2461119 ,
2487786 ,
2514607 ,
2541581 ,
2568710 ,
2595992 ,
2623429 ,
2651020 ,
2678766 ,
2706666 ,
2734721 ,
2762931 ,
2791295 ,
2819815 ,
2848490 ,
2877320 ,
2906305 ,
2935446 ,
2964742 ,
2994194 ,
3023802 ,
3053566 ,
3083485 ,
3113561 ,
3143793 ,
3174181 ,
3204726 ,
3235427 ,
3266285 ,
3297300 ,
3328471 ,
3359800 ,
3391285 ,
3422927 ,
3454727 ,
3486684 ,
3518799 ,
3551071 ,
3583500 ,
3616088 ,
3648833 ,
3681736 ,
3714798 ,
3748017 ,
3781395 ,
3814931 ,
3848625 ,
3882478 ,
3916489 ,
3950660 ,
3984989 ,
4019477 ,
4054124 ,
4088930 ,
4123895 ,
4159020 ,
4194304 ,

};

/*
*		index : 0 ~ 255
*		350 is max CANDELA
*		(350*((index/255)^1.9))*4194304
*/

static int curve_1p9_350[] = {
0 ,
39292 ,
146642 ,
316834 ,
547288 ,
836266 ,
1182467 ,
1584849 ,
2042549 ,
2554832 ,
3121056 ,
3740655 ,
4413122 ,
5137999 ,
5914866 ,
6743339 ,
7623064 ,
8553711 ,
9534971 ,
10566556 ,
11648194 ,
12779630 ,
13960620 ,
15190935 ,
16470355 ,
17798673 ,
19175689 ,
20601211 ,
22075059 ,
23597055 ,
25167031 ,
26784826 ,
28450281 ,
30163247 ,
31923577 ,
33731130 ,
35585769 ,
37487362 ,
39435780 ,
41430899 ,
43472597 ,
45560757 ,
47695264 ,
49876006 ,
52102875 ,
54375765 ,
56694573 ,
59059197 ,
61469539 ,
63925504 ,
66426996 ,
68973925 ,
71566200 ,
74203734 ,
76886439 ,
79614233 ,
82387032 ,
85204755 ,
88067323 ,
90974657 ,
93926682 ,
96923322 ,
99964504 ,
103050155 ,
106180204 ,
109354582 ,
112573219 ,
115836048 ,
119143002 ,
122494017 ,
125889029 ,
129327972 ,
132810787 ,
136337410 ,
139907783 ,
143521844 ,
147179537 ,
150880802 ,
154625583 ,
158413825 ,
162245471 ,
166120466 ,
170038759 ,
174000294 ,
178005020 ,
182052885 ,
186143838 ,
190277828 ,
194454807 ,
198674724 ,
202937532 ,
207243182 ,
211591627 ,
215982821 ,
220416716 ,
224893268 ,
229412432 ,
233974162 ,
238578416 ,
243225148 ,
247914316 ,
252645878 ,
257419790 ,
262236013 ,
267094503 ,
271995222 ,
276938127 ,
281923179 ,
286950339 ,
292019567 ,
297130824 ,
302284073 ,
307479276 ,
312716393 ,
317995390 ,
323316228 ,
328678870 ,
334083282 ,
339529427 ,
345017269 ,
350546773 ,
356117905 ,
361730630 ,
367384913 ,
373080721 ,
378818021 ,
384596778 ,
390416960 ,
396278535 ,
402181469 ,
408125730 ,
414111287 ,
420138108 ,
426206162 ,
432315417 ,
438465842 ,
444657408 ,
450890083 ,
457163838 ,
463478643 ,
469834468 ,
476231283 ,
482669060 ,
489147769 ,
495667383 ,
502227871 ,
508829207 ,
515471362 ,
522154308 ,
528878017 ,
535642463 ,
542447617 ,
549293454 ,
556179945 ,
563107064 ,
570074786 ,
577083083 ,
584131929 ,
591221299 ,
598351167 ,
605521507 ,
612732294 ,
619983503 ,
627275109 ,
634607086 ,
641979411 ,
649392059 ,
656845004 ,
664338224 ,
671871694 ,
679445391 ,
687059289 ,
694713367 ,
702407600 ,
710141966 ,
717916440 ,
725731001 ,
733585625 ,
741480289 ,
749414971 ,
757389650 ,
765404301 ,
773458904 ,
781553436 ,
789687875 ,
797862200 ,
806076389 ,
814330420 ,
822624273 ,
830957925 ,
839331356 ,
847744545 ,
856197471 ,
864690113 ,
873222451 ,
881794464 ,
890406131 ,
899057433 ,
907748349 ,
916478859 ,
925248944 ,
934058582 ,
942907756 ,
951796445 ,
960724629 ,
969692289 ,
978699406 ,
987745961 ,
996831934 ,
1005957307 ,
1015122061 ,
1024326177 ,
1033569635 ,
1042852419 ,
1052174508 ,
1061535885 ,
1070936531 ,
1080376429 ,
1089855560 ,
1099373905 ,
1108931448 ,
1118528170 ,
1128164053 ,
1137839080 ,
1147553233 ,
1157306495 ,
1167098848 ,
1176930275 ,
1186800759 ,
1196710282 ,
1206658828 ,
1216646379 ,
1226672919 ,
1236738430 ,
1246842896 ,
1256986300 ,
1267168626 ,
1277389858 ,
1287649977 ,
1297948969 ,
1308286817 ,
1318663505 ,
1329079017 ,
1339533336 ,
1350026446 ,
1360558332 ,
1371128978 ,
1381738368 ,
1392386487 ,
1403073317 ,
1413798845 ,
1424563055 ,
1435365930 ,
1446207456 ,
1457087618 ,
1468006400 ,
};

/*
*		index : 0 ~ 255
*		350 is max CANDELA
*		(350*((index/255)^2.15))*4194304
*/

static int curve_2p15_350[] = {
0 ,
9833 ,
43640 ,
104346 ,
193685 ,
312934 ,
463118 ,
645100 ,
859627 ,
1107358 ,
1388886 ,
1704751 ,
2055447 ,
2441433 ,
2863135 ,
3320953 ,
3815263 ,
4346421 ,
4914761 ,
5520607 ,
6164261 ,
6846018 ,
7566157 ,
8324946 ,
9122644 ,
9959501 ,
10835757 ,
11751645 ,
12707389 ,
13703208 ,
14739314 ,
15815911 ,
16933199 ,
18091373 ,
19290622 ,
20531130 ,
21813077 ,
23136639 ,
24501986 ,
25909287 ,
27358705 ,
28850401 ,
30384531 ,
31961249 ,
33580705 ,
35243048 ,
36948422 ,
38696970 ,
40488829 ,
42324139 ,
44203033 ,
46125644 ,
48092101 ,
50102533 ,
52157065 ,
54255821 ,
56398924 ,
58586493 ,
60818646 ,
63095500 ,
65417170 ,
67783768 ,
70195407 ,
72652195 ,
75154243 ,
77701657 ,
80294541 ,
82933002 ,
85617141 ,
88347061 ,
91122861 ,
93944641 ,
96812498 ,
99726531 ,
102686833 ,
105693499 ,
108746624 ,
111846300 ,
114992617 ,
118185666 ,
121425537 ,
124712318 ,
128046097 ,
131426959 ,
134854992 ,
138330279 ,
141852904 ,
145422951 ,
149040503 ,
152705639 ,
156418442 ,
160178991 ,
163987366 ,
167843644 ,
171747904 ,
175700223 ,
179700677 ,
183749341 ,
187846291 ,
191991601 ,
196185344 ,
200427595 ,
204718424 ,
209057905 ,
213446108 ,
217883104 ,
222368963 ,
226903755 ,
231487548 ,
236120412 ,
240802413 ,
245533619 ,
250314098 ,
255143915 ,
260023136 ,
264951827 ,
269930052 ,
274957876 ,
280035362 ,
285162575 ,
290339577 ,
295566431 ,
300843198 ,
306169941 ,
311546721 ,
316973598 ,
322450632 ,
327977885 ,
333555415 ,
339183282 ,
344861544 ,
350590260 ,
356369488 ,
362199285 ,
368079710 ,
374010817 ,
379992665 ,
386025310 ,
392108807 ,
398243212 ,
404428579 ,
410664965 ,
416952423 ,
423291007 ,
429680771 ,
436121770 ,
442614055 ,
449157681 ,
455752699 ,
462399162 ,
469097121 ,
475846630 ,
482647738 ,
489500497 ,
496404958 ,
503361172 ,
510369188 ,
517429057 ,
524540829 ,
531704552 ,
538920276 ,
546188051 ,
553507924 ,
560879944 ,
568304159 ,
575780617 ,
583309367 ,
590890454 ,
598523927 ,
606209832 ,
613948216 ,
621739126 ,
629582607 ,
637478707 ,
645427469 ,
653428941 ,
661483167 ,
669590192 ,
677750062 ,
685962821 ,
694228513 ,
702547183 ,
710918875 ,
719343633 ,
727821500 ,
736352519 ,
744936735 ,
753574189 ,
762264926 ,
771008986 ,
779806414 ,
788657251 ,
797561539 ,
806519320 ,
815530636 ,
824595529 ,
833714039 ,
842886207 ,
852112076 ,
861391685 ,
870725076 ,
880112288 ,
889553362 ,
899048338 ,
908597256 ,
918200156 ,
927857078 ,
937568060 ,
947333142 ,
957152364 ,
967025763 ,
976953380 ,
986935253 ,
996971419 ,
1007061919 ,
1017206788 ,
1027406067 ,
1037659792 ,
1047968002 ,
1058330733 ,
1068748024 ,
1079219912 ,
1089746433 ,
1100327625 ,
1110963525 ,
1121654169 ,
1132399595 ,
1143199837 ,
1154054934 ,
1164964921 ,
1175929833 ,
1186949708 ,
1198024580 ,
1209154485 ,
1220339460 ,
1231579538 ,
1242874757 ,
1254225150 ,
1265630752 ,
1277091599 ,
1288607725 ,
1300179166 ,
1311805954 ,
1323488126 ,
1335225715 ,
1347018754 ,
1358867280 ,
1370771324 ,
1382730921 ,
1394746105 ,
1406816909 ,
1418943367 ,
1431125512 ,
1443363377 ,
1455656995 ,
1468006400 ,
};
/*
*		index : 0 ~ 255
*		350 is max CANDELA
*		(350*((index/255)^2.2))*4194304
*/

static int curve_2p2_350[] = {
0 ,
7453 ,
34246 ,
83562 ,
157352 ,
257083 ,
383948 ,
538958 ,
722999 ,
936856 ,
1181244 ,
1456812 ,
1764161 ,
2103851 ,
2476402 ,
2882308 ,
3322030 ,
3796009 ,
4304662 ,
4848389 ,
5427571 ,
6042574 ,
6693749 ,
7381435 ,
8105957 ,
8867630 ,
9666760 ,
10503640 ,
11378558 ,
12291790 ,
13243608 ,
14234273 ,
15264040 ,
16333160 ,
17441875 ,
18590422 ,
19779033 ,
21007934 ,
22277347 ,
23587488 ,
24938569 ,
26330799 ,
27764381 ,
29239514 ,
30756396 ,
32315217 ,
33916168 ,
35559434 ,
37245197 ,
38973636 ,
40744929 ,
42559247 ,
44416763 ,
46317645 ,
48262056 ,
50250162 ,
52282123 ,
54358096 ,
56478238 ,
58642703 ,
60851642 ,
63105206 ,
65403542 ,
67746796 ,
70135112 ,
72568632 ,
75047497 ,
77571844 ,
80141812 ,
82757536 ,
85419149 ,
88126783 ,
90880570 ,
93680639 ,
96527117 ,
99420131 ,
102359806 ,
105346266 ,
108379633 ,
111460029 ,
114587574 ,
117762385 ,
120984582 ,
124254279 ,
127571594 ,
130936639 ,
134349528 ,
137810373 ,
141319285 ,
144876374 ,
148481748 ,
152135517 ,
155837787 ,
159588664 ,
163388253 ,
167236659 ,
171133986 ,
175080334 ,
179075808 ,
183120506 ,
187214530 ,
191357978 ,
195550950 ,
199793542 ,
204085852 ,
208427975 ,
212820008 ,
217262045 ,
221754180 ,
226296505 ,
230889115 ,
235532101 ,
240225553 ,
244969563 ,
249764221 ,
254609615 ,
259505836 ,
264452969 ,
269451104 ,
274500328 ,
279600725 ,
284752383 ,
289955385 ,
295209818 ,
300515765 ,
305873308 ,
311282533 ,
316743520 ,
322256351 ,
327821109 ,
333437873 ,
339106725 ,
344827744 ,
350601009 ,
356426600 ,
362304595 ,
368235072 ,
374218109 ,
380253782 ,
386342168 ,
392483343 ,
398677384 ,
404924365 ,
411224361 ,
417577447 ,
423983696 ,
430443184 ,
436955981 ,
443522162 ,
450141799 ,
456814964 ,
463541729 ,
470322164 ,
477156341 ,
484044331 ,
490986203 ,
497982027 ,
505031873 ,
512135809 ,
519293905 ,
526506229 ,
533772849 ,
541093833 ,
548469247 ,
555899160 ,
563383637 ,
570922746 ,
578516551 ,
586165120 ,
593868517 ,
601626807 ,
609440055 ,
617308327 ,
625231685 ,
633210194 ,
641243918 ,
649332920 ,
657477262 ,
665677008 ,
673932220 ,
682242960 ,
690609291 ,
699031273 ,
707508968 ,
716042438 ,
724631743 ,
733276943 ,
741978099 ,
750735271 ,
759548519 ,
768417902 ,
777343479 ,
786325311 ,
795363454 ,
804457968 ,
813608912 ,
822816343 ,
832080318 ,
841400897 ,
850778135 ,
860212091 ,
869702820 ,
879250380 ,
888854827 ,
898516218 ,
908234608 ,
918010052 ,
927842608 ,
937732329 ,
947679272 ,
957683490 ,
967745039 ,
977863973 ,
988040347 ,
998274214 ,
1008565629 ,
1018914645 ,
1029321316 ,
1039785694 ,
1050307834 ,
1060887787 ,
1071525607 ,
1082221346 ,
1092975056 ,
1103786790 ,
1114656600 ,
1125584537 ,
1136570652 ,
1147614998 ,
1158717625 ,
1169878585 ,
1181097928 ,
1192375706 ,
1203711967 ,
1215106764 ,
1226560145 ,
1238072162 ,
1249642863 ,
1261272299 ,
1272960519 ,
1284707572 ,
1296513507 ,
1308378374 ,
1320302221 ,
1332285097 ,
1344327051 ,
1356428130 ,
1368588383 ,
1380807858 ,
1393086603 ,
1405424665 ,
1417822093 ,
1430278933 ,
1442795233 ,
1455371039 ,
1468006400 ,
};

/*
*		index : 0 ~ 255
*		360 is max CANDELA
*		(360*((index/255)^1.9))*4194304
*/

static int curve_1p9_360[] = {
	0 ,
	40414 ,
	150832 ,
	325887 ,
	562924 ,
	860160 ,
	1216252  ,
	1630130  ,
	2100908  ,
	2627827  ,
	3210229  ,
	3847531  ,
	4539212  ,
	5284798  ,
	6083862  ,
	6936006  ,
	7840866  ,
	8798102  ,
	9807399  ,
	10868457 ,
	11981000 ,
	13144762 ,
	14359495 ,
	15624961 ,
	16940937 ,
	18307206 ,
	19723565 ,
	21189817 ,
	22705775 ,
	24271256 ,
	25886089 ,
	27550106 ,
	29263146 ,
	31025054 ,
	32835679 ,
	34694877 ,
	36602505 ,
	38558430 ,
	40562517 ,
	42614639 ,
	44714672 ,
	46862493 ,
	49057986 ,
	51301035 ,
	53591529 ,
	55929359 ,
	58314418 ,
	60746602 ,
	63225812 ,
	65751947 ,
	68324910 ,
	70944609 ,
	73610949 ,
	76323840 ,
	79083195 ,
	81888926 ,
	84740947 ,
	87639177 ,
	90583532 ,
	93573933 ,
	96610302 ,
	99692560 ,
	102820633 ,
	105994445 ,
	109213924 ,
	112478998 ,
	115789596 ,
	119145649 ,
	122547088 ,
	125993847 ,
	129485858 ,
	133023057 ,
	136605381 ,
	140232765 ,
	143905148 ,
	147622468 ,
	151384666 ,
	155191682 ,
	159043457 ,
	162939934 ,
	166881055 ,
	170866766 ,
	174897009 ,
	178971731 ,
	183090877 ,
	187254396 ,
	191462233 ,
	195714338 ,
	200010658 ,
	204351145 ,
	208735747 ,
	213164416 ,
	217637102 ,
	222153758 ,
	226714337 ,
	231318790 ,
	235967073 ,
	240659138 ,
	245394942 ,
	250174438 ,
	254997582 ,
	259864331 ,
	264774642 ,
	269728470 ,
	274725775 ,
	279766514 ,
	284850645 ,
	289978127 ,
	295148920 ,
	300362983 ,
	305620277 ,
	310920761 ,
	316264398 ,
	321651148 ,
	327080972 ,
	332553834 ,
	338069695 ,
	343628519 ,
	349230267 ,
	354874905 ,
	360562395 ,
	366292702 ,
	372065791 ,
	377881625 ,
	383740171 ,
	389641393 ,
	395585258 ,
	401571731 ,
	407600779 ,
	413672368 ,
	419786465 ,
	425943038 ,
	432142054 ,
	438383481 ,
	444667286 ,
	450993438 ,
	457361905 ,
	463772657 ,
	470225662 ,
	476720890 ,
	483258309 ,
	489837891 ,
	496459604 ,
	503123420 ,
	509829308 ,
	516577239 ,
	523367184 ,
	530199115 ,
	537073002 ,
	543988818 ,
	550946533 ,
	557946121 ,
	564987552 ,
	572070800 ,
	579195838 ,
	586362637 ,
	593571171 ,
	600821413 ,
	608113336 ,
	615446915 ,
	622822122 ,
	630238931 ,
	637697318 ,
	645197255 ,
	652738718 ,
	660321680 ,
	667946118 ,
	675612005 ,
	683319317 ,
	691068029 ,
	698858116 ,
	706689555 ,
	714562320 ,
	722476389 ,
	730431736 ,
	738428338 ,
	746466172 ,
	754545214 ,
	762665440 ,
	770826828 ,
	779029354 ,
	787272995 ,
	795557730 ,
	803883534 ,
	812250386 ,
	820658263 ,
	829107143 ,
	837597003 ,
	846127823 ,
	854699580 ,
	863312252 ,
	871965818 ,
	880660256 ,
	889395545 ,
	898171664 ,
	906988591 ,
	915846306 ,
	924744788 ,
	933684016 ,
	942663969 ,
	951684628 ,
	960745970 ,
	969847978 ,
	978990629 ,
	988173904 ,
	997397783 ,
	1006662246 ,
	1015967274 ,
	1025312847 ,
	1034698945 ,
	1044125548 ,
	1053592639 ,
	1063100196 ,
	1072648202 ,
	1082236637 ,
	1091865482 ,
	1101534718 ,
	1111244327 ,
	1120994290 ,
	1130784588 ,
	1140615204 ,
	1150486117 ,
	1160397312 ,
	1170348768 ,
	1180340469 ,
	1190372395 ,
	1200444530 ,
	1210556855 ,
	1220709352 ,
	1230902005 ,
	1241134795 ,
	1251407704 ,
	1261720716 ,
	1272073814 ,
	1282466979 ,
	1292900195 ,
	1303373444 ,
	1313886711 ,
	1324439977 ,
	1335033226 ,
	1345666441 ,
	1356339605 ,
	1367052703 ,
	1377805717 ,
	1388598630 ,
	1399431428 ,
	1410304092 ,
	1421216607 ,
	1432168958 ,
	1443161126 ,
	1454193098 ,
	1465264856 ,
	1476376385 ,
	1487527669 ,
	1498718693 ,
	1509949440 ,

};

/*
*		index : 0 ~ 255
*		360 is max CANDELA
*		(360*((index/255)^2.15))*4194304
*/

static int curve_2p15_360[] = {
	0,
	10113 ,
	44886 ,
	107328 ,
	199219 ,
	321874 ,
	476350 ,
	663532 ,
	884188 ,
	1138997 ,
	1428568 ,
	1753458 ,
	2114174 ,
	2511188 ,
	2944939 ,
	3415838 ,
	3924271 ,
	4470604 ,
	5055183 ,
	5678338 ,
	6340383 ,
	7041619 ,
	7782332 ,
	8562801 ,
	9383291 ,
	10244058 ,
	11145350 ,
	12087406 ,
	13070457 ,
	14094728 ,
	15160437 ,
	16267794 ,
	17417005 ,
	18608270 ,
	19841783 ,
	21117734 ,
	22436308 ,
	23797686 ,
	25202043 ,
	26649553 ,
	28140383 ,
	29674698 ,
	31252660 ,
	32874427 ,
	34540154 ,
	36249993 ,
	38004092 ,
	39802597 ,
	41645653 ,
	43533400 ,
	45465977 ,
	47443519 ,
	49466161 ,
	51534034 ,
	53647267 ,
	55805988 ,
	58010322 ,
	60260393 ,
	62556322 ,
	64898229 ,
	67286232 ,
	69720447 ,
	72200990 ,
	74727972 ,
	77301507 ,
	79921704 ,
	82588671 ,
	85302516 ,
	88063345 ,
	90871263 ,
	93726371 ,
	96628774 ,
	99578570 ,
	102575860 ,
	105620742 ,
	108713314 ,
	111853671 ,
	115041908 ,
	118278120 ,
	121562399 ,
	124894838 ,
	128275527 ,
	131704556 ,
	135182015 ,
	138707991 ,
	142282572 ,
	145905844 ,
	149577893 ,
	153298803 ,
	157068657 ,
	160887541 ,
	164755534 ,
	168672719 ,
	172639177 ,
	176654987 ,
	180720229 ,
	184834982 ,
	188999322 ,
	193213328 ,
	197477075 ,
	201790640 ,
	206154097 ,
	210567522 ,
	215030988 ,
	219544568 ,
	224108336 ,
	228722362 ,
	233386719 ,
	238101478 ,
	242866709 ,
	247682482 ,
	252548865 ,
	257465929 ,
	262433741 ,
	267452368 ,
	272521879 ,
	277642339 ,
	282813815 ,
	288036373 ,
	293310077 ,
	298634994 ,
	304011186 ,
	309438718 ,
	314917654 ,
	320448055 ,
	326029986 ,
	331663508 ,
	337348682 ,
	343085570 ,
	348874233 ,
	354714731 ,
	360607125 ,
	366551473 ,
	372547836 ,
	378596273 ,
	384696841 ,
	390849599 ,
	397054605 ,
	403311916 ,
	409621589 ,
	415983681 ,
	422398249 ,
	428865349 ,
	435385036 ,
	441957365 ,
	448582392 ,
	455260171 ,
	461990757 ,
	468774205 ,
	475610566 ,
	482499896 ,
	489442248 ,
	496437673 ,
	503486226 ,
	510587957 ,
	517742920 ,
	524951165 ,
	532212745 ,
	539527709 ,
	546896111 ,
	554317998 ,
	561793423 ,
	569322436 ,
	576905085 ,
	584541421 ,
	592231492 ,
	599975349 ,
	607773039 ,
	615624611 ,
	623530113 ,
	631489594 ,
	639503101 ,
	647570682 ,
	655692384 ,
	663868254 ,
	672098339 ,
	680382686 ,
	688721341 ,
	697114349 ,
	705561759 ,
	714063614 ,
	722619960 ,
	731230843 ,
	739896308 ,
	748616400 ,
	757391163 ,
	766220642 ,
	775104881 ,
	784043924 ,
	793037815 ,
	802086597 ,
	811190315 ,
	820349012 ,
	829562729 ,
	838831512 ,
	848155401 ,
	857534440 ,
	866968670 ,
	876458135 ,
	886002876 ,
	895602935 ,
	905258353 ,
	914969172 ,
	924735433 ,
	934557178 ,
	944434446 ,
	954367280 ,
	964355719 ,
	974399803 ,
	984499574 ,
	994655071 ,
	1004866334 ,
	1015133403 ,
	1025456317 ,
	1035835116 ,
	1046269840 ,
	1056760526 ,
	1067307215 ,
	1077909945 ,
	1088568754 ,
	1099283682 ,
	1110054766 ,
	1120882045 ,
	1131765557 ,
	1142705340 ,
	1153701431 ,
	1164753869 ,
	1175862690 ,
	1187027932 ,
	1198249633 ,
	1209527828 ,
	1220862556 ,
	1232253854 ,
	1243701756 ,
	1255206302 ,
	1266767525 ,
	1278385464 ,
	1290060154 ,
	1301791631 ,
	1313579931 ,
	1325425089 ,
	1337327142 ,
	1349286125 ,
	1361302072 ,
	1373375021 ,
	1385505005 ,
	1397692059 ,
	1409936219 ,
	1422237519 ,
	1434595994 ,
	1447011678 ,
	1459484606 ,
	1472014812 ,
	1484602331 ,
	1497247195 ,
	1509949440 ,

};
/*
*		index : 0 ~ 255
*		360 is max CANDELA
*		(360*((index/255)^2.2))*4194304
*/

static int curve_2p2_360[] = {
	0 ,
	7666 ,
	35224 ,
	85949 ,
	161847 ,
	264428 ,
	394918 ,
	554357 ,
	743656 ,
	963624 ,
	1214994 ,
	1498435 ,
	1814566 ,
	2163961 ,
	2547157 ,
	2964659 ,
	3416945 ,
	3904466 ,
	4427652 ,
	4986915 ,
	5582645 ,
	6215219 ,
	6884999 ,
	7592333 ,
	8337556 ,
	9120991 ,
	9942953 ,
	10803744 ,
	11703659 ,
	12642984 ,
	13621997 ,
	14640966 ,
	15700156 ,
	16799822 ,
	17940214 ,
	19121577 ,
	20344148 ,
	21608161 ,
	22913842 ,
	24261416 ,
	25651100 ,
	27083107 ,
	28557649 ,
	30074929 ,
	31635150 ,
	33238509 ,
	34885202 ,
	36575418 ,
	38309345 ,
	40087169 ,
	41909069 ,
	43775226 ,
	45685814 ,
	47641006 ,
	49640972 ,
	51685881 ,
	53775898 ,
	55911184 ,
	58091902 ,
	60318208 ,
	62590261 ,
	64908212 ,
	67272215 ,
	69682419 ,
	72138972 ,
	74642022 ,
	77191711 ,
	79788183 ,
	82431579 ,
	85122037 ,
	87859696 ,
	90644692 ,
	93477158 ,
	96357229 ,
	99285035 ,
	102260706 ,
	105284372 ,
	108356159 ,
	111476194 ,
	114644602 ,
	117861504 ,
	121127025 ,
	124441284 ,
	127804402 ,
	131216496 ,
	134677686 ,
	138188086 ,
	141747812 ,
	145356979 ,
	149015699 ,
	152724084 ,
	156482246 ,
	160290295 ,
	164148340 ,
	168056489 ,
	172014850 ,
	176023528 ,
	180082630 ,
	184192259 ,
	188352521 ,
	192563517 ,
	196825349 ,
	201138120 ,
	205501929 ,
	209916876 ,
	214383060 ,
	218900580 ,
	223469532 ,
	228090013 ,
	232762120 ,
	237485947 ,
	242261589 ,
	247089140 ,
	251968693 ,
	256900341 ,
	261884176 ,
	266920288 ,
	272008769 ,
	277149707 ,
	282343194 ,
	287589317 ,
	292888165 ,
	298239825 ,
	303644384 ,
	309101929 ,
	314612546 ,
	320176319 ,
	325793334 ,
	331463675 ,
	337187426 ,
	342964669 ,
	348795488 ,
	354679965 ,
	360618181 ,
	366610218 ,
	372656155 ,
	378756075 ,
	384910055 ,
	391118176 ,
	397380516 ,
	403697153 ,
	410068166 ,
	416493632 ,
	422973628 ,
	429508231 ,
	436097516 ,
	442741560 ,
	449440438 ,
	456194224 ,
	463002994 ,
	469866820 ,
	476785778 ,
	483759940 ,
	490789380 ,
	497874169 ,
	505014380 ,
	512210085 ,
	519461355 ,
	526768261 ,
	534130874 ,
	541549264 ,
	549023502 ,
	556553657 ,
	564139797 ,
	571781993 ,
	579480313 ,
	587234824 ,
	595045596 ,
	602912695 ,
	610836188 ,
	618816144 ,
	626852629 ,
	634945708 ,
	643095448 ,
	651301914 ,
	659565173 ,
	667885289 ,
	676262327 ,
	684696351 ,
	693187426 ,
	701735616 ,
	710340985 ,
	719003595 ,
	727723510 ,
	736500793 ,
	745335507 ,
	754227713 ,
	763177473 ,
	772184850 ,
	781249905 ,
	790372699 ,
	799553293 ,
	808791748 ,
	818088124 ,
	827442482 ,
	836854881 ,
	846325381 ,
	855854042 ,
	865440922 ,
	875086082 ,
	884789579 ,
	894551472 ,
	904371820 ,
	914250680 ,
	924188110 ,
	934184168 ,
	944238911 ,
	954352397 ,
	964524681 ,
	974755822 ,
	985045875 ,
	995394897 ,
	1005802944 ,
	1016270071 ,
	1026796335 ,
	1037381790 ,
	1048026492 ,
	1058730496 ,
	1069493857 ,
	1080316629 ,
	1091198867 ,
	1102140624 ,
	1113141956 ,
	1124202915 ,
	1135323556 ,
	1146503931 ,
	1157744095 ,
	1169044100 ,
	1180403998 ,
	1191823843 ,
	1203303688 ,
	1214843583 ,
	1226443583 ,
	1238103738 ,
	1249824100 ,
	1261604721 ,
	1273445652 ,
	1285346945 ,
	1297308650 ,
	1309330819 ,
	1321413502 ,
	1333556750 ,
	1345760613 ,
	1358025142 ,
	1370350386 ,
	1382736395 ,
	1395183219 ,
	1407690908 ,
	1420259511 ,
	1432889077 ,
	1445579655 ,
	1458331295 ,
	1471144045 ,
	1484017953 ,
	1496953069 ,
	1509949440 ,
};
#endif /* START_MTP_2P2_GAMMA_H */
