/* Copyright (c) 2009-2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#ifndef _V1_EDP_MDNIE_DATA_H_
#define _V1_EDP_MDNIE_DATA_H_

#include "edp_tcon_mdnie.h"

#define MDNIE_COL	98
#define MDNIE_ROW	2

#define MDNIE_COLOR_BLINDE_CM_START (74 - 1)
#define MDNIE_COLOR_BLINDE_CMD_SIZE 18

char mdnie_app_name[][NAME_STRING_MAX] = {
	"UI_APP",
	"VIDEO_APP",
	"VIDEO_WARM_APP",
	"VIDEO_COLD_APP",
	"CAMERA_APP",
	"NAVI_APP",
	"GALLERY_APP",
	"VT_APP",
	"BROWSER_APP",
	"eBOOK_APP",
	"EMAIL_APP",
};

char mdnie_mode_name[][NAME_STRING_MAX] = {
	"DYNAMIC_MODE",
	"STANDARD_MODE",
#if defined(NATURAL_MODE_ENABLE)
	"NATURAL_MODE",
#endif
	"MOVIE_MODE",
	"AUTO_MODE",
};


static short BYPASS_MDNIE[MDNIE_COL * MDNIE_ROW] = {
	//NDRA BYPASS
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en
	0x0CEF,0x00,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x00,	//CC R2_L
	0x0CF2,0x00,	//CC R2_H
	0x0CF3,0x00,	//CC R3_L
	0x0CF4,0x00,	//CC R3_H
	0x0CF5,0x00,	//CC G1_L
	0x0CF6,0x00,	//CC G1_H
	0x0CF7,0x00,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0x00,	//CC G3_L
	0x0CFA,0x00,	//CC G3_H
	0x0CFB,0x00,	//CC B1_L
	0x0CFC,0x00,	//CC B1_H
	0x0CFD,0x00,	//CC B2_L
	0x0CFE,0x00,	//CC B2_H
	0x0CFF,0x00,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short NEGATIVE_MDNIE[MDNIE_COL * MDNIE_ROW] = {
	//NDRA negative
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en
	0x0CEF,0x00,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x00,	//CC R2_L
	0x0CF2,0x00,	//CC R2_H
	0x0CF3,0x00,	//CC R3_L
	0x0CF4,0x00,	//CC R3_H
	0x0CF5,0x00,	//CC G1_L
	0x0CF6,0x00,	//CC G1_H
	0x0CF7,0x00,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0x00,	//CC G3_L
	0x0CFA,0x00,	//CC G3_H
	0x0CFB,0x00,	//CC B1_L
	0x0CFC,0x00,	//CC B1_H
	0x0CFD,0x00,	//CC B2_L
	0x0CFE,0x00,	//CC B2_H
	0x0CFF,0x00,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0xff,	//SCR_Cr
	0x0D4F,0x00,	//SCR_Rr
	0x0D50,0x00,	//SCR_Cg
	0x0D51,0xff,	//SCR_Rg
	0x0D52,0x00,	//SCR_Cb
	0x0D53,0xff,	//SCR_Rb
	0x0D54,0x00,	//SCR_Mr
	0x0D55,0xff,	//SCR_Gr
	0x0D56,0xff,	//SCR_Mg
	0x0D57,0x00,	//SCR_Gg
	0x0D58,0x00,	//SCR_Mb
	0x0D59,0xff,	//SCR_Gb
	0x0D5A,0x00,	//SCR_Yr
	0x0D5B,0xff,	//SCR_Br
	0x0D5C,0x00,	//SCR_Yg
	0x0D5D,0xff,	//SCR_Bg
	0x0D5E,0xff,	//SCR_Yb
	0x0D5F,0x00,	//SCR_Bb
	0x0D60,0x00,	//SCR_Wr
	0x0D61,0xff,	//SCR_Kr
	0x0D62,0x00,	//SCR_Wg
	0x0D63,0xff,	//SCR_Kg
	0x0D64,0x00,	//SCR_Wb
	0x0D65,0xff,	//SCR_Kb
	0x0DAD,0x00, //Mask Release
};

static short COLOR_BLIND_MDNIE[MDNIE_COL * MDNIE_ROW] = {
	//NDRA COLOR ADJUSTMENT
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en
	0x0CEF,0x00,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x00,	//CC R2_L
	0x0CF2,0x00,	//CC R2_H
	0x0CF3,0x00,	//CC R3_L
	0x0CF4,0x00,	//CC R3_H
	0x0CF5,0x00,	//CC G1_L
	0x0CF6,0x00,	//CC G1_H
	0x0CF7,0x00,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0x00,	//CC G3_L
	0x0CFA,0x00,	//CC G3_H
	0x0CFB,0x00,	//CC B1_L
	0x0CFC,0x00,	//CC B1_H
	0x0CFD,0x00,	//CC B2_L
	0x0CFE,0x00,	//CC B2_H
	0x0CFF,0x00,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short CAMERA[MDNIE_COL * MDNIE_ROW] = {
	//N1 camera
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short EBOOK_MDNIE[MDNIE_COL * MDNIE_ROW] = {
	//N1 ebook
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xf9,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xe4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short EMAIL_MDNIE[MDNIE_COL * MDNIE_ROW] = {
	//N1 email
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xfe,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf1,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_UI[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto ui
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x1c,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x1c,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x1c,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x1c,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x1c,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x1c,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x1c,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x1c,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x1c,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x1c,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x1c,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x1c,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x1c,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0xa4,	//Curve_14_a
	0x0D2A,0x0d,	//Curve_14_b
	0x0D2B,0xa4,	//Curve_15_a
	0x0D2C,0x0d,	//Curve_15_b
	0x0D2D,0xa4,	//Curve_16_a
	0x0D2E,0x0d,	//Curve_16_b
	0x0D2F,0xa4,	//Curve_17_a
	0x0D30,0x0d,	//Curve_17_b
	0x0D31,0xa4,	//Curve_18_a
	0x0D32,0x0d,	//Curve_18_b
	0x0D33,0xa4,	//Curve_19_a
	0x0D34,0x0d,	//Curve_19_b
	0x0D35,0xa4,	//Curve_20_a
	0x0D36,0x0d,	//Curve_20_b
	0x0D37,0xa4,	//Curve_21_a
	0x0D38,0x0d,	//Curve_21_b
	0x0D39,0x1c,	//Curve_22_a
	0x0D3A,0x25,	//Curve_22_b
	0x0D3B,0x17,	//Curve_23_a
	0x0D3C,0x4a,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_GALLERY[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto gallery
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_VIDEO[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto video
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x1c,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x1c,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x1c,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x1c,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x1c,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x1c,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x1c,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x1c,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x1c,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x1c,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x1c,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x1c,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x1c,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0xa4,	//Curve_14_a
	0x0D2A,0x0d,	//Curve_14_b
	0x0D2B,0xa4,	//Curve_15_a
	0x0D2C,0x0d,	//Curve_15_b
	0x0D2D,0xa4,	//Curve_16_a
	0x0D2E,0x0d,	//Curve_16_b
	0x0D2F,0xa4,	//Curve_17_a
	0x0D30,0x0d,	//Curve_17_b
	0x0D31,0xa4,	//Curve_18_a
	0x0D32,0x0d,	//Curve_18_b
	0x0D33,0xa4,	//Curve_19_a
	0x0D34,0x0d,	//Curve_19_b
	0x0D35,0xa4,	//Curve_20_a
	0x0D36,0x0d,	//Curve_20_b
	0x0D37,0xa4,	//Curve_21_a
	0x0D38,0x0d,	//Curve_21_b
	0x0D39,0x1c,	//Curve_22_a
	0x0D3A,0x25,	//Curve_22_b
	0x0D3B,0x17,	//Curve_23_a
	0x0D3C,0x4a,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_BROWSER[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto browser
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_CAMERA[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto camera
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short AUTO_VTCALL[MDNIE_COL * MDNIE_ROW] = {
	//N1 auto vtcall
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short DYNAMIC_UI[MDNIE_COL * MDNIE_ROW] = {
	//N1 dynamic ui
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x10,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x10,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x10,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x10,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x9c,	//Curve_5_a
	0x0D18,0x06,	//Curve_5_b
	0x0D19,0x9c,	//Curve_6_a
	0x0D1A,0x06,	//Curve_6_b
	0x0D1B,0x9c,	//Curve_7_a
	0x0D1C,0x06,	//Curve_7_b
	0x0D1D,0x9c,	//Curve_8_a
	0x0D1E,0x06,	//Curve_8_b
	0x0D1F,0xa4,	//Curve_9_a
	0x0D20,0x0e,	//Curve_9_b
	0x0D21,0xa4,	//Curve_10_a
	0x0D22,0x0e,	//Curve_10_b
	0x0D23,0xa4,	//Curve_11_a
	0x0D24,0x0e,	//Curve_11_b
	0x0D25,0xa4,	//Curve_12_a
	0x0D26,0x0e,	//Curve_12_b
	0x0D27,0xa8,	//Curve_13_a
	0x0D28,0x14,	//Curve_13_b
	0x0D29,0xa8,	//Curve_14_a
	0x0D2A,0x14,	//Curve_14_b
	0x0D2B,0xa8,	//Curve_15_a
	0x0D2C,0x14,	//Curve_15_b
	0x0D2D,0xa8,	//Curve_16_a
	0x0D2E,0x14,	//Curve_16_b
	0x0D2F,0xa8,	//Curve_17_a
	0x0D30,0x14,	//Curve_17_b
	0x0D31,0xa8,	//Curve_18_a
	0x0D32,0x14,	//Curve_18_b
	0x0D33,0xa8,	//Curve_19_a
	0x0D34,0x14,	//Curve_19_b
	0x0D35,0xa8,	//Curve_20_a
	0x0D36,0x14,	//Curve_20_b
	0x0D37,0xa8,	//Curve_21_a
	0x0D38,0x14,	//Curve_21_b
	0x0D39,0x14,	//Curve_22_a
	0x0D3A,0x69,	//Curve_22_b
	0x0D3B,0x06,	//Curve_23_a
	0x0D3C,0xcf,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short DYNAMIC_GALLERY[MDNIE_COL * MDNIE_ROW] = {
	//N1 dynamic gallery
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x1c,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x1c,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x1c,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x1c,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x1c,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x1c,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x1c,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x1c,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x1c,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x1c,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x1c,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x1c,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x1c,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0xa4,	//Curve_14_a
	0x0D2A,0x0d,	//Curve_14_b
	0x0D2B,0xa4,	//Curve_15_a
	0x0D2C,0x0d,	//Curve_15_b
	0x0D2D,0xa4,	//Curve_16_a
	0x0D2E,0x0d,	//Curve_16_b
	0x0D2F,0xa4,	//Curve_17_a
	0x0D30,0x0d,	//Curve_17_b
	0x0D31,0xa4,	//Curve_18_a
	0x0D32,0x0d,	//Curve_18_b
	0x0D33,0xa4,	//Curve_19_a
	0x0D34,0x0d,	//Curve_19_b
	0x0D35,0xa4,	//Curve_20_a
	0x0D36,0x0d,	//Curve_20_b
	0x0D37,0xa4,	//Curve_21_a
	0x0D38,0x0d,	//Curve_21_b
	0x0D39,0x1c,	//Curve_22_a
	0x0D3A,0x25,	//Curve_22_b
	0x0D3B,0x17,	//Curve_23_a
	0x0D3C,0x4a,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short DYNAMIC_VIDEO[MDNIE_COL * MDNIE_ROW] = {
	//N1 dynamic video
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x10,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x10,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x10,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x10,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x9c,	//Curve_5_a
	0x0D18,0x06,	//Curve_5_b
	0x0D19,0x9c,	//Curve_6_a
	0x0D1A,0x06,	//Curve_6_b
	0x0D1B,0x9c,	//Curve_7_a
	0x0D1C,0x06,	//Curve_7_b
	0x0D1D,0x9c,	//Curve_8_a
	0x0D1E,0x06,	//Curve_8_b
	0x0D1F,0xa4,	//Curve_9_a
	0x0D20,0x0e,	//Curve_9_b
	0x0D21,0xa4,	//Curve_10_a
	0x0D22,0x0e,	//Curve_10_b
	0x0D23,0xa4,	//Curve_11_a
	0x0D24,0x0e,	//Curve_11_b
	0x0D25,0xa4,	//Curve_12_a
	0x0D26,0x0e,	//Curve_12_b
	0x0D27,0xa8,	//Curve_13_a
	0x0D28,0x14,	//Curve_13_b
	0x0D29,0xa8,	//Curve_14_a
	0x0D2A,0x14,	//Curve_14_b
	0x0D2B,0xa8,	//Curve_15_a
	0x0D2C,0x14,	//Curve_15_b
	0x0D2D,0xa8,	//Curve_16_a
	0x0D2E,0x14,	//Curve_16_b
	0x0D2F,0xa8,	//Curve_17_a
	0x0D30,0x14,	//Curve_17_b
	0x0D31,0xa8,	//Curve_18_a
	0x0D32,0x14,	//Curve_18_b
	0x0D33,0xa8,	//Curve_19_a
	0x0D34,0x14,	//Curve_19_b
	0x0D35,0xa8,	//Curve_20_a
	0x0D36,0x14,	//Curve_20_b
	0x0D37,0xa8,	//Curve_21_a
	0x0D38,0x14,	//Curve_21_b
	0x0D39,0x14,	//Curve_22_a
	0x0D3A,0x69,	//Curve_22_b
	0x0D3B,0x06,	//Curve_23_a
	0x0D3C,0xcf,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short DYNAMIC_BROWSER[MDNIE_COL * MDNIE_ROW] = {
	//N1 dynamic browser
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x1c,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x1c,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x1c,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x1c,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x1c,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x1c,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x1c,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x1c,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x1c,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x1c,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x1c,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x1c,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x1c,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0xa4,	//Curve_14_a
	0x0D2A,0x0d,	//Curve_14_b
	0x0D2B,0xa4,	//Curve_15_a
	0x0D2C,0x0d,	//Curve_15_b
	0x0D2D,0xa4,	//Curve_16_a
	0x0D2E,0x0d,	//Curve_16_b
	0x0D2F,0xa4,	//Curve_17_a
	0x0D30,0x0d,	//Curve_17_b
	0x0D31,0xa4,	//Curve_18_a
	0x0D32,0x0d,	//Curve_18_b
	0x0D33,0xa4,	//Curve_19_a
	0x0D34,0x0d,	//Curve_19_b
	0x0D35,0xa4,	//Curve_20_a
	0x0D36,0x0d,	//Curve_20_b
	0x0D37,0xa4,	//Curve_21_a
	0x0D38,0x0d,	//Curve_21_b
	0x0D39,0x1c,	//Curve_22_a
	0x0D3A,0x25,	//Curve_22_b
	0x0D3B,0x17,	//Curve_23_a
	0x0D3C,0x4a,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short DYNAMIC_VTCALL[MDNIE_COL * MDNIE_ROW] = {
	//N1 dynamic vtcall
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x03,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x01,	//Gamma_en
	0x0D0F,0x1c,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x1c,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x1c,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x1c,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x1c,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x1c,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x1c,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x1c,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x1c,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x1c,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x1c,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x1c,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x1c,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0xa4,	//Curve_14_a
	0x0D2A,0x0d,	//Curve_14_b
	0x0D2B,0xa4,	//Curve_15_a
	0x0D2C,0x0d,	//Curve_15_b
	0x0D2D,0xa4,	//Curve_16_a
	0x0D2E,0x0d,	//Curve_16_b
	0x0D2F,0xa4,	//Curve_17_a
	0x0D30,0x0d,	//Curve_17_b
	0x0D31,0xa4,	//Curve_18_a
	0x0D32,0x0d,	//Curve_18_b
	0x0D33,0xa4,	//Curve_19_a
	0x0D34,0x0d,	//Curve_19_b
	0x0D35,0xa4,	//Curve_20_a
	0x0D36,0x0d,	//Curve_20_b
	0x0D37,0xa4,	//Curve_21_a
	0x0D38,0x0d,	//Curve_21_b
	0x0D39,0x1c,	//Curve_22_a
	0x0D3A,0x25,	//Curve_22_b
	0x0D3B,0x17,	//Curve_23_a
	0x0D3C,0x4a,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short MOVIE_UI[MDNIE_COL * MDNIE_ROW] = {
	//N1 movie ui
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en x
	0x0CEF,0xd7,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x4c,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xdd,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xa4,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x7f,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xdd,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xa4,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0x4c,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x10,	//CC B3_L
	0x0D00,0x05,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xfc,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short MOVIE_GALLERY[MDNIE_COL * MDNIE_ROW] = {
	//N1 movie gallery
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en x
	0x0CEF,0xd7,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x4c,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xdd,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xa4,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x7f,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xdd,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xa4,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0x4c,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x10,	//CC B3_L
	0x0D00,0x05,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xfc,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short MOVIE_VIDEO[MDNIE_COL * MDNIE_ROW] = {
	//N1 movie video
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en x
	0x0CEF,0xd7,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x4c,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xdd,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xa4,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x7f,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xdd,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xa4,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0x4c,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x10,	//CC B3_L
	0x0D00,0x05,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xfc,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short MOVIE_BROWSER[MDNIE_COL * MDNIE_ROW] = {
	//N1 movie browser
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en x
	0x0CEF,0xd7,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x4c,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xdd,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xa4,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x7f,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xdd,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xa4,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0x4c,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x10,	//CC B3_L
	0x0D00,0x05,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xfc,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};


static short MOVIE_VTCALL[MDNIE_COL * MDNIE_ROW] = {
	//N1 movie vtcall
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x00,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x03,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x00,	//CC_en x
	0x0CEF,0xd7,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0x4c,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xdd,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xa4,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x7f,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xdd,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xa4,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0x4c,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x10,	//CC B3_L
	0x0D00,0x05,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xfc,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xf4,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short STANDARD_UI[MDNIE_COL * MDNIE_ROW] = {
	//N1 standard ui
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short STANDARD_GALLERY[MDNIE_COL * MDNIE_ROW] = {
	//N1 standard gallery
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short STANDARD_VIDEO[MDNIE_COL * MDNIE_ROW] = {
	//N1 standard video
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short STANDARD_BROWSER[MDNIE_COL * MDNIE_ROW] = {
	//N1 standard browser
	0x0CB9,0x00,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x00,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

static short STANDARD_VTCALL[MDNIE_COL * MDNIE_ROW] = {
	//N1 standard vtcall
	0x0CB9,0x03,	//DE(Sharpen) roi_ctrl | on/off 3/0
	0x0CBA,0x03,	//CS(CC) roi_ctrl | on/off 3/0
	0x0CBB,0x00,	//CC(Gamma) roi_ctrl | on/off 3/0
	0x0CBC,0x00,	//SCR roi_ctrl | on/off 3/0
	0x0CDF,0x02,	//Sharpen Level
	0x0CEE,0x01,	//CC_en 0.1
	0x0CEF,0x48,	//CC R1_L
	0x0CF0,0x04,	//CC R1_H
	0x0CF1,0xc4,	//CC R2_L
	0x0CF2,0x1f,	//CC R2_H
	0x0CF3,0xf4,	//CC R3_L
	0x0CF4,0x1f,	//CC R3_H
	0x0CF5,0xe1,	//CC G1_L
	0x0CF6,0x1f,	//CC G1_H
	0x0CF7,0x2b,	//CC G2_L
	0x0CF8,0x04,	//CC G2_H
	0x0CF9,0xf4,	//CC G3_L
	0x0CFA,0x1f,	//CC G3_H
	0x0CFB,0xe1,	//CC B1_L
	0x0CFC,0x1f,	//CC B1_H
	0x0CFD,0xc4,	//CC B2_L
	0x0CFE,0x1f,	//CC B2_H
	0x0CFF,0x5b,	//CC B3_L
	0x0D00,0x04,	//CC B3_H
	0x0D0E,0x00,	//Gamma_en
	0x0D0F,0x20,	//Curve_1_a
	0x0D10,0x00,	//Curve_1_b
	0x0D11,0x20,	//Curve_2_a
	0x0D12,0x00,	//Curve_2_b
	0x0D13,0x20,	//Curve_3_a
	0x0D14,0x00,	//Curve_3_b
	0x0D15,0x20,	//Curve_4_a
	0x0D16,0x00,	//Curve_4_b
	0x0D17,0x20,	//Curve_5_a
	0x0D18,0x00,	//Curve_5_b
	0x0D19,0x20,	//Curve_6_a
	0x0D1A,0x00,	//Curve_6_b
	0x0D1B,0x20,	//Curve_7_a
	0x0D1C,0x00,	//Curve_7_b
	0x0D1D,0x20,	//Curve_8_a
	0x0D1E,0x00,	//Curve_8_b
	0x0D1F,0x20,	//Curve_9_a
	0x0D20,0x00,	//Curve_9_b
	0x0D21,0x20,	//Curve_10_a
	0x0D22,0x00,	//Curve_10_b
	0x0D23,0x20,	//Curve_11_a
	0x0D24,0x00,	//Curve_11_b
	0x0D25,0x20,	//Curve_12_a
	0x0D26,0x00,	//Curve_12_b
	0x0D27,0x20,	//Curve_13_a
	0x0D28,0x00,	//Curve_13_b
	0x0D29,0x20,	//Curve_14_a
	0x0D2A,0x00,	//Curve_14_b
	0x0D2B,0x20,	//Curve_15_a
	0x0D2C,0x00,	//Curve_15_b
	0x0D2D,0x20,	//Curve_16_a
	0x0D2E,0x00,	//Curve_16_b
	0x0D2F,0x20,	//Curve_17_a
	0x0D30,0x00,	//Curve_17_b
	0x0D31,0x20,	//Curve_18_a
	0x0D32,0x00,	//Curve_18_b
	0x0D33,0x20,	//Curve_19_a
	0x0D34,0x00,	//Curve_19_b
	0x0D35,0x20,	//Curve_20_a
	0x0D36,0x00,	//Curve_20_b
	0x0D37,0x20,	//Curve_21_a
	0x0D38,0x00,	//Curve_21_b
	0x0D39,0x20,	//Curve_22_a
	0x0D3A,0x00,	//Curve_22_b
	0x0D3B,0x20,	//Curve_23_a
	0x0D3C,0x00,	//Curve_23_b
	0x0D3D,0xff,	//Curve_24_a
	0x0D3E,0x00,	//Curve_24_b
	0x0D4E,0x00,	//SCR_Cr
	0x0D4F,0xff,	//SCR_Rr
	0x0D50,0xff,	//SCR_Cg
	0x0D51,0x00,	//SCR_Rg
	0x0D52,0xff,	//SCR_Cb
	0x0D53,0x00,	//SCR_Rb
	0x0D54,0xff,	//SCR_Mr
	0x0D55,0x00,	//SCR_Gr
	0x0D56,0x00,	//SCR_Mg
	0x0D57,0xff,	//SCR_Gg
	0x0D58,0xff,	//SCR_Mb
	0x0D59,0x00,	//SCR_Gb
	0x0D5A,0xff,	//SCR_Yr
	0x0D5B,0x00,	//SCR_Br
	0x0D5C,0xff,	//SCR_Yg
	0x0D5D,0x00,	//SCR_Bg
	0x0D5E,0x00,	//SCR_Yb
	0x0D5F,0xff,	//SCR_Bb
	0x0D60,0xff,	//SCR_Wr
	0x0D61,0x00,	//SCR_Kr
	0x0D62,0xff,	//SCR_Wg
	0x0D63,0x00,	//SCR_Kg
	0x0D64,0xff,	//SCR_Wb
	0x0D65,0x00,	//SCR_Kb
	0x0DAD,0x00,	//Mask Release
};

short *mdnie_tune_value[MAX_APP_MODE][MAX_MODE] = {
 		/*"
			DYNAMIC_MODE
			STANDARD_MODE
			NATURAL_MODE
			MOVIE_MODE
			AUTO_MODE
		*/
		// UI_APP
		{
			DYNAMIC_UI,
			STANDARD_UI,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_UI,
			AUTO_UI,
		},
		// VIDEO_APP
		{
			DYNAMIC_VIDEO,
			STANDARD_VIDEO,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_VIDEO,
			AUTO_VIDEO,
		},
		// VIDEO_WARM_APP
		{
			DYNAMIC_VIDEO,
			STANDARD_VIDEO,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_VIDEO,
			AUTO_VIDEO,
		},
		// VIDEO_COLD_APP
		{
			DYNAMIC_VIDEO,
			STANDARD_VIDEO,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_VIDEO,
			AUTO_VIDEO,
		},
		// CAMERA_APP
		{
			CAMERA,
			CAMERA,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			CAMERA,
			AUTO_CAMERA,
		},
		// NAVI_APP
		{
			NULL,
			NULL,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			NULL,
			NULL,
		},
		// GALLERY_APP
		{
			DYNAMIC_GALLERY,
			STANDARD_GALLERY,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_GALLERY,
			AUTO_GALLERY,
		},
		// VT_APP
		{
			DYNAMIC_VTCALL,
			STANDARD_VTCALL,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_VTCALL,
			AUTO_VTCALL,
		},
		// BROWSER_APP
		{
			DYNAMIC_BROWSER,
			STANDARD_BROWSER,
#if defined(NATURAL_MODE_ENABLE)
			NULL,
#endif
			MOVIE_BROWSER,
			AUTO_BROWSER,
		},
		// eBOOK_APP
		{
			EBOOK_MDNIE,
			EBOOK_MDNIE,
#if defined(NATURAL_MODE_ENABLE)
			EBOOK_MDNIE,
#endif
			EBOOK_MDNIE,
			EBOOK_MDNIE,
		},
		// EMAIL_APP
		{
			EMAIL_MDNIE,
			EMAIL_MDNIE,
#if defined(NATURAL_MODE_ENABLE)
			EMAIL_MDNIE,
#endif
			EMAIL_MDNIE,
			EMAIL_MDNIE,
		},
};

#endif
