/* Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
/****************************** Revision History ******************************************
 *CH# Product           author          Description                             Date
 *-----------------------------------------------------------------------------------------
 *01  Atlantic	      nj.shetty    Intial file creation                    09-May-2014
 *      3G
 ******************************************************************************************
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2132, 2108, 2112, 2113, 2100},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x	= {0},
	.y	= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries	= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1195, 306, 100, 86, 67},
				{1195, 306, 100, 86, 67},
				{1162, 310, 103, 85, 69},
				{1119, 312, 107, 85, 70},
				{1115, 308, 111, 88, 72},
				{1062, 323, 121, 93, 75},
				{1022, 292, 124, 95, 78},
				{1031, 296, 132, 101, 81},
				{1029, 293, 125, 106, 87},
				{1042, 292, 105, 100, 78},
				{1078, 290, 101, 83, 70},
				{1134, 289, 101, 93, 71},
				{1204, 289, 102, 87, 73},
				{1284, 296, 104, 87, 77},
				{1386, 313, 105, 85, 77},
				{1549, 336, 110, 85, 69},
				{1815, 370, 111, 85, 70},
				{2157, 414, 110, 86, 71},
				{2537, 461, 107, 85, 69},
				{2585, 475, 107, 85, 72},
				{2936, 447, 108, 88, 73},
				{3323, 475, 111, 87, 74},
				{3827, 511, 115, 93, 76},
				{4451, 556, 121, 93, 78},
				{5350, 619, 127, 96, 81},
				{6531, 696, 127, 95, 75},
				{8428, 827, 125, 95, 75},
				{11602, 1063, 133, 97, 79},
				{17923, 1589, 153, 113, 87},
				{17923, 1589, 153, 113, 87},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4362, 4346, 4344, 4340, 4330},
				{4258, 4266, 4272, 4270, 4264},
				{4183, 4204, 4212, 4211, 4205},
				{4114, 4146, 4154, 4154, 4148},
				{4066, 4089, 4099, 4098, 4094},
				{3989, 4039, 4054, 4048, 4044},
				{3918, 3957, 3992, 3998, 3997},
				{3882, 3924, 3958, 3959, 3956},
				{3844, 3889, 3912, 3920, 3918},
				{3814, 3856, 3865, 3870, 3870},
				{3795, 3828, 3834, 3834, 3834},
				{3780, 3802, 3811, 3812, 3810},
				{3767, 3783, 3793, 3793, 3792},
				{3754, 3770, 3779, 3778, 3778},
				{3740, 3761, 3769, 3766, 3764},
				{3724, 3749, 3760, 3754, 3740},
				{3704, 3734, 3744, 3734, 3722},
				{3685, 3720, 3717, 3708, 3696},
				{3666, 3709, 3693, 3684, 3670},
				{3648, 3701, 3688, 3680, 3669},
				{3640, 3696, 3687, 3679, 3668},
				{3629, 3692, 3686, 3678, 3668},
				{3616, 3687, 3684, 3678, 3666},
				{3598, 3680, 3682, 3676, 3664},
				{3578, 3672, 3678, 3670, 3660},
				{3550, 3653, 3662, 3651, 3640},
				{3516, 3620, 3622, 3608, 3594},
				{3464, 3565, 3558, 3544, 3532},
				{3383, 3479, 3470, 3454, 3448},
				{3248, 3331, 3324, 3306, 3316},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data samsung_2100mAH_4400mV_data = {
	.fcc				= 2100,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut			= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 166
};

