/* Copyright (c) 2013, Samsung Electronics Co. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {6750, 6765, 6777, 6720, 6713},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{813, 189, 100, 93, 93},
				{834, 194, 101, 93, 94},
				{829, 204, 102, 94, 93},
				{810, 213, 104, 95, 95},
				{823, 222, 107, 96, 95},
				{790, 231, 111, 99, 96},
				{756, 216, 114, 100, 97},
				{762, 191, 126, 105, 100},
				{691, 183, 105, 97, 97},
				{700, 182, 101, 95, 95},
				{712, 184, 101, 95, 95},
				{726, 186, 101, 95, 95},
				{747, 189, 102, 95, 97},
				{780, 191, 103, 95, 97},
				{821, 192, 102, 94, 95},
				{870, 194, 101, 94, 95},
				{935, 195, 101, 93, 95},
				{995, 193, 102, 94, 94},
				{1053, 200, 100, 94, 95},
				{1095, 211, 102, 95, 95},
				{1117, 218, 104, 95, 95},
				{1145, 226, 104, 96, 96},
				{1172, 236, 106, 97, 98},
				{1205, 242, 108, 100, 102},
				{1243, 245, 111, 101, 100},
				{1287, 251, 109, 98, 97},
				{1437, 257, 107, 97, 98},
				{1927, 267, 108, 98, 99},
				{3569, 284, 111, 101, 104},
				{13091, 1559, 236, 164, 220}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4341, 4339, 4334, 4322, 4323},
				{4246, 4270, 4272, 4262, 4264},
				{4178, 4216, 4218, 4209, 4211},
				{4115, 4165, 4166, 4157, 4159},
				{4068, 4113, 4116, 4107, 4109},
				{4003, 4070, 4071, 4061, 4061},
				{3934, 3994, 4017, 4011, 4017},
				{3894, 3929, 3969, 3974, 3976},
				{3867, 3903, 3917, 3915, 3919},
				{3843, 3874, 3880, 3878, 3881},
				{3816, 3847, 3852, 3850, 3852},
				{3792, 3823, 3828, 3827, 3828},
				{3772, 3803, 3808, 3807, 3808},
				{3754, 3785, 3791, 3790, 3790},
				{3739, 3769, 3776, 3769, 3761},
				{3724, 3752, 3758, 3750, 3738},
				{3706, 3727, 3737, 3728, 3714},
				{3683, 3709, 3708, 3698, 3683},
				{3662, 3703, 3691, 3682, 3671},
				{3641, 3698, 3689, 3681, 3669},
				{3629, 3695, 3688, 3680, 3668},
				{3614, 3691, 3687, 3679, 3666},
				{3596, 3683, 3685, 3677, 3664},
				{3575, 3670, 3682, 3673, 3659},
				{3550, 3650, 3672, 3663, 3643},
				{3519, 3622, 3646, 3635, 3609},
				{3479, 3585, 3600, 3587, 3558},
				{3429, 3534, 3535, 3522, 3489},
				{3356, 3455, 3441, 3430, 3391},
				{3242, 3321, 3284, 3281, 3240},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data samsung_6800mAH_data = {
	.fcc				= 6800,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 123
};
