/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20,0,25,40,60},
	.y		= {2800,2779,2786,2781,2769},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20,0,25,40,60},
	.percent	= {100,95,90,85,80,75,70,65,60,55,50,45,40,35,30,25,20,16,13,11,10,9,8,7,6,5,4,3,2,1},
	.sf		= {
				{1311,269,100,80,71},
				{1311,269,100,80,71},
				{1204,275,102,82,73},
				{1163,279,105,84,75},
				{1127,286,107,86,76},
				{1021,302,116,92,79},
				{1011,249,115,92,80},
				{995,250,127,96,82},
				{1013,246,122,102,88},
				{1050,240,102,88,79},
				{1097,238,98,80,73},
				{1149,237,98,82,75},
				{1205,242,100,85,77},
				{1260,256,101,86,80},
				{1323,280,103,84,78},
				{1391,310,107,83,74},
				{1482,337,105,83,75},
				{1660,357,104,83,75},
				{1822,385,102,82,74},
				{1833,406,103,83,76},
				{1730,404,104,85,77},
				{1806,400,105,86,78},
				{1986,412,108,89,79},
				{2198,434,112,91,80},
				{2476,457,117,92,80},
				{2830,480,117,90,79},
				{3351,501,112,86,77},
				{4280,536,115,89,80},
				{8011,592,127,96,87},
				{76763,719,9114,128,706}
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20,0,25,40,60},
	.percent	= {100,95,90,85,80,75,70,65,60,55,50,45,40,35,30,25,20,16,13,11,10,9,8,7,6,5,4,3,2,1,0},
	.ocv		= {
				{4328,4326,4324,4320,4312},
				{4214,4247,4254,4252,4248},
				{4140,4190,4198,4196,4192},
				{4092,4139,4144,4142,4138},
				{4035,4091,4092,4090,4087},
				{3936,4041,4054,4049,4040},
				{3894,3954,3984,3992,3996},
				{3851,3918,3958,3958,3956},
				{3828,3886,3915,3920,3918},
				{3812,3854,3867,3871,3872},
				{3800,3828,3836,3837,3837},
				{3787,3804,3814,3815,3814},
				{3776,3790,3796,3797,3796},
				{3762,3780,3782,3782,3780},
				{3748,3772,3772,3768,3764},
				{3732,3761,3764,3755,3742},
				{3715,3740,3746,3736,3722},
				{3698,3716,3718,3710,3696},
				{3680,3704,3694,3686,3676},
				{3666,3696,3689,3682,3670},
				{3656,3694,3688,3681,3670},
				{3644,3692,3687,3680,3669},
				{3630,3688,3686,3680,3668},
				{3612,3685,3684,3678,3666},
				{3590,3680,3680,3674,3660},
				{3558,3664,3666,3658,3638},
				{3516,3633,3624,3615,3593},
				{3454,3582,3560,3552,3529},
				{3358,3502,3468,3464,3438},
				{3232,3370,3318,3323,3287},
				{3000,3000,3000,3000,3000}
	}
};

struct bms_battery_data samsung_2800mAH_data = {
	.fcc				= 2800,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 169
};
