/* Copyright (c) 2013, Samsung Electronics Co. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4673, 4711, 4712, 4705, 4675},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1773, 246, 100, 86, 82},
				{1770, 246, 100, 86, 82},
				{1701, 249, 100, 87, 83},
				{1646, 256, 103, 88, 83},
				{1529, 265, 105, 89, 84},
				{1514, 277, 108, 90, 85},
				{1514, 258, 112, 93, 86},
				{1543, 249, 121, 98, 89},
				{1586, 240, 119, 98, 89},
				{1631, 240, 105, 90, 85},
				{1682, 246, 102, 88, 83},
				{1734, 256, 103, 88, 84},
				{1786, 272, 105, 89, 85},
				{1845, 293, 107, 91, 86},
				{1909, 323, 107, 90, 84},
				{1994, 360, 107, 89, 83},
				{2108, 409, 106, 89, 83},
				{2362, 455, 108, 89, 83},
				{2497, 501, 109, 89, 83},
				{2919, 559, 110, 89, 84},
				{3182, 595, 113, 90, 84},
				{3502, 640, 115, 91, 85},
				{3940, 693, 118, 92, 86},
				{4420, 754, 123, 94, 87},
				{5043, 813, 126, 95, 87},
				{5868, 874, 128, 94, 85},
				{6964, 970, 133, 94, 85},
				{8491, 1101, 140, 96, 87},
				{8491, 1101, 140, 96, 87},
				{8491, 1101, 140, 96, 87}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4328, 4327, 4322, 4317, 4310},
				{4207, 4246, 4254, 4253, 4248},
				{4126, 4186, 4197, 4196, 4192},
				{4062, 4132, 4142, 4141, 4138},
				{3979, 4081, 4091, 4089, 4086},
				{3930, 4028, 4042, 4041, 4038},
				{3890, 3968, 3996, 3997, 3995},
				{3861, 3925, 3957, 3958, 3955},
				{3839, 3884, 3911, 3914, 3913},
				{3820, 3850, 3867, 3869, 3868},
				{3802, 3823, 3836, 3838, 3838},
				{3786, 3802, 3814, 3815, 3814},
				{3770, 3788, 3795, 3796, 3796},
				{3755, 3777, 3780, 3781, 3780},
				{3740, 3767, 3768, 3764, 3759},
				{3724, 3752, 3755, 3747, 3735},
				{3706, 3728, 3736, 3728, 3715},
				{3687, 3702, 3712, 3705, 3692},
				{3669, 3687, 3689, 3682, 3670},
				{3652, 3680, 3683, 3678, 3667},
				{3642, 3677, 3682, 3676, 3665},
				{3628, 3673, 3680, 3675, 3664},
				{3611, 3668, 3677, 3673, 3662},
				{3591, 3659, 3674, 3669, 3659},
				{3566, 3639, 3665, 3661, 3648},
				{3533, 3603, 3638, 3634, 3620},
				{3488, 3553, 3592, 3588, 3573},
				{3423, 3489, 3529, 3525, 3511},
				{3327, 3400, 3442, 3439, 3425},
				{3191, 3269, 3311, 3305, 3293},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data samsung_lis_4450mAH_data = {
	.fcc				= 4450,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 99
};
