/*
 * =================================================================
 *
 *       Filename:  ss_dsi_smart_dimming_S6E3FA7_AMS559NK01.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3FA7_AMS559NK01_H_
#define _SS_DSI_SMART_DIMMING_S6E3FA7_AMS559NK01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

#define VREG0_REF_6P8 28521267	/* 6.8*4194304 */
#define VREG0_REF_6P5 27262976	/* 6.5*4194304 */
#define VREG0_REF_6P4 26843546	/* 6.4*4194304 */
#define VREG0_REF_6P3 26424115	/* 6.3*4194304 */
#define VREG0_REF_6P2 26004685	/* 6.2*4194304 */

#define HBM_INTERPOLATION_STEP 8

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
	char gamma_setting_log[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;
	char panel_revision;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* VT,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static const int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static const int vt_coefficient[] = {
	0, 12, 24, 36,
	48, 60, 72, 84,
	96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static const int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
	{0x80, 0x80, 0x80},		/* V1 */
	{0x80, 0x80, 0x80},		/* V7 */
	{0x80, 0x80, 0x80},		/* V11 */
	{0x80, 0x80, 0x80},		/* V23 */
	{0x80, 0x80, 0x80},		/* V35 */
	{0x80, 0x80, 0x80},		/* V51 */
	{0x80, 0x80, 0x80},		/* V87 */
	{0x80, 0x80, 0x80},		/* V151 */
	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static const int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

/* 443 is made but not used */
static const int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* Jackpot rev.A */
static const unsigned int base_luminance_revA[LUMINANCE_MAX][2] = {
	{2, 91},
	{3, 91},
	{4, 91},
	{5, 91},
	{6, 91},
	{7, 91},
	{8, 91},
	{9, 91},
	{10, 91},
	{11, 91},
	{12, 91},
	{13, 91},
	{14, 91},
	{15, 91},
	{16, 91},
	{17, 91},
	{19, 91},
	{20, 91},
	{21, 91},
	{22, 91},
	{24, 91},
	{25, 91},
	{27, 91},
	{29, 91},
	{30, 91},
	{32, 91},
	{34, 91},
	{37, 91},
	{39, 91},
	{41, 91},
	{44, 91},
	{47, 91},
	{50, 91},
	{53, 91},
	{56, 91},
	{60, 91},
	{64, 91},
	{68, 95},
	{72, 102},
	{77, 111},
	{82, 118},
	{87, 123},
	{93, 133},
	{98, 142},
	{105, 153},
	{111, 163},
	{119, 177},
	{126, 186},
	{134, 200},
	{143, 217},
	{152, 230},
	{162, 249},
	{172, 265},
	{183, 280},
	{195, 280},
	{207, 280},
	{220, 280},
	{234, 280},
	{249, 283},
	{265, 297},
	{282, 316},
	{300, 335},
	{316, 354},
	{333, 368},
	{350, 388},
	{357, 392},
	{365, 402},
	{372, 402},
	{380, 402},
	{387, 402},
	{395, 402},
	{403, 406},
	{412, 413},
	{420, 420},
};

static const int gradation_offset_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 2, 3, 6, 12, 16, 20, 24, 29},
	{0, 2, 3, 6, 11, 15, 19, 22, 27},
	{0, 2, 2, 5, 9, 13, 17, 20, 25},
	{0, 2, 2, 4, 8, 12, 15, 18, 23},
	{0, 2, 2, 4, 8, 12, 15, 18, 22},
	{0, 2, 2, 4, 8, 11, 14, 17, 21},
	{0, 2, 2, 4, 7, 10, 13, 16, 19},
	{0, 2, 2, 4, 7, 10, 13, 16, 19},
	{0, 2, 2, 4, 7, 9, 12, 16, 18},
	{0, 2, 2, 4, 7, 9, 11, 15, 17},
	{0, 2, 2, 4, 7, 10, 11, 15, 17},
	{0, 2, 2, 4, 7, 10, 11, 15, 17},
	{0, 2, 2, 4, 7, 9, 11, 15, 17},
	{0, 2, 3, 4, 7, 9, 11, 15, 17},
	{0, 2, 3, 4, 6, 9, 11, 15, 17},
	{0, 2, 3, 3, 6, 8, 10, 14, 15},
	{0, 2, 3, 3, 5, 7, 10, 14, 15},
	{0, 2, 3, 3, 5, 7, 9, 13, 14},
	{0, 1, 2, 3, 5, 7, 9, 13, 14},
	{0, 1, 1, 2, 4, 5, 8, 12, 13},
	{0, 1, 1, 2, 4, 5, 7, 10, 11},
	{0, 1, 1, 2, 4, 5, 7, 10, 11},
	{0, 1, 1, 2, 3, 4, 6, 9, 9},
	{0, 1, 1, 2, 3, 4, 6, 9, 9},
	{0, 1, 1, 2, 3, 4, 6, 9, 9},
	{0, 1, 1, 2, 3, 4, 6, 9, 9},
	{0, 1, 1, 2, 3, 4, 6, 9, 9},
	{0, 1, 1, 2, 3, 4, 5, 7, 7},
	{0, 1, 1, 2, 3, 4, 5, 7, 7},
	{0, 1, 1, 2, 3, 4, 5, 7, 7},
	{0, 1, 1, 2, 3, 3, 5, 7, 7},
	{0, 1, 1, 2, 3, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 4, 6, 6},
	{0, 1, 2, 2, 2, 2, 4, 6, 6},
	{0, 1, 2, 2, 2, 3, 3, 6, 6},
	{0, 1, 2, 2, 2, 2, 3, 6, 6},
	{0, 1, 2, 2, 2, 2, 3, 5, 6},
	{0, 1, 2, 2, 2, 2, 3, 5, 6},
	{0, 1, 2, 2, 2, 2, 3, 5, 6},
	{0, 1, 2, 2, 2, 2, 3, 5, 5},
	{0, 1, 2, 2, 2, 2, 3, 5, 5},
	{0, 1, 2, 2, 1, 1, 2, 4, 5},
	{0, 1, 2, 2, 1, 1, 2, 4, 5},
	{0, 1, 2, 2, 1, 1, 2, 4, 5},
	{0, 1, 2, 2, 1, 1, 2, 4, 5},
	{0, 1, 2, 2, 1, 1, 2, 3, 4},
	{0, 1, 2, 2, 1, 1, 2, 3, 3},
	{0, 1, 2, 2, 1, 1, 2, 3, 3},
	{0, 1, 2, 2, 1, 1, 1, 2, 3},
	{0, 1, 2, 2, 1, 1, 1, 2, 3},
	{0, 0, 2, 1, 1, 1, 2, 3, 4},
	{0, 0, 1, 1, 0, 1, 1, 3, 4},
	{0, 0, 1, 1, 0, 1, 1, 2, 3},
	{0, 0, 1, 1, 0, 1, 1, 2, 3},
	{0, 0, 0, 1, 0, 1, 1, 2, 3},
	{0, 0, 0, 1, 0, 0, 1, 2, 3},
	{0, 0, 1, 1, 0, 0, 1, 2, 2},
	{0, 0, 1, 1, 0, 0, 0, 0, 1},
	{0, 0, 1, 0, 0, 0, 0, 0, 1},
	{0, 0, 0, 0, 0, 0, 0, 1, 1},
	{0, 0, 1, 0, 0, -1, -1, 0, 0},
	{0, 0, 0, 0, 0, -1, -1, 0, 0},
	{0, 0, 0, 0, -1, -1, -1, -1, 0},
	{0, 0, -1, 0, -1, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, 0, 0, 0, 0, 0, -1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, -1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
};

static const int rgb_offset_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-4, 0, 2, -5, -1, -4, -4, 1, -2, -13, 2, -6, -19, -1, -10, -11, -1, -4, -9, -2, -4, -7, -2, -1, -18, -23, -16},
	{-2, 0, 3, -4, -1, -3, -4, 1, -3, -11, 1, -6, -18, -1, -11, -15, -5, -9, -10, -2, -5, -5, 2, -1, -20, -21, -16},
	{-1, 0, 3, -4, -1, -3, -3, 1, -2, -10, 0, -7, -16, 0, -11, -15, -5, -9, -10, -2, -7, -5, 2, -3, -18, -19, -16},
	{0, 0, 3, -4, -1, -3, -2, 1, -1, -8, 1, -5, -15, -1, -13, -15, -5, -9, -10, 0, -7, -4, 3, -1, -16, -17, -14},
	{0, 0, 2, -4, -1, -3, -1, 1, -1, -8, 0, -5, -15, -1, -13, -15, -6, -9, -10, -1, -9, -4, 3, -3, -14, -15, -12},
	{0, 0, 2, -3, -1, -2, -1, 1, -1, -8, 0, -6, -14, -1, -13, -13, -2, -8, -11, -2, -11, -4, 3, -3, -14, -15, -12},
	{0, 0, 2, -3, -1, -2, -1, 1, -1, -6, 0, -5, -11, 2, -11, -11, -2, -7, -11, -2, -11, -4, 3, -5, -12, -13, -10},
	{0, 0, 2, -3, -1, -2, -1, 1, -1, -6, 0, -5, -10, 1, -11, -11, -2, -9, -13, -4, -12, -4, 3, -5, -12, -13, -10},
	{0, 0, 2, -3, -1, -2, -1, 1, -1, -5, 0, -5, -10, 1, -11, -10, 1, -7, -10, -1, -11, -8, -1, -9, -8, -9, -8},
	{0, 0, 2, -2, 0, -2, -1, 0, -1, -5, 0, -4, -10, 1, -12, -10, -1, -8, -6, 3, -10, -6, 1, -9, -8, -9, -8},
	{0, 0, 2, -2, 0, -2, -1, 0, -1, -5, 0, -4, -10, 0, -12, -10, -2, -8, -7, 2, -11, -5, 3, -9, -8, -9, -8},
	{0, 0, 2, -2, 0, -2, -2, 0, -2, -5, -1, -4, -10, 0, -12, -10, -2, -8, -7, 2, -11, -5, 1, -9, -8, -9, -8},
	{0, 0, 2, -2, 0, -2, -1, 1, 0, -6, -2, -6, -9, 0, -12, -9, 0, -8, -7, 2, -10, -7, -1, -9, -8, -6, -9},
	{1, 0, 2, -2, 0, -2, -2, 0, -1, -4, 0, -4, -10, 0, -12, -9, 0, -7, -8, 0, -12, -9, 1, -13, -7, -6, -7},
	{1, 0, 2, -2, 0, -2, -2, -1, -2, -5, 0, -4, -6, 3, -8, -9, -1, -9, -9, 2, -11, -12, -2, -16, -8, -8, -10},
	{1, 0, 2, -2, 0, -2, -2, -1, -2, -4, 0, -4, -6, 3, -8, -9, -1, -9, -9, 2, -11, -8, 2, -16, 2, 0, -4},
	{1, 0, 2, -2, 0, -1, -2, -1, -2, -3, 0, -4, -6, 3, -8, -9, -1, -8, -9, -3, -11, -12, -2, -16, 2, 0, -4},
	{1, 0, 2, -1, 0, 0, -2, -1, -1, -3, -1, -4, -7, -1, -8, -7, -1, -6, -6, 3, -8, -11, -2, -16, 3, 3, -7},
	{0, 0, 2, -2, 0, -2, -1, 0, -1, -3, 0, -3, -7, 1, -8, -10, -2, -9, -8, 1, -12, -13, -3, -16, 0, 0, -4},
	{1, 0, 3, -2, 0, -2, 1, 2, 0, -2, 1, -3, -5, 3, -7, -6, 2, -6, -9, 0, -16, -12, -2, -15, 0, 0, -4},
	{0, 0, 2, -1, 0, -1, 1, 2, 0, -3, 0, -4, -5, 2, -7, -6, 2, -6, -2, 7, -8, -5, 7, -13, 1, 1, -3},
	{0, 0, 2, -1, 0, -1, 1, 2, 0, -2, 0, -3, -6, 1, -8, -7, 2, -6, -2, 7, -8, -6, 6, -14, -1, -1, -5},
	{1, 0, 3, -2, 0, -2, 1, 2, 0, -2, 0, -3, -2, 4, -4, -6, 3, -4, -3, 7, -9, -7, 7, -14, 12, 8, 4},
	{1, 0, 3, -2, 0, -2, 1, 2, 0, -2, 0, -2, -2, 4, -5, -6, 2, -4, -5, 5, -10, -9, 5, -16, 12, 8, 4},
	{1, 0, 3, -2, 0, -2, 1, 1, 0, -3, -1, -4, -2, 4, -4, -6, 1, -3, -5, 5, -10, -9, 5, -16, 10, 7, 1},
	{1, 0, 3, -2, -1, -2, 1, 3, 0, -3, -1, -3, -2, 3, -5, -7, 0, -4, -5, 5, -9, -12, 2, -18, 10, 7, 1},
	{1, 0, 3, -2, -1, -2, 1, 2, 0, -3, -1, -3, -2, 3, -5, -8, -2, -5, -7, 3, -11, -13, 1, -19, 10, 7, 1},
	{1, 0, 3, -2, -1, -2, 1, 2, 0, -2, -1, -3, -4, 1, -6, -8, -2, -5, 1, 11, -4, -5, 12, -13, 11, 9, 2},
	{1, 0, 3, -2, -1, -2, 0, 1, -1, -2, -1, -3, -3, 1, -5, -9, -3, -5, 0, 10, -5, -6, 11, -14, 10, 8, 1},
	{1, 0, 3, -2, -1, -2, 0, 1, -1, -2, -2, -3, -3, 1, -5, -9, -3, -5, -1, 9, -6, -8, 9, -16, 9, 7, 0},
	{1, 0, 3, -2, -1, -2, 0, 1, -1, -2, -2, -3, -3, 1, -5, -2, 4, 0, -6, 1, -10, -13, 5, -18, 10, 6, -2},
	{1, 0, 3, -2, -1, -2, -1, 0, -2, -2, -2, -3, -3, 1, -4, -2, 2, -1, -1, 8, -7, -11, 7, -16, 15, 11, 2},
	{1, 0, 3, -2, -1, -2, -2, -1, -2, -2, -2, -3, 1, 4, -2, -5, -1, -3, -3, 6, -8, -13, 5, -18, 13, 11, 2},
	{1, 0, 3, -2, -1, -2, -2, -1, -2, -2, -2, -2, 1, 4, -3, -5, -2, -3, -4, 4, -8, -16, 2, -21, 12, 12, 2},
	{1, 0, 3, -2, -1, -2, -2, -1, -2, -2, -2, -2, 1, 3, -3, -5, -2, -3, -4, 4, -8, -17, 0, -22, 11, 10, 1},
	{1, 0, 3, -2, -1, -2, -2, -1, -2, -2, -2, -3, 1, 2, -3, -6, -3, -4, -5, 2, -8, -19, -2, -23, 10, 10, 0},
	{1, 0, 3, -2, -1, -2, -2, -2, -2, -2, -1, -2, 1, 2, -3, -6, -3, -4, -6, 0, -9, -21, -4, -23, 8, 10, -2},
	{1, 0, 3, -1, 0, -1, -3, -2, -3, -3, -2, -2, 1, 2, -3, -4, 0, -1, -5, 1, -8, -23, -8, -25, 8, 10, -2},
	{1, 0, 3, -1, 1, 0, -3, -2, -3, -4, -5, -4, 0, 2, -3, -4, -1, -1, 1, 5, -4, -23, -8, -23, 7, 9, -5},
	{1, 0, 3, 1, 1, 1, -3, -2, -3, -4, -5, -4, 0, 2, -3, -1, 2, 1, 0, 4, -4, -23, -8, -23, 7, 8, -5},
	{1, 0, 3, 1, 2, 1, -3, -3, -3, -3, -3, -3, -1, 1, -4, -2, 0, 0, -2, 2, -6, -18, -3, -20, 7, 8, -5},
	{1, 0, 3, 1, 2, 1, -3, -2, -3, -3, -3, -3, -1, 1, -4, -2, 0, 0, -1, 3, -5, -21, -6, -23, 5, 6, -5},
	{1, 0, 3, 1, 2, 1, -1, -2, -3, -3, -3, -3, -1, -1, -4, -2, 0, 0, -1, 3, -3, -19, -4, -21, 3, 6, -7},
	{1, 0, 3, 0, 2, 1, -1, -1, -2, -3, -4, -3, -2, -1, -5, 0, 3, 3, -4, 1, -6, -15, 0, -17, 4, 7, -6},
	{1, 0, 2, -1, 1, 1, 1, 0, 0, -4, -2, -3, -2, -1, -5, -2, -1, 0, -4, 1, -6, -15, -1, -17, 2, 5, -7},
	{1, 0, 1, -1, 1, 1, 1, 0, -1, -2, -2, -2, -1, 0, -4, 1, 2, 3, -5, 1, -7, -15, -1, -17, -1, 3, -9},
	{1, 0, 1, -1, 1, 1, 0, 1, -1, -1, -2, -1, -2, -1, -4, 1, 2, 3, -3, 3, -5, -13, 1, -15, -1, 3, -11},
	{1, 0, 1, -1, 1, 2, 0, 1, 0, -2, -3, -3, -2, -1, -4, 1, 2, 3, -4, 0, -5, -13, 1, -15, -3, 1, -11},
	{1, 0, 1, -1, 0, 1, 0, 2, 0, -1, -2, -1, -2, -1, -3, 1, 1, 2, -2, 2, -3, -13, 1, -15, -3, 1, -11},
	{1, 0, 1, -1, 0, 0, 1, 2, 0, -1, -1, 0, -1, 0, -3, -1, 0, 0, -4, 0, -5, -11, 3, -13, -3, 1, -11},
	{1, 0, 1, -1, 0, 1, 1, 2, 1, -1, -1, -2, -1, 0, -2, -1, -1, 0, -1, 1, -2, -11, 2, -13, 8, 10, -2},
	{1, 0, 1, -3, -1, -1, 0, 1, 1, 0, 1, 0, -1, -1, -3, -1, -1, 0, -4, -2, -4, -8, 7, -10, 8, 10, -2},
	{0, 0, 0, -1, -1, 0, 0, 1, 1, 0, 0, 0, -1, -1, -2, 1, 1, 2, -1, 1, -1, -8, 3, -10, 4, 9, -4},
	{0, 0, 0, -2, -1, -1, 1, 1, 1, 0, 0, 0, 0, 0, -2, 1, 1, 1, -1, 1, -1, -8, 3, -10, 4, 9, -4},
	{0, 0, 0, -1, -1, 0, 0, 1, 0, 0, 1, 0, 0, 0, -2, 1, 1, 1, -3, -1, -3, -4, 7, -10, 5, 7, -7},
	{0, 0, 0, -1, -1, 0, 1, 3, 1, 0, 1, 0, 1, 1, -2, -1, -1, 0, 0, 2, -1, -9, -1, -10, 2, 6, -11},
	{0, 0, 0, -1, -1, -1, 0, 2, 1, 0, 1, 0, -1, 0, -2, -1, -1, 0, -1, 0, -1, -9, -1, -7, -5, 4, -11},
	{0, 0, 0, -2, -1, -1, 0, 1, 0, 0, 1, 0, 0, 0, -1, -1, -1, 0, -2, -1, -2, -9, -1, -7, -8, 1, -11},
	{0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, -1, -1, -1, 0, -2, -1, -2, -9, -1, -7, -8, -1, -11},
	{0, 0, 0, 0, 0, 1, 0, 1, 1, 0, -1, -1, 0, 0, -1, 0, 0, 1, -2, -1, -2, -6, 0, -7, -4, 1, -11},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 1, -2, -1, -2, -4, 0, -5, -6, -2, -11},
	{0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, -2, -2, -2, 0, 0, 1, 0, 1, 0, -2, 2, -3, -5, 1, -5},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 1, 0, 1, 0, -2, 2, -2, -3, 3, -3},
	{0, 0, 0, 0, 0, 0, -1, 1, 1, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, -2, 0, -1, -4, 2, -2},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 5, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 2, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

/************
 *	  HMT   *
 ************/
static unsigned int base_luminance_reverse_hmt_single[][2] = {

	{10, 29},
	{11, 33},
	{12, 36},
	{13, 39},
	{14, 44},
	{15, 48},
	{16, 51},
	{17, 56},
	{19, 65},
	{20, 69},
	{21, 73},
	{22, 76},
	{23, 82},
	{25, 89},
	{27, 97},
	{29, 105},
	{31, 113},
	{33, 121},
	{35, 129},
	{37, 137},
	{39, 147},
	{41, 154},
	{44, 167},
	{47, 182},
	{50, 196},
	{53, 208},
	{56, 222},
	{60, 238},
	{64, 256},
	{68, 273},
	{72, 288},
	{77, 207},
	{82, 222},
	{87, 237},
	{93, 258},
	{99, 273},
	{105, 289},
};

static int gradation_offset_reverse_hmt_single[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, -2, -1, 2, 3, 4, 6, 8, 10},
	{0, -2, -2, 1, 3, 4, 5, 7, 8},
	{0, -2, -2, 1, 3, 4, 5, 7, 9},
	{0, 2, -1, 2, 3, 5, 6, 7, 10},
	{0, 1, -1, 1, 3, 4, 5, 7, 8},
	{0, 0, -1, 1, 2, 4, 5, 7, 10},
	{0, 1, -1, 0, 3, 4, 5, 7, 8},
	{0, -1, -1, 0, 3, 4, 5, 7, 8},
	{0, -1, -1, 0, 2, 4, 6, 7, 10},
	{0, -2, -1, 0, 3, 4, 5, 7, 10},
	{0, -1, -1, 0, 2, 3, 5, 7, 10},
	{0, -1, -1, 0, 3, 4, 5, 7, 8},
	{0, -1, -1, 1, 2, 4, 5, 6, 7},
	{0, 0, 2, 1, 3, 4, 6, 7, 10},
	{0, 1, 2, 1, 3, 3, 6, 7, 8},
	{0, 1, 2, 1, 3, 4, 5, 7, 10},
	{0, 1, 1, 0, 3, 4, 6, 8, 8},
	{0, 1, 1, 0, 3, 3, 5, 7, 9},
	{0, 2, 3, 1, 3, 4, 6, 7, 9},
	{0, 1, 2, 1, 2, 4, 5, 7, 8},
	{0, 1, 2, 1, 2, 3, 5, 7, 8},
	{0, 1, 3, 1, 2, 4, 6, 8, 8},
	{0, 1, 3, 1, 2, 4, 5, 7, 8},
	{0, -1, 3, 2, 3, 4, 4, 7, 9},
	{0, -1, 2, 2, 3, 3, 5, 7, 9},
	{0, -1, 3, 2, 3, 3, 4, 7, 9},
	{0, -2, 3, 2, 2, 4, 5, 7, 8},
	{0, -1, 3, 2, 3, 4, 5, 7, 9},
	{0, -1, 3, 2, 3, 4, 5, 8, 9},
	{0, 0, 3, 3, 4, 4, 5, 7, 9},
	{0, 1, 3, 3, 2, 3, 5, 7, 9},
	{0, 0, 2, 1, 1, 1, 2, 4, 6},
	{0, -1, 3, 1, 0, 2, 3, 4, 5},
	{0, 0, 2, 1, 1, 2, 2, 4, 5},
	{0, -1, 2, 2, 1, 2, 3, 4, 5},
	{0, 1, 2, 3, 1, 2, 2, 4, 5},
	{0, 1, 3, 3, 0, 1, 2, 4, 6},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{1, 0, 4, 5, 0, 3, -1, 0, -2, -6, 2, -6, -4, 3, -6, -7, 3, -6, -4, 2, -4, -6, 2, -5, -1, 0, -1},
	{2, 0, 4, 5, 0, 3, 0, 0, -1, -6, 2, -6, -4, 2, -6, -5, 2, -6, -7, 3, -7, -5, 2, -5, -5, 0, 0},
	{2, 0, 4, 5, 0, 2, -1, 0, -2, -5, 2, -6, -5, 2, -6, -4, 3, -6, -8, 3, -7, -5, 2, -4, -1, 0, -1},
	{2, 0, 3, -1, 0, -1, 2, 0, 1, -2, 2, -5, -7, 2, -6, -6, 2, -6, -6, 2, -6, -7, 3, -6, -1, 0, -1},
	{3, 0, 3, 0, 0, 0, 2, 0, 2, -3, 2, -5, -7, 2, -5, -8, 2, -6, -9, 3, -7, -6, 3, -6, -1, 0, 0},
	{3, 0, 4, -1, 0, -1, 3, 0, 2, -3, 2, -5, -7, 2, -6, -6, 2, -5, -9, 3, -8, -9, 3, -6, -1, 0, -1},
	{3, -1, 4, -1, 0, -1, 4, 0, 3, -2, 2, -5, -6, 2, -5, -6, 2, -5, -10, 3, -8, -8, 3, -6, -1, 0, -1},
	{3, 0, 4, -1, 0, -1, 3, 0, 2, -2, 1, -4, -7, 2, -6, -6, 2, -5, -8, 3, -7, -11, 3, -7, -1, 1, -2},
	{4, 0, 4, 0, 0, 0, 3, 0, 2, -2, 1, -4, -7, 2, -6, -6, 1, -4, -7, 3, -6, -12, 3, -8, -1, 0, -1},
	{5, 0, 4, -3, 0, -2, 3, 0, 2, -3, 1, -4, -5, 2, -5, -6, 2, -5, -8, 2, -6, -11, 3, -8, -1, 0, -1},
	{5, -1, 4, -2, 0, -1, 3, 0, 2, -2, 1, -3, -6, 3, -6, -5, 2, -4, -8, 2, -6, -11, 3, -8, -1, 0, -1},
	{5, -1, 5, -2, 0, -1, 3, 0, 3, -1, 1, -3, -6, 2, -6, -5, 2, -4, -9, 3, -8, -11, 3, -8, 0, 0, 0},
	{5, -1, 5, -2, 0, -2, 2, 0, 2, 0, 1, -2, -5, 3, -6, -7, 2, -5, -6, 2, -6, -13, 4, -9, 0, 0, 0},
	{4, -1, 4, -1, 0, -1, -3, 0, -2, 1, 0, 0, -5, 2, -6, -5, 2, -5, -7, 2, -6, -11, 4, -8, -1, 0, -1},
	{5, -1, 4, 0, 0, 0, -4, 0, -2, 1, 0, 0, -4, 3, -6, -6, 2, -5, -7, 2, -5, -12, 4, -9, -1, 1, -2},
	{7, -1, 6, -2, 0, -2, -4, 0, -3, 1, 0, 1, -4, 2, -6, -5, 2, -4, -7, 3, -6, -12, 4, -9, -1, 0, -1},
	{7, -1, 5, -2, 0, -1, -3, 0, -1, 0, 0, 0, -3, 2, -5, -5, 2, -5, -7, 2, -6, -11, 4, -8, -3, 1, -3},
	{7, -1, 6, -1, 0, -1, -4, 0, -2, 0, 0, 1, -1, 2, -5, -6, 2, -5, -7, 3, -6, -10, 4, -8, -2, 1, -2},
	{8, -1, 7, -3, 0, -2, -4, 0, -3, 0, 0, 1, -1, 2, -5, -6, 2, -4, -5, 2, -4, -13, 4, -10, -3, 1, -2},
	{8, -1, 6, -1, 0, -1, -3, 0, -3, 0, 0, 1, -2, 2, -5, -5, 2, -4, -6, 2, -5, -14, 4, -10, -4, 1, -3},
	{8, -1, 6, -1, 0, -1, -4, 0, -3, 0, 0, 1, -2, 2, -4, -5, 2, -4, -7, 2, -6, -12, 4, -9, -3, 1, -3},
	{8, -1, 6, -2, 0, -1, -4, 0, -2, 1, 0, 0, -3, 2, -5, -4, 2, -4, -6, 2, -4, -13, 4, -10, -4, 1, -3},
	{9, -1, 7, -2, 0, -1, -4, 0, -2, 2, 0, 1, -3, 2, -5, -4, 2, -4, -6, 2, -5, -12, 4, -9, -6, 1, -4},
	{10, -1, 7, -2, 0, -1, -4, 0, -2, 0, 0, 0, -2, 2, -4, -5, 2, -5, -5, 2, -5, -13, 4, -10, -3, 1, -2},
	{10, -1, 7, -2, 0, -1, -4, 0, -1, 1, 0, 0, -1, 2, -4, -4, 2, -4, -5, 2, -5, -14, 4, -10, -4, 1, -3},
	{10, -1, 7, -1, 0, 0, -4, 0, -3, 1, 0, 1, -1, 2, -4, -6, 2, -5, -5, 2, -4, -11, 4, -9, -5, 1, -3},
	{12, -1, 8, 0, 0, 0, -6, 0, -3, 0, 0, 0, -2, 1, -3, -5, 2, -5, -5, 2, -4, -14, 4, -10, -5, 1, -3},
	{11, -1, 8, -1, 0, -1, -4, 0, -2, 0, 0, 0, -1, 1, -2, -6, 2, -6, -4, 2, -4, -13, 4, -10, -4, 1, -3},
	{12, -1, 8, -1, 0, 0, -5, 0, -3, 1, 0, 1, -1, 1, -3, -6, 2, -6, -4, 2, -4, -14, 4, -10, -4, 1, -3},
	{12, -1, 8, 0, 0, 0, -4, 0, -2, 0, 0, 0, -2, 1, -3, -5, 3, -6, -5, 1, -4, -13, 4, -9, -5, 1, -4},
	{12, -1, 8, 0, 0, 0, -3, 0, -2, 0, 0, 0, -1, 1, -2, -5, 3, -6, -5, 1, -4, -13, 4, -9, -5, 1, -4},
	{7, -1, 6, 0, 0, 0, -3, 0, -3, 0, 0, -1, -1, 0, -2, -2, 1, -2, -4, 1, -4, -13, 4, -9, -4, 1, -4},
	{7, -1, 6, 0, 0, 0, -1, 0, -1, -2, 1, -2, 0, 0, -2, -3, 1, -4, -2, 1, -2, -13, 4, -9, -4, 1, -4},
	{7, -1, 6, 0, 0, 0, -1, 0, -2, -2, 0, -1, 0, 0, -1, -2, 1, -4, -4, 1, -3, -13, 4, -9, -4, 1, -4},
	{8, -1, 6, 0, 0, 0, -2, 0, -3, -2, 0, -2, 1, 0, 0, -3, 1, -4, -2, 1, -3, -14, 4, -10, -4, 2, -4},
	{8, -1, 6, 0, 0, 0, -2, 0, -1, -2, 0, -2, 1, 0, 0, -3, 1, -4, -2, 1, -3, -12, 4, -8, -7, 2, -6},
	{8, -1, 7, 0, 0, 0, -1, 0, -1, -2, 1, -2, 1, 0, 0, -2, 1, -4, -2, 1, -3, -12, 4, -8, -5, 1, -4},
};

#endif
