/* Copyright (c) 2011-2014, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/of_gpio.h>
#include <linux/delay.h>
#include <linux/crc32.h>
#include <linux/lzo.h>
#include "msm_sd.h"
#include "msm_cci.h"
#include "msm_otp.h"
#include <media/msm_cam_sensor.h>

#ifdef CONFIG_S5K5E9YX
#include "s5k5e9yx_otp.h"
#endif
#ifdef CONFIG_S5K5E3YX
#include "s5k5e3yx_otp.h"
#endif

#define MSM_EEPROM_DEBUG 1

#undef CDBG
#ifdef MSM_EEPROM_DEBUG
#define CDBG(fmt, args...) pr_err(fmt, ##args)
#else
#define CDBG(fmt, args...) pr_debug(fmt, ##args)
#endif

#undef EEPROM_MMAP_DEBUG

#ifdef CONFIG_COMPAT
static struct v4l2_file_operations msm_eeprom_v4l2_subdev_fops;
#endif

#if defined(CONFIG_GET_FRONT_MODULE_ID_OTP)
extern uint8_t front_module_id[S5K5E9_OTP_MODULE_ID_SIZE + 1];
#endif
#if defined(CONFIG_GET_FRONT_SENSOR_ID)
extern uint8_t front_sensor_id[S5K5E9_OTP_SENSOR_ID_SIZE + 1];
#endif

uint8_t *map_data = NULL;
static struct msm_camera_i2c_reg_array sr544_init_reg[] = {
{0x0118, 0x0000}, //sleep On

//--- SRAM timing control---//
{0x0E00, 0x0101},
{0x0E02, 0x0101},
{0x0E04, 0x0101},
{0x0E06, 0x0101},
{0x0E08, 0x0101},
{0x0E0A, 0x0101},
{0x0E0C, 0x0101},
{0x0E0E, 0x0101},

//Firmware 2Lane v0.39, LB OTP Burst On + double luma under dark. FW 20140804
{0x2000, 0x4031},
{0x2002, 0x83F8},
{0x2004, 0x4104},
{0x2006, 0x4307},
{0x2008, 0x4382},
{0x200a, 0x80D0},
{0x200c, 0x4382},
{0x200e, 0x8070},
{0x2010, 0x43A2},
{0x2012, 0x0B80},
{0x2014, 0x0C0A},
{0x2016, 0x4382},
{0x2018, 0x0B90},
{0x201a, 0x0C0A},
{0x201c, 0x4382},
{0x201e, 0x0B9C},
{0x2020, 0x0C0A},
{0x2022, 0x93D2},
{0x2024, 0x003D},
{0x2026, 0x2002},
{0x2028, 0x4030},
{0x202a, 0xF6C0},
{0x202c, 0x43C2},
{0x202e, 0x0F82},
{0x2030, 0x425F},
{0x2032, 0x0118},
{0x2034, 0xF37F},
{0x2036, 0x930F},
{0x2038, 0x2002},
{0x203a, 0x0CC8},
{0x203c, 0x3FF9},
{0x203e, 0x4F82},
{0x2040, 0x809A},
{0x2042, 0x43D2},
{0x2044, 0x0A80},
{0x2046, 0x43D2},
{0x2048, 0x0180},
{0x204a, 0x43D2},
{0x204c, 0x019A},
{0x204e, 0x40F2},
{0x2050, 0x0009},
{0x2052, 0x019B},
{0x2054, 0x12B0},
{0x2056, 0xFE26},
{0x2058, 0x4382},
{0x205a, 0x8094},
{0x205c, 0x93D2},
{0x205e, 0x003E},
{0x2060, 0x2002},
{0x2062, 0x4030},
{0x2064, 0xF5A0},
{0x2066, 0x4308},
{0x2068, 0x5038},
{0x206a, 0x0030},
{0x206c, 0x480F},
{0x206e, 0x12B0},
{0x2070, 0xFE38},
{0x2072, 0x403B},
{0x2074, 0x7606},
{0x2076, 0x4B29},
{0x2078, 0x5318},
{0x207a, 0x480F},
{0x207c, 0x12B0},
{0x207e, 0xFE38},
{0x2080, 0x4B2A},
{0x2082, 0x5318},
{0x2084, 0x480F},
{0x2086, 0x12B0},
{0x2088, 0xFE38},
{0x208a, 0x4A0D},
{0x208c, 0xF03D},
{0x208e, 0x000F},
{0x2090, 0x108D},
{0x2092, 0x4B2E},
{0x2094, 0x5E0E},
{0x2096, 0x5E0E},
{0x2098, 0x5E0E},
{0x209a, 0x5E0E},
{0x209c, 0x4A0F},
{0x209e, 0xC312},
{0x20a0, 0x100F},
{0x20a2, 0x110F},
{0x20a4, 0x110F},
{0x20a6, 0x110F},
{0x20a8, 0x590D},
{0x20aa, 0x4D87},
{0x20ac, 0x5000},
{0x20ae, 0x5F0E},
{0x20b0, 0x4E87},
{0x20b2, 0x6000},
{0x20b4, 0x5327},
{0x20b6, 0x5038},
{0x20b8, 0xFFD1},
{0x20ba, 0x9038},
{0x20bc, 0x0300},
{0x20be, 0x2BD4},
{0x20c0, 0x0261},
{0x20c2, 0x0000},
{0x20c4, 0x43A2},
{0x20c6, 0x0384},
{0x20c8, 0x42B2},
{0x20ca, 0x0386},
{0x20cc, 0x43C2},
{0x20ce, 0x0180},
{0x20d0, 0x43D2},
{0x20d2, 0x003D},
{0x20d4, 0x40B2},
{0x20d6, 0x808B},
{0x20d8, 0x0B88},
{0x20da, 0x0C0A},
{0x20dc, 0x40B2},
{0x20de, 0x1009},
{0x20e0, 0x0B8A},
{0x20e2, 0x0C0A},
{0x20e4, 0x40B2},
{0x20e6, 0xC40C},
{0x20e8, 0x0B8C},
{0x20ea, 0x0C0A},
{0x20ec, 0x40B2},
{0x20ee, 0xC9E1},
{0x20f0, 0x0B8E},
{0x20f2, 0x0C0A},
{0x20f4, 0x40B2},
{0x20f6, 0x0C1E},
{0x20f8, 0x0B92},
{0x20fa, 0x0C0A},
{0x20fc, 0x43D2},
{0x20fe, 0x0F82},
{0x2100, 0x0C3C},
{0x2102, 0x0C3C},
{0x2104, 0x0C3C},
{0x2106, 0x0C3C},
{0x2108, 0x421F},
{0x210a, 0x00A6},
{0x210c, 0x503F},
{0x210e, 0x07D0},
{0x2110, 0x3811},
{0x2112, 0x4F82},
{0x2114, 0x7100},
{0x2116, 0x0004},
{0x2118, 0x0C0D},
{0x211a, 0x0005},
{0x211c, 0x0C04},
{0x211e, 0x000D},
{0x2120, 0x0C09},
{0x2122, 0x003D},
{0x2124, 0x0C1D},
{0x2126, 0x003C},
{0x2128, 0x0C13},
{0x212a, 0x0004},
{0x212c, 0x0C09},
{0x212e, 0x0004},
{0x2130, 0x533F},
{0x2132, 0x37EF},
{0x2134, 0x4392},
{0x2136, 0x8096},
{0x2138, 0x4382},
{0x213a, 0x809E},
{0x213c, 0x4382},
{0x213e, 0x80B6},
{0x2140, 0x4382},
{0x2142, 0x80BE},
{0x2144, 0x4382},
{0x2146, 0x80A2},
{0x2148, 0x40B2},
{0x214a, 0x0028},
{0x214c, 0x7000},
{0x214e, 0x43A2},
{0x2150, 0x80A0},
{0x2152, 0xB3E2},
{0x2154, 0x00B4},
{0x2156, 0x2402},
{0x2158, 0x4392},
{0x215a, 0x80A0},
{0x215c, 0x4326},
{0x215e, 0xB3D2},
{0x2160, 0x00B4},
{0x2162, 0x2002},
{0x2164, 0x4030},
{0x2166, 0xF590},
{0x2168, 0x4306},
{0x216a, 0x4384},
{0x216c, 0x0002},
{0x216e, 0x4384},
{0x2170, 0x0006},
{0x2172, 0x4382},
{0x2174, 0x809C},
{0x2176, 0x4382},
{0x2178, 0x8098},
{0x217a, 0x40B2},
{0x217c, 0x0005},
{0x217e, 0x7320},
{0x2180, 0x4392},
{0x2182, 0x7326},
{0x2184, 0x12B0},
{0x2186, 0xF952},
{0x2188, 0x4392},
{0x218a, 0x731C},
{0x218c, 0x9382},
{0x218e, 0x8096},
{0x2190, 0x200A},
{0x2192, 0x0B00},
{0x2194, 0x7302},
{0x2196, 0x02BC},
{0x2198, 0x4382},
{0x219a, 0x7004},
{0x219c, 0x430F},
{0x219e, 0x12B0},
{0x21a0, 0xF752},
{0x21a2, 0x12B0},
{0x21a4, 0xF952},
{0x21a6, 0x4392},
{0x21a8, 0x80BC},
{0x21aa, 0x4382},
{0x21ac, 0x740E},
{0x21ae, 0xB3E2},
{0x21b0, 0x0080},
{0x21b2, 0x2402},
{0x21b4, 0x4392},
{0x21b6, 0x740E},
{0x21b8, 0x431F},
{0x21ba, 0x12B0},
{0x21bc, 0xF752},
{0x21be, 0x4392},
{0x21c0, 0x7004},
{0x21c2, 0x4682},
{0x21c4, 0x7110},
{0x21c6, 0x9382},
{0x21c8, 0x8092},
{0x21ca, 0x2005},
{0x21cc, 0x9392},
{0x21ce, 0x7110},
{0x21d0, 0x2402},
{0x21d2, 0x4030},
{0x21d4, 0xF494},
{0x21d6, 0x9392},
{0x21d8, 0x7110},
{0x21da, 0x20A4},
{0x21dc, 0x0B00},
{0x21de, 0x7302},
{0x21e0, 0x0032},
{0x21e2, 0x4382},
{0x21e4, 0x7004},
{0x21e6, 0x0B00},
{0x21e8, 0x7302},
{0x21ea, 0x03E8},
{0x21ec, 0x0800},
{0x21ee, 0x7114},
{0x21f0, 0x425F},
{0x21f2, 0x0C9C},
{0x21f4, 0x4F4E},
{0x21f6, 0x430F},
{0x21f8, 0x4E0D},
{0x21fa, 0x430C},
{0x21fc, 0x421F},
{0x21fe, 0x0C9A},
{0x2200, 0xDF0C},
{0x2202, 0x1204},
{0x2204, 0x440F},
{0x2206, 0x532F},
{0x2208, 0x120F},
{0x220a, 0x1212},
{0x220c, 0x0CA2},
{0x220e, 0x403E},
{0x2210, 0x80C0},
{0x2212, 0x403F},
{0x2214, 0x8072},
{0x2216, 0x12B0},
{0x2218, 0xF7BA},
{0x221a, 0x4F07},
{0x221c, 0x425F},
{0x221e, 0x0CA0},
{0x2220, 0x4F4E},
{0x2222, 0x430F},
{0x2224, 0x4E0D},
{0x2226, 0x430C},
{0x2228, 0x421F},
{0x222a, 0x0C9E},
{0x222c, 0xDF0C},
{0x222e, 0x440F},
{0x2230, 0x522F},
{0x2232, 0x120F},
{0x2234, 0x532F},
{0x2236, 0x120F},
{0x2238, 0x1212},
{0x223a, 0x0CA4},
{0x223c, 0x403E},
{0x223e, 0x80A4},
{0x2240, 0x403F},
{0x2242, 0x8050},
{0x2244, 0x12B0},
{0x2246, 0xF7BA},
{0x2248, 0x4F08},
{0x224a, 0x430D},
{0x224c, 0x441E},
{0x224e, 0x0004},
{0x2250, 0x442F},
{0x2252, 0x5031},
{0x2254, 0x000C},
{0x2256, 0x9E0F},
{0x2258, 0x2C01},
{0x225a, 0x431D},
{0x225c, 0x8E0F},
{0x225e, 0x930F},
{0x2260, 0x3402},
{0x2262, 0xE33F},
{0x2264, 0x531F},
{0x2266, 0x421E},
{0x2268, 0x0CA2},
{0x226a, 0xC312},
{0x226c, 0x100E},
{0x226e, 0x9E0F},
{0x2270, 0x2804},
{0x2272, 0x930D},
{0x2274, 0x2001},
{0x2276, 0x5317},
{0x2278, 0x5D08},
{0x227a, 0x403B},
{0x227c, 0x0196},
{0x227e, 0x403D},
{0x2280, 0x0040},
{0x2282, 0x4D0F},
{0x2284, 0x8B2F},
{0x2286, 0x470A},
{0x2288, 0x4F0C},
{0x228a, 0x12B0},
{0x228c, 0xFE58},
{0x228e, 0x4E09},
{0x2290, 0xC312},
{0x2292, 0x1009},
{0x2294, 0x1109},
{0x2296, 0x1109},
{0x2298, 0x1109},
{0x229a, 0x1109},
{0x229c, 0x1109},
{0x229e, 0x4D0F},
{0x22a0, 0x8B2F},
{0x22a2, 0x480A},
{0x22a4, 0x4F0C},
{0x22a6, 0x12B0},
{0x22a8, 0xFE58},
{0x22aa, 0x4E0F},
{0x22ac, 0xC312},
{0x22ae, 0x100F},
{0x22b0, 0x110F},
{0x22b2, 0x110F},
{0x22b4, 0x110F},
{0x22b6, 0x110F},
{0x22b8, 0x110F},
{0x22ba, 0x5F09},
{0x22bc, 0xC312},
{0x22be, 0x1009},
{0x22c0, 0x92B2},
{0x22c2, 0x80BE},
{0x22c4, 0x280C},
{0x22c6, 0x90B2},
{0x22c8, 0x0096},
{0x22ca, 0x80B6},
{0x22cc, 0x2408},
{0x22ce, 0x0900},
{0x22d0, 0x710E},
{0x22d2, 0x0B00},
{0x22d4, 0x7302},
{0x22d6, 0x0320},
{0x22d8, 0x12B0},
{0x22da, 0xF6F2},
{0x22dc, 0x3F74},
{0x22de, 0x470A},
{0x22e0, 0x580A},
{0x22e2, 0xC312},
{0x22e4, 0x100A},
{0x22e6, 0x890A},
{0x22e8, 0xB3E2},
{0x22ea, 0x0C81},
{0x22ec, 0x2418},
{0x22ee, 0x425F},
{0x22f0, 0x0C92},
{0x22f2, 0xF37F},
{0x22f4, 0x9F0A},
{0x22f6, 0x280E},
{0x22f8, 0x425F},
{0x22fa, 0x0C92},
{0x22fc, 0xF37F},
{0x22fe, 0x4A0E},
{0x2300, 0x8F0E},
{0x2302, 0x4E82},
{0x2304, 0x0CAC},
{0x2306, 0x425F},
{0x2308, 0x0C92},
{0x230a, 0xF37F},
{0x230c, 0x8F0A},
{0x230e, 0x4A82},
{0x2310, 0x0CAE},
{0x2312, 0x3FDD},
{0x2314, 0x4382},
{0x2316, 0x0CAC},
{0x2318, 0x4382},
{0x231a, 0x0CAE},
{0x231c, 0x3FD8},
{0x231e, 0x4A82},
{0x2320, 0x0CAC},
{0x2322, 0x3FF5},
{0x2324, 0x0B00},
{0x2326, 0x7302},
{0x2328, 0x0002},
{0x232a, 0x069A},
{0x232c, 0x0C1F},
{0x232e, 0x0403},
{0x2330, 0x0C05},
{0x2332, 0x0001},
{0x2334, 0x0C01},
{0x2336, 0x0003},
{0x2338, 0x0C03},
{0x233a, 0x000B},
{0x233c, 0x0C33},
{0x233e, 0x0003},
{0x2340, 0x0C03},
{0x2342, 0x0653},
{0x2344, 0x0C03},
{0x2346, 0x065B},
{0x2348, 0x0C13},
{0x234a, 0x065F},
{0x234c, 0x0C43},
{0x234e, 0x0657},
{0x2350, 0x0C03},
{0x2352, 0x0653},
{0x2354, 0x0C03},
{0x2356, 0x0643},
{0x2358, 0x0C0F},
{0x235a, 0x067D},
{0x235c, 0x0C01},
{0x235e, 0x077F},
{0x2360, 0x0C01},
{0x2362, 0x0677},
{0x2364, 0x0C01},
{0x2366, 0x0673},
{0x2368, 0x0C67},
{0x236a, 0x0677},
{0x236c, 0x0C03},
{0x236e, 0x077D},
{0x2370, 0x0C19},
{0x2372, 0x0013},
{0x2374, 0x0C27},
{0x2376, 0x0003},
{0x2378, 0x0C45},
{0x237a, 0x0675},
{0x237c, 0x0C01},
{0x237e, 0x0671},
{0x2380, 0x4392},
{0x2382, 0x7004},
{0x2384, 0x430F},
{0x2386, 0x9382},
{0x2388, 0x80BC},
{0x238a, 0x2001},
{0x238c, 0x431F},
{0x238e, 0x4F82},
{0x2390, 0x80BC},
{0x2392, 0x930F},
{0x2394, 0x2473},
{0x2396, 0x0B00},
{0x2398, 0x7302},
{0x239a, 0x033A},
{0x239c, 0x0675},
{0x239e, 0x0C02},
{0x23a0, 0x0339},
{0x23a2, 0xAE0C},
{0x23a4, 0x0C01},
{0x23a6, 0x003C},
{0x23a8, 0x0C01},
{0x23aa, 0x0004},
{0x23ac, 0x0C01},
{0x23ae, 0x0642},
{0x23b0, 0x0B00},
{0x23b2, 0x7302},
{0x23b4, 0x0386},
{0x23b6, 0x0643},
{0x23b8, 0x0C05},
{0x23ba, 0x0001},
{0x23bc, 0x0C01},
{0x23be, 0x0003},
{0x23c0, 0x0C03},
{0x23c2, 0x000B},
{0x23c4, 0x0C33},
{0x23c6, 0x0003},
{0x23c8, 0x0C03},
{0x23ca, 0x0653},
{0x23cc, 0x0C03},
{0x23ce, 0x065B},
{0x23d0, 0x0C13},
{0x23d2, 0x065F},
{0x23d4, 0x0C43},
{0x23d6, 0x0657},
{0x23d8, 0x0C03},
{0x23da, 0x0653},
{0x23dc, 0x0C03},
{0x23de, 0x0643},
{0x23e0, 0x0C0F},
{0x23e2, 0x067D},
{0x23e4, 0x0C01},
{0x23e6, 0x077F},
{0x23e8, 0x0C01},
{0x23ea, 0x0677},
{0x23ec, 0x0C01},
{0x23ee, 0x0673},
{0x23f0, 0x0C67},
{0x23f2, 0x0677},
{0x23f4, 0x0C03},
{0x23f6, 0x077D},
{0x23f8, 0x0C19},
{0x23fa, 0x0013},
{0x23fc, 0x0C27},
{0x23fe, 0x0003},
{0x2400, 0x0C45},
{0x2402, 0x0675},
{0x2404, 0x0C01},
{0x2406, 0x0671},
{0x2408, 0x12B0},
{0x240a, 0xF6F2},
{0x240c, 0x930F},
{0x240e, 0x2405},
{0x2410, 0x4292},
{0x2412, 0x8096},
{0x2414, 0x809E},
{0x2416, 0x4382},
{0x2418, 0x8096},
{0x241a, 0x9382},
{0x241c, 0x80BC},
{0x241e, 0x241E},
{0x2420, 0x0B00},
{0x2422, 0x7302},
{0x2424, 0x069E},
{0x2426, 0x0675},
{0x2428, 0x0C02},
{0x242a, 0x0339},
{0x242c, 0xAE0C},
{0x242e, 0x0C01},
{0x2430, 0x003C},
{0x2432, 0x0C01},
{0x2434, 0x0004},
{0x2436, 0x0C01},
{0x2438, 0x0642},
{0x243a, 0x0C01},
{0x243c, 0x06A1},
{0x243e, 0x0C03},
{0x2440, 0x06A0},
{0x2442, 0x9382},
{0x2444, 0x80D0},
{0x2446, 0x2004},
{0x2448, 0x930F},
{0x244a, 0x26BD},
{0x244c, 0x4030},
{0x244e, 0xF18C},
{0x2450, 0x43C2},
{0x2452, 0x0A80},
{0x2454, 0x0B00},
{0x2456, 0x7302},
{0x2458, 0xFFF0},
{0x245a, 0x3EB5},
{0x245c, 0x0B00},
{0x245e, 0x7302},
{0x2460, 0x069E},
{0x2462, 0x0675},
{0x2464, 0x0C02},
{0x2466, 0x0301},
{0x2468, 0xAE0C},
{0x246a, 0x0C01},
{0x246c, 0x0004},
{0x246e, 0x0C03},
{0x2470, 0x0642},
{0x2472, 0x0C01},
{0x2474, 0x06A1},
{0x2476, 0x0C03},
{0x2478, 0x06A0},
{0x247a, 0x3FE3},
{0x247c, 0x0B00},
{0x247e, 0x7302},
{0x2480, 0x033A},
{0x2482, 0x0675},
{0x2484, 0x0C02},
{0x2486, 0x0301},
{0x2488, 0xAE0C},
{0x248a, 0x0C01},
{0x248c, 0x0004},
{0x248e, 0x0C03},
{0x2490, 0x0642},
{0x2492, 0x3F8E},
{0x2494, 0x0B00},
{0x2496, 0x7302},
{0x2498, 0x0002},
{0x249a, 0x069A},
{0x249c, 0x0C1F},
{0x249e, 0x0402},
{0x24a0, 0x0C05},
{0x24a2, 0x0001},
{0x24a4, 0x0C01},
{0x24a6, 0x0003},
{0x24a8, 0x0C03},
{0x24aa, 0x000B},
{0x24ac, 0x0C33},
{0x24ae, 0x0003},
{0x24b0, 0x0C03},
{0x24b2, 0x0653},
{0x24b4, 0x0C03},
{0x24b6, 0x065B},
{0x24b8, 0x0C13},
{0x24ba, 0x065F},
{0x24bc, 0x0C43},
{0x24be, 0x0657},
{0x24c0, 0x0C03},
{0x24c2, 0x0653},
{0x24c4, 0x0C03},
{0x24c6, 0x0643},
{0x24c8, 0x0C0F},
{0x24ca, 0x077D},
{0x24cc, 0x0C01},
{0x24ce, 0x067F},
{0x24d0, 0x0C01},
{0x24d2, 0x0677},
{0x24d4, 0x0C01},
{0x24d6, 0x0673},
{0x24d8, 0x0C5F},
{0x24da, 0x0663},
{0x24dc, 0x0C6F},
{0x24de, 0x0667},
{0x24e0, 0x0C01},
{0x24e2, 0x0677},
{0x24e4, 0x0C01},
{0x24e6, 0x077D},
{0x24e8, 0x0C33},
{0x24ea, 0x0013},
{0x24ec, 0x0C27},
{0x24ee, 0x0003},
{0x24f0, 0x0C4F},
{0x24f2, 0x0675},
{0x24f4, 0x0C01},
{0x24f6, 0x0671},
{0x24f8, 0x0CFF},
{0x24fa, 0x0C78},
{0x24fc, 0x0661},
{0x24fe, 0x4392},
{0x2500, 0x7004},
{0x2502, 0x430F},
{0x2504, 0x9382},
{0x2506, 0x80BC},
{0x2508, 0x2001},
{0x250a, 0x431F},
{0x250c, 0x4F82},
{0x250e, 0x80BC},
{0x2510, 0x12B0},
{0x2512, 0xF6F2},
{0x2514, 0x930F},
{0x2516, 0x2405},
{0x2518, 0x4292},
{0x251a, 0x8096},
{0x251c, 0x809E},
{0x251e, 0x4382},
{0x2520, 0x8096},
{0x2522, 0x9382},
{0x2524, 0x80BC},
{0x2526, 0x2019},
{0x2528, 0x0B00},
{0x252a, 0x7302},
{0x252c, 0x0562},
{0x252e, 0x0665},
{0x2530, 0x0C02},
{0x2532, 0x0301},
{0x2534, 0xA60C},
{0x2536, 0x0204},
{0x2538, 0xAE0C},
{0x253a, 0x0C03},
{0x253c, 0x0642},
{0x253e, 0x0C13},
{0x2540, 0x06A1},
{0x2542, 0x0C03},
{0x2544, 0x06A0},
{0x2546, 0x9382},
{0x2548, 0x80D0},
{0x254a, 0x277E},
{0x254c, 0x43C2},
{0x254e, 0x0A80},
{0x2550, 0x0B00},
{0x2552, 0x7302},
{0x2554, 0xFFF0},
{0x2556, 0x4030},
{0x2558, 0xF1C6},
{0x255a, 0x0B00},
{0x255c, 0x7302},
{0x255e, 0x0562},
{0x2560, 0x0665},
{0x2562, 0x0C02},
{0x2564, 0x0339},
{0x2566, 0xA60C},
{0x2568, 0x023C},
{0x256a, 0xAE0C},
{0x256c, 0x0C01},
{0x256e, 0x0004},
{0x2570, 0x0C01},
{0x2572, 0x0642},
{0x2574, 0x0C13},
{0x2576, 0x06A1},
{0x2578, 0x0C03},
{0x257a, 0x06A0},
{0x257c, 0x9382},
{0x257e, 0x80D0},
{0x2580, 0x2763},
{0x2582, 0x43C2},
{0x2584, 0x0A80},
{0x2586, 0x0B00},
{0x2588, 0x7302},
{0x258a, 0xFFF0},
{0x258c, 0x4030},
{0x258e, 0xF1C6},
{0x2590, 0xB3E2},
{0x2592, 0x00B4},
{0x2594, 0x2002},
{0x2596, 0x4030},
{0x2598, 0xF16A},
{0x259a, 0x4316},
{0x259c, 0x4030},
{0x259e, 0xF16A},
{0x25a0, 0x4392},
{0x25a2, 0x760E},
{0x25a4, 0x425F},
{0x25a6, 0x0118},
{0x25a8, 0xF37F},
{0x25aa, 0x930F},
{0x25ac, 0x2005},
{0x25ae, 0x43C2},
{0x25b0, 0x0A80},
{0x25b2, 0x0B00},
{0x25b4, 0x7302},
{0x25b6, 0xFFF0},
{0x25b8, 0x9382},
{0x25ba, 0x760C},
{0x25bc, 0x2002},
{0x25be, 0x0C64},
{0x25c0, 0x3FF1},
{0x25c2, 0x4F82},
{0x25c4, 0x809A},
{0x25c6, 0x421F},
{0x25c8, 0x760A},
{0x25ca, 0x932F},
{0x25cc, 0x2013},
{0x25ce, 0x4292},
{0x25d0, 0x018A},
{0x25d2, 0x80B8},
{0x25d4, 0x12B0},
{0x25d6, 0xFE26},
{0x25d8, 0x40B2},
{0x25da, 0x0005},
{0x25dc, 0x7600},
{0x25de, 0x4382},
{0x25e0, 0x7602},
{0x25e2, 0x0262},
{0x25e4, 0x0000},
{0x25e6, 0x0222},
{0x25e8, 0x0000},
{0x25ea, 0x0262},
{0x25ec, 0x0000},
{0x25ee, 0x0260},
{0x25f0, 0x0000},
{0x25f2, 0x3FD6},
{0x25f4, 0x903F},
{0x25f6, 0x0003},
{0x25f8, 0x285B},
{0x25fa, 0x903F},
{0x25fc, 0x0102},
{0x25fe, 0x204E},
{0x2600, 0x425F},
{0x2602, 0x0186},
{0x2604, 0x4F4C},
{0x2606, 0x93D2},
{0x2608, 0x018F},
{0x260a, 0x2446},
{0x260c, 0x425F},
{0x260e, 0x018F},
{0x2610, 0x4F4D},
{0x2612, 0x4308},
{0x2614, 0x421B},
{0x2616, 0x80B8},
{0x2618, 0x431F},
{0x261a, 0x480E},
{0x261c, 0x930E},
{0x261e, 0x2403},
{0x2620, 0x5F0F},
{0x2622, 0x831E},
{0x2624, 0x23FD},
{0x2626, 0xFC0F},
{0x2628, 0x242F},
{0x262a, 0x430F},
{0x262c, 0x9D0F},
{0x262e, 0x2C2C},
{0x2630, 0x4B0E},
{0x2632, 0x4E82},
{0x2634, 0x7600},
{0x2636, 0x4882},
{0x2638, 0x7602},
{0x263a, 0x4C82},
{0x263c, 0x7604},
{0x263e, 0x0264},
{0x2640, 0x0000},
{0x2642, 0x0224},
{0x2644, 0x0000},
{0x2646, 0x0264},
{0x2648, 0x0000},
{0x264a, 0x0260},
{0x264c, 0x0000},
{0x264e, 0x0268},
{0x2650, 0x0000},
{0x2652, 0x0C18},
{0x2654, 0x02E8},
{0x2656, 0x0000},
{0x2658, 0x0C30},
{0x265a, 0x02A8},
{0x265c, 0x0000},
{0x265e, 0x0C30},
{0x2660, 0x0C30},
{0x2662, 0x0C30},
{0x2664, 0x0C30},
{0x2666, 0x0C30},
{0x2668, 0x0C30},
{0x266a, 0x0C30},
{0x266c, 0x0C30},
{0x266e, 0x0C00},
{0x2670, 0x02E8},
{0x2672, 0x0000},
{0x2674, 0x0C30},
{0x2676, 0x0268},
{0x2678, 0x0000},
{0x267a, 0x0C18},
{0x267c, 0x0260},
{0x267e, 0x0000},
{0x2680, 0x0C18},
{0x2682, 0x531F},
{0x2684, 0x9D0F},
{0x2686, 0x2BD5},
{0x2688, 0x5318},
{0x268a, 0x9238},
{0x268c, 0x2BC5},
{0x268e, 0x0260},
{0x2690, 0x0000},
{0x2692, 0x5392},
{0x2694, 0x80B8},
{0x2696, 0x3F84},
{0x2698, 0x432D},
{0x269a, 0x3FBB},
{0x269c, 0x903F},
{0x269e, 0x0201},
{0x26a0, 0x237F},
{0x26a2, 0x5392},
{0x26a4, 0x80B8},
{0x26a6, 0x421F},
{0x26a8, 0x80B8},
{0x26aa, 0x12B0},
{0x26ac, 0xFE38},
{0x26ae, 0x3F78},
{0x26b0, 0x931F},
{0x26b2, 0x2376},
{0x26b4, 0x12B0},
{0x26b6, 0xFE26},
{0x26b8, 0x4292},
{0x26ba, 0x018A},
{0x26bc, 0x80B8},
{0x26be, 0x3FF3},
{0x26c0, 0x4382},
{0x26c2, 0x0B88},
{0x26c4, 0x0C0A},
{0x26c6, 0x4382},
{0x26c8, 0x0B8A},
{0x26ca, 0x0C0A},
{0x26cc, 0x40B2},
{0x26ce, 0x000C},
{0x26d0, 0x0B8C},
{0x26d2, 0x0C0A},
{0x26d4, 0x40B2},
{0x26d6, 0xB5E1},
{0x26d8, 0x0B8E},
{0x26da, 0x0C0A},
{0x26dc, 0x40B2},
{0x26de, 0x641C},
{0x26e0, 0x0B92},
{0x26e2, 0x0C0A},
{0x26e4, 0x43C2},
{0x26e6, 0x003D},
{0x26e8, 0x4030},
{0x26ea, 0xF02C},
{0x26ec, 0x5231},
{0x26ee, 0x4030},
{0x26f0, 0xFE54},
{0x26f2, 0xE3B2},
{0x26f4, 0x740E},
{0x26f6, 0x425F},
{0x26f8, 0x0118},
{0x26fa, 0xF37F},
{0x26fc, 0x4F82},
{0x26fe, 0x809A},
{0x2700, 0x930F},
{0x2702, 0x2005},
{0x2704, 0x93C2},
{0x2706, 0x0A82},
{0x2708, 0x2402},
{0x270a, 0x4392},
{0x270c, 0x80D0},
{0x270e, 0x9382},
{0x2710, 0x809A},
{0x2712, 0x2002},
{0x2714, 0x4392},
{0x2716, 0x8070},
{0x2718, 0x421F},
{0x271a, 0x710E},
{0x271c, 0x93A2},
{0x271e, 0x7110},
{0x2720, 0x2411},
{0x2722, 0x9382},
{0x2724, 0x710E},
{0x2726, 0x240C},
{0x2728, 0x5292},
{0x272a, 0x80A0},
{0x272c, 0x7110},
{0x272e, 0x4382},
{0x2730, 0x740E},
{0x2732, 0x9382},
{0x2734, 0x80BA},
{0x2736, 0x2402},
{0x2738, 0x4392},
{0x273a, 0x740E},
{0x273c, 0x4392},
{0x273e, 0x80BC},
{0x2740, 0x430F},
{0x2742, 0x4130},
{0x2744, 0xF31F},
{0x2746, 0x27ED},
{0x2748, 0x40B2},
{0x274a, 0x0003},
{0x274c, 0x7110},
{0x274e, 0x431F},
{0x2750, 0x4130},
{0x2752, 0x4F0E},
{0x2754, 0x421D},
{0x2756, 0x8070},
{0x2758, 0x425F},
{0x275a, 0x0118},
{0x275c, 0xF37F},
{0x275e, 0x903E},
{0x2760, 0x0003},
{0x2762, 0x2405},
{0x2764, 0x931E},
{0x2766, 0x2403},
{0x2768, 0x0B00},
{0x276a, 0x7302},
{0x276c, 0x0384},
{0x276e, 0x930F},
{0x2770, 0x241A},
{0x2772, 0x930D},
{0x2774, 0x2018},
{0x2776, 0x9382},
{0x2778, 0x7308},
{0x277a, 0x2402},
{0x277c, 0x930E},
{0x277e, 0x2419},
{0x2780, 0x9382},
{0x2782, 0x7328},
{0x2784, 0x2402},
{0x2786, 0x931E},
{0x2788, 0x2414},
{0x278a, 0x9382},
{0x278c, 0x710E},
{0x278e, 0x2402},
{0x2790, 0x932E},
{0x2792, 0x240F},
{0x2794, 0x9382},
{0x2796, 0x7114},
{0x2798, 0x2402},
{0x279a, 0x922E},
{0x279c, 0x240A},
{0x279e, 0x903E},
{0x27a0, 0x0003},
{0x27a2, 0x23DA},
{0x27a4, 0x3C06},
{0x27a6, 0x43C2},
{0x27a8, 0x0A80},
{0x27aa, 0x0B00},
{0x27ac, 0x7302},
{0x27ae, 0xFFF0},
{0x27b0, 0x3FD3},
{0x27b2, 0x4F82},
{0x27b4, 0x809A},
{0x27b6, 0x431F},
{0x27b8, 0x4130},
{0x27ba, 0x120B},
{0x27bc, 0x120A},
{0x27be, 0x1209},
{0x27c0, 0x1208},
{0x27c2, 0x1207},
{0x27c4, 0x1206},
{0x27c6, 0x1205},
{0x27c8, 0x1204},
{0x27ca, 0x8221},
{0x27cc, 0x403B},
{0x27ce, 0x0016},
{0x27d0, 0x510B},
{0x27d2, 0x4F08},
{0x27d4, 0x4E09},
{0x27d6, 0x4BA1},
{0x27d8, 0x0000},
{0x27da, 0x4B1A},
{0x27dc, 0x0002},
{0x27de, 0x4B91},
{0x27e0, 0x0004},
{0x27e2, 0x0002},
{0x27e4, 0x4304},
{0x27e6, 0x4305},
{0x27e8, 0x4306},
{0x27ea, 0x4307},
{0x27ec, 0x9382},
{0x27ee, 0x80B4},
{0x27f0, 0x2425},
{0x27f2, 0x438A},
{0x27f4, 0x0000},
{0x27f6, 0x430B},
{0x27f8, 0x4B0F},
{0x27fa, 0x5F0F},
{0x27fc, 0x5F0F},
{0x27fe, 0x580F},
{0x2800, 0x4C8F},
{0x2802, 0x0000},
{0x2804, 0x4D8F},
{0x2806, 0x0002},
{0x2808, 0x4B0F},
{0x280a, 0x5F0F},
{0x280c, 0x590F},
{0x280e, 0x41AF},
{0x2810, 0x0000},
{0x2812, 0x531B},
{0x2814, 0x923B},
{0x2816, 0x2BF0},
{0x2818, 0x430B},
{0x281a, 0x4B0F},
{0x281c, 0x5F0F},
{0x281e, 0x5F0F},
{0x2820, 0x580F},
{0x2822, 0x5F34},
{0x2824, 0x6F35},
{0x2826, 0x4B0F},
{0x2828, 0x5F0F},
{0x282a, 0x590F},
{0x282c, 0x4F2E},
{0x282e, 0x430F},
{0x2830, 0x5E06},
{0x2832, 0x6F07},
{0x2834, 0x531B},
{0x2836, 0x923B},
{0x2838, 0x2BF0},
{0x283a, 0x3C18},
{0x283c, 0x4A2E},
{0x283e, 0x4E0F},
{0x2840, 0x5F0F},
{0x2842, 0x5F0F},
{0x2844, 0x580F},
{0x2846, 0x4C8F},
{0x2848, 0x0000},
{0x284a, 0x4D8F},
{0x284c, 0x0002},
{0x284e, 0x5E0E},
{0x2850, 0x590E},
{0x2852, 0x41AE},
{0x2854, 0x0000},
{0x2856, 0x4A2F},
{0x2858, 0x903F},
{0x285a, 0x0007},
{0x285c, 0x2404},
{0x285e, 0x531F},
{0x2860, 0x4F8A},
{0x2862, 0x0000},
{0x2864, 0x3FD9},
{0x2866, 0x438A},
{0x2868, 0x0000},
{0x286a, 0x3FD6},
{0x286c, 0x440C},
{0x286e, 0x450D},
{0x2870, 0x460A},
{0x2872, 0x470B},
{0x2874, 0x12B0},
{0x2876, 0xFEAA},
{0x2878, 0x4C08},
{0x287a, 0x4D09},
{0x287c, 0x4C0E},
{0x287e, 0x430F},
{0x2880, 0x4E0A},
{0x2882, 0x4F0B},
{0x2884, 0x460C},
{0x2886, 0x470D},
{0x2888, 0x12B0},
{0x288a, 0xFE6E},
{0x288c, 0x8E04},
{0x288e, 0x7F05},
{0x2890, 0x440E},
{0x2892, 0x450F},
{0x2894, 0xC312},
{0x2896, 0x100F},
{0x2898, 0x100E},
{0x289a, 0x110F},
{0x289c, 0x100E},
{0x289e, 0x110F},
{0x28a0, 0x100E},
{0x28a2, 0x411D},
{0x28a4, 0x0002},
{0x28a6, 0x4E8D},
{0x28a8, 0x0000},
{0x28aa, 0x480F},
{0x28ac, 0x5221},
{0x28ae, 0x4134},
{0x28b0, 0x4135},
{0x28b2, 0x4136},
{0x28b4, 0x4137},
{0x28b6, 0x4138},
{0x28b8, 0x4139},
{0x28ba, 0x413A},
{0x28bc, 0x413B},
{0x28be, 0x4130},
{0x28c0, 0x120A},
{0x28c2, 0x4F0D},
{0x28c4, 0x4E0C},
{0x28c6, 0x425F},
{0x28c8, 0x00BA},
{0x28ca, 0x4F4A},
{0x28cc, 0x503A},
{0x28ce, 0x0010},
{0x28d0, 0x931D},
{0x28d2, 0x242B},
{0x28d4, 0x932D},
{0x28d6, 0x2421},
{0x28d8, 0x903D},
{0x28da, 0x0003},
{0x28dc, 0x2418},
{0x28de, 0x922D},
{0x28e0, 0x2413},
{0x28e2, 0x903D},
{0x28e4, 0x0005},
{0x28e6, 0x2407},
{0x28e8, 0x903D},
{0x28ea, 0x0006},
{0x28ec, 0x2028},
{0x28ee, 0xC312},
{0x28f0, 0x100A},
{0x28f2, 0x110A},
{0x28f4, 0x3C24},
{0x28f6, 0x4A0E},
{0x28f8, 0xC312},
{0x28fa, 0x100E},
{0x28fc, 0x110E},
{0x28fe, 0x4E0F},
{0x2900, 0x110F},
{0x2902, 0x4E0A},
{0x2904, 0x5F0A},
{0x2906, 0x3C1B},
{0x2908, 0xC312},
{0x290a, 0x100A},
{0x290c, 0x3C18},
{0x290e, 0x4A0E},
{0x2910, 0xC312},
{0x2912, 0x100E},
{0x2914, 0x4E0F},
{0x2916, 0x110F},
{0x2918, 0x3FF3},
{0x291a, 0x4A0F},
{0x291c, 0xC312},
{0x291e, 0x100F},
{0x2920, 0x4F0E},
{0x2922, 0x110E},
{0x2924, 0x4F0A},
{0x2926, 0x5E0A},
{0x2928, 0x3C0A},
{0x292a, 0x4A0F},
{0x292c, 0xC312},
{0x292e, 0x100F},
{0x2930, 0x4F0E},
{0x2932, 0x110E},
{0x2934, 0x4F0A},
{0x2936, 0x5E0A},
{0x2938, 0x4E0F},
{0x293a, 0x110F},
{0x293c, 0x3FE3},
{0x293e, 0x12B0},
{0x2940, 0xFE58},
{0x2942, 0x4E0F},
{0x2944, 0xC312},
{0x2946, 0x100F},
{0x2948, 0x110F},
{0x294a, 0x110F},
{0x294c, 0x110F},
{0x294e, 0x413A},
{0x2950, 0x4130},
{0x2952, 0x120B},
{0x2954, 0x120A},
{0x2956, 0x1209},
{0x2958, 0x1208},
{0x295a, 0x425F},
{0x295c, 0x0080},
{0x295e, 0xF36F},
{0x2960, 0x4F0E},
{0x2962, 0xF32E},
{0x2964, 0x4E82},
{0x2966, 0x80BA},
{0x2968, 0xB3D2},
{0x296a, 0x0786},
{0x296c, 0x2402},
{0x296e, 0x4392},
{0x2970, 0x7002},
{0x2972, 0x4392},
{0x2974, 0x80BC},
{0x2976, 0x4382},
{0x2978, 0x740E},
{0x297a, 0x9382},
{0x297c, 0x80BA},
{0x297e, 0x2402},
{0x2980, 0x4392},
{0x2982, 0x740E},
{0x2984, 0x93C2},
{0x2986, 0x00C6},
{0x2988, 0x2406},
{0x298a, 0xB392},
{0x298c, 0x732A},
{0x298e, 0x2403},
{0x2990, 0xB3D2},
{0x2992, 0x00C7},
{0x2994, 0x2412},
{0x2996, 0x4292},
{0x2998, 0x01A8},
{0x299a, 0x0688},
{0x299c, 0x4292},
{0x299e, 0x01AA},
{0x29a0, 0x068A},
{0x29a2, 0x4292},
{0x29a4, 0x01AC},
{0x29a6, 0x068C},
{0x29a8, 0x4292},
{0x29aa, 0x01AE},
{0x29ac, 0x068E},
{0x29ae, 0x4292},
{0x29b0, 0x0190},
{0x29b2, 0x0A92},
{0x29b4, 0x4292},
{0x29b6, 0x0192},
{0x29b8, 0x0A94},
{0x29ba, 0x430E},
{0x29bc, 0x425F},
{0x29be, 0x00C7},
{0x29c0, 0xF35F},
{0x29c2, 0xF37F},
{0x29c4, 0xF21F},
{0x29c6, 0x732A},
{0x29c8, 0x200C},
{0x29ca, 0xB3D2},
{0x29cc, 0x00C7},
{0x29ce, 0x2003},
{0x29d0, 0xB392},
{0x29d2, 0x80A2},
{0x29d4, 0x2006},
{0x29d6, 0xB3A2},
{0x29d8, 0x732A},
{0x29da, 0x2003},
{0x29dc, 0x9382},
{0x29de, 0x8096},
{0x29e0, 0x2401},
{0x29e2, 0x431E},
{0x29e4, 0x4E82},
{0x29e6, 0x80B4},
{0x29e8, 0x930E},
{0x29ea, 0x2002},
{0x29ec, 0x4030},
{0x29ee, 0xFDE4},
{0x29f0, 0x4382},
{0x29f2, 0x80BE},
{0x29f4, 0x421F},
{0x29f6, 0x732A},
{0x29f8, 0xF31F},
{0x29fa, 0x4F82},
{0x29fc, 0x80A2},
{0x29fe, 0x425F},
{0x2a00, 0x008C},
{0x2a02, 0x4FC2},
{0x2a04, 0x8092},
{0x2a06, 0x43C2},
{0x2a08, 0x8093},
{0x2a0a, 0x425F},
{0x2a0c, 0x009E},
{0x2a0e, 0x4F48},
{0x2a10, 0x425F},
{0x2a12, 0x009F},
{0x2a14, 0xF37F},
{0x2a16, 0x5F08},
{0x2a18, 0x1108},
{0x2a1a, 0x1108},
{0x2a1c, 0x425F},
{0x2a1e, 0x00B2},
{0x2a20, 0x4F49},
{0x2a22, 0x425F},
{0x2a24, 0x00B3},
{0x2a26, 0xF37F},
{0x2a28, 0x5F09},
{0x2a2a, 0x1109},
{0x2a2c, 0x1109},
{0x2a2e, 0x425F},
{0x2a30, 0x00BA},
{0x2a32, 0x4F4C},
{0x2a34, 0x407A},
{0x2a36, 0x001C},
{0x2a38, 0x12B0},
{0x2a3a, 0xFE8E},
{0x2a3c, 0x934C},
{0x2a3e, 0x25BE},
{0x2a40, 0x403E},
{0x2a42, 0x0080},
{0x2a44, 0x4E0F},
{0x2a46, 0xF37F},
{0x2a48, 0x108F},
{0x2a4a, 0xD03F},
{0x2a4c, 0x008B},
{0x2a4e, 0x4F82},
{0x2a50, 0x0B88},
{0x2a52, 0x0C0A},
{0x2a54, 0x403C},
{0x2a56, 0x0813},
{0x2a58, 0x403D},
{0x2a5a, 0x007F},
{0x2a5c, 0x403F},
{0x2a5e, 0x00BA},
{0x2a60, 0x4F6E},
{0x2a62, 0x90FF},
{0x2a64, 0x0010},
{0x2a66, 0x0000},
{0x2a68, 0x2D13},
{0x2a6a, 0x403C},
{0x2a6c, 0x1005},
{0x2a6e, 0x430D},
{0x2a70, 0x425E},
{0x2a72, 0x00BA},
{0x2a74, 0x4E4F},
{0x2a76, 0x108F},
{0x2a78, 0xDD0F},
{0x2a7a, 0x4F82},
{0x2a7c, 0x0B90},
{0x2a7e, 0x0C0A},
{0x2a80, 0x4C82},
{0x2a82, 0x0B8A},
{0x2a84, 0x0C0A},
{0x2a86, 0x425F},
{0x2a88, 0x0C87},
{0x2a8a, 0x4F4E},
{0x2a8c, 0x425F},
{0x2a8e, 0x0C88},
{0x2a90, 0xF37F},
{0x2a92, 0x12B0},
{0x2a94, 0xF8C0},
{0x2a96, 0x4F82},
{0x2a98, 0x0C8C},
{0x2a9a, 0x425F},
{0x2a9c, 0x0C85},
{0x2a9e, 0x4F4E},
{0x2aa0, 0x425F},
{0x2aa2, 0x0C89},
{0x2aa4, 0xF37F},
{0x2aa6, 0x12B0},
{0x2aa8, 0xF8C0},
{0x2aaa, 0x4F82},
{0x2aac, 0x0C8A},
{0x2aae, 0x425E},
{0x2ab0, 0x00B7},
{0x2ab2, 0x5E4E},
{0x2ab4, 0x4EC2},
{0x2ab6, 0x0CB0},
{0x2ab8, 0x425F},
{0x2aba, 0x00B8},
{0x2abc, 0x5F4F},
{0x2abe, 0x4FC2},
{0x2ac0, 0x0CB1},
{0x2ac2, 0x480E},
{0x2ac4, 0x5E0E},
{0x2ac6, 0x5E0E},
{0x2ac8, 0x5E0E},
{0x2aca, 0x5E0E},
{0x2acc, 0x490F},
{0x2ace, 0x5F0F},
{0x2ad0, 0x5F0F},
{0x2ad2, 0x5F0F},
{0x2ad4, 0x5F0F},
{0x2ad6, 0x5F0F},
{0x2ad8, 0x5F0F},
{0x2ada, 0x5F0F},
{0x2adc, 0xDF0E},
{0x2ade, 0x4E82},
{0x2ae0, 0x0A8E},
{0x2ae2, 0xB229},
{0x2ae4, 0x2401},
{0x2ae6, 0x5339},
{0x2ae8, 0xB3E2},
{0x2aea, 0x0080},
{0x2aec, 0x2403},
{0x2aee, 0x40F2},
{0x2af0, 0x0003},
{0x2af2, 0x00B5},
{0x2af4, 0x40B2},
{0x2af6, 0x1000},
{0x2af8, 0x7500},
{0x2afa, 0x40B2},
{0x2afc, 0x1001},
{0x2afe, 0x7502},
{0x2b00, 0x40B2},
{0x2b02, 0x0803},
{0x2b04, 0x7504},
{0x2b06, 0x40B2},
{0x2b08, 0x080F},
{0x2b0a, 0x7506},
{0x2b0c, 0x40B2},
{0x2b0e, 0x6003},
{0x2b10, 0x7508},
{0x2b12, 0x40B2},
{0x2b14, 0x0801},
{0x2b16, 0x750A},
{0x2b18, 0x40B2},
{0x2b1a, 0x0800},
{0x2b1c, 0x750C},
{0x2b1e, 0x40B2},
{0x2b20, 0x1400},
{0x2b22, 0x750E},
{0x2b24, 0x403F},
{0x2b26, 0x0003},
{0x2b28, 0x12B0},
{0x2b2a, 0xF752},
{0x2b2c, 0x421F},
{0x2b2e, 0x0098},
{0x2b30, 0x821F},
{0x2b32, 0x0092},
{0x2b34, 0x531F},
{0x2b36, 0xC312},
{0x2b38, 0x100F},
{0x2b3a, 0x4F82},
{0x2b3c, 0x0A86},
{0x2b3e, 0x421F},
{0x2b40, 0x00AC},
{0x2b42, 0x821F},
{0x2b44, 0x00A6},
{0x2b46, 0x531F},
{0x2b48, 0x4F82},
{0x2b4a, 0x0A88},
{0x2b4c, 0xB0B2},
{0x2b4e, 0x0010},
{0x2b50, 0x0A84},
{0x2b52, 0x248F},
{0x2b54, 0x421E},
{0x2b56, 0x068C},
{0x2b58, 0xC312},
{0x2b5a, 0x100E},
{0x2b5c, 0x4E82},
{0x2b5e, 0x0782},
{0x2b60, 0x4292},
{0x2b62, 0x068E},
{0x2b64, 0x0784},
{0x2b66, 0xB3D2},
{0x2b68, 0x0CB6},
{0x2b6a, 0x2418},
{0x2b6c, 0x421A},
{0x2b6e, 0x0CB8},
{0x2b70, 0x430B},
{0x2b72, 0x425F},
{0x2b74, 0x0CBA},
{0x2b76, 0x4F4E},
{0x2b78, 0x430F},
{0x2b7a, 0x4E0F},
{0x2b7c, 0x430E},
{0x2b7e, 0xDE0A},
{0x2b80, 0xDF0B},
{0x2b82, 0x421F},
{0x2b84, 0x0CBC},
{0x2b86, 0x4F0C},
{0x2b88, 0x430D},
{0x2b8a, 0x421F},
{0x2b8c, 0x0CBE},
{0x2b8e, 0x430E},
{0x2b90, 0xDE0C},
{0x2b92, 0xDF0D},
{0x2b94, 0x12B0},
{0x2b96, 0xFEAA},
{0x2b98, 0x4C82},
{0x2b9a, 0x0194},
{0x2b9c, 0xB2A2},
{0x2b9e, 0x0A84},
{0x2ba0, 0x2412},
{0x2ba2, 0x421E},
{0x2ba4, 0x0A96},
{0x2ba6, 0xC312},
{0x2ba8, 0x100E},
{0x2baa, 0x110E},
{0x2bac, 0x110E},
{0x2bae, 0x43C2},
{0x2bb0, 0x0A98},
{0x2bb2, 0x431D},
{0x2bb4, 0x4E0F},
{0x2bb6, 0x9F82},
{0x2bb8, 0x0194},
{0x2bba, 0x2850},
{0x2bbc, 0x5E0F},
{0x2bbe, 0x531D},
{0x2bc0, 0x903D},
{0x2bc2, 0x0009},
{0x2bc4, 0x2BF8},
{0x2bc6, 0x4292},
{0x2bc8, 0x0084},
{0x2bca, 0x7524},
{0x2bcc, 0x4292},
{0x2bce, 0x0088},
{0x2bd0, 0x7316},
{0x2bd2, 0x9382},
{0x2bd4, 0x8092},
{0x2bd6, 0x2403},
{0x2bd8, 0x4292},
{0x2bda, 0x008A},
{0x2bdc, 0x7316},
{0x2bde, 0x430E},
{0x2be0, 0x421F},
{0x2be2, 0x0086},
{0x2be4, 0x822F},
{0x2be6, 0x9F82},
{0x2be8, 0x0084},
{0x2bea, 0x2801},
{0x2bec, 0x431E},
{0x2bee, 0x4292},
{0x2bf0, 0x0086},
{0x2bf2, 0x7314},
{0x2bf4, 0x93C2},
{0x2bf6, 0x00BC},
{0x2bf8, 0x2007},
{0x2bfa, 0xB31E},
{0x2bfc, 0x2405},
{0x2bfe, 0x421F},
{0x2c00, 0x0084},
{0x2c02, 0x522F},
{0x2c04, 0x4F82},
{0x2c06, 0x7314},
{0x2c08, 0x425F},
{0x2c0a, 0x00BC},
{0x2c0c, 0xF37F},
{0x2c0e, 0xFE0F},
{0x2c10, 0x2406},
{0x2c12, 0x421E},
{0x2c14, 0x0086},
{0x2c16, 0x503E},
{0x2c18, 0xFFFB},
{0x2c1a, 0x4E82},
{0x2c1c, 0x7524},
{0x2c1e, 0x430E},
{0x2c20, 0x421F},
{0x2c22, 0x7524},
{0x2c24, 0x9F82},
{0x2c26, 0x809C},
{0x2c28, 0x2C07},
{0x2c2a, 0x9382},
{0x2c2c, 0x8096},
{0x2c2e, 0x2004},
{0x2c30, 0x9382},
{0x2c32, 0x8098},
{0x2c34, 0x2001},
{0x2c36, 0x431E},
{0x2c38, 0x40B2},
{0x2c3a, 0x0032},
{0x2c3c, 0x7522},
{0x2c3e, 0x4292},
{0x2c40, 0x7524},
{0x2c42, 0x809C},
{0x2c44, 0x930E},
{0x2c46, 0x24E6},
{0x2c48, 0x421F},
{0x2c4a, 0x7316},
{0x2c4c, 0xC312},
{0x2c4e, 0x100F},
{0x2c50, 0x832F},
{0x2c52, 0x4F82},
{0x2c54, 0x7522},
{0x2c56, 0x53B2},
{0x2c58, 0x7524},
{0x2c5a, 0x3CDC},
{0x2c5c, 0x431F},
{0x2c5e, 0x4D0E},
{0x2c60, 0x533E},
{0x2c62, 0x930E},
{0x2c64, 0x2403},
{0x2c66, 0x5F0F},
{0x2c68, 0x831E},
{0x2c6a, 0x23FD},
{0x2c6c, 0x4FC2},
{0x2c6e, 0x0A98},
{0x2c70, 0x3FAA},
{0x2c72, 0x4292},
{0x2c74, 0x0A86},
{0x2c76, 0x0782},
{0x2c78, 0x421F},
{0x2c7a, 0x0A88},
{0x2c7c, 0x490E},
{0x2c7e, 0x930E},
{0x2c80, 0x2404},
{0x2c82, 0xC312},
{0x2c84, 0x100F},
{0x2c86, 0x831E},
{0x2c88, 0x23FC},
{0x2c8a, 0x4F82},
{0x2c8c, 0x0784},
{0x2c8e, 0x3F6B},
{0x2c90, 0x90F2},
{0x2c92, 0x0010},
{0x2c94, 0x00BA},
{0x2c96, 0x2809},
{0x2c98, 0x90F2},
{0x2c9a, 0x0031},
{0x2c9c, 0x00BA},
{0x2c9e, 0x2C05},
{0x2ca0, 0x403C},
{0x2ca2, 0x0E05},
{0x2ca4, 0x403D},
{0x2ca6, 0x003C},
{0x2ca8, 0x3EE3},
{0x2caa, 0x90F2},
{0x2cac, 0x0031},
{0x2cae, 0x00BA},
{0x2cb0, 0x280D},
{0x2cb2, 0x90F2},
{0x2cb4, 0x0039},
{0x2cb6, 0x00BA},
{0x2cb8, 0x2C09},
{0x2cba, 0x403C},
{0x2cbc, 0x0E09},
{0x2cbe, 0x403D},
{0x2cc0, 0x003C},
{0x2cc2, 0x425E},
{0x2cc4, 0x00BA},
{0x2cc6, 0x507E},
{0x2cc8, 0x0003},
{0x2cca, 0x3ED4},
{0x2ccc, 0x90F2},
{0x2cce, 0x0039},
{0x2cd0, 0x00BA},
{0x2cd2, 0x280D},
{0x2cd4, 0x90F2},
{0x2cd6, 0x0041},
{0x2cd8, 0x00BA},
{0x2cda, 0x2C09},
{0x2cdc, 0x403C},
{0x2cde, 0x0C0B},
{0x2ce0, 0x403D},
{0x2ce2, 0x003C},
{0x2ce4, 0x425E},
{0x2ce6, 0x00BA},
{0x2ce8, 0x507E},
{0x2cea, 0x0005},
{0x2cec, 0x3EC3},
{0x2cee, 0x90F2},
{0x2cf0, 0x0041},
{0x2cf2, 0x00BA},
{0x2cf4, 0x280D},
{0x2cf6, 0x90F2},
{0x2cf8, 0x0051},
{0x2cfa, 0x00BA},
{0x2cfc, 0x2C09},
{0x2cfe, 0x403C},
{0x2d00, 0x0A0F},
{0x2d02, 0x403D},
{0x2d04, 0x003C},
{0x2d06, 0x425E},
{0x2d08, 0x00BA},
{0x2d0a, 0x507E},
{0x2d0c, 0x0009},
{0x2d0e, 0x3EB2},
{0x2d10, 0x90F2},
{0x2d12, 0x0051},
{0x2d14, 0x00BA},
{0x2d16, 0x280D},
{0x2d18, 0x90F2},
{0x2d1a, 0x0061},
{0x2d1c, 0x00BA},
{0x2d1e, 0x2C09},
{0x2d20, 0x403C},
{0x2d22, 0x0A11},
{0x2d24, 0x403D},
{0x2d26, 0x003C},
{0x2d28, 0x425E},
{0x2d2a, 0x00BA},
{0x2d2c, 0x507E},
{0x2d2e, 0x000B},
{0x2d30, 0x3EA1},
{0x2d32, 0x90F2},
{0x2d34, 0x0061},
{0x2d36, 0x00BA},
{0x2d38, 0x2807},
{0x2d3a, 0x90F2},
{0x2d3c, 0x0075},
{0x2d3e, 0x00BA},
{0x2d40, 0x2C03},
{0x2d42, 0x403C},
{0x2d44, 0x0813},
{0x2d46, 0x3FF0},
{0x2d48, 0x90F2},
{0x2d4a, 0x0075},
{0x2d4c, 0x00BA},
{0x2d4e, 0x280B},
{0x2d50, 0x90F2},
{0x2d52, 0xFF91},
{0x2d54, 0x00BA},
{0x2d56, 0x2C07},
{0x2d58, 0x403C},
{0x2d5a, 0x0813},
{0x2d5c, 0x425E},
{0x2d5e, 0x00BA},
{0x2d60, 0x507E},
{0x2d62, 0x000C},
{0x2d64, 0x3E87},
{0x2d66, 0x90F2},
{0x2d68, 0xFF91},
{0x2d6a, 0x00BA},
{0x2d6c, 0x280B},
{0x2d6e, 0x90F2},
{0x2d70, 0xFFB1},
{0x2d72, 0x00BA},
{0x2d74, 0x2C07},
{0x2d76, 0x403D},
{0x2d78, 0x0060},
{0x2d7a, 0x425E},
{0x2d7c, 0x00BA},
{0x2d7e, 0x507E},
{0x2d80, 0x000D},
{0x2d82, 0x3E78},
{0x2d84, 0x90F2},
{0x2d86, 0xFFB1},
{0x2d88, 0x00BA},
{0x2d8a, 0x280B},
{0x2d8c, 0x90F2},
{0x2d8e, 0xFFD1},
{0x2d90, 0x00BA},
{0x2d92, 0x2C07},
{0x2d94, 0x403D},
{0x2d96, 0x0050},
{0x2d98, 0x425E},
{0x2d9a, 0x00BA},
{0x2d9c, 0x507E},
{0x2d9e, 0x000E},
{0x2da0, 0x3E69},
{0x2da2, 0x403D},
{0x2da4, 0x003C},
{0x2da6, 0x403F},
{0x2da8, 0x00BA},
{0x2daa, 0x4F6E},
{0x2dac, 0x507E},
{0x2dae, 0x000F},
{0x2db0, 0x90FF},
{0x2db2, 0xFFF1},
{0x2db4, 0x0000},
{0x2db6, 0x2A5E},
{0x2db8, 0x437E},
{0x2dba, 0x3E5C},
{0x2dbc, 0x425F},
{0x2dbe, 0x00BA},
{0x2dc0, 0x4F4C},
{0x2dc2, 0x407A},
{0x2dc4, 0x001C},
{0x2dc6, 0x12B0},
{0x2dc8, 0xFE8E},
{0x2dca, 0x4E4F},
{0x2dcc, 0xC312},
{0x2dce, 0x104F},
{0x2dd0, 0x114F},
{0x2dd2, 0xF37F},
{0x2dd4, 0x5F0F},
{0x2dd6, 0x5F0F},
{0x2dd8, 0x5F0F},
{0x2dda, 0x5F0F},
{0x2ddc, 0x403E},
{0x2dde, 0x00F0},
{0x2de0, 0x8F0E},
{0x2de2, 0x3E30},
{0x2de4, 0x421F},
{0x2de6, 0x80BE},
{0x2de8, 0x903F},
{0x2dea, 0x0009},
{0x2dec, 0x2C05},
{0x2dee, 0x531F},
{0x2df0, 0x4F82},
{0x2df2, 0x80BE},
{0x2df4, 0x4030},
{0x2df6, 0xF9F4},
{0x2df8, 0x421F},
{0x2dfa, 0x80B6},
{0x2dfc, 0x903F},
{0x2dfe, 0x0098},
{0x2e00, 0x2C05},
{0x2e02, 0x531F},
{0x2e04, 0x4F82},
{0x2e06, 0x80B6},
{0x2e08, 0x4030},
{0x2e0a, 0xF9F4},
{0x2e0c, 0x4382},
{0x2e0e, 0x80B6},
{0x2e10, 0x4030},
{0x2e12, 0xF9F4},
{0x2e14, 0x4E82},
{0x2e16, 0x8098},
{0x2e18, 0xD392},
{0x2e1a, 0x7102},
{0x2e1c, 0x4138},
{0x2e1e, 0x4139},
{0x2e20, 0x413A},
{0x2e22, 0x413B},
{0x2e24, 0x4130},
{0x2e26, 0x0260},
{0x2e28, 0x0000},
{0x2e2a, 0x0C18},
{0x2e2c, 0x0240},
{0x2e2e, 0x0000},
{0x2e30, 0x0260},
{0x2e32, 0x0000},
{0x2e34, 0x0C05},
{0x2e36, 0x4130},
{0x2e38, 0x4382},
{0x2e3a, 0x7602},
{0x2e3c, 0x4F82},
{0x2e3e, 0x7600},
{0x2e40, 0x0270},
{0x2e42, 0x0000},
{0x2e44, 0x0C07},
{0x2e46, 0x0270},
{0x2e48, 0x0001},
{0x2e4a, 0x421F},
{0x2e4c, 0x7606},
{0x2e4e, 0x4FC2},
{0x2e50, 0x0188},
{0x2e52, 0x4130},
{0x2e54, 0xDF02},
{0x2e56, 0x3FFE},
{0x2e58, 0x430E},
{0x2e5a, 0x930A},
{0x2e5c, 0x2407},
{0x2e5e, 0xC312},
{0x2e60, 0x100C},
{0x2e62, 0x2801},
{0x2e64, 0x5A0E},
{0x2e66, 0x5A0A},
{0x2e68, 0x930C},
{0x2e6a, 0x23F7},
{0x2e6c, 0x4130},
{0x2e6e, 0x430E},
{0x2e70, 0x430F},
{0x2e72, 0x3C08},
{0x2e74, 0xC312},
{0x2e76, 0x100D},
{0x2e78, 0x100C},
{0x2e7a, 0x2802},
{0x2e7c, 0x5A0E},
{0x2e7e, 0x6B0F},
{0x2e80, 0x5A0A},
{0x2e82, 0x6B0B},
{0x2e84, 0x930C},
{0x2e86, 0x23F6},
{0x2e88, 0x930D},
{0x2e8a, 0x23F4},
{0x2e8c, 0x4130},
{0x2e8e, 0xEE4E},
{0x2e90, 0x407B},
{0x2e92, 0x0009},
{0x2e94, 0x3C05},
{0x2e96, 0x100D},
{0x2e98, 0x6E4E},
{0x2e9a, 0x9A4E},
{0x2e9c, 0x2801},
{0x2e9e, 0x8A4E},
{0x2ea0, 0x6C4C},
{0x2ea2, 0x6D0D},
{0x2ea4, 0x835B},
{0x2ea6, 0x23F7},
{0x2ea8, 0x4130},
{0x2eaa, 0xEF0F},
{0x2eac, 0xEE0E},
{0x2eae, 0x4039},
{0x2eb0, 0x0021},
{0x2eb2, 0x3C0A},
{0x2eb4, 0x1008},
{0x2eb6, 0x6E0E},
{0x2eb8, 0x6F0F},
{0x2eba, 0x9B0F},
{0x2ebc, 0x2805},
{0x2ebe, 0x2002},
{0x2ec0, 0x9A0E},
{0x2ec2, 0x2802},
{0x2ec4, 0x8A0E},
{0x2ec6, 0x7B0F},
{0x2ec8, 0x6C0C},
{0x2eca, 0x6D0D},
{0x2ecc, 0x6808},
{0x2ece, 0x8319},
{0x2ed0, 0x23F1},
{0x2ed2, 0x4130},
{0x2ed4, 0x0000},
{0x2ffe, 0xf000},
{0x3000, 0x00AE},
{0x3002, 0x00AE},
{0x3004, 0x00AE},
{0x3006, 0x00AE},
{0x3008, 0x00AE},
{0x4000, 0x0400},
{0x4002, 0x0400},
{0x4004, 0x0C04},
{0x4006, 0x0C04},
{0x4008, 0x0C04},

//--- FW End ---//


//--- Initial Set file ---//
{0x0B02, 0x0014},
{0x0B04, 0x07C8},
{0x0B06, 0x5ED7},
{0x0B14, 0x430F}, //PLL Main Div[15:8]. Mclk 26.022Mhz / 0x430F = Pclk(87.174Mhz)
{0x0B16, 0x4A0B},
{0x0B18, 0x0000},
{0x0B1A, 0x1044},

{0x004C, 0x0100}, //tg_enable.
{0x000C, 0x0000},
{0x0036, 0x0048}, //ramp_rst_offset
{0x0038, 0x4800}, //ramp_sig_poffset
{0x0138, 0x0104}, //pxl_drv_pwr
{0x013A, 0x0100}, //tx_idle
{0x0C00, 0x3BC7}, //BLC_ctl1. Line BLC on = 0x3b, off = 0x2A //LBLC_ctl1. [0]en_blc, [1]en_lblc_dpc, [2]en_channel_blc, [3]en_adj_pxl_dpc, [4]en_adp_dead_pxl_th
{0x0C0E, 0x0500}, //0x07 BLC display On, 0x05 BLC D off //BLC_ctl3. Frame BLC On = 0x05, off=0x04 //FBLC_ctl3. [0]en_fblc, [1]en_blc_bypass, [2]en_fblc_dpc, [5]en_fobp_dig_offset, [7]en_lobp_dpc_bypass
{0x0C10, 0x0510}, //dig_blc_offset_h
{0x0C16, 0x0000}, //fobp_dig_b_offset. red b[7] sign(0:+,1:-), b[6:0] dc offset 128(max)
{0x0C18, 0x0000}, //fobp_dig_Gb_offset. Gr b[7] sign(0:+,1:-), b[6:0] dc offset 128(max)
{0x0C36, 0x0100}, //r_g_sum_ctl. [0]:g_sum_en. '1'enable, '0'disable.

//--- MIPI blank time --------------//
{0x0902, 0x4101}, //mipi_value_clk_trail. MIPI CLK mode [1]'1'cont(0x43),'0'non-cont(0x41) [6]'1'2lane(0x41), '0'1lane(0x01)
{0x090A, 0x03E4}, //mipi_vblank_delay_h.
{0x090C, 0x0020}, //mipi_hblank_short_delay_h.
{0x090E, 0x0020}, //mipi_hblank_long_delay_h.
{0x0910, 0x5D07}, //05 mipi_LPX
{0x0912, 0x061e}, //05 mipi_CLK_prepare
{0x0914, 0x0407}, //02 mipi_clk_pre
{0x0916, 0x0d0a}, //09 mipi_data_zero
{0x0918, 0x0e09}, //0c mipi_clk_post

//--- Pixel Array Addressing ------//
{0x000E, 0x0000},
{0x0014, 0x003F},
{0x0010, 0x0050},
{0x0016, 0x008F},
{0x0012, 0x00AA},
{0x0018, 0x0ACD},
{0x0020, 0x0700},
{0x0022, 0x0004},
{0x0028, 0x000B},
{0x0024, 0xFFFA},
{0x002A, 0xFFFF},
{0x0026, 0x0016},
{0x002C, 0x07b1},
{0x0034, 0x0700},

{0x0128, 0x0002}, // digital_crop_x_offset_l
{0x012A, 0x0000}, // digital_crop_y_offset_l
{0x012C, 0x0A20}, //2C}, //2592 digital_crop_image_width
{0x012E, 0x0798}, //A4}, //1944 digital_crop_image_height

//----< Image FMT Size >--------------------//
//Image size 2592x1944
{0x0110, 0x0A20}, //X_output_size_h
{0x0112, 0x0798}, //Y_output_size_h

//----< Frame / Line Length >--------------//
{0x0006, 0x07c0}, //frame_length_h 1984
{0x0008, 0x0B40}, //line_length_h 2880
{0x000A, 0x0DB0},
//---------------------------------------//
//--- ETC set ----//
{0x003C, 0x0000}, //fixed frame off. b[0] '1'enable, '0'disable
{0x0500, 0x0000}, //DGA_ctl.  b[1]'0'OTP_color_ratio_disable, '1' OTP_color_ratio_enable, b[2]'0'data_pedestal_en, '1'data_pedestal_dis.
{0x0700, 0x0590}, //Scaler Normal
{0x001E, 0x0101},
{0x0032, 0x0101},
{0x0A02, 0x0100}, // Fast sleep Enable
{0x0C12, 0x0100}, // BLC Offset
{0x0116, 0x0024}, // FBLC Ratio
//----------------//

//--- AG / DG control ----------------//
//AG
{0x003A, 0x0000}, //Analog Gain.  0x00=x1, 0x70=x8, 0xf0=x16.

//DG
{0x0508, 0x0100}, //DG_Gr_h.  0x01=x1, 0x07=x8.
{0x050a, 0x0100}, //DG_Gb_h.  0x01=x1, 0x07=x8.
{0x050c, 0x0100}, //DG_R_h.  0x01=x1, 0x07=x8.
{0x050e, 0x0100}, //DG_B_h.  0x01=x1, 0x07=x8.
//----------------------------------//

//-----< Exp.Time >------------------------//
// Pclk_88Mhz @ Line_length_pclk : 2880 @Exp.Time 33.33ms
{0x0002, 0x0539},	//Fine_int : 33.33ms@Pclk88mhz@Line_length2880
{0x0004, 0x07E0}, //coarse_int : 33.33ms@Pclk88mhz@Line_length2880

//--- ISP enable Selection ---------------//
{0x0A04, 0x011A}, //isp_en. [9]s-gamma,[8]MIPI_en,[6]compresion10to8,[5]Scaler,[4]window,[3]DG,[2]LSC,[1]adpc,[0]tpg
//----------------------------------------//

{0x0118, 0x0100}, //sleep Off
};

struct msm_camera_i2c_reg_setting sr544_init = {
	sr544_init_reg, sizeof(sr544_init_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_WORD_DATA, 100
};
static struct msm_camera_i2c_reg_array init_otp_reg[] = {
	{0x0118, 0x00},  //sleep On
	{0x0F02, 0x00}, // PLL disable
	{0x011A, 0x01}, // CP TRI_H
	{0x011B, 0x09}, // IPGM TRIM_H
	{0x0D04, 0x01}, // FSync output enable
	{0x0D00, 0x07}, // FSync output Drivabiliy
	{0x004C, 0x01}, // TG MCU enable
	{0x003E, 0x01}, // OTP RW
	{0x0118, 0x01}, // Sleep off
};

struct msm_camera_i2c_reg_setting init_otp = {
	init_otp_reg, sizeof(init_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 100
};

struct msm_camera_i2c_reg_setting load_otp_setfile = {
#ifdef CONFIG_S5K5E9YX
	load_s5k5e9yx_otp_setfile_reg, sizeof(load_s5k5e9yx_otp_setfile_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 50
#endif
#ifdef CONFIG_S5K5E3YX
	load_s5k5e3yx_otp_setfile_reg, sizeof(load_s5k5e3yx_otp_setfile_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
};

struct msm_camera_i2c_reg_setting init_read_otp = {
#ifdef CONFIG_S5K5E9YX
	init_read_s5k5e9yx_otp_reg, sizeof(init_read_s5k5e9yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
#ifdef CONFIG_S5K5E3YX
	init_read_s5k5e3yx_otp_reg, sizeof(init_read_s5k5e3yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
};

struct msm_camera_i2c_reg_setting finish_read_otp = {
#ifdef CONFIG_S5K5E9YX
	finish_read_s5k5e9yx_otp_reg, sizeof(finish_read_s5k5e9yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
#ifdef CONFIG_S5K5E3YX
	finish_read_s5k5e3yx_otp_reg, sizeof(finish_read_s5k5e3yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
};

struct msm_camera_i2c_reg_setting init_write_otp = {
#ifdef CONFIG_S5K5E9YX
	init_write_s5k5e9yx_otp_reg, sizeof(init_write_s5k5e9yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
#ifdef CONFIG_S5K5E3YX
	init_write_s5k5e3yx_otp_reg, sizeof(init_write_s5k5e3yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
};

struct msm_camera_i2c_reg_setting finish_write_otp = {
#ifdef CONFIG_S5K5E9YX
	finish_write_s5k5e9yx_otp_reg, sizeof(finish_write_s5k5e9yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
#ifdef CONFIG_S5K5E3YX
	finish_write_s5k5e3yx_otp_reg, sizeof(finish_write_s5k5e3yx_otp_reg)/sizeof(struct msm_camera_i2c_reg_array), MSM_CAMERA_I2C_WORD_ADDR, MSM_CAMERA_I2C_BYTE_DATA, 10
#endif
};

DEFINE_MSM_MUTEX(msm_eeprom_mutex);

static int msm_eeprom_match_id(struct msm_eeprom_ctrl_t *e_ctrl);
static int read_eeprom_memory(struct msm_eeprom_ctrl_t *e_ctrl,
					struct msm_eeprom_memory_block_t *block);


static int msm_eeprom_get_dt_data(struct msm_eeprom_ctrl_t *e_ctrl);
//static long msm_eeprom_subdev_fops_ioctl32(struct file *file, unsigned int cmd, unsigned long arg);
/**
  * msm_eeprom_verify_sum - verify crc32 checksum
  * @mem:	data buffer
  * @size:	size of data buffer
  * @sum:	expected checksum
  *
  * Returns 0 if checksum match, -EINVAL otherwise.
  */
static int msm_eeprom_verify_sum(const char *mem, uint32_t size, uint32_t sum)
{
	uint32_t crc = ~0;

	/* check overflow */
	if (size > crc - sizeof(uint32_t))
		return -EINVAL;

	crc = crc32_le(crc, mem, size);
	if (~crc != sum) {
		pr_err("%s: expect 0x%x, result 0x%x\n", __func__, sum, ~crc);
		pr_err("Check eeprom or interface");
		return -EINVAL;
	}
	CDBG("%s: checksum pass 0x%x\n", __func__, sum);
	return 0;
}

/**
  * msm_eeprom_match_crc - verify multiple regions using crc
  * @data:	data block to be verified
  *
  * Iterates through all regions stored in @data.  Regions with odd index
  * are treated as data, and its next region is treated as checksum.  Thus
  * regions of even index must have valid_size of 4 or 0 (skip verification).
  * Returns a bitmask of verified regions, starting from LSB.  1 indicates
  * a checksum match, while 0 indicates checksum mismatch or not verified.
  */
static uint32_t msm_eeprom_match_crc(struct msm_eeprom_memory_block_t *data)
{
	int j, rc;
	uint32_t *sum;
	uint32_t ret = 0;
	uint8_t *memptr, *memptr_crc;
	struct msm_eeprom_memory_map_t *map;

	if (!data) {
		pr_err("%s data is NULL\n", __func__);
		return -EINVAL;
	}
	map = data->map;

	for (j = 0; j + 1 < data->num_map; j += 2) {
		memptr = data->mapdata + map[j].mem.addr;
		memptr_crc = data->mapdata + map[j+1].mem.addr;

		/* empty table or no checksum */
		if (!map[j].mem.valid_size || !map[j+1].mem.valid_size) {
			continue;
		}
		if (map[j+1].mem.valid_size != sizeof(uint32_t)) {
			pr_err("%s: malformatted data mapping\n", __func__);
			return -EINVAL;
		}
		sum = (uint32_t *) (memptr_crc);
		rc = msm_eeprom_verify_sum(memptr, map[j].mem.valid_size, *sum);
		if (!rc) {
			ret |= 1 << (j/2);
		}
	}
	return ret;
}

static int msm_eeprom_get_cmm_data(struct msm_eeprom_ctrl_t *e_ctrl,
						struct msm_eeprom_cfg_data *cdata)
{
	int rc = 0;
	struct msm_eeprom_cmm_t *cmm_data = &e_ctrl->eboard_info->cmm_data;
	cdata->cfg.get_cmm_data.cmm_support = cmm_data->cmm_support;
	cdata->cfg.get_cmm_data.cmm_compression = cmm_data->cmm_compression;
	cdata->cfg.get_cmm_data.cmm_size = cmm_data->cmm_size;
	return rc;
}

/**
  * msm_eeprom_power_up() - power up eeprom if it's not on
  * @e_ctrl:	control struct
  * @down:	output to indicate whether power down is needed later
  *
  * This function powers up EEPROM only if it's not already on.  If power
  * up is performed here, @down will be set to true.  Caller should power
  * down EEPROM after transaction if @down is true.
  */
static int msm_eeprom_power_up(struct msm_eeprom_ctrl_t *e_ctrl, bool *down)
{
	int rc = 0;
	if (e_ctrl->eeprom_device_type == MSM_CAMERA_SPI_DEVICE)
		rc = msm_eeprom_match_id(e_ctrl);
	pr_warn("%s : E", __func__);

	if (rc < 0) {
		 if (down) *down = true;
		rc = msm_camera_power_up(&e_ctrl->eboard_info->power_info,
		e_ctrl->eeprom_device_type,&e_ctrl->i2c_client);
	} else {
		if (down) *down = false;
	}
	return rc;
}
/**
  * msm_eeprom_power_down() - power down eeprom
  * @e_ctrl:	control struct
  * @down:	indicate whether kernel powered up eeprom before
  *
  * This function powers down EEPROM only if it's powered on by calling
  * msm_eeprom_power_up() before.  If @down is false, no action will be
  * taken.  Otherwise, eeprom will be powered down.
  */
static int msm_eeprom_power_down(struct msm_eeprom_ctrl_t *e_ctrl, bool down)
{
  int rc = 0;
  pr_warn("%s : E", __func__);
	if (down)
		return 	rc = msm_camera_power_down(&e_ctrl->eboard_info->power_info,
			e_ctrl->eeprom_device_type, &e_ctrl->i2c_client);
	else
		return 0;
}

#if defined(CONFIG_SR544)
static int prepare_read_write_data(struct msm_eeprom_ctrl_t *e_ctrl, uint8_t addr_h, uint8_t addr_l, enum msm_camera_i2c_data_type data_type, int isWrite)
{
	int rc=0;

	isWrite = !(!isWrite)+1;

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
			&(e_ctrl->i2c_client), &init_otp);
	if (rc < 0) {
		pr_err("%s:(%d) write failed\n", __func__, __LINE__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
			&(e_ctrl->i2c_client), r_otp_addr_h,
			addr_h, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) write failed\n", __func__, __LINE__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
			&(e_ctrl->i2c_client), r_otp_addr_l,
			addr_l, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) write failed\n", __func__, __LINE__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
			&(e_ctrl->i2c_client), r_otp_cmd,
			isWrite, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) write failed\n", __func__, __LINE__);
		return rc;
	}

	return rc;
}
#endif

static int eeprom_config_read_cal_data(struct msm_eeprom_ctrl_t *e_ctrl,
					struct msm_eeprom_cfg_data *cdata)
{
	int rc;
	/* check range */
	if ((cdata->cfg.read_data.num_bytes > e_ctrl->cal_data.num_data)||
		(cdata->cfg.read_data.addr > e_ctrl->cal_data.num_data)){
		pr_err("%s: Invalid size or addr. exp %u, req %u, addr %x\n", __func__,
			e_ctrl->cal_data.num_data, cdata->cfg.read_data.num_bytes, cdata->cfg.read_data.addr);
		return -EINVAL;
	}
	if (!e_ctrl->cal_data.mapdata) {
		pr_err("%s : is NULL", __func__);
		return -EFAULT;
	}
	CDBG("%s:%d: OTP subdevid: %d mapdata %p", __func__, __LINE__, e_ctrl->subdev_id, e_ctrl->cal_data.mapdata);
	CDBG("%s:%d: OTP addr: %x num_bytes 0x%d", __func__, __LINE__, cdata->cfg.read_data.addr, cdata->cfg.read_data.num_bytes);
	rc = copy_to_user(cdata->cfg.read_data.dbuffer,
		e_ctrl->cal_data.mapdata + cdata->cfg.read_data.addr,
		cdata->cfg.read_data.num_bytes);
	/* this below code is giving probelm in device -> encrypt -> came launch
	Ideally we should not free this data until dtor. so commentiong out */
	return rc;
}

static int eeprom_config_read_data(struct msm_eeprom_ctrl_t *e_ctrl,
				   struct msm_eeprom_cfg_data *cdata)
{
	char *buf;
	int rc = 0;
#if defined(CONFIG_SR544)
	return rc;
#endif
	buf = kmalloc(cdata->cfg.read_data.num_bytes, GFP_KERNEL);
	if (!buf) {
		pr_err("%s : buf is NULL", __func__);
		return -ENOMEM;
	}

	memcpy(buf, &map_data[(cdata->cfg.read_data.addr)],
		cdata->cfg.read_data.num_bytes);

	rc = copy_to_user(cdata->cfg.read_data.dbuffer, buf,
			  cdata->cfg.read_data.num_bytes);

	kfree(buf);
	return rc;
}

static int eeprom_config_read_fw_version(struct msm_eeprom_ctrl_t *e_ctrl,
				   struct msm_eeprom_cfg_data *cdata)
{
	char *buf;
	int rc = 0;

	buf = kmalloc(cdata->cfg.read_data.num_bytes, GFP_KERNEL);
	if (!buf) {
		pr_err("%s : buf is NULL", __func__);
		return -ENOMEM;
	}
	memset(buf, 0, cdata->cfg.read_data.num_bytes);
	if(e_ctrl->cal_data.num_data < (cdata->cfg.read_data.addr + cdata->cfg.read_data.num_bytes)) {
		pr_err("%s : requested data size was mismatched! addr:size[0x%x:%d]\n", __func__, cdata->cfg.read_data.addr, cdata->cfg.read_data.num_bytes);
		rc = -ENOMEM;
		goto FREE;
	}

	memcpy(buf, &map_data[cdata->cfg.read_data.addr], cdata->cfg.read_data.num_bytes);

	rc = copy_to_user(cdata->cfg.read_data.dbuffer, buf,
			  cdata->cfg.read_data.num_bytes);

FREE:

	kfree(buf);
	return rc;
}
static int eeprom_config_read_compressed_data(struct msm_eeprom_ctrl_t *e_ctrl,
	struct msm_eeprom_cfg_data *cdata)
{
	int rc = 0;
#if 0 //  just once to power up when load lib
	bool down;
#endif

	uint8_t *buf_comp = NULL;
	uint8_t *buf_decomp = NULL;
	size_t decomp_size;
	uint16_t data;
	int i;
#if defined(CONFIG_SR544)
	uint8_t addr_h, addr_l;
#endif
	pr_err("%s: address (0x%x) comp_size (%d) after decomp (%d)", __func__,
	cdata->cfg.read_data.addr,
	cdata->cfg.read_data.comp_size, cdata->cfg.read_data.num_bytes);

	buf_comp = kmalloc(cdata->cfg.read_data.comp_size, GFP_KERNEL);
	buf_decomp = kmalloc(cdata->cfg.read_data.num_bytes, GFP_KERNEL);
	if (!buf_decomp || !buf_comp) {
		pr_err("%s: kmalloc fail", __func__);
		rc = -ENOMEM;
		goto FREE;
	}

#if defined(CONFIG_SR544)
	addr_h = ((cdata->cfg.read_data.addr)>>8)&0xFF;
	addr_l = cdata->cfg.read_data.addr&0xFF;

	rc = prepare_read_write_data(e_ctrl, addr_h, addr_l, MSM_CAMERA_I2C_BYTE_DATA, 0);
	if (rc < 0) {
		pr_err("%s: failed to prepare read/write on otp\n", __func__);
		goto POWER_DOWN;
	}
#else
	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
			&(e_ctrl->i2c_client), &init_read_otp);
	if (rc < 0) {
		pr_err("%s:(%d) init_read_otp failed\n", __func__, __LINE__);
		goto POWER_DOWN;
	}
#endif

	for(i=0; i<cdata->cfg.read_data.comp_size; i++) {
		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
				&(e_ctrl->i2c_client),
#if defined(CONFIG_SR544)
				r_otp_rdata,
#else
				cdata->cfg.read_data.addr+i,
#endif
				&data, MSM_CAMERA_I2C_BYTE_DATA);
		if (rc < 0) {
			pr_err("%s:(%d) read failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}
		buf_comp[i]=data;
	}

#if !defined(CONFIG_SR544)
	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
			&(e_ctrl->i2c_client), &finish_read_otp);
	if (rc < 0) {
		pr_err("%s:(%d) finish_read_otp failed\n", __func__, __LINE__);
		goto POWER_DOWN;
	}
#endif

	pr_err("%s: crc = 0x%08X\n", __func__, *(uint32_t*)&buf_comp[cdata->cfg.read_data.comp_size-4]);
	//  compressed data(buf_comp) contains uncompressed crc32 value.
	rc = msm_eeprom_verify_sum(buf_comp, cdata->cfg.read_data.comp_size-4,
		*(uint32_t*)&buf_comp[cdata->cfg.read_data.comp_size-4]);

	if (rc < 0) {
		pr_err("%s: crc check error, rc %d\n", __func__, rc);
		goto POWER_DOWN;
	}

	decomp_size = cdata->cfg.read_data.num_bytes;
	rc = lzo1x_decompress_safe(buf_comp, cdata->cfg.read_data.comp_size-4,
			buf_decomp, &decomp_size);


	if (rc != LZO_E_OK) {
		pr_err("%s: decompression failed %d", __func__, rc);
		goto POWER_DOWN;
	}
	rc = copy_to_user(cdata->cfg.read_data.dbuffer, buf_decomp, decomp_size);

	if (rc < 0) {
		pr_err("%s: failed to copy to user\n", __func__);
		goto POWER_DOWN;
	}


POWER_DOWN:
#if 0 //  just once to power up when load lib
	msm_eeprom_power_down(e_ctrl, down);
#endif

	FREE:
	if (buf_comp) kfree(buf_comp);
	if (buf_decomp) kfree(buf_decomp);

	return rc;
}

static int eeprom_config_write_data(struct msm_eeprom_ctrl_t *e_ctrl,
				struct msm_eeprom_cfg_data *cdata)

{
	int rc = 0;

	char *buf = NULL;
	bool down;
	void *work_mem = NULL;
	uint8_t *compressed_buf = NULL;
	size_t compressed_size = 0;
	uint32_t crc = ~0;
	int i;
#if defined(CONFIG_SR544)
	uint8_t addr_h, addr_l;
#endif


	pr_warn("%s: compress ? %d size %d", __func__,
		cdata->cfg.write_data.compress, cdata->cfg.write_data.num_bytes);
	buf = kmalloc(cdata->cfg.write_data.num_bytes, GFP_KERNEL);
	if (!buf) {
		pr_err("%s: allocation failed 1", __func__);
		return -ENOMEM;
	}
	rc = copy_from_user(buf, cdata->cfg.write_data.dbuffer,
			cdata->cfg.write_data.num_bytes);
	if (rc < 0) {
		pr_err("%s: failed to copy write data\n", __func__);
		goto FREE;
	}
	/* compress */
	if (cdata->cfg.write_data.compress) {
		compressed_buf = kmalloc(cdata->cfg.write_data.num_bytes +
			cdata->cfg.write_data.num_bytes / 16 + 64 + 3, GFP_KERNEL);
		if (!compressed_buf) {
			pr_err("%s: allocation failed 2", __func__);
			rc = -ENOMEM;
			goto FREE;
		}
		work_mem = kmalloc(LZO1X_1_MEM_COMPRESS, GFP_KERNEL);
		if (!work_mem) {
			pr_err("%s: allocation failed 3", __func__);
			rc = -ENOMEM;
			goto FREE;
		}
		if (lzo1x_1_compress(buf, cdata->cfg.write_data.num_bytes,
				compressed_buf, &compressed_size, work_mem) != LZO_E_OK) {
			pr_err("%s: compression failed", __func__);
			goto FREE;
		}

		crc = crc32_le(crc, compressed_buf, compressed_size);
		crc = ~crc;

		pr_err("%s: compressed size %d, crc=0x%0X \n", __func__, (uint32_t)compressed_size, crc);
		*cdata->cfg.write_data.write_size = compressed_size + 4;  //  include CRC size
	}
	rc = msm_eeprom_power_up(e_ctrl, &down);
	if (rc < 0) {
		pr_err("%s: failed to power on eeprom\n", __func__);
		goto FREE;
	}

#if defined(CONFIG_SR544)
	if (cdata->cfg.write_data.compress) {

		addr_h = ((cdata->cfg.write_data.addr)>>8)&0xFF;
		addr_l = cdata->cfg.write_data.addr&0xFF;

		rc = prepare_read_write_data(e_ctrl, addr_h, addr_l, MSM_CAMERA_I2C_BYTE_DATA, 1);
		if (rc < 0) {
			pr_err("%s: failed to prepare read/write on otp\n", __func__);
			goto POWER_DOWN;
		}

		for(i=0; i<compressed_size; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), r_otp_wdata,
					compressed_buf[i], MSM_CAMERA_I2C_BYTE_DATA);
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}

		addr_h = ((cdata->cfg.write_data.addr+compressed_size)>>8)&0xFF;
		addr_l = (cdata->cfg.write_data.addr+compressed_size)&0xFF;

		rc = prepare_read_write_data(e_ctrl, addr_h, addr_l, MSM_CAMERA_I2C_BYTE_DATA, 1);
		if (rc < 0) {
			pr_err("%s: failed to prepare read/write on otp\n", __func__);
			goto POWER_DOWN;
		}

		//  write CRC32 for compressed data
		for(i=0; i<4; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), r_otp_wdata,
					((uint8_t *)crc)[i], MSM_CAMERA_I2C_BYTE_DATA);
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}
	} else {
		addr_h = ((cdata->cfg.write_data.addr)>>8)&0xFF;
		addr_l = cdata->cfg.write_data.addr&0xFF;

		rc = prepare_read_write_data(e_ctrl, addr_h, addr_l, MSM_CAMERA_I2C_BYTE_DATA, 1);
		if (rc < 0) {
			pr_err("%s: failed to prepare read/write on otp\n", __func__);
			goto POWER_DOWN;
		}

		for(i=0; i<cdata->cfg.write_data.num_bytes; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), r_otp_wdata,
					buf[i], MSM_CAMERA_I2C_BYTE_DATA);
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}
	}
#else
	if (cdata->cfg.write_data.compress) {
		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
				&(e_ctrl->i2c_client), &init_write_otp);
		if (rc < 0) {
			pr_err("%s:(%d) init_write_otp failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}

		for(i=0; i<compressed_size; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), cdata->cfg.write_data.addr+i,
					compressed_buf[i], MSM_CAMERA_I2C_BYTE_DATA);
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}

		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
				&(e_ctrl->i2c_client), &init_write_otp);
		if (rc < 0) {
			pr_err("%s:(%d) init_write_otp failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}

		//  write CRC32 for compressed data
		for(i=0; i<4; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), cdata->cfg.write_data.addr+compressed_size+i,
					buf[i], MSM_CAMERA_I2C_BYTE_DATA);//(uint8_t *)crc)[i], MSM_CAMERA_I2C_BYTE_DATA); check
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}

		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
				&(e_ctrl->i2c_client), &finish_write_otp);
		if (rc < 0) {
			pr_err("%s:(%d) finish_write_otp failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}
	} else {
		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
				&(e_ctrl->i2c_client), &init_write_otp);
		if (rc < 0) {
			pr_err("%s:(%d) init_write_otp failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}

		for(i=0; i<cdata->cfg.write_data.num_bytes; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
					&(e_ctrl->i2c_client), cdata->cfg.write_data.addr+i,
					buf[i], MSM_CAMERA_I2C_BYTE_DATA);
			if (rc < 0) {
				pr_err("%s:(%d) write failed\n", __func__, __LINE__);
				goto POWER_DOWN;
			}
		}
		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
				&(e_ctrl->i2c_client), &finish_write_otp);
		if (rc < 0) {
			pr_err("%s:(%d) finish_write_otp failed\n", __func__, __LINE__);
			goto POWER_DOWN;
		}
	}
#endif

	if (rc < 0) {
		pr_err("%s: failed to write data, rc %d\n", __func__, rc);
		goto POWER_DOWN;
	}
	CDBG("%s: done", __func__);
POWER_DOWN:
	msm_eeprom_power_down(e_ctrl, down);
FREE:
	if (buf) kfree(buf);
	if (compressed_buf) kfree(compressed_buf);
	if (work_mem) kfree(work_mem);
	return rc;
}
static int eeprom_config_erase(struct msm_eeprom_ctrl_t *e_ctrl,
			struct msm_eeprom_cfg_data *cdata)
{

	int rc = 0;
#if 0
	bool down;
	pr_warn("%s: erasing addr 0x%x, size %u\n", __func__,
		cdata->cfg.erase_data.addr, cdata->cfg.erase_data.num_bytes);
	rc = msm_eeprom_power_up(e_ctrl, &down);
	if (rc < 0) {
		pr_err("%s: failed to power on eeprom\n", __func__);
		return rc;
	}
	rc = msm_camera_spi_erase(&e_ctrl->i2c_client,
		cdata->cfg.erase_data.addr, cdata->cfg.erase_data.num_bytes);
	if (rc < 0)
		pr_err("%s: failed to erase eeprom\n", __func__);
	msm_eeprom_power_down(e_ctrl, down);
#endif
	return rc;
}

static int32_t msm_eeprom_read_eeprom_data(struct msm_eeprom_ctrl_t *e_ctrl)
{
	int32_t rc = 0;

	CDBG("%s:%d Enter\n", __func__, __LINE__);
	/* check eeprom id */
	if (e_ctrl->eeprom_device_type == MSM_CAMERA_SPI_DEVICE) {
		rc = msm_eeprom_match_id(e_ctrl);
		if (rc < 0) {
			CDBG("%s: eeprom not matching %d\n", __func__, rc);
			return rc;
		}
	}
	/* read eeprom */
	if (e_ctrl->cal_data.map) {
		int i;
		int normal_crc_value = 0;

		normal_crc_value = 0;
		for(i = 0; i < e_ctrl->cal_data.num_map>>1; i ++)
			normal_crc_value |= (1 << i);
		CDBG("num_map = %d, Normal CRC value = 0x%X\n",
			e_ctrl->cal_data.num_map, normal_crc_value);

        /* power up eeprom for reading */
        rc = msm_camera_power_up(&e_ctrl->eboard_info->power_info, e_ctrl->eeprom_device_type,
            &e_ctrl->i2c_client);
        if (rc < 0) {
            pr_err("failed rc %d\n", rc);
            return rc;
        }
		rc = read_eeprom_memory(e_ctrl, &e_ctrl->cal_data);
		if (rc < 0) {
			pr_err("%s: read cal data failed\n", __func__);
            goto POWER_DOWN;
		}
		e_ctrl->is_supported |= msm_eeprom_match_crc(&e_ctrl->cal_data);

		if(e_ctrl->is_supported != normal_crc_value) {
			pr_err("%s : any CRC value(s) are not matched.\n", __func__);
		} else {
			pr_err("%s : All CRC values are matched.\n", __func__);
		}
	}

	e_ctrl->is_supported = (e_ctrl->is_supported << 1) | 1;
	CDBG("%s:%d reloaded - is_supported : 0x%04X X\n",
		__func__, __LINE__, e_ctrl->is_supported);

POWER_DOWN:
  /* power down */
  if (msm_camera_power_down(&e_ctrl->eboard_info->power_info,
                            e_ctrl->eeprom_device_type, &e_ctrl->i2c_client) < 0)
  {
    pr_err("%s:%d pwoer down failed\n", __func__, __LINE__);
  }
  pr_err("%s:%d Exit\n", __func__, __LINE__);

  return rc;
}

static int msm_eeprom_config(struct msm_eeprom_ctrl_t *e_ctrl,
				void __user *argp)
{
	struct msm_eeprom_cfg_data *cdata =
		(struct msm_eeprom_cfg_data *)argp;
	int rc = 0;

	CDBG("%s:%d: subdevid: %d, cfgtype: %d\n",__func__,__LINE__,e_ctrl->subdev_id, cdata->cfgtype);
	switch (cdata->cfgtype) {
	case CFG_EEPROM_GET_INFO:
		CDBG("%s E CFG_OTP_GET_INFO\n", __func__);
		cdata->is_supported = e_ctrl->is_supported;
		memcpy(cdata->cfg.eeprom_name,
			e_ctrl->eboard_info->eeprom_name,
			sizeof(cdata->cfg.eeprom_name));
		break;
	case CFG_EEPROM_GET_CAL_DATA:
		CDBG("%s E CFG_OTP_GET_CAL_DATA\n", __func__);
		cdata->cfg.get_data.num_bytes =
			e_ctrl->cal_data.num_data;
		break;
	case CFG_EEPROM_READ_CAL_DATA:
		CDBG("%s E CFG_OTP_READ_CAL_DATA\n", __func__);
		rc = eeprom_config_read_cal_data(e_ctrl, cdata);
		break;
	case CFG_EEPROM_READ_DATA:
		CDBG("%s E CFG_OTP_READ_DATA\n", __func__);
		rc = eeprom_config_read_data(e_ctrl, cdata);
		break;
	case CFG_EEPROM_READ_COMPRESSED_DATA:
		rc = eeprom_config_read_compressed_data(e_ctrl, cdata);
	if (rc < 0)
		pr_err("%s : eeprom_config_read_compressed_data failed", __func__);
		break;
	case CFG_EEPROM_WRITE_DATA:
		pr_warn("%s E CFG_OTP_WRITE_DATA\n", __func__);
		rc = eeprom_config_write_data(e_ctrl, cdata);
		break;
	case CFG_EEPROM_READ_DATA_FROM_HW:
		CDBG("%s E CFG_OTP_READ_DATA_FROM_HW", __func__);
		e_ctrl->is_supported = 0x01;
		pr_err ("kernel is_supported before : 0x%04X\n", e_ctrl->is_supported);
		rc = msm_eeprom_read_eeprom_data(e_ctrl);
		pr_err ("kernel is_supported after : 0x%04X\n", e_ctrl->is_supported);
		cdata->is_supported = e_ctrl->is_supported;
		if (rc < 0) {
			pr_err("%s:%d failed rc %d\n", __func__, __LINE__,  rc);
			break;
		}
		break;
	case CFG_EEPROM_GET_MM_INFO:
		CDBG("%s E CFG_OTP_GET_MM_INFO\n", __func__);
		rc = msm_eeprom_get_cmm_data(e_ctrl, cdata);
		break;

	case CFG_EEPROM_ERASE:
		pr_warn("%s E CFG_OTP_ERASE\n", __func__);
		rc = eeprom_config_erase(e_ctrl, cdata);
		break;
	case CFG_EEPROM_POWER_ON:
		rc = msm_eeprom_power_up(e_ctrl, NULL);
		if (rc < 0)
			pr_err("%s : msm_OTP_power_up failed", __func__);
		break;
	case CFG_EEPROM_POWER_OFF:
		rc = msm_eeprom_power_down(e_ctrl, true);
		if (rc < 0)
			pr_err("%s : msm_OTP_power_down failed", __func__);
		break;
	case CFG_EEPROM_GET_FW_VERSION_INFO:
		CDBG("%s E CFG_OTP_GET_FW_VERSION_INFO\n", __func__);
		rc = eeprom_config_read_fw_version(e_ctrl, cdata);
		break;
	default:
		break;
	}

	pr_err("%s X rc: %d\n", __func__, rc);
	return rc;
}

static int msm_eeprom_get_subdev_id(struct msm_eeprom_ctrl_t *e_ctrl,
				void *arg)
{
	uint32_t *subdev_id = (uint32_t *)arg;
	CDBG("%s E\n", __func__);
	if (!subdev_id) {
		pr_err("%s failed\n", __func__);
		return -EINVAL;
	}
	*subdev_id = e_ctrl->subdev_id;
	CDBG("subdev_id %d\n", *subdev_id);
	CDBG("%s X\n", __func__);
	return 0;
}

static long msm_eeprom_subdev_ioctl(struct v4l2_subdev *sd,
		unsigned int cmd, void *arg)
{
	struct msm_eeprom_ctrl_t *e_ctrl = v4l2_get_subdevdata(sd);
	void __user *argp = (void __user *)arg;
	CDBG("%s E\n", __func__);
	CDBG("%s:%d a_ctrl %p argp %p\n", __func__, __LINE__, e_ctrl, argp);
	switch (cmd) {
	case VIDIOC_MSM_SENSOR_GET_SUBDEV_ID:
		return msm_eeprom_get_subdev_id(e_ctrl, argp);
	case VIDIOC_MSM_EEPROM_CFG:
		return msm_eeprom_config(e_ctrl, argp);
	default:
		return -ENOIOCTLCMD;
	}

	pr_err("%s X\n", __func__);
}

static struct msm_camera_i2c_fn_t msm_eeprom_cci_func_tbl = {
	.i2c_read = msm_camera_cci_i2c_read,
	.i2c_read_seq = msm_camera_cci_i2c_read_seq,
	.i2c_write = msm_camera_cci_i2c_write,
	.i2c_write_seq = msm_camera_cci_i2c_write_seq,
	.i2c_write_table = msm_camera_cci_i2c_write_table,
	.i2c_write_seq_table = msm_camera_cci_i2c_write_seq_table,
	.i2c_write_table_w_microdelay =
	msm_camera_cci_i2c_write_table_w_microdelay,
	.i2c_util = msm_sensor_cci_i2c_util,
	.i2c_poll = msm_camera_cci_i2c_poll,
};

static struct msm_camera_i2c_fn_t msm_eeprom_qup_func_tbl = {
	.i2c_read = msm_camera_qup_i2c_read,
	.i2c_read_seq = msm_camera_qup_i2c_read_seq,
	.i2c_write = msm_camera_qup_i2c_write,
	.i2c_write_table = msm_camera_qup_i2c_write_table,
	.i2c_write_seq_table = msm_camera_qup_i2c_write_seq_table,
	.i2c_write_table_w_microdelay =
	msm_camera_qup_i2c_write_table_w_microdelay,
};

static struct msm_camera_i2c_fn_t msm_eeprom_spi_func_tbl = {
	.i2c_read = msm_camera_spi_read,
	.i2c_read_seq = msm_camera_spi_read_seq,
};

static int msm_eeprom_open(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh) {
	int rc = 0;
	struct msm_eeprom_ctrl_t *e_ctrl =  v4l2_get_subdevdata(sd);
	CDBG("%s E\n", __func__);
	if (!e_ctrl) {
		pr_err("%s failed e_ctrl is NULL\n", __func__);
		return -EINVAL;
	}
	CDBG("%s X\n", __func__);
	return rc;
}

static int msm_eeprom_close(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh) {
	int rc = 0;
	struct msm_eeprom_ctrl_t *e_ctrl =  v4l2_get_subdevdata(sd);
	CDBG("%s E\n", __func__);
	if (!e_ctrl) {
		pr_err("%s failed e_ctrl is NULL\n", __func__);
		return -EINVAL;
	}
	CDBG("%s X\n", __func__);
	return rc;
}

static const struct v4l2_subdev_internal_ops msm_eeprom_internal_ops = {
	.open = msm_eeprom_open,
	.close = msm_eeprom_close,
};

uint8_t* get_eeprom_data_addr()
{
	if (map_data == NULL)
		pr_err("get_eeprom_data_addr otp - map_data is NULL ");
	return map_data;
}

/**
  * read_eeprom_memory() - read map data into buffer
  * @e_ctrl:	eeprom control struct
  * @block:	block to be read
  *
  * This function iterates through blocks stored in block->map, reads each
  * region and concatenate them into the pre-allocated block->mapdata
  */
#if defined(CONFIG_SR544)
//  compare dtsi file to GTA when L-OS upgrade for rossa/core-prime.
static int read_eeprom_memory(struct msm_eeprom_ctrl_t *e_ctrl,
			      struct msm_eeprom_memory_block_t *block)
{
	int rc = 0;
	struct msm_eeprom_memory_map_t *emap = block->map;
	struct msm_eeprom_board_info *eb_info;
	uint8_t *memptr = block->mapdata;
	enum msm_camera_i2c_data_type data_type = MSM_CAMERA_I2C_BYTE_DATA;
	uint16_t OTP_Bank=0, OTP_Data=0;
	int i, j;
	uint16_t start_addr;
	uint16_t version;

	if (!e_ctrl) {
		pr_err("%s e_ctrl is NULL", __func__);
		return -EINVAL;
	}

	eb_info = e_ctrl->eboard_info;
#if 1 //sanjay temp disable
	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
			&(e_ctrl->i2c_client), &sr544_init);
	if (rc < 0) {
		pr_err("%s:(%d) write failed\n", __func__, __LINE__);
		return rc;
	}
#endif //sanjay temp disable
	rc = prepare_read_write_data(e_ctrl, 0x00, 0x20, MSM_CAMERA_I2C_BYTE_DATA, 0);
	if (rc < 0) {
		pr_err("%s: failed to prepare read/write on otp\n", __func__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
			&(e_ctrl->i2c_client), r_otp_rdata,
			&version, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) read failed\n", __func__, __LINE__);
		return rc;
	}
	pr_err("%s:(%d) cra_version(0x%02X)",__func__,__LINE__,version);

	rc = prepare_read_write_data(e_ctrl, 0x06, 0x80, MSM_CAMERA_I2C_BYTE_DATA, 0);
	if (rc < 0) {
		pr_err("%s: failed to prepare read/write on otp\n", __func__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
			&(e_ctrl->i2c_client), r_otp_rdata,
			&OTP_Bank, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) read failed\n", __func__, __LINE__);
		return rc;
	}

	pr_err("%s: read OTP_Bank: %d\n", __func__, OTP_Bank);

	switch(OTP_Bank) {
	case 0:
	case 1:
		start_addr = 0x0690;
		break;
	case 3:
		start_addr = 0x0EE0;
		break;
	case 7:
		start_addr = 0x1730;
		break;
	default:
		pr_err("%s: Bank error : Bank(%d)\n", __func__, OTP_Bank);
		return -EINVAL;
	}

	for (j = 0; j < block->num_map; j++) {
		if (emap[j].saddr.addr) {
			eb_info->i2c_slaveaddr = emap[j].saddr.addr;
			e_ctrl->i2c_client.cci_client->sid =
					eb_info->i2c_slaveaddr >> 1;
			pr_err("qcom,slave-addr = 0x%X\n",
				eb_info->i2c_slaveaddr);
		}
	}

	pr_err("%s:(%d) e_ctrl->cal_data.num_data : %x\n", __func__, __LINE__, e_ctrl->cal_data.num_data);

	if (e_ctrl->cal_data.num_data)
	{
		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), r_otp_addr_h,
				((start_addr & 0xFF00) >> 8), data_type);
		if (rc < 0) {
			pr_err("%s:(%d) write failed\n", __func__, __LINE__);
			return rc;
		}

		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), r_otp_addr_l,
				(start_addr & 0x00FF), data_type);
		if (rc < 0) {
			pr_err("%s:(%d) write failed\n", __func__, __LINE__);
			return rc;
		}

		rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), r_otp_cmd,
				0x01, data_type);
		if (rc < 0) {
			pr_err("%s:(%d) write failed\n", __func__, __LINE__);
			return rc;
		}

		for (i=0; i<e_ctrl->cal_data.num_data; i++) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
					&(e_ctrl->i2c_client), r_otp_rdata,
					&OTP_Data, data_type);
			if (rc < 0) {
				pr_err("%s:(%d) read failed\n", __func__, __LINE__);
				return rc;
			}
			memptr[i] = OTP_Data;
		}
#ifdef EEPROM_MMAP_DEBUG
		printk("OTP data : ");
		for (i=0; i<e_ctrl->cal_data.num_data; i++) {
			printk("[%d:%x], ", i, memptr[i]);
			if(i%16 == 15)
				printk("\n");
		}
		printk("\n");
#endif

		// copy CRA information which is read from OTP 0x20 to cal data [0x50] address.
		memptr[0x50] = version & 0xFF;
		pr_err("%s: %d version = 0x%02X, memptr[0x50] = 0x%02X\n", __func__, __LINE__ , version, memptr[0x50]);

		memptr += e_ctrl->cal_data.num_data;
		pr_err("%s: %d   memptr after addition = %p\n", __func__, __LINE__ , memptr);
	}
	return rc;
}
#else
static int read_eeprom_memory(struct msm_eeprom_ctrl_t *e_ctrl,
			struct msm_eeprom_memory_block_t *block)
{
	int rc = 0;
	struct msm_eeprom_memory_map_t *emap = block->map;
	struct msm_eeprom_board_info *eb_info;
	uint8_t *memptr = block->mapdata;
	enum msm_camera_i2c_data_type data_type = MSM_CAMERA_I2C_BYTE_DATA;
	uint16_t OTP_Bank=0;
#ifdef CONFIG_S5K5E3YX
	uint16_t OTP_Data=0;
#endif
	uint16_t start_addr,end_addr;
	uint8_t page;
	int i, j;
#ifdef CONFIG_S5K5E9YX
	int read_bytes = 0;
	int total_bytes_to_read = 0;
	int next_page_count = 0;
#endif

	if (!e_ctrl) {
		pr_err("%s e_ctrl is NULL", __func__);
		return -EINVAL;
	}

	eb_info = e_ctrl->eboard_info;

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
		&(e_ctrl->i2c_client), &load_otp_setfile);
	if (rc < 0) {
		pr_err("%s:(%d) load_otp_setfile failed\n", __func__, __LINE__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
		&(e_ctrl->i2c_client), &init_read_otp);
	if (rc < 0) {
		pr_err("%s:(%d) init_read_otp failed\n", __func__, __LINE__);
		return rc;
	}

	rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
#ifdef CONFIG_S5K5E9YX
		&(e_ctrl->i2c_client), S5K5E9_OTP_PAGE_START_REGISTER,
#else
		&(e_ctrl->i2c_client), START_ADDR_FOR_S5K5E3_OTP,
#endif
		&OTP_Bank, data_type);
	if (rc < 0) {
		pr_err("%s:(%d) read failed\n", __func__, __LINE__);
		return rc;
	}
	memptr[0] = OTP_Bank;
	pr_info("%s:%d read OTP_Bank: %d\n", __func__, __LINE__, OTP_Bank);

	switch(OTP_Bank) {
		// Refer to OTP document
#ifdef CONFIG_S5K5E9YX
		case 0:
		case 1:
			page = 17;
			break;
		case 3:
			page = 22;
			break;
		case 7:
			page = 27;
			break;
		case 0xF:
			page = 32;
		case 0x1F:
			page = 37;
			break;
#else
		case 0:
		case 1:
			page = 2;
			break;
		case 3:
			page = 3;
			break;
		case 7:
			page = 4;
			break;
		case 0xF:
			page = 5;
			break;
#endif
		default:
			pr_err("%s: Bank error : Bank(%d)\n", __func__, OTP_Bank);
			return -EINVAL;
	}

	pr_info("%s:%d read page: %d\n", __func__, __LINE__, page);

#ifdef CONFIG_S5K5E9YX
	init_read_otp.reg_setting[1].reg_data = page;
	init_write_otp.reg_setting[7].reg_data = page;
#endif
#ifdef CONFIG_S5K5E3YX
	init_read_otp.reg_setting[1].reg_data = page;
	init_write_otp.reg_setting[7].reg_data = page;
#endif
	block->mapdata[0] = page;

	for (j = 0; j < block->num_map; j++) {
		if(emap[j].mem.data_t == 0) continue;

		memptr = block->mapdata + emap[j].mem.addr; // j=0, jump 12(0x0C) / j=1, jump 316(0x13C)

		pr_err("%s: %d addr = 0x%X, size = %d\n", __func__, __LINE__, emap[j].mem.addr, emap[j].mem.valid_size);

		if (emap[j].saddr.addr) {
			eb_info->i2c_slaveaddr = emap[j].saddr.addr;
			e_ctrl->i2c_client.cci_client->sid =
					eb_info->i2c_slaveaddr >> 1;
			pr_err("qcom,slave-addr = 0x%X\n",
				eb_info->i2c_slaveaddr);
		}

		if (emap[j].mem.valid_size) {
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), 0x0A00,
				0x04, data_type);
			if (rc < 0) {
				pr_err("%s:(%d) write initial state failed\n", __func__, __LINE__);
				return rc;
			}

			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), 0x0A02, page,
				data_type);
			if (rc < 0) {
				pr_err("%s:(%d) write page failed\n", __func__, __LINE__);
				return rc;
			}

			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
				&(e_ctrl->i2c_client), 0x0A00,
				0x01, data_type);
			if (rc < 0) {
				pr_err("%s:(%d) set read mode failed\n", __func__, __LINE__);
				return rc;
			}

#ifdef CONFIG_S5K5E9YX
			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_poll(
				&(e_ctrl->i2c_client), S5K5E9_OTP_ERROR_FLAG_REGISTER,
				0x01, MSM_CAMERA_I2C_BYTE_DATA, 1);
			if (rc < 0) {
				pr_err("%s:(%d) pool read byte failed\n", __func__, __LINE__);
				return rc;
			}

			start_addr = S5K5E9_OTP_PAGE_START_REGISTER + emap[j].mem.addr; //j=0, 0xA10

			while(start_addr > S5K5E9_OTP_PAGE_END_REGISTER) {//	j=1, start_addr will be 0xA40
				start_addr -= S5K5E9_OTP_PAGE_SIZE;
			}
#endif
#ifdef CONFIG_S5K5E3YX
			start_addr = START_ADDR_FOR_S5K5E3_OTP + emap[j].mem.addr;
#endif
			end_addr = start_addr + emap[j].mem.valid_size;

			pr_err("%s: %d page %d start_addr = 0x%X\n",
				__func__, __LINE__, page, start_addr);

#ifdef CONFIG_S5K5E9YX
			total_bytes_to_read = emap[j].mem.valid_size;
			read_bytes = S5K5E9_OTP_PAGE_SIZE - emap[j].mem.addr; //j=0, 52

			while(read_bytes < 0) {  //  j=1, read_bytes will be 4
				read_bytes += S5K5E9_OTP_PAGE_SIZE;
			}

			while (total_bytes_to_read > 0) {
				pr_err("%s: %d page_cnt [%d] read_bytes : %d \n",
				__func__, __LINE__, next_page_count, read_bytes);

				rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read_seq(
					&(e_ctrl->i2c_client), start_addr,
					memptr, read_bytes);
				if (rc < 0) {
					pr_err("%s:(%d) read failed\n", __func__, __LINE__);
					return rc;
				}

				start_addr = S5K5E9_OTP_PAGE_START_REGISTER;

				total_bytes_to_read -= read_bytes;
				memptr += read_bytes;

				if(total_bytes_to_read < S5K5E9_OTP_PAGE_SIZE) {
					read_bytes = total_bytes_to_read;
				} else {
					read_bytes = S5K5E9_OTP_PAGE_SIZE;
				}

				if (total_bytes_to_read > 0) {
					rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
							&(e_ctrl->i2c_client), &finish_read_otp);
					if (rc < 0) {
						pr_err("%s:(%d) finish_read_otp failed\n", __func__, __LINE__);
						return rc;
					}

					next_page_count++;

					rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
						&(e_ctrl->i2c_client), 0x0A02, page + next_page_count,
						data_type);
					if (rc < 0) {
						pr_err("%s:(%d) write page failed\n", __func__, __LINE__);
						return rc;
					}

					rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write(
						&(e_ctrl->i2c_client), 0x0A00,
						0x01, data_type);
					if (rc < 0) {
						pr_err("%s:(%d) set read mode failed\n", __func__, __LINE__);
						return rc;
					}
				}
			}

			page += next_page_count;

#else
			for (i=start_addr; i<end_addr; i++) {
				rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_read(
					&(e_ctrl->i2c_client), i,
					&OTP_Data, data_type);
				if (rc < 0) {
					pr_err("%s:(%d) read failed\n", __func__, __LINE__);
					return rc;
				}
				memptr[i-start_addr] = OTP_Data;
			}
#endif

			rc = e_ctrl->i2c_client.i2c_func_tbl->i2c_write_table(
					&(e_ctrl->i2c_client), &finish_read_otp);
			if (rc < 0) {
				pr_err("%s:(%d) finish_read_otp failed\n", __func__, __LINE__);
				return rc;
			}
		}
	}

#ifdef CONFIG_S5K5E9YX
	memptr = block->mapdata;
#if defined(CONFIG_GET_FRONT_MODULE_ID_OTP)
	memcpy(front_module_id, memptr + S5K5E9_OTP_MODULE_ID_OFFSET, S5K5E9_OTP_MODULE_ID_SIZE);
	front_module_id[S5K5E9_OTP_MODULE_ID_SIZE] = '\0';
#endif
#if defined(CONFIG_GET_FRONT_SENSOR_ID)
	memcpy(front_sensor_id, memptr + S5K5E9_OTP_SENSOR_ID_OFFSET, S5K5E9_OTP_SENSOR_ID_SIZE);
	front_sensor_id[S5K5E9_OTP_SENSOR_ID_SIZE] = '\0';
#endif
#endif

#ifdef MSM_EEPROM_DEBUG
	memptr = block->mapdata;
	for(i=0; i < block->num_data; i+=16)
	{
		pr_err("memptr[%03X]: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X\n", i,
			memptr[i],memptr[i+1],memptr[i+2],memptr[i+3],memptr[i+4],memptr[i+5],memptr[i+6],memptr[i+7],
			memptr[i+8],memptr[i+9],memptr[i+10],memptr[i+11],memptr[i+12],memptr[i+13],memptr[i+14],memptr[i+15]);
	}
#endif
	return rc;
}
#endif

/**
  * msm_eeprom_parse_memory_map() - parse memory map in device node
  * @of:	device node
  * @data:	memory block for output
  *
  * This functions parses @of to fill @data.  It allocates map itself, parses
  * the @of node, calculate total data length, and allocates required buffer.
  * It only fills the map, but does not perform actual reading.
  */
static int msm_eeprom_parse_memory_map(struct device_node *of,
				struct msm_eeprom_memory_block_t *data)
{
	int i, rc = 0;
	char property[PROPERTY_MAXSIZE];
	uint32_t count = 6;
	struct msm_eeprom_memory_map_t *map;
	uint32_t total_size = 0;

	snprintf(property, PROPERTY_MAXSIZE, "qcom,num-blocks");
	rc = of_property_read_u32(of, property, &data->num_map);
	pr_err("%s: otp %s %d\n", __func__, property, data->num_map);
	if (rc < 0) {
		pr_err("%s failed rc %d\n", __func__, rc);
		return rc;
	}

	map = kzalloc((sizeof(*map) * data->num_map), GFP_KERNEL);
	if (!map) {
		pr_err("%s failed line %d\n", __func__, __LINE__);
		return -ENOMEM;
	}
	data->map = map;

	for (i = 0; i < data->num_map; i++) {
		CDBG("%s, %d: i = %d\n", __func__, __LINE__, i);

		snprintf(property, PROPERTY_MAXSIZE, "qcom,page%d", i);
		rc = of_property_read_u32_array(of, property,
				(uint32_t *) &map[i].page, count);
		if (rc < 0) {
			pr_err("%s: failed %d\n", __func__, __LINE__);
			goto ERROR;
		}
#if 0// MSM8992_CAM : Temp eeprom
		snprintf(property, PROPERTY_MAXSIZE,
					"qcom,pageen%d", i);
		rc = of_property_read_u32_array(of, property,
			(uint32_t *) &map[i].pageen, count);
		if (rc < 0)
			CDBG("%s: pageen not needed\n", __func__);

		snprintf(property, PROPERTY_MAXSIZE, "qcom,saddr%d", i);
		rc = of_property_read_u32_array(of, property,
			(uint32_t *) &map[i].saddr.addr, 1);
		if (rc < 0)
			CDBG("%s: saddr not needed - block %d\n", __func__, i);
#endif
		snprintf(property, PROPERTY_MAXSIZE, "qcom,poll%d", i);
		rc = of_property_read_u32_array(of, property,
				(uint32_t *) &map[i].poll, count);
		if (rc < 0) {
			pr_err("%s failed %d\n", __func__, __LINE__);
			goto ERROR;
		}

		snprintf(property, PROPERTY_MAXSIZE, "qcom,mem%d", i);
		rc = of_property_read_u32_array(of, property,
				(uint32_t *) &map[i].mem, count);
		if (rc < 0) {
			pr_err("%s failed %d\n", __func__, __LINE__);
			goto ERROR;
		}

		if(map[i].mem.data_t == 1)
		{
			data->num_data += map[i].mem.valid_size;
		}
	}

	CDBG("%s::%d valid size = %d\n", __func__,__LINE__, data->num_data);

	// if total-size is defined at dtsi file.
	// set num_data as total-size
	snprintf(property, PROPERTY_MAXSIZE, "qcom,total-size");
	rc = of_property_read_u32(of, property, &total_size);
	CDBG("%s::%d  %s %d\n", __func__,__LINE__,property, total_size);

	// if "qcom,total-size" propoerty exists.
	if (rc >= 0) {
		pr_err("%s::%d set num_data as total-size (num_map : %d, total : %d, valid : %d)\n",
			__func__,__LINE__, data->num_map, total_size, data->num_data);
		data->num_data = total_size;
	}

	data->mapdata = kzalloc(data->num_data, GFP_KERNEL);
	if (!data->mapdata) {
		pr_err("%s failed line %d\n", __func__, __LINE__);
		rc = -ENOMEM;
		goto ERROR;
	}
	return rc;

ERROR:
	kfree(data->map);
	memset(data, 0, sizeof(*data));
	return rc;
}

static struct msm_cam_clk_info cam_8960_clk_info[] = {
	[SENSOR_CAM_MCLK] = {"cam_clk", 24000000},
};

static struct msm_cam_clk_info cam_8974_clk_info[] = {
	[SENSOR_CAM_MCLK] = {"cam_src_clk", 24000000},
	[SENSOR_CAM_CLK] = {"cam_clk", 0},
};

static struct v4l2_subdev_core_ops msm_eeprom_subdev_core_ops = {
	.ioctl = msm_eeprom_subdev_ioctl,
};

static struct v4l2_subdev_ops msm_eeprom_subdev_ops = {
	.core = &msm_eeprom_subdev_core_ops,
};

static int msm_eeprom_i2c_probe(struct i2c_client *client,
			 const struct i2c_device_id *id)
{
	int rc = 0;
	uint32_t temp = 0;
	struct msm_eeprom_ctrl_t *e_ctrl = NULL;
	struct msm_camera_power_ctrl_t *power_info = NULL;
	struct device_node *of_node = client->dev.of_node;

	int i = 0;
	int normal_crc_value = 0;

	pr_info("%s otp E\n", __func__);

	if (!of_node) {
		pr_err("%s of_node NULL\n", __func__);
		return -EINVAL;
	}

	if (!i2c_check_functionality(client->adapter, I2C_FUNC_I2C)) {
		pr_err("%s i2c_check_functionality failed\n", __func__);
		goto probe_failure;
	}

	e_ctrl = kzalloc(sizeof(*e_ctrl), GFP_KERNEL);
	if (!e_ctrl) {
		pr_err("%s:%d kzalloc failed\n", __func__, __LINE__);
		return -ENOMEM;
	}
	e_ctrl->eeprom_v4l2_subdev_ops = &msm_eeprom_subdev_ops;
	e_ctrl->eeprom_mutex = &msm_eeprom_mutex;
	CDBG("%s client = 0x%p\n", __func__, client);

	//e_ctrl->eboard_info = (struct msm_eeprom_board_info *)(id->driver_data);
	e_ctrl->eboard_info = kzalloc(sizeof(
		struct msm_eeprom_board_info), GFP_KERNEL);
	if (!e_ctrl->eboard_info) {
		pr_err("%s:%d board info NULL\n", __func__, __LINE__);
		rc = -EINVAL;
		goto memdata_free;
	}

	rc = of_property_read_u32(of_node, "qcom,slave-addr", &temp);
	if (rc < 0) {
		pr_err("%s failed rc %d\n", __func__, rc);
		goto board_free;
	}

	rc = of_property_read_u32(of_node, "cell-index",
			&e_ctrl->subdev_id);
	pr_info("cell-index/subdev_id %d, rc %d\n", e_ctrl->subdev_id, rc);
	if (rc < 0) {
		pr_err("failed read, rc %d\n", rc);
		goto board_free;
	}

	power_info = &e_ctrl->eboard_info->power_info;
	e_ctrl->eboard_info->i2c_slaveaddr = temp;
	e_ctrl->i2c_client.client = client;
	e_ctrl->is_supported = 0;

	pr_info("%s:%d e_ctrl->eboard_info->i2c_slaveaddr = %d\n",
		__func__, __LINE__ , e_ctrl->eboard_info->i2c_slaveaddr);

	/* Set device type as I2C */
	e_ctrl->eeprom_device_type = MSM_CAMERA_I2C_DEVICE;
	e_ctrl->i2c_client.i2c_func_tbl = &msm_eeprom_qup_func_tbl;
	e_ctrl->i2c_client.addr_type = MSM_CAMERA_I2C_WORD_ADDR;
	if (e_ctrl->eboard_info->i2c_slaveaddr != 0) {
		e_ctrl->i2c_client.client->addr = e_ctrl->eboard_info->i2c_slaveaddr;
	}

	power_info->clk_info = cam_8960_clk_info;
	power_info->clk_info_size = ARRAY_SIZE(cam_8960_clk_info);
	power_info->dev = &client->dev;

	rc = of_property_read_string(of_node, "qcom,eeprom-name",
		&e_ctrl->eboard_info->eeprom_name);
	pr_info("%s qcom,eeprom-name %s, rc %d\n", __func__,
		e_ctrl->eboard_info->eeprom_name, rc);
	if (rc < 0) {
		pr_err("%s failed %d\n", __func__, __LINE__);
		goto board_free;
	}
	rc = msm_eeprom_get_dt_data(e_ctrl);
	if (rc)
		goto board_free;
	rc = msm_eeprom_parse_memory_map(of_node, &e_ctrl->cal_data);
	if (rc < 0)
		pr_err("%s: no cal memory map\n", __func__);
	if (e_ctrl->cal_data.mapdata)
		map_data = e_ctrl->cal_data.mapdata;
	rc = msm_camera_power_up(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc) {
		pr_err("failed rc %d\n", rc);
		goto memdata_free;
	}

	normal_crc_value = 0;
	for(i = 0; i < e_ctrl->cal_data.num_map>>1; i ++)
		normal_crc_value |= (1 << i);
	CDBG("num_map = %d, Normal CRC value = 0x%X\n",
		e_ctrl->cal_data.num_map, normal_crc_value);

	rc = read_eeprom_memory(e_ctrl, &e_ctrl->cal_data);
	if (rc < 0) {
		pr_err("%s read_eeprom_memory failed\n", __func__);
		goto power_down;
	}
	for (i = 0; i < e_ctrl->cal_data.num_data; i++) {
		CDBG("memory_data[0x%02X] = 0x%02X\n", i, e_ctrl->cal_data.mapdata[i]);
	}

	e_ctrl->is_supported |= msm_eeprom_match_crc(&e_ctrl->cal_data);

	if(e_ctrl->is_supported != normal_crc_value) {
		pr_err("%s : any CRC value(s) are not matched.\n", __func__);
	} else {
		pr_err("%s : All CRC values are matched.\n", __func__);
	}

	rc = msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc) {
		pr_err("failed rc %d\n", rc);
		goto memdata_free;
	}
	if (0 > of_property_read_u32(of_node, "qcom,sensor-position", &temp)) {
		pr_err("%s:%d Fail position, Default sensor position\n", __func__, __LINE__);
		temp = 0;
	}
	pr_err("%s qcom,sensor-position %d\n", __func__,temp);

	/* Initialize sub device */
	v4l2_i2c_subdev_init(&e_ctrl->msm_sd.sd,
		e_ctrl->i2c_client.client,
		e_ctrl->eeprom_v4l2_subdev_ops);
	v4l2_set_subdevdata(&e_ctrl->msm_sd.sd, e_ctrl);
	e_ctrl->msm_sd.sd.internal_ops = &msm_eeprom_internal_ops;
	e_ctrl->msm_sd.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
	media_entity_init(&e_ctrl->msm_sd.sd.entity, 0, NULL, 0);
	e_ctrl->msm_sd.sd.entity.flags = temp;
	e_ctrl->msm_sd.sd.entity.type = MEDIA_ENT_T_V4L2_SUBDEV;
	e_ctrl->msm_sd.sd.entity.group_id = MSM_CAMERA_SUBDEV_EEPROM;
	msm_sd_register(&e_ctrl->msm_sd);
	e_ctrl->is_supported = (e_ctrl->is_supported << 1) | 1;
	pr_info("%s success result=%d is_supported=0x%XX\n", __func__, rc, e_ctrl->is_supported);
	return rc;
power_down:
	msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
board_free:
	kfree(e_ctrl->eboard_info);
memdata_free:
	kfree(e_ctrl);
probe_failure:
	pr_err("%s failed! rc = %d\n", __func__, rc);
	return rc;
}

static int msm_eeprom_i2c_remove(struct i2c_client *client)
{
	struct v4l2_subdev *sd = i2c_get_clientdata(client);
	struct msm_eeprom_ctrl_t  *e_ctrl;
	if (!sd) {
		pr_err("%s: Subdevice is NULL\n", __func__);
		return 0;
	}

	e_ctrl = (struct msm_eeprom_ctrl_t *)v4l2_get_subdevdata(sd);
	if (!e_ctrl) {
		pr_err("%s: eeprom device is NULL\n", __func__);
		return 0;
	}

	kfree(e_ctrl->cal_data.mapdata);
	kfree(e_ctrl->cal_data.map);
	if (e_ctrl->eboard_info) {
		kfree(e_ctrl->eboard_info->power_info.gpio_conf);
		kfree(e_ctrl->eboard_info);
	}
	kfree(e_ctrl);
	return 0;
}

#define msm_eeprom_spi_parse_cmd(spic, str, name, out, size)		\
	{								\
		if (of_property_read_u32_array(				\
			spic->spi_master->dev.of_node,			\
			str, out, size)) {				\
			return -EFAULT;					\
		} else {						\
			spic->cmd_tbl.name.opcode = out[0];		\
			spic->cmd_tbl.name.addr_len = out[1];		\
			spic->cmd_tbl.name.dummy_len = out[2];		\
		}							\
	}

static int msm_eeprom_spi_parse_of(struct msm_camera_spi_client *spic)
{
	int rc = -EFAULT;
	uint32_t tmp[5];
	struct device_node *of = spic->spi_master->dev.of_node;
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-read", read, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-readseq", read_seq, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-queryid", query_id, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-pprog",
				 page_program, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-wenable",
				 write_enable, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-readst",
				 read_status, tmp, 5);
	msm_eeprom_spi_parse_cmd(spic, "qcom,spiop-erase", erase, tmp, 5);

	rc = of_property_read_u32(of, "qcom,spi-busy-mask", tmp);
	if (rc < 0) {
		pr_err("%s: Failed to get busy mask\n", __func__);
		return rc;
	}
	spic->busy_mask = tmp[0];
	rc = of_property_read_u32(of, "qcom,spi-page-size", tmp);
	if (rc < 0) {
		pr_err("%s: Failed to get page size\n", __func__);
		return rc;
	}
	spic->page_size = tmp[0];
	rc = of_property_read_u32(of, "qcom,spi-erase-size", tmp);
	if (rc < 0) {
		pr_err("%s: Failed to get erase size\n", __func__);
		return rc;
	}
	spic->erase_size = tmp[0];

	rc = of_property_read_u32_array(of, "qcom,eeprom-id0", tmp, 2);
	if (rc < 0) {
		pr_err("%s: Failed to get eeprom id 0\n", __func__);
		return rc;
	}
	spic->mfr_id0 = tmp[0];
	spic->device_id0 = tmp[1];

	rc = of_property_read_u32_array(of, "qcom,eeprom-id1", tmp, 2);
	if (rc < 0) {
		pr_err("%s: Failed to get eeprom id 1\n", __func__);
		return rc;
	}
	spic->mfr_id1 = tmp[0];
	spic->device_id1 = tmp[1];

	return 0;
}


static int msm_eeprom_match_id(struct msm_eeprom_ctrl_t *e_ctrl)
{
	int rc;
	struct msm_camera_i2c_client *client = &e_ctrl->i2c_client;
	uint8_t id[2];
	rc = msm_camera_spi_query_id(client, 0, &id[0], 2);
	if (rc < 0)
		return rc;

	pr_info("%s: read 0x%02X%02X, check Fidelix 16M:0x%02X%02X, Winbond 8M:0x%02X%02X\n", __func__,
		id[0], id[1], client->spi_client->mfr_id0, client->spi_client->device_id0,
		client->spi_client->mfr_id1, client->spi_client->device_id1);

	if ((id[0] == client->spi_client->mfr_id0 && id[1] == client->spi_client->device_id0)
	|| (id[0] == client->spi_client->mfr_id1 && id[1] == client->spi_client->device_id1))
		return 0;

	return -ENODEV;
}


static int msm_eeprom_get_dt_data(struct msm_eeprom_ctrl_t *e_ctrl)
{
	int rc = 0, i = 0;
	struct msm_eeprom_board_info *eb_info;
	struct msm_camera_power_ctrl_t *power_info =
		&e_ctrl->eboard_info->power_info;
	struct device_node *of_node = NULL;
	struct msm_camera_gpio_conf *gconf = NULL;
	uint16_t gpio_array_size = 0;
	uint16_t *gpio_array = NULL;

	eb_info = e_ctrl->eboard_info;
	if (e_ctrl->eeprom_device_type == MSM_CAMERA_SPI_DEVICE)
		of_node = e_ctrl->i2c_client.
			spi_client->spi_master->dev.of_node;
	else if (e_ctrl->eeprom_device_type == MSM_CAMERA_PLATFORM_DEVICE)
		of_node = e_ctrl->pdev->dev.of_node;
	else if (e_ctrl->eeprom_device_type == MSM_CAMERA_I2C_DEVICE)
		of_node = e_ctrl->i2c_client.client->dev.of_node;

	rc = msm_camera_get_dt_vreg_data(of_node, &power_info->cam_vreg,
					&power_info->num_vreg);
	if (rc < 0) {
		pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
		return rc;
	}

	pr_info("msm_camera_get_dt_power_setting_data : %d\n", __LINE__);
	rc = msm_camera_get_dt_power_setting_data(of_node,
		power_info->cam_vreg, power_info->num_vreg,
		power_info);
	if (rc < 0) {
		pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
		goto ERROR1;
	}

	power_info->gpio_conf = kzalloc(sizeof(struct msm_camera_gpio_conf),
					GFP_KERNEL);
	if (!power_info->gpio_conf) {
		pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
		rc = -ENOMEM;
		goto ERROR2;
	}
	gconf = power_info->gpio_conf;
	gpio_array_size = of_gpio_count(of_node);
	pr_info("%s gpio count %d\n", __func__, gpio_array_size);

	if (gpio_array_size) {
		gpio_array = kzalloc(sizeof(uint16_t) * gpio_array_size,
			GFP_KERNEL);
		if (!gpio_array) {
			pr_err("%s failed %d\n", __func__, __LINE__);
			goto ERROR3;
		}
		for (i = 0; i < gpio_array_size; i++) {
			gpio_array[i] = of_get_gpio(of_node, i);
#if 0
			CDBG("%s gpio_array[%d] = %d\n", __func__, i,
				gpio_array[i]);
#endif
		}

		pr_info("msm_eeprom_get_dt_data: %d\n", __LINE__);
		rc = msm_camera_get_dt_gpio_req_tbl(of_node, gconf,
			gpio_array, gpio_array_size);
		if (rc < 0) {
			pr_err("%s failed %d\n", __func__, __LINE__);
			goto ERROR4;
		}

		pr_info("msm_eeprom_get_dt_data: %d\n", __LINE__);
		rc = msm_camera_init_gpio_pin_tbl(of_node, gconf,
			gpio_array, gpio_array_size);
		if (rc < 0) {
			pr_err("%s failed %d\n", __func__, __LINE__);
			goto ERROR4;
		}
		pr_info("msm_eeprom_get_dt_data: %d\n", __LINE__);
		kfree(gpio_array);
	}

	pr_info("msm_eeprom_get_dt_data: %d\n", __LINE__);
	return rc;
ERROR4:
	pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
	kfree(gpio_array);
ERROR3:
	pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
	kfree(power_info->gpio_conf);
ERROR2:
	pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
	kfree(power_info->cam_vreg);
ERROR1:
	pr_err("msm_eeprom_get_dt_data: %d\n", __LINE__);
	kfree(power_info->power_setting);
	return rc;
}

#ifdef CONFIG_COMPAT

static int msm_eeprom_config32(struct msm_eeprom_ctrl_t *e_ctrl,
	void __user *argp)
{
	struct msm_eeprom_cfg_data32 *cdata32 = (struct msm_eeprom_cfg_data32 *)argp;
	struct msm_eeprom_cfg_data cdata;
	int rc = 0;

	CDBG("%s:%d E: subdevid: %d\n",__func__,__LINE__,e_ctrl->subdev_id);
	cdata.cfgtype = cdata32->cfgtype;
	CDBG("%s:%d cfgtype = %d\n", __func__, __LINE__, cdata.cfgtype);
	switch (cdata.cfgtype) {
	case CFG_EEPROM_GET_INFO:
		CDBG("%s E CFG_EEPROM_GET_INFO: %d, %s\n",
			__func__, e_ctrl->is_supported, e_ctrl->eboard_info->eeprom_name);
		cdata32->is_supported = e_ctrl->is_supported;
		memcpy(cdata32->cfg.eeprom_name,
			e_ctrl->eboard_info->eeprom_name,
			sizeof(cdata32->cfg.eeprom_name));
		break;
	case CFG_EEPROM_GET_CAL_DATA:
		CDBG("%s E CFG_EEPROM_GET_CAL_DATA: %d\n", __func__, e_ctrl->cal_data.num_data);
		cdata32->cfg.get_data.num_bytes =
			e_ctrl->cal_data.num_data;
		break;
	case CFG_EEPROM_READ_CAL_DATA:
		CDBG("%s E CFG_EEPROM_READ_CAL_DATA\n", __func__);
		cdata.cfg.read_data.num_bytes = cdata32->cfg.read_data.num_bytes;
		cdata.cfg.read_data.addr = cdata32->cfg.read_data.addr;
		cdata.cfg.read_data.dbuffer = compat_ptr(cdata32->cfg.read_data.dbuffer);
		rc = eeprom_config_read_cal_data(e_ctrl, &cdata);
		break;
	case CFG_EEPROM_READ_DATA:
		CDBG("%s E CFG_EEPROM_READ_DATA\n", __func__);
		cdata.cfg.read_data.num_bytes = cdata32->cfg.read_data.num_bytes;
		cdata.cfg.read_data.addr = cdata32->cfg.read_data.addr;
		cdata.cfg.read_data.dbuffer = compat_ptr(cdata32->cfg.read_data.dbuffer);
		rc = eeprom_config_read_data(e_ctrl, &cdata);
		break;
	case CFG_EEPROM_READ_COMPRESSED_DATA:
		CDBG("%s E CFG_EEPROM_READ_COMPRESSED_DATA\n", __func__);
		cdata.cfg.read_data.num_bytes = cdata32->cfg.read_data.num_bytes;
		cdata.cfg.read_data.addr = cdata32->cfg.read_data.addr;
		cdata.cfg.read_data.comp_size = cdata32->cfg.read_data.comp_size;
		cdata.cfg.read_data.dbuffer = compat_ptr(cdata32->cfg.read_data.dbuffer);
		rc = eeprom_config_read_compressed_data(e_ctrl, &cdata);
		if (rc < 0)
			pr_err("%s : eeprom_config_read_compressed_data failed \n", __func__);
		break;
	case CFG_EEPROM_WRITE_DATA:
		pr_warn("%s E CFG_EEPROM_WRITE_DATA\n", __func__);
		cdata.cfg.write_data.num_bytes = cdata32->cfg.write_data.num_bytes;
		cdata.cfg.write_data.addr = cdata32->cfg.write_data.addr;
		cdata.cfg.write_data.compress = cdata32->cfg.write_data.compress;
		cdata.cfg.write_data.write_size = compat_ptr(cdata32->cfg.write_data.write_size);
		cdata.cfg.write_data.dbuffer = compat_ptr(cdata32->cfg.write_data.dbuffer);
		rc = eeprom_config_write_data(e_ctrl, &cdata);
		break;
	case CFG_EEPROM_READ_DATA_FROM_HW:
		e_ctrl->is_supported = 0x01;
		pr_err ("kernel is_supported before : 0x%04X\n", e_ctrl->is_supported);
		rc = msm_eeprom_read_eeprom_data(e_ctrl);
		pr_err ("kernel is_supported after : 0x%04X\n", e_ctrl->is_supported);

		cdata32->is_supported = e_ctrl->is_supported;
		if (rc < 0) {
			pr_err("%s:%d failed rc %d\n", __func__, __LINE__,  rc);
			break;
		}
		break;
	case CFG_EEPROM_GET_ERASESIZE:
		CDBG("%s E CFG_EEPROM_GET_ERASESIZE: %d\n",
			__func__, e_ctrl->i2c_client.spi_client->erase_size);
		cdata32->cfg.get_data.num_bytes =
			e_ctrl->i2c_client.spi_client->erase_size;
		break;
/*  //compile error fixed
	case CFG_EEPROM_ERASE:
		pr_warn("%s E CFG_EEPROM_ERASE\n", __func__);
		cdata.cfg.erase_data.addr = cdata32->cfg.erase_data.addr;
		cdata.cfg.erase_data.num_bytes = cdata32->cfg.erase_data.num_bytes;
		rc = eeprom_config_erase(e_ctrl, &cdata);
		break;
*/
	case CFG_EEPROM_POWER_ON:
		rc = msm_eeprom_power_up(e_ctrl, NULL);
		if (rc < 0)
			pr_err("%s : msm_eeprom_power_up failed \n", __func__);
		break;
	case CFG_EEPROM_POWER_OFF:
		rc = msm_eeprom_power_down(e_ctrl, true);
		if (rc < 0)
			pr_err("%s : msm_eeprom_power_down failed \n", __func__);
		break;
	case CFG_EEPROM_GET_MM_INFO:
		CDBG("%s E CFG_EEPROM_GET_MM_INFO\n", __func__);
		rc = msm_eeprom_get_cmm_data(e_ctrl, &cdata);
		break;
	default:
		break;
	}
	CDBG("%s X rc: %d\n", __func__, rc);
	return rc;
}

static long msm_eeprom_subdev_ioctl32(struct v4l2_subdev *sd,
		unsigned int cmd, void *arg)
{
	struct msm_eeprom_ctrl_t *e_ctrl = v4l2_get_subdevdata(sd);
	void __user *argp = (void __user *)arg;

	CDBG("%s E\n", __func__);
	CDBG("%s:%d a_ctrl %pK argp %pK\n", __func__, __LINE__, e_ctrl, argp);
	switch (cmd) {
	case VIDIOC_MSM_SENSOR_GET_SUBDEV_ID:
		return msm_eeprom_get_subdev_id(e_ctrl, argp);
	case VIDIOC_MSM_EEPROM_CFG32:
		return msm_eeprom_config32(e_ctrl, argp);
	default:
		return -ENOIOCTLCMD;
	}

	CDBG("%s X\n", __func__);
}

static long msm_eeprom_subdev_do_ioctl32(
	struct file *file, unsigned int cmd, void *arg)
{
	struct video_device *vdev = video_devdata(file);
	struct v4l2_subdev *sd = vdev_to_v4l2_subdev(vdev);

	return msm_eeprom_subdev_ioctl32(sd, cmd, arg);
}

static long msm_eeprom_subdev_fops_ioctl32(struct file *file, unsigned int cmd,
	unsigned long arg)
{
	return video_usercopy(file, cmd, arg, msm_eeprom_subdev_do_ioctl32);
}

#endif

static int msm_eeprom_cmm_dts(struct msm_eeprom_board_info *eb_info,
				struct device_node *of_node)
{
	int rc = 0;
	struct msm_eeprom_cmm_t *cmm_data = &eb_info->cmm_data;

	cmm_data->cmm_support =
		of_property_read_bool(of_node, "qcom,cmm-data-support");
	if (!cmm_data->cmm_support)
		return -EINVAL;
	cmm_data->cmm_compression =
		of_property_read_bool(of_node, "qcom,cmm-data-compressed");
	if (!cmm_data->cmm_compression)
		CDBG("No MM compression data\n");

	rc = of_property_read_u32(of_node, "qcom,cmm-data-offset",
				  &cmm_data->cmm_offset);
	if (rc < 0)
		CDBG("No MM offset data\n");

	rc = of_property_read_u32(of_node, "qcom,cmm-data-size",
				  &cmm_data->cmm_size);
	if (rc < 0)
		CDBG("No MM size data\n");

	CDBG("cmm_support: cmm_compr %d, cmm_offset %d, cmm_size %d\n",
		cmm_data->cmm_compression,
		cmm_data->cmm_offset,
		cmm_data->cmm_size);
	return 0;
}

static int msm_eeprom_spi_setup(struct spi_device *spi)
{
	struct msm_eeprom_ctrl_t *e_ctrl = NULL;
	struct msm_camera_i2c_client *client = NULL;
	struct msm_camera_spi_client *spi_client;
	struct msm_eeprom_board_info *eb_info;
	struct msm_camera_power_ctrl_t *power_info = NULL;
	int rc = 0;
	uint32_t temp = 0;
	int i = 0;
	int normal_crc_value = 0;

	e_ctrl = kzalloc(sizeof(*e_ctrl), GFP_KERNEL);
	if (!e_ctrl) {
		pr_err("%s:%d kzalloc failed\n", __func__, __LINE__);
		return -ENOMEM;
	}
	e_ctrl->eeprom_v4l2_subdev_ops = &msm_eeprom_subdev_ops;
	e_ctrl->eeprom_mutex = &msm_eeprom_mutex;
	client = &e_ctrl->i2c_client;
	e_ctrl->is_supported = 0;

	spi_client = kzalloc(sizeof(*spi_client), GFP_KERNEL);
	if (!spi_client) {
		pr_err("%s:%d kzalloc failed\n", __func__, __LINE__);
		kfree(e_ctrl);
		return -ENOMEM;
	}

	rc = of_property_read_u32(spi->dev.of_node, "cell-index",
				  &e_ctrl->subdev_id);
	CDBG("cell-index/subdev_id %d, rc %d\n", e_ctrl->subdev_id, rc);
	if (rc < 0) {
		pr_err("failed rc %d\n", rc);
		goto spi_free;
	}

	e_ctrl->eeprom_device_type = MSM_CAMERA_SPI_DEVICE;
	client->spi_client = spi_client;
	spi_client->spi_master = spi;
	client->i2c_func_tbl = &msm_eeprom_spi_func_tbl;
	client->addr_type = MSM_CAMERA_I2C_3B_ADDR;

	eb_info = kzalloc(sizeof(*eb_info), GFP_KERNEL);
	if (!eb_info)
		goto spi_free;
	e_ctrl->eboard_info = eb_info;
	rc = of_property_read_string(spi->dev.of_node, "qcom,eeprom-name",
		&eb_info->eeprom_name);
	CDBG("%s qcom,eeprom-name %s, rc %d\n", __func__,
		eb_info->eeprom_name, rc);
	if (rc < 0) {
		pr_err("%s failed %d\n", __func__, __LINE__);
		goto board_free;
	}

	rc = msm_eeprom_cmm_dts(e_ctrl->eboard_info, spi->dev.of_node);
	if (rc < 0)
		CDBG("%s MM data miss:%d\n", __func__, __LINE__);

	power_info = &eb_info->power_info;

	power_info->clk_info = cam_8974_clk_info;
	power_info->clk_info_size = ARRAY_SIZE(cam_8974_clk_info);
	power_info->dev = &spi->dev;

	rc = msm_eeprom_get_dt_data(e_ctrl);
	if (rc < 0)
		goto board_free;

	/* set spi instruction info */
	spi_client->retry_delay = 1;
	spi_client->retries = 0;

	rc = msm_eeprom_spi_parse_of(spi_client);
	if (rc < 0) {
		dev_err(&spi->dev,
			"%s: Error parsing device properties\n", __func__);
		goto board_free;
	}

	/* prepare memory buffer */
	rc = msm_eeprom_parse_memory_map(spi->dev.of_node,
					 &e_ctrl->cal_data);
	if (rc < 0)
		CDBG("%s: no cal memory map\n", __func__);

	/* power up eeprom for reading */
	rc = msm_camera_power_up(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc < 0) {
		pr_err("failed rc %d\n", rc);
		goto caldata_free;
	}

	/* check eeprom id */
	rc = msm_eeprom_match_id(e_ctrl);
	if (rc < 0) {
		CDBG("%s: eeprom not matching %d\n", __func__, rc);
		goto power_down;
	}

	normal_crc_value = 0;
	for(i = 0; i < e_ctrl->cal_data.num_map>>1; i ++)
		normal_crc_value |= (1 << i);
	CDBG("num_map = %d, Normal CRC value = 0x%X\n",
		e_ctrl->cal_data.num_map, normal_crc_value);

	/* read eeprom */
	if (e_ctrl->cal_data.map) {
		rc = read_eeprom_memory(e_ctrl, &e_ctrl->cal_data);
		if (rc < 0) {
			pr_err("%s: read cal data failed\n", __func__);
			goto power_down;
		}
		e_ctrl->is_supported |= msm_eeprom_match_crc(&e_ctrl->cal_data);

		if(e_ctrl->is_supported != normal_crc_value) {
			pr_err("%s : any CRC value(s) are not matched.\n", __func__);
		} else {
			pr_err("%s : All CRC values are matched.\n", __func__);
		}
	}

	rc = msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc < 0) {
		pr_err("failed rc %d\n", rc);
		goto caldata_free;
	}

	if (0 > of_property_read_u32(spi->dev.of_node, "qcom,sensor-position", &temp)) {
		pr_err("%s:%d Fail position, Default sensor position\n", __func__, __LINE__);
		temp = 0;
	}

	/* initiazlie subdev */
	v4l2_spi_subdev_init(&e_ctrl->msm_sd.sd,
		e_ctrl->i2c_client.spi_client->spi_master,
		e_ctrl->eeprom_v4l2_subdev_ops);
	v4l2_set_subdevdata(&e_ctrl->msm_sd.sd, e_ctrl);
	e_ctrl->msm_sd.sd.internal_ops = &msm_eeprom_internal_ops;
	e_ctrl->msm_sd.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
	media_entity_init(&e_ctrl->msm_sd.sd.entity, 0, NULL, 0);
	e_ctrl->msm_sd.sd.entity.flags = temp;
	e_ctrl->msm_sd.sd.entity.type = MEDIA_ENT_T_V4L2_SUBDEV;
	e_ctrl->msm_sd.sd.entity.group_id = MSM_CAMERA_SUBDEV_EEPROM;
	msm_sd_register(&e_ctrl->msm_sd);
	e_ctrl->is_supported = (e_ctrl->is_supported << 1) | 1;
	CDBG("%s success result=%d supported=%x X\n", __func__, rc,
		e_ctrl->is_supported);

	return 0;

power_down:
	msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
caldata_free:
	kfree(e_ctrl->cal_data.mapdata);
	kfree(e_ctrl->cal_data.map);
board_free:
	kfree(e_ctrl->eboard_info);
spi_free:
	kfree(spi_client);
	kfree(e_ctrl);
	return rc;
}

static int msm_eeprom_spi_probe(struct spi_device *spi)
{
	int irq, cs, cpha, cpol, cs_high;

	pr_err("%s\n", __func__);
	spi->bits_per_word = 8;
	spi->mode = SPI_MODE_0;
	spi_setup(spi);

	irq = spi->irq;
	cs = spi->chip_select;
	cpha = (spi->mode & SPI_CPHA) ? 1 : 0;
	cpol = (spi->mode & SPI_CPOL) ? 1 : 0;
	cs_high = (spi->mode & SPI_CS_HIGH) ? 1 : 0;
	pr_err("%s: irq[%d] cs[%x] CPHA[%x] CPOL[%x] CS_HIGH[%x]\n",
			__func__, irq, cs, cpha, cpol, cs_high);
	pr_err("%s: max_speed[%u]\n", __func__, spi->max_speed_hz);

	return msm_eeprom_spi_setup(spi);
}

static int msm_eeprom_spi_remove(struct spi_device *sdev)
{
	struct v4l2_subdev *sd = spi_get_drvdata(sdev);
	struct msm_eeprom_ctrl_t  *e_ctrl;
	if (!sd) {
		pr_err("%s: Subdevice is NULL\n", __func__);
		return 0;
	}

	e_ctrl = (struct msm_eeprom_ctrl_t *)v4l2_get_subdevdata(sd);
	if (!e_ctrl) {
		pr_err("%s: eeprom device is NULL\n", __func__);
		return 0;
	}

	kfree(e_ctrl->i2c_client.spi_client);
	kfree(e_ctrl->cal_data.mapdata);
	kfree(e_ctrl->cal_data.map);
	if (e_ctrl->eboard_info) {
		kfree(e_ctrl->eboard_info->power_info.gpio_conf);
		kfree(e_ctrl->eboard_info);
	}
	kfree(e_ctrl);
	return 0;
}

static int msm_otp_platform_probe(struct platform_device *pdev)
{
	int rc = 0;
	int retry_count = 0;
	uint32_t temp;
	int i = 0;
	int normal_crc_value = 0;

	struct msm_camera_cci_client *cci_client = NULL;
	struct msm_eeprom_ctrl_t *e_ctrl = NULL;
	struct msm_eeprom_board_info *eb_info = NULL;
	struct device_node *of_node = pdev->dev.of_node;
	struct msm_camera_power_ctrl_t *power_info = NULL;

	CDBG("%s:%d otp E\n", __func__, __LINE__);

	e_ctrl = kzalloc(sizeof(*e_ctrl), GFP_KERNEL);
	if (!e_ctrl) {
		pr_err("%s:%d kzalloc failed\n", __func__, __LINE__);
		return -ENOMEM;
	}
	e_ctrl->eeprom_v4l2_subdev_ops = &msm_eeprom_subdev_ops;
	e_ctrl->eeprom_mutex = &msm_eeprom_mutex;

	e_ctrl->is_supported = 0;
	if (!of_node) {
		pr_err("%s dev.of_node NULL\n", __func__);
		kfree(e_ctrl);
		return -EINVAL;
	}

	rc = of_property_read_u32(of_node, "cell-index",
		&pdev->id);
	CDBG("cell-index %d, rc %d\n", pdev->id, rc);
	if (rc < 0) {
		pr_err("failed rc %d\n", rc);
		kfree(e_ctrl);
		return rc;
	}
	e_ctrl->subdev_id = pdev->id;

	rc = of_property_read_u32(of_node, "qcom,cci-master",
		&e_ctrl->cci_master);
	CDBG("qcom,cci-master %d, rc %d\n", e_ctrl->cci_master, rc);
	if (rc < 0) {
		pr_err("%s failed rc %d\n", __func__, rc);
		kfree(e_ctrl);
		return rc;
	}
	rc = of_property_read_u32(of_node, "qcom,slave-addr",
		&temp);
	if (rc < 0) {
		pr_err("%s failed rc %d\n", __func__, rc);
		kfree(e_ctrl);
		return rc;
	}

	/* Set platform device handle */
	e_ctrl->pdev = pdev;
	/* Set device type as platform device */
	e_ctrl->eeprom_device_type = MSM_CAMERA_PLATFORM_DEVICE;
	e_ctrl->i2c_client.i2c_func_tbl = &msm_eeprom_cci_func_tbl;
	e_ctrl->i2c_client.addr_type = MSM_CAMERA_I2C_WORD_ADDR;
	e_ctrl->i2c_client.cci_client = kzalloc(sizeof(
		struct msm_camera_cci_client), GFP_KERNEL);
	if (!e_ctrl->i2c_client.cci_client) {
		pr_err("%s failed no memory\n", __func__);
		kfree(e_ctrl);
		return -ENOMEM;
	}

	e_ctrl->eboard_info = kzalloc(sizeof(
		struct msm_eeprom_board_info), GFP_KERNEL);
	if (!e_ctrl->eboard_info) {
		pr_err("%s failed line %d\n", __func__, __LINE__);
		rc = -ENOMEM;
		goto cciclient_free;
	}
	eb_info = e_ctrl->eboard_info;
	power_info = &eb_info->power_info;
	eb_info->i2c_slaveaddr = temp;

	power_info->clk_info = cam_8974_clk_info;
	power_info->clk_info_size = ARRAY_SIZE(cam_8974_clk_info);
	power_info->dev = &pdev->dev;

	CDBG("qcom,slave-addr = 0x%X\n", eb_info->i2c_slaveaddr);
	cci_client = e_ctrl->i2c_client.cci_client;
	cci_client->cci_subdev = msm_cci_get_subdev();
	cci_client->cci_i2c_master = e_ctrl->cci_master;
	cci_client->sid = eb_info->i2c_slaveaddr >> 1;
	cci_client->retries = 3;
	cci_client->id_map = 0;
	cci_client->i2c_freq_mode = I2C_FAST_MODE;

	rc = of_property_read_string(of_node, "qcom,eeprom-name",
		&eb_info->eeprom_name);
	CDBG("%s qcom,eeprom-name %s, rc %d\n", __func__,
		eb_info->eeprom_name, rc);
	if (rc < 0) {
		pr_err("%s failed %d\n", __func__, __LINE__);
		goto board_free;
	}

	rc = msm_eeprom_cmm_dts(e_ctrl->eboard_info, of_node);
	if (rc < 0)
		CDBG("%s MM data miss:%d\n", __func__, __LINE__);

	rc = msm_eeprom_get_dt_data(e_ctrl);
	if (rc)
		goto board_free;

	/* Get clocks information */
	rc = msm_camera_get_clk_info(
		e_ctrl->pdev,
		&power_info->clk_info,
		&power_info->clk_ptr,
		&power_info->clk_info_size);
	if (rc < 0) {
		pr_err("failed: msm_camera_i2c_dev_get_clk_info rc %d", rc);
		goto board_free;
	}

	rc = msm_eeprom_parse_memory_map(of_node, &e_ctrl->cal_data);
	if (rc < 0)
		goto board_free;

	if (e_ctrl->cal_data.mapdata)
		map_data = e_ctrl->cal_data.mapdata;
RETRY:
	rc = msm_camera_power_up(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc) {
		pr_err("failed rc %d\n", rc);
		goto memdata_free;
	}
	if (e_ctrl->cal_data.map) {
		normal_crc_value = 0;
		for(i = 0; i < e_ctrl->cal_data.num_map>>1; i ++)
			normal_crc_value |= (1 << i);
		CDBG("num_map = %d, Normal CRC value = 0x%X\n",
			e_ctrl->cal_data.num_map, normal_crc_value);

		rc = read_eeprom_memory(e_ctrl, &e_ctrl->cal_data);
		if (rc < 0) {
			pr_err("%s read_eeprom_memory failed (%d)\n", __func__, retry_count);
			//Added retry code, sometimes, GPIO request is failed
			if(retry_count == 3) {
				goto power_down;
			} else {
				retry_count++;
				msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
					&e_ctrl->i2c_client);
				goto RETRY;
			}
		}
		for (i = 0; i < e_ctrl->cal_data.num_data; i++) {
			CDBG("memory_data[%d] = 0x%X\n", i, e_ctrl->cal_data.mapdata[i]);
		}


		e_ctrl->is_supported |= msm_eeprom_match_crc(&e_ctrl->cal_data);

		if(e_ctrl->is_supported != normal_crc_value) {
			pr_err("%s : any CRC value(s) are not matched.\n", __func__);
		} else {
			pr_err("%s : All CRC values are matched.\n", __func__);
		}
	}
	rc = msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);
	if (rc) {
		pr_err("failed rc %d\n", rc);
		goto memdata_free;
	}

	if (0 > of_property_read_u32(of_node, "qcom,sensor-position", &temp)) {
		pr_err("%s:%d Fail position, Default sensor position\n", __func__, __LINE__);
		temp = 0;
	}
	pr_info("%s qcom,sensor-position %d\n", __func__,temp);

	v4l2_subdev_init(&e_ctrl->msm_sd.sd,
		e_ctrl->eeprom_v4l2_subdev_ops);
	v4l2_set_subdevdata(&e_ctrl->msm_sd.sd, e_ctrl);
	platform_set_drvdata(pdev, &e_ctrl->msm_sd.sd);
	e_ctrl->msm_sd.sd.internal_ops = &msm_eeprom_internal_ops;
	e_ctrl->msm_sd.sd.flags |= V4L2_SUBDEV_FL_HAS_DEVNODE;
	snprintf(e_ctrl->msm_sd.sd.name,
		ARRAY_SIZE(e_ctrl->msm_sd.sd.name), "msm_otp");
	media_entity_init(&e_ctrl->msm_sd.sd.entity, 0, NULL, 0);
	e_ctrl->msm_sd.sd.entity.flags = temp;
	e_ctrl->msm_sd.sd.entity.type = MEDIA_ENT_T_V4L2_SUBDEV;
	e_ctrl->msm_sd.sd.entity.group_id = MSM_CAMERA_SUBDEV_EEPROM;
	msm_sd_register(&e_ctrl->msm_sd);
	e_ctrl->is_supported = (e_ctrl->is_supported << 1) | 1;
	pr_err("%s Front is_supported=0x%02X\n",
		__func__, e_ctrl->is_supported);

#ifdef CONFIG_COMPAT
	msm_eeprom_v4l2_subdev_fops = v4l2_subdev_fops;
	msm_eeprom_v4l2_subdev_fops.compat_ioctl32 =
		msm_eeprom_subdev_fops_ioctl32;
	e_ctrl->msm_sd.sd.devnode->fops = &msm_eeprom_v4l2_subdev_fops;
#endif
	CDBG("%s X\n", __func__);
	return rc;
power_down:
	msm_camera_power_down(power_info, e_ctrl->eeprom_device_type,
		&e_ctrl->i2c_client);

memdata_free:
	kfree(e_ctrl->cal_data.mapdata);
	kfree(e_ctrl->cal_data.map);
board_free:
	kfree(e_ctrl->eboard_info);
cciclient_free:
	kfree(e_ctrl->i2c_client.cci_client);
	kfree(e_ctrl);
	return rc;
}

static int msm_otp_platform_remove(struct platform_device *pdev)
{
	struct v4l2_subdev *sd = platform_get_drvdata(pdev);
	struct msm_eeprom_ctrl_t  *e_ctrl;
	if (!sd) {
		pr_err("%s: Subdevice is NULL\n", __func__);
		return 0;
	}

	e_ctrl = (struct msm_eeprom_ctrl_t *)v4l2_get_subdevdata(sd);
	if (!e_ctrl) {
		pr_err("%s: eeprom device is NULL\n", __func__);
		return 0;
	}

	kfree(e_ctrl->i2c_client.cci_client);
	kfree(e_ctrl->cal_data.mapdata);
	kfree(e_ctrl->cal_data.map);
	if (e_ctrl->eboard_info) {
		kfree(e_ctrl->eboard_info->power_info.gpio_conf);
		kfree(e_ctrl->eboard_info);
	}
	kfree(e_ctrl);
	return 0;
}

static const struct of_device_id msm_otp_dt_match[] = {
	{ .compatible = "qcom,otp" },
	{ }
};

MODULE_DEVICE_TABLE(of, msm_otp_dt_match);

static struct platform_driver msm_otp_platform_driver = {
	.driver = {
		.name = "qcom,otp",
		.owner = THIS_MODULE,
		.of_match_table = msm_otp_dt_match,
	},
	.probe = msm_otp_platform_probe,
	.remove = msm_otp_platform_remove,
};

static const struct of_device_id msm_eeprom_i2c_dt_match[] = {
	{ .compatible = "qcom,otp"},
	{ }
};

MODULE_DEVICE_TABLE(of, msm_eeprom_i2c_dt_match);

static const struct i2c_device_id msm_eeprom_i2c_id[] = {
	{ "qcom,otp", (kernel_ulong_t)NULL},
	{ }
};

static struct i2c_driver msm_eeprom_i2c_driver = {
	.id_table = msm_eeprom_i2c_id,
	.probe  = msm_eeprom_i2c_probe,
	.remove = msm_eeprom_i2c_remove,
	.driver = {
		.name = "qcom,otp",
		.owner = THIS_MODULE,
		.of_match_table = msm_eeprom_i2c_dt_match,
	},
};

static struct spi_driver msm_eeprom_spi_driver = {
	.driver = {
		.name = "qcom_otp",
		.owner = THIS_MODULE,
		.of_match_table = msm_otp_dt_match,
	},
	.probe = msm_eeprom_spi_probe,
	.remove = msm_eeprom_spi_remove,
};

static int __init msm_eeprom_init_module(void)
{
	int rc = 0;
	CDBG("%s:%d otp E\n", __func__, __LINE__);
	rc = platform_driver_register(&msm_otp_platform_driver);
	CDBG("%s:%d otp platform rc %d\n", __func__, __LINE__, rc);
	rc = i2c_add_driver(&msm_eeprom_i2c_driver);
	if (rc < 0)
		pr_err("%s:%d otp probe failed\n", __func__, __LINE__);
	else
		pr_info("%s:%d otp probe succeed\n", __func__, __LINE__);

	return rc;
}

static void __exit msm_eeprom_exit_module(void)
{
	platform_driver_unregister(&msm_otp_platform_driver);
	spi_unregister_driver(&msm_eeprom_spi_driver);
	i2c_del_driver(&msm_eeprom_i2c_driver);
}

module_init(msm_eeprom_init_module);
module_exit(msm_eeprom_exit_module);
MODULE_DESCRIPTION("MSM EEPROM driver");
MODULE_LICENSE("GPL v2");
