/*
 * =================================================================
 *
 *
 *	Description:  samsung display common file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/

#ifndef _SAMSUNG_DSI_MDNIE_TD4100_BS050HDM_
#define _SAMSUNG_DSI_MDNIE_TD4100_BS050HDM_

#include "../ss_dsi_mdnie_lite_common.h"

#define MDNIE_COLOR_BLINDE_CMD_OFFSET 0

#define ADDRESS_SCR_WHITE_RED   0x0
#define ADDRESS_SCR_WHITE_GREEN 0x0
#define ADDRESS_SCR_WHITE_BLUE  0x0

#define MDNIE_RGB_SENSOR_INDEX	0

#define MDNIE_STEP1_INDEX 0
#define MDNIE_STEP2_INDEX 1

static char AUTO_DSI0_UI_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};
	
static char AUTO_DSI0_UI_MDNIE_2[] ={
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_UI_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_UI_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x01,
	0x03,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_UI_MDNIE_5[] ={
	0x55,
	0x00,
};

static char DSI0_HBM_CE_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};
static char DSI0_HBM_CE_MDNIE_2[] ={
	0xC7,
	0x08,
	0x1D,
	0x2A,
	0x3C,
	0x49,
	0x55,
	0x6C,
	0x7D,
	0x89,
	0x94,
	0x45,
	0x50,
	0x5C,
	0x6B,
	0x72,
	0x7C,
	0x89,
	0x95,
	0xBF,
	0x08,
	0x1D,
	0x2A,
	0x3C,
	0x49,
	0x55,
	0x6C,
	0x7D,
	0x89,
	0x94,
	0x45,
	0x50,
	0x5C,
	0x6B,
	0x72,
	0x7C,
	0x89,
	0x95,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char DSI0_HBM_CE_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char DSI0_HBM_CE_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x01,
	0x03,
	0x45,
	0x00,
	0x00,
};

static char DSI0_HBM_CE_MDNIE_5[] ={
	0x55,
	0x00,
};

static char AUTO_DSI0_VIDEO_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};
static char AUTO_DSI0_VIDEO_MDNIE_2[] ={
	0xC7,
	0x08,
	0x13,
	0x1E,
	0x30,
	0x42,
	0x50,
	0x6F,
	0x81,
	0x92,
	0xA0,
	0x54,
	0x61,
	0x71,
	0x83,
	0x8D,
	0x99,
	0xA6,
	0xB0,
	0xBF,
	0x08,
	0x13,
	0x1E,
	0x30,
	0x42,
	0x50,
	0x6F,
	0x81,
	0x92,
	0xA0,
	0x54,
	0x61,
	0x71,
	0x83,
	0x8D,
	0x99,
	0xA6,
	0xB0,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_VIDEO_MDNIE_3[] = {
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_VIDEO_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x04,
	0x04,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_VIDEO_MDNIE_5[] ={
	0x55,
	0x03,
};

static char AUTO_DSI0_CAMERA_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};
static char AUTO_DSI0_CAMERA_MDNIE_2[] ={
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_CAMERA_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_CAMERA_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x04,
	0x04,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_CAMERA_MDNIE_5[] ={
	0x55,
	0x03,
};

static char AUTO_DSI0_EBOOK_MDNIE_1[] = {
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};

static char AUTO_DSI0_EBOOK_MDNIE_2[] = {
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_EBOOK_MDNIE_3[] = {
	0xC8,
	0x01,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xE7,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x48,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xE7,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x48,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xE7,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x48,
};

static char AUTO_DSI0_EBOOK_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x01,
	0x03,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_EBOOK_MDNIE_5[] ={
	0x55,
	0x00,
};

static char AUTO_DSI0_GAME_LOW_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};

static char AUTO_DSI0_GAME_LOW_MDNIE_2[] ={
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_GAME_LOW_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_GAME_LOW_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x04,
	0x04,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_GAME_LOW_MDNIE_5[] ={
	0x55,
	0x03,
};

static char AUTO_DSI0_GAME_MID_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};

static char AUTO_DSI0_GAME_MID_MDNIE_2[] ={
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_GAME_MID_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_GAME_MID_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x04,
	0x04,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_GAME_MID_MDNIE_5[] ={
	0x55,
	0x03,
};

static char AUTO_DSI0_GAME_HIGH_MDNIE_1[] ={
	0xCA,
	0x1D, 
	0xFC, 
	0xFC, 
	0xFC, 
	0xF3, 
	0x06, 
	0xFE, 
	0x00, 
	0x20, 
	0xCD,
	0x00, 
	0x0A, 
	0x00, 
	0xE5, 
	0x00, 
	0xEA, 
	0x45, 
	0x2B, 
	0x00, 
	0x00,
	0xEA, 
	0x18, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00, 
	0x00,
	0x00, 
	0x00, 
	0x00,
};

static char AUTO_DSI0_GAME_HIGH_MDNIE_2[] ={
	0xC7,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA2,
	0x57,
	0x65,
	0x73,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x08,
	0x25,
	0x35,
	0x48,
	0x57,
	0x62,
	0x7A,
	0x8A,
	0x96,
	0xA1,
	0x4E,
	0x58,
	0x63,
	0x7E,
	0x86,
	0x91,
	0x9F,
	0xAA,
	0xBF,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
	0x00,
	0x97,
};

static char AUTO_DSI0_GAME_HIGH_MDNIE_3[] ={
	0xC8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xFC,
	0x00,
};

static char AUTO_DSI0_GAME_HIGH_MDNIE_4[] ={
	0xCE,
	0x7d,
	0x40,
	0x48,
	0x56,
	0x67,
	0x78,
	0x88,
	0x98,
	0xA7,
	0xB5,
	0xC3,
	0xD1,
	0xDE,
	0xE9,
	0xF2,
	0xFA,
	0xFF,
	0x04,
	0x00,
	0x04,
	0x04,
	0x45,
	0x00,
	0x00,
};

static char AUTO_DSI0_GAME_HIGH_MDNIE_5[] ={
	0x55,
	0x03,
};

static unsigned char DYNAMIC_UI_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x17, 0x07, 0x05, 0xFF, 0x00, 0xFF, 0x08,
	0x2E, 0x00, 0x37, 0x00, 0xED, 0x27, 0x35, 0x00, 0x00, 0xFC, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

};

static unsigned char DYNAMIC_UI_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char DYNAMIC_UI_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char DYNAMIC_UI_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char DYNAMIC_UI_5[] ={
	0x55,
	0x00,
};


static unsigned char DYNAMIC_VIDEO_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x17, 0x07, 0x05, 0xFF, 0x00, 0xFF, 0x08,
	0x2E, 0x00, 0x37, 0x00, 0xED, 0x27, 0x35, 0x00, 0x00, 0xFC, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static unsigned char DYNAMIC_VIDEO_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char DYNAMIC_VIDEO_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char DYNAMIC_VIDEO_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char DYNAMIC_VIDEO_5[] ={
	0x55,
	0x00,
};

static unsigned char DYNAMIC_CAMERA_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x17, 0x07, 0x05, 0xFF, 0x00, 0xFF, 0x08,
	0x2E, 0x00, 0x37, 0x00, 0xED, 0x27, 0x35, 0x00, 0x00, 0xFC, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static unsigned char DYNAMIC_CAMERA_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char DYNAMIC_CAMERA_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char DYNAMIC_CAMERA_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char DYNAMIC_CAMERA_5[] ={
	0x55,
	0x00,
};

static unsigned char DYNAMIC_GAME_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x17, 0x07, 0x05, 0xFF, 0x00, 0xFF, 0x08,
	0x2E, 0x00, 0x37, 0x00, 0xED, 0x27, 0x35, 0x00, 0x00, 0xFC, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static unsigned char DYNAMIC_GAME_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char DYNAMIC_GAME_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char DYNAMIC_GAME_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char DYNAMIC_GAME_5[] ={
	0x55,
	0x00,
};



static unsigned char STANDARD_UI_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x5E, 0x29, 0x23, 0x00, 0x00, 0x02,
	0x32, 0x2E, 0x10, 0xDD, 0x00, 0xE7, 0x17, 0x33, 0xD7, 0x00,
	0xED, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,

};

static unsigned char STANDARD_UI_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char STANDARD_UI_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char STANDARD_UI_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char STANDARD_UI_5[] ={
	0x55,
	0x00,
};


static unsigned char STANDARD_VIDEO_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x5E, 0x29, 0x23, 0x00, 0x00, 0x02,
	0x32, 0x2E, 0x10, 0xDD, 0x00, 0xE7, 0x17, 0x33, 0xD7, 0x00,
	0xED, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
};

static unsigned char STANDARD_VIDEO_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char STANDARD_VIDEO_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char STANDARD_VIDEO_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char STANDARD_VIDEO_5[] ={
	0x55,
	0x00,
};


static unsigned char STANDARD_CAMERA_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x5E, 0x29, 0x23, 0x00, 0x00, 0x02,
	0x32, 0x2E, 0x10, 0xDD, 0x00, 0xE7, 0x17, 0x33, 0xD7, 0x00,
	0xED, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
};

static unsigned char STANDARD_CAMERA_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char STANDARD_CAMERA_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char STANDARD_CAMERA_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char STANDARD_CAMERA_5[] ={
	0x55,
	0x00,
};

static unsigned char STANDARD_GAME_1[] = {
	0xCA,
	0x1D, 0xFC, 0xA5, 0x56, 0x5E, 0x29, 0x23, 0x00, 0x00, 0x02,
	0x32, 0x2E, 0x10, 0xDD, 0x00, 0xE7, 0x17, 0x33, 0xD7, 0x00,
	0xED, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
};

static unsigned char STANDARD_GAME_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char STANDARD_GAME_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char STANDARD_GAME_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char STANDARD_GAME_5[] ={
	0x55,
	0x00,
};


static unsigned char NATURAL_UI_1[] = {
	0xCA,
	0x0D, 0xFC, 0xA5, 0x56, 0x34, 0x37, 0x25, 0x7F, 0x32, 0x4A,
	0x1C, 0x2D, 0x00, 0x7F, 0x00, 0xE7, 0x0C, 0x42, 0xFF, 0x00,
	0xF8, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00,

};

static unsigned char NATURAL_UI_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char NATURAL_UI_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char NATURAL_UI_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char NATURAL_UI_5[] ={
	0x55,
	0x00,
};

static unsigned char NATURAL_VIDEO_1[] = {
	0xCA,
	0x0D, 0xFC, 0xA5, 0x56, 0x34, 0x37, 0x25, 0x7F, 0x32, 0x4A,
	0x1C, 0x2D, 0x00, 0x7F, 0x00, 0xE7, 0x0C, 0x42, 0xFF, 0x00,
	0xF8, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00,
};

static unsigned char NATURAL_VIDEO_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char NATURAL_VIDEO_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char NATURAL_VIDEO_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char NATURAL_VIDEO_5[] ={
	0x55,
	0x00,
};

static unsigned char NATURAL_CAMERA_1[] = {
	0xCA,
	0x0D, 0xFC, 0xA5, 0x56, 0x34, 0x37, 0x25, 0x7F, 0x32, 0x4A,
	0x1C, 0x2D, 0x00, 0x7F, 0x00, 0xE7, 0x0C, 0x42, 0xFF, 0x00,
	0xF8, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00,
};

static unsigned char NATURAL_CAMERA_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char NATURAL_CAMERA_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char NATURAL_CAMERA_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char NATURAL_CAMERA_5[] ={
	0x55,
	0x00,
};

static unsigned char NATURAL_GAME_1[] = {
	0xCA,
	0x0D, 0xFC, 0xA5, 0x56, 0x34, 0x37, 0x25, 0x7F, 0x32, 0x4A,
	0x1C, 0x2D, 0x00, 0x7F, 0x00, 0xE7, 0x0C, 0x42, 0xFF, 0x00,
	0xF8, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 	0x00, 0x00, 0x00,
};

static unsigned char NATURAL_GAME_2[] ={
	0xC7,
	0x08, 0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA2,
	0x57, 0x65, 0x73, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x08,
	0x25, 0x35, 0x48, 0x57, 0x62, 0x7A, 0x8A, 0x96, 0xA1, 0x4E,
	0x58, 0x63, 0x7E, 0x86, 0x91, 0x9F, 0xAA, 0xBF, 0x00, 0x97,
	0x00, 0x97, 0x00, 0x97, 0x00, 0x97,
};

static unsigned char NATURAL_GAME_3[] ={
	0xC8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFC, 0x00,
};

static unsigned char NATURAL_GAME_4[] = {
	0xCE,
	0x7D, 0x40, 0x48, 0x56, 0x67, 0x78, 0x88, 0x98, 0xA7, 0xB5,
	0xC3, 0xD1, 0xDE, 0xE9, 0xF2, 0xFA, 0xFF, 0x04, 0x00, 0x01,
	0x03, 0x45, 0x00, 0x00,
};

static unsigned char NATURAL_GAME_5[] ={
	0x55,
	0x00,
};


static struct dsi_cmd_desc AUTO_DSI0_CAMERA_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_CAMERA_MDNIE_1)}, AUTO_DSI0_CAMERA_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_CAMERA_MDNIE_2)}, AUTO_DSI0_CAMERA_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_CAMERA_MDNIE_3)}, AUTO_DSI0_CAMERA_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_CAMERA_MDNIE_4)}, AUTO_DSI0_CAMERA_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_CAMERA_MDNIE_5)}, AUTO_DSI0_CAMERA_MDNIE_5},
};
static struct dsi_cmd_desc AUTO_DSI0_EBOOK_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_EBOOK_MDNIE_1)}, AUTO_DSI0_EBOOK_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_EBOOK_MDNIE_2)}, AUTO_DSI0_EBOOK_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_EBOOK_MDNIE_3)}, AUTO_DSI0_EBOOK_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_EBOOK_MDNIE_4)}, AUTO_DSI0_EBOOK_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_EBOOK_MDNIE_5)}, AUTO_DSI0_EBOOK_MDNIE_5},
};
static struct dsi_cmd_desc DSI0_HBM_CE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_1)}, DSI0_HBM_CE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_2)}, DSI0_HBM_CE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_3)}, DSI0_HBM_CE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_4)}, DSI0_HBM_CE_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_5)}, DSI0_HBM_CE_MDNIE_5},
};
static struct dsi_cmd_desc AUTO_DSI0_UI_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_1)}, AUTO_DSI0_UI_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_2)}, AUTO_DSI0_UI_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_3)}, AUTO_DSI0_UI_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_4)}, AUTO_DSI0_UI_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_5)}, AUTO_DSI0_UI_MDNIE_5},
};
static struct dsi_cmd_desc DSI0_LIGHT_NOTIFICATION_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_1)}, AUTO_DSI0_UI_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_2)}, AUTO_DSI0_UI_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_3)}, AUTO_DSI0_UI_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_4)}, AUTO_DSI0_UI_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_UI_MDNIE_5)}, AUTO_DSI0_UI_MDNIE_5},
};
static struct dsi_cmd_desc AUTO_DSI0_VIDEO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_VIDEO_MDNIE_1)}, AUTO_DSI0_VIDEO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_VIDEO_MDNIE_2)}, AUTO_DSI0_VIDEO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_VIDEO_MDNIE_3)}, AUTO_DSI0_VIDEO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_VIDEO_MDNIE_4)}, AUTO_DSI0_VIDEO_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_VIDEO_MDNIE_5)}, AUTO_DSI0_VIDEO_MDNIE_5},
};
static struct dsi_cmd_desc AUTO_DSI0_GAME_LOW_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_LOW_MDNIE_1)}, AUTO_DSI0_GAME_LOW_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_LOW_MDNIE_2)}, AUTO_DSI0_GAME_LOW_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_LOW_MDNIE_3)}, AUTO_DSI0_GAME_LOW_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_LOW_MDNIE_4)}, AUTO_DSI0_GAME_LOW_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_GAME_LOW_MDNIE_5)}, AUTO_DSI0_GAME_LOW_MDNIE_5},
};
static struct dsi_cmd_desc AUTO_DSI0_GAME_MID_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_MID_MDNIE_1)}, AUTO_DSI0_GAME_MID_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_MID_MDNIE_2)}, AUTO_DSI0_GAME_MID_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_MID_MDNIE_3)}, AUTO_DSI0_GAME_MID_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_MID_MDNIE_4)}, AUTO_DSI0_GAME_MID_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_GAME_MID_MDNIE_5)}, AUTO_DSI0_GAME_MID_MDNIE_5},

};
static struct dsi_cmd_desc AUTO_DSI0_GAME_HIGH_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_HIGH_MDNIE_1)}, AUTO_DSI0_GAME_HIGH_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_HIGH_MDNIE_2)}, AUTO_DSI0_GAME_HIGH_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_HIGH_MDNIE_3)}, AUTO_DSI0_GAME_HIGH_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(AUTO_DSI0_GAME_HIGH_MDNIE_4)}, AUTO_DSI0_GAME_HIGH_MDNIE_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(AUTO_DSI0_GAME_HIGH_MDNIE_5)}, AUTO_DSI0_GAME_HIGH_MDNIE_5},
};
static struct dsi_cmd_desc DYNAMIC_UI[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_UI_1)}, DYNAMIC_UI_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_UI_2)}, DYNAMIC_UI_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_UI_3)}, DYNAMIC_UI_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_UI_4)}, DYNAMIC_UI_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(DYNAMIC_UI_5)}, DYNAMIC_UI_5},
};
static struct dsi_cmd_desc DYNAMIC_VIDEO[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_VIDEO_1)}, DYNAMIC_VIDEO_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_VIDEO_2)}, DYNAMIC_VIDEO_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_VIDEO_3)}, DYNAMIC_VIDEO_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_VIDEO_4)}, DYNAMIC_VIDEO_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(DYNAMIC_VIDEO_5)}, DYNAMIC_VIDEO_5},
};
static struct dsi_cmd_desc DYNAMIC_CAMERA[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_CAMERA_1)}, DYNAMIC_CAMERA_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_CAMERA_2)}, DYNAMIC_CAMERA_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_CAMERA_3)}, DYNAMIC_CAMERA_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_CAMERA_4)}, DYNAMIC_CAMERA_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(DYNAMIC_CAMERA_5)}, DYNAMIC_CAMERA_5},
};
static struct dsi_cmd_desc DYNAMIC_GAME[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_GAME_1)}, DYNAMIC_GAME_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_GAME_2)}, DYNAMIC_GAME_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_GAME_3)}, DYNAMIC_GAME_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DYNAMIC_GAME_4)}, DYNAMIC_GAME_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(DYNAMIC_GAME_5)}, DYNAMIC_GAME_5},
};

static struct dsi_cmd_desc STANDARD_UI[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_UI_1)}, STANDARD_UI_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_UI_2)}, STANDARD_UI_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_UI_3)}, STANDARD_UI_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_UI_4)}, STANDARD_UI_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(STANDARD_UI_5)}, STANDARD_UI_5},
};
static struct dsi_cmd_desc STANDARD_VIDEO[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_VIDEO_1)}, STANDARD_VIDEO_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_VIDEO_2)}, STANDARD_VIDEO_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_VIDEO_3)}, STANDARD_VIDEO_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_VIDEO_4)}, STANDARD_VIDEO_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(STANDARD_VIDEO_5)}, STANDARD_VIDEO_5},
};
static struct dsi_cmd_desc STANDARD_CAMERA[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_CAMERA_1)}, STANDARD_CAMERA_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_CAMERA_2)}, STANDARD_CAMERA_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_CAMERA_3)}, STANDARD_CAMERA_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_CAMERA_4)}, STANDARD_CAMERA_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(STANDARD_CAMERA_5)}, STANDARD_CAMERA_5},
};
static struct dsi_cmd_desc STANDARD_GAME[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_GAME_1)}, STANDARD_GAME_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_GAME_2)}, STANDARD_GAME_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_GAME_3)}, STANDARD_GAME_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(STANDARD_GAME_4)}, STANDARD_GAME_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(STANDARD_GAME_5)}, STANDARD_GAME_5},
};

static struct dsi_cmd_desc NATURAL_UI[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_UI_1)}, NATURAL_UI_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_UI_2)}, NATURAL_UI_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_UI_3)}, NATURAL_UI_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_UI_4)}, NATURAL_UI_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(NATURAL_UI_5)}, NATURAL_UI_5},
};
static struct dsi_cmd_desc NATURAL_VIDEO[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_VIDEO_1)}, NATURAL_VIDEO_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_VIDEO_2)}, NATURAL_VIDEO_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_VIDEO_3)}, NATURAL_VIDEO_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_VIDEO_4)}, NATURAL_VIDEO_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(NATURAL_VIDEO_5)}, NATURAL_VIDEO_5},
};
static struct dsi_cmd_desc NATURAL_CAMERA[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_CAMERA_1)}, NATURAL_CAMERA_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_CAMERA_2)}, NATURAL_CAMERA_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_CAMERA_3)}, NATURAL_CAMERA_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_CAMERA_4)}, NATURAL_CAMERA_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(NATURAL_CAMERA_5)}, NATURAL_CAMERA_5},
};
static struct dsi_cmd_desc NATURAL_GAME[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_GAME_1)}, NATURAL_GAME_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_GAME_2)}, NATURAL_GAME_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_GAME_3)}, NATURAL_GAME_3},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(NATURAL_GAME_4)}, NATURAL_GAME_4},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(NATURAL_GAME_5)}, NATURAL_GAME_5},
};
static struct dsi_cmd_desc *mdnie_tune_value_dsi0[MAX_APP_MODE][MAX_MODE][MAX_OUTDOOR_MODE] = {
		/*
			DYNAMIC_MODE
			STANDARD_MODE
			NATURAL_MODE
			MOVIE_MODE
			AUTO_MODE
			READING_MODE
		*/
		// UI_APP
		{
			{DYNAMIC_UI,			NULL},
			{STANDARD_UI,			NULL},
			{NATURAL_UI,			NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// VIDEO_APP
		{
			{DYNAMIC_VIDEO,		    NULL},
			{STANDARD_VIDEO,	    NULL},
			{NATURAL_VIDEO,		    NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_EBOOK_MDNIE, NULL},
		},
		// VIDEO_WARM_APP
		{
			{DYNAMIC_VIDEO,		    NULL},
			{STANDARD_VIDEO,	    NULL},
			{NATURAL_VIDEO,		    NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_EBOOK_MDNIE, NULL},
		},
		// VIDEO_COLD_APP
		{
			{DYNAMIC_VIDEO,		    NULL},
			{STANDARD_VIDEO,	    NULL},
			{NATURAL_VIDEO,		    NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_VIDEO_MDNIE, NULL},
			{AUTO_DSI0_EBOOK_MDNIE, NULL},
		},
		// CAMERA_APP
		{
			{DYNAMIC_CAMERA,		NULL},
			{STANDARD_CAMERA,		NULL},
			{NATURAL_CAMERA,		NULL},
			{AUTO_DSI0_CAMERA_MDNIE,NULL},
			{AUTO_DSI0_CAMERA_MDNIE,NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// NAVI_APP
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		// GALLERY_APP
		{
			{DYNAMIC_UI,			NULL},
			{STANDARD_UI,			NULL},
			{NATURAL_UI,			NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// VT_APP
		{
			{DYNAMIC_UI,			NULL},
			{STANDARD_UI,			NULL},
			{NATURAL_UI,			NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// BROWSER_APP
		{
			{DYNAMIC_UI,			NULL},
			{STANDARD_UI,			NULL},
			{NATURAL_UI,			NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// eBOOK_APP
		{
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// EMAIL_APP
		{
			{DYNAMIC_UI,			NULL},
			{STANDARD_UI,			NULL},
			{NATURAL_UI,			NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
		// GAME_LOW_APP
		{
			{DYNAMIC_GAME,				NULL},
			{STANDARD_GAME,				NULL},
			{NATURAL_GAME,				NULL},
			{AUTO_DSI0_GAME_LOW_MDNIE,	NULL},
			{AUTO_DSI0_GAME_LOW_MDNIE,	NULL},
			{AUTO_DSI0_GAME_LOW_MDNIE,	NULL},
		},
		// GAME_MID_APP
		{
			{DYNAMIC_GAME,				NULL},
			{STANDARD_GAME,				NULL},
			{NATURAL_GAME,				NULL},
			{AUTO_DSI0_GAME_MID_MDNIE,	NULL},
			{AUTO_DSI0_GAME_MID_MDNIE,	NULL},
			{AUTO_DSI0_GAME_MID_MDNIE,	NULL},
		},
		// GAME_HIGH_APP
		{
			{DYNAMIC_GAME,				NULL},
			{STANDARD_GAME,				NULL},
			{NATURAL_GAME,				NULL},
			{AUTO_DSI0_GAME_HIGH_MDNIE,	NULL},
			{AUTO_DSI0_GAME_HIGH_MDNIE,	NULL},
			{AUTO_DSI0_GAME_HIGH_MDNIE,	NULL},
		},
		// TDMB_APP
		{
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_UI_MDNIE,	NULL},
			{AUTO_DSI0_EBOOK_MDNIE,	NULL},
		},
};

static struct dsi_cmd_desc *light_notification_tune_value[LIGHT_NOTIFICATION_MAX] = {
	NULL,
	DSI0_LIGHT_NOTIFICATION_MDNIE,
};

#define DSI0_RGB_SENSOR_MDNIE_1_SIZE ARRAY_SIZE(AUTO_DSI0_UI_MDNIE_1)
#define DSI0_RGB_SENSOR_MDNIE_2_SIZE ARRAY_SIZE(AUTO_DSI0_UI_MDNIE_2)
#define DSI0_RGB_SENSOR_MDNIE_3_SIZE ARRAY_SIZE(AUTO_DSI0_UI_MDNIE_3)
#endif /*_DSI_TCON_MDNIE_LITE_DATA_FHD_TD4100_BS050HDM_H_*/

