/*
 * =================================================================
 *
 *       Filename:  ss_dsi_smart_dimming_S6E3FA7_AMS604NL01.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3FA7_AMS604NL01_H_
#define _SS_DSI_SMART_DIMMING_S6E3FA7_AMS604NL01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

#define VREG0_REF_6P8 28521267	/* 6.8*4194304 */
#define VREG0_REF_6P5 27262976	/* 6.5*4194304 */
#define VREG0_REF_6P4 26843546	/* 6.4*4194304 */
#define VREG0_REF_6P3 26424115	/* 6.3*4194304 */
#define VREG0_REF_6P2 26004685	/* 6.2*4194304 */

#define HBM_INTERPOLATION_STEP 8

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
	char gamma_setting_log[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;
	char panel_revision;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* VT,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static const int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static const int vt_coefficient[] = {
	0, 12, 24, 36,
	48, 60, 72, 84,
	96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static const int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
	{0x80, 0x80, 0x80},		/* V1 */
	{0x80, 0x80, 0x80},		/* V7 */
	{0x80, 0x80, 0x80},		/* V11 */
	{0x80, 0x80, 0x80},		/* V23 */
	{0x80, 0x80, 0x80},		/* V35 */
	{0x80, 0x80, 0x80},		/* V51 */
	{0x80, 0x80, 0x80},		/* V87 */
	{0x80, 0x80, 0x80},		/* V151 */
	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static const int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{129, 860},		/* V255 */
};

/* 443 is made but not used */
static const int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* Jackpot2 rev.A */
static const unsigned int base_luminance_revA[LUMINANCE_MAX][2] = {
	{2, 102},
	{3, 102},
	{4, 102},
	{5, 102},
	{6, 102},
	{7, 102},
	{8, 102},
	{9, 102},
	{10, 102},
	{11, 102},
	{12, 102},
	{13, 102},
	{14, 102},
	{15, 102},
	{16, 102},
	{17, 102},
	{19, 102},
	{20, 102},
	{21, 102},
	{22, 102},
	{24, 102},
	{25, 102},
	{27, 102},
	{29, 102},
	{30, 102},
	{32, 102},
	{34, 102},
	{37, 102},
	{39, 102},
	{41, 102},
	{44, 102},
	{47, 102},
	{50, 102},
	{53, 102},
	{56, 102},
	{60, 102},
	{64, 102},
	{68, 109},
	{72, 116},
	{77, 123},
	{82, 131},
	{87, 138},
	{93, 147},
	{98, 157},
	{105, 168},
	{111, 179},
	{119, 190},
	{126, 200},
	{134, 215},
	{143, 228},
	{152, 243},
	{162, 260},
	{172, 271},
	{183, 286},
	{195, 286},
	{207, 286},
	{220, 286},
	{234, 286},
	{249, 297},
	{265, 313},
	{282, 328},
	{300, 341},
	{316, 358},
	{333, 374},
	{350, 388},
	{357, 395},
	{365, 402},
	{372, 402},
	{380, 402},
	{387, 402},
	{395, 402},
	{403, 409},
	{412, 413},
	{420, 420},
};


static const int gradation_offset_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 2, 3, 8, 15, 19, 25, 28, 30},
	{0, 1, 2, 5, 13, 17, 22, 27, 27},
	{0, 1, 2, 5, 11, 15, 20, 25, 26},
	{0, 1, 2, 4, 11, 15, 18, 23, 25},
	{0, 1, 2, 3, 9, 14, 17, 22, 24},
	{0, 1, 2, 3, 9, 13, 16, 21, 23},
	{0, 1, 2, 3, 9, 12, 15, 20, 22},
	{0, 1, 2, 3, 8, 11, 14, 19, 21},
	{0, 1, 2, 3, 8, 10, 13, 18, 20},
	{0, 1, 2, 2, 7, 9, 12, 17, 19},
	{0, 1, 2, 2, 6, 9, 12, 16, 18},
	{0, 1, 2, 2, 6, 9, 12, 16, 18},
	{0, 1, 2, 2, 6, 9, 12, 16, 18},
	{0, 1, 2, 2, 6, 9, 12, 16, 18},
	{0, 1, 1, 2, 6, 9, 11, 15, 17},
	{0, 1, 1, 2, 6, 9, 11, 15, 17},
	{0, 0, 1, 2, 5, 8, 10, 14, 16},
	{0, 0, 1, 1, 5, 7, 10, 14, 16},
	{0, 0, 1, 1, 4, 7, 9, 14, 16},
	{0, 0, 1, 1, 4, 7, 9, 13, 15},
	{0, 0, 1, 1, 4, 6, 8, 12, 14},
	{0, 0, 0, 0, 3, 5, 7, 11, 13},
	{0, 0, 0, 0, 3, 4, 6, 10, 12},
	{0, 0, 0, 0, 3, 4, 6, 10, 11},
	{0, 0, 0, 0, 2, 4, 6, 10, 11},
	{0, 0, 0, 0, 2, 3, 5, 9, 10},
	{0, 0, 0, 0, 2, 3, 5, 9, 10},
	{0, 0, 0, 0, 2, 3, 5, 8, 9},
	{0, 0, 0, 0, 2, 3, 5, 8, 9},
	{0, 0, 0, 0, 2, 3, 5, 8, 9},
	{0, 0, 0, 0, 1, 2, 4, 7, 8},
	{0, 0, 0, 0, 1, 2, 3, 6, 7},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 0, 0, 0, 2, 2, 3, 5, 6},
	{0, 0, 0, 0, 1, 2, 3, 5, 6},
	{0, 1, 0, 0, 1, 1, 3, 4, 6},
	{0, 1, 0, 0, 1, 1, 2, 4, 5},
	{0, 1, 0, 0, 0, 1, 2, 4, 5},
	{0, 1, 0, 0, 0, 1, 2, 4, 5},
	{0, 1, 0, 0, 0, 1, 2, 4, 5},
	{0, 0, 0, 0, 0, 1, 2, 4, 5},
	{0, 0, 1, 1, 1, 1, 2, 4, 5},
	{0, -1, 1, 1, 1, 1, 2, 4, 5},
	{0, 0, 1, 1, 1, 1, 2, 4, 5},
	{0, -1, 1, 1, 1, 0, 2, 4, 5},
	{0, 0, 2, 1, 1, 0, 2, 4, 5},
	{0, 0, 2, 0, 0, 1, 1, 4, 5},
	{0, 0, 1, 0, 0, 0, 1, 2, 4},
	{0, 0, 1, 0, 0, 0, 1, 2, 4},
	{0, 0, 1, 0, 0, 0, 1, 2, 4},
	{0, 0, 1, 0, 0, 0, 1, 2, 4},
	{0, 0, 1, 0, 0, 0, 1, 1, 3},
	{0, -1, 1, 0, 0, 0, 0, 1, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 2},
	{0, 0, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 1, 0, 0, 0, -1, 0, 2},
	{0, 0, 1, -1, -1, -1, 0, 0, 1},
	{0, 0, -1, -1, -1, 0, -1, 0, 1},
	{0, 0, 0, -1, -2, -2, -1, -1, 1},
	{0, 0, 0, 0, -1, -1, -1, -1, 0},
	{0, 0, -1, 0, -1, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, -1, 0, 0, -1, -1, -1, 0},
	{0, 0, 0, 0, 0, 0, 0, -1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, -1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0},
};

static const int rgb_offset_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-5, 0, -2, -2, 1, -2, -5, 1, -2, -14, 1, -7, -22, -1, -10, -19, -1, -6, -22, -8, -10, -23, -3, -4, -13, -6, -5},
	{-3, 0, -1, -2, 1, -1, -3, 0, -1, -11, 0, -7, -21, -4, -12, -19, -3, -7, -24, -8, -11, -25, -5, -8, -13, -6, -8},
	{-2, 0, -1, -2, 1, -1, -3, -1, -1, -11, -1, -7, -20, -2, -12, -19, -3, -7, -22, -9, -10, -24, -7, -11, -13, -6, -8},
	{-1, 0, -1, -2, 0, -1, -3, -1, -1, -10, 0, -7, -20, -5, -15, -20, -6, -9, -21, -2, -7, -24, -7, -11, -13, -6, -8},
	{0, 0, 0, -1, 0, -1, -3, -1, -1, -9, 0, -6, -20, -5, -16, -20, -6, -9, -22, -5, -9, -24, -7, -11, -13, -6, -8},
	{0, 0, 0, -1, 0, -1, -3, -1, -1, -7, -1, -5, -20, -5, -16, -18, -6, -10, -22, -7, -10, -25, -8, -12, -13, -6, -8},
	{0, 0, 0, -1, 0, -1, -3, -1, -1, -7, -1, -5, -18, -5, -16, -15, -2, -7, -20, -5, -10, -20, -8, -12, -10, -6, -8},
	{0, 0, 0, -1, 0, -1, -3, -1, -1, -6, -1, -5, -16, -4, -14, -15, -2, -7, -17, -4, -10, -20, -8, -12, -10, -6, -8},
	{0, 0, 0, -1, 0, -1, -3, -1, -1, -6, -1, -5, -14, -3, -13, -11, 0, -6, -16, -3, -9, -16, -6, -12, -9, -5, -8},
	{0, 0, -1, 0, 1, 0, -3, -1, -1, -4, -1, -3, -14, -2, -14, -9, 2, -4, -16, -4, -10, -15, -5, -11, -9, -5, -8},
	{0, 0, -1, 0, 1, 0, -3, -1, -1, -4, -1, -3, -13, -1, -13, -10, 1, -6, -16, -4, -10, -11, 0, -8, -8, -4, -6},
	{0, 0, -1, 0, 1, 0, -3, -1, -1, -4, -1, -3, -13, -1, -13, -10, 0, -7, -14, -3, -10, -11, 0, -8, -8, -4, -6},
	{0, 0, -1, 0, 1, 0, -3, -1, -1, -4, -1, -3, -13, -2, -13, -10, 0, -7, -14, -3, -10, -9, 0, -8, -8, -4, -6},
	{1, 0, -1, 0, 1, 0, -3, -1, -1, -4, -1, -3, -13, -2, -13, -10, 0, -7, -14, -3, -11, -9, 0, -8, -8, -4, -6},
	{1, 0, -1, 0, 1, 0, -2, 0, -1, -4, -1, -3, -13, -2, -13, -10, 0, -7, -12, 0, -10, -7, 2, -8, -7, -3, -5},
	{1, 0, -1, 0, 1, 0, -2, 0, -1, -4, -1, -3, -12, -2, -12, -10, -1, -7, -13, -1, -11, -9, 2, -9, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -2, 0, -1, -3, -1, -2, -11, -1, -12, -10, -1, -7, -13, -2, -11, -10, 1, -9, -7, -5, -7},
	{0, 0, -1, 0, 1, 0, -2, 0, -1, -3, -1, -2, -11, -2, -11, -9, 1, -7, -13, -4, -11, -12, 0, -11, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -2, -1, -1, -3, 0, -2, -7, 1, -9, -11, -3, -9, -11, 0, -9, -15, -3, -14, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -2, -1, -1, -3, 0, -2, -7, 0, -9, -11, -3, -9, -12, -1, -10, -11, 2, -10, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -2, -1, -1, -2, 0, -1, -7, 0, -9, -10, -1, -8, -11, 0, -9, -12, 1, -12, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, 0, -2, -7, 0, -9, -7, 1, -5, -10, 1, -8, -13, 0, -12, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, 0, -2, -6, 0, -8, -6, 3, -4, -8, 2, -7, -15, 1, -12, -7, -5, -7},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -6, 0, -8, -6, 2, -4, -9, 1, -8, -15, 1, -12, -4, 1, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -4, 2, -7, -7, 0, -5, -10, 0, -8, -15, -1, -12, -4, 1, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -4, 2, -7, -5, 2, -2, -10, 1, -8, -14, 0, -13, -5, 0, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -4, 1, -7, -5, 2, -2, -10, 0, -8, -16, -2, -15, -5, 0, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -4, 0, -7, -5, 2, -2, -11, -1, -9, -14, 2, -13, -4, 1, -3},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -5, -1, -8, -5, 1, -2, -11, -1, -8, -14, 2, -13, -4, 1, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -1, -2, -5, -1, -8, -4, 1, -2, -11, -2, -8, -15, 0, -14, -5, 0, -5},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -2, -2, -2, 2, -5, -3, 2, -2, -9, -2, -7, -15, 0, -14, -5, -1, -5},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -2, -2, -2, 1, -5, -3, 1, -2, -7, 1, -5, -13, 2, -14, -3, 1, -2},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -2, -2, -2, 1, -5, -3, 1, -2, -7, 1, -5, -11, 4, -12, -3, 1, -2},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -2, -2, -2, 1, -5, -3, 0, -2, -7, 1, -5, -11, 3, -12, -5, 0, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -1, -2, -2, -3, 1, -5, -4, 0, -2, -6, 0, -5, -15, 1, -14, -3, 0, -4},
	{1, 0, -1, 0, 1, 0, -1, 0, 0, -2, -2, -2, -2, 0, -5, -2, 1, -1, -7, -1, -5, -15, 0, -14, -5, -1, -4},
	{0, 0, -1, 0, 0, -1, -1, 0, 0, -1, -1, -1, -2, 0, -5, -3, -1, -2, -9, -3, -7, -15, 0, -14, -4, -2, -5},
	{1, 0, -1, 0, 1, 1, -1, 0, 0, -1, -1, -1, -2, 0, -5, -4, -2, -2, -5, 2, -4, -16, -1, -15, -4, -1, -5},
	{1, 0, -1, 0, 0, 0, -2, -1, 0, -1, -1, -1, -1, 1, -4, -3, 0, -1, -8, -2, -7, -18, -3, -15, -2, 4, -3},
	{1, 0, -1, 0, 1, 0, -1, 0, 1, -1, -1, -1, -2, 0, -5, -5, -3, -3, -6, 0, -5, -18, -2, -15, -1, 4, -3},
	{1, 0, -1, 0, 1, 0, -2, 0, 0, 1, 0, 1, -2, 1, -5, -4, -2, -2, -4, 1, -3, -14, 1, -12, -6, -2, -7},
	{0, 0, -1, 1, 1, 0, 0, 0, 1, -1, -1, -1, -3, 0, -4, -1, 1, 0, -4, 1, -3, -13, 1, -12, -8, -2, -8},
	{1, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 1, -1, 1, -4, -5, -1, -2, -3, 1, -3, -13, 2, -11, -8, -3, -9},
	{0, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, -2, 1, -4, -1, 1, -1, -6, -2, -5, -16, -2, -14, -5, 3, -4},
	{1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, -4, -2, 1, 0, -4, -1, -5, -16, -1, -12, -5, 2, -5},
	{0, 0, -1, 1, 1, 0, 0, 0, 0, -1, -1, -1, -1, 0, -2, -1, 2, 0, -2, 0, -2, -16, -2, -13, -6, 2, -6},
	{0, 0, 0, 0, 0, -1, -1, 0, 0, -1, -1, 1, -2, -2, -5, -1, 0, -1, -3, 1, -2, -13, 1, -11, -6, 2, -6},
	{1, 0, 0, 1, 0, 0, -1, 0, 0, -2, -1, 0, -2, -1, -3, 0, 2, 0, -3, 2, -1, -14, 0, -12, -6, 1, -7},
	{0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 1, -3, -1, -4, 0, 1, 0, -5, -2, -4, -15, -2, -12, -8, -1, -9},
	{0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 1, -2, -1, -2, -1, 0, -1, -2, 1, -2, -15, -4, -14, -11, -1, -11},
	{-1, 0, -1, 0, 0, -1, 0, 0, -1, -1, 0, 0, 0, 0, -1, 1, 2, 1, -6, -3, -5, -12, 0, -11, -11, -1, -11},
	{-1, 0, -1, 0, -1, -1, -1, 0, -1, 1, 1, 1, -1, -1, -2, -1, 1, -1, -4, -1, -4, -11, 0, -10, -11, 0, -10},
	{-1, 0, -1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, -1, 0, 1, 0, -1, 2, -2, -8, 2, -6, -11, -1, -11},
	{0, 0, 0, 1, 0, 0, 1, 1, 1, -1, 0, 1, -2, 0, -2, -1, 0, -1, 0, 3, 0, -8, 3, -7, -10, -1, -10},
	{0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 1, -1, 1, -1, 0, 1, 0, 0, 2, -1, -7, 1, -7, -13, -2, -11},
	{0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 1, -1, 1, -1, -1, -1, -1, -1, 1, -2, -9, 0, -8, -5, 2, -4},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, -1, 0, 0, 0, -2, 1, -1, -8, 2, -7, -3, 2, -4},
	{0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 1, 1, 1, 3, 1, -7, 2, -4, -4, 1, -5},
	{-1, 0, -1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, -2, -1, -2, -5, 3, -4, -4, 2, -5},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, -2, -1, 1, 0, 0, 2, 0, -5, 2, -4, -5, 0, -3},
	{0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, -1, 2, 0, 0, 1, 0, -7, 1, -6, -7, -2, -6},
	{0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, -2, -1, -2, -2, 2, -1, -8, -3, -7},
	{1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 1, -2, 1, -1, -9, -4, -8},
	{0, 0, -1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, -1, 0, 0, 0, -3, -2, -2, 0, 3, 2, -5, 2, 0},
	{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, -3, -2, -3, 0, 2, 1, 0, 2, 1},
	{1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 1, 2, -4, -3, -4, 0, 2, 1, -2, 2, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 2, 1},
	{0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

};

/************
 *	  HMT   *
 ************/
static unsigned int base_luminance_reverse_hmt_single[][2] = {
	{10, 50},
	{11, 56},
	{12, 61},
	{13, 66},
	{14, 72},
	{15, 75},
	{16, 80},
	{17, 86},
	{19, 94},
	{20, 99},
	{21, 103},
	{22, 108},
	{23, 112},
	{25, 121},
	{27, 129},
	{29, 138},
	{31, 149},
	{33, 156},
	{35, 165},
	{37, 174},
	{39, 183},
	{41, 193},
	{44, 206},
	{47, 218},
	{50, 229},
	{53, 244},
	{56, 255},
	{60, 267},
	{64, 283},
	{68, 294},
	{72, 311},
	{77, 237},
	{82, 251},
	{87, 266},
	{93, 279},
	{99, 291},
	{105, 306},
};

static int gradation_offset_reverse_hmt_single[][9] = {
	/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 0, 2, 2, 4, 6, 7, 9, 9},
	{0, 0, 1, 2, 4, 5, 7, 8, 9},
	{0, 0, 1, 2, 4, 6, 7, 9, 10},
	{0, -1, 1, 2, 4, 5, 7, 8, 10},
	{0, -1, 1, 2, 3, 5, 6, 9, 10},
	{0, 1, 2, 2, 4, 5, 7, 9, 12},
	{0, 0, 2, 2, 4, 5, 7, 8, 9},
	{0, 0, 1, 2, 3, 4, 6, 8, 9},
	{0, 1, 2, 2, 3, 4, 7, 8, 9},
	{0, 1, 2, 2, 4, 4, 6, 8, 9},
	{0, 1, 1, 2, 4, 5, 6, 8, 9},
	{0, 2, 2, 1, 3, 4, 6, 8, 9},
	{0, 2, 1, 1, 3, 4, 6, 9, 9},
	{0, 2, 1, 1, 3, 4, 6, 8, 9},
	{0, 2, 2, 2, 3, 5, 6, 8, 10},
	{0, 3, 3, 2, 3, 5, 5, 8, 9},
	{0, 3, 3, 2, 3, 4, 6, 8, 9},
	{0, 3, 4, 3, 3, 5, 6, 7, 9},
	{0, 3, 4, 4, 3, 4, 5, 8, 9},
	{0, 2, 4, 3, 4, 4, 6, 8, 9},
	{0, 2, 3, 3, 4, 4, 5, 8, 9},
	{0, 2, 5, 3, 3, 4, 5, 8, 9},
	{0, 1, 4, 4, 3, 4, 5, 7, 10},
	{0, 3, 5, 4, 4, 4, 5, 7, 8},
	{0, 3, 6, 4, 4, 4, 6, 8, 9},
	{0, 3, 5, 4, 4, 3, 5, 7, 9},
	{0, 2, 5, 4, 4, 4, 5, 8, 9},
	{0, 4, 6, 4, 4, 3, 4, 7, 9},
	{0, 4, 6, 4, 4, 3, 5, 7, 9},
	{0, 4, 7, 5, 4, 4, 4, 7, 9},
	{0, 6, 8, 6, 5, 4, 5, 8, 8},
	{0, 3, 4, 3, 1, 2, 2, 4, 5},
	{0, 3, 4, 2, 1, 1, 2, 4, 5},
	{0, 3, 5, 3, 2, 2, 2, 4, 5},
	{0, 4, 5, 3, 2, 3, 3, 4, 6},
	{0, 4, 7, 4, 2, 2, 2, 4, 6},
	{0, 5, 7, 4, 2, 2, 3, 5, 5},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-1, 0, 0, 0, 0, 0, -1, 0, -1, -1, 2, -4, -7, 3, -7, -7, 2, -5, -13, 4, -8, -18, 3, -7, -9, 0, -2},
	{-1, 0, 0, 0, 0, 0, -2, 0, -2, -2, 2, -4, -5, 3, -6, -7, 3, -6, -10, 3, -6, -21, 4, -8, -9, 1, -2},
	{-1, 0, 1, 0, 0, 0, -1, 0, -2, -2, 2, -4, -6, 2, -6, -7, 2, -6, -12, 3, -7, -16, 3, -7, -6, 0, -2},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -2, 1, -4, -5, 2, -6, -7, 3, -6, -10, 3, -6, -22, 4, -9, -5, 0, -1},
	{-1, 0, 0, 0, 0, 0, -1, 0, -1, -2, 1, -3, -6, 3, -6, -6, 3, -6, -12, 3, -7, -17, 3, -7, -5, 0, -2},
	{0, 0, 1, 0, 0, 0, -1, 0, -1, -2, 1, -4, -6, 2, -6, -6, 2, -5, -10, 3, -6, -22, 4, -10, -1, 0, -1},
	{0, 0, 0, 0, 0, -1, -1, 0, -1, -1, 1, -2, -5, 2, -6, -7, 2, -6, -10, 3, -6, -20, 4, -9, -5, 0, -2},
	{0, 0, 0, 0, 0, 0, -2, 0, -1, -1, 1, -2, -5, 2, -6, -7, 2, -6, -11, 3, -7, -19, 4, -8, -6, 1, -2},
	{0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, -1, -5, 3, -6, -6, 2, -6, -8, 3, -6, -22, 4, -10, -8, 1, -2},
	{0, 0, 1, 0, 0, 0, 0, 0, -1, -2, 1, -2, -4, 2, -5, -6, 2, -6, -9, 2, -6, -21, 5, -10, -7, 1, -2},
	{-1, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, -1, -4, 2, -5, -6, 2, -6, -9, 3, -6, -21, 4, -10, -7, 1, -2},
	{0, 0, 1, 0, 0, 0, -1, 0, -1, 0, 1, -2, -4, 2, -5, -5, 2, -5, -9, 3, -6, -22, 4, -10, -7, 1, -2},
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -1, 1, -2, -5, 2, -6, -5, 2, -6, -10, 3, -6, -16, 4, -8, -14, 1, -4},
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -5, -4, 2, -4, -8, 3, -6, -19, 5, -10, -14, 1, -4},
	{0, 0, 1, 0, 0, 0, -1, 0, 0, -1, 0, -1, -3, 2, -5, -4, 2, -4, -8, 3, -7, -19, 5, -10, -6, 1, -2},
	{-1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -5, -4, 2, -5, -10, 3, -7, -21, 5, -11, -5, 0, -2},
	{-1, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -1, -2, 2, -4, -4, 2, -4, -8, 2, -6, -20, 5, -11, -6, 1, -2},
	{0, 0, 1, 0, 0, -1, -1, 0, 0, -1, 0, -1, -3, 2, -4, -4, 1, -4, -8, 3, -6, -20, 5, -11, -6, 1, -2},
	{0, 0, 2, 0, 0, 0, -2, 0, -1, -1, 0, -1, -3, 2, -5, -3, 1, -4, -9, 3, -7, -17, 4, -10, -10, 1, -3},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -3, 1, -4, -3, 2, -4, -8, 2, -5, -18, 5, -12, -10, 1, -3},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -2, -3, 1, -4, -4, 2, -5, -9, 2, -6, -17, 5, -11, -10, 1, -3},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -2, -2, 1, -3, -4, 1, -4, -7, 3, -6, -17, 5, -11, -10, 2, -4},
	{0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, -2, 1, -4, -3, 1, -4, -7, 2, -6, -18, 5, -12, -5, 1, -2},
	{0, 0, 2, 0, 0, -1, -1, 0, 0, 0, 0, -1, -2, 1, -3, -3, 2, -4, -6, 2, -5, -17, 5, -12, -11, 2, -4},
	{0, 0, 2, 0, 0, 0, -1, 0, 0, -1, 0, -1, -2, 1, -3, -3, 2, -4, -5, 2, -5, -15, 5, -11, -8, 1, -4},
	{0, 0, 2, 0, 0, 0, 0, 0, 0, -2, 0, -2, -1, 1, -2, -3, 2, -4, -5, 2, -5, -18, 6, -12, -4, 1, -2},
	{2, 0, 3, 0, 0, 0, -1, 0, 0, -1, 0, -1, -1, 1, -2, -3, 1, -4, -7, 2, -6, -14, 5, -11, -8, 1, -4},
	{0, 0, 2, 0, 0, 0, -1, 0, -1, 0, 0, 0, -1, 1, -2, -2, 2, -4, -6, 2, -5, -12, 5, -10, -8, 1, -4},
	{1, 0, 3, 0, 0, 0, 0, 0, -1, -2, 0, -1, -1, 1, -3, -1, 1, -3, -6, 2, -5, -16, 5, -12, -8, 1, -4},
	{2, 0, 3, 0, 0, 0, -1, 0, -1, 0, 0, 0, -2, 1, -3, 0, 1, -3, -6, 2, -5, -15, 5, -12, -8, 1, -4},
	{1, 0, 3, 0, 0, 0, -2, 0, 0, -1, 0, -1, -1, 1, -2, -1, 1, -3, -5, 2, -5, -13, 4, -10, -12, 2, -6},
	{1, 0, 3, 0, 0, -1, -1, 0, 0, 0, 0, 0, -1, 0, -2, -2, 1, -3, -4, 2, -4, -12, 5, -10, -8, 2, -4},
	{1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -2, -1, 1, -3, -3, 1, -4, -14, 5, -11, -7, 2, -4},
	{0, 0, 3, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, -2, -2, 1, -3, -3, 1, -4, -11, 5, -10, -9, 2, -5},
	{1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, -2, -2, 1, -3, -3, 1, -4, -11, 5, -10, -6, 1, -4},
	{2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 1, -3, -3, 1, -4, -11, 4, -10, -6, 2, -4},
	{1, 0, 3, 0, 0, 0, -1, 0, -1, 0, 0, 0, -1, 0, -2, -1, 1, -3, -3, 1, -3, -11, 4, -10, -8, 2, -5},
};

#endif
