/*
 * =================================================================
 *
 *
 *	Description:  samsung display common file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/

#ifndef _SAMSUNG_DSI_MDNIE_S6D7AT0B01_PM6003XB1_
#define _SAMSUNG_DSI_MDNIE_S6D7AT0B01_PM6003XB1_

#include "../ss_dsi_mdnie_lite_common.h"

#define MDNIE_COLOR_BLINDE_CMD_OFFSET 30

#define ADDRESS_SCR_WHITE_RED   48
#define ADDRESS_SCR_WHITE_GREEN 50
#define ADDRESS_SCR_WHITE_BLUE  52

#define MDNIE_RGB_SENSOR_INDEX	1

#define MDNIE_STEP1_INDEX 1
#define MDNIE_STEP2_INDEX 2


static unsigned char LEVEL_UNLOCK_1[] = {
	0xF0,
	0x5A, 0x5A
};

static unsigned char LEVEL_UNLOCK_2[] = {
	0xFC,
	0x5A, 0x5A
};


static unsigned char LEVEL_LOCK_1[] = {
	0xF0,
	0xA5, 0xA5
};

static unsigned char LEVEL_LOCK_2[] = {
	0xFC,
	0xA5, 0xA5
};

static char night_mode_data[] = {
	0x00, 0xff, 0xef, 0x00, 0xd8, 0x00, 0xff, 0x00, 0x00, 0xef, 0xd8, 0x00, 0xff, 0x00, 0xef, 0x00, 0x00, 0xd8, 0xff, 0x00, 0xef, 0x00, 0xd8, 0x00, /* 6500K */
	0x00, 0xff, 0xea, 0x00, 0xcc, 0x00, 0xff, 0x00, 0x00, 0xea, 0xcc, 0x00, 0xff, 0x00, 0xea, 0x00, 0x00, 0xcc, 0xff, 0x00, 0xea, 0x00, 0xcc, 0x00, /* 6100K */
	0x00, 0xff, 0xe4, 0x00, 0xbf, 0x00, 0xff, 0x00, 0x00, 0xe4, 0xbf, 0x00, 0xff, 0x00, 0xe4, 0x00, 0x00, 0xbf, 0xff, 0x00, 0xe4, 0x00, 0xbf, 0x00, /* 5700K */
	0x00, 0xff, 0xdf, 0x00, 0xb1, 0x00, 0xff, 0x00, 0x00, 0xdf, 0xb1, 0x00, 0xff, 0x00, 0xdf, 0x00, 0x00, 0xb1, 0xff, 0x00, 0xdf, 0x00, 0xb1, 0x00, /* 5300K */
	0x00, 0xff, 0xd6, 0x00, 0xa1, 0x00, 0xff, 0x00, 0x00, 0xd6, 0xa1, 0x00, 0xff, 0x00, 0xd6, 0x00, 0x00, 0xa1, 0xff, 0x00, 0xd6, 0x00, 0xa1, 0x00, /* 4900K */
	0x00, 0xff, 0xcf, 0x00, 0x90, 0x00, 0xff, 0x00, 0x00, 0xcf, 0x90, 0x00, 0xff, 0x00, 0xcf, 0x00, 0x00, 0x90, 0xff, 0x00, 0xcf, 0x00, 0x90, 0x00, /* 4500K */
	0x00, 0xff, 0xc6, 0x00, 0x7d, 0x00, 0xff, 0x00, 0x00, 0xc6, 0x7d, 0x00, 0xff, 0x00, 0xc6, 0x00, 0x00, 0x7d, 0xff, 0x00, 0xc6, 0x00, 0x7d, 0x00, /* 4100K */
	0x00, 0xff, 0xbc, 0x00, 0x68, 0x00, 0xff, 0x00, 0x00, 0xbc, 0x68, 0x00, 0xff, 0x00, 0xbc, 0x00, 0x00, 0x68, 0xff, 0x00, 0xbc, 0x00, 0x68, 0x00, /* 3700K */
	0x00, 0xff, 0xaf, 0x00, 0x4b, 0x00, 0xff, 0x00, 0x00, 0xaf, 0x4b, 0x00, 0xff, 0x00, 0xaf, 0x00, 0x00, 0x4b, 0xff, 0x00, 0xaf, 0x00, 0x4b, 0x00, /* 3300K */
	0x00, 0xff, 0xa2, 0x00, 0x28, 0x00, 0xff, 0x00, 0x00, 0xa2, 0x28, 0x00, 0xff, 0x00, 0xa2, 0x00, 0x00, 0x28, 0xff, 0x00, 0xa2, 0x00, 0x28, 0x00, /* 2900K */
	0x00, 0xff, 0x95, 0x00, 0x0e, 0x00, 0xff, 0x00, 0x00, 0x95, 0x0e, 0x00, 0xff, 0x00, 0x95, 0x00, 0x00, 0x0e, 0xff, 0x00, 0x95, 0x00, 0x0e, 0x00  /* 2500K */
};

static char color_lens_data[] = {
	//Blue
	0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, 0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, 0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, 0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, 0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, 0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, 0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, 0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, 0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, 0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, 0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, 0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, 0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, 0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, 0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, 0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, /* 60% */

	//Azure
	0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, 0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, 0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, 0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, 0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, 0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, 0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, 0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, 0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, 0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, 0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, 0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, 0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, 0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, 0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, 0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, 0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, 0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, 0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, /* 60% */

	//Cyan
	0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, 0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, 0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, 0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, 0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, 0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, 0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, 0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, 0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, 0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, 0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, 0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, 0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, 0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, 0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, 0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, 0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, 0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, /* 60% */

	//Spring green
	0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, 0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, 0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, 0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, 0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, 0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, 0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, 0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, 0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, 0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, 0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, 0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, 0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, 0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, 0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, 0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, 0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, 0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, 0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, /* 60% */

	//Green
	0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, 0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, 0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, 0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, 0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, 0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, 0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, 0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, 0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, 0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, 0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, 0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, 0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, 0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, 0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, 0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, 0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Chartreuse Green
	0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, 0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, 0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, 0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, 0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, 0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, 0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, 0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, 0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, 0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, 0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, 0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, 0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, 0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, 0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, 0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, 0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, 0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, 0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Yellow
	0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, 0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, 0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, 0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, 0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, 0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, 0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, 0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, 0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, 0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, 0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, 0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, 0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, 0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, 0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, 0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, 0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Orange
	0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, 0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, 0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, 0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, 0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, 0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, 0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, 0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, 0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, 0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, 0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, 0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, 0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, 0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, 0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, 0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, 0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, 0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, 0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, /* 60% */

	//Red
	0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, 0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, 0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, 0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, 0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, 0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, 0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, 0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, 0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, 0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, 0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, 0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, 0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, 0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, 0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, 0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, 0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, 0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, /* 60% */

	//Rose
	0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, 0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, 0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, 0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, 0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, 0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, 0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, 0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, 0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, 0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, 0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, 0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, 0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, 0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, 0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, 0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, 0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, 0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, 0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, /* 60% */

	//Magenta
	0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, 0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, 0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, 0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, 0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, 0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, 0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, 0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, 0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, 0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, 0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, 0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, 0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, 0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, 0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, 0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, /* 60% */

	//Violet
	0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, 0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, 0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, 0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, 0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, 0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, 0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, 0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, 0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, 0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, 0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, 0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, 0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, 0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, 0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, 0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, 0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, 0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, 0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, /* 60% */
};

static unsigned char BYPASS_1[] = {
	0xCF,
	0x00, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char BYPASS_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x00, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char NEGATIVE_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0x00, //scr Wr
	0xff, //scr Kr
	0x00, //scr Wg
	0xff, //scr Kg
	0x00, //scr Wb
	0xff, //scr Kb
};

static unsigned char NEGATIVE_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char GRAYSCALE_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0xb3, //scr Cr
	0x4c, //scr Rr
	0xb3, //scr Cg
	0x4c, //scr Rg
	0xb3, //scr Cb
	0x4c, //scr Rb
	0x69, //scr Mr
	0x96, //scr Gr
	0x69, //scr Mg
	0x96, //scr Gg
	0x69, //scr Mb
	0x96, //scr Gb
	0xe2, //scr Yr
	0x1d, //scr Br
	0xe2, //scr Yg
	0x1d, //scr Bg
	0xe2, //scr Yb
	0x1d, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char GRAYSCALE_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char GRAYSCALE_NEGATIVE_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0xb3, //scr Cr
	0x4c, //scr Rr
	0xb3, //scr Cg
	0x4c, //scr Rg
	0xb3, //scr Cb
	0x4c, //scr Rb
	0x69, //scr Mr
	0x96, //scr Gr
	0x69, //scr Mg
	0x96, //scr Gg
	0x69, //scr Mb
	0x96, //scr Gb
	0xe2, //scr Yr
	0x1d, //scr Br
	0xe2, //scr Yg
	0x1d, //scr Bg
	0xe2, //scr Yb
	0x1d, //scr Bb
	0x00, //scr Wr
	0xff, //scr Kr
	0x00, //scr Wg
	0xff, //scr Kg
	0x00, //scr Wb
	0xff, //scr Kb
};

static unsigned char GRAYSCALE_NEGATIVE_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char UI_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char UI_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char VIDEO_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x10,
	0x40, //de_maxplus 8
	0x40, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x0a, //curve_1
	0x17, //curve_2
	0x26, //curve_3
	0x36, //curve_4
	0x49, //curve_5
	0x5c, //curve_6
	0x6f, //curve_7
	0x82, //curve_8
	0x95, //curve_9
	0xa8, //curve_10
	0xbb, //curve_11
	0xcb, //curve_12
	0xdb, //curve_13
	0xeb, //curve_14
	0xf8, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char VIDEO_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char CAMERA_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char CAMERA_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char GALLERY_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x10,
	0xa0, //de_maxplus 8
	0xa0, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char GALLERY_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char CAMERA_SWA_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xf4, //scr Wg
	0x00, //scr Kg
	0xfd, //scr Wb
	0x00, //scr Kb
};

static unsigned char CAMERA_SWA_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char GALLERY_SWA_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x10,
	0xa0, //de_maxplus 8
	0xa0, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xf4, //scr Wg
	0x00, //scr Kg
	0xfd, //scr Wb
	0x00, //scr Kb
};

static unsigned char GALLERY_SWA_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};


static unsigned char BROWSER_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char BROWSER_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char EBOOK_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xf7, //scr Wg
	0x00, //scr Kg
	0xe5, //scr Wb
	0x00, //scr Kb
};

static unsigned char EBOOK_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char OUTDOOR_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x1a, //curve_1
	0x2f, //curve_2
	0x41, //curve_3
	0x52, //curve_4
	0x63, //curve_5
	0x73, //curve_6
	0x82, //curve_7
	0x91, //curve_8
	0xa0, //curve_9
	0xae, //curve_10
	0xbc, //curve_11
	0xca, //curve_12
	0xd8, //curve_13
	0xe5, //curve_14
	0xf3, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char OUTDOOR_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char NIGHT_MODE_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char NIGHT_MODE_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char COLOR_LENS_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char COLOR_LENS_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char COLOR_BLIND_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char COLOR_BLIND_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char LIGHT_NOTIFICATION_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x60,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x66, //scr Cr
	0xff, //scr Rr
	0xf9, //scr Cg
	0x60, //scr Rg
	0xac, //scr Cb
	0x13, //scr Rb
	0xff, //scr Mr
	0x66, //scr Gr
	0x60, //scr Mg
	0xf9, //scr Gg
	0xac, //scr Mb
	0x13, //scr Gb
	0xff, //scr Yr
	0x66, //scr Br
	0xf9, //scr Yg
	0x60, //scr Bg
	0x13, //scr Yb
	0xac, //scr Bb
	0xff, //scr Wr
	0x66, //scr Kr
	0xf9, //scr Wg
	0x60, //scr Kg
	0xac, //scr Wb
	0x13, //scr Kb
};

static unsigned char LIGHT_NOTIFICATION_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char CURTAIN_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0x00, //scr Rr
	0x00, //scr Cg
	0x00, //scr Rg
	0x00, //scr Cb
	0x00, //scr Rb
	0x00, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0x00, //scr Gg
	0x00, //scr Mb
	0x00, //scr Gb
	0x00, //scr Yr
	0x00, //scr Br
	0x00, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0x00, //scr Bb
	0x00, //scr Wr
	0x00, //scr Kr
	0x00, //scr Wg
	0x00, //scr Kg
	0x00, //scr Wb
	0x00, //scr Kb
};

static unsigned char CURTAIN_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static unsigned char RGB_SENSOR_1[] = {
	0xCF,
	0x07, //de cs cc 000
	0x00, //de_gain 10
	0x00,
	0xff, //de_maxplus 8
	0xff, //de_maxminus 8
	0x01, //cs_gain 10
	0x00,
	0x00, //curve_0
	0x10, //curve_1
	0x20, //curve_2
	0x30, //curve_3
	0x40, //curve_4
	0x50, //curve_5
	0x60, //curve_6
	0x70, //curve_7
	0x80, //curve_8
	0x90, //curve_9
	0xa0, //curve_10
	0xb0, //curve_11
	0xc0, //curve_12
	0xd0, //curve_13
	0xe0, //curve_14
	0xf0, //curve_15
	0x01, //curve_16
	0x00,
	0x00, //curve_offset
	0x00,
	0x00, //curve_low_x
	0x00, //curve_low_y
	0x00, //scr Cr
	0xff, //scr Rr
	0xff, //scr Cg
	0x00, //scr Rg
	0xff, //scr Cb
	0x00, //scr Rb
	0xff, //scr Mr
	0x00, //scr Gr
	0x00, //scr Mg
	0xff, //scr Gg
	0xff, //scr Mb
	0x00, //scr Gb
	0xff, //scr Yr
	0x00, //scr Br
	0xff, //scr Yg
	0x00, //scr Bg
	0x00, //scr Yb
	0xff, //scr Bb
	0xff, //scr Wr
	0x00, //scr Kr
	0xff, //scr Wg
	0x00, //scr Kg
	0xff, //scr Wb
	0x00, //scr Kb
};

static unsigned char RGB_SENSOR_2[] = {
	//start
	0xCE,
	0x01, //mdnie_en
	0x00, //RGB_IF_Type mask 00 000
	0x0f, //scr_bypass scr_en algo_bypass algo_en 0000
	0x00, //roi_en
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi0 y end
	0x00,
	0x14, //trans_en trans_slope 0 0000
	0x01, //trans_interval
	0x0f, //trans_ctrl scr gamma cs de
};

static struct dsi_cmd_desc DSI0_BYPASS_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(BYPASS_1)}, BYPASS_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(BYPASS_2)}, BYPASS_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_NEGATIVE_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(NEGATIVE_1)}, NEGATIVE_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(NEGATIVE_2)}, NEGATIVE_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_GRAYSCALE_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GRAYSCALE_1)}, GRAYSCALE_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GRAYSCALE_2)}, GRAYSCALE_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_GRAYSCALE_NEGATIVE_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GRAYSCALE_NEGATIVE_1)}, GRAYSCALE_NEGATIVE_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GRAYSCALE_NEGATIVE_2)}, GRAYSCALE_NEGATIVE_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_UI_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(UI_1)}, UI_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(UI_2)}, UI_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_VIDEO_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(VIDEO_1)}, VIDEO_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(VIDEO_2)}, VIDEO_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_CAMERA_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CAMERA_1)}, CAMERA_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CAMERA_2)}, CAMERA_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_GALLERY_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GALLERY_1)}, GALLERY_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GALLERY_2)}, GALLERY_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_CAMERA_SWA_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CAMERA_SWA_1)}, CAMERA_SWA_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CAMERA_SWA_2)}, CAMERA_SWA_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_GALLERY_SWA_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GALLERY_SWA_1)}, GALLERY_SWA_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(GALLERY_SWA_2)}, GALLERY_SWA_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_BROWSER_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(BROWSER_1)}, BROWSER_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(BROWSER_2)}, BROWSER_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_EBOOK_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(EBOOK_1)}, EBOOK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(EBOOK_2)}, EBOOK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_HBM_CE_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(OUTDOOR_1)}, OUTDOOR_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(OUTDOOR_2)}, OUTDOOR_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_NIGHT_MODE_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(NIGHT_MODE_1)}, NIGHT_MODE_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(NIGHT_MODE_2)}, NIGHT_MODE_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_COLOR_LENS_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(COLOR_LENS_1)}, COLOR_LENS_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(COLOR_LENS_2)}, COLOR_LENS_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_COLOR_BLIND_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(COLOR_BLIND_1)}, COLOR_BLIND_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(COLOR_BLIND_2)}, COLOR_BLIND_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_LIGHT_NOTIFICATION_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LIGHT_NOTIFICATION_1)}, LIGHT_NOTIFICATION_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LIGHT_NOTIFICATION_2)}, LIGHT_NOTIFICATION_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_CURTAIN_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CURTAIN_1)}, CURTAIN_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(CURTAIN_2)}, CURTAIN_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};
static struct dsi_cmd_desc DSI0_RGB_SENSOR_MDNIE[] = {
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_1)}, LEVEL_UNLOCK_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_UNLOCK_2)}, LEVEL_UNLOCK_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(RGB_SENSOR_1)}, RGB_SENSOR_1},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(RGB_SENSOR_2)}, RGB_SENSOR_2},
	{{DTYPE_GEN_LWRITE, 0, 0, 0, 0, sizeof(LEVEL_LOCK_1)}, LEVEL_LOCK_1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(LEVEL_LOCK_2)}, LEVEL_LOCK_2},
};


static struct dsi_cmd_desc *mdnie_tune_value_dsi0[MAX_APP_MODE][MAX_MODE][MAX_OUTDOOR_MODE] = {
		/*
			DYNAMIC_MODE
			STANDARD_MODE
			NATURAL_MODE
			MOVIE_MODE
			AUTO_MODE
			READING_MODE
		*/
		// UI_APP
		{
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// VIDEO_APP
		{
			{DSI0_VIDEO_MDNIE,	NULL},
			{DSI0_VIDEO_MDNIE,	NULL},
			{DSI0_VIDEO_MDNIE,	NULL},
			{DSI0_VIDEO_MDNIE,	NULL},
			{DSI0_VIDEO_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// VIDEO_WARM_APP
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		// VIDEO_COLD_APP
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		// CAMERA_APP
		{
			{DSI0_CAMERA_MDNIE,	NULL},
			{DSI0_CAMERA_MDNIE,	NULL},
			{DSI0_CAMERA_MDNIE,	NULL},
			{DSI0_CAMERA_MDNIE,	NULL},
			{DSI0_CAMERA_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// CAMERA_SWA_APP
		{
			{DSI0_CAMERA_SWA_MDNIE,	NULL},
			{DSI0_CAMERA_SWA_MDNIE,	NULL},
			{DSI0_CAMERA_SWA_MDNIE,	NULL},
			{DSI0_CAMERA_SWA_MDNIE,	NULL},
			{DSI0_CAMERA_SWA_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// GALLERY_APP
		{
			{DSI0_GALLERY_MDNIE,	NULL},
			{DSI0_GALLERY_MDNIE,	NULL},
			{DSI0_GALLERY_MDNIE,	NULL},
			{DSI0_GALLERY_MDNIE,	NULL},
			{DSI0_GALLERY_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// GALLERY_SWA_APP
		{
			{DSI0_GALLERY_SWA_MDNIE,	NULL},
			{DSI0_GALLERY_SWA_MDNIE,	NULL},
			{DSI0_GALLERY_SWA_MDNIE,	NULL},
			{DSI0_GALLERY_SWA_MDNIE,	NULL},
			{DSI0_GALLERY_SWA_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// BROWSER_APP
		{
			{DSI0_BROWSER_MDNIE,	NULL},
			{DSI0_BROWSER_MDNIE,	NULL},
			{DSI0_BROWSER_MDNIE,	NULL},
			{DSI0_BROWSER_MDNIE,	NULL},
			{DSI0_BROWSER_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// eBOOK_APP
		{
			{DSI0_EBOOK_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// EMAIL_APP
		{
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
		// TDMB_APP
		{
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_UI_MDNIE,	NULL},
			{DSI0_EBOOK_MDNIE,	NULL},
		},
};

static struct dsi_cmd_desc *light_notification_tune_value[LIGHT_NOTIFICATION_MAX] = {
	NULL,
	DSI0_LIGHT_NOTIFICATION_MDNIE,
};

#define DSI0_RGB_SENSOR_MDNIE_1_SIZE ARRAY_SIZE(RGB_SENSOR_1)
#define DSI0_RGB_SENSOR_MDNIE_2_SIZE ARRAY_SIZE(RGB_SENSOR_2)
#define DSI0_RGB_SENSOR_MDNIE_3_SIZE ARRAY_SIZE(RGB_SENSOR_3)
#endif /*_DSI_TCON_MDNIE_LITE_DATA_FHD_S6D7AT0B01_PM6003XB1_H_*/
