/*
 * =================================================================
 *
 *
 *	Description:  samsung display panel file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_MTP_MAGNA_EA8061S_SDC__H_
#define _SS_DSI_SMART_MTP_MAGNA_EA8061S_SDC__H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

#define LUMINANCE_MAX 62
#define GAMMA_SET_MAX 33
#define BIT_SHIFT 22

/*
	it means BIT_SHIFT is 22.  pow(2,BIT_SHIFT) is 4194304.
	BIT_SHIFT is used for right bit shfit
*/
#define BIT_SHFIT_MUL 4194304
#define GRAY_SCALE_MAX 256

/* 5.8 * 4194304 */
#define VREG0_REF_5P8 24326963
/* 5.6 * 4194304 */
#define VREG0_REF_5P6 23488102
/* 5.4 * 4194304 */
#define VREG0_REF_5P4 22649241
/* 5.7 * 4194304 */
#define VREG0_REF_5P7 23907532

/*V0,V3,V11,V23,V35,V51,V87,V151,V203,V255*/
#define ARRAY_MAX 11

/* PANEL DEPENDENT THINGS */
#define MAX_CANDELA 360
#define MIN_CANDELA	5

/*
*	ID 0x20
*/
#define V255_300CD_R_MSB_20 0x01
#define V255_300CD_R_LSB_20 0x00

#define V255_300CD_G_MSB_20 0x01
#define V255_300CD_G_LSB_20 0x00

#define V255_300CD_B_MSB_20 0x01
#define V255_300CD_B_LSB_20 0x00

#define V203_300CD_R_20 0x80
#define V203_300CD_G_20 0x80
#define V203_300CD_B_20 0x80

#define V151_300CD_R_20 0x80
#define V151_300CD_G_20 0x80
#define V151_300CD_B_20 0x80

#define V87_300CD_R_20 0x80
#define V87_300CD_G_20 0x80
#define V87_300CD_B_20 0x80

#define V51_300CD_R_20 0x80
#define V51_300CD_G_20 0x80
#define V51_300CD_B_20 0x80

#define V35_300CD_R_20 0x80
#define V35_300CD_G_20 0x80
#define V35_300CD_B_20 0x80

#define V23_300CD_R_20 0x80
#define V23_300CD_G_20 0x80
#define V23_300CD_B_20 0x80

#define V11_300CD_R_20 0x80
#define V11_300CD_G_20 0x80
#define V11_300CD_B_20 0x80

#define V3_300CD_R_20 0x80
#define V3_300CD_G_20 0x80
#define V3_300CD_B_20 0x80

#define VT_300CD_R_20 0x00
#define VT_300CD_G_20 0x00
#define VT_300CD_B_20 0x00

/* PANEL DEPENDENT THINGS END*/
enum {
	V1_INDEX = 0,
	V3_INDEX = 1,
	V11_INDEX = 2,
	V23_INDEX = 3,
	V35_INDEX = 4,
	V51_INDEX = 5,
	V87_INDEX = 6,
	V151_INDEX = 7,
	V203_INDEX = 8,
	V255_INDEX = 9,
};

struct GAMMA_LEVEL {
	int level_0;
	int level_1;
	int level_3;
	int level_11;
	int level_23;
	int level_35;
	int level_51;
	int level_87;
	int level_151;
	int level_203;
	int level_255;
} __packed;

struct RGB_OUTPUT_VOLTARE {
	struct GAMMA_LEVEL R_VOLTAGE;
	struct GAMMA_LEVEL G_VOLTAGE;
	struct GAMMA_LEVEL B_VOLTAGE;
} __packed;

struct GRAY_VOLTAGE {
	/*
		This voltage value use 14bit right shit
		it means voltage is divied by 16384.
	*/
	int R_Gray;
	int G_Gray;
	int B_Gray;
} __packed;

struct GRAY_SCALE {
	struct GRAY_VOLTAGE TABLE[GRAY_SCALE_MAX];
	struct GRAY_VOLTAGE VT_TABLE;
} __packed;

/*V0,V1,V3,V11,V23,V35,V51,V87,V151,V203,V255*/

struct MTP_SET {
	char OFFSET_255_MSB;
	char OFFSET_255_LSB;
	char OFFSET_203;
	char OFFSET_151;
	char OFFSET_87;
	char OFFSET_51;
	char OFFSET_35;
	char OFFSET_23;
	char OFFSET_11;
	char OFFSET_3;
	char OFFSET_1;
} __packed;

struct MTP_OFFSET {
	struct MTP_SET R_OFFSET;
	struct MTP_SET G_OFFSET;
	struct MTP_SET B_OFFSET;
} __packed;

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	struct MTP_OFFSET MTP_ORIGN;

	struct MTP_OFFSET MTP;
	struct RGB_OUTPUT_VOLTARE RGB_OUTPUT;
	struct GRAY_SCALE GRAY;

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;
} __packed;

#define CANDELA_MAX_TABLE 61
#define RGB_COMPENSATION 24

static int candela_table[][2] = {
	{5,	 0},
	{6,	 1},
	{7,	 2},
	{8,	 3},
	{9,	 4},
	{10, 5},
	{11, 6},
	{12, 7},
	{13, 8},
	{14, 9},
	{15, 10},
	{16, 11},
	{17, 12},
	{19, 13},
	{20, 14},
	{21, 15},
	{22, 16},
	{24, 17},
	{25, 18},
	{27, 19},
	{29, 20},
	{30, 21},
	{32, 22},
	{34, 23},
	{37, 24},
	{39, 25},
	{41, 26},
	{44, 27},
	{47, 28},
	{50, 29},
	{53, 30},
	{56, 31},
	{60, 32},
	{64, 33},
	{68, 34},
	{72, 35},
	{77, 36},
	{82, 37},
	{87, 38},
	{93, 39},
	{98, 40},
	{105, 41},
	{111, 42},
	{119, 43},
	{126, 44},
	{134, 45},
	{143, 46},
	{152, 47},
	{162, 48},
	{172, 49},
	{183, 50},
	{195, 51},
	{207, 52},
	{220, 53},
	{234, 54},
	{249, 55},
	{265, 56},
	{282, 57},
	{300, 58},
	{316, 59},
	{333, 60},
	{360, 61},
};

static int base_luminance_revA[][2] = {
	{5,  136},	// A-Dimm
	{6,  136},
	{7,  136},
	{8,  136},
	{9,  136},
	{10,  136},
	{11,  136},
	{12,  136},
	{13,  136},
	{14,  136},
	{15,  136},
	{16,  136},
	{17,  136},
	{19,  136},
	{20,  136},
	{21,  136},
	{22,  136},
	{24,  136},
	{25,  136},
	{27,  136},
	{29,  136},
	{30,  136},
	{32,  136},
	{34,  136},
	{37,  136},
	{39,  136},
	{41,  136},
	{44,  136},
	{47,  136},
	{50,  136},
	{53,  136},
	{56,  136},
	{60,  136},
	{64,  136},
	{68,  136},
	{72,  144},
	{77,  154},
	{82,  162},
	{87,  172},
	{93,  182},
	{98,  192},
	{105, 206},
	{111, 216},
	{119, 230},
	{126, 243},
	{134, 256},	// S-Dimm
	{143, 259},
	{152, 259},
	{162, 259},
	{172, 259},
	{183, 259},
	{195, 259},
	{207, 259},
	{220, 259},
	{234, 259},
	{249, 259},	// A-Dimm
	{265, 272},
	{282, 288},
	{300, 306},
	{316, 320},
	{333, 335},
	{360, 360},	// S-Dimm
};

static int gradation_offset_revA[][9] = {
	 /*V255 V203 V151 V87  V51  V35   V23   V11  V3 */
	{0,	3,	6,	7,	9,	11,15,	19,	20},
	{0,	3,	5,	6,	7,	9, 13,	16,	18},
	{0,	3,	4,	5,	6,	8, 12,	14,	16},
	{0,	3,	3,	4,	5,	7, 11,	14,	16},
	{0,	3,	3,	3,	2,	4, 10,	12,	13},
	{0,	2,	3,	3,	2,	4,  8,	10,	12},
	{0,	2,	3,	3,	2,	4,  6,	10,	12},
	{0,	2,	3,	3,	2,	2,  6,	9,	11},
	{0,	2,	3,	3,	2,	4,  6,	10,	11},
	{0,	2,	3,	3,	2,	4,  5,	8,	10},
	{0,	2,	3,	3,	2, 	2,  3,	7,	9},
	{0,	2,	3,	2,	1,	1,  2,	7,	8},
	{0,	3,	3,	2,	1,	1,  2,	6,	8},
	{0,	2,	3,	2,	1,	1,  2,	5,	7},
	{0,	2,	4,	3,	2,	3,  5,	8,	9},
	{0,	2,	3,	3,	2,	2,  3,	7,	9},
	{0,	2,	3,	3,	1,	3,  4,	7,	9},
	{0,	2,	3,	3,	1,	3,  4,	8,	10},
	{0,	2,	3,	3,	2,	3,  4,	8,	10},
	{0,	2,	3,	3,	2,	3,  4,	8,	10},
	{0,	2,	3,	3,	3,	3,  5,	9,	11},
	{0,	2,	3,	3,	3,	3,  5,	9,	11},
	{0,	2,	3,	3,	2,	3,  5,	8,	10},
	{0,	2,	3,	3,	2,	3,  5,	8,	10},
	{0,	2,	3,	3,	2,	3,  4,	7,	9},
	{0,	2,	3,	3,	2,	3,  4,	7,	9},
	{0,	2,	3,	3,	2,	2,  4,	7,	9},
	{0,	2,	2,	3,	2,	2,  4,	7,	9},
	{0,	2,	2,	3,	2,	2,  3,	6,	8},
	{0,	2,	3,	3,	2,	2,  3,	6,	8},
	{0,	2,	2,	3,	1,	2,  3,	5,	7},
	{0,	2,	2,	3,	1,	2,  3,	5,	7},
	{0,	2,	2,	3,	1,	1,  3,	5,	7},
	{0,	2,	2,	3,	1,	1,  3,	4,	6},
	{0,	2,	2,	3,	1,	1,  3,	4,	6},
	{0,	2,	4,	3,	1,	1,  3,	4,	6},
	{0,	1,	4,	4,	2,	2,  2,	3,	5},
	{0,	1,	4,	4,	2,	2,  2,	3,	5},
	{0,	1,	4,	4,	2,	2,  2,	3,	5},
	{0,	1,	4,	4,	1,	2,  2,	3,	4},
	{0,	2,	3,	3,	2,	2,  3,	4,	6},
	{0,	1,	3,	4,	1,	2,  2,	3,	4},
	{0,	1,	3,	3,	1,	2,  2,	2,	4},
	{0,	1,	2,	3,	1,	2,  1,	2,	4},
	{0,	1,	2,	3,	1,	2,  1,	2,	4},
	{0,	1,	2,	3,	1,	1,  1,	1,	3},
	{0,	1,	2,	3,	1,	1,  1,	1,	3},
	{0,	0,	2,	3,	1,	1,  1,	1,	3},
	{0,	0,	2,	3,	1,	1,  1,	1,	3},
	{0,	0,	2,	3,	1,	1,  1,	1,	3},
	{0,	1,	2,	2,	1,	1,  1,	2,	5},
	{0,	0,	2,	2,	1,	1,  1,	1,	2},
	{0,	0,	1,	2,	1,	1,  1,	1,	2},
	{0,	0,	1,	2,	1,	1,  1,	1,	2},
	{0,	0,	0,	1,	1,	1,  1,	1,	2},
	{0,	0,	0,	1,	1,	1,  0,	1,	2},
	{0,	0,	0,	1,	1,	1,  0,	1,	2},
	{0,	0,	0,	0,	1,	1,  0,	0,	2},
	{0,	0,	0,	0,	0,	0,  0,	0,	1},
	{0,	0,	0,	0,	0,	0,  0,	0,	1},
	{0,	0,	0,	0,	0,	0,  0,	0,	0},
	{0,	0,	0,	0,	0,	0,  0,	0,	0},
};

static int rgb_offset_revA[][RGB_COMPENSATION] = {
        //------ 255 ------|--------- 203 ------|-------- 151 -------|--------- 87 -------|-------- 51 ----------|--------- 35 -------|-------- 23 --------|------- 11 ---------|
	{-2,	0,	-4,	-1,	0,	-1,	-1,	0,	0,	-3,	0,	-2,	-9,	0,	4,	-4,	0,	-4,	-8,	0,	-4,	-8,	4,	-4,},
	{-2,	0,	-3,	-1,	0,	-1,	0,	0,	0,	-3,	3,	-2,	-1,	2,	3,	-8,	0,	-2,	-12,	0,	-3,	-9,	4,	-2},
	{-2,	0,	-3,	-1,	0,	-1,	0,	0,	0,	-3,	3,	-2,	-1,	2,	3,	-7,	0,	-2,	-14,	0,	-5,	-9,	4,	-3},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	-2,	2,	-2,	-2,	2,	4,	-8,	0,	-2,	-13,	0,	-6,	-10,	4,	-3},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-8,	0,	-2,	-12,	0,	-6,	-10,	4,	-2},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-7,	0,	-3,	-12,	0,	-3,	-10,	4,	-4},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-6,	0,	-3,	-11,	0,	-2,	-10,	4,	-2},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-6,	0,	-3,	-9,	0,	-2,	-13,	4,	-4},
	{-1,	0,	-3,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-7,	2,	-2,	-9,	0,	-3,	-13,	4,	-2},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	-3,	2,	4,	-6,	0,	-2,	-9,	0,	-3,	-15,	4,	-5},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-5,	0,	-2,	-8,	3,	-3,	-15,	4,	-4},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	1,	-1,	0,	0,	3,	-4,	0,	-3,	-7,	1,	-3,	-15,	4,	-3},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-4,	0,	-3,	-7,	0,	-3,	-15,	4,	-3},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-2,	0,	-3,	-8,	0,	-3,	-16,	4,	-5},
	{-1,	0,	-2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-3,	0,	-3,	-6,	-1,	-1,	-6,	4,	-3},
	{0,	0,	-2,	0,	0,	0,	0,	0,	0,	-1,	0,	-1,	0,	0,	3,	-5,	0,	-4,	-4,	0,	-4,	-10,	0,	-6},
	{0,	0,	-1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-5,	0,	-4,	-3,	0,	-2,	-10,	0,	-10},
	{0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-4,	0,	-5,	-1,	0,	1,	-8,	0,	-8},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-4,	0,	-5,	-1,	0,	1,	-8,	0,	-8},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	3,	-4,	0,	-5,	-1,	0,	1,	-8,	0,	-8},
	{2,	0,	2,	1,	0,	1,	1,	0,	0,	1,	0,	0,	1,	0,	2,	-4,	0,	-5,	-1,	0,	1,	-8,	0,	-10},
	{2,	0,	2,	1,	0,	1,	1,	0,	0,	1,	0,	0,	1,	0,	2,	-4,	0,	-5,	-3,	0,	1,	-8,	0,	-11},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-4,	0,	-5,	-3,	0,	-2,	-11,	0,	-15},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-4,	0,	-5,	-3,	0,	-2,	-10,	0,	-13},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-4,	0,	-5,	-4,	0,	-3,	-9,	0,	-13},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-4,	0,	-5,	-3,	0,	-3,	-9,	0,	-11},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-4,	0,	-5,	-2,	0,	-3,	-10,	0,	-10},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	0,	1,	1,	3,	-4,	0,	-5,	-1,	0,	-2,	-10,	0,	-9},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	3,	-4,	0,	-5,	-2,	0,	-5,	-9,	0,	-7},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	0,	1,	0,	3,	-1,	0,	-3,	0,	0,	2,	-9,	0,	-8},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	3,	-1,	0,	-3,	0,	0,	2,	-10,	0,	-10},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	3,	-1,	0,	-3,	0,	0,	2,	-10,	0,	-10},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	3,	-1,	0,	-3,	0,	0,	2,	-8,	0,	-8},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	3,	-1,	0,	-3,	0,	0,	2,	-8,	0,	-10},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	0,	0,	2,	-8,	0,	-8},
	{3,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	0,	0,	2,	-3,	1,	-3},
	{2,	0,	3,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	0,	0,	2,	-3,	1,	-3},
	{2,	0,	2,	1,	0,	1,	1,	0,	0,	1,	0,	1,	0,	0,	1,	-1,	0,	-3,	0,	0,	2,	-3,	1,	-3},
	{2,	0,	2,	1,	0,	1,	1,	0,	1,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	1,	0,	2,	-3,	1,	-4},
	{2,	0,	2,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	0,	0,	2,	-3,	1,	-3},
	{2,	0,	1,	1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	2,	-1,	0,	-3,	0,	0,	2,	-3,	1,	-3},
	{1,	0,	2,	1,	0,	1,	1,	0,	1,	1,	0,	0,	1,	0,	1,	-1,	0,	-3,	0,	0,	-2,	-7,	0,	-6},
	{1,	0,	1,	0,	0,	1,	1,	0,	1,	1,	0,	0,	1,	0,	1,	-2,	-1,	-3,	1,	0,	-2,	-10,	0,	-9},
	{1,	0,	1,	1,	0,	1,	1,	0,	1,	1,	0,	0,	1,	0,	1,	-2,	-1,	-3,	2,	-1,	0,	-8,	0,	-5},
	{1,	0,	1,	1,	0,	1,	1,	0,	2,	1,	0,	0,	1,	0,	1,	-2,	0,	-3,	2,	0,	-1,	-5,	0,	-4},
	{1,	0,	1,	1,	0,	1,	1,	0,	1,	1,	0,	0,	1,	0,	1,	-2,	0,	-3,	1,	0,	-2,	-5,	0,	-1},
	{1,	0,	1,	2,	0,	1,	0,	0,	1,	0,	0,	-1,	1,	0,	1,	-1,	0,	-3,	0,	0,	-2,	-4,	0,	2},
	{1,	0,	1,	2,	0,	1,	0,	0,	1,	0,	0,	-1,	1,	0,	1,	-1,	0,	-3,	0,	0,	-2,	-3,	0,	3},
	{1,	0,	1,	2,	0,	1,	0,	0,	1,	0,	0,	-1,	1,	0,	1,	-1,	0,	-3,	0,	0,	-2,	-3,	0,	3},
	{1,	0,	1,	0,	0,	1,	0,	0,	1,	0,	0,	-2,	1,	0,	1,	-1,	0,	-3,	0,	0,	-2,	-3,	0,	3},
	{0,	0,	1,	1,	0,	1,	0,	0,	0,	1,	0,	-1,	1,	-1,	2,	0,	0,	0,	1,	2,	2,	0,	0,	0},
	{0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	1,	1,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};
#endif
