/*
 * =================================================================
 *
 *
 *	Description:  samsung display panel file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_MTP_MAGNA_EA8061S_SDC__H_
#define _SS_DSI_SMART_MTP_MAGNA_EA8061S_SDC__H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

/*
*	From 4.8 inch model use AID function
*	CASE#1 is used for now.
*/
#define AID_OPERATION

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

#define LUMINANCE_MAX 62
#define GAMMA_SET_MAX 33
#define BIT_SHIFT 22

/*
	it means BIT_SHIFT is 22.  pow(2,BIT_SHIFT) is 4194304.
	BIT_SHIFT is used for right bit shfit
*/
#define BIT_SHFIT_MUL 4194304
#define GRAY_SCALE_MAX 256

/* 5.8 * 4194304 */
#define VREG0_REF_5P8 24326963
/* 5.6 * 4194304 */
#define VREG0_REF_5P6 23488102
/* 5.4 * 4194304 */
#define VREG0_REF_5P4 22649241

/*V0,V3,V11,V23,V35,V51,V87,V151,V203,V255*/
#define ARRAY_MAX 11

/* PANEL DEPENDENT THINGS */
#define MIN_CANDELA	5

/*
*	ID 0x20
*/
#define V255_300CD_R_MSB_20 0x01
#define V255_300CD_R_LSB_20 0x00

#define V255_300CD_G_MSB_20 0x01
#define V255_300CD_G_LSB_20 0x00

#define V255_300CD_B_MSB_20 0x01
#define V255_300CD_B_LSB_20 0x00

#define V203_300CD_R_20 0x80
#define V203_300CD_G_20 0x80
#define V203_300CD_B_20 0x80

#define V151_300CD_R_20 0x80
#define V151_300CD_G_20 0x80
#define V151_300CD_B_20 0x80

#define V87_300CD_R_20 0x80
#define V87_300CD_G_20 0x80
#define V87_300CD_B_20 0x80

#define V51_300CD_R_20 0x80
#define V51_300CD_G_20 0x80
#define V51_300CD_B_20 0x80

#define V35_300CD_R_20 0x80
#define V35_300CD_G_20 0x80
#define V35_300CD_B_20 0x80

#define V23_300CD_R_20 0x80
#define V23_300CD_G_20 0x80
#define V23_300CD_B_20 0x80

#define V11_300CD_R_20 0x80
#define V11_300CD_G_20 0x80
#define V11_300CD_B_20 0x80

#define V3_300CD_R_20 0x80
#define V3_300CD_G_20 0x80
#define V3_300CD_B_20 0x80

#define VT_300CD_R_20 0x00
#define VT_300CD_G_20 0x00
#define VT_300CD_B_20 0x00

/* PANEL DEPENDENT THINGS END*/
enum {
	V1_INDEX = 0,
	V3_INDEX = 1,
	V11_INDEX = 2,
	V23_INDEX = 3,
	V35_INDEX = 4,
	V51_INDEX = 5,
	V87_INDEX = 6,
	V151_INDEX = 7,
	V203_INDEX = 8,
	V255_INDEX = 9,
};

struct GAMMA_LEVEL {
	int level_0;
	int level_1;
	int level_3;
	int level_11;
	int level_23;
	int level_35;
	int level_51;
	int level_87;
	int level_151;
	int level_203;
	int level_255;
} __packed;

struct RGB_OUTPUT_VOLTARE {
	struct GAMMA_LEVEL R_VOLTAGE;
	struct GAMMA_LEVEL G_VOLTAGE;
	struct GAMMA_LEVEL B_VOLTAGE;
} __packed;

struct GRAY_VOLTAGE {
	/*
		This voltage value use 14bit right shit
		it means voltage is divied by 16384.
	*/
	int R_Gray;
	int G_Gray;
	int B_Gray;
} __packed;

struct GRAY_SCALE {
	struct GRAY_VOLTAGE TABLE[GRAY_SCALE_MAX];
	struct GRAY_VOLTAGE VT_TABLE;
} __packed;

/*V0,V1,V3,V11,V23,V35,V51,V87,V151,V203,V255*/

struct MTP_SET {
	char OFFSET_255_MSB;
	char OFFSET_255_LSB;
	char OFFSET_203;
	char OFFSET_151;
	char OFFSET_87;
	char OFFSET_51;
	char OFFSET_35;
	char OFFSET_23;
	char OFFSET_11;
	char OFFSET_3;
	char OFFSET_1;
} __packed;

struct MTP_OFFSET {
	struct MTP_SET R_OFFSET;
	struct MTP_SET G_OFFSET;
	struct MTP_SET B_OFFSET;
} __packed;

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	struct MTP_OFFSET MTP_ORIGN;

	struct MTP_OFFSET MTP;
	struct RGB_OUTPUT_VOLTARE RGB_OUTPUT;
	struct GRAY_SCALE GRAY;

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;
} __packed;

#define CANDELA_MAX_TABLE 61
#define RGB_COMPENSATION 24

#if defined(AID_OPERATION)
static int candela_table[][2] = {
	{5, 0},
	{6, 1},
	{7, 2},
	{8, 3},
	{9, 4},
	{10, 5},
	{11, 6},
	{12, 7},
	{13, 8},
	{14, 9},
	{15, 10},
	{16, 11},
	{17, 12},
	{19, 13},
	{20, 14},
	{21, 15},
	{22, 16},
	{24, 17},
	{25, 18},
	{27, 19},
	{29, 20},
	{30, 21},
	{32, 22},
	{34, 23},
	{37, 24},
	{39, 25},
	{41, 26},
	{44, 27},
	{47, 28},
	{50, 29},
	{53, 30},
	{56, 31},
	{60, 32},
	{64, 33},
	{68, 34},
	{72, 35},
	{77, 36},
	{82, 37},
	{87, 38},
	{93, 39},
	{98, 40},
	{105, 41},
	{111, 42},
	{119, 43},
	{126, 44},
	{134, 45},
	{143, 46},
	{152, 47},
	{162, 48},
	{172, 49},
	{183, 50},
	{195, 51},
	{207, 52},
	{220, 53},
	{234, 54},
	{249, 55},
	{265, 56},
	{282, 57},
	{300, 58},
	{316, 59},
	{333, 60},
	{350, 61},
};

static int base_luminance_revC[][2] = {
	{5,	  128},	// A-Dimm
	{6,	  128},
	{7,	  128},
	{8,	  128},
	{9,	  128},
	{10,  128},
	{11,  128},
	{12,  128},
	{13,  128},
	{14,  128},
	{15,  128},
	{16,  128},
	{17,  128},
	{19,  128},
	{20,  128},
	{21,  128},
	{22,  128},
	{24,  128},
	{25,  128},
	{27,  128},
	{29,  128},
	{30,  128},
	{32,  128},
	{34,  128},
	{37,  128},
	{39,  128},
	{41,  128},
	{44,  128},
	{47,  128},
	{50,  128},
	{53,  128},
	{56,  128},
	{60,  128},
	{64,  128},
	{68,  128},
	{72,  128},	// S-Dimm
	{77,  137},
	{82,  146},
	{87,  153},
	{93,  163},
	{98,  171},
	{105, 183},
	{111, 191},	// A-Dimm
	{119, 191},
	{126, 191},
	{134, 191},
	{143, 191},
	{152, 191},
	{162, 191},
	{172, 191},
	{183, 191},	// S-Dimm
	{195, 206},
	{207, 217},
	{220, 229},
	{234, 243},
	{249, 256},
	{265, 272},
	{282, 288},
	{300, 304},
	{316, 320},
	{333, 334},
	{350, 350},
};

static int gradation_offset_revC[][9] = {
	 /*V255 V203 V151 V87  V51  V35   V23   V11  V3 */
	{0,	2,	3,	6,	11,	14,	18,	23,	6},
	{0,	3,	4,	6,	9,	12,	16,	21,	6},
	{0,	2,	3,	5,	8,	11,	14,	19,	6},
	{0,	2,	3,	5,	7,	9,	13,	17,	6},
	{0,	2,	3,	4,	6,	9,	12,	16,	6},
	{0,	2,	3,	3,	5,	8,	11,	15,	6},
	{0,	2,	3,	3,	5,	7,	10,	14,	6},
	{0,	2,	2,	3,	5,	7,	9,	13,	6},
	{0,	2,	2,	3,	4,	6,	8,	13,	6},
	{0,	2,	2,	3,	4,	6,	8,	12,	6},
	{0,	2,	2,	3,	5, 	6,	8,	12,	6},
	{0,	2,	2,	3,	3,	5,	7,	11,	5},
	{0,	2,	2,	2,	4,	4,	7,	11,	5},
	{0,	2,	2,	2,	3,	4,	6,	10,	5},
	{0,	2,	2,	2,	3,	4,	6,	10,	5},
	{0,	2,	2,	2,	3,	5,	6,	10,	5},
	{0,	2,	3,	3,	4,	5,	7,	11,	5},
	{0,	2,	3,	3,	4,	5,	7,	11,	5},
	{0,	2,	3,	4,	4,	5,	7,	11,	5},
	{0,	2,	3,	4,	4,	5,	7,	11,	5},
	{0,	2,	3,	4,	4,	5,	7,	11,	5},
	{0,	2,	3,	4,	4,	5,	7,	11,	5},
	{0,	2,	3,	4,	4,	5,	7,	10,	5},
	{0,	2,	3,	3,	4,	5,	6,	10,	5},
	{0,	2,	3,	3,	4,	4,	6,	9,	4},
	{0,	2,	3,	3,	4,	4,	6,	9,	4},
	{0,	2,	3,	3,	4,	4,	5,	8,	4},
	{0,	2,	3,	3,	3,	4,	5,	8,	4},
	{0,	2,	3,	3,	3,	3,	5,	8,	4},
	{0,	2,	3,	3,	3,	3,	5,	7,	4},
	{0,	2,	3,	3,	3,	3,	4,	7,	4},
	{0,	2,	3,	3,	3,	3,	4,	6,	4},
	{0,	2,	3,	3,	3,	3,	4,	6,	4},
	{0,	2,	3,	3,	3,	2,	4,	6,	4},
	{0,	2,	2,	3,	3,	2,	4,	5,	4},
	{0,	2,	3,	3,	2,	2,	3,	5,	3},
	{0,	2,	3,	3,	1,	2,	2,	4,	3},
	{0,	2,	3,	3,	1,	2,	3,	4,	3},
	{0,	1,	4,	3,	2,	2,	2,	4,	3},
	{0,	1,	4,	4,	3,	2,	3,	5,	3},
	{0,	1,	4,	4,	2,	3,	2,	4,	3},
	{0,	1,	4,	5,	3,	3,	3,	4,	3},
	{0,	1,	4,	4,	3,	2,	3,	4,	3},
	{0,	1,	3,	4,	3,	2,	3,	3,	3},
	{0,	1,	3,	3,	2,	2,	3,	3,	3},
	{0,	1,	3,	3,	2,	1,	2,	3,	3},
	{0,	1,	3,	3,	2,	1,	2,	3,	3},
	{0,	1,	3,	3,	2,	1,	2,	2,	3},
	{0,	1,	3,	3,	2,	1,	2,	2,	3},
	{0,	1,	2,	2,	1,	1,	2,	2,	3},
	{0,	1,	3,	2,	1,	1,	1,	2,	2},
	{0,	0,	2,	2,	1,	1,	1,	2,	2},
	{0,	0,	2,	1,	0,	1,	0,	2,	2},
	{0,	0,	2,	1,	0,	1,	0,	1,	1},
	{0,	0,	2,	1,	0,	1,	0,	1,	1},
	{0,	0,	1,	1,	0,	0,	0,	1,	1},
	{0,	0,	1,	0,	0,	0,	0,	0,	1},
	{0,	0,	1,	0,	0,	-1,	0,	0,	1},
	{0,	0,	1,	0,	-1,	0,	0,	0,	0},
	{0,	0,	0,	-1,	-1,	0,	0,	0,	0},
	{0,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revC[][RGB_COMPENSATION] = {
        //------ 255 ------|--------- 203 ------|-------- 151 -------|--------- 87 -------|-------- 51 ----------|--------- 35 -------|-------- 23 --------|------- 11 ---------|
	{0,	0,	1,	-1,	0,	0,	-2,	0,	-2,	-1,	0,	0,	-14,	0,	-1,	-16,	0,	-7,	-18,	0,	-7,	1,	0,	-1},
	{0,	0,	1,	-1,	0,	-1,	-2,	0,	-2,	-1,	0,	0,	-18,	0,	-5,	-4,	0,	1,	-15,	0,	-5,	-1,	0,	0},
	{0,	0,	1,	0,	0,	0,	-2,	0,	-2,	-1,	0,	-1,	-17,	0,	1,	-6,	0,	-2,	-7,	0,	2,	-9,	0,	-6},
	{0,	0,	1,	0,	0,	0,	-2,	0,	-2,	-1,	0,	-1,	-15,	0,	-5,	-11,	0,	-3,	-16,	0,	-7,	-1,	0,	3},
	{0,	0,	1,	0,	0,	0,	-2,	0,	-2,	2,	0,	1,	-13,	0,	-5,	-7,	0,	1,	-12,	0,	-1,	-10,	0,	-6},
	{0,	0,	1,	0,	0,	0,	-2,	0,	-2,	2,	0,	0,	-12,	0,	3,	-7,	0,	-6,	-15,	0,	-3,	-9,	0,	-5},
	{0,	0,	1,	0,	0,	0,	-2,	0,	-2,	2,	0,	1,	-13,	0,	3,	-7,	0,	-5,	-14,	0,	-5,	-8,	0,	-6},
	{0,	0,	0,	0,	0,	0,	-2,	0,	-1,	0,	0,	2,	-11,	0,	-4,	-6,	0,	0,	-9,	0,	-1,	-12,	0,	-11},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-2,	0,	-1,	-10,	0,	-2,	-5,	0,	0,	-8,	0,	2,	-14,	0,	-13},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-1,	0,	-1,	-10,	0,	-2,	-4,	0,	0,	-11,	0,	-2,	-14,	0,	-12},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	2,	-10,	0,	3,	-7,	0,	-6,	-9,	0,	-2,	-13,	0,	-10},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	-7,	0,	0,	-8,	0,	-3,	-6,	0,	0,	-18,	0,	-14},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	3,	0,	2,	-4,	0,	5,	-6,	0,	-5,	-9,	0,	-2,	-18,	0,	-12},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	0,	-8,	0,	5,	-2,	0,	-5,	-6,	0,	0,	-18,	0,	-15},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	0,	-8,	0,	5,	-3,	0,	-5,	-1,	0,	-1,	-20,	0,	-12},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	0,	-7,	0,	4,	-2,	0,	-7,	-13,	0,	-5,	-12,	0,	-9},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	1,	0,	1,	-7,	0,	-3,	-4,	0,	-3,	-3,	0,	2,	-15,	0,	-9},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-7,	0,	-2,	-4,	0,	-2,	-2,	0,	2,	-14,	0,	-9},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	-1,	-4,	0,	-2,	-2,	0,	1,	-14,	0,	-11},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	-1,	-3,	0,	-2,	-3,	0,	1,	-13,	0,	-12},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	-1,	-3,	0,	-2,	-1,	0,	1,	-14,	0,	-12},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-5,	0,	-1,	-4,	0,	-3,	-1,	0,	1,	-14,	0,	-12},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-5,	0,	-1,	-2,	0,	-1,	-11,	0,	-6,	-11,	0,	-14},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	1,	-7,	0,	-4,	0,	0,	0,	-10,	0,	-7,	-10,	0,	-8},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	0,	-6,	0,	4,	-2,	0,	-7,	-6,	0,	-4,	-12,	0,	-12},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	0,	-6,	0,	4,	-2,	0,	-7,	-5,	0,	-3,	-11,	0,	-10},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	0,	-5,	0,	4,	-1,	0,	-6,	-7,	0,	-1,	-12,	0,	-15},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	0,	-4,	0,	-1,	1,	0,	-1,	-6,	0,	-1,	-13,	0,	-11},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	0,	0,	0,	-3,	2,	0,	-1,	-14,	0,	-7},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	0,	2,	0,	-2,	-7,	0,	-5,	-12,	0,	-11},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	0,	3,	0,	0,	-5,	0,	-5,	-12,	0,	-8},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	0,	3,	0,	0,	2,	0,	-2,	-15,	0,	-13},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-5,	0,	-1,	2,	0,	1,	2,	0,	-1,	-14,	0,	-11},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	-1,	-6,	0,	1,	0,	0,	-3,	-2,	0,	-4,	-10,	0,	-4},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	2,	0,	0,	-6,	0,	0,	0,	0,	-3,	-3,	0,	-2,	-11,	0,	-10},
	{1,	0,	0,	0,	0,	0,	-1,	0,	-1,	4,	0,	1,	-4,	0,	0,	-1,	0,	-2,	1,	0,	0,	-12,	0,	-8},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-2,	2,	0,	1,	-3,	0,	1,	-1,	0,	-2,	-3,	0,	-4,	-13,	0,	-8},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	3,	0,	1,	-2,	0,	1,	-1,	0,	-2,	2,	0,	0,	-13,	0,	-11},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-1,	0,	0,	0,	-3,	0,	0,	2,	0,	0,	2,	0,	0,	-12,	0,	-10},
	{1,	0,	0,	0,	0,	0,	-2,	0,	-2,	2,	0,	0,	-3,	0,	0,	1,	0,	1,	0,	0,	-1,	-11,	0,	-7},
	{1,	0,	1,	0,	0,	0,	-1,	0,	-2,	2,	0,	0,	0,	0,	0,	-3,	0,	-1,	-2,	0,	-2,	-10,	0,	-6},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	0,	0,	-1,	0,	0,	0,	-2,	0,	0,	-4,	0,	-2,	-10,	0,	-6},
	{1,	0,	1,	0,	0,	1,	1,	0,	-1,	-1,	0,	-3,	-1,	0,	5,	3,	0,	0,	-5,	0,	-3,	-10,	0,	-6},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	0,	0,	-2,	-1,	0,	2,	1,	0,	1,	-4,	0,	-3,	-9,	0,	-7},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-2,	-1,	0,	0,	2,	0,	2,	-5,	0,	-3,	-9,	0,	-5},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-2,	-2,	0,	0,	2,	0,	1,	1,	0,	0,	-10,	0,	-5},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-2,	-2,	0,	0,	2,	0,	1,	1,	0,	0,	-7,	0,	-2},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-2,	-2,	0,	0,	2,	0,	1,	-3,	0,	-3,	-6,	0,	-2},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-2,	-2,	0,	1,	2,	0,	0,	-2,	0,	-5,	-6,	0,	0},
	{1,	0,	1,	0,	0,	1,	0,	0,	-1,	-1,	0,	-3,	-1,	0,	2,	1,	0,	0,	-2,	0,	-6,	-3,	0,	2},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};
#endif

#endif
