/*!
* @section LICENSE
 * (C) Copyright 2011~2015 Bosch Sensortec GmbH All Rights Reserved
 *
 * This software program is licensed subject to the GNU General
 * Public License (GPL).Version 2,June 1991,
 * available at http://www.fsf.org/copyleft/gpl.html
*
* @filename bhy_host_interface.h
* @date     "Fri Oct 30 18:57:44 2015 +0800"
* @id       "3230a0f"
*
* @brief
* The header file for BHy host interface
*/

#ifndef BHY_HOST_INTERFACE_H
#define BHY_HOST_INTERFACE_H

#define BHY_REG_FIFO_BUFFER_0	0x0	/* 0x0 through 0x31 */
#define BHY_REG_FIFO_FLUSH	0x32
#define BHY_REG_CHIP_CTRL	0x34
#define BHY_REG_HOST_STATUS	0x35
#define BHY_REG_INT_STATUS	0x36
#define BHY_REG_CHIP_STATUS	0x37
#define BHY_REG_BYTES_REMAIN_0	0x38	/* 0x38 through 0x39 */
#define BHY_REG_PARAM_ACK	0x3A
#define BHY_REG_SAVED_PARAM_0	0x3B	/* 0x3B through 0x4A */
#define BHY_REG_I2C_SLV_INT_LOC	0x4B
#define BHY_REG_BUFFER_CTRL	0x4C
#define BHY_REG_GP22	0x4D
#define BHY_REG_GP23	0x4E
#define BHY_REG_GP24	0x4F
#define BHY_REG_ERROR	0x50
#define BHY_REG_INT_STATE	0x51
#define BHY_REG_DBG_VALUE	0x52
#define BHY_REG_DBG_STATE	0x53
#define BHY_REG_PARAM_PAGE_SEL	0x54
#define BHY_REG_HOST_CTRL	0x55
#define BHY_REG_GP31	0x56
#define BHY_REG_GP32	0x57
#define BHY_REG_GP33	0x58
#define BHY_REG_GP34	0x59
#define BHY_REG_GP35	0x5A
#define BHY_REG_GP36	0x5B
#define BHY_REG_LOAD_PARAM_0	0x5C	/* 0x5C through 0x63 */
#define BHY_REG_PARAM_REQ	0x64
#define BHY_REG_GP46	0x65
#define BHY_REG_GP47	0x66
#define BHY_REG_GP48	0x67
#define BHY_REG_GP49	0x68
#define BHY_REG_GP50	0x69
#define BHY_REG_GP51	0x6A
#define BHY_REG_GP52	0x6B
#define BHY_REG_HOST_IRQ_TIMESTAMP_1	0x6C /* 0x6C through 0x6F */
#define BHY_REG_ROM_VERSION_0	0x70	/* 0x70 through 0x71 */
#define BHY_REG_RAM_VERSION_0	0x72	/* 0x72 through 0x73 */
#define BHY_REG_PRODUCT_ID	0x90
#define BHY_REG_REV_ID	0x91
#define BHY_REG_UPLOAD_ADDR_0	0x94	/* 0x94 through 0x95 */
#define BHY_REG_UPLOAD_DATA	0x96
#define BHY_REG_DATA_CRC_0	0x97	/* 0x97 through 0x9A */
#define BHY_REG_RESET_REQ	0x9B
#define BHY_REG_PASS_THRU_READY	0x9E
#define BHY_REG_SCL_LOW_CYCLES	0x9F
#define BHY_REG_PASS_THRU_CFG	0xA0
#define BHY_REG_TEST_CLKCONTROL	0XB2

#define BST_FPGA_PRODUCT_ID_7181	0x80
#define BHY_C1_PRODUCT_ID	0x81
#define BST_FPGA_PRODUCT_ID_7183	0x83
#define BHY_RESET_WAIT_RETRY	1000
#define BHY_DEF_RAM_PATCH_FILE_PATH	"/system/vendor/firmware/ram_patch.fw"
#define BHY_FIFO_LEN_MAX	(30 * 1024)
#define BHY_FIFO_READ_LEN	50	/* must be multiple of 50 */
#define BHY_PARAM_ACK_WAIT_RETRY	100

struct __attribute__((__packed__)) ram_patch_header {
	u16 magic;
	u16 flags;
	u32 crc;
	u32 rsv1;
	u16 data_length;
	u16 rsv2;
};

/* Sensor ID from FIFO */
#define BHY_SENSOR_HANDLE_ZERO	0
#define BHY_SENSOR_HANDLE_ACCELEROMETER	1
#define BHY_SENSOR_HANDLE_GEOMAGNETIC_FIELD	2
#define BHY_SENSOR_HANDLE_ORIENTATION	3
#define BHY_SENSOR_HANDLE_GYROSCOPE	4
#define BHY_SENSOR_HANDLE_LIGHT	5
#define BHY_SENSOR_HANDLE_PRESSURE	6
#define BHY_SENSOR_HANDLE_TEMPERATURE	7
#define BHY_SENSOR_HANDLE_PROXIMITY	8
#define BHY_SENSOR_HANDLE_GRAVITY	9
#define BHY_SENSOR_HANDLE_LINEAR_ACCELERATION	10
#define BHY_SENSOR_HANDLE_ROTATION_VECTOR	11
#define BHY_SENSOR_HANDLE_RELATIVE_HUMIDITY	12
#define BHY_SENSOR_HANDLE_AMBIENT_TEMPERATURE	13
#define BHY_SENSOR_HANDLE_MAGNETIC_FIELD_UNCALIBRATED	14
#define BHY_SENSOR_HANDLE_GAME_ROTATION_VECTOR	15
#define BHY_SENSOR_HANDLE_GYROSCOPE_UNCALIBRATED	16
#define BHY_SENSOR_HANDLE_SIGNIFICANT_MOTION	49
#define BHY_SENSOR_HANDLE_STEP_DETECTOR	18
#define BHY_SENSOR_HANDLE_STEP_COUNTER	19
#define BHY_SENSOR_HANDLE_GEOMAGNETIC_ROTATION_VECTOR	20
#define BHY_SENSOR_HANDLE_HEART_RATE	21
#define BHY_SENSOR_HANDLE_ACCELEROMETER_WU	33
#define BHY_SENSOR_HANDLE_GEOMAGNETIC_FIELD_WU	34
#define BHY_SENSOR_HANDLE_ORIENTATION_WU	35
#define BHY_SENSOR_HANDLE_GYROSCOPE_WU	36
#define BHY_SENSOR_HANDLE_LIGHT_WU	37
#define BHY_SENSOR_HANDLE_PRESSURE_WU	38
#define BHY_SENSOR_HANDLE_TEMPERATURE_WU	39
#define BHY_SENSOR_HANDLE_PROXIMITY_WU	40
#define BHY_SENSOR_HANDLE_GRAVITY_WU	41
#define BHY_SENSOR_HANDLE_LINEAR_ACCELERATION_WU	42
#define BHY_SENSOR_HANDLE_ROTATION_VECTOR_WU	43
#define BHY_SENSOR_HANDLE_RELATIVE_HUMIDITY_WU	44
#define BHY_SENSOR_HANDLE_AMBIENT_TEMPERATURE_WU	45
#define BHY_SENSOR_HANDLE_MAGNETIC_FIELD_UNCALIBRATED_WU	46
#define BHY_SENSOR_HANDLE_GAME_ROTATION_VECTOR_WU	47
#define BHY_SENSOR_HANDLE_GYROSCOPE_UNCALIBRATED_WU	48
#define BHY_SENSOR_HANDLE_STEP_DETECTOR_WU	50
#define BHY_SENSOR_HANDLE_STEP_COUNTER_WU	51
#define BHY_SENSOR_HANDLE_GEOMAGNETIC_ROTATION_VECTOR_WU	52
#define BHY_SENSOR_HANDLE_HEART_RATE_WU	53
#define BHY_SENSOR_HANDLE_TILT_DETECTOR	54
#define BHY_SENSOR_HANDLE_WAKE_GESTURE	55
#define BHY_SENSOR_HANDLE_GLANCE_GESTURE	56
#define BHY_SENSOR_HANDLE_PICK_UP_GESTURE	57
#define BHY_SENSOR_HANDLE_ACTIVITY_RECOGNITION	63
#define BHY_SENSOR_HANDLE_MAX	BHY_SENSOR_HANDLE_ACTIVITY_RECOGNITION
/* raw gyro */
#define BHY_SENSOR_HANDLE_BSX_C	249
/* raw mag */
#define BHY_SENSOR_HANDLE_BSX_B	250
/* raw accel */
#define BHY_SENSOR_HANDLE_BSX_A	251
#define BHY_SENSOR_HANDLE_TIMESTAMP_LSW	252
#define BHY_SENSOR_HANDLE_TIMESTAMP_MSW	253
/* Not to confuse with google's meta event */
#define BHY_SENSOR_HANDLE_META_EVENT	254
#define BHY_SENSOR_HANDLE_TIMESTAMP_LSW_WU	246
#define BHY_SENSOR_HANDLE_TIMESTAMP_MSW_WU	247
#define BHY_SENSOR_HANDLE_META_EVENT_WU	248
#define BHY_SENSOR_HANDLE_TIMESTAMP_SYNC	255
#define BHY_SENSOR_HANDLE_DEBUG	245
/* Custom sensor */
#define BHY_SENSOR_HANDLE_CUSTOM_1	26
#define BHY_SENSOR_HANDLE_CUSTOM_2	27
#define BHY_SENSOR_HANDLE_CUSTOM_3	28
#define BHY_SENSOR_HANDLE_CUSTOM_4	29
#define BHY_SENSOR_HANDLE_CUSTOM_5	30
#define BHY_SENSOR_HANDLE_CUSTOM_1_WU	58
#define BHY_SENSOR_HANDLE_CUSTOM_2_WU	59
#define BHY_SENSOR_HANDLE_CUSTOM_3_WU	60
#define BHY_SENSOR_HANDLE_CUSTOM_4_WU	61
#define BHY_SENSOR_HANDLE_CUSTOM_5_WU	62

#define BHY_AR_ACTIVATE 1

/* Sensor data len */
#define BHY_SENSOR_DATA_LEN_ACCELEROMETER	7
#define BHY_SENSOR_DATA_LEN_GEOMAGNETIC_FIELD	7
#define BHY_SENSOR_DATA_LEN_ORIENTATION	7
#define BHY_SENSOR_DATA_LEN_GYROSCOPE	7
#define BHY_SENSOR_DATA_LEN_LIGHT	2
#define BHY_SENSOR_DATA_LEN_PRESSURE	3
#define BHY_SENSOR_DATA_LEN_TEMPERATURE	2
#define BHY_SENSOR_DATA_LEN_PROXIMITY	2
#define BHY_SENSOR_DATA_LEN_GRAVITY	7
#define BHY_SENSOR_DATA_LEN_LINEAR_ACCELERATION	7
#define BHY_SENSOR_DATA_LEN_ROTATION_VECTOR	10
#define BHY_SENSOR_DATA_LEN_RELATIVE_HUMIDITY	2
#define BHY_SENSOR_DATA_LEN_AMBIENT_TEMPERATURE	2
#define BHY_SENSOR_DATA_LEN_MAGNETIC_FIELD_UNCALIBRATED	13
#define BHY_SENSOR_DATA_LEN_GAME_ROTATION_VECTOR	10
#define BHY_SENSOR_DATA_LEN_GYROSCOPE_UNCALIBRATED	13
#define BHY_SENSOR_DATA_LEN_SIGNIFICANT_MOTION	0
#define BHY_SENSOR_DATA_LEN_STEP_DETECTOR	0
#define BHY_SENSOR_DATA_LEN_STEP_COUNTER	4
#define BHY_SENSOR_DATA_LEN_GEOMAGNETIC_ROTATION_VECTOR	10
#define BHY_SENSOR_DATA_LEN_HEART_RATE	1
#define BHY_SENSOR_DATA_LEN_ACCELEROMETER_WU	7
#define BHY_SENSOR_DATA_LEN_GEOMAGNETIC_FIELD_WU	7
#define BHY_SENSOR_DATA_LEN_ORIENTATION_WU	7
#define BHY_SENSOR_DATA_LEN_GYROSCOPE_WU	7
#define BHY_SENSOR_DATA_LEN_LIGHT_WU	2
#define BHY_SENSOR_DATA_LEN_PRESSURE_WU	3
#define BHY_SENSOR_DATA_LEN_TEMPERATURE_WU	2
#define BHY_SENSOR_DATA_LEN_PROXIMITY_WU	2
#define BHY_SENSOR_DATA_LEN_GRAVITY_WU	7
#define BHY_SENSOR_DATA_LEN_LINEAR_ACCELERATION_WU	7
#define BHY_SENSOR_DATA_LEN_ROTATION_VECTOR_WU	10
#define BHY_SENSOR_DATA_LEN_RELATIVE_HUMIDITY_WU	2
#define BHY_SENSOR_DATA_LEN_AMBIENT_TEMPERATURE_WU	2
#define BHY_SENSOR_DATA_LEN_MAGNETIC_FIELD_UNCALIBRATED_WU	13
#define BHY_SENSOR_DATA_LEN_GAME_ROTATION_VECTOR_WU	10
#define BHY_SENSOR_DATA_LEN_GYROSCOPE_UNCALIBRATED_WU	13
#define BHY_SENSOR_DATA_LEN_STEP_DETECTOR_WU	0
#define BHY_SENSOR_DATA_LEN_STEP_COUNTER_WU	2
#define BHY_SENSOR_DATA_LEN_GEOMAGNETIC_ROTATION_VECTOR_WU	10
#define BHY_SENSOR_DATA_LEN_HEART_RATE_WU	1
#define BHY_SENSOR_DATA_LEN_TILT_DETECTOR	0
#define BHY_SENSOR_DATA_LEN_WAKE_GESTURE	0
#define BHY_SENSOR_DATA_LEN_GLANCE_GESTURE	0
#define BHY_SENSOR_DATA_LEN_PICK_UP_GESTURE	0
#define BHY_SENSOR_DATA_LEN_ACTIVITY_RECOGNITION	2
#define BHY_SENSOR_DATA_LEN_BSX_C	16
#define BHY_SENSOR_DATA_LEN_BSX_B	16
#define BHY_SENSOR_DATA_LEN_BSX_A	16
#define BHY_SENSOR_DATA_LEN_TIMESTAMP_LSW	2
#define BHY_SENSOR_DATA_LEN_TIMESTAMP_MSW	2
#define BHY_SENSOR_DATA_LEN_META_EVENT	3
#define BHY_SENSOR_DATA_LEN_TIMESTAMP_LSW_WU	2
#define BHY_SENSOR_DATA_LEN_TIMESTAMP_MSW_WU	2
#define BHY_SENSOR_DATA_LEN_META_EVENT_WU	3
#define BHY_SENSOR_DATA_LEN_DEBUG	13
#define BHY_SENSOR_DATA_LEN_CUSTOM_1	1
#define BHY_SENSOR_DATA_LEN_CUSTOM_2	7
#define BHY_SENSOR_DATA_LEN_CUSTOM_3	14
#define BHY_SENSOR_DATA_LEN_CUSTOM_4	1
#define BHY_SENSOR_DATA_LEN_CUSTOM_5	7
#define BHY_SENSOR_DATA_LEN_CUSTOM_1_WU	7
#define BHY_SENSOR_DATA_LEN_CUSTOM_2_WU	7
#define BHY_SENSOR_DATA_LEN_CUSTOM_3_WU	14
#define BHY_SENSOR_DATA_LEN_CUSTOM_4_WU	1
#define BHY_SENSOR_DATA_LEN_CUSTOM_5_WU	7
#define BHY_SENSOR_DATA_LEN_MAX	16

/* Physical sensor handles */
#define BHY_PHYS_HANDLE_ACC	BHY_SENSOR_HANDLE_ACCELEROMETER
#define BHY_PHYS_HANDLE_MAG	BHY_SENSOR_HANDLE_MAGNETIC_FIELD_UNCALIBRATED
#define BHY_PHYS_HANDLE_GYRO	BHY_SENSOR_HANDLE_GYROSCOPE_UNCALIBRATED

/* system page */
#define BHY_PAGE_SYSTEM	1
#define BHY_PARAM_SYSTEM_META_EVENT_CTRL	1
#define BHY_PARAM_SYSTEM_FIFO_CTRL	2
#define BHY_PARAM_SYSTEM_STAUS_BANK_0	3
#define BHY_PARAM_SYSTEM_STAUS_BANK_1	4
#define BHY_PARAM_SYSTEM_STAUS_BANK_2	5
#define BHY_PARAM_SYSTEM_STAUS_BANK_3	6
#define BHY_PARAM_SYSTEM_CUSTOM_VERSION	24
#define BHY_PARAM_SYSTEM_WAKE_UP_META_EVENT_CTRL	29
#define BHY_PARAM_SYSTEM_HOST_IRQ_TIMESTAMP	30
#define BHY_PARAM_SYSTEM_PHYSICAL_SENSOR_STATUS	31
#define BHY_PARAM_SYSTEM_PHYSICAL_SENSOR_PRESENT	32
#define BHY_PARAM_SYSTEM_PHYSICAL_SENSOR_DETAIL_0	32
#define BHY_PARAM_SYSTEM_PHYSICAL_SENSOR_DETAIL_ACC		33

/* algorithm page */
#define BHY_PAGE_ALGORITHM	2
#define BHY_PARAM_SIC_MATRIX_0_1	1
#define BHY_PARAM_SIC_MATRIX_2_3	2
#define BHY_PARAM_SIC_MATRIX_4_5	3
#define BHY_PARAM_SIC_MATRIX_6_7	4
#define BHY_PARAM_SIC_MATRIX_8	5
#define BHY_PARAM_OFFSET_ACC	6
#define BHY_PARAM_OFFSET_MAG	7
#define BHY_PARAM_OFFSET_GYRO	8
#define BHY_PARAM_WORKING_MODE_ENABLE	9
#define BHY_PARAM_OPERATING_MODE	10
#define BHY_PARAM_OFFSET_ACC_2	15
#define BHY_PARAM_OFFSET_MAG_2	16
#define BHY_PARAM_OFFSET_GYRO_2	17
#define BHY_PARAM_SELFTEST_DIFF_X	18
#define BHY_PARAM_BSX_VERSION	126
#define BHY_PARAM_VIRTUAL_BSX_ENABLE	127

/* sensor page */
#define BHY_PAGE_SENSOR	3
#define BHY_PARAM_SENSOR_INFO_0	0
#define BHY_PARAM_SENSOR_CONF_0	64

/* soft pass through page */
#define BHY_PAGE_SOFT_PASS_THRU	15
#define BHY_PARAM_SOFT_PASS_THRU_READ	1
#define BHY_PARAM_SOFT_PASS_THRU_WRITE	2
#define BHY_PARAM_SOFT_PASS_THRU_READ_NONBURST	3
#define BHY_PARAM_SOFT_PASS_THRU_WRITE_NONBURST	4
#define BHY_SOFT_PASS_THRU_READ_RETRY	1000

#define BHY_CALIB_PROFILE_LEN		9
#define BHY_FIFO_CTRL_PARAM_LEN		8
#define BHY_SENSOR_STATUS_BANK_LEN	64

#define RESET_FLAG_TODO			0
#define RESET_FLAG_READY		1
#define RESET_FLAG_INITIALIZED	2
#define RESET_FLAG_SELF_TEST	3
#define RESET_FLAG_ERROR		4

#define META_EVENT_SELF_TEST_RESULTS	15
#define META_EVENT_INITIALIZED	16

#define BHY_WAKE_UP_FLAG		0x20

#define BHY_FLUSH_DISCARD_ALL	0xFE
#define BHY_FLUSH_FLUSH_ALL	0xFF

/* Host control reg masks */
#define HOST_CTRL_MASK_ALGORITHM_STANDBY	(1 << 0)
#define HOST_CTRL_MASK_ABORT_TRANSFER	(1 << 1)
#define HOST_CTRL_MASK_UPDATE_TRANSFER_COUNT	(1 << 2)
#define HOST_CTRL_MASK_WAKEUP_FIFO_IRQ_DISABLE	(1 << 3)
#define HOST_CTRL_MASK_NED_COORDINATES	(1 << 4)
#define HOST_CTRL_MASK_AP_SUSPENDED	(1 << 5)
#define HOST_CTRL_MASK_SELF_TEST_REQ	(1 << 6)
#define HOST_CTRL_MASK_NON_WAKEUP_FIFO_IRQ_DISABLE	(1 << 7)

/* Host status bits */
#define BHY_HOST_STATUS_MASK_RESET	(1 << 0)
#define BHY_HOST_STATUS_MASK_ALGO_STANDBY	(1 << 1)
#define BHY_HOST_STATUS_MASK_HOST_INTERFACE_ID	(0x7 << 2)
#define BHY_HOST_STATUS_MASK_ALGO_ID	(0x7 << 5)

/* Chip status bits */
#define BHY_CHIP_STATUS_BIT_EEPROM_DETECTED	(1 << 0)
#define BHY_CHIP_STATUS_BIT_EE_UPLOAD_DONE	(1 << 1)
#define BHY_CHIP_STATUS_BIT_EE_UPLOAD_ERROR	(1 << 2)
#define BHY_CHIP_STATUS_BIT_FIRMWARE_IDLE	(1 << 3)
#define BHY_CHIP_STATUS_BIT_NO_EEPROM	(1 << 4)

/* BMI160 control */
#define BHY_SLAVE_ADDR_BMI160	0x69
#define BMI160_REG_PMU_STATUS	0x03
#define BMI160_PMU_STATUS_MASK_ACC	(0x03 << 4)
#define BMI160_PMU_STATUS_OFFSET_ACC	4
#define BMI160_PMU_STATUS_MASK_GYRO	(0x03 << 2)
#define BMI160_PMU_STATUS_OFFSET_GYRO	2
#define BMI160_PMU_STATUS_SUSPEND 0
#define BMI160_PMU_STATUS_NORMAL 1
#define BMI160_REG_STATUS	0x1B
#define BMI160_STATUS_BIT_FOC_RDY	0x08
#define BMI160_STATUS_BIT_NVM_RDY	0x10
#define BMI160_REG_FOC_CONF	0x69
#define BMI160_FOC_CONF_MASK_ACC_X	(0x03 << 4)
#define BMI160_FOC_CONF_OFFSET_ACC_X	4
#define BMI160_FOC_CONF_MASK_ACC_Y	(0x03 << 2)
#define BMI160_FOC_CONF_OFFSET_ACC_Y	2
#define BMI160_FOC_CONF_MASK_ACC_Z	0x03
#define BMI160_FOC_CONF_OFFSET_ACC_Z	0
#define BMI160_FOC_CONF_MASK_GYRO	(0x03 << 6)
#define BMI160_FOC_CONF_OFFSET_GYRO	6
#define BMI160_FOC_CONF_DISABLE	0
#define BMI160_FOC_CONF_1G	1
#define BMI160_FOC_CONF_N1G	2
#define BMI160_FOC_CONF_0	3
#define BMI160_REG_CONF	0x6A
#define BMI160_CONF_BIT_NVM	0x02
#define BMI160_REG_ACC_OFFSET_X	0x71
#define BMI160_REG_GYRO_OFFSET_X	0x74
#define BMI160_REG_OFFSET_6	0x77
#define BMI160_OFFSET_6_BIT_ACC_EN	0x40
#define BMI160_OFFSET_6_BIT_GYRO_EN	0x80
#define BMI160_OFFSET_6_MASK_GYRO_X	0x03
#define BMI160_OFFSET_6_OFFSET_GYRO_X	0
#define BMI160_OFFSET_6_MASK_GYRO_Y	(0x03 << 2)
#define BMI160_OFFSET_6_OFFSET_GYRO_Y	2
#define BMI160_OFFSET_6_MASK_GYRO_Z	(0x03 << 4)
#define BMI160_OFFSET_6_OFFSET_GYRO_Z	4
#define BMI160_REG_CMD	0x7E
#define BMI160_CMD_START_FOC	0x03
#define BMI160_CMD_PMU_BASE_ACC	0x10
#define BMI160_CMD_PMU_BASE_GYRO	0x14
#define BMI160_CMD_PROG_NVM	0xA0
#define BMI160_OP_RETRY	1000
#define BMI160_REG_ACC_RANGE	0x41
#define BMI160_ACC_RANGE_MASK	0x0F
#define BMI160_ACC_RANGE_4G	0x05

/* BMA2X2 control */
#define BHY_SLAVE_ADDR_BMA2X2_FPGA	0x11 /* FPGA, BMA250 */
#define BHY_SLAVE_ADDR_BMA2X2_CLCC	0x18 /* CLCC, BMA280 */
#define BHY_SLAVE_ADDR_BMA2X2_FF	0x19 /* FF, BHA */
#define BHY_SLAVE_ADDR_BMA2X2	BHY_SLAVE_ADDR_BMA2X2_FF
#define BMA2X2_REG_OFC_CTRL	0x36
#define BMA2X2_CAL_TRIGGER_X	0x20
#define BMA2X2_CAL_TRIGGER_Y	0x40
#define BMA2X2_CAL_TRIGGER_Z	0x60
#define BMA2X2_CAL_RDY_MASK	0x10
#define BMA2X2_REG_OFC_SETTING	0x37
#define BMA2X2_OFC_CONF_MASK_X	(0x03 << 1)
#define BMA2X2_OFC_CONF_OFFSET_X	1
#define BMA2X2_OFC_CONF_MASK_Y	(0x03 << 3)
#define BMA2X2_OFC_CONF_OFFSET_Y	3
#define BMA2X2_OFC_CONF_MASK_Z	(0x03 << 5)
#define BMA2X2_OFC_CONF_OFFSET_Z	5
#define BMA2X2_OFC_CONF_DISABLE	0
#define BMA2X2_OFC_CONF_1G	1
#define BMA2X2_OFC_CONF_N1G	2
#define BMA2X2_OFC_CONF_0	3
#define BMA2X2_REG_OFC_OFFSET_X	0x38
#define BMA2X2_REG_OFC_OFFSET_Y	0x39
#define BMA2X2_REG_OFC_OFFSET_Z	0x3A
#define BMA2X2_REG_PMU_LPW	0x11
#define BMA2X2_PMU_CONF_MASK	0xE0
#define BMA2X2_PMU_CONF_NORMAL	0
#define BMA2X2_PUM_CONF_SUSPENDED	(1 << 7)
#define BMA2X2_OP_RETRY	1000
#define BMA2X2_REG_PMU_RANGE	0x0F
#define BMA2X2_PMU_RANGE_2G	0x03
#define BMA2X2_PMU_RANGE_4G	0x05
#define BMA2X2_PMU_RANGE_8G	0x08
#define BMA2X2_PMU_RANGE_16G	0x0C
#define BMA2X2_REG_PMU_BW	0x10
#define BMA2X2_PMU_BW_MIN	0x08	/* 7.81Hz */
#define BMA2X2_PMU_BW_15_63	0x09
#define BMA2X2_PMU_BW_31_25	0x0A
#define BMA2X2_PMU_BW_62_5	0x0B
#define BMA2X2_PMU_BW_125	0x0C
#define BMA2X2_PMU_BW_250	0x0D
#define BMA2X2_PMU_BW_500	0x0E
#define BMA2X2_PMU_BW_MAX	0x0F	/* 1kHz */

#endif /** BHY_HOST_INTERFACE_H */
