/*====================================================================================
    EVS Codec 3GPP TS26.443 Oct 20, 2015. Version 12.4.0
  ====================================================================================*/

#include "options.h"
#include "cnst.h"

const short hangover_hd_tbl[3] = {1, 1, 3};
const short hangover_sf_tbl[6] = {1, 3, 4, 1, 1, 2};
const short bwd_start_bin[BWD_N_BINS_MAX] = {1, 3, 6, 11};
const short bwd_end_bin[BWD_N_BINS_MAX] = {1, 4, 9, 12};

const short BAND_NUM_TAB[5] = {10,10,20,40,60};	 /* {OFFSET, NB, WB, SWB, FB} */

const float M_inr[16] =
{
    1.00000000f, 0.98078525f, 0.92387950f, 0.83146960f, 0.70710677f, 0.55557019f, 0.38268343f, 0.19509035f,
    0.00000008f, -0.19509020f, -0.38268328f, -0.55557019f, -0.70710677f, -0.83146966f, -0.92387962f, -0.98078531f
};

const float M_ini[16] =
{
    0.00000000f, 0.19509032f, 0.38268346f, 0.55557024f, 0.70710677f, 0.83146966f, 0.92387950f, 0.98078525f,
    1.00000000f, 0.98078531f, 0.92387956f, 0.83146966f, 0.70710677f, 0.55557019f, 0.38268328f, 0.19509009f
};

const float M_r[8] =
{
    1.00000000f, 0.92387950f, 0.70710677f, 0.38268343f, -0.00000004f, -0.38268352f, -0.70710677f, -0.92387950f
};

const float M_i[8] =
{
    0.00000000f, 0.38268346f, 0.70710677f, 0.92387950f, 1.00000000f, 0.92387950f, 0.70710677f, 0.38268349f
};

const float M_Wr[16]=
{
    9.9518473e-001f,  9.5694034e-001f,  8.8192126e-001f,  7.7301045e-001f,  6.3439328e-001f,  4.7139674e-001f,  2.9028468e-001f,  9.8017140e-002f,
    -9.8017140e-002f, -2.9028468e-001f, -4.7139674e-001f, -6.3439328e-001f, -7.7301045e-001f, -8.8192126e-001f, -9.5694034e-001f, -9.9518473e-001f
};

const float M_Wi[16] =
{
    9.8017140e-002f,  2.9028468e-001f, 4.7139674e-001f, 6.3439328e-001f, 7.7301045e-001f, 8.8192126e-001f, 9.5694034e-001f, 9.9518473e-001f,
    9.9518473e-001f, 9.5694034e-001f, 8.8192126e-001f, 7.7301045e-001f, 6.3439328e-001f, 4.7139674e-001f, 2.9028468e-001f, 9.8017140e-002f
};

const short SP_CENTER_BAND_NUM_TAB[5] = {10, 10, 20, 24, 24};

/* 107374184.f = 32768.f * 32768.f * 0.1 */
const float DELTA1[5] = {107374184.f, 0.0f, 107374184.f, 107374184.f, 0.0f};
const float DELTA2[5] = {107374184.f, 1.f, 107374184.f, 107374184.f, 107374184.f};

const int NREGION_INDEX_NB[9]   = {0,1,2,3,4,5,6,7, 9};
const int NREGION_INDEX_WB[13]  = {0,1,2,3,4,5,6,8,10,12,16};
const int NREGION_INDEX_SWB[16] = {0,1,2,3,4,5,6,8,10,12,16,24,36};
const int NREGION_INDEX_FB[16]  = {0,1,2,3,4,5,6,8,10,12,16,24,36};
const int ENERGY_BAND_NUM[4] = {8,10,12,MAX_SUBBAND_NUM};
const int *const REGION_INDEX[4] = {NREGION_INDEX_NB, NREGION_INDEX_WB,NREGION_INDEX_SWB,NREGION_INDEX_FB};
const float MAX_LF_SNR_TAB[4] = {0.8f, 0.8f, 1.6f, 0.8f};

const float COMVAD_INIT_SNR_DELTA[5] = {1.0f, 0.6f, 0.86f, 1.16f, 1.0f};
const float LS_MIN_SELENCE_SNR[3] = {7.5f, 7.5f, 6.8f};
const float LT_MIN_SILENCE_SNR[3] = {4.5f, 4.5f, 4.5f};

/* half of the square root hanning window for spectral analysis */
const float sqrt_han_window[L_FFT/2+1]=
{
    0.000000f, 0.012272f, 0.024541f, 0.036807f, 0.049068f, 0.061321f, 0.073565f, 0.085797f,
    0.098017f, 0.110222f, 0.122411f, 0.134581f, 0.146730f, 0.158858f, 0.170962f, 0.183040f,
    0.195090f, 0.207111f, 0.219101f, 0.231058f, 0.242980f, 0.254866f, 0.266713f, 0.278520f,
    0.290285f, 0.302006f, 0.313682f, 0.325310f, 0.336890f, 0.348419f, 0.359895f, 0.371317f,
    0.382683f, 0.393992f, 0.405241f, 0.416430f, 0.427555f, 0.438616f, 0.449611f, 0.460539f,
    0.471397f, 0.482184f, 0.492898f, 0.503538f, 0.514103f, 0.524590f, 0.534998f, 0.545325f,
    0.555570f, 0.565732f, 0.575808f, 0.585798f, 0.595699f, 0.605511f, 0.615232f, 0.624860f,
    0.634393f, 0.643832f, 0.653173f, 0.662416f, 0.671559f, 0.680601f, 0.689541f, 0.698376f,
    0.707107f, 0.715731f, 0.724247f, 0.732654f, 0.740951f, 0.749136f, 0.757209f, 0.765167f,
    0.773010f, 0.780737f, 0.788346f, 0.795837f, 0.803208f, 0.810457f, 0.817585f, 0.824589f,
    0.831470f, 0.838225f, 0.844854f, 0.851355f, 0.857729f, 0.863973f, 0.870087f, 0.876070f,
    0.881921f, 0.887640f, 0.893224f, 0.898674f, 0.903989f, 0.909168f, 0.914210f, 0.919114f,
    0.923880f, 0.928506f, 0.932993f, 0.937339f, 0.941544f, 0.945607f, 0.949528f, 0.953306f,
    0.956940f, 0.960431f, 0.963776f, 0.966976f, 0.970031f, 0.972940f, 0.975702f, 0.978317f,
    0.980785f, 0.983105f, 0.985278f, 0.987301f, 0.989177f, 0.990903f, 0.992480f, 0.993907f,
    0.995185f, 0.996313f, 0.997290f, 0.998118f, 0.998795f, 0.999322f, 0.999699f, 0.999925f,
    1.000000f
};

/*----------------------------------------------------------------------------------*
 * Starting points for pulse position search in Algebraic innovation codebook
 *----------------------------------------------------------------------------------*/

const short tipos[40] =
{
    0, 1, 2, 3, /* starting point &ipos[0], 1st iter */
    1, 2, 3, 0, /* starting point &ipos[4], 2nd iter */
    2, 3, 0, 1, /* starting point &ipos[8], 3rd iter */
    3, 0, 1, 2, /* starting point &ipos[12], 4th iter */
    0, 1, 2, 3,
    1, 2, 3, 0,
    2, 3, 0, 1,
    3, 0, 1, 2,
    0, 1, 2, 3,
    1, 2, 3, 0 /* end point for 28 pulses &ipos[39], 4th iter */
};

/*----------------------------------------------------------------------------------*
 * 1/4 resolution interpolation filter (-3 dB at 0.791*fs/2)
 * for fractional pitch search
 *----------------------------------------------------------------------------------*/

/* 1/4 resolution interpolation filter (-3 dB at 0.791*fs/2) */
const float sEVS_E_ROM_inter4_1[PIT_UP_SAMP * L_INTERPOL1 + 1] =
{
    0.900000F,
    0.818959F,  0.604850F,  0.331379F,  0.083958F,
    -0.075795F, -0.130717F, -0.105685F, -0.046774F,
    0.004467F,  0.027789F,  0.025642F,  0.012571F,
    0.001927F, -0.001571F, -0.000753F,  0.000000f
};

/* 1/6 resolution interpolation filter (-3 dB at 0.9*fs/2) */
const float sEVS_E_ROM_inter6_1[PIT_UP_SAMP6 * L_INTERPOL1 + 1] =
{
    0.900848F,
    0.864136F,    0.760071F,    0.605408F,    0.424072F,
    0.242462F,    0.0840759F,  -0.0343933F,  -0.105560F,
    -0.131348F,   -0.121124F,   -0.0884705F,  -0.0476379F,
    -0.0102539F,   0.0162964F,   0.0296021F,   0.0312195F,
    0.0251160F,   0.0157471F,   0.00671387F,  0.000000F,
    -0.00399780F, -0.00592041F, -0.00656128F, 0.000000F
};

/*----------------------------------------------------------------------------------*
 * Open-loop pitch tables
 *----------------------------------------------------------------------------------*/
const short nb_sect_12k8[3]    = { 4, 4, 4 };
const short nb_subsect_12k8[3] = { 7, 7, 7 };
const short pit_max_12k8[8] = { 11, 16, 21, 31, 40, 61, 77, 115};

const short len_12k8[4]     = { 40, 40, 62, 115 };
const short len1_12k8[4]    = { 40, 50, 80, 115 };
const short sublen_12k8[7]  = { 40, 40, 40, 62, 62, 115, 115 };
const short sublen1_12k8[7] = { 40, 40, 50, 50, 80,  80, 115 } ;
const short sec_length_12k8[4]  = {  7, 15, 30, 54 };
const short sec_length1_12k8[4] = { 10, 19, 37, 38 };
const float h_fir[5] = {0.13f, 0.23f, 0.28f, 0.23f, 0.13f};

const float W_HIST[DTX_HIST_SIZE] =
{
    0.2f, 0.16f, 0.128f, 0.1024f, 0.08192f, 0.065536f, 0.0524288f, 0.01048576f
};

const float preemphCompensation[NB_BANDS] = { 9.7461f, 9.5182f, 9.0262f, 8.3493f, 7.5764f, 6.7838f, 5.8377f, 4.8502f, 4.0346f, 3.2788f, 2.6283f, 2.0920f, 1.6304f, 1.2850f, 1.0108f, 0.7916f, 0.6268f, 0.5011f, 0.4119f, 0.3637f };

/*----------------------------------------------------------------------------------*
 * LSF quantizer
 *----------------------------------------------------------------------------------*/

const int lsf_numlevels[TCXLPC_NUMSTAGES] = { 32, 16, 16 };
const int lsf_ind_numlevels[TCXLPC_IND_NUMSTAGES] = { 4 };

const short lsf_unified_fit_model_nb[4][16] =
{
    {12506 , -17641 , -6444 , -6646 , -3523 , -2132 , -511 , -92 , 699 , 1062 , 2578 , 3564 , 3200 , -285 , 2928 , -250},
    {20383 , 18855 , 8494 , 8062 , 8105 , 6211 , 5068 , 4408 , 3741 , 3458 , 2732 , 3174 , 2412 , 17421 , -21717 , 0},
    {-717 , -617 , -144 , -117 , -229 , -144 , -141 , -98 , -92 , -69 , -51 , -87 , -37 , -3019 , 19864 , 8034},
    {-2424 , 8999 , 5723 , 5629 , 4239 , 3423 , 2507 , 2019 , 1245 , 736 , -907 , -2237 , -2558 , -1979 , -652 , 1657}
};

const short lsf_unified_fit_model_wb[4][16] =
{
    {8323 , -567 , 3402 , 1389 , 1437 , 1820 , 1407 , 1299 , 1292 , 1206 , 1031 , 928 , 898 , 832 , 840 , 681},
    {24635 , 19605 , 9294 , 7407 , 6419 , 5459 , 4966 , 4189 , 3394 , 2964 , 2425 , 2110 , 2140 , 1972 , 1540 , 2252},
    {-867 , -666 , -168 , -114 , -90 , -122 , -129 , -101 , -65 , -56 , -39 , -35 , -40 , -42 , -35 , -56},
    {-2313 , 3035 , 1677 , 2854 , 2334 , 1232 , 1347 , 1034 , 863 , 707 , 886 , 891 , 432 , 357 , 206 , -310}
};

const short lsf_unified_fit_model_wbhb[4][16] =
{
    {5312 , 1967 , 2914 , 1438 , 2595 , 1848 , 1980 , 2021 , 1535 , 1489 , 1651 , 1502 , 1447 , 1311 , 1353 , 1202},
    {28135 , 16053 , 10129 , 7366 , 5898 , 5341 , 3290 , 2780 , 3146 , 2423 , 1613 , 1370 , 1294 , 1635 , 1105 , 1431},
    {-615 , -308 , -147 , -119 , -104 , -105 , -30 , -28 , -50 , -39 , -15 , -14 , -14 , -21 , -19 , -29},
    {1534 , 3569 , 3138 , 4023 , 2105 , 2023 , 2046 , 1264 , 1340 , 1067 , 780 , 547 , 188 , -540 , -722 , -479}
};

/* LPC weights used in SWB TBE */
const float lpc_weights[LPC_SHB_ORDER+1] =
{
    1.0f, 0.975000000f, 0.950625000f, 0.926859375f, 0.903687891f,
    0.881095693f, 0.859068301f, 0.837591593f, 0.816651804f,
    0.796235509f, 0.776329621f
};

/* LSF weighting */
const float Freq_Weight_Com[160] =
{
    0.50000000f, 0.62940955f, 0.75000000f, 0.85355341f, 0.93301272f, 0.98296291f, 1.00000000f, 1.00000000f,
    1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f,
    1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 1.00000000f, 0.97272730f, 0.94690263f, 0.92241377f,
    0.89915967f, 0.87704921f, 0.85600001f, 0.83593750f, 0.81679392f, 0.79850745f, 0.78102189f, 0.76428574f,
    0.74825174f, 0.73287672f, 0.71812081f, 0.70394737f, 0.69032258f, 0.67721522f, 0.66459626f, 0.65243900f,
    0.64071858f, 0.62941176f, 0.61849713f, 0.60795456f, 0.59776539f, 0.58791208f, 0.57837838f, 0.56914896f,
    0.56020945f, 0.55154639f, 0.54314721f, 0.53500003f, 0.52709359f, 0.51941746f, 0.51196170f, 0.50471699f,
    0.49767441f, 0.49082568f, 0.48416290f, 0.47767857f, 0.47136563f, 0.46521738f, 0.45922747f, 0.45338982f,
    0.44769874f, 0.44214877f, 0.43673471f, 0.43145162f, 0.42629483f, 0.42125985f, 0.41634241f, 0.41153845f,
    0.40684411f, 0.40225562f, 0.39776951f, 0.39338234f, 0.38909090f, 0.38489208f, 0.38078293f, 0.37676057f,
    0.37282231f, 0.36896551f, 0.36518770f, 0.36148649f, 0.35785952f, 0.35430464f, 0.35081968f, 0.34740260f,
    0.34405145f, 0.34076434f, 0.33753943f, 0.33437499f, 0.33126935f, 0.32822084f, 0.32522798f, 0.32228917f,
    0.31940299f, 0.31656805f, 0.31378299f, 0.31104651f, 0.30835736f, 0.30571428f, 0.30311614f, 0.30056179f,
    0.29805014f, 0.29558012f, 0.29315069f, 0.29076087f, 0.28840971f, 0.28609625f, 0.28381962f, 0.28157896f,
    0.27937338f, 0.27720207f, 0.27506426f, 0.27295917f, 0.27088606f, 0.26884422f, 0.26683292f, 0.26485148f,
    0.26289925f, 0.26097560f, 0.25907990f, 0.25721154f, 0.25536993f, 0.25355449f, 0.25176471f, 0.25000000f,
    0.24825986f, 0.24654378f, 0.24485126f, 0.24318182f, 0.24153499f, 0.23991032f, 0.23830736f, 0.23672566f,
    0.23516484f, 0.23362446f, 0.23210412f, 0.23060344f, 0.22912206f, 0.22765957f, 0.22621565f, 0.22478992f,
    0.22338204f, 0.22199170f, 0.22061856f, 0.21926230f, 0.21792261f, 0.21659920f, 0.21529175f, 0.21400000f,
    0.21272366f, 0.21146245f, 0.21021610f, 0.20898438f, 0.20776699f, 0.20656371f, 0.20537429f, 0.20419848f
};

const float Freq_Weight_UV[160] =
{
    0.50000000f, 0.62940955f, 0.75000000f, 0.85355341f, 0.93301272f, 0.98296291f, 1.00000000f, 0.99180329f,
    0.98373985f, 0.97580647f, 0.96799999f, 0.96031743f, 0.95275593f, 0.94531250f, 0.93798447f, 0.93076921f,
    0.92366409f, 0.91666669f, 0.90977442f, 0.90298510f, 0.89629632f, 0.88970590f, 0.88321167f, 0.87681162f,
    0.87050360f, 0.86428571f, 0.85815603f, 0.85211265f, 0.84615386f, 0.84027779f, 0.83448273f, 0.82876712f,
    0.82312924f, 0.81756759f, 0.81208056f, 0.80666667f, 0.80132449f, 0.79605263f, 0.79084969f, 0.78571427f,
    0.78064513f, 0.77564102f, 0.77070063f, 0.76582277f, 0.76100630f, 0.75625002f, 0.75155282f, 0.74691355f,
    0.74233127f, 0.73780489f, 0.73333335f, 0.72891569f, 0.72455090f, 0.72023809f, 0.71597636f, 0.71176469f,
    0.70760232f, 0.70348835f, 0.69942194f, 0.69540232f, 0.69142854f, 0.68750000f, 0.68361580f, 0.67977530f,
    0.67597765f, 0.67222220f, 0.66850829f, 0.66483516f, 0.66120219f, 0.65760869f, 0.65405405f, 0.65053761f,
    0.64705884f, 0.64361703f, 0.64021164f, 0.63684213f, 0.63350785f, 0.63020831f, 0.62694299f, 0.62371135f,
    0.62051284f, 0.61734694f, 0.61421317f, 0.61111110f, 0.60804021f, 0.60500002f, 0.60199004f, 0.59900987f,
    0.59605908f, 0.59313726f, 0.59024388f, 0.58737862f, 0.58454108f, 0.58173078f, 0.57894737f, 0.57619047f,
    0.57345974f, 0.57075471f, 0.56807512f, 0.56542057f, 0.56279069f, 0.56018519f, 0.55760366f, 0.55504584f,
    0.55251139f, 0.55000001f, 0.54751134f, 0.54504502f, 0.54260087f, 0.54017860f, 0.53777778f, 0.53539824f,
    0.53303963f, 0.53070176f, 0.52838427f, 0.52608699f, 0.52380955f, 0.52155173f, 0.51931328f, 0.51709402f,
    0.51489359f, 0.51271188f, 0.51054853f, 0.50840336f, 0.50627613f, 0.50416666f, 0.50207472f, 0.50000000f,
    0.49794239f, 0.49590164f, 0.49387756f, 0.49186993f, 0.48987854f, 0.48790324f, 0.48594376f, 0.48400000f,
    0.48207173f, 0.48015872f, 0.47826087f, 0.47637796f, 0.47450981f, 0.47265625f, 0.47081712f, 0.46899223f,
    0.46718147f, 0.46538460f, 0.46360153f, 0.46183205f, 0.46007603f, 0.45833334f, 0.45660377f, 0.45488721f,
    0.45318353f, 0.45149255f, 0.44981414f, 0.44814816f, 0.44649446f, 0.44485295f, 0.44322345f, 0.44160584f
};

/*----------------------------------------------------------------------------------*
 * Speech/music classification
 *----------------------------------------------------------------------------------*/

const float w[HANG_LEN][HANG_LEN] =
{
    {1.0f,    0,       0,       0,      0,      0,       0,      0},
    {0.6f,    0.4f,    0,       0,      0,      0,       0,      0},
    {0.47f,   0.33f,   0.2f,    0,      0,      0,       0,      0},
    {0.4f,    0.3f,    0.2f,    0.1f,   0,      0,       0,      0},
    {0.30f,   0.25f,   0.2f,    0.15f,  0.1f,   0,       0,      0},
    {0.233f,  0.207f,  0.18f,   0.153f, 0.127f, 0.1f,    0,      0},
    {0.235f,  0.205f,  0.174f,  0.143f, 0.112f, 0.081f,  0.05f,  0},
    {0.200f,  0.179f,  0.157f,  0.136f, 0.114f, 0.093f,  0.071f, 0.05f}
};

const float m_speech[N_MIXTURES*N_FEATURES] =
{
    0.287950f,      0.915145f,      0.146341f,      0.215938f,      0.337233f,      0.416424f,      0.464061f,      0.463680f,      0.059083f,      0.853025f,      0.768184f,      0.314352f,
    0.306930f,      0.936427f,      0.255783f,      0.304095f,      0.328435f,      0.264893f,      0.353664f,      0.481807f,      0.050087f,      0.816373f,      0.828952f,      0.335445f,
    0.241923f,      0.953049f,      0.219456f,      0.259538f,      0.436515f,      0.498549f,      0.456902f,      0.490619f,      0.062629f,      0.832243f,      0.845146f,      0.331393f,
    0.424629f,      0.528660f,      0.325986f,      0.502250f,      0.543419f,      0.561620f,      0.591057f,      0.386511f,      0.067280f,      0.903251f,      0.891515f,      0.344377f,
    0.380487f,      0.727792f,      0.209973f,      0.314364f,      0.421881f,      0.398734f,      0.446999f,      0.402498f,      0.105313f,      0.867979f,      0.877883f,      0.317694f,
    0.344962f,      0.658148f,      0.240913f,      0.348251f,      0.433178f,      0.480324f,      0.498983f,      0.419444f,      0.187060f,      0.868077f,      0.855516f,      0.347290f
};

const float invV_speech[N_MIXTURES*N_FEATURES*N_FEATURES] =
{
    -39.495125f,    -14.409725f,    -38.632778f,    -17.688078f,      8.772461f,    -11.402443f,      0.439471f,    -10.340120f,    -48.738274f,      0.349716f,     16.818443f,     32.142887f,
    -14.409725f,   -195.908417f,    -27.029999f,    -27.433266f,    -16.451397f,     -6.243556f,      5.814015f,     12.751663f,    -65.479347f,    -46.738777f,     -8.373536f,     18.300566f,
    -38.632782f,    -27.029999f,   -753.940247f,    115.388985f,    -47.167007f,     27.107189f,    -36.896187f,     72.593445f,   -298.310120f,    -22.776127f,    177.255432f,     89.802238f,
    -17.688076f,    -27.433270f,    115.388954f,   -222.724594f,     40.140877f,    -45.163593f,     21.461746f,      7.970023f,    -27.137230f,     76.520920f,     25.476706f,     38.804222f,
    8.772461f,    -16.451405f,    -47.167007f,     40.140877f,    -94.404678f,     40.199402f,    -17.781452f,      3.901072f,    -14.428046f,     23.148809f,     13.478944f,     17.505091f,
    -11.402439f,     -6.243560f,     27.107193f,    -45.163593f,     40.199394f,    -93.411865f,     57.189003f,      3.581622f,      0.100851f,      5.812640f,      9.256781f,     10.823537f,
    0.439471f,      5.814015f,    -36.896187f,     21.461748f,    -17.781452f,     57.189003f,    -89.808571f,     -5.465971f,    -46.055283f,    -15.567553f,     14.521687f,     10.769546f,
    -10.340121f,     12.751663f,     72.593445f,      7.970019f,      3.901072f,      3.581622f,     -5.465971f,   -100.358055f,     24.768887f,    -20.986031f,    -47.276218f,     13.192144f,
    -48.738274f,    -65.479347f,   -298.310120f,    -27.137238f,    -14.428048f,      0.100851f,    -46.055275f,     24.768887f,  -1377.781250f,    -56.637291f,    233.195129f,   -114.883377f,
    0.349715f,    -46.738777f,    -22.776127f,     76.520912f,     23.148806f,      5.812638f,    -15.567553f,    -20.986031f,    -56.637291f,   -216.730820f,     -0.914011f,     39.627998f,
    16.818443f,     -8.373537f,    177.255432f,     25.476713f,     13.478942f,      9.256781f,     14.521687f,    -47.276218f,    233.195129f,     -0.914013f,   -153.435181f,    -48.048389f,
    32.142887f,     18.300564f,     89.802223f,     38.804218f,     17.505091f,     10.823533f,     10.769546f,     13.192144f,   -114.883377f,     39.628006f,    -48.048389f,   -313.631622f,
    -53.471222f,    -47.464245f,     -0.896915f,    -25.132132f,     30.892912f,    -27.316641f,     22.758862f,    -18.016706f,    -66.564011f,     -3.584184f,     -7.795120f,     35.122147f,
    -47.464249f,   -438.709412f,    -11.227010f,    -14.463504f,     12.490106f,    -11.184597f,      2.622577f,     -3.664124f,    -84.887161f,    -29.377838f,    -53.413090f,     17.047739f,
    -0.896916f,    -11.227015f,   -251.993881f,    153.947250f,      4.508913f,     26.900564f,    -22.145449f,      7.110321f,   -215.903503f,    -47.320839f,     78.247871f,     16.021702f,
    -25.132132f,    -14.463490f,    153.947235f,   -326.623169f,     62.711872f,      7.543400f,     23.738796f,     19.846117f,    -97.089355f,      2.828130f,     75.120659f,     34.945835f,
    30.892912f,     12.490105f,      4.508915f,     62.711872f,   -289.161591f,    178.348740f,    -26.642651f,     11.309997f,    -10.248929f,     16.504482f,     48.839104f,     20.334949f,
    -27.316643f,    -11.184605f,     26.900568f,      7.543384f,    178.348740f,   -267.764130f,     15.141651f,      4.242836f,     -7.640367f,     77.632545f,     -2.166305f,     12.531335f,
    22.758862f,      2.622574f,    -22.145449f,     23.738796f,    -26.642651f,     15.141647f,    -71.479584f,      2.006794f,     -4.579958f,     30.676281f,     15.085149f,      8.568682f,
    -18.016706f,     -3.664128f,      7.110321f,     19.846119f,     11.309998f,      4.242836f,      2.006794f,    -76.086823f,     56.165844f,     -8.384334f,   -103.682259f,      6.086752f,
    -66.564011f,    -84.887161f,   -215.903488f,    -97.089355f,    -10.248927f,     -7.640366f,     -4.579959f,     56.165840f,  -1920.100708f,     -8.861668f,    500.888123f,    -16.967447f,
    -3.584186f,    -29.377846f,    -47.320839f,      2.828135f,     16.504475f,     77.632553f,     30.676281f,     -8.384336f,     -8.861669f,   -181.010406f,    -15.615012f,      8.247152f,
    -7.795123f,    -53.413109f,     78.247864f,     75.120659f,     48.839104f,     -2.166309f,     15.085151f,   -103.682251f,    500.888123f,    -15.615015f,   -433.988953f,    -70.138153f,
    35.122147f,     17.047737f,     16.021706f,     34.945835f,     20.334948f,     12.531336f,      8.568681f,      6.086751f,    -16.967451f,      8.247154f,    -70.138176f,   -217.081589f,
    -94.138069f,    -64.204018f,      0.309024f,    -46.150829f,     42.051434f,    -41.965660f,     10.197500f,    -19.122877f,    -42.942600f,    -19.220772f,    -21.222412f,     46.903416f,
    -64.204025f,   -818.921143f,     30.093992f,    -42.236637f,      6.486305f,     -4.382217f,     10.975861f,      0.330433f,    -16.922922f,    -58.340889f,   -111.845398f,     -1.666081f,
    0.309030f,     30.093992f,   -342.960907f,    202.719925f,    -66.503586f,     59.412266f,    -81.710594f,     14.449543f,   -155.271118f,     13.000940f,    119.772522f,     37.219341f,
    -46.150829f,    -42.236637f,    202.719910f,   -315.177094f,     74.731415f,    -97.374359f,     58.435394f,     19.693314f,    -62.044556f,      6.968471f,     74.460442f,     22.385506f,
    42.051434f,      6.486304f,    -66.503578f,     74.731415f,    -93.988602f,     52.841560f,    -21.181007f,      2.344793f,    -35.600548f,    -19.262661f,     37.872654f,      6.642675f,
    -41.965660f,     -4.382209f,     59.412254f,    -97.374352f,     52.841560f,   -278.285614f,    214.990295f,     -0.626728f,    -43.822613f,    -21.303955f,     15.663709f,      3.870531f,
    10.197496f,     10.975868f,    -81.710587f,     58.435387f,    -21.181000f,    214.990295f,   -234.196167f,      1.970801f,    -16.810629f,     -1.859668f,     16.002600f,      3.998644f,
    -19.122877f,      0.330433f,     14.449545f,     19.693314f,      2.344791f,     -0.626729f,      1.970801f,    -57.165413f,     20.255400f,     -9.028506f,    -83.099960f,      8.659401f,
    -42.942604f,    -16.922922f,   -155.271103f,    -62.044556f,    -35.600552f,    -43.822613f,    -16.810629f,     20.255400f,   -986.222534f,     27.520060f,    397.979370f,    -10.706357f,
    -19.220772f,    -58.340889f,     13.000940f,      6.968470f,    -19.262661f,    -21.303955f,     -1.859668f,     -9.028505f,     27.520063f,   -181.756256f,    -31.725298f,      5.532037f,
    -21.222410f,   -111.845398f,    119.772507f,     74.460449f,     37.872654f,     15.663704f,     16.002598f,    -83.099960f,    397.979370f,    -31.725298f,   -499.032318f,    -64.723236f,
    46.903416f,     -1.666086f,     37.219345f,     22.385508f,      6.642675f,      3.870531f,      3.998645f,      8.659404f,    -10.706349f,      5.532042f,    -64.723228f,   -245.227646f,
    -20.650835f,      1.359996f,     -2.309748f,      3.667799f,     -4.431922f,     -1.491803f,      2.244124f,     -6.511281f,     -7.420423f,     -2.656161f,     -5.103209f,      2.977657f,
    1.359996f,    -45.519173f,    -27.833733f,     11.524545f,     -5.826983f,      8.198447f,     -4.084381f,     13.450377f,     18.150373f,     -9.569582f,     -6.539153f,     -3.438999f,
    -2.309748f,    -27.833733f,    -75.630455f,     54.383217f,    -10.366678f,     10.230091f,     -6.134814f,      5.390231f,    -18.911335f,      8.611535f,     -4.468428f,      2.542004f,
    3.667800f,     11.524545f,     54.383224f,   -148.724060f,    102.126076f,     -8.536950f,     14.920280f,     -2.707708f,     16.232759f,    -12.092183f,     -2.761442f,      5.324492f,
    -4.431922f,     -5.826983f,    -10.366676f,    102.126083f,   -239.405472f,    114.426819f,     -4.901945f,      3.331610f,     -2.787818f,    -19.461893f,      9.501407f,      1.843912f,
    -1.491803f,      8.198447f,     10.230090f,     -8.536962f,    114.426842f,   -252.874207f,    133.055328f,     -2.890811f,     -8.063058f,    -19.651783f,     -6.576759f,     -6.167914f,
    2.244124f,     -4.084381f,     -6.134819f,     14.920280f,     -4.901949f,    133.055328f,   -188.368149f,      0.868558f,     -5.905251f,    -73.150818f,     15.489239f,      3.931309f,
    -6.511280f,     13.450379f,      5.390231f,     -2.707708f,      3.331610f,     -2.890812f,      0.868557f,   -291.328827f,      8.357405f,      5.690188f,    -65.318748f,     -3.008168f,
    -7.420423f,     18.150373f,    -18.911335f,     16.232759f,     -2.787818f,     -8.063062f,     -5.905251f,      8.357409f,   -817.866455f,    -35.719170f,    465.940338f,    -57.209427f,
    -2.656161f,     -9.569582f,      8.611535f,    -12.092187f,    -19.461897f,    -19.651789f,    -73.150826f,      5.690184f,    -35.719170f,   -273.267426f,     28.788002f,     35.708652f,
    -5.103208f,     -6.539154f,     -4.468427f,     -2.761442f,      9.501406f,     -6.576763f,     15.489231f,    -65.318748f,    465.940338f,     28.788004f,   -993.901489f,    -74.051056f,
    2.977657f,     -3.439001f,      2.542004f,      5.324495f,      1.843912f,     -6.167918f,      3.931307f,     -3.008166f,    -57.209423f,     35.708649f,    -74.051048f,   -188.919189f,
    -29.690845f,     -6.602296f,     -5.942207f,     -8.191399f,     12.539626f,    -17.187153f,      8.095049f,    -11.539900f,     -3.959312f,     -2.929833f,    -13.009781f,     14.593680f,
    -6.602297f,    -27.784903f,    -12.036678f,     -8.735461f,     10.268900f,     -8.173005f,     -0.508073f,      2.189236f,     -3.210277f,    -19.652676f,      0.174784f,     12.064508f,
    -5.942207f,    -12.036678f,   -176.179718f,     87.371017f,    -19.441795f,      2.946336f,    -40.577980f,      4.105769f,    -30.427385f,    -23.225182f,     84.964821f,     43.734604f,
    -8.191399f,     -8.735461f,     87.371017f,   -143.001602f,     51.919571f,    -27.973251f,     29.284573f,     -2.447426f,    -11.954906f,     27.745192f,     11.595254f,      0.393728f,
    12.539626f,     10.268898f,    -19.441788f,     51.919567f,   -178.068130f,    128.031281f,     -3.544543f,      6.851246f,    -10.772905f,    -42.477104f,     34.736156f,     40.172005f,
    -17.187153f,     -8.173005f,      2.946335f,    -27.973251f,    128.031281f,   -165.563629f,     51.259937f,     -4.838826f,      3.758103f,     40.516190f,     -7.739178f,    -19.154724f,
    8.095048f,     -0.508073f,    -40.577976f,     29.284571f,     -3.544538f,     51.259933f,   -108.403847f,     -0.894440f,      3.337809f,      2.241667f,      3.315053f,      1.456518f,
    -11.539901f,      2.189236f,      4.105764f,     -2.447426f,      6.851246f,     -4.838827f,     -0.894440f,   -214.332535f,     -4.848935f,     -3.779825f,    -75.247871f,     -1.171161f,
    -3.959312f,     -3.210277f,    -30.427393f,    -11.954905f,    -10.772905f,      3.758103f,      3.337807f,     -4.848933f,   -266.199005f,      2.878902f,    180.030838f,    -44.094963f,
    -2.929832f,    -19.652674f,    -23.225182f,     27.745188f,    -42.477104f,     40.516193f,      2.241667f,     -3.779825f,      2.878902f,   -156.775406f,    -11.596662f,      4.385890f,
    -13.009781f,      0.174784f,     84.964828f,     11.595254f,     34.736156f,     -7.739182f,      3.315054f,    -75.247871f,    180.030838f,    -11.596662f,   -489.502777f,    -57.779266f,
    14.593680f,     12.064507f,     43.734604f,      0.393729f,     40.172005f,    -19.154715f,      1.456519f,     -1.171165f,    -44.094959f,      4.385883f,    -57.779274f,   -250.653564f,
    -23.921967f,     -5.683947f,     -2.099401f,      0.128250f,      5.166994f,    -10.038282f,      6.450608f,     -0.731379f,     -2.247439f,     -4.157187f,      6.583568f,      4.081524f,
    -5.683947f,    -30.142115f,     -8.658390f,    -12.576810f,     -1.309613f,      1.993960f,     -4.383123f,      6.826682f,     -0.827366f,    -21.146013f,      3.620328f,     11.092305f,
    -2.099401f,     -8.658390f,   -121.018547f,     88.485786f,    -27.739552f,     24.281445f,    -27.560604f,      3.724861f,      6.288231f,    -12.520897f,      2.671664f,     12.669825f,
    0.128251f,    -12.576811f,     88.485771f,   -144.032974f,     84.679276f,    -37.420727f,     25.546324f,      1.023258f,     -7.474452f,     16.698721f,      8.763003f,      1.241009f,
    5.166994f,     -1.309613f,    -27.739553f,     84.679291f,   -144.411407f,     72.554382f,    -14.219510f,      2.006990f,     17.638592f,      1.209377f,     -4.082684f,     14.381269f,
    -10.038282f,      1.993960f,     24.281441f,    -37.420734f,     72.554382f,   -164.510483f,    115.127594f,     -0.853720f,    -16.850563f,      0.659630f,     12.865159f,    -12.793469f,
    6.450607f,     -4.383123f,    -27.560604f,     25.546320f,    -14.219501f,    115.127594f,   -144.301163f,    -12.984586f,      2.706392f,     -4.143620f,     -4.696592f,      1.570192f,
    -0.731379f,      6.826682f,      3.724859f,      1.023259f,      2.006988f,     -0.853720f,    -12.984586f,    -75.763382f,    -31.576742f,     -4.753652f,      9.548754f,     -6.625205f,
    -2.247438f,     -0.827366f,      6.288230f,     -7.474454f,     17.638592f,    -16.850563f,      2.706394f,    -31.576742f,    -68.203148f,     11.220890f,     20.883671f,    -23.079214f,
    -4.157187f,    -21.146011f,    -12.520897f,     16.698721f,      1.209376f,      0.659629f,     -4.143620f,     -4.753652f,     11.220889f,   -148.282272f,     -2.460779f,     12.595567f,
    6.583566f,      3.620328f,      2.671665f,      8.763003f,     -4.082685f,     12.865157f,     -4.696593f,      9.548755f,     20.883675f,     -2.460779f,    -59.110310f,     -3.725027f,
    4.081524f,     11.092305f,     12.669825f,      1.241007f,     14.381269f,    -12.793469f,      1.570194f,     -6.625203f,    -23.079216f,     12.595569f,     -3.725027f,    -62.429104f
};

const float lvm_speech[N_MIXTURES] =
{
    31.996607f,     32.762783f,     32.964325f,     31.979258f,     30.885334f,     26.185850f
};

const float m_music[N_MIXTURES*N_FEATURES] =
{
    0.451772f,      0.776554f,      0.271046f,      0.354725f,      0.395602f,      0.413925f,      0.451482f,      0.627645f,      0.031510f,      0.835348f,      0.725457f,      0.357440f,
    0.487510f,      0.629043f,      0.236111f,      0.388441f,      0.440188f,      0.465005f,      0.494082f,      0.465069f,      0.069486f,      0.918461f,      0.858141f,      0.351628f,
    0.538064f,      0.605061f,      0.283209f,      0.430647f,      0.474700f,      0.497116f,      0.519075f,      0.527071f,      0.034547f,      0.951717f,      0.846345f,      0.380536f,
    0.484100f,      0.744331f,      0.238170f,      0.341071f,      0.358081f,      0.365782f,      0.392370f,      0.702362f,      0.021764f,      0.879612f,      0.725783f,      0.420504f,
    0.305845f,      0.692470f,      0.378321f,      0.465361f,      0.486968f,      0.499951f,      0.520584f,      0.473288f,      0.125325f,      0.726521f,      0.692794f,      0.374433f,
    0.513981f,      0.696380f,      0.246046f,      0.343276f,      0.374858f,      0.396051f,      0.418772f,      0.646286f,      0.026468f,      0.930184f,      0.778228f,      0.369588f
};

const float invV_music[N_MIXTURES*N_FEATURES*N_FEATURES] =
{
    -7.693553f,     -0.657163f,     -1.988950f,     -0.864460f,     -0.230076f,     -0.650926f,      0.731884f,     -1.685300f,    -19.945335f,     -0.839110f,      2.405366f,      3.916922f,
    -0.657164f,    -30.621262f,     -1.553432f,     -2.976453f,     -1.828387f,      1.246830f,     -3.716787f,      8.629019f,      5.424546f,     -1.983033f,    -10.816823f,     -7.156825f,
    -1.988950f,     -1.553432f,    -64.019180f,     41.928944f,    -11.140388f,     11.880524f,      0.733497f,      8.586295f,     23.512827f,    -15.433292f,     -2.485986f,     -2.458197f,
    -0.864460f,     -2.976454f,     41.928940f,    -86.408936f,     41.949852f,    -12.773962f,      4.663799f,     14.073083f,     23.178215f,     -5.600554f,     14.946990f,     14.853354f,
    -0.230076f,     -1.828387f,    -11.140390f,     41.949852f,    -88.611122f,     37.060493f,     -1.752939f,      3.927101f,    -34.439037f,     12.153290f,     13.335299f,     16.994671f,
    -0.650926f,      1.246830f,     11.880524f,    -12.773962f,     37.060493f,    -84.266197f,     37.053310f,      3.348819f,     -5.522115f,      5.531706f,      8.455176f,     -0.010933f,
    0.731884f,     -3.716787f,      0.733498f,      4.663802f,     -1.752939f,     37.053310f,    -76.037888f,     -8.315558f,    -72.524521f,     21.789789f,      3.751793f,      0.630349f,
    -1.685300f,      8.629018f,      8.586294f,     14.073083f,      3.927101f,      3.348819f,     -8.315558f,    -57.921276f,   -118.393280f,      1.583935f,     -8.300871f,      4.850578f,
    -19.945335f,      5.424546f,     23.512829f,     23.178215f,    -34.439041f,     -5.522115f,    -72.524521f,   -118.393280f,  -5404.569336f,    171.743378f,    241.973938f,   -289.196930f,
    -0.839109f,     -1.983034f,    -15.433292f,     -5.600554f,     12.153290f,      5.531708f,     21.789789f,      1.583935f,    171.743362f,   -101.897446f,     -1.140457f,     31.464947f,
    2.405366f,    -10.816823f,     -2.485986f,     14.946990f,     13.335299f,      8.455174f,      3.751793f,     -8.300871f,    241.973923f,     -1.140458f,    -77.658661f,    -44.502563f,
    3.916922f,     -7.156825f,     -2.458197f,     14.853354f,     16.994675f,     -0.010933f,      0.630349f,      4.850579f,   -289.196899f,     31.464947f,    -44.502563f,   -243.168915f,
    -9.878029f,      0.598697f,     -4.302856f,     -0.393763f,      0.713794f,      0.876955f,      0.341871f,     -1.948222f,     -8.764623f,     -0.165505f,     -1.265450f,      1.204445f,
    0.598697f,    -29.943895f,    -12.133356f,     -1.089194f,     -1.817891f,      2.837961f,     -2.426654f,     12.585359f,     -8.634910f,    -11.784335f,      4.719538f,      2.997951f,
    -4.302856f,    -12.133356f,    -84.521080f,     48.461727f,    -11.249048f,     15.025650f,    -19.584152f,     20.383547f,    -13.363368f,     27.676975f,     22.609833f,     -0.788566f,
    -0.393763f,     -1.089193f,     48.461727f,   -128.134705f,     79.103844f,      1.020304f,      3.012457f,      7.957530f,    -11.608212f,     -3.021832f,     42.826736f,     14.192619f,
    0.713794f,     -1.817891f,    -11.249048f,     79.103836f,   -220.859680f,    112.957855f,      8.839993f,     -6.276199f,    -19.145348f,    -19.927418f,      7.305478f,      5.922347f,
    0.876955f,      2.837961f,     15.025646f,      1.020303f,    112.957878f,   -275.141998f,    147.030670f,     -5.400043f,      0.264864f,     -5.583443f,      1.633528f,      7.493776f,
    0.341871f,     -2.426655f,    -19.584156f,      3.012456f,      8.839993f,    147.030670f,   -196.030136f,    -21.359327f,     -9.146851f,     10.225628f,     -2.139116f,      3.010611f,
    -1.948222f,     12.585359f,     20.383547f,      7.957529f,     -6.276197f,     -5.400044f,    -21.359325f,   -108.690598f,    -28.919056f,    -26.963711f,    -53.457581f,     -9.210483f,
    -8.764623f,     -8.634909f,    -13.363366f,    -11.608211f,    -19.145348f,      0.264862f,     -9.146851f,    -28.919056f,   -602.275146f,     73.117203f,    185.012711f,    -77.751747f,
    -0.165505f,    -11.784335f,     27.676975f,     -3.021834f,    -19.927414f,     -5.583444f,     10.225626f,    -26.963711f,     73.117210f,   -350.919952f,    -12.616115f,     28.914690f,
    -1.265450f,      4.719537f,     22.609833f,     42.826729f,      7.305476f,      1.633531f,     -2.139116f,    -53.457581f,    185.012711f,    -12.616107f,   -398.114899f,    -16.563597f,
    1.204445f,      2.997951f,     -0.788567f,     14.192617f,      5.922347f,      7.493775f,      3.010611f,     -9.210481f,    -77.751747f,     28.914690f,    -16.563597f,   -176.464386f,
    -12.120523f,      5.409175f,     -1.857854f,      0.089656f,      2.747151f,      0.330849f,     -0.110976f,     -1.052840f,    -23.532089f,     -2.869304f,     -1.769891f,      0.390127f,
    5.409175f,    -35.374779f,     -7.060057f,     -0.748528f,     -2.384489f,      2.017226f,     -2.828100f,      8.307317f,     16.044216f,    -11.155272f,    -11.784020f,     -0.186719f,
    -1.857854f,     -7.060059f,   -112.721130f,     43.297070f,     11.361997f,     13.618838f,     -3.489388f,     22.195547f,    -71.385941f,    116.419769f,     68.520813f,      4.576182f,
    0.089655f,     -0.748527f,     43.297066f,   -183.503693f,     79.711113f,     24.255428f,     12.465648f,      1.436299f,    -42.306995f,    -23.502007f,     43.622116f,      3.459679f,
    2.747151f,     -2.384489f,     11.361995f,     79.711113f,   -288.300781f,    101.748329f,     51.744507f,     -3.170304f,   -142.892792f,    -76.845322f,     33.559555f,     -2.748073f,
    0.330848f,      2.017227f,     13.618836f,     24.255434f,    101.748344f,   -339.510773f,    165.319336f,     -4.353420f,   -124.114395f,    -92.283844f,     41.981186f,      5.566007f,
    -0.110976f,     -2.828100f,     -3.489391f,     12.465652f,     51.744499f,    165.319336f,   -302.816223f,    -18.169355f,    -26.544678f,    -18.664721f,     -2.650121f,      0.010451f,
    -1.052840f,      8.307317f,     22.195547f,      1.436298f,     -3.170304f,     -4.353420f,    -18.169355f,    -67.658730f,     39.626808f,    -46.781792f,   -132.578033f,     -6.489147f,
    -23.532089f,     16.044214f,    -71.385941f,    -42.306988f,   -142.892792f,   -124.114395f,    -26.544678f,     39.626808f,  -8048.467285f,    -69.854523f,   1809.758301f,   -171.409134f,
    -2.869304f,    -11.155272f,    116.419769f,    -23.502005f,    -76.845306f,    -92.283836f,    -18.664721f,    -46.781792f,    -69.854530f,  -1329.704834f,    -35.750607f,     26.050083f,
    -1.769890f,    -11.784019f,     68.520813f,     43.622116f,     33.559555f,     41.981186f,     -2.650122f,   -132.578033f,   1809.758423f,    -35.750607f,  -1306.246704f,    -81.942009f,
    0.390127f,     -0.186719f,      4.576182f,      3.459679f,     -2.748072f,      5.566006f,      0.010449f,     -6.489147f,   -171.409149f,     26.050083f,    -81.942001f,   -218.411270f,
    -8.602416f,      3.247867f,     -1.244849f,     -1.473311f,      1.389639f,      1.193549f,     -0.749351f,     -3.831526f,    -63.977875f,     -5.851153f,      9.731353f,      3.762766f,
    3.247867f,    -31.158295f,     -1.860033f,      4.017265f,     -4.594161f,      1.111136f,     -0.570251f,     10.457798f,    101.742371f,      5.974397f,    -29.646946f,     -5.117320f,
    -1.244849f,     -1.860033f,   -180.090790f,     66.379784f,    -17.006353f,     31.490606f,     -6.954518f,     15.675142f,     -2.924051f,    -51.747025f,     22.995018f,     27.119001f,
    -1.473310f,      4.017266f,     66.379791f,   -156.629517f,     84.327309f,     -8.737753f,     13.449555f,      8.031604f,      3.398430f,      2.564645f,     23.766497f,      1.825905f,
    1.389639f,     -4.594161f,    -17.006353f,     84.327293f,   -194.113434f,     66.407173f,      7.188343f,     13.696414f,     10.890992f,     22.594927f,     12.302410f,      9.738532f,
    1.193549f,      1.111136f,     31.490606f,     -8.737754f,     66.407173f,   -162.236801f,     56.553402f,     17.216257f,    115.981384f,     38.547184f,      1.763872f,      7.097052f,
    -0.749351f,     -0.570251f,     -6.954517f,     13.449550f,      7.188342f,     56.553402f,   -120.315659f,      2.011221f,     46.796513f,     58.099625f,     10.238644f,     -4.947532f,
    -3.831526f,     10.457799f,     15.675138f,      8.031604f,     13.696414f,     17.216261f,      2.011219f,    -88.214516f,   -358.424683f,    -29.549349f,    -19.958910f,     -2.982261f,
    -63.977875f,    101.742371f,     -2.924051f,      3.398430f,     10.890991f,    115.981384f,     46.796513f,   -358.424683f, -16459.796875f,   -177.281921f,    882.743164f,    -92.799385f,
    -5.851152f,      5.974398f,    -51.747017f,      2.564646f,     22.594927f,     38.547184f,     58.099625f,    -29.549349f,   -177.281921f,   -313.395386f,    -11.227232f,     55.211266f,
    9.731353f,    -29.646946f,     22.995022f,     23.766500f,     12.302408f,      1.763873f,     10.238644f,    -19.958918f,    882.743225f,    -11.227232f,   -192.809204f,    -15.728045f,
    3.762767f,     -5.117321f,     27.118999f,      1.825905f,      9.738532f,      7.097054f,     -4.947530f,     -2.982259f,    -92.799385f,     55.211269f,    -15.728045f,   -105.412018f,
    -14.256830f,     -2.369603f,     -4.383267f,      2.198855f,      0.019220f,     -0.679427f,     -2.574428f,      5.400897f,      1.071412f,      0.106907f,      1.327079f,      2.677950f,
    -2.369603f,    -22.438606f,      1.295039f,     -4.309244f,     -6.401002f,      0.194309f,     -2.196638f,     15.858343f,      6.752327f,     -6.119870f,      1.303229f,     -0.311533f,
    -4.383267f,      1.295039f,    -37.935478f,     39.653362f,    -15.988548f,     -0.134974f,      6.192506f,      2.302801f,     -5.721854f,      1.463135f,     -1.312438f,     -3.824724f,
    2.198855f,     -4.309245f,     39.653366f,    -92.374901f,     67.554337f,     -3.709706f,    -16.418154f,     -5.289310f,    -10.926604f,     -3.034606f,      2.011261f,     -3.425366f,
    0.019220f,     -6.401002f,    -15.988548f,     67.554329f,   -118.435379f,     53.987152f,      0.083914f,      3.628703f,     11.506127f,     -9.430386f,      3.335730f,      0.535830f,
    -0.679426f,      0.194309f,     -0.134974f,     -3.709705f,     53.987152f,   -103.065208f,     60.766655f,      5.174506f,      3.534084f,      1.888132f,     -2.451842f,      0.595043f,
    -2.574428f,     -2.196638f,      6.192506f,    -16.418154f,      0.083914f,     60.766647f,    -77.825020f,     -7.066206f,     -9.501147f,     -2.838846f,      2.729818f,      0.055436f,
    5.400897f,     15.858343f,      2.302801f,     -5.289312f,      3.628702f,      5.174504f,     -7.066205f,    -51.364357f,    -39.811016f,     -5.072917f,      2.924570f,     10.896112f,
    1.071412f,      6.752328f,     -5.721853f,    -10.926604f,     11.506124f,      3.534082f,     -9.501149f,    -39.811012f,    -93.637161f,     18.029125f,      2.729363f,    -18.075464f,
    0.106908f,     -6.119870f,      1.463135f,     -3.034606f,     -9.430385f,      1.888131f,     -2.838846f,     -5.072917f,     18.029125f,    -28.455194f,      2.956357f,     16.863293f,
    1.327079f,      1.303229f,     -1.312438f,      2.011261f,      3.335730f,     -2.451841f,      2.729818f,      2.924570f,      2.729363f,      2.956357f,    -10.622586f,     -6.668186f,
    2.677950f,     -0.311532f,     -3.824724f,     -3.425365f,      0.535831f,      0.595042f,      0.055436f,     10.896112f,    -18.075462f,     16.863293f,     -6.668186f,    -47.191391f,
    -9.240052f,      2.899430f,     -1.061725f,     -1.878852f,      1.384787f,     -0.341924f,      0.387138f,     -3.050452f,    -34.497913f,      0.665648f,      3.172123f,      5.710633f,
    2.899430f,    -28.464540f,     -2.599636f,      2.343385f,     -2.987666f,      2.706673f,      0.826991f,      8.178236f,     58.632381f,     -6.619084f,    -22.678297f,     -7.513733f,
    -1.061725f,     -2.599636f,   -168.556702f,     81.834229f,      2.535699f,     32.237877f,      3.761089f,     12.106804f,     80.076279f,    -79.117699f,     15.459833f,     34.635460f,
    -1.878852f,      2.343384f,     81.834229f,   -199.355972f,     64.456390f,      2.859692f,     17.605833f,     14.360981f,      8.356211f,     15.654006f,     43.245403f,     35.328991f,
    1.384787f,     -2.987666f,      2.535698f,     64.456375f,   -197.841049f,     46.107910f,     19.035957f,     10.296391f,     -4.554988f,     45.390419f,     10.640046f,     17.738880f,
    -0.341924f,      2.706673f,     32.237885f,      2.859688f,     46.107910f,   -193.370590f,     74.545746f,     13.889868f,    120.411064f,     69.282364f,      1.826012f,      8.071488f,
    0.387138f,      0.826990f,      3.761087f,     17.605829f,     19.035957f,     74.545746f,   -173.431549f,     -5.219500f,     77.031425f,    112.113403f,     -0.166995f,      3.456159f,
    -3.050452f,      8.178238f,     12.106802f,     14.360980f,     10.296390f,     13.889872f,     -5.219500f,    -66.011856f,   -245.560532f,    -53.745152f,    -21.376526f,      7.093097f,
    -34.497917f,     58.632385f,     80.076279f,      8.356211f,     -4.554988f,    120.411072f,     77.031425f,   -245.560532f, -12485.017578f,   -211.927429f,    791.254944f,   -708.115784f,
    0.665648f,     -6.619084f,    -79.117699f,     15.654002f,     45.390419f,     69.282356f,    112.113403f,    -53.745152f,   -211.927429f,   -775.154602f,     -7.915978f,     73.130432f,
    3.172123f,    -22.678297f,     15.459837f,     43.245403f,     10.640046f,      1.826011f,     -0.166995f,    -21.376526f,    791.254944f,     -7.915982f,   -312.138367f,    -76.008308f,
    5.710633f,     -7.513731f,     34.635460f,     35.328983f,     17.738880f,      8.071489f,      3.456159f,      7.093094f,   -708.115784f,     73.130432f,    -76.008293f,   -469.943726f
};

const float lvm_music[N_MIXTURES] =
{
    27.932661f,     30.347250f,     34.528702f,     31.239647f,     20.447638f,     33.589111f
};

const float m_noise[N_MIXTURES*N_FEATURES] =
{
    0.452427f,      0.570086f,      0.242006f,      0.342721f,      0.403700f,      0.415107f,      0.444218f,      0.438761f,      0.034564f,      0.893050f,      0.819168f,      0.404974f,
    0.436768f,      0.457530f,      0.286204f,      0.393398f,      0.429530f,      0.444983f,      0.474495f,      0.377982f,      0.032033f,      0.980933f,      0.864315f,      0.377762f,
    0.554771f,      0.507113f,      0.244596f,      0.401393f,      0.425160f,      0.441338f,      0.467793f,      0.361573f,      0.031537f,      0.971703f,      0.866892f,      0.372985f,
    0.482864f,      0.545745f,      0.098616f,      0.246756f,      0.304649f,      0.303124f,      0.352083f,      0.363268f,      0.031057f,      0.901759f,      0.838419f,      0.339094f,
    0.421798f,      0.491610f,      0.266544f,      0.367277f,      0.407442f,      0.415130f,      0.458496f,      0.395402f,      0.035484f,      0.951506f,      0.861898f,      0.362091f,
    0.422524f,      0.475384f,      0.321804f,      0.436169f,      0.468526f,      0.481682f,      0.505572f,      0.389095f,      0.048487f,      0.967269f,      0.878799f,      0.409561f
};

const float invV_noise[N_MIXTURES*N_FEATURES*N_FEATURES] =
{
    -10.867715f,     -0.756548f,     -0.787901f,      4.638586f,     -4.208551f,     -1.593690f,      1.654504f,      0.517274f,    -24.544769f,     -2.342500f,      1.593914f,      1.892730f,
    -0.756548f,    -42.676064f,     -5.171525f,    -22.601748f,     -3.989791f,     -1.960918f,      9.223408f,     12.652583f,     16.718012f,     10.374084f,    -17.742804f,    -14.035854f,
    -0.787901f,     -5.171525f,   -115.159836f,     77.010605f,    -22.974529f,     22.149885f,     -7.457938f,     51.154774f,     20.176580f,     -1.104116f,     17.582054f,    -18.231829f,
    4.638585f,    -22.601746f,     77.010605f,   -162.083023f,     69.046974f,     -0.931657f,      9.922201f,      6.555853f,     49.297676f,     18.854517f,     -9.951534f,     16.527628f,
    -4.208551f,     -3.989791f,    -22.974525f,     69.046974f,   -181.796692f,    112.212860f,    -28.314665f,      9.765093f,     17.263042f,    -17.941118f,    -20.316977f,    -12.281874f,
    -1.593690f,     -1.960918f,     22.149881f,     -0.931659f,    112.212860f,   -230.312469f,    120.808189f,     -3.664834f,     21.109715f,      8.984108f,     15.273976f,    -10.366921f,
    1.654504f,      9.223406f,     -7.457942f,      9.922205f,    -28.314672f,    120.808205f,   -152.423096f,     -1.527340f,     -7.447964f,      5.038412f,     13.851591f,    -12.278207f,
    0.517274f,     12.652583f,     51.154770f,      6.555853f,      9.765094f,     -3.664836f,     -1.527341f,   -113.809120f,   -127.203827f,     -2.824038f,    -50.058937f,     -1.399267f,
    -24.544767f,     16.718014f,     20.176580f,     49.297676f,     17.263042f,     21.109715f,     -7.447963f,   -127.203827f,  -6696.807617f,    -22.621326f,    415.747192f,   -168.268478f,
    -2.342500f,     10.374086f,     -1.104114f,     18.854517f,    -17.941120f,      8.984108f,      5.038413f,     -2.824039f,    -22.621326f,   -153.911545f,      9.088697f,     20.155067f,
    1.593914f,    -17.742804f,     17.582056f,     -9.951534f,    -20.316977f,     15.273976f,     13.851592f,    -50.058945f,    415.747162f,      9.088697f,   -180.485260f,     -2.179248f,
    1.892730f,    -14.035856f,    -18.231823f,     16.527628f,    -12.281875f,    -10.366921f,    -12.278206f,     -1.399268f,   -168.268478f,     20.155067f,     -2.179248f,    -92.283646f,
    -23.031761f,     -1.252800f,      2.168407f,      5.677273f,     -1.038399f,     -5.394459f,      4.921468f,     -0.398360f,     -7.562253f,     64.160614f,     -4.832063f,      1.192536f,
    -1.252800f,    -99.841995f,     18.003206f,    -17.730101f,     -6.070672f,     16.703362f,     -1.826001f,     24.508341f,     95.143112f,     31.486519f,    -75.776428f,     -4.459583f,
    2.168407f,     18.003206f,   -298.278900f,    136.582794f,     23.557480f,     32.080963f,    -44.544701f,     44.470726f,    121.132362f,    294.113434f,    -22.118645f,      3.540136f,
    5.677273f,    -17.730099f,    136.582779f,   -552.121826f,    236.890076f,     45.754177f,     49.528828f,    -18.333956f,   -155.456558f,    137.723495f,     87.803368f,      9.539282f,
    -1.038398f,     -6.070671f,     23.557480f,    236.890076f,   -779.760498f,    250.522018f,    101.655136f,      9.155396f,    -82.543655f,   -398.953156f,     95.902740f,      4.389515f,
    -5.394459f,     16.703358f,     32.080971f,     45.754185f,    250.522049f,   -825.768005f,    305.349487f,     -6.825818f,     49.064461f,   -530.656738f,    -41.630035f,      0.097057f,
    4.921468f,     -1.825999f,    -44.544685f,     49.528828f,    101.655106f,    305.349457f,   -714.934082f,     14.071314f,     81.227341f,   -137.562592f,     -2.118532f,     -2.266444f,
    -0.398360f,     24.508341f,     44.470741f,    -18.333960f,      9.155393f,     -6.825818f,     14.071318f,   -306.676453f,    267.131439f,    -29.354313f,   -247.414047f,     -3.381219f,
    -7.562254f,     95.143112f,    121.132362f,   -155.456558f,    -82.543648f,     49.064457f,     81.227341f,    267.131439f, -18849.244141f,   -929.838013f,   3582.389648f,    -91.670364f,
    64.160622f,     31.486523f,    294.113434f,    137.723495f,   -398.953186f,   -530.656738f,   -137.562607f,    -29.354321f,   -929.838013f, -15657.494141f,   -160.551666f,    -23.622292f,
    -4.832063f,    -75.776428f,    -22.118641f,     87.803375f,     95.902733f,    -41.630043f,     -2.118535f,   -247.414047f,   3582.389648f,   -160.551666f,  -2443.248535f,   -102.662750f,
    1.192536f,     -4.459581f,      3.540133f,      9.539283f,      4.389517f,      0.097059f,     -2.266439f,     -3.381226f,    -91.670372f,    -23.622292f,   -102.662750f,   -246.260574f,
    -11.285410f,      5.316821f,      1.028375f,      1.780153f,     -1.713055f,     -6.356722f,      3.452291f,     -0.472106f,      5.616539f,     22.361168f,     -4.266212f,      2.444066f,
    5.316821f,    -59.978729f,    -45.510380f,      0.510493f,     -4.121831f,      5.250934f,    -14.358817f,      2.281706f,      4.310630f,      4.492869f,     17.377964f,      5.232576f,
    1.028376f,    -45.510380f,   -192.404053f,     60.491817f,     29.311884f,     10.877782f,    -13.830601f,      4.475446f,     14.358991f,    170.638504f,    103.112320f,      3.708024f,
    1.780153f,      0.510493f,     60.491817f,   -566.125488f,    303.482666f,    -24.292496f,     -8.399674f,     -1.485864f,    -37.162815f,   -301.527344f,     10.013409f,     11.255829f,
    -1.713055f,     -4.121831f,     29.311880f,    303.482666f,   -852.739014f,    287.208618f,      7.622868f,      2.283498f,    -27.422876f,   -496.049957f,     -5.396815f,     -1.631967f,
    -6.356722f,      5.250934f,     10.877782f,    -24.292484f,    287.208618f,   -723.304810f,    301.939606f,    -18.888754f,    -49.648453f,   -140.429428f,     26.881662f,      4.222802f,
    3.452292f,    -14.358817f,    -13.830603f,     -8.399690f,      7.622864f,    301.939575f,   -496.315796f,     24.400175f,    203.557098f,   -224.619278f,    -47.202961f,     -9.425015f,
    -0.472106f,      2.281706f,      4.475447f,     -1.485866f,      2.283498f,    -18.888754f,     24.400175f,   -354.005493f,    136.772644f,   -115.911537f,   -131.393005f,      0.959444f,
    5.616539f,      4.310630f,     14.358991f,    -37.162819f,    -27.422880f,    -49.648449f,    203.557098f,    136.772644f, -20332.845703f,   -321.084869f,   3009.444580f,    -97.580765f,
    22.361168f,      4.492869f,    170.638519f,   -301.527344f,   -496.049957f,   -140.429428f,   -224.619293f,   -115.911537f,   -321.084839f,  -7067.310059f,   -220.679733f,    -46.764927f,
    -4.266212f,     17.377964f,    103.112320f,     10.013409f,     -5.396815f,     26.881662f,    -47.202957f,   -131.393005f,   3009.444336f,   -220.679733f,  -2442.017334f,   -122.001373f,
    2.444066f,      5.232576f,      3.708023f,     11.255831f,     -1.631966f,      4.222802f,     -9.425015f,      0.959446f,    -97.580765f,    -46.764931f,   -122.001373f,   -270.966095f,
    -14.192688f,      3.186916f,     -7.950537f,     12.989626f,      5.455102f,      1.765226f,     -5.165048f,      0.461338f,      7.198293f,    -20.877787f,     -2.402384f,      0.581967f,
    3.186916f,    -44.923344f,    -55.269123f,      8.982286f,     -0.746719f,     13.665676f,      5.123918f,      2.567272f,    -14.412151f,    -21.068356f,      5.512080f,      3.727387f,
    -7.950538f,    -55.269123f,   -874.676270f,    396.753632f,   -241.704224f,     70.721024f,   -240.685715f,     31.769787f,   -186.425156f,    -72.526421f,     58.346741f,     10.030197f,
    12.989626f,      8.982285f,    396.753632f,   -538.253601f,    134.091171f,     33.957142f,     -5.240913f,     40.302223f,     65.792999f,    256.190460f,     41.462269f,     59.464478f,
    5.455101f,     -0.746719f,   -241.704254f,    134.091171f,   -942.252197f,    384.468231f,     36.093376f,      5.026894f,    111.673508f,     64.876976f,    -19.179228f,     18.067732f,
    1.765226f,     13.665678f,     70.721085f,     33.957142f,    384.468231f,   -885.075134f,    358.333008f,     13.728846f,     74.583847f,    277.755707f,     15.872023f,     32.199970f,
    -5.165048f,      5.123920f,   -240.685776f,     -5.240921f,     36.093372f,    358.333008f,   -694.631653f,     22.914997f,     82.867088f,    154.286697f,      2.264358f,     21.074474f,
    0.461338f,      2.567272f,     31.769791f,     40.302223f,      5.026892f,     13.728846f,     22.915001f,   -341.417511f,    -72.276520f,    -87.553932f,    -17.271832f,      7.437448f,
    7.198294f,    -14.412151f,   -186.425171f,     65.792999f,    111.673508f,     74.583847f,     82.867088f,    -72.276520f, -16628.691406f,   -258.116119f,    387.521759f,   -260.230133f,
    -20.877787f,    -21.068354f,    -72.526451f,    256.190460f,     64.876984f,    277.755707f,    154.286697f,    -87.553932f,   -258.116089f,   -851.111816f,      3.469927f,      2.253677f,
    -2.402384f,      5.512080f,     58.346741f,     41.462273f,    -19.179226f,     15.872023f,      2.264359f,    -17.271832f,    387.521759f,      3.469929f,   -327.105011f,    -45.187340f,
    0.581967f,      3.727389f,     10.030209f,     59.464478f,     18.067736f,     32.199970f,     21.074471f,      7.437444f,   -260.230133f,      2.253681f,    -45.187363f,   -348.881165f,
    -20.546539f,     -1.232953f,     -6.539483f,      7.977976f,     -1.242327f,     -4.323449f,      4.044850f,     -8.261212f,    -61.714569f,    -16.814053f,      0.693824f,      2.217177f,
    -1.232953f,    -81.245918f,    -33.514919f,    -26.628014f,      2.160939f,     -0.234839f,     -0.764257f,     21.764839f,    133.689529f,      9.364232f,    -27.287352f,     -6.621866f,
    -6.539483f,    -33.514919f,   -321.563904f,    105.228661f,      0.660729f,    -32.550903f,    -45.134315f,     42.045963f,   -200.154724f,    -42.022831f,    200.115005f,     19.959410f,
    7.977976f,    -26.628016f,    105.228653f,   -362.669098f,    100.723396f,     10.423860f,     45.250904f,     -3.221930f,    -63.687748f,    -41.052856f,     -5.156573f,     12.700191f,
    -1.242327f,      2.160941f,      0.660730f,    100.723396f,   -410.276917f,    189.899841f,      1.538413f,     21.637842f,    -26.361103f,     35.868237f,     46.390850f,     13.527671f,
    -4.323449f,     -0.234840f,    -32.550911f,     10.423860f,    189.899841f,   -359.953278f,    149.268143f,     13.839684f,    104.534042f,     43.236813f,    -23.356220f,     -8.712662f,
    4.044850f,     -0.764257f,    -45.134308f,     45.250904f,      1.538413f,    149.268143f,   -274.089874f,     -8.017480f,     39.217266f,     23.817112f,     13.071558f,      8.212641f,
    -8.261212f,     21.764839f,     42.045967f,     -3.221937f,     21.637842f,     13.839684f,     -8.017480f,   -250.062653f,     77.902710f,     -1.225836f,    -98.802437f,      0.740895f,
    -61.714565f,    133.689514f,   -200.154709f,    -63.687748f,    -26.361105f,    104.534027f,     39.217266f,     77.902695f, -12793.175781f,    257.379974f,   1953.936523f,   -236.987503f,
    -16.814053f,      9.364232f,    -42.022831f,    -41.052856f,     35.868237f,     43.236813f,     23.817108f,     -1.225832f,    257.379974f,  -1194.391846f,   -211.503952f,    -22.654963f,
    0.693823f,    -27.287352f,    200.115005f,     -5.156573f,     46.390850f,    -23.356216f,     13.071561f,    -98.802437f,   1953.936523f,   -211.503983f,  -1273.349854f,    -88.061317f,
    2.217178f,     -6.621865f,     19.959414f,     12.700191f,     13.527678f,     -8.712662f,      8.212641f,      0.740895f,   -236.987518f,    -22.654963f,    -88.061317f,   -364.010010f,
    -23.764925f,     -0.313664f,     -1.392676f,      1.488295f,      1.913436f,     -4.066601f,      6.848008f,     -3.074351f,     -7.675101f,      9.171298f,      3.117799f,      2.142688f,
    -0.313664f,    -88.759735f,     -8.855761f,    -26.637909f,      5.178853f,     10.666278f,      2.244489f,     21.984133f,     16.797499f,      4.685480f,     13.074540f,     -2.708393f,
    -1.392676f,     -8.855759f,   -175.915054f,     83.474174f,     41.251793f,     14.369057f,    -12.605553f,     33.395245f,     65.670242f,     39.710125f,     36.098553f,     -9.562349f,
    1.488295f,    -26.637909f,     83.474182f,   -383.095245f,    216.683212f,     12.198986f,     32.383698f,    -14.022625f,      7.763216f,   -100.727264f,    -28.525242f,     -5.235438f,
    1.913436f,      5.178854f,     41.251801f,    216.683212f,   -586.877808f,    253.507355f,     29.591257f,      7.710151f,    -31.813087f,   -112.656593f,     20.279724f,     -7.102311f,
    -4.066601f,     10.666278f,     14.369057f,     12.198978f,    253.507355f,   -597.128113f,    296.967621f,      6.174671f,    -41.961372f,    -36.203259f,    -20.597570f,    -14.877533f,
    6.848009f,      2.244488f,    -12.605548f,     32.383701f,     29.591269f,    296.967590f,   -456.794678f,     26.321606f,    -34.872383f,     28.424320f,     34.979023f,     -8.548788f,
    -3.074351f,     21.984133f,     33.395245f,    -14.022625f,      7.710150f,      6.174670f,     26.321606f,   -265.545593f,      2.918175f,      0.831582f,   -125.449432f,    -11.139709f,
    -7.675101f,     16.797503f,     65.670242f,      7.763219f,    -31.813070f,    -41.961380f,    -34.872383f,      2.918175f,  -1731.894409f,   -210.794144f,    739.213074f,    -97.542229f,
    9.171299f,      4.685479f,     39.710129f,   -100.727264f,   -112.656593f,    -36.203262f,     28.424320f,      0.831581f,   -210.794113f,  -2326.243652f,   -106.282173f,      1.036536f,
    3.117799f,     13.074540f,     36.098553f,    -28.525242f,     20.279724f,    -20.597570f,     34.979023f,   -125.449432f,    739.213074f,   -106.282112f,  -1878.532593f,   -113.480858f,
    2.142687f,     -2.708396f,     -9.562349f,     -5.235439f,     -7.102309f,    -14.877532f,     -8.548790f,    -11.139709f,    -97.542229f,      1.036536f,   -113.480865f,   -101.406532f
};

const float lvm_noise[N_MIXTURES] =
{
    28.723963f,     41.180500f,     39.296734f,     38.508724f,     37.029205f,     35.496319f
};

const float SF[N_FEATURES*2] =
{
    0.0048f, -0.0952f,
    1.0002f, 0,
    0.6226f, -0.0695f,
    0.5497f, -0.1265f,
    0.4963f, -0.2230f,
    0.5049f, -0.4103f,
    0.5069f, -0.5717f,
    0.0041f, 0,
    0.0022f, -0.0029f,
    0.0630f, 1.0015f,
    0.0684f, 0.9103f,
    0.1159f, -0.2931f
};

const float SF_8k[N_FEATURES*2] =
{
    0.0041f, 0,
    0.8572f, 0.1020f,
    0.6739f, -0.1000f,
    0.6257f, -0.1678f,
    0.5495f, -0.2380f,
    0.5793f, -0.4646f,
    0.2502f, 0,
    0.0041f, 0,
    0.0020f, 0,
    0.0630f, 1.0015f,
    0.0598f, 0.8967f,
    0.0631f, 0
};


/* searching thresholds for quantization of peak gains */
const float thren_pg[44] =
{
    120193.5539509f, 101070.3286539f,
    84989.6770536f, 71467.5147680f,
    60096.7769755f, 50535.1643270f,
    42494.8385268f, 35733.7573840f,
    30048.3884877f, 25267.5821635f,
    19483.9693722f, 13777.2468675f,
    9741.9846861f, 6888.6234338f,
    4870.9923431f, 3444.3117169f,
    2435.4961715f, 1722.1558584f,
    1217.7480858f, 861.0779292f,
    608.8740429f, 430.5389646f,
    304.4370214f, 215.2694823f,
    152.2185107f, 107.6347412f,
    76.1092554f, 53.8173706f,
    38.0546277f, 26.9086853f,
    19.0273138f, 13.4543426f,
    9.5136569f,  6.7271713f,
    4.7568285f,  3.3635857f,
    2.3784142f,  1.6817928f,
    1.1892071f,  0.840896f,
    0.594604f,   0.420448f,
    0.297302f,   0.210224f
};

/* Huffmann coding - searching thresholds for quantization of peak gains */
const short huffnorm_e[32] =
{
    1062, 550, 314, 274, 273, 272, 156,  79,  69,  38,
    18,   40,  5,   3,   0,   1,   3,    4,   11,  21,
    41,   32,  35,  67,  133, 264, 530,  315, 551, 2126, 4254, 4255
};

const short huffnorm_n[32] =
{
    14831, 14830, 7414, 3706, 593, 927, 462, 297, 230, 116,
    50,    36,    13,   8,    5,   1,   0,   2,   6,   7,
    15,    19,    24,   56,   59,  51,  114, 117, 75,  149, 592, 1852
};

const short huffsizn_e[32] =
{
    13, 12, 11, 11, 11, 11, 10, 9,  9,  8,
    7,  6,  5,  4,  3,  2,  2,  3,  4,  5,
    6,  8,  8,  9,  10, 11, 12, 11, 12, 14, 15, 15
};

const short huffsizn_n[32] =
{
    14, 14, 13, 12, 10, 10, 9,  9,  8,  7,
    7,  6,  5,  4,  3,  3,  3,  3,  3,  4,
    4,  5,  6,  6,  6,  7,  7,  7,  7,  8, 10, 11
};

const short resize_huffnorm[32] =
{
    0, 0, 0, 0, 0, 1023, 511, 255, 127, 63, 31, 15, 7, 3, 1, 0,
    2, 5, 11, 23, 47, 95, 191, 383, 767, 2047, 0, 0, 0, 0, 0, 0
};

const short huffnorm[32] =
{
    26, 58, 90, 122, 27, 59, 91, 123, 12, 28, 44,  60,  2,  6,  4,   6,
    0,  2,  10,  14, 14, 30, 46,  62, 30, 62, 94, 126, 31, 63, 95, 127
};

const short pgain_huffnorm[32] =
{
    1, 1, 2, 3, 3, 2, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 4, 5, 3, 2, 3, 3, 4, 5, 0, 1
};

const short hessize[8]=
{
    7, 5, 3, 2, 1, 4, 6, 7
};

const short hescode[8]=
{
    11, 3, 1, 1, 1, 0, 4, 10
};

/*----------------------------------------------------------------------------------*
 * BWD
 *----------------------------------------------------------------------------------*/

const float hann_window_320[BWD_TOTAL_WIDTH/2] =
{
    0.0f,               0.000096984948331f, 0.000387902169007f, 0.000872638803658f,
    0.001551006803657f, 0.002422743003060f, 0.003487509220708f, 0.004744892391413f,
    0.006194404726209f, 0.007835483901579f, 0.009667493277608f, 0.011689722144956f,
    0.013901386000576f, 0.016301626852047f, 0.018889513550430f, 0.021664042151495f,
    0.024624136305188f, 0.027768647673197f, 0.031096356374430f, 0.034605971458262f,
    0.038296131405342f, 0.042165404655783f, 0.046212290164521f, 0.050435217983627f,
    0.054832549871356f, 0.059402579927684f, 0.064143535256096f, 0.069053576651361f,
    0.074130799313035f, 0.079373233584409f, 0.084778845716614f, 0.090345538657597f,
    0.096071152865649f, 0.101953467147178f, 0.107990199518396f, 0.114179008090596f,
    0.120517491978659f, 0.127003192232455f, 0.133633592790768f, 0.140406121457376f,
    0.147318150898908f, 0.154366999664091f, 0.161549933223991f, 0.168864165032848f,
    0.176306857609086f, 0.183875123636085f, 0.191566027082286f, 0.199376584340196f,
    0.207303765383847f, 0.215344494944262f, 0.223495653702478f, 0.231754079499652f,
    0.240116568563785f, 0.248579876752599f, 0.257140720812064f, 0.265795779650105f,
    0.274541695624985f, 0.283375075847868f, 0.292292493499057f, 0.301290489157390f,
    0.310365572142292f, 0.319514221867944f, 0.328732889209064f, 0.338017997877748f,
    0.347365945810858f, 0.356773106567405f, 0.366235830735390f, 0.375750447347553f,
    0.385313265305494f, 0.394920574811589f, 0.404568648808175f, 0.414253744423419f,
    0.423972104423331f, 0.433719958669339f, 0.443493525580883f, 0.453289013602435f,
    0.463102622674396f, 0.472930545707291f, 0.482768970058690f, 0.492614079012283f,
    0.502462053258538f, 0.512309072376361f, 0.522151316315189f, 0.531984966876945f,
    0.541806209197260f, 0.551611233225420f, 0.561396235202429f, 0.571157419136643f,
    0.580890998276382f, 0.590593196578969f, 0.600260250175597f, 0.609888408831494f,
    0.619473937400779f, 0.629013117275481f, 0.638502247828131f, 0.647937647847382f,
    0.657315656966103f, 0.666632637081372f, 0.675884973765851f, 0.685069077669957f,
    0.694181385914321f, 0.703218363471965f, 0.712176504539683f, 0.721052333898081f,
    0.729842408259752f, 0.738543317605065f, 0.747151686505047f, 0.755664175430844f,
    0.764077482049264f, 0.772388342503876f, 0.780593532681191f, 0.788689869461429f,
    0.796674211953372f, 0.804543462712845f, 0.812294568944333f, 0.819924523685287f,
    0.827430366972643f, 0.834809186991105f, 0.842058121202763f, 0.849174357457574f,
    0.856155135084319f, 0.862997745961565f, 0.869699535568266f, 0.876257904013544f,
    0.882670307045301f, 0.888934257037231f, 0.895047323953867f, 0.901007136293294f,
    0.906811382007145f, 0.912457809397536f, 0.917944227990593f, 0.923268509386220f,
    0.928428588083795f, 0.933422462283452f, 0.938248194662667f, 0.942903913127819f,
    0.947387811540448f, 0.951698150417930f, 0.955833257608292f, 0.959791528938907f,
    0.963571428838810f, 0.967171490934417f, 0.970590318618383f, 0.973826585591401f,
    0.976879036376732f, 0.979746486807249f, 0.982427824484824f, 0.984922009211872f,
    0.987228073394887f, 0.989345122419805f, 0.991272334999066f, 0.993008963490220f,
    0.994554334185968f, 0.995907847575523f, 0.997068978577180f, 0.998037276742018f,
    0.998812366428647f, 0.999393946948934f, 0.999781792684653f, 0.999975753175008f
};

/*----------------------------------------------------------------------------------*
 * Starting line for the noise measurement in TCX.
 *----------------------------------------------------------------------------------*/
const int startLineWB[11]  = { 8, 23, 36, 45, 66, 128 /* 13.2kbps */, 200, 320, 320, 320 /* 48kbps */, 320 };
const int startLineSWB[9] = { 8, 44,  96 /* 13.2kbps */, 160, 320, 320, 256 /* 48kbps */, 341, 640 };
