/*
 * Copyright (c) 2015, 2017 The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/types.h>
#include "wcd9335_registers.h"

#define WCD9335_REG(reg)  ((reg) & 0xFF)

const u8 wcd9335_page0_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE0_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_CLK_BYPASS)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_CLK_GATE)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_CLK_MCLK_CFG)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_RST_CTL)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CDC_DIG_HM_CTL)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_1)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_2)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_3)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_IRAM_SHUTDOWN)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DRAM1_SHUTDOWN)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_1)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_2)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_INT_MASK)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_INT_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CODEC_RPM_INT_CLEAR)] = 0,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE0)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE1)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE2)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE3)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_CTL)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_TEST0)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_TEST1)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT0)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT1)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT2)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT3)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT4)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT5)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT6)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT7)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT8)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT9)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT10)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT11)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT12)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT13)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT14)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT15)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_EFUSE_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_1)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_2)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_3)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_I2C_ACTIVE)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC1_MON_CTL)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC1_MON_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_MSB)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_LSB)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC2_MON_CTL)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC2_MON_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_MSB)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_LSB)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC3_MON_CTL)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC3_MON_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_MSB)] = 1,
	[WCD9335_REG(WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_LSB)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX_I2S_CTL)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_TX_I2S_CTL)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_I2S_CLK)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX0_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX1_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX2_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX3_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX4_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX5_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX6_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_RX7_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX0_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX1_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX2_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX3_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX4_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX5_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX6_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX7_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX8_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX9_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX10_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX11_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX13_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX14_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_SB_TX15_INP_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_L_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_R_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_L_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_R_CFG)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_NATIVE_FIFO_SYNC)] = 1,
	[WCD9335_REG(WCD9335_DATA_HUB_NATIVE_FIFO_STATUS)] = 1,
	[WCD9335_REG(WCD9335_INTR_CFG)] = 1,
	[WCD9335_REG(WCD9335_INTR_CLR_COMMIT)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN1_MASK0)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_MASK1)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_MASK2)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_MASK3)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_STATUS0)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_STATUS1)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_STATUS2)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_STATUS3)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN1_CLEAR0)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN1_CLEAR1)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN1_CLEAR2)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN1_CLEAR3)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN2_MASK0)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_MASK1)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_MASK2)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_MASK3)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_STATUS0)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_STATUS1)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_STATUS2)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_STATUS3)] = 1,
	[WCD9335_REG(WCD9335_INTR_PIN2_CLEAR0)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN2_CLEAR1)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN2_CLEAR2)] = 0,
	[WCD9335_REG(WCD9335_INTR_PIN2_CLEAR3)] = 0,
	[WCD9335_REG(WCD9335_INTR_LEVEL0)] = 1,
	[WCD9335_REG(WCD9335_INTR_LEVEL1)] = 1,
	[WCD9335_REG(WCD9335_INTR_LEVEL2)] = 1,
	[WCD9335_REG(WCD9335_INTR_LEVEL3)] = 1,
	[WCD9335_REG(WCD9335_INTR_BYPASS0)] = 1,
	[WCD9335_REG(WCD9335_INTR_BYPASS1)] = 1,
	[WCD9335_REG(WCD9335_INTR_BYPASS2)] = 1,
	[WCD9335_REG(WCD9335_INTR_BYPASS3)] = 1,
	[WCD9335_REG(WCD9335_INTR_SET0)] = 1,
	[WCD9335_REG(WCD9335_INTR_SET1)] = 1,
	[WCD9335_REG(WCD9335_INTR_SET2)] = 1,
	[WCD9335_REG(WCD9335_INTR_SET3)] = 1,
};

const u8 wcd9335_page1_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE1_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_8)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_USER_CTL_9)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_L_VAL_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_L_VAL_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_DSM_FRAC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_DSM_FRAC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_CONFIG_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_CONFIG_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_CONFIG_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_CONFIG_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_CONFIG_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_TEST_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_FREQ_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_FREQ_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_FREQ_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_FREQ_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_SSC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_SSC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_SSC_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_SSC_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_FLL_MODE)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_STATUS_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_STATUS_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_STATUS_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_FLL_STATUS_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_8)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_USER_CTL_9)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_L_VAL_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_L_VAL_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_DSM_FRAC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_DSM_FRAC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_CONFIG_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_CONFIG_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_CONFIG_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_CONFIG_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_CONFIG_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_TEST_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_FREQ_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_FREQ_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_FREQ_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_FREQ_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_SSC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_SSC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_SSC_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_SSC_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_FLL_MODE)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_STATUS_0)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_STATUS_1)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_STATUS_2)] = 1,
	[WCD9335_REG(WCD9335_I2S_FLL_STATUS_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_8)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_USER_CTL_9)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_L_VAL_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_L_VAL_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_DSM_FRAC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_DSM_FRAC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_CONFIG_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_CONFIG_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_CONFIG_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_CONFIG_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_CONFIG_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_TEST_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_FREQ_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_FREQ_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_FREQ_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_FREQ_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_SSC_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_SSC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_SSC_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_SSC_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_FLL_MODE)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_STATUS_0)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_STATUS_1)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_STATUS_2)] = 1,
	[WCD9335_REG(WCD9335_SB_FLL_STATUS_3)] = 1,
};

const u8 wcd9335_page2_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE2_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_PTR_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_PTR_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_PTR_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_CTRL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_5)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_6)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_7)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_8)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_9)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_10)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_11)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_12)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_13)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_14)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MEM_BANK_15)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_TRG)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_TRG)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_0)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_1)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_2)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_3)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_4)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_5)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_6)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_7)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_8)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_9)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_10)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_11)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_12)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_13)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_14)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX1_15)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_5)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_6)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_7)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_8)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_9)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_10)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_11)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_12)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_13)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_14)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_15)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_0)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_1)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_2)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_3)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_4)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_5)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_6)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_7)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_8)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_9)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_10)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_11)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_12)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_13)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_14)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_INBOX2_15)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_0)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_1)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_2)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_3)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_4)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_5)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_6)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_7)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_8)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_9)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_10)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_11)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_12)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_13)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_14)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_15)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX1_ACK)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_OUTBOX2_ACK)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_EC_BUF_INT_PERIOD)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_US_BUF_INT_PERIOD)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_US_EC_MUX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_MAD_CTL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_CPAR_CTL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_TX_PP_BUF_INT_PERIOD)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_TX_PP_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_DMIC0_CTL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_DMIC1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_DMIC2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_DMIC_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_SVA_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_CPAR_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_WDOG_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_BACKUP_INT)] = 0,
	[WCD9335_REG(WCD9335_CPE_SS_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_CPE_OCD_CFG)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_SS_ERROR_INT_MASK)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_SS_ERROR_INT_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CPE_SS_SS_ERROR_INT_CLEAR)] = 0,
	[WCD9335_REG(WCD9335_SOC_MAD_MAIN_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_MAIN_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_CTL_8)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_IIR_CTL_PTR)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_AUDIO_IIR_CTL_VAL)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_ULTR_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_4)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_5)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_6)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_7)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_CTL_8)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_IIR_CTL_PTR)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_BEACON_IIR_CTL_VAL)] = 1,
	[WCD9335_REG(WCD9335_SOC_MAD_INP_SEL)] = 1,
};

const u8 wcd9335_page6_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE6_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_ANA_BIAS)] = 1,
	[WCD9335_REG(WCD9335_ANA_CLK_TOP)] = 1,
	[WCD9335_REG(WCD9335_ANA_RCO)] = 1,
	[WCD9335_REG(WCD9335_ANA_BUCK_VOUT_A)] = 1,
	[WCD9335_REG(WCD9335_ANA_BUCK_VOUT_D)] = 1,
	[WCD9335_REG(WCD9335_ANA_BUCK_CTL)] = 1,
	[WCD9335_REG(WCD9335_ANA_BUCK_STATUS)] = 1,
	[WCD9335_REG(WCD9335_ANA_RX_SUPPLIES)] = 1,
	[WCD9335_REG(WCD9335_ANA_HPH)] = 1,
	[WCD9335_REG(WCD9335_ANA_EAR)] = 1,
	[WCD9335_REG(WCD9335_ANA_LO_1_2)] = 1,
	[WCD9335_REG(WCD9335_ANA_LO_3_4)] = 1,
	[WCD9335_REG(WCD9335_ANA_MAD_SETUP)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC1)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC2)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC3)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC4)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC5)] = 1,
	[WCD9335_REG(WCD9335_ANA_AMIC6)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_MECH)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_ELECT)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_ZDET)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_RESULT_1)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_RESULT_2)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_RESULT_3)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN0)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN1)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN2)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN3)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN4)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN5)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN6)] = 1,
	[WCD9335_REG(WCD9335_ANA_MBHC_BTN7)] = 1,
	[WCD9335_REG(WCD9335_ANA_MICB1)] = 1,
	[WCD9335_REG(WCD9335_ANA_MICB2)] = 1,
	[WCD9335_REG(WCD9335_ANA_MICB2_RAMP)] = 1,
	[WCD9335_REG(WCD9335_ANA_MICB3)] = 1,
	[WCD9335_REG(WCD9335_ANA_MICB4)] = 1,
	[WCD9335_REG(WCD9335_ANA_VBADC)] = 1,
	[WCD9335_REG(WCD9335_BIAS_CTL)] = 1,
	[WCD9335_REG(WCD9335_BIAS_VBG_FINE_ADJ)] = 1,
	[WCD9335_REG(WCD9335_CLOCK_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_RCO_CTRL_1)] = 1,
	[WCD9335_REG(WCD9335_RCO_CTRL_2)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_1)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_2)] = 1,
	[WCD9335_REG(WCD9335_RCO_TEST_CTRL)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_OUT_1)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_OUT_2)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_OUT_3)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_OUT_4)] = 1,
	[WCD9335_REG(WCD9335_RCO_CAL_OUT_5)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_MODE_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_MODE_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_MODE_3)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_MODE_4)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_VCL_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_VCL_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_VCL_3)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_3)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_4)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_5)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_6)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_7)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_8)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_9)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CCL_10)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_FILTER_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_FILTER_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_DRIVER_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_DRIVER_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_DRIVER_3)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CAL_CODE_EXT_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CAL_CODE_EXT_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CAL_CODE_OUT_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_CAL_CODE_OUT_2)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_TEST_1)] = 1,
	[WCD9335_REG(WCD9335_SIDO_SIDO_TEST_2)] = 1,
	[WCD9335_REG(WCD9335_MBHC_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_MBHC_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_MBHC_PLUG_DETECT_CTL)] = 1,
	[WCD9335_REG(WCD9335_MBHC_ZDET_ANA_CTL)] = 1,
	[WCD9335_REG(WCD9335_MBHC_ZDET_RAMP_CTL)] = 1,
	[WCD9335_REG(WCD9335_MBHC_FSM_DEBUG)] = 1,
	[WCD9335_REG(WCD9335_MBHC_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_VBADC_SUBBLOCK_EN)] = 1,
	[WCD9335_REG(WCD9335_VBADC_IBIAS_FE)] = 1,
	[WCD9335_REG(WCD9335_VBADC_BIAS_ADC)] = 1,
	[WCD9335_REG(WCD9335_VBADC_FE_CTRL)] = 1,
	[WCD9335_REG(WCD9335_VBADC_ADC_REF)] = 1,
	[WCD9335_REG(WCD9335_VBADC_ADC_IO)] = 1,
	[WCD9335_REG(WCD9335_VBADC_ADC_SAR)] = 1,
	[WCD9335_REG(WCD9335_VBADC_DEBUG)] = 1,
	[WCD9335_REG(WCD9335_VBADC_ADC_DOUTMSB)] = 1,
	[WCD9335_REG(WCD9335_VBADC_ADC_DOUTLSB)] = 1,
	[WCD9335_REG(WCD9335_LDOH_MODE)] = 1,
	[WCD9335_REG(WCD9335_LDOH_BIAS)] = 1,
	[WCD9335_REG(WCD9335_LDOH_STB_LOADS)] = 1,
	[WCD9335_REG(WCD9335_LDOH_SLOWRAMP)] = 1,
	[WCD9335_REG(WCD9335_MICB1_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_MICB1_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_MICB1_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_MICB2_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_MICB2_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_MICB2_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_MICB3_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_MICB3_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_MICB3_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_MICB4_TEST_CTL_1)] = 1,
	[WCD9335_REG(WCD9335_MICB4_TEST_CTL_2)] = 1,
	[WCD9335_REG(WCD9335_MICB4_TEST_CTL_3)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_ADC_VCM)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_BIAS_ATEST)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_ADC_INT1_IB)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_ADC_INT2_IB)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_TXFE_DIV_CTL)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_TXFE_DIV_START)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_TXFE_DIV_STOP_9P6M)] = 1,
	[WCD9335_REG(WCD9335_TX_COM_TXFE_DIV_STOP_12P288M)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_TEST_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_ADC_IB)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_ATEST_REFCTL)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_TEST_BLK_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_TXFE_CLKDIV)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_SAR1_ERR)] = 1,
	[WCD9335_REG(WCD9335_TX_1_2_SAR2_ERR)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_TEST_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_ADC_IB)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_ATEST_REFCTL)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_TEST_BLK_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_TXFE_CLKDIV)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_SAR1_ERR)] = 1,
	[WCD9335_REG(WCD9335_TX_3_4_SAR2_ERR)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_TEST_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_ADC_IB)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_ATEST_REFCTL)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_TEST_BLK_EN)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_TXFE_CLKDIV)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_SAR1_ERR)] = 1,
	[WCD9335_REG(WCD9335_TX_5_6_SAR2_ERR)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_MODE_1)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_MODE_2)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_MODE_3)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_VCL_1)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_VCL_2)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_CCL_1)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_CCL_2)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_CCL_3)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_CCL_4)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_CTRL_CCL_5)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_BUCK_TMUX_A_D)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_BUCK_SW_DRV_CNTL)] = 1,
	[WCD9335_REG(WCD9335_CLASSH_SPARE)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_EN)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_1)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_2)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_3)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_4)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_5)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_6)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_7)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_8)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_CTRL_9)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_DAC_CTRL_1)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_DAC_CTRL_2)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_DAC_CTRL_3)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_VNEG_DAC_CTRL_4)] = 1,
	[WCD9335_REG(WCD9335_FLYBACK_TEST_CTL)] = 1,
	[WCD9335_REG(WCD9335_RX_AUX_SW_CTL)] = 1,
	[WCD9335_REG(WCD9335_RX_PA_AUX_IN_CONN)] = 1,
	[WCD9335_REG(WCD9335_RX_TIMER_DIV)] = 1,
	[WCD9335_REG(WCD9335_RX_OCP_CTL)] = 1,
	[WCD9335_REG(WCD9335_RX_OCP_COUNT)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_EAR_DAC)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_EAR_AMP)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_LDO)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_PA)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_RDACBUFF_CNP2)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_RDAC_LDO)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_CNP1)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_HPH_LOWPOWER)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_DIFFLO_PA)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_DIFFLO_REF)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_DIFFLO_LDO)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_SELO_DAC_PA)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_BUCK_RST)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_BUCK_VREF_ERRAMP)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_FLYB_ERRAMP)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_FLYB_BUFF)] = 1,
	[WCD9335_REG(WCD9335_RX_BIAS_FLYB_MID_RST)] = 1,
	[WCD9335_REG(WCD9335_HPH_L_STATUS)] = 1,
	[WCD9335_REG(WCD9335_HPH_R_STATUS)] = 1,
	[WCD9335_REG(WCD9335_HPH_CNP_EN)] = 1,
	[WCD9335_REG(WCD9335_HPH_CNP_WG_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_CNP_WG_TIME)] = 1,
	[WCD9335_REG(WCD9335_HPH_OCP_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_AUTO_CHOP)] = 1,
	[WCD9335_REG(WCD9335_HPH_CHOP_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_PA_CTL1)] = 1,
	[WCD9335_REG(WCD9335_HPH_PA_CTL2)] = 1,
	[WCD9335_REG(WCD9335_HPH_L_EN)] = 1,
	[WCD9335_REG(WCD9335_HPH_L_TEST)] = 1,
	[WCD9335_REG(WCD9335_HPH_L_ATEST)] = 1,
	[WCD9335_REG(WCD9335_HPH_R_EN)] = 1,
	[WCD9335_REG(WCD9335_HPH_R_TEST)] = 1,
	[WCD9335_REG(WCD9335_HPH_R_ATEST)] = 1,
	[WCD9335_REG(WCD9335_HPH_RDAC_CLK_CTL1)] = 1,
	[WCD9335_REG(WCD9335_HPH_RDAC_CLK_CTL2)] = 1,
	[WCD9335_REG(WCD9335_HPH_RDAC_LDO_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_RDAC_CHOP_CLK_LP_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_REFBUFF_UHQA_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_REFBUFF_LP_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_L_DAC_CTL)] = 1,
	[WCD9335_REG(WCD9335_HPH_R_DAC_CTL)] = 1,
	[WCD9335_REG(WCD9335_EAR_EN_REG)] = 1,
	[WCD9335_REG(WCD9335_EAR_CMBUFF)] = 1,
	[WCD9335_REG(WCD9335_EAR_ICTL)] = 1,
	[WCD9335_REG(WCD9335_EAR_EN_DBG_CTL)] = 1,
	[WCD9335_REG(WCD9335_EAR_CNP)] = 1,
	[WCD9335_REG(WCD9335_EAR_DAC_CTL_ATEST)] = 1,
	[WCD9335_REG(WCD9335_EAR_STATUS_REG)] = 1,
	[WCD9335_REG(WCD9335_EAR_OUT_SHORT)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_MISC)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_LO2_COMPANDER)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_LO1_COMPANDER)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_COMMON)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_BYPASS_EN)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_CNP)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_CORE_OUT_PROG)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_LDO_OUT_PROG)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_COM_SWCAP_REFBUF_FREQ)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_COM_PA_FREQ)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_RESERVED_REG)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_LO1_STATUS_1)] = 1,
	[WCD9335_REG(WCD9335_DIFF_LO_LO1_STATUS_2)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_COM1)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_COM2)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO3_GAIN)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO3_CTRL)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO4_GAIN)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO4_CTRL)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO3_STATUS)] = 1,
	[WCD9335_REG(WCD9335_SE_LO_LO4_STATUS)] = 1,
};

const u8 wcd9335_page10_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE10_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_CLK_RESET_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_MODE_1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_MODE_2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_FF_SHIFT)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_FB_SHIFT)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_LPF_FF_A_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_LPF_FF_B_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_LPF_FB_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_SMLPF_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_DCFLT_SHIFT_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_IIR_ADAPT_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_IIR_COEFF_1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_IIR_COEFF_2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_FF_A_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_FF_B_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC0_FB_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_CLK_RESET_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_MODE_1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_MODE_2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_FF_SHIFT)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_FB_SHIFT)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_LPF_FF_A_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_LPF_FF_B_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_LPF_FB_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_SMLPF_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_DCFLT_SHIFT_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_IIR_ADAPT_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_IIR_COEFF_1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_IIR_COEFF_2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_FF_A_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_FF_B_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_ANC1_FB_GAIN_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX0_TX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX1_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX2_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX3_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX4_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX5_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX6_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX7_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_192_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_192_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX8_TX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX9_SPKR_PROT_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX9_SPKR_PROT_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX10_SPKR_PROT_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX10_SPKR_PROT_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX11_SPKR_PROT_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX11_SPKR_PROT_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX12_SPKR_PROT_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX12_SPKR_PROT_PATH_CFG0)] = 1,
};

const u8 wcd9335_page11_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE11_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER1_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER2_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER3_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER4_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER5_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER6_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER7_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL0)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL4)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL5)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL6)] = 1,
	[WCD9335_REG(WCD9335_CDC_COMPANDER8_CTL7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX0_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX1_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX2_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX3_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX4_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX5_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX6_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX7_RX_PATH_MIX_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_VOL_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_MIX_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_VOL_MIX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC5)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC6)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_SEC7)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_MIX_SEC0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX8_RX_PATH_MIX_SEC1)] = 1,
};

const u8 wcd9335_page12_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE12_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_CRC)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_DLY_CTRL)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_DECAY_CTRL)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_HPH_V_PA)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_EAR_V_PA)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_HPH_V_HD)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_EAR_V_HD)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_K1_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_K1_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_K2_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_K2_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_IDLE_CTRL)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_IDLE_HPH)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_IDLE_EAR)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_TEST0)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_TEST1)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLSH_OVR_VREF)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST0_BOOST_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST0_BOOST_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST0_BOOST_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST0_BOOST_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST1_BOOST_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST1_BOOST_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST1_BOOST_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_BOOST1_BOOST_CFG2)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_DATA_0)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_DATA_1)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_DATA_2)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_DATA_3)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_ADDR_0)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_ADDR_1)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_ADDR_2)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_WR_ADDR_3)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_ADDR_0)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_ADDR_1)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_ADDR_2)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_ADDR_3)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_DATA_0)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_DATA_1)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_DATA_2)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_RD_DATA_3)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_ACCESS_CFG)] = 1,
	[WCD9335_REG(WCD9335_SWR_AHB_BRIDGE_ACCESS_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_CFG)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_ADC_CAL1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_ADC_CAL2)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_ADC_CAL3)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_PK_EST1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_PK_EST2)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_PK_EST3)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_RF_PROC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_RF_PROC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_TAC1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_TAC2)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_TAC3)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_TAC4)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_UPD1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_UPD2)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_UPD3)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_UPD4)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_DEBUG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_UPD_MON)] = 0,
	[WCD9335_REG(WCD9335_CDC_VBAT_VBAT_GAIN_MON_VAL)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC0_CLK_RST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC0_STATUS)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC1_CLK_RST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC1_STATUS)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC2_CLK_RST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC2_STATUS)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC3_CLK_RST_CTL_0)] = 1,
	[WCD9335_REG(WCD9335_SPLINE_SRC3_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CFG1)] = 1,
};

const u8 wcd9335_page13_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE13_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG3)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG4)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_ANC_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_RX_INP_MUX_SPLINE_SRC_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX4_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX5_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX6_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX7_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX8_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX10_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX11_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX12_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TX_INP_MUX_ADC_MUX13_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG3)] = 1,
	[WCD9335_REG(WCD9335_CDC_IF_ROUTER_TX_MUX_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_IF_ROUTER_TX_MUX_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_IF_ROUTER_TX_MUX_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_IF_ROUTER_TX_MUX_CFG3)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLK_RST_CTRL_MCLK_CONTROL)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLK_RST_CTRL_FS_CNT_CONTROL)] = 1,
	[WCD9335_REG(WCD9335_CDC_CLK_RST_CTRL_SWR_CONTROL)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD0)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD1)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_STATUS)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_TEST_CTRL)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD)] = 1,
	[WCD9335_REG(WCD9335_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_PATH_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B3_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B4_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B5_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B6_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B7_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B8_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_TIMER_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B1_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B2_CTL)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG0)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG1)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG2)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG3)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG4)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG5)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG6)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_TOP_CFG7)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHL_COMP_WR_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHL_COMP_WR_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHL_COMP_LUT)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHL_COMP_RD_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHL_COMP_RD_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHR_COMP_WR_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHR_COMP_WR_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHR_COMP_LUT)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHR_COMP_RD_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_HPHR_COMP_RD_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFL_COMP_WR_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFL_COMP_WR_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFL_COMP_LUT)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFL_COMP_RD_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFL_COMP_RD_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFR_COMP_WR_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFR_COMP_WR_MSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFR_COMP_LUT)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFR_COMP_RD_LSB)] = 1,
	[WCD9335_REG(WCD9335_CDC_TOP_DIFFR_COMP_RD_MSB)] = 1,
};

const u8 wcd9335_page_0x80_reg_readable[WCD9335_PAGE_SIZE] = {
	[WCD9335_REG(WCD9335_PAGE80_PAGE_REGISTER)] = 1,
	[WCD9335_REG(WCD9335_TLMM_BIST_MODE_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_RF_PA_ON_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_INTR1_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_INTR2_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_SWR_DATA_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_SWR_CLK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_SLIMBUS_DATA2_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2C_CLK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2C_DATA_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_RX_SD0_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_RX_SD1_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_RX_SCK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_RX_WS_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_TX_SD0_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_TX_SD1_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_TX_SCK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_I2S_TX_WS_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC1_CLK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC1_DATA_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC2_CLK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC2_DATA_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC3_CLK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_DMIC3_DATA_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_JTDI_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_JTDO_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_JTMS_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_JTCK_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TLMM_JTRST_PINCFG)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_OE_0)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_OE_1)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_OE_2)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_OE_3)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_DATA_0)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_DATA_1)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_DATA_2)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_CTL_DATA_3)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PAD_DRVCTL)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_PIN_STATUS)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_NPL_DLY_TEST_1)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_NPL_DLY_TEST_2)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_MEM_CTRL)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_DEBUG_BUS_SEL)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_DEBUG_JTAG)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_DEBUG_EN_1)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_DEBUG_EN_2)] = 1,
	[WCD9335_REG(WCD9335_TEST_DEBUG_DEBUG_EN_3)] = 1,
};

const u8 *wcd9335_reg[WCD9335_NUM_PAGES] = {
	[PAGE_0] = wcd9335_page0_reg_readable,
	[PAGE_1] = wcd9335_page1_reg_readable,
	[PAGE_2] = wcd9335_page2_reg_readable,
	[PAGE_6] = wcd9335_page6_reg_readable,
	[PAGE_10] = wcd9335_page10_reg_readable,
	[PAGE_11] = wcd9335_page11_reg_readable,
	[PAGE_12] = wcd9335_page12_reg_readable,
	[PAGE_13] = wcd9335_page13_reg_readable,
	[PAGE_0X80] = wcd9335_page_0x80_reg_readable,
};
