/* Copyright (c) 2015-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef __GSI_REG_H__
#define __GSI_REG_H__

#define GSI_GSI_REG_BASE_OFFS 0

#define GSI_GSI_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000000)
#define GSI_GSI_CFG_RMSK 0xf
#define GSI_GSI_CFG_BP_MTRIX_DISABLE_BMSK 0x20
#define GSI_GSI_CFG_BP_MTRIX_DISABLE_SHFT 0x5
#define GSI_GSI_CFG_GSI_PWR_CLPS_BMSK 0x10
#define GSI_GSI_CFG_GSI_PWR_CLPS_SHFT 0x4
#define GSI_GSI_CFG_UC_IS_MCS_BMSK 0x8
#define GSI_GSI_CFG_UC_IS_MCS_SHFT 0x3
#define GSI_GSI_CFG_DOUBLE_MCS_CLK_FREQ_BMSK 0x4
#define GSI_GSI_CFG_DOUBLE_MCS_CLK_FREQ_SHFT 0x2
#define GSI_GSI_CFG_MCS_ENABLE_BMSK 0x2
#define GSI_GSI_CFG_MCS_ENABLE_SHFT 0x1
#define GSI_GSI_CFG_GSI_ENABLE_BMSK 0x1
#define GSI_GSI_CFG_GSI_ENABLE_SHFT 0x0

#define GSI_GSI_MCS_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000B000)
#define GSI_GSI_MCS_CFG_MCS_ENABLE_BMSK 0x1
#define GSI_GSI_MCS_CFG_MCS_ENABLE_SHFT 0x0

#define GSI_GSI_MANAGER_MCS_CODE_VER_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000008)
#define GSI_GSI_MANAGER_MCS_CODE_VER_RMSK 0xffffffff
#define GSI_GSI_MANAGER_MCS_CODE_VER_VER_BMSK 0xffffffff
#define GSI_GSI_MANAGER_MCS_CODE_VER_VER_SHFT 0x0

#define GSI_GSI_ZEROS_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000010)
#define GSI_GSI_ZEROS_RMSK 0xffffffff
#define GSI_GSI_ZEROS_ZEROS_BMSK 0xffffffff
#define GSI_GSI_ZEROS_ZEROS_SHFT 0x0

#define GSI_GSI_PERIPH_BASE_ADDR_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000018)
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_RMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_BASE_ADDR_BMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_BASE_ADDR_SHFT 0x0

#define GSI_GSI_PERIPH_BASE_ADDR_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000001c)
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_RMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_BASE_ADDR_BMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_BASE_ADDR_SHFT 0x0

#define GSI_GSI_MOQA_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000030)
#define GSI_GSI_MOQA_CFG_RMSK 0xffffff
#define GSI_GSI_MOQA_CFG_CLIENT_OOWR_BMSK 0xff0000
#define GSI_GSI_MOQA_CFG_CLIENT_OOWR_SHFT 0x10
#define GSI_GSI_MOQA_CFG_CLIENT_OORD_BMSK 0xff00
#define GSI_GSI_MOQA_CFG_CLIENT_OORD_SHFT 0x8
#define GSI_GSI_MOQA_CFG_CLIENT_REQ_PRIO_BMSK 0xff
#define GSI_GSI_MOQA_CFG_CLIENT_REQ_PRIO_SHFT 0x0

#define GSI_GSI_REE_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000038)
#define GSI_GSI_REE_CFG_RMSK 0xff01
#define GSI_GSI_REE_CFG_MAX_BURST_SIZE_BMSK 0xff00
#define GSI_GSI_REE_CFG_MAX_BURST_SIZE_SHFT 0x8
#define GSI_GSI_REE_CFG_MOVE_TO_ESC_CLR_MODE_TRSH_BMSK 0x1
#define GSI_GSI_REE_CFG_MOVE_TO_ESC_CLR_MODE_TRSH_SHFT 0x0

#define GSI_GSI_SHRAM_WR_WRR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000050)
#define GSI_GSI_SHRAM_WR_WRR_RMSK 0xffff
#define GSI_GSI_SHRAM_WR_WRR_CLIENT3_WR_WEIGHT_BMSK 0xf000
#define GSI_GSI_SHRAM_WR_WRR_CLIENT3_WR_WEIGHT_SHFT 0xc
#define GSI_GSI_SHRAM_WR_WRR_CLIENT2_WR_WEIGHT_BMSK 0xf00
#define GSI_GSI_SHRAM_WR_WRR_CLIENT2_WR_WEIGHT_SHFT 0x8
#define GSI_GSI_SHRAM_WR_WRR_CLIENT1_WR_WEIGHT_BMSK 0xf0
#define GSI_GSI_SHRAM_WR_WRR_CLIENT1_WR_WEIGHT_SHFT 0x4
#define GSI_GSI_SHRAM_WR_WRR_CLIENT0_WR_WEIGHT_BMSK 0xf
#define GSI_GSI_SHRAM_WR_WRR_CLIENT0_WR_WEIGHT_SHFT 0x0

#define GSI_GSI_SHRAM_RD_WRR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000058)
#define GSI_GSI_SHRAM_RD_WRR_RMSK 0xffffff
#define GSI_GSI_SHRAM_RD_WRR_ACH_SHRAM_RD_WEIGHT_BMSK 0xf00000
#define GSI_GSI_SHRAM_RD_WRR_ACH_SHRAM_RD_WEIGHT_SHFT 0x14
#define GSI_GSI_SHRAM_RD_WRR_IE_SHRAM_RD_WEIGHT_BMSK 0xf0000
#define GSI_GSI_SHRAM_RD_WRR_IE_SHRAM_RD_WEIGHT_SHFT 0x10
#define GSI_GSI_SHRAM_RD_WRR_CSR_SHRAM_RD_WEIGHT_BMSK 0xf000
#define GSI_GSI_SHRAM_RD_WRR_CSR_SHRAM_RD_WEIGHT_SHFT 0xc
#define GSI_GSI_SHRAM_RD_WRR_RE_CNTXT_SHRAM_RD_WEIGHT_BMSK 0xf00
#define GSI_GSI_SHRAM_RD_WRR_RE_CNTXT_SHRAM_RD_WEIGHT_SHFT 0x8
#define GSI_GSI_SHRAM_RD_WRR_MCS_LD_SHRAM_RD_WEIGHT_BMSK 0xf0
#define GSI_GSI_SHRAM_RD_WRR_MCS_LD_SHRAM_RD_WEIGHT_SHFT 0x4
#define GSI_GSI_SHRAM_RD_WRR_EV_ENG_SHRAM_RD_WEIGHT_BMSK 0xf
#define GSI_GSI_SHRAM_RD_WRR_EV_ENG_SHRAM_RD_WEIGHT_SHFT 0x0

#define GSI_GSI_CGC_CTRL_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000060)
#define GSI_GSI_CGC_CTRL_RMSK 0x3f
#define GSI_GSI_CGC_CTRL_REGION_12_HW_CGC_EN_BMSK 0x800
#define GSI_GSI_CGC_CTRL_REGION_12_HW_CGC_EN_SHFT 0xb
#define GSI_GSI_CGC_CTRL_REGION_11_HW_CGC_EN_BMSK0x400
#define GSI_GSI_CGC_CTRL_REGION_11_HW_CGC_EN_SHFT 0xa
#define GSI_GSI_CGC_CTRL_REGION_10_HW_CGC_EN_BMSK0x200
#define GSI_GSI_CGC_CTRL_REGION_10_HW_CGC_EN_SHFT 0x9
#define GSI_GSI_CGC_CTRL_REGION_9_HW_CGC_EN_BMSK 0x100
#define GSI_GSI_CGC_CTRL_REGION_9_HW_CGC_EN_SHFT 0x8
#define GSI_GSI_CGC_CTRL_REGION_8_HW_CGC_EN_BMSK 0x80
#define GSI_GSI_CGC_CTRL_REGION_8_HW_CGC_EN_SHFT 0x7
#define GSI_GSI_CGC_CTRL_REGION_7_HW_CGC_EN_BMSK 0x40
#define GSI_GSI_CGC_CTRL_REGION_7_HW_CGC_EN_SHFT 0x6
#define GSI_GSI_CGC_CTRL_REGION_6_HW_CGC_EN_BMSK 0x20
#define GSI_GSI_CGC_CTRL_REGION_6_HW_CGC_EN_SHFT 0x5
#define GSI_GSI_CGC_CTRL_REGION_5_HW_CGC_EN_BMSK 0x10
#define GSI_GSI_CGC_CTRL_REGION_5_HW_CGC_EN_SHFT 0x4
#define GSI_GSI_CGC_CTRL_REGION_4_HW_CGC_EN_BMSK 0x8
#define GSI_GSI_CGC_CTRL_REGION_4_HW_CGC_EN_SHFT 0x3
#define GSI_GSI_CGC_CTRL_REGION_3_HW_CGC_EN_BMSK 0x4
#define GSI_GSI_CGC_CTRL_REGION_3_HW_CGC_EN_SHFT 0x2
#define GSI_GSI_CGC_CTRL_REGION_2_HW_CGC_EN_BMSK 0x2
#define GSI_GSI_CGC_CTRL_REGION_2_HW_CGC_EN_SHFT 0x1
#define GSI_GSI_CGC_CTRL_REGION_1_HW_CGC_EN_BMSK 0x1
#define GSI_GSI_CGC_CTRL_REGION_1_HW_CGC_EN_SHFT 0x0

#define GSI_GSI_MSI_CACHEATTR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000080)
#define GSI_GSI_MSI_CACHEATTR_RMSK 0x3f
#define GSI_GSI_MSI_CACHEATTR_AREQPRIORITY_BMSK 0x30
#define GSI_GSI_MSI_CACHEATTR_AREQPRIORITY_SHFT 0x4
#define GSI_GSI_MSI_CACHEATTR_ATRANSIENT_BMSK 0x8
#define GSI_GSI_MSI_CACHEATTR_ATRANSIENT_SHFT 0x3
#define GSI_GSI_MSI_CACHEATTR_ANOALLOCATE_BMSK 0x4
#define GSI_GSI_MSI_CACHEATTR_ANOALLOCATE_SHFT 0x2
#define GSI_GSI_MSI_CACHEATTR_AINNERSHARED_BMSK 0x2
#define GSI_GSI_MSI_CACHEATTR_AINNERSHARED_SHFT 0x1
#define GSI_GSI_MSI_CACHEATTR_ASHARED_BMSK 0x1
#define GSI_GSI_MSI_CACHEATTR_ASHARED_SHFT 0x0

#define GSI_GSI_EVENT_CACHEATTR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000084)
#define GSI_GSI_EVENT_CACHEATTR_RMSK 0x3f
#define GSI_GSI_EVENT_CACHEATTR_AREQPRIORITY_BMSK 0x30
#define GSI_GSI_EVENT_CACHEATTR_AREQPRIORITY_SHFT 0x4
#define GSI_GSI_EVENT_CACHEATTR_ATRANSIENT_BMSK 0x8
#define GSI_GSI_EVENT_CACHEATTR_ATRANSIENT_SHFT 0x3
#define GSI_GSI_EVENT_CACHEATTR_ANOALLOCATE_BMSK 0x4
#define GSI_GSI_EVENT_CACHEATTR_ANOALLOCATE_SHFT 0x2
#define GSI_GSI_EVENT_CACHEATTR_AINNERSHARED_BMSK 0x2
#define GSI_GSI_EVENT_CACHEATTR_AINNERSHARED_SHFT 0x1
#define GSI_GSI_EVENT_CACHEATTR_ASHARED_BMSK 0x1
#define GSI_GSI_EVENT_CACHEATTR_ASHARED_SHFT 0x0

#define GSI_GSI_DATA_CACHEATTR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000088)
#define GSI_GSI_DATA_CACHEATTR_RMSK 0x3f
#define GSI_GSI_DATA_CACHEATTR_AREQPRIORITY_BMSK 0x30
#define GSI_GSI_DATA_CACHEATTR_AREQPRIORITY_SHFT 0x4
#define GSI_GSI_DATA_CACHEATTR_ATRANSIENT_BMSK 0x8
#define GSI_GSI_DATA_CACHEATTR_ATRANSIENT_SHFT 0x3
#define GSI_GSI_DATA_CACHEATTR_ANOALLOCATE_BMSK 0x4
#define GSI_GSI_DATA_CACHEATTR_ANOALLOCATE_SHFT 0x2
#define GSI_GSI_DATA_CACHEATTR_AINNERSHARED_BMSK 0x2
#define GSI_GSI_DATA_CACHEATTR_AINNERSHARED_SHFT 0x1
#define GSI_GSI_DATA_CACHEATTR_ASHARED_BMSK 0x1
#define GSI_GSI_DATA_CACHEATTR_ASHARED_SHFT 0x0

#define GSI_GSI_TRE_CACHEATTR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000090)
#define GSI_GSI_TRE_CACHEATTR_RMSK 0x3f
#define GSI_GSI_TRE_CACHEATTR_AREQPRIORITY_BMSK 0x30
#define GSI_GSI_TRE_CACHEATTR_AREQPRIORITY_SHFT 0x4
#define GSI_GSI_TRE_CACHEATTR_ATRANSIENT_BMSK 0x8
#define GSI_GSI_TRE_CACHEATTR_ATRANSIENT_SHFT 0x3
#define GSI_GSI_TRE_CACHEATTR_ANOALLOCATE_BMSK 0x4
#define GSI_GSI_TRE_CACHEATTR_ANOALLOCATE_SHFT 0x2
#define GSI_GSI_TRE_CACHEATTR_AINNERSHARED_BMSK 0x2
#define GSI_GSI_TRE_CACHEATTR_AINNERSHARED_SHFT 0x1
#define GSI_GSI_TRE_CACHEATTR_ASHARED_BMSK 0x1
#define GSI_GSI_TRE_CACHEATTR_ASHARED_SHFT 0x0

#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a0)
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a4)
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a8)
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000ac)
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_GEN_INT_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b0)
#define GSI_IC_GEN_INT_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_GEN_INT_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_GEN_INT_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_GEN_INT_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_GEN_INT_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_INT_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_INT_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_GEN_INT_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_GEN_INT_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b4)
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_GEN_INT_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_GEN_INT_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_GEN_INT_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_INT_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_INT_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_GEN_INT_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b8)
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000bc)
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c0)
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c4)
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_TLV_STOP_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c8)
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_TLV_STOP_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000cc)
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_TLV_RESET_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d0)
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_TLV_RESET_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d4)
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d8)
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000dc)
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_READ_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e0)
#define GSI_IC_READ_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_READ_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_READ_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_READ_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_READ_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_READ_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_READ_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_READ_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_READ_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_READ_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_READ_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_READ_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e4)
#define GSI_IC_READ_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_READ_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_READ_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_READ_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_READ_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_READ_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_READ_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_READ_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_READ_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_WRITE_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e8)
#define GSI_IC_WRITE_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_WRITE_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_WRITE_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_WRITE_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_WRITE_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_WRITE_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_WRITE_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_WRITE_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_WRITE_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_WRITE_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_WRITE_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_WRITE_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000ec)
#define GSI_IC_WRITE_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_WRITE_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_WRITE_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_WRITE_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_WRITE_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_WRITE_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_WRITE_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_WRITE_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_WRITE_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000f0)
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000f4)
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_REE_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000100)
#define GSI_IC_INT_WEIGHT_REE_RMSK 0xfff
#define GSI_IC_INT_WEIGHT_REE_CH_EMPTY_INT_WEIGHT_BMSK 0xf00
#define GSI_IC_INT_WEIGHT_REE_CH_EMPTY_INT_WEIGHT_SHFT 0x8
#define GSI_IC_INT_WEIGHT_REE_NEW_RE_INT_WEIGHT_BMSK 0xf0
#define GSI_IC_INT_WEIGHT_REE_NEW_RE_INT_WEIGHT_SHFT 0x4
#define GSI_IC_INT_WEIGHT_REE_STOP_CH_COMP_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_REE_STOP_CH_COMP_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_EVT_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000104)
#define GSI_IC_INT_WEIGHT_EVT_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_EVT_ENG_EVNT_ENG_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_EVT_ENG_EVNT_ENG_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_INT_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000108)
#define GSI_IC_INT_WEIGHT_INT_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_INT_ENG_INT_ENG_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_INT_ENG_INT_ENG_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_CSR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000010c)
#define GSI_IC_INT_WEIGHT_CSR_RMSK 0xffffff
#define GSI_IC_INT_WEIGHT_CSR_CH_START_CMD_INT_WEIGHT_BMSK 0xf00000
#define GSI_IC_INT_WEIGHT_CSR_CH_START_CMD_INT_WEIGHT_SHFT 0x14
#define GSI_IC_INT_WEIGHT_CSR_CH_STOP_CMD_INT_WEIGHT_BMSK 0xf0000
#define GSI_IC_INT_WEIGHT_CSR_CH_STOP_CMD_INT_WEIGHT_SHFT 0x10
#define GSI_IC_INT_WEIGHT_CSR_CH_RESET_CMD_INT_WEIGHT_BMSK 0xf000
#define GSI_IC_INT_WEIGHT_CSR_CH_RESET_CMD_INT_WEIGHT_SHFT 0xc
#define GSI_IC_INT_WEIGHT_CSR_CH_ALLOC_CMD_INT_WEIGHT_BMSK 0xf00
#define GSI_IC_INT_WEIGHT_CSR_CH_ALLOC_CMD_INT_WEIGHT_SHFT 0x8
#define GSI_IC_INT_WEIGHT_CSR_EV_RESET_CMD_INT_WEIGHT_BMSK 0xf0
#define GSI_IC_INT_WEIGHT_CSR_EV_RESET_CMD_INT_WEIGHT_SHFT 0x4
#define GSI_IC_INT_WEIGHT_CSR_EV_ALLOC_CMD_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_CSR_EV_ALLOC_CMD_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_TLV_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000110)
#define GSI_IC_INT_WEIGHT_TLV_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_TLV_ENG_TLV_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_TLV_ENG_TLV_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_TIMER_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000114)
#define GSI_IC_INT_WEIGHT_TIMER_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_TIMER_ENG_TIMER_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_TIMER_ENG_TIMER_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_DB_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000118)
#define GSI_IC_INT_WEIGHT_DB_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_DB_ENG_NEW_DB_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_DB_ENG_NEW_DB_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_RD_WR_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000011c)
#define GSI_IC_INT_WEIGHT_RD_WR_ENG_RMSK 0xff
#define GSI_IC_INT_WEIGHT_RD_WR_ENG_WRITE_INT_WEIGHT_BMSK 0xf0
#define GSI_IC_INT_WEIGHT_RD_WR_ENG_WRITE_INT_WEIGHT_SHFT 0x4
#define GSI_IC_INT_WEIGHT_RD_WR_ENG_READ_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_RD_WR_ENG_READ_INT_WEIGHT_SHFT 0x0

#define GSI_IC_INT_WEIGHT_UCONTROLLER_ENG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000120)
#define GSI_IC_INT_WEIGHT_UCONTROLLER_ENG_RMSK 0xf
#define GSI_IC_INT_WEIGHT_UCONTROLLER_ENG_GP_INT_WEIGHT_BMSK 0xf
#define GSI_IC_INT_WEIGHT_UCONTROLLER_ENG_GP_INT_WEIGHT_SHFT 0x0

#define GSI_GSI_MANAGER_EE_QOS_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00000300 + 0x4 * (n))
#define GSI_GSI_MANAGER_EE_QOS_n_RMSK 0x1f1f03
#define GSI_GSI_MANAGER_EE_QOS_n_MAXn 3
#define GSI_GSI_MANAGER_EE_QOS_n_MAX_EV_ALLOC_BMSK 0x1f0000
#define GSI_GSI_MANAGER_EE_QOS_n_MAX_EV_ALLOC_SHFT 0x10
#define GSI_GSI_MANAGER_EE_QOS_n_MAX_CH_ALLOC_BMSK 0x1f00
#define GSI_GSI_MANAGER_EE_QOS_n_MAX_CH_ALLOC_SHFT 0x8
#define GSI_GSI_MANAGER_EE_QOS_n_EE_PRIO_BMSK 0x3
#define GSI_GSI_MANAGER_EE_QOS_n_EE_PRIO_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000200)
#define GSI_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000204)
#define GSI_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000208)
#define GSI_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000020c)
#define GSI_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000240)
#define GSI_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000244)
#define GSI_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_RMSK 0xffff
#define GSI_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_SHRAM_PTR_BMSK 0xffff
#define GSI_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_SHRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_CMD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000400)
#define GSI_GSI_IRAM_PTR_CH_CMD_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_CMD_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_CMD_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000404)
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_DB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000418)
#define GSI_GSI_IRAM_PTR_CH_DB_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DB_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DB_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EV_DB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000041c)
#define GSI_GSI_IRAM_PTR_EV_DB_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EV_DB_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EV_DB_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_NEW_RE_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000420)
#define GSI_GSI_IRAM_PTR_NEW_RE_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_NEW_RE_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_NEW_RE_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000424)
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_EMPTY_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000428)
#define GSI_GSI_IRAM_PTR_CH_EMPTY_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_EMPTY_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_EMPTY_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000042c)
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000430)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000434)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000438)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000043c)
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000440)
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000444)
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_UC_GP_INT_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000448)
#define GSI_GSI_IRAM_PTR_UC_GP_INT_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_UC_GP_INT_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_UC_GP_INT_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000044c)
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_IRAM_PTR_SHFT 0x0

#define GSI_GSI_INST_RAM_n_WORD_SZ 0x4
#define GSI_GSI_INST_RAM_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00004000 + GSI_GSI_INST_RAM_n_WORD_SZ * (n))
#define GSI_GSI_INST_RAM_n_RMSK 0xffffffff
#define GSI_GSI_INST_RAM_n_MAXn 4095
#define GSI_GSI_INST_RAM_n_INST_BYTE_3_BMSK 0xff000000
#define GSI_GSI_INST_RAM_n_INST_BYTE_3_SHFT 0x18
#define GSI_GSI_INST_RAM_n_INST_BYTE_2_BMSK 0xff0000
#define GSI_GSI_INST_RAM_n_INST_BYTE_2_SHFT 0x10
#define GSI_GSI_INST_RAM_n_INST_BYTE_1_BMSK 0xff00
#define GSI_GSI_INST_RAM_n_INST_BYTE_1_SHFT 0x8
#define GSI_GSI_INST_RAM_n_INST_BYTE_0_BMSK 0xff
#define GSI_GSI_INST_RAM_n_INST_BYTE_0_SHFT 0x0

#define GSI_GSI_SHRAM_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00002000 + 0x4 * (n))
#define GSI_GSI_SHRAM_n_RMSK 0xffffffff
#define GSI_GSI_SHRAM_n_MAXn 1023
#define GSI_GSI_SHRAM_n_SHRAM_BMSK 0xffffffff
#define GSI_GSI_SHRAM_n_SHRAM_SHFT 0x0

#define GSI_GSI_TEST_BUS_SEL_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001000)
#define GSI_GSI_TEST_BUS_SEL_RMSK 0xff
#define GSI_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_BMSK 0xff
#define GSI_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_SHFT 0x0

#define GSI_GSI_TEST_BUS_REG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001008)
#define GSI_GSI_TEST_BUS_REG_RMSK 0xffffffff
#define GSI_GSI_TEST_BUS_REG_GSI_TESTBUS_REG_BMSK 0xffffffff
#define GSI_GSI_TEST_BUS_REG_GSI_TESTBUS_REG_SHFT 0x0

#define GSI_GSI_DEBUG_BUSY_REG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001010)
#define GSI_GSI_DEBUG_BUSY_REG_RMSK 0xff
#define GSI_GSI_DEBUG_BUSY_REG_REE_PWR_CLPS_BUSY_BMSK 0x80
#define GSI_GSI_DEBUG_BUSY_REG_REE_PWR_CLPS_BUSY_SHFT 0x7
#define GSI_GSI_DEBUG_BUSY_REG_INT_ENG_BUSY_BMSK 0x40
#define GSI_GSI_DEBUG_BUSY_REG_INT_ENG_BUSY_SHFT 0x6
#define GSI_GSI_DEBUG_BUSY_REG_EV_ENG_BUSY_BMSK 0x20
#define GSI_GSI_DEBUG_BUSY_REG_EV_ENG_BUSY_SHFT 0x5
#define GSI_GSI_DEBUG_BUSY_REG_RD_WR_BUSY_BMSK 0x10
#define GSI_GSI_DEBUG_BUSY_REG_RD_WR_BUSY_SHFT 0x4
#define GSI_GSI_DEBUG_BUSY_REG_TIMER_BUSY_BMSK 0x8
#define GSI_GSI_DEBUG_BUSY_REG_TIMER_BUSY_SHFT 0x3
#define GSI_GSI_DEBUG_BUSY_REG_MCS_BUSY_BMSK 0x4
#define GSI_GSI_DEBUG_BUSY_REG_MCS_BUSY_SHFT 0x2
#define GSI_GSI_DEBUG_BUSY_REG_REE_BUSY_BMSK 0x2
#define GSI_GSI_DEBUG_BUSY_REG_REE_BUSY_SHFT 0x1
#define GSI_GSI_DEBUG_BUSY_REG_CSR_BUSY_BMSK 0x1
#define GSI_GSI_DEBUG_BUSY_REG_CSR_BUSY_SHFT 0x0

#define GSI_GSI_DEBUG_COUNTER_CFGn_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001200 + 0x4 * (n))
#define GSI_GSI_DEBUG_COUNTER_CFGn_RMSK 0x3ffffff7
#define GSI_GSI_DEBUG_COUNTER_CFGn_MAXn 7
#define GSI_GSI_DEBUG_COUNTER_CFGn_TIMER_VALUE_BMSK 0x3ff80000
#define GSI_GSI_DEBUG_COUNTER_CFGn_TIMER_VALUE_SHFT 0x13
#define GSI_GSI_DEBUG_COUNTER_CFGn_VIRTUAL_CHNL_BMSK 0x7f000
#define GSI_GSI_DEBUG_COUNTER_CFGn_VIRTUAL_CHNL_SHFT 0xc
#define GSI_GSI_DEBUG_COUNTER_CFGn_EE_BMSK 0xf00
#define GSI_GSI_DEBUG_COUNTER_CFGn_EE_SHFT 0x8
#define GSI_GSI_DEBUG_COUNTER_CFGn_EVNT_TYPE_BMSK 0xf0
#define GSI_GSI_DEBUG_COUNTER_CFGn_EVNT_TYPE_SHFT 0x4
#define GSI_GSI_DEBUG_COUNTER_CFGn_CLR_AT_READ_BMSK 0x4
#define GSI_GSI_DEBUG_COUNTER_CFGn_CLR_AT_READ_SHFT 0x2
#define GSI_GSI_DEBUG_COUNTER_CFGn_STOP_AT_WRAP_ARND_BMSK 0x2
#define GSI_GSI_DEBUG_COUNTER_CFGn_STOP_AT_WRAP_ARND_SHFT 0x1
#define GSI_GSI_DEBUG_COUNTER_CFGn_ENABLE_BMSK 0x1
#define GSI_GSI_DEBUG_COUNTER_CFGn_ENABLE_SHFT 0x0

#define GSI_GSI_DEBUG_COUNTERn_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001240 + 0x4 * (n))
#define GSI_GSI_DEBUG_COUNTERn_RMSK 0xffff
#define GSI_GSI_DEBUG_COUNTERn_MAXn 7
#define GSI_GSI_DEBUG_COUNTERn_COUNTER_VALUE_BMSK 0xffff
#define GSI_GSI_DEBUG_COUNTERn_COUNTER_VALUE_SHFT 0x0

#define GSI_GSI_DEBUG_PC_FROM_SW_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001040)
#define GSI_GSI_DEBUG_PC_FROM_SW_RMSK 0xfff
#define GSI_GSI_DEBUG_PC_FROM_SW_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_DEBUG_PC_FROM_SW_IRAM_PTR_SHFT 0x0

#define GSI_GSI_DEBUG_SW_STALL_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001044)
#define GSI_GSI_DEBUG_SW_STALL_RMSK 0x1
#define GSI_GSI_DEBUG_SW_STALL_MCS_STALL_BMSK 0x1
#define GSI_GSI_DEBUG_SW_STALL_MCS_STALL_SHFT 0x0

#define GSI_GSI_DEBUG_PC_FOR_DEBUG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001048)
#define GSI_GSI_DEBUG_PC_FOR_DEBUG_RMSK 0xfff
#define GSI_GSI_DEBUG_PC_FOR_DEBUG_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_DEBUG_PC_FOR_DEBUG_IRAM_PTR_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_SEL_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001050)
#define GSI_GSI_DEBUG_QSB_LOG_SEL_RMSK 0xffff01
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_MID_BMSK 0xff0000
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_MID_SHFT 0x10
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_TID_BMSK 0xff00
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_TID_SHFT 0x8
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_WRITE_BMSK 0x1
#define GSI_GSI_DEBUG_QSB_LOG_SEL_SEL_WRITE_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_CLR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001058)
#define GSI_GSI_DEBUG_QSB_LOG_CLR_RMSK 0x1
#define GSI_GSI_DEBUG_QSB_LOG_CLR_LOG_CLR_BMSK 0x1
#define GSI_GSI_DEBUG_QSB_LOG_CLR_LOG_CLR_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001060)
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_RMSK 0x1ffff01
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_SAVED_BMSK 0x1000000
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_SAVED_SHFT 0x18
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_MID_BMSK 0xff0000
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_MID_SHFT 0x10
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_TID_BMSK 0xff00
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_TID_SHFT 0x8
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_WRITE_BMSK 0x1
#define GSI_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ERR_WRITE_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_0_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001064)
#define GSI_GSI_DEBUG_QSB_LOG_0_RMSK 0xffffffff
#define GSI_GSI_DEBUG_QSB_LOG_0_ADDR_31_0_BMSK 0xffffffff
#define GSI_GSI_DEBUG_QSB_LOG_0_ADDR_31_0_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_1_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00001068)
#define GSI_GSI_DEBUG_QSB_LOG_1_RMSK 0xfff7ffff
#define GSI_GSI_DEBUG_QSB_LOG_1_AREQPRIORITY_BMSK 0xf0000000
#define GSI_GSI_DEBUG_QSB_LOG_1_AREQPRIORITY_SHFT 0x1c
#define GSI_GSI_DEBUG_QSB_LOG_1_ASIZE_BMSK 0xf000000
#define GSI_GSI_DEBUG_QSB_LOG_1_ASIZE_SHFT 0x18
#define GSI_GSI_DEBUG_QSB_LOG_1_ALEN_BMSK 0xf00000
#define GSI_GSI_DEBUG_QSB_LOG_1_ALEN_SHFT 0x14
#define GSI_GSI_DEBUG_QSB_LOG_1_AOOOWR_BMSK 0x40000
#define GSI_GSI_DEBUG_QSB_LOG_1_AOOOWR_SHFT 0x12
#define GSI_GSI_DEBUG_QSB_LOG_1_AOOORD_BMSK 0x20000
#define GSI_GSI_DEBUG_QSB_LOG_1_AOOORD_SHFT 0x11
#define GSI_GSI_DEBUG_QSB_LOG_1_ATRANSIENT_BMSK 0x10000
#define GSI_GSI_DEBUG_QSB_LOG_1_ATRANSIENT_SHFT 0x10
#define GSI_GSI_DEBUG_QSB_LOG_1_ACACHEABLE_BMSK 0x8000
#define GSI_GSI_DEBUG_QSB_LOG_1_ACACHEABLE_SHFT 0xf
#define GSI_GSI_DEBUG_QSB_LOG_1_ASHARED_BMSK 0x4000
#define GSI_GSI_DEBUG_QSB_LOG_1_ASHARED_SHFT 0xe
#define GSI_GSI_DEBUG_QSB_LOG_1_ANOALLOCATE_BMSK 0x2000
#define GSI_GSI_DEBUG_QSB_LOG_1_ANOALLOCATE_SHFT 0xd
#define GSI_GSI_DEBUG_QSB_LOG_1_AINNERSHARED_BMSK 0x1000
#define GSI_GSI_DEBUG_QSB_LOG_1_AINNERSHARED_SHFT 0xc
#define GSI_GSI_DEBUG_QSB_LOG_1_ADDR_43_32_BMSK 0xfff
#define GSI_GSI_DEBUG_QSB_LOG_1_ADDR_43_32_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_2_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000106c)
#define GSI_GSI_DEBUG_QSB_LOG_2_RMSK 0xffff
#define GSI_GSI_DEBUG_QSB_LOG_2_AMEMTYPE_BMSK 0xf000
#define GSI_GSI_DEBUG_QSB_LOG_2_AMEMTYPE_SHFT 0xc
#define GSI_GSI_DEBUG_QSB_LOG_2_AMMUSID_BMSK 0xfff
#define GSI_GSI_DEBUG_QSB_LOG_2_AMMUSID_SHFT 0x0

#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001070 + 0x4 * (n))
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_RMSK 0xffffffff
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_MAXn 3
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_MID_BMSK 0xf8000000
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_MID_SHFT 0x1b
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_TID_BMSK 0x7c00000
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_TID_SHFT 0x16
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_WRITE_BMSK 0x200000
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_WRITE_SHFT 0x15
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_ADDR_20_0_BMSK 0x1fffff
#define GSI_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_ADDR_20_0_SHFT 0x0

#define GSI_GSI_DEBUG_SW_RF_n_WRITE_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001080 + 0x4 * (n))
#define GSI_GSI_DEBUG_SW_RF_n_WRITE_RMSK 0xffffffff
#define GSI_GSI_DEBUG_SW_RF_n_WRITE_MAXn 31
#define GSI_GSI_DEBUG_SW_RF_n_WRITE_DATA_IN_BMSK 0xffffffff
#define GSI_GSI_DEBUG_SW_RF_n_WRITE_DATA_IN_SHFT 0x0

#define GSI_GSI_DEBUG_SW_RF_n_READ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001100 + 0x4 * (n))
#define GSI_GSI_DEBUG_SW_RF_n_READ_RMSK 0xffffffff
#define GSI_GSI_DEBUG_SW_RF_n_READ_MAXn 31
#define GSI_GSI_DEBUG_SW_RF_n_READ_RF_REG_BMSK 0xffffffff
#define GSI_GSI_DEBUG_SW_RF_n_READ_RF_REG_SHFT 0x0

#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001400 + 0x80 * (n) + 0x4 * (k))
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_RMSK 0x3f
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_MAXk 30
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_MAXn 3
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_VALID_BMSK 0x20
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_VALID_SHFT 0x5
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_PHY_CH_BMSK 0x1f
#define GSI_GSI_DEBUG_EE_n_CH_k_VP_TABLE_PHY_CH_SHFT 0x0

#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00001600 + 0x80 * (n) + 0x4 * (k))
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_RMSK 0x3f
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_MAXk 15
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_MAXn 3
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_VALID_BMSK 0x20
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_VALID_SHFT 0x5
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_PHY_EV_CH_BMSK 0x1f
#define GSI_GSI_DEBUG_EE_n_EV_k_VP_TABLE_PHY_EV_CH_SHFT 0x0

#define GSI_GSI_UC_SRC_IRQ_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000500)
#define GSI_GSI_UC_SRC_IRQ_RMSK 0xf
#define GSI_GSI_UC_SRC_IRQ_IC_2_UC_MCS_INT_VLD_BMSK 0x8
#define GSI_GSI_UC_SRC_IRQ_IC_2_UC_MCS_INT_VLD_SHFT 0x3
#define GSI_GSI_UC_SRC_IRQ_ACC_2_UC_MCS_GO_ACK_BMSK 0x4
#define GSI_GSI_UC_SRC_IRQ_ACC_2_UC_MCS_GO_ACK_SHFT 0x2
#define GSI_GSI_UC_SRC_IRQ_UC_ACC_CMPLT_BMSK 0x2
#define GSI_GSI_UC_SRC_IRQ_UC_ACC_CMPLT_SHFT 0x1
#define GSI_GSI_UC_SRC_IRQ_UC_ACC_GO_BMSK 0x1
#define GSI_GSI_UC_SRC_IRQ_UC_ACC_GO_SHFT 0x0

#define GSI_GSI_UC_SRC_IRQ_MSK_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000504)
#define GSI_GSI_UC_SRC_IRQ_MSK_RMSK 0xf
#define GSI_GSI_UC_SRC_IRQ_MSK_IC_2_UC_MCS_INT_VLD_BMSK 0x8
#define GSI_GSI_UC_SRC_IRQ_MSK_IC_2_UC_MCS_INT_VLD_SHFT 0x3
#define GSI_GSI_UC_SRC_IRQ_MSK_ACC_2_UC_MCS_GO_ACK_BMSK 0x4
#define GSI_GSI_UC_SRC_IRQ_MSK_ACC_2_UC_MCS_GO_ACK_SHFT 0x2
#define GSI_GSI_UC_SRC_IRQ_MSK_UC_ACC_CMPLT_BMSK 0x2
#define GSI_GSI_UC_SRC_IRQ_MSK_UC_ACC_CMPLT_SHFT 0x1
#define GSI_GSI_UC_SRC_IRQ_MSK_UC_ACC_GO_BMSK 0x1
#define GSI_GSI_UC_SRC_IRQ_MSK_UC_ACC_GO_SHFT 0x0

#define GSI_GSI_UC_SRC_IRQ_CLR_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000508)
#define GSI_GSI_UC_SRC_IRQ_CLR_RMSK 0xf
#define GSI_GSI_UC_SRC_IRQ_CLR_IC_2_UC_MCS_INT_VLD_BMSK 0x8
#define GSI_GSI_UC_SRC_IRQ_CLR_IC_2_UC_MCS_INT_VLD_SHFT 0x3
#define GSI_GSI_UC_SRC_IRQ_CLR_ACC_2_UC_MCS_GO_ACK_BMSK 0x4
#define GSI_GSI_UC_SRC_IRQ_CLR_ACC_2_UC_MCS_GO_ACK_SHFT 0x2
#define GSI_GSI_UC_SRC_IRQ_CLR_UC_ACC_CMPLT_BMSK 0x2
#define GSI_GSI_UC_SRC_IRQ_CLR_UC_ACC_CMPLT_SHFT 0x1
#define GSI_GSI_UC_SRC_IRQ_CLR_UC_ACC_GO_BMSK 0x1
#define GSI_GSI_UC_SRC_IRQ_CLR_UC_ACC_GO_SHFT 0x0

#define GSI_GSI_ACC_ARGS_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000050c + 0x4 * (n))
#define GSI_GSI_ACC_ARGS_n_RMSK 0xffffffff
#define GSI_GSI_ACC_ARGS_n_MAXn 5
#define GSI_GSI_ACC_ARGS_n_GSI_ACC_ARGS_BMSK 0xffffffff
#define GSI_GSI_ACC_ARGS_n_GSI_ACC_ARGS_SHFT 0x0

#define GSI_GSI_ACC_ROUTINE_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000524)
#define GSI_GSI_ACC_ROUTINE_RMSK 0xffffffff
#define GSI_GSI_ACC_ROUTINE_GSI_ACC_ROUTINE_BMSK 0xffffffff
#define GSI_GSI_ACC_ROUTINE_GSI_ACC_ROUTINE_SHFT 0x0

#define GSI_GSI_ACC_GO_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000528)
#define GSI_GSI_ACC_GO_RMSK 0x7f
#define GSI_GSI_ACC_GO_TIMER_GO_BMSK 0x40
#define GSI_GSI_ACC_GO_TIMER_GO_SHFT 0x6
#define GSI_GSI_ACC_GO_RW_ENG_GO_BMSK 0x20
#define GSI_GSI_ACC_GO_RW_ENG_GO_SHFT 0x5
#define GSI_GSI_ACC_GO_INT_ENG_GO_BMSK 0x10
#define GSI_GSI_ACC_GO_INT_ENG_GO_SHFT 0x4
#define GSI_GSI_ACC_GO_TLV_OUT_GO_BMSK 0x8
#define GSI_GSI_ACC_GO_TLV_OUT_GO_SHFT 0x3
#define GSI_GSI_ACC_GO_CSR_GO_BMSK 0x4
#define GSI_GSI_ACC_GO_CSR_GO_SHFT 0x2
#define GSI_GSI_ACC_GO_RE_ENG_GO_BMSK 0x2
#define GSI_GSI_ACC_GO_RE_ENG_GO_SHFT 0x1
#define GSI_GSI_ACC_GO_EV_ENG_GO_BMSK 0x1
#define GSI_GSI_ACC_GO_EV_ENG_GO_SHFT 0x0

#define GSI_GSI_ACC_2_UC_MCS_STTS_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000052c)
#define GSI_GSI_ACC_2_UC_MCS_STTS_RMSK 0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_STTS_GSI_ACC_2_UC_MCS_STTS_BMSK 0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_STTS_GSI_ACC_2_UC_MCS_STTS_SHFT 0x0

#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000530)
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_LSB_RMSK 0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_LSB_GSI_ACC_2_UC_MCS_RET_VAL_BMSK \
	0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_LSB_GSI_ACC_2_UC_MCS_RET_VAL_SHFT \
	0x0

#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000534)
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_MSB_RMSK 0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_MSB_GSI_ACC_2_UC_MCS_RET_VAL_BMSK \
	0xffffffff
#define GSI_GSI_ACC_2_UC_MCS_RET_VAL_MSB_GSI_ACC_2_UC_MCS_RET_VAL_SHFT \
	0x0

#define GSI_GSI_IC_2_UC_MCS_VLD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000538)
#define GSI_GSI_IC_2_UC_MCS_VLD_RMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_VLD_GSI_IC_2_UC_MCS_VLD_BMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_VLD_GSI_IC_2_UC_MCS_VLD_SHFT 0x0

#define GSI_GSI_IC_2_UC_MCS_PC_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000053c)
#define GSI_GSI_IC_2_UC_MCS_PC_RMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_PC_GSI_IC_2_UC_MCS_PC_BMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_PC_GSI_IC_2_UC_MCS_PC_SHFT 0x0

#define GSI_GSI_IC_2_UC_MCS_ARGS_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00000540 + 0x4 * (n))
#define GSI_GSI_IC_2_UC_MCS_ARGS_n_RMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_ARGS_n_MAXn 5
#define GSI_GSI_IC_2_UC_MCS_ARGS_n_GSI_IC_2_UC_MCS_ARGS_BMSK 0xffffffff
#define GSI_GSI_IC_2_UC_MCS_ARGS_n_GSI_IC_2_UC_MCS_ARGS_SHFT 0x0

#define GSI_GSI_UC_TLV_IN_VLD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000558)
#define GSI_GSI_UC_TLV_IN_VLD_RMSK 0x1
#define GSI_GSI_UC_TLV_IN_VLD_GSI_UC_TLV_IN_VLD_BMSK 0x1
#define GSI_GSI_UC_TLV_IN_VLD_GSI_UC_TLV_IN_VLD_SHFT 0x0

#define GSI_GSI_UC_TLV_IN_ROUTINE_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000055c)
#define GSI_GSI_UC_TLV_IN_ROUTINE_RMSK 0xffffffff
#define GSI_GSI_UC_TLV_IN_ROUTINE_GSI_UC_TLV_IN_ROUTINE_BMSK 0xffffffff
#define GSI_GSI_UC_TLV_IN_ROUTINE_GSI_UC_TLV_IN_ROUTINE_SHFT 0x0

#define GSI_GSI_UC_TLV_IN_ARGS_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00000560 + 0x4 * (n))
#define GSI_GSI_UC_TLV_IN_ARGS_n_RMSK 0xffffffff
#define GSI_GSI_UC_TLV_IN_ARGS_n_MAXn 5
#define GSI_GSI_UC_TLV_IN_ARGS_n_GSI_UC_TLV_IN_ARGS_BMSK 0xffffffff
#define GSI_GSI_UC_TLV_IN_ARGS_n_GSI_UC_TLV_IN_ARGS_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c000 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_0_RMSK 0xfff7dfff
#define GSI_EE_n_GSI_CH_k_CNTXT_0_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_0_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_BMSK 0x7c000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_SHFT 0xe
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHID_BMSK 0x1f00
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHID_SHFT 0x8
#define GSI_EE_n_GSI_CH_k_CNTXT_0_EE_BMSK 0xf0
#define GSI_EE_n_GSI_CH_k_CNTXT_0_EE_SHFT 0x4
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_BMSK 0x8
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_SHFT 0x3
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_BMSK 0x7
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c004 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_1_RMSK 0xffff
#define GSI_EE_n_GSI_CH_k_CNTXT_1_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_1_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c008 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_2_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_2_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_2_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c00c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_3_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_3_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_3_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_4_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c010 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_4_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_4_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_4_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_5_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c014 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_5_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_5_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_5_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_6_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c018 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_6_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_6_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_6_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_7_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c01c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_7_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_7_MAXk 30
#define GSI_EE_n_GSI_CH_k_CNTXT_7_MAXn 3
#define GSI_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c054 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_RMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXk 30
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXn 3
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c058 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXk 30
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXn 3
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_QOS_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c05c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_QOS_RMSK 0x303
#define GSI_EE_n_GSI_CH_k_QOS_MAXk 30
#define GSI_EE_n_GSI_CH_k_QOS_MAXn 3
#define GSI_EE_n_GSI_CH_k_QOS_USE_ESCAPE_BUF_ONLY_BMSK 0x400
#define GSI_EE_n_GSI_CH_k_QOS_USE_ESCAPE_BUF_ONLY_SHFT 0xa
#define GSI_EE_n_GSI_CH_k_QOS_USE_DB_ENG_BMSK 0x200
#define GSI_EE_n_GSI_CH_k_QOS_USE_DB_ENG_SHFT 0x9
#define GSI_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_BMSK 0x100
#define GSI_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_SHFT 0x8
#define GSI_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_BMSK 0xf
#define GSI_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c060 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_MAXk 30
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_MAXn 3
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c064 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_MAXk 30
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_MAXn 3
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c068 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_MAXk 30
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_MAXn 3
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c06c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_MAXk 30
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_MAXn 3
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d000 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_0_RMSK 0xfff1ffff
#define GSI_EE_n_EV_CH_k_CNTXT_0_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_0_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define GSI_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define GSI_EE_n_EV_CH_k_CNTXT_0_INTYPE_BMSK 0x10000
#define GSI_EE_n_EV_CH_k_CNTXT_0_INTYPE_SHFT 0x10
#define GSI_EE_n_EV_CH_k_CNTXT_0_EVCHID_BMSK 0xff00
#define GSI_EE_n_EV_CH_k_CNTXT_0_EVCHID_SHFT 0x8
#define GSI_EE_n_EV_CH_k_CNTXT_0_EE_BMSK 0xf0
#define GSI_EE_n_EV_CH_k_CNTXT_0_EE_SHFT 0x4
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHTYPE_BMSK 0xf
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHTYPE_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d004 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_1_RMSK 0xffff
#define GSI_EE_n_EV_CH_k_CNTXT_1_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_1_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define GSI_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d008 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_2_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_2_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_2_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d00c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_3_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_3_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_3_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_4_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d010 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_4_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_4_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_4_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_5_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d014 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_5_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_5_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_5_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_6_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d018 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_6_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_6_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_6_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_7_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d01c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_7_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_7_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_7_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_8_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d020 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_8_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_8_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_8_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_BMSK 0xff000000
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_SHFT 0x18
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODC_BMSK 0xff0000
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODC_SHFT 0x10
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODT_BMSK 0xffff
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODT_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_9_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d024 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_9_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_9_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_9_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_9_INTVEC_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_9_INTVEC_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_10_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d028 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_10_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_10_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_10_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_11_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d02c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_11_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_11_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_11_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_12_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d030 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_12_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_12_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_12_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_13_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d034 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_13_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_13_MAXk 15
#define GSI_EE_n_EV_CH_k_CNTXT_13_MAXn 3
#define GSI_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_SCRATCH_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d048 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_SCRATCH_0_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_0_MAXk 15
#define GSI_EE_n_EV_CH_k_SCRATCH_0_MAXn 3
#define GSI_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_SCRATCH_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d04c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_SCRATCH_1_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_1_MAXk 15
#define GSI_EE_n_EV_CH_k_SCRATCH_1_MAXn 3
#define GSI_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_DOORBELL_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e000 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_MAXk 30
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_MAXn 3
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_DOORBELL_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e004 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_RMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_MAXk 30
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_MAXn 3
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_DOORBELL_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e100 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_EV_CH_k_DOORBELL_0_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_0_MAXk 15
#define GSI_EE_n_EV_CH_k_DOORBELL_0_MAXn 3
#define GSI_EE_n_EV_CH_k_DOORBELL_0_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_0_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_DOORBELL_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e104 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_EV_CH_k_DOORBELL_1_RMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_1_MAXk 15
#define GSI_EE_n_EV_CH_k_DOORBELL_1_MAXn 3
#define GSI_EE_n_EV_CH_k_DOORBELL_1_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_1_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_STATUS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f000 + 0x4000 * (n))
#define GSI_EE_n_GSI_STATUS_RMSK 0x1
#define GSI_EE_n_GSI_STATUS_MAXn 3
#define GSI_EE_n_GSI_STATUS_ENABLED_BMSK 0x1
#define GSI_EE_n_GSI_STATUS_ENABLED_SHFT 0x0

#define GSI_EE_n_GSI_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f008 + 0x4000 * (n))
#define GSI_EE_n_GSI_CH_CMD_RMSK 0xff0000ff
#define GSI_EE_n_GSI_CH_CMD_MAXn 3
#define GSI_EE_n_GSI_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_EE_n_GSI_CH_CMD_OPCODE_SHFT 0x18
#define GSI_EE_n_GSI_CH_CMD_CHID_BMSK 0xff
#define GSI_EE_n_GSI_CH_CMD_CHID_SHFT 0x0

#define GSI_EE_n_EV_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f010 + 0x4000 * (n))
#define GSI_EE_n_EV_CH_CMD_RMSK 0xff0000ff
#define GSI_EE_n_EV_CH_CMD_MAXn 3
#define GSI_EE_n_EV_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_EE_n_EV_CH_CMD_OPCODE_SHFT 0x18
#define GSI_EE_n_EV_CH_CMD_CHID_BMSK 0xff
#define GSI_EE_n_EV_CH_CMD_CHID_SHFT 0x0

#define GSI_EE_n_GSI_EE_GENERIC_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f018 + 0x4000 * (n))
#define GSI_EE_n_GSI_EE_GENERIC_CMD_RMSK 0xffffffff
#define GSI_EE_n_GSI_EE_GENERIC_CMD_MAXn 3
#define GSI_EE_n_GSI_EE_GENERIC_CMD_OPCODE_BMSK 0x1f
#define GSI_EE_n_GSI_EE_GENERIC_CMD_OPCODE_SHFT 0x0
#define GSI_EE_n_GSI_EE_GENERIC_CMD_VIRT_CHAN_IDX_BMSK 0x3e0
#define GSI_EE_n_GSI_EE_GENERIC_CMD_VIRT_CHAN_IDX_SHFT 0x5
#define GSI_EE_n_GSI_EE_GENERIC_CMD_EE_BMSK 0x3c00
#define GSI_EE_n_GSI_EE_GENERIC_CMD_EE_SHFT 0xa

/* v1.0 */
#define GSI_V1_0_EE_n_GSI_HW_PARAM_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V1_0_EE_n_GSI_HW_PARAM_RMSK 0x7fffffff
#define GSI_V1_0_EE_n_GSI_HW_PARAM_MAXn 3
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_SEC_GRP_BMSK 0x7c000000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_SEC_GRP_SHFT 0x1a
#define GSI_V1_0_EE_n_GSI_HW_PARAM_USE_AXI_M_BMSK 0x2000000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_USE_AXI_M_SHFT 0x19
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_CONF_ADDR_BUS_W_BMSK 0x1f00000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_CONF_ADDR_BUS_W_SHFT 0x14
#define GSI_V1_0_EE_n_GSI_HW_PARAM_NUM_EES_BMSK 0xf0000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_NUM_EES_SHFT 0x10
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_CH_NUM_BMSK 0xff00
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_CH_NUM_SHFT 0x8
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_EV_CH_NUM_BMSK 0xff
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_EV_CH_NUM_SHFT 0x0

/* v1.2 */
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f038 + 0x4000 * (n))
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_RMSK 0xffffffff
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_MAXn 2
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_USE_AXI_M_BMSK 0x80000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_USE_AXI_M_SHFT 0x1f
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_BMSK 0x7c000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_SHFT 0x1a
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_BMSK 0x3e00000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_SHFT 0x15
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_NUM_EES_BMSK 0x1f0000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_NUM_EES_SHFT 0x10
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_BMSK 0xff00
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_SHFT 0x8
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_BMSK 0xff
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_SHFT 0x0

#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_RMSK 0xffffffff
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_MAXn 2
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_2_EN_BMSK \
	0x80000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_2_EN_SHFT 0x1f
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_1_EN_BMSK \
	0x40000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_1_EN_SHFT 0x1e
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_SIMPLE_RD_WR_BMSK 0x20000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_SIMPLE_RD_WR_SHFT 0x1d
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_ESCAPE_BUF_ONLY_BMSK 0x10000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_ESCAPE_BUF_ONLY_SHFT 0x1c
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_UC_IF_BMSK 0x8000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_UC_IF_SHFT 0x1b
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_DB_ENG_BMSK 0x4000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_DB_ENG_SHFT 0x1a
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_BP_MTRIX_BMSK 0x2000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_BP_MTRIX_SHFT 0x19
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NUM_TIMERS_BMSK 0x1f00000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NUM_TIMERS_SHFT 0x14
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_XPU_BMSK 0x80000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_USE_XPU_SHFT 0x13
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_QRIB_EN_BMSK 0x40000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_QRIB_EN_SHFT 0x12
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_VMIDACR_EN_BMSK 0x20000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_VMIDACR_EN_SHFT 0x11
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_SEC_EN_BMSK 0x10000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_SEC_EN_SHFT 0x10
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NONSEC_EN_BMSK 0xf000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NONSEC_EN_SHFT 0xc
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NUM_QAD_BMSK 0xf00
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_NUM_QAD_SHFT 0x8
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_M_DATA_BUS_W_BMSK 0xff
#define GSI_V1_2_EE_n_GSI_HW_PARAM_1_GSI_M_DATA_BUS_W_SHFT 0x0

/* v1.3 */
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f038 + 0x4000 * (n))
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_RMSK 0xffffffff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_MAXn 2
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_USE_AXI_M_BMSK 0x80000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_USE_AXI_M_SHFT 0x1f
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_BMSK 0x7c000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_SHFT 0x1a
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_BMSK 0x3e00000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_SHFT 0x15
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_NUM_EES_BMSK 0x1f0000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_NUM_EES_SHFT 0x10
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_BMSK 0xff00
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_SHFT 0x8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_BMSK 0xff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_SHFT 0x0

#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f03c + 0x4000 * (n))
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_RMSK 0xffffffff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_MAXn 2
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_2_EN_BMSK \
	0x80000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_2_EN_SHFT 0x1f
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_1_EN_BMSK \
	0x40000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_BLK_INT_ACCESS_REGION_1_EN_SHFT 0x1e
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_SIMPLE_RD_WR_BMSK 0x20000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_SIMPLE_RD_WR_SHFT 0x1d
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_ESCAPE_BUF_ONLY_BMSK 0x10000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_ESCAPE_BUF_ONLY_SHFT 0x1c
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_UC_IF_BMSK 0x8000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_UC_IF_SHFT 0x1b
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_DB_ENG_BMSK 0x4000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_DB_ENG_SHFT 0x1a
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_BP_MTRIX_BMSK 0x2000000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_BP_MTRIX_SHFT 0x19
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NUM_TIMERS_BMSK 0x1f00000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NUM_TIMERS_SHFT 0x14
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_XPU_BMSK 0x80000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_USE_XPU_SHFT 0x13
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_QRIB_EN_BMSK 0x40000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_QRIB_EN_SHFT 0x12
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_VMIDACR_EN_BMSK 0x20000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_VMIDACR_EN_SHFT 0x11
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_SEC_EN_BMSK 0x10000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_SEC_EN_SHFT 0x10
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NONSEC_EN_BMSK 0xf000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NONSEC_EN_SHFT 0xc
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NUM_QAD_BMSK 0xf00
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_NUM_QAD_SHFT 0x8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_M_DATA_BUS_W_BMSK 0xff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_1_GSI_M_DATA_BUS_W_SHFT 0x0

#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1

/* v2.0 */
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_BMSK 0x38000000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_SHFT 0x1b
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_BMSK 0x7F80000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_SHFT 0x13
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_BMSK 0x70000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_SHFT 0x10
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_BMSK 0x8000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_SHFT 0xf
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_N_HALF_KB_FVAL 0x2
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_THREE_KB_FVAL 0x3

#define GSI_EE_n_GSI_SW_VERSION_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f044 + 0x4000 * (n))
#define GSI_EE_n_GSI_SW_VERSION_RMSK 0xffffffff
#define GSI_EE_n_GSI_SW_VERSION_MAXn 3
#define GSI_EE_n_GSI_SW_VERSION_MAJOR_BMSK 0xf0000000
#define GSI_EE_n_GSI_SW_VERSION_MAJOR_SHFT 0x1c
#define GSI_EE_n_GSI_SW_VERSION_MINOR_BMSK 0xfff0000
#define GSI_EE_n_GSI_SW_VERSION_MINOR_SHFT 0x10
#define GSI_EE_n_GSI_SW_VERSION_STEP_BMSK 0xffff
#define GSI_EE_n_GSI_SW_VERSION_STEP_SHFT 0x0

#define GSI_EE_n_GSI_MCS_CODE_VER_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f048 + 0x4000 * (n))
#define GSI_EE_n_GSI_MCS_CODE_VER_RMSK 0xffffffff
#define GSI_EE_n_GSI_MCS_CODE_VER_MAXn 3
#define GSI_EE_n_GSI_MCS_CODE_VER_VER_BMSK 0xffffffff
#define GSI_EE_n_GSI_MCS_CODE_VER_VER_SHFT 0x0

#define GSI_EE_n_CNTXT_TYPE_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f080 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_TYPE_IRQ_RMSK 0x7f
#define GSI_EE_n_CNTXT_TYPE_IRQ_MAXn 3
#define GSI_EE_n_CNTXT_TYPE_IRQ_GENERAL_BMSK 0x40
#define GSI_EE_n_CNTXT_TYPE_IRQ_GENERAL_SHFT 0x6
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_BMSK 0x20
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_SHFT 0x5
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_BMSK 0x10
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_SHFT 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_IEOB_BMSK 0x8
#define GSI_EE_n_CNTXT_TYPE_IRQ_IEOB_SHFT 0x3
#define GSI_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_BMSK 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_SHFT 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_BMSK 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_SHFT 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_BMSK 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_SHFT 0x0

#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f088 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_RMSK 0x7f
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_MAXn 3
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_BMSK 0x40
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_SHFT 0x6
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_BMSK 0x20
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_SHFT 0x5
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_BMSK 0x10
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_SHFT 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_BMSK 0x8
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_SHFT 0x3
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_BMSK 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_SHFT 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_BMSK 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_SHFT 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_BMSK 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f090 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MAXn 3
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f094 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MAXn 3
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f098 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_MAXn 3
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_BMSK \
	0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f09c + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_MAXn 3
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK \
	0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0a0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_MAXn 3
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0a4 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_MAXn 3
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0b0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MAXn 3
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0b8 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_MAXn 3
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK \
	0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0c0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_MAXn 3
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f100 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_RMSK 0xf
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_MAXn 3
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f108 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_RMSK 0xf
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_MAXn 3
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f110 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_RMSK 0xf
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_MAXn 3
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f118 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_RMSK 0xf
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_MAXn 3
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_EN_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f120 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_RMSK 0xf
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_MAXn 3
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f128 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_RMSK 0xf
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_MAXn 3
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_INTSET_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f180 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_INTSET_RMSK 0x1
#define GSI_EE_n_CNTXT_INTSET_MAXn 3
#define GSI_EE_n_CNTXT_INTSET_INTYPE_BMSK 0x1
#define GSI_EE_n_CNTXT_INTSET_INTYPE_SHFT 0x0

#define GSI_EE_n_CNTXT_MSI_BASE_LSB_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f188 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_MSI_BASE_LSB_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_MSI_BASE_LSB_MAXn 3
#define GSI_EE_n_CNTXT_MSI_BASE_LSB_MSI_ADDR_LSB_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_MSI_BASE_LSB_MSI_ADDR_LSB_SHFT 0x0

#define GSI_EE_n_CNTXT_MSI_BASE_MSB_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f18c + 0x4000 * (n))
#define GSI_EE_n_CNTXT_MSI_BASE_MSB_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_MSI_BASE_MSB_MAXn 3
#define GSI_EE_n_CNTXT_MSI_BASE_MSB_MSI_ADDR_MSB_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_MSI_BASE_MSB_MSI_ADDR_MSB_SHFT 0x0

#define GSI_EE_n_CNTXT_INT_VEC_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f190 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_INT_VEC_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_INT_VEC_MAXn 3
#define GSI_EE_n_CNTXT_INT_VEC_INT_VEC_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_INT_VEC_INT_VEC_SHFT 0x0

#define GSI_EE_n_ERROR_LOG_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f200 + 0x4000 * (n))
#define GSI_EE_n_ERROR_LOG_RMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_MAXn 3
#define GSI_EE_n_ERROR_LOG_TODO_BMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_TODO_SHFT 0x0

#define GSI_EE_n_ERROR_LOG_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f210 + 0x4000 * (n))
#define GSI_EE_n_ERROR_LOG_CLR_RMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_CLR_MAXn 3
#define GSI_EE_n_ERROR_LOG_CLR_TODO_BMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_CLR_TODO_SHFT 0x0

#define GSI_EE_n_CNTXT_SCRATCH_0_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f400 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SCRATCH_0_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SCRATCH_0_MAXn 3
#define GSI_EE_n_CNTXT_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_EE_n_CNTXT_SCRATCH_1_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f404 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SCRATCH_1_RMSK 0xffffffff
#define GSI_EE_n_CNTXT_SCRATCH_1_MAXn 3
#define GSI_EE_n_CNTXT_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SCRATCH_1_SCRATCH_SHFT 0x0

#define GSI_INTER_EE_n_ORIGINATOR_EE_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c000 + 0x1000 * (n))
#define GSI_INTER_EE_n_ORIGINATOR_EE_RMSK 0xf
#define GSI_INTER_EE_n_ORIGINATOR_EE_MAXn 3
#define GSI_INTER_EE_n_ORIGINATOR_EE_EE_NUMBER_BMSK 0xf
#define GSI_INTER_EE_n_ORIGINATOR_EE_EE_NUMBER_SHFT 0x0

#define GSI_INTER_EE_n_GSI_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c008 + 0x1000 * (n))
#define GSI_INTER_EE_n_GSI_CH_CMD_RMSK 0xff0000ff
#define GSI_INTER_EE_n_GSI_CH_CMD_MAXn 3
#define GSI_INTER_EE_n_GSI_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_INTER_EE_n_GSI_CH_CMD_OPCODE_SHFT 0x18
#define GSI_INTER_EE_n_GSI_CH_CMD_CHID_BMSK 0xff
#define GSI_INTER_EE_n_GSI_CH_CMD_CHID_SHFT 0x0

#define GSI_INTER_EE_n_EV_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c010 + 0x1000 * (n))
#define GSI_INTER_EE_n_EV_CH_CMD_RMSK 0xff0000ff
#define GSI_INTER_EE_n_EV_CH_CMD_MAXn 3
#define GSI_INTER_EE_n_EV_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_INTER_EE_n_EV_CH_CMD_OPCODE_SHFT 0x18
#define GSI_INTER_EE_n_EV_CH_CMD_CHID_BMSK 0xff
#define GSI_INTER_EE_n_EV_CH_CMD_CHID_SHFT 0x0

#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c018 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MAXn 3
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c01c + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MAXn 3
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c020 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_MAXn 3
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_BMSK \
	0x00003fff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c024 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MSK_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MSK_MAXn 3
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK \
	0x000003ff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c028 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_MAXn 3
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c02c + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_RMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_MAXn 3
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0


#endif /* __GSI_REG_H__ */
