/* Copyright (c) 2015-2017, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "sde_hw_mdss.h"

static const struct sde_format_extended plane_formats[] = {
	{DRM_FORMAT_ARGB8888, 0},
	{DRM_FORMAT_ABGR8888, 0},
	{DRM_FORMAT_RGBA8888, 0},
	{DRM_FORMAT_ABGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_BGRA8888, 0},
	{DRM_FORMAT_XRGB8888, 0},
	{DRM_FORMAT_RGBX8888, 0},
	{DRM_FORMAT_BGRX8888, 0},
	{DRM_FORMAT_XBGR8888, 0},
	{DRM_FORMAT_XBGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_RGB888, 0},
	{DRM_FORMAT_BGR888, 0},
	{DRM_FORMAT_RGB565, 0},
	{DRM_FORMAT_BGR565, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_BGR565, 0},
	{DRM_FORMAT_ARGB1555, 0},
	{DRM_FORMAT_ABGR1555, 0},
	{DRM_FORMAT_RGBA5551, 0},
	{DRM_FORMAT_BGRA5551, 0},
	{DRM_FORMAT_XRGB1555, 0},
	{DRM_FORMAT_XBGR1555, 0},
	{DRM_FORMAT_RGBX5551, 0},
	{DRM_FORMAT_BGRX5551, 0},
	{DRM_FORMAT_ARGB4444, 0},
	{DRM_FORMAT_ABGR4444, 0},
	{DRM_FORMAT_RGBA4444, 0},
	{DRM_FORMAT_BGRA4444, 0},
	{DRM_FORMAT_XRGB4444, 0},
	{DRM_FORMAT_XBGR4444, 0},
	{DRM_FORMAT_RGBX4444, 0},
	{DRM_FORMAT_BGRX4444, 0},
	{0, 0},
};

static const struct sde_format_extended plane_formats_yuv[] = {
	{DRM_FORMAT_ARGB8888, 0},
	{DRM_FORMAT_ABGR8888, 0},
	{DRM_FORMAT_RGBA8888, 0},
	{DRM_FORMAT_BGRX8888, 0},
	{DRM_FORMAT_ABGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_BGRA8888, 0},
	{DRM_FORMAT_XRGB8888, 0},
	{DRM_FORMAT_XBGR8888, 0},
	{DRM_FORMAT_RGBX8888, 0},
	{DRM_FORMAT_XBGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_RGB888, 0},
	{DRM_FORMAT_BGR888, 0},
	{DRM_FORMAT_RGB565, 0},
	{DRM_FORMAT_BGR565, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_BGR565, 0},
	{DRM_FORMAT_ARGB1555, 0},
	{DRM_FORMAT_ABGR1555, 0},
	{DRM_FORMAT_RGBA5551, 0},
	{DRM_FORMAT_BGRA5551, 0},
	{DRM_FORMAT_XRGB1555, 0},
	{DRM_FORMAT_XBGR1555, 0},
	{DRM_FORMAT_RGBX5551, 0},
	{DRM_FORMAT_BGRX5551, 0},
	{DRM_FORMAT_ARGB4444, 0},
	{DRM_FORMAT_ABGR4444, 0},
	{DRM_FORMAT_RGBA4444, 0},
	{DRM_FORMAT_BGRA4444, 0},
	{DRM_FORMAT_XRGB4444, 0},
	{DRM_FORMAT_XBGR4444, 0},
	{DRM_FORMAT_RGBX4444, 0},
	{DRM_FORMAT_BGRX4444, 0},

	{DRM_FORMAT_NV12, 0},
	{DRM_FORMAT_NV12, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_NV21, 0},
	{DRM_FORMAT_NV16, 0},
	{DRM_FORMAT_NV61, 0},
	{DRM_FORMAT_VYUY, 0},
	{DRM_FORMAT_UYVY, 0},
	{DRM_FORMAT_YUYV, 0},
	{DRM_FORMAT_YVYU, 0},
	{DRM_FORMAT_YUV420, 0},
	{DRM_FORMAT_YVU420, 0},
	{0, 0},
};

static const struct sde_format_extended cursor_formats[] = {
	{DRM_FORMAT_ARGB8888, 0},
	{DRM_FORMAT_ABGR8888, 0},
	{DRM_FORMAT_RGBA8888, 0},
	{DRM_FORMAT_BGRA8888, 0},
	{DRM_FORMAT_XRGB8888, 0},
	{DRM_FORMAT_ARGB1555, 0},
	{DRM_FORMAT_ABGR1555, 0},
	{DRM_FORMAT_RGBA5551, 0},
	{DRM_FORMAT_BGRA5551, 0},
	{DRM_FORMAT_ARGB4444, 0},
	{DRM_FORMAT_ABGR4444, 0},
	{DRM_FORMAT_RGBA4444, 0},
	{DRM_FORMAT_BGRA4444, 0},
	{0, 0},
};

static const struct sde_format_extended wb2_formats[] = {
	{DRM_FORMAT_RGB565, 0},
	{DRM_FORMAT_BGR565, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_RGB888, 0},
	{DRM_FORMAT_ARGB8888, 0},
	{DRM_FORMAT_RGBA8888, 0},
	{DRM_FORMAT_ABGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_XRGB8888, 0},
	{DRM_FORMAT_RGBX8888, 0},
	{DRM_FORMAT_XBGR8888, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_ARGB1555, 0},
	{DRM_FORMAT_RGBA5551, 0},
	{DRM_FORMAT_XRGB1555, 0},
	{DRM_FORMAT_RGBX5551, 0},
	{DRM_FORMAT_ARGB4444, 0},
	{DRM_FORMAT_RGBA4444, 0},
	{DRM_FORMAT_RGBX4444, 0},
	{DRM_FORMAT_XRGB4444, 0},

	{DRM_FORMAT_BGR565, 0},
	{DRM_FORMAT_BGR888, 0},
	{DRM_FORMAT_ABGR8888, 0},
	{DRM_FORMAT_BGRA8888, 0},
	{DRM_FORMAT_BGRX8888, 0},
	{DRM_FORMAT_XBGR8888, 0},
	{DRM_FORMAT_ABGR1555, 0},
	{DRM_FORMAT_BGRA5551, 0},
	{DRM_FORMAT_XBGR1555, 0},
	{DRM_FORMAT_BGRX5551, 0},
	{DRM_FORMAT_ABGR4444, 0},
	{DRM_FORMAT_BGRA4444, 0},
	{DRM_FORMAT_BGRX4444, 0},
	{DRM_FORMAT_XBGR4444, 0},

	{DRM_FORMAT_YUV420, 0},
	{DRM_FORMAT_NV12, 0},
	{DRM_FORMAT_NV12, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_NV16, 0},
	{DRM_FORMAT_YUYV, 0},

	{0, 0},
};

static const struct sde_format_extended rgb_10bit_formats[] = {
	{DRM_FORMAT_BGRA1010102, 0},
	{DRM_FORMAT_BGRX1010102, 0},
	{DRM_FORMAT_RGBA1010102, 0},
	{DRM_FORMAT_RGBX1010102, 0},
	{DRM_FORMAT_ABGR2101010, 0},
	{DRM_FORMAT_ABGR2101010, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_XBGR2101010, 0},
	{DRM_FORMAT_XBGR2101010, DRM_FORMAT_MOD_QCOM_COMPRESSED},
	{DRM_FORMAT_ARGB2101010, 0},
	{DRM_FORMAT_XRGB2101010, 0},
};

static const struct sde_format_extended p010_formats[] = {
	{DRM_FORMAT_NV12, DRM_FORMAT_MOD_QCOM_DX},
};

static const struct sde_format_extended p010_ubwc_formats[] = {
	{DRM_FORMAT_NV12, DRM_FORMAT_MOD_QCOM_DX |
		DRM_FORMAT_MOD_QCOM_COMPRESSED},
};

static const struct sde_format_extended tp10_ubwc_formats[] = {
	{DRM_FORMAT_NV12, DRM_FORMAT_MOD_QCOM_COMPRESSED |
		DRM_FORMAT_MOD_QCOM_DX | DRM_FORMAT_MOD_QCOM_TIGHT},
};
