/*
 * =================================================================
 *
 *
 *	Description:  samsung display common file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
*/
#ifndef _SAMSUNG_DSI_MDNIE_S6E3FA7_AMS604NL01_
#define _SAMSUNG_DSI_MDNIE_S6E3FA7_AMS604NL01_

#include "../ss_dsi_mdnie_lite_common.h"

#define MDNIE_COLOR_BLINDE_CMD_OFFSET 32

#define ADDRESS_SCR_WHITE_RED   0x32
#define ADDRESS_SCR_WHITE_GREEN 0x34
#define ADDRESS_SCR_WHITE_BLUE  0x36

#define MDNIE_RGB_SENSOR_INDEX	1

#define MDNIE_STEP1_INDEX 1
#define MDNIE_STEP2_INDEX 2
#define MDNIE_STEP3_INDEX 3

#define MDNIE_TRANS_DIMMING_DATA_INDEX	16

static char level_1_key_on[] = {
	0xF0,
	0x5A, 0x5A
};

static char level_1_key_off[] = {
	0xF0,
	0xA5, 0xA5
};

static char adjust_ldu_data_1[] = {
	0xff, 0xff, 0xff,
	0xf6, 0xfa, 0xff,
	0xf4, 0xf8, 0xff,
	0xe9, 0xf2, 0xff,
	0xe2, 0xef, 0xff,
	0xd4, 0xe8, 0xff,
};

static char adjust_ldu_data_2[] = {
	0xff, 0xfa, 0xf1,
	0xff, 0xfd, 0xf8,
	0xff, 0xfd, 0xfa,
	0xfa, 0xfd, 0xff,
	0xf5, 0xfb, 0xff,
	0xe5, 0xf3, 0xff,
};

static char *adjust_ldu_data[MAX_MODE] = {
	adjust_ldu_data_2,
	adjust_ldu_data_2,
	adjust_ldu_data_2,
	adjust_ldu_data_1,
	adjust_ldu_data_1,
};

static char night_mode_data[] = {
	0x00, 0xff, 0xf9, 0x00, 0xed, 0x00, 0xff, 0x00, 0x00, 0xf9, 0xed, 0x00, 0xff, 0x00, 0xf9, 0x00, 0x00, 0xed, 0xff, 0x00, 0xf9, 0x00, 0xed, 0x00, /* 6500K */
	0x00, 0xff, 0xf6, 0x00, 0xe5, 0x00, 0xff, 0x00, 0x00, 0xf6, 0xe5, 0x00, 0xff, 0x00, 0xf6, 0x00, 0x00, 0xe5, 0xff, 0x00, 0xf6, 0x00, 0xe5, 0x00, /* 6100K */
	0x00, 0xff, 0xf2, 0x00, 0xdb, 0x00, 0xff, 0x00, 0x00, 0xf2, 0xdb, 0x00, 0xff, 0x00, 0xf2, 0x00, 0x00, 0xdb, 0xff, 0x00, 0xf2, 0x00, 0xdb, 0x00, /* 5700K */
	0x00, 0xff, 0xee, 0x00, 0xd1, 0x00, 0xff, 0x00, 0x00, 0xee, 0xd1, 0x00, 0xff, 0x00, 0xee, 0x00, 0x00, 0xd1, 0xff, 0x00, 0xee, 0x00, 0xd1, 0x00, /* 5300K */
	0x00, 0xff, 0xea, 0x00, 0xc6, 0x00, 0xff, 0x00, 0x00, 0xea, 0xc6, 0x00, 0xff, 0x00, 0xea, 0x00, 0x00, 0xc6, 0xff, 0x00, 0xea, 0x00, 0xc6, 0x00, /* 4900K */
	0x00, 0xff, 0xe4, 0x00, 0xb7, 0x00, 0xff, 0x00, 0x00, 0xe4, 0xb7, 0x00, 0xff, 0x00, 0xe4, 0x00, 0x00, 0xb7, 0xff, 0x00, 0xe4, 0x00, 0xb7, 0x00, /* 4500K */
	0x00, 0xff, 0xde, 0x00, 0xa7, 0x00, 0xff, 0x00, 0x00, 0xde, 0xa7, 0x00, 0xff, 0x00, 0xde, 0x00, 0x00, 0xa7, 0xff, 0x00, 0xde, 0x00, 0xa7, 0x00, /* 4100K */
	0x00, 0xff, 0xd7, 0x00, 0x95, 0x00, 0xff, 0x00, 0x00, 0xd7, 0x95, 0x00, 0xff, 0x00, 0xd7, 0x00, 0x00, 0x95, 0xff, 0x00, 0xd7, 0x00, 0x95, 0x00, /* 3700K */
	0x00, 0xff, 0xce, 0x00, 0x82, 0x00, 0xff, 0x00, 0x00, 0xce, 0x82, 0x00, 0xff, 0x00, 0xce, 0x00, 0x00, 0x82, 0xff, 0x00, 0xce, 0x00, 0x82, 0x00, /* 3300K */
	0x00, 0xff, 0xc3, 0x00, 0x6d, 0x00, 0xff, 0x00, 0x00, 0xc3, 0x6d, 0x00, 0xff, 0x00, 0xc3, 0x00, 0x00, 0x6d, 0xff, 0x00, 0xc3, 0x00, 0x6d, 0x00, /* 2900K */
	0x00, 0xff, 0xb2, 0x00, 0x56, 0x00, 0xff, 0x00, 0x00, 0xb2, 0x56, 0x00, 0xff, 0x00, 0xb2, 0x00, 0x00, 0x56, 0xff, 0x00, 0xb2, 0x00, 0x56, 0x00, /* 2500K */
};

static char color_lens_data[] = {
	//Blue
	0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, 0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, 0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, 0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, 0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, 0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, 0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, 0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, 0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, 0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, 0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, 0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, 0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, 0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, 0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, 0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, /* 60% */

	//Azure
	0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, 0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, 0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, 0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, 0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, 0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, 0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, 0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, 0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, 0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, 0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, 0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, 0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, 0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, 0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, 0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, 0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, 0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, 0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, /* 60% */

	//Cyan
	0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, 0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, 0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, 0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, 0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, 0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, 0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, 0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, 0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, 0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, 0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, 0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, 0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, 0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, 0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, 0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, 0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, 0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, /* 60% */

	//Spring green
	0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, 0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, 0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, 0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, 0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, 0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, 0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, 0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, 0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, 0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, 0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, 0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, 0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, 0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, 0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, 0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, 0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, 0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, 0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, /* 60% */

	//Green
	0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, 0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, 0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, 0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, 0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, 0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, 0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, 0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, 0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, 0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, 0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, 0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, 0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, 0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, 0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, 0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, 0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Chartreuse Green
	0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, 0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, 0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, 0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, 0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, 0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, 0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, 0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, 0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, 0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, 0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, 0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, 0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, 0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, 0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, 0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, 0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, 0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, 0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Yellow
	0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, 0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, 0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, 0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, 0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, 0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, 0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, 0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, 0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, 0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, 0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, 0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, 0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, 0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, 0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, 0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, 0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, /* 60% */

	//Orange
	0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, 0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, 0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, 0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, 0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, 0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, 0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, 0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, 0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, 0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, 0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, 0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, 0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, 0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, 0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, 0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, 0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, 0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, 0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, /* 60% */

	//Red
	0x33, 0xff, 0xcc, 0x00, 0xcc, 0x00, 0xff, 0x33, 0x00, 0xcc, 0xcc, 0x00, 0xff, 0x33, 0xcc, 0x00, 0x00, 0xcc, 0xff, 0x33, 0xcc, 0x00, 0xcc, 0x00, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xbf, 0x00, 0xff, 0x40, 0x00, 0xbf, 0xbf, 0x00, 0xff, 0x40, 0xbf, 0x00, 0x00, 0xbf, 0xff, 0x40, 0xbf, 0x00, 0xbf, 0x00, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xb2, 0x00, 0xff, 0x4d, 0x00, 0xb2, 0xb2, 0x00, 0xff, 0x4d, 0xb2, 0x00, 0x00, 0xb2, 0xff, 0x4d, 0xb2, 0x00, 0xb2, 0x00, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xa6, 0x00, 0xff, 0x59, 0x00, 0xa6, 0xa6, 0x00, 0xff, 0x59, 0xa6, 0x00, 0x00, 0xa6, 0xff, 0x59, 0xa6, 0x00, 0xa6, 0x00, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0x99, 0x00, 0xff, 0x66, 0x00, 0x99, 0x99, 0x00, 0xff, 0x66, 0x99, 0x00, 0x00, 0x99, 0xff, 0x66, 0x99, 0x00, 0x99, 0x00, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0x8c, 0x00, 0xff, 0x73, 0x00, 0x8c, 0x8c, 0x00, 0xff, 0x73, 0x8c, 0x00, 0x00, 0x8c, 0xff, 0x73, 0x8c, 0x00, 0x8c, 0x00, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0x7f, 0x00, 0xff, 0x80, 0x00, 0x7f, 0x7f, 0x00, 0xff, 0x80, 0x7f, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x7f, 0x00, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0x73, 0x00, 0xff, 0x8c, 0x00, 0x73, 0x73, 0x00, 0xff, 0x8c, 0x73, 0x00, 0x00, 0x73, 0xff, 0x8c, 0x73, 0x00, 0x73, 0x00, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0x66, 0x00, 0xff, 0x99, 0x00, 0x66, 0x66, 0x00, 0xff, 0x99, 0x66, 0x00, 0x00, 0x66, 0xff, 0x99, 0x66, 0x00, 0x66, 0x00, /* 60% */

	//Rose
	0x33, 0xff, 0xcc, 0x00, 0xe5, 0x19, 0xff, 0x33, 0x00, 0xcc, 0xe5, 0x19, 0xff, 0x33, 0xcc, 0x00, 0x19, 0xe5, 0xff, 0x33, 0xcc, 0x00, 0xe5, 0x19, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xdf, 0x20, 0xff, 0x40, 0x00, 0xbf, 0xdf, 0x20, 0xff, 0x40, 0xbf, 0x00, 0x20, 0xdf, 0xff, 0x40, 0xbf, 0x00, 0xdf, 0x20, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xd8, 0x26, 0xff, 0x4d, 0x00, 0xb2, 0xd8, 0x26, 0xff, 0x4d, 0xb2, 0x00, 0x26, 0xd8, 0xff, 0x4d, 0xb2, 0x00, 0xd8, 0x26, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xd2, 0x2c, 0xff, 0x59, 0x00, 0xa6, 0xd2, 0x2c, 0xff, 0x59, 0xa6, 0x00, 0x2c, 0xd2, 0xff, 0x59, 0xa6, 0x00, 0xd2, 0x2c, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0xcc, 0x33, 0xff, 0x66, 0x00, 0x99, 0xcc, 0x33, 0xff, 0x66, 0x99, 0x00, 0x33, 0xcc, 0xff, 0x66, 0x99, 0x00, 0xcc, 0x33, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0xc5, 0x39, 0xff, 0x73, 0x00, 0x8c, 0xc5, 0x39, 0xff, 0x73, 0x8c, 0x00, 0x39, 0xc5, 0xff, 0x73, 0x8c, 0x00, 0xc5, 0x39, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0xbf, 0x40, 0xff, 0x80, 0x00, 0x7f, 0xbf, 0x40, 0xff, 0x80, 0x7f, 0x00, 0x40, 0xbf, 0xff, 0x80, 0x7f, 0x00, 0xbf, 0x40, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0xb9, 0x46, 0xff, 0x8c, 0x00, 0x73, 0xb9, 0x46, 0xff, 0x8c, 0x73, 0x00, 0x46, 0xb9, 0xff, 0x8c, 0x73, 0x00, 0xb9, 0x46, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0xb2, 0x4c, 0xff, 0x99, 0x00, 0x66, 0xb2, 0x4c, 0xff, 0x99, 0x66, 0x00, 0x4c, 0xb2, 0xff, 0x99, 0x66, 0x00, 0xb2, 0x4c, /* 60% */

	//Magenta
	0x33, 0xff, 0xcc, 0x00, 0xff, 0x33, 0xff, 0x33, 0x00, 0xcc, 0xff, 0x33, 0xff, 0x33, 0xcc, 0x00, 0x33, 0xff, 0xff, 0x33, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x40, 0xff, 0xbf, 0x00, 0xff, 0x40, 0xff, 0x40, 0x00, 0xbf, 0xff, 0x40, 0xff, 0x40, 0xbf, 0x00, 0x40, 0xff, 0xff, 0x40, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x4d, 0xff, 0xb2, 0x00, 0xff, 0x4d, 0xff, 0x4d, 0x00, 0xb2, 0xff, 0x4d, 0xff, 0x4d, 0xb2, 0x00, 0x4d, 0xff, 0xff, 0x4d, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x59, 0xff, 0xa6, 0x00, 0xff, 0x59, 0xff, 0x59, 0x00, 0xa6, 0xff, 0x59, 0xff, 0x59, 0xa6, 0x00, 0x59, 0xff, 0xff, 0x59, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x66, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0x66, 0x00, 0x99, 0xff, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0xff, 0xff, 0x66, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x73, 0xff, 0x8c, 0x00, 0xff, 0x73, 0xff, 0x73, 0x00, 0x8c, 0xff, 0x73, 0xff, 0x73, 0x8c, 0x00, 0x73, 0xff, 0xff, 0x73, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x80, 0xff, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x00, 0x80, 0xff, 0xff, 0x80, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x8c, 0xff, 0x73, 0x00, 0xff, 0x8c, 0xff, 0x8c, 0x00, 0x73, 0xff, 0x8c, 0xff, 0x8c, 0x73, 0x00, 0x8c, 0xff, 0xff, 0x8c, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x99, 0xff, 0x66, 0x00, 0xff, 0x99, 0xff, 0x99, 0x00, 0x66, 0xff, 0x99, 0xff, 0x99, 0x66, 0x00, 0x99, 0xff, 0xff, 0x99, 0x66, 0x00, 0xff, 0x99, /* 60% */

	//Violet
	0x19, 0xe5, 0xcc, 0x00, 0xff, 0x33, 0xe5, 0x19, 0x00, 0xcc, 0xff, 0x33, 0xe5, 0x19, 0xcc, 0x00, 0x33, 0xff, 0xe5, 0x19, 0xcc, 0x00, 0xff, 0x33, /* 20% */
	0x20, 0xdf, 0xbf, 0x00, 0xff, 0x40, 0xdf, 0x20, 0x00, 0xbf, 0xff, 0x40, 0xdf, 0x20, 0xbf, 0x00, 0x40, 0xff, 0xdf, 0x20, 0xbf, 0x00, 0xff, 0x40, /* 25% */
	0x26, 0xd8, 0xb2, 0x00, 0xff, 0x4d, 0xd8, 0x26, 0x00, 0xb2, 0xff, 0x4d, 0xd8, 0x26, 0xb2, 0x00, 0x4d, 0xff, 0xd8, 0x26, 0xb2, 0x00, 0xff, 0x4d, /* 30% */
	0x2c, 0xd2, 0xa6, 0x00, 0xff, 0x59, 0xd2, 0x2c, 0x00, 0xa6, 0xff, 0x59, 0xd2, 0x2c, 0xa6, 0x00, 0x59, 0xff, 0xd2, 0x2c, 0xa6, 0x00, 0xff, 0x59, /* 35% */
	0x33, 0xcc, 0x99, 0x00, 0xff, 0x66, 0xcc, 0x33, 0x00, 0x99, 0xff, 0x66, 0xcc, 0x33, 0x99, 0x00, 0x66, 0xff, 0xcc, 0x33, 0x99, 0x00, 0xff, 0x66, /* 40% */
	0x39, 0xc5, 0x8c, 0x00, 0xff, 0x73, 0xc5, 0x39, 0x00, 0x8c, 0xff, 0x73, 0xc5, 0x39, 0x8c, 0x00, 0x73, 0xff, 0xc5, 0x39, 0x8c, 0x00, 0xff, 0x73, /* 45% */
	0x40, 0xbf, 0x7f, 0x00, 0xff, 0x80, 0xbf, 0x40, 0x00, 0x7f, 0xff, 0x80, 0xbf, 0x40, 0x7f, 0x00, 0x80, 0xff, 0xbf, 0x40, 0x7f, 0x00, 0xff, 0x80, /* 50% */
	0x46, 0xb9, 0x73, 0x00, 0xff, 0x8c, 0xb9, 0x46, 0x00, 0x73, 0xff, 0x8c, 0xb9, 0x46, 0x73, 0x00, 0x8c, 0xff, 0xb9, 0x46, 0x73, 0x00, 0xff, 0x8c, /* 55% */
	0x4c, 0xb2, 0x66, 0x00, 0xff, 0x99, 0xb2, 0x4c, 0x00, 0x66, 0xff, 0x99, 0xb2, 0x4c, 0x66, 0x00, 0x99, 0xff, 0xb2, 0x4c, 0x66, 0x00, 0xff, 0x99, /* 60% */
};

static char DSI0_BYPASS_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_BYPASS_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_BYPASS_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0x00, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_NEGATIVE_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0x00, //ascr_Wr
	0xff, //ascr_Kr
	0x00, //ascr_Wg
	0xff, //ascr_Kg
	0x00, //ascr_Wb
	0xff, //ascr_Kb
};

static char DSI0_NEGATIVE_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_NEGATIVE_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GRAYSCALE_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0x4c, //ascr_skin_Rr
	0x4c, //ascr_skin_Rg
	0x4c, //ascr_skin_Rb
	0xe2, //ascr_skin_Yr
	0xe2, //ascr_skin_Yg
	0xe2, //ascr_skin_Yb
	0x69, //ascr_skin_Mr
	0x69, //ascr_skin_Mg
	0x69, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0xb3, //ascr_Cr
	0x4c, //ascr_Rr
	0xb3, //ascr_Cg
	0x4c, //ascr_Rg
	0xb3, //ascr_Cb
	0x4c, //ascr_Rb
	0x69, //ascr_Mr
	0x96, //ascr_Gr
	0x69, //ascr_Mg
	0x96, //ascr_Gg
	0x69, //ascr_Mb
	0x96, //ascr_Gb
	0xe2, //ascr_Yr
	0x1d, //ascr_Br
	0xe2, //ascr_Yg
	0x1d, //ascr_Bg
	0xe2, //ascr_Yb
	0x1d, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};
static char DSI0_GRAYSCALE_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GRAYSCALE_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0x4c, //ascr_skin_Rr
	0x4c, //ascr_skin_Rg
	0x4c, //ascr_skin_Rb
	0xe2, //ascr_skin_Yr
	0xe2, //ascr_skin_Yg
	0xe2, //ascr_skin_Yb
	0x69, //ascr_skin_Mr
	0x69, //ascr_skin_Mg
	0x69, //ascr_skin_Mb
	0x00, //ascr_skin_Wr
	0x00, //ascr_skin_Wg
	0x00, //ascr_skin_Wb
	0xb3, //ascr_Cr
	0x4c, //ascr_Rr
	0xb3, //ascr_Cg
	0x4c, //ascr_Rg
	0xb3, //ascr_Cb
	0x4c, //ascr_Rb
	0x69, //ascr_Mr
	0x96, //ascr_Gr
	0x69, //ascr_Mg
	0x96, //ascr_Gg
	0x69, //ascr_Mb
	0x96, //ascr_Gb
	0xe2, //ascr_Yr
	0x1d, //ascr_Br
	0xe2, //ascr_Yg
	0x1d, //ascr_Bg
	0xe2, //ascr_Yb
	0x1d, //ascr_Bb
	0x00, //ascr_Wr
	0xff, //ascr_Kr
	0x00, //ascr_Wg
	0xff, //ascr_Kg
	0x00, //ascr_Wb
	0xff, //ascr_Kb
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_COLOR_BLIND_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_COLOR_BLIND_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_COLOR_BLIND_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_COLOR_LENS_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_COLOR_LENS_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_COLOR_LENS_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x60, //ascr_skin_Rg
	0x13, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf9, //ascr_skin_Yg
	0x13, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x60, //ascr_skin_Mg
	0xac, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf9, //ascr_skin_Wg
	0xac, //ascr_skin_Wb
	0x66, //ascr_Cr
	0xff, //ascr_Rr
	0xf9, //ascr_Cg
	0x60, //ascr_Rg
	0xac, //ascr_Cb
	0x13, //ascr_Rb
	0xff, //ascr_Mr
	0x66, //ascr_Gr
	0x60, //ascr_Mg
	0xf9, //ascr_Gg
	0xac, //ascr_Mb
	0x13, //ascr_Gb
	0xff, //ascr_Yr
	0x66, //ascr_Br
	0xf9, //ascr_Yg
	0x60, //ascr_Bg
	0x13, //ascr_Yb
	0xac, //ascr_Bb
	0xff, //ascr_Wr
	0x66, //ascr_Kr
	0xf9, //ascr_Wg
	0x60, //ascr_Kg
	0xac, //ascr_Wb
	0x13, //ascr_Kb
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_NIGHT_MODE_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_NIGHT_MODE_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_NIGHT_MODE_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_HBM_CE_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_HBM_CE_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x18, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x01, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0 
	0x08, //gamma_x_1 
	0x10, //gamma_x_2 
	0x18, //gamma_x_3 
	0x20, //gamma_x_4 
	0x28, //gamma_x_5 
	0x30, //gamma_x_6 
	0x38, //gamma_x_7 
	0x40, //gamma_x_8 
	0x48, //gamma_x_9 
	0x50, //gamma_x_10 
	0x58, //gamma_x_11 
	0x60, //gamma_x_12 
	0x68, //gamma_x_13 
	0x70, //gamma_x_14 
	0x78, //gamma_x_15 
	0x80, //gamma_x_16 
	0x88, //gamma_x_17 
	0x90, //gamma_x_18 
	0x98, //gamma_x_19 
	0xa0, //gamma_x_20 
	0xa8, //gamma_x_21 
	0xb0, //gamma_x_22 
	0xb8, //gamma_x_23 
	0xc0, //gamma_x_24 
	0xc8, //gamma_x_25 
	0xd0, //gamma_x_26 
	0xd8, //gamma_x_27 
	0xe0, //gamma_x_28 
	0xe8, //gamma_x_29 
	0xf0, //gamma_x_30 
	0xf8, //gamma_x_31 
	0x01, //gamma_x_32 
	0x00,
	0x00, //gamma_y_0 
	0x0f, //gamma_y_1 
	0x1a, //gamma_y_2 
	0x25, //gamma_y_3 
	0x2f, //gamma_y_4 
	0x38, //gamma_y_5 
	0x41, //gamma_y_6 
	0x4a, //gamma_y_7 
	0x52, //gamma_y_8 
	0x5b, //gamma_y_9 
	0x63, //gamma_y_10 
	0x6b, //gamma_y_11 
	0x73, //gamma_y_12 
	0x7a, //gamma_y_13 
	0x82, //gamma_y_14 
	0x8a, //gamma_y_15 
	0x91, //gamma_y_16 
	0x98, //gamma_y_17 
	0xa0, //gamma_y_18 
	0xa7, //gamma_y_19 
	0xae, //gamma_y_20 
	0xb5, //gamma_y_21 
	0xbc, //gamma_y_22 
	0xc3, //gamma_y_23 
	0xca, //gamma_y_24 
	0xd1, //gamma_y_25 
	0xd8, //gamma_y_26 
	0xdf, //gamma_y_27 
	0xe5, //gamma_y_28 
	0xec, //gamma_y_29 
	0xf3, //gamma_y_30 
	0xf9, //gamma_y_31 
	0x01, //gamma_y_32 
	0x00,
};

static char DSI0_HBM_CE_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xfc, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_SCREEN_CURTAIN_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0x00, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0x00, //ascr_skin_Yr
	0x00, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0x00, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0x00, //ascr_skin_Mb
	0x00, //ascr_skin_Wr
	0x00, //ascr_skin_Wg
	0x00, //ascr_skin_Wb
	0x00, //ascr_Cr
	0x00, //ascr_Rr
	0x00, //ascr_Cg
	0x00, //ascr_Rg
	0x00, //ascr_Cb
	0x00, //ascr_Rb
	0x00, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0x00, //ascr_Gg
	0x00, //ascr_Mb
	0x00, //ascr_Gb
	0x00, //ascr_Yr
	0x00, //ascr_Br
	0x00, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0x00, //ascr_Bb
	0x00, //ascr_Wr
	0x00, //ascr_Kr
	0x00, //ascr_Wg
	0x00, //ascr_Kg
	0x00, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_SCREEN_CURTAIN_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_SCREEN_CURTAIN_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_RGB_SENSOR_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x0c, //ascr_dist_up
	0x0c, //ascr_dist_down
	0x0c, //ascr_dist_right
	0x0c, //ascr_dist_left
	0x00, //ascr_div_up 20
	0xaa,
	0xab,
	0x00, //ascr_div_down
	0xaa,
	0xab,
	0x00, //ascr_div_right
	0xaa,
	0xab,
	0x00, //ascr_div_left
	0xaa,
	0xab,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_RGB_SENSOR_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_RGB_SENSOR_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xc0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_UI_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xe2, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xf3, //ascr_skin_Yr
	0xe9, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xee, //ascr_skin_Mr
	0x0f, //ascr_skin_Mg
	0xe8, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x5b, //ascr_Cr
	0xe2, //ascr_Rr
	0xf4, //ascr_Cg
	0x00, //ascr_Rg
	0xec, //ascr_Cb
	0x00, //ascr_Rb
	0xee, //ascr_Mr
	0x51, //ascr_Gr
	0x0f, //ascr_Mg
	0xe6, //ascr_Gg
	0xe8, //ascr_Mb
	0x00, //ascr_Gb
	0xf3, //ascr_Yr
	0x25, //ascr_Br
	0xe9, //ascr_Yg
	0x31, //ascr_Bg
	0x00, //ascr_Yb
	0xe5, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_UI_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_UI_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_UI_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xf3, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x2b, //ascr_skin_Rb
	0xf4, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x3e, //ascr_skin_Yb
	0xfd, //ascr_skin_Mr
	0x3c, //ascr_skin_Mg
	0xe7, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xf3, //ascr_Rr
	0xeb, //ascr_Cg
	0x2a, //ascr_Rg
	0xe9, //ascr_Cb
	0x2b, //ascr_Rb
	0xfd, //ascr_Mr
	0x00, //ascr_Gr
	0x3c, //ascr_Mg
	0xe1, //ascr_Gg
	0xe7, //ascr_Mb
	0x2e, //ascr_Gb
	0xf4, //ascr_Yr
	0x24, //ascr_Br
	0xeb, //ascr_Yg
	0x30, //ascr_Bg
	0x3e, //ascr_Yb
	0xe0, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_UI_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x02, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_UI_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_UI_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xd7, //ascr_skin_Rr
	0x24, //ascr_skin_Rg
	0x25, //ascr_skin_Rb
	0xf5, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x51, //ascr_skin_Yb
	0xdd, //ascr_skin_Mr
	0x3b, //ascr_skin_Mg
	0xe1, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x8f, //ascr_Cr
	0xd7, //ascr_Rr
	0xf0, //ascr_Cg
	0x24, //ascr_Rg
	0xea, //ascr_Cb
	0x25, //ascr_Rb
	0xdd, //ascr_Mr
	0x89, //ascr_Gr
	0x3b, //ascr_Mg
	0xe6, //ascr_Gg
	0xe1, //ascr_Mb
	0x49, //ascr_Gb
	0xf5, //ascr_Yr
	0x26, //ascr_Br
	0xeb, //ascr_Yg
	0x2f, //ascr_Bg
	0x51, //ascr_Yb
	0xdd, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_UI_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_UI_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_UI_AUTO_MDNIE_1[] = {
	0xDF,
	0x00, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x37, //ascr_dist_up
	0x29, //ascr_dist_down
	0x19, //ascr_dist_right
	0x47, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x25,
	0x3d,
	0x00, //ascr_div_down
	0x31,
	0xf4,
	0x00, //ascr_div_right
	0x51,
	0xec,
	0x00, //ascr_div_left
	0x1c,
	0xd8,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_UI_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_UI_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xe2, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xf3, //ascr_skin_Yr
	0xe9, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xee, //ascr_skin_Mr
	0x0f, //ascr_skin_Mg
	0xe8, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x5b, //ascr_Cr
	0xe2, //ascr_Rr
	0xf4, //ascr_Cg
	0x00, //ascr_Rg
	0xec, //ascr_Cb
	0x00, //ascr_Rb
	0xee, //ascr_Mr
	0x51, //ascr_Gr
	0x0f, //ascr_Mg
	0xe6, //ascr_Gg
	0xe8, //ascr_Mb
	0x00, //ascr_Gb
	0xf3, //ascr_Yr
	0x25, //ascr_Br
	0xe9, //ascr_Yg
	0x31, //ascr_Bg
	0x00, //ascr_Yb
	0xe5, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_VIDEO_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xf3, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x2b, //ascr_skin_Rb
	0xf4, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x3e, //ascr_skin_Yb
	0xfd, //ascr_skin_Mr
	0x3c, //ascr_skin_Mg
	0xe7, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xf3, //ascr_Rr
	0xeb, //ascr_Cg
	0x2a, //ascr_Rg
	0xe9, //ascr_Cb
	0x2b, //ascr_Rb
	0xfd, //ascr_Mr
	0x00, //ascr_Gr
	0x3c, //ascr_Mg
	0xe1, //ascr_Gg
	0xe7, //ascr_Mb
	0x2e, //ascr_Gb
	0xf4, //ascr_Yr
	0x24, //ascr_Br
	0xeb, //ascr_Yg
	0x30, //ascr_Bg
	0x3e, //ascr_Yb
	0xe0, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_VIDEO_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x02, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_VIDEO_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_VIDEO_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xd7, //ascr_skin_Rr
	0x24, //ascr_skin_Rg
	0x25, //ascr_skin_Rb
	0xf5, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x51, //ascr_skin_Yb
	0xdd, //ascr_skin_Mr
	0x3b, //ascr_skin_Mg
	0xe1, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x8f, //ascr_Cr
	0xd7, //ascr_Rr
	0xf0, //ascr_Cg
	0x24, //ascr_Rg
	0xea, //ascr_Cb
	0x25, //ascr_Rb
	0xdd, //ascr_Mr
	0x89, //ascr_Gr
	0x3b, //ascr_Mg
	0xe6, //ascr_Gg
	0xe1, //ascr_Mb
	0x49, //ascr_Gb
	0xf5, //ascr_Yr
	0x26, //ascr_Br
	0xeb, //ascr_Yg
	0x2f, //ascr_Bg
	0x51, //ascr_Yb
	0xdd, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_VIDEO_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_VIDEO_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_VIDEO_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x67, //ascr_skin_cb
	0xa9, //ascr_skin_cr
	0x37, //ascr_dist_up
	0x29, //ascr_dist_down
	0x19, //ascr_dist_right
	0x47, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x25,
	0x3d,
	0x00, //ascr_div_down
	0x31,
	0xf4,
	0x00, //ascr_div_right
	0x51,
	0xec,
	0x00, //ascr_div_left
	0x1c,
	0xd8,
	0xff, //ascr_skin_Rr
	0x68, //ascr_skin_Rg
	0x86, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf4, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_VIDEO_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x0f, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x28,
	0x00, //de_maxplus 11
	0x40,
	0x00, //de_maxminus 11
	0x40,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x01,
	0x00, //fa_step_n 10
	0x01,
	0x00, //fa_max_de_gain 10
	0x28,
	0x00, //fa_pcl_ppi 14
	0x01,
	0x28, //fa_os_cnt_10_co
	0x3c, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x05, //gamma_y_1
	0x0a, //gamma_y_2
	0x10, //gamma_y_3
	0x17, //gamma_y_4
	0x1e, //gamma_y_5
	0x26, //gamma_y_6
	0x2e, //gamma_y_7
	0x36, //gamma_y_8
	0x3f, //gamma_y_9
	0x49, //gamma_y_10
	0x52, //gamma_y_11
	0x5c, //gamma_y_12
	0x65, //gamma_y_13
	0x6f, //gamma_y_14
	0x78, //gamma_y_15
	0x82, //gamma_y_16
	0x8b, //gamma_y_17
	0x95, //gamma_y_18
	0x9e, //gamma_y_19
	0xa8, //gamma_y_20
	0xb1, //gamma_y_21
	0xbb, //gamma_y_22
	0xc3, //gamma_y_23
	0xcb, //gamma_y_24
	0xd3, //gamma_y_25
	0xdb, //gamma_y_26
	0xe3, //gamma_y_27
	0xeb, //gamma_y_28
	0xf1, //gamma_y_29
	0xf8, //gamma_y_30
	0xfc, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_VIDEO_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xe2, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xf3, //ascr_skin_Yr
	0xe9, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xee, //ascr_skin_Mr
	0x0f, //ascr_skin_Mg
	0xe8, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x5b, //ascr_Cr
	0xe2, //ascr_Rr
	0xf4, //ascr_Cg
	0x00, //ascr_Rg
	0xec, //ascr_Cb
	0x00, //ascr_Rb
	0xee, //ascr_Mr
	0x51, //ascr_Gr
	0x0f, //ascr_Mg
	0xe6, //ascr_Gg
	0xe8, //ascr_Mb
	0x00, //ascr_Gb
	0xf3, //ascr_Yr
	0x25, //ascr_Br
	0xe9, //ascr_Yg
	0x31, //ascr_Bg
	0x00, //ascr_Yb
	0xe5, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_CAMERA_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xf3, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x2b, //ascr_skin_Rb
	0xf4, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x3e, //ascr_skin_Yb
	0xfd, //ascr_skin_Mr
	0x3c, //ascr_skin_Mg
	0xe7, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xf3, //ascr_Rr
	0xeb, //ascr_Cg
	0x2a, //ascr_Rg
	0xe9, //ascr_Cb
	0x2b, //ascr_Rb
	0xfd, //ascr_Mr
	0x00, //ascr_Gr
	0x3c, //ascr_Mg
	0xe1, //ascr_Gg
	0xe7, //ascr_Mb
	0x2e, //ascr_Gb
	0xf4, //ascr_Yr
	0x24, //ascr_Br
	0xeb, //ascr_Yg
	0x30, //ascr_Bg
	0x3e, //ascr_Yb
	0xe0, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_CAMERA_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x02, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_CAMERA_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_CAMERA_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xd7, //ascr_skin_Rr
	0x24, //ascr_skin_Rg
	0x25, //ascr_skin_Rb
	0xf5, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x51, //ascr_skin_Yb
	0xdd, //ascr_skin_Mr
	0x3b, //ascr_skin_Mg
	0xe1, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x8f, //ascr_Cr
	0xd7, //ascr_Rr
	0xf0, //ascr_Cg
	0x24, //ascr_Rg
	0xea, //ascr_Cb
	0x25, //ascr_Rb
	0xdd, //ascr_Mr
	0x89, //ascr_Gr
	0x3b, //ascr_Mg
	0xe6, //ascr_Gg
	0xe1, //ascr_Mb
	0x49, //ascr_Gb
	0xf5, //ascr_Yr
	0x26, //ascr_Br
	0xeb, //ascr_Yg
	0x2f, //ascr_Bg
	0x51, //ascr_Yb
	0xdd, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_CAMERA_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_CAMERA_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_CAMERA_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x3c, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf0, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xd8, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xd9, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xe0, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xf6, //ascr_Cb
	0x00, //ascr_Rb
	0xd8, //ascr_Mr
	0x3b, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xd9, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x14, //ascr_Br
	0xf9, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_CAMERA_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x0c, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x28,
	0x00, //de_maxplus 11
	0xa0,
	0x00, //de_maxminus 11
	0xa0,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x01,
	0x00, //fa_step_n 10
	0x01,
	0x00, //fa_max_de_gain 10
	0x28,
	0x00, //fa_pcl_ppi 14
	0x01,
	0x28, //fa_os_cnt_10_co
	0x3c, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_CAMERA_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_CAMERA_SWA_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x3c, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf0, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xd8, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xd9, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xe0, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xf6, //ascr_Cb
	0x00, //ascr_Rb
	0xd8, //ascr_Mr
	0x3b, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xd9, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x14, //ascr_Br
	0xf9, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xf4, //ascr_Wr
	0x00, //ascr_Kr
	0xf2, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_CAMERA_SWA_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x0c, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x28,
	0x00, //de_maxplus 11
	0xa0,
	0x00, //de_maxminus 11
	0xa0,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x01,
	0x00, //fa_step_n 10
	0x01,
	0x00, //fa_max_de_gain 10
	0x28,
	0x00, //fa_pcl_ppi 14
	0x01,
	0x28, //fa_os_cnt_10_co
	0x3c, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_CAMERA_SWA_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GALLERY_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xe2, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xf3, //ascr_skin_Yr
	0xe9, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xee, //ascr_skin_Mr
	0x0f, //ascr_skin_Mg
	0xe8, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x5b, //ascr_Cr
	0xe2, //ascr_Rr
	0xf4, //ascr_Cg
	0x00, //ascr_Rg
	0xec, //ascr_Cb
	0x00, //ascr_Rb
	0xee, //ascr_Mr
	0x51, //ascr_Gr
	0x0f, //ascr_Mg
	0xe6, //ascr_Gg
	0xe8, //ascr_Mb
	0x00, //ascr_Gb
	0xf3, //ascr_Yr
	0x25, //ascr_Br
	0xe9, //ascr_Yg
	0x31, //ascr_Bg
	0x00, //ascr_Yb
	0xe5, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_GALLERY_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GALLERY_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GALLERY_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xf3, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x2b, //ascr_skin_Rb
	0xf4, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x3e, //ascr_skin_Yb
	0xfd, //ascr_skin_Mr
	0x3c, //ascr_skin_Mg
	0xe7, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xf3, //ascr_Rr
	0xeb, //ascr_Cg
	0x2a, //ascr_Rg
	0xe9, //ascr_Cb
	0x2b, //ascr_Rb
	0xfd, //ascr_Mr
	0x00, //ascr_Gr
	0x3c, //ascr_Mg
	0xe1, //ascr_Gg
	0xe7, //ascr_Mb
	0x2e, //ascr_Gb
	0xf4, //ascr_Yr
	0x24, //ascr_Br
	0xeb, //ascr_Yg
	0x30, //ascr_Bg
	0x3e, //ascr_Yb
	0xe0, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_GALLERY_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x02, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GALLERY_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GALLERY_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xd7, //ascr_skin_Rr
	0x24, //ascr_skin_Rg
	0x25, //ascr_skin_Rb
	0xf5, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x51, //ascr_skin_Yb
	0xdd, //ascr_skin_Mr
	0x3b, //ascr_skin_Mg
	0xe1, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x8f, //ascr_Cr
	0xd7, //ascr_Rr
	0xf0, //ascr_Cg
	0x24, //ascr_Rg
	0xea, //ascr_Cb
	0x25, //ascr_Rb
	0xdd, //ascr_Mr
	0x89, //ascr_Gr
	0x3b, //ascr_Mg
	0xe6, //ascr_Gg
	0xe1, //ascr_Mb
	0x49, //ascr_Gb
	0xf5, //ascr_Yr
	0x26, //ascr_Br
	0xeb, //ascr_Yg
	0x2f, //ascr_Bg
	0x51, //ascr_Yb
	0xdd, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_GALLERY_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GALLERY_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GALLERY_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x3c, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf0, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xd8, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xd9, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xe0, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xf6, //ascr_Cb
	0x00, //ascr_Rb
	0xd8, //ascr_Mr
	0x3b, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xd9, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x14, //ascr_Br
	0xf9, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_GALLERY_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x0c, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x28,
	0x00, //de_maxplus 11
	0xa0,
	0x00, //de_maxminus 11
	0xa0,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x01,
	0x00, //fa_step_n 10
	0x01,
	0x00, //fa_max_de_gain 10
	0x28,
	0x00, //fa_pcl_ppi 14
	0x01,
	0x28, //fa_os_cnt_10_co
	0x3c, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GALLERY_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_GALLERY_SWA_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x3c, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf0, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xd8, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xd9, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xe0, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xf6, //ascr_Cb
	0x00, //ascr_Rb
	0xd8, //ascr_Mr
	0x3b, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xd9, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x14, //ascr_Br
	0xf9, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_GALLERY_SWA_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x0c, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x28,
	0x00, //de_maxplus 11
	0xa0,
	0x00, //de_maxminus 11
	0xa0,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x01,
	0x00, //fa_step_n 10
	0x01,
	0x00, //fa_max_de_gain 10
	0x28,
	0x00, //fa_pcl_ppi 14
	0x01,
	0x28, //fa_os_cnt_10_co
	0x3c, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x00,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_GALLERY_SWA_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xe2, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xf3, //ascr_skin_Yr
	0xe9, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xee, //ascr_skin_Mr
	0x0f, //ascr_skin_Mg
	0xe8, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x5b, //ascr_Cr
	0xe2, //ascr_Rr
	0xf4, //ascr_Cg
	0x00, //ascr_Rg
	0xec, //ascr_Cb
	0x00, //ascr_Rb
	0xee, //ascr_Mr
	0x51, //ascr_Gr
	0x0f, //ascr_Mg
	0xe6, //ascr_Gg
	0xe8, //ascr_Mb
	0x00, //ascr_Gb
	0xf3, //ascr_Yr
	0x25, //ascr_Br
	0xe9, //ascr_Yg
	0x31, //ascr_Bg
	0x00, //ascr_Yb
	0xe5, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_BROWSER_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xf3, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x2b, //ascr_skin_Rb
	0xf4, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x3e, //ascr_skin_Yb
	0xfd, //ascr_skin_Mr
	0x3c, //ascr_skin_Mg
	0xe7, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xf3, //ascr_Rr
	0xeb, //ascr_Cg
	0x2a, //ascr_Rg
	0xe9, //ascr_Cb
	0x2b, //ascr_Rb
	0xfd, //ascr_Mr
	0x00, //ascr_Gr
	0x3c, //ascr_Mg
	0xe1, //ascr_Gg
	0xe7, //ascr_Mb
	0x2e, //ascr_Gb
	0xf4, //ascr_Yr
	0x24, //ascr_Br
	0xeb, //ascr_Yg
	0x30, //ascr_Bg
	0x3e, //ascr_Yb
	0xe0, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_BROWSER_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x02, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_BROWSER_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_BROWSER_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xd7, //ascr_skin_Rr
	0x24, //ascr_skin_Rg
	0x25, //ascr_skin_Rb
	0xf5, //ascr_skin_Yr
	0xeb, //ascr_skin_Yg
	0x51, //ascr_skin_Yb
	0xdd, //ascr_skin_Mr
	0x3b, //ascr_skin_Mg
	0xe1, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf7, //ascr_skin_Wg
	0xef, //ascr_skin_Wb
	0x8f, //ascr_Cr
	0xd7, //ascr_Rr
	0xf0, //ascr_Cg
	0x24, //ascr_Rg
	0xea, //ascr_Cb
	0x25, //ascr_Rb
	0xdd, //ascr_Mr
	0x89, //ascr_Gr
	0x3b, //ascr_Mg
	0xe6, //ascr_Gg
	0xe1, //ascr_Mb
	0x49, //ascr_Gb
	0xf5, //ascr_Yr
	0x26, //ascr_Br
	0xeb, //ascr_Yg
	0x2f, //ascr_Bg
	0x51, //ascr_Yb
	0xdd, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf7, //ascr_Wg
	0x00, //ascr_Kg
	0xef, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_BROWSER_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_BROWSER_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_BROWSER_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x2a, //ascr_skin_Rg
	0x3c, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xf0, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xd8, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xd9, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xff, //ascr_skin_Wg
	0xff, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xe0, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xf6, //ascr_Cb
	0x00, //ascr_Rb
	0xd8, //ascr_Mr
	0x3b, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xd9, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x14, //ascr_Br
	0xf9, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xff, //ascr_Wg
	0x00, //ascr_Kg
	0xff, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_BROWSER_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_BROWSER_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_EBOOK_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf6, //ascr_skin_Wg
	0xe6, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf6, //ascr_Wg
	0x00, //ascr_Kg
	0xe6, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_EBOOK_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_EBOOK_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static char DSI0_EMAIL_AUTO_MDNIE_1[] = {
	0xDF,
	0x01, //linear_on ascr_skin_on 0000 0000
	0x6a, //ascr_skin_cb
	0x9a, //ascr_skin_cr
	0x25, //ascr_dist_up
	0x1a, //ascr_dist_down
	0x16, //ascr_dist_right
	0x2a, //ascr_dist_left
	0x00, //ascr_div_up 20
	0x37,
	0x5a,
	0x00, //ascr_div_down
	0x4e,
	0xc5,
	0x00, //ascr_div_right
	0x5d,
	0x17,
	0x00, //ascr_div_left
	0x30,
	0xc3,
	0xff, //ascr_skin_Rr
	0x00, //ascr_skin_Rg
	0x00, //ascr_skin_Rb
	0xff, //ascr_skin_Yr
	0xff, //ascr_skin_Yg
	0x00, //ascr_skin_Yb
	0xff, //ascr_skin_Mr
	0x00, //ascr_skin_Mg
	0xff, //ascr_skin_Mb
	0xff, //ascr_skin_Wr
	0xf5, //ascr_skin_Wg
	0xe4, //ascr_skin_Wb
	0x00, //ascr_Cr
	0xff, //ascr_Rr
	0xff, //ascr_Cg
	0x00, //ascr_Rg
	0xff, //ascr_Cb
	0x00, //ascr_Rb
	0xff, //ascr_Mr
	0x00, //ascr_Gr
	0x00, //ascr_Mg
	0xff, //ascr_Gg
	0xff, //ascr_Mb
	0x00, //ascr_Gb
	0xff, //ascr_Yr
	0x00, //ascr_Br
	0xff, //ascr_Yg
	0x00, //ascr_Bg
	0x00, //ascr_Yb
	0xff, //ascr_Bb
	0xff, //ascr_Wr
	0x00, //ascr_Kr
	0xf5, //ascr_Wg
	0x00, //ascr_Kg
	0xe4, //ascr_Wb
	0x00, //ascr_Kb
};

static char DSI0_EMAIL_AUTO_MDNIE_2[] = {
	0xDE,
	0x00, //gamut_gamma_on gamut_blk_shift 0000 0000
	0x40, //gamut_scale
	0x04, //gamut_r1
	0x00,
	0x00, //gamut_r2
	0x00,
	0x00, //gamut_r3
	0x00,
	0x00, //gamut_g1
	0x00,
	0x04, //gamut_g2
	0x00,
	0x00, //gamut_g3
	0x00,
	0x00, //gamut_b1
	0x00,
	0x00, //gamut_b2
	0x00,
	0x04, //gamut_b3
	0x00,
	0x06, //ove_SLCE_gain 0 00 0000
	0x0c, //ove_color_gain 00 0000
	0x00, //ove_min_ref_offset
	0x96,
	0xf0, //ove_illum_gain
	0x01, //ove_ref_offset 9
	0x0e,
	0x01, //ove_ref_gain 9
	0x00,
	0x66, //ove_block_size h v 000 000
	0x00, //ove_dark_th 000
	0x17, //ove_black reduct_slope 0000 0
	0x00, //nr fa de cs gamma 0 0000
	0xff, //nr_mask_th
	0x00, //de_gain 10
	0x00,
	0x07, //de_maxplus 11
	0xff,
	0x07, //de_maxminus 11
	0xff,
	0x14, //fa_edge_th
	0x00, //fa_step_p 10
	0x02,
	0x00, //fa_step_n 10
	0x02,
	0x01, //fa_max_de_gain 10
	0xf4,
	0x08, //fa_pcl_ppi 14
	0x8a,
	0x20, //fa_os_cnt_10_co
	0x2d, //fa_os_cnt_20_co
	0x04, //fa_edge_cnt
	0x0f, //fa_AVG_y_cnt
	0x01, //cs_gain 10
	0x20,
	0x00, //gamma_x_0
	0x08, //gamma_x_1
	0x10, //gamma_x_2
	0x18, //gamma_x_3
	0x20, //gamma_x_4
	0x28, //gamma_x_5
	0x30, //gamma_x_6
	0x38, //gamma_x_7
	0x40, //gamma_x_8
	0x48, //gamma_x_9
	0x50, //gamma_x_10
	0x58, //gamma_x_11
	0x60, //gamma_x_12
	0x68, //gamma_x_13
	0x70, //gamma_x_14
	0x78, //gamma_x_15
	0x80, //gamma_x_16
	0x88, //gamma_x_17
	0x90, //gamma_x_18
	0x98, //gamma_x_19
	0xa0, //gamma_x_20
	0xa8, //gamma_x_21
	0xb0, //gamma_x_22
	0xb8, //gamma_x_23
	0xc0, //gamma_x_24
	0xc8, //gamma_x_25
	0xd0, //gamma_x_26
	0xd8, //gamma_x_27
	0xe0, //gamma_x_28
	0xe8, //gamma_x_29
	0xf0, //gamma_x_30
	0xf8, //gamma_x_31
	0x01, //gamma_x_32
	0x00,
	0x00, //gamma_y_0
	0x08, //gamma_y_1
	0x10, //gamma_y_2
	0x18, //gamma_y_3
	0x20, //gamma_y_4
	0x28, //gamma_y_5
	0x30, //gamma_y_6
	0x38, //gamma_y_7
	0x40, //gamma_y_8
	0x48, //gamma_y_9
	0x50, //gamma_y_10
	0x58, //gamma_y_11
	0x60, //gamma_y_12
	0x68, //gamma_y_13
	0x70, //gamma_y_14
	0x78, //gamma_y_15
	0x80, //gamma_y_16
	0x88, //gamma_y_17
	0x90, //gamma_y_18
	0x98, //gamma_y_19
	0xa0, //gamma_y_20
	0xa8, //gamma_y_21
	0xb0, //gamma_y_22
	0xb8, //gamma_y_23
	0xc0, //gamma_y_24
	0xc8, //gamma_y_25
	0xd0, //gamma_y_26
	0xd8, //gamma_y_27
	0xe0, //gamma_y_28
	0xe8, //gamma_y_29
	0xf0, //gamma_y_30
	0xf8, //gamma_y_31
	0x01, //gamma_y_32
	0x00,
};

static char DSI0_EMAIL_AUTO_MDNIE_3[] = {
	0xDD,
	0x01, //mdnie_en
	0x00, //mask 00 0000
	0xf0, //ascr algo aolce gamut 00 00 00 00
	0x00, //v_partial_on 000
	0x7f, //partial_en ascr_cc_cs_de_nr_lce_gamut
	0x00, //roi_en
	0x00, //roi_block
	0x00, //roi_sx
	0x00, //roi_sx
	0x00, //roi_sy
	0x00, //roi_sy
	0x00, //roi_ex
	0x00, //roi_ex
	0x00, //roi_ey
	0x00, //roi_ey
	0xff, //trans_on trans_block 000 0000
	0x04, //trans_slope
	0x01, //trans_interval
};

static struct dsi_cmd_desc DSI0_BYPASS_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_1)}, DSI0_BYPASS_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_2)}, DSI0_BYPASS_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_3)}, DSI0_BYPASS_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_NEGATIVE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_1)}, DSI0_NEGATIVE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_2)}, DSI0_NEGATIVE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_3)}, DSI0_NEGATIVE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GRAYSCALE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_1)}, DSI0_GRAYSCALE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_2)}, DSI0_GRAYSCALE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_3)}, DSI0_GRAYSCALE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GRAYSCALE_NEGATIVE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_1)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_2)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_3)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_COLOR_BLIND_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_1)}, DSI0_COLOR_BLIND_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_2)}, DSI0_COLOR_BLIND_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_3)}, DSI0_COLOR_BLIND_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_NIGHT_MODE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_1)}, DSI0_NIGHT_MODE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_2)}, DSI0_NIGHT_MODE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_3)}, DSI0_NIGHT_MODE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_COLOR_LENS_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_LENS_MDNIE_1)}, DSI0_COLOR_LENS_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_LENS_MDNIE_2)}, DSI0_COLOR_LENS_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_LENS_MDNIE_3)}, DSI0_COLOR_LENS_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_HBM_CE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_1)}, DSI0_HBM_CE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_2)}, DSI0_HBM_CE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_3)}, DSI0_HBM_CE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_RGB_SENSOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_1)}, DSI0_RGB_SENSOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_2)}, DSI0_RGB_SENSOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_3)}, DSI0_RGB_SENSOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_SCREEN_CURTAIN_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_1)}, DSI0_SCREEN_CURTAIN_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_2)}, DSI0_SCREEN_CURTAIN_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_3)}, DSI0_SCREEN_CURTAIN_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_LIGHT_NOTIFICATION_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_1)}, DSI0_LIGHT_NOTIFICATION_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_2)}, DSI0_LIGHT_NOTIFICATION_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_3)}, DSI0_LIGHT_NOTIFICATION_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_1)}, DSI0_UI_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_2)}, DSI0_UI_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_3)}, DSI0_UI_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_1)}, DSI0_UI_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_2)}, DSI0_UI_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_3)}, DSI0_UI_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_1)}, DSI0_UI_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_2)}, DSI0_UI_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_3)}, DSI0_UI_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_1)}, DSI0_UI_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_2)}, DSI0_UI_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_3)}, DSI0_UI_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_1)}, DSI0_VIDEO_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_2)}, DSI0_VIDEO_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_3)}, DSI0_VIDEO_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_1)}, DSI0_VIDEO_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_2)}, DSI0_VIDEO_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_3)}, DSI0_VIDEO_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_1)}, DSI0_VIDEO_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_2)}, DSI0_VIDEO_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_3)}, DSI0_VIDEO_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_1)}, DSI0_VIDEO_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_2)}, DSI0_VIDEO_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_3)}, DSI0_VIDEO_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_1)}, DSI0_CAMERA_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_2)}, DSI0_CAMERA_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_3)}, DSI0_CAMERA_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_1)}, DSI0_CAMERA_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_2)}, DSI0_CAMERA_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_3)}, DSI0_CAMERA_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_1)}, DSI0_CAMERA_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_2)}, DSI0_CAMERA_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_3)}, DSI0_CAMERA_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_1)}, DSI0_CAMERA_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_2)}, DSI0_CAMERA_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_3)}, DSI0_CAMERA_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_SWA_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_SWA_AUTO_MDNIE_1)}, DSI0_CAMERA_SWA_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_SWA_AUTO_MDNIE_2)}, DSI0_CAMERA_SWA_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_SWA_AUTO_MDNIE_3)}, DSI0_CAMERA_SWA_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_1)}, DSI0_GALLERY_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_2)}, DSI0_GALLERY_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_3)}, DSI0_GALLERY_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_1)}, DSI0_GALLERY_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_2)}, DSI0_GALLERY_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_3)}, DSI0_GALLERY_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_1)}, DSI0_GALLERY_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_2)}, DSI0_GALLERY_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_3)}, DSI0_GALLERY_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_1)}, DSI0_GALLERY_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_2)}, DSI0_GALLERY_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_3)}, DSI0_GALLERY_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_SWA_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_SWA_AUTO_MDNIE_1)}, DSI0_GALLERY_SWA_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_SWA_AUTO_MDNIE_2)}, DSI0_GALLERY_SWA_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_SWA_AUTO_MDNIE_3)}, DSI0_GALLERY_SWA_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_1)}, DSI0_BROWSER_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_2)}, DSI0_BROWSER_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_3)}, DSI0_BROWSER_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_1)}, DSI0_BROWSER_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_2)}, DSI0_BROWSER_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_3)}, DSI0_BROWSER_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_1)}, DSI0_BROWSER_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_2)}, DSI0_BROWSER_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_3)}, DSI0_BROWSER_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_1)}, DSI0_BROWSER_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_2)}, DSI0_BROWSER_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_3)}, DSI0_BROWSER_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_1)}, DSI0_EBOOK_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_2)}, DSI0_EBOOK_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_3)}, DSI0_EBOOK_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EMAIL_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_1)}, DSI0_EMAIL_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_2)}, DSI0_EMAIL_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_3)}, DSI0_EMAIL_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc *mdnie_tune_value_dsi0[MAX_APP_MODE][MAX_MODE][MAX_OUTDOOR_MODE] = {
		/*
			DYNAMIC_MODE
			STANDARD_MODE
			NATURAL_MODE
			MOVIE_MODE
			AUTO_MODE
			READING_MODE
		*/
		/* UI_APP */
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_UI_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* VIDEO_APP*/
		{
			{DSI0_VIDEO_DYNAMIC_MDNIE,	NULL},
			{DSI0_VIDEO_STANDARD_MDNIE,	NULL},
			{DSI0_VIDEO_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_VIDEO_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE, NULL},
		},
		/* VIDEO_WARM_APP*/
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		/* VIDEO_COLD_APP*/
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		/* CAMERA_APP*/
		{
			{DSI0_CAMERA_DYNAMIC_MDNIE,	NULL},
			{DSI0_CAMERA_STANDARD_MDNIE,	NULL},
			{DSI0_CAMERA_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_CAMERA_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* CAMERA_SWA_APP*/
		{
			{DSI0_CAMERA_DYNAMIC_MDNIE,	NULL},
			{DSI0_CAMERA_STANDARD_MDNIE,	NULL},
			{DSI0_CAMERA_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_CAMERA_SWA_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* GALLERY_APP*/
		{
			{DSI0_GALLERY_DYNAMIC_MDNIE,	NULL},
			{DSI0_GALLERY_STANDARD_MDNIE,	NULL},
			{DSI0_GALLERY_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_GALLERY_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* GALLERY_SWA_APP*/
		{
			{DSI0_GALLERY_DYNAMIC_MDNIE,	NULL},
			{DSI0_GALLERY_STANDARD_MDNIE,	NULL},
			{DSI0_GALLERY_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_GALLERY_SWA_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* BROWSER_APP*/
		{
			{DSI0_BROWSER_DYNAMIC_MDNIE,	NULL},
			{DSI0_BROWSER_STANDARD_MDNIE,	NULL},
			{DSI0_BROWSER_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_BROWSER_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* eBOOK_APP*/
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* EMAIL_APP*/
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* TDMB_APP*/
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{NULL,	NULL},
			{DSI0_UI_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
};

static struct dsi_cmd_desc *light_notification_tune_value_dsi0[LIGHT_NOTIFICATION_MAX] = {
	NULL,
	DSI0_LIGHT_NOTIFICATION_MDNIE,
};

#define DSI0_RGB_SENSOR_MDNIE_1_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_1)
#define DSI0_RGB_SENSOR_MDNIE_2_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_2)
#define DSI0_RGB_SENSOR_MDNIE_3_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_3)
#endif
