/*
 * =================================================================
 *
 *
 *	Description:  samsung display common file
 *
 *	Author: jb09.kim
 *	Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
*/
#ifndef _SAMSUNG_DSI_MDNIE_S6E3FA7_AMS559NK01_
#define _SAMSUNG_DSI_MDNIE_S6E3FA7_AMS559NK01_

#include "../ss_dsi_mdnie_lite_common.h"

#define MDNIE_COLOR_BLINDE_CMD_OFFSET 32

#define ADDRESS_SCR_WHITE_RED   0x32
#define ADDRESS_SCR_WHITE_GREEN 0x34
#define ADDRESS_SCR_WHITE_BLUE  0x36

#define MDNIE_RGB_SENSOR_INDEX	1

#define MDNIE_STEP1_INDEX 1
#define MDNIE_STEP2_INDEX 2
#define MDNIE_STEP3_INDEX 3

static char level_1_key_on[] = {
	0xF0,
	0x5A, 0x5A
};

static char level_1_key_off[] = {
	0xF0,
	0xA5, 0xA5
};

static char adjust_ldu_data_1[] = {
	0xff, 0xff, 0xff,
	0xf6, 0xfa, 0xff,
	0xf4, 0xf8, 0xff,
	0xe9, 0xf2, 0xff,
	0xe2, 0xef, 0xff,
	0xd4, 0xe8, 0xff,
};

static char adjust_ldu_data_2[] = {
	0xff, 0xfa, 0xf1,
	0xff, 0xfd, 0xf8,
	0xff, 0xfd, 0xfa,
	0xfa, 0xfd, 0xff,
	0xf5, 0xfb, 0xff,
	0xe5, 0xf3, 0xff,
};

static char *adjust_ldu_data[MAX_MODE] = {
	adjust_ldu_data_2,
	adjust_ldu_data_2,
	adjust_ldu_data_2,
	adjust_ldu_data_1,
	adjust_ldu_data_1,
};

static char night_mode_data[] = {
    0x00, 0xff, 0xf9, 0x00, 0xed, 0x00, 0xff, 0x00, 0x00, 0xf9, 0xed, 0x00, 0xff, 0x00, 0xf9, 0x00, 0x00, 0xed, 0xff, 0x00, 0xf9, 0x00, 0xed, 0x00,
    0x00, 0xff, 0xf6, 0x00, 0xe5, 0x00, 0xff, 0x00, 0x00, 0xf6, 0xe5, 0x00, 0xff, 0x00, 0xf6, 0x00, 0x00, 0xe5, 0xff, 0x00, 0xf6, 0x00, 0xe5, 0x00,
    0x00, 0xff, 0xf2, 0x00, 0xdb, 0x00, 0xff, 0x00, 0x00, 0xf2, 0xdb, 0x00, 0xff, 0x00, 0xf2, 0x00, 0x00, 0xdb, 0xff, 0x00, 0xf2, 0x00, 0xdb, 0x00,
    0x00, 0xff, 0xee, 0x00, 0xd1, 0x00, 0xff, 0x00, 0x00, 0xee, 0xd1, 0x00, 0xff, 0x00, 0xee, 0x00, 0x00, 0xd1, 0xff, 0x00, 0xee, 0x00, 0xd1, 0x00,
    0x00, 0xff, 0xea, 0x00, 0xc6, 0x00, 0xff, 0x00, 0x00, 0xea, 0xc6, 0x00, 0xff, 0x00, 0xea, 0x00, 0x00, 0xc6, 0xff, 0x00, 0xea, 0x00, 0xc6, 0x00,
    0x00, 0xff, 0xe4, 0x00, 0xb7, 0x00, 0xff, 0x00, 0x00, 0xe4, 0xb7, 0x00, 0xff, 0x00, 0xe4, 0x00, 0x00, 0xb7, 0xff, 0x00, 0xe4, 0x00, 0xb7, 0x00,
    0x00, 0xff, 0xde, 0x00, 0xa7, 0x00, 0xff, 0x00, 0x00, 0xde, 0xa7, 0x00, 0xff, 0x00, 0xde, 0x00, 0x00, 0xa7, 0xff, 0x00, 0xde, 0x00, 0xa7, 0x00,
    0x00, 0xff, 0xd7, 0x00, 0x95, 0x00, 0xff, 0x00, 0x00, 0xd7, 0x95, 0x00, 0xff, 0x00, 0xd7, 0x00, 0x00, 0x95, 0xff, 0x00, 0xd7, 0x00, 0x95, 0x00,
    0x00, 0xff, 0xce, 0x00, 0x82, 0x00, 0xff, 0x00, 0x00, 0xce, 0x82, 0x00, 0xff, 0x00, 0xce, 0x00, 0x00, 0x82, 0xff, 0x00, 0xce, 0x00, 0x82, 0x00,
    0x00, 0xff, 0xc3, 0x00, 0x6d, 0x00, 0xff, 0x00, 0x00, 0xc3, 0x6d, 0x00, 0xff, 0x00, 0xc3, 0x00, 0x00, 0x6d, 0xff, 0x00, 0xc3, 0x00, 0x6d, 0x00,
    0x00, 0xff, 0xb2, 0x00, 0x56, 0x00, 0xff, 0x00, 0x00, 0xb2, 0x56, 0x00, 0xff, 0x00, 0xb2, 0x00, 0x00, 0x56, 0xff, 0x00, 0xb2, 0x00, 0x56, 0x00,
};


static char DSI0_BYPASS_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_BYPASS_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BYPASS_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_NEGATIVE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
};

static char DSI0_NEGATIVE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_NEGATIVE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GRAYSCALE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0xb3,
	0x4c,
	0xb3,
	0x4c,
	0xb3,
	0x4c,
	0x69,
	0x96,
	0x69,
	0x96,
	0x69,
	0x96,
	0xe2,
	0x1d,
	0xe2,
	0x1d,
	0xe2,
	0x1d,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};
static char DSI0_GRAYSCALE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GRAYSCALE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0xb3,
	0x4c,
	0xb3,
	0x4c,
	0xb3,
	0x4c,
	0x69,
	0x96,
	0x69,
	0x96,
	0x69,
	0x96,
	0xe2,
	0x1d,
	0xe2,
	0x1d,
	0xe2,
	0x1d,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GRAYSCALE_NEGATIVE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_COLOR_BLIND_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_COLOR_BLIND_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_COLOR_BLIND_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x60,
	0x13,
	0xff,
	0xf9,
	0x13,
	0xff,
	0x60,
	0xac,
	0xff,
	0xf9,
	0xac,
	0x66,
	0xff,
	0xf9,
	0x60,
	0xac,
	0x13,
	0xff,
	0x66,
	0x60,
	0xf9,
	0xac,
	0x13,
	0xff,
	0x66,
	0xf9,
	0x60,
	0x13,
	0xac,
	0xff,
	0x66,
	0xf9,
	0x60,
	0xac,
	0x13,
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_LIGHT_NOTIFICATION_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_NIGHT_MODE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_NIGHT_MODE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_NIGHT_MODE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_HBM_CE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_HBM_CE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x14,
	0x00,
	0xff,
	0xb3,
	0x00,
	0xff,
	0x01,
	0x10,
	0x77,
	0x05,
	0x07,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_HBM_CE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xfc,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_HBM_CE_TEXT_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_HBM_CE_TEXT_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x14,
	0x00,
	0xff,
	0xb3,
	0x00,
	0xff,
	0x01,
	0x10,
	0x77,
	0x05,
	0x07,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_HBM_CE_TEXT_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xfc,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_SCREEN_CURTAIN_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};

static char DSI0_SCREEN_CURTAIN_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_SCREEN_CURTAIN_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_RGB_SENSOR_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_RGB_SENSOR_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_RGB_SENSOR_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

/* UI */

static char DSI0_UI_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_UI_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_UI_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_UI_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_UI_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x02,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_UI_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_UI_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_UI_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_UI_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_UI_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_UI_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_UI_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_UI_AUTO_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0xff,
	0xff,
	0xff,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_UI_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_UI_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};



static char DSI0_VIDEO_OUTDOOR_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_OUTDOOR_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_OUTDOOR_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x04,
	0xff,
	0x00,
	0x10,
	0x00,
	0x40,
	0x00,
	0x40,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VIDEO_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x06,
	0xff,
	0x00,
	0x10,
	0x00,
	0x40,
	0x00,
	0x40,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VIDEO_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x04,
	0xff,
	0x00,
	0x10,
	0x00,
	0x40,
	0x00,
	0x40,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xff,
	0x68,
	0x7c,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0xff,
	0xf4,
	0xff,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x0f,
	0xff,
	0x00,
	0x28,
	0x00,
	0x40,
	0x00,
	0x40,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x28,
	0x00,
	0x01,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x05,
	0x0a,
	0x10,
	0x17,
	0x1e,
	0x26,
	0x2e,
	0x36,
	0x3f,
	0x49,
	0x52,
	0x5c,
	0x65,
	0x6f,
	0x78,
	0x82,
	0x8b,
	0x95,
	0x9e,
	0xa8,
	0xb1,
	0xbb,
	0xc3,
	0xcb,
	0xd3,
	0xdb,
	0xe3,
	0xeb,
	0xf1,
	0xf8,
	0xfc,
	0x01,
	0x00,
};

static char DSI0_VIDEO_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_WARM_OUTDOOR_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_WARM_OUTDOOR_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_WARM_OUTDOOR_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_WARM_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_WARM_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_WARM_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_COLD_OUTDOOR_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_COLD_OUTDOOR_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_COLD_OUTDOOR_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VIDEO_COLD_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VIDEO_COLD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VIDEO_COLD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_OUTDOOR_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_CAMERA_OUTDOOR_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_OUTDOOR_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xc0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_CAMERA_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x02,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_CAMERA_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_CAMERA_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_CAMERA_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x1c,
	0x34,
	0xff,
	0xf0,
	0x00,
	0xd8,
	0x00,
	0xd9,
	0xff,
	0xff,
	0xff,
	0x00,
	0xe0,
	0xff,
	0x0a,
	0xf6,
	0x0a,
	0xd8,
	0x3b,
	0x00,
	0xff,
	0xd9,
	0x00,
	0xff,
	0x14,
	0xf9,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_CAMERA_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x0c,
	0xff,
	0x00,
	0x28,
	0x00,
	0xa0,
	0x00,
	0xa0,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x28,
	0x00,
	0x01,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_CAMERA_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};



static char DSI0_GALLERY_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_GALLERY_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x04,
	0xff,
	0x00,
	0x10,
	0x02,
	0x00,
	0x02,
	0x00,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GALLERY_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GALLERY_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_GALLERY_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x06,
	0xff,
	0x00,
	0x10,
	0x02,
	0x00,
	0x02,
	0x00,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GALLERY_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GALLERY_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_GALLERY_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x04,
	0xff,
	0x00,
	0x10,
	0x02,
	0x00,
	0x02,
	0x00,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x10,
	0x00,
	0x00,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GALLERY_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GALLERY_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_GALLERY_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GALLERY_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_GALLERY_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x1c,
	0x34,
	0xff,
	0xf0,
	0x00,
	0xd8,
	0x00,
	0xd9,
	0xff,
	0xff,
	0xff,
	0x00,
	0xe0,
	0xff,
	0x0a,
	0xf6,
	0x0a,
	0xd8,
	0x3b,
	0x00,
	0xff,
	0xd9,
	0x00,
	0xff,
	0x14,
	0xf9,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_GALLERY_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x0c,
	0xff,
	0x00,
	0x28,
	0x00,
	0xa0,
	0x00,
	0xa0,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x28,
	0x00,
	0x01,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_GALLERY_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};


static char DSI0_VT_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VT_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VT_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VT_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VT_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x02,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VT_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VT_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_VT_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VT_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VT_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VT_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VT_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_VT_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x48,
	0x5b,
	0xff,
	0xf9,
	0x00,
	0xd8,
	0x00,
	0xd9,
	0xff,
	0xff,
	0xff,
	0x00,
	0xe0,
	0xff,
	0x00,
	0xf6,
	0x00,
	0xd8,
	0x3b,
	0x00,
	0xff,
	0xd9,
	0x00,
	0xff,
	0x14,
	0xf9,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_VT_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x0c,
	0xff,
	0x00,
	0x28,
	0x00,
	0xa0,
	0x00,
	0xa0,
	0x14,
	0x00,
	0x01,
	0x00,
	0x01,
	0x00,
	0x28,
	0x00,
	0x01,
	0x28,
	0x3c,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_VT_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BROWSER_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_BROWSER_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_BROWSER_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x02,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BROWSER_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_BROWSER_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_BROWSER_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BROWSER_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_BROWSER_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_BROWSER_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BROWSER_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_BROWSER_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x5c,
	0x70,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0xff,
	0xff,
	0xff,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_BROWSER_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_BROWSER_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};


static char DSI0_EBOOK_DYNAMIC_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xe8,
	0x00,
	0x00,
	0xf6,
	0xed,
	0x00,
	0xf0,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x5a,
	0xe8,
	0xf7,
	0x00,
	0xec,
	0x00,
	0xf0,
	0x4f,
	0x00,
	0xec,
	0xe8,
	0x00,
	0xf6,
	0x2e,
	0xed,
	0x2b,
	0x00,
	0xe6,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_EBOOK_DYNAMIC_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EBOOK_DYNAMIC_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_EBOOK_STANDARD_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xf8,
	0x2b,
	0x2c,
	0xf6,
	0xef,
	0x00,
	0xff,
	0x00,
	0xe8,
	0xff,
	0xf9,
	0xef,
	0x00,
	0xf8,
	0xf0,
	0x2b,
	0xea,
	0x2c,
	0xff,
	0x00,
	0x3c,
	0xec,
	0xe8,
	0x2f,
	0xf6,
	0x2c,
	0xef,
	0x2b,
	0x40,
	0xe3,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_EBOOK_STANDARD_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x02,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EBOOK_STANDARD_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_EBOOK_NATURAL_MDNIE_1[] = {
	0xDF,
	0x11,
	0x67,
	0xa9,
	0x37,
	0x29,
	0x19,
	0x47,
	0x00,
	0x25,
	0x3d,
	0x00,
	0x31,
	0xf4,
	0x00,
	0x51,
	0xec,
	0x00,
	0x1c,
	0xd8,
	0xd9,
	0x25,
	0x25,
	0xf6,
	0xef,
	0x00,
	0xdf,
	0x00,
	0xe2,
	0xff,
	0xf9,
	0xef,
	0x8c,
	0xd9,
	0xf3,
	0x25,
	0xea,
	0x25,
	0xdf,
	0x87,
	0x34,
	0xec,
	0xe2,
	0x4b,
	0xf6,
	0x2a,
	0xef,
	0x2b,
	0x51,
	0xde,
	0xff,
	0x00,
	0xf7,
	0x00,
	0xef,
	0x00,
};

static char DSI0_EBOOK_NATURAL_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EBOOK_NATURAL_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_EBOOK_MOVIE_MDNIE_1[] = {
	0xDF,
	0x00,
	0x67,
	0xa9,
	0x0c,
	0x0c,
	0x0c,
	0x0c,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0x00,
	0xaa,
	0xab,
	0xd5,
	0x2c,
	0x2a,
	0xff,
	0xf5,
	0x63,
	0xfe,
	0x4a,
	0xff,
	0xff,
	0xf9,
	0xf8,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
};

static char DSI0_EBOOK_MOVIE_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EBOOK_MOVIE_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_EBOOK_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0xff,
	0xf5,
	0xe4,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xf6,
	0x00,
	0xe6,
	0x00,
};

static char DSI0_EBOOK_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EBOOK_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static char DSI0_EMAIL_AUTO_MDNIE_1[] = {
	0xDF,
	0x01,
	0x6a,
	0x9a,
	0x25,
	0x1a,
	0x16,
	0x2a,
	0x00,
	0x37,
	0x5a,
	0x00,
	0x4e,
	0xc5,
	0x00,
	0x5d,
	0x17,
	0x00,
	0x30,
	0xc3,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0xff,
	0xf5,
	0xe4,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xff,
	0x00,
	0xff,
	0x00,
	0x00,
	0xff,
	0xff,
	0x00,
	0xf5,
	0x00,
	0xe4,
	0x00,
};

static char DSI0_EMAIL_AUTO_MDNIE_2[] = {
	0xDE,
	0x00,
	0x40,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x00,
	0x40,
	0x20,
	0x00,
	0x96,
	0x9a,
	0x00,
	0xf2,
	0x01,
	0x0e,
	0x66,
	0x03,
	0x01,
	0x00,
	0xff,
	0x00,
	0x00,
	0x07,
	0xff,
	0x07,
	0xff,
	0x14,
	0x00,
	0x02,
	0x00,
	0x02,
	0x01,
	0xf4,
	0x08,
	0x8a,
	0x20,
	0x2d,
	0x04,
	0x0f,
	0x01,
	0x20,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
	0x00,
	0x08,
	0x10,
	0x18,
	0x20,
	0x28,
	0x30,
	0x38,
	0x40,
	0x48,
	0x50,
	0x58,
	0x60,
	0x68,
	0x70,
	0x78,
	0x80,
	0x88,
	0x90,
	0x98,
	0xa0,
	0xa8,
	0xb0,
	0xb8,
	0xc0,
	0xc8,
	0xd0,
	0xd8,
	0xe0,
	0xe8,
	0xf0,
	0xf8,
	0x01,
	0x00,
};

static char DSI0_EMAIL_AUTO_MDNIE_3[] = {
	0xDD,
	0x01,
	0x00,
	0xf0,
	0x00,
	0x7f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x04,
	0x01,
};

static struct dsi_cmd_desc DSI0_BYPASS_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_1)}, DSI0_BYPASS_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_2)}, DSI0_BYPASS_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BYPASS_MDNIE_3)}, DSI0_BYPASS_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_NEGATIVE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_1)}, DSI0_NEGATIVE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_2)}, DSI0_NEGATIVE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NEGATIVE_MDNIE_3)}, DSI0_NEGATIVE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GRAYSCALE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_1)}, DSI0_GRAYSCALE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_2)}, DSI0_GRAYSCALE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_MDNIE_3)}, DSI0_GRAYSCALE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GRAYSCALE_NEGATIVE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_1)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_2)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GRAYSCALE_NEGATIVE_MDNIE_3)}, DSI0_GRAYSCALE_NEGATIVE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_COLOR_BLIND_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_1)}, DSI0_COLOR_BLIND_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_2)}, DSI0_COLOR_BLIND_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_COLOR_BLIND_MDNIE_3)}, DSI0_COLOR_BLIND_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_NIGHT_MODE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_1)}, DSI0_NIGHT_MODE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_2)}, DSI0_NIGHT_MODE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_NIGHT_MODE_MDNIE_3)}, DSI0_NIGHT_MODE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_HBM_CE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_1)}, DSI0_HBM_CE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_2)}, DSI0_HBM_CE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_MDNIE_3)}, DSI0_HBM_CE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_HBM_CE_TEXT_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_TEXT_MDNIE_1)}, DSI0_HBM_CE_TEXT_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_TEXT_MDNIE_2)}, DSI0_HBM_CE_TEXT_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_HBM_CE_TEXT_MDNIE_3)}, DSI0_HBM_CE_TEXT_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_RGB_SENSOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_1)}, DSI0_RGB_SENSOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_2)}, DSI0_RGB_SENSOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_RGB_SENSOR_MDNIE_3)}, DSI0_RGB_SENSOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_SCREEN_CURTAIN_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_1)}, DSI0_SCREEN_CURTAIN_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_2)}, DSI0_SCREEN_CURTAIN_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_SCREEN_CURTAIN_MDNIE_3)}, DSI0_SCREEN_CURTAIN_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_LIGHT_NOTIFICATION_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_1)}, DSI0_LIGHT_NOTIFICATION_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_2)}, DSI0_LIGHT_NOTIFICATION_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_LIGHT_NOTIFICATION_MDNIE_3)}, DSI0_LIGHT_NOTIFICATION_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

/*====================================================================*/

static struct dsi_cmd_desc DSI0_UI_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_1)}, DSI0_UI_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_2)}, DSI0_UI_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_DYNAMIC_MDNIE_3)}, DSI0_UI_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_1)}, DSI0_UI_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_2)}, DSI0_UI_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_STANDARD_MDNIE_3)}, DSI0_UI_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_1)}, DSI0_UI_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_2)}, DSI0_UI_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_NATURAL_MDNIE_3)}, DSI0_UI_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_MOVIE_MDNIE_1)}, DSI0_UI_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_MOVIE_MDNIE_2)}, DSI0_UI_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_MOVIE_MDNIE_3)}, DSI0_UI_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_UI_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_1)}, DSI0_UI_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_2)}, DSI0_UI_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_UI_AUTO_MDNIE_3)}, DSI0_UI_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_OUTDOOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_OUTDOOR_MDNIE_1)}, DSI0_VIDEO_OUTDOOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_OUTDOOR_MDNIE_2)}, DSI0_VIDEO_OUTDOOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_OUTDOOR_MDNIE_3)}, DSI0_VIDEO_OUTDOOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_1)}, DSI0_VIDEO_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_2)}, DSI0_VIDEO_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_DYNAMIC_MDNIE_3)}, DSI0_VIDEO_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_1)}, DSI0_VIDEO_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_2)}, DSI0_VIDEO_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_STANDARD_MDNIE_3)}, DSI0_VIDEO_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_1)}, DSI0_VIDEO_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_2)}, DSI0_VIDEO_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_NATURAL_MDNIE_3)}, DSI0_VIDEO_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_MOVIE_MDNIE_1)}, DSI0_VIDEO_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_MOVIE_MDNIE_2)}, DSI0_VIDEO_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_MOVIE_MDNIE_3)}, DSI0_VIDEO_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_1)}, DSI0_VIDEO_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_2)}, DSI0_VIDEO_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_AUTO_MDNIE_3)}, DSI0_VIDEO_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_WARM_OUTDOOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_OUTDOOR_MDNIE_1)}, DSI0_VIDEO_WARM_OUTDOOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_OUTDOOR_MDNIE_2)}, DSI0_VIDEO_WARM_OUTDOOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_OUTDOOR_MDNIE_3)}, DSI0_VIDEO_WARM_OUTDOOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_WARM_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_MDNIE_1)}, DSI0_VIDEO_WARM_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_MDNIE_2)}, DSI0_VIDEO_WARM_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_WARM_MDNIE_3)}, DSI0_VIDEO_WARM_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_COLD_OUTDOOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_OUTDOOR_MDNIE_1)}, DSI0_VIDEO_COLD_OUTDOOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_OUTDOOR_MDNIE_2)}, DSI0_VIDEO_COLD_OUTDOOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_OUTDOOR_MDNIE_3)}, DSI0_VIDEO_COLD_OUTDOOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VIDEO_COLD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_MDNIE_1)}, DSI0_VIDEO_COLD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_MDNIE_2)}, DSI0_VIDEO_COLD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VIDEO_COLD_MDNIE_3)}, DSI0_VIDEO_COLD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_OUTDOOR_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_OUTDOOR_MDNIE_1)}, DSI0_CAMERA_OUTDOOR_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_OUTDOOR_MDNIE_2)}, DSI0_CAMERA_OUTDOOR_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_OUTDOOR_MDNIE_3)}, DSI0_CAMERA_OUTDOOR_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_1)}, DSI0_CAMERA_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_2)}, DSI0_CAMERA_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_DYNAMIC_MDNIE_3)}, DSI0_CAMERA_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_1)}, DSI0_CAMERA_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_2)}, DSI0_CAMERA_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_STANDARD_MDNIE_3)}, DSI0_CAMERA_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_1)}, DSI0_CAMERA_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_2)}, DSI0_CAMERA_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_NATURAL_MDNIE_3)}, DSI0_CAMERA_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_MOVIE_MDNIE_1)}, DSI0_CAMERA_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_MOVIE_MDNIE_2)}, DSI0_CAMERA_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_MOVIE_MDNIE_3)}, DSI0_CAMERA_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_CAMERA_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_1)}, DSI0_CAMERA_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_2)}, DSI0_CAMERA_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_CAMERA_AUTO_MDNIE_3)}, DSI0_CAMERA_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_1)}, DSI0_GALLERY_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_2)}, DSI0_GALLERY_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_DYNAMIC_MDNIE_3)}, DSI0_GALLERY_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_1)}, DSI0_GALLERY_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_2)}, DSI0_GALLERY_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_STANDARD_MDNIE_3)}, DSI0_GALLERY_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_1)}, DSI0_GALLERY_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_2)}, DSI0_GALLERY_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_NATURAL_MDNIE_3)}, DSI0_GALLERY_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_MOVIE_MDNIE_1)}, DSI0_GALLERY_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_MOVIE_MDNIE_2)}, DSI0_GALLERY_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_MOVIE_MDNIE_3)}, DSI0_GALLERY_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_GALLERY_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_1)}, DSI0_GALLERY_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_2)}, DSI0_GALLERY_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_GALLERY_AUTO_MDNIE_3)}, DSI0_GALLERY_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VT_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_DYNAMIC_MDNIE_1)}, DSI0_VT_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_DYNAMIC_MDNIE_2)}, DSI0_VT_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_DYNAMIC_MDNIE_3)}, DSI0_VT_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VT_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_STANDARD_MDNIE_1)}, DSI0_VT_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_STANDARD_MDNIE_2)}, DSI0_VT_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_STANDARD_MDNIE_3)}, DSI0_VT_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VT_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_NATURAL_MDNIE_1)}, DSI0_VT_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_NATURAL_MDNIE_2)}, DSI0_VT_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_NATURAL_MDNIE_3)}, DSI0_VT_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VT_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_MOVIE_MDNIE_1)}, DSI0_VT_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_MOVIE_MDNIE_2)}, DSI0_VT_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_MOVIE_MDNIE_3)}, DSI0_VT_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_VT_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_AUTO_MDNIE_1)}, DSI0_VT_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_AUTO_MDNIE_2)}, DSI0_VT_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_VT_AUTO_MDNIE_3)}, DSI0_VT_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_1)}, DSI0_BROWSER_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_2)}, DSI0_BROWSER_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_DYNAMIC_MDNIE_3)}, DSI0_BROWSER_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_1)}, DSI0_BROWSER_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_2)}, DSI0_BROWSER_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_STANDARD_MDNIE_3)}, DSI0_BROWSER_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_1)}, DSI0_BROWSER_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_2)}, DSI0_BROWSER_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_NATURAL_MDNIE_3)}, DSI0_BROWSER_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_MOVIE_MDNIE_1)}, DSI0_BROWSER_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_MOVIE_MDNIE_2)}, DSI0_BROWSER_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_MOVIE_MDNIE_3)}, DSI0_BROWSER_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_BROWSER_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_1)}, DSI0_BROWSER_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_2)}, DSI0_BROWSER_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_BROWSER_AUTO_MDNIE_3)}, DSI0_BROWSER_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_DYNAMIC_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_DYNAMIC_MDNIE_1)}, DSI0_EBOOK_DYNAMIC_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_DYNAMIC_MDNIE_2)}, DSI0_EBOOK_DYNAMIC_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_DYNAMIC_MDNIE_3)}, DSI0_EBOOK_DYNAMIC_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_STANDARD_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_STANDARD_MDNIE_1)}, DSI0_EBOOK_STANDARD_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_STANDARD_MDNIE_2)}, DSI0_EBOOK_STANDARD_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_STANDARD_MDNIE_3)}, DSI0_EBOOK_STANDARD_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_NATURAL_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_NATURAL_MDNIE_1)}, DSI0_EBOOK_NATURAL_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_NATURAL_MDNIE_2)}, DSI0_EBOOK_NATURAL_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_NATURAL_MDNIE_3)}, DSI0_EBOOK_NATURAL_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_MOVIE_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_MOVIE_MDNIE_1)}, DSI0_EBOOK_MOVIE_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_MOVIE_MDNIE_2)}, DSI0_EBOOK_MOVIE_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_MOVIE_MDNIE_3)}, DSI0_EBOOK_MOVIE_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EBOOK_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_1)}, DSI0_EBOOK_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_2)}, DSI0_EBOOK_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EBOOK_AUTO_MDNIE_3)}, DSI0_EBOOK_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc DSI0_EMAIL_AUTO_MDNIE[] = {
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(level_1_key_on)}, level_1_key_on},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_1)}, DSI0_EMAIL_AUTO_MDNIE_1},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_2)}, DSI0_EMAIL_AUTO_MDNIE_2},
	{{DTYPE_DCS_LWRITE, 0, 0, 0, 0, sizeof(DSI0_EMAIL_AUTO_MDNIE_3)}, DSI0_EMAIL_AUTO_MDNIE_3},
	{{DTYPE_DCS_LWRITE, 1, 0, 0, 0, sizeof(level_1_key_off)}, level_1_key_off},
};

static struct dsi_cmd_desc *mdnie_tune_value_dsi0[MAX_APP_MODE][MAX_MODE][MAX_OUTDOOR_MODE] = {
		/*
			DYNAMIC_MODE
			STANDARD_MODE
			NATURAL_MODE
			MOVIE_MODE
			AUTO_MODE
			READING_MODE
		*/
		/* UI_APP*/
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{DSI0_UI_MOVIE_MDNIE,	NULL},
			{DSI0_UI_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* VIDEO_APP*/
		{
			{DSI0_VIDEO_DYNAMIC_MDNIE,	DSI0_VIDEO_OUTDOOR_MDNIE},
			{DSI0_VIDEO_STANDARD_MDNIE,	DSI0_VIDEO_OUTDOOR_MDNIE},
			{DSI0_VIDEO_NATURAL_MDNIE,	DSI0_VIDEO_OUTDOOR_MDNIE},
			{DSI0_VIDEO_MOVIE_MDNIE,	DSI0_VIDEO_OUTDOOR_MDNIE},
			{DSI0_VIDEO_AUTO_MDNIE,	DSI0_VIDEO_OUTDOOR_MDNIE},
			{DSI0_EBOOK_AUTO_MDNIE, DSI0_VIDEO_OUTDOOR_MDNIE},
		},
		/* VIDEO_WARM_APP*/
		{
			{DSI0_VIDEO_WARM_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
			{DSI0_VIDEO_WARM_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
			{DSI0_VIDEO_WARM_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
			{DSI0_VIDEO_WARM_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
			{DSI0_VIDEO_WARM_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
			{DSI0_EBOOK_AUTO_MDNIE,	DSI0_VIDEO_WARM_OUTDOOR_MDNIE},
		},
		/* VIDEO_COLD_APP*/
		{
			{DSI0_VIDEO_COLD_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
			{DSI0_VIDEO_COLD_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
			{DSI0_VIDEO_COLD_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
			{DSI0_VIDEO_COLD_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
			{DSI0_VIDEO_COLD_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
			{DSI0_EBOOK_AUTO_MDNIE,	DSI0_VIDEO_COLD_OUTDOOR_MDNIE},
		},
		/* CAMERA_APP*/
		{
			{DSI0_CAMERA_DYNAMIC_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
			{DSI0_CAMERA_STANDARD_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
			{DSI0_CAMERA_NATURAL_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
			{DSI0_CAMERA_MOVIE_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
			{DSI0_CAMERA_AUTO_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
			{DSI0_EBOOK_AUTO_MDNIE,	DSI0_CAMERA_OUTDOOR_MDNIE},
		},
		/* NAVI_APP*/
		{
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
			{NULL,	NULL},
		},
		/* GALLERY_APP*/
		{
			{DSI0_GALLERY_DYNAMIC_MDNIE,	NULL},
			{DSI0_GALLERY_STANDARD_MDNIE,	NULL},
			{DSI0_GALLERY_NATURAL_MDNIE,	NULL},
			{DSI0_GALLERY_MOVIE_MDNIE,	NULL},
			{DSI0_GALLERY_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* VT_APP*/
		{
			{DSI0_VT_DYNAMIC_MDNIE,	NULL},
			{DSI0_VT_STANDARD_MDNIE,	NULL},
			{DSI0_VT_NATURAL_MDNIE,	NULL},
			{DSI0_VT_MOVIE_MDNIE,	NULL},
			{DSI0_VT_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* BROWSER_APP*/
		{
			{DSI0_BROWSER_DYNAMIC_MDNIE,	NULL},
			{DSI0_BROWSER_STANDARD_MDNIE,	NULL},
			{DSI0_BROWSER_NATURAL_MDNIE,	NULL},
			{DSI0_BROWSER_MOVIE_MDNIE,	NULL},
			{DSI0_BROWSER_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* eBOOK_APP*/
		{
			{DSI0_EBOOK_DYNAMIC_MDNIE,	NULL},
			{DSI0_EBOOK_STANDARD_MDNIE, NULL},
			{DSI0_EBOOK_NATURAL_MDNIE,	NULL},
			{DSI0_EBOOK_MOVIE_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* EMAIL_APP*/
		{
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EMAIL_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
		/* TDMB_APP*/
		{
			{DSI0_UI_DYNAMIC_MDNIE,	NULL},
			{DSI0_UI_STANDARD_MDNIE,	NULL},
			{DSI0_UI_NATURAL_MDNIE,	NULL},
			{DSI0_UI_MOVIE_MDNIE,	NULL},
			{DSI0_UI_AUTO_MDNIE,	NULL},
			{DSI0_EBOOK_AUTO_MDNIE,	NULL},
		},
};

static struct dsi_cmd_desc *light_notification_tune_value_dsi0[LIGHT_NOTIFICATION_MAX] = {
	NULL,
	DSI0_LIGHT_NOTIFICATION_MDNIE,
};

#define DSI0_RGB_SENSOR_MDNIE_1_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_1)
#define DSI0_RGB_SENSOR_MDNIE_2_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_2)
#define DSI0_RGB_SENSOR_MDNIE_3_SIZE ARRAY_SIZE(DSI0_RGB_SENSOR_MDNIE_3)
#endif
