/*
 * Video for Linux Two header file for Exynos
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * This header file contains several v4l2 APIs to be proposed to v4l2
 * community and until being accepted, will be used restrictly for Exynos.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __LINUX_VIDEODEV2_EXYNOS_MEDIA_H
#define __LINUX_VIDEODEV2_EXYNOS_MEDIA_H

/*      Pixel format          FOURCC                     depth  Description  */

/* RGB formats */
#define V4L2_PIX_FMT_RGB32X    v4l2_fourcc('R', 'G', 'B', 'X') /* 32  RGB-8-8-8-8   */
#define V4L2_PIX_FMT_ARGB32    v4l2_fourcc('A', 'R', 'G', 'B') /* 32  ARGB-8-8-8-8   */

/* two planes -- one Y, one Cr + Cb interleaved  */
#define V4L2_PIX_FMT_YUV444_2P v4l2_fourcc('Y', 'U', '2', 'P') /* 24  Y/CbCr */
#define V4L2_PIX_FMT_YVU444_2P v4l2_fourcc('Y', 'V', '2', 'P') /* 24  Y/CrCb */

/* three planes -- one Y, one Cr, one Cb */
#define V4L2_PIX_FMT_YUV444_3P v4l2_fourcc('Y', 'U', '3', 'P') /* 24  Y/Cb/Cr */

/* two non contiguous planes - one Y, one Cr + Cb interleaved  */
/* 21  Y/CrCb 4:2:0  */
#define V4L2_PIX_FMT_NV21M    v4l2_fourcc('N', 'M', '2', '1')
/* 12  Y/CbCr 4:2:0 16x16 macroblocks */
#define V4L2_PIX_FMT_NV12MT_16X16 v4l2_fourcc('V', 'M', '1', '2')

/* three non contiguous planes - Y, Cb, Cr */
/* 12  YVU420 planar */
#define V4L2_PIX_FMT_YVU420M  v4l2_fourcc('Y', 'V', 'U', 'M')

/* compressed formats */
#define V4L2_PIX_FMT_H264_MVC v4l2_fourcc('M', '2', '6', '4') /* H264 MVC */
#define V4L2_PIX_FMT_FIMV     v4l2_fourcc('F', 'I', 'M', 'V') /* FIMV  */
#define V4L2_PIX_FMT_FIMV1    v4l2_fourcc('F', 'I', 'M', '1') /* FIMV1 */
#define V4L2_PIX_FMT_FIMV2    v4l2_fourcc('F', 'I', 'M', '2') /* FIMV2 */
#define V4L2_PIX_FMT_FIMV3    v4l2_fourcc('F', 'I', 'M', '3') /* FIMV3 */
#define V4L2_PIX_FMT_FIMV4    v4l2_fourcc('F', 'I', 'M', '4') /* FIMV4 */
#define V4L2_PIX_FMT_VP8      v4l2_fourcc('V', 'P', '8', '0') /* VP8 */
#define V4L2_PIX_FMT_VP9      v4l2_fourcc('V', 'P', '9', '0') /* VP9 */
#define V4L2_PIX_FMT_HEVC     v4l2_fourcc('H', 'E', 'V', 'C') /* HEVC */

/* yuv444 of JFIF JPEG */
#define V4L2_PIX_FMT_JPEG_444 v4l2_fourcc('J', 'P', 'G', '4')
/* yuv422 of JFIF JPEG */
#define V4L2_PIX_FMT_JPEG_422 v4l2_fourcc('J', 'P', 'G', '2')
/* yuv420 of JFIF JPEG */
#define V4L2_PIX_FMT_JPEG_420 v4l2_fourcc('J', 'P', 'G', '0')
/* grey of JFIF JPEG */
#define V4L2_PIX_FMT_JPEG_GRAY v4l2_fourcc('J', 'P', 'G', 'G')
/* yuv411 of JFIF JPEG */
#define V4L2_PIX_FMT_JPEG_411 v4l2_fourcc('J', 'P', 'G', '3')

/*
 *	C O N T R O L S
 */
/* CID base for Exynos controls (USER_CLASS) */
#define V4L2_CID_EXYNOS_BASE		(V4L2_CTRL_CLASS_USER | 0x2000)

/* for rgb alpha function */
#define V4L2_CID_GLOBAL_ALPHA		(V4L2_CID_EXYNOS_BASE + 1)

/* cacheable configuration */
#define V4L2_CID_CACHEABLE		(V4L2_CID_EXYNOS_BASE + 10)

/* jpeg captured size */
#define V4L2_CID_CAM_JPEG_MEMSIZE	(V4L2_CID_EXYNOS_BASE + 20)
#define V4L2_CID_CAM_JPEG_ENCODEDSIZE	(V4L2_CID_EXYNOS_BASE + 21)

#define V4L2_CID_SET_SHAREABLE		(V4L2_CID_EXYNOS_BASE + 40)

/* TV configuration */
#define V4L2_CID_TV_LAYER_BLEND_ENABLE	(V4L2_CID_EXYNOS_BASE + 50)
#define V4L2_CID_TV_LAYER_BLEND_ALPHA	(V4L2_CID_EXYNOS_BASE + 51)
#define V4L2_CID_TV_PIXEL_BLEND_ENABLE	(V4L2_CID_EXYNOS_BASE + 52)
#define V4L2_CID_TV_CHROMA_ENABLE	(V4L2_CID_EXYNOS_BASE + 53)
#define V4L2_CID_TV_CHROMA_VALUE	(V4L2_CID_EXYNOS_BASE + 54)
#define V4L2_CID_TV_HPD_STATUS		(V4L2_CID_EXYNOS_BASE + 55)
#define V4L2_CID_TV_LAYER_PRIO		(V4L2_CID_EXYNOS_BASE + 56)
#define V4L2_CID_TV_SET_DVI_MODE	(V4L2_CID_EXYNOS_BASE + 57)
#define V4L2_CID_TV_GET_DVI_MODE	(V4L2_CID_EXYNOS_BASE + 58)
#define V4L2_CID_TV_SET_ASPECT_RATIO	(V4L2_CID_EXYNOS_BASE + 59)
#define V4L2_CID_TV_MAX_AUDIO_CHANNELS	(V4L2_CID_EXYNOS_BASE + 60)
#define V4L2_CID_TV_ENABLE_HDMI_AUDIO	(V4L2_CID_EXYNOS_BASE + 61)
#define V4L2_CID_TV_SET_NUM_CHANNELS	(V4L2_CID_EXYNOS_BASE + 62)
#define V4L2_CID_TV_UPDATE		(V4L2_CID_EXYNOS_BASE + 63)
#define V4L2_CID_TV_SET_COLOR_RANGE	(V4L2_CID_EXYNOS_BASE + 64)
#define V4L2_CID_TV_HDCP_ENABLE		(V4L2_CID_EXYNOS_BASE + 65)
#define V4L2_CID_TV_HDMI_STATUS		(V4L2_CID_EXYNOS_BASE + 66)
#define V4L2_CID_TV_SOURCE_PHY_ADDR	(V4L2_CID_EXYNOS_BASE + 67)
#define V4L2_CID_TV_BLANK		(V4L2_CID_EXYNOS_BASE + 68)

/* for color space conversion equation selection */
#define V4L2_CID_CSC_EQ_MODE		(V4L2_CID_EXYNOS_BASE + 100)
#define V4L2_CID_CSC_EQ			(V4L2_CID_EXYNOS_BASE + 101)
#define V4L2_CID_CSC_RANGE		(V4L2_CID_EXYNOS_BASE + 102)

/* for gscaler m2m context information */
#define V4L2_CID_M2M_CTX_NUM		(V4L2_CID_EXYNOS_BASE + 200)
/* for DRM playback scenario */
#define V4L2_CID_CONTENT_PROTECTION	(V4L2_CID_EXYNOS_BASE + 201)

/* for 2d blending operation */
#define V4L2_CID_2D_BLEND_OP		(V4L2_CID_EXYNOS_BASE + 103)
#define V4L2_CID_2D_COLOR_FILL		(V4L2_CID_EXYNOS_BASE + 104)
#define V4L2_CID_2D_DITH		(V4L2_CID_EXYNOS_BASE + 105)
#define V4L2_CID_2D_FMT_PREMULTI	(V4L2_CID_EXYNOS_BASE + 106)

/* CID base for MFC controls (MPEG_CLASS) */
#define V4L2_CID_MPEG_MFC_BASE		(V4L2_CTRL_CLASS_MPEG | 0x2000)

#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_AVAIL		\
					(V4L2_CID_MPEG_MFC_BASE + 1)
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_ARRGMENT_ID	\
					(V4L2_CID_MPEG_MFC_BASE + 2)
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_INFO		\
					(V4L2_CID_MPEG_MFC_BASE + 3)
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_GRID_POS	\
					(V4L2_CID_MPEG_MFC_BASE + 4)

#define V4L2_CID_MPEG_MFC51_VIDEO_PACKED_PB		\
					(V4L2_CID_MPEG_MFC_BASE + 5)
#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_TAG		\
					(V4L2_CID_MPEG_MFC_BASE + 6)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_ENABLE		\
					(V4L2_CID_MPEG_MFC_BASE + 7)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_DATA_LUMA		\
					(V4L2_CID_MPEG_MFC_BASE + 8)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_DATA_CHROMA	\
					(V4L2_CID_MPEG_MFC_BASE + 9)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_DATA_LUMA_BOT	\
					(V4L2_CID_MPEG_MFC_BASE + 10)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_DATA_CHROMA_BOT	\
					(V4L2_CID_MPEG_MFC_BASE + 11)
#define V4L2_CID_MPEG_MFC51_VIDEO_CRC_GENERATED		\
					(V4L2_CID_MPEG_MFC_BASE + 12)
#define V4L2_CID_MPEG_MFC51_VIDEO_CHECK_STATE		\
					(V4L2_CID_MPEG_MFC_BASE + 13)
#define V4L2_CID_MPEG_MFC51_VIDEO_DISPLAY_STATUS	\
					(V4L2_CID_MPEG_MFC_BASE + 14)

#define V4L2_CID_MPEG_MFC51_VIDEO_LUMA_ADDR	\
					(V4L2_CID_MPEG_MFC_BASE + 15)
#define V4L2_CID_MPEG_MFC51_VIDEO_CHROMA_ADDR	\
					(V4L2_CID_MPEG_MFC_BASE + 16)

#define V4L2_CID_MPEG_MFC51_VIDEO_STREAM_SIZE		\
					(V4L2_CID_MPEG_MFC_BASE + 17)
#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_COUNT		\
					(V4L2_CID_MPEG_MFC_BASE + 18)
#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_TYPE		\
					(V4L2_CID_MPEG_MFC_BASE + 19)
enum v4l2_mpeg_mfc51_video_frame_type {
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_NOT_CODED	= 0,
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_I_FRAME	= 1,
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_P_FRAME	= 2,
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_B_FRAME	= 3,
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_SKIPPED	= 4,
	V4L2_MPEG_MFC51_VIDEO_FRAME_TYPE_OTHERS		= 5,
};

#define V4L2_CID_MPEG_MFC51_VIDEO_H264_INTERLACE	\
					(V4L2_CID_MPEG_MFC_BASE + 20)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_RC_FRAME_RATE	\
					(V4L2_CID_MPEG_MFC_BASE + 21)
#define V4L2_CID_MPEG_MFC51_VIDEO_MPEG4_VOP_TIME_RES	\
					(V4L2_CID_MPEG_MFC_BASE + 22)
#define V4L2_CID_MPEG_MFC51_VIDEO_MPEG4_VOP_FRM_DELTA	\
					(V4L2_CID_MPEG_MFC_BASE + 23)
#define V4L2_CID_MPEG_MFC51_VIDEO_H263_RC_FRAME_RATE	\
					(V4L2_CID_MPEG_MFC_BASE + 24)

#define V4L2_CID_MPEG_MFC6X_VIDEO_FRAME_DELTA		\
					(V4L2_CID_MPEG_MFC_BASE + 25)

#define V4L2_CID_MPEG_MFC51_VIDEO_I_PERIOD_CH	V4L2_CID_MPEG_VIDEO_GOP_SIZE
#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_RATE_CH		\
				V4L2_CID_MPEG_MFC51_VIDEO_H264_RC_FRAME_RATE
#define V4L2_CID_MPEG_MFC51_VIDEO_BIT_RATE_CH	V4L2_CID_MPEG_VIDEO_BITRATE

/* new entry for enum v4l2_mpeg_video_mpeg4_level */
#define V4L2_MPEG_VIDEO_MPEG4_LEVEL_6		8

/* new entry for enum v4l2_mpeg_video_header_mode */
#define V4L2_MPEG_VIDEO_HEADER_MODE_AT_THE_READY	2

#define V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED_S_B \
	V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY

#define V4L2_CID_MPEG_VIDEO_H264_MVC_VIEW_ID			\
					(V4L2_CID_MPEG_MFC_BASE + 42)

#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_STATUS			\
					(V4L2_CID_MPEG_MFC_BASE + 43)

#define V4L2_CID_MPEG_MFC51_VIDEO_I_FRAME_DECODING		\
					(V4L2_CID_MPEG_MFC_BASE + 44)

#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_RATE			\
					(V4L2_CID_MPEG_MFC_BASE + 45)
#define V4L2_CID_MPEG_VIDEO_H264_PREPEND_SPSPPS_TO_IDR		\
					(V4L2_CID_MPEG_MFC_BASE + 46)
#define V4L2_CID_MPEG_VIDEO_DECODER_IMMEDIATE_DISPLAY		\
					(V4L2_CID_MPEG_MFC_BASE + 47)
#define V4L2_CID_MPEG_VIDEO_DECODER_DECODING_TIMESTAMP_MODE	\
					(V4L2_CID_MPEG_MFC_BASE + 48)
#define V4L2_CID_MPEG_VIDEO_DECODER_WAIT_DECODING_START		\
					(V4L2_CID_MPEG_MFC_BASE + 49)
#define V4L2_CID_MPEG_VIDEO_QOS_RATIO				\
					(V4L2_CID_MPEG_MFC_BASE + 50)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT	\
					(V4L2_CID_MPEG_MFC_BASE + 51)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_CH \
					(V4L2_CID_MPEG_MFC_BASE + 52)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT0	\
					(V4L2_CID_MPEG_MFC_BASE + 53)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT1	\
					(V4L2_CID_MPEG_MFC_BASE + 54)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT2	\
					(V4L2_CID_MPEG_MFC_BASE + 55)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT3	\
					(V4L2_CID_MPEG_MFC_BASE + 56)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT4	\
					(V4L2_CID_MPEG_MFC_BASE + 57)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT5	\
					(V4L2_CID_MPEG_MFC_BASE + 58)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_BIT6	\
					(V4L2_CID_MPEG_MFC_BASE + 59)

/* CIDs for VP8 encoding. Number gaps are for compatibility */
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_VERSION			\
					(V4L2_CID_MPEG_MFC_BASE + 60)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_RC_FRAME_RATE		\
					(V4L2_CID_MPEG_MFC_BASE + 61)
#define V4L2_CID_MPEG_VIDEO_VP8_MIN_QP				\
					(V4L2_CID_MPEG_MFC_BASE + 62)
#define V4L2_CID_MPEG_VIDEO_VP8_MAX_QP				\
					(V4L2_CID_MPEG_MFC_BASE + 63)
#define V4L2_CID_MPEG_VIDEO_VP8_I_FRAME_QP			\
					(V4L2_CID_MPEG_MFC_BASE + 64)
#define V4L2_CID_MPEG_VIDEO_VP8_P_FRAME_QP			\
					(V4L2_CID_MPEG_MFC_BASE + 65)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_NUM_OF_PARTITIONS		\
					(V4L2_CID_MPEG_MFC_BASE + 66)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_FILTER_LEVEL		\
					(V4L2_CID_MPEG_MFC_BASE + 67)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_FILTER_SHARPNESS		\
					(V4L2_CID_MPEG_MFC_BASE + 68)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_GOLDEN_FRAMESEL		\
					(V4L2_CID_MPEG_MFC_BASE + 69)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_GF_REFRESH_PERIOD		\
					(V4L2_CID_MPEG_MFC_BASE + 70)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_HIERARCHY_QP_ENABLE	\
					(V4L2_CID_MPEG_MFC_BASE + 71)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_HIERARCHY_QP_LAYER0	\
					(V4L2_CID_MPEG_MFC_BASE + 72)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_HIERARCHY_QP_LAYER1	\
					(V4L2_CID_MPEG_MFC_BASE + 73)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_HIERARCHY_QP_LAYER2	\
					(V4L2_CID_MPEG_MFC_BASE + 74)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_REF_NUMBER_FOR_PFRAMES	\
					(V4L2_CID_MPEG_MFC_BASE + 75)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_DISABLE_INTRA_MD4X4	\
					(V4L2_CID_MPEG_MFC_BASE + 76)
#define V4L2_CID_MPEG_MFC70_VIDEO_VP8_NUM_TEMPORAL_LAYER	\
					(V4L2_CID_MPEG_MFC_BASE + 77)
#define V4L2_CID_MPEG_VIDEO_VP8_HIERARCHICAL_CODING_LAYER_BIT	\
					(V4L2_CID_MPEG_MFC_BASE + 78)
#define V4L2_CID_MPEG_VIDEO_VP8_HIERARCHICAL_CODING_LAYER_CH \
					(V4L2_CID_MPEG_MFC_BASE + 79)
#define V4L2_CID_MPEG_VIDEO_VP8_HIERARCHICAL_CODING_LAYER_BIT0	\
					(V4L2_CID_MPEG_MFC_BASE + 80)
#define V4L2_CID_MPEG_VIDEO_VP8_HIERARCHICAL_CODING_LAYER_BIT1	\
					(V4L2_CID_MPEG_MFC_BASE + 81)
#define V4L2_CID_MPEG_VIDEO_VP8_HIERARCHICAL_CODING_LAYER_BIT2	\
					(V4L2_CID_MPEG_MFC_BASE + 82)

/* ~ 90 : Reserved for using later */

#define V4L2_CID_MPEG_MFC_GET_VERSION_INFO			\
					(V4L2_CID_MPEG_MFC_BASE + 91)
#define V4L2_CID_MPEG_MFC_GET_EXTRA_BUFFER_SIZE			\
					(V4L2_CID_MPEG_MFC_BASE + 92)
#define V4L2_CID_MPEG_MFC_SET_DUAL_DPB_MODE			\
					(V4L2_CID_MPEG_MFC_BASE + 93)
#define V4L2_CID_MPEG_MFC_SET_DYNAMIC_DPB_MODE			\
					(V4L2_CID_MPEG_MFC_BASE + 95)
#define V4L2_CID_MPEG_MFC_SET_USER_SHARED_HANDLE		\
					(V4L2_CID_MPEG_MFC_BASE + 96)
#define V4L2_CID_MPEG_MFC_GET_EXT_INFO				\
					(V4L2_CID_MPEG_MFC_BASE + 97)
#define V4L2_CID_MPEG_MFC_SET_BUF_PROCESS_TYPE			\
					(V4L2_CID_MPEG_MFC_BASE + 98)

/* CIDs for HEVC encoding. Number gaps are for compatibility */

#define V4L2_CID_MPEG_VIDEO_HEVC_MIN_QP				\
					(V4L2_CID_MPEG_MFC_BASE + 110)
#define V4L2_CID_MPEG_VIDEO_HEVC_MAX_QP				\
					(V4L2_CID_MPEG_MFC_BASE + 111)
#define V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_QP			\
					(V4L2_CID_MPEG_MFC_BASE + 112)
#define V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_QP                     \
					(V4L2_CID_MPEG_MFC_BASE + 113)
#define V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_QP                     \
					(V4L2_CID_MPEG_MFC_BASE + 114)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIERARCHICAL_QP_ENABLE \
					(V4L2_CID_MPEG_MFC_BASE + 115)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_TYPE       \
					(V4L2_CID_MPEG_MFC_BASE + 116)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_LAYER      \
					(V4L2_CID_MPEG_MFC_BASE + 117)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_LAYER_QP   \
					(V4L2_CID_MPEG_MFC_BASE + 118)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_LAYER_BIT  \
					(V4L2_CID_MPEG_MFC_BASE + 119)
#define V4L2_CID_MPEG_VIDEO_HEVC_PROFILE			\
					(V4L2_CID_MPEG_MFC_BASE + 120)
#define V4L2_CID_MPEG_VIDEO_HEVC_LEVEL				\
					(V4L2_CID_MPEG_MFC_BASE + 121)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_RC_FRAME_RATE            \
					(V4L2_CID_MPEG_MFC_BASE + 122)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_TIER_FLAG                \
					(V4L2_CID_MPEG_MFC_BASE + 123)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_MAX_PARTITION_DEPTH      \
					(V4L2_CID_MPEG_MFC_BASE + 124)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_REF_NUMBER_FOR_PFRAMES   \
					(V4L2_CID_MPEG_MFC_BASE + 125)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LF_DISABLE               \
					(V4L2_CID_MPEG_MFC_BASE + 126)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LF_SLICE_BOUNDARY        \
					(V4L2_CID_MPEG_MFC_BASE + 127)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LF_BETA_OFFSET_DIV2      \
					(V4L2_CID_MPEG_MFC_BASE + 128)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LF_TC_OFFSET_DIV2        \
					(V4L2_CID_MPEG_MFC_BASE + 129)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_REFRESH_TYPE             \
					(V4L2_CID_MPEG_MFC_BASE + 130)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_REFRESH_PERIOD           \
					(V4L2_CID_MPEG_MFC_BASE + 131)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LOSSLESS_CU_ENABLE       \
					(V4L2_CID_MPEG_MFC_BASE + 132)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_CONST_INTRA_PRED_ENABLE  \
					(V4L2_CID_MPEG_MFC_BASE + 133)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_WAVEFRONT_ENABLE         \
					(V4L2_CID_MPEG_MFC_BASE + 134)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_LTR_ENABLE               \
					(V4L2_CID_MPEG_MFC_BASE + 135)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_USER_REF                 \
					(V4L2_CID_MPEG_MFC_BASE + 136)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_STORE_REF                \
					(V4L2_CID_MPEG_MFC_BASE + 137)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_SIGN_DATA_HIDING         \
					(V4L2_CID_MPEG_MFC_BASE + 138)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_GENERAL_PB_ENABLE        \
					(V4L2_CID_MPEG_MFC_BASE + 139)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_TEMPORAL_ID_ENABLE       \
					(V4L2_CID_MPEG_MFC_BASE + 140)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_STRONG_SMOTHING_FLAG     \
					(V4L2_CID_MPEG_MFC_BASE + 141)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_MAX_NUM_MERGE_MV_MINUS1  \
					(V4L2_CID_MPEG_MFC_BASE + 142)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_ADAPTIVE_RC_DARK         \
					(V4L2_CID_MPEG_MFC_BASE + 143)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_ADAPTIVE_RC_SMOOTH       \
					(V4L2_CID_MPEG_MFC_BASE + 144)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_ADAPTIVE_RC_STATIC	\
					(V4L2_CID_MPEG_MFC_BASE + 145)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_ADAPTIVE_RC_ACTIVITY     \
					(V4L2_CID_MPEG_MFC_BASE + 146)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_DISABLE_INTRA_PU_SPLIT   \
					(V4L2_CID_MPEG_MFC_BASE + 147)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_DISABLE_TMV_PREDICTION	\
					(V4L2_CID_MPEG_MFC_BASE + 148)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_WITHOUT_STARTCODE_ENABLE \
					(V4L2_CID_MPEG_MFC_BASE + 149)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_QP_INDEX_CR		\
					(V4L2_CID_MPEG_MFC_BASE + 150)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_QP_INDEX_CB		\
					(V4L2_CID_MPEG_MFC_BASE + 151)
#define V4L2_CID_MPEG_MFC90_VIDEO_HEVC_SIZE_OF_LENGTH_FIELD	\
					(V4L2_CID_MPEG_MFC_BASE + 152)
#endif /* __LINUX_VIDEODEV2_EXYNOS_MEDIA_H */
