/*
 * Driver model for sensor
 *
 * Copyright (C) 2008 Samsung Electronics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __LINUX_SENSORS_AXES_H_INCLUDED
#define __LINUX_SENSORS_AXES_H_INCLUDED

/* For position setting */
#define AXES_PXPYPZ	0
#define AXES_PYNXPZ	1
#define AXES_NXNYPZ	2
#define AXES_NYPXPZ	3
#define AXES_NXPYNZ	4
#define AXES_PYPXNZ	5
#define AXES_PXNYNZ	6
#define AXES_NYNXNZ	7
#define AXES_PXPYNZ	8
#define AXES_PYNXNZ	9
#define AXES_NXNYNZ	10
#define AXES_NYPXNZ	11
#define AXES_NXPYPZ	12
#define AXES_PYPXPZ	13
#define AXES_PXNYPZ	14
#define AXES_NYNXPZ	15

/* POSITION VALUES */
/* TYPE 1 */
#define TYPE1_TOP_UPPER_LEFT		AXES_PXPYPZ
#define TYPE1_TOP_UPPER_RIGHT		AXES_PYNXPZ
#define TYPE1_TOP_LOWER_RIGHT		AXES_NXNYPZ
#define TYPE1_TOP_LOWER_LEFT		AXES_NYPXPZ
#define TYPE1_BOTTOM_UPPER_LEFT		AXES_NXPYNZ
#define TYPE1_BOTTOM_UPPER_RIGHT	AXES_NYNXNZ
#define TYPE1_BOTTOM_LOWER_RIGHT	AXES_PXNYNZ
#define TYPE1_BOTTOM_LOWER_LEFT		AXES_PYPXNZ

/* TYPE2 : K330 */
#define TYPE2_TOP_UPPER_LEFT		AXES_NYPXPZ
#define TYPE2_TOP_UPPER_RIGHT		AXES_PXPYPZ
#define TYPE2_TOP_LOWER_RIGHT		AXES_PYNXPZ
#define TYPE2_TOP_LOWER_LEFT		AXES_NXNYPZ
#define TYPE2_BOTTOM_UPPER_LEFT		AXES_PYPXNZ
#define TYPE2_BOTTOM_UPPER_RIGHT	AXES_NXPYNZ
#define TYPE2_BOTTOM_LOWER_RIGHT	AXES_NYNXNZ
#define TYPE2_BOTTOM_LOWER_LEFT		AXES_PXNYNZ

/* TYPE3 : AK8975C, AK8963C, LSM330DLC */
#define TYPE3_TOP_UPPER_LEFT		AXES_NXNYPZ
#define TYPE3_TOP_UPPER_RIGHT		AXES_NYPXPZ
#define TYPE3_TOP_LOWER_RIGHT		AXES_PXPYPZ
#define TYPE3_TOP_LOWER_LEFT		AXES_PYNXPZ
#define TYPE3_BOTTOM_UPPER_LEFT		AXES_PXNYNZ
#define TYPE3_BOTTOM_UPPER_RIGHT	AXES_PYPXNZ
#define TYPE3_BOTTOM_LOWER_RIGHT	AXES_NXPYNZ
#define TYPE3_BOTTOM_LOWER_LEFT		AXES_NYNXNZ

/* TYPE4 */
#define TYPE4_TOP_UPPER_LEFT		AXES_PYNXNZ
#define TYPE4_TOP_UPPER_RIGHT		AXES_NXNYNZ
#define TYPE4_TOP_LOWER_RIGHT		AXES_NYPXNZ
#define TYPE4_TOP_LOWER_LEFT		AXES_PXPYNZ
#define TYPE4_BOTTOM_UPPER_LEFT		AXES_NYNXPZ
#define TYPE4_BOTTOM_UPPER_RIGHT	AXES_PXNYPZ
#define TYPE4_BOTTOM_LOWER_RIGHT	AXES_PYPXPZ
#define TYPE4_BOTTOM_LOWER_LEFT		AXES_NXPYPZ

/* TYPE 5 */
#define TYPE5_TOP_UPPER_LEFT		AXES_PXPYNZ
#define TYPE5_TOP_UPPER_RIGHT		AXES_PYNXNZ
#define TYPE5_TOP_LOWER_RIGHT		AXES_NXNYNZ
#define TYPE5_TOP_LOWER_LEFT		AXES_NYPXNZ
#define TYPE5_BOTTOM_UPPER_LEFT		AXES_NXPYPZ
#define TYPE5_BOTTOM_UPPER_RIGHT	AXES_NYNXPZ
#define TYPE5_BOTTOM_LOWER_RIGHT	AXES_PXNYPZ
#define TYPE5_BOTTOM_LOWER_LEFT		AXES_PYPXPZ

/* TYPE6 */
#define TYPE6_TOP_UPPER_LEFT		AXES_NYPXNZ
#define TYPE6_TOP_UPPER_RIGHT		AXES_PXPYNZ
#define TYPE6_TOP_LOWER_RIGHT		AXES_PYNXNZ
#define TYPE6_TOP_LOWER_LEFT		AXES_NXNYNZ
#define TYPE6_BOTTOM_UPPER_LEFT		AXES_PYPXPZ
#define TYPE6_BOTTOM_UPPER_RIGHT	AXES_NXPYPZ
#define TYPE6_BOTTOM_LOWER_RIGHT	AXES_NYNXPZ
#define TYPE6_BOTTOM_LOWER_LEFT		AXES_PXNYPZ

/* TYPE7 */
#define TYPE7_TOP_UPPER_LEFT		AXES_NXNYNZ
#define TYPE7_TOP_UPPER_RIGHT		AXES_NYPXNZ
#define TYPE7_TOP_LOWER_RIGHT		AXES_PXPYNZ
#define TYPE7_TOP_LOWER_LEFT		AXES_PYNXNZ
#define TYPE7_BOTTOM_UPPER_LEFT		AXES_PXNYPZ
#define TYPE7_BOTTOM_UPPER_RIGHT	AXES_PYPXPZ
#define TYPE7_BOTTOM_LOWER_RIGHT	AXES_NXPYPZ
#define TYPE7_BOTTOM_LOWER_LEFT		AXES_NYNXPZ

/* TYPE8 */
#define TYPE8_TOP_UPPER_LEFT		AXES_PYNXNZ
#define TYPE8_TOP_UPPER_RIGHT		AXES_NXNYNZ
#define TYPE8_TOP_LOWER_RIGHT		AXES_NYPXNZ
#define TYPE8_TOP_LOWER_LEFT		AXES_PXPYNZ
#define TYPE8_BOTTOM_UPPER_LEFT		AXES_NYNXPZ
#define TYPE8_BOTTOM_UPPER_RIGHT	AXES_PXNYPZ
#define TYPE8_BOTTOM_LOWER_RIGHT	AXES_PYPXPZ
#define TYPE8_BOTTOM_LOWER_LEFT		AXES_NXPYPZ

typedef void (*axes_func_s16)(s16 *, s16 *, s16*);

#endif	/* __LINUX_SENSORS_AXES_H_INCLUDED */
