/*
 * S2MPU01A.h
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_S2MPU01A_H
#define __LINUX_MFD_S2MPU01A_H

/* S2MPU01A Revision Number */
enum s2mpu01a_revision_number {
	S2MPU01A_REV_01 = 0x01,
	S2MPU01A_REV_02 = 0x02,
};

/* S2MPU01A registers */
enum S2MPU01A_reg {
	S2MPU01A_REG_ID,
	S2MPU01A_REG_INT1,
	S2MPU01A_REG_INT2,
	S2MPU01A_REG_INT3,
	S2MPU01A_REG_INT1M,
	S2MPU01A_REG_INT2M,
	S2MPU01A_REG_INT3M,
	S2MPU01A_REG_ST1,
	S2MPU01A_REG_ST2,
	S2MPU01A_REG_PWRONSRC,
	S2MPU01A_REG_OFFSRC,
	S2MPU01A_REG_RTC_CTRL,
	S2MPU01A_REG_CTRL1,
	S2MPU01A_REG_ETC_TEST,
	S2MPU01A_REG_RSVD1,
	S2MPU01A_REG_BU_CHG,
	S2MPU01A_REG_RAMP,
	S2MPU01A_REG_RAMP_BUCK,
	S2MPU01A_REG_LDO1_8,
	S2MPU01A_REG_LDO9_29,
	S2MPU01A_REG_LDO30_37,
	S2MPU01A_REG_LDO38_42,
	S2MPU01A_REG_OTP_ADRL,
	S2MPU01A_REG_OTP_ADRH,
	S2MPU01A_REG_OTP_DATA,
	S2MPU01A_REG_MON1SEL,
	S2MPU01A_REG_MON2SEL,
	S2MPU01A_REG_LEE,
	S2MPU01A_REG_RSVD2,
	S2MPU01A_REG_RSVD3,
	S2MPU01A_REG_SET_ST1,
	S2MPU01A_REG_SET_ST2,
	S2MPU01A_REG_SET_ST3,
	S2MPU01A_REG_TOP_RSVD,
	S2MPU01A_REG_DVS_SEL,
	S2MPU01A_REG_DVS_PTR,
	S2MPU01A_REG_DVS_DATA,
	S2MPU01A_REG_RSVD_NO,
	S2MPU01A_REG_UVLO,
	S2MPU01A_REG_LEE_NO,
	S2MPU01A_REG_B1CTRL1,
	S2MPU01A_REG_B1CTRL2,
	S2MPU01A_REG_B2CTRL1,
	S2MPU01A_REG_B2CTRL2,
	S2MPU01A_REG_B3CTRL1,
	S2MPU01A_REG_B3CTRL2,
	S2MPU01A_REG_B4CTRL1,
	S2MPU01A_REG_B4CTRL2,
	S2MPU01A_REG_B5CTRL1,
	S2MPU01A_REG_B5CTRL2,
	S2MPU01A_REG_B6CTRL1,
	S2MPU01A_REG_B6CTRL2,
	S2MPU01A_REG_B7CTRL1,
	S2MPU01A_REG_B7CTRL2,
	S2MPU01A_REG_B8CTRL1,
	S2MPU01A_REG_B8CTRL2,
	S2MPU01A_REG_L1CTRL,
	S2MPU01A_REG_L2CTRL,
	S2MPU01A_REG_L3CTRL,
	S2MPU01A_REG_L4CTRL,
	S2MPU01A_REG_L5CTRL,
	S2MPU01A_REG_L6CTRL,
	S2MPU01A_REG_L7CTRL,
	S2MPU01A_REG_L8CTRL,
	S2MPU01A_REG_L9CTRL,
	S2MPU01A_REG_L23CTRL,
	S2MPU01A_REG_L24CTRL,
	S2MPU01A_REG_L25CTRL,
	S2MPU01A_REG_L26CTRL,
	S2MPU01A_REG_L27CTRL,
	S2MPU01A_REG_L28CTRL,
	S2MPU01A_REG_L29CTRL,
	S2MPU01A_REG_L30CTRL,
	S2MPU01A_REG_L31CTRL,
	S2MPU01A_REG_L32CTRL,
	S2MPU01A_REG_L33CTRL,
	S2MPU01A_REG_L34CTRL,
	S2MPU01A_REG_L35CTRL,
	S2MPU01A_REG_L36CTRL,
	S2MPU01A_REG_L37CTRL,
	S2MPU01A_REG_L38CTRL,
	S2MPU01A_REG_L39CTRL,
	S2MPU01A_REG_L40CTRL,
	S2MPU01A_REG_L41CTRL,
	S2MPU01A_REG_L42CTRL,
	S2MPU01A_REG_LDO1_8_1,
	S2MPU01A_REG_LDO9_29_1,
	S2MPU01A_REG_LDO30_37_1,
	S2MPU01A_REG_LDO38_42_1,
};

/* S2MPU01A regulator ids */
enum S2MPU01A_regulators {
	S2MPU01A_LDO1,
	S2MPU01A_LDO2,
	S2MPU01A_LDO3,
	S2MPU01A_LDO4,
	S2MPU01A_LDO5,
	S2MPU01A_LDO6,
	S2MPU01A_LDO7,
	S2MPU01A_LDO8,
	S2MPU01A_LDO9,
	S2MPU01A_LDO23,
	S2MPU01A_LDO24,
	S2MPU01A_LDO25,
	S2MPU01A_LDO26,
	S2MPU01A_LDO27,
	S2MPU01A_LDO28,
	S2MPU01A_LDO29,
	S2MPU01A_LDO30,
	S2MPU01A_LDO31,
	S2MPU01A_LDO32,
	S2MPU01A_LDO33,
	S2MPU01A_LDO34,
	S2MPU01A_LDO35,
	S2MPU01A_LDO36,
	S2MPU01A_LDO37,
	S2MPU01A_LDO38,
	S2MPU01A_LDO39,
	S2MPU01A_LDO40,
	S2MPU01A_LDO41,
	S2MPU01A_LDO42,
	S2MPU01A_BUCK1,
	S2MPU01A_BUCK2,
	S2MPU01A_BUCK3,
	S2MPU01A_BUCK4,
	S2MPU01A_BUCK5,
	S2MPU01A_BUCK6,
	S2MPU01A_BUCK7,
	S2MPU01A_BUCK8,
	S2MPU01A_AP_EN32KHZ,
	S2MPU01A_CP_EN32KHZ,

	S2MPU01A_REG_MAX,
};

#define S2MPU01A_PMIC_EN_SHIFT	6

extern int change_mr_reset(void);
extern unsigned int get_pmic_rev(void);
extern bool s2mpu01a_get_jig_status(void);

#endif /*  __LINUX_MFD_S2MPU01A_H */
