/*
 * S2MPU01.h
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_S2MPU01_H
#define __LINUX_MFD_S2MPU01_H

/* S2MPU01 registers */
enum S2MPU01_reg {
	S2MPU01_REG_ID,
	S2MPU01_REG_INT1,
	S2MPU01_REG_INT2,
	S2MPU01_REG_INT3,
	S2MPU01_REG_INT1M,
	S2MPU01_REG_INT2M,
	S2MPU01_REG_INT3M,
	S2MPU01_REG_ST1,
	S2MPU01_REG_ST2,
	S2MPU01_REG_PWRONSRC,
	S2MPU01_REG_OFFSRC,
	S2MPU01_REG_RTC_CTRL,
	S2MPU01_REG_CTRL1,
	S2MPU01_REG_ETC_TEST,
	S2MPU01_REG_RSVD1,
	S2MPU01_REG_BU_CHG,
	S2MPU01_REG_RAMP,
	S2MPU01_REG_RAMP_BUCK,
	S2MPU01_REG_LDO1_8,
	S2MPU01_REG_LDO9_29,
	S2MPU01_REG_LDO30_37,
	S2MPU01_REG_LDO38_45,
	S2MPU01_REG_LDO46_49,
	S2MPU01_REG_LDO1_8_1,
	S2MPU01_REG_LDO9_29_1,
	S2MPU01_REG_LDO30_37_1,
	S2MPU01_REG_LDO38_45_1,
	S2MPU01_REG_LDO46_49_1,
	S2MPU01_REG_OTP_ADRL,
	S2MPU01_REG_OTP_ADRH,
	S2MPU01_REG_OTP_DATA,
	S2MPU01_REG_MON1SEL,
	S2MPU01_REG_MON2SEL,
	S2MPU01_REG_LEE,
	S2MPU01_REG_ADDR_TRIMDATA1,
	S2MPU01_REG_ADDR_TRIMDATA2,
	S2MPU01_REG_SET_ST1,
	S2MPU01_REG_SET_ST2,
	S2MPU01_REG_SET_ST3,
	S2MPU01_REG_TOP_RSVD,
	S2MPU01_REG_DVS_SEL,
	S2MPU01_REG_DVS_DATA,
	S2MPU01_REG_RSVD_NO,
	S2MPU01_REG_UVLO,
	S2MPU01_REG_LEE_NO,
	S2MPU01_REG_B1CTRL1,
	S2MPU01_REG_B1CTRL2,
	S2MPU01_REG_B2CTRL1,
	S2MPU01_REG_B2CTRL2,
	S2MPU01_REG_B3CTRL1,
	S2MPU01_REG_B3CTRL2,
	S2MPU01_REG_B4CTRL1,
	S2MPU01_REG_B4CTRL2,
	S2MPU01_REG_B5CTRL1,
	S2MPU01_REG_B5CTRL2,
	S2MPU01_REG_B5CTRL3,
	S2MPU01_REG_B5CTRL4,
	S2MPU01_REG_B5CTRL5,
	S2MPU01_REG_B6CTRL1,
	S2MPU01_REG_B6CTRL2,
	S2MPU01_REG_B7CTRL1,
	S2MPU01_REG_B7CTRL2,
	S2MPU01_REG_B8CTRL1,
	S2MPU01_REG_B8CTRL2,
	S2MPU01_REG_B9CTRL1,
	S2MPU01_REG_B9CTRL2,
	S2MPU01_REG_B12CTRL1,
	S2MPU01_REG_B12CTRL2,
	S2MPU01_REG_L1CTRL,
	S2MPU01_REG_L2CTRL,
	S2MPU01_REG_L2CTRL2,
	S2MPU01_REG_L2CTRL3,
	S2MPU01_REG_L2CTRL4,
	S2MPU01_REG_L3CTRL,
	S2MPU01_REG_L4CTRL,
	S2MPU01_REG_L5CTRL,
	S2MPU01_REG_L6CTRL,
	S2MPU01_REG_L7CTRL,
	S2MPU01_REG_L8CTRL,
	S2MPU01_REG_L9CTRL,
	S2MPU01_REG_L10CTRL,
	S2MPU01_REG_L11CTRL,
	S2MPU01_REG_L12CTRL,
	S2MPU01_REG_L26CTRL,
	S2MPU01_REG_L27CTRL,
	S2MPU01_REG_L28CTRL,
	S2MPU01_REG_L29CTRL,
	S2MPU01_REG_L30CTRL,
	S2MPU01_REG_L31CTRL,
	S2MPU01_REG_L32CTRL,
	S2MPU01_REG_L33CTRL,
	S2MPU01_REG_L34CTRL,
	S2MPU01_REG_L35CTRL,
	S2MPU01_REG_L36CTRL,
	S2MPU01_REG_L37CTRL,
	S2MPU01_REG_L38CTRL,
	S2MPU01_REG_L39CTRL,
	S2MPU01_REG_L40CTRL,
	S2MPU01_REG_L41CTRL,
	S2MPU01_REG_L42CTRL,
	S2MPU01_REG_L43CTRL,
	S2MPU01_REG_L44CTRL,
	S2MPU01_REG_L45CTRL,
	S2MPU01_REG_L46CTRL,
	S2MPU01_REG_L47CTRL,
	S2MPU01_REG_L48CTRL,
	S2MPU01_REG_L49CTRL,
};

/* S2MPU01 regulator ids */
enum S2MPU01_regulators {
	S2MPU01_LDO1,
	S2MPU01_LDO2,
	S2MPU01_LDO3,
	S2MPU01_LDO4,
	S2MPU01_LDO5,
	S2MPU01_LDO6,
	S2MPU01_LDO7,
	S2MPU01_LDO8,
	S2MPU01_LDO9,
	S2MPU01_LDO10,
	S2MPU01_LDO11,
	S2MPU01_LDO12,
	S2MPU01_LDO26,
	S2MPU01_LDO27,
	S2MPU01_LDO28,
	S2MPU01_LDO29,
	S2MPU01_LDO30,
	S2MPU01_LDO31,
	S2MPU01_LDO32,
	S2MPU01_LDO33,
	S2MPU01_LDO34,
	S2MPU01_LDO35,
	S2MPU01_LDO36,
	S2MPU01_LDO37,
	S2MPU01_LDO38,
	S2MPU01_LDO39,
	S2MPU01_LDO40,
	S2MPU01_LDO41,
	S2MPU01_LDO42,
	S2MPU01_LDO43,
	S2MPU01_LDO44,
	S2MPU01_LDO45,
	S2MPU01_LDO46,
	S2MPU01_LDO47,
	S2MPU01_LDO48,
	S2MPU01_LDO49,
	S2MPU01_BUCK1,
	S2MPU01_BUCK2,
	S2MPU01_BUCK3,
	S2MPU01_BUCK4,
	S2MPU01_BUCK5,
	S2MPU01_BUCK6,
	S2MPU01_BUCK7,
	S2MPU01_BUCK8,
	S2MPU01_BUCK9,
	S2MPU01_BUCK12,
	S2MPU01_AP_EN32KHZ,
	S2MPU01_CP_EN32KHZ,
	S2MPU01_BT_EN32KHZ,

	S2MPU01_REG_MAX,
};

#define S2MPU01_PMIC_EN_SHIFT	6

#endif /*  __LINUX_MFD_S2MPU01_H */
