/*
 * S2MPS14.h
 *
 * Copyright (c) 2013 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_S2MPS14_H
#define __LINUX_MFD_S2MPS14_H

/* S2MPU01A Revision Number */
enum s2mps14_revision_number {
	S2MPS14_REV_00 = 0x00,
	S2MPS14_REV_01 = 0x01,
};

/* S2MPS14 registers */
enum S2MPS14_reg {
	S2MPS14_REG_ID,
	S2MPS14_REG_INT1,
	S2MPS14_REG_INT2,
	S2MPS14_REG_INT3,
	S2MPS14_REG_INT1M,
	S2MPS14_REG_INT2M,
	S2MPS14_REG_INT3M,
	S2MPS14_REG_ST1,
	S2MPS14_REG_ST2,
	S2MPS14_REG_PWRONSRC,
	S2MPS14_REG_OFFSRC,
	S2MPS14_REG_BU_CHG,
	S2MPS14_REG_RTC_BUF,
	S2MPS14_REG_CTRL1,
	S2MPS14_REG_CTRL2,
	S2MPS14_REG_ETC_TEST,
	S2MPS14_REG_OTP_ADRL,
	S2MPS14_REG_OTP_ADRH,
	S2MPS14_REG_OTP_DATA,
	S2MPS14_REG_MON1SEL,
	S2MPS14_REG_MON2SEL,
	S2MPS14_REG_CTRL3,
	S2MPS14_REG_ETC_OTP,
	S2MPS14_REG_UVLO_OTP,
	S2MPS14_REG_LEE_NO,
	S2MPS14_REG_B1CTRL1,
	S2MPS14_REG_B1CTRL2,
	S2MPS14_REG_B2CTRL1,
	S2MPS14_REG_B2CTRL2,
	S2MPS14_REG_B3CTRL1,
	S2MPS14_REG_B3CTRL2,
	S2MPS14_REG_B4CTRL1,
	S2MPS14_REG_B4CTRL2,
	S2MPS14_REG_B5CTRL1,
	S2MPS14_REG_B5CTRL2,
	S2MPS14_REG_L1CTRL,
	S2MPS14_REG_L2CTRL,
	S2MPS14_REG_L3CTRL,
	S2MPS14_REG_L4CTRL,
	S2MPS14_REG_L5CTRL,
	S2MPS14_REG_L6CTRL,
	S2MPS14_REG_L7CTRL,
	S2MPS14_REG_L8CTRL,
	S2MPS14_REG_L9CTRL,
	S2MPS14_REG_L10CTRL,
	S2MPS14_REG_L11CTRL,
	S2MPS14_REG_L12CTRL,
	S2MPS14_REG_L13CTRL,
	S2MPS14_REG_L14CTRL,
	S2MPS14_REG_L15CTRL,
	S2MPS14_REG_L16CTRL,
	S2MPS14_REG_L17CTRL,
	S2MPS14_REG_L18CTRL,
	S2MPS14_REG_L19CTRL,
	S2MPS14_REG_L20CTRL,
	S2MPS14_REG_L21CTRL,
	S2MPS14_REG_L22CTRL,
	S2MPS14_REG_L23CTRL,
	S2MPS14_REG_L24CTRL,
	S2MPS14_REG_L25CTRL,
	S2MPS14_REG_LDO_DSCH1,
	S2MPS14_REG_LDO_DSCH2,
	S2MPS14_REG_LDO_DSCH3,
};

/* S2MPS14 regulator ids */
enum S2MPS14_regulators {
	S2MPS14_LDO1,
	S2MPS14_LDO2,
	S2MPS14_LDO3,
	S2MPS14_LDO4,
	S2MPS14_LDO5,
	S2MPS14_LDO6,
	S2MPS14_LDO7,
	S2MPS14_LDO8,
	S2MPS14_LDO9,
	S2MPS14_LDO10,
	S2MPS14_LDO11,
	S2MPS14_LDO12,
	S2MPS14_LDO13,
	S2MPS14_LDO14,
	S2MPS14_LDO15,
	S2MPS14_LDO16,
	S2MPS14_LDO17,
	S2MPS14_LDO18,
	S2MPS14_LDO19,
	S2MPS14_LDO20,
	S2MPS14_LDO21,
	S2MPS14_LDO22,
	S2MPS14_LDO23,
	S2MPS14_LDO24,
	S2MPS14_LDO25,

	S2MPS14_BUCK1,
	S2MPS14_BUCK2,
	S2MPS14_BUCK3,
	S2MPS14_BUCK4,
	S2MPS14_BUCK5,

	S2MPS14_AP_EN32KHZ,
	S2MPS14_CP_EN32KHZ,
	S2MPS14_BT_EN32KHZ,

	S2MPS14_REG_MAX,
};

#define S2MPS14_PMIC_EN_SHIFT	6

#endif /*  __LINUX_MFD_S2MPS14_H */
