#ifndef __DYNAMIC_AID_GAMMA_CURVE_H
#define __DYNAMIC_AID_GAMMA_CURVE_H __FILE__

static const int gamma_curve_1p60_table[256] = {
	0,	141,	428,	818,	1297,	1853,	2481,	3175,
	3931,	4746,	5617,	6543,	7520,	8548,	9624,	10747,
	11916,	13130,	14387,	15687,	17029,	18411,	19834,	21296,
	22797,	24335,	25912,	27524,	29174,	30858,	32578,	34333,
	36122,	37945,	39802,	41691,	43613,	45568,	47554,	49572,
	51622,	53702,	55813,	57954,	60126,	62327,	64558,	66818,
	69107,	71425,	73771,	76146,	78549,	80980,	83438,	85924,
	88438,	90978,	93545,	96139,	98759,	101406,	104079,	106778,
	109502,	112253,	115029,	117830,	120656,	123508,	126384,	129285,
	132211,	135161,	138136,	141135,	144158,	147204,	150275,	153370,
	156488,	159629,	162794,	165982,	169193,	172427,	175684,	178964,
	182267,	185592,	188940,	192310,	195702,	199117,	202554,	206012,
	209493,	212996,	216520,	220066,	223633,	227222,	230832,	234464,
	238116,	241790,	245485,	249201,	252938,	256695,	260474,	264273,
	268092,	271933,	275793,	279674,	283575,	287497,	291439,	295400,
	299382,	303384,	307405,	311447,	315508,	319589,	323689,	327810,
	331949,	336108,	340287,	344485,	348702,	352938,	357193,	361468,
	365761,	370074,	374406,	378756,	383125,	387513,	391920,	396345,
	400789,	405251,	409732,	414232,	418750,	423286,	427840,	432413,
	437004,	441613,	446240,	450886,	455549,	460230,	464929,	469647,
	474381,	479134,	483905,	488693,	493499,	498322,	503163,	508021,
	512897,	517791,	522702,	527630,	532576,	537538,	542518,	547516,
	552530,	557562,	562610,	567676,	572759,	577858,	582975,	588108,
	593259,	598426,	603610,	608811,	614028,	619262,	624513,	629780,
	635064,	640365,	645682,	651015,	656365,	661731,	667114,	672513,
	677928,	683360,	688808,	694272,	699752,	705248,	710760,	716289,
	721834,	727394,	732971,	738563,	744172,	749796,	755436,	761092,
	766764,	772452,	778155,	783874,	789609,	795359,	801125,	806907,
	812704,	818517,	824345,	830189,	836048,	841923,	847813,	853719,
	859640,	865576,	871527,	877494,	883476,	889474,	895486,	901514,
	907557,	913614,	919688,	925776,	931879,	937997,	944130,	950278,
	956441,	962620,	968812,	975020,	981243,	987481,	993733,	1000000
};

static const int gamma_curve_1p65_table[256] = {
	0,	107,	336,	655,	1053,	1522,	2057,	2652,
	3306,	4015,	4778,	5591,	6454,	7366,	8324,	9327,
	10375,	11467,	12601,	13777,	14994,	16251,	17547,	18883,
	20256,	21668,	23116,	24601,	26123,	27680,	29272,	30900,
	32562,	34258,	35987,	37750,	39546,	41375,	43237,	45130,
	47055,	49012,	51000,	53019,	55069,	57149,	59260,	61400,
	63571,	65771,	68000,	70259,	72546,	74862,	77207,	79581,
	81982,	84412,	86869,	89354,	91867,	94407,	96974,	99568,
	102189,	104837,	107512,	110213,	112940,	115694,	118473,	121279,
	124110,	126967,	129850,	132758,	135691,	138650,	141633,	144642,
	147675,	150733,	153816,	156923,	160055,	163211,	166392,	169596,
	172824,	176077,	179353,	182653,	185977,	189324,	192695,	196089,
	199506,	202947,	206410,	209897,	213407,	216940,	220495,	224073,
	227674,	231298,	234943,	238612,	242303,	246015,	249751,	253508,
	257287,	261089,	264912,	268757,	272624,	276513,	280423,	284355,
	288309,	292284,	296280,	300298,	304337,	308397,	312478,	316581,
	320705,	324849,	329015,	333201,	337408,	341636,	345885,	350154,
	354444,	358755,	363086,	367437,	371809,	376201,	380614,	385046,
	389499,	393972,	398466,	402979,	407512,	412065,	416638,	421231,
	425844,	430477,	435129,	439801,	444492,	449203,	453934,	458684,
	463454,	468243,	473052,	477879,	482726,	487593,	492478,	497383,
	502307,	507250,	512212,	517193,	522193,	527211,	532249,	537306,
	542381,	547475,	552588,	557720,	562870,	568039,	573227,	578433,
	583658,	588901,	594162,	599442,	604741,	610057,	615392,	620746,
	626117,	631507,	636915,	642341,	647785,	653248,	658728,	664227,
	669743,	675277,	680830,	686400,	691988,	697594,	703217,	708859,
	714518,	720195,	725890,	731602,	737332,	743079,	748844,	754627,
	760427,	766244,	772079,	777932,	783802,	789689,	795593,	801515,
	807454,	813411,	819384,	825375,	831383,	837408,	843451,	849510,
	855586,	861680,	867790,	873918,	880062,	886224,	892402,	898598,
	904810,	911039,	917285,	923547,	929826,	936123,	942435,	948765,
	955111,	961474,	967854,	974250,	980663,	987092,	993538,	1000000
};

static const int gamma_curve_1p70_table[256] = {
	0,	81,	263,	525,	856,	1251,	1705,	2216,
	2781,	3397,	4063,	4778,	5540,	6347,	7199,	8095,
	9034,	10015,	11037,	12099,	13202,	14343,	15524,	16742,
	17999,	19292,	20622,	21989,	23391,	24829,	26302,	27810,
	29352,	30928,	32538,	34182,	35859,	37569,	39311,	41086,
	42893,	44732,	46602,	48504,	50437,	52401,	54396,	56422,
	58478,	60564,	62680,	64826,	67002,	69207,	71442,	73705,
	75998,	78319,	80669,	83048,	85455,	87891,	90354,	92845,
	95365,	97912,	100486,	103088,	105717,	108374,	111058,	113768,
	116506,	119270,	122061,	124878,	127722,	130592,	133488,	136410,
	139359,	142333,	145333,	148359,	151411,	154488,	157590,	160718,
	163871,	167049,	170253,	173481,	176734,	180013,	183315,	186643,
	189995,	193372,	196773,	200199,	203649,	207123,	210621,	214144,
	217690,	221260,	224855,	228473,	232114,	235780,	239469,	243182,
	246918,	250677,	254460,	258266,	262096,	265949,	269824,	273723,
	277645,	281590,	285557,	289548,	293561,	297597,	301656,	305737,
	309841,	313967,	318116,	322287,	326481,	330696,	334934,	339195,
	343477,	347782,	352108,	356457,	360827,	365220,	369634,	374070,
	378528,	383008,	387509,	392032,	396576,	401142,	405730,	410339,
	414969,	419621,	424294,	428988,	433704,	438441,	443199,	447978,
	452778,	457600,	462442,	467305,	472189,	477094,	482020,	486967,
	491935,	496923,	501932,	506962,	512012,	517083,	522174,	527286,
	532419,	537572,	542745,	547939,	553153,	558387,	563642,	568917,
	574212,	579527,	584862,	590218,	595594,	600989,	606405,	611841,
	617296,	622772,	628268,	633783,	639318,	644873,	650448,	656042,
	661657,	667291,	672944,	678617,	684310,	690023,	695754,	701506,
	707277,	713067,	718877,	724706,	730555,	736422,	742310,	748216,
	754142,	760087,	766051,	772034,	778037,	784059,	790099,	796159,
	802238,	808336,	814453,	820589,	826744,	832918,	839110,	845322,
	851552,	857801,	864069,	870356,	876662,	882986,	889329,	895691,
	902071,	908470,	914888,	921324,	927779,	934252,	940744,	947254,
	953783,	960330,	966896,	973480,	980082,	986703,	993342,	1000000
};

static const int gamma_curve_1p75_table[256] = {
	0,	61,	207,	420,	695,	1027,	1414,	1851,
	2339,	2874,	3456,	4083,	4755,	5470,	6227,	7026,
	7866,	8747,	9667,	10626,	11624,	12660,	13734,	14845,
	15993,	17177,	18397,	19654,	20945,	22272,	23633,	25029,
	26459,	27922,	29420,	30951,	32515,	34112,	35742,	37404,
	39098,	40825,	42583,	44374,	46195,	48048,	49932,	51847,
	53793,	55770,	57777,	59814,	61881,	63979,	66106,	68264,
	70450,	72667,	74912,	77187,	79491,	81824,	84186,	86577,
	88996,	91444,	93920,	96424,	98957,	101517,	104106,	106723,
	109367,	112039,	114739,	117466,	120220,	123002,	125811,	128648,
	131511,	134401,	137318,	140262,	143233,	146230,	149254,	152305,
	155382,	158485,	161614,	164770,	167951,	171159,	174393,	177652,
	180938,	184249,	187586,	190949,	194337,	197750,	201189,	204654,
	208144,	211659,	215199,	218764,	222355,	225970,	229611,	233276,
	236966,	240681,	244421,	248185,	251974,	255788,	259626,	263489,
	267376,	271287,	275223,	279183,	283167,	287175,	291208,	295264,
	299345,	303450,	307578,	311731,	315907,	320107,	324331,	328578,
	332849,	337144,	341463,	345804,	350170,	354559,	358971,	363407,
	367865,	372348,	376853,	381382,	385934,	390509,	395107,	399728,
	404372,	409039,	413729,	418442,	423178,	427936,	432718,	437522,
	442349,	447198,	452070,	456965,	461882,	466822,	471785,	476770,
	481777,	486807,	491859,	496933,	502030,	507149,	512290,	517453,
	522639,	527847,	533077,	538329,	543603,	548899,	554217,	559557,
	564919,	570302,	575708,	581136,	586585,	592056,	597549,	603064,
	608600,	614158,	619737,	625339,	630961,	636606,	642272,	647959,
	653668,	659398,	665150,	670923,	676718,	682533,	688371,	694229,
	700109,	706010,	711932,	717875,	723840,	729825,	735832,	741860,
	747909,	753979,	760070,	766182,	772315,	778469,	784644,	790839,
	797056,	803293,	809551,	815830,	822130,	828451,	834792,	841154,
	847537,	853940,	860364,	866809,	873274,	879760,	886267,	892793,
	899341,	905909,	912497,	919106,	925735,	932385,	939055,	945746,
	952456,	959188,	965939,	972711,	979503,	986315,	993147,	1000000
};

static const int gamma_curve_1p80_table[256] = {
	0,	47,	162,	337,	565,	844,	1172,	1547,
	1967,	2431,	2939,	3489,	4081,	4713,	5386,	6098,
	6849,	7639,	8467,	9332,	10235,	11174,	12150,	13162,
	14210,	15294,	16413,	17566,	18755,	19978,	21235,	22526,
	23851,	25209,	26600,	28025,	29483,	30974,	32497,	34052,
	35640,	37260,	38911,	40595,	42310,	44057,	45834,	47644,
	49484,	51355,	53257,	55189,	57152,	59146,	61170,	63224,
	65308,	67422,	69566,	71740,	73943,	76177,	78439,	80731,
	83052,	85403,	87782,	90191,	92628,	95095,	97590,	100114,
	102666,	105247,	107856,	110494,	113160,	115854,	118576,	121327,
	124105,	126911,	129746,	132608,	135497,	138415,	141359,	144332,
	147332,	150359,	153414,	156496,	159605,	162741,	165904,	169095,
	172312,	175556,	178828,	182126,	185450,	188802,	192180,	195585,
	199016,	202474,	205958,	209468,	213005,	216569,	220158,	223774,
	227416,	231083,	234777,	238497,	242243,	246015,	249813,	253637,
	257486,	261361,	265262,	269189,	273141,	277119,	281122,	285151,
	289205,	293285,	297390,	301520,	305676,	309857,	314063,	318294,
	322550,	326832,	331139,	335470,	339827,	344209,	348616,	353047,
	357503,	361985,	366491,	371021,	375577,	380157,	384762,	389391,
	394045,	398724,	403427,	408155,	412907,	417683,	422484,	427309,
	432159,	437033,	441931,	446854,	451800,	456771,	461766,	466785,
	471829,	476896,	481987,	487103,	492242,	497406,	502593,	507804,
	513039,	518298,	523581,	528887,	534218,	539572,	544949,	550351,
	555776,	561225,	566697,	572193,	577713,	583256,	588822,	594412,
	600026,	605663,	611323,	617007,	622714,	628444,	634198,	639975,
	645776,	651599,	657446,	663316,	669209,	675126,	681065,	687028,
	693013,	699022,	705054,	711109,	717187,	723288,	729411,	735558,
	741728,	747920,	754135,	760374,	766635,	772919,	779225,	785555,
	791907,	798282,	804679,	811100,	817543,	824008,	830496,	837007,
	843541,	850097,	856675,	863276,	869900,	876546,	883215,	889906,
	896619,	903355,	910113,	916894,	923697,	930522,	937370,	944240,
	951132,	958046,	964983,	971942,	978923,	985927,	992952,	1000000
};

static const int gamma_curve_1p85_table[256] = {
	0,	35,	127,	270,	459,	693,	972,	1292,
	1654,	2057,	2500,	2982,	3503,	4062,	4658,	5293,
	5964,	6672,	7416,	8196,	9012,	9863,	10749,	11671,
	12627,	13617,	14642,	15701,	16794,	17920,	19080,	20273,
	21499,	22759,	24051,	25376,	26734,	28124,	29546,	31001,
	32487,	34006,	35556,	37138,	38751,	40397,	42073,	43781,
	45519,	47289,	49090,	50922,	52785,	54678,	56602,	58556,
	60541,	62556,	64601,	66677,	68783,	70919,	73085,	75280,
	77506,	79761,	82046,	84360,	86705,	89078,	91481,	93914,
	96375,	98866,	101386,	103936,	106514,	109121,	111757,	114422,
	117116,	119839,	122590,	125370,	128179,	131016,	133882,	136776,
	139699,	142650,	145629,	148637,	151673,	154737,	157829,	160949,
	164098,	167274,	170478,	173710,	176970,	180258,	183574,	186917,
	190288,	193687,	197114,	200568,	204049,	207558,	211095,	214659,
	218250,	221869,	225515,	229188,	232888,	236616,	240371,	244153,
	247962,	251799,	255662,	259552,	263470,	267414,	271385,	275383,
	279408,	283460,	287538,	291644,	295776,	299934,	304120,	308332,
	312570,	316835,	321127,	325445,	329790,	334161,	338559,	342983,
	347433,	351910,	356413,	360942,	365498,	370080,	374688,	379322,
	383982,	388669,	393382,	398120,	402885,	407676,	412493,	417336,
	422204,	427099,	432020,	436966,	441938,	446937,	451961,	457010,
	462086,	467187,	472314,	477467,	482646,	487850,	493079,	498335,
	503616,	508922,	514254,	519612,	524995,	530403,	535837,	541296,
	546781,	552292,	557827,	563388,	568974,	574586,	580223,	585885,
	591572,	597285,	603023,	608786,	614574,	620388,	626226,	632090,
	637979,	643893,	649831,	655795,	661784,	667798,	673837,	679901,
	685990,	692104,	698243,	704406,	710595,	716808,	723046,	729309,
	735597,	741910,	748247,	754610,	760996,	767408,	773844,	780305,
	786791,	793302,	799837,	806396,	812981,	819589,	826223,	832881,
	839563,	846270,	853002,	859758,	866539,	873344,	880173,	887027,
	893905,	900808,	907735,	914687,	921662,	928663,	935687,	942736,
	949809,	956906,	964028,	971174,	978344,	985539,	992757,	1000000
};

static const int gamma_curve_1p90_table[256] = {
	0,	27,	100,	216,	373,	570,	805,	1080,
	1391,	1740,	2126,	2548,	3006,	3500,	4029,	4594,
	5193,	5827,	6495,	7198,	7935,	8705,	9510,	10348,
	11220,	12124,	13062,	14033,	15037,	16074,	17144,	18246,
	19380,	20547,	21746,	22978,	24241,	25536,	26863,	28223,
	29613,	31036,	32490,	33975,	35492,	37041,	38620,	40231,
	41873,	43546,	45250,	46985,	48751,	50547,	52375,	54233,
	56122,	58041,	59991,	61972,	63982,	66024,	68095,	70197,
	72330,	74492,	76684,	78907,	81160,	83442,	85755,	88098,
	90470,	92872,	95305,	97766,	100258,	102779,	105330,	107911,
	110521,	113161,	115830,	118528,	121256,	124014,	126800,	129616,
	132462,	135336,	138240,	141173,	144135,	147127,	150147,	153196,
	156275,	159382,	162519,	165684,	168878,	172101,	175353,	178634,
	181944,	185282,	188649,	192045,	195469,	198923,	202404,	205915,
	209454,	213021,	216617,	220242,	223895,	227576,	231286,	235024,
	238791,	242586,	246409,	250261,	254141,	258049,	261986,	265950,
	269943,	273964,	278014,	282091,	286196,	290330,	294492,	298681,
	302899,	307144,	311418,	315720,	320049,	324407,	328792,	333205,
	337647,	342116,	346612,	351137,	355689,	360270,	364877,	369513,
	374176,	378868,	383586,	388333,	393107,	397908,	402738,	407594,
	412479,	417391,	422330,	427297,	432292,	437314,	442363,	447440,
	452545,	457676,	462835,	468022,	473236,	478477,	483746,	489042,
	494365,	499716,	505093,	510498,	515931,	521390,	526877,	532391,
	537932,	543500,	549096,	554719,	560368,	566045,	571749,	577480,
	583238,	589023,	594836,	600675,	606541,	612434,	618354,	624302,
	630276,	636277,	642305,	648360,	654442,	660550,	666686,	672849,
	679038,	685254,	691497,	697767,	704063,	710387,	716737,	723114,
	729518,	735948,	742405,	748889,	755400,	761937,	768501,	775091,
	781709,	788352,	795023,	801720,	808444,	815194,	821971,	828775,
	835605,	842461,	849344,	856254,	863190,	870153,	877142,	884158,
	891200,	898268,	905363,	912485,	919633,	926807,	934007,	941235,
	948488,	955768,	963074,	970407,	977765,	985151,	992562,	1000000
};

static const int gamma_curve_1p95_table[256] = {
	0,	20,	78,	173,	303,	468,	668,	902,
	1170,	1472,	1808,	2178,	2580,	3016,	3485,	3987,
	4521,	5089,	5689,	6321,	6986,	7684,	8413,	9175,
	9969,	10795,	11653,	12543,	13465,	14419,	15404,	16421,
	17470,	18550,	19662,	20806,	21980,	23187,	24424,	25693,
	26994,	28325,	29688,	31082,	32507,	33963,	35451,	36969,
	38518,	40099,	41710,	43352,	45025,	46729,	48463,	50229,
	52025,	53852,	55710,	57598,	59517,	61467,	63447,	65458,
	67499,	69571,	71673,	73806,	75969,	78163,	80387,	82642,
	84927,	87242,	89588,	91964,	94370,	96806,	99273,	101770,
	104297,	106854,	109442,	112060,	114707,	117385,	120093,	122831,
	125599,	128398,	131226,	134084,	136972,	139891,	142839,	145817,
	148825,	151863,	154931,	158028,	161156,	164314,	167501,	170718,
	173965,	177242,	180548,	183884,	187250,	190646,	194072,	197527,
	201012,	204527,	208071,	211645,	215248,	218882,	222544,	226237,
	229959,	233710,	237492,	241302,	245143,	249013,	252912,	256841,
	260799,	264787,	268804,	272851,	276927,	281033,	285168,	289333,
	293527,	297750,	302003,	306285,	310596,	314937,	319307,	323707,
	328136,	332594,	337081,	341598,	346144,	350719,	355324,	359958,
	364621,	369313,	374035,	378786,	383566,	388375,	393213,	398081,
	402977,	407903,	412858,	417842,	422856,	427898,	432970,	438070,
	443200,	448359,	453547,	458764,	464010,	469285,	474589,	479922,
	485284,	490676,	496096,	501545,	507023,	512531,	518067,	523632,
	529226,	534849,	540501,	546182,	551892,	557631,	563399,	569196,
	575021,	580876,	586759,	592672,	598613,	604583,	610582,	616609,
	622666,	628751,	634866,	641009,	647181,	653381,	659611,	665869,
	672156,	678472,	684817,	691190,	697592,	704023,	710483,	716971,
	723488,	730034,	736609,	743212,	749844,	756505,	763194,	769912,
	776659,	783434,	790238,	797071,	803933,	810823,	817741,	824689,
	831665,	838669,	845702,	852764,	859855,	866974,	874121,	881298,
	888502,	895736,	902998,	910288,	917607,	924955,	932331,	939736,
	947169,	954631,	962121,	969640,	977187,	984763,	992367,	1000000
};

static const int gamma_curve_2p00_table[256] = {
	0,	15,	62,	138,	246,	384,	554,	754,
	984,	1246,	1538,	1861,	2215,	2599,	3014,	3460,
	3937,	4444,	4983,	5552,	6151,	6782,	7443,	8135,
	8858,	9612,	10396,	11211,	12057,	12933,	13841,	14779,
	15748,	16747,	17778,	18839,	19931,	21053,	22207,	23391,
	24606,	25852,	27128,	28435,	29773,	31142,	32541,	33972,
	35433,	36924,	38447,	40000,	41584,	43199,	44844,	46521,
	48228,	49965,	51734,	53533,	55363,	57224,	59116,	61038,
	62991,	64975,	66990,	69035,	71111,	73218,	75356,	77524,
	79723,	81953,	84214,	86505,	88827,	91180,	93564,	95978,
	98424,	100900,	103406,	105944,	108512,	111111,	113741,	116401,
	119093,	121815,	124567,	127351,	130165,	133010,	135886,	138793,
	141730,	144698,	147697,	150727,	153787,	156878,	160000,	163153,
	166336,	169550,	172795,	176071,	179377,	182714,	186082,	189481,
	192910,	196371,	199862,	203383,	206936,	210519,	214133,	217778,
	221453,	225160,	228897,	232664,	236463,	240292,	244152,	248043,
	251965,	255917,	259900,	263914,	267958,	272034,	276140,	280277,
	284444,	288643,	292872,	297132,	301423,	305744,	310096,	314479,
	318893,	323337,	327812,	332318,	336855,	341423,	346021,	350650,
	355309,	360000,	364721,	369473,	374256,	379070,	383914,	388789,
	393695,	398631,	403599,	408597,	413626,	418685,	423775,	428897,
	434048,	439231,	444444,	449689,	454963,	460269,	465606,	470973,
	476371,	481799,	487259,	492749,	498270,	503822,	509404,	515017,
	520661,	526336,	532042,	537778,	543545,	549343,	555171,	561030,
	566920,	572841,	578793,	584775,	590788,	596832,	602907,	609012,
	615148,	621315,	627512,	633741,	640000,	646290,	652611,	658962,
	665344,	671757,	678201,	684675,	691180,	697716,	704283,	710880,
	717509,	724168,	730857,	737578,	744329,	751111,	757924,	764767,
	771642,	778547,	785483,	792449,	799446,	806474,	813533,	820623,
	827743,	834894,	842076,	849289,	856532,	863806,	871111,	878447,
	885813,	893210,	900638,	908097,	915586,	923106,	930657,	938239,
	945852,	953495,	961169,	968874,	976609,	984375,	992172,	1000000
};

static const int gamma_curve_2p05_table[256] = {
	0,	12,	48,	111,	200,	316,	459,	630,
	828,	1054,	1308,	1590,	1901,	2240,	2607,	3003,
	3428,	3882,	4364,	4876,	5416,	5986,	6585,	7213,
	7871,	8558,	9274,	10020,	10796,	11601,	12436,	13301,
	14195,	15120,	16074,	17058,	18072,	19116,	20191,	21295,
	22429,	23594,	24789,	26014,	27269,	28555,	29871,	31217,
	32594,	34001,	35439,	36907,	38406,	39935,	41495,	43086,
	44707,	46359,	48042,	49755,	51499,	53274,	55080,	56917,
	58784,	60683,	62612,	64572,	66563,	68586,	70639,	72723,
	74838,	76985,	79162,	81371,	83610,	85881,	88183,	90517,
	92881,	95277,	97704,	100162,	102651,	105172,	107724,	110308,
	112923,	115569,	118247,	120956,	123697,	126469,	129272,	132107,
	134974,	137872,	140801,	143762,	146755,	149779,	152835,	155923,
	159042,	162192,	165375,	168589,	171835,	175112,	178422,	181763,
	185135,	188540,	191976,	195444,	198944,	202476,	206040,	209635,
	213262,	216922,	220613,	224336,	228090,	231877,	235696,	239547,
	243429,	247344,	251291,	255269,	259280,	263323,	267398,	271504,
	275643,	279814,	284017,	288252,	292520,	296819,	301151,	305514,
	309910,	314338,	318798,	323291,	327815,	332372,	336961,	341582,
	346236,	350922,	355640,	360390,	365172,	369987,	374835,	379714,
	384626,	389570,	394547,	399556,	404597,	409671,	414777,	419915,
	425086,	430289,	435525,	440793,	446094,	451427,	456792,	462190,
	467621,	473084,	478579,	484107,	489667,	495261,	500886,	506544,
	512235,	517958,	523714,	529502,	535323,	541177,	547063,	552982,
	558934,	564918,	570934,	576984,	583066,	589181,	595328,	601508,
	607721,	613966,	620245,	626555,	632899,	639275,	645685,	652126,
	658601,	665109,	671649,	678222,	684827,	691466,	698137,	704842,
	711579,	718348,	725151,	731986,	738855,	745756,	752690,	759657,
	766657,	773690,	780755,	787854,	794985,	802150,	809347,	816577,
	823840,	831136,	838465,	845827,	853222,	860650,	868111,	875605,
	883132,	890692,	898285,	905911,	913570,	921262,	928987,	936745,
	944536,	952360,	960218,	968108,	976031,	983988,	991977,	1000000
};

static const int gamma_curve_2p10_table[256] = {
	0,	9,	38,	89,	162,	259,	381,	526,
	696,	892,	1112,	1359,	1631,	1930,	2255,	2606,
	2985,	3390,	3822,	4282,	4769,	5284,	5826,	6396,
	6994,	7620,	8274,	8956,	9667,	10406,	11174,	11971,
	12796,	13650,	14534,	15446,	16387,	17358,	18357,	19387,
	20445,	21533,	22651,	23798,	24976,	26183,	27419,	28686,
	29983,	31310,	32667,	34054,	35471,	36919,	38397,	39905,
	41444,	43013,	44613,	46244,	47905,	49597,	51320,	53074,
	54858,	56674,	58520,	60398,	62307,	64246,	66217,	68219,
	70253,	72318,	74414,	76541,	78700,	80890,	83112,	85366,
	87651,	89967,	92316,	94696,	97107,	99551,	102026,	104534,
	107073,	109644,	112247,	114882,	117549,	120249,	122980,	125743,
	128539,	131367,	134227,	137120,	140044,	143001,	145991,	149013,
	152067,	155154,	158273,	161425,	164610,	167827,	171076,	174359,
	177674,	181022,	184402,	187815,	191261,	194740,	198252,	201797,
	205374,	208985,	212628,	216305,	220014,	223757,	227533,	231341,
	235183,	239058,	242967,	246908,	250883,	254891,	258932,	263007,
	267114,	271256,	275430,	279638,	283880,	288155,	292463,	296805,
	301181,	305589,	310032,	314508,	319018,	323561,	328139,	332749,
	337394,	342072,	346784,	351530,	356309,	361123,	365970,	370851,
	375766,	380715,	385698,	390715,	395765,	400850,	405969,	411122,
	416308,	421529,	426784,	432073,	437397,	442754,	448146,	453571,
	459031,	464525,	470054,	475617,	481214,	486845,	492511,	498211,
	503945,	509714,	515517,	521354,	527226,	533133,	539074,	545049,
	551059,	557104,	563183,	569296,	575444,	581627,	587845,	594097,
	600383,	606705,	613061,	619451,	625877,	632337,	638832,	645362,
	651926,	658526,	665160,	671829,	678533,	685272,	692045,	698854,
	705697,	712576,	719489,	726438,	733421,	740439,	747493,	754581,
	761704,	768863,	776057,	783285,	790549,	797848,	805182,	812551,
	819956,	827395,	834870,	842380,	849925,	857506,	865122,	872773,
	880459,	888181,	895938,	903730,	911558,	919421,	927319,	935253,
	943222,	951227,	959267,	967343,	975454,	983600,	991782,	1000000
};

static const int gamma_curve_2p12_table[256] = {
	0,	8,	34,	81,	149,	240,	353,	489,
	650,	834,	1043,	1276,	1535,	1818,	2128,	2463,
	2824,	3211,	3625,	4065,	4532,	5026,	5547,	6095,
	6671,	7274,	7905,	8563,	9249,	9964,	10706,	11477,
	12276,	13103,	13960,	14844,	15758,	16700,	17672,	18672,
	19702,	20760,	21849,	22966,	24113,	25290,	26496,	27732,
	28998,	30294,	31619,	32975,	34361,	35777,	37223,	38699,
	40206,	41744,	43311,	44910,	46539,	48199,	49889,	51610,
	53363,	55146,	56960,	58805,	60681,	62589,	64527,	66497,
	68498,	70531,	72595,	74690,	76817,	78976,	81166,	83388,
	85642,	87927,	90244,	92593,	94974,	97387,	99832,	102309,
	104819,	107360,	109933,	112539,	115177,	117847,	120550,	123285,
	126052,	128852,	131684,	134549,	137447,	140377,	143340,	146336,
	149364,	152425,	155519,	158646,	161805,	164998,	168224,	171482,
	174774,	178099,	181457,	184848,	188272,	191729,	195220,	198744,
	202301,	205892,	209516,	213174,	216865,	220589,	224347,	228139,
	231964,	235822,	239715,	243641,	247601,	251594,	255621,	259682,
	263777,	267906,	272069,	276265,	280496,	284760,	289059,	293391,
	297758,	302159,	306593,	311062,	315566,	320103,	324675,	329280,
	333921,	338595,	343304,	348047,	352825,	357637,	362483,	367364,
	372280,	377230,	382214,	387233,	392287,	397375,	402498,	407656,
	412848,	418075,	423337,	428634,	433965,	439332,	444733,	450169,
	455640,	461146,	466686,	472262,	477873,	483519,	489200,	494916,
	500667,	506453,	512274,	518130,	524022,	529949,	535911,	541908,
	547941,	554008,	560111,	566250,	572424,	578633,	584878,	591158,
	597473,	603824,	610211,	616633,	623090,	629583,	636112,	642676,
	649276,	655911,	662582,	669289,	676031,	682810,	689623,	696473,
	703359,	710280,	717237,	724230,	731258,	738323,	745424,	752560,
	759732,	766941,	774185,	781465,	788781,	796134,	803522,	810947,
	818407,	825904,	833436,	841005,	848610,	856251,	863929,	871642,
	879392,	887178,	895001,	902859,	910754,	918686,	926653,	934657,
	942698,	950774,	958887,	967037,	975223,	983446,	991705,	1000000
};

static const int gamma_curve_2p13_table[256] = {
	0,	7,	33,	78,	143,	231,	340,	472,
	628,	807,	1009,	1237,	1488,	1765,	2067,	2394,
	2747,	3126,	3530,	3961,	4418,	4902,	5413,	5950,
	6515,	7107,	7726,	8373,	9047,	9749,	10479,	11238,
	12024,	12838,	13681,	14552,	15452,	16381,	17338,	18325,
	19340,	20384,	21458,	22561,	23693,	24855,	26046,	27267,
	28518,	29798,	31108,	32448,	33819,	35219,	36650,	38110,
	39601,	41123,	42675,	44257,	45870,	47514,	49189,	50894,
	52630,	54397,	56195,	58024,	59884,	61776,	63698,	65652,
	67638,	69654,	71702,	73782,	75893,	78036,	80210,	82417,
	84655,	86925,	89226,	91560,	93926,	96323,	98753,	101215,
	103709,	106236,	108794,	111385,	114009,	116664,	119353,	122073,
	124827,	127612,	130431,	133282,	136166,	139083,	142033,	145015,
	148030,	151078,	154160,	157274,	160421,	163602,	166815,	170062,
	173342,	176655,	180002,	183382,	186795,	190242,	193722,	197235,
	200782,	204363,	207977,	211625,	215307,	219022,	222771,	226554,
	230370,	234221,	238105,	242023,	245976,	249962,	253982,	258036,
	262124,	266247,	270403,	274594,	278819,	283078,	287371,	291699,
	296061,	300458,	304888,	309354,	313853,	318388,	322956,	327560,
	332197,	336870,	341577,	346319,	351095,	355906,	360752,	365633,
	370548,	375499,	380484,	385504,	390559,	395649,	400774,	405934,
	411129,	416359,	421624,	426925,	432260,	437631,	443036,	448477,
	453954,	459465,	465012,	470594,	476211,	481864,	487553,	493276,
	499035,	504830,	510660,	516526,	522427,	528364,	534336,	540344,
	546388,	552467,	558582,	564733,	570919,	577142,	583400,	589694,
	596023,	602389,	608790,	615228,	621701,	628210,	634756,	641337,
	647954,	654608,	661297,	668022,	674784,	681582,	688416,	695286,
	702192,	709135,	716113,	723128,	730180,	737267,	744391,	751552,
	758748,	765981,	773251,	780557,	787899,	795278,	802693,	810145,
	817634,	825159,	832720,	840319,	847953,	855625,	863333,	871078,
	878859,	886678,	894533,	902424,	910353,	918318,	926320,	934359,
	942435,	950548,	958698,	966884,	975108,	983368,	991666,	1000000
};

static const int gamma_curve_2p15_table[256] = {
	0,	7,	30,	71,	132,	213,	315,	439,
	586,	754,	946,	1161,	1400,	1663,	1950,	2262,
	2599,	2961,	3348,	3761,	4199,	4663,	5154,	5671,
	6214,	6784,	7381,	8005,	8656,	9335,	10040,	10774,
	11535,	12324,	13141,	13986,	14859,	15761,	16691,	17649,
	18637,	19653,	20698,	21772,	22875,	24007,	25169,	26360,
	27581,	28831,	30111,	31421,	32760,	34130,	35529,	36959,
	38419,	39909,	41429,	42980,	44562,	46174,	47817,	49490,
	51195,	52930,	54696,	56494,	58322,	60182,	62073,	63995,
	65948,	67933,	69950,	71998,	74078,	76189,	78333,	80508,
	82715,	84954,	87224,	89528,	91863,	94230,	96630,	99062,
	101526,	104022,	106552,	109113,	111708,	114334,	116994,	119686,
	122411,	125169,	127960,	130784,	133641,	136530,	139453,	142409,
	145399,	148421,	151477,	154566,	157688,	160844,	164034,	167257,
	170513,	173803,	177127,	180484,	183875,	187300,	190759,	194252,
	197778,	201339,	204933,	208562,	212224,	215921,	219652,	223417,
	227217,	231050,	234918,	238821,	242757,	246729,	250734,	254775,
	258849,	262959,	267103,	271282,	275495,	279743,	284026,	288344,
	292697,	297084,	301507,	305964,	310457,	314984,	319547,	324145,
	328778,	333446,	338149,	342888,	347661,	352471,	357315,	362195,
	367110,	372061,	377047,	382069,	387126,	392219,	397348,	402512,
	407712,	412948,	418219,	423526,	428869,	434248,	439663,	445113,
	450600,	456122,	461681,	467275,	472906,	478572,	484275,	490014,
	495789,	501600,	507448,	513332,	519252,	525208,	531201,	537230,
	543296,	549398,	555536,	561711,	567923,	574171,	580455,	586777,
	593134,	599529,	605960,	612428,	618933,	625474,	632052,	638668,
	645319,	652008,	658734,	665497,	672296,	679133,	686006,	692917,
	699865,	706850,	713872,	720931,	728027,	735160,	742331,	749539,
	756784,	764066,	771386,	778743,	786138,	793569,	801039,	808545,
	816089,	823671,	831290,	838947,	846641,	854373,	862143,	869950,
	877794,	885677,	893597,	901555,	909550,	917584,	925655,	933764,
	941911,	950095,	958318,	966578,	974877,	983213,	991588,	1000000
};

static const int gamma_curve_2p18_table[256] = {
	0,	6,	26,	62,	116,	189,	282,	395,
	528,	682,	859,	1057,	1277,	1521,	1788,	2078,
	2392,	2730,	3092,	3479,	3890,	4327,	4789,	5276,
	5789,	6328,	6893,	7484,	8101,	8745,	9416,	10114,
	10839,	11591,	12370,	13177,	14011,	14874,	15764,	16683,
	17629,	18604,	19608,	20640,	21700,	22790,	23909,	25056,
	26233,	27439,	28675,	29940,	31234,	32558,	33913,	35297,
	36711,	38155,	39629,	41134,	42669,	44235,	45831,	47457,
	49115,	50803,	52523,	54273,	56055,	57867,	59711,	61587,
	63493,	65431,	67401,	69403,	71436,	73501,	75598,	77727,
	79887,	82080,	84306,	86563,	88853,	91175,	93530,	95917,
	98336,	100789,	103274,	105792,	108343,	110926,	113543,	116193,
	118876,	121592,	124341,	127124,	129940,	132789,	135672,	138589,
	141539,	144522,	147540,	150591,	153676,	156795,	159948,	163135,
	166356,	169611,	172900,	176223,	179581,	182973,	186400,	189861,
	193356,	196886,	200450,	204050,	207683,	211352,	215055,	218794,
	222567,	226375,	230218,	234096,	238009,	241957,	245941,	249960,
	254014,	258103,	262228,	266388,	270584,	274815,	279081,	283384,
	287722,	292095,	296505,	300950,	305431,	309948,	314501,	319089,
	323714,	328375,	333072,	337805,	342574,	347379,	352221,	357099,
	362013,	366963,	371950,	376974,	382034,	387131,	392264,	397433,
	402640,	407883,	413163,	418479,	423833,	429223,	434650,	440114,
	445615,	451153,	456728,	462341,	467990,	473676,	479400,	485161,
	490959,	496794,	502667,	508577,	514525,	520510,	526533,	532593,
	538690,	544825,	550998,	557209,	563457,	569743,	576066,	582428,
	588827,	595264,	601739,	608252,	614803,	621392,	628019,	634684,
	641387,	648129,	654908,	661726,	668582,	675476,	682409,	689379,
	696388,	703436,	710522,	717647,	724809,	732011,	739251,	746530,
	753847,	761203,	768597,	776030,	783502,	791013,	798563,	806151,
	813779,	821445,	829150,	836894,	844677,	852499,	860360,	868260,
	876199,	884178,	892195,	900252,	908348,	916483,	924658,	932871,
	941124,	949417,	957749,	966120,	974531,	982981,	991471,	1000000
};

static const int gamma_curve_2p20_table[256] = {
	0,	5,	23,	57,	107,	175,	262,	367,
	493,	638,	805,	992,	1202,	1433,	1687,	1963,
	2263,	2586,	2932,	3303,	3697,	4116,	4560,	5028,
	5522,	6041,	6585,	7155,	7751,	8373,	9021,	9696,
	10398,	11126,	11881,	12664,	13473,	14311,	15175,	16068,
	16988,	17936,	18913,	19918,	20951,	22013,	23104,	24223,
	25371,	26549,	27755,	28991,	30257,	31551,	32876,	34230,
	35614,	37029,	38473,	39947,	41452,	42987,	44553,	46149,
	47776,	49433,	51122,	52842,	54592,	56374,	58187,	60032,
	61907,	63815,	65754,	67725,	69727,	71761,	73828,	75926,
	78057,	80219,	82414,	84642,	86901,	89194,	91518,	93876,
	96266,	98689,	101145,	103634,	106156,	108711,	111299,	113921,
	116576,	119264,	121986,	124741,	127530,	130352,	133209,	136099,
	139022,	141980,	144972,	147998,	151058,	154152,	157281,	160444,
	163641,	166872,	170138,	173439,	176774,	180144,	183549,	186989,
	190463,	193972,	197516,	201096,	204710,	208360,	212044,	215764,
	219520,	223310,	227137,	230998,	234895,	238828,	242796,	246800,
	250840,	254916,	259027,	263175,	267358,	271577,	275833,	280124,
	284452,	288816,	293216,	297653,	302125,	306635,	311180,	315763,
	320382,	325037,	329729,	334458,	339223,	344026,	348865,	353741,
	358654,	363604,	368591,	373615,	378676,	383775,	388910,	394083,
	399293,	404541,	409826,	415148,	420508,	425905,	431340,	436813,
	442323,	447871,	453456,	459080,	464741,	470440,	476177,	481952,
	487765,	493616,	499505,	505432,	511398,	517401,	523443,	529523,
	535642,	541798,	547994,	554227,	560499,	566810,	573159,	579547,
	585973,	592438,	598942,	605484,	612066,	618686,	625345,	632043,
	638779,	645555,	652370,	659224,	666117,	673049,	680020,	687031,
	694081,	701170,	708298,	715465,	722672,	729919,	737205,	744530,
	751895,	759300,	766744,	774227,	781751,	789314,	796917,	804559,
	812241,	819964,	827726,	835528,	843370,	851252,	859174,	867136,
	875138,	883180,	891262,	899385,	907547,	915750,	923993,	932277,
	940601,	948965,	957370,	965815,	974300,	982826,	991393,	1000000
};

static const int gamma_curve_2p21_table[256] = {
	0,	5,	22,	54,	103,	168,	252,	354,
	476,	617,	779,	962,	1166,	1391,	1639,	1909,
	2201,	2517,	2856,	3218,	3604,	4015,	4449,	4909,
	5393,	5902,	6436,	6996,	7582,	8193,	8830,	9494,
	10184,	10901,	11644,	12415,	13212,	14037,	14889,	15769,
	16676,	17612,	18575,	19566,	20586,	21634,	22711,	23817,
	24951,	26114,	27307,	28528,	29779,	31060,	32370,	33709,
	35079,	36478,	37907,	39367,	40856,	42377,	43927,	45508,
	47120,	48762,	50436,	52140,	53875,	55642,	57440,	59269,
	61130,	63022,	64945,	66901,	68888,	70907,	72958,	75042,
	77157,	79305,	81484,	83697,	85942,	88219,	90529,	92872,
	95247,	97656,	100097,	102572,	105079,	107620,	110194,	112802,
	115442,	118117,	120825,	123566,	126342,	129151,	131994,	134870,
	137781,	140726,	143705,	146718,	149766,	152848,	155964,	159115,
	162300,	165520,	168774,	172063,	175387,	178746,	182140,	185569,
	189033,	192532,	196066,	199635,	203240,	206879,	210555,	214266,
	218012,	221794,	225611,	229465,	233354,	237278,	241239,	245236,
	249268,	253337,	257442,	261583,	265760,	269973,	274223,	278509,
	282831,	287190,	291586,	296018,	300486,	304992,	309534,	314113,
	318728,	323381,	328070,	332797,	337560,	342361,	347199,	352074,
	356986,	361936,	366923,	371947,	377008,	382108,	387244,	392419,
	397631,	402880,	408167,	413492,	418855,	424256,	429695,	435171,
	440686,	446239,	451829,	457458,	463125,	468830,	474574,	480356,
	486176,	492035,	497932,	503867,	509841,	515854,	521905,	527995,
	534124,	540291,	546497,	552742,	559026,	565349,	571711,	578111,
	584551,	591030,	597548,	604105,	610701,	617337,	624012,	630726,
	637479,	644272,	651105,	657977,	664888,	671839,	678829,	685860,
	692929,	700039,	707188,	714377,	721606,	728875,	736184,	743532,
	750921,	758350,	765818,	773327,	780876,	788465,	796095,	803764,
	811474,	819224,	827015,	834846,	842717,	850629,	858581,	866574,
	874607,	882681,	890796,	898951,	907147,	915384,	923661,	931980,
	940339,	948739,	957180,	965662,	974185,	982749,	991354,	1000000
};

static const int gamma_curve_2p22_table[256] = {
	0,	5,	21,	52,	99,	162,	243,	342,
	460,	597,	754,	932,	1130,	1350,	1592,	1855,
	2141,	2449,	2781,	3136,	3514,	3916,	4342,	4792,
	5267,	5766,	6291,	6841,	7416,	8017,	8644,	9296,
	9975,	10680,	11412,	12171,	12956,	13769,	14608,	15475,
	16370,	17293,	18243,	19221,	20228,	21262,	22326,	23417,
	24538,	25687,	26865,	28073,	29309,	30575,	31871,	33196,
	34551,	35935,	37350,	38795,	40270,	41775,	43310,	44876,
	46473,	48100,	49759,	51448,	53168,	54919,	56702,	58516,
	60361,	62238,	64147,	66087,	68059,	70063,	72099,	74167,
	76268,	78400,	80565,	82763,	84993,	87255,	89550,	91878,
	94239,	96633,	99060,	101520,	104014,	106540,	109100,	111693,
	114320,	116981,	119675,	122403,	125164,	127960,	130790,	133653,
	136551,	139483,	142449,	145450,	148485,	151554,	154658,	157797,
	160970,	164178,	167421,	170699,	174011,	177359,	180742,	184160,
	187613,	191102,	194625,	198185,	201779,	205410,	209076,	212777,
	216514,	220288,	224096,	227941,	231822,	235739,	239692,	243681,
	247706,	251768,	255866,	260000,	264171,	268378,	272622,	276902,
	281220,	285573,	289964,	294392,	298856,	303357,	307896,	312471,
	317083,	321733,	326420,	331144,	335906,	340705,	345541,	350415,
	355326,	360275,	365262,	370286,	375348,	380448,	385586,	390761,
	395975,	401226,	406516,	411843,	417209,	422613,	428056,	433536,
	439055,	444612,	450208,	455842,	461515,	467226,	472976,	478765,
	484592,	490458,	496363,	502307,	508290,	514311,	520372,	526472,
	532610,	538788,	545005,	551261,	557557,	563892,	570266,	576680,
	583133,	589625,	596157,	602729,	609340,	615991,	622682,	629412,
	636182,	642992,	649842,	656732,	663661,	670631,	677641,	684690,
	691780,	698910,	706080,	713291,	720542,	727833,	735164,	742536,
	749948,	757401,	764894,	772428,	780003,	787618,	795274,	802970,
	810707,	818485,	826304,	834164,	842065,	850006,	857989,	866012,
	874077,	882183,	890330,	898518,	906747,	915018,	923330,	931683,
	940077,	948513,	956990,	965509,	974070,	982671,	991315,	1000000
};

static const int gamma_curve_2p23_table[256] = {
	0,	4,	20,	50,	95,	156,	234,	330,
	444,	577,	730,	903,	1096,	1311,	1546,	1803,
	2083,	2384,	2708,	3055,	3425,	3819,	4237,	4678,
	5144,	5634,	6149,	6689,	7254,	7844,	8460,	9102,
	9770,	10464,	11184,	11931,	12705,	13505,	14333,	15188,
	16070,	16979,	17917,	18882,	19875,	20897,	21947,	23025,
	24131,	25267,	26431,	27625,	28847,	30099,	31380,	32691,
	34031,	35401,	36801,	38231,	39691,	41181,	42702,	44253,
	45835,	47447,	49091,	50765,	52470,	54206,	55974,	57773,
	59603,	61465,	63358,	65283,	67240,	69229,	71250,	73303,
	75389,	77506,	79656,	81839,	84054,	86302,	88582,	90896,
	93242,	95621,	98034,	100480,	102959,	105471,	108017,	110596,
	113209,	115855,	118536,	121250,	123998,	126780,	129597,	132447,
	135332,	138251,	141204,	144192,	147214,	150271,	153363,	156490,
	159651,	162847,	166078,	169345,	172646,	175983,	179354,	182762,
	186204,	189682,	193196,	196745,	200330,	203950,	207607,	211299,
	215027,	218792,	222592,	226428,	230301,	234210,	238155,	242136,
	246154,	250209,	254300,	258427,	262592,	266793,	271031,	275305,
	279617,	283966,	288352,	292774,	297234,	301732,	306266,	310838,
	315447,	320094,	324778,	329500,	334259,	339056,	343891,	348763,
	353674,	358622,	363608,	368633,	373695,	378795,	383934,	389111,
	394326,	399579,	404871,	410201,	415570,	420977,	426423,	431907,
	437430,	442992,	448592,	454232,	459910,	465627,	471384,	477179,
	483013,	488887,	494800,	500751,	506743,	512773,	518843,	524952,
	531101,	537289,	543517,	549785,	556092,	562439,	568825,	575251,
	581718,	588224,	594770,	601356,	607982,	614648,	621354,	628101,
	634887,	641714,	648581,	655489,	662437,	669425,	676454,	683523,
	690633,	697783,	704974,	712206,	719479,	726792,	734146,	741541,
	748977,	756454,	763972,	771530,	779130,	786771,	794453,	802177,
	809941,	817747,	825594,	833483,	841413,	849384,	857397,	865451,
	873547,	881685,	889864,	898085,	906347,	914652,	922998,	931386,
	939816,	948287,	956801,	965357,	973954,	982594,	991276,	1000000
};

static const int gamma_curve_2p24_table[256] = {
	0,	4,	19,	48,	91,	150,	225,	318,
	429,	558,	707,	875,	1063,	1272,	1502,	1753,
	2026,	2320,	2637,	2977,	3339,	3725,	4134,	4567,
	5024,	5505,	6010,	6540,	7096,	7676,	8281,	8913,
	9569,	10252,	10961,	11697,	12459,	13247,	14063,	14905,
	15775,	16672,	17597,	18549,	19529,	20537,	21574,	22639,
	23732,	24854,	26004,	27184,	28392,	29630,	30897,	32193,
	33519,	34875,	36260,	37675,	39121,	40597,	42102,	43639,
	45206,	46803,	48432,	50091,	51781,	53502,	55255,	57039,
	58854,	60701,	62579,	64489,	66431,	68405,	70411,	72449,
	74520,	76623,	78758,	80925,	83126,	85359,	87625,	89923,
	92255,	94620,	97018,	99450,	101914,	104412,	106944,	109509,
	112108,	114741,	117408,	120108,	122843,	125612,	128415,	131252,
	134123,	137029,	139970,	142945,	145955,	149000,	152079,	155193,
	158343,	161527,	164747,	168001,	171292,	174617,	177978,	181374,
	184806,	188274,	191777,	195316,	198891,	202502,	206148,	209831,
	213550,	217306,	221097,	224925,	228789,	232690,	236627,	240601,
	244612,	248659,	252743,	256864,	261022,	265217,	269449,	273718,
	278024,	282367,	286748,	291166,	295622,	300115,	304645,	309213,
	313819,	318463,	323144,	327863,	332621,	337416,	342249,	347120,
	352029,	356977,	361963,	366987,	372049,	377150,	382289,	387467,
	392684,	397939,	403233,	408565,	413936,	419347,	424796,	430284,
	435811,	441377,	446983,	452627,	458311,	464034,	469797,	475598,
	481440,	487320,	493241,	499201,	505200,	511240,	517319,	523437,
	529596,	535795,	542033,	548312,	554630,	560989,	567388,	573827,
	580306,	586826,	593386,	599986,	606627,	613308,	620030,	626792,
	633595,	640439,	647323,	654248,	661214,	668221,	675269,	682358,
	689488,	696658,	703870,	711123,	718417,	725753,	733129,	740547,
	748007,	755508,	763050,	770634,	778259,	785926,	793634,	801384,
	809176,	817010,	824885,	832802,	840762,	848763,	856806,	864891,
	873018,	881187,	889399,	897652,	905948,	914286,	922666,	931089,
	939554,	948062,	956612,	965204,	973839,	982517,	991237,	1000000
};

static const int gamma_curve_2p25_table[256] = {
	0,	4,	18,	46,	87,	144,	217,	307,
	414,	540,	684,	848,	1031,	1235,	1459,	1704,
	1970,	2258,	2568,	2901,	3255,	3633,	4034,	4458,
	4906,	5378,	5875,	6395,	6940,	7511,	8106,	8727,
	9373,	10045,	10743,	11467,	12217,	12994,	13797,	14628,
	15485,	16370,	17282,	18222,	19189,	20184,	21208,	22259,
	23339,	24447,	25584,	26750,	27944,	29168,	30421,	31703,
	33015,	34356,	35727,	37128,	38559,	40020,	41511,	43033,
	44585,	46168,	47781,	49426,	51101,	52807,	54545,	56314,
	58114,	59946,	61810,	63705,	65632,	67591,	69582,	71605,
	73661,	75749,	77869,	80022,	82208,	84426,	86677,	88962,
	91279,	93629,	96013,	98430,	100880,	103364,	105882,	108433,
	111018,	113637,	116290,	118977,	121698,	124454,	127243,	130067,
	132926,	135819,	138747,	141709,	144707,	147739,	150806,	153908,
	157045,	160218,	163426,	166669,	169948,	173262,	176612,	179997,
	183418,	186875,	190368,	193897,	197462,	201063,	204700,	208374,
	212084,	215830,	219613,	223432,	227288,	231180,	235110,	239076,
	243079,	247119,	251196,	255310,	259461,	263650,	267876,	272139,
	276440,	280778,	285153,	289567,	294018,	298506,	303033,	307597,
	312200,	316840,	321519,	326235,	330990,	335783,	340614,	345484,
	350392,	355339,	360324,	365348,	370410,	375512,	380652,	385831,
	391048,	396305,	401601,	406936,	412310,	417723,	423175,	428667,
	434198,	439769,	445379,	451028,	456718,	462446,	468215,	474023,
	479871,	485759,	491687,	497655,	503663,	509711,	515799,	521927,
	528095,	534304,	540553,	546843,	553173,	559543,	565954,	572406,
	578898,	585431,	592005,	598619,	605275,	611971,	618708,	625486,
	632306,	639166,	646068,	653010,	659994,	667020,	674086,	681194,
	688344,	695535,	702768,	710042,	717357,	724715,	732114,	739555,
	747038,	754563,	762129,	769738,	777388,	785081,	792816,	800593,
	808412,	816273,	824177,	832123,	840111,	848142,	856215,	864331,
	872489,	880690,	888933,	897220,	905548,	913920,	922335,	930792,
	939293,	947836,	956422,	965051,	973724,	982439,	991198,	1000000
};

#endif /* __DYNAMIC_AID_GAMMA_CURVE_H */
