/* drivers/media/video/sr130pc20_regs_1_1.h
 *
 * Driver for sr130pc20 (VGA Camera) from Siliconfile
 *
 * Copyright (C) 2012, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */


/* ========== version info ==========*/
//2012.06.13 jwryu
//26MHz (50Hz)
/* ============================*/

#ifndef __EOSCAMERASR130PC20_REG_H
#define __EOSCAMERASR130PC20_REG_H

// Frame Auto
static const unsigned short sr130pc20_set_init_regs[]={

/*0 Page*/
0x0300,
0x0101,	/*sleep*/
0x0103,	/*s/w reset*/
0x0101,	/*sleep*/

0x0800,/*Don't touch*/
0x0937,/*Don't touch*/
0x0a33,/*Don't touch*/

/*PLL Setting*/
0xd005,
0xd130,
0xd201,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x1011,
0x1190,	/*xy flip*/
0x1200,
0x1488,

0x0300,
0x2000,
0x2104,
0x2200,
0x2304,
0x2403,
0x25C0,
0x2605,
0x2700,

0x4001, /*Hblank_280*/
0x4118,
0x4200, /*Vblank 100*/
0x4364,

/*--------------- BLC*/
0x8008,  /*Don't touch */
0x8197,  /*Don't touch */
0x8290,  /*Don't touch */
0x8330,  /*Don't touch */
0x84cc, /*Don't touch*/
0x8500,  /*Don't touch*/
0x86d4,  /*Don' t touch*/
0x870f,   /*Don't touch*/
0x8834,  /*Don't touch*/

0x900c, /*BLC_TIME_TH_ON*/
0x910c, /*BLC_TIME_TH_OFF */
0x92f0, /*BLC_AG_TH_ON*/
0x93e8, /*BLC_AG_TH_OFF*/

0x9495, /*091202*/
0x9590, /*091202 */
0x9838,  /*Don't touch*/

/*Dark BLC*/
0xa001,  /* 20100309*/
0xa201,  /* 20100309*/
0xa401,  /* 20100309*/
0xa601,  /* 20100309*/

/*Normal BLC*/
0xa800,
0xaa00,
0xac00,
0xae00,

/*Out  BLC*/
0x9900,
0x9a00,
0x9b00,
0x9c00,

/*2 Page*/
0x0302,
0x1200, /*Don't touch*/
0x1400, /*Don't touch*/
0x1500, /*Don't touch*/
0x184C, /*Don't touch*/
0x1900, /*Don't touch*/
0x1A39, /*Don't touch*/
0x1B00,/*Don't touch*/
0x1C1a, /*Don't touch*/
0x1D14, /*Don't touch*/
0x1E30,/*Don't touch*/
0x1F10,/*Don't touch*/

0x2077,
0x21de,
0x22a7,
0x2330,
0x2477,
0x2510,
0x2610,
0x273c,
0x2b80,
0x2c02,
0x2da0,
0x2e00,
0x2fa7,

0x3000,
0x3199,
0x3200,
0x3300,
0x3422,
0x3601,
0x3701,
0x3888,
0x3988,
0x3d03,
0x3e0d,
0x3f02,

0x49d1,
0x4a14,

0x5021,
0x5201,
0x5381,
0x5410,
0x551c,
0x5611,
0x5818,
0x5916,
0x5da2,
0x5e5a,

0x6093,	/* 20120517 modify*/
0x61a4,	/* 20120517 modify*/
0x6294,	/* 20120517 modify*/
0x63a3,   /* 20120517 modify*/
0x6494,	/* 20120517 modify*/
0x65a3,   /* 20120517 modify*/
0x670c,
0x680c,
0x690c,
0x6ab4,
0x6bc4,
0x6cb5,
0x6dc2,
0x6eb5,
0x6fc0,

0x70b6,
0x71b8,
0x7295,	/* 20120517 modify*/
0x73a2,	/* 20120517 modify*/
0x7495,	/* 20120517 modify*/
0x75a2,	/* 20120517 modify*/
0x7695,	/* 20120517 modify*/
0x77a2,	/* 20120517 modify*/
0x7C92,	/* 20120517 modify*/
0x7Dff,	/* 20120517 modify*/

0x8001,	/* 20120517 modify*/
0x818a,   /* 20120517 modify*/
0x821e,	/* 20120517 modify*/
0x8336,	/* 20120517 modify*/
0x8489,	/* 20120517 modify*/
0x858b,	/* 20120517 modify*/
0x8689,	/* 20120517 modify*/
0x878b,	/* 20120517 modify*/
0x88ab,
0x89bc,
0x8aac,
0x8bba,
0x8cad,
0x8db8,
0x8eae,
0x8fb2,

0x90b3,
0x91b7,
0x9252,	/* 20120517 modify*/
0x936a,	/* 20120517 modify*/
0x9489,	/* 20120517 modify*/
0x958b,	/* 20120517 modify*/
0x9689,	/* 20120517 modify*/
0x978b,	/* 20120517 modify*/

0xA002,
0xA186,	/* 20120517 modify*/
0xA202,
0xA386,	/* 20120517 modify*/
0xA486,	/* 20120517 modify*/
0xA502,
0xA686,	/* 20120517 modify*/
0xA702,
0xA892,	/* 20120517 modify*/
0xA994,	/* 20120517 modify*/
0xAA92,	/* 20120517 modify*/
0xAB94,	/* 20120517 modify*/
0xAC1c,
0xAD22,
0xAE1c,
0xAF22,

0xB0a4,	/* 20120517 modify*/
0xB1ae,	/* 20120517 modify*/
0xB2a4,	/* 20120517 modify*/
0xB3ae,	/* 20120517 modify*/
0xB4a6,	/* 20120517 modify*/
0xB5ac,	/* 20120517 modify*/
0xB6a6,	/* 20120517 modify*/
0xB7ac,	/* 20120517 modify*/
0xB8a6,	/* 20120517 modify*/
0xB9ab,	/* 20120517 modify*/
0xBAa6,	/* 20120517 modify*/
0xBBab,	/* 20120517 modify*/
0xBCa6,	/* 20120517 modify*/
0xBDab,	/* 20120517 modify*/
0xBEa6,	/* 20120517 modify*/
0xBFab,	/* 20120517 modify*/

0xc437,
0xc552,
0xc66b,
0xc786,
0xc838,	/* 20120517 modify*/
0xc950,	/* 20120517 modify*/
0xca38,	/* 20120517 modify*/
0xcb50,	/* 20120517 modify*/
0xcc6c,	/* 20120517 modify*/
0xcd84,	/* 20120517 modify*/
0xce6c,	/* 20120517 modify*/
0xcf84,	/* 20120517 modify*/

/*d4a6,*/
/*d5ac,*/
/*d6a6,*/
/*d7ac,*/
/*add 20120517*/
0xdc00,   /* Added*/
0xddaf,   /* Added*/
0xde00,   /* Added*/
0xdf90,   /* Added*/

0xd010,
0xd114,
0xd220,
0xd300,
/*DCDC */
0xd40c, /*DCDC_TIME_TH_ON*/
0xd50c, /*DCDC_TIME_TH_OFF */
0xd6f0, /*DCDC_AG_TH_ON*/
0xd7e8, /*DCDC_AG_TH_OFF*/

0xea8a,

0xF001,	/* clock inversion*/
0xF101,
0xF201,
0xF301,
0xF401,
0xF500,

/*----------------------------------------------*/
0x0310,	/*page 10*/
0x1001,	/*Ycbcr422_bit Order: YUYV*/
0x1103,
0x1230,	/*y offset[4], dif_offset[5]*/
0x1302,
0x3400,	/*hidden 10->00 100209*/
0x3701,	/*yc2d power save */
0x3f04,	/*100825*/
0x4080,	/*Y offset  */
0x4880,
0x5300,	/*dif_offset option */
0x5530,	/*dif_offset option  diff_offset max */

0x604f,	/*out color sat en[7] | auto color decrement en[1] /
	| manual color sat en[0]*/

0x6183,	/*blue saturation_C0*/
0x6280,	/*red saturation_B0*/

0x63ff,	/*auto decresment on AG th*/
0x64c0,	/*auto decresment on DG th*/
0x66e4,	/*Outdoor saturation step 137fps apply out th */
0x6703,	/*Outdoor saturation B/R*/
0x7601, /* ADD 20121031 */
0x7904, /* ADD 20121031 */

/* Hi 163 */
/* PAGE 10 START*/
0x0310,
0x8000, /* dsshin --> color enhance*/
0xf500, /* dsshin --> h blank option*/

0x0311,	/*page 11 D_LPF	*/
0x103f,	/*B[6]:Blue En  Dlpf on[4:0] Sky over off : 7f->3f*/
0x1120,	/* Uniform Full GbGr/OV-Nr*/

0x1280,	/*Blue MaxOpt  blue sky max filter optoin rate : 0 c0->80*/
0x13b8,	/*dark2[7] | ratio[6:4] | dark3[3] | dark3 maxfilter ratio[2:0] */

0x30ba,	/*Outdoor2 H th*/
0x3110,	/*Outdoor2 L th*/
0x3250,	/*Outdoor2 gain ratio*/
0x331d,	/*Outdoor2 H lum*/
0x3420,	/*Outdoor2 M lum*/
0x351f,	/*Outdoor2 L lum*/

0x36b0,	/*Outdoor1 H th*/
0x3718,	/*Outdoor1 L th*/
0x3850,	/*Outdoor1 gain ratio  80->40*/
0x391d,	/*Outdoor1 H lum       28->1e*/
0x3a20,	/*Outdoor1 M lum       10->15*/
0x3b1f,	/*Outdoor1 L lum       08->20*/

0x3c3f,	/*indoor H th*/
0x3d16,	/*indoor L th*/
0x3e30,	/*indoor gain ratio    44  6a */
0x3f1a,	/*indoor H lum         12  18	*/
0x4060,	/*indoor M lum	       18  1c*/
0x411a,	/*indoor L lum         18  3e*/

0x4298,	/*dark1 H th*/
0x4328,	/*dark1 L th*/
0x4465,	/*dark1 gain ratio*/
0x4516,	/*dark1 H lum         38->28  */
0x4630,	/*dark1 M lum         27->17*/
0x4734,	/*dark1 L lum         20->1a */

0x4890,	/*dark2 H th*/
0x492a,	/*dark2 L th*/
0x4a65,	/*dark2 gain ratio*/
0x4b18,	/*dark2 H lum */
0x4c31,	/*dark2 M lum*/
0x4d36,	/*dark2 L lum */

0x4e80,	/*dark3 H th*/
0x4f30,	/*dark3 L th*/
0x5065,	/*dark3 gain ratio*/
0x5119,	/*dark3 H lum	*/
0x5231,	/*dark3 M lum */
0x5336,	/*dark3 L lum */

0x5a3f,	/*blue sky mode out1/2 enable  27->3f */
0x5b00,	/*Impulse pixel enable dark123,in,out123 ::  must be 07*/
0x5c9f,	/*Indoor maxfilter rate[7:5] | Uncertain onoff[4:0] 1f ->9f*/

0x603f,	/*GbGr all enable*/
0x620f,	/*GbGr offset*/

0x650c,	/*Outdoor GbGr rate H 100% M 25% L 100%*/
0x660c,	/*Indoor GbGr  rate H 100% M 25% L 100%*/
0x6700,	/*dark GbGr    rate H/M/L  100%*/

0x700c,	/* Abberation On/Off B[1]: Outdoor B[0]: Indoor 07>>c*/
0x75a0,	/* Outdoor2 Abberation Luminance lvl */
0x7db4,	/* Indoor Abberation Luminance   lvl*/

0x9608,	/*indoor/Dark1 edgeoffset1*/
0x9714,	/*indoor/Dark1 center G value*/
0x98f5,	/*slope indoor :: left/right graph polarity, slope*/
0x992a,	/*indoor uncertain ratio control*/
0x9a20,	/*Edgeoffset_dark*/

/*DPC_CTRL*/
0x0312,	/*Preview DPC off[5c] on[5d]*/
0x200f,
0x210f,

0x2500, /* 30*/

0x2a01,
0x2e00,	/*2010.8.25*/

0x3035,	/*Texture region(most detail)*/
0x31a0,	/*STD uniform1 most blur region*/
0x32b0,	/*STD uniform2      2nd blur*/
0x33c0,	/*STD uniform3      3rd blur*/
0x34d0,	/*STD normal noise1 4th blur	*/
0x35e0,	/*STD normal noise2 5th blur*/
0x36ff,	/*STD normal noise3 6th blur*/

0x4083,	/*Outdoor2 H th*/
0x4120,	/*Outdoor2 L th		*/
0x4208,	/*Outdoor2 H luminance */
0x4310,	/*Outdoor2 M luminance */
0x4410,	/*Outdoor2 l luminance */
0x4550,	/*Outdoor2 ratio*/

0x4683,	/*Outdoor1 H th*/
0x4720,	/*Outdoor1 L th		*/
0x4808,	/*Outdoor1 H luminance*/
0x4910,	/*Outdoor1 M luminance*/
0x4a10,	/*Outdoor1 L luminance*/
0x4b50,	/*Outdoor1 ratio*/

0x4c80,	/*Indoor H th*/
0x4d48,	/*Indoor L th*/
0x4e30,	/*indoor H lum*/
0x4f30,	/*indoor M lum*/
0x5012,	/*indoor L lum */
0x5170,	/*indoor ratio  10 -> 45*/

0x52a8,	/*dark1 H th*/
0x5330,	/*dark1 L th	*/
0x5428,	/*dark1 H lum */
0x553e,	/*dark1 M lum*/
0x5667,	/*dark1 L lum*/
0x576a,	/*dark1 ratio*/

0x58a0,	/*dark2 H th*/
0x5940,	/*dark2 L th*/
0x5a28,	/*dark2 H lum*/
0x5b3f,	/*dark2 M lum*/
0x5c68,	/*dark2 L lum*/
0x5d70,	/*dark2 ratio*/

0x5ea0,	/*dark3 H th*/
0x5f40,	/*dark3 L th*/
0x6029,	/*dark3 H lum*/
0x613f,	/*dark3 M lum*/
0x6269,	/*dark3 L lum*/
0x636a,	/*dark3 ratio*/

/*C-filter(Out2&Out1)*/
0x7010,
0x710a,

/*C-filter(Indoor&Dark3)*/
0x7210,
0x730a,

/*C-filter(Dark2&Dark1)*/
0x7418,
0x7512,

0x8020,
0x8140,
0x8265,
0x851a,
0x8800,
0x8900,
0x905d,	/*Preview DPC off[5c] on[5d]*/

/*DPC-Dark1,2,3*/
0xad07,	/*10825*/
0xae07,	/*10825*/
0xaf07,	/*10825*/

/*Blue Det..*/
0xc558,	/*BlueRange   2010.8.25    40->23 */
0xc620,	/*GreenRange  2010.8.25    3b->20 */

0xd088,	/*2010.8.25*/
0xd180,
0xd217,/*preview 17, full 67*/
0xd300,
0xd400,
0xd50f,/*preview 0f, full 02*/
0xd6ff,
0xd7ff,/*preview ff, full 18*/
0xd800,
0xd904,

/*interpolated with average*/
0xdb38,	/*resolution issue 00->18->38 */
0xd904,	/*strong_edge detect ratio*/
0xe001,	/*strong_edge detect ratio*/

0x0313,	/*page 13 sharpness 1D*/
0x10c5,
0x117b,
0x120e,
0x1400,

0x1511,	/*added option 1.3M*/
0x1830,	/*added option 1.3M*/

0x2015,
0x2113,
0x2233,
0x2308,	/*hi_clip th1*/
0x241a,	/*hi_clip th2*/
0x2506,	/*low clip th*/

0x2618,
0x2730,
0x2910,	/*time th*/
0x2a30,	/*pga th*/

0x2b03,	/*lpf out2*/
0x2c03,	/*lpf out1*/
0x2d0c,
0x2e12,
0x2f12,

/*1D Edge*/
0x500a,	/*out2  hi nega*/
0x5307,	/*      hi pos*/
0x510c,	/*      mi nega*/
0x5407,	/*      mi pos*/
0x520b,	/*      lo nega*/
0x5508,	/*      lo pos*/

0x560a,	/*out1   hi nega*/
0x5907,	/*       hi pos */
0x570c,	/*       mi nega*/
0x5a07,	/*       mi pos */
0x580b,	/*       lo nega*/
0x5b08,	/*       lo pos	*/

/*Indoor Edge*/
0x5c08,  /*indoor hi  nega*/
0x5f07,  /*       hi  pos*/
0x5d14,
0x6012,
0x5e0a,
0x6108,  /*       low pos*/

0x6208,  /*dark1  hi nega*/
0x6506,  /*       hi  pos   */
0x6308,  /*       mid nega  */
0x6606,  /*       mid pos   */
0x6408,  /*       low nega  */
0x6706,  /*       low pos   */

0x6807,  /*dark2  hi  nega*/
0x6b05,  /*       hi  pos       */
0x6907,  /*       mid nega      */
0x6c05,  /*       mid pos       */
0x6a07,  /*       low nega      */
0x6d05,  /*       low pos       */

0x6e0a,  /*dark3  hi  nega*/
0x7109,  /*       hi  pos       */
0x6f0a,  /*       mid nega      */
0x7209,  /*       mid pos       */
0x700a,  /*       low nega      */
0x7309,  /*       low pos       */

	/* 2DY*/
0x80c1,
0x811f,
0x82e1,
0x8333,

0x9005,
0x9105,
0x9233,
0x9330,
0x9403,
0x9514,
0x9730,
0x9930,

0xa002,	/*2d lclp out2  nega*/
0xa103,	/*2d lclp out2  pos*/
0xa202,	/*2d lclp out1  nega*/
0xa303,	/*2d lclp out1  pos*/
0xa403,	/*2d lclp in    nega*/
0xa504,	/*2d lclp in    pos*/
0xa607,	/*2d lclp dark1 nega*/
0xa708,	/*2d lclp dark1 pos*/
0xa807,	/*2d lclp dark2 nega*/
0xa908,	/*2d lclp dark2 pos*/
0xaa07,	/*2d lclp dark3 nega*/
0xab08,	/*2d lclp dark3 pos*/

0xb010,	/*out2   H Ne*/
0xb310,	/*       H Po*/
0xb11e,	/*       M Ne*/
0xb41e,	/*       M Po*/
0xb21f,	/*       L Ne*/
0xb51e,	/*       L Po*/

0xb610,	/*out1   H Ne   */
0xb910,	/*       H Po   */
0xb71e,	/*       M Ne   */
0xba1e,	/*       M Po   */
0xb81f,	/*       L Ne   */
0xbb1e,	/*       L Po   */

0xbc20,  /*indoor H Ne*/
0xbf1e,  /*       H Po*/
0xbd25,  /*       M Ne*/
0xc023,  /*       M Po*/
0xbe24,  /*       L Ne*/
0xc122,  /*       L Po*/

0xc223,  /*dark1  H Ne*/
0xc523,  /*       H Po*/
0xc329,  /*       M Ne*/
0xc629,  /*       M Po*/
0xc425,  /*       L Ne*/
0xc725,  /*       L Po*/

0xc81c, /*dark2   H Ne*/
0xcb1c,  /*       H Po*/
0xc925,  /*       M Ne*/
0xcc25,  /*       M Po*/
0xca23,  /*       L Ne*/
0xcd23,  /*       L Po*/

0xce1c,  /*dark3  H Ne*/
0xd11c,  /*       H Po*/
0xcf25,  /*       M Ne*/
0xd225,  /*       M Po*/
0xd023,  /*       L Ne*/
0xd323,  /*       L Po*/

/* PAGE 14 START*/
0x0314,
0x1031,

0x1480, /* GX*/
0x1580, /* GY*/
0x1680, /* RX*/
0x1780, /* RY*/
0x1880, /* BX*/
0x1980, /* BY*/

0x2060, /* X Center*/
0x2180, /* Y Center*/

0x2280,
0x2380,
0x2480,

0x30c8,
0x312b,
0x3200,
0x3300,
0x3490,

0x4056,	/*R min's set 4e*/
0x413a,	/*Gr*/
0x4237,	/*B*/
0x433a,	/*Gb*/

0x0315,
0x1021,
0x1444, /*49*/
0x1534, /*38*/
0x1626, /*2b*/
0x172f,

0x30dd,
0x3162,
0x3205,
0x3326,
0x34bd,
0x3517,
0x3618,
0x3738,
0x38d0,

0x40b0,
0x4130,
0x4200,
0x4300,
0x4400,
0x4500,
0x4699,
0x4719,
0x4800,

0x5016,
0x51b2,
0x521c,
0x5306,
0x5420,
0x55a6,
0x560e,
0x57b2,
0x5824,

0x0316,
0x1031,	/*GMA_CTL*/
0x187e,	/*AG_ON*/
0x197d,	/*AG_OFF*/
0x1a0e,	/*TIME_ON*/
0x1b01,	/*TIME_OFF*/
0x1Cdc,	/*OUT_ON*/
0x1Dfe,	/*OUT_OFF*/

/*GMA Indoor*/
0x3000,
0x3107,
0x321a,
0x3335,
0x345a,
0x357c,
0x3696,
0x37a9,
0x38b7,
0x39c6,
0x3ad2,
0x3bdc,
0x3ce4,
0x3deb,
0x3ef1,
0x3ff5,
0x40f9,
0x41fd,
0x42ff,

/*RGMA Outdoor*/
0x5000,
0x5103,
0x5213,
0x532e,
0x5459,
0x5579,
0x5690,
0x57a3,
0x58b4,
0x59c2,
0x5acd,
0x5bd7,
0x5ce0,
0x5de5,
0x5ee9,
0x5fee,
0x60f1,
0x61f3,
0x62f6,

/*BGMA Dark*/
0x7003,
0x7111,
0x721f,
0x7337,
0x7452,
0x756c,
0x7685,
0x779a,
0x78ad,
0x79bd,
0x7acb,
0x7bd6,
0x7ce0,
0x7de8,
0x7eef,
0x7ff4,
0x80f8,
0x81fb,
0x82fe,

0x0324,	/*Resol control */
0x60c5,	/*edge even frame | 16bit resol | white edge cnt | scene resol enable*/
0x6104,	/*even frame update	*/
0x6408,
0x6500,
0x6626,	/*edge th2 H	*/
0x6700,	/*edge th2 L	*/

0x0313,
0x1831,	/*flat center Gb/Gr*/
0x7402,	/*det slope en | gausian filter*/
0x750d,	/*1D negative gain det 09	*/
0x760d,	/*1D postive  gain det	08*/
0x7710,	/*1D hclp2 det*/
0x7808,	/*outdoor flat threshold*/
0x7910,	/*indoor flat threshold*/

0x81df,	/*det gain controler*/
0x8690,	/*2D negative gain det	*/
0x8790,	/*2D postive  gain det	*/
0x962a,	/*2D hclp2 det*/

0x0312,	/*12 page*/
0xd088,
0xd9e4,

/* PAGE 18 START*/
0x0318,
0x1400,

/* PAGE 20 START*/
0x0320,
0x111c,
0x1830,
0x1a08,
0x2045,/*weight*/
0x2130,
0x2210,
0x2300,
0x2400,

0x28e7, /* add 20120223*/
0x290d, /* 20100305 ad -> 0d*/
0x2afd,
0x2bf8,

0x2cc3,
0x2d5f, /* add 20120223*/
0x2e33,
0x30f8,
0x3203,
0x332e,
0x3430,
0x35d4,
0x36ff, /*fe*/
0x3732,
0x3804,
0x3922,
0x3ade,
0x3b22,
0x3cde,
0x3de1,

0x5045,
0x5188,

0x561a,
0x5780,
0x580e,
0x596a,
0x5a04,

0x5e9d, /*AE_AWB_start*/
0x5f76, /*AE_AWB_start*/

0x7033, /* 6c*/
0x7182, /* 82(+8)*/

0x7621,
0x7771,
0x7822, /* 24*/
0x7923, /* Y Target 70 => 25, 72 => 26*/
0x7a23, /* 23*/
0x7b22, /* 22*/
0x7d23,

0x8301, /*EXP Normal 33.33 fps */
0x845f,
0x8590,
0x8601, /*EXPMin 7500.00 fps*/
0x8790,
0x8805, /*EXP Max(120Hz) 8.00 fps */
0x89b8,
0x8ad8,
0xa505, /*EXP Max(100Hz) 8.33 fps */
0xa67e,
0xa740,
0x8B75, /*EXP100 */
0x8C30,
0x8D61, /*EXP120 */
0x8Ea8,
0x9c09, /*EXP Limit 1250.00 fps */
0x9d60,
0x9e01, /*EXP Unit */
0x9f90,
0x989d,

0xb016,
0xb114,
0xb2f8,
0xb314,
0xb41b,
0xb546,
0xb631,
0xb729,
0xb826,
0xb924,
0xba22,
0xbb42,
0xbc41,
0xbd40,

0xc010,
0xc138,
0xc238,
0xc338,
0xc407,

0xc880,
0xc980,
0x109c,	/* ae enable*/
/* PAGE 20 END*/

/*AE_Weight*/
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2412,
0x2522,
0x2622,
0x2721,
0x2812,
0x2922,
0x2a22,
0x2b21,
0x2c12,
0x2d23,
0x2e32,
0x2f21,
0x3012,
0x3123,
0x3232,
0x3321,
0x3412,
0x3522,
0x3622,
0x3721,
0x3812,
0x3922,
0x3a22,
0x3b21,
0x3c11,
0x3d11,
0x3e11,
0x3f11,

/* PAGE 22 START*/
0x0322,
0x10fd,
0x112e,
0x1901, /* Low On*/
0x2030, /* for wb speed*/
0x2140,
0x2401,
0x257e, /* for tracking 20120314 */

0x3080, /* 20120224 test*/
0x3180,
0x3811,
0x3934,

0x40e8,
0x4143, /* 33*/
0x4222, /* 22*/

0x43f3, /* f6*/
0x4454, /* 44*/
0x4522, /* 33*/

0x4600,
0x480a,
0x50b2,
0x5181,
0x5298,

0x8038,
0x8120,
0x8238, /* 3a*/

0x8356, /* R Max*/
0x8420, /* R Min*/
0x8552, /* B Max*/
0x8620, /* B Min*/

0x8745,
0x883a,
0x8933,
0x8a2c,

0x8b42,
0x8c3d,
0x8d30,
0x8e2c,

0x8f5a,
0x9059,
0x9155,
0x924e,
0x9344,
0x943a,
0x9534,
0x962c,
0x9723,
0x9820,
0x991f,
0x9a1f,

0x9b77,
0x9c77,
0x9d48,
0x9e38,
0x9f30,

0xa040,
0xa121,
0xa26f,
0xa3ff,

0xa414, /* 1500fps*/
0xa544, /* 700fps*/
0xa6cf,

0xad40,
0xae4a,

0xaf2a,  /* low temp Rgain*/
0xb028,  /* low temp Rgain*/

0xb100, /* 20 -> 00 0405 modify*/
0xb4bf, /* for tracking 20120314*/
0xb8a1, /* a2: b-2, R+2  b4 B-3, R+4 lowtemp b0 a1 Spec AWB A modify*/
0xb900,
/* PAGE 22 END*/

/* PAGE 48 (MiPi 1600  x  1200)*/
0x0300,

/* PLL Setting */
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x0348,
/* MIPI TX Setting */
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
0x1d0e,
0x1e07,
0x1f08,

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2b40,*/

0x3005,
0x3100,

0x3207,
0x3309,
0x3401,
0x3501,

0x0300,
0x0101,
};

static const unsigned short sr130pc20_stream_off[]={
0x0300,
0x0101,
};

static const unsigned short sr130pc20_stream_on[]={
0x0300,
0x0100,
};

static const unsigned short sr130pc20_Capture_Mode[] ={
0x0300,
0x0101,/*sleep*/

0xd005,/*Pll off*/

0x0322,
0x107d,/*AWB off*/

0x0300,
0x1000,
/* 1190, */

0x0302,
0x2faa,

0x0311,
0x5b00,/*don't touch*/

0x0312,
0x200f,
0x210f,

/*preview DPC*/
0xd267,
0xd502,
0xd718,

0x0313,
0x10c5,
0x80c1,/*Sharpness 2D On[c1] Off[c0]*/

/* PAGE 18 START*/
0x0318,
0x1000,
0x1400,

0x0300,
0xd005,/*pll on*/
0xd130,
0xd201,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x0348,
/* MIPI TX Setting */
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
0x1d0d, /* 0c:90ns , 0b:110ns */
0x1e0f,
0x1f0a,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x300a,
0x3100,

0x320d,
0x330b,
0x3402,
0x3504,
0x3601,
0x3709,
/*3802,*/
/*3902,*/

0x0300,
0x0101,/*sleep off*/

};

//==========================================================
//  EFFECT(6)
//==========================================================

static const unsigned short sr130pc20_effect_normal_regs[] =
{
0x0310,
0x1103,
0x1230,
0x1302,
0x4080,
0x4480,
0x4580,
};
static const unsigned short sr130pc20_effect_negative_regs[] =
{
0x0310,
0x1103,
0x1238,
0x1302,
0x4080,
0x4480,
0x4580,
};
static const unsigned short sr130pc20_effect_sepia_regs[] =
{
0x0310,
0x1103,
0x1233,
0x1302,
0x4080,
0x4470,
0x4598,
};
static const unsigned short sr130pc20_effect_mono_regs[] =
{
0x0310,
0x1103,
0x1233,
0x1302,
0x4080,
0x4480,
0x4580,
};
static const unsigned short sr130pc20_effect_aqua_regs[] =
{
0xff01,
};
static const unsigned short sr130pc20_effect_sharpen_regs[] =
{
0xFF00,  //END
};
static const unsigned short sr130pc20_effect_solarization_regs[] =
{
0xFF00,  //END
};
static const unsigned short sr130pc20_effect_black_white_regs[] =
{
0xFF00,  //END
};
//==========================================================
//  EFFECT(6)  -END
//==========================================================



//==========================================================
// WB(5) -START
//==========================================================


static const unsigned short sr130pc20_wb_auto_regs[] =
{
0x0322,
0x106b,
0x112e,
0x8038,
0x8120,
0x8238,
0x8356,
0x8420,
0x8552,
0x8620,
0x10eb,
};

static const unsigned short sr130pc20_wb_daylight_regs[] =
{
0x0322,
0x106b,
0x112c,
0x8038,
0x8120,
0x8235,
0x833b,
0x8434,
0x8538,
0x8631,
0x10eb,
};

static const unsigned short sr130pc20_wb_cloudy_regs[] =
{
0x0322,
0x106b,
0x112c,
0x8050,
0x8120,
0x8228,
0x8352,
0x844c,
0x852c,
0x8622,
0x10eb,
};
static const unsigned short sr130pc20_wb_incandescent_regs[] =
{
0x0322,
0x106b,
0x112c,
0x8021,
0x8120,
0x824f,
0x8327,
0x841b,
0x8559,
0x8650,
0x10eb,
};

static const unsigned short sr130pc20_wb_fluorescent_regs[] =
{
0x0322,
0x106b,
0x112c,
0x8037,
0x8120,
0x8248,
0x8339,
0x8434,
0x854a,
0x8645,
0x10eb,
};

//==========================================================
// WB(5)  --END
//==========================================================



//==========================================================
//METERING()
//==========================================================

static const unsigned short sr130pc20_metering_matrix_regs[] =
{
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2411,
0x2511,
0x2611,
0x2711,
0x2811,
0x2911,
0x2a11,
0x2b11,
0x2c11,
0x2d11,
0x2e11,
0x2f11,
0x3011,
0x3111,
0x3211,
0x3311,
0x3411,
0x3511,
0x3611,
0x3711,
0x3811,
0x3911,
0x3a11,
0x3b11,
0x3c11,
0x3d11,
0x3e11,
0x3f11,
};

static const unsigned short sr130pc20_metering_center_regs[] =
{
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2412,
0x2522,
0x2622,
0x2721,
0x2812,
0x2922,
0x2a22,
0x2b21,
0x2c12,
0x2d23,
0x2e32,
0x2f21,
0x3012,
0x3123,
0x3232,
0x3321,
0x3412,
0x3522,
0x3622,
0x3721,
0x3812,
0x3922,
0x3a22,
0x3b21,
0x3c11,
0x3d11,
0x3e11,
0x3f11,
};

static const unsigned short sr130pc20_metering_spot_regs[] =
{
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2411,
0x2511,
0x2611,
0x2711,
0x2811,
0x2911,
0x2a11,
0x2b11,
0x2c11,
0x2d13,
0x2e31,
0x2f11,
0x3011,
0x3113,
0x3231,
0x3311,
0x3411,
0x3511,
0x3611,
0x3711,
0x3811,
0x3911,
0x3a11,
0x3b11,
0x3c11,
0x3d11,
0x3e11,
0x3f11,
};
//==========================================================
//METERING() - END
//==========================================================


//==========================================================
// BRIGHTNES(9) - START
//==========================================================

static const unsigned short sr130pc20_ev_minus_4_regs[] =
{
0x0310,
0x40D0,
};

static const unsigned short sr130pc20_ev_minus_3_regs[] =
{
0x0310,
0x40B0,
};

static const unsigned short sr130pc20_ev_minus_2_regs[] =
{
 0x0310,
 0x40A0,

};

static const unsigned short sr130pc20_ev_minus_1_regs[] =
{
 0x0310,
 0x4090,
};

static const unsigned short sr130pc20_ev_default_regs[] =
{
0x0310,
0x4080,
};

static const unsigned short sr130pc20_ev_plus_1_regs[] =
{
 0x0310,
 0x4010,

};

static const unsigned short sr130pc20_ev_plus_2_regs[] =
{
 0x0310,
 0x4020,

};

static const unsigned short sr130pc20_ev_plus_3_regs[] =
{
 0x0310,
 0x4030,
};

static const unsigned short sr130pc20_ev_plus_4_regs[] =
{
 0x0310,
 0x4050,
};
// ==========================================================
// BRIGHTNES(9) - END
//==========================================================

//==========================================================
// contrast(5) - START
//==========================================================

static const unsigned short sr130pc20_contrast_minus_2_regs[] =
{
0x0310,
0x48a0,
};

static const unsigned short sr130pc20_contrast_minus_1_regs[] =
{
0x0310,
0x4890,
};

static const unsigned short sr130pc20_contrast_default_regs[] =
{
0x0310,
0x4885,
};

static const unsigned short sr130pc20_contrast_plus_1_regs[] =
{
0x0310,
0x4870,
};

static const unsigned short sr130pc20_contrast_plus_2_regs[] =
{
0x0310,
0x4860,
};

static const unsigned short sr130pc20_fps_auto_regs[] =
{
  0xFF00,  //END
};
//==========================================================
//FPS()
//==========================================================

static const unsigned short sr130pc20_fps_5_regs[] =
{
  0xFF00,  //END
};
static const unsigned short sr130pc20_fps_7_regs[] =
{
0x0300,
0x0101,

0x1190,

0x4200,
0x4314,

0x0320,
0x101C,

0x0322,
0x107d,

0x0320,
0x2af3,
0x2bf5,

0x8301, /*EXP Normal 33.33 fps */
0x845f,
0x8590,

0x8806, /*EXP Max(120Hz) 7.50 fps */
0x8968,
0x8aa0,

0xa506, /*EXP Max(100Hz) 7.14 fps */
0xa668,
0xa7a0,

0x9106, /*EXP Fix 7.00 fps*/
0x9289,
0x9370,

0x0320,
0x109C,

0x0322,
0x10fd,

0x0300,
0x1194,

0x0300,
0x0101,
};

static const unsigned short sr130pc20_fps_10_regs[] =
{
0xFF00,
};

static const unsigned short sr130pc20_fps_15_regs[] =
{
0x0300,
0x0101,

0x1190,

0x4200,
0x4314,

0x0320,
0x101C,

0x0322,
0x107d,

0x0310,	/*page 10*/
0x6007,
0x6380,	/*auto decresment on AG th*/

0x0316,
0x7007,
0x711a,
0x722d,
0x7346,
0x746a,
0x7586,
0x769c,
0x77ad,
0x78bc,
0x79c9,
0x7ad4,
0x7bde,
0x7ce4,
0x7deb,
0x7ef1,
0x7ff5,
0x80f9,
0x81fd,
0x82ff,

0x0322,
0x8f5d,
0x905a,
0x9156,
0x9250,
0x9348,
0x943f,

0x0320,
0x2afd,
0x2bf8,

0x8301, /*EXP Normal 33.33 fps */
0x845f,
0x8590,

0x8802, /*EXP Max(120Hz) 17.14 fps */
0x89bf,
0x8a20,

0xa502, /*EXP Max(100Hz) 16.67 fps */
0xa6bf,
0xa720,

0x9103, /*EXP Fix 15.00 fps*/
0x920d,
0x9340,

0x0320,
0x109C,

0x0322,
0x10fd,

0x0300,
0x1194,

0x0300,
0x0101,
};

static const unsigned short sr130pc20_fps_20_regs[] =
{
0xFF00,
};
static const unsigned short sr130pc20_fps_25_regs[] =
{
0x0300,
0x0101,

0x1190,

0x4200,
0x4362,

0x0320,
0x101C,

0x0322,
0x107d,

0x0310,	/*page 10*/

0x410a,
0x6007,
0x6380,	/*auto decresment on AG th*/

0x0316,
0x7007,
0x711a,
0x722d,
0x7346,
0x746a,
0x7586,
0x769c,
0x77ad,
0x78bc,
0x79c9,
0x7ad4,
0x7bde,
0x7ce4,
0x7deb,
0x7ef1,
0x7ff5,
0x80f9,
0x81fd,
0x82ff,

0x0322,
0x8f5d,
0x905a,
0x9156,
0x9250,
0x9348,
0x943f,

0x0320,
0x2afd,
0x2bf8,

0x8301, /*EXP Normal 33.33 fps */
0x845d,
0x8538,

0x8801, /*EXP Max(120Hz) 40.00 fps */
0x895f,
0x8a90,

0xa501, /*EXP Max(100Hz) 25.xx fps */
0xa6d1,
0xa7a0,

0x8b74, /*EXP100 */
0x8c68,
0x8d60, /*EXP120 */
0x8ee0,

0x9101, /*EXP Fix 25.00 fps*/
0x92d4,
0x93c0,

0x0320,
0x109C,

0x0322,
0x10fd,

0x0300,
0x1194,

0x0300,
0x0101,
};

static const unsigned short sr130pc20_fps_30_regs[] =
{
0xFF00,
};

//==========================================================
//AE - START
//==========================================================

static const unsigned short sr130pc20_ae_lock_regs[] =
{
  0xFF00,  //END
};
static const unsigned short sr130pc20_ae_unlock_regs[] =
{
  0xFF00,  //END
};

//==========================================================
//AE - END
//==========================================================



//==========================================================
//AWB - START
//==========================================================

static const unsigned short sr130pc20_awb_lock_regs[] =
{
  0xFF00,  //END
};
static const unsigned short sr130pc20_awb_unlock_regs[] =
{
  0xFF00,  //END
};

//==========================================================
//AWB - END
//==========================================================

// Frame Fixed
static const unsigned short sr130pc20_vt_mode_regs[] =
{
/*0 Page*/
0x0300,
0x0101,	/*sleep*/
0x0103,	/*s/w reset*/
0x0101,	/*sleep*/

0x0800,/*Don't touch*/
0x0937,/*Don't touch*/
0x0a33,/*Don't touch*/

/*PLL Setting*/
0xd005,
0xd130,
0xd201,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x1011,
0x1194,	/*xy flip*/
0x1200,	/*Sync type default:00 PCLK[2] 0 falling, 1 rising*/
0x1488,

/*--------------- windowing */
0x0300,
0x2000,
0x2104,
0x2200,
0x2304,
0x2403,
0x25C0,
0x2605,
0x2700,

0x4001, /*Hblank 280*/
0x4118,
0x4200, /*Vblank 20*/
0x4314,

/*--------------- BLC*/
0x8008,  /*Don't touch */
0x8197,  /*Don't touch */
0x8290,  /*Don't touch */
0x8330,  /*Don't touch */
0x84cc, /*Don't touch*/
0x8500,  /*Don't touch*/
0x86d4,  /*Don' t touch*/
0x870f,   /*Don't touch*/
0x8834,  /*Don't touch*/

0x9009, /*BLC_TIME_TH_ON*/
0x9109, /*BLC_TIME_TH_OFF */
0x92f0, /*BLC_AG_TH_ON*/
0x93e8, /*BLC_AG_TH_OFF*/

0x9495, /*091202*/
0x9590, /*091202 */
0x9838,  /*Don't touch*/

/*Dark BLC*/
0xa001,  /* 20100309*/
0xa201,  /* 20100309*/
0xa401,  /* 20100309*/
0xa601,  /* 20100309*/

/*Normal BLC*/
0xa800,
0xaa00,
0xac00,
0xae00,

/*Out  BLC*/
0x9900,
0x9a00,
0x9b00,
0x9c00,

/*2 Page*/
0x0302,
0x1200, /*Don't touch*/
0x1400, /*Don't touch*/
0x1500, /*Don't touch*/
0x184C, /*Don't touch*/
0x1900, /*Don't touch*/
0x1A39, /*Don't touch*/
0x1B00,/*Don't touch*/
0x1C1a, /*Don't touch*/
0x1D14, /*Don't touch*/
0x1E30,/*Don't touch*/
0x1F10,/*Don't touch*/

0x2077,
0x21de,
0x22a7,
0x2330,
0x2477,
0x2510,
0x2610,
0x273c,
0x2b80,
0x2c02,
0x2da0,
0x2e00,
0x2fa7,

0x3000,
0x3199,
0x3200,
0x3300,
0x3422,
0x3601,
0x3701,
0x3888,
0x3988,
0x3d03,
0x3e0d,
0x3f02,

0x49d1,
0x4a14,

0x5021,
0x5201,
0x5381,
0x5410,
0x551c,
0x5611,
0x5818,
0x5916,
0x5da2,
0x5e5a,

0x6093,	/* 20120517 modify*/
0x61a4,	/* 20120517 modify*/
0x6294,	/* 20120517 modify*/
0x63a3,   /* 20120517 modify*/
0x6494,	/* 20120517 modify*/
0x65a3,   /* 20120517 modify*/
0x670c,
0x680c,
0x690c,
0x6ab4,
0x6bc4,
0x6cb5,
0x6dc2,
0x6eb5,
0x6fc0,

0x70b6,
0x71b8,
0x7295,	/* 20120517 modify*/
0x73a2,	/* 20120517 modify*/
0x7495,	/* 20120517 modify*/
0x75a2,	/* 20120517 modify*/
0x7695,	/* 20120517 modify*/
0x77a2,	/* 20120517 modify*/
0x7C92,	/* 20120517 modify*/
0x7Dff,	/* 20120517 modify*/

0x8001,	/* 20120517 modify*/
0x818a,   /* 20120517 modify*/
0x821e,	/* 20120517 modify*/
0x8336,	/* 20120517 modify*/
0x8489,	/* 20120517 modify*/
0x858b,	/* 20120517 modify*/
0x8689,	/* 20120517 modify*/
0x878b,	/* 20120517 modify*/
0x88ab,
0x89bc,
0x8aac,
0x8bba,
0x8cad,
0x8db8,
0x8eae,
0x8fb2,

0x90b3,
0x91b7,
0x9252,	/* 20120517 modify*/
0x936a,	/* 20120517 modify*/
0x9489,	/* 20120517 modify*/
0x958b,	/* 20120517 modify*/
0x9689,	/* 20120517 modify*/
0x978b,	/* 20120517 modify*/

0xA002,
0xA186,	/* 20120517 modify*/
0xA202,
0xA386,	/* 20120517 modify*/
0xA486,	/* 20120517 modify*/
0xA502,
0xA686,	/* 20120517 modify*/
0xA702,
0xA892,	/* 20120517 modify*/
0xA994,	/* 20120517 modify*/
0xAA92,	/* 20120517 modify*/
0xAB94,	/* 20120517 modify*/
0xAC1c,
0xAD22,
0xAE1c,
0xAF22,

0xB0a4,	/* 20120517 modify*/
0xB1ae,	/* 20120517 modify*/
0xB2a4,	/* 20120517 modify*/
0xB3ae,	/* 20120517 modify*/
0xB4a6,	/* 20120517 modify*/
0xB5ac,	/* 20120517 modify*/
0xB6a6,	/* 20120517 modify*/
0xB7ac,	/* 20120517 modify*/
0xB8a6,	/* 20120517 modify*/
0xB9ab,	/* 20120517 modify*/
0xBAa6,	/* 20120517 modify*/
0xBBab,	/* 20120517 modify*/
0xBCa6,	/* 20120517 modify*/
0xBDab,	/* 20120517 modify*/
0xBEa6,	/* 20120517 modify*/
0xBFab,	/* 20120517 modify*/

0xc437,
0xc552,
0xc66b,
0xc786,
0xc838,	/* 20120517 modify*/
0xc950,	/* 20120517 modify*/
0xca38,	/* 20120517 modify*/
0xcb50,	/* 20120517 modify*/
0xcc6c,	/* 20120517 modify*/
0xcd84,	/* 20120517 modify*/
0xce6c,	/* 20120517 modify*/
0xcf84,	/* 20120517 modify*/

/*d4a6,*/
/*d5ac,*/
/*d6a6,*/
/*d7ac,*/
/*add 20120517*/
0xdc00,   /* Added*/
0xddaf,   /* Added*/
0xde00,   /* Added*/
0xdf90,   /* Added*/

0xd010,
0xd114,
0xd220,
0xd300,
/*DCDC */
0xd409, /*DCDC_TIME_TH_ON*/
0xd509, /*DCDC_TIME_TH_OFF */
0xd6f0, /*DCDC_AG_TH_ON*/
0xd7e8, /*DCDC_AG_TH_OFF*/

0xea8a,

0xF001,	/* clock inversion*/
0xF101,
0xF201,
0xF301,
0xF401,
0xF500,

/*----------------------------------------------*/
0x0310,	/*page 10*/
0x1001,	/*Ycbcr422_bit Order: YUYV*/
0x1230,	/*y offset[4], dif_offset[5]*/
0x1302,	/*contrast effet enable : 02*/
0x3400,	/*hidden 10->00 100209*/
0x3701,	/*yc2d power save */
0x3f04,	/*100825*/
0x4080,	/*Y offset  */
0x4138,
0x4880,	/*Contrast (Y = constrast * (Y - 128) + 128)*//*86 */
0x50f0,
0x5300,	/*dif_offset option */
0x5530,	/*dif_offset option  diff_offset max */

0x6003,	/*out color sat en[7] | auto color decrement en[1] /
	| manual color sat en[0]*/


0x6183,	/*blue saturation_C0*/
0x6280,	/*red saturation_B0*/

0x63ff,	/*auto decresment on AG th*/
0x64ff,	/*auto decresment on DG th*/
0x66e4,	/*Outdoor saturation step 137fps apply out th */
0x6700,	/*Outdoor saturation B/R*/
0x7601, /* ADD 20121031 */
0x7904, /* ADD 20121031 */

/* Hi 163 */
/* PAGE 10 START*/
0x0310,
0x8000, /* dsshin --> color enhance*/
0xf500, /* dsshin --> h blank option*/

0x0311,	/*page 11 D_LPF	*/
0x103f,	/*B[6]:Blue En  Dlpf on[4:0] Sky over off :7f->3f*/
0x1120,	/* Uniform Full GbGr/OV-Nr*/

0x1280,	/*Blue MaxOpt  blue sky max filter optoin rate : 0 c0->80*/
0x13b8,	/*dark2[7] | dark2 maxfilter ratio[6:4]
	| dark3[3] | dark3 maxfilter ratio[2:0] */

0x30ba,	/*Outdoor2 H th*/
0x3110,	/*Outdoor2 L th*/
0x3250,	/*Outdoor2 gain ratio*/
0x331d,	/*Outdoor2 H lum*/
0x3420,	/*Outdoor2 M lum*/
0x351f,	/*Outdoor2 L lum*/

0x36b0,	/*Outdoor1 H th*/
0x3718,	/*Outdoor1 L th*/
0x3850,	/*Outdoor1 gain ratio  80->40*/
0x391d,	/*Outdoor1 H lum       28->1e*/
0x3a20,	/*Outdoor1 M lum       10->15*/
0x3b1f,	/*Outdoor1 L lum       08->20*/

0x3c3f,	/*indoor H th*/
0x3d16,	/*indoor L th*/
0x3e30,	/*indoor gain ratio    44  6a */
0x3f1a,	/*indoor H lum         12  18	*/
0x4060,	/*indoor M lum	       18  1c*/
0x411a,	/*indoor L lum         18  3e*/

0x4298,	/*dark1 H th*/
0x4328,	/*dark1 L th*/
0x4465,	/*dark1 gain ratio*/
0x4516,	/*dark1 H lum         38->28  */
0x4630,	/*dark1 M lum         27->17*/
0x4734,	/*dark1 L lum         20->1a */

0x4890,	/*dark2 H th*/
0x492a,	/*dark2 L th*/
0x4a65,	/*dark2 gain ratio*/
0x4b18,	/*dark2 H lum */
0x4c31,	/*dark2 M lum*/
0x4d36,	/*dark2 L lum */

0x4e80,	/*dark3 H th*/
0x4f30,	/*dark3 L th*/
0x5065,	/*dark3 gain ratio*/
0x5119,	/*dark3 H lum	*/
0x5231,	/*dark3 M lum */
0x5336,	/*dark3 L lum */

0x5a3f,	/*blue sky mode out1/2 enable  27->3f */
0x5b00,	/*Impulse pixel enable dark123,in,out123
	::  must be 07 fix setting use!*/
0x5c9f,	/*Indoor maxfilter rate[7:5] | Uncertain onoff[4:0] 1f ->9f*/

0x603f,	/*GbGr all enable*/
0x620f,	/*GbGr offset*/
/*6325,*/	/*GbGr max_20120605_off*/
/*6410,*/	/*GbGr min_20120605_off*/

0x650c,	/*Outdoor GbGr rate H 100% M 25% L 100%*/
0x660c,	/*Indoor GbGr  rate H 100% M 25% L 100%*/
0x6700,	/*dark GbGr    rate H/M/L  100%*/

0x700c,	/* Abberation On/Off B[1]: Outdoor B[0]: Indoor 07>>c*/
0x75a0,	/* Outdoor2 Abberation Luminance lvl */
0x7db4,	/* Indoor Abberation Luminance   lvl*/

0x9608,	/*indoor/Dark1 edgeoffset1*/
0x9714,	/*indoor/Dark1 center G value*/
0x98f5,	/*slope indoor :: left/right graph polarity, slope*/
0x992a,	/*indoor uncertain ratio control*/
0x9a20,	/*Edgeoffset_dark*/

/*DPC_CTRL*/
0x0312,	/*Preview DPC off[5c] on[5d]*/
0x200e,
0x210e,

0x2500, /* 30*/

0x2a01,
0x2e00,	/*2010.8.25*/

0x3035,	/*Texture region(most detail)*/
0x31a0,	/*STD uniform1 most blur region*/
0x32b0,	/*STD uniform2      2nd blur*/
0x33c0,	/*STD uniform3      3rd blur*/
0x34d0,	/*STD normal noise1 4th blur	*/
0x35e0,	/*STD normal noise2 5th blur*/
0x36ff,	/*STD normal noise3 6th blur*/

0x4083,	/*Outdoor2 H th*/
0x4120,	/*Outdoor2 L th		*/
0x4208,	/*Outdoor2 H luminance */
0x4310,	/*Outdoor2 M luminance */
0x4410,	/*Outdoor2 l luminance */
0x4550,	/*Outdoor2 ratio*/

0x4683,	/*Outdoor1 H th*/
0x4720,	/*Outdoor1 L th		*/
0x4808,	/*Outdoor1 H luminance*/
0x4910,	/*Outdoor1 M luminance*/
0x4a10,	/*Outdoor1 L luminance*/
0x4b50,	/*Outdoor1 ratio*/

0x4c80,	/*Indoor H th*/
0x4d48,	/*Indoor L th*/
0x4e30,	/*indoor H lum*/
0x4f30,	/*indoor M lum*/
0x5012,	/*indoor L lum */
0x5170,	/*indoor ratio  10 -> 45*/

0x52a8,	/*dark1 H th*/
0x5330,	/*dark1 L th	*/
0x5428,	/*dark1 H lum */
0x553e,	/*dark1 M lum*/
0x5667,	/*dark1 L lum*/
0x576a,	/*dark1 ratio*/

0x58a0,	/*dark2 H th*/
0x5940,	/*dark2 L th*/
0x5a28,	/*dark2 H lum*/
0x5b3f,	/*dark2 M lum*/
0x5c68,	/*dark2 L lum*/
0x5d70,	/*dark2 ratio*/

0x5ea0,	/*dark3 H th*/
0x5f40,	/*dark3 L th*/
0x6029,	/*dark3 H lum*/
0x613f,	/*dark3 M lum*/
0x6269,	/*dark3 L lum*/
0x636a,	/*dark3 ratio*/

/*C-filter(Out2&Out1)*/
0x7010,
0x710a,

/*C-filter(Indoor&Dark3)*/
0x7210,
0x730a,

/*C-filter(Dark2&Dark1)*/
0x7418,
0x7512,

0x8020,
0x8140,
0x8265,
0x851a,
0x8800,
0x8900,
0x905d,	/*Preview DPC off[5c] on[5d]*/

/*DPC-Dark1,2,3*/
0xad07,	/*10825*/
0xae07,	/*10825*/
0xaf07,	/*10825*/

/*Blue Det..*/
0xc558,	/*BlueRange   2010.8.25    40->23 */
0xc620,	/*GreenRange  2010.8.25    3b->20 */

0xd088,	/*2010.8.25*/
0xd180,
0xd217,/*preview 17, full 67*/
0xd300,
0xd400,
0xd50f,/*preview 0f, full 02*/
0xd6ff,
0xd7ff,/*preview ff, full 18*/
0xd800,
0xd904,

/*interpolated with average*/
0xdb38,	/*resolution issue 00->18->38 */
0xd904,	/*strong_edge detect ratio*/
0xe001,	/*strong_edge detect ratio*/

0x0313,	/*page 13 sharpness 1D*/
0x10c5,
0x117b,
0x120e,
0x1400,

0x1511,	/*added option 1.3M*/
0x1830,	/*added option 1.3M*/

0x2015,
0x2113,
0x2233,
0x2308,	/*hi_clip th1*/
0x241a,	/*hi_clip th2*/
0x2506,	/*low clip th*/

0x2618,
0x2730,
0x2910,	/*time th*/
0x2a30,	/*pga th*/

0x2b03,	/*lpf out2*/
0x2c03,	/*lpf out1*/
0x2d0c,
0x2e12,
0x2f12,

/*1D Edge*/
0x500a,	/*out2  hi nega*/
0x5307,	/*      hi pos*/
0x510c,	/*      mi nega*/
0x5407,	/*      mi pos*/
0x520b,	/*      lo nega*/
0x5508,	/*      lo pos*/

0x560a,	/*out1   hi nega*/
0x5907,	/*       hi pos */
0x570c,	/*       mi nega*/
0x5a07,	/*       mi pos */
0x580b,	/*       lo nega*/
0x5b08,	/*       lo pos	*/

/*Indoor Edge*/
0x5c08,  /*indoor hi  nega*/
0x5f07,  /*       hi  pos*/
0x5d14,  /*       mid nega ,11*/
0x6012,  /*       mid pos ,0*/
0x5e0a,  /*       low nega  */
0x6108,  /*       low pos*/

0x6208,  /*dark1  hi nega*/
0x6506,  /*       hi  pos   */
0x6308,  /*       mid nega  */
0x6606,  /*       mid pos   */
0x6408,  /*       low nega  */
0x6706,  /*       low pos   */

0x6807,  /*dark2  hi  nega*/
0x6b05,  /*       hi  pos       */
0x6907,  /*       mid nega      */
0x6c05,  /*       mid pos       */
0x6a07,  /*       low nega      */
0x6d05,  /*       low pos       */

0x6e0a,  /*dark3  hi  nega*/
0x7109,  /*       hi  pos       */
0x6f0a,  /*       mid nega      */
0x7209,  /*       mid pos       */
0x700a,  /*       low nega      */
0x7309,  /*       low pos       */

	/* 2DY*/
0x80c1,
0x811f,
0x82e1,
0x8333,

0x9005,
0x9105,
0x9233,
0x9330,
0x9403,
0x9514,
0x9730,
0x9930,

0xa002,	/*2d lclp out2  nega*/
0xa103,	/*2d lclp out2  pos*/
0xa202,	/*2d lclp out1  nega*/
0xa303,	/*2d lclp out1  pos*/
0xa403,	/*2d lclp in    nega*/
0xa504,	/*2d lclp in    pos*/
0xa607,	/*2d lclp dark1 nega*/
0xa708,	/*2d lclp dark1 pos*/
0xa807,	/*2d lclp dark2 nega*/
0xa908,	/*2d lclp dark2 pos*/
0xaa07,	/*2d lclp dark3 nega*/
0xab08,	/*2d lclp dark3 pos*/

0xb010,	/*out2   H Ne*/
0xb310,	/*       H Po*/
0xb11e,	/*       M Ne*/
0xb41e,	/*       M Po*/
0xb21f,	/*       L Ne*/
0xb51e,	/*       L Po*/

0xb610,	/*out1   H Ne   */
0xb910,	/*       H Po   */
0xb71e,	/*       M Ne   */
0xba1e,	/*       M Po   */
0xb81f,	/*       L Ne   */
0xbb1e,	/*       L Po   */

0xbc20,  /*indoor H Ne*/
0xbf1e,  /*       H Po*/
0xbd25,  /*       M Ne*/
0xc023,  /*       M Po*/
0xbe24,  /*       L Ne*/
0xc122,  /*       L Po*/

0xc223,  /*dark1  H Ne*/
0xc523,  /*       H Po*/
0xc329,  /*       M Ne*/
0xc629,  /*       M Po*/
0xc425,  /*       L Ne*/
0xc725,  /*       L Po*/

0xc81c, /*dark2   H Ne*/
0xcb1c,  /*       H Po*/
0xc925,  /*       M Ne*/
0xcc25,  /*       M Po*/
0xca23,  /*       L Ne*/
0xcd23,  /*       L Po*/

0xce1c,  /*dark3  H Ne*/
0xd11c,  /*       H Po*/
0xcf25,  /*       M Ne*/
0xd225,  /*       M Po*/
0xd023,  /*       L Ne*/
0xd323,  /*       L Po*/

/* PAGE 14 START*/
0x0314,
0x1031,

0x1480, /* GX*/
0x1580, /* GY*/
0x1680, /* RX*/
0x1780, /* RY*/
0x1880, /* BX*/
0x1980, /* BY*/

0x2060, /* X Center*/
0x2180, /* Y Center*/

0x2280,
0x2380,
0x2480,

0x30c8,
0x312b,
0x3200,
0x3300,
0x3490,

0x4056,	/*R min's set 4e*/
0x413a,	/*Gr*/
0x4237,	/*B*/
0x433a,	/*Gb*/

0x0315,
0x1021,
0x1444, /*49*/
0x1534, /*38*/
0x1626, /*2b*/
0x172f,

0x30dd,
0x3162,
0x3205,
0x3326,
0x34bd,
0x3517,
0x3618,
0x3738,
0x38d0,

0x40b0,
0x4130,
0x4200,
0x4300,
0x4400,
0x4500,
0x4699,
0x4719,
0x4800,

0x5016,
0x51b2,
0x521c,
0x5306,
0x5420,
0x55a6,
0x560e,
0x57b2,
0x5824,

0x0316,
0x1031,	/*GMA_CTL*/
0x187e,	/*AG_ON*/
0x197d,	/*AG_OFF*/
0x1a0e,	/*TIME_ON*/
0x1b01,	/*TIME_OFF*/
0x1Cdc,	/*OUT_ON*/
0x1Dfe,	/*OUT_OFF*/

/*GMA, Indoor*/
0x3000,
0x3107,
0x321a,
0x3335,
0x345a,
0x357c,
0x3696,
0x37a9,
0x38b7,
0x39c6,
0x3ad2,
0x3bdc,
0x3ce4,
0x3deb,
0x3ef1,
0x3ff5,
0x40f9,
0x41fd,
0x42ff,

/*RGMA, Outdoor*/
0x5000,
0x5103,
0x5213,
0x532e,
0x5459,
0x5579,
0x5690,
0x57a3,
0x58b4,
0x59c2,
0x5acd,
0x5bd7,
0x5ce0,
0x5de5,
0x5ee9,
0x5fee,
0x60f1,
0x61f3,
0x62f6,

/*BGMA Dark*/
0x7000,
0x7107,
0x721a,
0x7335,
0x745a,
0x757c,
0x7696,
0x77a9,
0x78b7,
0x79c6,
0x7ad2,
0x7bdc,
0x7ce4,
0x7deb,
0x7ef1,
0x7ff5,
0x80f9,
0x81fd,
0x82ff,

0x0324,	/*Resol control */
0x60c5,	/*edge even frame | 16bit resol | white edge cnt | scene resol enable*/
0x6104,	/*even frame update	*/
0x6408,	/*	6435,	edge th1 H*/
0x6500,	/*edge th1 L*/
0x6626,	/*edge th2 H	*/
0x6700,	/*edge th2 L	*/

0x0313,
0x1831,	/*flat center Gb/Gr*/
0x7402,	/*det slope en | gausian filter*/
0x750d,	/*1D negative gain det 09	*/
0x760d,	/*1D postive  gain det	08*/
0x7710,	/*1D hclp2 det*/
0x7808,	/*outdoor flat threshold*/
0x7910,	/*indoor flat threshold*/

0x81df,	/*det gain controler*/
0x8690,	/*2D negative gain det	*/
0x8790,	/*2D postive  gain det	*/
0x962a,	/*2D hclp2 det*/

0x0312,	/*12 page*/
0xd088,
0xd9e4,

/* PAGE 20 START*/
0x0320,
0x111c,
0x1830,
0x1a08,
0x2045,/*weight*/
0x2130,
0x2210,
0x2300,
0x2400,

0x28e7, /* add 20120223*/
0x290d, /* 20100305 ad -> 0d*/
0x2afd,
0x2bf8,

0x2cc3,
0x2d5f, /* add 20120223*/
0x2e33,
0x30f8,
0x3203,
0x332e,
0x3430,
0x35d4,
0x36fe,
0x3732,
0x3804,
0x3922,
0x3ade,
0x3b22,
0x3cde,
0x3de1,

0x5045,
0x5188,

0x561a,
0x5780,
0x580e,
0x596a,
0x5a04,

0x5e9d, /*AE_AWB_start*/
0x5f76, /*AE_AWB_start*/

0x7040, /* 6c*/
0x7182, /* 82(+8)*/

0x7621,
0x7791,
0x7822, /* 24*/
0x792b, /* Y Target 70 => 25, 72 => 26*/
0x7a23, /* 23*/
0x7b22, /* 22*/
0x7d23,

0x8301, /*EXP Normal 33.33 fps */
0x845f,
0x8590,

0x8601, /*EXPMin 7500.00 fps*/
0x8790,

0x8803, /*EXP Max(120Hz) 12.00 fps*/
0x89d0,
0x8a90,

0xa504, /*EXP Max(100Hz) 11.11 fps*/
0xa61e,
0xa7b0,

0x8B75, /*EXP100 */
0x8C30,
0x8D61, /*EXP120 */
0x8Ea8,

0x9104, /*EXP Fix 10.00 fps*/
0x9293,
0x93e0,

0x9c0a, /*EXP Limit 1071.43 fps*/
0x9df0,
0x9e01, /*EXP Unit */
0x9f90,
0x989d,

0xb016,
0xb114,
0xb2f8,
0xb314,
0xb41b,
0xb546,
0xb631,
0xb729,
0xb826,
0xb924,
0xba22,
0xbb42,
0xbc41,
0xbd40,

0xc010,
0xc138,
0xc238,
0xc338,
0xc407,

0xc880,
0xc980,
0x109c,	/* ae enable*/
/* PAGE 20 END*/

/*AE_Weight*/
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2412,
0x2522,
0x2622,
0x2721,
0x2812,
0x2922,
0x2a22,
0x2b21,
0x2c12,
0x2d23,
0x2e32,
0x2f21,
0x3012,
0x3123,
0x3232,
0x3321,
0x3412,
0x3522,
0x3622,
0x3721,
0x3812,
0x3922,
0x3a22,
0x3b21,
0x3c11,
0x3d11,
0x3e11,
0x3f11,

/* PAGE 22 START*/
0x0322,
0x10fd,
0x112e,
0x1901, /* Low On*/
0x2030, /* for wb speed*/
0x2140,
0x2401,
0x257e, /* for tracking 20120314 */

0x3080, /* 20120224 test*/
0x3180,
0x3811,
0x3934,

0x40e8,
0x4143, /* 33*/
0x4222, /* 22*/

0x43f3, /* f6*/
0x4454, /* 44*/
0x4522, /* 33*/

0x4600,
0x480a,
0x50b2,
0x5181,
0x5298,

0x8038,
0x8120,
0x8238, /* 3a*/

0x8356, /* R Max*/
0x8420, /* R Min*/
0x8554, /* B Max*/
0x8620, /* B Min*/

0x8746,
0x8836,
0x893a,
0x8a2f,

0x8b3d,
0x8c37,
0x8d35,
0x8e32,

0x8f5a,
0x9059,
0x9155,
0x924e,
0x9344,
0x943a,
0x9534,
0x962c,
0x9723,
0x9820,
0x991f,
0x9a1f,

0x9b77,
0x9c77,
0x9d48,
0x9e38,
0x9f30,

0xa040,
0xa121,
0xa26f,
0xa3ff,

0xa414, /* 1500fps*/
0xa544, /* 700fps*/
0xa6cf,

0xad40,
0xae4a,

0xaf2a,  /* low temp Rgain*/
0xb028,  /* low temp Rgain*/

0xb100, /* 20 -> 00 0405 modify*/
0xb4bf, /* for tracking 20120314*/
0xb8a1, /* a2: b-2, R+2  b4 B-3, R+4 lowtemp b0 a1 Spec AWB A modify*/
0xb900,
/* PAGE 22 END*/

/* PAGE 48 (MiPi 1600   x   1200)*/
0x0300,

/* PLL Setting */
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

/* MIPI TX Setting */
0x0348,
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
0x1d0e,
0x1e07,
0x1f08,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x3005,
0x3100,

0x3207,
0x3309,
0x3401,
0x3501,
/*3601,*/
/*3707,*/
/*3802,*/
/*3902,*/

0x0300,
0x0101,
};

static const unsigned short sr130pc20_init_regs_smart_stay[] = {
/*0 Page*/
0x0300,
0x0101,	/*sleep*/
0x0103,	/*s/w reset*/
0x0101,	/*sleep*/

0x0800,/*Don't touch*/
0x0937,/*Don't touch*/
0x0a33,/*Don't touch*/

/*PLL Setting*/
0xd005,
0xd130,
0xd201,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x1011,
0x1190,	/*xy flip*/
0x1200,
0x1488,

0x0300,
0x2000,
0x2104,
0x2200,
0x2304,
0x2403,
0x25C0,
0x2605,
0x2700,

0x4001, /*Hblank_280*/
0x4118,
0x4201, /*Vblank 400*/
0x4390,

/*--------------- BLC*/
0x8008,  /*Don't touch */
0x8197,  /*Don't touch */
0x8290,  /*Don't touch */
0x8330,  /*Don't touch */
0x84cc, /*Don't touch*/
0x8500,  /*Don't touch*/
0x86d4,  /*Don' t touch*/
0x870f,   /*Don't touch*/
0x8834,  /*Don't touch*/

0x900c, /*BLC_TIME_TH_ON*/
0x910c, /*BLC_TIME_TH_OFF */
0x92f7, /*BLC_AG_TH_ON*/
0x93ef, /*BLC_AG_TH_OFF*/

0x9495, /*091202*/
0x9590, /*091202 */
0x9838,  /*Don't touch*/

/*Dark BLC*/
0xa000,  /* 20100309*/
0xa200,  /* 20100309*/
0xa400,  /* 20100309*/
0xa600,  /* 20100309*/

/*Normal BLC*/
0xa800,
0xaa00,
0xac00,
0xae00,

/*Out  BLC*/
0x9900,
0x9a00,
0x9b00,
0x9c00,

/*2 Page*/
0x0302,
0x1200, /*Don't touch*/
0x1400, /*Don't touch*/
0x1500, /*Don't touch*/
0x184C, /*Don't touch*/
0x1900, /*Don't touch*/
0x1A39, /*Don't touch*/
0x1B00,/*Don't touch*/
0x1C1a, /*Don't touch*/
0x1D14, /*Don't touch*/
0x1E30,/*Don't touch*/
0x1F10,/*Don't touch*/

0x2077,
0x21de,
0x22a7,
0x2330,
0x2477,
0x2510,
0x2610,
0x273c,
0x2b80,
0x2c02,
0x2da0,
0x2e00,
0x2fa7,

0x3000,
0x3199,
0x3200,
0x3300,
0x3422,
0x3601,
0x3701,
0x3888,
0x3988,
0x3d03,
0x3e0d,
0x3f02,

0x49d1,
0x4a14,

0x5021,
0x5201,
0x5381,
0x5410,
0x551c,
0x5611,
0x5818,
0x5916,
0x5da2,
0x5e5a,

0x6093,	/* 20120517 modify*/
0x61a4,	/* 20120517 modify*/
0x6294,	/* 20120517 modify*/
0x63a3,   /* 20120517 modify*/
0x6494,	/* 20120517 modify*/
0x65a3,   /* 20120517 modify*/
0x670c,
0x680c,
0x690c,
0x6ab4,
0x6bc4,
0x6cb5,
0x6dc2,
0x6eb5,
0x6fc0,

0x70b6,
0x71b8,
0x7295,	/* 20120517 modify*/
0x73a2,	/* 20120517 modify*/
0x7495,	/* 20120517 modify*/
0x75a2,	/* 20120517 modify*/
0x7695,	/* 20120517 modify*/
0x77a2,	/* 20120517 modify*/
0x7C92,	/* 20120517 modify*/
0x7Dff,	/* 20120517 modify*/

0x8001,	/* 20120517 modify*/
0x818a,   /* 20120517 modify*/
0x821e,	/* 20120517 modify*/
0x8336,	/* 20120517 modify*/
0x8489,	/* 20120517 modify*/
0x858b,	/* 20120517 modify*/
0x8689,	/* 20120517 modify*/
0x878b,	/* 20120517 modify*/
0x88ab,
0x89bc,
0x8aac,
0x8bba,
0x8cad,
0x8db8,
0x8eae,
0x8fb2,

0x90b3,
0x91b7,
0x9252,	/* 20120517 modify*/
0x936a,	/* 20120517 modify*/
0x9489,	/* 20120517 modify*/
0x958b,	/* 20120517 modify*/
0x9689,	/* 20120517 modify*/
0x978b,	/* 20120517 modify*/

0xA002,
0xA186,	/* 20120517 modify*/
0xA202,
0xA386,	/* 20120517 modify*/
0xA486,	/* 20120517 modify*/
0xA502,
0xA686,	/* 20120517 modify*/
0xA702,
0xA892,	/* 20120517 modify*/
0xA994,	/* 20120517 modify*/
0xAA92,	/* 20120517 modify*/
0xAB94,	/* 20120517 modify*/
0xAC1c,
0xAD22,
0xAE1c,
0xAF22,

0xB0a4,	/* 20120517 modify*/
0xB1ae,	/* 20120517 modify*/
0xB2a4,	/* 20120517 modify*/
0xB3ae,	/* 20120517 modify*/
0xB4a6,	/* 20120517 modify*/
0xB5ac,	/* 20120517 modify*/
0xB6a6,	/* 20120517 modify*/
0xB7ac,	/* 20120517 modify*/
0xB8a6,	/* 20120517 modify*/
0xB9ab,	/* 20120517 modify*/
0xBAa6,	/* 20120517 modify*/
0xBBab,	/* 20120517 modify*/
0xBCa6,	/* 20120517 modify*/
0xBDab,	/* 20120517 modify*/
0xBEa6,	/* 20120517 modify*/
0xBFab,	/* 20120517 modify*/

0xc437,
0xc552,
0xc66b,
0xc786,
0xc838,	/* 20120517 modify*/
0xc950,	/* 20120517 modify*/
0xca38,	/* 20120517 modify*/
0xcb50,	/* 20120517 modify*/
0xcc6c,	/* 20120517 modify*/
0xcd84,	/* 20120517 modify*/
0xce6c,	/* 20120517 modify*/
0xcf84,	/* 20120517 modify*/

/*d4a6,*/
/*d5ac,*/
/*d6a6,*/
/*d7ac,*/
/*add 20120517*/
0xdc00,   /* Added*/
0xddaf,   /* Added*/
0xde00,   /* Added*/
0xdf90,   /* Added*/

0xd010,
0xd114,
0xd220,
0xd300,
/*DCDC */
0xd40c, /*DCDC_TIME_TH_ON*/
0xd50c, /*DCDC_TIME_TH_OFF */
0xd6f7, /*DCDC_AG_TH_ON*/
0xd7ef, /*DCDC_AG_TH_OFF*/

0xea8a,

0xF001,	/* clock inversion*/
0xF101,
0xF201,
0xF301,
0xF401,
0xF500,

/*----------------------------------------------*/
0x0310,	/*page 10*/
0x1001,	/*Ycbcr422_bit Order: YUYV*/
0x1103,
0x1230,	/*y offset[4], dif_offset[5]*/
0x1302,	/*contrast effet enable : 02*/
0x3400,	/*hidden 10->00 100209*/
0x3701,	/*yc2d power save */
0x3f04,	/*100825*/
0x4080,	/*Y offset  */
0x4128,
0x4880,
0x5300,	/*dif_offset option */
0x5530,	/*dif_offset option  diff_offset max */

0x606b,	/*out color sat en[7] | auto color decrement en[1] /
	| manual color sat en[0]*/

0x6183,	/*blue saturation_C0*/
0x6280,	/*red saturation_B0*/

0x63b0,	/*auto decresment on AG th*/
0x64ff,	/*auto decresment on DG th*/
0x66e4,	/*Outdoor saturation step 137fps apply out th */
0x6700,	/*Outdoor saturation B/R*/
0x7601, /* ADD 20121031 */
0x7904, /* ADD 20121031 */

/* Hi 163 */
/* PAGE 10 START*/
0x0310,
0x8000, /* dsshin --> color enhance*/
0xf500, /* dsshin --> h blank option*/

0x0311,	/*page 11 D_LPF	*/
0x103f,	/*B[6]:Blue En  Dlpf on[4:0] Sky over off : 7f->3f*/
0x1120,	/* Uniform Full GbGr/OV-Nr*/

0x1280,	/*Blue MaxOpt  blue sky max filter optoin rate : 0 c0->80*/
0x13b8,	/*dark2[7] | ratio[6:4] | dark3[3] | dark3 maxfilter ratio[2:0] */

0x30ba,	/*Outdoor2 H th*/
0x3110,	/*Outdoor2 L th*/
0x3250,	/*Outdoor2 gain ratio*/
0x331d,	/*Outdoor2 H lum*/
0x3420,	/*Outdoor2 M lum*/
0x351f,	/*Outdoor2 L lum*/

0x36b0,	/*Outdoor1 H th*/
0x3718,	/*Outdoor1 L th*/
0x3850,	/*Outdoor1 gain ratio  80->40*/
0x391d,	/*Outdoor1 H lum       28->1e*/
0x3a20,	/*Outdoor1 M lum       10->15*/
0x3b1f,	/*Outdoor1 L lum       08->20*/

0x3c3f,	/*indoor H th*/
0x3d16,	/*indoor L th*/
0x3e30,	/*indoor gain ratio    44  6a */
0x3f1a,	/*indoor H lum         12  18	*/
0x4060,	/*indoor M lum	       18  1c*/
0x411a,	/*indoor L lum         18  3e*/

0x4280,	/*dark1 H th*/
0x4318,	/*dark1 L th*/
0x4480,	/*dark1 gain ratio*/
0x450f,	/*dark1 H lum         38->28  */
0x460c,	/*dark1 M lum         27->17*/
0x470b,	/*dark1 L lum         20->1a */

0x4880,	/*dark2 H th*/
0x4918,	/*dark2 L th*/
0x4a80,	/*dark2 gain ratio*/
0x4b0f,	/*dark2 H lum */
0x4c0c,	/*dark2 M lum*/
0x4d0b,	/*dark2 L lum */

0x4e80,	/*dark3 H th*/
0x4f23,	/*dark3 L th*/
0x5080,	/*dark3 gain ratio*/
0x511d,	/*dark3 H lum	*/
0x521f,	/*dark3 M lum */
0x531f,	/*dark3 L lum */

0x5a3f,	/*blue sky mode out1/2 enable  27->3f */
0x5b00,	/*Impulse pixel enable dark123,in,out123 ::  must be 07*/
0x5c9f,	/*Indoor maxfilter rate[7:5] | Uncertain onoff[4:0] 1f ->9f*/

0x603f,	/*GbGr all enable*/
0x620f,	/*GbGr offset*/

0x650c,	/*Outdoor GbGr rate H 100% M 25% L 100%*/
0x660c,	/*Indoor GbGr  rate H 100% M 25% L 100%*/
0x6700,	/*dark GbGr    rate H/M/L  100%*/

0x700c,	/* Abberation On/Off B[1]: Outdoor B[0]: Indoor 07>>c*/
0x75a0,	/* Outdoor2 Abberation Luminance lvl */
0x7db4,	/* Indoor Abberation Luminance   lvl*/

0x9608,	/*indoor/Dark1 edgeoffset1*/
0x9714,	/*indoor/Dark1 center G value*/
0x98f5,	/*slope indoor :: left/right graph polarity, slope*/
0x992a,	/*indoor uncertain ratio control*/
0x9a20,	/*Edgeoffset_dark*/

/*DPC_CTRL*/
0x0312,	/*Preview DPC off[5c] on[5d]*/
0x200f,
0x210f,

0x2500, /* 30*/

0x2a01,
0x2e00,	/*2010.8.25*/

0x3035,	/*Texture region(most detail)*/
0x31a0,	/*STD uniform1 most blur region*/
0x32b0,	/*STD uniform2      2nd blur*/
0x33c0,	/*STD uniform3      3rd blur*/
0x34d0,	/*STD normal noise1 4th blur	*/
0x35e0,	/*STD normal noise2 5th blur*/
0x36ff,	/*STD normal noise3 6th blur*/

0x4083,	/*Outdoor2 H th*/
0x4120,	/*Outdoor2 L th		*/
0x4208,	/*Outdoor2 H luminance */
0x4310,	/*Outdoor2 M luminance */
0x4410,	/*Outdoor2 l luminance */
0x4550,	/*Outdoor2 ratio*/

0x4683,	/*Outdoor1 H th*/
0x4720,	/*Outdoor1 L th		*/
0x4808,	/*Outdoor1 H luminance*/
0x4910,	/*Outdoor1 M luminance*/
0x4a10,	/*Outdoor1 L luminance*/
0x4b50,	/*Outdoor1 ratio*/

0x4c80,	/*Indoor H th*/
0x4d48,	/*Indoor L th*/
0x4e30,	/*indoor H lum*/
0x4f30,	/*indoor M lum*/
0x5012,	/*indoor L lum */
0x5170,	/*indoor ratio  10 -> 45*/

0x52a8,	/*dark1 H th*/
0x5330,	/*dark1 L th	*/
0x5428,	/*dark1 H lum */
0x553e,	/*dark1 M lum*/
0x5667,	/*dark1 L lum*/
0x576a,	/*dark1 ratio*/

0x58a0,	/*dark2 H th*/
0x5940,	/*dark2 L th*/
0x5a28,	/*dark2 H lum*/
0x5b3f,	/*dark2 M lum*/
0x5c68,	/*dark2 L lum*/
0x5d70,	/*dark2 ratio*/

0x5ea0,	/*dark3 H th*/
0x5f1c,	/*dark3 L th*/
0x6029,	/*dark3 H lum*/
0x614a,	/*dark3 M lum*/
0x62ff,	/*dark3 L lum*/
0x63ff,	/*dark3 ratio*/

/*C-filter(Out2&Out1)*/
0x7010,
0x710a,

/*C-filter(Indoor&Dark3)*/
0x7210,
0x730a,

/*C-filter(Dark2&Dark1)*/
0x7418,
0x7512,

0x8020,
0x8140,
0x8265,
0x851a,
0x8800,
0x8900,
0x905d,	/*Preview DPC off[5c] on[5d]*/

/*DPC-Dark1,2,3*/
0xad07,	/*10825*/
0xae07,	/*10825*/
0xaf07,	/*10825*/

/*Blue Det..*/
0xc558,	/*BlueRange   2010.8.25    40->23 */
0xc620,	/*GreenRange  2010.8.25    3b->20 */

0xd088,	/*2010.8.25*/
0xd180,
0xd217,/*preview 17, full 67*/
0xd300,
0xd400,
0xd50f,/*preview 0f, full 02*/
0xd6ff,
0xd7ff,/*preview ff, full 18*/
0xd800,
0xd904,

/*interpolated with average*/
0xdb38,	/*resolution issue 00->18->38 */
0xd904,	/*strong_edge detect ratio*/
0xe001,	/*strong_edge detect ratio*/

0x0313,	/*page 13 sharpness 1D*/
0x10c5,
0x117b,
0x120e,
0x1400,

0x1511,	/*added option 1.3M*/
0x1830,	/*added option 1.3M*/

0x2015,
0x2113,
0x2233,
0x2308,	/*hi_clip th1*/
0x241a,	/*hi_clip th2*/
0x2506,	/*low clip th*/

0x2618,
0x2730,
0x2910,	/*time th*/
0x2a30,	/*pga th*/

0x2b03,	/*lpf out2*/
0x2c03,	/*lpf out1*/
0x2d0c,
0x2e12,
0x2f12,

/*1D Edge*/
0x500a,	/*out2  hi nega*/
0x5307,	/*      hi pos*/
0x510c,	/*      mi nega*/
0x5407,	/*      mi pos*/
0x520b,	/*      lo nega*/
0x5508,	/*      lo pos*/

0x560a,	/*out1   hi nega*/
0x5907,	/*       hi pos */
0x570c,	/*       mi nega*/
0x5a07,	/*       mi pos */
0x580b,	/*       lo nega*/
0x5b08,	/*       lo pos	*/

/*Indoor Edge*/
0x5c08,  /*indoor hi  nega*/
0x5f07,  /*       hi  pos*/
0x5d14,
0x6012,
0x5e0a,
0x6108,  /*       low pos*/

0x6208,  /*dark1  hi nega*/
0x6506,  /*       hi  pos   */
0x6308,  /*       mid nega  */
0x6606,  /*       mid pos   */
0x6408,  /*       low nega  */
0x6706,  /*       low pos   */

0x6807,  /*dark2  hi  nega*/
0x6b05,  /*       hi  pos       */
0x6907,  /*       mid nega      */
0x6c05,  /*       mid pos       */
0x6a07,  /*       low nega      */
0x6d05,  /*       low pos       */

0x6e0a,  /*dark3  hi  nega*/
0x7109,  /*       hi  pos       */
0x6f0d,  /*       mid nega      */
0x720c,  /*       mid pos       */
0x700d,  /*       low nega      */
0x730c,  /*       low pos       */

	/* 2DY*/
0x80c1,
0x811f,
0x82e1,
0x8333,

0x9005,
0x9105,
0x9233,
0x9330,
0x9403,
0x9514,
0x9730,
0x9930,

0xa002,	/*2d lclp out2  nega*/
0xa103,	/*2d lclp out2  pos*/
0xa202,	/*2d lclp out1  nega*/
0xa303,	/*2d lclp out1  pos*/
0xa403,	/*2d lclp in    nega*/
0xa504,	/*2d lclp in    pos*/
0xa607,	/*2d lclp dark1 nega*/
0xa708,	/*2d lclp dark1 pos*/
0xa807,	/*2d lclp dark2 nega*/
0xa908,	/*2d lclp dark2 pos*/
0xaa07,	/*2d lclp dark3 nega*/
0xab08,	/*2d lclp dark3 pos*/

0xb010,	/*out2   H Ne*/
0xb310,	/*       H Po*/
0xb11e,	/*       M Ne*/
0xb41e,	/*       M Po*/
0xb21f,	/*       L Ne*/
0xb51e,	/*       L Po*/

0xb610,	/*out1   H Ne   */
0xb910,	/*       H Po   */
0xb71e,	/*       M Ne   */
0xba1e,	/*       M Po   */
0xb81f,	/*       L Ne   */
0xbb1e,	/*       L Po   */

0xbc20,  /*indoor H Ne*/
0xbf1e,  /*       H Po*/
0xbd25,  /*       M Ne*/
0xc023,  /*       M Po*/
0xbe24,  /*       L Ne*/
0xc122,  /*       L Po*/

0xc223,  /*dark1  H Ne*/
0xc523,  /*       H Po*/
0xc329,  /*       M Ne*/
0xc629,  /*       M Po*/
0xc425,  /*       L Ne*/
0xc725,  /*       L Po*/

0xc81c, /*dark2   H Ne*/
0xcb1c,  /*       H Po*/
0xc925,  /*       M Ne*/
0xcc25,  /*       M Po*/
0xca23,  /*       L Ne*/
0xcd23,  /*       L Po*/

0xce1c,  /*dark3  H Ne*/
0xd11c,  /*       H Po*/
0xcf29,  /*       M Ne*/
0xd229,  /*       M Po*/
0xd027,  /*       L Ne*/
0xd327,  /*       L Po*/

/* PAGE 14 START*/
0x0314,
0x1031,

0x1480, /* GX*/
0x1580, /* GY*/
0x1680, /* RX*/
0x1780, /* RY*/
0x1880, /* BX*/
0x1980, /* BY*/

0x2060, /* X Center*/
0x2180, /* Y Center*/

0x2280,
0x2380,
0x2480,

0x30c8,
0x312b,
0x3200,
0x3300,
0x3490,

0x4056,	/*R min's set 4e*/
0x413a,	/*Gr*/
0x4237,	/*B*/
0x433a,	/*Gb*/

0x0315,
0x1021,
0x1444, /*49*/
0x1534, /*38*/
0x1626, /*2b*/
0x172f,

0x30dd,
0x3162,
0x3205,
0x3326,
0x34bd,
0x3517,
0x3618,
0x3738,
0x38d0,

0x40b0,
0x4130,
0x4200,
0x4300,
0x4400,
0x4500,
0x4699,
0x4719,
0x4800,

0x5016,
0x51b2,
0x521c,
0x5306,
0x5420,
0x55a6,
0x560e,
0x57b2,
0x5824,

0x0316,
0x1031,	/*GMA_CTL*/
0x187e,	/*AG_ON*/
0x197d,	/*AG_OFF*/
0x1a0e,	/*TIME_ON*/
0x1b01,	/*TIME_OFF*/
0x1Cdc,	/*OUT_ON*/
0x1Dfe,	/*OUT_OFF*/

/*GMA Indoor*/
0x3000,
0x3126,
0x3238,
0x3355,
0x347e,
0x3597,
0x36a9,
0x37ba,
0x38c7,
0x39d2,
0x3adb,
0x3be3,
0x3cea,
0x3dee,
0x3ef5,
0x3ff9,
0x40fc,
0x41fe,
0x42ff,

/*RGMA Outdoor*/
0x5000,
0x5126,
0x5238,
0x5355,
0x547e,
0x5597,
0x56a9,
0x57ba,
0x58c7,
0x59d2,
0x5adb,
0x5be3,
0x5cea,
0x5dee,
0x5ef5,
0x5ff9,
0x60fc,
0x61fe,
0x62ff,

/*BGMA Dark*/
0x7002,
0x712a,
0x723b,
0x7359,
0x7481,
0x759b,
0x76ac,
0x77be,
0x78ca,
0x79d4,
0x7adb,
0x7be4,
0x7ceb,
0x7def,
0x7ef6,
0x7ffa,
0x80fc,
0x81fe,
0x82ff,

0x0324,	/*Resol control */
0x60c5,	/*edge even frame | 16bit resol | white edge cnt | scene resol enable*/
0x6104,	/*even frame update	*/
0x6408,
0x6500,
0x6626,	/*edge th2 H	*/
0x6700,	/*edge th2 L	*/

0x0313,
0x1831,	/*flat center Gb/Gr*/
0x7402,	/*det slope en | gausian filter*/
0x750d,	/*1D negative gain det 09	*/
0x760d,	/*1D postive  gain det	08*/
0x7710,	/*1D hclp2 det*/
0x7808,	/*outdoor flat threshold*/
0x7910,	/*indoor flat threshold*/

0x81df,	/*det gain controler*/
0x8690,	/*2D negative gain det	*/
0x8790,	/*2D postive  gain det	*/
0x962a,	/*2D hclp2 det*/

0x0312,	/*12 page*/
0xd088,
0xd9e4,

/* PAGE 18 START*/
0x0318,
0x1400,

/* PAGE 20 START*/
0x0320,
0x111c,
0x1830,
0x1a08,
0x2045,/*weight*/
0x2130,
0x2210,
0x2300,
0x2400,

0x28e7, /* add 20120223*/
0x290d, /* 20100305 ad -> 0d*/
0x2afd,
0x2bf8,

0x2cc3,
0x2d5f, /* add 20120223*/
0x2e33,
0x30f8,
0x3203,
0x332e,
0x3430,
0x35d4,
0x36ff, /*fe*/
0x3732,
0x3804,
0x3922,
0x3ade,
0x3b22,
0x3cde,
0x3de1,

0x5045,
0x5188,

0x561a,
0x5780,
0x580e,
0x596a,
0x5a04,

0x5e9d, /*AE_AWB_start*/
0x5f76, /*AE_AWB_start*/

0x703f, /* 6c*/
0x7180, /* 82(+8)*/

0x7621,
0x7781,
0x7822, /* 24*/
0x7925, /* Y Target 70 => 25, 72 => 26*/
0x7a23, /* 23*/
0x7b22, /* 22*/
0x7d23,

0x8301, /*EXP Normal 30.00 fps */
0x845f,
0x8590,
0x8601, /*EXPMin 7500.00 fps*/
0x8790,
0x8805, /*EXP Max(120Hz) 8.00 fps */
0x89b8,
0x8ad8,
0xa505, /*EXP Max(100Hz) 8.33 fps */
0xa67e,
0xa740,
0x8B75, /*EXP100 */
0x8C30,
0x8D61, /*EXP120 */
0x8Ea8,
0x9c09, /*EXP Limit 1250.00 fps */
0x9d60,
0x9e01, /*EXP Unit */
0x9f90,
0x989d,

0xb016,
0xb114,
0xb2f0,
0xb314,
0xb41b,
0xb546,
0xb631,
0xb729,
0xb826,
0xb924,
0xba22,
0xbb42,
0xbc41,
0xbd40,

0xc010,
0xc138,
0xc238,
0xc338,
0xc407,

0xc880,
0xc980,
0x109c,	/* ae enable*/
/* PAGE 20 END*/

/*AE_Weight*/
0x0321,
0x2011,
0x2111,
0x2211,
0x2311,
0x2422,
0x2522,
0x2622,
0x2721,
0x2823,
0x2933,
0x2a32,
0x2b21,
0x2c23,
0x2d44,
0x2e32,
0x2f21,
0x3023,
0x3144,
0x3232,
0x3311,
0x3423,
0x3533,
0x3632,
0x3721,
0x3822,
0x3922,
0x3a22,
0x3b21,
0x3c11,
0x3d11,
0x3e11,
0x3f11,

/* PAGE 22 START*/
0x0322,
0x10fd,
0x112e,
0x1901, /* Low On*/
0x2030, /* for wb speed*/
0x2140,
0x2401,
0x257e, /* for tracking 20120314 */

0x3080, /* 20120224 test*/
0x3180,
0x3811,
0x3934,

0x40e8,
0x4143, /* 33*/
0x4222, /* 22*/

0x43f3, /* f6*/
0x4454, /* 44*/
0x4522, /* 33*/

0x4600,
0x480a,
0x50b2,
0x5181,
0x5298,

0x8038,
0x8120,
0x8238, /* 3a*/

0x8356, /* R Max*/
0x8420, /* R Min*/
0x8552, /* B Max*/
0x8620, /* B Min*/

0x8746,
0x8836,
0x8939,
0x8a2d,

0x8b3c,
0x8c36,
0x8d34,
0x8e31,

0x8f5a,
0x9059,
0x9154,
0x924d,
0x9342,
0x943a,
0x9534,
0x962c,
0x9723,
0x9820,
0x991f,
0x9a1f,

0x9b77,
0x9c77,
0x9d48,
0x9e38,
0x9f30,

0xa040,
0xa122,
0xa26f,
0xa3ff,

0xa414, /* 1500fps*/
0xa544, /* 700fps*/
0xa6cf,

0xad40,
0xae4a,

0xaf2a,  /* low temp Rgain*/
0xb028,  /* low temp Rgain*/

0xb100, /* 20 -> 00 0405 modify*/
0xb4bf, /* for tracking 20120314*/
0xb8a1, /* a2: b-2, R+2  b4 B-3, R+4 lowtemp b0 a1 Spec AWB A modify*/
0xb900,
/* PAGE 22 END*/

/* PAGE 48 (MiPi 1600  x  1200)*/
0x0300,

/* PLL Setting */
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

0x0348,
/* MIPI TX Setting */
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
0x1d0e,
0x1e07,
0x1f08,

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2b40,*/

0x3005,
0x3100,

0x3207,
0x3309,
0x3401,
0x3501,

0x0300,
0x0101,
};

static const unsigned short sr130pc20_640_480_size_regs[] =
{
0x0300,
0x0101,/*sleep*/

0xd005,/*Pll Off*/

0x0320,
0x101c,/*AE off (0c:60Hz   1c:50Hz)*/
0x0322,
0x107d,/*AWB off*/

0x0300,
0x1011,
/* 1190, *//*91 : mirror mode*/

/* page 11  yc_lpf */
0x0311,
0x5b00,/*don't touch*/

/* PAGE 12  YC_LPF */
0x0312,
0x200f,
0x210f,

/*preview DPC*/
0xd217,
0xd50f,
0xd7ff,


/* PAGE13  Sharpness 1D/2D */
0x0313,
0x10c4,
0x80c0,

/* PAGE 18 START*/
0x0318,
0x1443, /*83*/

0x0320,
0x109c,  /*AE ON (8c:60Hz   9c:50Hz)*/
0x0322,
0x10fd,  /*AWB ON*/

0x0300,  /*Page 0 PLL on*/
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

/* MIPI TX Setting */
0x0348,
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
/*1d09,*/
0x1d0e,
0x1e07,
0x1f08,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x3005,
0x3100,

0x3207,
0x3309,
0x3401,
0x3501,
/*3601,*/
/*3707,*/
/*3802,*/
/*3902,*/

0x0300,
0x0101,

0xff05,
};

static const unsigned short sr130pc20_528_432_size_regs[] =
{
0x0300,
0x0101,/*sleep*/

0xd005,/*Pll Off*/

0x0320,
0x101c,/*AE off (0c:60Hz   1c:50Hz)*/
0x0322,
0x107d,/*AWB off*/

0x0300,
0x1011,
/* 1190, *//*91 : mirror mode*/

/* page 11  yc_lpf */
0x0311,
0x5b00,/*don't touch*/

/* PAGE 12  YC_LPF */
0x0312,
0x200f,
0x210f,

/*preview DPC*/
0xd217,
0xd50f,
0xd7ff,


/* PAGE13  Sharpness 1D/2D */
0x0313,
0x10c4,
0x80c0,

0x0318,/*scaler page*/
0x1007,/*scaler on*/
0x1200,/*zoom config*/
0x2004,/*Target Width*/
0x2180,/*Target Width*/
0x2201,/*Target Height*/
0x23b0,/*Target Height*/
0x2400,/*Start X*/
0x2530,/*Start X*/
0x2600,/*Start Y*/
0x2700,/*Start Y*/
0x2804,/*End X*/
0x2950,/*End X*/
0x2a01,/*End Y*/
0x2bb0,/*End Y*/
0x2c08,/*Step Width*/
0x2de3,/*Step Width*/
0x2e08,/*Step Height*/
0x2fe3,/*Step Height*/
0x302d,/*Fifo delay*/

0x0320,
0x109c,  /*AE ON (8c:60Hz   9c:50Hz)*/
0x0322,
0x10fd,  /*AWB ON*/

0x0300,  /*Page 0 PLL on*/
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

/* MIPI TX Setting */
0x0348,
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
/*1d09,*/
0x1d0e,
0x1e07,
0x1f08,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x3004,/*l_pkt_wc_h*/
0x3120,/*l_pkt_wc_l*/

0x3207,
0x3309,
0x3401,
0x3501,

0x0300,
0x0101,

0xff28,
};

static const unsigned short sr130pc20_352_288_size_regs[] =
{
0x0300,
0x0101,/*sleep*/

0xd005,/*Pll Off*/

0x0320,
0x101c,/*AE off (0c:60Hz   1c:50Hz)*/
0x0322,
0x107d,/*AWB off*/

0x0300,
0x1011,
/* 1190, *//*91 : mirror mode*/

/* page 11  yc_lpf */
0x0311,
0x5b00,/*don't touch*/

/* PAGE 12  YC_LPF */
0x0312,
0x200f,
0x210f,

/*preview DPC*/
0xd217,
0xd50f,
0xd7ff,


/* PAGE13  Sharpness 1D/2D */
0x0313,
0x10c4,
0x80c0,

0x0318,
0x1007,
0x1200,
0x2003,
0x2100,
0x2201,
0x2320,
0x2400,
0x2520,
0x2600,
0x2700,
0x2802,
0x29e0,
0x2a01,
0x2b20,
0x2c0d,
0x2d55,
0x2e0d,
0x2f55,
0x3051,

0x0320,
0x109c,  /*AE ON (8c:60Hz   9c:50Hz)*/
0x0322,
0x10fd,  /*AWB ON*/

0x0300,  /*Page 0 PLL on*/
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

/* MIPI TX Setting */
0x0348,
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
/*1d09,*/
0x1d0e,
0x1e07,
0x1f08,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x0348,
0x3002,
0x31c0,

0x3207,
0x3309,
0x3401,
0x3501,

0x0300,
0x0101,

0xff28,
};

static const unsigned short sr130pc20_176_144_size_regs[] =
{
0x0300,
0x0101,/*sleep*/

0xd005,/*Pll Off*/

0x0320,
0x101c,/*AE off (0c:60Hz   1c:50Hz)*/
0x0322,
0x107d,/*AWB off*/

0x0300,
0x1011,
/* 1190, *//*91 : mirror mode*/

/* page 11  yc_lpf */
0x0311,
0x5b00,/*don't touch*/

/* PAGE 12  YC_LPF */
0x0312,
0x200f,
0x210f,

/*preview DPC*/
0xd217,
0xd50f,
0xd7ff,


/* PAGE13  Sharpness 1D/2D */
0x0313,
0x10c4,
0x80c0,

0x0318,
0x1007,
0x1200,
0x2001,
0x2180,
0x2200,
0x2390,
0x2400,
0x2510,
0x2600,
0x2700,
0x2801,
0x2970,
0x2a00,
0x2b90,
0x2c1a,
0x2daa,
0x2e1a,
0x2faa,
0x304b,

0x0348,
0x3001,
0x3160,

0x0300,
0x0100,

0xff28,
};


static const unsigned short sr130pc20_320_240_size_regs[] =
{
0x0300,
0x0101,

0x0300,
0x1023,

0x0318,
0x1000,

0x0320,
0x109c,  /*AE ON (8c:60Hz   9c:50Hz)*/
0x0322,
0x10fd,  /*AWB ON*/

0x0300,  /*Page 0 PLL on*/
0xd005,
0xd130,
0xd205,
0xd320,
0xd085,
0xd085,
0xd085,
0xd095,

/* MIPI TX Setting */
0x0348,
0x101c,
0x1100,
0x1200,
0x1400,
0x1604,
0x1700,
0x1880,
0x1900,
0x1aa0,
/*1b0d,*/
0x1c02,
/*1d09,*/
0x1d0e,
0x1e07,
0x1f08,
/*2000,*/

0x2200,
0x2301,
0x241e,
0x2500,
0x2600,
0x2708,
0x2800,
/*2a06,*/
/*2b40,*/
/*2c04,*/
/*2db0,*/

0x3002,
0x3180,

0x3207,
0x3309,
0x3401,
0x3501,

0x0300,
0x0101,

0xff28,
};

#endif /* __EOSCAMERASR130PC20_REG_H */
