/* linux/drivers/media/video/exynos/jpeg/jpeg_conf.h
 *
 * Copyright (c) 2013 Samsung Electronics Co., Ltd.
 * http://www.samsung.com/
 *
 * Definition Quantization Table for Jpeg encoder/docoder
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __JPEG_CONF_H__
#define __JPEG_CONF_H__

/* Q-table for JPEG */
/* ITU standard Q-table */
static const unsigned int qtbl[6][2][16] = {
	{ /* QF : 97 */
	{/* Y */
		0x01010101, 0x01020304, 0x01010101, 0x02030403,
		0x01010101, 0x02030403, 0x01010102, 0x03050504,
		0x01010203, 0x04070605, 0x01020304, 0x05060706,
		0x03040505, 0x06070706, 0x04060606, 0x07060606,
	},
	/* Original QTBL Y */
	/*{
		0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04,
		0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04, 0x03,
		0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04, 0x03,
		0x01, 0x01, 0x01, 0x02, 0x03, 0x05, 0x05, 0x04,
		0x01, 0x01, 0x02, 0x03, 0x04, 0x07, 0x06, 0x05,
		0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x06,
		0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x06,
		0x04, 0x06, 0x06, 0x06, 0x07, 0x06, 0x06, 0x06,
	}, */
	{/* CbCr */
		0x01010103, 0x06060606, 0x01010204, 0x06060606,
		0x01020306, 0x06060606, 0x03040606, 0x06060606,
		0x06060606, 0x06060606, 0x06060606, 0x06060606,
		0x06060606, 0x06060606, 0x06060606, 0x06060606,
	},
	/* Original QTBL CbCr */
	/* {
		0x01, 0x01, 0x01, 0x03, 0x06, 0x06, 0x06, 0x06,
		0x01, 0x01, 0x02, 0x04, 0x06, 0x06, 0x06, 0x06,
		0x01, 0x02, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x03, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	}, */
	},
	{ /* QF : 92 */
	{/* Y */
		0x03020203, 0x0406080a, 0x02020203, 0x04090a09,
		0x02020304, 0x06090b09, 0x02030405, 0x080e0d0a,
		0x03040609, 0x0b11100c, 0x0406090a, 0x0d11120f,
		0x080a0c0e, 0x10131310, 0x0c0f0f10, 0x12101010,
	},
	/* Original QTBL Y */
	/* {
		0x03, 0x02, 0x02, 0x03, 0x04, 0x06, 0x08, 0x0a,
		0x02, 0x02, 0x02, 0x03, 0x04, 0x09, 0x0a, 0x09,
		0x02, 0x02, 0x03, 0x04, 0x06, 0x09, 0x0b, 0x09,
		0x02, 0x03, 0x04, 0x05, 0x08, 0x0e, 0x0d, 0x0a,
		0x03, 0x04, 0x06, 0x09, 0x0b, 0x11, 0x10, 0x0c,
		0x04, 0x06, 0x09, 0x0a, 0x0d, 0x11, 0x12, 0x0f,
		0x08, 0x0a, 0x0c, 0x0e, 0x10, 0x13, 0x13, 0x10,
		0x0c, 0x0f, 0x0f, 0x10, 0x12, 0x10, 0x10, 0x10,
	}, */
	{/* CbCr */
		0x03030408, 0x10101010, 0x0303040b, 0x10101010,
		0x04040910, 0x10101010, 0x080b1010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0x10101010, 0x10101010,
	},
	/* Original QTBL CbCr */
	/* {
		0x03, 0x03, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10,
		0x03, 0x03, 0x04, 0x0b, 0x10, 0x10, 0x10, 0x10,
		0x04, 0x04, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10,
		0x08, 0x0b, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
		0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
		0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
		0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
		0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	}, */
	},
	{ /* QF : 88 */
	{/* Y */
		0x04030204, 0x060a0c0f, 0x03030305, 0x060e0e0d,
		0x03030406, 0x0a0e110d, 0x03040507, 0x0c15130f,
		0x0405090d, 0x101a1912, 0x06080d0f, 0x13191b16,
		0x0c0f1315, 0x191d1d18, 0x11161718, 0x1b181918,
	},
	/* Original QTBL Y */
	/* {
		0x04, 0x03, 0x02, 0x04, 0x06, 0x0a, 0x0c, 0x0f,
		0x03, 0x03, 0x03, 0x05, 0x06, 0x0e, 0x0e, 0x0d,
		0x03, 0x03, 0x04, 0x06, 0x0a, 0x0e, 0x11, 0x0d,
		0x03, 0x04, 0x05, 0x07, 0x0c, 0x15, 0x13, 0x0f,
		0x04, 0x05, 0x09, 0x0d, 0x10, 0x1a, 0x19, 0x12,
		0x06, 0x08, 0x0d, 0x0f, 0x13, 0x19, 0x1b, 0x16,
		0x0c, 0x0f, 0x13, 0x15, 0x19, 0x1d, 0x1d, 0x18,
		0x11, 0x16, 0x17, 0x18, 0x1b, 0x18, 0x19, 0x18,
	}, */
	{/* CbCr */
		0x0404060b, 0x18181818, 0x04050610, 0x18181818,
		0x06060d18, 0x18181818, 0x0b101818, 0x18181818,
		0x18181818, 0x18181818, 0x18181818, 0x18181818,
		0x18181818, 0x18181818, 0x18181818, 0x18181818,
	},
	/* Original QTBL CbCr */
	/* {	0x04, 0x04, 0x06, 0x0b, 0x18, 0x18, 0x18, 0x18,
		0x04, 0x05, 0x06, 0x10, 0x18, 0x18, 0x18, 0x18,
		0x06, 0x06, 0x0d, 0x18, 0x18, 0x18, 0x18, 0x18,
		0x0b, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
		0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
		0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
		0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
		0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	}, */
	},
	{ /* QF : 38 */
	{/* Y */
		0x150e0d15, 0x1f344350, 0x10101219, 0x224c4f48,
		0x1211151f, 0x344b5a49, 0x12161d26, 0x43726951,
		0x181d3049, 0x598f8765, 0x1f2e4854, 0x6a889479,
		0x40546672, 0x879f9d84, 0x5e797c80, 0x93838782,
	},
	/* Original QTBL Y */
	/* {
		0x15, 0x0e, 0x0d, 0x15, 0x1f, 0x34, 0x43, 0x50,
		0x10, 0x10, 0x12, 0x19, 0x22, 0x4c, 0x4f, 0x48,
		0x12, 0x11, 0x15, 0x1f, 0x34, 0x4b, 0x5a, 0x49,
		0x12, 0x16, 0x1d, 0x26, 0x43, 0x72, 0x69, 0x51,
		0x18, 0x1d, 0x30, 0x49, 0x59, 0x8f, 0x87, 0x65,
		0x1f, 0x2e, 0x48, 0x54, 0x6a, 0x88, 0x94, 0x79,
		0x40, 0x54, 0x66, 0x72, 0x87, 0x9f, 0x9d, 0x84,
		0x5e, 0x79, 0x7c, 0x80, 0x93, 0x83, 0x87, 0x82,
	}, */
	{/* CbCr */
		0x16181f3e, 0x82828282, 0x181c2256, 0x82828282,
		0x1f224982, 0x82828282, 0x3e568282, 0x82828282,
		0x82828282, 0x82828282, 0x82828282, 0x82828282,
		0x82828282, 0x82828282, 0x82828282, 0x82828282,
	},
	/* Original QTBL CbCr */
	/* {
		0x16, 0x18, 0x1f, 0x3e, 0x82, 0x82, 0x82, 0x82,
		0x18, 0x1c, 0x22, 0x56, 0x82, 0x82, 0x82, 0x82,
		0x1f, 0x22, 0x49, 0x82, 0x82, 0x82, 0x82, 0x82,
		0x3e, 0x56, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
		0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
		0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
		0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
		0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	}, */
	},
	{ /* QF : 30 */
	{/* Y */
		0x1b12111b, 0x28425565, 0x14141720, 0x2b60645b,
		0x17161b28, 0x425f735d, 0x171c2530, 0x55908567,
		0x1e253d5d, 0x71b5ab80, 0x283a5b6a, 0x86adbc99,
		0x516a8190, 0xabc9c7a8, 0x78999ea3, 0xbaa6aba4,
	},
	/* Original QTBL Y */
	/* {
		0x1b, 0x12, 0x11, 0x1b, 0x28, 0x42, 0x55, 0x65,
		0x14, 0x14, 0x17, 0x20, 0x2b, 0x60, 0x64, 0x5b,
		0x17, 0x16, 0x1b, 0x28, 0x42, 0x5f, 0x73, 0x5d,
		0x17, 0x1c, 0x25, 0x30, 0x55, 0x90, 0x85, 0x67,
		0x1e, 0x25, 0x3d, 0x5d, 0x71, 0xb5, 0xab, 0x80,
		0x28, 0x3a, 0x5b, 0x6a, 0x86, 0xad, 0xbc, 0x99,
		0x51, 0x6a, 0x81, 0x90, 0xab, 0xc9, 0xc7, 0xa8,
		0x78, 0x99, 0x9e, 0xa3, 0xba, 0xa6, 0xab, 0xa4,
	}, */
	{/* CbCr */
		0x1c1e284e, 0xa4a4a4a4, 0x1e232b6e, 0xa4a4a4a4,
		0x282b5da4, 0xa4a4a4a4, 0x4e6ea4a4, 0xa4a4a4a4,
		0xa4a4a4a4, 0xa4a4a4a4, 0xa4a4a4a4, 0xa4a4a4a4,
		0xa4a4a4a4, 0xa4a4a4a4, 0xa4a4a4a4, 0xa4a4a4a4,
	},
	/* Original QTBL CbCr */
	/* {
		0x1c, 0x1e, 0x28, 0x4e, 0xa4, 0xa4, 0xa4, 0xa4,
		0x1e, 0x23, 0x2b, 0x6e, 0xa4, 0xa4, 0xa4, 0xa4,
		0x28, 0x2b, 0x5d, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
		0x4e, 0x6e, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
		0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
		0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
		0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
		0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
	}, */
	},
	{ /* QF : 10 */
	{/* Y */
		0x50373250, 0x78c8ffff, 0x3c3c465f, 0x82ffffff,
		0x46415078, 0xc8ffffff, 0x46556e91, 0xffffffff,
		0x5a6eb9ff, 0xffffffff, 0x78afffff, 0xffffffff,
		0xf5ffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	},
	/* Original QTBL Y */
	/* {
		0x50, 0x37, 0x32, 0x50, 0x78, 0xc8, 0xff, 0xff,
		0x3c, 0x3c, 0x46, 0x5f, 0x82, 0xff, 0xff, 0xff,
		0x46, 0x41, 0x50, 0x78, 0xc8, 0xff, 0xff, 0xff,
		0x46, 0x55, 0x6e, 0x91, 0xff, 0xff, 0xff, 0xff,
		0x5a, 0x6e, 0xb9, 0xff, 0xff, 0xff, 0xff, 0xff,
		0x78, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	}, */
	{/* CbCr */
		0x555a78eb, 0xffffffff, 0x5a6982ff, 0xffffffff,
		0x7882ffff, 0xffffffff, 0xebffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
	},
	/* Original QTBL CbCr */
	/* {
		0x55, 0x5a, 0x78, 0xeb, 0xff, 0xff, 0xff, 0xff,
		0x5a, 0x69, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff,
		0x78, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	} */
	}
};

/* ITU Luminace Huffman Table */
static unsigned int ITU_H_tbl_len_DC_luminance[4] = {
	0x01050100, 0x01010101, 0x00000001, 0x00000000
};
static unsigned int ITU_H_tbl_val_DC_luminance[3] = {
	0x03020100, 0x07060504, 0x0b0a0908
};

/* ITU Chrominace Huffman Table */
static unsigned int ITU_H_tbl_len_DC_chrominance[4] = {
	0x01010300, 0x01010101, 0x00010101, 0x00000000
};
static unsigned int ITU_H_tbl_val_DC_chrominance[3] = {
	0x03020100, 0x07060504, 0x0b0a0908
};

/* ITU Luminace Huffman Table */
static unsigned int ITU_H_tbl_len_AC_luminance[4] = {
	0x03010200, 0x03040203, 0x04040505, 0x7d010000
};

static unsigned int ITU_H_tbl_val_AC_luminance[41] = {
	0x00030201, 0x12051104, 0x06413121, 0x07615113,
	0x32147122, 0x08a19181, 0xc1b14223, 0xf0d15215,
	0x72623324, 0x160a0982, 0x1a191817, 0x28272625,
	0x35342a29, 0x39383736, 0x4544433a, 0x49484746,
	0x5554534a, 0x59585756, 0x6564635a, 0x69686766,
	0x7574736a, 0x79787776, 0x8584837a, 0x89888786,
	0x9493928a, 0x98979695, 0xa3a29a99, 0xa7a6a5a4,
	0xb2aaa9a8, 0xb6b5b4b3, 0xbab9b8b7, 0xc5c4c3c2,
	0xc9c8c7c6, 0xd4d3d2ca, 0xd8d7d6d5, 0xe2e1dad9,
	0xe6e5e4e3, 0xeae9e8e7, 0xf4f3f2f1, 0xf8f7f6f5,
	0x0000faf9
};

/* ITU Chrominace Huffman Table */
static u32 ITU_H_tbl_len_AC_chrominance[4] = {
	0x02010200, 0x04030404, 0x04040507, 0x77020100
};
static u32 ITU_H_tbl_val_AC_chrominance[41] = {
	0x03020100, 0x21050411, 0x41120631, 0x71610751,
	0x81322213, 0x91421408, 0x09c1b1a1, 0xf0523323,
	0xd1726215, 0x3424160a, 0x17f125e1, 0x261a1918,
	0x2a292827, 0x38373635, 0x44433a39, 0x48474645,
	0x54534a49, 0x58575655, 0x64635a59, 0x68676665,
	0x74736a69, 0x78777675, 0x83827a79, 0x87868584,
	0x928a8988, 0x96959493, 0x9a999897, 0xa5a4a3a2,
	0xa9a8a7a6, 0xb4b3b2aa, 0xb8b7b6b5, 0xc3c2bab9,
	0xc7c6c5c4, 0xd2cac9c8, 0xd6d5d4d3, 0xdad9d8d7,
	0xe5e4e3e2, 0xe9e8e7e6, 0xf4f3f2ea, 0xf8f7f6f5,
	0x0000faf9
};
#endif /* __JPEG_CONF_H__ */
