/*
 * Samsung Exynos5 SoC series Sensor driver
 *
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/version.h>
#include <linux/gpio.h>
#include <linux/clk.h>
#include <linux/regulator/consumer.h>
#include <linux/videodev2.h>
#include <linux/videodev2_exynos_camera.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/vmalloc.h>
#include <linux/platform_device.h>
#include <mach/regs-gpio.h>
#include <mach/regs-clock.h>
#include <plat/clock.h>
#include <plat/gpio-cfg.h>
#include <media/v4l2-ctrls.h>
#include <media/v4l2-device.h>
#include <media/v4l2-subdev.h>
#include <mach/exynos-fimc-is-sensor.h>

#include "../fimc-is-core.h"
#include "../fimc-is-device-sensor.h"
#include "../fimc-is-resourcemgr.h"
#include "../fimc-is-hw.h"
#include "fimc-is-device-sr352.h"

#define SENSOR_NAME "SR352"

struct sensor_reg {
	u8 addr;
	u8 data;
};

struct sensor_regset {
	struct sensor_reg	*reg;
	u32			size;
};

struct sensor_regset_table {
	struct sensor_regset init;
	struct sensor_regset refresh_50h;
	struct sensor_regset stop_stream;
	struct sensor_regset resol_640_480;
	struct sensor_regset resol_1024_768;
	struct sensor_regset resol_1024_576;
};

#define SENSOR_REGISTER_REGSET(y)		\
	{					\
		.reg	= (y),			\
		.size	= ARRAY_SIZE((y)),	\
	}

 /* Sysctl registers */
#define SR352_COMMAND_REGISTER                0x0080
#define SR352_COMMAND_REGISTER_APPLY_PATCH    (1 << 0)
#define SR352_COMMAND_REGISTER_SET_STATE      (1 << 1)
#define SR352_COMMAND_REGISTER_REFRESH        (1 << 2)
#define SR352_COMMAND_REGISTER_WAIT_FOR_EVENT (1 << 3)
#define SR352_COMMAND_REGISTER_OK             (1 << 15)

static struct sensor_reg sr352_Init_Reg_01[] = {

///////////////////////////////////////////////////////////////////////////////
// Sensor Initial Start
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// mcu clock enable for bus release
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x26,},
{0x10, 0x89,},
{0x10, 0x80,},

///////////////////////////////////////////////////////////////////////////////
// reset
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x00,},
{0x01, 0x01,},
{0x01, 0x07,},
{0x01, 0x01,},

{0x05, 0x01,}, // ver1.10
{0x0d, 0xaa,}, // ESD Check Register
{0x0f, 0xaa,}, // ESD Check Register

///////////////////////////////////////////////////////////////////////////////
// pad drive / pll setting
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
//OUTPUT: MIPI interface /////////////////////////////////////////
{0x02, 0x07,},		// pclk_drive = 000b, i2c_drive = 111b
{0x0c, 0x07,},		// d_pad_drive = 000b, gpio_pad_drive = 111b
//////////////////////////////////////////////////////////////////
{0x07, 0x25,}, //mode_pll1  24mhz / (5+1) = 4mhz
{0x08, 0x6c,}, //mode_pll2  isp clk = 108Mhz;
{0x09, 0x85,}, //mode_pll3  // MIPI 4x div 1/2 // isp clk div = 1/4 //Preview
{0x07, 0xA5,},
{0x07, 0xA5,},
{0x07, 0xA5,},
//OUTPUT: MIPI interface /////////////////////////////////////////
{0x0A, 0x60,}, // mode_pll4 for mipi mode
{0x0A, 0xe0,}, // mode_pll4 for mipi mode

{0x03, 0x26,},
{0x1B, 0x03,},		// bus clk div = 1/4

///////////////////////////////////////////////////////////////////////////////
// 7 Page(memory configuration)
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x07,},
{0x21, 0x01,},	// SSD sram clock inv on
{0x33, 0x45,},	// bit[6]:C-NR DC ?? ??

///////////////////////////////////////////////////////////////////////////////
// mcu reset
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x26,},
{0x10, 0x80,},		// mcu reset
{0x10, 0x89,},		// mcu clk enable
{0x11, 0x08,},		// xdata clear
{0x11, 0x00,},		// xdata clear
{0xff, 0x01,},   // delay 10ms

///////////////////////////////////////////////////////////////////////////////
// opt download
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x0A,},
{0x12, 0x00,},	// otp clock enable

// timing for 108mhz
{0x40, 0x3B,},	// otp cfg 1
{0x41, 0x55,},	// otp cfg 2
{0x42, 0x3B,},	// otp cfg 3
{0x43, 0x3B,},	// otp cfg 4
{0x44, 0x3B,},	// otp cfg 5
{0x45, 0x2B,},	// otp cfg 6
{0x46, 0x71,},	// otp cfg 7
{0x47, 0x0B,},	// otp cfg 8
{0x48, 0x03,},	// otp cfg 9
{0x49, 0x6A,},	// otp cfg 10
{0x4A, 0x3B,},	// otp cfg 11
{0x4B, 0x85,},	// otp cfg 12
{0x4C, 0x55,},	// otp cfg 13

{0xff, 0x01,},	//delay 10ms

// downlaod otp - system data
{0x20, 0x00,},	// otp addr = Otp:0000h
{0x21, 0x00,},	// otp addr = Otp:0000h
{0x20, 0x00,},	// otp addr = Otp:0000h (otp addr must be set twice)
{0x21, 0x00,},	// otp addr = Otp:0000h (otp addr must be set twice)
{0x2e, 0x00,},	// otp download size = 0080
{0x2f, 0x80,},	// otp download size = 0080
{0x13, 0x01,},	// start download system data
{0x13, 0x00,},	// toggle start

{0xff, 0x01,},   // delay 10ms

// download otp - mcu data
{0x20, 0x00,},	// otp addr = Otp:0080h
{0x21, 0x80,},	// otp addr = Otp:0080h
{0x20, 0x00,},	// otp addr = Otp:0080h (otp addr must be set twice)
{0x21, 0x80,},	// otp addr = Otp:0080h (otp addr must be set twice)
{0x2e, 0x01,},	// otp download size = 0100
{0x2f, 0x00,},	// otp download size = 0100
{0x18, 0x01,},	// link xdata to otp
{0x30, 0x10,},	// otp mcu buffer addr = Xdata:105Dh
{0x31, 0x5D,},	// otp mcu buffer addr = Xdata:105Dh
{0x13, 0x02,},	// start download mcu data
{0x13, 0x00,},	// toggle start

{0xff, 0x01,},	//delay 10ms

{0x18, 0x00,},	// link xdata to mcu

// download otp - dpc data
{0x20, 0x01,},	// otp addr = Otp:0180h
{0x21, 0x80,},	// otp addr = Otp:0180h
{0x20, 0x01,},	// otp addr = Otp:0180h (otp addr must be set twice)
{0x21, 0x80,},	// otp addr = Otp:0180h (otp addr must be set twice)
{0x2e, 0x00,},	// otp download size = 0080
{0x2f, 0x80,},	// otp download size = 0080
{0x18, 0x01,},	// link xdata to otp
{0x30, 0x33,},	// otp mcu buffer addr = Xdata:3384h
{0x31, 0x84,},	// otp mcu buffer addr = Xdata:3384h
{0x13, 0x04,},	// start download dpc data
{0x13, 0x00,},	// toggle start

{0xff, 0x01,},	//delay 10ms

{0x18, 0x00,},	// link xdata to mcu

{0x03, 0x0A,},
{0x12, 0x80,},	// otp clock disable

///////////////////////////////////////////////////////////////////////////////
// TAP for capture function
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x26,},

{0x16, 0x00,},		// set tap address (high)
{0x17, 0x00,},		// set tap address (low)
{0x18, 0x01,},		// use tap memory

{0x40, 0x02,},		// set auto increment mode
{0x44, 0x00,},		// select rom
{0x45, 0x00,},		// set high address
{0x46, 0x00,},		// set low address

// tap code download - start
// (caution : data length must be even)
{0x42, 0x90,},
{0x42, 0x81,},
{0x42, 0xf0,},
{0x42, 0xe0,},
{0x42, 0x54,},
{0x42, 0x07,},
{0x42, 0xd3,},
{0x42, 0x94,},
{0x42, 0x02,},
{0x42, 0x40,},
{0x42, 0x1e,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0xaf,},
{0x42, 0xe0,},
{0x42, 0xb4,},
{0x42, 0x01,},
{0x42, 0x07,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x89,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe1,},
{0x42, 0x10,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0xaf,},
{0x42, 0xe0,},
{0x42, 0xd3,},
{0x42, 0x94,},
{0x42, 0x02,},
{0x42, 0x50,},
{0x42, 0x13,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x89,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe1,},
{0x42, 0x0c,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8c,},
{0x42, 0xe4,},
{0x42, 0xf0,},
{0x42, 0xa3,},
{0x42, 0xf0,},
{0x42, 0xa3,},
{0x42, 0xf0,},
{0x42, 0xa3,},
{0x42, 0xf0,},
{0x42, 0x22,},
{0x42, 0x90,},
{0x42, 0x1f,},
{0x42, 0x21,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe1,},
{0x42, 0x55,},
{0x42, 0x90,},
{0x42, 0x90,},

{0x42, 0xb4,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe5,},
{0x42, 0x4e,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe1,},
{0x42, 0x4a,},
{0x42, 0x90,},
{0x42, 0x1f,},
{0x42, 0x2d,},
{0x42, 0x74,},
{0x42, 0x08,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x89,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe4,},
{0x42, 0x1d,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x88,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8c,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x89,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8d,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x8a,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8e,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x8b,},
{0x42, 0x80,},
{0x42, 0x1b,},
{0x42, 0x90,},

{0x42, 0x00,},
{0x42, 0x8c,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8c,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x8d,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8d,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x8e,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8e,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x00,},
{0x42, 0x8f,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8f,},
{0x42, 0xf0,},
{0x42, 0x22,},
{0x42, 0x90,},
{0x42, 0x1f,},
{0x42, 0x2d,},
{0x42, 0x74,},
{0x42, 0x04,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x89,},
{0x42, 0xe0,},
{0x42, 0x30,},
{0x42, 0xe4,},
{0x42, 0x1d,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x66,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8c,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x67,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8d,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x68,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8e,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x69,},
{0x42, 0x80,},
{0x42, 0x1b,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x6a,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8c,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x6b,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8d,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x6c,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8e,},
{0x42, 0xf0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x6d,},
{0x42, 0xe0,},
{0x42, 0x90,},
{0x42, 0x06,},
{0x42, 0x8f,},
{0x42, 0xf0,},
{0x42, 0x22,},
{0x42, 0x0a,},
// tap code download - end

{0x44, 0x01,},		// select ram

{0x16, 0xf8,},		// set tap address (high)
{0x17, 0x00,},		// set tap address (low)

///////////////////////////////////////////////////////////////////////////////
// 0 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x10, 0x41,}, //binning + prev1
{0x11, 0x80,}, //Fixed mode off
{0x12, 0x00,},
{0x13, 0x28,},
{0x15, 0x01,},
{0x17, 0x00,}, // Clock inversion off
{0x18, 0x00,},
{0x1d, 0x05,},	//Group_frame_update
{0x1E, 0x01,},	//Group_frame_update_reset
{0x20, 0x00,},
{0x21, 0x00,}, // preview row start set
{0x22, 0x00,},
{0x23, 0x00,}, // preview col start set
{0x24, 0x06,}, // height = 1536
{0x25, 0x00,},
{0x26, 0x08,}, // width = 2048
{0x27, 0x00,},

///////////////////////////////////////////////////////////////////////////////
//ONE LINE SETTING
{0x03, 0x00,},
{0x4c, 0x08,}, // 1Line = 2200  : 054(HBLANK) + 2146(Active Pixel)
{0x4d, 0x98,},

///////////////////////////////////////////////////////////////////////////////
{0x52, 0x00,},	//Vsync H
{0x53, 0x14,},	//Vsync L
///////////////////////////////////////////////////////////////////////////////

//Pixel windowing
{0x80, 0x00,}, // bayer y start
{0x81, 0x00,},
{0x82, 0x06,}, // bayer height
{0x83, 0x24,},
{0x84, 0x00,},	//pixel_col_start
{0x85, 0x00,},
{0x86, 0x08,},	//pixel_width
{0x87, 0x24,},

///////////////////////////////////////////////////////////////////////////////
// 1 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x01,},
{0x10, 0x62,},	// BLC=ON, column BLC, col_OBP DPC
{0x11, 0x11,},   // BLC offset ENB + Adaptive BLC ENB B[4]
{0x12, 0x00,},
{0x13, 0x39,},	// BLC(Frame BLC ofs - Column ALC ofs)+FrameALC skip
{0x14, 0x00,},
{0x23, 0x8F,},	// Frame BLC avg ?? for 8 frame
{0x50, 0x04,}, // blc height = 4
{0x51, 0x44,},
{0x60, 0x00,},
{0x61, 0x00,},
{0x62, 0x00,},
{0x63, 0x00,},
{0x78, 0x7f,},	// ramp_rst_offset = 128
{0x79, 0x04,},	// ramp offset
{0x7b, 0x04,},	// ramp offset
{0x7e, 0x00,},

///////////////////////////////////////////////////////////////////////////////
// 2 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x02,},
{0x1b, 0x80,},
{0x1d, 0x40,},
{0x23, 0x10,},
{0x40, 0x08,},
{0x41, 0x8a,},	// 20130213 Rev BC ver. ADC input range @ 800mv
{0x46, 0x0a,},	// + 3.3V, -0.9V
{0x47, 0x17,}, // 20121129 2.9V
{0x48, 0x1a,},
{0x49, 0x13,},
{0x54, 0xc0,},
{0x55, 0x40,},
{0x56, 0x33,},
{0xa0, 0x02,},
{0xa1, 0xa8,},
{0xa2, 0x04,},
{0xa3, 0x79,},
{0xa4, 0x04,},
{0xa5, 0xdc,},
{0xa6, 0x08,},
{0xa7, 0x66,},
{0xa8, 0x02,},
{0xa9, 0x7b,},
{0xaa, 0x03,},
{0xab, 0x4f,},
{0xac, 0x03,},
{0xad, 0xa0,},
{0xae, 0x05,},
{0xaf, 0x43,},

///////////////////////////////////////////////////////////////////////////////
// 3 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x03,},
{0x1a, 0x06,}, // cds_s1
{0x1b, 0x7c,},
{0x1c, 0x02,},
{0x1d, 0x88,},
{0x1e, 0x06,},
{0x1f, 0x7c,},
{0x42, 0x00,},
{0x43, 0xb0,},
{0x46, 0x01,},
{0x47, 0x00,},
{0x4a, 0x00,},
{0x4b, 0xae,},
{0x4e, 0x00,},
{0x4f, 0xae,},
{0x52, 0x00,},
{0x53, 0xaa,},
{0x56, 0x00,},
{0x57, 0xaa,},
{0x5A, 0x00,},
{0x5b, 0xaa,},
{0x6A, 0x00,},
{0x6B, 0xf8,},
{0x72, 0x06,}, // s_addr_cut
{0x73, 0x90,},
{0x78, 0x06,}, // rx half_rst
{0x79, 0x8b,},
{0x7A, 0x06,},
{0x7B, 0x95,},
{0x7C, 0x06,},
{0x7D, 0x8b,},
{0x7E, 0x06,},
{0x7F, 0x95,},
{0x84, 0x06,}, // tx half_rst
{0x85, 0x8b,},
{0x86, 0x06,},
{0x87, 0x95,},
{0x88, 0x06,},
{0x89, 0x8b,},
{0x8A, 0x06,},
{0x8B, 0x95,},
{0x92, 0x06,}, // sx
{0x93, 0x81,},
{0x96, 0x06,},
{0x97, 0x81,},
{0x98, 0x06,}, // sxb
{0x99, 0x81,},
{0x9c, 0x06,},
{0x9d, 0x81,},

{0xb6, 0x01,}, // --------------> s_hb_cnt_hold = 500
{0xb7, 0xf4,},
{0xc0, 0x00,}, // i_addr_mux_prev
{0xc1, 0xb4,},
{0xc2, 0x00,},
{0xc3, 0xf4,},
{0xc4, 0x00,},
{0xc5, 0xb4,},
{0xc6, 0x00,},
{0xc7, 0xf4,},
{0xc8, 0x00,}, // i_addr_cut_prev
{0xc9, 0xb8,},
{0xca, 0x00,},
{0xcb, 0xf0,},
{0xcc, 0x00,},
{0xcd, 0xb8,},
{0xce, 0x00,},
{0xcf, 0xf0,},
{0xd0, 0x00,}, // Rx_exp_prev
{0xd1, 0xba,},
{0xd2, 0x00,},
{0xd3, 0xee,},
{0xd4, 0x00,},
{0xd5, 0xba,},
{0xd6, 0x00,},
{0xd7, 0xee,},
{0xd8, 0x00,}, // Tx_exp_prev
{0xd9, 0xbc,},
{0xdA, 0x00,},
{0xdB, 0xec,},
{0xdC, 0x00,},
{0xdD, 0xbc,},
{0xdE, 0x00,},
{0xdF, 0xec,},

{0xe0, 0x00,},
{0xe1, 0x20,},
{0xfc, 0x06,}, // clamp_sig
{0xfd, 0x78,},

///////////////////////////////////////////////////////////////////////////////
// 4 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x04,},
{0x10, 0x03,},	//Ramp multiple sampling

{0x5a, 0x06,}, // cds_pxl_smpl
{0x5b, 0x78,},
{0x5e, 0x06,},
{0x5f, 0x78,},
{0x62, 0x06,},
{0x63, 0x78,},

///////////////////////////////////////////////////////////////////////////////
// mcu start
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x26,},
{0x62, 0x00,},	// normal mode start
{0x65, 0x00,},	// watchdog disable
{0x10, 0x09,},	// mcu reset release
//Analog setting ??? MCU? reset ??.

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x10, 0x01,}, // otp_dpc_ctl
{0x11, 0x11,}, //Preview1 0410
{0x12, 0x02,}, //Preview1 0410

///////////////////////////////////////////////////////////////////////////////
// 15 Page (LSC)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x15,},
{0x10, 0x00,},	// LSC OFF
{0x11, 0x00,}, //gap y disable

///////////////////////////////////////////////////////////////////////////////
// set lsc parameter
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x0a,},
{0x19, 0x01,},

{0x11, 0x80,}, // B[7] LSC burst mode ENB

{0x03, 0x26,},
{0x40, 0x02,},	// auto increment enable
{0x44, 0x01,},
{0x45, 0xa3,},	// LSC bank0 start addr H
{0x46, 0x00,},	// LSC bank0 start addr L

//LSC G channel reg________________________ 20130625 LSC Blending DNP 90_CWF 5_TL84 5

{0x0e, 0x01,}, //BURST_START

//G Value
{0x42, 0x38,},
{0x42, 0xe3,},
{0x42, 0x6c,},
{0x42, 0x39,},
{0x42, 0xa3,},
{0x42, 0x70,},
{0x42, 0x33,},
{0x42, 0x92,},
{0x42, 0xfd,},
{0x42, 0x2c,},
{0x42, 0x52,},
{0x42, 0x98,},
{0x42, 0x27,},
{0x42, 0xe2,},
{0x42, 0x7e,},
{0x42, 0x29,},
{0x42, 0x82,},
{0x42, 0xc5,},
{0x42, 0x2f,},
{0x42, 0xd3,},
{0x42, 0x39,},
{0x42, 0x37,},
{0x42, 0x03,},
{0x42, 0x9a,},
{0x42, 0x36,},
{0x42, 0xc3,},
{0x42, 0x8e,},
{0x42, 0x35,},
{0x42, 0xb3,},
{0x42, 0x62,},
{0x42, 0x36,},
{0x42, 0x83,},
{0x42, 0x31,},
{0x42, 0x2e,},
{0x42, 0xd2,},
{0x42, 0xa4,},
{0x42, 0x26,},
{0x42, 0x12,},
{0x42, 0x2e,},
{0x42, 0x21,},
{0x42, 0x12,},
{0x42, 0x11,},
{0x42, 0x22,},
{0x42, 0xe2,},
{0x42, 0x61,},
{0x42, 0x2a,},
{0x42, 0x42,},
{0x42, 0xed,},
{0x42, 0x33,},
{0x42, 0x13,},
{0x42, 0x68,},
{0x42, 0x36,},
{0x42, 0x23,},
{0x42, 0x5b,},
{0x42, 0x37,},
{0x42, 0x83,},
{0x42, 0x57,},
{0x42, 0x33,},
{0x42, 0x52,},
{0x42, 0xf2,},
{0x42, 0x2a,},
{0x42, 0x12,},
{0x42, 0x4b,},
{0x42, 0x1f,},
{0x42, 0xe1,},
{0x42, 0xc4,},
{0x42, 0x1a,},
{0x42, 0x51,},
{0x42, 0xa5,},
{0x42, 0x1c,},
{0x42, 0x41,},
{0x42, 0xfe,},
{0x42, 0x24,},
{0x42, 0xb2,},
{0x42, 0xa1,},
{0x42, 0x2f,},
{0x42, 0x23,},
{0x42, 0x35,},
{0x42, 0x35,},
{0x42, 0x73,},
{0x42, 0x78,},
{0x42, 0x37,},
{0x42, 0xa3,},
{0x42, 0x44,},
{0x42, 0x30,},
{0x42, 0xe2,},
{0x42, 0xbd,},
{0x42, 0x25,},
{0x42, 0x91,},
{0x42, 0xf3,},
{0x42, 0x19,},
{0x42, 0x91,},
{0x42, 0x58,},
{0x42, 0x13,},
{0x42, 0x61,},
{0x42, 0x36,},
{0x42, 0x15,},
{0x42, 0x81,},
{0x42, 0x99,},
{0x42, 0x1f,},
{0x42, 0x32,},
{0x42, 0x59,},
{0x42, 0x2b,},
{0x42, 0xd3,},
{0x42, 0x0e,},
{0x42, 0x34,},
{0x42, 0x43,},
{0x42, 0x7a,},
{0x42, 0x36,},
{0x42, 0x13,},
{0x42, 0x21,},
{0x42, 0x2e,},
{0x42, 0x02,},
{0x42, 0x7f,},
{0x42, 0x20,},
{0x42, 0xa1,},
{0x42, 0x97,},
{0x42, 0x13,},
{0x42, 0x70,},
{0x42, 0xf2,},
{0x42, 0x0c,},
{0x42, 0xf0,},
{0x42, 0xcf,},
{0x42, 0x0f,},
{0x42, 0x21,},
{0x42, 0x37,},
{0x42, 0x19,},
{0x42, 0x72,},
{0x42, 0x0a,},
{0x42, 0x27,},
{0x42, 0xf2,},
{0x42, 0xe0,},
{0x42, 0x32,},
{0x42, 0x13,},
{0x42, 0x61,},
{0x42, 0x34,},
{0x42, 0x93,},
{0x42, 0x00,},
{0x42, 0x2b,},
{0x42, 0x62,},
{0x42, 0x47,},
{0x42, 0x1c,},
{0x42, 0x51,},
{0x42, 0x4a,},
{0x42, 0x0e,},
{0x42, 0x50,},
{0x42, 0x9f,},
{0x42, 0x07,},
{0x42, 0xb0,},
{0x42, 0x7b,},
{0x42, 0x09,},
{0x42, 0xf0,},
{0x42, 0xe5,},
{0x42, 0x14,},
{0x42, 0xa1,},
{0x42, 0xc5,},
{0x42, 0x24,},
{0x42, 0x72,},
{0x42, 0xb6,},
{0x42, 0x30,},
{0x42, 0x03,},
{0x42, 0x49,},
{0x42, 0x33,},
{0x42, 0x62,},
{0x42, 0xe4,},
{0x42, 0x29,},
{0x42, 0x32,},
{0x42, 0x18,},
{0x42, 0x18,},
{0x42, 0xd1,},
{0x42, 0x0d,},
{0x42, 0x0a,},
{0x42, 0x60,},
{0x42, 0x60,},
{0x42, 0x03,},
{0x42, 0xd0,},
{0x42, 0x3d,},
{0x42, 0x06,},
{0x42, 0x00,},
{0x42, 0xa6,},
{0x42, 0x10,},
{0x42, 0xd1,},
{0x42, 0x8d,},
{0x42, 0x21,},
{0x42, 0x82,},
{0x42, 0x93,},
{0x42, 0x2e,},
{0x42, 0x43,},
{0x42, 0x36,},
{0x42, 0x32,},
{0x42, 0x92,},
{0x42, 0xd2,},
{0x42, 0x27,},
{0x42, 0xb1,},
{0x42, 0xf6,},
{0x42, 0x16,},
{0x42, 0x60,},
{0x42, 0xe4,},
{0x42, 0x07,},
{0x42, 0xd0,},
{0x42, 0x37,},
{0x42, 0x01,},
{0x42, 0x30,},
{0x42, 0x13,},
{0x42, 0x03,},
{0x42, 0x70,},
{0x42, 0x7d,},
{0x42, 0x0e,},
{0x42, 0x41,},
{0x42, 0x66,},
{0x42, 0x1f,},
{0x42, 0x62,},
{0x42, 0x7b,},
{0x42, 0x2d,},
{0x42, 0x23,},
{0x42, 0x29,},
{0x42, 0x32,},
{0x42, 0x22,},
{0x42, 0xc7,},
{0x42, 0x26,},
{0x42, 0xd1,},
{0x42, 0xe5,},
{0x42, 0x15,},
{0x42, 0x30,},
{0x42, 0xcf,},
{0x42, 0x06,},
{0x42, 0x80,},
{0x42, 0x22,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0x20,},
{0x42, 0x68,},
{0x42, 0x0c,},
{0x42, 0xf1,},
{0x42, 0x53,},
{0x42, 0x1e,},
{0x42, 0x52,},
{0x42, 0x6d,},
{0x42, 0x2c,},
{0x42, 0x73,},
{0x42, 0x22,},

{0x0e, 0x00,}, //BURST_END
{0x0e, 0x01,}, //BURST_START

{0x42, 0x32,},
{0x42, 0x22,},
{0x42, 0xc7,},
{0x42, 0x26,},
{0x42, 0xd1,},
{0x42, 0xe5,},
{0x42, 0x15,},
{0x42, 0x30,},
{0x42, 0xcf,},
{0x42, 0x06,},
{0x42, 0x80,},
{0x42, 0x22,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0x20,},
{0x42, 0x68,},
{0x42, 0x0c,},
{0x42, 0xf1,},
{0x42, 0x53,},
{0x42, 0x1e,},
{0x42, 0x52,},
{0x42, 0x6d,},
{0x42, 0x2c,},
{0x42, 0x73,},
{0x42, 0x22,},
{0x42, 0x32,},
{0x42, 0x92,},
{0x42, 0xd2,},
{0x42, 0x27,},
{0x42, 0xb1,},
{0x42, 0xf6,},
{0x42, 0x16,},
{0x42, 0x60,},
{0x42, 0xe4,},
{0x42, 0x07,},
{0x42, 0xd0,},
{0x42, 0x37,},
{0x42, 0x01,},
{0x42, 0x30,},
{0x42, 0x13,},
{0x42, 0x03,},
{0x42, 0x70,},
{0x42, 0x7d,},
{0x42, 0x0e,},
{0x42, 0x41,},
{0x42, 0x66,},
{0x42, 0x1f,},
{0x42, 0x62,},
{0x42, 0x7b,},
{0x42, 0x2d,},
{0x42, 0x23,},
{0x42, 0x29,},
{0x42, 0x33,},
{0x42, 0x62,},
{0x42, 0xe4,},
{0x42, 0x29,},
{0x42, 0x32,},
{0x42, 0x18,},
{0x42, 0x18,},
{0x42, 0xd1,},
{0x42, 0x0d,},
{0x42, 0x0a,},
{0x42, 0x60,},
{0x42, 0x60,},
{0x42, 0x03,},
{0x42, 0xd0,},
{0x42, 0x3d,},
{0x42, 0x06,},
{0x42, 0x00,},
{0x42, 0xa6,},
{0x42, 0x10,},
{0x42, 0xd1,},
{0x42, 0x8d,},
{0x42, 0x21,},
{0x42, 0x82,},
{0x42, 0x93,},
{0x42, 0x2e,},
{0x42, 0x43,},
{0x42, 0x36,},
{0x42, 0x34,},
{0x42, 0x93,},
{0x42, 0x00,},
{0x42, 0x2b,},
{0x42, 0x62,},
{0x42, 0x47,},
{0x42, 0x1c,},
{0x42, 0x51,},
{0x42, 0x4a,},
{0x42, 0x0e,},
{0x42, 0x50,},
{0x42, 0x9f,},
{0x42, 0x07,},
{0x42, 0xb0,},
{0x42, 0x7b,},
{0x42, 0x09,},
{0x42, 0xf0,},
{0x42, 0xe5,},
{0x42, 0x14,},
{0x42, 0xa1,},
{0x42, 0xc5,},
{0x42, 0x24,},
{0x42, 0x72,},
{0x42, 0xb6,},
{0x42, 0x30,},
{0x42, 0x03,},
{0x42, 0x49,},
{0x42, 0x36,},
{0x42, 0x13,},
{0x42, 0x21,},
{0x42, 0x2e,},
{0x42, 0x02,},
{0x42, 0x7f,},
{0x42, 0x20,},
{0x42, 0xa1,},
{0x42, 0x97,},
{0x42, 0x13,},
{0x42, 0x70,},
{0x42, 0xf2,},
{0x42, 0x0c,},
{0x42, 0xf0,},
{0x42, 0xcf,},
{0x42, 0x0f,},
{0x42, 0x21,},
{0x42, 0x37,},
{0x42, 0x19,},
{0x42, 0x72,},
{0x42, 0x0a,},
{0x42, 0x27,},
{0x42, 0xf2,},
{0x42, 0xe0,},
{0x42, 0x32,},
{0x42, 0x13,},
{0x42, 0x61,},
{0x42, 0x37,},
{0x42, 0xa3,},
{0x42, 0x44,},
{0x42, 0x30,},
{0x42, 0xe2,},
{0x42, 0xbd,},
{0x42, 0x25,},
{0x42, 0x91,},
{0x42, 0xf3,},
{0x42, 0x19,},
{0x42, 0x91,},
{0x42, 0x58,},
{0x42, 0x13,},
{0x42, 0x61,},
{0x42, 0x36,},
{0x42, 0x15,},
{0x42, 0x81,},
{0x42, 0x99,},
{0x42, 0x1f,},
{0x42, 0x32,},
{0x42, 0x59,},
{0x42, 0x2b,},
{0x42, 0xd3,},
{0x42, 0x0e,},
{0x42, 0x34,},
{0x42, 0x43,},
{0x42, 0x7a,},
{0x42, 0x37,},
{0x42, 0x83,},
{0x42, 0x57,},
{0x42, 0x33,},
{0x42, 0x52,},
{0x42, 0xf2,},
{0x42, 0x2a,},
{0x42, 0x12,},
{0x42, 0x4b,},
{0x42, 0x1f,},
{0x42, 0xe1,},
{0x42, 0xc4,},
{0x42, 0x1a,},
{0x42, 0x51,},
{0x42, 0xa5,},
{0x42, 0x1c,},
{0x42, 0x41,},
{0x42, 0xfe,},
{0x42, 0x24,},
{0x42, 0xb2,},
{0x42, 0xa1,},
{0x42, 0x2f,},
{0x42, 0x23,},
{0x42, 0x35,},
{0x42, 0x35,},
{0x42, 0x73,},
{0x42, 0x78,},
{0x42, 0x35,},
{0x42, 0xb3,},
{0x42, 0x62,},
{0x42, 0x36,},
{0x42, 0x83,},
{0x42, 0x31,},
{0x42, 0x2e,},
{0x42, 0xd2,},
{0x42, 0xa4,},
{0x42, 0x26,},
{0x42, 0x12,},
{0x42, 0x2e,},
{0x42, 0x21,},
{0x42, 0x12,},
{0x42, 0x11,},
{0x42, 0x22,},
{0x42, 0xe2,},
{0x42, 0x61,},
{0x42, 0x2a,},
{0x42, 0x42,},
{0x42, 0xed,},
{0x42, 0x33,},
{0x42, 0x13,},
{0x42, 0x68,},
{0x42, 0x36,},
{0x42, 0x23,},
{0x42, 0x5b,},
{0x42, 0x38,},
{0x42, 0xe3,},
{0x42, 0x6c,},
{0x42, 0x39,},
{0x42, 0xa3,},
{0x42, 0x70,},
{0x42, 0x33,},
{0x42, 0x92,},
{0x42, 0xfd,},
{0x42, 0x2c,},
{0x42, 0x52,},
{0x42, 0x98,},
{0x42, 0x27,},
{0x42, 0xe2,},
{0x42, 0x7e,},
{0x42, 0x29,},
{0x42, 0x82,},
{0x42, 0xc5,},
{0x42, 0x2f,},
{0x42, 0xd3,},
{0x42, 0x39,},
{0x42, 0x37,},
{0x42, 0x03,},
{0x42, 0x9a,},
{0x42, 0x36,},
{0x42, 0xc3,},
{0x42, 0x8e,},

{0x0e, 0x00,}, //BURST_END
{0x0e, 0x01,}, //BURST_START

//R Value
{0x42, 0x54,},
{0x42, 0x85,},
{0x42, 0x21,},
{0x42, 0x56,},
{0x42, 0x75,},
{0x42, 0x2f,},
{0x42, 0x4d,},
{0x42, 0xc4,},
{0x42, 0x81,},
{0x42, 0x42,},
{0x42, 0xb3,},
{0x42, 0xe5,},
{0x42, 0x3b,},
{0x42, 0xe3,},
{0x42, 0xbe,},
{0x42, 0x3e,},
{0x42, 0x54,},
{0x42, 0x2b,},
{0x42, 0x48,},
{0x42, 0x14,},
{0x42, 0xdc,},
{0x42, 0x52,},
{0x42, 0xf5,},
{0x42, 0x67,},
{0x42, 0x52,},
{0x42, 0x15,},
{0x42, 0x48,},
{0x42, 0x50,},
{0x42, 0xa5,},
{0x42, 0x02,},
{0x42, 0x50,},
{0x42, 0xd4,},
{0x42, 0xbe,},
{0x42, 0x45,},
{0x42, 0x53,},
{0x42, 0xe6,},
{0x42, 0x37,},
{0x42, 0xf3,},
{0x42, 0x31,},
{0x42, 0x30,},
{0x42, 0x83,},
{0x42, 0x08,},
{0x42, 0x33,},
{0x42, 0x13,},
{0x42, 0x7f,},
{0x42, 0x3e,},
{0x42, 0x64,},
{0x42, 0x55,},
{0x42, 0x4b,},
{0x42, 0xe5,},
{0x42, 0x0d,},
{0x42, 0x50,},
{0x42, 0x25,},
{0x42, 0x0a,},
{0x42, 0x53,},
{0x42, 0xa4,},
{0x42, 0xf5,},
{0x42, 0x4c,},
{0x42, 0x24,},
{0x42, 0x5c,},
{0x42, 0x3d,},
{0x42, 0xc3,},
{0x42, 0x59,},
{0x42, 0x2e,},
{0x42, 0x32,},
{0x42, 0x8d,},
{0x42, 0x26,},
{0x42, 0x02,},
{0x42, 0x60,},
{0x42, 0x28,},
{0x42, 0xd2,},
{0x42, 0xe3,},
{0x42, 0x35,},
{0x42, 0x93,},
{0x42, 0xdc,},
{0x42, 0x45,},
{0x42, 0xc4,},
{0x42, 0xc2,},
{0x42, 0x4f,},
{0x42, 0x55,},
{0x42, 0x3a,},
{0x42, 0x53,},
{0x42, 0xd4,},
{0x42, 0xd7,},
{0x42, 0x48,},
{0x42, 0x54,},
{0x42, 0x02,},
{0x42, 0x36,},
{0x42, 0x52,},
{0x42, 0xc8,},
{0x42, 0x24,},
{0x42, 0x31,},
{0x42, 0xe6,},
{0x42, 0x1b,},
{0x42, 0x61,},
{0x42, 0xb6,},
{0x42, 0x1e,},
{0x42, 0x62,},
{0x42, 0x43,},
{0x42, 0x2c,},
{0x42, 0x83,},
{0x42, 0x65,},
{0x42, 0x40,},
{0x42, 0x24,},
{0x42, 0x85,},
{0x42, 0x4d,},
{0x42, 0x75,},
{0x42, 0x3d,},
{0x42, 0x51,},
{0x42, 0xd4,},
{0x42, 0xa4,},
{0x42, 0x43,},
{0x42, 0xf3,},
{0x42, 0xa4,},
{0x42, 0x2e,},
{0x42, 0xd2,},
{0x42, 0x3f,},
{0x42, 0x1b,},
{0x42, 0x21,},
{0x42, 0x52,},
{0x42, 0x12,},
{0x42, 0x01,},
{0x42, 0x20,},
{0x42, 0x15,},
{0x42, 0x21,},
{0x42, 0xb2,},
{0x42, 0x23,},
{0x42, 0xf2,},
{0x42, 0xed,},
{0x42, 0x3a,},
{0x42, 0x44,},
{0x42, 0x3f,},
{0x42, 0x4a,},
{0x42, 0x45,},
{0x42, 0x1d,},
{0x42, 0x4f,},
{0x42, 0xd4,},
{0x42, 0x74,},
{0x42, 0x3f,},
{0x42, 0xf3,},
{0x42, 0x4c,},
{0x42, 0x28,},
{0x42, 0x41,},
{0x42, 0xcd,},
{0x42, 0x13,},
{0x42, 0xd0,},
{0x42, 0xdc,},
{0x42, 0x0a,},
{0x42, 0xb0,},
{0x42, 0xab,},
{0x42, 0x0d,},
{0x42, 0xc1,},
{0x42, 0x3d,},
{0x42, 0x1c,},
{0x42, 0xd2,},
{0x42, 0x84,},
{0x42, 0x34,},
{0x42, 0xc3,},
{0x42, 0xff,},
{0x42, 0x47,},
{0x42, 0x44,},
{0x42, 0xfd,},
{0x42, 0x4e,},
{0x42, 0x24,},
{0x42, 0x4c,},
{0x42, 0x3c,},
{0x42, 0xa3,},
{0x42, 0x04,},
{0x42, 0x23,},
{0x42, 0x11,},
{0x42, 0x76,},
{0x42, 0x0e,},
{0x42, 0x50,},
{0x42, 0x84,},
{0x42, 0x05,},
{0x42, 0x40,},
{0x42, 0x54,},
{0x42, 0x08,},
{0x42, 0x40,},
{0x42, 0xe5,},
{0x42, 0x17,},
{0x42, 0x62,},
{0x42, 0x31,},
{0x42, 0x30,},
{0x42, 0x43,},
{0x42, 0xca,},
{0x42, 0x44,},
{0x42, 0xc4,},
{0x42, 0xe2,},
{0x42, 0x4d,},
{0x42, 0x24,},
{0x42, 0x31,},
{0x42, 0x3a,},
{0x42, 0x42,},
{0x42, 0xd3,},
{0x42, 0x1f,},
{0x42, 0xa1,},
{0x42, 0x3d,},
{0x42, 0x0a,},
{0x42, 0xb0,},
{0x42, 0x4b,},
{0x42, 0x01,},
{0x42, 0xb0,},
{0x42, 0x1b,},
{0x42, 0x04,},
{0x42, 0xb0,},
{0x42, 0xab,},
{0x42, 0x13,},
{0x42, 0xd1,},
{0x42, 0xfa,},
{0x42, 0x2d,},
{0x42, 0x33,},
{0x42, 0xa4,},
{0x42, 0x43,},
{0x42, 0x14,},
{0x42, 0xd2,},
{0x42, 0x4c,},
{0x42, 0x94,},
{0x42, 0x22,},
{0x42, 0x39,},
{0x42, 0x02,},
{0x42, 0xba,},
{0x42, 0x1d,},
{0x42, 0xe1,},
{0x42, 0x20,},
{0x42, 0x08,},
{0x42, 0xf0,},
{0x42, 0x2e,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0xe0,},
{0x42, 0x8f,},
{0x42, 0x12,},
{0x42, 0x01,},
{0x42, 0xde,},
{0x42, 0x2b,},
{0x42, 0xa3,},
{0x42, 0x90,},
{0x42, 0x42,},
{0x42, 0x24,},
{0x42, 0xc9,},

{0x0e, 0x00,}, //BURST_END
{0x0e, 0x01,}, //BURST_START

{0x42, 0x4c,},
{0x42, 0x94,},
{0x42, 0x22,},
{0x42, 0x39,},
{0x42, 0x02,},
{0x42, 0xba,},
{0x42, 0x1d,},
{0x42, 0xe1,},
{0x42, 0x20,},
{0x42, 0x08,},
{0x42, 0xf0,},
{0x42, 0x2e,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0xe0,},
{0x42, 0x8f,},
{0x42, 0x12,},
{0x42, 0x01,},
{0x42, 0xde,},
{0x42, 0x2b,},
{0x42, 0xa3,},
{0x42, 0x90,},
{0x42, 0x42,},
{0x42, 0x24,},
{0x42, 0xc9,},
{0x42, 0x4d,},
{0x42, 0x24,},
{0x42, 0x31,},
{0x42, 0x3a,},
{0x42, 0x42,},
{0x42, 0xd3,},
{0x42, 0x1f,},
{0x42, 0xa1,},
{0x42, 0x3d,},
{0x42, 0x0a,},
{0x42, 0xb0,},
{0x42, 0x4b,},
{0x42, 0x01,},
{0x42, 0xb0,},
{0x42, 0x1b,},
{0x42, 0x04,},
{0x42, 0xb0,},
{0x42, 0xab,},
{0x42, 0x13,},
{0x42, 0xd1,},
{0x42, 0xfa,},
{0x42, 0x2d,},
{0x42, 0x33,},
{0x42, 0xa4,},
{0x42, 0x43,},
{0x42, 0x14,},
{0x42, 0xd2,},
{0x42, 0x4e,},
{0x42, 0x24,},
{0x42, 0x4c,},
{0x42, 0x3c,},
{0x42, 0xa3,},
{0x42, 0x04,},
{0x42, 0x23,},
{0x42, 0x11,},
{0x42, 0x76,},
{0x42, 0x0e,},
{0x42, 0x50,},
{0x42, 0x84,},
{0x42, 0x05,},
{0x42, 0x40,},
{0x42, 0x54,},
{0x42, 0x08,},
{0x42, 0x40,},
{0x42, 0xe5,},
{0x42, 0x17,},
{0x42, 0x62,},
{0x42, 0x31,},
{0x42, 0x30,},
{0x42, 0x43,},
{0x42, 0xca,},
{0x42, 0x44,},
{0x42, 0xc4,},
{0x42, 0xe2,},
{0x42, 0x4f,},
{0x42, 0xd4,},
{0x42, 0x74,},
{0x42, 0x3f,},
{0x42, 0xf3,},
{0x42, 0x4c,},
{0x42, 0x28,},
{0x42, 0x41,},
{0x42, 0xcd,},
{0x42, 0x13,},
{0x42, 0xd0,},
{0x42, 0xdc,},
{0x42, 0x0a,},
{0x42, 0xb0,},
{0x42, 0xab,},
{0x42, 0x0d,},
{0x42, 0xc1,},
{0x42, 0x3d,},
{0x42, 0x1c,},
{0x42, 0xd2,},
{0x42, 0x84,},
{0x42, 0x34,},
{0x42, 0xc3,},
{0x42, 0xff,},
{0x42, 0x47,},
{0x42, 0x44,},
{0x42, 0xfd,},
{0x42, 0x51,},
{0x42, 0xd4,},
{0x42, 0xa4,},
{0x42, 0x43,},
{0x42, 0xf3,},
{0x42, 0xa4,},
{0x42, 0x2e,},
{0x42, 0xd2,},
{0x42, 0x3f,},
{0x42, 0x1b,},
{0x42, 0x21,},
{0x42, 0x52,},
{0x42, 0x12,},
{0x42, 0x01,},
{0x42, 0x20,},
{0x42, 0x15,},
{0x42, 0x21,},
{0x42, 0xb2,},
{0x42, 0x23,},
{0x42, 0xf2,},
{0x42, 0xed,},
{0x42, 0x3a,},
{0x42, 0x44,},
{0x42, 0x3f,},
{0x42, 0x4a,},
{0x42, 0x45,},
{0x42, 0x1d,},
{0x42, 0x53,},
{0x42, 0xd4,},
{0x42, 0xd7,},
{0x42, 0x48,},
{0x42, 0x54,},
{0x42, 0x02,},
{0x42, 0x36,},
{0x42, 0x52,},
{0x42, 0xc8,},
{0x42, 0x24,},
{0x42, 0x31,},
{0x42, 0xe6,},
{0x42, 0x1b,},
{0x42, 0x61,},
{0x42, 0xb6,},
{0x42, 0x1e,},
{0x42, 0x62,},
{0x42, 0x43,},
{0x42, 0x2c,},
{0x42, 0x83,},
{0x42, 0x65,},
{0x42, 0x40,},
{0x42, 0x24,},
{0x42, 0x85,},
{0x42, 0x4d,},
{0x42, 0x75,},
{0x42, 0x3d,},
{0x42, 0x53,},
{0x42, 0xa4,},
{0x42, 0xf5,},
{0x42, 0x4c,},
{0x42, 0x24,},
{0x42, 0x5c,},
{0x42, 0x3d,},
{0x42, 0xc3,},
{0x42, 0x59,},
{0x42, 0x2e,},
{0x42, 0x32,},
{0x42, 0x8d,},
{0x42, 0x26,},
{0x42, 0x02,},
{0x42, 0x60,},
{0x42, 0x28,},
{0x42, 0xd2,},
{0x42, 0xe3,},
{0x42, 0x35,},
{0x42, 0x93,},
{0x42, 0xdc,},
{0x42, 0x45,},
{0x42, 0xc4,},
{0x42, 0xc2,},
{0x42, 0x4f,},
{0x42, 0x55,},
{0x42, 0x3a,},
{0x42, 0x50,},
{0x42, 0xa5,},
{0x42, 0x02,},
{0x42, 0x50,},
{0x42, 0xd4,},
{0x42, 0xbe,},
{0x42, 0x45,},
{0x42, 0x53,},
{0x42, 0xe6,},
{0x42, 0x37,},
{0x42, 0xf3,},
{0x42, 0x31,},
{0x42, 0x30,},
{0x42, 0x83,},
{0x42, 0x08,},
{0x42, 0x33,},
{0x42, 0x13,},
{0x42, 0x7f,},
{0x42, 0x3e,},
{0x42, 0x64,},
{0x42, 0x55,},
{0x42, 0x4b,},
{0x42, 0xe5,},
{0x42, 0x0d,},
{0x42, 0x50,},
{0x42, 0x25,},
{0x42, 0x0a,},
{0x42, 0x54,},
{0x42, 0x85,},
{0x42, 0x21,},
{0x42, 0x56,},
{0x42, 0x75,},
{0x42, 0x2f,},
{0x42, 0x4d,},
{0x42, 0xc4,},
{0x42, 0x81,},
{0x42, 0x42,},
{0x42, 0xb3,},
{0x42, 0xe5,},
{0x42, 0x3b,},
{0x42, 0xe3,},
{0x42, 0xbe,},
{0x42, 0x3e,},
{0x42, 0x54,},
{0x42, 0x2b,},
{0x42, 0x48,},
{0x42, 0x14,},
{0x42, 0xdc,},
{0x42, 0x52,},
{0x42, 0xf5,},
{0x42, 0x67,},
{0x42, 0x52,},
{0x42, 0x15,},
{0x42, 0x48,},

{0x0e, 0x00,}, //BURST_END
{0x0e, 0x01,}, //BURST_START

//B Value
{0x42, 0x3e,},
{0x42, 0x93,},
{0x42, 0x9d,},
{0x42, 0x3b,},
{0x42, 0x43,},
{0x42, 0x8f,},
{0x42, 0x35,},
{0x42, 0x93,},
{0x42, 0x2c,},
{0x42, 0x2f,},
{0x42, 0xb2,},
{0x42, 0xd7,},
{0x42, 0x2c,},
{0x42, 0x32,},
{0x42, 0xc3,},
{0x42, 0x2d,},
{0x42, 0x72,},
{0x42, 0xfb,},
{0x42, 0x32,},
{0x42, 0xc3,},
{0x42, 0x59,},
{0x42, 0x38,},
{0x42, 0xf3,},
{0x42, 0xb4,},
{0x42, 0x39,},
{0x42, 0xd3,},
{0x42, 0xe9,},
{0x42, 0x38,},
{0x42, 0x83,},
{0x42, 0x6d,},
{0x42, 0x35,},
{0x42, 0x33,},
{0x42, 0x26,},
{0x42, 0x2e,},
{0x42, 0xb2,},
{0x42, 0xb0,},
{0x42, 0x27,},
{0x42, 0x62,},
{0x42, 0x4c,},
{0x42, 0x23,},
{0x42, 0x52,},
{0x42, 0x35,},
{0x42, 0x24,},
{0x42, 0xc2,},
{0x42, 0x76,},
{0x42, 0x2b,},
{0x42, 0x02,},
{0x42, 0xeb,},
{0x42, 0x32,},
{0x42, 0x63,},
{0x42, 0x53,},
{0x42, 0x36,},
{0x42, 0xd3,},
{0x42, 0x88,},
{0x42, 0x38,},
{0x42, 0xa3,},
{0x42, 0x3d,},
{0x42, 0x2f,},
{0x42, 0x12,},
{0x42, 0xbe,},
{0x42, 0x27,},
{0x42, 0xd2,},
{0x42, 0x35,},
{0x42, 0x1f,},
{0x42, 0x11,},
{0x42, 0xc1,},
{0x42, 0x1a,},
{0x42, 0x81,},
{0x42, 0xa8,},
{0x42, 0x1c,},
{0x42, 0x11,},
{0x42, 0xf1,},
{0x42, 0x23,},
{0x42, 0x52,},
{0x42, 0x7d,},
{0x42, 0x2b,},
{0x42, 0xe2,},
{0x42, 0xf1,},
{0x42, 0x33,},
{0x42, 0xd3,},
{0x42, 0x8a,},
{0x42, 0x37,},
{0x42, 0xa3,},
{0x42, 0x21,},
{0x42, 0x2c,},
{0x42, 0x82,},
{0x42, 0x89,},
{0x42, 0x23,},
{0x42, 0x51,},
{0x42, 0xde,},
{0x42, 0x19,},
{0x42, 0x11,},
{0x42, 0x59,},
{0x42, 0x13,},
{0x42, 0xc1,},
{0x42, 0x3c,},
{0x42, 0x15,},
{0x42, 0x91,},
{0x42, 0x91,},
{0x42, 0x1d,},
{0x42, 0xe2,},
{0x42, 0x35,},
{0x42, 0x28,},
{0x42, 0x92,},
{0x42, 0xc8,},
{0x42, 0x32,},
{0x42, 0x13,},
{0x42, 0x7a,},
{0x42, 0x35,},
{0x42, 0x82,},
{0x42, 0xf7,},
{0x42, 0x29,},
{0x42, 0x62,},
{0x42, 0x4b,},
{0x42, 0x1e,},
{0x42, 0x91,},
{0x42, 0x87,},
{0x42, 0x13,},
{0x42, 0x20,},
{0x42, 0xf6,},
{0x42, 0x0d,},
{0x42, 0x70,},
{0x42, 0xd7,},
{0x42, 0x0f,},
{0x42, 0x61,},
{0x42, 0x32,},
{0x42, 0x18,},
{0x42, 0x71,},
{0x42, 0xe9,},
{0x42, 0x24,},
{0x42, 0xb2,},
{0x42, 0x96,},
{0x42, 0x2f,},
{0x42, 0x73,},
{0x42, 0x58,},
{0x42, 0x33,},
{0x42, 0xb2,},
{0x42, 0xd2,},
{0x42, 0x26,},
{0x42, 0x82,},
{0x42, 0x0f,},
{0x42, 0x1a,},
{0x42, 0x41,},
{0x42, 0x3a,},
{0x42, 0x0e,},
{0x42, 0x00,},
{0x42, 0xa1,},
{0x42, 0x08,},
{0x42, 0x20,},
{0x42, 0x82,},
{0x42, 0x0a,},
{0x42, 0x10,},
{0x42, 0xe0,},
{0x42, 0x13,},
{0x42, 0xa1,},
{0x42, 0xa4,},
{0x42, 0x20,},
{0x42, 0xf2,},
{0x42, 0x68,},
{0x42, 0x2d,},
{0x42, 0x23,},
{0x42, 0x3b,},
{0x42, 0x31,},
{0x42, 0xc2,},
{0x42, 0xb1,},
{0x42, 0x24,},
{0x42, 0x41,},
{0x42, 0xe0,},
{0x42, 0x16,},
{0x42, 0xc0,},
{0x42, 0xfd,},
{0x42, 0x0a,},
{0x42, 0x20,},
{0x42, 0x62,},
{0x42, 0x04,},
{0x42, 0x20,},
{0x42, 0x42,},
{0x42, 0x06,},
{0x42, 0x20,},
{0x42, 0xa2,},
{0x42, 0x0f,},
{0x42, 0xd1,},
{0x42, 0x6c,},
{0x42, 0x1e,},
{0x42, 0x02,},
{0x42, 0x44,},
{0x42, 0x2b,},
{0x42, 0x13,},
{0x42, 0x1c,},
{0x42, 0x30,},
{0x42, 0xe2,},
{0x42, 0x9b,},
{0x42, 0x22,},
{0x42, 0x91,},
{0x42, 0xbe,},
{0x42, 0x14,},
{0x42, 0x50,},
{0x42, 0xd4,},
{0x42, 0x07,},
{0x42, 0x70,},
{0x42, 0x36,},
{0x42, 0x01,},
{0x42, 0x60,},
{0x42, 0x16,},
{0x42, 0x03,},
{0x42, 0x60,},
{0x42, 0x77,},
{0x42, 0x0d,},
{0x42, 0x41,},
{0x42, 0x45,},
{0x42, 0x1b,},
{0x42, 0xe2,},
{0x42, 0x29,},
{0x42, 0x29,},
{0x42, 0xb3,},
{0x42, 0x0e,},
{0x42, 0x30,},
{0x42, 0x22,},
{0x42, 0x8e,},
{0x42, 0x21,},
{0x42, 0x91,},
{0x42, 0xab,},
{0x42, 0x13,},
{0x42, 0x00,},
{0x42, 0xbe,},
{0x42, 0x06,},
{0x42, 0x10,},
{0x42, 0x20,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0x00,},
{0x42, 0x61,},
{0x42, 0x0b,},
{0x42, 0xe1,},
{0x42, 0x30,},
{0x42, 0x1a,},
{0x42, 0xb2,},
{0x42, 0x19,},
{0x42, 0x28,},
{0x42, 0xe3,},
{0x42, 0x02,},

{0x0e, 0x00,}, //BURST_END
{0x0e, 0x01,}, //BURST_START

{0x42, 0x30,},
{0x42, 0x22,},
{0x42, 0x8e,},
{0x42, 0x21,},
{0x42, 0x91,},
{0x42, 0xab,},
{0x42, 0x13,},
{0x42, 0x00,},
{0x42, 0xbe,},
{0x42, 0x06,},
{0x42, 0x10,},
{0x42, 0x20,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x00,},
{0x42, 0x02,},
{0x42, 0x00,},
{0x42, 0x61,},
{0x42, 0x0b,},
{0x42, 0xe1,},
{0x42, 0x30,},
{0x42, 0x1a,},
{0x42, 0xb2,},
{0x42, 0x19,},
{0x42, 0x28,},
{0x42, 0xe3,},
{0x42, 0x02,},
{0x42, 0x30,},
{0x42, 0xe2,},
{0x42, 0x9b,},
{0x42, 0x22,},
{0x42, 0x91,},
{0x42, 0xbe,},
{0x42, 0x14,},
{0x42, 0x50,},
{0x42, 0xd4,},
{0x42, 0x07,},
{0x42, 0x70,},
{0x42, 0x36,},
{0x42, 0x01,},
{0x42, 0x60,},
{0x42, 0x16,},
{0x42, 0x03,},
{0x42, 0x60,},
{0x42, 0x77,},
{0x42, 0x0d,},
{0x42, 0x41,},
{0x42, 0x45,},
{0x42, 0x1b,},
{0x42, 0xe2,},
{0x42, 0x29,},
{0x42, 0x29,},
{0x42, 0xb3,},
{0x42, 0x0e,},
{0x42, 0x31,},
{0x42, 0xc2,},
{0x42, 0xb1,},
{0x42, 0x24,},
{0x42, 0x41,},
{0x42, 0xe0,},
{0x42, 0x16,},
{0x42, 0xc0,},
{0x42, 0xfd,},
{0x42, 0x0a,},
{0x42, 0x20,},
{0x42, 0x62,},
{0x42, 0x04,},
{0x42, 0x20,},
{0x42, 0x42,},
{0x42, 0x06,},
{0x42, 0x20,},
{0x42, 0xa2,},
{0x42, 0x0f,},
{0x42, 0xd1,},
{0x42, 0x6c,},
{0x42, 0x1e,},
{0x42, 0x02,},
{0x42, 0x44,},
{0x42, 0x2b,},
{0x42, 0x13,},
{0x42, 0x1c,},
{0x42, 0x33,},
{0x42, 0xb2,},
{0x42, 0xd2,},
{0x42, 0x26,},
{0x42, 0x82,},
{0x42, 0x0f,},
{0x42, 0x1a,},
{0x42, 0x41,},
{0x42, 0x3a,},
{0x42, 0x0e,},
{0x42, 0x00,},
{0x42, 0xa1,},
{0x42, 0x08,},
{0x42, 0x20,},
{0x42, 0x82,},
{0x42, 0x0a,},
{0x42, 0x10,},
{0x42, 0xe0,},
{0x42, 0x13,},
{0x42, 0xa1,},
{0x42, 0xa4,},
{0x42, 0x20,},
{0x42, 0xf2,},
{0x42, 0x68,},
{0x42, 0x2d,},
{0x42, 0x23,},
{0x42, 0x3b,},
{0x42, 0x35,},
{0x42, 0x82,},
{0x42, 0xf7,},
{0x42, 0x29,},
{0x42, 0x62,},
{0x42, 0x4b,},
{0x42, 0x1e,},
{0x42, 0x91,},
{0x42, 0x87,},
{0x42, 0x13,},
{0x42, 0x20,},
{0x42, 0xf6,},
{0x42, 0x0d,},
{0x42, 0x70,},
{0x42, 0xd7,},
{0x42, 0x0f,},
{0x42, 0x61,},
{0x42, 0x32,},
{0x42, 0x18,},
{0x42, 0x71,},
{0x42, 0xe9,},
{0x42, 0x24,},
{0x42, 0xb2,},
{0x42, 0x96,},
{0x42, 0x2f,},
{0x42, 0x73,},
{0x42, 0x58,},
{0x42, 0x37,},
{0x42, 0xa3,},
{0x42, 0x21,},
{0x42, 0x2c,},
{0x42, 0x82,},
{0x42, 0x89,},
{0x42, 0x23,},
{0x42, 0x51,},
{0x42, 0xde,},
{0x42, 0x19,},
{0x42, 0x11,},
{0x42, 0x59,},
{0x42, 0x13,},
{0x42, 0xc1,},
{0x42, 0x3c,},
{0x42, 0x15,},
{0x42, 0x91,},
{0x42, 0x91,},
{0x42, 0x1d,},
{0x42, 0xe2,},
{0x42, 0x35,},
{0x42, 0x28,},
{0x42, 0x92,},
{0x42, 0xc8,},
{0x42, 0x32,},
{0x42, 0x13,},
{0x42, 0x7a,},
{0x42, 0x38,},
{0x42, 0xa3,},
{0x42, 0x3d,},
{0x42, 0x2f,},
{0x42, 0x12,},
{0x42, 0xbe,},
{0x42, 0x27,},
{0x42, 0xd2,},
{0x42, 0x35,},
{0x42, 0x1f,},
{0x42, 0x11,},
{0x42, 0xc1,},
{0x42, 0x1a,},
{0x42, 0x81,},
{0x42, 0xa8,},
{0x42, 0x1c,},
{0x42, 0x11,},
{0x42, 0xf1,},
{0x42, 0x23,},
{0x42, 0x52,},
{0x42, 0x7d,},
{0x42, 0x2b,},
{0x42, 0xe2,},
{0x42, 0xf1,},
{0x42, 0x33,},
{0x42, 0xd3,},
{0x42, 0x8a,},
{0x42, 0x38,},
{0x42, 0x83,},
{0x42, 0x6d,},
{0x42, 0x35,},
{0x42, 0x33,},
{0x42, 0x26,},
{0x42, 0x2e,},
{0x42, 0xb2,},
{0x42, 0xb0,},
{0x42, 0x27,},
{0x42, 0x62,},
{0x42, 0x4c,},
{0x42, 0x23,},
{0x42, 0x52,},
{0x42, 0x35,},
{0x42, 0x24,},
{0x42, 0xc2,},
{0x42, 0x76,},
{0x42, 0x2b,},
{0x42, 0x02,},
{0x42, 0xeb,},
{0x42, 0x32,},
{0x42, 0x63,},
{0x42, 0x53,},
{0x42, 0x36,},
{0x42, 0xd3,},
{0x42, 0x88,},
{0x42, 0x3e,},
{0x42, 0x93,},
{0x42, 0x9d,},
{0x42, 0x3b,},
{0x42, 0x43,},
{0x42, 0x8f,},
{0x42, 0x35,},
{0x42, 0x93,},
{0x42, 0x2c,},
{0x42, 0x2f,},
{0x42, 0xb2,},
{0x42, 0xd7,},
{0x42, 0x2c,},
{0x42, 0x32,},
{0x42, 0xc3,},
{0x42, 0x2d,},
{0x42, 0x72,},
{0x42, 0xfb,},
{0x42, 0x32,},
{0x42, 0xc3,},
{0x42, 0x59,},
{0x42, 0x38,},
{0x42, 0xf3,},
{0x42, 0xb4,},
{0x42, 0x39,},
{0x42, 0xd3,},
{0x42, 0xe9,},

{0x0e, 0x00,}, //BURST_END

{0x03, 0x0a,},
{0x19, 0x02,},	// Bus Switch

{0x03, 0x15,},	// Shading FPGA(Hi-352)
{0x10, 0x01,},	// LSC ON
{0x11, 0x00,}, //gap y off, gap x off

{0x27, 0x80,},	// LSC G
{0x28, 0x80,},	// LSC B
{0x29, 0x80,},	// LSC R

///////////////////////////////////
// 10 Page Saturation (H/W)
///////////////////////////////////
{0x03, 0x10,},
{0x10, 0x01,},
{0x12, 0x10,}, //YOFS ENB
{0x18, 0x00,}, //20121127 CSP option
{0x20, 0x00,}, //16_235 range scale down off
{0x60, 0x03,}, //Sat ENB Transfer Function     //Transfunction on

///////////////////////////////////
// 11 Page D-LPF (H/W)
///////////////////////////////////
{0x03, 0x11,}, //11 page
{0x10, 0x1f,},//D-LPF ENB //DPC marker

{0x12, 0x28,}, //20121120 character long line detection th
{0x13, 0x2c,}, //20121120 character short line detection th

{0x1d, 0x12,}, // ORG_STD Ctrl
{0x1e, 0x00,},// 20130410_STD 03 -> 00
{0x21, 0x78,}, // Color STD Gain
//Bayer Sharpness Gain Ctrl
{0xb7, 0x22,}, //SpColor_gain1
{0xb8, 0x22,}, //SpColor_gain2
{0xb9, 0x21,}, //SpColor_gain3
{0xba, 0x1e,}, //SpColor_gain4
{0xbb, 0x1c,}, //SpColor_gain5
{0xbc, 0x1a,}, //SpColor_gain6

{0xf2, 0x7a,}, //pga_dark1_hi //Enter Dark1
{0xf3, 0x72,}, //pga_dark_lo  //Escape Dark1
///////////////////////////////////
// 12 Page DPC,GBGR (H/W)//////////
///////////////////////////////////
{0x03, 0x12,}, //12 page
{0x10, 0x57,}, //DPC ON
{0x12, 0x30,},
{0x2b, 0x08,}, //white_th
{0x2c, 0x08,}, //middle_h_th
{0x2d, 0x08,}, //middle_l_th
{0x2e, 0x06,}, //dark_th
{0x2f, 0x40,}, //20121127 _DPC TH
{0x30, 0x40,}, //20121127 _DPC TH
{0x31, 0x40,}, //20121127 _DPC TH
{0x32, 0x40,}, //20121127 _DPC TH
{0x41, 0x88,}, //GBGR Cut off //46

///////////////////////////////////
// 12 Page CI-LPF (H/W)////////////
///////////////////////////////////

{0xEF, 0x01,}, //Interpol Color filter On/Off

///////////////////////////////////
// 13 Page YC-2D_Y-NR (H/W)/////////
///////////////////////////////////
{0x03, 0x13,},

{0x80, 0x2d,}, //YC-2D_C-NR ENB, C-Filter DC option on B[7] //DC on 8b //DC off 2d
{0x81, 0xff,}, // add 20121210
{0x82, 0xfe,}, // add 20121210

{0x85, 0x32,},
{0x86, 0x08,}, // add 20121210

//==========================================================================
// C-Filter PS Reducing (Mask-Size Adjustment)

{0x87, 0x90,},//C-mask near STD TH
{0x88, 0x70,},//C-mask middle STD TH
{0x89, 0x50,},//C-mask far STD TH

{0x8a, 0x86,}, //color STD

{0x97, 0x0f,}, // C-filter Lum gain 1
{0x98, 0x0e,},
{0x99, 0x0d,},
{0x9a, 0x0c,},
{0x9b, 0x0b,},
{0x9c, 0x0a,},
{0x9d, 0x09,},
{0x9e, 0x08,},

{0xa7, 0x0f,}, // C-filter STD gain 1
{0xa8, 0x0e,},
{0xa9, 0x0d,},
{0xaa, 0x0c,},
{0xab, 0x0b,},
{0xac, 0x0a,},
{0xad, 0x09,},
{0xae, 0x08,},

//==========================================================================

///////////////////////////////////
// 14 Page YC-2D_Sharpness(H/W)
///////////////////////////////////
{0x03, 0x14,},
{0x77, 0x20,},//Yc2d_ee_color_gain1
{0x78, 0x20,},//Yc2d_ee_color_gain2
{0x79, 0x20,},//Yc2d_ee_color_gain3
{0x7a, 0x20,},//Yc2d_ee_color_gain4
{0x7b, 0x20,},//Yc2d_ee_color_gain5
{0x7c, 0x20,},//Yc2d_ee_color_gain6
{0x7d, 0x20,},//Yc2d_ee_color_gain7
{0x7e, 0x20,},//Yc2d_ee_color_gain8

{0xc0, 0x00,},//Yc2d_ee_lclip_gain_n1
{0xc1, 0x00,},//Yc2d_ee_lclip_gain_n2
{0xc2, 0x00,},//Yc2d_ee_lclip_gain_n3
{0xc3, 0x00,},//Yc2d_ee_lclip_gain_n4
{0xc4, 0x01,},//Yc2d_ee_lclip_gain_n5

///////////////////////////////////////////////////////////////////////////////
// 16 Page CMC / AWB Gain
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x16,},
{0x10, 0x7f,},	// CMC ENB	3f(spGrap off) 7f(spGrap on)
{0x20, 0x52,},// PS / LN

{0xa0, 0x03,},	// WB gain on
{0xa2, 0x05,},	// R_h (12bit = 8bit * 16)
{0xa3, 0x80,},	// R_l
{0xa4, 0x07,},	// B_h (12bit = 8bit * 16)
{0xa5, 0x80,},	// B_l

{0xd0, 0x01,},//Bayer gain enable
///////////////////////////////////////////////////////////////////////////////
// 17 Page Gamma
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x17,},
{0x10, 0x07,},	// GMA ENB //PS On
{0x12, 0x52,},// old:43 new:65

///////////////////////////////////////////////////////////////////////////////
// 18 Page MCMC
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x18,},	// Page 18
{0x10, 0x01,},	// mcmc_ctl1
{0x11, 0x7f,},	// mcmc_ctl2
{0x53, 0x10,},	// mcmc_ctl3

{0x56, 0x1b,},	// mcmc_glb_sat_lvl_sp1
{0x57, 0x39,},	// mcmc_glb_sat_lvl_sp2
{0x58, 0x5a,},	// mcmc_glb_sat_lvl_sp3
{0x59, 0x80,},	// mcmc_glb_sat_lvl_sp4
{0x5a, 0xa6,},	// mcmc_glb_sat_lvl_sp5
{0x5b, 0xc1,},	// mcmc_glb_sat_lvl_sp6
{0x5c, 0xe8,},	// mcmc_glb_sat_lvl_sp7
{0x5d, 0x38,},	// mcmc_glb_sat_gain_sp1
{0x5e, 0x3a,},	// mcmc_glb_sat_gain_sp2
{0x5f, 0x3c,},	// mcmc_glb_sat_gain_sp3
{0x60, 0x3f,},	// mcmc_glb_sat_gain_sp4
{0x61, 0x3f,},	// mcmc_glb_sat_gain_sp5
{0x62, 0x3f,},	// mcmc_glb_sat_gain_sp6
{0x63, 0x3f,},	// mcmc_glb_sat_gain_sp7
{0x64, 0x3f,},	// mcmc_glb_sat_gain_sp8
{0x65, 0x00,},	// mcmc_std_ctl1
{0x66, 0x00,},	// mcmc_std_ctl2
{0x67, 0x00,},	// mcmc_std_ctl3

{0x6c, 0xff,},	// mcmc_lum_ctl1 sat hue offset
{0x6d, 0x3f,},	// mcmc_lum_ctl2 gain
{0x6e, 0x00,},	// mcmc_lum_ctl3 hue
{0x6f, 0x00,},	// mcmc_lum_ctl4 rgb offset
{0x70, 0x00,},	// mcmc_lum_ctl5 rgb scale

{0xa1, 0x00,},
{0xa2, 0x01,},	//star gain enb

///////////////////////////////////////////////////////////////////////////////
// 1A Page_RGB Y-NR, Y-Sharpness
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x1a,},
{0x30, 0x9f,},	// RGB-Sharpness ENB // Flat-region RGB ENB B[1] //Green dis [7] On

{0x8d, 0x20,},//RGB-Color_Gain1
{0x8e, 0x20,},//RGB-Color_Gain2
{0x8f, 0x20,},//RGB-Color_Gain3
{0x90, 0x20,},//RGB-Color_Gain4
{0x91, 0x20,},//RGB-Color_Gain5
{0xcb, 0x34,},//20130604 Cyan th

///////////////////////////////////////////////////////////////////////////////
// 20 Page (FZY)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x20,}, //Page 20
{0x12, 0x20,},

{0x18, 0x00,},//Check Flicker Lock Off

{0x36, 0x00,}, //EXP Unit
{0x37, 0x08,},
{0x38, 0x98,},

{0x51, 0xff,}, //PGA Max
{0x52, 0x20,}, //PGA Min x0.9

{0x61, 0xFF,},	// max ramp gain
{0x62, 0x00,},	// min ramp gain
{0x60, 0xE0,},	// ramp gain

{0x80, 0x3a,}, //Y Target
///////////////////////////////////////////////////////////////////////////////
// 23 Page (AFC)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x23,}, //Page 23
{0x14, 0x7A,}, //Flicker Line 100
{0x15, 0x66,}, //Flicker Line 120
{0x10, 0x01,}, //Frame Interval

///////////////////////////////////////////////////////////////////////////////
// 2A Page (SSD)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x2A,},
{0x10, 0x11,},
{0x11, 0x01,},
{0x16, 0x50,},	//SSD B gain int gain 1.5

///////////////////////////////////////////////////////////////////////////////
//
// F/W setting start
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// C0 Page (SYSTEM)
///////////////////////////////////////////////////////////////////////////////
//OPCLK Setting
////54mhz = 337F980
{0x03, 0xC0,},
{0x14, 0x03,},
{0x15, 0x37,},
{0x16, 0xF9,},
{0x17, 0x80,},

///////////////////////////////////////////////////////////////////////////////
// C6 Page (SSD Y weight)
///////////////////////////////////////////////////////////////////////////////
//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9e, 0x00,},//1 Line
{0x9f, 0x00,},
{0xa0, 0x00,},
{0xa1, 0x00,},
{0xa2, 0x00,},
{0xa3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

///////////////////////////////////////////////////////////////////////////////
// D9 Page (Capture/Preview)
///////////////////////////////////////////////////////////////////////////////
{0x03, 0xd9,},
{0x7c, 0xe0,},
{0x8c, 0x20,},	//en_ramp_gain_auto

///////////////////////////////////////////////////////////////////////////////
// C8 ~ CC Page (AWB)
///////////////////////////////////////////////////////////////////////////////
{0x03, 0xC8,},
{0x0e, 0x01,}, // burst start

{0x10, 0xD2,},
{0x11, 0xc3,},
{0x12, 0xe4,},
{0x13, 0x1a,}, //bCtl4
{0x14, 0x9f,},
{0x15, 0xc4,},
{0x16, 0x00,},
{0x17, 0x34,},
{0x18, 0x55,},
{0x19, 0x22,},
{0x1a, 0x22,},
{0x1b, 0x44,},
{0x1c, 0x44,},
{0x1d, 0x66,},
{0x1e, 0x66,},
{0x1f, 0x88,},
{0x20, 0x88,},
{0x21, 0x04,},
{0x22, 0x30,},
{0x23, 0x08,},
{0x24, 0x00,},
{0x25, 0x1e,},
{0x26, 0x30,}, //init awb speed
{0x27, 0x6a,},
{0x28, 0x80,},
{0x29, 0x10,},
{0x2a, 0x04,},
{0x2b, 0x0a,},
{0x2c, 0x04,},
{0x2d, 0x0c,},
{0x2e, 0x1e,},
{0x2f, 0x00,},//dwOutdoorCondInTh
{0x30, 0x00,},//dwOutdoorCondInTh_n01
{0x31, 0x21,},//dwOutdoorCondInTh_n02
{0x32, 0x34,},//dwOutdoorCondInTh_n03
{0x33, 0x00,},//dwOutdoorCondOutTh
{0x34, 0x00,},//dwOutdoorCondOutTh_n01
{0x35, 0x27,},//dwOutdoorCondOutTh_n02
{0x36, 0x10,},//dwOutdoorCondOutTh_n03
{0x37, 0x00,},//dwEvTh
{0x38, 0x00,},//dwEvTh_n01
{0x39, 0x04,},//dwEvTh_n02 //840fps
{0x3a, 0x11,},//dwEvTh_n03
{0x3b, 0x00,},//dwEvTh_a01
{0x3c, 0x00,},//dwEvTh_a01_n01
{0x3d, 0x08,},//dwEvTh_a01_n02
{0x3e, 0x23,},//dwEvTh_a01_n03 //480fps
{0x3f, 0x00,},//dwEvTh_a02
{0x40, 0x00,},//dwEvTh_a02_n01
{0x41, 0x20,},//dwEvTh_a02_n02
{0x42, 0x8D,},//dwEvTh_a02_n03 //120fps
{0x43, 0x00,},//dwEvTh_a03
{0x44, 0x00,},//dwEvTh_a03_n01
{0x45, 0x61,},//dwEvTh_a03_n02
{0x46, 0xa8,},//dwEvTh_a03_n03 //40fps
{0x47, 0x00,},//dwEvTh_a04
{0x48, 0x04,},//dwEvTh_a04_n01
{0x49, 0xc4,},//dwEvTh_a04_n02
{0x4a, 0xb4,},//dwEvTh_a04_n03
{0x4b, 0x00,},//dwEvTh_a05
{0x4c, 0x0b,},//dwEvTh_a05_n01
{0x4d, 0x71,},//dwEvTh_a05_n02
{0x4e, 0xb0,},//dwEvTh_a05_n03
{0x4f, 0x96,},//aAglMaxMinLmt
{0x50, 0x4a,},//aAglMaxMinLmt_a01
{0x51, 0x9C,},//aAglMaxMinLmt_a02
{0x52, 0x60,}, //aAglMaxMinLmt_a03
{0x53, 0xa0,},//aAglMaxMinLmt_a04
{0x54, 0x20,},//aAglMaxMinLmt_a05
{0x55, 0xa0,},//aAglMaxMinLmt_a06
{0x56, 0x32,},//aAglMaxMinLmt_a07            13.05.21 Night shot awb issue h38->h32
{0x57, 0x78,},//aTgtWhtRgnBgMaxMinLmt
{0x58, 0x56,},//aTgtWhtRgnBgMaxMinLmt_a01
{0x59, 0x81,},//aTgtWhtRgnBgMaxMinLmt_a02
{0x5a, 0x51,},//aTgtWhtRgnBgMaxMinLmt_a03
{0x5b, 0x98,},//aTgtWhtRgnBgMaxMinLmt_a04
{0x5c, 0x20,},//aTgtWhtRgnBgMaxMinLmt_a05
{0x5d, 0x98,},//aTgtWhtRgnBgMaxMinLmt_a06
{0x5e, 0x32,},//aTgtWhtRgnBgMaxMinLmt_a07   13.05.21 Night shot awb issue h42->h32

{0x5f, 0x10,},//bTgtWhtRgnBgStep
{0x60, 0x0a,},//BpOption distance weight  def : 0a -> 04 -> 02

{0x61, 0x1e,},
{0x62, 0x34,},
{0x63, 0x80,},
{0x64, 0x10,},
{0x65, 0x01,},
{0x66, 0x04,},
{0x67, 0x0e,},
{0x68, 0x00,},
{0x69, 0x32,},
{0x6a, 0x00,},
{0x6b, 0xa2,},
{0x6c, 0x02,},
{0x6d, 0x00,},
{0x6e, 0x00,},
{0x6f, 0x00,},
{0x70, 0x00,},
{0x71, 0x00,},
{0x72, 0x00,},
{0x73, 0x00,},
{0x74, 0x00,},
{0x75, 0x00,},
{0x76, 0x55,},
{0x77, 0x55,},
{0x78, 0x55,},
{0x79, 0x55,},
{0x7a, 0x55,},
{0x7b, 0x55,},
{0x7c, 0x55,},
{0x7d, 0x55,},
{0x7e, 0x55,},
{0x7f, 0x55,},
{0x80, 0x55,},
{0x81, 0x55,},
{0x82, 0x55,},
{0x83, 0x55,},
{0x84, 0x55,},
{0x85, 0x55,},
{0x86, 0x55,},
{0x87, 0x55,},
{0x88, 0x55,},
{0x89, 0x55,},
{0x8a, 0x55,},
{0x8b, 0x55,},
{0x8c, 0x55,},
{0x8d, 0x55,},
{0x8e, 0x55,},
{0x8f, 0x55,},
{0x90, 0x55,},
{0x91, 0x00,},
{0x92, 0x00,},

{0x93, 0x00,}, //Indoor_wRgIntOfs
{0x94, 0xc0,},//Indoor_wRgIntOfs_n01
{0x95, 0x00,}, //Indoor_wBgIntOfs
{0x96, 0xc0,}, //Indoor_wBgIntOfs_n01
{0x97, 0x10,}, //Indoor_bRgStep
{0x98, 0x10,}, //Indoor_bBgStep
{0x99, 0x26,}, //Indoor_aTgtWhtRgnBg
{0x9a, 0x29,}, //Indoor_aTgtWhtRgnBg_a01
{0x9b, 0x2c,}, //Indoor_aTgtWhtRgnBg_a02
{0x9c, 0x38,}, //Indoor_aTgtWhtRgnBg_a03
{0x9d, 0x43,}, //Indoor_aTgtWhtRgnBg_a04
{0x9e, 0x4d,}, //Indoor_aTgtWhtRgnBg_a05
{0x9f, 0x59,}, //Indoor_aTgtWhtRgnBg_a06
{0xa0, 0x64,}, //Indoor_aTgtWhtRgnBg_a07
{0xa1, 0x6f,}, //Indoor_aTgtWhtRgnBg_a08
{0xa2, 0x7b,}, //Indoor_aTgtWhtRgnBg_a09
{0xa3, 0x8e,},//Indoor_aTgtWhtRgnBg_a10
{0xa4, 0xa0,},//Indoor_aTgtWhtRgnRgLtLmt
{0xa5, 0x98,},//Indoor_aTgtWhtRgnRgLtLmt_a01
{0xa6, 0x82,},//Indoor_aTgtWhtRgnRgLtLmt_a02
{0xa7, 0x6d,},//Indoor_aTgtWhtRgnRgLtLmt_a03
{0xa8, 0x60,},//Indoor_aTgtWhtRgnRgLtLmt_a04
{0xa9, 0x56,},//Indoor_aTgtWhtRgnRgLtLmt_a05
{0xaa, 0x4c,},//Indoor_aTgtWhtRgnRgLtLmt_a06
{0xab, 0x45,},//Indoor_aTgtWhtRgnRgLtLmt_a07
{0xac, 0x40,},//Indoor_aTgtWhtRgnRgLtLmt_a08
{0xad, 0x3c,},//Indoor_aTgtWhtRgnRgLtLmt_a09
{0xae, 0x39,},//Indoor_aTgtWhtRgnRgLtLmt_a10
{0xaf, 0xaa,},//Indoor_aTgtWhtRgnRgRtLmt
{0xb0, 0xa9,},//Indoor_aTgtWhtRgnRgRtLmt_a01
{0xb1, 0xa8,},//Indoor_aTgtWhtRgnRgRtLmt_a02
{0xb2, 0xa2,},//Indoor_aTgtWhtRgnRgRtLmt_a03
{0xb3, 0x95,},//Indoor_aTgtWhtRgnRgRtLmt_a04
{0xb4, 0x88,},//Indoor_aTgtWhtRgnRgRtLmt_a05
{0xb5, 0x78,},//Indoor_aTgtWhtRgnRgRtLmt_a06
{0xb6, 0x65,},//Indoor_aTgtWhtRgnRgRtLmt_a07
{0xb7, 0x5a,},//Indoor_aTgtWhtRgnRgRtLmt_a08
{0xb8, 0x50,},//Indoor_aTgtWhtRgnRgRtLmt_a09
{0xb9, 0x4a,},//Indoor_aTgtWhtRgnRgRtLmt_a10
{0xba, 0x1b,}, //Indoor_aOptWhtRgnBg
{0xbb, 0x1d,}, //Indoor_aOptWhtRgnBg_a01
{0xbc, 0x1f,}, //Indoor_aOptWhtRgnBg_a02
{0xbd, 0x2a,}, //Indoor_aOptWhtRgnBg_a03
{0xbe, 0x38,}, //Indoor_aOptWhtRgnBg_a04
{0xbf, 0x47,}, //Indoor_aOptWhtRgnBg_a05
{0xc0, 0x54,}, //Indoor_aOptWhtRgnBg_a06
{0xc1, 0x61,}, //Indoor_aOptWhtRgnBg_a07
{0xc2, 0x72,}, //Indoor_aOptWhtRgnBg_a08
{0xc3, 0x82,}, //Indoor_aOptWhtRgnBg_a09
{0xc4, 0x9a,},//Indoor_aOptWhtRgnBg_a10
{0xc5, 0xad,}, //Indoor_aOptWhtRgnRgLtLmt
{0xc6, 0x98,},//Indoor_aOptWhtRgnRgLtLmt_a01
{0xc7, 0x8a,},//Indoor_aOptWhtRgnRgLtLmt_a02
{0xc8, 0x74,},//Indoor_aOptWhtRgnRgLtLmt_a03
{0xc9, 0x5f,},//Indoor_aOptWhtRgnRgLtLmt_a04
{0xca, 0x50,},//Indoor_aOptWhtRgnRgLtLmt_a05
{0xcb, 0x46,},//Indoor_aOptWhtRgnRgLtLmt_a06
{0xcc, 0x40,},//Indoor_aOptWhtRgnRgLtLmt_a07
{0xcd, 0x39,},//Indoor_aOptWhtRgnRgLtLmt_a08
{0xce, 0x35,},//Indoor_aOptWhtRgnRgLtLmt_a09
{0xcf, 0x33,},//Indoor_aOptWhtRgnRgLtLmt_a10
{0xd0, 0xba,},//Indoor_aOptWhtRgnRgRtLmt
{0xd1, 0xb9,},//Indoor_aOptWhtRgnRgRtLmt_a01
{0xd2, 0xb8,},//Indoor_aOptWhtRgnRgRtLmt_a02
{0xd3, 0xb5,}, //Indoor_aOptWhtRgnRgRtLmt_a03
{0xd4, 0xae,}, //Indoor_aOptWhtRgnRgRtLmt_a04
{0xd5, 0xa1,}, //Indoor_aOptWhtRgnRgRtLmt_a05
{0xd6, 0x8c,}, //Indoor_aOptWhtRgnRgRtLmt_a06
{0xd7, 0x78,},//Indoor_aOptWhtRgnRgRtLmt_a07
{0xd8, 0x60,},//Indoor_aOptWhtRgnRgRtLmt_a08
{0xd9, 0x54,},//Indoor_aOptWhtRgnRgRtLmt_a09
{0xda, 0x4d,},//Indoor_aOptWhtRgnRgRtLmt_a10

{0xdb, 0x36,}, //Indoor_aCtmpWgtWdhTh
{0xdc, 0x40,}, //Indoor_aCtmpWgtWdhTh_a01
{0xdd, 0x4c,}, //Indoor_aCtmpWgtWdhTh_a02
{0xde, 0x5c,}, //Indoor_aCtmpWgtWdhTh_a03
{0xdf, 0x6e,}, //Indoor_aCtmpWgtWdhTh_a04
{0xe0, 0x7f,}, //Indoor_aCtmpWgtWdhTh_a05
{0xe1, 0xa4,}, //Indoor_aCtmpWgtWdhTh_a06
{0xe2, 0x27,}, //Indoor_aCtmpWgtHgtTh
{0xe3, 0x32,}, //Indoor_aCtmpWgtHgtTh_a01
{0xe4, 0x3c,}, //Indoor_aCtmpWgtHgtTh_a02
{0xe5, 0x48,}, //Indoor_aCtmpWgtHgtTh_a03
{0xe6, 0x5c,}, //Indoor_aCtmpWgtHgtTh_a04
{0xe7, 0x70,}, //Indoor_aCtmpWgtHgtTh_a05
{0xe8, 0x7c,}, //Indoor_aCtmpWgtHgtTh_a06
{0xe9, 0x86,}, //Indoor_aCtmpWgtHgtTh_a07
{0xea, 0x90,}, //Indoor_aCtmpWgtHgtTh_a08
{0xeb, 0x11,}, //Indoor_aCtmpWgt
{0xec, 0x11,}, //Indoor_aCtmpWgt_a01
{0xed, 0x12,}, //Indoor_aCtmpWgt_a02
{0xee, 0x11,}, //Indoor_aCtmpWgt_a03
{0xef, 0x11,}, //Indoor_aCtmpWgt_a04
{0xf0, 0x33,}, //Indoor_aCtmpWgt_a05
{0xf1, 0x11,}, //Indoor_aCtmpWgt_a06
{0xf2, 0x14,}, //Indoor_aCtmpWgt_a07
{0xf3, 0x43,}, //Indoor_aCtmpWgt_a08
{0xf4, 0x11,}, //Indoor_aCtmpWgt_a09
{0xf5, 0x55,}, //Indoor_aCtmpWgt_a10
{0xf6, 0x41,}, //Indoor_aCtmpWgt_a11
{0xf7, 0x16,}, //Indoor_aCtmpWgt_a12
{0xf8, 0x65,}, //Indoor_aCtmpWgt_a13
{0xf9, 0x11,}, //Indoor_aCtmpWgt_a14
{0xfa, 0x48,}, //Indoor_aCtmpWgt_a15
{0xfb, 0x61,}, //Indoor_aCtmpWgt_a16
{0xfc, 0x11,}, //Indoor_aCtmpWgt_a17
{0xfd, 0x46,}, //Indoor_aCtmpWgt_a18
{0x0e, 0x00,}, // burst end

{0x03, 0xc9,}, //c9 page
{0x0e, 0x01,}, // burst start

{0x10, 0x11,}, //Indoor_aCtmpWgt_a19
{0x11, 0x11,}, //Indoor_aCtmpWgt_a20
{0x12, 0x23,}, //Indoor_aCtmpWgt_a21
{0x13, 0x11,}, //Indoor_aCtmpWgt_a22
{0x14, 0x11,}, //Indoor_aCtmpWgt_a23

{0x15, 0x10,}, //Indoor_aCtmpWgt_a24

{0x16, 0x11,},//Indoor_aYlvlWgt
{0x17, 0x11,},//Indoor_aYlvlWgt_a01
{0x18, 0x11,},//Indoor_aYlvlWgt_a02
{0x19, 0x11,},//Indoor_aYlvlWgt_a03
{0x1a, 0x11,},//Indoor_aYlvlWgt_a04
{0x1b, 0x11,},//Indoor_aYlvlWgt_a05
{0x1c, 0x11,},//Indoor_aYlvlWgt_a06
{0x1d, 0x11,},//Indoor_aYlvlWgt_a07
{0x1e, 0x11,},//Indoor_aYlvlWgt_a08
{0x1f, 0x11,},//Indoor_aYlvlWgt_a09
{0x20, 0x11,},//Indoor_aYlvlWgt_a10
{0x21, 0x22,},//Indoor_aYlvlWgt_a11
{0x22, 0x22,},//Indoor_aYlvlWgt_a12
{0x23, 0x34,},//Indoor_aYlvlWgt_a13
{0x24, 0x32,},//Indoor_aYlvlWgt_a14
{0x25, 0x21,},//Indoor_aYlvlWgt_a15

{0x26, 0x34,},//Indoor_aTgtAngle
{0x27, 0x3e,},//Indoor_aTgtAngle_a01
{0x28, 0x41,},//Indoor_aTgtAngle_a02
{0x29, 0x4e,},//Indoor_aTgtAngle_a03
{0x2a, 0x72,},//Indoor_aTgtAngle_a04

{0x2b, 0x10,},//Indoor_aRgTgtOfs
{0x2c, 0x10,},//Indoor_aRgTgtOfs_a01
{0x2d, 0x8e,},//Indoor_aRgTgtOfs_a02
{0x2e, 0x84,},//Indoor_aRgTgtOfs_a03
{0x2f, 0x86,},//Indoor_aRgTgtOfs_a04

{0x30, 0xc6,},//Indoor_aBgTgtOfs
{0x31, 0xc6,},//Indoor_aBgTgtOfs_a01
{0x32, 0xb1,},//Indoor_aBgTgtOfs_a02
{0x33, 0x8a,},//Indoor_aBgTgtOfs_a03
{0x34, 0x84,},//Indoor_aBgTgtOfs_a04 h88->h00  13.5.29 choi

{0x35, 0x24,},//bRgDefTgt //indoor
{0x36, 0x00,},//bBgDefTgt //indoor

{0x37, 0x20,},//Indoor_aWhtPtTrcAglOfs
{0x38, 0x1e,},//Indoor_aWhtPtTrcAglOfs_a01
{0x39, 0x1c,},//Indoor_aWhtPtTrcAglOfs_a02
{0x3a, 0x1a,},//Indoor_aWhtPtTrcAglOfs_a03
{0x3b, 0x18,},//Indoor_aWhtPtTrcAglOfs_a04
{0x3c, 0x16,},//Indoor_aWhtPtTrcAglOfs_a05
{0x3d, 0x14,},//Indoor_aWhtPtTrcAglOfs_a06
{0x3e, 0x14,},//Indoor_aWhtPtTrcAglOfs_a07
{0x3f, 0x13,},//Indoor_aWhtPtTrcAglOfs_a08
{0x40, 0x12,},//Indoor_aWhtPtTrcAglOfs_a09
{0x41, 0x04,},//Indoor_bWhtPtTrcCnt
{0x42, 0x14,},//Indoor_aRtoDiffThNrBp
{0x43, 0x3c,},//Indoor_aRtoDiffThNrBp_a01
{0x44, 0x28,},//Indoor_aAglDiffThTrWhtPt
{0x45, 0x50,},//Indoor_aAglDiffThTrWhtPt_a01
{0x46, 0xaa,},//Indoor_bWgtRatioTh1
{0x47, 0xa0,},//Indoor_bWgtRatioTh2
{0x48, 0x44,},//Indoor_bWgtOfsTh1
{0x49, 0x40,},//Indoor_bWgtOfsTh2
{0x4a, 0x5a,},//Indoor_bWhtPtCorAglMin
{0x4b, 0x70,},//Indoor_bWhtPtCorAglMax
{0x4c, 0x04,},//Indoor_bYlvlMin
{0x4d, 0xf8,},//Indoor_bYlvlMax
{0x4e, 0x28,},//Indoor_bPxlWgtLmtLoTh
{0x4f, 0x78,},//Indoor_bPxlWgtLmtHiTh
{0x50, 0x00,},//Indoor_SplBldWgt_1
{0x51, 0x00,},//Indoor_SplBldWgt_2
{0x52, 0x64,},//Indoor_SplBldWgt_3
{0x53, 0x60,},//Indoor_TgtOff_StdHiTh
{0x54, 0x30,},//Indoor_TgtOff_StdLoTh
{0x55, 0x05,},//Indoor_wInitRg
{0x56, 0xd0,},//Indoor_wInitRg_n01
{0x57, 0x06,},//Indoor_wInitBg
{0x58, 0x40,},//Indoor_wInitBg_n01

{0x59, 0x02,}, //Indoor_aRatioBox
{0x5a, 0xee,}, //Indoor_aRatioBox_a01
{0x5b, 0x06,}, //Indoor_aRatioBox_a02
{0x5c, 0x40,}, //Indoor_aRatioBox_a03
{0x5d, 0x08,}, //Indoor_aRatioBox_a04
{0x5e, 0x34,}, //Indoor_aRatioBox_a05
{0x5f, 0x0b,},//Indoor_aRatioBox_a06
{0x60, 0x54,},//Indoor_aRatioBox_a07
{0x61, 0x03,}, //Indoor_aRatioBox_a08
{0x62, 0x52,}, //Indoor_aRatioBox_a09
{0x63, 0x07,}, //Indoor_aRatioBox_a10
{0x64, 0xd0,}, //Indoor_aRatioBox_a11
{0x65, 0x06,}, //Indoor_aRatioBox_a12
{0x66, 0xa4,}, //Indoor_aRatioBox_a13
{0x67, 0x08,}, //Indoor_aRatioBox_a14
{0x68, 0xfc,}, //Indoor_aRatioBox_a15
{0x69, 0x03,}, //Indoor_aRatioBox_a16
{0x6a, 0xe8,}, //Indoor_aRatioBox_a17
{0x6b, 0x0a,}, //Indoor_aRatioBox_a18
{0x6c, 0x8c,}, //Indoor_aRatioBox_a19
{0x6d, 0x04,}, //Indoor_aRatioBox_a20
{0x6e, 0xb0,}, //Indoor_aRatioBox_a21
{0x6f, 0x07,}, //Indoor_aRatioBox_a22
{0x70, 0x6c,}, //Indoor_aRatioBox_a23
{0x71, 0x04,}, //Indoor_aRatioBox_a24
{0x72, 0xe2,}, //Indoor_aRatioBox_a25
{0x73, 0x0c,}, //Indoor_aRatioBox_a26
{0x74, 0x1c,}, //Indoor_aRatioBox_a27
{0x75, 0x03,}, //Indoor_aRatioBox_a28
{0x76, 0x84,}, //Indoor_aRatioBox_a29
{0x77, 0x05,}, //Indoor_aRatioBox_a30
{0x78, 0xdc,}, //Indoor_aRatioBox_a31
{0x79, 0x05,}, //Indoor_aRatioBox_a32
{0x7a, 0xdc,}, //Indoor_aRatioBox_a33
{0x7b, 0x0c,}, //Indoor_aRatioBox_a34
{0x7c, 0xe4,}, //Indoor_aRatioBox_a35
{0x7d, 0x01,}, //Indoor_aRatioBox_a36
{0x7e, 0xf4,}, //Indoor_aRatioBox_a37
{0x7f, 0x05,}, //Indoor_aRatioBox_a38
{0x80, 0x00,}, //Indoor_aRatioBox_a39

{0x81, 0x00,}, //Outdoor_wRgIntOfs
{0x82, 0x08,}, //Outdoor_wRgIntOfs_n01    h40->h20  13.5.27  LSC update shift
{0x83, 0x01,}, //Outdoor_wBgIntOfs
{0x84, 0x00,}, //Outdoor_wBgIntOfs_n01
{0x85, 0x10,}, //Outdoor_bRgStep
{0x86, 0x10,}, //Outdoor_bBgStep
{0x87, 0x51,}, //Outdoor_aTgtWhtRgnBg
{0x88, 0x52,}, //Outdoor_aTgtWhtRgnBg_a01
{0x89, 0x53,}, //Outdoor_aTgtWhtRgnBg_a02
{0x8a, 0x57,}, //Outdoor_aTgtWhtRgnBg_a03
{0x8b, 0x5e,}, //Outdoor_aTgtWhtRgnBg_a04
{0x8c, 0x64,}, //Outdoor_aTgtWhtRgnBg_a05
{0x8d, 0x6A,}, //Outdoor_aTgtWhtRgnBg_a06
{0x8e, 0x6F,}, //Outdoor_aTgtWhtRgnBg_a07
{0x8f, 0x75,}, //Outdoor_aTgtWhtRgnBg_a08
{0x90, 0x7c,}, //Outdoor_aTgtWhtRgnBg_a09
{0x91, 0x84,}, //Outdoor_aTgtWhtRgnBg_a10
{0x92, 0x5D,}, //Outdoor_aTgtWhtRgnRgLtLmt
{0x93, 0x57,}, //Outdoor_aTgtWhtRgnRgLtLmt_a01
{0x94, 0x51,}, //Outdoor_aTgtWhtRgnRgLtLmt_a02
{0x95, 0x50,}, //Outdoor_aTgtWhtRgnRgLtLmt_a03
{0x96, 0x4e,}, //Outdoor_aTgtWhtRgnRgLtLmt_a04
{0x97, 0x4c,}, //Outdoor_aTgtWhtRgnRgLtLmt_a05
{0x98, 0x4b,}, //Outdoor_aTgtWhtRgnRgLtLmt_a06
{0x99, 0x49,}, //Outdoor_aTgtWhtRgnRgLtLmt_a07
{0x9a, 0x47,}, //Outdoor_aTgtWhtRgnRgLtLmt_a08
{0x9b, 0x46,}, //Outdoor_aTgtWhtRgnRgLtLmt_a09
{0x9c, 0x45,}, //Outdoor_aTgtWhtRgnRgLtLmt_a10
{0x9d, 0x64,}, //Outdoor_aTgtWhtRgnRgRtLmt
{0x9e, 0x63,}, //Outdoor_aTgtWhtRgnRgRtLmt_a01
{0x9f, 0x62,}, //Outdoor_aTgtWhtRgnRgRtLmt_a02
{0xa0, 0x62,}, //Outdoor_aTgtWhtRgnRgRtLmt_a03
{0xa1, 0x61,}, //Outdoor_aTgtWhtRgnRgRtLmt_a04
{0xa2, 0x60,}, //Outdoor_aTgtWhtRgnRgRtLmt_a05
{0xa3, 0x5e,}, //Outdoor_aTgtWhtRgnRgRtLmt_a06
{0xa4, 0x5d,}, //Outdoor_aTgtWhtRgnRgRtLmt_a07
{0xa5, 0x5c,}, //Outdoor_aTgtWhtRgnRgRtLmt_a08
{0xa6, 0x5a,}, //Outdoor_aTgtWhtRgnRgRtLmt_a09
{0xa7, 0x57,}, //Outdoor_aTgtWhtRgnRgRtLmt_a10
{0xa8, 0x40,}, //Outdoor_aOptWhtRgnBg
{0xa9, 0x45,}, //Outdoor_aOptWhtRgnBg_a01
{0xaa, 0x4b,}, //Outdoor_aOptWhtRgnBg_a02
{0xab, 0x54,}, //Outdoor_aOptWhtRgnBg_a03
{0xac, 0x60,}, //Outdoor_aOptWhtRgnBg_a04
{0xad, 0x6c,}, //Outdoor_aOptWhtRgnBg_a05
{0xae, 0x76,}, //Outdoor_aOptWhtRgnBg_a06
{0xaf, 0x7f,}, //Outdoor_aOptWhtRgnBg_a07
{0xb0, 0x8c,}, //Outdoor_aOptWhtRgnBg_a08
{0xb1, 0x95,}, //Outdoor_aOptWhtRgnBg_a09
{0xb2, 0xa0,}, //Outdoor_aOptWhtRgnBg_a10
{0xb3, 0x6a,}, //Outdoor_aOptWhtRgnRgLtLmt
{0xb4, 0x5b,}, //Outdoor_aOptWhtRgnRgLtLmt_a01
{0xb5, 0x53,}, //Outdoor_aOptWhtRgnRgLtLmt_a02
{0xb6, 0x4c,}, //Outdoor_aOptWhtRgnRgLtLmt_a03
{0xb7, 0x46,}, //Outdoor_aOptWhtRgnRgLtLmt_a04
{0xb8, 0x42,}, //Outdoor_aOptWhtRgnRgLtLmt_a05
{0xb9, 0x3e,}, //Outdoor_aOptWhtRgnRgLtLmt_a06
{0xba, 0x3c,}, //Outdoor_aOptWhtRgnRgLtLmt_a07
{0xbb, 0x3a,}, //Outdoor_aOptWhtRgnRgLtLmt_a08
{0xbc, 0x39,}, //Outdoor_aOptWhtRgnRgLtLmt_a09
{0xbd, 0x37,}, //Outdoor_aOptWhtRgnRgLtLmt_a10
{0xbe, 0x7d,}, //Outdoor_aOptWhtRgnRgRtLmt
{0xbf, 0x7c,}, //Outdoor_aOptWhtRgnRgRtLmt_a01
{0xc0, 0x79,}, //Outdoor_aOptWhtRgnRgRtLmt_a02
{0xc1, 0x76,}, //Outdoor_aOptWhtRgnRgRtLmt_a03
{0xc2, 0x6f,}, //Outdoor_aOptWhtRgnRgRtLmt_a04
{0xc3, 0x6a,}, //Outdoor_aOptWhtRgnRgRtLmt_a05
{0xc4, 0x66,}, //Outdoor_aOptWhtRgnRgRtLmt_a06
{0xc5, 0x63,}, //Outdoor_aOptWhtRgnRgRtLmt_a07
{0xc6, 0x5B,}, //Outdoor_aOptWhtRgnRgRtLmt_a08
{0xc7, 0x54,}, //Outdoor_aOptWhtRgnRgRtLmt_a09
{0xc8, 0x4a,}, //Outdoor_aOptWhtRgnRgRtLmt_a10

{0xc9, 0x42,}, //Outdoor_aCtmpWgtWdhTh
{0xca, 0x4c,}, //Outdoor_aCtmpWgtWdhTh_a01
{0xcb, 0x54,}, //Outdoor_aCtmpWgtWdhTh_a02
{0xcc, 0x5c,}, //Outdoor_aCtmpWgtWdhTh_a03
{0xcd, 0x64,}, //Outdoor_aCtmpWgtWdhTh_a04
{0xce, 0x6c,}, //Outdoor_aCtmpWgtWdhTh_a05
{0xcf, 0x74,}, //Outdoor_aCtmpWgtWdhTh_a06
{0xd0, 0x42,}, //Outdoor_aCtmpWgtHgtTh
{0xd1, 0x52,}, //Outdoor_aCtmpWgtHgtTh_a01
{0xd2, 0x58,}, //Outdoor_aCtmpWgtHgtTh_a02
{0xd3, 0x5e,}, //Outdoor_aCtmpWgtHgtTh_a03
{0xd4, 0x64,}, //Outdoor_aCtmpWgtHgtTh_a04
{0xd5, 0x6a,}, //Outdoor_aCtmpWgtHgtTh_a05
{0xd6, 0x72,}, //Outdoor_aCtmpWgtHgtTh_a06
{0xd7, 0x7a,}, //Outdoor_aCtmpWgtHgtTh_a07
{0xd8, 0x88,}, //Outdoor_aCtmpWgtHgtTh_a08
{0xd9, 0x11,}, //Outdoor_aCtmpWgt
{0xda, 0x23,}, //Outdoor_aCtmpWgt_a01
{0xdb, 0x22,}, //Outdoor_aCtmpWgt_a02
{0xdc, 0x11,}, //Outdoor_aCtmpWgt_a03
{0xdd, 0x22,}, //Outdoor_aCtmpWgt_a04
{0xde, 0x22,}, //Outdoor_aCtmpWgt_a05
{0xdf, 0x11,}, //Outdoor_aCtmpWgt_a06
{0xe0, 0x33,}, //Outdoor_aCtmpWgt_a07
{0xe1, 0x31,}, //Outdoor_aCtmpWgt_a08
{0xe2, 0x12,}, //Outdoor_aCtmpWgt_a09
{0xe3, 0x66,}, //Outdoor_aCtmpWgt_a10
{0xe4, 0x41,}, //Outdoor_aCtmpWgt_a11
{0xe5, 0x13,}, //Outdoor_aCtmpWgt_a12
{0xe6, 0x77,}, //Outdoor_aCtmpWgt_a13
{0xe7, 0x41,}, //Outdoor_aCtmpWgt_a14
{0xe8, 0x13,}, //Outdoor_aCtmpWgt_a15
{0xe9, 0x74,}, //Outdoor_aCtmpWgt_a16
{0xea, 0x11,}, //Outdoor_aCtmpWgt_a17
{0xeb, 0x23,}, //Outdoor_aCtmpWgt_a18
{0xec, 0x53,}, //Outdoor_aCtmpWgt_a19
{0xed, 0x11,}, //Outdoor_aCtmpWgt_a20
{0xee, 0x43,}, //Outdoor_aCtmpWgt_a21
{0xef, 0x31,}, //Outdoor_aCtmpWgt_a22
{0xf0, 0x11,}, //Outdoor_aCtmpWgt_a23
{0xf1, 0x11,}, //Outdoor_aCtmpWgt_a24

{0xf2, 0x12,}, //aYlvlWgt
{0xf3, 0x34,}, //aYlvlWgt_a01
{0xf4, 0x43,}, //aYlvlWgt_a02
{0xf5, 0x32,}, //aYlvlWgt_a03
{0xf6, 0x22,}, //aYlvlWgt_a04
{0xf7, 0x11,}, //aYlvlWgt_a05
{0xf8, 0x11,}, //aYlvlWgt_a06
{0xf9, 0x11,}, //aYlvlWgt_a07
{0xfa, 0x11,}, //aYlvlWgt_a08
{0xfb, 0x11,}, //aYlvlWgt_a09
{0xfc, 0x11,}, //aYlvlWgt_a10
{0xfd, 0x11,}, //aYlvlWgt_a11
{0x0e, 0x00,}, // burst end

//Page ca
{0x03, 0xca,},
{0x0e, 0x01,}, // burst start

{0x10, 0x11,}, //aYlvlWgt_a12
{0x11, 0x22,}, //aYlvlWgt_a13
{0x12, 0x22,}, //aYlvlWgt_a14
{0x13, 0x11,}, //aYlvlWgt_a15

{0x14, 0x64,},//Outdoor_aTgtAngle
{0x15, 0x6b,},//Outdoor_aTgtAngle_a01
{0x16, 0x72,},//Outdoor_aTgtAngle_a02
{0x17, 0x7a,},//Outdoor_aTgtAngle_a03
{0x18, 0x84,},//Outdoor_aTgtAngle_a04
{0x19, 0x16,},//Outdoor_aRgTgtOfs
{0x1a, 0x0e,},//Outdoor_aRgTgtOfs_a01
{0x1b, 0x82,},//Outdoor_aRgTgtOfs_a02
{0x1c, 0x88,},//Outdoor_aRgTgtOfs_a03
{0x1d, 0x88,},//Outdoor_aRgTgtOfs_a04

{0x1e, 0x9e,},//Outdoor_aBgTgtOfs
{0x1f, 0x8b,},//Outdoor_aBgTgtOfs_a01
{0x20, 0x89,},//Outdoor_aBgTgtOfs_a02
{0x21, 0x87,},//Outdoor_aBgTgtOfs_a03
{0x22, 0x84,},//Outdoor_aBgTgtOfs_a04

{0x23, 0x92,},//Outdoor_bRgDefTgt
{0x24, 0x8d,},//Outdoor_bBgDefTgt

{0x25, 0x1c,}, //Outdoor_aWhtPtTrcAglOfs
{0x26, 0x1a,}, //Outdoor_aWhtPtTrcAglOfs_a01
{0x27, 0x18,}, //Outdoor_aWhtPtTrcAglOfs_a02
{0x28, 0x16,}, //Outdoor_aWhtPtTrcAglOfs_a03
{0x29, 0x14,}, //Outdoor_aWhtPtTrcAglOfs_a04
{0x2a, 0x12,}, //Outdoor_aWhtPtTrcAglOfs_a05
{0x2b, 0x10,}, //Outdoor_aWhtPtTrcAglOfs_a06
{0x2c, 0x0f,}, //Outdoor_aWhtPtTrcAglOfs_a07
{0x2d, 0x0e,}, //Outdoor_aWhtPtTrcAglOfs_a08
{0x2e, 0x0e,}, //Outdoor_aWhtPtTrcAglOfs_a09
{0x2f, 0x0a,}, //Outdoor_bWhtPtTrcCnt
{0x30, 0x28,}, //Outdoor_aRtoDiffThNrBp
{0x31, 0x48,}, //Outdoor_aRtoDiffThNrBp_a01
{0x32, 0x28,}, //Outdoor_aAglDiffThTrWhtPt
{0x33, 0x50,}, //Outdoor_aAglDiffThTrWhtPt_a01
{0x34, 0xaa,}, //Outdoor_bWgtRatioTh1
{0x35, 0xa0,}, //Outdoor_bWgtRatioTh2
{0x36, 0x0a,}, //Outdoor_bWgtOfsTh1
{0x37, 0xa0,}, //Outdoor_bWgtOfsTh2

{0x38, 0x6d,},//Outdoor_bWhtPtCorAglMin
{0x39, 0x78,},//Outdoor_bWhtPtCorAglMax

{0x3a, 0x04,}, //Outdoor_bYlvlMin
{0x3b, 0xf8,}, //Outdoor_bYlvlMax
{0x3c, 0x28,}, //Outdoor_bPxlWgtLmtLoTh
{0x3d, 0x78,}, //Outdoor_bPxlWgtLmtHiTh
{0x3e, 0x00,}, //Outdoor_SplBldWgt_1
{0x3f, 0x00,}, //Outdoor_SplBldWgt_2
{0x40, 0x64,}, //Outdoor_SplBldWgt_3
{0x41, 0x60,}, //Outdoor_TgtOff_StdHiTh
{0x42, 0x30,}, //Outdoor_TgtOff_StdLoTh
{0x43, 0x04,},
{0x44, 0xc0,},
{0x45, 0x07,},
{0x46, 0xc0,},
{0x47, 0x02,},//Outdoor_aRatioBox
{0x48, 0xb2,},//Outdoor_aRatioBox_a01
{0x49, 0x05,},//Outdoor_aRatioBox_a02
{0x4a, 0xdc,},//Outdoor_aRatioBox_a03
{0x4b, 0x0a,},//Outdoor_aRatioBox_a04
{0x4c, 0x28,},//Outdoor_aRatioBox_a05
{0x4d, 0x0c,},//Outdoor_aRatioBox_a06
{0x4e, 0x1c,},//Outdoor_aRatioBox_a07
{0x4f, 0x02,},//Outdoor_aRatioBox_a08
{0x50, 0xee,},//Outdoor_aRatioBox_a09
{0x51, 0x06,},//Outdoor_aRatioBox_a10
{0x52, 0x72,},//Outdoor_aRatioBox_a11
{0x53, 0x08,},//Outdoor_aRatioBox_a12
{0x54, 0x98,},//Outdoor_aRatioBox_a13
{0x55, 0x0a,},//Outdoor_aRatioBox_a14
{0x56, 0xf0,},//Outdoor_aRatioBox_a15
{0x57, 0x03,},//Outdoor_aRatioBox_a16
{0x58, 0x20,},//Outdoor_aRatioBox_a17
{0x59, 0x07,},//Outdoor_aRatioBox_a18
{0x5a, 0x08,},//Outdoor_aRatioBox_a19
{0x5b, 0x07,},//Outdoor_aRatioBox_a20
{0x5c, 0x6c,},//Outdoor_aRatioBox_a21
{0x5d, 0x09,},//Outdoor_aRatioBox_a22
{0x5e, 0x60,},//Outdoor_aRatioBox_a23
{0x5f, 0x03,},//Outdoor_aRatioBox_a24
{0x60, 0x84,},//Outdoor_aRatioBox_a25
{0x61, 0x07,},//Outdoor_aRatioBox_a26
{0x62, 0xd0,},//Outdoor_aRatioBox_a27
{0x63, 0x06,},//Outdoor_aRatioBox_a28
{0x64, 0x40,},//Outdoor_aRatioBox_a29
{0x65, 0x08,},//Outdoor_aRatioBox_a30
{0x66, 0x34,},//Outdoor_aRatioBox_a31
{0x67, 0x03,},//Outdoor_aRatioBox_a32
{0x68, 0xe8,},//Outdoor_aRatioBox_a33
{0x69, 0x08,},//Outdoor_aRatioBox_a34
{0x6a, 0xd0,},//Outdoor_aRatioBox_a35
{0x6b, 0x04,},//Outdoor_aRatioBox_a36
{0x6c, 0x4c,},//Outdoor_aRatioBox_a37
{0x6d, 0x07,},//Outdoor_aRatioBox_a38
{0x6e, 0x08,},//Outdoor_aRatioBox_a39

{0x6f, 0x04,},
{0x70, 0x00,},

{0x71, 0x05,},//Out2_Adt_RgainMin
{0x72, 0x00,},//Out2_Adt_RgainMin_n01
{0x73, 0x05,}, //Out2_Adt_RgainMax
{0x74, 0xe0,},//Out2_Adt_RgainMax_n01
{0x75, 0x04,},//Out2_Adt_GgainMin
{0x76, 0x00,},//Out2_Adt_GgainMin_n01
{0x77, 0x04,},//Out2_Adt_GgainMax
{0x78, 0x00,},//Out2_Adt_GgainMax_n01
{0x79, 0x05,}, //Out2_Adt_BgainMin
{0x7a, 0xe0,}, //Out2_Adt_BgainMin_n01
{0x7b, 0x07,},//Out2_Adt_BgainMax
{0x7c, 0x00,},//Out2_Adt_BgainMax_n01

{0x7d, 0x05,},//Out1_Adt_RgainMin
{0x7e, 0x40,},//Out1_Adt_RgainMin_n01
{0x7f, 0x06,},//Out1_Adt_RgainMax
{0x80, 0x80,}, //Out1_Adt_RgainMax_n01
{0x81, 0x04,},//Out1_Adt_GgainMin
{0x82, 0x00,},//Out1_Adt_GgainMin_n01
{0x83, 0x04,},//Out1_Adt_GgainMax
{0x84, 0x00,},//Out1_Adt_GgainMax_n01
{0x85, 0x05,},//Out1_Adt_BgainMin
{0x86, 0x80,},//Out1_Adt_BgainMin_n01
{0x87, 0x07,},//Out1_Adt_BgainMax
{0x88, 0xe0,}, //Out1_Adt_BgainMax_n01

{0x89, 0x04,},//In_Adt_RgainMin
{0x8a, 0x00,},//In_Adt_RgainMin_n01
{0x8b, 0x0d,},//In_Adt_RgainMax
{0x8c, 0x00,},//In_Adt_RgainMax_n01
{0x8d, 0x04,},//In_Adt_GgainMin
{0x8e, 0x00,},//In_Adt_GgainMin_n01
{0x8f, 0x05,},//In_Adt_GgainMax
{0x90, 0x80,}, //In_Adt_GgainMax_n01
{0x91, 0x04,},//In_Adt_BgainMin
{0x92, 0x00,},//In_Adt_BgainMin_n01
{0x93, 0x0d,},//In_Adt_BgainMax
{0x94, 0x80,},//In_Adt_BgainMax_n01

{0x95, 0x04,},//Manual_Adt_RgainMin
{0x96, 0x00,},//Manual_Adt_RgainMin_n01
{0x97, 0x0d,},//Manual_Adt_RgainMax
{0x98, 0x00,},//Manual_Adt_RgainMax_n01
{0x99, 0x04,},//Manual_Adt_GgainMin
{0x9a, 0x00,},//Manual_Adt_GgainMin_n01
{0x9b, 0x04,}, //Manual_Adt_GgainMax
{0x9c, 0x80,}, //Manual_Adt_GgainMax_n01
{0x9d, 0x04,},//Manual_Adt_BgainMin
{0x9e, 0x00,},//Manual_Adt_BgainMin_n01
{0x9f, 0x0b,},//Manual_Adt_BgainMax
{0xa0, 0x00,},//Manual_Adt_BgainMax_n01

{0x0e, 0x00,}, //burst end

{0x03, 0xC8,},
{0x11, 0xC3,},	//AWB reset


/////////////////////////////////////////////////////////////////////////////////
// CD page(OTP control)
/////////////////////////////////////////////////////////////////////////////////
{0x03, 0xCD,},
{0x10, 0x03,},

{0x22, 0x10,},
//Manual Typical colo ratio write
{0x27, 0x1A,}, //Typical RG=0.685*1000 = 6850 = 1AC2
{0x28, 0xC2,},
{0x29, 0x10,}, //Typical BG=0.430*1000 = 4300 = 10CC
{0x2A, 0xCC,},
{0x2b, 0x0a,},//+/-10 valid ratio check

///////////////////////////////////////////////////////////////////////////////
// Color ratio setting
/////////////////////////////////////////////////////////////////////////////////
{0x03, 0xCE,},
{0x33, 0x04,},	//R gain def
{0x34, 0x00,},
{0x35, 0x04,},	//G gain def
{0x36, 0x00,},
{0x37, 0x04,},	//B gain def
{0x38, 0x00,},

{0x45, 0x00,}, //Outdoor In EvTh
{0x46, 0x00,},
{0x47, 0x27,},
{0x48, 0x10,},
{0x49, 0x00,}, //Outdoor Out EvTh
{0x4a, 0x00,},
{0x4b, 0x4e,},
{0x4c, 0x20,},

{0x55, 0x48,},//Low In Th
{0x56, 0x52,},//Low Out Th
{0x57, 0x60,},//High Out Th
{0x58, 0x70,},//High In Th

{0x62, 0xd8,},//Out weight //ca->d8
{0x63, 0xa6,},//Indoor weight
{0x64, 0x88,},//Dark weight
{0x65, 0xe8,},//Low weight
{0x66, 0xa6,},//High weight

{0x31, 0x01,},//Color ratio reset
{0x30, 0x98,},//Color ratio on
///////////////////////////////////////////////////////////////////////////////
// D3 ~ D8 Page (Adaptive)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xd3,},	// Adaptive start

{0x0e, 0x01,}, // burst start

{0x10, 0x00,},
{0x11, 0x00,},
{0x12, 0x00,},
{0x13, 0x00,},
{0x14, 0x00,},
{0x15, 0x00,},
{0x16, 0x00,},
{0x17, 0x00,},
{0x18, 0x00,},
{0x19, 0x00,},

{0x1a, 0x00,},	// Def_Yoffset
{0x1b, 0x23,},	// DYOFS_Ratio
{0x1c, 0x04,},	// DYOFS_Limit

{0x1d, 0x00,},//EV Th OutEnd
{0x1e, 0x00,},
{0x1f, 0x20,},
{0x20, 0x8d,},

{0x21, 0x00,},//EV Th OutStr def :  80fps  Ag 1x Dg 1x
{0x22, 0x00,},
{0x23, 0x30,},
{0x24, 0xd4,},

{0x25, 0x00,},	//EV Th Dark1Str
{0x26, 0x0b,},
{0x27, 0x71,},
{0x28, 0xb0,},

{0x29, 0x00,},	//EV Th Dark1End
{0x2a, 0x0d,},
{0x2b, 0xbb,},
{0x2c, 0xa0,},

{0x2d, 0x00,},	//EV Th Dark2Str
{0x2e, 0x12,},
{0x2f, 0x76,},
{0x30, 0x90,},

{0x31, 0x00,},	//EV Th Dark2End
{0x32, 0x1e,},
{0x33, 0x84,},
{0x34, 0x80,},

{0x35, 0x4b,}, //Ctmp LT End
{0x36, 0x52,}, //Ctmp LT Str
{0x37, 0x69,},	//Ctmp HT Str
{0x38, 0x73,},	//Ctmp HT End

{0x39, 0x00,},	// LSC_EvTh_OutEnd_4
{0x3a, 0x00,},	// LSC_EvTh_OutEnd_3
{0x3b, 0x13,},	// LSC_EvTh_OutEnd_2
{0x3c, 0x88,},	// LSC_EvTh_OutEnd_1    def : 200fps  Ag 1x Dg 1x

{0x3d, 0x00,},	// LSC_EvTh_OutStr_4
{0x3e, 0x00,},	// LSC_EvTh_OutStr_3
{0x3f, 0x30,},	// LSC_EvTh_OutStr_2
{0x40, 0xd4,},	// LSC_EvTh_OutStr_1    def :  80fps  Ag 1x Dg 1x

{0x41, 0x00,},	// LSC_EvTh_Dark1Str_4
{0x42, 0x05,},	// LSC_EvTh_Dark1Str_3
{0x43, 0xb8,},	// LSC_EvTh_Dark1Str_2
{0x44, 0xd8,},	// LSC_EvTh_Dark1Str_1  def :  8fps  Ag 3x Dg 1x

{0x45, 0x00,},	// LSC_EvTh_Dark1End_4
{0x46, 0x0b,},	// LSC_EvTh_Dark1End_3
{0x47, 0x71,},	// LSC_EvTh_Dark1End_2
{0x48, 0xb0,},	// LSC_EvTh_Dark1End_1  def :  8fps  Ag 6x Dg 1x

{0x49, 0x00,},	// LSC_EvTh_Dark2Str_4
{0x4a, 0x0f,},	// LSC_EvTh_Dark2Str_3
{0x4b, 0x42,},	// LSC_EvTh_Dark2Str_2
{0x4c, 0x40,},	// LSC_EvTh_Dark2Str_1  def :  8fps  Ag 8x Dg 1x

{0x4d, 0x00,},	// LSC_EvTh_Dark2End_4
{0x4e, 0x1e,},	// LSC_EvTh_Dark2End_3
{0x4f, 0x84,},	// LSC_EvTh_Dark2End_2
{0x50, 0x80,},	// LSC_EvTh_Dark2End_1  def :  4fps  Ag 8x Dg 1x

{0x51, 0x55,},// LSC Ctmp LTEnd Out
{0x52, 0x64,},// LSC Ctmp LTStr Out
{0x53, 0x78,},// LSC Ctmp HTStr Out
{0x54, 0x86,},// LSC Ctmp HTEnd Out

{0x55, 0x4a,},// LSC Ctmp LTEnd In     h46->h4a   13.5.29 multi gain modify
{0x56, 0x56,},// LSC Ctmp LTStr In     h56->h56
{0x57, 0x6e,},// LSC Ctmp HTStr In     h6e->h6e
{0x58, 0x78,},// LSC Ctmp HTEnd In     h76->h78

{0x59, 0x50,},	// LSC_CTmpTh_LT_End_Dark
{0x5a, 0x78,},	// LSC_CTmpTh_LT_Str_Dark
{0x5b, 0xa0,},	// LSC_CTmpTh_HT_Str_Dark
{0x5c, 0xb4,},	// LSC_CTmpTh_HT_End_Dark

{0x5d, 0x00,},	// UniScn_EvMinTh_4
{0x5e, 0x00,},	// UniScn_EvMinTh_3
{0x5f, 0x04,},	// UniScn_EvMinTh_2
{0x60, 0xe2,},	// UniScn_EvMinTh_1    def : 600fps  Ag 1x Dg 1x

{0x61, 0x00,},	// UniScn_EvMaxTh_4
{0x62, 0x05,},	// UniScn_EvMaxTh_3
{0x63, 0xb8,},	// UniScn_EvMaxTh_2
{0x64, 0xd8,},	// UniScn_EvMaxTh_1     def :  8fps  Ag 3x Dg 1x

{0x65, 0x4e,},	// UniScn_AglMinTh_1
{0x66, 0x50,},	// UniScn_AglMinTh_2
{0x67, 0x73,},	// UniScn_AglMaxTh_1
{0x68, 0x7d,},	// UniScn_AglMaxTh_2

{0x69, 0x03,},// UniScn_YstdMinTh
{0x6a, 0x0a,},// UniScn_YstdMaxTh
{0x6b, 0x1e,},// UniScn_BPstdMinTh
{0x6c, 0x3a,},// UniScn_BPstdMaxTh

{0x6d, 0x64,},	// Ytgt_ColWgt_Out
{0x6e, 0x64,},	// Ytgt_ColWgt_Dark
{0x6f, 0x64,},	// ColSat_ColWgt_Out
{0x70, 0x64,},	// ColSat_ColWgt_Dark
{0x71, 0x64,},	// CMC_ColWgt_Out
{0x72, 0x64,},	// CMC_ColWgt_Dark
{0x73, 0x64,},	// MCMC_ColWgt_Out
{0x74, 0x64,},	// MCMC_ColWgt_Dark
{0x75, 0x64,},	// CustomReg_CorWgt_Out
{0x76, 0x64,},	// CustomReg_CorWgt_Dark

{0x77, 0x64,},	// UniScn_Y_Ratio
{0x78, 0x50,},	// UniScn_Cb_Ratio
{0x79, 0x50,},	// UniScn_Cr_Ratio

{0x7a, 0x00,},	// Ytgt_offset
{0x7b, 0x00,},	// CbSat_offset
{0x7c, 0x00,},	// CrSat_offset

{0x7d, 0x34,},// Y_target_Outdoor
{0x7e, 0x34,},// Y_target_Indoor
{0x7f, 0x34,},// Y_target_Dark1
{0x80, 0x34,},// Y_target_Dark2
{0x81, 0x39,},// Y_target_LowTemp
{0x82, 0x2f,},// Y_target_HighTemp

{0x83, 0x98,}, // Cb_Outdoor
{0x84, 0x95,},// Cb _Sat_Indoor
{0x85, 0xa0,},// Cb _Sat_Dark1
{0x86, 0x8a,},// Cb _Sat_Dark2
{0x87, 0x88,},// Cb _Sat_LowTemp
{0x88, 0x92,},// Cb _Sat_HighTemp

{0x89, 0x88,},// Cr _Sat_Outdoor
{0x8a, 0x90,},// Cr _Sat_Indoor
{0x8b, 0xa0,},// Cr _Sat_Dark1
{0x8c, 0x84,},// Cr _Sat_Dark2
{0x8d, 0x75,},// Cr _Sat_LowTemp
{0x8e, 0x92,},// Cr _Sat_HighTemp

{0x8f, 0x82,},	// BLC_ofs_r_Outdoor
{0x90, 0x81,},	// BLC_ofs_b_Outdoor
{0x91, 0x82,},	// BLC_ofs_gr_Outdoor
{0x92, 0x82,},	// BLC_ofs_gb_Outdoor

{0x93, 0x81,},	// BLC_ofs_r_Indoor
{0x94, 0x80,},	// BLC_ofs_b_Indoor
{0x95, 0x81,},	// BLC_ofs_gr_Indoor
{0x96, 0x81,},	// BLC_ofs_gb_Indoor

{0x97, 0x82,},	// BLC_ofs_r_Dark1
{0x98, 0x82,},	// BLC_ofs_b_Dark1
{0x99, 0x82,},	// BLC_ofs_gr_Dark1
{0x9a, 0x82,},	// BLC_ofs_gb_Dark1

{0x9b, 0x82,},	// BLC_ofs_r_Dark2
{0x9c, 0x82,},	// BLC_ofs_b_Dark2
{0x9d, 0x82,},	// BLC_ofs_gr_Dark2
{0x9e, 0x82,},	// BLC_ofs_gb_Dark2

{0x9f, 0x00,},//LSC Out_L ofs G
{0xa0, 0x00,},//LSC Out_L ofs B
{0xa1, 0x00,},//LSC Out_L ofs R
{0xa2, 0x80,},//LSC Out_L Gain G
{0xa3, 0x82,},//LSC Out_L Gain B
{0xa4, 0x88,},//LSC Out_L Gain R

{0xa5, 0x00,},//LSC Out_M ofs G
{0xa6, 0x00,},//LSC Out_M ofs B
{0xa7, 0x00,},//LSC Out_M ofs R
{0xa8, 0x80,},//LSC Out_M Gain G
{0xa9, 0x84,},//LSC Out_M Gain B
{0xaa, 0x85,},//LSC Out_M Gain R

{0xab, 0x00,},//LSC Out_H ofs G
{0xac, 0x00,},//LSC Out_H ofs B
{0xad, 0x00,},//LSC Out_H ofs R
{0xae, 0x80,},//LSC Out_H Gain G
{0xaf, 0x86,},//LSC Out_H Gain B
{0xb0, 0x7e,},//LSC Out_H Gain R

{0xb1, 0x00,},// LSC0_Ind_LowTmp        offset g
{0xb2, 0x00,},// LSC1_Ind_LowTmp        offset b
{0xb3, 0x00,},// LSC2_Ind_LowTmp        offset r
{0xb4, 0x80,},// LSC3_Ind_LowTmp        gain g
{0xb5, 0x80,},// LSC4_Ind_LowTmp        gain b
{0xb6, 0x84,},// LSC5_Ind_LowTmp        gain r

{0xb7, 0x00,},// LSC0_Ind_MiddleTmp     offset g
{0xb8, 0x00,},// LSC1_Ind_MiddleTmp     offset b
{0xb9, 0x00,},// LSC2_Ind_MiddleTmp     offset r
{0xba, 0x80,},// LSC3_Ind_MiddleTmp     gain g
{0xbb, 0x80,},// LSC4_Ind_MiddleTmp     gain b
{0xbc, 0x78,},// LSC5_Ind_MiddleTmp     gain r

{0xbd, 0x00,},// LSC0_Ind_HighTmp       offset g
{0xbe, 0x00,},// LSC1_Ind_HighTmp       offset b
{0xbf, 0x00,},// LSC2_Ind_HighTmp       offset r
{0xc0, 0x80,},// LSC3_Ind_HighTmp       gain g
{0xc1, 0x80,},// LSC4_Ind_HighTmp       gain b
{0xc2, 0x7a,},// LSC5_Ind_HighTmp       gain r

{0xc3, 0x00,},	// LSC0_Dark1_LowTmp      offset g
{0xc4, 0x00,},	// LSC1_Dark1_LowTmp      offset b
{0xc5, 0x00,},	// LSC2_Dark1_LowTmp      offset r
{0xc6, 0x68,},	// LSC3_Dark1_LowTmp      gain g
{0xc7, 0x65,},// LSC4_Dark1_LowTmp      gain b
{0xc8, 0x62,},// LSC5_Dark1_LowTmp      gain r

{0xc9, 0x00,},	// LSC0_Dark1_MiddleTmp   offset g
{0xca, 0x00,},	// LSC1_Dark1_MiddleTmp   offset b
{0xcb, 0x00,},	// LSC2_Dark1_MiddleTmp   offset r
{0xcc, 0x68,},	// LSC3_Dark1_MiddleTmp   gain g
{0xcd, 0x65,},// LSC4_Dark1_MiddleTmp   gain b
{0xce, 0x62,},// LSC5_Dark1_MiddleTmp   gain r

{0xcf, 0x00,},	// LSC0_Dark1_HighTmp   offset g
{0xd0, 0x00,},	// LSC1_Dark1_HighTmp   offset b
{0xd1, 0x00,},	// LSC2_Dark1_HighTmp   offset r
{0xd2, 0x68,},	// LSC3_Dark1_HighTmp   gain g
{0xd3, 0x65,},// LSC4_Dark1_HighTmp   gain b
{0xd4, 0x62,},// LSC5_Dark1_HighTmp   gain r

{0xd5, 0x00,},	// LSC0_Dark2           offset g
{0xd6, 0x00,},	// LSC1_Dark2           offset b
{0xd7, 0x00,},	// LSC2_Dark2           offset r
{0xd8, 0x68,},	// LSC3_Dark2           gain g
{0xd9, 0x65,},// LSC4_Dark2           gain b
{0xda, 0x62,},// LSC5_Dark2           gain r

{0xdb, 0x2f,}, //CMCSIGN_Out
{0xdc, 0x50,}, //CMC_Out_00
{0xdd, 0x1d,}, //CMC_Out_01
{0xde, 0x0d,}, //CMC_Out_02
{0xdf, 0x0e,}, //CMC_Out_03
{0xe0, 0x50,}, //CMC_Out_04
{0xe1, 0x02,}, //CMC_Out_05
{0xe2, 0x05,}, //CMC_Out_06
{0xe3, 0x15,}, //CMC_Out_07
{0xe4, 0x5a,}, //CMC_Out_08

{0xe5, 0x04,},	// CMC_Out_LumTh1      CMC SP gain axis X(luminance)
{0xe6, 0x0a,},	// CMC_Out_LumTh2
{0xe7, 0x10,},	// CMC_Out_LumTh3
{0xe8, 0x18,},	// CMC_Out_LumTh4
{0xe9, 0x20,},	// CMC_Out_LumTh5
{0xea, 0x28,},	// CMC_Out_LumTh6
{0xeb, 0x40,},	// CMC_Out_LumTh7

{0xec, 0x20,},	// CMC_Out_LumGain1_R  CMC SP R gain axis Y (gain):: max32
{0xed, 0x20,},	// CMC_Out_LumGain2_R
{0xee, 0x20,},	// CMC_Out_LumGain3_R
{0xef, 0x20,},	// CMC_Out_LumGain4_R
{0xf0, 0x20,},	// CMC_Out_LumGain5_R
{0xf1, 0x20,},	// CMC_Out_LumGain6_R
{0xf2, 0x20,},	// CMC_Out_LumGain7_R
{0xf3, 0x20,},	// CMC_Out_LumGain8_R    20 = x1.0

{0xf4, 0x20,},	// CMC_Out_LumGain1_G  CMC SP G gain axis Y (gain):: max32
{0xf5, 0x20,},	// CMC_Out_LumGain2_G
{0xf6, 0x20,},	// CMC_Out_LumGain3_G
{0xf7, 0x20,},	// CMC_Out_LumGain4_G
{0xf8, 0x20,},	// CMC_Out_LumGain5_G
{0xf9, 0x20,},	// CMC_Out_LumGain6_G
{0xfa, 0x20,},	// CMC_Out_LumGain7_G
{0xfb, 0x20,},	// CMC_Out_LumGain8_G    20 = x1.0

{0xfc, 0x20,},	// CMC_Out_LumGain1_B  CMC SP B gain axis Y (gain):: max32
{0xfd, 0x20,},	// CMC_Out_LumGain2_B
{0x0e, 0x00,}, // burst end

{0x03, 0xd4,},	// page D4
{0x0e, 0x01,}, // burst start

{0x10, 0x20,},	// CMC_Out_LumGain3_B
{0x11, 0x20,},	// CMC_Out_LumGain4_B
{0x12, 0x20,},	// CMC_Out_LumGain5_B
{0x13, 0x20,},	// CMC_Out_LumGain6_B
{0x14, 0x20,},	// CMC_Out_LumGain7_B
{0x15, 0x20,},	// CMC_Out_LumGain8_B    20 = x1.0

{0x16, 0x2f,},//CMCSIGN_In_Mid
{0x17, 0x53,},//CMC_In_Mid_00
{0x18, 0x16,},//CMC_In_Mid_01
{0x19, 0x03,},//CMC_In_Mid_02
{0x1a, 0x10,},//CMC_In_Mid_03
{0x1b, 0x53,},//CMC_In_Mid_04
{0x1c, 0x03,},//CMC_In_Mid_05
{0x1d, 0x04,},//CMC_In_Mid_06
{0x1e, 0x1d,},//CMC_In_Mid_07
{0x1f, 0x61,},//CMC_In_Mid_08

{0x20, 0x04,},	// CMC_Ind_LumTh1     CMC SP gain axis X(luminance)
{0x21, 0x0a,},	// CMC_Ind_LumTh2
{0x22, 0x10,},	// CMC_Ind_LumTh3
{0x23, 0x18,},	// CMC_Ind_LumTh4
{0x24, 0x20,},	// CMC_Ind_LumTh5
{0x25, 0x28,},	// CMC_Ind_LumTh6
{0x26, 0x40,},	// CMC_Ind_LumTh7

{0x27, 0x08,},	// CMC_Ind_LumGain1_R   CMC SP R gain axis Y (gain):: max32
{0x28, 0x12,},	// CMC_Ind_LumGain2_R
{0x29, 0x18,},	// CMC_Ind_LumGain3_R
{0x2a, 0x1c,},	// CMC_Ind_LumGain4_R
{0x2b, 0x1e,},	// CMC_Ind_LumGain5_R
{0x2c, 0x20,},	// CMC_Ind_LumGain6_R
{0x2d, 0x20,},	// CMC_Ind_LumGain7_R
{0x2e, 0x20,},	// CMC_Ind_LumGain8_R    20 = x1.0

{0x2f, 0x08,},	// CMC_Ind_LumGain1_G   CMC SP G gain axis Y (gain):: max32
{0x30, 0x12,},	// CMC_Ind_LumGain2_G
{0x31, 0x18,},	// CMC_Ind_LumGain3_G
{0x32, 0x1c,},	// CMC_Ind_LumGain4_G
{0x33, 0x1e,},	// CMC_Ind_LumGain5_G
{0x34, 0x20,},	// CMC_Ind_LumGain6_G
{0x35, 0x20,},	// CMC_Ind_LumGain7_G
{0x36, 0x20,},	// CMC_Ind_LumGain8_G    20 = x1.0

{0x37, 0x08,},	// CMC_Ind_LumGain1_B   CMC SP B gain axis Y (gain):: max32
{0x38, 0x12,},	// CMC_Ind_LumGain2_B
{0x39, 0x18,},	// CMC_Ind_LumGain3_B
{0x3a, 0x1c,},	// CMC_Ind_LumGain4_B
{0x3b, 0x1e,},	// CMC_Ind_LumGain5_B
{0x3c, 0x20,},	// CMC_Ind_LumGain6_B
{0x3d, 0x20,},	// CMC_Ind_LumGain7_B
{0x3e, 0x20,},	// CMC_Ind_LumGain8_B   20 = x1.0

{0x3f, 0x2f,},//CMCSIGN_Dark1
{0x40, 0x53,},//CMC_Dark1_00
{0x41, 0x1c,},//CMC_Dark1_01
{0x42, 0x09,},//CMC_Dark1_02
{0x43, 0x0e,},//CMC_Dark1_03
{0x44, 0x53,},//CMC_Dark1_04
{0x45, 0x05,},//CMC_Dark1_05
{0x46, 0x03,},//CMC_Dark1_06
{0x47, 0x23,},//CMC_Dark1_07
{0x48, 0x66,},//CMC_Dark1_08

{0x49, 0x04,},	// CMC_Dark1_LumTh1     CMC SP gain axis X(luminance)
{0x4a, 0x0a,},	// CMC_Dark1_LumTh2
{0x4b, 0x10,},	// CMC_Dark1_LumTh3
{0x4c, 0x18,},	// CMC_Dark1_LumTh4
{0x4d, 0x20,},	// CMC_Dark1_LumTh5
{0x4e, 0x28,},	// CMC_Dark1_LumTh6
{0x4f, 0x40,},	// CMC_Dark1_LumTh7

{0x50, 0x08,},	// CMC_Dark1_LumGain1_R  CMC SP R gain axis Y (gain):: max32
{0x51, 0x12,},	// CMC_Dark1_LumGain2_R
{0x52, 0x18,},	// CMC_Dark1_LumGain3_R
{0x53, 0x1c,},	// CMC_Dark1_LumGain4_R
{0x54, 0x1e,},	// CMC_Dark1_LumGain5_R
{0x55, 0x20,},	// CMC_Dark1_LumGain6_R
{0x56, 0x20,},	// CMC_Dark1_LumGain7_R
{0x57, 0x20,},	// CMC_Dark1_LumGain8_R    20 = x1.0

{0x58, 0x08,},	// CMC_Dark1_LumGain1_G   CMC SP G gain axis Y (gain):: max32
{0x59, 0x12,},	// CMC_Dark1_LumGain2_G
{0x5a, 0x18,},	// CMC_Dark1_LumGain3_G
{0x5b, 0x1c,},	// CMC_Dark1_LumGain4_G
{0x5c, 0x1e,},	// CMC_Dark1_LumGain5_G
{0x5d, 0x20,},	// CMC_Dark1_LumGain6_G
{0x5e, 0x20,},	// CMC_Dark1_LumGain7_G
{0x5f, 0x20,},	// CMC_Dark1_LumGain8_G    20 = x1.0

{0x60, 0x08,},	// CMC_Dark1_LumGain1_B   CMC SP B gain axis Y (gain):: max32
{0x61, 0x12,},	// CMC_Dark1_LumGain2_B
{0x62, 0x18,},	// CMC_Dark1_LumGain3_B
{0x63, 0x1c,},	// CMC_Dark1_LumGain4_B
{0x64, 0x1e,},	// CMC_Dark1_LumGain5_B
{0x65, 0x20,},	// CMC_Dark1_LumGain6_B
{0x66, 0x20,},	// CMC_Dark1_LumGain7_B
{0x67, 0x20,},	// CMC_Dark1_LumGain8_B   20 = x1.0

{0x68, 0x2f,},//CMCSIGN_Dark2
{0x69, 0x53,},//CMC_Dark2_00
{0x6a, 0x1c,},//CMC_Dark2_01
{0x6b, 0x09,},//CMC_Dark2_02
{0x6c, 0x0e,},//CMC_Dark2_03
{0x6d, 0x53,},//CMC_Dark2_04
{0x6e, 0x05,},//CMC_Dark2_05
{0x6f, 0x03,},//CMC_Dark2_06
{0x70, 0x23,},//CMC_Dark2_07
{0x71, 0x66,},//CMC_Dark2_08

{0x72, 0x04,},	// CMC_Dark2_LumTh1        CMC SP gain axis X(luminance)
{0x73, 0x0a,},	// CMC_Dark2_LumTh2
{0x74, 0x10,},	// CMC_Dark2_LumTh3
{0x75, 0x18,},	// CMC_Dark2_LumTh4
{0x76, 0x20,},	// CMC_Dark2_LumTh5
{0x77, 0x28,},	// CMC_Dark2_LumTh6
{0x78, 0x40,},	// CMC_Dark2_LumTh7

{0x79, 0x15,},// CMC_Dark2_LumGain1_R    CMC SP R gain
{0x7a, 0x18,},// CMC_Dark2_LumGain2_R
{0x7b, 0x1e,},// CMC_Dark2_LumGain3_R
{0x7c, 0x1f,},// CMC_Dark2_LumGain4_R
{0x7d, 0x20,},// CMC_Dark2_LumGain5_R
{0x7e, 0x20,},// CMC_Dark2_LumGain6_R
{0x7f, 0x20,},// CMC_Dark2_LumGain7_R
{0x80, 0x20,},// CMC_Dark2_LumGain8_R    20 = x1

{0x81, 0x15,},// CMC_Dark2_LumGain1_G    CMC SP G gain
{0x82, 0x18,},// CMC_Dark2_LumGain2_G
{0x83, 0x1e,},// CMC_Dark2_LumGain3_G
{0x84, 0x1f,},// CMC_Dark2_LumGain4_G
{0x85, 0x20,},// CMC_Dark2_LumGain5_G
{0x86, 0x20,},// CMC_Dark2_LumGain6_G
{0x87, 0x20,},// CMC_Dark2_LumGain7_G
{0x88, 0x20,},// CMC_Dark2_LumGain8_G    20 = x1.

{0x89, 0x15,},// CMC_Dark2_LumGain1_B    CMC SP B gain
{0x8a, 0x18,},// CMC_Dark2_LumGain2_B
{0x8b, 0x1e,},// CMC_Dark2_LumGain3_B
{0x8c, 0x1f,},// CMC_Dark2_LumGain4_B
{0x8d, 0x20,},// CMC_Dark2_LumGain5_B
{0x8e, 0x20,},// CMC_Dark2_LumGain6_B
{0x8f, 0x20,},// CMC_Dark2_LumGain7_B
{0x90, 0x20,},// CMC_Dark2_LumGain8_B    20 = x1.0

{0x91, 0x2f,}, // CMCSIGN_In_Low
{0x92, 0x53,}, // CMC_In_Low_00
{0x93, 0x1e,}, //CMC_In_Low_01
{0x94, 0x0b,}, //CMC_In_Low_02
{0x95, 0x18,}, //CMC_In_Low_03
{0x96, 0x61,}, // CMC_In_Low_04
{0x97, 0x09,}, //CMC_In_Low_05
{0x98, 0x04,}, //CMC_In_Low_06
{0x99, 0x14,}, //CMC_In_Low_07
{0x9a, 0x58,}, // CMC_In_Low_08

{0x9b, 0x04,},	// CMC_LowTemp_LumTh1     CMC SP gain axis X(luminance)
{0x9c, 0x0a,},	// CMC_LowTemp_LumTh2
{0x9d, 0x10,},	// CMC_LowTemp_LumTh3
{0x9e, 0x18,},	// CMC_LowTemp_LumTh4
{0x9f, 0x20,},	// CMC_LowTemp_LumTh5
{0xa0, 0x28,},	// CMC_LowTemp_LumTh6
{0xa1, 0x40,},	// CMC_LowTemp_LumTh7

{0xa2, 0x20,},	// CMC_LowTemp_LumGain1_R    CMC SP R gain
{0xa3, 0x20,},	// CMC_LowTemp_LumGain2_R
{0xa4, 0x20,},	// CMC_LowTemp_LumGain3_R
{0xa5, 0x20,},	// CMC_LowTemp_LumGain4_R
{0xa6, 0x20,},	// CMC_LowTemp_LumGain5_R
{0xa7, 0x20,},	// CMC_LowTemp_LumGain6_R
{0xa8, 0x20,},	// CMC_LowTemp_LumGain7_R
{0xa9, 0x20,},	// CMC_LowTemp_LumGain8_R    20 = x1.0

{0xaa, 0x20,},	// CMC_LowTemp_LumGain1_G    CMC SP G gain
{0xab, 0x20,},	// CMC_LowTemp_LumGain2_G
{0xac, 0x20,},	// CMC_LowTemp_LumGain3_G
{0xad, 0x20,},	// CMC_LowTemp_LumGain4_G
{0xae, 0x20,},	// CMC_LowTemp_LumGain5_G
{0xaf, 0x20,},	// CMC_LowTemp_LumGain6_G
{0xb0, 0x20,},	// CMC_LowTemp_LumGain7_G
{0xb1, 0x20,},	// CMC_LowTemp_LumGain8_G    20 = x1.0

{0xb2, 0x20,},	// CMC_LowTemp_LumGain1_B    CMC SP B gain
{0xb3, 0x20,},	// CMC_LowTemp_LumGain2_B
{0xb4, 0x20,},	// CMC_LowTemp_LumGain3_B
{0xb5, 0x20,},	// CMC_LowTemp_LumGain4_B
{0xb6, 0x20,},	// CMC_LowTemp_LumGain5_B
{0xb7, 0x20,},	// CMC_LowTemp_LumGain6_B
{0xb8, 0x20,},	// CMC_LowTemp_LumGain7_B
{0xb9, 0x20,},	// CMC_LowTemp_LumGain8_B    20 = x1.0

{0xba, 0x2d,}, //CMCSIGN_In_High
{0xbb, 0x55,}, //CMC_In_High_00
{0xbc, 0x21,}, //CMC_In_High_01
{0xbd, 0x0c,}, //CMC_In_High_02
{0xbe, 0x08,}, //CMC_In_High_03
{0xbf, 0x55,}, //CMC_In_High_04
{0xc0, 0x0d,}, //CMC_In_High_05
{0xc1, 0x03,}, //CMC_In_High_06
{0xc2, 0x18,}, //CMC_In_High_07
{0xc3, 0x55,}, //CMC_In_High_08

{0xc4, 0x04,},	// CMC_HighTemp_LumTh1       CMC SP gain axis X(luminance)
{0xc5, 0x0a,},	// CMC_HighTemp_LumTh2
{0xc6, 0x10,},	// CMC_HighTemp_LumTh3
{0xc7, 0x18,},	// CMC_HighTemp_LumTh4
{0xc8, 0x20,},	// CMC_HighTemp_LumTh5
{0xc9, 0x28,},	// CMC_HighTemp_LumTh6
{0xca, 0x40,},	// CMC_HighTemp_LumTh7

{0xcb, 0x20,},	// CMC_HighTemp_LumGain1_R   CMC SP R gain
{0xcc, 0x20,},	// CMC_HighTemp_LumGain2_R
{0xcd, 0x20,},	// CMC_HighTemp_LumGain3_R
{0xce, 0x20,},	// CMC_HighTemp_LumGain4_R
{0xcf, 0x20,},	// CMC_HighTemp_LumGain5_R
{0xd0, 0x20,},	// CMC_HighTemp_LumGain6_R
{0xd1, 0x20,},	// CMC_HighTemp_LumGain7_R
{0xd2, 0x20,},	// CMC_HighTemp_LumGain8_R    20 = x1.0

{0xd3, 0x20,},	// CMC_HighTemp_LumGain1_G   CMC SP G gain
{0xd4, 0x20,},	// CMC_HighTemp_LumGain2_G
{0xd5, 0x20,},	// CMC_HighTemp_LumGain3_G
{0xd6, 0x20,},	// CMC_HighTemp_LumGain4_G
{0xd7, 0x20,},	// CMC_HighTemp_LumGain5_G
{0xd8, 0x20,},	// CMC_HighTemp_LumGain6_G
{0xd9, 0x20,},	// CMC_HighTemp_LumGain7_G
{0xda, 0x20,},	// CMC_HighTemp_LumGain8_G    20 = x1.

{0xdb, 0x20,},	// CMC_HighTemp_LumGain1_B   CMC SP B gain
{0xdc, 0x20,},	// CMC_HighTemp_LumGain2_B
{0xdd, 0x20,},	// CMC_HighTemp_LumGain3_B
{0xde, 0x20,},	// CMC_HighTemp_LumGain4_B
{0xdf, 0x20,},	// CMC_HighTemp_LumGain5_B
{0xe0, 0x20,},	// CMC_HighTemp_LumGain6_B
{0xe1, 0x20,},	// CMC_HighTemp_LumGain7_B
{0xe2, 0x20,},	// CMC_HighTemp_LumGain8_B   20 = x1.0

////////////////////
// Adaptive Gamma //
////////////////////

{0xe3, 0x00,},	// GMA_OUT
{0xe4, 0x03,},
{0xe5, 0x08,},
{0xe6, 0x0f,},
{0xe7, 0x15,},
{0xe8, 0x20,},
{0xe9, 0x2d,},
{0xea, 0x3b,},
{0xeb, 0x47,},
{0xec, 0x53,},
{0xed, 0x5c,},
{0xee, 0x65,},
{0xef, 0x6d,},
{0xf0, 0x75,},
{0xf1, 0x7c,},
{0xf2, 0x82,},
{0xf3, 0x88,},
{0xf4, 0x8d,},
{0xf5, 0x91,},
{0xf6, 0x96,},
{0xf7, 0x9a,},
{0xf8, 0xa1,},
{0xf9, 0xa9,},
{0xfa, 0xb0,},
{0xfb, 0xbe,},
{0xfc, 0xc8,},
{0xfd, 0xd2,},

{0x0e, 0x00,}, // burst end

{0x03, 0xd5,},	// Page d5

{0x0e, 0x01,}, // burst start

{0x10, 0xdb,},
{0x11, 0xe3,},
{0x12, 0xea,},
{0x13, 0xf0,},
{0x14, 0xf5,},
{0x15, 0xfb,},
{0x16, 0xff,},

{0x17, 0x00,},	//GMA_IN
{0x18, 0x03,},
{0x19, 0x08,},
{0x1a, 0x0f,},
{0x1b, 0x15,},
{0x1c, 0x20,},
{0x1d, 0x2d,},
{0x1e, 0x3b,},
{0x1f, 0x47,},
{0x20, 0x53,},
{0x21, 0x5c,},
{0x22, 0x65,},
{0x23, 0x6d,},
{0x24, 0x75,},
{0x25, 0x7c,},
{0x26, 0x82,},
{0x27, 0x88,},
{0x28, 0x8d,},
{0x29, 0x91,},
{0x2a, 0x96,},
{0x2b, 0x9a,},
{0x2c, 0xa1,},
{0x2d, 0xa9,},
{0x2e, 0xb0,},
{0x2f, 0xbe,},
{0x30, 0xc8,},
{0x31, 0xd2,},
{0x32, 0xdb,},
{0x33, 0xe3,},
{0x34, 0xea,},
{0x35, 0xf0,},
{0x36, 0xf5,},
{0x37, 0xfb,},
{0x38, 0xff,},

{0x39, 0x00,},	// GMA_D1
{0x3a, 0x06,},
{0x3b, 0x0e,},
{0x3c, 0x17,},
{0x3d, 0x1f,},
{0x3e, 0x2c,},
{0x3f, 0x3c,},
{0x40, 0x4c,},
{0x41, 0x57,},
{0x42, 0x61,},
{0x43, 0x6b,},
{0x44, 0x76,},
{0x45, 0x7e,},
{0x46, 0x85,},
{0x47, 0x8c,},
{0x48, 0x92,},
{0x49, 0x98,},
{0x4a, 0x9c,},
{0x4b, 0xa2,},
{0x4c, 0xa6,},
{0x4d, 0xab,},
{0x4e, 0xb4,},
{0x4f, 0xbc,},
{0x50, 0xc2,},
{0x51, 0xcb,},
{0x52, 0xd3,},
{0x53, 0xdb,},
{0x54, 0xe1,},
{0x55, 0xe7,},
{0x56, 0xed,},
{0x57, 0xf3,},
{0x58, 0xf8,},
{0x59, 0xfc,},
{0x5a, 0xff,},

{0x5b, 0x00,},	//GMA_D2
{0x5c, 0x08,},
{0x5d, 0x12,},
{0x5e, 0x1b,},
{0x5f, 0x24,},
{0x60, 0x32,},
{0x61, 0x3f,},
{0x62, 0x4c,},
{0x63, 0x57,},
{0x64, 0x61,},
{0x65, 0x6c,},
{0x66, 0x79,},
{0x67, 0x82,},
{0x68, 0x8c,},
{0x69, 0x94,},
{0x6a, 0x99,},
{0x6b, 0x9f,},
{0x6c, 0xa4,},
{0x6d, 0xaa,},
{0x6e, 0xaf,},
{0x6f, 0xb4,},
{0x70, 0xba,},
{0x71, 0xc0,},
{0x72, 0xc5,},
{0x73, 0xcd,},
{0x74, 0xd5,},
{0x75, 0xdc,},
{0x76, 0xe1,},
{0x77, 0xe7,},
{0x78, 0xed,},
{0x79, 0xf3,},
{0x7a, 0xf8,},
{0x7b, 0xfc,},
{0x7c, 0xff,},

///////////////////
// Adaptive MCMC //
///////////////////

// Outdoor MCMC
{0x7d, 0x15,}, //Outdoor_delta1
{0x7e, 0x19,}, //Outdoor_center1
{0x7f, 0x0f,}, //Outdoor_delta2
{0x80, 0x86,}, //Outdoor_center2
{0x81, 0x18,}, //Outdoor_delta3
{0x82, 0xb3,}, //Outdoor_center3
{0x83, 0x1b,}, //Outdoor_delta4
{0x84, 0xee,}, //Outdoor_center4
{0x85, 0x93,}, //Outdoor_delta5
{0x86, 0x25,}, //Outdoor_center5
{0x87, 0x93,}, //Outdoor_delta6
{0x88, 0x51,}, //Outdoor_center6
{0x89, 0x40,}, //Outdoor_sat_gain1
{0x8a, 0x40,}, //Outdoor_sat_gain2
{0x8b, 0x40,}, //Outdoor_sat_gain3
{0x8c, 0x40,}, //Outdoor_sat_gain4
{0x8d, 0x40,}, //Outdoor_sat_gain5
{0x8e, 0x40,}, //Outdoor_sat_gain6
{0x8f, 0x94,}, //Outdoor_hue_angle1
{0x90, 0x8c,}, //Outdoor_hue_angle2
{0x91, 0x0e,}, //Outdoor_hue_angle3
{0x92, 0x05,}, //Outdoor_hue_angle4
{0x93, 0x0b,}, //Outdoor_hue_angle5
{0x94, 0x87,}, //Outdoor_hue_angle6

{0x95, 0x00,},	// MCMC24_Outdoor  mcmc_rgb_ofs_sign_r
{0x96, 0x00,},	// MCMC25_Outdoor  mcmc_rgb_ofs_sign_g
{0x97, 0x00,},	// MCMC26_Outdoor  mcmc_rgb_ofs_sign_b

{0x98, 0x00,},	// MCMC27_Outdoor  mcmc_rgb_ofs_r1 R
{0x99, 0x00,},	// MCMC28_Outdoor  mcmc_rgb_ofs_r1 G
{0x9a, 0x00,},	// MCMC29_Outdoor  mcmc_rgb_ofs_r1 B

{0x9b, 0x00,},	// MCMC30_Outdoor  mcmc_rgb_ofs_r2 R
{0x9c, 0x00,},	// MCMC31_Outdoor  mcmc_rgb_ofs_r2 G
{0x9d, 0x00,},	// MCMC32_Outdoor  mcmc_rgb_ofs_r2 B

{0x9e, 0x00,},	// MCMC33_Outdoor  mcmc_rgb_ofs_r3 R
{0x9f, 0x00,},	// MCMC34_Outdoor  mcmc_rgb_ofs_r3 G
{0xa0, 0x00,},	// MCMC35_Outdoor  mcmc_rgb_ofs_r3 B

{0xa1, 0x00,},	// MCMC36_Outdoor  mcmc_rgb_ofs_r4 R
{0xa2, 0x00,},	// MCMC37_Outdoor  mcmc_rgb_ofs_r4 G
{0xa3, 0x00,},	// MCMC38_Outdoor  mcmc_rgb_ofs_r4 B

{0xa4, 0x00,},	// MCMC39_Outdoor  mcmc_rgb_ofs_r5 R
{0xa5, 0x00,},	// MCMC40_Outdoor  mcmc_rgb_ofs_r5 G
{0xa6, 0x00,},	// MCMC41_Outdoor  mcmc_rgb_ofs_r5 B

{0xa7, 0x00,},	// MCMC42_Outdoor  mcmc_rgb_ofs_r6 R
{0xa8, 0x00,},	// MCMC43_Outdoor  mcmc_rgb_ofs_r6 G
{0xa9, 0x00,},	// MCMC44_Outdoor  mcmc_rgb_ofs_r6 B

{0xaa, 0x00,},	// MCMC45_Outdoor  mcmc_std_offset1
{0xab, 0x00,},	// MCMC46_Outdoor  mcmc_std_offset2
{0xac, 0xff,},	// MCMC47_Outdoor  mcmc_std_th_max
{0xad, 0x00,},	// MCMC48_Outdoor  mcmc_std_th_min

{0xae, 0x3f,},	// MCMC49_Outdoor  mcmc_lum_gain_wgt_th1 R1 magenta
{0xaf, 0x3f,},	// MCMC50_Outdoor  mcmc_lum_gain_wgt_th2 R1
{0xb0, 0x3f,},	// MCMC51_Outdoor  mcmc_lum_gain_wgt_th3 R1
{0xb1, 0x3f,},	// MCMC52_Outdoor  mcmc_lum_gain_wgt_th4 R1
{0xb2, 0x30,},	// MCMC53_Outdoor  mcmc_rg1_lum_sp1      R1
{0xb3, 0x50,},	// MCMC54_Outdoor  mcmc_rg1_lum_sp2      R1
{0xb4, 0x80,},	// MCMC55_Outdoor  mcmc_rg1_lum_sp3      R1
{0xb5, 0xb0,},	// MCMC56_Outdoor  mcmc_rg1_lum_sp4      R1

{0xb6, 0x3f,},// MCMC57_Outdoor  mcmc_lum_gain_wgt_th1 R2 Skin
{0xb7, 0x3f,},// MCMC58_Outdoor  mcmc_lum_gain_wgt_th2 R2
{0xb8, 0x3f,},// MCMC59_Outdoor  mcmc_lum_gain_wgt_th3 R2
{0xb9, 0x3f,},// MCMC60_Outdoor  mcmc_lum_gain_wgt_th4 R2
{0xba, 0x28,},// MCMC61_Outdoor  mcmc_rg2_lum_sp1      R2
{0xbb, 0x50,},// MCMC62_Outdoor  mcmc_rg2_lum_sp2      R2
{0xbc, 0x80,},// MCMC63_Outdoor  mcmc_rg2_lum_sp3      R2
{0xbd, 0xb0,},// MCMC64_Outdoor  mcmc_rg2_lum_sp4      R2

{0xbe, 0x3f,},// MCMC65_Outdoor  mcmc_lum_gain_wgt_th1 R3 bright green1
{0xbf, 0x3f,},// MCMC66_Outdoor  mcmc_lum_gain_wgt_th2 R3
{0xc0, 0x30,},// MCMC67_Outdoor  mcmc_lum_gain_wgt_th3 R3
{0xc1, 0x2a,},// MCMC68_Outdoor  mcmc_lum_gain_wgt_th4 R3
{0xc2, 0x20,},// MCMC69_Outdoor  mcmc_rg3_lum_sp1      R3
{0xc3, 0x40,},// MCMC70_Outdoor  mcmc_rg3_lum_sp2      R3
{0xc4, 0x70,},// MCMC71_Outdoor  mcmc_rg3_lum_sp3      R3
{0xc5, 0xb0,},// MCMC72_Outdoor  mcmc_rg3_lum_sp4      R3

{0xc6, 0x3f,},// MCMC73_Outdoor  mcmc_lum_gain_wgt_th1 R4 dark Green2
{0xc7, 0x3f,},// MCMC74_Outdoor  mcmc_lum_gain_wgt_th2 R4
{0xc8, 0x3f,},// MCMC75_Outdoor  mcmc_lum_gain_wgt_th3 R4
{0xc9, 0x3f,},// MCMC76_Outdoor  mcmc_lum_gain_wgt_th4 R4
{0xca, 0x10,},// MCMC77_Outdoor  mcmc_rg4_lum_sp1      R4
{0xcb, 0x30,},// MCMC78_Outdoor  mcmc_rg4_lum_sp2      R4
{0xcc, 0x60,},// MCMC79_Outdoor  mcmc_rg4_lum_sp3      R4
{0xcd, 0x90,},// MCMC80_Outdoor  mcmc_rg4_lum_sp4      R4

{0xce, 0x3f,},	// MCMC81_Outdoor  mcmc_rg5_gain_wgt_th1 R5 Cyan
{0xcf, 0x3f,},	// MCMC82_Outdoor  mcmc_rg5_gain_wgt_th2 R5
{0xd0, 0x3f,},	// MCMC83_Outdoor  mcmc_rg5_gain_wgt_th3 R5
{0xd1, 0x3f,},	// MCMC84_Outdoor  mcmc_rg5_gain_wgt_th4 R5
{0xd2, 0x28,},	// MCMC85_Outdoor  mcmc_rg5_lum_sp1      R5
{0xd3, 0x50,},	// MCMC86_Outdoor  mcmc_rg5_lum_sp2      R5
{0xd4, 0x80,},	// MCMC87_Outdoor  mcmc_rg5_lum_sp3      R5
{0xd5, 0xb0,},	// MCMC88_Outdoor  mcmc_rg5_lum_sp4      R5

{0xd6, 0x3f,},	// MCMC89_Outdoor  mcmc_rg6_gain_wgt_th1 R6 Blue
{0xd7, 0x3f,},	// MCMC90_Outdoor  mcmc_rg6_gain_wgt_th2 R6
{0xd8, 0x3f,},	// MCMC91_Outdoor  mcmc_rg6_gain_wgt_th3 R6
{0xd9, 0x3f,},	// MCMC92_Outdoor  mcmc_rg6_gain_wgt_th4 R6
{0xda, 0x28,},	// MCMC93_Outdoor  mcmc_rg6_lum_sp1      R6
{0xdb, 0x50,},	// MCMC94_Outdoor  mcmc_rg6_lum_sp2      R6
{0xdc, 0x80,},	// MCMC95_Outdoor  mcmc_rg6_lum_sp3      R6
{0xdd, 0xb0,},	// MCMC96_Outdoor  mcmc_rg6_lum_sp4      R6

{0xde, 0x1e,},	// MCMC97_Outdoor  mcmc2_allgain_x1
{0xdf, 0x3c,},	// MCMC98_Outdoor  mcmc2_allgain_x2
{0xe0, 0x3c,},	// MCMC99_Outdoor  mcmc2_allgain_x4
{0xe1, 0x1e,},	// MCMC100_Outdoor mcmc2_allgain_x5
{0xe2, 0x1e,},	// MCMC101_Outdoor mcmc2_allgain_x7
{0xe3, 0x3c,},	// MCMC102_Outdoor mcmc2_allgain_x8
{0xe4, 0x3c,},	// MCMC103_Outdoor mcmc2_allgain_x10
{0xe5, 0x1e,},	// MCMC104_Outdoor mcmc2_allgain_x11

{0xe6, 0x16,}, //Outdoor_allgain_y0
{0xe7, 0x16,}, //Outdoor_allgain_y1
{0xe8, 0x16,}, //Outdoor_allgain_y2
{0xe9, 0x16,}, //Outdoor_allgain_y3
{0xea, 0x16,}, //Outdoor_allgain_y4
{0xeb, 0x15,}, //Outdoor_allgain_y5
{0xec, 0x19,}, //Outdoor_allgain_y6
{0xed, 0x19,}, //Outdoor_allgain_y7
{0xee, 0x18,}, //Outdoor_allgain_y8
{0xef, 0x17,}, //Outdoor_allgain_y9
{0xf0, 0x14,}, //Outdoor_allgain_y10
{0xf1, 0x14,}, //Outdoor_allgain_y11

// Indoor MCMC
{0xf2, 0x10,},//Indoor_delta1
{0xf3, 0x1e,},//Indoor_center1
{0xf4, 0x0b,},//Indoor_delta2
{0xf5, 0x6f,},//Indoor_center2
{0xf6, 0x1b,},//Indoor_delta3	light green
{0xf7, 0xc2,},//Indoor_center3	light green
{0xf8, 0x17,},//Indoor_delta4
{0xf9, 0xfb,},//Indoor_center4
{0xfa, 0x91,},//Indoor_delta5
{0xfb, 0x2b,},//Indoor_center5
{0xfc, 0x92,},//Indoor_delta6
{0xfd, 0x4f,},//Indoor_center6
{0x0e, 0x00,},// burst end

{0x03, 0xd6,},	// Page D6

{0x0e, 0x01,}, // burst start

{0x10, 0x40,}, //Indoor_sat_gain1
{0x11, 0x40,}, //Indoor_sat_gain2
{0x12, 0x40,}, //Indoor_sat_gain3
{0x13, 0x40,}, //Indoor_sat_gain4
{0x14, 0x40,}, //Indoor_sat_gain5
{0x15, 0x40,}, //Indoor_sat_gain6

{0x16, 0x00,}, //Indoor_hue_angle1
{0x17, 0x00,}, //Indoor_hue_angle2
{0x18, 0x1e,}, //Indoor_hue_angle3
{0x19, 0x0a,}, //Indoor_hue_angle4
{0x1a, 0x00,}, //Indoor_hue_angle5
{0x1b, 0x02,}, //Indoor_hue_angle6

{0x1c, 0x00,},	// MCMC24_Indoor   mcmc_rgb_ofs_sign_r
{0x1d, 0x00,},	// MCMC25_Indoor   mcmc_rgb_ofs_sign_g
{0x1e, 0x00,},	// MCMC26_Indoor   mcmc_rgb_ofs_sign_b

{0x1f, 0x00,},	// MCMC27_Indoor   mcmc_rgb_ofs_r1 R
{0x20, 0x00,},	// MCMC28_Indoor   mcmc_rgb_ofs_r1 G
{0x21, 0x00,},	// MCMC29_Indoor   mcmc_rgb_ofs_r1 B

{0x22, 0x00,},	// MCMC30_Indoor   mcmc_rgb_ofs_r2 R
{0x23, 0x00,},	// MCMC31_Indoor   mcmc_rgb_ofs_r2 G
{0x24, 0x00,},	// MCMC32_Indoor   mcmc_rgb_ofs_r2 B

{0x25, 0x00,},	// MCMC33_Indoor   mcmc_rgb_ofs_r3 R
{0x26, 0x00,},	// MCMC34_Indoor   mcmc_rgb_ofs_r3 G
{0x27, 0x00,},	// MCMC35_Indoor   mcmc_rgb_ofs_r3 B

{0x28, 0x00,},	// MCMC36_Indoor   mcmc_rgb_ofs_r4 R
{0x29, 0x00,},	// MCMC37_Indoor   mcmc_rgb_ofs_r4 G
{0x2a, 0x00,},	// MCMC38_Indoor   mcmc_rgb_ofs_r4 B

{0x2b, 0x00,},	// MCMC39_Indoor   mcmc_rgb_ofs_r5 R
{0x2c, 0x00,},	// MCMC40_Indoor   mcmc_rgb_ofs_r5 G
{0x2d, 0x00,},	// MCMC41_Indoor   mcmc_rgb_ofs_r5 B

{0x2e, 0x00,},	// MCMC42_Indoor  mcmc_rgb_ofs_r6 R
{0x2f, 0x00,},	// MCMC43_Indoor  mcmc_rgb_ofs_r6 G
{0x30, 0x00,},	// MCMC44_Indoor  mcmc_rgb_ofs_r6 B

{0x31, 0x00,},	// MCMC45_Indoor  mcmc_std_offset1
{0x32, 0x00,},	// MCMC46_Indoor  mcmc_std_offset2
{0x33, 0xff,},	// MCMC47_Indoor  mcmc_std_th_max
{0x34, 0x00,},	// MCMC48_Indoor  mcmc_std_th_min

{0x35, 0x10,},	// MCMC49_Indoor  mcmc_lum_gain_wgt_th1 R1 magenta
{0x36, 0x21,},	// MCMC50_Indoor  mcmc_lum_gain_wgt_th2 R1
{0x37, 0x34,},	// MCMC51_Indoor  mcmc_lum_gain_wgt_th3 R1
{0x38, 0x3f,},	// MCMC52_Indoor  mcmc_lum_gain_wgt_th4 R1
{0x39, 0x08,},	// MCMC53_Indoor  mcmc_rg1_lum_sp1      R1
{0x3a, 0x15,},	// MCMC54_Indoor  mcmc_rg1_lum_sp2      R1
{0x3b, 0x2f,},	// MCMC55_Indoor  mcmc_rg1_lum_sp3      R1
{0x3c, 0x51,},	// MCMC56_Indoor  mcmc_rg1_lum_sp4      R1

{0x3d, 0x3f,},	// MCMC57_Indoor  mcmc_lum_gain_wgt_th1 R2 red
{0x3e, 0x3f,},	// MCMC58_Indoor  mcmc_lum_gain_wgt_th2 R2
{0x3f, 0x3f,},	// MCMC59_Indoor  mcmc_lum_gain_wgt_th3 R2
{0x40, 0x3f,},	// MCMC60_Indoor  mcmc_lum_gain_wgt_th4 R2
{0x41, 0x28,},	// MCMC61_Indoor  mcmc_rg2_lum_sp1      R2
{0x42, 0x50,},	// MCMC62_Indoor  mcmc_rg2_lum_sp2      R2
{0x43, 0x80,},	// MCMC63_Indoor  mcmc_rg2_lum_sp3      R2
{0x44, 0xb0,},	// MCMC64_Indoor  mcmc_rg2_lum_sp4      R2

{0x45, 0x3f,},	// MCMC65_Indoor  mcmc_lum_gain_wgt_th1 R3 yellow
{0x46, 0x3f,},	// MCMC66_Indoor  mcmc_lum_gain_wgt_th2 R3
{0x47, 0x3f,},	// MCMC67_Indoor  mcmc_lum_gain_wgt_th3 R3
{0x48, 0x3f,},	// MCMC68_Indoor  mcmc_lum_gain_wgt_th4 R3
{0x49, 0x28,},	// MCMC69_Indoor  mcmc_rg3_lum_sp1      R3
{0x4a, 0x50,},	// MCMC70_Indoor  mcmc_rg3_lum_sp2      R3
{0x4b, 0x80,},	// MCMC71_Indoor  mcmc_rg3_lum_sp3      R3
{0x4c, 0xb0,},	// MCMC72_Indoor  mcmc_rg3_lum_sp4      R3

{0x4d, 0x3f,},	// MCMC73_Indoor  mcmc_lum_gain_wgt_th1 R4 Green
{0x4e, 0x3f,},	// MCMC74_Indoor  mcmc_lum_gain_wgt_th2 R4
{0x4f, 0x3f,},	// MCMC75_Indoor  mcmc_lum_gain_wgt_th3 R4
{0x50, 0x3f,},	// MCMC76_Indoor  mcmc_lum_gain_wgt_th4 R4
{0x51, 0x10,},	// MCMC77_Indoor  mcmc_rg4_lum_sp1      R4
{0x52, 0x30,},	// MCMC78_Indoor  mcmc_rg4_lum_sp2      R4
{0x53, 0x60,},	// MCMC79_Indoor  mcmc_rg4_lum_sp3      R4
{0x54, 0x90,},	// MCMC80_Indoor  mcmc_rg4_lum_sp4      R4

{0x55, 0x3f,},	// MCMC81_Indoor  mcmc_rg5_gain_wgt_th1 R5 Cyan
{0x56, 0x3f,},	// MCMC82_Indoor  mcmc_rg5_gain_wgt_th2 R5
{0x57, 0x3f,},	// MCMC83_Indoor  mcmc_rg5_gain_wgt_th3 R5
{0x58, 0x3f,},	// MCMC84_Indoor  mcmc_rg5_gain_wgt_th4 R5
{0x59, 0x28,},	// MCMC85_Indoor  mcmc_rg5_lum_sp1      R5
{0x5a, 0x50,},	// MCMC86_Indoor  mcmc_rg5_lum_sp2      R5
{0x5b, 0x80,},	// MCMC87_Indoor  mcmc_rg5_lum_sp3      R5
{0x5c, 0xb0,},	// MCMC88_Indoor  mcmc_rg5_lum_sp4      R5

{0x5d, 0x3f,},	// MCMC89_Indoor  mcmc_rg6_gain_wgt_th1 R6 Blue
{0x5e, 0x3f,},	// MCMC90_Indoor  mcmc_rg6_gain_wgt_th2 R6
{0x5f, 0x3f,},	// MCMC91_Indoor  mcmc_rg6_gain_wgt_th3 R6
{0x60, 0x3f,},	// MCMC92_Indoor  mcmc_rg6_gain_wgt_th4 R6
{0x61, 0x28,},	// MCMC93_Indoor  mcmc_rg6_lum_sp1      R6
{0x62, 0x50,},	// MCMC94_Indoor  mcmc_rg6_lum_sp2      R6
{0x63, 0x80,},	// MCMC95_Indoor  mcmc_rg6_lum_sp3      R6
{0x64, 0xb0,},	// MCMC96_Indoor  mcmc_rg6_lum_sp4      R6

{0x65, 0x1d,},	// MCMC97_Indoor  mcmc2_allgain_x1
{0x66, 0x3b,},	// MCMC98_Indoor  mcmc2_allgain_x2
{0x67, 0x3b,},	// MCMC99_Indoor  mcmc2_allgain_x4
{0x68, 0x1d,},	// MCMC100_Indoor mcmc2_allgain_x5
{0x69, 0x1d,},	// MCMC101_Indoor mcmc2_allgain_x7
{0x6a, 0x3b,},	// MCMC102_Indoor mcmc2_allgain_x8
{0x6b, 0x3b,},	// MCMC103_Indoor mcmc2_allgain_x10
{0x6c, 0x1d,},	// MCMC104_Indoor mcmc2_allgain_x11

{0x6d, 0x0e,},// MCMC105_Indoor mcmc2_allgain_y0
{0x6e, 0x0f,},// MCMC106_Indoor mcmc2_allgain_y1
{0x6f, 0x0f,},// MCMC107_Indoor mcmc2_allgain_y2
{0x70, 0x0f,},// MCMC108_Indoor mcmc2_allgain_y3
{0x71, 0x0f,},// MCMC109_Indoor mcmc2_allgain_y4
{0x72, 0x10,},// MCMC110_Indoor mcmc2_allgain_y5
{0x73, 0x10,},// MCMC111_Indoor mcmc2_allgain_y6
{0x74, 0x12,},// MCMC112_Indoor mcmc2_allgain_y7
{0x75, 0x12,},// MCMC113_Indoor mcmc2_allgain_y8
{0x76, 0x0f,},// MCMC114_Indoor mcmc2_allgain_y9
{0x77, 0x0e,},// MCMC115_Indoor mcmc2_allgain_y10
{0x78, 0x0d,},	// MCMC116_Indoor mcmc2_allgain_y11

// Dark1 MCMC
{0x79, 0x17,}, //Dark1_delta1
{0x7a, 0x56,}, //Dark1_center1
{0x7b, 0x10,}, //Dark1_delta2
{0x7c, 0x70,}, //Dark1_center2
{0x7d, 0x10,}, //Dark1_delta3
{0x7e, 0x9c,}, //Dark1_center3
{0x7f, 0x18,}, //Dark1_delta4
{0x80, 0xdb,}, //Dark1_center4
{0x81, 0x98,}, //Dark1_delta5
{0x82, 0x26,}, //Dark1_center5
{0x83, 0x99,}, //Dark1_delta6
{0x84, 0x5b,}, //Dark1_center6

{0x85, 0x40,}, //Dark1_sat_gain1
{0x86, 0x40,}, //Dark1_sat_gain2
{0x87, 0x40,}, //Dark1_sat_gain3
{0x88, 0x40,}, //Dark1_sat_gain4
{0x89, 0x40,}, //Dark1_sat_gain5
{0x8a, 0x40,}, //Dark1_sat_gain6
{0x8b, 0x91,}, //Dark1_hue_angle1
{0x8c, 0x00,}, //Dark1_hue_angle2
{0x8d, 0x00,}, //Dark1_hue_angle3
{0x8e, 0x0a,}, //Dark1_hue_angle4
{0x8f, 0x05,}, //Dark1_hue_angle5
{0x90, 0x86,}, //Dark1_hue_angle6

{0x91, 0x3f,},	// MCMC24_Dark1   mcmc_rgb_ofs_sign
{0x92, 0x3f,},	// MCMC25_Dark1   mcmc_rgb_ofs_sign
{0x93, 0x3f,},	// MCMC26_Dark1   mcmc_rgb_ofs_sign

{0x94, 0x00,},	// MCMC27_Dark1   mcmc_rgb_ofs_r1 R
{0x95, 0x00,},	// MCMC28_Dark1   mcmc_rgb_ofs_r1 G
{0x96, 0x00,},	// MCMC29_Dark1   mcmc_rgb_ofs_r1 B

{0x97, 0x00,},	// MCMC30_Dark1   mcmc_rgb_ofs_r2 R
{0x98, 0x00,},	// MCMC31_Dark1   mcmc_rgb_ofs_r2 G
{0x99, 0x00,},	// MCMC32_Dark1   mcmc_rgb_ofs_r2 B

{0x9a, 0x00,},	// MCMC33_Dark1   mcmc_rgb_ofs_r3 R
{0x9b, 0x00,},	// MCMC34_Dark1   mcmc_rgb_ofs_r3 G
{0x9c, 0x00,},	// MCMC35_Dark1   mcmc_rgb_ofs_r3 B

{0x9d, 0x00,},	// MCMC36_Dark1   mcmc_rgb_ofs_r4 R
{0x9e, 0x00,},	// MCMC37_Dark1   mcmc_rgb_ofs_r4 G
{0x9f, 0x00,},	// MCMC38_Dark1   mcmc_rgb_ofs_r4 B

{0xa0, 0x00,},	// MCMC39_Dark1   mcmc_rgb_ofs_r5 R
{0xa1, 0x00,},	// MCMC40_Dark1   mcmc_rgb_ofs_r5 G
{0xa2, 0x00,},	// MCMC41_Dark1   mcmc_rgb_ofs_r5 B

{0xa3, 0x00,},	// MCMC42_Dark1  mcmc_rgb_ofs_r6 R
{0xa4, 0x00,},	// MCMC43_Dark1  mcmc_rgb_ofs_r6 G
{0xa5, 0x00,},	// MCMC44_Dark1  mcmc_rgb_ofs_r6 B

{0xa6, 0x00,},	// MCMC45_Dark1  mcmc_std_offset1
{0xa7, 0x00,},	// MCMC46_Dark1  mcmc_std_offset2
{0xa8, 0xff,},	// MCMC47_Dark1  mcmc_std_th_max
{0xa9, 0x00,},	// MCMC48_Dark1  mcmc_std_th_min

{0xaa, 0x3f,},	// MCMC49_Dark1  mcmc_lum_gain_wgt R1
{0xab, 0x3f,},	// MCMC50_Dark1  mcmc_lum_gain_wgt R1
{0xac, 0x3f,},	// MCMC51_Dark1  mcmc_lum_gain_wgt R1
{0xad, 0x3f,},	// MCMC52_Dark1  mcmc_lum_gain_wgt R1
{0xae, 0x30,},	// MCMC53_Dark1  mcmc_rg1_lum_sp1  R1
{0xaf, 0x50,},	// MCMC54_Dark1  mcmc_rg1_lum_sp2  R1
{0xb0, 0x80,},	// MCMC55_Dark1  mcmc_rg1_lum_sp3  R1
{0xb1, 0xb0,},	// MCMC56_Dark1  mcmc_rg1_lum_sp4  R1

{0xb2, 0x3f,},	// MCMC57_Dark1  mcmc_lum_gain_wgt R2
{0xb3, 0x3f,},	// MCMC58_Dark1  mcmc_lum_gain_wgt R2
{0xb4, 0x3f,},	// MCMC59_Dark1  mcmc_lum_gain_wgt R2
{0xb5, 0x3f,},	// MCMC60_Dark1  mcmc_lum_gain_wgt R2
{0xb6, 0x28,},	// MCMC61_Dark1  mcmc_rg2_lum_sp1  R2
{0xb7, 0x50,},	// MCMC62_Dark1  mcmc_rg2_lum_sp2  R2
{0xb8, 0x80,},	// MCMC63_Dark1  mcmc_rg2_lum_sp3  R2
{0xb9, 0xb0,},	// MCMC64_Dark1  mcmc_rg2_lum_sp4  R2

{0xba, 0x3f,},	// MCMC65_Dark1  mcmc_lum_gain_wgt R3
{0xbb, 0x3f,},	// MCMC66_Dark1  mcmc_lum_gain_wgt R3
{0xbc, 0x3f,},	// MCMC67_Dark1  mcmc_lum_gain_wgt R3
{0xbd, 0x3f,},	// MCMC68_Dark1  mcmc_lum_gain_wgt R3
{0xbe, 0x28,},	// MCMC69_Dark1  mcmc_rg3_lum_sp1  R3
{0xbf, 0x50,},	// MCMC70_Dark1  mcmc_rg3_lum_sp2  R3
{0xc0, 0x80,},	// MCMC71_Dark1  mcmc_rg3_lum_sp3  R3
{0xc1, 0xb0,},	// MCMC72_Dark1  mcmc_rg3_lum_sp4  R3

{0xc2, 0x3f,},	// MCMC73_Dark1  mcmc_lum_gain_wgt R4
{0xc3, 0x3f,},	// MCMC74_Dark1  mcmc_lum_gain_wgt R4
{0xc4, 0x3f,},	// MCMC75_Dark1  mcmc_lum_gain_wgt R4
{0xc5, 0x3f,},	// MCMC76_Dark1  mcmc_lum_gain_wgt R4
{0xc6, 0x10,},	// MCMC77_Dark1  mcmc_rg4_lum_sp1  R4
{0xc7, 0x30,},	// MCMC78_Dark1  mcmc_rg4_lum_sp2  R4
{0xc8, 0x60,},	// MCMC79_Dark1  mcmc_rg4_lum_sp3  R4
{0xc9, 0x90,},	// MCMC80_Dark1  mcmc_rg4_lum_sp4  R4

{0xca, 0x3f,},	// MCMC81_Dark1  mcmc_rg5_gain_wgt R5
{0xcb, 0x3f,},	// MCMC82_Dark1  mcmc_rg5_gain_wgt R5
{0xcc, 0x3f,},	// MCMC83_Dark1  mcmc_rg5_gain_wgt R5
{0xcd, 0x3f,},	// MCMC84_Dark1  mcmc_rg5_gain_wgt R5
{0xce, 0x28,},	// MCMC85_Dark1  mcmc_rg5_lum_sp1  R5
{0xcf, 0x50,},	// MCMC86_Dark1  mcmc_rg5_lum_sp2  R5
{0xd0, 0x80,},	// MCMC87_Dark1  mcmc_rg5_lum_sp3  R5
{0xd1, 0xb0,},	// MCMC88_Dark1  mcmc_rg5_lum_sp4  R5

{0xd2, 0x3f,},	// MCMC89_Dark1  mcmc_rg6_gain_wgt R6
{0xd3, 0x3f,},	// MCMC90_Dark1  mcmc_rg6_gain_wgt R6
{0xd4, 0x3f,},	// MCMC91_Dark1  mcmc_rg6_gain_wgt R6
{0xd5, 0x3f,},	// MCMC92_Dark1  mcmc_rg6_gain_wgt R6
{0xd6, 0x28,},	// MCMC93_Dark1  mcmc_rg6_lum_sp1  R6
{0xd7, 0x50,},	// MCMC94_Dark1  mcmc_rg6_lum_sp2  R6
{0xd8, 0x80,},	// MCMC95_Dark1  mcmc_rg6_lum_sp3  R6
{0xd9, 0xb0,},	// MCMC96_Dark1  mcmc_rg6_lum_sp4  R6

{0xda, 0x1c,},	// MCMC97_Dark1  mcmc2_allgain_x1
{0xdb, 0x3a,},	// MCMC98_Dark1  mcmc2_allgain_x2
{0xdc, 0x3a,},	// MCMC99_Dark1  mcmc2_allgain_x4
{0xdd, 0x1c,},	// MCMC100_Dark1 mcmc2_allgain_x5
{0xde, 0x1c,},	// MCMC101_Dark1 mcmc2_allgain_x7
{0xdf, 0x3a,},	// MCMC102_Dark1 mcmc2_allgain_x8
{0xe0, 0x3a,},	// MCMC103_Dark1 mcmc2_allgain_x10
{0xe1, 0x1c,},	// MCMC104_Dark1 mcmc2_allgain_x11

{0xe2, 0x0f,},//Dark1_allgain_y1
{0xe3, 0x10,},//Dark1_allgain_y2
{0xe4, 0x10,},//Dark1_allgain_y3
{0xe5, 0x11,},//Dark1_allgain_y4
{0xe6, 0x10,},//Dark1_allgain_y5
{0xe7, 0x13,},//Dark1_allgain_y6
{0xe8, 0x12,},//Dark1_allgain_y7
{0xe9, 0x12,},//Dark1_allgain_y8
{0xea, 0x12,},//Dark1_allgain_y9
{0xeb, 0x11,},//Dark1_allgain_y10
{0xec, 0x10,},//Dark1_allgain_y11
{0xed, 0x0f,},//Dark1_allgain_y12

// Dark2 MCMC
{0xee, 0x17,},	// MCMC00_Dark2   mcmc_delta1
{0xef, 0x56,},	// MCMC01_Dark2   mcmc_center1
{0xf0, 0x10,},	// MCMC02_Dark2   mcmc_delta2
{0xf1, 0x70,},	// MCMC03_Dark2   mcmc_center2
{0xf2, 0x10,},	// MCMC04_Dark2   mcmc_delta3
{0xf3, 0x9c,},	// MCMC05_Dark2   mcmc_center3
{0xf4, 0x18,},	// MCMC06_Dark2   mcmc_delta4
{0xf5, 0xdb,},	// MCMC07_Dark2   mcmc_center4
{0xf6, 0x98,},	// MCMC08_Dark2   mcmc_delta5
{0xf7, 0x26,},	// MCMC09_Dark2   mcmc_center5
{0xf8, 0x99,},	// MCMC10_Dark2   mcmc_delta6
{0xf9, 0x5b,},	// MCMC11_Dark2   mcmc_center6

{0xfa, 0x40,},	// MCMC12_Dark2   mcmc_sat_gain1
{0xfb, 0x40,},	// MCMC13_Dark2   mcmc_sat_gain2
{0xfc, 0x40,},	// MCMC14_Dark2   mcmc_sat_gain3
{0xfd, 0x40,},	// MCMC15_Dark2   mcmc_sat_gain4
{0x0e, 0x00,}, // burst end

{0x03, 0xd7,},// Page D7

{0x0e, 0x01,}, // burst start

{0x10, 0x40,},// MCMC16_Dark2   mcmc_sat_gain5
{0x11, 0x40,},// MCMC17_Dark2   mcmc_sat_gain6
{0x12, 0x91,},// MCMC18_Dark2   mcmc_hue_angle1
{0x13, 0x00,},// MCMC19_Dark2   mcmc_hue_angle2
{0x14, 0x00,},// MCMC20_Dark2   mcmc_hue_angle3
{0x15, 0x0a,},// MCMC21_Dark2   mcmc_hue_angle4
{0x16, 0x0f,},// MCMC22_Dark2   mcmc_hue_angle5
{0x17, 0x05,},// MCMC23_Dark2   mcmc_hue_angle6

{0x18, 0x2f,},	// MCMC24_Dark2   mcmc_rgb_ofs_sig
{0x19, 0x2f,},	// MCMC25_Dark2   mcmc_rgb_ofs_sig
{0x1a, 0x2f,},	// MCMC26_Dark2   mcmc_rgb_ofs_sig

{0x1b, 0x00,},	// MCMC27_Dark2   mcmc_rgb_ofs_r1
{0x1c, 0x00,},	// MCMC28_Dark2   mcmc_rgb_ofs_r1
{0x1d, 0x00,},	// MCMC29_Dark2   mcmc_rgb_ofs_r1

{0x1e, 0x00,},	// MCMC30_Dark2   mcmc_rgb_ofs_r2
{0x1f, 0x00,},	// MCMC31_Dark2   mcmc_rgb_ofs_r2
{0x20, 0x00,},	// MCMC32_Dark2   mcmc_rgb_ofs_r2

{0x21, 0x00,},	// MCMC33_Dark2   mcmc_rgb_ofs_r3
{0x22, 0x00,},	// MCMC34_Dark2   mcmc_rgb_ofs_r3
{0x23, 0x00,},	// MCMC35_Dark2   mcmc_rgb_ofs_r3

{0x24, 0x00,},	// MCMC36_Dark2   mcmc_rgb_ofs_r4
{0x25, 0x00,},	// MCMC37_Dark2   mcmc_rgb_ofs_r4
{0x26, 0x00,},	// MCMC38_Dark2   mcmc_rgb_ofs_r4

{0x27, 0x00,},	// MCMC39_Dark2   mcmc_rgb_ofs_r5
{0x28, 0x00,},	// MCMC40_Dark2   mcmc_rgb_ofs_r5
{0x29, 0x00,},	// MCMC41_Dark2   mcmc_rgb_ofs_r5

{0x2a, 0x00,},	// MCMC42_Dark2  mcmc_rgb_ofs_r6 R
{0x2b, 0x00,},	// MCMC43_Dark2  mcmc_rgb_ofs_r6 G
{0x2c, 0x00,},	// MCMC44_Dark2  mcmc_rgb_ofs_r6 B

{0x2d, 0x00,},	// MCMC45_Dark2  mcmc_std_offset1
{0x2e, 0x00,},	// MCMC46_Dark2  mcmc_std_offset2
{0x2f, 0xff,},	// MCMC47_Dark2  mcmc_std_th_max
{0x30, 0x00,},	// MCMC48_Dark2  mcmc_std_th_min

{0x31, 0x3f,},	// MCMC49_Dark2  mcmc_lum_gain_wgt R1
{0x32, 0x3f,},	// MCMC50_Dark2  mcmc_lum_gain_wgt R1
{0x33, 0x3f,},	// MCMC51_Dark2  mcmc_lum_gain_wgt R1
{0x34, 0x3f,},	// MCMC52_Dark2  mcmc_lum_gain_wgt R1
{0x35, 0x30,},	// MCMC53_Dark2  mcmc_rg1_lum_sp1  R1
{0x36, 0x50,},	// MCMC54_Dark2  mcmc_rg1_lum_sp2  R1
{0x37, 0x80,},	// MCMC55_Dark2  mcmc_rg1_lum_sp3  R1
{0x38, 0xb0,},	// MCMC56_Dark2  mcmc_rg1_lum_sp4  R1

{0x39, 0x3f,},	// MCMC57_Dark2  mcmc_lum_gain_wgt R2
{0x3a, 0x3f,},	// MCMC58_Dark2  mcmc_lum_gain_wgt R2
{0x3b, 0x3f,},	// MCMC59_Dark2  mcmc_lum_gain_wgt R2
{0x3c, 0x3f,},	// MCMC60_Dark2  mcmc_lum_gain_wgt R2
{0x3d, 0x28,},	// MCMC61_Dark2  mcmc_rg2_lum_sp1  R2
{0x3e, 0x50,},	// MCMC62_Dark2  mcmc_rg2_lum_sp2  R2
{0x3f, 0x80,},	// MCMC63_Dark2  mcmc_rg2_lum_sp3  R2
{0x40, 0xb0,},	// MCMC64_Dark2  mcmc_rg2_lum_sp4  R2

{0x41, 0x3f,},	// MCMC65_Dark2  mcmc_lum_gain_wgt R3
{0x42, 0x3f,},	// MCMC66_Dark2  mcmc_lum_gain_wgt R3
{0x43, 0x3f,},	// MCMC67_Dark2  mcmc_lum_gain_wgt R3
{0x44, 0x3f,},	// MCMC68_Dark2  mcmc_lum_gain_wgt R3
{0x45, 0x28,},	// MCMC69_Dark2  mcmc_rg3_lum_sp1  R3
{0x46, 0x50,},	// MCMC70_Dark2  mcmc_rg3_lum_sp2  R3
{0x47, 0x80,},	// MCMC71_Dark2  mcmc_rg3_lum_sp3  R3
{0x48, 0xb0,},	// MCMC72_Dark2  mcmc_rg3_lum_sp4  R3

{0x49, 0x1a,},	// MCMC73_Dark2  mcmc_lum_gain_wgt R4
{0x4a, 0x28,},	// MCMC74_Dark2  mcmc_lum_gain_wgt R4
{0x4b, 0x3f,},	// MCMC75_Dark2  mcmc_lum_gain_wgt R4
{0x4c, 0x3f,},	// MCMC76_Dark2  mcmc_lum_gain_wgt R4
{0x4d, 0x10,},	// MCMC77_Dark2  mcmc_rg4_lum_sp1  R4
{0x4e, 0x30,},	// MCMC78_Dark2  mcmc_rg4_lum_sp2  R4
{0x4f, 0x60,},	// MCMC79_Dark2  mcmc_rg4_lum_sp3  R4
{0x50, 0x90,},	// MCMC80_Dark2  mcmc_rg4_lum_sp4  R4

{0x51, 0x1a,},	// MCMC81_Dark2  mcmc_rg5_gain_wgt R5
{0x52, 0x28,},	// MCMC82_Dark2  mcmc_rg5_gain_wgt R5
{0x53, 0x3f,},	// MCMC83_Dark2  mcmc_rg5_gain_wgt R5
{0x54, 0x3f,},	// MCMC84_Dark2  mcmc_rg5_gain_wgt R5
{0x55, 0x28,},	// MCMC85_Dark2  mcmc_rg5_lum_sp1  R5
{0x56, 0x50,},	// MCMC86_Dark2  mcmc_rg5_lum_sp2  R5
{0x57, 0x80,},	// MCMC87_Dark2  mcmc_rg5_lum_sp3  R5
{0x58, 0xb0,},	// MCMC88_Dark2  mcmc_rg5_lum_sp4  R5

{0x59, 0x1a,},	// MCMC89_Dark2  mcmc_rg6_gain_wgt R6
{0x5a, 0x28,},	// MCMC90_Dark2  mcmc_rg6_gain_wgt R6
{0x5b, 0x3f,},	// MCMC91_Dark2  mcmc_rg6_gain_wgt R6
{0x5c, 0x3f,},	// MCMC92_Dark2  mcmc_rg6_gain_wgt R6
{0x5d, 0x28,},	// MCMC93_Dark2  mcmc_rg6_lum_sp1  R6
{0x5e, 0x50,},	// MCMC94_Dark2  mcmc_rg6_lum_sp2  R6
{0x5f, 0x80,},	// MCMC95_Dark2  mcmc_rg6_lum_sp3  R6
{0x60, 0xb0,},	// MCMC96_Dark2  mcmc_rg6_lum_sp4  R6

{0x61, 0x1b,},	// MCMC97_Dark2  mcmc2_allgain_x1
{0x62, 0x39,},	// MCMC98_Dark2  mcmc2_allgain_x2
{0x63, 0x39,},	// MCMC99_Dark2  mcmc2_allgain_x4
{0x64, 0x1b,},	// MCMC100_Dark2 mcmc2_allgain_x5
{0x65, 0x1b,},	// MCMC101_Dark2 mcmc2_allgain_x7
{0x66, 0x39,},	// MCMC102_Dark2 mcmc2_allgain_x8
{0x67, 0x39,},	// MCMC103_Dark2 mcmc2_allgain_x10
{0x68, 0x1b,},	// MCMC104_Dark2 mcmc2_allgain_x11

{0x69, 0x0f,},// MCMC105_Dark2 mcmc2_allgain_y0
{0x6a, 0x10,},// MCMC106_Dark2 mcmc2_allgain_y1
{0x6b, 0x10,},// MCMC107_Dark2 mcmc2_allgain_y2
{0x6c, 0x11,},// MCMC108_Dark2 mcmc2_allgain_y3
{0x6d, 0x10,},// MCMC109_Dark2 mcmc2_allgain_y4
{0x6e, 0x13,},// MCMC110_Dark2 mcmc2_allgain_y5
{0x6f, 0x12,},// MCMC111_Dark2 mcmc2_allgain_y6
{0x70, 0x12,},// MCMC112_Dark2 mcmc2_allgain_y7
{0x71, 0x12,},// MCMC113_Dark2 mcmc2_allgain_y8
{0x72, 0x11,},// MCMC114_Dark2 mcmc2_allgain_y9
{0x73, 0x10,},// MCMC115_Dark2 mcmc2_allgain_y10
{0x74, 0x0f,},// MCMC116_Dark2 mcmc2_allgain_y11

// LowTemp MCMC
{0x75, 0x10,},	// MCMC00_LowTemp   mcmc_delta1
{0x76, 0x39,},	// MCMC01_LowTemp   mcmc_center1
{0x77, 0x10,},	// MCMC02_LowTemp   mcmc_delta2
{0x78, 0x59,},	// MCMC03_LowTemp   mcmc_center2
{0x79, 0x12,},	// MCMC04_LowTemp   mcmc_delta3
{0x7a, 0x9d,},	// MCMC05_LowTemp   mcmc_center3
{0x7b, 0x12,},	// MCMC06_LowTemp   mcmc_delta4
{0x7c, 0xc1,},	// MCMC07_LowTemp   mcmc_center4
{0x7d, 0x18,},	// MCMC08_LowTemp   mcmc_delta5
{0x7e, 0xeb,},	// MCMC09_LowTemp   mcmc_center5
{0x7f, 0x99,},	// MCMC10_LowTemp   mcmc_delta6
{0x80, 0x1c,},	// MCMC11_LowTemp   mcmc_center6

{0x81, 0x40,},	// MCMC12_LowTemp   mcmc_sat_gain1
{0x82, 0x40,},	// MCMC13_LowTemp   mcmc_sat_gain2
{0x83, 0x40,},	// MCMC14_LowTemp   mcmc_sat_gain3
{0x84, 0x40,},	// MCMC15_LowTemp   mcmc_sat_gain4
{0x85, 0x40,},	// MCMC16_LowTemp   mcmc_sat_gain5
{0x86, 0x40,},	// MCMC17_LowTemp   mcmc_sat_gain6
{0x87, 0x00,},	// MCMC18_LowTemp   mcmc_hue_angle1
{0x88, 0x00,},	// MCMC19_LowTemp   mcmc_hue_angle2
{0x89, 0x00,},	// MCMC20_LowTemp   mcmc_hue_angle3
{0x8a, 0x00,},	// MCMC21_LowTemp   mcmc_hue_angle4
{0x8b, 0x00,},	// MCMC22_LowTemp   mcmc_hue_angle5
{0x8c, 0x00,},	// MCMC23_LowTemp   mcmc_hue_angle6

{0x8d, 0x1f,},	// MCMC24_LowTemp   mcmc_rgb_ofs_sig
{0x8e, 0x1f,},	// MCMC25_LowTemp   mcmc_rgb_ofs_sig
{0x8f, 0x1f,},	// MCMC26_LowTemp   mcmc_rgb_ofs_sig

{0x90, 0x00,},	// MCMC27_LowTemp   mcmc_rgb_ofs_r1
{0x91, 0x00,},	// MCMC28_LowTemp   mcmc_rgb_ofs_r1
{0x92, 0x00,},	// MCMC29_LowTemp   mcmc_rgb_ofs_r1

{0x93, 0x00,},	// MCMC30_LowTemp   mcmc_rgb_ofs_r2
{0x94, 0x00,},	// MCMC31_LowTemp   mcmc_rgb_ofs_r2
{0x95, 0x00,},	// MCMC32_LowTemp   mcmc_rgb_ofs_r2

{0x96, 0x00,},	// MCMC33_LowTemp   mcmc_rgb_ofs_r3
{0x97, 0x00,},	// MCMC34_LowTemp   mcmc_rgb_ofs_r3
{0x98, 0x00,},	// MCMC35_LowTemp   mcmc_rgb_ofs_r3

{0x99, 0x00,},	// MCMC36_LowTemp   mcmc_rgb_ofs_r4
{0x9a, 0x00,},	// MCMC37_LowTemp   mcmc_rgb_ofs_r4
{0x9b, 0x00,},	// MCMC38_LowTemp   mcmc_rgb_ofs_r4

{0x9c, 0x00,},	// MCMC39_LowTemp   mcmc_rgb_ofs_r5
{0x9d, 0x00,},	// MCMC40_LowTemp   mcmc_rgb_ofs_r5
{0x9e, 0x00,},	// MCMC41_LowTemp   mcmc_rgb_ofs_r5

{0x9f, 0x00,},	// MCMC42_LowTemp  mcmc_rgb_ofs_r6 R
{0xa0, 0x00,},	// MCMC43_LowTemp  mcmc_rgb_ofs_r6 G
{0xa1, 0x00,},	// MCMC44_LowTemp  mcmc_rgb_ofs_r6 B

{0xa2, 0x00,},	// MCMC45_LowTemp  mcmc_std_offset1
{0xa3, 0x00,},	// MCMC46_LowTemp  mcmc_std_offset2
{0xa4, 0xff,},	// MCMC47_LowTemp  mcmc_std_th_max
{0xa5, 0x00,},	// MCMC48_LowTemp  mcmc_std_th_min

{0xa6, 0x3f,},	// MCMC49_LowTemp  mcmc_lum_gain_wgt R1
{0xa7, 0x3f,},	// MCMC50_LowTemp  mcmc_lum_gain_wgt R1
{0xa8, 0x3f,},	// MCMC51_LowTemp  mcmc_lum_gain_wgt R1
{0xa9, 0x3f,},	// MCMC52_LowTemp  mcmc_lum_gain_wgt R1
{0xaa, 0x30,},	// MCMC53_LowTemp  mcmc_rg1_lum_sp1  R1
{0xab, 0x50,},	// MCMC54_LowTemp  mcmc_rg1_lum_sp2  R1
{0xac, 0x80,},	// MCMC55_LowTemp  mcmc_rg1_lum_sp3  R1
{0xad, 0xb0,},	// MCMC56_LowTemp  mcmc_rg1_lum_sp4  R1

{0xae, 0x3f,},	// MCMC57_LowTemp  mcmc_lum_gain_wgt R2
{0xaf, 0x3f,},	// MCMC58_LowTemp  mcmc_lum_gain_wgt R2
{0xb0, 0x3f,},	// MCMC59_LowTemp  mcmc_lum_gain_wgt R2
{0xb1, 0x3f,},	// MCMC60_LowTemp  mcmc_lum_gain_wgt R2
{0xb2, 0x28,},	// MCMC61_LowTemp  mcmc_rg2_lum_sp1  R2
{0xb3, 0x50,},	// MCMC62_LowTemp  mcmc_rg2_lum_sp2  R2
{0xb4, 0x80,},	// MCMC63_LowTemp  mcmc_rg2_lum_sp3  R2
{0xb5, 0xb0,},	// MCMC64_LowTemp  mcmc_rg2_lum_sp4  R2

{0xb6, 0x3f,},	// MCMC65_LowTemp  mcmc_lum_gain_wgt R3
{0xb7, 0x3f,},	// MCMC66_LowTemp  mcmc_lum_gain_wgt R3
{0xb8, 0x3f,},	// MCMC67_LowTemp  mcmc_lum_gain_wgt R3
{0xb9, 0x3f,},	// MCMC68_LowTemp  mcmc_lum_gain_wgt R3
{0xba, 0x28,},	// MCMC69_LowTemp  mcmc_rg3_lum_sp1  R3
{0xbb, 0x50,},	// MCMC70_LowTemp  mcmc_rg3_lum_sp2  R3
{0xbc, 0x80,},	// MCMC71_LowTemp  mcmc_rg3_lum_sp3  R3
{0xbd, 0xb0,},	// MCMC72_LowTemp  mcmc_rg3_lum_sp4  R3

{0xbe, 0x3f,},	// MCMC73_LowTemp  mcmc_lum_gain_wgt R4
{0xbf, 0x3f,},	// MCMC74_LowTemp  mcmc_lum_gain_wgt R4
{0xc0, 0x3f,},	// MCMC75_LowTemp  mcmc_lum_gain_wgt R4
{0xc1, 0x3f,},	// MCMC76_LowTemp  mcmc_lum_gain_wgt R4
{0xc2, 0x10,},	// MCMC77_LowTemp  mcmc_rg4_lum_sp1  R4
{0xc3, 0x30,},	// MCMC78_LowTemp  mcmc_rg4_lum_sp2  R4
{0xc4, 0x60,},	// MCMC79_LowTemp  mcmc_rg4_lum_sp3  R4
{0xc5, 0x90,},	// MCMC80_LowTemp  mcmc_rg4_lum_sp4  R4

{0xc6, 0x3f,},	// MCMC81_LowTemp  mcmc_rg5_gain_wgt R5
{0xc7, 0x3f,},	// MCMC82_LowTemp  mcmc_rg5_gain_wgt R5
{0xc8, 0x3f,},	// MCMC83_LowTemp  mcmc_rg5_gain_wgt R5
{0xc9, 0x3f,},	// MCMC84_LowTemp  mcmc_rg5_gain_wgt R5
{0xca, 0x28,},	// MCMC85_LowTemp  mcmc_rg5_lum_sp1  R5
{0xcb, 0x50,},	// MCMC86_LowTemp  mcmc_rg5_lum_sp2  R5
{0xcc, 0x80,},	// MCMC87_LowTemp  mcmc_rg5_lum_sp3  R5
{0xcd, 0xb0,},	// MCMC88_LowTemp  mcmc_rg5_lum_sp4  R5

{0xce, 0x3f,},	// MCMC89_LowTemp  mcmc_rg6_gain_wgt R6
{0xcf, 0x3f,},	// MCMC90_LowTemp  mcmc_rg6_gain_wgt R6
{0xd0, 0x3f,},	// MCMC91_LowTemp  mcmc_rg6_gain_wgt R6
{0xd1, 0x3f,},	// MCMC92_LowTemp  mcmc_rg6_gain_wgt R6
{0xd2, 0x28,},	// MCMC93_LowTemp  mcmc_rg6_lum_sp1  R6
{0xd3, 0x50,},	// MCMC94_LowTemp  mcmc_rg6_lum_sp2  R6
{0xd4, 0x80,},	// MCMC95_LowTemp  mcmc_rg6_lum_sp3  R6
{0xd5, 0xb0,},	// MCMC96_LowTemp  mcmc_rg6_lum_sp4  R6

{0xd6, 0x1a,},	// MCMC97_LowTemp  mcmc2_allgain_x1
{0xd7, 0x38,},	// MCMC98_LowTemp  mcmc2_allgain_x2
{0xd8, 0x38,},	// MCMC99_LowTemp  mcmc2_allgain_x4
{0xd9, 0x1a,},	// MCMC100_LowTemp mcmc2_allgain_x5
{0xda, 0x1a,},	// MCMC101_LowTemp mcmc2_allgain_x7
{0xdb, 0x38,},	// MCMC102_LowTemp mcmc2_allgain_x8
{0xdc, 0x38,},	// MCMC103_LowTemp mcmc2_allgain_x10
{0xdd, 0x1a,},	// MCMC104_LowTemp mcmc2_allgain_x11

{0xde, 0x10,},	// MCMC105_LowTemp mcmc2_allgain_y0
{0xdf, 0x0f,},	// MCMC106_LowTemp mcmc2_allgain_y1
{0xe0, 0x0e,},	// MCMC107_LowTemp mcmc2_allgain_y2
{0xe1, 0x0e,},	// MCMC108_LowTemp mcmc2_allgain_y3
{0xe2, 0x12,},	// MCMC109_LowTemp mcmc2_allgain_y4
{0xe3, 0x16,},	// MCMC110_LowTemp mcmc2_allgain_y5
{0xe4, 0x16,},	// MCMC111_LowTemp mcmc2_allgain_y6
{0xe5, 0x14,},	// MCMC112_LowTemp mcmc2_allgain_y
{0xe6, 0x12,},	// MCMC113_LowTemp mcmc2_allgain_y8
{0xe7, 0x10,},	// MCMC114_LowTemp mcmc2_allgain_y9
{0xe8, 0x10,},	// MCMC115_LowTemp mcmc2_allgain_y10
{0xe9, 0x10,},	// MCMC116_LowTemp mcmc2_allgain_y11
{0x0e, 0x00,}, // burst end

// HighTemp MCMC
{0x03, 0xd7,}, //Page d7
{0xea, 0x10,}, //Hi-Temp_delta1
{0xeb, 0x39,}, //Hi-Temp_center1
{0xec, 0x10,}, //Hi-Temp_delta2
{0xed, 0x59,}, //Hi-Temp_center2
{0xee, 0x12,}, //Hi-Temp_delta3
{0xef, 0x9d,}, //Hi-Temp_center3
{0xf0, 0x12,}, //Hi-Temp_delta4
{0xf1, 0xbd,}, //Hi-Temp_center4
{0xf2, 0x1e,}, //Hi-Temp_delta5
{0xf3, 0xf1,}, //Hi-Temp_center5
{0xf4, 0x9e,}, //Hi-Temp_delta6
{0xf5, 0x34,}, //Hi-Temp_center6
{0xf6, 0x40,}, //Hi-Temp_sat_gain1
{0xf7, 0x40,}, //Hi-Temp_sat_gain2
{0xf8, 0x40,}, //Hi-Temp_sat_gain3
{0xf9, 0x40,}, //Hi-Temp_sat_gain4
{0xfa, 0x40,}, //Hi-Temp_sat_gain5
{0xfb, 0x40,}, //Hi-Temp_sat_gain6
{0xfc, 0x00,}, //Hi-Temp_hue_angle1
{0xfd, 0x00,}, //Hi-Temp_hue_angle2

{0x03, 0xd8,}, //Page d8
{0x0e, 0x01,}, // burst start

{0x10, 0x00,}, //Hi-Temp_hue_angle3
{0x11, 0x00,}, //Hi-Temp_hue_angle4
{0x12, 0x06,}, //Hi-Temp_hue_angle5
{0x13, 0x00,}, //Hi-Temp_hue_angle6
{0x14, 0x11,}, //Hi-Temp_rgb_ofs_sign_r
{0x15, 0x11,}, //Hi-Temp_rgb_ofs_sign_g
{0x16, 0x11,}, //Hi-Temp_rgb_ofs_sign_b
{0x17, 0x00,}, //Hi-Temp_rgb_ofs_scl_r1
{0x18, 0x00,}, //Hi-Temp_rgb_ofs_scl_g1
{0x19, 0x00,}, //Hi-Temp_rgb_ofs_scl_b1
{0x1a, 0x00,}, //Hi-Temp_rgb_ofs_scl_r2
{0x1b, 0x00,}, //Hi-Temp_rgb_ofs_scl_g2
{0x1c, 0x00,}, //Hi-Temp_rgb_ofs_scl_b2
{0x1d, 0x00,}, //Hi-Temp_rgb_ofs_scl_r3
{0x1e, 0x00,}, //Hi-Temp_rgb_ofs_scl_g3
{0x1f, 0x00,}, //Hi-Temp_rgb_ofs_scl_b3
{0x20, 0x00,}, //Hi-Temp_rgb_ofs_scl_r4
{0x21, 0x00,}, //Hi-Temp_rgb_ofs_scl_g4
{0x22, 0x00,}, //Hi-Temp_rgb_ofs_scl_b4
{0x23, 0x00,}, //Hi-Temp_rgb_ofs_scl_r5
{0x24, 0x00,}, //Hi-Temp_rgb_ofs_scl_g5
{0x25, 0x00,}, //Hi-Temp_rgb_ofs_scl_b5
{0x26, 0x00,}, //Hi-Temp_rgb_ofs_scl_r6
{0x27, 0x00,}, //Hi-Temp_rgb_ofs_scl_g6
{0x28, 0x00,}, //Hi-Temp_rgb_ofs_scl_b6
{0x29, 0x00,}, //Hi-Temp_std_offset1
{0x2a, 0x00,}, //Hi-Temp_std_offset2
{0x2b, 0xff,}, //Hi-Temp_std_th_max
{0x2c, 0x00,}, //Hi-Temp_std_th_min
{0x2d, 0x3f,}, //Hi-Temp_rg1_lum_gain_wgt_th1
{0x2e, 0x3f,}, //Hi-Temp_rg1_lum_gain_wgt_th2
{0x2f, 0x3f,}, //Hi-Temp_rg1_lum_gain_wgt_th3
{0x30, 0x3f,}, //Hi-Temp_rg1_lum_gain_wgt_th4
{0x31, 0x30,}, //Hi-Temp_rg1_lum_sp1
{0x32, 0x50,}, //Hi-Temp_rg1_lum_sp2
{0x33, 0x80,}, //Hi-Temp_rg1_lum_sp3
{0x34, 0xb0,}, //Hi-Temp_rg1_lum_sp4
{0x35, 0x3f,}, //Hi-Temp_rg2_gain_wgt_th1
{0x36, 0x3f,}, //Hi-Temp_rg2_gain_wgt_th2
{0x37, 0x3f,}, //Hi-Temp_rg2_gain_wgt_th3
{0x38, 0x3f,}, //Hi-Temp_rg2_gain_wgt_th4
{0x39, 0x28,}, //Hi-Temp_rg2_lum_sp1
{0x3a, 0x50,}, //Hi-Temp_rg2_lum_sp2
{0x3b, 0x80,}, //Hi-Temp_rg2_lum_sp3
{0x3c, 0xb0,}, //Hi-Temp_rg2_lum_sp4
{0x3d, 0x3f,}, //Hi-Temp_rg3_gain_wgt_th1
{0x3e, 0x3f,}, //Hi-Temp_rg3_gain_wgt_th2
{0x3f, 0x3f,}, //Hi-Temp_rg3_gain_wgt_th3
{0x40, 0x3f,}, //Hi-Temp_rg3_gain_wgt_th4
{0x41, 0x28,}, //Hi-Temp_rg3_lum_sp1
{0x42, 0x50,}, //Hi-Temp_rg3_lum_sp2
{0x43, 0x80,}, //Hi-Temp_rg3_lum_sp3
{0x44, 0xb0,}, //Hi-Temp_rg3_lum_sp4

{0x45, 0x3f,}, //Hi-Temp_rg4_gain_wgt_th1
{0x46, 0x3f,}, //Hi-Temp_rg4_gain_wgt_th2
{0x47, 0x3f,}, //Hi-Temp_rg4_gain_wgt_th3
{0x48, 0x3f,}, //Hi-Temp_rg4_gain_wgt_th4
{0x49, 0x10,}, //Hi-Temp_rg4_lum_sp1
{0x4a, 0x30,}, //Hi-Temp_rg4_lum_sp2
{0x4b, 0x60,}, //Hi-Temp_rg4_lum_sp3
{0x4c, 0x90,}, //Hi-Temp_rg4_lum_sp4

{0x4d, 0x3f,}, //Hi-Temp_rg5_gain_wgt_th1
{0x4e, 0x3f,}, //Hi-Temp_rg5_gain_wgt_th2
{0x4f, 0x3f,}, //Hi-Temp_rg5_gain_wgt_th3
{0x50, 0x3f,}, //Hi-Temp_rg5_gain_wgt_th4
{0x51, 0x28,}, //Hi-Temp_rg5_lum_sp1
{0x52, 0x50,}, //Hi-Temp_rg5_lum_sp2
{0x53, 0x80,}, //Hi-Temp_rg5_lum_sp3
{0x54, 0xb0,}, //Hi-Temp_rg5_lum_sp4

{0x55, 0x3f,}, //Hi-Temp_rg6_gain_wgt_th1
{0x56, 0x3f,}, //Hi-Temp_rg6_gain_wgt_th2
{0x57, 0x3f,}, //Hi-Temp_rg6_gain_wgt_th3
{0x58, 0x3f,}, //Hi-Temp_rg6_gain_wgt_th4
{0x59, 0x28,}, //Hi-Temp_rg6_lum_sp1
{0x5a, 0x50,}, //Hi-Temp_rg6_lum_sp2
{0x5b, 0x80,}, //Hi-Temp_rg6_lum_sp3
{0x5c, 0xb0,}, //Hi-Temp_rg6_lum_sp4

{0x5d, 0x19,}, //Hi-Temp_allgain_x1
{0x5e, 0x37,}, //Hi-Temp_allgain_x2
{0x5f, 0x37,}, //Hi-Temp_allgain_x3
{0x60, 0x19,}, //Hi-Temp_allgain_x4
{0x61, 0x19,}, //Hi-Temp_allgain_x5
{0x62, 0x37,}, //Hi-Temp_allgain_x6
{0x63, 0x37,}, //Hi-Temp_allgain_x7
{0x64, 0x19,}, //Hi-Temp_allgain_x8

{0x65, 0x0e,},//Hi-Temp_allgain_y0
{0x66, 0x0d,},//Hi-Temp_allgain_y1
{0x67, 0x0e,},//Hi-Temp_allgain_y2
{0x68, 0x0e,},//Hi-Temp_allgain_y3
{0x69, 0x0f,},//Hi-Temp_allgain_y4
{0x6a, 0x10,},//Hi-Temp_allgain_y5
{0x6b, 0x12,},//Hi-Temp_allgain_y6
{0x6c, 0x14,},//Hi-Temp_allgain_y7
{0x6d, 0x13,},//Hi-Temp_allgain_y8
{0x6e, 0x12,},//Hi-Temp_allgain_y9
{0x6f, 0x0e,},//Hi-Temp_allgain_y10
{0x70, 0x11,},//Hi-Temp_allgain_y11

{0x0e, 0x00,}, // burst end

{0x03, 0xD3,},
{0x11, 0xFE,},	// function block on
{0x10, 0x8F,},	// Adaptive on

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

///////////////////////////////////////////////////////////////////////////////
// DE ~ E0 Page (DMA Outdoor)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xde,}, //DMA DE Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0x77,}, //Outdoor 1111 add 720p
{0x14, 0x14,},
{0x15, 0x00,}, //Outdoor 1114 add 720p
{0x16, 0x15,},
{0x17, 0x81,}, //Outdoor 1115 add 720p
{0x18, 0x16,},
{0x19, 0x04,}, //Outdoor 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x58,}, //Outdoor 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x30,}, //Outdoor 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x12,}, //Outdoor 1119 add 720p
{0x20, 0x37,},
{0x21, 0x00,}, //Outdoor 1137
{0x22, 0x38,},
{0x23, 0x00,}, //Outdoor 1138
{0x24, 0x39,},
{0x25, 0x00,}, //Outdoor 1139
{0x26, 0x3a,},
{0x27, 0x00,}, //Outdoor 113a
{0x28, 0x3b,},
{0x29, 0x00,}, //Outdoor 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Outdoor 113c
{0x2c, 0x3d,},
{0x2d, 0x00,}, //Outdoor 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Outdoor 113e
{0x30, 0x3f,},
{0x31, 0x00,}, //Outdoor 113f
{0x32, 0x40,},
{0x33, 0x00,}, //Outdoor 1140
{0x34, 0x41,},
{0x35, 0x00,}, //Outdoor 1141
{0x36, 0x42,},
{0x37, 0x00,}, //Outdoor 1142
{0x38, 0x43,},
{0x39, 0x00,}, //Outdoor 1143
{0x3a, 0x49,},
{0x3b, 0x06,}, //Outdoor 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x0a,}, //Outdoor 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x12,}, //Outdoor 114b add 720p
{0x40, 0x4c,},
{0x41, 0x1c,}, //Outdoor 114c add 720p
{0x42, 0x4d,},
{0x43, 0x24,}, //Outdoor 114d add 720p
{0x44, 0x4e,},
{0x45, 0x40,}, //Outdoor 114e add 720p
{0x46, 0x4f,},
{0x47, 0x80,}, //Outdoor 114f add 720p
{0x48, 0x50,},
{0x49, 0x36,},//Outdoor 1150
{0x4a, 0x51,},
{0x4b, 0x38,},//Outdoor 1151
{0x4c, 0x52,},
{0x4d, 0x3c,},//Outdoor 1152
{0x4e, 0x53,},
{0x4f, 0x3f,},//Outdoor 1153
{0x50, 0x54,},
{0x51, 0x3f,},//Outdoor 1154
{0x52, 0x55,},
{0x53, 0x3f,},//Outdoor 1155
{0x54, 0x56,},
{0x55, 0x3f,},//Outdoor 1156
{0x56, 0x57,},
{0x57, 0x3f,},//Outdoor 1157
{0x58, 0x58,},
{0x59, 0x3f,}, //Outdoor 1158
{0x5a, 0x59,},
{0x5b, 0x3f,}, //Outdoor 1159
{0x5c, 0x5a,},
{0x5d, 0x3e,}, //Outdoor 115a
{0x5e, 0x5b,},
{0x5f, 0x3a,}, //Outdoor 115b
{0x60, 0x5c,},
{0x61, 0x37,}, //Outdoor 115c
{0x62, 0x5d,},
{0x63, 0x34,}, //Outdoor 115d
{0x64, 0x5e,},
{0x65, 0x32,}, //Outdoor 115e
{0x66, 0x5f,},
{0x67, 0x30,}, //Outdoor 115f
{0x68, 0x6e,},
{0x69, 0x18,},//Outdoor 116e
{0x6a, 0x6f,},
{0x6b, 0x18,},//Outdoor 116f
{0x6c, 0x77,},
{0x6d, 0x32,},//Outdoor 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x31,},//Outdoor 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x23,},//Outdoor 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x1b,},//Outdoor 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x1c,},//Outdoor 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x1a,},//Outdoor 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x19,},//Outdoor 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x17,},//Outdoor 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x26,},//Outdoor 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x25,},//Outdoor 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x21,},//Outdoor 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x1e,},//Outdoor 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x1a,}, //Outdoor 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x1a,}, //Outdoor 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x1a,}, //Outdoor 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x1a,}, //Outdoor 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x1a,}, //Outdoor 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x16,}, //Outdoor 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x16,}, //Outdoor 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x15,}, //Outdoor 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x17,}, //Outdoor 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x17,}, //Outdoor 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x17,}, //Outdoor 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x16,}, //Outdoor 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x16,}, //Outdoor 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x20,}, //Outdoor 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x23,}, //Outdoor 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x21,}, //Outdoor 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x21,}, //Outdoor 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x20,}, //Outdoor 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x1b,}, //Outdoor 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x18,}, //Outdoor 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x2b,}, //Outdoor 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x2b,}, //Outdoor 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x2b,}, //Outdoor 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x2b,}, //Outdoor 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x2b,}, //Outdoor 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x2c,}, //Outdoor 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x31,}, //Outdoor 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x35,}, //Outdoor 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x22,}, //Outdoor 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x22,}, //Outdoor 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x21,}, //Outdoor 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x1e,}, //Outdoor 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x1c,}, //Outdoor 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x1a,},//Outdoor 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x30,},//Outdoor 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x30,},//Outdoor 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x30,},//Outdoor 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x33,},//Outdoor 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x38,},//Outdoor 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x33,},//Outdoor 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x2d,},//Outdoor 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x2a,}, //Outdoor 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x15,},//Outdoor 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x3f,}, //Outdoor 11d1
{0xde, 0xd2,},
{0xdf, 0x40,}, //Outdoor 11d2
{0xe0, 0xd3,},
{0xe1, 0xff,}, //Outdoor 11d3
{0xe2, 0xd4,},
{0xe3, 0x01,}, //Outdoor 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x0a,}, //Outdoor 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x01,}, //Outdoor 11d6
{0xe8, 0xd7,},
{0xe9, 0x10,},//Outdoor 11d7
{0xea, 0xd8,},
{0xeb, 0x01,}, //Outdoor 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x06,}, //Outdoor 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x01,}, //Outdoor 11da
{0xf0, 0xdb,},
{0xf1, 0x07,},//Outdoor 11db
{0xf2, 0xdf,},
{0xf3, 0x33,},//Outdoor 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x3a,},//Outdoor 11e0
{0xf6, 0xe1,},
{0xf7, 0x7a,},//Outdoor 11e1
{0xf8, 0xe2,},
{0xf9, 0x3a,},//Outdoor 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xa0,}, //Outdoor 11e3
{0xfc, 0xe4,},
{0xfd, 0x01,}, //Outdoor 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xdf,}, //DMA DF Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x20,},//Outdoor 11e5
{0x12, 0xe6,},
{0x13, 0x01,}, //Outdoor 11e6
{0x14, 0xe7,},
{0x15, 0x1a,},//Outdoor 11e7
{0x16, 0xe8,},
{0x17, 0x01,}, //Outdoor 11e8
{0x18, 0xe9,},
{0x19, 0x10,}, //Outdoor 11e9
{0x1a, 0xea,},
{0x1b, 0x01,}, //Outdoor 11ea
{0x1c, 0xeb,},
{0x1d, 0x12,}, //Outdoor 11eb
{0x1e, 0xef,},
{0x1f, 0x22,},//Outdoor 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,},//12 Page
{0x22, 0x12,},
{0x23, 0x30,},//Outdoor 1212
{0x24, 0x33,},
{0x25, 0x30,},//Outdoor 1233 add 20130603 Skin_th
{0x26, 0x34,},
{0x27, 0x21,},//Outdoor 1234 add 20130603 Cyan_th
{0x28, 0x40,},
{0x29, 0x37,},//Outdoor 1240 add 720p
{0x2a, 0x70,},
{0x2b, 0x9f,},//Outdoor 1270 // Bayer Sharpness ENB add 720p
{0x2c, 0x71,},
{0x2d, 0x1a,},//Outdoor 1271 //Bayer HPF Gain
{0x2e, 0x72,},
{0x2f, 0x16,},//Outdoor 1272 //Bayer LPF Gain
{0x30, 0x77,},
{0x31, 0x36,},//Outdoor 1277
{0x32, 0x78,},
{0x33, 0x2f,},//Outdoor 1278
{0x34, 0x79,},
{0x35, 0x09,},//Outdoor 1279
{0x36, 0x7a,},
{0x37, 0x50,},//Outdoor 127a
{0x38, 0x7b,},
{0x39, 0x10,},//Outdoor 127b
{0x3a, 0x7c,},
{0x3b, 0x50,},//Outdoor 127c //skin HPF gain
{0x3c, 0x7d,},
{0x3d, 0x10,},//Outdoor 127d
{0x3e, 0x7f,},
{0x3f, 0x50,},//Outdoor 127f
{0x40, 0x87,},
{0x41, 0x3f,},//Outdoor 1287 add 720p
{0x42, 0x88,},
{0x43, 0x3f,},//Outdoor 1288 add 720p
{0x44, 0x89,},
{0x45, 0x3f,},//Outdoor 1289 add 720p
{0x46, 0x8a,},
{0x47, 0x3f,},//Outdoor 128a add 720p
{0x48, 0x8b,},
{0x49, 0x3f,},//Outdoor 128b add 720p
{0x4a, 0x8c,},
{0x4b, 0x3f,},//Outdoor 128c add 720p
{0x4c, 0x8d,},
{0x4d, 0x3f,},//Outdoor 128d add 720p
{0x4e, 0x8e,},
{0x4f, 0x3f,},//Outdoor 128e add 720p
{0x50, 0x8f,},
{0x51, 0x3f,},//Outdoor 128f add 720p
{0x52, 0x90,},
{0x53, 0x3f,},//Outdoor 1290 add 720p
{0x54, 0x91,},
{0x55, 0x3f,},//Outdoor 1291 add 720p
{0x56, 0x92,},
{0x57, 0x3f,},//Outdoor 1292 add 720p
{0x58, 0x93,},
{0x59, 0x3f,},//Outdoor 1293 add 720p
{0x5a, 0x94,},
{0x5b, 0x3f,},//Outdoor 1294 add 720p
{0x5c, 0x95,},
{0x5d, 0x3f,},//Outdoor 1295 add 720p
{0x5e, 0x96,},
{0x5f, 0x3f,},//Outdoor 1296 add 720p
{0x60, 0xae,},
{0x61, 0x7f,},//Outdoor 12ae
{0x62, 0xaf,},
{0x63, 0x63,},//Outdoor 12af // B[7:4]Blue/B[3:0]Skin
{0x64, 0xc0,},
{0x65, 0x23,},//Outdoor 12c0 // CI-LPF ENB add 720p
{0x66, 0xc3,},
{0x67, 0x3c,},//Outdoor 12c3 add 720p
{0x68, 0xc4,},
{0x69, 0x1a,},//Outdoor 12c4 add 720p
{0x6a, 0xc5,},
{0x6b, 0x0c,},//Outdoor 12c5 add 720p
{0x6c, 0xc6,},
{0x6d, 0x91,},//Outdoor 12c6
{0x6e, 0xc7,},
{0x6f, 0xa4,},//Outdoor 12c7
{0x70, 0xc8,},
{0x71, 0x3c,},//Outdoor 12c8
{0x72, 0xd0,},
{0x73, 0x08,},//Outdoor 12d0 add 720p
{0x74, 0xd1,},
{0x75, 0x10,},//Outdoor 12d1 add 720p
{0x76, 0xd2,},
{0x77, 0x18,},//Outdoor 12d2 add 720p
{0x78, 0xd3,},
{0x79, 0x20,},//Outdoor 12d3 add 720p
{0x7a, 0xd4,},
{0x7b, 0x30,},//Outdoor 12d4 add 720p
{0x7c, 0xd5,},
{0x7d, 0x60,},//Outdoor 12d5 add 720p
{0x7e, 0xd6,},
{0x7f, 0x80,},//Outdoor 12d6 add 720p
{0x80, 0xd7,},
{0x81, 0x3f,},//Outdoor 12d7
{0x82, 0xd8,},
{0x83, 0x3f,},//Outdoor 12d8
{0x84, 0xd9,},
{0x85, 0x3f,},//Outdoor 12d9
{0x86, 0xda,},
{0x87, 0x3f,},//Outdoor 12da
{0x88, 0xdb,},
{0x89, 0x3f,},//Outdoor 12db
{0x8a, 0xdc,},
{0x8b, 0x3f,},//Outdoor 12dc
{0x8c, 0xdd,},
{0x8d, 0x3f,},//Outdoor 12dd
{0x8e, 0xde,},
{0x8f, 0x3f,},//Outdoor 12de
{0x90, 0xe0,},
{0x91, 0x49,},//Outdoor 12e0 // 20121120 ln dy
{0x92, 0xe1,},
{0x93, 0xfc,},//Outdoor 12e1
{0x94, 0xe2,},
{0x95, 0x02,},//Outdoor 12e2
{0x96, 0xe3,},
{0x97, 0x20,},//Outdoor 12e3 //PS LN graph Y1
{0x98, 0xe4,},
{0x99, 0x20,},//Outdoor 12e4 //PS LN graph Y2
{0x9a, 0xe5,},
{0x9b, 0x20,},//Outdoor 12e5 //PS LN graph Y3
{0x9c, 0xe6,},
{0x9d, 0x20,},//Outdoor 12e6 //PS LN graph Y4
{0x9e, 0xe7,},
{0x9f, 0x20,},//Outdoor 12e7 //PS LN graph Y5
{0xa0, 0xe8,},
{0xa1, 0x20,},//Outdoor 12e8 //PS LN graph Y6
{0xa2, 0xe9,},
{0xa3, 0x20,},//Outdoor 12e9 //PS DY graph Y1
{0xa4, 0xea,},
{0xa5, 0x20,},//Outdoor 12ea //PS DY graph Y2
{0xa6, 0xeb,},
{0xa7, 0x18,},//Outdoor 12eb //PS DY graph Y3
{0xa8, 0xec,},
{0xa9, 0x1e,},//Outdoor 12ec //PS DY graph Y4
{0xaa, 0xed,},
{0xab, 0x1d,},//Outdoor 12ed //PS DY graph Y5
{0xac, 0xee,},
{0xad, 0x20,},//Outdoor 12ee //PS DY graph Y6
{0xae, 0xf0,},
{0xaf, 0x00,},//Outdoor 12f0
{0xb0, 0xf1,},
{0xb1, 0x2a,},//Outdoor 12f1
{0xb2, 0xf2,},
{0xb3, 0x32,},//Outdoor 12f2
{0xb4, 0x03,},
{0xb5, 0x13,},//13 Page
{0xb6, 0x10,},
{0xb7, 0x81,},//Outdoor 1310 //Y-NR ENB add  720p
{0xb8, 0x30,},
{0xb9, 0x3f,},//Outdoor 1330
{0xba, 0x31,},
{0xbb, 0x3f,},//Outdoor 1331
{0xbc, 0x32,},
{0xbd, 0x3f,},//Outdoor 1332
{0xbe, 0x33,},
{0xbf, 0x3f,},//Outdoor 1333
{0xc0, 0x34,},
{0xc1, 0x3f,},//Outdoor 1334
{0xc2, 0x35,},
{0xc3, 0x33,},//Outdoor 1335
{0xc4, 0x36,},
{0xc5, 0x2f,},//Outdoor 1336
{0xc6, 0x37,},
{0xc7, 0x2e,},//Outdoor 1337
{0xc8, 0x38,},
{0xc9, 0x02,},//Outdoor 1338
{0xca, 0x40,},
{0xcb, 0x1e,},//Outdoor 1340
{0xcc, 0x41,},
{0xcd, 0x22,},//Outdoor 1341
{0xce, 0x42,},
{0xcf, 0x62,},//Outdoor 1342
{0xd0, 0x43,},
{0xd1, 0x63,},//Outdoor 1343
{0xd2, 0x44,},
{0xd3, 0xff,},//Outdoor 1344
{0xd4, 0x45,},
{0xd5, 0x04,},//Outdoor 1345
{0xd6, 0x46,},
{0xd7, 0x36,},//Outdoor 1346
{0xd8, 0x47,},
{0xd9, 0x05,},//Outdoor 1347
{0xda, 0x48,},
{0xdb, 0x20,},//Outdoor 1348
{0xdc, 0x49,},
{0xdd, 0x02,},//Outdoor 1349
{0xde, 0x4a,},
{0xdf, 0x22,},//Outdoor 134a
{0xe0, 0x4b,},
{0xe1, 0x06,},//Outdoor 134b
{0xe2, 0x4c,},
{0xe3, 0x20,},//Outdoor 134c
{0xe4, 0x83,},
{0xe5, 0x08,},//Outdoor 1383
{0xe6, 0x84,},
{0xe7, 0x08,},//Outdoor 1384
{0xe8, 0xb7,},
{0xe9, 0xfd,},//Outdoor 13b7
{0xea, 0xb8,},
{0xeb, 0xa7,},//Outdoor 13b8
{0xec, 0xb9,},
{0xed, 0xfe,},//Outdoor 13b9 //20121217 DC R1,2 CR
{0xee, 0xba,},
{0xef, 0xca,},//Outdoor 13ba //20121217 DC R3,4 CR
{0xf0, 0xbd,},
{0xf1, 0x78,},//Outdoor 13bd //20121121 c-filter LumHL DC rate
{0xf2, 0xc5,},
{0xf3, 0x01,},//Outdoor 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xf4, 0xc6,},
{0xf5, 0x22,},//Outdoor 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf6, 0xc7,},
{0xf7, 0x33,},//Outdoor 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf8, 0x03,},
{0xf9, 0x14,},//14 page
{0xfa, 0x10,},
{0xfb, 0xb3,},//Outdoor 1410
{0xfc, 0x11,},
{0xfd, 0xd8,},//Outdoor 1411

{0x0e, 0x00,}, // burst end

{0x03, 0xe0,}, //DMA E0 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x12,},
{0x11, 0x10,},//Outdoor 1412
{0x12, 0x13,},
{0x13, 0x03,},//Outdoor 1413
{0x14, 0x14,},
{0x15, 0x0f,},//Outdoor 1414 //YC2D Low Gain B[5:0]
{0x16, 0x15,},
{0x17, 0x7b,},//Outdoor 1415 // Y Hi filter mask 1/16
{0x18, 0x16,},
{0x19, 0x1c,},//Outdoor 1416 //YC2D Hi Gain B[5:0]
{0x1a, 0x17,},
{0x1b, 0x40,},//Outdoor 1417
{0x1c, 0x18,},
{0x1d, 0x0c,},//Outdoor 1418
{0x1e, 0x19,},
{0x1f, 0x0c,},//Outdoor 1419
{0x20, 0x1a,},
{0x21, 0x18,},//Outdoor 141a //YC2D Post STD gain Pos
{0x22, 0x1b,},
{0x23, 0x1d,},//Outdoor 141b //YC2D Post STD gain Neg
{0x24, 0x27,},
{0x25, 0x2c,},//Outdoor 1427 //YC2D SP Lum Gain Pos1
{0x26, 0x28,},
{0x27, 0x2a,},//Outdoor 1428 //YC2D SP Lum Gain Pos2
{0x28, 0x29,},
{0x29, 0x28,},//Outdoor 1429 //YC2D SP Lum Gain Pos3
{0x2a, 0x2a,},
{0x2b, 0x1e,},//Outdoor 142a //YC2D SP Lum Gain Pos4
{0x2c, 0x2b,},
{0x2d, 0x14,},//Outdoor 142b //YC2D SP Lum Gain Pos5
{0x2e, 0x2c,},
{0x2f, 0x14,},//Outdoor 142c //YC2D SP Lum Gain Pos6
{0x30, 0x2d,},
{0x31, 0x16,},//Outdoor 142d //YC2D SP Lum Gain Pos7
{0x32, 0x2e,},
{0x33, 0x16,},//Outdoor 142e //YC2D SP Lum Gain Pos8
{0x34, 0x30,},
{0x35, 0x28,},//Outdoor 1430 //YC2D SP Lum Gain Neg1
{0x36, 0x31,},
{0x37, 0x26,},//Outdoor 1431 //YC2D SP Lum Gain Neg2
{0x38, 0x32,},
{0x39, 0x23,},//Outdoor 1432 //YC2D SP Lum Gain Neg3
{0x3a, 0x33,},
{0x3b, 0x19,},//Outdoor 1433 //YC2D SP Lum Gain Neg4
{0x3c, 0x34,},
{0x3d, 0x16,},//Outdoor 1434 //YC2D SP Lum Gain Neg5
{0x3e, 0x35,},
{0x3f, 0x15,},//Outdoor 1435 //YC2D SP Lum Gain Neg6
{0x40, 0x36,},
{0x41, 0x17,},//Outdoor 1436 //YC2D SP Lum Gain Neg7
{0x42, 0x37,},
{0x43, 0x19,},//Outdoor 1437 //YC2D SP Lum Gain Neg8
{0x44, 0x47,},
{0x45, 0x24,},//Outdoor 1447 //YC2D SP Dy Gain Pos1
{0x46, 0x48,},
{0x47, 0x22,},//Outdoor 1448 //YC2D SP Dy Gain Pos2
{0x48, 0x49,},
{0x49, 0x24,},//Outdoor 1449 //YC2D SP Dy Gain Pos3
{0x4a, 0x4a,},
{0x4b, 0x1a,},//Outdoor 144a //YC2D SP Dy Gain Pos4
{0x4c, 0x4b,},
{0x4d, 0x14,},//Outdoor 144b //YC2D SP Dy Gain Pos5
{0x4e, 0x4c,},
{0x4f, 0x10,},//Outdoor 144c //YC2D SP Dy Gain Pos6
{0x50, 0x4d,},
{0x51, 0x18,},//Outdoor 144d //YC2D SP Dy Gain Pos7
{0x52, 0x4e,},
{0x53, 0x18,},//Outdoor 144e //YC2D SP Dy Gain Pos8
{0x54, 0x50,},
{0x55, 0x18,},//Outdoor 1450 //YC2D SP Dy Gain Neg1
{0x56, 0x51,},
{0x57, 0x18,},//Outdoor 1451 //YC2D SP Dy Gain Neg2
{0x58, 0x52,},
{0x59, 0x1a,},//Outdoor 1452 //YC2D SP Dy Gain Neg3
{0x5a, 0x53,},
{0x5b, 0x18,},//Outdoor 1453 //YC2D SP Dy Gain Neg4
{0x5c, 0x54,},
{0x5d, 0x15,},//Outdoor 1454 //YC2D SP Dy Gain Neg5
{0x5e, 0x55,},
{0x5f, 0x18,},//Outdoor 1455 //YC2D SP Dy Gain Neg6
{0x60, 0x56,},
{0x61, 0x22,},//Outdoor 1456 //YC2D SP Dy Gain Neg7
{0x62, 0x57,},
{0x63, 0x23,},//Outdoor 1457 //YC2D SP Dy Gain Neg8
{0x64, 0x67,},
{0x65, 0x24,},//Outdoor 1467 //YC2D SP Edge Gain1
{0x66, 0x68,},
{0x67, 0x24,},//Outdoor 1468 //YC2D SP Edge Gain2
{0x68, 0x69,},
{0x69, 0x28,},//Outdoor 1469 //YC2D SP Edge Gain3
{0x6a, 0x6a,},
{0x6b, 0x2e,},//Outdoor 146a //YC2D SP Edge Gain4
{0x6c, 0x6b,},
{0x6d, 0x2f,},//Outdoor 146b //YC2D SP Edge Gain5
{0x6e, 0x6c,},
{0x6f, 0x2f,},//Outdoor 146c //YC2D SP Edge Gain6
{0x70, 0x6d,},
{0x71, 0x2f,},//Outdoor 146d //YC2D SP Edge Gain7
{0x72, 0x6e,},
{0x73, 0x28,},//Outdoor 146e //YC2D SP Edge Gain8
{0x74, 0x87,},
{0x75, 0x27,},//Outdoor 1487 //YC2D SP STD Gain1
{0x76, 0x88,},
{0x77, 0x28,},//Outdoor 1488 //YC2D SP STD Gain2
{0x78, 0x89,},
{0x79, 0x2d,},//Outdoor 1489 //YC2D SP STD Gain3
{0x7a, 0x8a,},
{0x7b, 0x2f,},//Outdoor 148a //YC2D SP STD Gain4
{0x7c, 0x8b,},
{0x7d, 0x34,},//Outdoor 148b //YC2D SP STD Gain5
{0x7e, 0x8c,},
{0x7f, 0x2d,},//Outdoor 148c //YC2D SP STD Gain6
{0x80, 0x8d,},
{0x81, 0x26,},//Outdoor 148d //YC2D SP STD Gain7
{0x82, 0x8e,},
{0x83, 0x24,},//Outdoor 148e //YC2D SP STD Gain8
{0x84, 0x97,},
{0x85, 0x3f,},//Outdoor 1497 add 720p
{0x86, 0x98,},
{0x87, 0x3f,},//Outdoor 1498 add 720p
{0x88, 0x99,},
{0x89, 0x3f,},//Outdoor 1499 add 720p
{0x8a, 0x9a,},
{0x8b, 0x3f,},//Outdoor 149a add 720p
{0x8c, 0x9b,},
{0x8d, 0x3f,},//Outdoor 149b add 720p
{0x8e, 0xa0,},
{0x8f, 0x3f,},//Outdoor 14a0 add 720p
{0x90, 0xa1,},
{0x91, 0x3f,},//Outdoor 14a1 add 720p
{0x92, 0xa2,},
{0x93, 0x3f,},//Outdoor 14a2 add 720p
{0x94, 0xa3,},
{0x95, 0x3f,},//Outdoor 14a3 add 720p
{0x96, 0xa4,},
{0x97, 0x3f,},//Outdoor 14a4 add 720p
{0x98, 0xc9,},
{0x99, 0x13,},//Outdoor 14c9
{0x9a, 0xca,},
{0x9b, 0x3f,},//Outdoor 14ca
{0x9c, 0x03,},
{0x9d, 0x1a,},//1A page
{0x9e, 0x10,},
{0x9f, 0x15,},//Outdoor 1A10 add 720p
{0xa0, 0x18,},
{0xa1, 0x3f,},//Outdoor 1A18
{0xa2, 0x19,},
{0xa3, 0x3f,},//Outdoor 1A19
{0xa4, 0x1a,},
{0xa5, 0x3f,},//Outdoor 1A1a
{0xa6, 0x1b,},
{0xa7, 0x3f,},//Outdoor 1A1b
{0xa8, 0x1c,},
{0xa9, 0x3f,},//Outdoor 1A1c
{0xaa, 0x1d,},
{0xab, 0x3c,},//Outdoor 1A1d
{0xac, 0x1e,},
{0xad, 0x38,},//Outdoor 1A1e
{0xae, 0x1f,},
{0xaf, 0x35,},//Outdoor 1A1f
{0xb0, 0x20,},
{0xb1, 0xe7,},//Outdoor 1A20 add
{0xb2, 0x2f,},
{0xb3, 0xf1,},//Outdoor 1A2f add
{0xb4, 0x32,},
{0xb5, 0x87,},//Outdoor 1A32 add
{0xb6, 0x34,},
{0xb7, 0xd2,},//Outdoor 1A34 //RGB High Gain B[5:0]
{0xb8, 0x35,},
{0xb9, 0x1c,},//Outdoor 1A35 //RGB Low Gain B[5:0]
{0xba, 0x36,},
{0xbb, 0x06,},//Outdoor 1A36
{0xbc, 0x37,},
{0xbd, 0x40,},//Outdoor 1A37
{0xbe, 0x38,},
{0xbf, 0xff,},//Outdoor 1A38
{0xc0, 0x39,},
{0xc1, 0x2e,},//Outdoor 1A39 //RGB Flat R2_Lum L
{0xc2, 0x3a,},
{0xc3, 0x3f,},//Outdoor 1A3a
{0xc4, 0x3b,},
{0xc5, 0x01,},//Outdoor 1A3b
{0xc6, 0x3c,},
{0xc7, 0x0c,},//Outdoor 1A3c
{0xc8, 0x3d,},
{0xc9, 0x01,},//Outdoor 1A3d
{0xca, 0x3e,},
{0xcb, 0x07,},//Outdoor 1A3e
{0xcc, 0x3f,},
{0xcd, 0x01,},//Outdoor 1A3f
{0xce, 0x40,},
{0xcf, 0x0c,},//Outdoor 1A40
{0xd0, 0x41,},
{0xd1, 0x01,},//Outdoor 1A41
{0xd2, 0x42,},
{0xd3, 0x07,},//Outdoor 1A42
{0xd4, 0x43,},
{0xd5, 0x2b,},//Outdoor 1A43
{0xd6, 0x4d,},
{0xd7, 0x0b,},//Outdoor 1A4d //RGB SP Lum Gain Neg1
{0xd8, 0x4e,},
{0xd9, 0x0c,},//Outdoor 1A4e //RGB SP Lum Gain Neg2
{0xda, 0x4f,},
{0xdb, 0x0c,},//Outdoor 1A4f //RGB SP Lum Gain Neg3
{0xdc, 0x50,},
{0xdd, 0x11,},//Outdoor 1A50 //RGB SP Lum Gain Neg4
{0xde, 0x51,},
{0xdf, 0x17,},//Outdoor 1A51 //RGB SP Lum Gain Neg5
{0xe0, 0x52,},
{0xe1, 0x17,},//Outdoor 1A52 //RGB SP Lum Gain Neg6
{0xe2, 0x53,},
{0xe3, 0x17,},//Outdoor 1A53 //RGB SP Lum Gain Neg7
{0xe4, 0x54,},
{0xe5, 0x17,},//Outdoor 1A54 //RGB SP Lum Gain Neg8
{0xe6, 0x55,},
{0xe7, 0x16,},//Outdoor 1A55 //RGB SP Lum Gain Pos1
{0xe8, 0x56,},
{0xe9, 0x13,},//Outdoor 1A56 //RGB SP Lum Gain Pos2
{0xea, 0x57,},
{0xeb, 0x11,},//Outdoor 1A57 //RGB SP Lum Gain Pos3
{0xec, 0x58,},
{0xed, 0x12,},//Outdoor 1A58 //RGB SP Lum Gain Pos4
{0xee, 0x59,},
{0xef, 0x12,},//Outdoor 1A59 //RGB SP Lum Gain Pos5
{0xf0, 0x5a,},
{0xf1, 0x12,},//Outdoor 1A5a //RGB SP Lum Gain Pos6
{0xf2, 0x5b,},
{0xf3, 0x12,},//Outdoor 1A5b //RGB SP Lum Gain Pos7
{0xf4, 0x5c,},
{0xf5, 0x12,},//Outdoor 1A5c //RGB SP Lum Gain Pos8
{0xf6, 0x65,},
{0xf7, 0x0f,},//Outdoor 1A65 //RGB SP Dy Gain Neg1
{0xf8, 0x66,},
{0xf9, 0x0f,},//Outdoor 1A66 //RGB SP Dy Gain Neg2
{0xfa, 0x67,},
{0xfb, 0x10,},//Outdoor 1A67 //RGB SP Dy Gain Neg3
{0xfc, 0x68,},
{0xfd, 0x17,},//Outdoor 1A68 //RGB SP Dy Gain Neg4

{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E0 page.
{0xd0, 0x27,},
{0xd1, 0x42,},

{0x03, 0xe0,}, //DMA E0 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x69,},
{0x11, 0x19,},//Outdoor 1A69 //RGB SP Dy Gain Neg5
{0x12, 0x6a,},
{0x13, 0x17,},//Outdoor 1A6a //RGB SP Dy Gain Neg6
{0x14, 0x6b,},
{0x15, 0x16,},//Outdoor 1A6b //RGB SP Dy Gain Neg7
{0x16, 0x6c,},
{0x17, 0x16,},//Outdoor 1A6c //RGB SP Dy Gain Neg8
{0x18, 0x6d,},
{0x19, 0x10,},//Outdoor 1A6d //RGB SP Dy Gain Pos1
{0x1a, 0x6e,},
{0x1b, 0x16,},//Outdoor 1A6e //RGB SP Dy Gain Pos2
{0x1c, 0x6f,},
{0x1d, 0x15,},//Outdoor 1A6f //RGB SP Dy Gain Pos3
{0x1e, 0x70,},
{0x1f, 0x12,},//Outdoor 1A70 //RGB SP Dy Gain Pos4
{0x20, 0x71,},
{0x21, 0x13,},//Outdoor 1A71 //RGB SP Dy Gain Pos5
{0x22, 0x72,},
{0x23, 0x13,},//Outdoor 1A72 //RGB SP Dy Gain Pos6
{0x24, 0x73,},
{0x25, 0x13,},//Outdoor 1A73 //RGB SP Dy Gain Pos7
{0x26, 0x74,},
{0x27, 0x13,},//Outdoor 1A74 //RGB SP Dy Gain Pos8
{0x28, 0x7d,},
{0x29, 0x29,},//Outdoor 1A7d //RGB SP Edge Gain1
{0x2a, 0x7e,},
{0x2b, 0x29,},//Outdoor 1A7e //RGB SP Edge Gain2
{0x2c, 0x7f,},
{0x2d, 0x29,},//Outdoor 1A7f //RGB SP Edge Gain3
{0x2e, 0x80,},
{0x2f, 0x2f,},//Outdoor 1A80 //RGB SP Edge Gain4
{0x30, 0x81,},
{0x31, 0x2f,},//Outdoor 1A81 //RGB SP Edge Gain5
{0x32, 0x82,},
{0x33, 0x2f,},//Outdoor 1A82 //RGB SP Edge Gain6
{0x34, 0x83,},
{0x35, 0x27,},//Outdoor 1A83 //RGB SP Edge Gain7
{0x36, 0x84,},
{0x37, 0x25,},//Outdoor 1A84 //RGB SP Edge Gain8
{0x38, 0x9e,},
{0x39, 0x28,},//Outdoor 1A9e //RGB SP STD Gain1
{0x3a, 0x9f,},
{0x3b, 0x28,},//Outdoor 1A9f //RGB SP STD Gain2
{0x3c, 0xa0,},
{0x3d, 0x2f,},//Outdoor 1Aa0 //RGB SP STD Gain3
{0x3e, 0xa1,},
{0x3f, 0x2e,},//Outdoor 1Aa1 //RGB SP STD Gain4
{0x40, 0xa2,},
{0x41, 0x2d,},//Outdoor 1Aa2 //RGB SP STD Gain5
{0x42, 0xa3,},
{0x43, 0x2d,},//Outdoor 1Aa3 //RGB SP STD Gain6
{0x44, 0xa4,},
{0x45, 0x29,},//Outdoor 1Aa4 //RGB SP STD Gain7
{0x46, 0xa5,},
{0x47, 0x25,},//Outdoor 1Aa5 //RGB SP STD Gain8
{0x48, 0xa6,},
{0x49, 0x23,},//Outdoor 1Aa6 //RGB Post STD Gain Pos/Neg
{0x4a, 0xa7,},
{0x4b, 0x3f,},//Outdoor 1Aa7 add
{0x4c, 0xa8,},
{0x4d, 0x3f,},//Outdoor 1Aa8 add
{0x4e, 0xa9,},
{0x4f, 0x3f,},//Outdoor 1Aa9 add
{0x50, 0xaa,},
{0x51, 0x3f,},//Outdoor 1Aaa add
{0x52, 0xab,},
{0x53, 0x3f,},//Outdoor 1Aab add
{0x54, 0xaf,},
{0x55, 0x3f,},//Outdoor 1Aaf add
{0x56, 0xb0,},
{0x57, 0x3f,},//Outdoor 1Ab0 add
{0x58, 0xb1,},
{0x59, 0x3f,},//Outdoor 1Ab1 add
{0x5a, 0xb2,},
{0x5b, 0x3f,},//Outdoor 1Ab2 add
{0x5c, 0xb3,},
{0x5d, 0x3f,},//Outdoor 1Ab3 add
{0x5e, 0xca,},
{0x5f, 0x00,},//Outdoor 1Aca
{0x60, 0xe3,},
{0x61, 0x13,},//Outdoor 1Ae3 add
{0x62, 0xe4,},
{0x63, 0x13,},//Outdoor 1Ae4 add
{0x64, 0x03,},
{0x65, 0x10,},//10 page
{0x66, 0x70,},
{0x67, 0x0f,},//Outdoor 1070 Trans Func.   130108 Outdoor transFuc Flat graph
{0x68, 0x71,},
{0x69, 0x00,},//Outdoor 1071
{0x6a, 0x72,},
{0x6b, 0x00,},//Outdoor 1072
{0x6c, 0x73,},
{0x6d, 0x00,},//Outdoor 1073
{0x6e, 0x74,},
{0x6f, 0x00,},//Outdoor 1074
{0x70, 0x75,},
{0x71, 0x00,},//Outdoor 1075
{0x72, 0x76,},
{0x73, 0x40,},//Outdoor 1076
{0x74, 0x77,},
{0x75, 0x40,},//Outdoor 1077
{0x76, 0x78,},
{0x77, 0x00,},//Outdoor 1078
{0x78, 0x79,},
{0x79, 0x40,},//Outdoor 1079
{0x7a, 0x7a,},
{0x7b, 0x00,},//Outdoor 107a
{0x7c, 0x7b,},
{0x7d, 0x40,},//Outdoor 107b
{0x7e, 0x7c,},
{0x7f, 0x00,},//Outdoor 107c
{0x80, 0x7d,},
{0x81, 0x07,},//Outdoor 107d
{0x82, 0x7e,},
{0x83, 0x0f,},//Outdoor 107e
{0x84, 0x7f,},
{0x85, 0x1e,},//Outdoor 107f
{0x86, 0x03,},
{0x87, 0x02,},// 2 page
{0x88, 0x23,},
{0x89, 0x30,},//Outdoor 0223 (for sun-spot) // normal 3c
{0x8a, 0x03,},
{0x8b, 0x03,},// 3 page
{0x8c, 0x1a,},
{0x8d, 0x00,},//Outdoor 031a (for sun-spot)
{0x8e, 0x1b,},
{0x8f, 0x8c,},//Outdoor 031b (for sun-spot)
{0x90, 0x1c,},
{0x91, 0x02,},//Outdoor 031c (for sun-spot)
{0x92, 0x1d,},
{0x93, 0x88,},//Outdoor 031d (for sun-spot)
{0x94, 0x03,},
{0x95, 0x11,},// 11 page
{0x96, 0xf0,},
{0x97, 0x02,},//Outdoor 11f0 (for af bug)
{0x98, 0x03,},
{0x99, 0x10,},// 10 page
{0x9a, 0x17,},
{0x9b, 0x00,},//Outdoor 1017 CSP option

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////////////////////////////////////////
// E1 ~ E3 Page (DMA Indoor)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xe1,}, //DMA E1 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0x77,}, //Indoor 1111 add 720p
{0x14, 0x14,},
{0x15, 0x04,}, //Indoor 1114 add 720p
{0x16, 0x15,},
{0x17, 0x44,}, //Indoor 1115 add 720p
{0x18, 0x16,},
{0x19, 0x44,}, //Indoor 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x58,}, //Indoor 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x30,}, //Indoor 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x12,}, //Indoor 1119 add 720p
{0x20, 0x37,},
{0x21, 0x07,}, //Indoor 1137
{0x22, 0x38,},
{0x23, 0x00,}, //Indoor 1138 //Pre flat R1 LumL
{0x24, 0x39,},
{0x25, 0xff,}, //Indoor 1139 //Pre flat R1 LumH
{0x26, 0x3a,},
{0x27, 0x00,}, //Indoor 113a
{0x28, 0x3b,},
{0x29, 0x00,}, //Indoor 113b
{0x2a, 0x3c,},
{0x2b, 0x00,},//Indoor 113c //Pre flat R1 DyL
{0x2c, 0x3d,},
{0x2d, 0x56,},//Indoor 113d //Pre flat R1 DyH
{0x2e, 0x3e,},
{0x2f, 0x00,},//Indoor 113e
{0x30, 0x3f,},
{0x31, 0x00,},//Indoor 113f
{0x32, 0x40,},
{0x33, 0x00,},//Indoor 1140 //Pre flat R1 STDL
{0x34, 0x41,},
{0x35, 0x1c,},//Indoor 1141 //Pre flat R1 STDH
{0x36, 0x42,},
{0x37, 0x00,}, //Indoor 1142
{0x38, 0x43,},
{0x39, 0x00,}, //Indoor 1143
{0x3a, 0x49,},
{0x3b, 0x06,}, //Indoor 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x0a,}, //Indoor 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x12,}, //Indoor 114b add 720p
{0x40, 0x4c,},
{0x41, 0x1c,}, //Indoor 114c add 720p
{0x42, 0x4d,},
{0x43, 0x24,}, //Indoor 114d add 720p
{0x44, 0x4e,},
{0x45, 0x40,}, //Indoor 114e add 720p
{0x46, 0x4f,},
{0x47, 0x80,}, //Indoor 114f add 720p
{0x48, 0x50,},
{0x49, 0x3f,}, //Indoor 1150
{0x4a, 0x51,},
{0x4b, 0x3f,},//Indoor 1151
{0x4c, 0x52,},
{0x4d, 0x3f,},//Indoor 1152
{0x4e, 0x53,},
{0x4f, 0x3f,},//Indoor 1153
{0x50, 0x54,},
{0x51, 0x3f,},//Indoor 1154
{0x52, 0x55,},
{0x53, 0x3f,},//Indoor 1155
{0x54, 0x56,},
{0x55, 0x3f,},//Indoor 1156
{0x56, 0x57,},
{0x57, 0x3f,},//Indoor 1157
{0x58, 0x58,},
{0x59, 0x10,},//Indoor 1158
{0x5a, 0x59,},
{0x5b, 0x10,},//Indoor 1159
{0x5c, 0x5a,},
{0x5d, 0x10,}, //Indoor 115a
{0x5e, 0x5b,},
{0x5f, 0x10,}, //Indoor 115b
{0x60, 0x5c,},
{0x61, 0x10,}, //Indoor 115c
{0x62, 0x5d,},
{0x63, 0x10,}, //Indoor 115d
{0x64, 0x5e,},
{0x65, 0x10,}, //Indoor 115e
{0x66, 0x5f,},
{0x67, 0x10,}, //Indoor 115f
{0x68, 0x6e,},
{0x69, 0x20,}, //Indoor 116e
{0x6a, 0x6f,},
{0x6b, 0x18,},//Indoor 116f
{0x6c, 0x77,},
{0x6d, 0x15,},//Indoor 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x13,},//Indoor 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x10,},//Indoor 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x10,},//Indoor 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x12,},//Indoor 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,},//Indoor 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x10,},//Indoor 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x10,},//Indoor 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x17,},//Indoor 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x16,},//Indoor 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x13,},//Indoor 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x13,},//Indoor 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x15,},//Indoor 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x16,},//Indoor 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x16,},//Indoor 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x16,},//Indoor 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x14,},//Indoor 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x12,},//Indoor 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x11,},//Indoor 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x12,},//Indoor 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x13,},//Indoor 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x13,},//Indoor 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x13,},//Indoor 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x10,},//Indoor 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x16,},//Indoor 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x18,},//Indoor 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x13,},//Indoor 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x16,},//Indoor 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x1a,}, //Indoor 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x1a,}, //Indoor 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x1a,}, //Indoor 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x19,}, //Indoor 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x26,}, //Indoor 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x26,}, //Indoor 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x25,}, //Indoor 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x25,}, //Indoor 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x25,},//Indoor 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x25,},//Indoor 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x26,},//Indoor 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x28,},//Indoor 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x22,}, //Indoor 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x22,}, //Indoor 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x21,}, //Indoor 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x1e,}, //Indoor 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x1c,}, //Indoor 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x1a,}, //Indoor 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x20,}, //Indoor 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x21,}, //Indoor 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x22,}, //Indoor 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x24,}, //Indoor 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x24,}, //Indoor 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x24,}, //Indoor 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x20,}, //Indoor 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x1f,},//Indoor 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x15,},//Indoor 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x3f,},//Indoor 11d1 //Bayer Flat R1 Lum H
{0xde, 0xd2,},
{0xdf, 0x40,},//Indoor 11d2
{0xe0, 0xd3,},
{0xe1, 0xff,},//Indoor 11d3
{0xe2, 0xd4,},
{0xe3, 0x01,},//Indoor 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x20,},//Indoor 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x01,}, //Indoor 11d6
{0xe8, 0xd7,},
{0xe9, 0x10,}, //Indoor 11d7
{0xea, 0xd8,},
{0xeb, 0x01,}, //Indoor 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x18,},//Indoor 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x01,}, //Indoor 11da
{0xf0, 0xdb,},
{0xf1, 0x07,}, //Indoor 11db
{0xf2, 0xdf,},
{0xf3, 0xcc,},//Indoor 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x08,},//Indoor 11e0 //Bayer Flat R3 LumL
{0xf6, 0xe1,},
{0xf7, 0x15,},//Indoor 11e1 //Bayer Flat R3 LumH
{0xf8, 0xe2,},
{0xf9, 0x3c,},//Indoor 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xff,},//Indoor 11e3 //Bayer Flat R4 LumH
{0xfc, 0xe4,},
{0xfd, 0x01,},//Indoor 11e4 //Bayer Flat R3 StdL
{0x0e, 0x00,},// burst end

{0x03, 0xe2,}, //DMA E2 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x11,},//Indoor 11e5 //Bayer Flat R3 StdH
{0x12, 0xe6,},
{0x13, 0x01,},//Indoor 11e6 //Bayer Flat R4 StdL
{0x14, 0xe7,},
{0x15, 0x40,},//Indoor 11e7 //Bayer Flat R4 StdH
{0x16, 0xe8,},
{0x17, 0x01,},//Indoor 11e8 //Bayer Flat R3 DyL
{0x18, 0xe9,},
{0x19, 0x0a,},//Indoor 11e9 //Bayer Flat R3 DyH
{0x1a, 0xea,},
{0x1b, 0x01,},//Indoor 11ea //Bayer Flat R4 DyL
{0x1c, 0xeb,},
{0x1d, 0x25,},//Indoor 11eb //Bayer Flat R4 DyH
{0x1e, 0xef,},
{0x1f, 0x6a,},//Indoor 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,},//12 Page
{0x22, 0x12,},
{0x23, 0x08,},//Indoor 1212
{0x24, 0x33,},
{0x25, 0x16,},//Indoor 1233 add 20130603 Skin_th
{0x26, 0x34,},
{0x27, 0x90,},//Indoor 1234 add 20130603 Cyan_th
{0x28, 0x40,},
{0x29, 0x37,},//Indoor 1240 add 720p
{0x2a, 0x70,},
{0x2b, 0xbf,},//Indoor 1270 // Bayer Sharpness ENB add
{0x2c, 0x71,},
{0x2d, 0x1a,},//Indoor 1271 //Bayer HPF Gain
{0x2e, 0x72,},
{0x2f, 0x16,},//Indoor 1272 //Bayer LPF Gain
{0x30, 0x77,},
{0x31, 0x26,},//Indoor 1277 //20130412
{0x32, 0x78,},
{0x33, 0x2f,},//Indoor 1278
{0x34, 0x79,},
{0x35, 0xff,},//Indoor 1279
{0x36, 0x7a,},
{0x37, 0x50,},//Indoor 127a
{0x38, 0x7b,},
{0x39, 0x10,},//Indoor 127b
{0x3a, 0x7c,},
{0x3b, 0x60,},//Indoor 127c //skin HPF gain
{0x3c, 0x7d,},
{0x3d, 0x20,},//Indoor 127d
{0x3e, 0x7f,},
{0x3f, 0x50,},//Indoor 127f
{0x40, 0x87,},
{0x41, 0x3f,},//Indoor 1287 add 720p
{0x42, 0x88,},
{0x43, 0x3f,},//Indoor 1288 add 720p
{0x44, 0x89,},
{0x45, 0x3f,},//Indoor 1289 add 720p
{0x46, 0x8a,},
{0x47, 0x3f,},//Indoor 128a add 720p
{0x48, 0x8b,},
{0x49, 0x3f,},//Indoor 128b add 720p
{0x4a, 0x8c,},
{0x4b, 0x3f,},//Indoor 128c add 720p
{0x4c, 0x8d,},
{0x4d, 0x3f,},//Indoor 128d add 720p
{0x4e, 0x8e,},
{0x4f, 0x3f,},//Indoor 128e add 720p
{0x50, 0x8f,},
{0x51, 0x3f,},//Indoor 128f add 720p
{0x52, 0x90,},
{0x53, 0x3f,},//Indoor 1290 add 720p
{0x54, 0x91,},
{0x55, 0x3f,},//Indoor 1291 add 720p
{0x56, 0x92,},
{0x57, 0x3f,},//Indoor 1292 add 720p
{0x58, 0x93,},
{0x59, 0x3f,},//Indoor 1293 add 720p
{0x5a, 0x94,},
{0x5b, 0x3f,},//Indoor 1294 add 720p
{0x5c, 0x95,},
{0x5d, 0x3f,},//Indoor 1295 add 720p
{0x5e, 0x96,},
{0x5f, 0x3f,},//Indoor 1296 add 720p
{0x60, 0xae,},
{0x61, 0x7f,},//Indoor 12ae
{0x62, 0xaf,},
{0x63, 0x00,},//Indoor 12af // B[7:4]Blue/B[3:0]Skin
{0x64, 0xc0,},
{0x65, 0x23,},//Indoor 12c0 // CI-LPF ENB add 720p
{0x66, 0xc3,},
{0x67, 0x3c,},//Indoor 12c3 add 720p
{0x68, 0xc4,},
{0x69, 0x1a,},//Indoor 12c4 add 720p
{0x6a, 0xc5,},
{0x6b, 0x0c,},//Indoor 12c5 add 720p
{0x6c, 0xc6,},
{0x6d, 0x44,},//Indoor 12c6
{0x6e, 0xc7,},
{0x6f, 0x44,},//Indoor 12c7
{0x70, 0xc8,},
{0x71, 0x3e,},//Indoor 12c8
{0x72, 0xd0,},
{0x73, 0x08,},//Indoor 12d0 add 720p
{0x74, 0xd1,},
{0x75, 0x10,},//Indoor 12d1 add 720p
{0x76, 0xd2,},
{0x77, 0x18,},//Indoor 12d2 add 720p
{0x78, 0xd3,},
{0x79, 0x20,},//Indoor 12d3 add 720p
{0x7a, 0xd4,},
{0x7b, 0x30,},//Indoor 12d4 add 720p
{0x7c, 0xd5,},
{0x7d, 0x60,},//Indoor 12d5 add 720p
{0x7e, 0xd6,},
{0x7f, 0x80,},//Indoor 12d6 add 720p
{0x80, 0xd7,},
{0x81, 0x3f,},//Indoor 12d7
{0x82, 0xd8,},
{0x83, 0x3f,},//Indoor 12d8
{0x84, 0xd9,},
{0x85, 0x3f,},//Indoor 12d9
{0x86, 0xda,},
{0x87, 0x3f,},//Indoor 12da
{0x88, 0xdb,},
{0x89, 0x3f,},//Indoor 12db
{0x8a, 0xdc,},
{0x8b, 0x3f,},//Indoor 12dc
{0x8c, 0xdd,},
{0x8d, 0x3f,},//Indoor 12dd
{0x8e, 0xde,},
{0x8f, 0x3f,},//Indoor 12de
{0x90, 0xe0,},
{0x91, 0x63,},//Indoor 12e0 // 20121120 ln dy
{0x92, 0xe1,},
{0x93, 0xfc,},//Indoor 12e1
{0x94, 0xe2,},
{0x95, 0x02,},//Indoor 12e2
{0x96, 0xe3,},
{0x97, 0x10,},//Indoor 12e3 //PS LN graph Y1
{0x98, 0xe4,},
{0x99, 0x12,},//Indoor 12e4 //PS LN graph Y2
{0x9a, 0xe5,},
{0x9b, 0x1a,},//Indoor 12e5 //PS LN graph Y3
{0x9c, 0xe6,},
{0x9d, 0x1d,},//Indoor 12e6 //PS LN graph Y4
{0x9e, 0xe7,},
{0x9f, 0x1e,},//Indoor 12e7 //PS LN graph Y5
{0xa0, 0xe8,},
{0xa1, 0x1f,},//Indoor 12e8 //PS LN graph Y6
{0xa2, 0xe9,},
{0xa3, 0x10,},//Indoor 12e9 //PS DY graph Y1
{0xa4, 0xea,},
{0xa5, 0x12,},//Indoor 12ea //PS DY graph Y2
{0xa6, 0xeb,},
{0xa7, 0x18,},//Indoor 12eb //PS DY graph Y3
{0xa8, 0xec,},
{0xa9, 0x1c,},//Indoor 12ec //PS DY graph Y4
{0xaa, 0xed,},
{0xab, 0x1e,},//Indoor 12ed //PS DY graph Y5
{0xac, 0xee,},
{0xad, 0x1f,},//Indoor 12ee //PS DY graph Y6
{0xae, 0xf0,},
{0xaf, 0x00,},//Indoor 12f0
{0xb0, 0xf1,},
{0xb1, 0x2a,},//Indoor 12f1
{0xb2, 0xf2,},
{0xb3, 0x32,},//Indoor 12f2
{0xb4, 0x03,},
{0xb5, 0x13,},//13 Page
{0xb6, 0x10,},
{0xb7, 0x81,},//Indoor 1310 //Y-NR ENB add 720p
{0xb8, 0x30,},
{0xb9, 0x20,},//Indoor 1330
{0xba, 0x31,},
{0xbb, 0x20,},//Indoor 1331
{0xbc, 0x32,},
{0xbd, 0x20,},//Indoor 1332
{0xbe, 0x33,},
{0xbf, 0x20,},//Indoor 1333
{0xc0, 0x34,},
{0xc1, 0x20,},//Indoor 1334
{0xc2, 0x35,},
{0xc3, 0x20,},//Indoor 1335
{0xc4, 0x36,},
{0xc5, 0x20,},//Indoor 1336
{0xc6, 0x37,},
{0xc7, 0x20,},//Indoor 1337
{0xc8, 0x38,},
{0xc9, 0x02,},//Indoor 1338
{0xca, 0x40,},
{0xcb, 0x18,},//Indoor 1340
{0xcc, 0x41,},
{0xcd, 0x36,},//Indoor 1341
{0xce, 0x42,},
{0xcf, 0x62,},//Indoor 1342
{0xd0, 0x43,},
{0xd1, 0x63,},//Indoor 1343
{0xd2, 0x44,},
{0xd3, 0xff,},//Indoor 1344
{0xd4, 0x45,},
{0xd5, 0x04,},//Indoor 1345
{0xd6, 0x46,},
{0xd7, 0x45,},//Indoor 1346
{0xd8, 0x47,},
{0xd9, 0x05,},//Indoor 1347
{0xda, 0x48,},
{0xdb, 0x65,},//Indoor 1348
{0xdc, 0x49,},
{0xdd, 0x02,},//Indoor 1349
{0xde, 0x4a,},
{0xdf, 0x22,},//Indoor 134a
{0xe0, 0x4b,},
{0xe1, 0x06,},//Indoor 134b
{0xe2, 0x4c,},
{0xe3, 0x30,},//Indoor 134c
{0xe4, 0x83,},
{0xe5, 0x08,},//Indoor 1383 //add 20121210
{0xe6, 0x84,},
{0xe7, 0x0a,},//Indoor 1384 //add 20121210
{0xe8, 0xb7,},
{0xe9, 0xfa,},//Indoor 13b7
{0xea, 0xb8,},
{0xeb, 0x77,},//Indoor 13b8
{0xec, 0xb9,},
{0xed, 0xfe,},//Indoor 13b9 //20121217 DC R1,2 CR
{0xee, 0xba,},
{0xef, 0xca,},//Indoor 13ba //20121217 DC R3,4 CR
{0xf0, 0xbd,},
{0xf1, 0x78,},//Indoor 13bd //20121121 c-filter LumHL DC rate
{0xf2, 0xc5,},
{0xf3, 0x01,},//Indoor 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xf4, 0xc6,},
{0xf5, 0x22,},//Indoor 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf6, 0xc7,},
{0xf7, 0x33,},//Indoor 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf8, 0x03,},
{0xf9, 0x14,},//14 page
{0xfa, 0x10,},
{0xfb, 0xb3,},//Indoor 1410
{0xfc, 0x11,},
{0xfd, 0x98,},//Indoor 1411

{0x0e, 0x00,}, // burst end

{0x03, 0xe3,}, //DMA E3 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x12,},
{0x11, 0x10,},//Indoor 1412
{0x12, 0x13,},
{0x13, 0x03,},//Indoor 1413
{0x14, 0x14,},
{0x15, 0x10,},//Indoor 1414 //YC2D Low Gain B[5:0]
{0x16, 0x15,},
{0x17, 0x7b,},//Indoor 1415 // Y Hi filter mask 1/16
{0x18, 0x16,},
{0x19, 0x10,},//Indoor 1416 //YC2D Hi Gain B[5:0]
{0x1a, 0x17,},
{0x1b, 0x40,},//Indoor 1417
{0x1c, 0x18,},
{0x1d, 0x0c,},//Indoor 1418
{0x1e, 0x19,},
{0x1f, 0x0c,},//Indoor 1419
{0x20, 0x1a,},
{0x21, 0x18,},//Indoor 141a //YC2D Post STD gain Pos
{0x22, 0x1b,},
{0x23, 0x1c,},//Indoor 141b //YC2D Post STD gain Neg
{0x24, 0x27,},
{0x25, 0x20,},//Indoor 1427 //YC2D SP Lum Gain Pos1
{0x26, 0x28,},
{0x27, 0x1f,},//Indoor 1428 //YC2D SP Lum Gain Pos2
{0x28, 0x29,},
{0x29, 0x1c,},//Indoor 1429 //YC2D SP Lum Gain Pos3
{0x2a, 0x2a,},
{0x2b, 0x11,},//Indoor 142a //YC2D SP Lum Gain Pos4
{0x2c, 0x2b,},
{0x2d, 0x10,},//Indoor 142b //YC2D SP Lum Gain Pos5
{0x2e, 0x2c,},
{0x2f, 0x10,},//Indoor 142c //YC2D SP Lum Gain Pos6
{0x30, 0x2d,},
{0x31, 0x11,},//Indoor 142d //YC2D SP Lum Gain Pos7
{0x32, 0x2e,},
{0x33, 0x10,},//Indoor 142e //YC2D SP Lum Gain Pos8
{0x34, 0x30,},
{0x35, 0x1a,},//Indoor 1430 //YC2D SP Lum Gain Neg1
{0x36, 0x31,},
{0x37, 0x15,},//Indoor 1431 //YC2D SP Lum Gain Neg2
{0x38, 0x32,},
{0x39, 0x14,},//Indoor 1432 //YC2D SP Lum Gain Neg3
{0x3a, 0x33,},
{0x3b, 0x13,},//Indoor 1433 //YC2D SP Lum Gain Neg4
{0x3c, 0x34,},
{0x3d, 0x12,},//Indoor 1434 //YC2D SP Lum Gain Neg5
{0x3e, 0x35,},
{0x3f, 0x12,},//Indoor 1435 //YC2D SP Lum Gain Neg6
{0x40, 0x36,},
{0x41, 0x14,},//Indoor 1436 //YC2D SP Lum Gain Neg7
{0x42, 0x37,},
{0x43, 0x15,},//Indoor 1437 //YC2D SP Lum Gain Neg8
{0x44, 0x47,},
{0x45, 0x22,},//Indoor 1447 //YC2D SP Dy Gain Pos1
{0x46, 0x48,},
{0x47, 0x22,},//Indoor 1448 //YC2D SP Dy Gain Pos2
{0x48, 0x49,},
{0x49, 0x22,},//Indoor 1449 //YC2D SP Dy Gain Pos3
{0x4a, 0x4a,},
{0x4b, 0x1f,},//Indoor 144a //YC2D SP Dy Gain Pos4
{0x4c, 0x4b,},
{0x4d, 0x1a,},//Indoor 144b //YC2D SP Dy Gain Pos5
{0x4e, 0x4c,},
{0x4f, 0x18,},//Indoor 144c //YC2D SP Dy Gain Pos6
{0x50, 0x4d,},
{0x51, 0x1a,},//Indoor 144d //YC2D SP Dy Gain Pos7
{0x52, 0x4e,},
{0x53, 0x1d,},//Indoor 144e //YC2D SP Dy Gain Pos8
{0x54, 0x50,},
{0x55, 0x19,},//Indoor 1450 //YC2D SP Dy Gain Neg1
{0x56, 0x51,},
{0x57, 0x18,},//Indoor 1451 //YC2D SP Dy Gain Neg2
{0x58, 0x52,},
{0x59, 0x16,},//Indoor 1452 //YC2D SP Dy Gain Neg3
{0x5a, 0x53,},
{0x5b, 0x15,},//Indoor 1453 //YC2D SP Dy Gain Neg4
{0x5c, 0x54,},
{0x5d, 0x14,},//Indoor 1454 //YC2D SP Dy Gain Neg5
{0x5e, 0x55,},
{0x5f, 0x14,},//Indoor 1455 //YC2D SP Dy Gain Neg6
{0x60, 0x56,},
{0x61, 0x13,},//Indoor 1456 //YC2D SP Dy Gain Neg7
{0x62, 0x57,},
{0x63, 0x12,},//Indoor 1457 //YC2D SP Dy Gain Neg8
{0x64, 0x67,},
{0x65, 0x2b,},//Indoor 1467 //YC2D SP Edge Gain1
{0x66, 0x68,},
{0x67, 0x2c,},//Indoor 1468 //YC2D SP Edge Gain2
{0x68, 0x69,},
{0x69, 0x2e,},//Indoor 1469 //YC2D SP Edge Gain3
{0x6a, 0x6a,},
{0x6b, 0x2f,},//Indoor 146a //YC2D SP Edge Gain4
{0x6c, 0x6b,},
{0x6d, 0x2f,},//Indoor 146b //YC2D SP Edge Gain5
{0x6e, 0x6c,},
{0x6f, 0x2e,},//Indoor 146c //YC2D SP Edge Gain6
{0x70, 0x6d,},
{0x71, 0x2f,},//Indoor 146d //YC2D SP Edge Gain7
{0x72, 0x6e,},
{0x73, 0x30,},//Indoor 146e //YC2D SP Edge Gain8
{0x74, 0x87,},
{0x75, 0x17,},//Indoor 1487 //YC2D SP STD Gain1
{0x76, 0x88,},
{0x77, 0x1d,},//Indoor 1488 //YC2D SP STD Gain2
{0x78, 0x89,},
{0x79, 0x24,},//Indoor 1489 //YC2D SP STD Gain3
{0x7a, 0x8a,},
{0x7b, 0x26,},//Indoor 148a //YC2D SP STD Gain4
{0x7c, 0x8b,},
{0x7d, 0x24,},//Indoor 148b //YC2D SP STD Gain5
{0x7e, 0x8c,},
{0x7f, 0x23,},//Indoor 148c //YC2D SP STD Gain6
{0x80, 0x8d,},
{0x81, 0x1d,},//Indoor 148d //YC2D SP STD Gain7
{0x82, 0x8e,},
{0x83, 0x17,},//Indoor 148e //YC2D SP STD Gain8
{0x84, 0x97,},
{0x85, 0x3f,},//Indoor 1497 add 720p
{0x86, 0x98,},
{0x87, 0x3f,},//Indoor 1498 add 720p
{0x88, 0x99,},
{0x89, 0x3f,},//Indoor 1499 add 720p
{0x8a, 0x9a,},
{0x8b, 0x3f,},//Indoor 149a add 720p
{0x8c, 0x9b,},
{0x8d, 0x3f,},//Indoor 149b add 720p
{0x8e, 0xa0,},
{0x8f, 0x3f,},//Indoor 14a0 add 720p
{0x90, 0xa1,},
{0x91, 0x3f,},//Indoor 14a1 add 720p
{0x92, 0xa2,},
{0x93, 0x3f,},//Indoor 14a2 add 720p
{0x94, 0xa3,},
{0x95, 0x3f,},//Indoor 14a3 add 720p
{0x96, 0xa4,},
{0x97, 0x3f,},//Indoor 14a4 add 720p
{0x98, 0xc9,},
{0x99, 0x13,},//Indoor 14c9
{0x9a, 0xca,},
{0x9b, 0x50,},//Indoor 14ca
{0x9c, 0x03,},
{0x9d, 0x1a,},//1A page
{0x9e, 0x10,},
{0x9f, 0x15,},//Indoor 1A10 add 720p
{0xa0, 0x18,},
{0xa1, 0x3f,},//Indoor 1A18
{0xa2, 0x19,},
{0xa3, 0x3f,},//Indoor 1A19
{0xa4, 0x1a,},
{0xa5, 0x2a,},//Indoor 1A1a
{0xa6, 0x1b,},
{0xa7, 0x27,},//Indoor 1A1b
{0xa8, 0x1c,},
{0xa9, 0x23,},//Indoor 1A1c
{0xaa, 0x1d,},
{0xab, 0x23,},//Indoor 1A1d
{0xac, 0x1e,},
{0xad, 0x23,},//Indoor 1A1e
{0xae, 0x1f,},
{0xaf, 0x23,},//Indoor 1A1f
{0xb0, 0x20,},
{0xb1, 0xe7,},//Indoor 1A20 add 720p
{0xb2, 0x2f,},
{0xb3, 0xf1,},//Indoor 1A2f add 720p
{0xb4, 0x32,},
{0xb5, 0x87,},//Indoor 1A32 add 720p
{0xb6, 0x34,},
{0xb7, 0xd0,},//Indoor 1A34 //RGB High Gain B[5:0]
{0xb8, 0x35,},
{0xb9, 0x11,},//Indoor 1A35 //RGB Low Gain B[5:0]
{0xba, 0x36,},
{0xbb, 0x00,},//Indoor 1A36
{0xbc, 0x37,},
{0xbd, 0x40,},//Indoor 1A37
{0xbe, 0x38,},
{0xbf, 0xff,},//Indoor 1A38
{0xc0, 0x39,},
{0xc1, 0x1d,},//Indoor 1A39 //RGB Flat R2_Lum L
{0xc2, 0x3a,},
{0xc3, 0x3f,},//Indoor 1A3a //RGB Flat R2_Lum H
{0xc4, 0x3b,},
{0xc5, 0x00,},//Indoor 1A3b
{0xc6, 0x3c,},
{0xc7, 0x4c,},//Indoor 1A3c
{0xc8, 0x3d,},
{0xc9, 0x00,},//Indoor 1A3d
{0xca, 0x3e,},
{0xcb, 0x13,},//Indoor 1A3e
{0xcc, 0x3f,},
{0xcd, 0x00,},//Indoor 1A3f
{0xce, 0x40,},
{0xcf, 0x2a,},//Indoor 1A40
{0xd0, 0x41,},
{0xd1, 0x00,},//Indoor 1A41
{0xd2, 0x42,},
{0xd3, 0x17,},//Indoor 1A42
{0xd4, 0x43,},
{0xd5, 0x2c,},//Indoor 1A43
{0xd6, 0x4d,},
{0xd7, 0x12,},//Indoor 1A4d //RGB SP Lum Gain Neg1
{0xd8, 0x4e,},
{0xd9, 0x12,},//Indoor 1A4e //RGB SP Lum Gain Neg2
{0xda, 0x4f,},
{0xdb, 0x11,},//Indoor 1A4f //RGB SP Lum Gain Neg3
{0xdc, 0x50,},
{0xdd, 0x10,},//Indoor 1A50 //RGB SP Lum Gain Neg4
{0xde, 0x51,},
{0xdf, 0x10,},//Indoor 1A51 //RGB SP Lum Gain Neg5
{0xe0, 0x52,},
{0xe1, 0x10,},//Indoor 1A52 //RGB SP Lum Gain Neg6
{0xe2, 0x53,},
{0xe3, 0x10,},//Indoor 1A53 //RGB SP Lum Gain Neg7
{0xe4, 0x54,},
{0xe5, 0x10,},//Indoor 1A54 //RGB SP Lum Gain Neg8
{0xe6, 0x55,},
{0xe7, 0x15,},//Indoor 1A55 //RGB SP Lum Gain Pos1
{0xe8, 0x56,},
{0xe9, 0x12,},//Indoor 1A56 //RGB SP Lum Gain Pos2
{0xea, 0x57,},
{0xeb, 0x10,},//Indoor 1A57 //RGB SP Lum Gain Pos3
{0xec, 0x58,},
{0xed, 0x10,},//Indoor 1A58 //RGB SP Lum Gain Pos4
{0xee, 0x59,},
{0xef, 0x10,},//Indoor 1A59 //RGB SP Lum Gain Pos5
{0xf0, 0x5a,},
{0xf1, 0x10,},//Indoor 1A5a //RGB SP Lum Gain Pos6
{0xf2, 0x5b,},
{0xf3, 0x10,},//Indoor 1A5b //RGB SP Lum Gain Pos7
{0xf4, 0x5c,},
{0xf5, 0x10,},//Indoor 1A5c //RGB SP Lum Gain Pos8
{0xf6, 0x65,},
{0xf7, 0x13,},//Indoor 1A65 //RGB SP Dy Gain Neg1
{0xf8, 0x66,},
{0xf9, 0x14,},//Indoor 1A66 //RGB SP Dy Gain Neg2
{0xfa, 0x67,},
{0xfb, 0x12,},//Indoor 1A67 //RGB SP Dy Gain Neg3
{0xfc, 0x68,},
{0xfd, 0x12,},//Indoor 1A68 //RGB SP Dy Gain Neg4

{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E3 page.
{0xD6, 0x2A,},
{0xD7, 0xFA,},

{0x03, 0xe3,}, //DMA E3 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x69,},
{0x11, 0x13,},//Indoor 1A69 //RGB SP Dy Gain Neg5
{0x12, 0x6a,},
{0x13, 0x14,},//Indoor 1A6a //RGB SP Dy Gain Neg6
{0x14, 0x6b,},
{0x15, 0x15,},//Indoor 1A6b //RGB SP Dy Gain Neg7
{0x16, 0x6c,},
{0x17, 0x15,},//Indoor 1A6c //RGB SP Dy Gain Neg8
{0x18, 0x6d,},
{0x19, 0x11,},//Indoor 1A6d //RGB SP Dy Gain Pos1
{0x1a, 0x6e,},
{0x1b, 0x11,},//Indoor 1A6e //RGB SP Dy Gain Pos2
{0x1c, 0x6f,},
{0x1d, 0x11,},//Indoor 1A6f //RGB SP Dy Gain Pos3
{0x1e, 0x70,},
{0x1f, 0x12,},//Indoor 1A70 //RGB SP Dy Gain Pos4
{0x20, 0x71,},
{0x21, 0x12,},//Indoor 1A71 //RGB SP Dy Gain Pos5
{0x22, 0x72,},
{0x23, 0x13,},//Indoor 1A72 //RGB SP Dy Gain Pos6
{0x24, 0x73,},
{0x25, 0x13,},//Indoor 1A73 //RGB SP Dy Gain Pos7
{0x26, 0x74,},
{0x27, 0x13,},//Indoor 1A74 //RGB SP Dy Gain Pos8
{0x28, 0x7d,},
{0x29, 0x22,},//Indoor 1A7d //RGB SP Edge Gain1
{0x2a, 0x7e,},
{0x2b, 0x23,},//Indoor 1A7e //RGB SP Edge Gain2
{0x2c, 0x7f,},
{0x2d, 0x24,},//Indoor 1A7f //RGB SP Edge Gain3
{0x2e, 0x80,},
{0x2f, 0x25,},//Indoor 1A80 //RGB SP Edge Gain4
{0x30, 0x81,},
{0x31, 0x26,},//Indoor 1A81 //RGB SP Edge Gain5
{0x32, 0x82,},
{0x33, 0x28,},//Indoor 1A82 //RGB SP Edge Gain6
{0x34, 0x83,},
{0x35, 0x2b,},//Indoor 1A83 //RGB SP Edge Gain7
{0x36, 0x84,},
{0x37, 0x2d,},//Indoor 1A84 //RGB SP Edge Gain8
{0x38, 0x9e,},
{0x39, 0x22,},//Indoor 1A9e //RGB SP STD Gain1
{0x3a, 0x9f,},
{0x3b, 0x23,},//Indoor 1A9f //RGB SP STD Gain2
{0x3c, 0xa0,},
{0x3d, 0x26,},//Indoor 1Aa0 //RGB SP STD Gain3
{0x3e, 0xa1,},
{0x3f, 0x26,},//Indoor 1Aa1 //RGB SP STD Gain4
{0x40, 0xa2,},
{0x41, 0x26,},//Indoor 1Aa2 //RGB SP STD Gain5
{0x42, 0xa3,},
{0x43, 0x26,},//Indoor 1Aa3 //RGB SP STD Gain6
{0x44, 0xa4,},
{0x45, 0x26,},//Indoor 1Aa4 //RGB SP STD Gain7
{0x46, 0xa5,},
{0x47, 0x26,},//Indoor 1Aa5 //RGB SP STD Gain8
{0x48, 0xa6,},
{0x49, 0x34,},//Indoor 1Aa6 //RGB Post STD Gain Pos/Neg
{0x4a, 0xa7,},
{0x4b, 0x08,},//Indoor 1Aa7 add 720p
{0x4c, 0xa8,},
{0x4d, 0x08,},//Indoor 1Aa8 add 720p
{0x4e, 0xa9,},
{0x4f, 0x08,},//Indoor 1Aa9 add 720p
{0x50, 0xaa,},
{0x51, 0x08,},//Indoor 1Aaa add 720p
{0x52, 0xab,},
{0x53, 0x08,},//Indoor 1Aab add 720p
{0x54, 0xaf,},
{0x55, 0x3f,},//Indoor 1Aaf add 720p
{0x56, 0xb0,},
{0x57, 0x3f,},//Indoor 1Ab0 add 720p
{0x58, 0xb1,},
{0x59, 0x3f,},//Indoor 1Ab1 add 720p
{0x5a, 0xb2,},
{0x5b, 0x3f,},//Indoor 1Ab2 add 720p
{0x5c, 0xb3,},
{0x5d, 0x3f,},//Indoor 1Ab3 add 720p
{0x5e, 0xca,},
{0x5f, 0x00,},//Indoor 1Aca
{0x60, 0xe3,},
{0x61, 0x13,},//Indoor 1Ae3 add
{0x62, 0xe4,},
{0x63, 0x13,},//Indoor 1Ae4 add
{0x64, 0x03,},
{0x65, 0x10,},//10 page
{0x66, 0x70,},
{0x67, 0x0c,},//Indoor 1070 Trans Func.   130618 Indoor transFuc Low 1.0->0.84
{0x68, 0x71,},
{0x69, 0x06,},//Indoor 1071
{0x6a, 0x72,},
{0x6b, 0x85,},//Indoor 1072
{0x6c, 0x73,},
{0x6d, 0x0a,},//Indoor 1073
{0x6e, 0x74,},
{0x6f, 0x00,},//Indoor 1074
{0x70, 0x75,},
{0x71, 0x00,},//Indoor 1075
{0x72, 0x76,},
{0x73, 0x36,},//Indoor 1076
{0x74, 0x77,},
{0x75, 0x47,},//Indoor 1077
{0x76, 0x78,},
{0x77, 0xae,},//Indoor 1078
{0x78, 0x79,},
{0x79, 0x50,},//Indoor 1079
{0x7a, 0x7a,},
{0x7b, 0x00,},//Indoor 107a
{0x7c, 0x7b,},
{0x7d, 0x50,},//Indoor 107b
{0x7e, 0x7c,},
{0x7f, 0x00,},//Indoor 107c
{0x80, 0x7d,},
{0x81, 0x07,},//Indoor 107d
{0x82, 0x7e,},
{0x83, 0x0f,},//Indoor 107e
{0x84, 0x7f,},
{0x85, 0x1e,},//Indoor 107f
{0x86, 0x03,},
{0x87, 0x02,},// 2 page
{0x88, 0x23,},
{0x89, 0x2a,},//Indoor 0223 (for sun-spot) // normal 3c
{0x8a, 0x03,},
{0x8b, 0x03,},// 3 page
{0x8c, 0x1a,},
{0x8d, 0x00,},//Indoor 031a (for sun-spot)
{0x8e, 0x1b,},
{0x8f, 0x8c,},//Indoor 031b (for sun-spot)
{0x90, 0x1c,},
{0x91, 0x02,},//Indoor 031c (for sun-spot)
{0x92, 0x1d,},
{0x93, 0x88,},//Indoor 031d (for sun-spot)
{0x94, 0x03,},
{0x95, 0x11,},// 11 page
{0x96, 0xf0,},
{0x97, 0x03,},//Indoor 11f0 (for af bug)
{0x98, 0x03,},
{0x99, 0x10,},// 10 page
{0x9a, 0x17,},
{0x9b, 0x40,},//Indoor 1017 CSP option


{0x0e, 0x00,}, // burst end

///////////////////////////////////////////////////////////////////////////////
// E4 ~ E6 Page (DMA Dark1)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xe4,}, //DMA E4 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0x77,}, //Dark1 1111 add 720p
{0x14, 0x14,},
{0x15, 0x04,}, //Dark1 1114 add 720p
{0x16, 0x15,},
{0x17, 0x44,}, //Dark1 1115 add 720p
{0x18, 0x16,},
{0x19, 0x44,}, //Dark1 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x58,}, //Dark1 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x30,}, //Dark1 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x12,}, //Dark1 1119 add 720p
{0x20, 0x37,},
{0x21, 0x1f,}, //Dark1 1137 //Pre Flat rate B[4:1]
{0x22, 0x38,},
{0x23, 0x00,}, //Dark1 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0xff,}, //Dark1 1139 //Pre Flat R1 LumH
{0x26, 0x3a,},
{0x27, 0x00,}, //Dark1 113a
{0x28, 0x3b,},
{0x29, 0x00,}, //Dark1 113b
{0x2a, 0x3c,},
{0x2b, 0x00,},//Dark1 113c //Pre Flat R1 DyL
{0x2c, 0x3d,},
{0x2d, 0x53,},//Dark1 113d //Pre Flat R1 DyH
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark1 113e
{0x30, 0x3f,},
{0x31, 0x00,}, //Dark1 113f
{0x32, 0x40,},
{0x33, 0x00,},//Dark1 1140 //Pre Flat R1 STDL
{0x34, 0x41,},
{0x35, 0x2c,},//Dark1 1141 //Pre Flat R1 STDH
{0x36, 0x42,},
{0x37, 0x00,}, //Dark1 1142
{0x38, 0x43,},
{0x39, 0x00,}, //Dark1 1143
{0x3a, 0x49,},
{0x3b, 0x06,}, //Dark1 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x0a,}, //Dark1 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x12,}, //Dark1 114b add 720p
{0x40, 0x4c,},
{0x41, 0x1c,}, //Dark1 114c add 720p
{0x42, 0x4d,},
{0x43, 0x24,}, //Dark1 114d add 720p
{0x44, 0x4e,},
{0x45, 0x40,}, //Dark1 114e add 720p
{0x46, 0x4f,},
{0x47, 0x80,}, //Dark1 114f add 720p
{0x48, 0x50,},
{0x49, 0x3f,}, //Dark1 1150
{0x4a, 0x51,},
{0x4b, 0x3f,}, //Dark1 1151
{0x4c, 0x52,},
{0x4d, 0x3f,}, //Dark1 1152
{0x4e, 0x53,},
{0x4f, 0x3d,}, //Dark1 1153
{0x50, 0x54,},
{0x51, 0x3c,}, //Dark1 1154
{0x52, 0x55,},
{0x53, 0x38,}, //Dark1 1155
{0x54, 0x56,},
{0x55, 0x36,}, //Dark1 1156
{0x56, 0x57,},
{0x57, 0x34,}, //Dark1 1157
{0x58, 0x58,},
{0x59, 0x10,}, //Dark1 1158
{0x5a, 0x59,},
{0x5b, 0x10,}, //Dark1 1159
{0x5c, 0x5a,},
{0x5d, 0x10,}, //Dark1 115a
{0x5e, 0x5b,},
{0x5f, 0x10,}, //Dark1 115b
{0x60, 0x5c,},
{0x61, 0x10,}, //Dark1 115c
{0x62, 0x5d,},
{0x63, 0x10,}, //Dark1 115d
{0x64, 0x5e,},
{0x65, 0x10,}, //Dark1 115e
{0x66, 0x5f,},
{0x67, 0x10,}, //Dark1 115f
{0x68, 0x6e,},
{0x69, 0x20,}, //Dark1 116e
{0x6a, 0x6f,},
{0x6b, 0x18,}, //Dark1 116f
{0x6c, 0x77,},
{0x6d, 0x12,},//Dark1 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x0f,},//Dark1 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x0e,},//Dark1 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x0e,},//Dark1 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x0e,},//Dark1 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,},//Dark1 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x12,}, //Dark1 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x12,}, //Dark1 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x12,}, //Dark1 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x0f,}, //Dark1 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x0f,}, //Dark1 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x12,}, //Dark1 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x12,}, //Dark1 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x12,}, //Dark1 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x12,}, //Dark1 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x12,}, //Dark1 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x0f,}, //Dark1 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x0f,}, //Dark1 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x12,}, //Dark1 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x12,}, //Dark1 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x12,}, //Dark1 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x12,}, //Dark1 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark1 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x12,}, //Dark1 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x0f,}, //Dark1 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x0f,}, //Dark1 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x12,}, //Dark1 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x12,}, //Dark1 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x12,}, //Dark1 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x12,}, //Dark1 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark1 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x12,}, //Dark1 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x1c,}, //Dark1 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark1 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark1 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x18,}, //Dark1 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x1d,}, //Dark1 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x20,}, //Dark1 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x20,}, //Dark1 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x20,}, //Dark1 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x22,}, //Dark1 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x22,}, //Dark1 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x21,}, //Dark1 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x1e,}, //Dark1 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x1c,}, //Dark1 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x1a,}, //Dark1 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x12,}, //Dark1 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x12,}, //Dark1 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x13,}, //Dark1 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x18,}, //Dark1 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark1 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x18,}, //Dark1 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x18,}, //Dark1 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x18,}, //Dark1 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark1 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0xff,}, //Dark1 11d1
{0xde, 0xd2,},
{0xdf, 0x00,}, //Dark1 11d2
{0xe0, 0xd3,},
{0xe1, 0xff,}, //Dark1 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark1 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x40,},//Dark1 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark1 11d6
{0xe8, 0xd7,},
{0xe9, 0x2a,}, //Dark1 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark1 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x27,}, //Dark1 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark1 11da
{0xf0, 0xdb,},
{0xf1, 0x20,}, //Dark1 11db
{0xf2, 0xdf,},
{0xf3, 0xff,}, //Dark1 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x32,}, //Dark1 11e0
{0xf6, 0xe1,},
{0xf7, 0x7a,}, //Dark1 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark1 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0x00,}, //Dark1 11e3
{0xfc, 0xe4,},
{0xfd, 0x01,}, //Dark1 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe5,}, //DMA E5 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x21,}, //Dark1 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark1 11e6
{0x14, 0xe7,},
{0x15, 0x00,}, //Dark1 11e7
{0x16, 0xe8,},
{0x17, 0x01,}, //Dark1 11e8
{0x18, 0xe9,},
{0x19, 0x1d,}, //Dark1 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark1 11ea
{0x1c, 0xeb,},
{0x1d, 0x00,}, //Dark1 11eb
{0x1e, 0xef,},
{0x1f, 0xff,}, //Dark1 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,},//12 Page
{0x22, 0x12,},
{0x23, 0x03,},//Dark1 1212
{0x24, 0x33,},
{0x25, 0x16,},//Dark1 1233 add 20130603 Skin_th
{0x26, 0x34,},
{0x27, 0x90,},//Dark1 1234 add 20130603 Cyan_th
{0x28, 0x40,},
{0x29, 0x37,},//Dark1 1240 add 720p
{0x2a, 0x70,},
{0x2b, 0xbf,},//Dark1 1270 // Bayer Sharpness ENB add 720p
{0x2c, 0x71,},
{0x2d, 0x1a,},//Dark1 1271 //Bayer HPF Gain
{0x2e, 0x72,},
{0x2f, 0x16,},//Dark1 1272 //Bayer LPF Gain
{0x30, 0x77,},
{0x31, 0x36,},//Dark1 1277
{0x32, 0x78,},
{0x33, 0x2f,},//Dark1 1278
{0x34, 0x79,},
{0x35, 0xff,},//Dark1 1279
{0x36, 0x7a,},
{0x37, 0x50,},//Dark1 127a
{0x38, 0x7b,},
{0x39, 0x10,},//Dark1 127b
{0x3a, 0x7c,},
{0x3b, 0x64,},//Dark1 127c //skin HPF gain
{0x3c, 0x7d,},
{0x3d, 0x20,},//Dark1 127d
{0x3e, 0x7f,},
{0x3f, 0x50,},//Dark1 127f
{0x40, 0x87,},
{0x41, 0x3f,},//Dark1 1287 add 720p
{0x42, 0x88,},
{0x43, 0x3f,},//Dark1 1288 add 720p
{0x44, 0x89,},
{0x45, 0x3f,},//Dark1 1289 add 720p
{0x46, 0x8a,},
{0x47, 0x3f,},//Dark1 128a add 720p
{0x48, 0x8b,},
{0x49, 0x3f,},//Dark1 128b add 720p
{0x4a, 0x8c,},
{0x4b, 0x3f,},//Dark1 128c add 720p
{0x4c, 0x8d,},
{0x4d, 0x3f,},//Dark1 128d add 720p
{0x4e, 0x8e,},
{0x4f, 0x3f,},//Dark1 128e add 720p
{0x50, 0x8f,},
{0x51, 0x3f,},//Dark1 128f add 720p
{0x52, 0x90,},
{0x53, 0x3f,},//Dark1 1290 add 720p
{0x54, 0x91,},
{0x55, 0x3f,},//Dark1 1291 add 720p
{0x56, 0x92,},
{0x57, 0x3f,},//Dark1 1292 add 720p
{0x58, 0x93,},
{0x59, 0x3f,},//Dark1 1293 add 720p
{0x5a, 0x94,},
{0x5b, 0x3f,},//Dark1 1294 add 720p
{0x5c, 0x95,},
{0x5d, 0x3f,},//Dark1 1295 add 720p
{0x5e, 0x96,},
{0x5f, 0x3f,},//Dark1 1296 add 720p
{0x60, 0xae,},
{0x61, 0x7f,},//Dark1 12ae
{0x62, 0xaf,},
{0x63, 0x00,},//Dark1 12af // B[7:4]Blue/B[3:0]Skin
{0x64, 0xc0,},
{0x65, 0x23,},//Dark1 12c0 // CI-LPF ENB add 720p
{0x66, 0xc3,},
{0x67, 0x3c,},//Dark1 12c3 add 720p
{0x68, 0xc4,},
{0x69, 0x1a,},//Dark1 12c4 add 720p
{0x6a, 0xc5,},
{0x6b, 0x0c,},//Dark1 12c5 add 720p
{0x6c, 0xc6,},
{0x6d, 0x44,},//Dark1 12c6
{0x6e, 0xc7,},
{0x6f, 0x44,},//Dark1 12c7
{0x70, 0xc8,},
{0x71, 0x3e,},//Dark1 12c8
{0x72, 0xd0,},
{0x73, 0x08,},//Dark1 12d0 add 720p
{0x74, 0xd1,},
{0x75, 0x10,},//Dark1 12d1 add 720p
{0x76, 0xd2,},
{0x77, 0x18,},//Dark1 12d2 add 720p
{0x78, 0xd3,},
{0x79, 0x20,},//Dark1 12d3 add 720p
{0x7a, 0xd4,},
{0x7b, 0x30,},//Dark1 12d4 add 720p
{0x7c, 0xd5,},
{0x7d, 0x60,},//Dark1 12d5 add 720p
{0x7e, 0xd6,},
{0x7f, 0x80,},//Dark1 12d6 add 720p
{0x80, 0xd7,},
{0x81, 0x38,},//Dark1 12d7
{0x82, 0xd8,},
{0x83, 0x30,},//Dark1 12d8
{0x84, 0xd9,},
{0x85, 0x2a,},//Dark1 12d9
{0x86, 0xda,},
{0x87, 0x2a,},//Dark1 12da
{0x88, 0xdb,},
{0x89, 0x24,},//Dark1 12db
{0x8a, 0xdc,},
{0x8b, 0x20,},//Dark1 12dc
{0x8c, 0xdd,},
{0x8d, 0x1a,},//Dark1 12dd
{0x8e, 0xde,},
{0x8f, 0x16,},//Dark1 12de
{0x90, 0xe0,},
{0x91, 0x63,},//Dark1 12e0 // 20121120 ln dy
{0x92, 0xe1,},
{0x93, 0xfc,},//Dark1 12e1
{0x94, 0xe2,},
{0x95, 0x02,},//Dark1 12e2
{0x96, 0xe3,},
{0x97, 0x10,},//Dark1 12e3 //PS LN graph Y1
{0x98, 0xe4,},
{0x99, 0x12,},//Dark1 12e4 //PS LN graph Y2
{0x9a, 0xe5,},
{0x9b, 0x1a,},//Dark1 12e5 //PS LN graph Y3
{0x9c, 0xe6,},
{0x9d, 0x1d,},//Dark1 12e6 //PS LN graph Y4
{0x9e, 0xe7,},
{0x9f, 0x1e,},//Dark1 12e7 //PS LN graph Y5
{0xa0, 0xe8,},
{0xa1, 0x1f,},//Dark1 12e8 //PS LN graph Y6
{0xa2, 0xe9,},
{0xa3, 0x10,},//Dark1 12e9 //PS DY graph Y1
{0xa4, 0xea,},
{0xa5, 0x12,},//Dark1 12ea //PS DY graph Y2
{0xa6, 0xeb,},
{0xa7, 0x18,},//Dark1 12eb //PS DY graph Y3
{0xa8, 0xec,},
{0xa9, 0x1c,},//Dark1 12ec //PS DY graph Y4
{0xaa, 0xed,},
{0xab, 0x1e,},//Dark1 12ed //PS DY graph Y5
{0xac, 0xee,},
{0xad, 0x1f,},//Dark1 12ee //PS DY graph Y6
{0xae, 0xf0,},
{0xaf, 0x00,},//Dark1 12f0
{0xb0, 0xf1,},
{0xb1, 0x2a,},//Dark1 12f1
{0xb2, 0xf2,},
{0xb3, 0x32,},//Dark1 12f2
{0xb4, 0x03,},
{0xb5, 0x13,},//13 Page
{0xb6, 0x10,},
{0xb7, 0x81,},//Dark1 1310 //Y-NR ENB add 720p
{0xb8, 0x30,},
{0xb9, 0x20,},//Dark1 1330
{0xba, 0x31,},
{0xbb, 0x20,},//Dark1 1331
{0xbc, 0x32,},
{0xbd, 0x20,},//Dark1 1332
{0xbe, 0x33,},
{0xbf, 0x20,},//Dark1 1333
{0xc0, 0x34,},
{0xc1, 0x20,},//Dark1 1334
{0xc2, 0x35,},
{0xc3, 0x20,},//Dark1 1335
{0xc4, 0x36,},
{0xc5, 0x20,},//Dark1 1336
{0xc6, 0x37,},
{0xc7, 0x20,},//Dark1 1337
{0xc8, 0x38,},
{0xc9, 0x02,},//Dark1 1338
{0xca, 0x40,},
{0xcb, 0x18,},//Dark1 1340
{0xcc, 0x41,},
{0xcd, 0x36,},//Dark1 1341
{0xce, 0x42,},
{0xcf, 0x62,},//Dark1 1342
{0xd0, 0x43,},
{0xd1, 0x63,},//Dark1 1343
{0xd2, 0x44,},
{0xd3, 0xff,},//Dark1 1344
{0xd4, 0x45,},
{0xd5, 0x04,},//Dark1 1345
{0xd6, 0x46,},
{0xd7, 0x45,},//Dark1 1346
{0xd8, 0x47,},
{0xd9, 0x05,},//Dark1 1347
{0xda, 0x48,},
{0xdb, 0x65,},//Dark1 1348
{0xdc, 0x49,},
{0xdd, 0x02,},//Dark1 1349
{0xde, 0x4a,},
{0xdf, 0x22,},//Dark1 134a
{0xe0, 0x4b,},
{0xe1, 0x06,},//Dark1 134b
{0xe2, 0x4c,},
{0xe3, 0x30,},//Dark1 134c
{0xe4, 0x83,},
{0xe5, 0x08,},//Dark1 1383
{0xe6, 0x84,},
{0xe7, 0x0a,},//Dark1 1384
{0xe8, 0xb7,},
{0xe9, 0xfa,},//Dark1 13b7
{0xea, 0xb8,},
{0xeb, 0x77,},//Dark1 13b8
{0xec, 0xb9,},
{0xed, 0xfe,},//Dark1 13b9 //20121217 DC R1,2 CR
{0xee, 0xba,},
{0xef, 0xca,},//Dark1 13ba //20121217 DC R3,4 CR
{0xf0, 0xbd,},
{0xf1, 0x78,},//Dark1 13bd //20121121 c-filter LumHL DC rate
{0xf2, 0xc5,},
{0xf3, 0x01,},//Dark1 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xf4, 0xc6,},
{0xf5, 0x22,},//Dark1 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf6, 0xc7,},
{0xf7, 0x33,},//Dark1 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf8, 0x03,},
{0xf9, 0x14,},//14 page
{0xfa, 0x10,},
{0xfb, 0xb3,},//Dark1 1410
{0xfc, 0x11,},
{0xfd, 0x98,},//Dark1 1411

{0x0e, 0x00,}, // burst end

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x12,},
{0x11, 0x10,},//Dark1 1412
{0x12, 0x13,},
{0x13, 0x03,},//Dark1 1413
{0x14, 0x14,},
{0x15, 0x23,},//Dark1 1414 //YC2D Low Gain B[5:0]
{0x16, 0x15,},
{0x17, 0x7b,},//Dark1 1415 // Y Hi filter mask 1/16
{0x18, 0x16,},
{0x19, 0x10,},//Dark1 1416 //YC2D Hi Gain B[5:0]
{0x1a, 0x17,},
{0x1b, 0x40,},//Dark1 1417
{0x1c, 0x18,},
{0x1d, 0x0c,},//Dark1 1418
{0x1e, 0x19,},
{0x1f, 0x0c,},//Dark1 1419
{0x20, 0x1a,},
{0x21, 0x24,},//Dark1 141a //YC2D Post STD gain Pos
{0x22, 0x1b,},
{0x23, 0x24,},//Dark1 141b //YC2D Post STD gain Neg
{0x24, 0x27,},
{0x25, 0x14,},//Dark1 1427 //YC2D SP Lum Gain Pos1
{0x26, 0x28,},
{0x27, 0x14,},//Dark1 1428 //YC2D SP Lum Gain Pos2
{0x28, 0x29,},
{0x29, 0x14,},//Dark1 1429 //YC2D SP Lum Gain Pos3
{0x2a, 0x2a,},
{0x2b, 0x14,},//Dark1 142a //YC2D SP Lum Gain Pos4
{0x2c, 0x2b,},
{0x2d, 0x14,},//Dark1 142b //YC2D SP Lum Gain Pos5
{0x2e, 0x2c,},
{0x2f, 0x14,},//Dark1 142c //YC2D SP Lum Gain Pos6
{0x30, 0x2d,},
{0x31, 0x14,},//Dark1 142d //YC2D SP Lum Gain Pos7
{0x32, 0x2e,},
{0x33, 0x14,},//Dark1 142e //YC2D SP Lum Gain Pos8
{0x34, 0x30,},
{0x35, 0x12,},//Dark1 1430 //YC2D SP Lum Gain Neg1
{0x36, 0x31,},
{0x37, 0x12,},//Dark1 1431 //YC2D SP Lum Gain Neg2
{0x38, 0x32,},
{0x39, 0x12,},//Dark1 1432 //YC2D SP Lum Gain Neg3
{0x3a, 0x33,},
{0x3b, 0x12,},//Dark1 1433 //YC2D SP Lum Gain Neg4
{0x3c, 0x34,},
{0x3d, 0x12,},//Dark1 1434 //YC2D SP Lum Gain Neg5
{0x3e, 0x35,},
{0x3f, 0x12,},//Dark1 1435 //YC2D SP Lum Gain Neg6
{0x40, 0x36,},
{0x41, 0x12,},//Dark1 1436 //YC2D SP Lum Gain Neg7
{0x42, 0x37,},
{0x43, 0x12,},//Dark1 1437 //YC2D SP Lum Gain Neg8
{0x44, 0x47,},
{0x45, 0x14,},//Dark1 1447 //YC2D SP Dy Gain Pos1
{0x46, 0x48,},
{0x47, 0x14,},//Dark1 1448 //YC2D SP Dy Gain Pos2
{0x48, 0x49,},
{0x49, 0x14,},//Dark1 1449 //YC2D SP Dy Gain Pos3
{0x4a, 0x4a,},
{0x4b, 0x14,},//Dark1 144a //YC2D SP Dy Gain Pos4
{0x4c, 0x4b,},
{0x4d, 0x14,},//Dark1 144b //YC2D SP Dy Gain Pos5
{0x4e, 0x4c,},
{0x4f, 0x14,},//Dark1 144c //YC2D SP Dy Gain Pos6
{0x50, 0x4d,},
{0x51, 0x14,},//Dark1 144d //YC2D SP Dy Gain Pos7
{0x52, 0x4e,},
{0x53, 0x14,},//Dark1 144e //YC2D SP Dy Gain Pos8
{0x54, 0x50,},
{0x55, 0x12,},//Dark1 1450 //YC2D SP Dy Gain Neg1
{0x56, 0x51,},
{0x57, 0x12,},//Dark1 1451 //YC2D SP Dy Gain Neg2
{0x58, 0x52,},
{0x59, 0x12,},//Dark1 1452 //YC2D SP Dy Gain Neg3
{0x5a, 0x53,},
{0x5b, 0x12,},//Dark1 1453 //YC2D SP Dy Gain Neg4
{0x5c, 0x54,},
{0x5d, 0x12,},//Dark1 1454 //YC2D SP Dy Gain Neg5
{0x5e, 0x55,},
{0x5f, 0x12,},//Dark1 1455 //YC2D SP Dy Gain Neg6
{0x60, 0x56,},
{0x61, 0x12,},//Dark1 1456 //YC2D SP Dy Gain Neg7
{0x62, 0x57,},
{0x63, 0x12,},//Dark1 1457 //YC2D SP Dy Gain Neg8
{0x64, 0x67,},
{0x65, 0x20,},//Dark1 1467 //YC2D SP Edge Gain1
{0x66, 0x68,},
{0x67, 0x20,},//Dark1 1468 //YC2D SP Edge Gain2
{0x68, 0x69,},
{0x69, 0x20,},//Dark1 1469 //YC2D SP Edge Gain3
{0x6a, 0x6a,},
{0x6b, 0x20,},//Dark1 146a //YC2D SP Edge Gain4
{0x6c, 0x6b,},
{0x6d, 0x20,},//Dark1 146b //YC2D SP Edge Gain5
{0x6e, 0x6c,},
{0x6f, 0x20,},//Dark1 146c //YC2D SP Edge Gain6
{0x70, 0x6d,},
{0x71, 0x20,},//Dark1 146d //YC2D SP Edge Gain7
{0x72, 0x6e,},
{0x73, 0x20,},//Dark1 146e //YC2D SP Edge Gain8
{0x74, 0x87,},
{0x75, 0x2a,},//Dark1 1487 //YC2D SP STD Gain1
{0x76, 0x88,},
{0x77, 0x2a,},//Dark1 1488 //YC2D SP STD Gain2
{0x78, 0x89,},
{0x79, 0x2a,},//Dark1 1489 //YC2D SP STD Gain3
{0x7a, 0x8a,},
{0x7b, 0x2a,},//Dark1 148a //YC2D SP STD Gain4
{0x7c, 0x8b,},
{0x7d, 0x2a,},//Dark1 148b //YC2D SP STD Gain5
{0x7e, 0x8c,},
{0x7f, 0x1a,},//Dark1 148c //YC2D SP STD Gain6
{0x80, 0x8d,},
{0x81, 0x1a,},//Dark1 148d //YC2D SP STD Gain7
{0x82, 0x8e,},
{0x83, 0x1a,},//Dark1 148e //YC2D SP STD Gain8
{0x84, 0x97,},
{0x85, 0x3f,},//Dark1 1497 add 720p
{0x86, 0x98,},
{0x87, 0x3f,},//Dark1 1498 add 720p
{0x88, 0x99,},
{0x89, 0x3f,},//Dark1 1499 add 720p
{0x8a, 0x9a,},
{0x8b, 0x3f,},//Dark1 149a add 720p
{0x8c, 0x9b,},
{0x8d, 0x3f,},//Dark1 149b add 720p
{0x8e, 0xa0,},
{0x8f, 0x3f,},//Dark1 14a0 add 720p
{0x90, 0xa1,},
{0x91, 0x3f,},//Dark1 14a1 add 720p
{0x92, 0xa2,},
{0x93, 0x3f,},//Dark1 14a2 add 720p
{0x94, 0xa3,},
{0x95, 0x3f,},//Dark1 14a3 add 720p
{0x96, 0xa4,},
{0x97, 0x3f,},//Dark1 14a4 add 720p
{0x98, 0xc9,},
{0x99, 0x13,},//Dark1 14c9
{0x9a, 0xca,},
{0x9b, 0x27,},//Dark1 14ca
{0x9c, 0x03,},
{0x9d, 0x1a,},//1A page
{0x9e, 0x10,},
{0x9f, 0x15,},//Dark1 1A10 add 720p
{0xa0, 0x18,},
{0xa1, 0x3f,},//Dark1 1A18
{0xa2, 0x19,},
{0xa3, 0x3f,},//Dark1 1A19
{0xa4, 0x1a,},
{0xa5, 0x2a,},//Dark1 1A1a
{0xa6, 0x1b,},
{0xa7, 0x27,},//Dark1 1A1b
{0xa8, 0x1c,},
{0xa9, 0x23,},//Dark1 1A1c
{0xaa, 0x1d,},
{0xab, 0x23,},//Dark1 1A1d
{0xac, 0x1e,},
{0xad, 0x23,},//Dark1 1A1e
{0xae, 0x1f,},
{0xaf, 0x23,},//Dark1 1A1f
{0xb0, 0x20,},
{0xb1, 0xe7,},//Dark1 1A20 add 720p
{0xb2, 0x2f,},
{0xb3, 0xf1,},//Dark1 1A2f add 720p
{0xb4, 0x32,},
{0xb5, 0x87,},//Dark1 1A32 add 720p
{0xb6, 0x34,},
{0xb7, 0xd0,},//Dark1 1A34 //RGB High Gain B[5:0]
{0xb8, 0x35,},
{0xb9, 0x11,},//Dark1 1A35 //RGB Low Gain B[5:0]
{0xba, 0x36,},
{0xbb, 0x00,},//Dark1 1A36
{0xbc, 0x37,},
{0xbd, 0x40,},//Dark1 1A37
{0xbe, 0x38,},
{0xbf, 0xff,},//Dark1 1A38
{0xc0, 0x39,},
{0xc1, 0x11,},//Dark1 1A39 //RGB Flat R2_Lum L
{0xc2, 0x3a,},
{0xc3, 0x3f,},//Dark1 1A3a
{0xc4, 0x3b,},
{0xc5, 0x00,},//Dark1 1A3b
{0xc6, 0x3c,},
{0xc7, 0x4c,},//Dark1 1A3c
{0xc8, 0x3d,},
{0xc9, 0x00,},//Dark1 1A3d
{0xca, 0x3e,},
{0xcb, 0x13,},//Dark1 1A3e
{0xcc, 0x3f,},
{0xcd, 0x00,},//Dark1 1A3f
{0xce, 0x40,},
{0xcf, 0x2a,},//Dark1 1A40
{0xd0, 0x41,},
{0xd1, 0x00,},//Dark1 1A41
{0xd2, 0x42,},
{0xd3, 0x17,},//Dark1 1A42
{0xd4, 0x43,},
{0xd5, 0x2c,},//Dark1 1A43
{0xd6, 0x4d,},
{0xd7, 0x08,},//Dark1 1A4d //RGB SP Lum Gain Neg1
{0xd8, 0x4e,},
{0xd9, 0x0a,},//Dark1 1A4e //RGB SP Lum Gain Neg2
{0xda, 0x4f,},
{0xdb, 0x10,},//Dark1 1A4f //RGB SP Lum Gain Neg3
{0xdc, 0x50,},
{0xdd, 0x12,},//Dark1 1A50 //RGB SP Lum Gain Neg4
{0xde, 0x51,},
{0xdf, 0x12,},//Dark1 1A51 //RGB SP Lum Gain Neg5
{0xe0, 0x52,},
{0xe1, 0x12,},//Dark1 1A52 //RGB SP Lum Gain Neg6
{0xe2, 0x53,},
{0xe3, 0x12,},//Dark1 1A53 //RGB SP Lum Gain Neg7
{0xe4, 0x54,},
{0xe5, 0x12,},//Dark1 1A54 //RGB SP Lum Gain Neg8
{0xe6, 0x55,},
{0xe7, 0x12,},//Dark1 1A55 //RGB SP Lum Gain Pos1
{0xe8, 0x56,},
{0xe9, 0x12,},//Dark1 1A56 //RGB SP Lum Gain Pos2
{0xea, 0x57,},
{0xeb, 0x12,},//Dark1 1A57 //RGB SP Lum Gain Pos3
{0xec, 0x58,},
{0xed, 0x12,},//Dark1 1A58 //RGB SP Lum Gain Pos4
{0xee, 0x59,},
{0xef, 0x12,},//Dark1 1A59 //RGB SP Lum Gain Pos5
{0xf0, 0x5a,},
{0xf1, 0x12,},//Dark1 1A5a //RGB SP Lum Gain Pos6
{0xf2, 0x5b,},
{0xf3, 0x12,},//Dark1 1A5b //RGB SP Lum Gain Pos7
{0xf4, 0x5c,},
{0xf5, 0x12,},//Dark1 1A5c //RGB SP Lum Gain Pos8
{0xf6, 0x65,},
{0xf7, 0x12,},//Dark1 1A65 //RGB SP Dy Gain Neg1
{0xf8, 0x66,},
{0xf9, 0x12,},//Dark1 1A66 //RGB SP Dy Gain Neg2
{0xfa, 0x67,},
{0xfb, 0x12,},//Dark1 1A67 //RGB SP Dy Gain Neg3
{0xfc, 0x68,},
{0xfd, 0x12,},//Dark1 1A68 //RGB SP Dy Gain Neg4

{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E6 page.
{0xDC, 0x2E,},
{0xDD, 0xB2,},

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x69,},
{0x11, 0x12,},//Dark1 1A69 //RGB SP Dy Gain Neg5
{0x12, 0x6a,},
{0x13, 0x12,},//Dark1 1A6a //RGB SP Dy Gain Neg6
{0x14, 0x6b,},
{0x15, 0x12,},//Dark1 1A6b //RGB SP Dy Gain Neg7
{0x16, 0x6c,},
{0x17, 0x12,},//Dark1 1A6c //RGB SP Dy Gain Neg8
{0x18, 0x6d,},
{0x19, 0x12,},//Dark1 1A6d //RGB SP Dy Gain Pos1
{0x1a, 0x6e,},
{0x1b, 0x12,},//Dark1 1A6e //RGB SP Dy Gain Pos2
{0x1c, 0x6f,},
{0x1d, 0x12,},//Dark1 1A6f //RGB SP Dy Gain Pos3
{0x1e, 0x70,},
{0x1f, 0x12,},//Dark1 1A70 //RGB SP Dy Gain Pos4
{0x20, 0x71,},
{0x21, 0x12,},//Dark1 1A71 //RGB SP Dy Gain Pos5
{0x22, 0x72,},
{0x23, 0x12,},//Dark1 1A72 //RGB SP Dy Gain Pos6
{0x24, 0x73,},
{0x25, 0x12,},//Dark1 1A73 //RGB SP Dy Gain Pos7
{0x26, 0x74,},
{0x27, 0x12,},//Dark1 1A74 //RGB SP Dy Gain Pos8
{0x28, 0x7d,},
{0x29, 0x20,},//Dark1 1A7d //RGB SP Edge Gain1
{0x2a, 0x7e,},
{0x2b, 0x20,},//Dark1 1A7e //RGB SP Edge Gain2
{0x2c, 0x7f,},
{0x2d, 0x20,},//Dark1 1A7f //RGB SP Edge Gain3
{0x2e, 0x80,},
{0x2f, 0x20,},//Dark1 1A80 //RGB SP Edge Gain4
{0x30, 0x81,},
{0x31, 0x20,},//Dark1 1A81 //RGB SP Edge Gain5
{0x32, 0x82,},
{0x33, 0x20,},//Dark1 1A82 //RGB SP Edge Gain6
{0x34, 0x83,},
{0x35, 0x20,},//Dark1 1A83 //RGB SP Edge Gain7
{0x36, 0x84,},
{0x37, 0x20,},//Dark1 1A84 //RGB SP Edge Gain8
{0x38, 0x9e,},
{0x39, 0x1a,},//Dark1 1A9e //RGB SP STD Gain1
{0x3a, 0x9f,},
{0x3b, 0x1a,},//Dark1 1A9f //RGB SP STD Gain2
{0x3c, 0xa0,},
{0x3d, 0x1a,},//Dark1 1Aa0 //RGB SP STD Gain3
{0x3e, 0xa1,},
{0x3f, 0x1a,},//Dark1 1Aa1 //RGB SP STD Gain4
{0x40, 0xa2,},
{0x41, 0x1a,},//Dark1 1Aa2 //RGB SP STD Gain5
{0x42, 0xa3,},
{0x43, 0x1a,},//Dark1 1Aa3 //RGB SP STD Gain6
{0x44, 0xa4,},
{0x45, 0x1a,},//Dark1 1Aa4 //RGB SP STD Gain7
{0x46, 0xa5,},
{0x47, 0x1a,},//Dark1 1Aa5 //RGB SP STD Gain8
{0x48, 0xa6,},
{0x49, 0x36,},//Dark1 1Aa6 //RGB Post STD Gain Pos/Neg
{0x4a, 0xa7,},
{0x4b, 0x08,},//Dark1 1Aa7 add 720p
{0x4c, 0xa8,},
{0x4d, 0x08,},//Dark1 1Aa8 add 720p
{0x4e, 0xa9,},
{0x4f, 0x08,},//Dark1 1Aa9 add 720p
{0x50, 0xaa,},
{0x51, 0x08,},//Dark1 1Aaa add 720p
{0x52, 0xab,},
{0x53, 0x08,},//Dark1 1Aab add 720p
{0x54, 0xaf,},
{0x55, 0x3f,},//Dark1 1Aaf add 720p
{0x56, 0xb0,},
{0x57, 0x3f,},//Dark1 1Ab0 add 720p
{0x58, 0xb1,},
{0x59, 0x3f,},//Dark1 1Ab1 add 720p
{0x5a, 0xb2,},
{0x5b, 0x3f,},//Dark1 1Ab2 add 720p
{0x5c, 0xb3,},
{0x5d, 0x3f,},//Dark1 1Ab3 add 720p
{0x5e, 0xca,},
{0x5f, 0x00,},//Dark1 1Aca
{0x60, 0xe3,},
{0x61, 0x13,},//Dark1 1Ae3 add 720p
{0x62, 0xe4,},
{0x63, 0x13,},//Dark1 1Ae4 add 720p
{0x64, 0x03,},
{0x65, 0x10,},//10 page
{0x66, 0x70,},
{0x67, 0x0c,},//Dark1 1070 Trans Func.   130108 Dark1 transFuc Flat graph
{0x68, 0x71,},
{0x69, 0x0a,},//Dark1 1071
{0x6a, 0x72,},
{0x6b, 0xbe,},//Dark1 1072
{0x6c, 0x73,},
{0x6d, 0xcc,},//Dark1 1073
{0x6e, 0x74,},
{0x6f, 0x00,},//Dark1 1074
{0x70, 0x75,},
{0x71, 0x00,},//Dark1 1075
{0x72, 0x76,},
{0x73, 0x20,},//Dark1 1076
{0x74, 0x77,},
{0x75, 0x33,},//Dark1 1077
{0x76, 0x78,},
{0x77, 0x33,},//Dark1 1078
{0x78, 0x79,},
{0x79, 0x49,},//Dark1 1079
{0x7a, 0x7a,},
{0x7b, 0x99,},//Dark1 107a
{0x7c, 0x7b,},
{0x7d, 0x49,},//Dark1 107b
{0x7e, 0x7c,},
{0x7f, 0x99,},//Dark1 107c
{0x80, 0x7d,},
{0x81, 0x07,},//Dark1 107d
{0x82, 0x7e,},
{0x83, 0x0f,},//Dark1 107e
{0x84, 0x7f,},
{0x85, 0x1e,},//Dark1 107f
{0x86, 0x03,},
{0x87, 0x02,},// 2 page
{0x88, 0x23,},
{0x89, 0x10,},//Dark1 0223 (for sun-spot) // normal 3c
{0x8a, 0x03,},
{0x8b, 0x03,},// 3 page
{0x8c, 0x1a,},
{0x8d, 0x06,},//Dark1 031a (for sun-spot)
{0x8e, 0x1b,},
{0x8f, 0x7c,},//Dark1 031b (for sun-spot)
{0x90, 0x1c,},
{0x91, 0x00,},//Dark1 031c (for sun-spot)
{0x92, 0x1d,},
{0x93, 0x50,},//Dark1 031d (for sun-spot)
{0x94, 0x03,},
{0x95, 0x11,},// 11 page
{0x96, 0xf0,},
{0x97, 0x04,},//Dark1 11f0 (for af bug)
{0x98, 0x03,},
{0x99, 0x10,},// 10 page
{0x9a, 0x17,},
{0x9b, 0x40,},//Dark1 1017 CSP option

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////////////////////////////////////////
// E7 ~ E9 Page (DMA Dark2)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xe7,}, //DMA E7 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0x77,}, //Dark2 1111 add 720p
{0x14, 0x14,},
{0x15, 0x04,}, //Dark2 1114 add 720p
{0x16, 0x15,},
{0x17, 0x44,}, //Dark2 1115 add 720p
{0x18, 0x16,},
{0x19, 0x44,}, //Dark2 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x58,}, //Dark2 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x30,}, //Dark2 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x12,}, //Dark2 1119 add 720p
{0x20, 0x37,},
{0x21, 0x1f,}, //Dark2 1137 //Pre Flat rate B[4:1]
{0x22, 0x38,},
{0x23, 0x00,}, //Dark2 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0xff,}, //Dark2 1139 //Pre Flat R1 LumH
{0x26, 0x3a,},
{0x27, 0x00,}, //Dark2 113a
{0x28, 0x3b,},
{0x29, 0x00,}, //Dark2 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Dark2 113c
{0x2c, 0x3d,},
{0x2d, 0x53,}, //Dark2 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark2 113e
{0x30, 0x3f,},
{0x31, 0x00,}, //Dark2 113f
{0x32, 0x40,},
{0x33, 0x00,},//Dark2 1140
{0x34, 0x41,},
{0x35, 0x2c,},//Dark2 1141
{0x36, 0x42,},
{0x37, 0x00,},//Dark2 1142
{0x38, 0x43,},
{0x39, 0x00,}, //Dark2 1143
{0x3a, 0x49,},
{0x3b, 0x06,}, //Dark2 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x0a,}, //Dark2 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x12,}, //Dark2 114b add 720p
{0x40, 0x4c,},
{0x41, 0x1c,}, //Dark2 114c add 720p
{0x42, 0x4d,},
{0x43, 0x24,}, //Dark2 114d add 720p
{0x44, 0x4e,},
{0x45, 0x40,}, //Dark2 114e add 720p
{0x46, 0x4f,},
{0x47, 0x80,}, //Dark2 114f add 720p
{0x48, 0x50,},
{0x49, 0x3f,}, //Dark2 1150
{0x4a, 0x51,},
{0x4b, 0x3f,}, //Dark2 1151
{0x4c, 0x52,},
{0x4d, 0x3f,}, //Dark2 1152
{0x4e, 0x53,},
{0x4f, 0x3d,}, //Dark2 1153
{0x50, 0x54,},
{0x51, 0x3c,}, //Dark2 1154
{0x52, 0x55,},
{0x53, 0x38,}, //Dark2 1155
{0x54, 0x56,},
{0x55, 0x36,}, //Dark2 1156
{0x56, 0x57,},
{0x57, 0x34,}, //Dark2 1157
{0x58, 0x58,},
{0x59, 0x10,}, //Dark2 1158
{0x5a, 0x59,},
{0x5b, 0x10,}, //Dark2 1159
{0x5c, 0x5a,},
{0x5d, 0x10,}, //Dark2 115a
{0x5e, 0x5b,},
{0x5f, 0x10,}, //Dark2 115b
{0x60, 0x5c,},
{0x61, 0x10,}, //Dark2 115c
{0x62, 0x5d,},
{0x63, 0x10,}, //Dark2 115d
{0x64, 0x5e,},
{0x65, 0x10,}, //Dark2 115e
{0x66, 0x5f,},
{0x67, 0x10,}, //Dark2 115f
{0x68, 0x6e,},
{0x69, 0x20,}, //Dark2 116e
{0x6a, 0x6f,},
{0x6b, 0x18,},//Dark2 116f
{0x6c, 0x77,},
{0x6d, 0x12,},//Dark2 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x0f,},//Dark2 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x0e,},//Dark2 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x0e,},//Dark2 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x0e,},//Dark2 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,},//Dark2 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x12,},//Dark2 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x12,}, //Dark2 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x12,}, //Dark2 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x0f,}, //Dark2 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x0f,}, //Dark2 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x12,}, //Dark2 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x12,}, //Dark2 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x12,}, //Dark2 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x12,}, //Dark2 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x12,}, //Dark2 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x0f,}, //Dark2 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x0f,}, //Dark2 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x12,}, //Dark2 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x12,}, //Dark2 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x12,}, //Dark2 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x12,}, //Dark2 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark2 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x12,}, //Dark2 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x0f,}, //Dark2 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x0f,}, //Dark2 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x12,}, //Dark2 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x12,}, //Dark2 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x12,}, //Dark2 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x12,}, //Dark2 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark2 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x12,}, //Dark2 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x1c,}, //Dark2 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark2 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark2 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x18,}, //Dark2 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x1d,}, //Dark2 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x20,}, //Dark2 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x20,}, //Dark2 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x20,}, //Dark2 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x22,}, //Dark2 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x22,}, //Dark2 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x21,}, //Dark2 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x1e,}, //Dark2 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x1c,}, //Dark2 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x1a,}, //Dark2 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x12,}, //Dark2 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x12,}, //Dark2 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x13,}, //Dark2 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x18,}, //Dark2 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark2 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x18,}, //Dark2 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x18,}, //Dark2 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x18,}, //Dark2 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark2 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0xff,}, //Dark2 11d1
{0xde, 0xd2,},
{0xdf, 0x00,}, //Dark2 11d2
{0xe0, 0xd3,},
{0xe1, 0xff,}, //Dark2 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark2 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x40,},//Dark2 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark2 11d6
{0xe8, 0xd7,},
{0xe9, 0x2a,}, //Dark2 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark2 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x27,}, //Dark2 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark2 11da
{0xf0, 0xdb,},
{0xf1, 0x20,}, //Dark2 11db
{0xf2, 0xdf,},
{0xf3, 0xff,}, //Dark2 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x32,}, //Dark2 11e0
{0xf6, 0xe1,},
{0xf7, 0x7a,}, //Dark2 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark2 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0x00,}, //Dark2 11e3
{0xfc, 0xe4,},
{0xfd, 0x01,}, //Dark2 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe8,}, //DMA E8 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x21,}, //Dark2 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark2 11e6
{0x14, 0xe7,},
{0x15, 0x00,}, //Dark2 11e7
{0x16, 0xe8,},
{0x17, 0x01,}, //Dark2 11e8
{0x18, 0xe9,},
{0x19, 0x1d,}, //Dark2 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark2 11ea
{0x1c, 0xeb,},
{0x1d, 0x00,}, //Dark2 11eb
{0x1e, 0xef,},
{0x1f, 0xff,}, //Dark2 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,},//12 Page
{0x22, 0x12,},
{0x23, 0x03,},//Dark2 1212
{0x24, 0x33,},
{0x25, 0x16,},//Dark2 1233 add 20130603 Skin_th
{0x26, 0x34,},
{0x27, 0x90,},//Dark2 1234 add 20130603 Cyan_th
{0x28, 0x40,},
{0x29, 0x37,},//Dark2 1240 add 720p
{0x2a, 0x70,},
{0x2b, 0xbf,},//Dark2 1270 // Bayer Sharpness ENB add 720p
{0x2c, 0x71,},
{0x2d, 0x1a,},//Dark2 1271 //Bayer HPF Gain
{0x2e, 0x72,},
{0x2f, 0x16,},//Dark2 1272 //Bayer LPF Gain
{0x30, 0x77,},
{0x31, 0x36,},//Dark2 1277
{0x32, 0x78,},
{0x33, 0x2f,},//Dark2 1278
{0x34, 0x79,},
{0x35, 0xff,},//Dark2 1279
{0x36, 0x7a,},
{0x37, 0x50,},//Dark2 127a
{0x38, 0x7b,},
{0x39, 0x10,},//Dark2 127b
{0x3a, 0x7c,},
{0x3b, 0x64,},//Dark2 127c //skin HPF gain
{0x3c, 0x7d,},
{0x3d, 0x20,},//Dark2 127d
{0x3e, 0x7f,},
{0x3f, 0x50,},//Dark2 127f
{0x40, 0x87,},
{0x41, 0x3f,},//Dark2 1287 add 720p
{0x42, 0x88,},
{0x43, 0x3f,},//Dark2 1288 add 720p
{0x44, 0x89,},
{0x45, 0x3f,},//Dark2 1289 add 720p
{0x46, 0x8a,},
{0x47, 0x3f,},//Dark2 128a add 720p
{0x48, 0x8b,},
{0x49, 0x3f,},//Dark2 128b add 720p
{0x4a, 0x8c,},
{0x4b, 0x3f,},//Dark2 128c add 720p
{0x4c, 0x8d,},
{0x4d, 0x3f,},//Dark2 128d add 720p
{0x4e, 0x8e,},
{0x4f, 0x3f,},//Dark2 128e add 720p
{0x50, 0x8f,},
{0x51, 0x3f,},//Dark2 128f add 720p
{0x52, 0x90,},
{0x53, 0x3f,},//Dark2 1290 add 720p
{0x54, 0x91,},
{0x55, 0x3f,},//Dark2 1291 add 720p
{0x56, 0x92,},
{0x57, 0x3f,},//Dark2 1292 add 720p
{0x58, 0x93,},
{0x59, 0x3f,},//Dark2 1293 add 720p
{0x5a, 0x94,},
{0x5b, 0x3f,},//Dark2 1294 add 720p
{0x5c, 0x95,},
{0x5d, 0x3f,},//Dark2 1295 add 720p
{0x5e, 0x96,},
{0x5f, 0x3f,},//Dark2 1296 add 720p
{0x60, 0xae,},
{0x61, 0x7f,},//Dark2 12ae
{0x62, 0xaf,},
{0x63, 0x00,},//Dark2 12af // B[7:4]Blue/B[3:0]Skin
{0x64, 0xc0,},
{0x65, 0x23,},//Dark2 12c0 // CI-LPF ENB add 720p
{0x66, 0xc3,},
{0x67, 0x3c,},//Dark2 12c3 add 720p
{0x68, 0xc4,},
{0x69, 0x1a,},//Dark2 12c4 add 720p
{0x6a, 0xc5,},
{0x6b, 0x0c,},//Dark2 12c5 add 720p
{0x6c, 0xc6,},
{0x6d, 0x44,},//Dark2 12c6
{0x6e, 0xc7,},
{0x6f, 0x44,},//Dark2 12c7
{0x70, 0xc8,},
{0x71, 0x3e,},//Dark2 12c8
{0x72, 0xd0,},
{0x73, 0x08,},//Dark2 12d0 add 720p
{0x74, 0xd1,},
{0x75, 0x10,},//Dark2 12d1 add 720p
{0x76, 0xd2,},
{0x77, 0x18,},//Dark2 12d2 add 720p
{0x78, 0xd3,},
{0x79, 0x20,},//Dark2 12d3 add 720p
{0x7a, 0xd4,},
{0x7b, 0x30,},//Dark2 12d4 add 720p
{0x7c, 0xd5,},
{0x7d, 0x60,},//Dark2 12d5 add 720p
{0x7e, 0xd6,},
{0x7f, 0x80,},//Dark2 12d6 add 720p
{0x80, 0xd7,},
{0x81, 0x38,},//Dark2 12d7
{0x82, 0xd8,},
{0x83, 0x30,},//Dark2 12d8
{0x84, 0xd9,},
{0x85, 0x2a,},//Dark2 12d9
{0x86, 0xda,},
{0x87, 0x2a,},//Dark2 12da
{0x88, 0xdb,},
{0x89, 0x24,},//Dark2 12db
{0x8a, 0xdc,},
{0x8b, 0x20,},//Dark2 12dc
{0x8c, 0xdd,},
{0x8d, 0x1a,},//Dark2 12dd
{0x8e, 0xde,},
{0x8f, 0x16,},//Dark2 12de
{0x90, 0xe0,},
{0x91, 0x63,},//Dark2 12e0 // 20121120 ln dy
{0x92, 0xe1,},
{0x93, 0xfc,},//Dark2 12e1
{0x94, 0xe2,},
{0x95, 0x02,},//Dark2 12e2
{0x96, 0xe3,},
{0x97, 0x10,},//Dark2 12e3 //PS LN graph Y1
{0x98, 0xe4,},
{0x99, 0x12,},//Dark2 12e4 //PS LN graph Y2
{0x9a, 0xe5,},
{0x9b, 0x1a,},//Dark2 12e5 //PS LN graph Y3
{0x9c, 0xe6,},
{0x9d, 0x1d,},//Dark2 12e6 //PS LN graph Y4
{0x9e, 0xe7,},
{0x9f, 0x1e,},//Dark2 12e7 //PS LN graph Y5
{0xa0, 0xe8,},
{0xa1, 0x1f,},//Dark2 12e8 //PS LN graph Y6
{0xa2, 0xe9,},
{0xa3, 0x10,},//Dark2 12e9 //PS DY graph Y1
{0xa4, 0xea,},
{0xa5, 0x12,},//Dark2 12ea //PS DY graph Y2
{0xa6, 0xeb,},
{0xa7, 0x18,},//Dark2 12eb //PS DY graph Y3
{0xa8, 0xec,},
{0xa9, 0x1c,},//Dark2 12ec //PS DY graph Y4
{0xaa, 0xed,},
{0xab, 0x1e,},//Dark2 12ed //PS DY graph Y5
{0xac, 0xee,},
{0xad, 0x1f,},//Dark2 12ee //PS DY graph Y6
{0xae, 0xf0,},
{0xaf, 0x00,},//Dark2 12f0
{0xb0, 0xf1,},
{0xb1, 0x2a,},//Dark2 12f1
{0xb2, 0xf2,},
{0xb3, 0x32,},//Dark2 12f2
{0xb4, 0x03,},
{0xb5, 0x13,},//13 Page
{0xb6, 0x10,},
{0xb7, 0x81,},//Dark2 1310 //Y-NR ENB add 720p
{0xb8, 0x30,},
{0xb9, 0x20,},//Dark2 1330
{0xba, 0x31,},
{0xbb, 0x20,},//Dark2 1331
{0xbc, 0x32,},
{0xbd, 0x20,},//Dark2 1332
{0xbe, 0x33,},
{0xbf, 0x20,},//Dark2 1333
{0xc0, 0x34,},
{0xc1, 0x20,},//Dark2 1334
{0xc2, 0x35,},
{0xc3, 0x20,},//Dark2 1335
{0xc4, 0x36,},
{0xc5, 0x20,},//Dark2 1336
{0xc6, 0x37,},
{0xc7, 0x20,},//Dark2 1337
{0xc8, 0x38,},
{0xc9, 0x02,},//Dark2 1338
{0xca, 0x40,},
{0xcb, 0x18,},//Dark2 1340
{0xcc, 0x41,},
{0xcd, 0x36,},//Dark2 1341
{0xce, 0x42,},
{0xcf, 0x62,},//Dark2 1342
{0xd0, 0x43,},
{0xd1, 0x63,},//Dark2 1343
{0xd2, 0x44,},
{0xd3, 0xff,},//Dark2 1344
{0xd4, 0x45,},
{0xd5, 0x04,},//Dark2 1345
{0xd6, 0x46,},
{0xd7, 0x45,},//Dark2 1346
{0xd8, 0x47,},
{0xd9, 0x05,},//Dark2 1347
{0xda, 0x48,},
{0xdb, 0x65,},//Dark2 1348
{0xdc, 0x49,},
{0xdd, 0x02,},//Dark2 1349
{0xde, 0x4a,},
{0xdf, 0x22,},//Dark2 134a
{0xe0, 0x4b,},
{0xe1, 0x06,},//Dark2 134b
{0xe2, 0x4c,},
{0xe3, 0x30,},//Dark2 134c
{0xe4, 0x83,},
{0xe5, 0x08,},//Dark2 1383
{0xe6, 0x84,},
{0xe7, 0x0a,},//Dark2 1384
{0xe8, 0xb7,},
{0xe9, 0xfa,},//Dark2 13b7
{0xea, 0xb8,},
{0xeb, 0x77,},//Dark2 13b8
{0xec, 0xb9,},
{0xed, 0xfe,},//Dark2 13b9 //20121217 DC R1,2 CR
{0xee, 0xba,},
{0xef, 0xca,},//Dark2 13ba //20121217 DC R3,4 CR
{0xf0, 0xbd,},
{0xf1, 0x78,},//Dark2 13bd //20121121 c-filter LumHL DC rate
{0xf2, 0xc5,},
{0xf3, 0x01,},//Dark2 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xf4, 0xc6,},
{0xf5, 0x22,},//Dark2 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf6, 0xc7,},
{0xf7, 0x33,},//Dark2 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf8, 0x03,},
{0xf9, 0x14,},//14 page
{0xfa, 0x10,},
{0xfb, 0xb3,},//Dark2 1410
{0xfc, 0x11,},
{0xfd, 0x98,},//Dark2 1411

{0x0e, 0x00,}, // burst end

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x12,},
{0x11, 0x10,},//Dark2 1412
{0x12, 0x13,},
{0x13, 0x03,},//Dark2 1413
{0x14, 0x14,},
{0x15, 0x23,},//Dark2 1414 //YC2D Low Gain B[5:0]
{0x16, 0x15,},
{0x17, 0x7b,},//Dark2 1415 // Y Hi filter mask 1/16
{0x18, 0x16,},
{0x19, 0x10,},//Dark2 1416 //YC2D Hi Gain B[5:0]
{0x1a, 0x17,},
{0x1b, 0x40,},//Dark2 1417
{0x1c, 0x18,},
{0x1d, 0x0c,},//Dark2 1418
{0x1e, 0x19,},
{0x1f, 0x0c,},//Dark2 1419
{0x20, 0x1a,},
{0x21, 0x24,},//Dark2 141a //YC2D Post STD gain Pos
{0x22, 0x1b,},
{0x23, 0x24,},//Dark2 141b //YC2D Post STD gain Neg
{0x24, 0x27,},
{0x25, 0x14,},//Dark2 1427 //YC2D SP Lum Gain Pos1
{0x26, 0x28,},
{0x27, 0x14,},//Dark2 1428 //YC2D SP Lum Gain Pos2
{0x28, 0x29,},
{0x29, 0x14,},//Dark2 1429 //YC2D SP Lum Gain Pos3
{0x2a, 0x2a,},
{0x2b, 0x14,},//Dark2 142a //YC2D SP Lum Gain Pos4
{0x2c, 0x2b,},
{0x2d, 0x14,},//Dark2 142b //YC2D SP Lum Gain Pos5
{0x2e, 0x2c,},
{0x2f, 0x14,},//Dark2 142c //YC2D SP Lum Gain Pos6
{0x30, 0x2d,},
{0x31, 0x14,},//Dark2 142d //YC2D SP Lum Gain Pos7
{0x32, 0x2e,},
{0x33, 0x14,},//Dark2 142e //YC2D SP Lum Gain Pos8
{0x34, 0x30,},
{0x35, 0x12,},//Dark2 1430 //YC2D SP Lum Gain Neg1
{0x36, 0x31,},
{0x37, 0x12,},//Dark2 1431 //YC2D SP Lum Gain Neg2
{0x38, 0x32,},
{0x39, 0x12,},//Dark2 1432 //YC2D SP Lum Gain Neg3
{0x3a, 0x33,},
{0x3b, 0x12,},//Dark2 1433 //YC2D SP Lum Gain Neg4
{0x3c, 0x34,},
{0x3d, 0x12,},//Dark2 1434 //YC2D SP Lum Gain Neg5
{0x3e, 0x35,},
{0x3f, 0x12,},//Dark2 1435 //YC2D SP Lum Gain Neg6
{0x40, 0x36,},
{0x41, 0x12,},//Dark2 1436 //YC2D SP Lum Gain Neg7
{0x42, 0x37,},
{0x43, 0x12,},//Dark2 1437 //YC2D SP Lum Gain Neg8
{0x44, 0x47,},
{0x45, 0x14,},//Dark2 1447 //YC2D SP Dy Gain Pos1
{0x46, 0x48,},
{0x47, 0x14,},//Dark2 1448 //YC2D SP Dy Gain Pos2
{0x48, 0x49,},
{0x49, 0x14,},//Dark2 1449 //YC2D SP Dy Gain Pos3
{0x4a, 0x4a,},
{0x4b, 0x14,},//Dark2 144a //YC2D SP Dy Gain Pos4
{0x4c, 0x4b,},
{0x4d, 0x14,},//Dark2 144b //YC2D SP Dy Gain Pos5
{0x4e, 0x4c,},
{0x4f, 0x14,},//Dark2 144c //YC2D SP Dy Gain Pos6
{0x50, 0x4d,},
{0x51, 0x14,},//Dark2 144d //YC2D SP Dy Gain Pos7
{0x52, 0x4e,},
{0x53, 0x14,},//Dark2 144e //YC2D SP Dy Gain Pos8
{0x54, 0x50,},
{0x55, 0x12,},//Dark2 1450 //YC2D SP Dy Gain Neg1
{0x56, 0x51,},
{0x57, 0x12,},//Dark2 1451 //YC2D SP Dy Gain Neg2
{0x58, 0x52,},
{0x59, 0x12,},//Dark2 1452 //YC2D SP Dy Gain Neg3
{0x5a, 0x53,},
{0x5b, 0x12,},//Dark2 1453 //YC2D SP Dy Gain Neg4
{0x5c, 0x54,},
{0x5d, 0x12,},//Dark2 1454 //YC2D SP Dy Gain Neg5
{0x5e, 0x55,},
{0x5f, 0x12,},//Dark2 1455 //YC2D SP Dy Gain Neg6
{0x60, 0x56,},
{0x61, 0x12,},//Dark2 1456 //YC2D SP Dy Gain Neg7
{0x62, 0x57,},
{0x63, 0x12,},//Dark2 1457 //YC2D SP Dy Gain Neg8
{0x64, 0x67,},
{0x65, 0x20,},//Dark2 1467 //YC2D SP Edge Gain1
{0x66, 0x68,},
{0x67, 0x20,},//Dark2 1468 //YC2D SP Edge Gain2
{0x68, 0x69,},
{0x69, 0x20,},//Dark2 1469 //YC2D SP Edge Gain3
{0x6a, 0x6a,},
{0x6b, 0x20,},//Dark2 146a //YC2D SP Edge Gain4
{0x6c, 0x6b,},
{0x6d, 0x20,},//Dark2 146b //YC2D SP Edge Gain5
{0x6e, 0x6c,},
{0x6f, 0x20,},//Dark2 146c //YC2D SP Edge Gain6
{0x70, 0x6d,},
{0x71, 0x20,},//Dark2 146d //YC2D SP Edge Gain7
{0x72, 0x6e,},
{0x73, 0x20,},//Dark2 146e //YC2D SP Edge Gain8
{0x74, 0x87,},
{0x75, 0x2a,},//Dark2 1487 //YC2D SP STD Gain1
{0x76, 0x88,},
{0x77, 0x2a,},//Dark2 1488 //YC2D SP STD Gain2
{0x78, 0x89,},
{0x79, 0x2a,},//Dark2 1489 //YC2D SP STD Gain3
{0x7a, 0x8a,},
{0x7b, 0x2a,},//Dark2 148a //YC2D SP STD Gain4
{0x7c, 0x8b,},
{0x7d, 0x2a,},//Dark2 148b //YC2D SP STD Gain5
{0x7e, 0x8c,},
{0x7f, 0x1a,},//Dark2 148c //YC2D SP STD Gain6
{0x80, 0x8d,},
{0x81, 0x1a,},//Dark2 148d //YC2D SP STD Gain7
{0x82, 0x8e,},
{0x83, 0x1a,},//Dark2 148e //YC2D SP STD Gain8
{0x84, 0x97,},
{0x85, 0x3f,},//Dark2 1497 add 720p
{0x86, 0x98,},
{0x87, 0x3f,},//Dark2 1498 add 720p
{0x88, 0x99,},
{0x89, 0x3f,},//Dark2 1499 add 720p
{0x8a, 0x9a,},
{0x8b, 0x3f,},//Dark2 149a add 720p
{0x8c, 0x9b,},
{0x8d, 0x3f,},//Dark2 149b add 720p
{0x8e, 0xa0,},
{0x8f, 0x3f,},//Dark2 14a0 add 720p
{0x90, 0xa1,},
{0x91, 0x3f,},//Dark2 14a1 add 720p
{0x92, 0xa2,},
{0x93, 0x3f,},//Dark2 14a2 add 720p
{0x94, 0xa3,},
{0x95, 0x3f,},//Dark2 14a3 add 720p
{0x96, 0xa4,},
{0x97, 0x3f,},//Dark2 14a4 add 720p
{0x98, 0xc9,},
{0x99, 0x13,},//Dark2 14c9
{0x9a, 0xca,},
{0x9b, 0x27,},//Dark2 14ca
{0x9c, 0x03,},
{0x9d, 0x1a,},//1A page
{0x9e, 0x10,},
{0x9f, 0x15,},//Dark2 1A10 add 720p
{0xa0, 0x18,},
{0xa1, 0x3f,},//Dark2 1A18
{0xa2, 0x19,},
{0xa3, 0x3f,},//Dark2 1A19
{0xa4, 0x1a,},
{0xa5, 0x2a,},//Dark2 1A1a
{0xa6, 0x1b,},
{0xa7, 0x27,},//Dark2 1A1b
{0xa8, 0x1c,},
{0xa9, 0x23,},//Dark2 1A1c
{0xaa, 0x1d,},
{0xab, 0x23,},//Dark2 1A1d
{0xac, 0x1e,},
{0xad, 0x23,},//Dark2 1A1e
{0xae, 0x1f,},
{0xaf, 0x23,},//Dark2 1A1f
{0xb0, 0x20,},
{0xb1, 0xe7,},//Dark2 1A20 add 720p
{0xb2, 0x2f,},
{0xb3, 0xf1,},//Dark2 1A2f add 720p
{0xb4, 0x32,},
{0xb5, 0x87,},//Dark2 1A32 add 720p
{0xb6, 0x34,},
{0xb7, 0xd0,},//Dark2 1A34 //RGB High Gain B[5:0]
{0xb8, 0x35,},
{0xb9, 0x11,},//Dark2 1A35 //RGB Low Gain B[5:0]
{0xba, 0x36,},
{0xbb, 0x00,},//Dark2 1A36
{0xbc, 0x37,},
{0xbd, 0x40,},//Dark2 1A37
{0xbe, 0x38,},
{0xbf, 0xff,},//Dark2 1A38
{0xc0, 0x39,},
{0xc1, 0x11,},//Dark2 1A39 //RGB Flat R2_Lum L
{0xc2, 0x3a,},
{0xc3, 0x3f,},//Dark2 1A3a
{0xc4, 0x3b,},
{0xc5, 0x00,},//Dark2 1A3b
{0xc6, 0x3c,},
{0xc7, 0x4c,},//Dark2 1A3c
{0xc8, 0x3d,},
{0xc9, 0x00,},//Dark2 1A3d
{0xca, 0x3e,},
{0xcb, 0x13,},//Dark2 1A3e
{0xcc, 0x3f,},
{0xcd, 0x00,},//Dark2 1A3f
{0xce, 0x40,},
{0xcf, 0x2a,},//Dark2 1A40
{0xd0, 0x41,},
{0xd1, 0x00,},//Dark2 1A41
{0xd2, 0x42,},
{0xd3, 0x17,},//Dark2 1A42
{0xd4, 0x43,},
{0xd5, 0x2c,},//Dark2 1A43
{0xd6, 0x4d,},
{0xd7, 0x08,},//Dark2 1A4d //RGB SP Lum Gain Neg1
{0xd8, 0x4e,},
{0xd9, 0x0a,},//Dark2 1A4e //RGB SP Lum Gain Neg2
{0xda, 0x4f,},
{0xdb, 0x10,},//Dark2 1A4f //RGB SP Lum Gain Neg3
{0xdc, 0x50,},
{0xdd, 0x12,},//Dark2 1A50 //RGB SP Lum Gain Neg4
{0xde, 0x51,},
{0xdf, 0x12,},//Dark2 1A51 //RGB SP Lum Gain Neg5
{0xe0, 0x52,},
{0xe1, 0x12,},//Dark2 1A52 //RGB SP Lum Gain Neg6
{0xe2, 0x53,},
{0xe3, 0x12,},//Dark2 1A53 //RGB SP Lum Gain Neg7
{0xe4, 0x54,},
{0xe5, 0x12,},//Dark2 1A54 //RGB SP Lum Gain Neg8
{0xe6, 0x55,},
{0xe7, 0x12,},//Dark2 1A55 //RGB SP Lum Gain Pos1
{0xe8, 0x56,},
{0xe9, 0x12,},//Dark2 1A56 //RGB SP Lum Gain Pos2
{0xea, 0x57,},
{0xeb, 0x12,},//Dark2 1A57 //RGB SP Lum Gain Pos3
{0xec, 0x58,},
{0xed, 0x12,},//Dark2 1A58 //RGB SP Lum Gain Pos4
{0xee, 0x59,},
{0xef, 0x12,},//Dark2 1A59 //RGB SP Lum Gain Pos5
{0xf0, 0x5a,},
{0xf1, 0x12,},//Dark2 1A5a //RGB SP Lum Gain Pos6
{0xf2, 0x5b,},
{0xf3, 0x12,},//Dark2 1A5b //RGB SP Lum Gain Pos7
{0xf4, 0x5c,},
{0xf5, 0x12,},//Dark2 1A5c //RGB SP Lum Gain Pos8
{0xf6, 0x65,},
{0xf7, 0x12,},//Dark2 1A65 //RGB SP Dy Gain Neg1
{0xf8, 0x66,},
{0xf9, 0x12,},//Dark2 1A66 //RGB SP Dy Gain Neg2
{0xfa, 0x67,},
{0xfb, 0x12,},//Dark2 1A67 //RGB SP Dy Gain Neg3
{0xfc, 0x68,},
{0xfd, 0x12,},//Dark2 1A68 //RGB SP Dy Gain Neg4

{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E9 page.
{0xE2, 0x32,},
{0xE3, 0x6A,},

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x69,},
{0x11, 0x12,},//Dark2 1A69 //RGB SP Dy Gain Neg5
{0x12, 0x6a,},
{0x13, 0x12,},//Dark2 1A6a //RGB SP Dy Gain Neg6
{0x14, 0x6b,},
{0x15, 0x12,},//Dark2 1A6b //RGB SP Dy Gain Neg7
{0x16, 0x6c,},
{0x17, 0x12,},//Dark2 1A6c //RGB SP Dy Gain Neg8
{0x18, 0x6d,},
{0x19, 0x12,},//Dark2 1A6d //RGB SP Dy Gain Pos1
{0x1a, 0x6e,},
{0x1b, 0x12,},//Dark2 1A6e //RGB SP Dy Gain Pos2
{0x1c, 0x6f,},
{0x1d, 0x12,},//Dark2 1A6f //RGB SP Dy Gain Pos3
{0x1e, 0x70,},
{0x1f, 0x12,},//Dark2 1A70 //RGB SP Dy Gain Pos4
{0x20, 0x71,},
{0x21, 0x12,},//Dark2 1A71 //RGB SP Dy Gain Pos5
{0x22, 0x72,},
{0x23, 0x12,},//Dark2 1A72 //RGB SP Dy Gain Pos6
{0x24, 0x73,},
{0x25, 0x12,},//Dark2 1A73 //RGB SP Dy Gain Pos7
{0x26, 0x74,},
{0x27, 0x12,},//Dark2 1A74 //RGB SP Dy Gain Pos8
{0x28, 0x7d,},
{0x29, 0x20,},//Dark2 1A7d //RGB SP Edge Gain1
{0x2a, 0x7e,},
{0x2b, 0x20,},//Dark2 1A7e //RGB SP Edge Gain2
{0x2c, 0x7f,},
{0x2d, 0x20,},//Dark2 1A7f //RGB SP Edge Gain3
{0x2e, 0x80,},
{0x2f, 0x20,},//Dark2 1A80 //RGB SP Edge Gain4
{0x30, 0x81,},
{0x31, 0x20,},//Dark2 1A81 //RGB SP Edge Gain5
{0x32, 0x82,},
{0x33, 0x20,},//Dark2 1A82 //RGB SP Edge Gain6
{0x34, 0x83,},
{0x35, 0x20,},//Dark2 1A83 //RGB SP Edge Gain7
{0x36, 0x84,},
{0x37, 0x20,},//Dark2 1A84 //RGB SP Edge Gain8
{0x38, 0x9e,},
{0x39, 0x1a,},//Dark2 1A9e //RGB SP STD Gain1
{0x3a, 0x9f,},
{0x3b, 0x1a,},//Dark2 1A9f //RGB SP STD Gain2
{0x3c, 0xa0,},
{0x3d, 0x1a,},//Dark2 1Aa0 //RGB SP STD Gain3
{0x3e, 0xa1,},
{0x3f, 0x1a,},//Dark2 1Aa1 //RGB SP STD Gain4
{0x40, 0xa2,},
{0x41, 0x1a,},//Dark2 1Aa2 //RGB SP STD Gain5
{0x42, 0xa3,},
{0x43, 0x1a,},//Dark2 1Aa3 //RGB SP STD Gain6
{0x44, 0xa4,},
{0x45, 0x1a,},//Dark2 1Aa4 //RGB SP STD Gain7
{0x46, 0xa5,},
{0x47, 0x1a,},//Dark2 1Aa5 //RGB SP STD Gain8
{0x48, 0xa6,},
{0x49, 0x36,},//Dark2 1Aa6 //RGB Post STD Gain Pos/Neg
{0x4a, 0xa7,},
{0x4b, 0x08,},//Dark2 1Aa7 add 720p
{0x4c, 0xa8,},
{0x4d, 0x08,},//Dark2 1Aa8 add 720p
{0x4e, 0xa9,},
{0x4f, 0x08,},//Dark2 1Aa9 add 720p
{0x50, 0xaa,},
{0x51, 0x08,},//Dark2 1Aaa add 720p
{0x52, 0xab,},
{0x53, 0x08,},//Dark2 1Aab add 720p
{0x54, 0xaf,},
{0x55, 0x3f,},//Dark2 1Aaf add 720p
{0x56, 0xb0,},
{0x57, 0x3f,},//Dark2 1Ab0 add 720p
{0x58, 0xb1,},
{0x59, 0x3f,},//Dark2 1Ab1 add 720p
{0x5a, 0xb2,},
{0x5b, 0x3f,},//Dark2 1Ab2 add 720p
{0x5c, 0xb3,},
{0x5d, 0x3f,},//Dark2 1Ab3 add 720p
{0x5e, 0xca,},
{0x5f, 0x00,},//Dark2 1Aca
{0x60, 0xe3,},
{0x61, 0x13,},//Dark2 1Ae3 add 720p
{0x62, 0xe4,},
{0x63, 0x13,},//Dark2 1Ae4 add 720p
{0x64, 0x03,},
{0x65, 0x10,},//10 page
{0x66, 0x70,},
{0x67, 0x0c,},//Dark2 1070 Trans Func.   130108 Dark2 transFuc Flat graph
{0x68, 0x71,},
{0x69, 0x06,},//Dark2 1071
{0x6a, 0x72,},
{0x6b, 0xbe,},//Dark2 1072
{0x6c, 0x73,},
{0x6d, 0x99,},//Dark2 1073
{0x6e, 0x74,},
{0x6f, 0x00,},//Dark2 1074
{0x70, 0x75,},
{0x71, 0x00,},//Dark2 1075
{0x72, 0x76,},
{0x73, 0x20,},//Dark2 1076
{0x74, 0x77,},
{0x75, 0x33,},//Dark2 1077
{0x76, 0x78,},
{0x77, 0x33,},//Dark2 1078
{0x78, 0x79,},
{0x79, 0x40,},//Dark2 1079
{0x7a, 0x7a,},
{0x7b, 0x00,},//Dark2 107a
{0x7c, 0x7b,},
{0x7d, 0x40,},//Dark2 107b
{0x7e, 0x7c,},
{0x7f, 0x00,},//Dark2 107c
{0x80, 0x7d,},
{0x81, 0x07,},//Dark2 107d
{0x82, 0x7e,},
{0x83, 0x0f,},//Dark2 107e
{0x84, 0x7f,},
{0x85, 0x1e,},//Dark2 107f
{0x86, 0x03,},
{0x87, 0x02,},// 2 page
{0x88, 0x23,},
{0x89, 0x10,},//Dark2 0223 (for sun-spot) // normal 3c
{0x8a, 0x03,},
{0x8b, 0x03,},// 3 page
{0x8c, 0x1a,},
{0x8d, 0x06,},//Dark2 031a (for sun-spot)
{0x8e, 0x1b,},
{0x8f, 0x7c,},//Dark2 031b (for sun-spot)
{0x90, 0x1c,},
{0x91, 0x00,},//Dark2 031c (for sun-spot)
{0x92, 0x1d,},
{0x93, 0x50,},//Dark2 031d (for sun-spot)
{0x94, 0x03,},
{0x95, 0x11,},// 11 page
{0x96, 0xf0,},
{0x97, 0x05,},//Dark2 11f0 (for af bug)
{0x98, 0x03,},
{0x99, 0x10,},// 10 page
{0x9a, 0x17,},
{0x9b, 0x40,},//Dark2 1017 CSP option


{0x0e, 0x00,}, // burst end

//--------------------------------------------------------------------------//
// MIPI TX Setting  //PCLK 54MHz
//--------------------------------------------------------------------------//
{0x03, 0x05,},  // Page05
{0x11, 0x00,},  // lvds_ctl_2 //Phone set not continuous
{0x12, 0x00,},  // crc_ctl
{0x13, 0x00,},  // serial_ctl
{0x14, 0x00,},  // ser_out_ctl_1
{0x15, 0x00,},  // dphy_fifo_ctl
{0x16, 0x02,},  // lvds_inout_ctl1
{0x17, 0x00,},  // lvds_inout_ctl2
{0x18, 0x80,},  // lvds_inout_ctl3
{0x19, 0x00,},  // lvds_inout_ctl4
{0x1a, 0xf0,},  // lvds_time_ctl
{0x1c, 0x01,},  // tlpx_time_l_dp
{0x1d, 0x0f,},  // tlpx_time_l_dn
{0x1e, 0x08,},  // hs_zero_time
{0x1f, 0x0a,},  // hs_trail_time
{0x21, 0xb8,},  // hs_sync_code
{0x22, 0x00,},  // frame_start_id
{0x23, 0x01,},  // frame_end_id
{0x24, 0x1e,},  // long_packet_id
{0x25, 0x00,},  // s_pkt_wc_h
{0x26, 0x00,},  // s_pkt_wc_l
{0x27, 0x08,},  // lvds_frame_end_cnt_h
{0x28, 0x00,},  // lvds_frame_end_cnt_l
{0x2a, 0x06,},  // lvds_image_width_h
{0x2b, 0x40,},  // lvds_image_width_l
{0x2c, 0x04,},  // lvds_image_height_h
{0x2d, 0xb0,},  // lvds_image_height_l
{0x30, 0x08,}, // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
{0x32, 0x0f,},  // clk_zero_time
{0x33, 0x0b,},  // clk_post_time
{0x34, 0x03,},  // clk_prepare_time
{0x35, 0x04,},  // clk_trail_time
{0x36, 0x01,},  // clk_tlpx_time_dp
{0x37, 0x06,},  // clk_tlpx_time_dn
{0x39, 0x07,},  // lvds_bias_ctl
{0x3a, 0x00,},  // lvds_test_tx
{0x42, 0x00,},  // mipi_test_width_l
{0x43, 0x00,},  // mipi_test_height_l
{0x44, 0x00,},  // mipi_test_size_h
{0x45, 0x00,},  // mipi_test_hsync_st
{0x46, 0x00,},  // mipi_test_hblank
{0x47, 0x00,},  // mipi_test_vsync_st
{0x48, 0x00,},  // mipi_test_vsync_end
{0x49, 0xff,},  // ulps_size_opt1
{0x4a, 0x0a,},  // ulps_size_opt2
{0x4b, 0x22,},  // ulps_size_opt3
{0x4c, 0x41,},  // hs_wakeup_size_h
{0x4d, 0x20,},  // hs_wakeup_size_l
{0x4e, 0x00,},  // mipi_int_time_h
{0x4f, 0xff,},  // mipi_int_time_l
{0x50, 0x0A,},  // cntns_clk_wait_h
{0x51, 0x00,},  // cntns_clk_wait_l
{0x57, 0x40,},  // mipi_dmy_reg
{0x60, 0x00,},  // mipi_frame_pkt_opt
{0x61, 0x08,},  // line_cnt_value_h
{0x62, 0x00,},  // line_cnt_value_l
{0x10, 0x1c,},  // lvds_ctl_1
};

static struct sensor_reg sr352_50hz_setting[] = {
{0x03, 0x00,},
{0x01, 0x00,},
{0xff, 0x02,},

{0x03, 0x20,},
{0x10, 0xbd,}, //50hz bd, 60hz ad
{0x20, 0x00,}, //Start ExpTime 120fps
{0x21, 0x06,},
{0x22, 0xd9,},
{0x23, 0x20,},

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x02,}, // 20ms

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////////////////////////////////////////
// C7 Page (AE)
///////////////////////////////////////////////////////////////////////////////
//Shutter Setting
{0x03, 0xc7,},
{0x10, 0x70,},	//AE Off (Band Off) 50hz 70, 60hz 50
{0x12, 0x30,}, // Fast speed
{0x15, 0xc0,}, // SSD Patch Weight Y Mean On

{0x1e, 0x03,}, // Band1 Step
{0x1f, 0x06,}, // Band2 Step
{0x20, 0x08,}, // Band3 Step

{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,},// Band3 Gain 12fps

{0x36, 0x08,}, // Max 8fps
{0x37, 0x08,}, // Max 8fps

{0x3d, 0x22,}, // YTh Lock, Unlock0

{0x11, 0x01,}, // B[1]Initial Speed Up, B[0]AE Reset
{0x70, 0x82,}, // 50hz 82, 60hz 02
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x44, 0x00,}, //Start ExpTime 120fps
{0x45, 0x06,},
{0x46, 0xd9,},
{0x47, 0x20,},

{0xa7, 0x48,}, //Start ExpTime 120fps float
{0xa8, 0xdb,},
{0xa9, 0x24,},
{0xaa, 0x00,},

{0x03, 0x20,}, //HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2A, 0x60,},

{0x03, 0xc7,},
{0x10, 0xf0,},	//AE On 50hz f0, 60hz d0

};

static struct sensor_reg sr352_stop_stream[] = {
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	//Sleep of frame sync type | Mipi frame

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0x00,},
};

static struct sensor_reg sr352_Enterpreview_640x480_01[] = {
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x00,},	// preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Preview 0410
{0x12, 0x02,}, //Preview1 0410

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 640_480
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x02,}, //width
{0xa3, 0x80,},
{0xa4, 0x01,}, //height
{0xa5, 0xe0,},

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x05,},  // l_pkt_wc_h  // Pre = 640 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_1024x768_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x00,},	// preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Preview 0410
{0x12, 0x02,}, //Preview1 0410

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x768
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x00,}, //sawtooth off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_1024x576_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,}, // binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,}, // preview row start set
{0x22, 0x00,},
{0x23, 0x00,}, // preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Preview 0410
{0x12, 0x02,}, //Preview1 0410


///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,}, //Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,}, //Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x576
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x04,}, //width
{0xa3, 0x00,},
{0xa4, 0x02,}, //height
{0xa5, 0x40,},
{0xa6, 0x00,},	//fw scaler col start
{0xa7, 0x00,}, //fw scaler row start

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

#if 0
static struct sensor_reg sr352_Enterpreview_1024x768[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x04,},	// preview col start set //XY flip

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x93,}, //Preview1 XY flip 1219
{0x12, 0x82,}, //Preview1 XY flip 1219

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x768
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x00,}, //sawtooth off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_1024x768_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x00,},	// preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Preview 0410
{0x12, 0x02,}, //Preview1 0410

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x768
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x00,}, //sawtooth off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_1024x576[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x04,},	// preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x93,}, //Preview1 XY flip 1219
{0x12, 0x82,}, //Preview1 XY flip 1219

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x576
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x04,}, //width
{0xa3, 0x00,},
{0xa4, 0x02,}, //height
{0xa5, 0x40,},
{0xa6, 0x00,}, //fw scaler col start
{0xa7, 0x00,}, //fw scaler row start

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_1024x576_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,}, // binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,}, // preview row start set
{0x22, 0x00,},
{0x23, 0x00,}, // preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Preview 0410
{0x12, 0x02,}, //Preview1 0410


///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,}, //Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,}, //Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 1024x576
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x04,}, //width
{0xa3, 0x00,},
{0xa4, 0x02,}, //height
{0xa5, 0x40,},
{0xa6, 0x00,},	//fw scaler col start
{0xa7, 0x00,}, //fw scaler row start

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x08,},  // l_pkt_wc_h  // Pre = 1024 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//
{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Enterpreview_640x480[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x41,},	// binning + prev1
{0x17, 0x00,}, // ISP Divider2 1/1
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x04,},	// preview col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x93,}, //Preview1 XY flip 1219
{0x12, 0x82,}, //Preview1 XY flip 1219

///////////////////////////////////////////
// 19 Page  Scalor off
///////////////////////////////////////////
{0x03, 0x19,},	//Scaler Off
{0x10, 0x00,},
{0x14, 0x00,}, //sawtooth off

{0x03, 0xc0,},	//Scaler Off
{0xa0, 0x00,},
{0xa6, 0x00,},
{0xa7, 0x00,},

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x0F,},	//Bit[4]=Low
{0x70, 0x9E,},	//Bit[0]=Low

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x01,}, //delay 10ms
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 640_480
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x02,}, //width
{0xa3, 0x80,},
{0xa4, 0x01,}, //height
{0xa5, 0xe0,},

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x05,},  // l_pkt_wc_h  // Pre = 640 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
//------------------------------------//

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x28,},	// Preview // sleep off

{0x03, 0x00,},
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Capture_2048_1536[] ={
{0x03, 0xc8,},	//AWB Off
{0x10, 0x52,},

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set
{0xff, 0x0c,},	// 120ms

///////////////////////////////////////////
// D9 Page(Capture function)
///////////////////////////////////////////
{0x03, 0xd9,},
{0x1c, 0x04,},	// Capture Pll Div (CAP_OPCLK_DIV / 2.0)
///////////////////////////////////////////
// 00 Page

///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x00,}, // full
{0x17, 0x01,}, // ISP Divider2 1/2
{0x20, 0x00,},
{0x21, 0x0a,}, //XY Flip
{0x22, 0x00,},
{0x23, 0x14,}, //XY Flip

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x93,}, //Full XY flip 1219
{0x12, 0x82,}, //Full XY flip 1219

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x1F,},	//Bit[4]=Hi
{0x03, 0x12,},
{0x70, 0x9F,},	//Bit[0]=Hi

//------------------------------------------------//
//TAP Capture Setting
//------------------------------------------------//
{0x03, 0xc0,},
{0x98, 0x00,},
{0x99, 0x10,},
{0x9a, 0x72,},
{0x9b, 0xf0,},		// exp_band_100 * 2
{0x9c, 0x00,},
{0x9d, 0x0d,},
{0x9e, 0xb2,},
{0x9f, 0x40,},		// exp_band_120 * 2

{0x03, 0x26,},
{0x63, 0xf8,},		// set custom call address (high)
{0x64, 0x00,},		// set custom call address (low)

{0x03, 0xc0,},
{0x66, 0x01,},	// jump custom call

{0xff, 0x01,}, //delay 10ms

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x29,},	// Capture On

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0x26,},
{0x63, 0xf8,},		// set custom call address (high)
{0x64, 0x92,},		// set custom call address (low)

{0x03, 0xc0,},
{0x66, 0x01,},	// jump custom call
//------------------------------------------------//

///////////////////////////////////////////
//  Scaler Off
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x00,}, //sawtooth off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05
{0x30, 0x10,},  // l_pkt_wc_h  // Full = 1280 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},

{0xff, 0x01,}, //delay 10ms
};

static struct sensor_reg sr352_Capture_2048_1536_01[] ={
{0x03, 0xc8,},	//AWB Off
{0x10, 0x52,},

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set
{0xff, 0x0c,},	// 120ms

///////////////////////////////////////////
// D9 Page(Capture function)
///////////////////////////////////////////
{0x03, 0xd9,},
{0x1c, 0x04,},	// Capture Pll Div (CAP_OPCLK_DIV / 2.0)
///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x10, 0x00,},	// full
{0x17, 0x01,},  // ISP Divider2 1/2
{0x20, 0x00,},
{0x21, 0x08,},	// row start set
{0x22, 0x00,},
{0x23, 0x01,},	// col start set

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x11, 0x11,}, //Full & HD(crop) 0410
{0x12, 0x00,}, //Full & HD(crop) 0410

//--------------------------------------//
//PWR margin setting
//--------------------------------------//
{0x03, 0x11,},
{0x10, 0x1F,},	//Bit[4]=Hi
{0x03, 0x12,},
{0x70, 0x9F,},	//Bit[0]=Hi

//------------------------------------------------//
//TAP Capture Setting
//------------------------------------------------//
{0x03, 0xc0,},
{0x98, 0x00,},
{0x99, 0x10,},
{0x9a, 0x72,},
{0x9b, 0xf0,},		// exp_band_100 * 2
{0x9c, 0x00,},
{0x9d, 0x0d,},
{0x9e, 0xb2,},
{0x9f, 0x40,},		// exp_band_120 * 2

{0x03, 0x26,},
{0x63, 0xf8,},		// set custom call address (high)
{0x64, 0x00,},		// set custom call address (low)

{0x03, 0xc0,},
{0x66, 0x01,},	// jump custom call

{0xff, 0x01,}, //delay 10ms

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update

{0x03, 0x26,},
{0x30, 0x29,},	// Capture On

{0x03, 0x00,},
{0x01, 0x00,},	// sleep off

{0x03, 0x26,},
{0x63, 0xf8,},		// set custom call address (high)
{0x64, 0x92,},		// set custom call address (low)

{0x03, 0xc0,},
{0x66, 0x01,},	// jump custom call
//------------------------------------------------//

///////////////////////////////////////////
//  Scaler Off
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x00,}, //sawtooth off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05
{0x30, 0x10,},  // l_pkt_wc_h  // Full = 1280 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},
};

static struct sensor_reg sr352_preview_176_144[] ={
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 176_144
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x63,}, //sawtooth on 320_240 176_144 pre filter //Bit[5] on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x00,},
{0xa3, 0xb0,},
{0xa4, 0x00,},
{0xa5, 0x90,},

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x01,},  // l_pkt_wc_h  // Pre = 176 * 2 (YUV)
{0x31, 0x60,},  // l_pkt_wc_l
//------------------------------------//

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms

};

static struct sensor_reg sr352_preview_320_240[] ={
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 320_240
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x43,}, //sawtooth on 320_240 176_144 pre filter

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x01,}, //width
{0xa3, 0x40,},
{0xa4, 0x00,}, //height
{0xa5, 0xf0,},

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x02,},  // l_pkt_wc_h  // Pre = 320 * 2 (YUV)
{0x31, 0x80,},  // l_pkt_wc_l
//------------------------------------//


{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms

};

static struct sensor_reg sr352_preview_800_480[] ={
{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

///////////////////////////////////////////
//  Scaler 800_480
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off
{0x14, 0x03,}, //sawtooth on

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off
{0xa2, 0x03,}, //width
{0xa3, 0x20,},
{0xa4, 0x01,}, //height
{0xa5, 0xe0,},

{0xa1, 0x00,}, //zoom step
{0xa0, 0xc0,}, //fw scaler on

{0x03, 0x19,},
{0x10, 0x07,}, //hw scaler on

///////////////////////////////////////////
// 05 Page MIPI Size
///////////////////////////////////////////
{0x03, 0x05,},  // Page05

{0x30, 0x06,},  // l_pkt_wc_h  // Pre = 800 * 2 (YUV)
{0x31, 0x40,},  // l_pkt_wc_l
//------------------------------------//


{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},	// Sleep Off

{0xff, 0x01,}, //delay 10ms

};

/*===========================================*/
/*CAMERA_RECORDING WITH 30fps  */
/*============================================*/

static struct sensor_reg sr352_recording_50Hz_HD[] = {

///////////////////////////////////////////////////////////////////////////////
// HD Initial Start
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0x26,},
{0x10, 0x01,}, //mcu clock off
{0x08, 0x56,},	//mode_pll2  isp clk = 86Mhz;
{0x09, 0x81,}, //mode_pll3  // MIPI 4x div 1/1 // isp clk div = 1/4

///////////////////////////////////////////////////////////////////////////////
// 0 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x10, 0x00,},	// Full size
{0x11, 0x83,},	// Fixed mode off
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x08,},	// preview col start set
{0x24, 0x02,},
{0x25, 0xd0,},	// height 720
{0x26, 0x05,},
{0x27, 0x00,},	// width 1280

///////////////////////////////////////////////////////////////////////////////
//ONE LINE SETTING
{0x03, 0x00,},
{0x4c, 0x07,},	// one_line = 1850
{0x4d, 0x3a,},

///////////////////////////////////////////////////////////////////////////////
{0x52, 0x00,},	// Vsync H
{0x53, 0x14,},	// Vsync L
///////////////////////////////////////////////////////////////////////////////

//Pixel windowing
{0x80, 0x01,},	// pixel_row_start for 720p crop mode
{0x81, 0x9e,},	// pwin_row_start = 414
{0x82, 0x02,},	// pwin_row_height = 738
{0x83, 0xe2,},
{0x84, 0x01,},	// pwin_col_start = 384
{0x85, 0x80,},
{0x86, 0x05,},	// pwin_col_width = 1312
{0x87, 0x20,},

///////////////////////////////////////////////////////////////////////////////
// 2 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x02,},
{0x1b, 0x80,},
{0x1d, 0x40,},
{0x23, 0x2a,},
{0x40, 0x08,},
{0x41, 0x8a,},	//20130213 Rev BC ver. ADC input range @ 800mv
{0x46, 0x0a,},	// + 3.3V, -0.9V
{0x47, 0x17,}, // 20121129 2.9V
{0x48, 0x1a,},
{0x49, 0x13,},
{0x54, 0xc0,},
{0x55, 0x40,},
{0x56, 0x33,},
{0xa0, 0x01,},
{0xa1, 0x7c,},
{0xa2, 0x03,},
{0xa3, 0x4d,},
{0xa4, 0x03,},
{0xa5, 0xb0,},
{0xa6, 0x06,},
{0xa7, 0xf2,},
{0xa8, 0x01,},
{0xa9, 0x4f,},
{0xaa, 0x02,},
{0xab, 0x23,},
{0xac, 0x02,},
{0xad, 0x74,},
{0xae, 0x04,},
{0xaf, 0x17,},

///////////////////////////////////////////////////////////////////////////////
// 3 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x03,},
{0x1a, 0x06,}, // cds_s1
{0x1b, 0x7c,},
{0x1e, 0x06,},
{0x1f, 0x7c,},
{0x42, 0x00,},
{0x43, 0x46,},
{0x46, 0x00,},
{0x47, 0x74,},
{0x4a, 0x00,},
{0x4b, 0x44,},
{0x4e, 0x00,},
{0x4f, 0x44,},
{0x52, 0x00,},
{0x53, 0x20,},
{0x56, 0x00,},
{0x57, 0x20,},
{0x5a, 0x00,},
{0x5b, 0x20,},
{0x6a, 0x00,},
{0x6b, 0x6f,},
{0x72, 0x06,}, // s_addr_cut
{0x73, 0x40,},
{0x78, 0x06,}, // rx half_rst
{0x79, 0x3b,},
{0x7a, 0x06,},
{0x7b, 0x45,},
{0x7c, 0x06,},
{0x7d, 0x3b,},
{0x7e, 0x06,},
{0x7f, 0x45,},
{0x84, 0x06,}, // tx half_rst
{0x85, 0x3b,},
{0x86, 0x06,},
{0x87, 0x45,},
{0x88, 0x06,},
{0x89, 0x3b,},
{0x8a, 0x06,},
{0x8b, 0x45,},
{0x92, 0x06,}, // sx
{0x93, 0x31,},
{0x96, 0x06,},
{0x97, 0x31,},
{0x98, 0x06,}, // sxb
{0x99, 0x31,},
{0x9c, 0x06,},
{0x9d, 0x31,},

{0xb6, 0x00,},
{0xb7, 0xc8,},
{0xc0, 0x00,},
{0xc1, 0x48,},
{0xc2, 0x00,},
{0xc3, 0x6e,},
{0xc4, 0x00,},
{0xc5, 0x48,},
{0xc6, 0x00,},
{0xc7, 0x6e,},
{0xc8, 0x00,},
{0xc9, 0x4d,},
{0xca, 0x00,},
{0xcb, 0x6c,},
{0xcc, 0x00,},
{0xcd, 0x4d,},
{0xce, 0x00,},
{0xcf, 0x6c,},
{0xd0, 0x00,},
{0xd1, 0x4f,},
{0xd2, 0x00,},
{0xd3, 0x6a,},
{0xd4, 0x00,},
{0xd5, 0x4f,},
{0xd6, 0x00,},
{0xd7, 0x6a,},
{0xd8, 0x00,},
{0xd9, 0x50,},
{0xda, 0x00,},
{0xdb, 0x68,},
{0xdc, 0x00,},
{0xdd, 0x50,},
{0xde, 0x00,},
{0xdf, 0x68,},

{0xe0, 0x00,},
{0xe1, 0x20,},
{0xfc, 0x06,}, // clamp_sig
{0xfd, 0x38,},

{0x03, 0x26,},
{0x10, 0x09,}, //mcu clock enable

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x10, 0x01,}, // otp_dpc_ctl
{0x11, 0x93,}, //HD(Crop) XY flip 1219
{0x12, 0x82,}, //HD(Crop) XY flip 1219

///////////////////////////////////////////////////////////////////////////////
// 15 Page (LSC)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x15,},	// Shading FPGA(Hi-352)
{0x10, 0x01,},	// LSC ON
{0x11, 0x06,}, //gap y enb, gap x enb for 720p

{0x27, 0x80,},	// LSC G
{0x28, 0x80,},	// LSC B
{0x29, 0x80,},	// LSC R

{0x30, 0x8a,}, //gap x for 720p
{0x31, 0x68,}, //gap y for 720p
{0x36, 0x6c,}, //lsc_win_x for 720p
{0x37, 0x64,}, //lsc_win_y for 720p

///////////////////////////////////
// 10 Page Saturation (H/W)
///////////////////////////////////
{0x03, 0x10,},
{0x12, 0x00,}, //Y OFS Disable
{0x20, 0x04,}, //16_235 range scale down on

///////////////////////////////////
// 11 Page D-LPF (H/W)
///////////////////////////////////
{0x03, 0x11,}, //11 page

{0xf2, 0xff,}, //pga_dark1_hi
{0xf3, 0xfc,}, //pga_dark_lo

///////////////////////////////////
// 13 Page YC-2D_Y-NR (H/W)/////////
///////////////////////////////////
{0x03, 0x13,},

//==========================================================================
// C-Filter PS Reducing (Mask-Size Adjustment)

{0x87, 0xff,}, //C-mask near STD TH
{0x88, 0xff,}, //C-mask middle STD TH
{0x89, 0xff,}, //C-mask far STD TH

///////////////////////////////////////////////////////////////////////////////
// 20 Page (FZY)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x20,}, //Page 20

{0x12, 0xe0,}, //Dgain off 20 //Dgain enb_2x e0

{0x36, 0x00,}, //EXP Unit
{0x37, 0x07,},
{0x38, 0x3a,},

{0x71, 0x70,}, //DG MAX //D gain 1x = 80 = x 1 // D gain 2x = 40 = x 1
{0x72, 0x40,}, //DG MIN

{0x80, 0x3a,}, //Y Target

///////////////////////////////////////////////////////////////////////////////
// 2A Page (SSD)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x2A,},
{0x15, 0x02,},	//720p mode on
{0x16, 0x50,},	//SSD B gain int gain 1.5x
{0x73, 0x0C,},	//start x in 720p
{0x74, 0x08,},	//start y in 720p
{0x75, 0x64,},	//width   in 720p
{0x76, 0x4A,},	//height  in 720p

///////////////////////////////////////////////////////////////////////////////
//
// F/W setting start
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// C0 Page (SYSTEM)
///////////////////////////////////////////////////////////////////////////////
//OPCLK Setting
//43Mhz = 29020C0
{0x03, 0xC0,},
{0x14, 0x02,},
{0x15, 0x90,},
{0x16, 0x20,},
{0x17, 0xC0,},

///////////////////////////////////////////////////////////////////////////////
// C7 Page (AE)
///////////////////////////////////////////////////////////////////////////////
//Shutter Setting
{0x03, 0xc7,},

{0x12, 0x03,}, // Slow AE
{0x15, 0xc0,}, // SSD Patch Weight Y Mean On

{0x36, 0x18,}, // Max 24fps
{0x37, 0x18,}, // Max 24fps

{0x11, 0x01,}, // B[1]Initial Speed Up, B[0]AE Reset

{0x4c, 0x00,}, //SW ExpMin = 3700
{0x4d, 0x00,},
{0x4e, 0x0e,},
{0x4f, 0x74,},

{0x03, 0x20,}, //20 page

{0x28, 0x00,}, //HW ExpMin = 3700
{0x29, 0x0e,},
{0x2a, 0x74,},

///////////////////////////////////////////////////////////////////////////////
// C8 ~ CC Page (AWB)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xc8,},
{0x17, 0x00,}, //AWB Speed
{0x18, 0x11,},
{0x21, 0x00,},
{0x22, 0x01,},
{0x11, 0xC3,},	//AWB reset
///////////////////////////////////////////////////////////////////////////////
// D3 ~ D8 Page (Adaptive)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xd3,},	// Adaptive start

{0x1d, 0x00,},	//EV Th OutEnd : 120fps AG 1x DG 1x
{0x1e, 0x00,},
{0x1f, 0x20,},
{0x20, 0x8d,},

{0x21, 0x00,},	//EV Th OutStr : 80fps  Ag 1x Dg 1x
{0x22, 0x00,},
{0x23, 0x30,},
{0x24, 0xd4,},

{0x25, 0x00,},	//EV Th Dark1Str
{0x26, 0x03,},
{0x27, 0x70,},
{0x28, 0xf0,},

{0x29, 0x00,},	//EV Th Dark1End
{0x2a, 0x05,},
{0x2b, 0x57,},
{0x2c, 0x30,},

{0x2d, 0x00,},	//EV Th Dark2Str
{0x2e, 0x06,},
{0x2f, 0x1a,},
{0x30, 0x80,},

{0x31, 0x00,},	//EV Th Dark2End
{0x32, 0x08,},
{0x33, 0x86,},
{0x34, 0xb6,},

{0x7d, 0x36,},	// Y_target_Outdoor
{0x7e, 0x3c,},	// Y_target_Indoor
{0x7f, 0x3c,},	// Y_target_Dark1
{0x80, 0x3c,},	// Y_target_Dark2
{0x81, 0x3c,},	// Y_target_LowTemp
{0x82, 0x3c,},	// Y_target_HighTemp

{0x83, 0x80,}, // Cb_Outdoor
{0x89, 0x80,},	// Cr _Sat_Outdoor

{0x97, 0x84,},	// BLC_ofs_r_Dark1
{0x98, 0x84,},	// BLC_ofs_b_Dark1
{0x99, 0x85,},	// BLC_ofs_gr_Dark1
{0x9a, 0x85,},	// BLC_ofs_gb_Dark1

{0x9b, 0x84,},	// BLC_ofs_r_Dark2
{0x9c, 0x84,},	// BLC_ofs_b_Dark2
{0x9d, 0x85,},	// BLC_ofs_gr_Dark2
{0x9e, 0x85,},	// BLC_ofs_gb_Dark2

////////////////////
// Adaptive Gamma //
////////////////////

{0x03, 0xd4,},
{0x0e, 0x01,}, // burst start
{0xe3, 0x00,},	//GMA_OUT
{0xe4, 0x00,},
{0xe5, 0x03,},
{0xe6, 0x0b,},
{0xe7, 0x15,},
{0xe8, 0x21,},
{0xe9, 0x2f,},
{0xea, 0x3c,},
{0xeb, 0x49,},
{0xec, 0x54,},
{0xed, 0x5e,},
{0xee, 0x68,},
{0xef, 0x72,},
{0xf0, 0x79,},
{0xf1, 0x7f,},
{0xf2, 0x84,},
{0xf3, 0x8a,},
{0xf4, 0x8e,},
{0xf5, 0x94,},
{0xf6, 0x98,},
{0xf7, 0x9d,},
{0xf8, 0xa7,},
{0xf9, 0xb2,},
{0xfa, 0xbb,},
{0xfb, 0xcb,},
{0xfc, 0xda,},
{0xfd, 0xe9,},
{0x0e, 0x00,}, // burst end

{0x03, 0xd5,},	//Page d5

{0x0e, 0x01,}, // burst start

{0x10, 0xf7,},
{0x11, 0xff,},
{0x12, 0xff,},
{0x13, 0xff,},
{0x14, 0xff,},
{0x15, 0xff,},
{0x16, 0xff,},

{0x17, 0x00,},	//GMA_IN
{0x18, 0x05,},
{0x19, 0x09,},
{0x1a, 0x11,},
{0x1b, 0x19,},
{0x1c, 0x26,},
{0x1d, 0x33,},
{0x1e, 0x3f,},
{0x1f, 0x4a,},
{0x20, 0x55,},
{0x21, 0x5e,},
{0x22, 0x67,},
{0x23, 0x6f,},
{0x24, 0x77,},
{0x25, 0x7e,},
{0x26, 0x84,},
{0x27, 0x8b,},
{0x28, 0x91,},
{0x29, 0x96,},
{0x2a, 0x9b,},
{0x2b, 0xa0,},
{0x2c, 0xa8,},
{0x2d, 0xb2,},
{0x2e, 0xbc,},
{0x2f, 0xcd,},
{0x30, 0xdd,},
{0x31, 0xec,},
{0x32, 0xf9,},
{0x33, 0xff,},
{0x34, 0xff,},
{0x35, 0xff,},
{0x36, 0xff,},
{0x37, 0xff,},
{0x38, 0xff,},

{0x39, 0x00,},	//GMA_D1
{0x3a, 0x04,},
{0x3b, 0x08,},
{0x3c, 0x0f,},
{0x3d, 0x1b,},
{0x3e, 0x2e,},
{0x3f, 0x3e,},
{0x40, 0x4e,},
{0x41, 0x5b,},
{0x42, 0x65,},
{0x43, 0x71,},
{0x44, 0x7b,},
{0x45, 0x85,},
{0x46, 0x8d,},
{0x47, 0x95,},
{0x48, 0x9b,},
{0x49, 0xa3,},
{0x4a, 0xa9,},
{0x4b, 0xb0,},
{0x4c, 0xb6,},
{0x4d, 0xbb,},
{0x4e, 0xc5,},
{0x4f, 0xcf,},
{0x50, 0xd7,},
{0x51, 0xe7,},
{0x52, 0xf3,},
{0x53, 0xfa,},
{0x54, 0xff,},
{0x55, 0xff,},
{0x56, 0xff,},
{0x57, 0xff,},
{0x58, 0xff,},
{0x59, 0xff,},
{0x5a, 0xff,},

{0x5b, 0x00,},	//GMA_D2
{0x5c, 0x04,},
{0x5d, 0x08,},
{0x5e, 0x0f,},
{0x5f, 0x1b,},
{0x60, 0x2e,},
{0x61, 0x3e,},
{0x62, 0x4e,},
{0x63, 0x5b,},
{0x64, 0x65,},
{0x65, 0x71,},
{0x66, 0x7b,},
{0x67, 0x85,},
{0x68, 0x8d,},
{0x69, 0x95,},
{0x6a, 0x9b,},
{0x6b, 0xa3,},
{0x6c, 0xa9,},
{0x6d, 0xb0,},
{0x6e, 0xb6,},
{0x6f, 0xbb,},
{0x70, 0xc5,},
{0x71, 0xcf,},
{0x72, 0xd7,},
{0x73, 0xe7,},
{0x74, 0xf3,},
{0x75, 0xfa,},
{0x76, 0xff,},
{0x77, 0xff,},
{0x78, 0xff,},
{0x79, 0xff,},
{0x7a, 0xff,},
{0x7b, 0xff,},
{0x7c, 0xff,},
{0x0e, 0x00,}, // burst end

{0x03, 0xD3,},
{0x11, 0xFE,},	// Adaptive LSC on
{0x10, 0x8d,},	// Adaptive on //B[1] EV with Y off for HD

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E0 page Original.
{0xd0, 0x26,},
{0xd1, 0x54,},

//DMA Outdoor
{0x03, 0xdf,}, //DMA DF Page
{0xb1, 0x83,}, //Outdoor 1310 //Y-NR ENB add  720p

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E0 page.
{0xD0, 0x27,},
{0xD1, 0x42,},

{0x03, 0xe0,}, //DMA E0 Page
{0x94, 0x11,},
{0x95, 0x29,}, //Outdoor 1211 (20130416 for defect)

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E3 page Origianl.
{0xd6, 0x2a,},
{0xd7, 0x0c,},

//DMA Indoor
{0x03, 0xe1,}, //DMA E1 Page
{0x13, 0x7f,}, //Indoor 1111 add 720p
{0x21, 0x01,}, //Indoor 1137 //Pre Flat rate
{0x23, 0x00,}, //Indoor 1138
{0x25, 0xff,}, //Indoor 1139
{0x2d, 0x20,}, //Indoor 113d
{0x35, 0x1e,}, //Indoor 1141
{0xd9, 0x65,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos
{0xf9, 0x00,}, //Indoor 11e2 //Bayer Flat R4 LumL
{0xfb, 0x00,}, //Indoor 11e3

{0x03, 0xe2,}, //DMA E2 Page
{0x11, 0x2a,}, //Indoor 11e5 //Bayer Flat R4 StdH
{0x15, 0x00,}, //Indoor 11e7
{0x1d, 0x00,}, //Indoor 11eb
{0x1f, 0xac,}, //Indoor 11ef //Bayer Flat R3/R4 rate
{0x5b, 0x5f,}, //Indoor 12ae //Bayer Flat off
{0xb1, 0x83,}, //Indoor 1310 //Y-NR ENB add 720p
{0xfd, 0x17,}, //Indoor 1414 //YC2D Low Gain B[5:0]

{0x03, 0xe3,}, //DMA E3 Page
{0x13, 0x17,}, //Indoor 1416 //YC2D Hi Gain B[5:0]
{0x1d, 0x20,}, //Indoor 141b //YC2D Post STD gain Neg
{0x6f, 0x1c,}, //Indoor 1487 //YC2D SP STD Gain1
{0x71, 0x20,}, //Indoor 1488 //YC2D SP STD Gain2
{0x77, 0x22,}, //Indoor 148b //YC2D SP STD Gain5
{0x79, 0x22,}, //Indoor 148c //YC2D SP STD Gain6
{0x7b, 0x1c,}, //Indoor 148d //YC2D SP STD Gain7
{0x7d, 0x18,}, //Indoor 148e //YC2D SP STD Gain8

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E3 page.
{0xD6, 0x2A,},
{0xD7, 0xFA,},

{0x03, 0xe3,}, //DMA E3 Page
{0x94, 0x11,},
{0x95, 0x29,}, //Indoor 1211 (20130416 for defect)

///////////////////////////////////////////////////////////////////////////////
// E4 ~ E6 Page (DMA Dark1)
///////////////////////////////////////////////////////////////////////////////

//I2CD set
{0x03, 0x26,}, //Xdata mapping for I2C direct E6 page Original.
{0xdc, 0x2d,},
{0xdd, 0xc4,},

{0x03, 0xe4,}, //DMA E4 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0xff,}, //Dark1 1111 add 720p
{0x14, 0x14,},
{0x15, 0x00,}, //Dark1 1114 add 720p
{0x16, 0x15,},
{0x17, 0x00,}, //Dark1 1115 add 720p
{0x18, 0x16,},
{0x19, 0x00,}, //Dark1 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x1e,}, //Dark1 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x10,}, //Dark1 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x06,}, //Dark1 1119 add 720p
{0x20, 0x37,},
{0x21, 0x01,}, //Dark1 1137 //Pre Flat rate B[4:1]
{0x22, 0x38,},
{0x23, 0x00,}, //Dark1 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0x03,}, //Dark1 1139 //Pre Flat R1 LumH
{0x26, 0x3a,},
{0x27, 0x03,}, //Dark1 113a
{0x28, 0x3b,},
{0x29, 0xff,}, //Dark1 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Dark1 113c
{0x2c, 0x3d,},
{0x2d, 0x13,}, //Dark1 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark1 113e
{0x30, 0x3f,},
{0x31, 0x10,}, //Dark1 113f
{0x32, 0x40,},
{0x33, 0x00,}, //Dark1 1140
{0x34, 0x41,},
{0x35, 0x10,}, //Dark1 1141
{0x36, 0x42,},
{0x37, 0x00,}, //Dark1 1142
{0x38, 0x43,},
{0x39, 0x18,}, //Dark1 1143
{0x3a, 0x49,},
{0x3b, 0x02,}, //Dark1 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x04,}, //Dark1 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x07,}, //Dark1 114b add 720p
{0x40, 0x4c,},
{0x41, 0x0c,}, //Dark1 114c add 720p
{0x42, 0x4d,},
{0x43, 0x10,}, //Dark1 114d add 720p
{0x44, 0x4e,},
{0x45, 0x18,}, //Dark1 114e add 720p
{0x46, 0x4f,},
{0x47, 0x20,}, //Dark1 114f add 720p
{0x48, 0x50,},
{0x49, 0x1a,}, //Dark1 1150
{0x4a, 0x51,},
{0x4b, 0x1c,}, //Dark1 1151
{0x4c, 0x52,},
{0x4d, 0x1e,}, //Dark1 1152
{0x4e, 0x53,},
{0x4f, 0x24,}, //Dark1 1153
{0x50, 0x54,},
{0x51, 0x28,}, //Dark1 1154
{0x52, 0x55,},
{0x53, 0x26,}, //Dark1 1155
{0x54, 0x56,},
{0x55, 0x22,}, //Dark1 1156
{0x56, 0x57,},
{0x57, 0x1e,}, //Dark1 1157
{0x58, 0x58,},
{0x59, 0x3f,}, //Dark1 1158
{0x5a, 0x59,},
{0x5b, 0x3f,}, //Dark1 1159
{0x5c, 0x5a,},
{0x5d, 0x3f,}, //Dark1 115a
{0x5e, 0x5b,},
{0x5f, 0x3f,}, //Dark1 115b
{0x60, 0x5c,},
{0x61, 0x3f,}, //Dark1 115c
{0x62, 0x5d,},
{0x63, 0x3f,}, //Dark1 115d
{0x64, 0x5e,},
{0x65, 0x3f,}, //Dark1 115e
{0x66, 0x5f,},
{0x67, 0x3f,}, //Dark1 115f
{0x68, 0x6e,},
{0x69, 0x10,}, //Dark1 116e
{0x6a, 0x6f,},
{0x6b, 0x10,}, //Dark1 116f
{0x6c, 0x77,},
{0x6d, 0x20,}, //Dark1 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x1e,}, //Dark1 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x1c,}, //Dark1 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x18,}, //Dark1 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x14,}, //Dark1 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,}, //Dark1 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x08,}, //Dark1 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x08,}, //Dark1 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x1c,}, //Dark1 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x1c,}, //Dark1 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x1c,}, //Dark1 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x18,}, //Dark1 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x14,}, //Dark1 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x10,}, //Dark1 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x08,}, //Dark1 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x08,}, //Dark1 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x20,}, //Dark1 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x1e,}, //Dark1 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x1c,}, //Dark1 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x1a,}, //Dark1 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x16,}, //Dark1 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x14,}, //Dark1 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark1 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x10,}, //Dark1 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x1d,}, //Dark1 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x1d,}, //Dark1 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x1c,}, //Dark1 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x1a,}, //Dark1 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x16,}, //Dark1 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x14,}, //Dark1 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark1 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x10,}, //Dark1 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x18,}, //Dark1 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark1 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark1 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x15,}, //Dark1 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x12,}, //Dark1 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x10,}, //Dark1 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x10,}, //Dark1 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x10,}, //Dark1 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x18,}, //Dark1 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x10,}, //Dark1 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x08,}, //Dark1 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x08,}, //Dark1 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x08,}, //Dark1 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x08,}, //Dark1 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x1c,}, //Dark1 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x1c,}, //Dark1 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x1c,}, //Dark1 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x1a,}, //Dark1 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark1 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x16,}, //Dark1 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x14,}, //Dark1 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x12,}, //Dark1 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x22,}, //Dark1 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark1 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x04,}, //Dark1 11d1
{0xde, 0xd2,},
{0xdf, 0x1a,}, //Dark1 11d2
{0xe0, 0xd3,},
{0xe1, 0x23,}, //Dark1 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark1 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x16,}, //Dark1 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark1 11d6
{0xe8, 0xd7,},
{0xe9, 0x1c,}, //Dark1 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark1 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x08,}, //Dark1 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark1 11da
{0xf0, 0xdb,},
{0xf1, 0x0e,}, //Dark1 11db
{0xf2, 0xdf,},
{0xf3, 0x73,}, //Dark1 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x04,}, //Dark1 11e0
{0xf6, 0xe1,},
{0xf7, 0x1a,}, //Dark1 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark1 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xff,}, //Dark1 11e3
{0xfc, 0xe4,},
{0xfd, 0x00,}, //Dark1 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe5,}, //DMA E5 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x18,}, //Dark1 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark1 11e6
{0x14, 0xe7,},
{0x15, 0x28,}, //Dark1 11e7
{0x16, 0xe8,},
{0x17, 0x00,}, //Dark1 11e8
{0x18, 0xe9,},
{0x19, 0x09,}, //Dark1 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark1 11ea
{0x1c, 0xeb,},
{0x1d, 0x14,}, //Dark1 11eb
{0x1e, 0xef,},
{0x1f, 0x33,}, //Dark1 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,}, //12 Page
{0x22, 0x40,},
{0x23, 0x36,}, //Dark1 1240 add 720p
{0x24, 0x70,},
{0x25, 0x81,}, //Dark1 1270 // Bayer Sharpness ENB add 720p
{0x26, 0x71,},
{0x27, 0x07,}, //Dark1 1271 //Bayer HPF Gain
{0x28, 0x72,},
{0x29, 0x07,}, //Dark1 1272 //Bayer LPF Gain
{0x2a, 0x77,},
{0x2b, 0x00,}, //Dark1 1277
{0x2c, 0x78,},
{0x2d, 0x09,}, //Dark1 1278
{0x2e, 0x79,},
{0x2f, 0x2e,}, //Dark1 1279
{0x30, 0x7a,},
{0x31, 0x50,}, //Dark1 127a
{0x32, 0x7b,},
{0x33, 0x10,}, //Dark1 127b
{0x34, 0x7c,},
{0x35, 0x50,}, //Dark1 127c //skin HPF gain
{0x36, 0x7d,},
{0x37, 0x10,}, //Dark1 127d
{0x38, 0x7f,},
{0x39, 0x50,}, //Dark1 127f
{0x3a, 0x87,},
{0x3b, 0x08,}, //Dark1 1287 add 720p
{0x3c, 0x88,},
{0x3d, 0x08,}, //Dark1 1288 add 720p
{0x3e, 0x89,},
{0x3f, 0x08,}, //Dark1 1289 add 720p
{0x40, 0x8a,},
{0x41, 0x0c,}, //Dark1 128a add 720p
{0x42, 0x8b,},
{0x43, 0x10,}, //Dark1 128b add 720p
{0x44, 0x8c,},
{0x45, 0x14,}, //Dark1 128c add 720p
{0x46, 0x8d,},
{0x47, 0x18,}, //Dark1 128d add 720p
{0x48, 0x8e,},
{0x49, 0x1a,}, //Dark1 128e add 720p
{0x4a, 0x8f,},
{0x4b, 0x08,}, //Dark1 128f add 720p
{0x4c, 0x90,},
{0x4d, 0x0a,}, //Dark1 1290 add 720p
{0x4e, 0x91,},
{0x4f, 0x0e,}, //Dark1 1291 add 720p
{0x50, 0x92,},
{0x51, 0x12,}, //Dark1 1292 add 720p
{0x52, 0x93,},
{0x53, 0x16,}, //Dark1 1293 add 720p
{0x54, 0x94,},
{0x55, 0x1a,}, //Dark1 1294 add 720p
{0x56, 0x95,},
{0x57, 0x20,}, //Dark1 1295 add 720p
{0x58, 0x96,},
{0x59, 0x20,}, //Dark1 1296 add 720p
{0x5a, 0xae,},
{0x5b, 0x20,}, //Dark1 12ae
{0x5c, 0xaf,},
{0x5d, 0x33,}, //Dark1 12af // B[7:4]Blue/B[3:0]Skin
{0x5e, 0xc0,},
{0x5f, 0x23,}, //Dark1 12c0 // CI-LPF ENB add 720p
{0x60, 0xc3,},
{0x61, 0x18,}, //Dark1 12c3 add 720p
{0x62, 0xc4,},
{0x63, 0x0d,}, //Dark1 12c4 add 720p
{0x64, 0xc5,},
{0x65, 0x06,}, //Dark1 12c5 add 720p
{0x66, 0xc6,},
{0x67, 0x11,}, //Dark1 12c6
{0x68, 0xc7,},
{0x69, 0x11,}, //Dark1 12c7
{0x6a, 0xc8,},
{0x6b, 0x04,}, //Dark1 12c8
{0x6c, 0xd0,},
{0x6d, 0x02,}, //Dark1 12d0 add 720p
{0x6e, 0xd1,},
{0x6f, 0x04,}, //Dark1 12d1 add 720p
{0x70, 0xd2,},
{0x71, 0x07,}, //Dark1 12d2 add 720p
{0x72, 0xd3,},
{0x73, 0x0c,}, //Dark1 12d3 add 720p
{0x74, 0xd4,},
{0x75, 0x10,}, //Dark1 12d4 add 720p
{0x76, 0xd5,},
{0x77, 0x18,}, //Dark1 12d5 add 720p
{0x78, 0xd6,},
{0x79, 0x20,}, //Dark1 12d6 add 720p
{0x7a, 0xd7,},
{0x7b, 0x29,}, //Dark1 12d7 //CI LPF Lum offset start
{0x7c, 0xd8,},
{0x7d, 0x2a,}, //Dark1 12d8
{0x7e, 0xd9,},
{0x7f, 0x2c,}, //Dark1 12d9
{0x80, 0xda,},
{0x81, 0x2b,}, //Dark1 12da
{0x82, 0xdb,},
{0x83, 0x2a,}, //Dark1 12db
{0x84, 0xdc,},
{0x85, 0x28,}, //Dark1 12dc
{0x86, 0xdd,},
{0x87, 0x27,}, //Dark1 12dd
{0x88, 0xde,},
{0x89, 0x27,}, //Dark1 12de //CI LPF Lum offset end
{0x8a, 0xe0,},
{0x8b, 0x63,}, //Dark1 12e0 // 20121120 ln dy
{0x8c, 0xe1,},
{0x8d, 0xfc,}, //Dark1 12e1
{0x8e, 0xe2,},
{0x8f, 0x02,}, //Dark1 12e2
{0x90, 0xe3,},
{0x91, 0x10,}, //Dark1 12e3 //PS LN graph Y1
{0x92, 0xe4,},
{0x93, 0x12,}, //Dark1 12e4 //PS LN graph Y2
{0x94, 0xe5,},
{0x95, 0x1a,}, //Dark1 12e5 //PS LN graph Y3
{0x96, 0xe6,},
{0x97, 0x1d,}, //Dark1 12e6 //PS LN graph Y4
{0x98, 0xe7,},
{0x99, 0x1e,}, //Dark1 12e7 //PS LN graph Y5
{0x9a, 0xe8,},
{0x9b, 0x1f,}, //Dark1 12e8 //PS LN graph Y6
{0x9c, 0xe9,},
{0x9d, 0x10,}, //Dark1 12e9 //PS DY graph Y1
{0x9e, 0xea,},
{0x9f, 0x12,}, //Dark1 12ea //PS DY graph Y2
{0xa0, 0xeb,},
{0xa1, 0x18,}, //Dark1 12eb //PS DY graph Y3
{0xa2, 0xec,},
{0xa3, 0x1c,}, //Dark1 12ec //PS DY graph Y4
{0xa4, 0xed,},
{0xa5, 0x1e,}, //Dark1 12ed //PS DY graph Y5
{0xa6, 0xee,},
{0xa7, 0x1f,}, //Dark1 12ee //PS DY graph Y6
{0xa8, 0xf0,},
{0xa9, 0x00,}, //Dark1 12f0
{0xaa, 0xf1,},
{0xab, 0x2a,}, //Dark1 12f1
{0xac, 0xf2,},
{0xad, 0x32,}, //Dark1 12f2
{0xae, 0x03,},
{0xaf, 0x13,}, //13 Page
{0xb0, 0x10,},
{0xb1, 0x80,}, //Dark1 1310 //Y-NR ENB add 720p
{0xb2, 0x30,},
{0xb3, 0x20,}, //Dark1 1330
{0xb4, 0x31,},
{0xb5, 0x20,}, //Dark1 1331
{0xb6, 0x32,},
{0xb7, 0x20,}, //Dark1 1332
{0xb8, 0x33,},
{0xb9, 0x20,}, //Dark1 1333
{0xba, 0x34,},
{0xbb, 0x20,}, //Dark1 1334
{0xbc, 0x35,},
{0xbd, 0x2d,}, //Dark1 1335
{0xbe, 0x36,},
{0xbf, 0x20,}, //Dark1 1336
{0xc0, 0x37,},
{0xc1, 0x20,}, //Dark1 1337
{0xc2, 0x38,},
{0xc3, 0x02,}, //Dark1 1338
{0xc4, 0x40,},
{0xc5, 0x00,}, //Dark1 1340
{0xc6, 0x41,},
{0xc7, 0x13,}, //Dark1 1341
{0xc8, 0x42,},
{0xc9, 0x62,}, //Dark1 1342
{0xca, 0x43,},
{0xcb, 0x63,}, //Dark1 1343
{0xcc, 0x44,},
{0xcd, 0x7e,}, //Dark1 1344
{0xce, 0x45,},
{0xcf, 0x00,}, //Dark1 1345
{0xd0, 0x46,},
{0xd1, 0x6b,}, //Dark1 1346
{0xd2, 0x47,},
{0xd3, 0x00,}, //Dark1 1347
{0xd4, 0x48,},
{0xd5, 0x4a,}, //Dark1 1348
{0xd6, 0x49,},
{0xd7, 0x00,}, //Dark1 1349
{0xd8, 0x4a,},
{0xd9, 0x43,}, //Dark1 134a
{0xda, 0x4b,},
{0xdb, 0x00,}, //Dark1 134b
{0xdc, 0x4c,},
{0xdd, 0x2e,}, //Dark1 134c
{0xde, 0x83,},
{0xdf, 0x08,}, //Dark1 1383
{0xe0, 0x84,},
{0xe1, 0x0a,}, //Dark1 1384
{0xe2, 0xb7,},
{0xe3, 0xff,}, //Dark1 13b7
{0xe4, 0xb8,},
{0xe5, 0xff,}, //Dark1 13b8
{0xe6, 0xb9,},
{0xe7, 0xff,}, //Dark1 13b9 //20121217 DC R1,2 CR
{0xe8, 0xba,},
{0xe9, 0xff,}, //Dark1 13ba //20121217 DC R3,4 CR
{0xea, 0xbd,},
{0xeb, 0x78,}, //Dark1 13bd //20121121 c-filter LumHL DC rate
{0xec, 0xc5,},
{0xed, 0x01,}, //Dark1 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xee, 0xc6,},
{0xef, 0x22,}, //Dark1 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf0, 0xc7,},
{0xf1, 0x33,}, //Dark1 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf2, 0x03,},
{0xf3, 0x14,}, //14 page
{0xf4, 0x10,},
{0xf5, 0x01,}, //Dark1 1410
{0xf6, 0x11,},
{0xf7, 0xd8,}, //Dark1 1411
{0xf8, 0x12,},
{0xf9, 0x10,}, //Dark1 1412
{0xfa, 0x13,},
{0xfb, 0x05,}, //Dark1 1413
{0xfc, 0x14,},
{0xfd, 0x14,}, //Dark1 1414 //YC2D Low Gain B[5:0]
{0x0e, 0x00,}, // burst end

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x15,},
{0x11, 0x7d,}, //Dark1 1415 // Y Hi filter mask 1/16
{0x12, 0x16,},
{0x13, 0x17,}, //Dark1 1416 //YC2D Hi Gain B[5:0]
{0x14, 0x17,},
{0x15, 0x40,}, //Dark1 1417
{0x16, 0x18,},
{0x17, 0x0c,}, //Dark1 1418
{0x18, 0x19,},
{0x19, 0x0c,}, //Dark1 1419
{0x1a, 0x1a,},
{0x1b, 0x1c,}, //Dark1 141a //YC2D Post STD gain Pos
{0x1c, 0x1b,},
{0x1d, 0x1c,}, //Dark1 141b //YC2D Post STD gain Neg
{0x1e, 0x27,},
{0x1f, 0x0f,}, //Dark1 1427 //YC2D SP Lum Gain Pos1
{0x20, 0x28,},
{0x21, 0x10,}, //Dark1 1428 //YC2D SP Lum Gain Pos2
{0x22, 0x29,},
{0x23, 0x11,}, //Dark1 1429 //YC2D SP Lum Gain Pos3
{0x24, 0x2a,},
{0x25, 0x12,}, //Dark1 142a //YC2D SP Lum Gain Pos4
{0x26, 0x2b,},
{0x27, 0x13,}, //Dark1 142b //YC2D SP Lum Gain Pos5
{0x28, 0x2c,},
{0x29, 0x14,}, //Dark1 142c //YC2D SP Lum Gain Pos6
{0x2a, 0x2d,},
{0x2b, 0x13,}, //Dark1 142d //YC2D SP Lum Gain Pos7
{0x2c, 0x2e,},
{0x2d, 0x10,}, //Dark1 142e //YC2D SP Lum Gain Pos8
{0x2e, 0x30,},
{0x2f, 0x0f,}, //Dark1 1430 //YC2D SP Lum Gain Neg1
{0x30, 0x31,},
{0x31, 0x10,}, //Dark1 1431 //YC2D SP Lum Gain Neg2
{0x32, 0x32,},
{0x33, 0x11,}, //Dark1 1432 //YC2D SP Lum Gain Neg3
{0x34, 0x33,},
{0x35, 0x12,}, //Dark1 1433 //YC2D SP Lum Gain Neg4
{0x36, 0x34,},
{0x37, 0x13,}, //Dark1 1434 //YC2D SP Lum Gain Neg5
{0x38, 0x35,},
{0x39, 0x13,}, //Dark1 1435 //YC2D SP Lum Gain Neg6
{0x3a, 0x36,},
{0x3b, 0x12,}, //Dark1 1436 //YC2D SP Lum Gain Neg7
{0x3c, 0x37,},
{0x3d, 0x10,}, //Dark1 1437 //YC2D SP Lum Gain Neg8
{0x3e, 0x47,},
{0x3f, 0x1c,}, //Dark1 1447 //YC2D SP Dy Gain Pos1
{0x40, 0x48,},
{0x41, 0x1b,}, //Dark1 1448 //YC2D SP Dy Gain Pos2
{0x42, 0x49,},
{0x43, 0x1a,}, //Dark1 1449 //YC2D SP Dy Gain Pos3
{0x44, 0x4a,},
{0x45, 0x18,}, //Dark1 144a //YC2D SP Dy Gain Pos4
{0x46, 0x4b,},
{0x47, 0x16,}, //Dark1 144b //YC2D SP Dy Gain Pos5
{0x48, 0x4c,},
{0x49, 0x14,}, //Dark1 144c //YC2D SP Dy Gain Pos6
{0x4a, 0x4d,},
{0x4b, 0x12,}, //Dark1 144d //YC2D SP Dy Gain Pos7
{0x4c, 0x4e,},
{0x4d, 0x10,}, //Dark1 144e //YC2D SP Dy Gain Pos8
{0x4e, 0x50,},
{0x4f, 0x1a,}, //Dark1 1450 //YC2D SP Dy Gain Neg1
{0x50, 0x51,},
{0x51, 0x19,}, //Dark1 1451 //YC2D SP Dy Gain Neg2
{0x52, 0x52,},
{0x53, 0x18,}, //Dark1 1452 //YC2D SP Dy Gain Neg3
{0x54, 0x53,},
{0x55, 0x17,}, //Dark1 1453 //YC2D SP Dy Gain Neg4
{0x56, 0x54,},
{0x57, 0x16,}, //Dark1 1454 //YC2D SP Dy Gain Neg5
{0x58, 0x55,},
{0x59, 0x14,}, //Dark1 1455 //YC2D SP Dy Gain Neg6
{0x5a, 0x56,},
{0x5b, 0x12,}, //Dark1 1456 //YC2D SP Dy Gain Neg7
{0x5c, 0x57,},
{0x5d, 0x10,}, //Dark1 1457 //YC2D SP Dy Gain Neg8
{0x5e, 0x67,},
{0x5f, 0x10,}, //Dark1 1467 //YC2D SP Edge Gain1
{0x60, 0x68,},
{0x61, 0x13,}, //Dark1 1468 //YC2D SP Edge Gain2
{0x62, 0x69,},
{0x63, 0x13,}, //Dark1 1469 //YC2D SP Edge Gain3
{0x64, 0x6a,},
{0x65, 0x14,}, //Dark1 146a //YC2D SP Edge Gain4
{0x66, 0x6b,},
{0x67, 0x16,}, //Dark1 146b //YC2D SP Edge Gain5
{0x68, 0x6c,},
{0x69, 0x16,}, //Dark1 146c //YC2D SP Edge Gain6
{0x6a, 0x6d,},
{0x6b, 0x15,}, //Dark1 146d //YC2D SP Edge Gain7
{0x6c, 0x6e,},
{0x6d, 0x13,}, //Dark1 146e //YC2D SP Edge Gain8
{0x6e, 0x87,},
{0x6f, 0x19,}, //Dark1 1487 //YC2D SP STD Gain1
{0x70, 0x88,},
{0x71, 0x1a,}, //Dark1 1488 //YC2D SP STD Gain2
{0x72, 0x89,},
{0x73, 0x1c,}, //Dark1 1489 //YC2D SP STD Gain3
{0x74, 0x8a,},
{0x75, 0x1b,}, //Dark1 148a //YC2D SP STD Gain4
{0x76, 0x8b,},
{0x77, 0x1a,}, //Dark1 148b //YC2D SP STD Gain5
{0x78, 0x8c,},
{0x79, 0x1c,}, //Dark1 148c //YC2D SP STD Gain6
{0x7a, 0x8d,},
{0x7b, 0x25,}, //Dark1 148d //YC2D SP STD Gain7
{0x7c, 0x8e,},
{0x7d, 0x29,}, //Dark1 148e //YC2D SP STD Gain8
{0x7e, 0x97,},
{0x7f, 0x08,}, //Dark1 1497 add 720p
{0x80, 0x98,},
{0x81, 0x0c,}, //Dark1 1498 add 720p
{0x82, 0x99,},
{0x83, 0x10,}, //Dark1 1499 add 720p
{0x84, 0x9a,},
{0x85, 0x10,}, //Dark1 149a add 720p
{0x86, 0x9b,},
{0x87, 0x10,}, //Dark1 149b add 720p
{0x88, 0xa0,},
{0x89, 0x08,}, //Dark1 14a0 add 720p
{0x8a, 0xa1,},
{0x8b, 0x10,}, //Dark1 14a1 add 720p
{0x8c, 0xa2,},
{0x8d, 0x14,}, //Dark1 14a2 add 720p
{0x8e, 0xa3,},
{0x8f, 0x1a,}, //Dark1 14a3 add 720p
{0x90, 0xa4,},
{0x91, 0x1a,}, //Dark1 14a4 add 720p
{0x92, 0xc9,},
{0x93, 0x13,}, //Dark1 14c9
{0x94, 0xca,},
{0x95, 0x20,}, //Dark1 14ca
{0x96, 0x03,},
{0x97, 0x1a,}, //1A page
{0x98, 0x10,},
{0x99, 0x14,}, //Dark1 1A10 add 720p
{0x9a, 0x18,},
{0x9b, 0x1f,}, //Dark1 1A18
{0x9c, 0x19,},
{0x9d, 0x15,}, //Dark1 1A19
{0x9e, 0x1a,},
{0x9f, 0x0a,}, //Dark1 1A1a
{0xa0, 0x1b,},
{0xa1, 0x07,}, //Dark1 1A1b
{0xa2, 0x1c,},
{0xa3, 0x03,}, //Dark1 1A1c
{0xa4, 0x1d,},
{0xa5, 0x03,}, //Dark1 1A1d
{0xa6, 0x1e,},
{0xa7, 0x03,}, //Dark1 1A1e
{0xa8, 0x1f,},
{0xa9, 0x03,}, //Dark1 1A1f
{0xaa, 0x20,},
{0xab, 0x07,}, //Dark1 1A20 add 720p
{0xac, 0x2f,},
{0xad, 0xf6,}, //Dark1 1A2f add 720p
{0xae, 0x32,},
{0xaf, 0x07,}, //Dark1 1A32 add 720p
{0xb0, 0x34,},
{0xb1, 0xdf,}, //Dark1 1A34 //RGB High Gain B[5:0]
{0xb2, 0x35,},
{0xb3, 0x1b,}, //Dark1 1A35 //RGB Low Gain B[5:0]
{0xb4, 0x36,},
{0xb5, 0xef,}, //Dark1 1A36
{0xb6, 0x37,},
{0xb7, 0x40,}, //Dark1 1A37
{0xb8, 0x38,},
{0xb9, 0xff,}, //Dark1 1A38
{0xba, 0x39,},
{0xbb, 0x2e,}, //Dark1 1A39 //RGB Flat R2_Lum L
{0xbc, 0x3a,},
{0xbd, 0x3f,}, //Dark1 1A3a
{0xbe, 0x3b,},
{0xbf, 0x01,}, //Dark1 1A3b
{0xc0, 0x3c,},
{0xc1, 0x0c,}, //Dark1 1A3c
{0xc2, 0x3d,},
{0xc3, 0x01,}, //Dark1 1A3d
{0xc4, 0x3e,},
{0xc5, 0x07,}, //Dark1 1A3e
{0xc6, 0x3f,},
{0xc7, 0x01,}, //Dark1 1A3f
{0xc8, 0x40,},
{0xc9, 0x0c,}, //Dark1 1A40
{0xca, 0x41,},
{0xcb, 0x01,}, //Dark1 1A41
{0xcc, 0x42,},
{0xcd, 0x07,}, //Dark1 1A42
{0xce, 0x43,},
{0xcf, 0x2b,}, //Dark1 1A43
{0xd0, 0x4d,},
{0xd1, 0x15,}, //Dark1 1A4d //RGB SP Lum Gain Neg1
{0xd2, 0x4e,},
{0xd3, 0x14,}, //Dark1 1A4e //RGB SP Lum Gain Neg2
{0xd4, 0x4f,},
{0xd5, 0x13,}, //Dark1 1A4f //RGB SP Lum Gain Neg3
{0xd6, 0x50,},
{0xd7, 0x12,}, //Dark1 1A50 //RGB SP Lum Gain Neg4
{0xd8, 0x51,},
{0xd9, 0x11,}, //Dark1 1A51 //RGB SP Lum Gain Neg5
{0xda, 0x52,},
{0xdb, 0x10,}, //Dark1 1A52 //RGB SP Lum Gain Neg6
{0xdc, 0x53,},
{0xdd, 0x0f,}, //Dark1 1A53 //RGB SP Lum Gain Neg7
{0xde, 0x54,},
{0xdf, 0x0e,}, //Dark1 1A54 //RGB SP Lum Gain Neg8
{0xe0, 0x55,},
{0xe1, 0x15,}, //Dark1 1A55 //RGB SP Lum Gain Pos1
{0xe2, 0x56,},
{0xe3, 0x14,}, //Dark1 1A56 //RGB SP Lum Gain Pos2
{0xe4, 0x57,},
{0xe5, 0x13,}, //Dark1 1A57 //RGB SP Lum Gain Pos3
{0xe6, 0x58,},
{0xe7, 0x12,}, //Dark1 1A58 //RGB SP Lum Gain Pos4
{0xe8, 0x59,},
{0xe9, 0x11,}, //Dark1 1A59 //RGB SP Lum Gain Pos5
{0xea, 0x5a,},
{0xeb, 0x10,}, //Dark1 1A5a //RGB SP Lum Gain Pos6
{0xec, 0x5b,},
{0xed, 0x0f,}, //Dark1 1A5b //RGB SP Lum Gain Pos7
{0xee, 0x5c,},
{0xef, 0x0e,}, //Dark1 1A5c //RGB SP Lum Gain Pos8
{0xf0, 0x65,},
{0xf1, 0x1e,}, //Dark1 1A65 //RGB SP Dy Gain Neg1
{0xf2, 0x66,},
{0xf3, 0x1d,}, //Dark1 1A66 //RGB SP Dy Gain Neg2
{0xf4, 0x67,},
{0xf5, 0x1c,}, //Dark1 1A67 //RGB SP Dy Gain Neg3
{0xf6, 0x68,},
{0xf7, 0x1a,}, //Dark1 1A68 //RGB SP Dy Gain Neg4
{0xf8, 0x69,},
{0xf9, 0x18,}, //Dark1 1A69 //RGB SP Dy Gain Neg5
{0xfa, 0x6a,},
{0xfb, 0x16,}, //Dark1 1A6a //RGB SP Dy Gain Neg6
{0xfc, 0x6b,},
{0xfd, 0x14,}, //Dark1 1A6b //RGB SP Dy Gain Neg7
{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E6 page.
{0xDC, 0x2E,},
{0xDD, 0xB2,},

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x6c,},
{0x11, 0x12,}, //Dark1 1A6c //RGB SP Dy Gain Neg8
{0x12, 0x6d,},
{0x13, 0x1e,}, //Dark1 1A6d //RGB SP Dy Gain Pos1
{0x14, 0x6e,},
{0x15, 0x1d,}, //Dark1 1A6e //RGB SP Dy Gain Pos2
{0x16, 0x6f,},
{0x17, 0x1c,}, //Dark1 1A6f //RGB SP Dy Gain Pos3
{0x18, 0x70,},
{0x19, 0x1a,}, //Dark1 1A70 //RGB SP Dy Gain Pos4
{0x1a, 0x71,},
{0x1b, 0x18,}, //Dark1 1A71 //RGB SP Dy Gain Pos5
{0x1c, 0x72,},
{0x1d, 0x16,}, //Dark1 1A72 //RGB SP Dy Gain Pos6
{0x1e, 0x73,},
{0x1f, 0x14,}, //Dark1 1A73 //RGB SP Dy Gain Pos7
{0x20, 0x74,},
{0x21, 0x12,}, //Dark1 1A74 //RGB SP Dy Gain Pos8
{0x22, 0x7d,},
{0x23, 0x20,}, //Dark1 1A7d //RGB SP Edge Gain1
{0x24, 0x7e,},
{0x25, 0x1f,}, //Dark1 1A7e //RGB SP Edge Gain2
{0x26, 0x7f,},
{0x27, 0x1e,}, //Dark1 1A7f //RGB SP Edge Gain3
{0x28, 0x80,},
{0x29, 0x1c,}, //Dark1 1A80 //RGB SP Edge Gain4
{0x2a, 0x81,},
{0x2b, 0x1a,}, //Dark1 1A81 //RGB SP Edge Gain5
{0x2c, 0x82,},
{0x2d, 0x18,}, //Dark1 1A82 //RGB SP Edge Gain6
{0x2e, 0x83,},
{0x2f, 0x14,}, //Dark1 1A83 //RGB SP Edge Gain7
{0x30, 0x84,},
{0x31, 0x10,}, //Dark1 1A84 //RGB SP Edge Gain8
{0x32, 0x9e,},
{0x33, 0x22,}, //Dark1 1A9e //RGB SP STD Gain1
{0x34, 0x9f,},
{0x35, 0x20,}, //Dark1 1A9f //RGB SP STD Gain2
{0x36, 0xa0,},
{0x37, 0x1e,}, //Dark1 1Aa0 //RGB SP STD Gain3
{0x38, 0xa1,},
{0x39, 0x1c,}, //Dark1 1Aa1 //RGB SP STD Gain4
{0x3a, 0xa2,},
{0x3b, 0x1a,}, //Dark1 1Aa2 //RGB SP STD Gain5
{0x3c, 0xa3,},
{0x3d, 0x18,}, //Dark1 1Aa3 //RGB SP STD Gain6
{0x3e, 0xa4,},
{0x3f, 0x14,}, //Dark1 1Aa4 //RGB SP STD Gain7
{0x40, 0xa5,},
{0x41, 0x10,}, //Dark1 1Aa5 //RGB SP STD Gain8
{0x42, 0xa6,},
{0x43, 0xaa,}, //Dark1 1Aa6 //RGB Post STD Gain Pos/Neg
{0x44, 0xa7,},
{0x45, 0x04,}, //Dark1 1Aa7 add 720p
{0x46, 0xa8,},
{0x47, 0x06,}, //Dark1 1Aa8 add 720p
{0x48, 0xa9,},
{0x49, 0x08,}, //Dark1 1Aa9 add 720p
{0x4a, 0xaa,},
{0x4b, 0x09,}, //Dark1 1Aaa add 720p
{0x4c, 0xab,},
{0x4d, 0x0a,}, //Dark1 1Aab add 720p
{0x4e, 0xaf,},
{0x4f, 0x04,}, //Dark1 1Aaf add 720p
{0x50, 0xb0,},
{0x51, 0x06,}, //Dark1 1Ab0 add 720p
{0x52, 0xb1,},
{0x53, 0x08,}, //Dark1 1Ab1 add 720p
{0x54, 0xb2,},
{0x55, 0x0a,}, //Dark1 1Ab2 add 720p
{0x56, 0xb3,},
{0x57, 0x0c,}, //Dark1 1Ab3 add 720p
{0x58, 0xca,},
{0x59, 0x00,}, //Dark1 1Aca
{0x5a, 0xe3,},
{0x5b, 0x12,}, //Dark1 1Ae3 add 720p
{0x5c, 0xe4,},
{0x5d, 0x12,}, //Dark1 1Ae4 add 720p
{0x5e, 0x03,},
{0x5f, 0x10,}, //10 page
{0x60, 0x70,},
{0x61, 0x0c,}, //Dark1 1070 Trans Func.   130108 Dark1 transFuc Flat graph
{0x62, 0x71,},
{0x63, 0x06,}, //Dark1 1071
{0x64, 0x72,},
{0x65, 0xbe,}, //Dark1 1072
{0x66, 0x73,},
{0x67, 0x99,}, //Dark1 1073
{0x68, 0x74,},
{0x69, 0x00,}, //Dark1 1074
{0x6a, 0x75,},
{0x6b, 0x00,}, //Dark1 1075
{0x6c, 0x76,},
{0x6d, 0x20,}, //Dark1 1076
{0x6e, 0x77,},
{0x6f, 0x33,}, //Dark1 1077
{0x70, 0x78,},
{0x71, 0x33,}, //Dark1 1078
{0x72, 0x79,},
{0x73, 0x40,}, //Dark1 1079
{0x74, 0x7a,},
{0x75, 0x00,}, //Dark1 107a
{0x76, 0x7b,},
{0x77, 0x40,}, //Dark1 107b
{0x78, 0x7c,},
{0x79, 0x00,}, //Dark1 107c
{0x7a, 0x7d,},
{0x7b, 0x07,}, //Dark1 107d
{0x7c, 0x7e,},
{0x7d, 0x0f,}, //Dark1 107e
{0x7e, 0x7f,},
{0x7f, 0x1e,}, //Dark1 107f
{0x80, 0x03,},
{0x81, 0x02,}, // 2 page
{0x82, 0x23,},
{0x83, 0x10,}, //Dark1 0223 (for sun-spot) // normal 3c
{0x84, 0x03,},
{0x85, 0x03,}, // 3 page
{0x86, 0x1a,},
{0x87, 0x06,}, //Dark1 031a (for sun-spot)
{0x88, 0x1b,},
{0x89, 0x7c,}, //Dark1 031b (for sun-spot)
{0x8a, 0x1c,},
{0x8b, 0x00,}, //Dark1 031c (for sun-spot)
{0x8c, 0x1d,},
{0x8d, 0x50,}, //Dark1 031d (for sun-spot)
{0x8e, 0x03,},
{0x8f, 0x11,}, // 11 page
{0x90, 0xf0,},
{0x91, 0x04,}, //Dark1 11f0 (for af bug)
{0x92, 0x03,},
{0x93, 0x12,}, //12 page
{0x94, 0x11,},
{0x95, 0xa9,}, //Dark1 1211 (20130416 for defect)

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////////////////////////////////////////
// E7 ~ E9 Page (DMA Dark2)
///////////////////////////////////////////////////////////////////////////////

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E9 page Original.
{0xe2, 0x31,},
{0xe3, 0x7c,},

{0x03, 0xe7,}, //DMA E7 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0xff,}, //Dark2 1111 add 720p
{0x14, 0x14,},
{0x15, 0x00,}, //Dark2 1114 add 720p
{0x16, 0x15,},
{0x17, 0x00,}, //Dark2 1115 add 720p
{0x18, 0x16,},
{0x19, 0x00,}, //Dark2 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x1e,}, //Dark2 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x10,}, //Dark2 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x06,}, //Dark2 1119 add 720p
{0x20, 0x37,},
{0x21, 0x01,}, //Dark2 1137 //Pre Flat rate B[4:1] //04
{0x22, 0x38,},
{0x23, 0x00,}, //Dark2 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0x03,}, //Dark2 1139
{0x26, 0x3a,},
{0x27, 0x03,}, //Dark2 113a
{0x28, 0x3b,},
{0x29, 0xff,}, //Dark2 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Dark2 113c
{0x2c, 0x3d,},
{0x2d, 0x13,}, //Dark2 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark2 113e
{0x30, 0x3f,},
{0x31, 0x10,}, //Dark2 113f
{0x32, 0x40,},
{0x33, 0x00,}, //Dark2 1140
{0x34, 0x41,},
{0x35, 0x10,}, //Dark2 1141
{0x36, 0x42,},
{0x37, 0x00,}, //Dark2 1142
{0x38, 0x43,},
{0x39, 0x18,}, //Dark2 1143
{0x3a, 0x49,},
{0x3b, 0x02,}, //Dark2 1149
{0x3c, 0x4a,},
{0x3d, 0x04,}, //Dark2 114a
{0x3e, 0x4b,},
{0x3f, 0x07,}, //Dark2 114b
{0x40, 0x4c,},
{0x41, 0x0c,}, //Dark2 114c
{0x42, 0x4d,},
{0x43, 0x10,}, //Dark2 114d
{0x44, 0x4e,},
{0x45, 0x18,}, //Dark2 114e
{0x46, 0x4f,},
{0x47, 0x20,}, //Dark2 114f
{0x48, 0x50,},
{0x49, 0x1a,}, //Dark2 1150
{0x4a, 0x51,},
{0x4b, 0x1c,}, //Dark2 1151
{0x4c, 0x52,},
{0x4d, 0x1e,}, //Dark2 1152
{0x4e, 0x53,},
{0x4f, 0x24,}, //Dark2 1153
{0x50, 0x54,},
{0x51, 0x28,}, //Dark2 1154
{0x52, 0x55,},
{0x53, 0x26,}, //Dark2 1155
{0x54, 0x56,},
{0x55, 0x22,}, //Dark2 1156
{0x56, 0x57,},
{0x57, 0x1e,}, //Dark2 1157
{0x58, 0x58,},
{0x59, 0x3f,}, //Dark2 1158
{0x5a, 0x59,},
{0x5b, 0x3f,}, //Dark2 1159
{0x5c, 0x5a,},
{0x5d, 0x3f,}, //Dark2 115a
{0x5e, 0x5b,},
{0x5f, 0x3f,}, //Dark2 115b
{0x60, 0x5c,},
{0x61, 0x3f,}, //Dark2 115c
{0x62, 0x5d,},
{0x63, 0x3f,}, //Dark2 115d
{0x64, 0x5e,},
{0x65, 0x3f,}, //Dark2 115e
{0x66, 0x5f,},
{0x67, 0x3f,}, //Dark2 115f
{0x68, 0x6e,},
{0x69, 0x10,}, //Dark2 116e
{0x6a, 0x6f,},
{0x6b, 0x10,}, //Dark2 116f
{0x6c, 0x77,},
{0x6d, 0x20,}, //Dark2 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x1e,}, //Dark2 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x1c,}, //Dark2 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x18,}, //Dark2 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x14,}, //Dark2 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,}, //Dark2 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x08,}, //Dark2 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x08,}, //Dark2 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x1c,}, //Dark2 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x1c,}, //Dark2 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x1c,}, //Dark2 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x18,}, //Dark2 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x14,}, //Dark2 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x10,}, //Dark2 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x08,}, //Dark2 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x08,}, //Dark2 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x20,}, //Dark2 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x1e,}, //Dark2 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x1c,}, //Dark2 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x1a,}, //Dark2 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x16,}, //Dark2 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x14,}, //Dark2 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark2 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x10,}, //Dark2 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x1d,}, //Dark2 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x1d,}, //Dark2 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x1c,}, //Dark2 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x1a,}, //Dark2 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x16,}, //Dark2 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x14,}, //Dark2 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark2 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x10,}, //Dark2 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x18,}, //Dark2 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark2 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark2 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x15,}, //Dark2 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x12,}, //Dark2 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x10,}, //Dark2 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x10,}, //Dark2 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x10,}, //Dark2 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x18,}, //Dark2 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x10,}, //Dark2 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x08,}, //Dark2 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x08,}, //Dark2 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x08,}, //Dark2 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x08,}, //Dark2 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x1c,}, //Dark2 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x1c,}, //Dark2 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x1c,}, //Dark2 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x1a,}, //Dark2 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark2 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x16,}, //Dark2 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x14,}, //Dark2 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x12,}, //Dark2 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x22,}, //Dark2 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark2 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x04,}, //Dark2 11d1
{0xde, 0xd2,},
{0xdf, 0x1a,}, //Dark2 11d2
{0xe0, 0xd3,},
{0xe1, 0x23,}, //Dark2 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark2 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x16,}, //Dark2 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark2 11d6
{0xe8, 0xd7,},
{0xe9, 0x1c,}, //Dark2 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark2 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x08,}, //Dark2 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark2 11da
{0xf0, 0xdb,},
{0xf1, 0x0e,}, //Dark2 11db
{0xf2, 0xdf,},
{0xf3, 0x73,}, //Dark2 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x04,}, //Dark2 11e0
{0xf6, 0xe1,},
{0xf7, 0x1a,}, //Dark2 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark2 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xff,}, //Dark2 11e3
{0xfc, 0xe4,},
{0xfd, 0x00,}, //Dark2 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe8,}, //DMA E8 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x18,}, //Dark2 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark2 11e6
{0x14, 0xe7,},
{0x15, 0x28,}, //Dark2 11e7
{0x16, 0xe8,},
{0x17, 0x00,}, //Dark2 11e8
{0x18, 0xe9,},
{0x19, 0x09,}, //Dark2 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark2 11ea
{0x1c, 0xeb,},
{0x1d, 0x14,}, //Dark2 11eb
{0x1e, 0xef,},
{0x1f, 0x33,}, //Dark2 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,}, //12 Page
{0x22, 0x40,},
{0x23, 0x36,}, //Dark2 1240 add 720p
{0x24, 0x70,},
{0x25, 0x81,}, //Dark2 1270 // Bayer Sharpness ENB add 720p
{0x26, 0x71,},
{0x27, 0x07,}, //Dark2 1271 //Bayer HPF Gain
{0x28, 0x72,},
{0x29, 0x07,}, //Dark2 1272 //Bayer LPF Gain
{0x2a, 0x77,},
{0x2b, 0x00,}, //Dark2 1277
{0x2c, 0x78,},
{0x2d, 0x09,}, //Dark2 1278
{0x2e, 0x79,},
{0x2f, 0x2e,}, //Dark2 1279
{0x30, 0x7a,},
{0x31, 0x50,}, //Dark2 127a
{0x32, 0x7b,},
{0x33, 0x10,}, //Dark2 127b
{0x34, 0x7c,},
{0x35, 0x50,}, //Dark2 127c //skin HPF gain
{0x36, 0x7d,},
{0x37, 0x10,}, //Dark2 127d
{0x38, 0x7f,},
{0x39, 0x50,}, //Dark2 127f
{0x3a, 0x87,},
{0x3b, 0x08,}, //Dark2 1287 add 720p
{0x3c, 0x88,},
{0x3d, 0x08,}, //Dark2 1288 add 720p
{0x3e, 0x89,},
{0x3f, 0x08,}, //Dark2 1289 add 720p
{0x40, 0x8a,},
{0x41, 0x0c,}, //Dark2 128a add 720p
{0x42, 0x8b,},
{0x43, 0x10,}, //Dark2 128b add 720p
{0x44, 0x8c,},
{0x45, 0x14,}, //Dark2 128c add 720p
{0x46, 0x8d,},
{0x47, 0x18,}, //Dark2 128d add 720p
{0x48, 0x8e,},
{0x49, 0x1a,}, //Dark2 128e add 720p
{0x4a, 0x8f,},
{0x4b, 0x08,}, //Dark2 128f add 720p
{0x4c, 0x90,},
{0x4d, 0x0a,}, //Dark2 1290 add 720p
{0x4e, 0x91,},
{0x4f, 0x0e,}, //Dark2 1291 add 720p
{0x50, 0x92,},
{0x51, 0x12,}, //Dark2 1292 add 720p
{0x52, 0x93,},
{0x53, 0x16,}, //Dark2 1293 add 720p
{0x54, 0x94,},
{0x55, 0x1a,}, //Dark2 1294 add 720p
{0x56, 0x95,},
{0x57, 0x20,}, //Dark2 1295 add 720p
{0x58, 0x96,},
{0x59, 0x20,}, //Dark2 1296 add 720p
{0x5a, 0xae,},
{0x5b, 0x20,}, //Dark2 12ae
{0x5c, 0xaf,},
{0x5d, 0x33,}, //Dark2 12af // B[7:4]Blue/B[3:0]Skin
{0x5e, 0xc0,},
{0x5f, 0x23,}, //Dark2 12c0 // CI-LPF ENB add 720p
{0x60, 0xc3,},
{0x61, 0x18,}, //Dark2 12c3 add 720p
{0x62, 0xc4,},
{0x63, 0x0d,}, //Dark2 12c4 add 720p
{0x64, 0xc5,},
{0x65, 0x06,}, //Dark2 12c5 add 720p
{0x66, 0xc6,},
{0x67, 0x11,}, //Dark2 12c6
{0x68, 0xc7,},
{0x69, 0x11,}, //Dark2 12c7
{0x6a, 0xc8,},
{0x6b, 0x04,}, //Dark2 12c8
{0x6c, 0xd0,},
{0x6d, 0x02,}, //Dark2 12d0 add 720p
{0x6e, 0xd1,},
{0x6f, 0x04,}, //Dark2 12d1 add 720p
{0x70, 0xd2,},
{0x71, 0x07,}, //Dark2 12d2 add 720p
{0x72, 0xd3,},
{0x73, 0x0c,}, //Dark2 12d3 add 720p
{0x74, 0xd4,},
{0x75, 0x10,}, //Dark2 12d4 add 720p
{0x76, 0xd5,},
{0x77, 0x18,}, //Dark2 12d5 add 720p
{0x78, 0xd6,},
{0x79, 0x20,}, //Dark2 12d6 add 720p
{0x7a, 0xd7,},
{0x7b, 0x29,}, //Dark2 12d7 //CI LPF Lum offset start
{0x7c, 0xd8,},
{0x7d, 0x2a,}, //Dark2 12d8
{0x7e, 0xd9,},
{0x7f, 0x2c,}, //Dark2 12d9
{0x80, 0xda,},
{0x81, 0x2b,}, //Dark2 12da
{0x82, 0xdb,},
{0x83, 0x2a,}, //Dark2 12db
{0x84, 0xdc,},
{0x85, 0x28,}, //Dark2 12dc
{0x86, 0xdd,},
{0x87, 0x27,}, //Dark2 12dd
{0x88, 0xde,},
{0x89, 0x27,}, //Dark2 12de //CI LPF Lum offset end
{0x8a, 0xe0,},
{0x8b, 0x63,}, //Dark2 12e0 // 20121120 ln dy
{0x8c, 0xe1,},
{0x8d, 0xfc,}, //Dark2 12e1
{0x8e, 0xe2,},
{0x8f, 0x02,}, //Dark2 12e2
{0x90, 0xe3,},
{0x91, 0x10,}, //Dark2 12e3 //PS LN graph Y1
{0x92, 0xe4,},
{0x93, 0x12,}, //Dark2 12e4 //PS LN graph Y2
{0x94, 0xe5,},
{0x95, 0x1a,}, //Dark2 12e5 //PS LN graph Y3
{0x96, 0xe6,},
{0x97, 0x1d,}, //Dark2 12e6 //PS LN graph Y4
{0x98, 0xe7,},
{0x99, 0x1e,}, //Dark2 12e7 //PS LN graph Y5
{0x9a, 0xe8,},
{0x9b, 0x1f,}, //Dark2 12e8 //PS LN graph Y6
{0x9c, 0xe9,},
{0x9d, 0x10,}, //Dark2 12e9 //PS DY graph Y1
{0x9e, 0xea,},
{0x9f, 0x12,}, //Dark2 12ea //PS DY graph Y2
{0xa0, 0xeb,},
{0xa1, 0x18,}, //Dark2 12eb //PS DY graph Y3
{0xa2, 0xec,},
{0xa3, 0x1c,}, //Dark2 12ec //PS DY graph Y4
{0xa4, 0xed,},
{0xa5, 0x1e,}, //Dark2 12ed //PS DY graph Y5
{0xa6, 0xee,},
{0xa7, 0x1f,}, //Dark2 12ee //PS DY graph Y6
{0xa8, 0xf0,},
{0xa9, 0x00,}, //Dark2 12f0
{0xaa, 0xf1,},
{0xab, 0x2a,}, //Dark2 12f1
{0xac, 0xf2,},
{0xad, 0x32,}, //Dark2 12f2
{0xae, 0x03,},
{0xaf, 0x13,}, //13 Page
{0xb0, 0x10,},
{0xb1, 0x80,}, //Dark2 1310 //Y-NR ENB add 720p
{0xb2, 0x30,},
{0xb3, 0x20,}, //Dark2 1330
{0xb4, 0x31,},
{0xb5, 0x20,}, //Dark2 1331
{0xb6, 0x32,},
{0xb7, 0x20,}, //Dark2 1332
{0xb8, 0x33,},
{0xb9, 0x20,}, //Dark2 1333
{0xba, 0x34,},
{0xbb, 0x20,}, //Dark2 1334
{0xbc, 0x35,},
{0xbd, 0x2d,}, //Dark2 1335
{0xbe, 0x36,},
{0xbf, 0x20,}, //Dark2 1336
{0xc0, 0x37,},
{0xc1, 0x20,}, //Dark2 1337
{0xc2, 0x38,},
{0xc3, 0x02,}, //Dark2 1338
{0xc4, 0x40,},
{0xc5, 0x00,}, //Dark2 1340
{0xc6, 0x41,},
{0xc7, 0x13,}, //Dark2 1341
{0xc8, 0x42,},
{0xc9, 0x62,}, //Dark2 1342
{0xca, 0x43,},
{0xcb, 0x63,}, //Dark2 1343
{0xcc, 0x44,},
{0xcd, 0x7e,}, //Dark2 1344
{0xce, 0x45,},
{0xcf, 0x00,}, //Dark2 1345
{0xd0, 0x46,},
{0xd1, 0x6b,}, //Dark2 1346
{0xd2, 0x47,},
{0xd3, 0x00,}, //Dark2 1347
{0xd4, 0x48,},
{0xd5, 0x4a,}, //Dark2 1348
{0xd6, 0x49,},
{0xd7, 0x00,}, //Dark2 1349
{0xd8, 0x4a,},
{0xd9, 0x43,}, //Dark2 134a
{0xda, 0x4b,},
{0xdb, 0x00,}, //Dark2 134b
{0xdc, 0x4c,},
{0xdd, 0x2e,}, //Dark2 134c
{0xde, 0x83,},
{0xdf, 0x08,}, //Dark2 1383
{0xe0, 0x84,},
{0xe1, 0x0a,}, //Dark2 1384
{0xe2, 0xb7,},
{0xe3, 0xff,}, //Dark2 13b7
{0xe4, 0xb8,},
{0xe5, 0xff,}, //Dark2 13b8
{0xe6, 0xb9,},
{0xe7, 0xff,}, //Dark2 13b9 //20121217 DC R1,2 CR
{0xe8, 0xba,},
{0xe9, 0xff,}, //Dark2 13ba //20121217 DC R3,4 CR
{0xea, 0xbd,},
{0xeb, 0x78,}, //Dark2 13bd //20121121 c-filter LumHL DC rate
{0xec, 0xc5,},
{0xed, 0x01,}, //Dark2 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xee, 0xc6,},
{0xef, 0x22,}, //Dark2 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf0, 0xc7,},
{0xf1, 0x33,}, //Dark2 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf2, 0x03,},
{0xf3, 0x14,}, //14 page
{0xf4, 0x10,},
{0xf5, 0x01,}, //Dark2 1410
{0xf6, 0x11,},
{0xf7, 0xd8,}, //Dark2 1411
{0xf8, 0x12,},
{0xf9, 0x10,}, //Dark2 1412
{0xfa, 0x13,},
{0xfb, 0x05,}, //Dark2 1413
{0xfc, 0x14,},
{0xfd, 0x14,}, //Dark2 1414 //YC2D Low Gain B[5:0]
{0x0e, 0x00,}, // burst end

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x15,},
{0x11, 0x7d,}, //Dark2 1415 // Y Hi filter mask 1/16
{0x12, 0x16,},
{0x13, 0x17,}, //Dark2 1416 //YC2D Hi Gain B[5:0]
{0x14, 0x17,},
{0x15, 0x40,}, //Dark2 1417
{0x16, 0x18,},
{0x17, 0x0c,}, //Dark2 1418
{0x18, 0x19,},
{0x19, 0x0c,}, //Dark2 1419
{0x1a, 0x1a,},
{0x1b, 0x1c,}, //Dark2 141a //YC2D Post STD gain Pos
{0x1c, 0x1b,},
{0x1d, 0x1c,}, //Dark2 141b //YC2D Post STD gain Neg
{0x1e, 0x27,},
{0x1f, 0x0f,}, //Dark2 1427 //YC2D SP Lum Gain Pos1
{0x20, 0x28,},
{0x21, 0x10,}, //Dark2 1428 //YC2D SP Lum Gain Pos2
{0x22, 0x29,},
{0x23, 0x11,}, //Dark2 1429 //YC2D SP Lum Gain Pos3
{0x24, 0x2a,},
{0x25, 0x12,}, //Dark2 142a //YC2D SP Lum Gain Pos4
{0x26, 0x2b,},
{0x27, 0x13,}, //Dark2 142b //YC2D SP Lum Gain Pos5
{0x28, 0x2c,},
{0x29, 0x14,}, //Dark2 142c //YC2D SP Lum Gain Pos6
{0x2a, 0x2d,},
{0x2b, 0x13,}, //Dark2 142d //YC2D SP Lum Gain Pos7
{0x2c, 0x2e,},
{0x2d, 0x10,}, //Dark2 142e //YC2D SP Lum Gain Pos8
{0x2e, 0x30,},
{0x2f, 0x0f,}, //Dark2 1430 //YC2D SP Lum Gain Neg1
{0x30, 0x31,},
{0x31, 0x10,}, //Dark2 1431 //YC2D SP Lum Gain Neg2
{0x32, 0x32,},
{0x33, 0x11,}, //Dark2 1432 //YC2D SP Lum Gain Neg3
{0x34, 0x33,},
{0x35, 0x12,}, //Dark2 1433 //YC2D SP Lum Gain Neg4
{0x36, 0x34,},
{0x37, 0x13,}, //Dark2 1434 //YC2D SP Lum Gain Neg5
{0x38, 0x35,},
{0x39, 0x13,}, //Dark2 1435 //YC2D SP Lum Gain Neg6
{0x3a, 0x36,},
{0x3b, 0x12,}, //Dark2 1436 //YC2D SP Lum Gain Neg7
{0x3c, 0x37,},
{0x3d, 0x10,}, //Dark2 1437 //YC2D SP Lum Gain Neg8
{0x3e, 0x47,},
{0x3f, 0x1c,}, //Dark2 1447 //YC2D SP Dy Gain Pos1
{0x40, 0x48,},
{0x41, 0x1b,}, //Dark2 1448 //YC2D SP Dy Gain Pos2
{0x42, 0x49,},
{0x43, 0x1a,}, //Dark2 1449 //YC2D SP Dy Gain Pos3
{0x44, 0x4a,},
{0x45, 0x18,}, //Dark2 144a //YC2D SP Dy Gain Pos4
{0x46, 0x4b,},
{0x47, 0x16,}, //Dark2 144b //YC2D SP Dy Gain Pos5
{0x48, 0x4c,},
{0x49, 0x14,}, //Dark2 144c //YC2D SP Dy Gain Pos6
{0x4a, 0x4d,},
{0x4b, 0x12,}, //Dark2 144d //YC2D SP Dy Gain Pos7
{0x4c, 0x4e,},
{0x4d, 0x10,}, //Dark2 144e //YC2D SP Dy Gain Pos8
{0x4e, 0x50,},
{0x4f, 0x1a,}, //Dark2 1450 //YC2D SP Dy Gain Neg1
{0x50, 0x51,},
{0x51, 0x19,}, //Dark2 1451 //YC2D SP Dy Gain Neg2
{0x52, 0x52,},
{0x53, 0x18,}, //Dark2 1452 //YC2D SP Dy Gain Neg3
{0x54, 0x53,},
{0x55, 0x17,}, //Dark2 1453 //YC2D SP Dy Gain Neg4
{0x56, 0x54,},
{0x57, 0x16,}, //Dark2 1454 //YC2D SP Dy Gain Neg5
{0x58, 0x55,},
{0x59, 0x14,}, //Dark2 1455 //YC2D SP Dy Gain Neg6
{0x5a, 0x56,},
{0x5b, 0x12,}, //Dark2 1456 //YC2D SP Dy Gain Neg7
{0x5c, 0x57,},
{0x5d, 0x10,}, //Dark2 1457 //YC2D SP Dy Gain Neg8
{0x5e, 0x67,},
{0x5f, 0x10,}, //Dark2 1467 //YC2D SP Edge Gain1
{0x60, 0x68,},
{0x61, 0x23,}, //Dark2 1468 //YC2D SP Edge Gain2
{0x62, 0x69,},
{0x63, 0x26,}, //Dark2 1469 //YC2D SP Edge Gain3
{0x64, 0x6a,},
{0x65, 0x24,}, //Dark2 146a //YC2D SP Edge Gain4
{0x66, 0x6b,},
{0x67, 0x13,}, //Dark2 146b //YC2D SP Edge Gain5
{0x68, 0x6c,},
{0x69, 0x1a,}, //Dark2 146c //YC2D SP Edge Gain6
{0x6a, 0x6d,},
{0x6b, 0x12,}, //Dark2 146d //YC2D SP Edge Gain7
{0x6c, 0x6e,},
{0x6d, 0x12,}, //Dark2 146e //YC2D SP Edge Gain8
{0x6e, 0x87,},
{0x6f, 0x19,}, //Dark2 1487 //YC2D SP STD Gain1
{0x70, 0x88,},
{0x71, 0x1a,}, //Dark2 1488 //YC2D SP STD Gain2
{0x72, 0x89,},
{0x73, 0x1c,}, //Dark2 1489 //YC2D SP STD Gain3
{0x74, 0x8a,},
{0x75, 0x1b,}, //Dark2 148a //YC2D SP STD Gain4
{0x76, 0x8b,},
{0x77, 0x1a,}, //Dark2 148b //YC2D SP STD Gain5
{0x78, 0x8c,},
{0x79, 0x1c,}, //Dark2 148c //YC2D SP STD Gain6
{0x7a, 0x8d,},
{0x7b, 0x25,}, //Dark2 148d //YC2D SP STD Gain7
{0x7c, 0x8e,},
{0x7d, 0x29,}, //Dark2 148e //YC2D SP STD Gain8
{0x7e, 0x97,},
{0x7f, 0x08,}, //Dark2 1497 add 720p
{0x80, 0x98,},
{0x81, 0x0c,}, //Dark2 1498 add 720p
{0x82, 0x99,},
{0x83, 0x10,}, //Dark2 1499 add 720p
{0x84, 0x9a,},
{0x85, 0x10,}, //Dark2 149a add 720p
{0x86, 0x9b,},
{0x87, 0x10,}, //Dark2 149b add 720p
{0x88, 0xa0,},
{0x89, 0x08,}, //Dark2 14a0 add 720p
{0x8a, 0xa1,},
{0x8b, 0x10,}, //Dark2 14a1 add 720p
{0x8c, 0xa2,},
{0x8d, 0x14,}, //Dark2 14a2 add 720p
{0x8e, 0xa3,},
{0x8f, 0x1a,}, //Dark2 14a3 add 720p
{0x90, 0xa4,},
{0x91, 0x1a,}, //Dark2 14a4 add 720p
{0x92, 0xc9,},
{0x93, 0x13,}, //Dark2 14c9
{0x94, 0xca,},
{0x95, 0x20,}, //Dark2 14ca
{0x96, 0x03,},
{0x97, 0x1a,}, //1A page
{0x98, 0x10,},
{0x99, 0x14,}, //Dark2 1A10 add 720p
{0x9a, 0x18,},
{0x9b, 0x1f,}, //Dark2 1A18
{0x9c, 0x19,},
{0x9d, 0x15,}, //Dark2 1A19
{0x9e, 0x1a,},
{0x9f, 0x0a,}, //Dark2 1A1a
{0xa0, 0x1b,},
{0xa1, 0x07,}, //Dark2 1A1b
{0xa2, 0x1c,},
{0xa3, 0x03,}, //Dark2 1A1c
{0xa4, 0x1d,},
{0xa5, 0x03,}, //Dark2 1A1d
{0xa6, 0x1e,},
{0xa7, 0x03,}, //Dark2 1A1e
{0xa8, 0x1f,},
{0xa9, 0x03,}, //Dark2 1A1f
{0xaa, 0x20,},
{0xab, 0x07,}, //Dark2 1A20 add 720p
{0xac, 0x2f,},
{0xad, 0xf6,}, //Dark2 1A2f add 720p
{0xae, 0x32,},
{0xaf, 0x07,}, //Dark2 1A32 add 720p
{0xb0, 0x34,},
{0xb1, 0xdf,}, //Dark2 1A34 //RGB High Gain B[5:0]
{0xb2, 0x35,},
{0xb3, 0x1b,}, //Dark2 1A35 //RGB Low Gain B[5:0]
{0xb4, 0x36,},
{0xb5, 0xef,}, //Dark2 1A36
{0xb6, 0x37,},
{0xb7, 0x40,}, //Dark2 1A37
{0xb8, 0x38,},
{0xb9, 0xff,}, //Dark2 1A38
{0xba, 0x39,},
{0xbb, 0x2e,}, //Dark2 1A39 //RGB Flat R2_Lum L
{0xbc, 0x3a,},
{0xbd, 0x3f,}, //Dark2 1A3a
{0xbe, 0x3b,},
{0xbf, 0x01,}, //Dark2 1A3b
{0xc0, 0x3c,},
{0xc1, 0x0c,}, //Dark2 1A3c
{0xc2, 0x3d,},
{0xc3, 0x01,}, //Dark2 1A3d
{0xc4, 0x3e,},
{0xc5, 0x07,}, //Dark2 1A3e
{0xc6, 0x3f,},
{0xc7, 0x01,}, //Dark2 1A3f
{0xc8, 0x40,},
{0xc9, 0x0c,}, //Dark2 1A40
{0xca, 0x41,},
{0xcb, 0x01,}, //Dark2 1A41
{0xcc, 0x42,},
{0xcd, 0x07,}, //Dark2 1A42
{0xce, 0x43,},
{0xcf, 0x2b,}, //Dark2 1A43
{0xd0, 0x4d,},
{0xd1, 0x15,}, //Dark2 1A4d //RGB SP Lum Gain Neg1
{0xd2, 0x4e,},
{0xd3, 0x14,}, //Dark2 1A4e //RGB SP Lum Gain Neg2
{0xd4, 0x4f,},
{0xd5, 0x13,}, //Dark2 1A4f //RGB SP Lum Gain Neg3
{0xd6, 0x50,},
{0xd7, 0x12,}, //Dark2 1A50 //RGB SP Lum Gain Neg4
{0xd8, 0x51,},
{0xd9, 0x11,}, //Dark2 1A51 //RGB SP Lum Gain Neg5
{0xda, 0x52,},
{0xdb, 0x10,}, //Dark2 1A52 //RGB SP Lum Gain Neg6
{0xdc, 0x53,},
{0xdd, 0x0f,}, //Dark2 1A53 //RGB SP Lum Gain Neg7
{0xde, 0x54,},
{0xdf, 0x0e,}, //Dark2 1A54 //RGB SP Lum Gain Neg8
{0xe0, 0x55,},
{0xe1, 0x15,}, //Dark2 1A55 //RGB SP Lum Gain Pos1
{0xe2, 0x56,},
{0xe3, 0x14,}, //Dark2 1A56 //RGB SP Lum Gain Pos2
{0xe4, 0x57,},
{0xe5, 0x13,}, //Dark2 1A57 //RGB SP Lum Gain Pos3
{0xe6, 0x58,},
{0xe7, 0x12,}, //Dark2 1A58 //RGB SP Lum Gain Pos4
{0xe8, 0x59,},
{0xe9, 0x11,}, //Dark2 1A59 //RGB SP Lum Gain Pos5
{0xea, 0x5a,},
{0xeb, 0x10,}, //Dark2 1A5a //RGB SP Lum Gain Pos6
{0xec, 0x5b,},
{0xed, 0x0f,}, //Dark2 1A5b //RGB SP Lum Gain Pos7
{0xee, 0x5c,},
{0xef, 0x0e,}, //Dark2 1A5c //RGB SP Lum Gain Pos8
{0xf0, 0x65,},
{0xf1, 0x1e,}, //Dark2 1A65 //RGB SP Dy Gain Neg1
{0xf2, 0x66,},
{0xf3, 0x1d,}, //Dark2 1A66 //RGB SP Dy Gain Neg2
{0xf4, 0x67,},
{0xf5, 0x1c,}, //Dark2 1A67 //RGB SP Dy Gain Neg3
{0xf6, 0x68,},
{0xf7, 0x1a,}, //Dark2 1A68 //RGB SP Dy Gain Neg4
{0xf8, 0x69,},
{0xf9, 0x18,}, //Dark2 1A69 //RGB SP Dy Gain Neg5
{0xfa, 0x6a,},
{0xfb, 0x16,}, //Dark2 1A6a //RGB SP Dy Gain Neg6
{0xfc, 0x6b,},
{0xfd, 0x14,}, //Dark2 1A6b //RGB SP Dy Gain Neg7
{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E9 page.
{0xE2, 0x32,},
{0xE3, 0x6A,},

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x6c,},
{0x11, 0x12,}, //Dark2 1A6c //RGB SP Dy Gain Neg8
{0x12, 0x6d,},
{0x13, 0x1e,}, //Dark2 1A6d //RGB SP Dy Gain Pos1
{0x14, 0x6e,},
{0x15, 0x1d,}, //Dark2 1A6e //RGB SP Dy Gain Pos2
{0x16, 0x6f,},
{0x17, 0x1c,}, //Dark2 1A6f //RGB SP Dy Gain Pos3
{0x18, 0x70,},
{0x19, 0x1a,}, //Dark2 1A70 //RGB SP Dy Gain Pos4
{0x1a, 0x71,},
{0x1b, 0x18,}, //Dark2 1A71 //RGB SP Dy Gain Pos5
{0x1c, 0x72,},
{0x1d, 0x16,}, //Dark2 1A72 //RGB SP Dy Gain Pos6
{0x1e, 0x73,},
{0x1f, 0x14,}, //Dark2 1A73 //RGB SP Dy Gain Pos7
{0x20, 0x74,},
{0x21, 0x12,}, //Dark2 1A74 //RGB SP Dy Gain Pos8
{0x22, 0x7d,},
{0x23, 0x20,}, //Dark2 1A7d //RGB SP Edge Gain1
{0x24, 0x7e,},
{0x25, 0x1f,}, //Dark2 1A7e //RGB SP Edge Gain2
{0x26, 0x7f,},
{0x27, 0x1e,}, //Dark2 1A7f //RGB SP Edge Gain3
{0x28, 0x80,},
{0x29, 0x1c,}, //Dark2 1A80 //RGB SP Edge Gain4
{0x2a, 0x81,},
{0x2b, 0x1a,}, //Dark2 1A81 //RGB SP Edge Gain5
{0x2c, 0x82,},
{0x2d, 0x18,}, //Dark2 1A82 //RGB SP Edge Gain6
{0x2e, 0x83,},
{0x2f, 0x14,}, //Dark2 1A83 //RGB SP Edge Gain7
{0x30, 0x84,},
{0x31, 0x10,}, //Dark2 1A84 //RGB SP Edge Gain8
{0x32, 0x9e,},
{0x33, 0x22,}, //Dark2 1A9e //RGB SP STD Gain1
{0x34, 0x9f,},
{0x35, 0x20,}, //Dark2 1A9f //RGB SP STD Gain2
{0x36, 0xa0,},
{0x37, 0x1e,}, //Dark2 1Aa0 //RGB SP STD Gain3
{0x38, 0xa1,},
{0x39, 0x1c,}, //Dark2 1Aa1 //RGB SP STD Gain4
{0x3a, 0xa2,},
{0x3b, 0x1a,}, //Dark2 1Aa2 //RGB SP STD Gain5
{0x3c, 0xa3,},
{0x3d, 0x18,}, //Dark2 1Aa3 //RGB SP STD Gain6
{0x3e, 0xa4,},
{0x3f, 0x14,}, //Dark2 1Aa4 //RGB SP STD Gain7
{0x40, 0xa5,},
{0x41, 0x10,}, //Dark2 1Aa5 //RGB SP STD Gain8
{0x42, 0xa6,},
{0x43, 0xaa,}, //Dark2 1Aa6 //RGB Post STD Gain Pos/Neg
{0x44, 0xa7,},
{0x45, 0x04,}, //Dark2 1Aa7 add 720p
{0x46, 0xa8,},
{0x47, 0x06,}, //Dark2 1Aa8 add 720p
{0x48, 0xa9,},
{0x49, 0x08,}, //Dark2 1Aa9 add 720p
{0x4a, 0xaa,},
{0x4b, 0x09,}, //Dark2 1Aaa add 720p
{0x4c, 0xab,},
{0x4d, 0x0a,}, //Dark2 1Aab add 720p
{0x4e, 0xaf,},
{0x4f, 0x04,}, //Dark2 1Aaf add 720p
{0x50, 0xb0,},
{0x51, 0x06,}, //Dark2 1Ab0 add 720p
{0x52, 0xb1,},
{0x53, 0x08,}, //Dark2 1Ab1 add 720p
{0x54, 0xb2,},
{0x55, 0x0a,}, //Dark2 1Ab2 add 720p
{0x56, 0xb3,},
{0x57, 0x0c,}, //Dark2 1Ab3 add 720p
{0x58, 0xca,},
{0x59, 0x00,}, //Dark2 1Aca
{0x5a, 0xe3,},
{0x5b, 0x12,}, //Dark2 1Ae3 add 720p
{0x5c, 0xe4,},
{0x5d, 0x12,}, //Dark2 1Ae4 add 720p
{0x5e, 0x03,},
{0x5f, 0x10,}, //10 page
{0x60, 0x70,},
{0x61, 0x0c,}, //Dark2 1070 Trans Func.   130108 Dark2 transFuc Flat graph
{0x62, 0x71,},
{0x63, 0x06,}, //Dark2 1071
{0x64, 0x72,},
{0x65, 0xbe,}, //Dark2 1072
{0x66, 0x73,},
{0x67, 0x99,}, //Dark2 1073
{0x68, 0x74,},
{0x69, 0x00,}, //Dark2 1074
{0x6a, 0x75,},
{0x6b, 0x00,}, //Dark2 1075
{0x6c, 0x76,},
{0x6d, 0x20,}, //Dark2 1076
{0x6e, 0x77,},
{0x6f, 0x33,}, //Dark2 1077
{0x70, 0x78,},
{0x71, 0x33,}, //Dark2 1078
{0x72, 0x79,},
{0x73, 0x40,}, //Dark2 1079
{0x74, 0x7a,},
{0x75, 0x00,}, //Dark2 107a
{0x76, 0x7b,},
{0x77, 0x40,}, //Dark2 107b
{0x78, 0x7c,},
{0x79, 0x00,}, //Dark2 107c
{0x7a, 0x7d,},
{0x7b, 0x07,}, //Dark2 107d
{0x7c, 0x7e,},
{0x7d, 0x0f,}, //Dark2 107e
{0x7e, 0x7f,},
{0x7f, 0x1e,}, //Dark2 107f
{0x80, 0x03,},
{0x81, 0x02,}, // 2 page
{0x82, 0x23,},
{0x83, 0x10,}, //Dark2 0223 (for sun-spot) // normal 3c
{0x84, 0x03,},
{0x85, 0x03,}, // 3 page
{0x86, 0x1a,},
{0x87, 0x06,}, //Dark2 031a (for sun-spot)
{0x88, 0x1b,},
{0x89, 0x7c,}, //Dark2 031b (for sun-spot)
{0x8a, 0x1c,},
{0x8b, 0x00,}, //Dark2 031c (for sun-spot)
{0x8c, 0x1d,},
{0x8d, 0x50,}, //Dark2 031d (for sun-spot)
{0x8e, 0x03,},
{0x8f, 0x11,}, // 11 page
{0x90, 0xf0,},
{0x91, 0x05,}, //Dark2 11f0 (for af bug)
{0x92, 0x03,},
{0x93, 0x12,}, //12 page
{0x94, 0x11,},
{0x95, 0xa9,}, //Dark2 1211 (20130416 for defect)

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////
//  Scaler Off
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

//--------------------------------------------------------------------------//
// MIPI TX Setting  //PCLK 86MHz
//--------------------------------------------------------------------------//
{0x03, 0x05,},  // Page05
{0x1d, 0x0d,},  // tlpx_time_l_dn
{0x1e, 0x0c,},  // hs_zero_time
{0x1f, 0x0c,},  // hs_trail_time
{0x30, 0x0a,},  // l_pkt_wc_h  // Full = 1280 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
{0x32, 0x1c,},  // clk_zero_time
{0x33, 0x0e,},  // clk_post_time
{0x34, 0x05,},  // clk_prepare_time
{0x35, 0x08,},  // clk_trail_time
{0x36, 0x01,},  // clk_tlpx_time_dp
{0x37, 0x08,},  // clk_tlpx_time_dn

///////////////////////////////////////////////////////////////////////////////
// sleep off
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},	// Sleep Off

{0x03, 0xc0,},
{0x7F, 0x80,},	// DMA on
{0x7E, 0x01,},	// DMA set

{0xff, 0x01,},	//delay 10ms

///////////////////////////////////////////////////////////////////////////////
// end of HD set
///////////////////////////////////////////////////////////////////////////////
};

static struct sensor_reg sr352_recording_50Hz_HD_01[] = {

///////////////////////////////////////////////////////////////////////////////
// HD Initial Start
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x01, 0x01,},	// Sleep On

{0x03, 0x26,},
{0x10, 0x01,}, //mcu clock off
{0x08, 0x56,},	//mode_pll2  isp clk = 86Mhz;
{0x09, 0x81,}, //mode_pll3  // MIPI 4x div 1/1 // isp clk div = 1/4

///////////////////////////////////////////////////////////////////////////////
// 0 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x10, 0x00,},	// Full size
{0x11, 0x80,},	// Fixed mode off
{0x20, 0x00,},
{0x21, 0x00,},	// preview row start set
{0x22, 0x00,},
{0x23, 0x08,},	// preview col start set
{0x24, 0x02,},
{0x25, 0xd0,},	// height 720
{0x26, 0x05,},
{0x27, 0x00,},	// width 1280

///////////////////////////////////////////////////////////////////////////////
//ONE LINE SETTING
{0x03, 0x00,},
{0x4c, 0x07,},	// one_line = 1850
{0x4d, 0x3a,},

///////////////////////////////////////////////////////////////////////////////
{0x52, 0x00,},	// Vsync H
{0x53, 0x14,},	// Vsync L
///////////////////////////////////////////////////////////////////////////////

//Pixel windowing
{0x80, 0x01,},	// pixel_row_start for 720p crop mode
{0x81, 0x9e,},	// pwin_row_start = 414
{0x82, 0x02,},	// pwin_row_height = 738
{0x83, 0xe2,},
{0x84, 0x01,},	// pwin_col_start = 384
{0x85, 0x80,},
{0x86, 0x05,},	// pwin_col_width = 1312
{0x87, 0x20,},

///////////////////////////////////////////////////////////////////////////////
// 2 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x02,},
{0x1b, 0x80,},
{0x1d, 0x40,},
{0x23, 0x2a,},
{0x40, 0x08,},
{0x41, 0x8a,},	//20130213 Rev BC ver. ADC input range @ 800mv
{0x46, 0x0a,},	// + 3.3V, -0.9V
{0x47, 0x17,}, // 20121129 2.9V
{0x48, 0x1a,},
{0x49, 0x13,},
{0x54, 0xc0,},
{0x55, 0x40,},
{0x56, 0x33,},
{0xa0, 0x01,},
{0xa1, 0x7c,},
{0xa2, 0x03,},
{0xa3, 0x4d,},
{0xa4, 0x03,},
{0xa5, 0xb0,},
{0xa6, 0x06,},
{0xa7, 0xf2,},
{0xa8, 0x01,},
{0xa9, 0x4f,},
{0xaa, 0x02,},
{0xab, 0x23,},
{0xac, 0x02,},
{0xad, 0x74,},
{0xae, 0x04,},
{0xaf, 0x17,},

///////////////////////////////////////////////////////////////////////////////
// 3 Page
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x03,},
{0x1a, 0x06,}, // cds_s1
{0x1b, 0x7c,},
{0x1e, 0x06,},
{0x1f, 0x7c,},
{0x42, 0x00,},
{0x43, 0x46,},
{0x46, 0x00,},
{0x47, 0x74,},
{0x4a, 0x00,},
{0x4b, 0x44,},
{0x4e, 0x00,},
{0x4f, 0x44,},
{0x52, 0x00,},
{0x53, 0x20,},
{0x56, 0x00,},
{0x57, 0x20,},
{0x5a, 0x00,},
{0x5b, 0x20,},
{0x6a, 0x00,},
{0x6b, 0x6f,},
{0x72, 0x06,}, // s_addr_cut
{0x73, 0x40,},
{0x78, 0x06,}, // rx half_rst
{0x79, 0x3b,},
{0x7a, 0x06,},
{0x7b, 0x45,},
{0x7c, 0x06,},
{0x7d, 0x3b,},
{0x7e, 0x06,},
{0x7f, 0x45,},
{0x84, 0x06,}, // tx half_rst
{0x85, 0x3b,},
{0x86, 0x06,},
{0x87, 0x45,},
{0x88, 0x06,},
{0x89, 0x3b,},
{0x8a, 0x06,},
{0x8b, 0x45,},
{0x92, 0x06,}, // sx
{0x93, 0x31,},
{0x96, 0x06,},
{0x97, 0x31,},
{0x98, 0x06,}, // sxb
{0x99, 0x31,},
{0x9c, 0x06,},
{0x9d, 0x31,},

{0xb6, 0x00,},
{0xb7, 0xc8,},
{0xc0, 0x00,},
{0xc1, 0x48,},
{0xc2, 0x00,},
{0xc3, 0x6e,},
{0xc4, 0x00,},
{0xc5, 0x48,},
{0xc6, 0x00,},
{0xc7, 0x6e,},
{0xc8, 0x00,},
{0xc9, 0x4d,},
{0xca, 0x00,},
{0xcb, 0x6c,},
{0xcc, 0x00,},
{0xcd, 0x4d,},
{0xce, 0x00,},
{0xcf, 0x6c,},
{0xd0, 0x00,},
{0xd1, 0x4f,},
{0xd2, 0x00,},
{0xd3, 0x6a,},
{0xd4, 0x00,},
{0xd5, 0x4f,},
{0xd6, 0x00,},
{0xd7, 0x6a,},
{0xd8, 0x00,},
{0xd9, 0x50,},
{0xda, 0x00,},
{0xdb, 0x68,},
{0xdc, 0x00,},
{0xdd, 0x50,},
{0xde, 0x00,},
{0xdf, 0x68,},

{0xe0, 0x00,},
{0xe1, 0x20,},
{0xfc, 0x06,}, // clamp_sig
{0xfd, 0x38,},

{0x03, 0x26,},
{0x10, 0x09,}, //mcu clock enable

///////////////////////////////////////////////////////////////////////////////
// b Page
///////////////////////////////////////////////////////////////////////////////
{0x03, 0x0b,},
{0x10, 0x01,}, // otp_dpc_ctl
{0x11, 0x11,}, //HD 0415
{0x12, 0x00,}, //HD 0415

///////////////////////////////////////////////////////////////////////////////
// 15 Page (LSC)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x15,},	// Shading FPGA(Hi-352)
{0x10, 0x01,},	// LSC ON
{0x11, 0x06,}, //gap y enb, gap x enb for 720p

{0x27, 0x80,},	// LSC G
{0x28, 0x80,},	// LSC B
{0x29, 0x80,},	// LSC R

{0x30, 0x8a,}, //gap x for 720p
{0x31, 0x68,}, //gap y for 720p
{0x36, 0x6c,}, //lsc_win_x for 720p
{0x37, 0x64,}, //lsc_win_y for 720p

///////////////////////////////////
// 10 Page Saturation (H/W)
///////////////////////////////////
{0x03, 0x10,},
{0x12, 0x00,}, //Y OFS Disable
{0x20, 0x04,}, //16_235 range scale down on

///////////////////////////////////
// 11 Page D-LPF (H/W)
///////////////////////////////////
{0x03, 0x11,}, //11 page

{0xf2, 0xff,}, //pga_dark1_hi
{0xf3, 0xfc,}, //pga_dark_lo

///////////////////////////////////
// 13 Page YC-2D_Y-NR (H/W)/////////
///////////////////////////////////
{0x03, 0x13,},

//==========================================================================
// C-Filter PS Reducing (Mask-Size Adjustment)

{0x87, 0xff,}, //C-mask near STD TH
{0x88, 0xff,}, //C-mask middle STD TH
{0x89, 0xff,}, //C-mask far STD TH

///////////////////////////////////////////////////////////////////////////////
// 20 Page (FZY)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x20,}, //Page 20

{0x12, 0xe0,}, //Dgain off 20 //Dgain enb_2x e0

{0x36, 0x00,}, //EXP Unit
{0x37, 0x07,},
{0x38, 0x3a,},

{0x71, 0x70,}, //DG MAX //D gain 1x = 80 = x 1 // D gain 2x = 40 = x 1
{0x72, 0x40,}, //DG MIN

{0x80, 0x3a,}, //Y Target

///////////////////////////////////////////////////////////////////////////////
// 2A Page (SSD)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x2A,},
{0x15, 0x02,},	//720p mode on
{0x16, 0x50,},	//SSD B gain int gain 1.5x
{0x73, 0x0C,},	//start x in 720p
{0x74, 0x08,},	//start y in 720p
{0x75, 0x64,},	//width   in 720p
{0x76, 0x4A,},	//height  in 720p

///////////////////////////////////////////////////////////////////////////////
//
// F/W setting start
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// C0 Page (SYSTEM)
///////////////////////////////////////////////////////////////////////////////
//OPCLK Setting
//43Mhz = 29020C0
{0x03, 0xC0,},
{0x14, 0x02,},
{0x15, 0x90,},
{0x16, 0x20,},
{0x17, 0xC0,},

///////////////////////////////////////////////////////////////////////////////
// C7 Page (AE)
///////////////////////////////////////////////////////////////////////////////
//Shutter Setting
{0x03, 0xc7,},

{0x12, 0x03,}, // Slow AE
{0x15, 0xc0,}, // SSD Patch Weight Y Mean On

{0x36, 0x18,}, // Max 24fps
{0x37, 0x18,}, // Max 24fps

{0x11, 0x01,}, // B[1]Initial Speed Up, B[0]AE Reset

{0x4c, 0x00,}, //SW ExpMin = 3700
{0x4d, 0x00,},
{0x4e, 0x0e,},
{0x4f, 0x74,},

{0x03, 0x20,}, //20 page

{0x28, 0x00,}, //HW ExpMin = 3700
{0x29, 0x0e,},
{0x2a, 0x74,},

///////////////////////////////////////////////////////////////////////////////
// C8 ~ CC Page (AWB)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xc8,},
{0x17, 0x00,}, //AWB Speed
{0x18, 0x11,},
{0x21, 0x00,},
{0x22, 0x01,},
{0x11, 0xC3,},	//AWB reset
///////////////////////////////////////////////////////////////////////////////
// D3 ~ D8 Page (Adaptive)
///////////////////////////////////////////////////////////////////////////////

{0x03, 0xd3,},	// Adaptive start

{0x1d, 0x00,},	//EV Th OutEnd : 120fps AG 1x DG 1x
{0x1e, 0x00,},
{0x1f, 0x20,},
{0x20, 0x8d,},

{0x21, 0x00,},	//EV Th OutStr : 80fps  Ag 1x Dg 1x
{0x22, 0x00,},
{0x23, 0x30,},
{0x24, 0xd4,},

{0x25, 0x00,},	//EV Th Dark1Str
{0x26, 0x03,},
{0x27, 0x70,},
{0x28, 0xf0,},

{0x29, 0x00,},	//EV Th Dark1End
{0x2a, 0x05,},
{0x2b, 0x57,},
{0x2c, 0x30,},

{0x2d, 0x00,},	//EV Th Dark2Str
{0x2e, 0x06,},
{0x2f, 0x1a,},
{0x30, 0x80,},

{0x31, 0x00,},	//EV Th Dark2End
{0x32, 0x08,},
{0x33, 0x86,},
{0x34, 0xb6,},

{0x7d, 0x36,},	// Y_target_Outdoor
{0x7e, 0x3c,},	// Y_target_Indoor
{0x7f, 0x3c,},	// Y_target_Dark1
{0x80, 0x3c,},	// Y_target_Dark2
{0x81, 0x3c,},	// Y_target_LowTemp
{0x82, 0x3c,},	// Y_target_HighTemp

{0x83, 0x80,}, // Cb_Outdoor
{0x89, 0x80,},	// Cr _Sat_Outdoor

{0x97, 0x84,},	// BLC_ofs_r_Dark1
{0x98, 0x84,},	// BLC_ofs_b_Dark1
{0x99, 0x85,},	// BLC_ofs_gr_Dark1
{0x9a, 0x85,},	// BLC_ofs_gb_Dark1

{0x9b, 0x84,},	// BLC_ofs_r_Dark2
{0x9c, 0x84,},	// BLC_ofs_b_Dark2
{0x9d, 0x85,},	// BLC_ofs_gr_Dark2
{0x9e, 0x85,},	// BLC_ofs_gb_Dark2

////////////////////
// Adaptive Gamma //
////////////////////

{0x03, 0xd4,},
{0x0e, 0x01,}, // burst start
{0xe3, 0x00,},	//GMA_OUT
{0xe4, 0x00,},
{0xe5, 0x03,},
{0xe6, 0x0b,},
{0xe7, 0x15,},
{0xe8, 0x21,},
{0xe9, 0x2f,},
{0xea, 0x3c,},
{0xeb, 0x49,},
{0xec, 0x54,},
{0xed, 0x5e,},
{0xee, 0x68,},
{0xef, 0x72,},
{0xf0, 0x79,},
{0xf1, 0x7f,},
{0xf2, 0x84,},
{0xf3, 0x8a,},
{0xf4, 0x8e,},
{0xf5, 0x94,},
{0xf6, 0x98,},
{0xf7, 0x9d,},
{0xf8, 0xa7,},
{0xf9, 0xb2,},
{0xfa, 0xbb,},
{0xfb, 0xcb,},
{0xfc, 0xda,},
{0xfd, 0xe9,},
{0x0e, 0x00,}, // burst end

{0x03, 0xd5,},	//Page d5

{0x0e, 0x01,}, // burst start

{0x10, 0xf7,},
{0x11, 0xff,},
{0x12, 0xff,},
{0x13, 0xff,},
{0x14, 0xff,},
{0x15, 0xff,},
{0x16, 0xff,},

{0x17, 0x00,},	//GMA_IN
{0x18, 0x05,},
{0x19, 0x09,},
{0x1a, 0x11,},
{0x1b, 0x19,},
{0x1c, 0x26,},
{0x1d, 0x33,},
{0x1e, 0x3f,},
{0x1f, 0x4a,},
{0x20, 0x55,},
{0x21, 0x5e,},
{0x22, 0x67,},
{0x23, 0x6f,},
{0x24, 0x77,},
{0x25, 0x7e,},
{0x26, 0x84,},
{0x27, 0x8b,},
{0x28, 0x91,},
{0x29, 0x96,},
{0x2a, 0x9b,},
{0x2b, 0xa0,},
{0x2c, 0xa8,},
{0x2d, 0xb2,},
{0x2e, 0xbc,},
{0x2f, 0xcd,},
{0x30, 0xdd,},
{0x31, 0xec,},
{0x32, 0xf9,},
{0x33, 0xff,},
{0x34, 0xff,},
{0x35, 0xff,},
{0x36, 0xff,},
{0x37, 0xff,},
{0x38, 0xff,},

{0x39, 0x00,},	//GMA_D1
{0x3a, 0x04,},
{0x3b, 0x08,},
{0x3c, 0x0f,},
{0x3d, 0x1b,},
{0x3e, 0x2e,},
{0x3f, 0x3e,},
{0x40, 0x4e,},
{0x41, 0x5b,},
{0x42, 0x65,},
{0x43, 0x71,},
{0x44, 0x7b,},
{0x45, 0x85,},
{0x46, 0x8d,},
{0x47, 0x95,},
{0x48, 0x9b,},
{0x49, 0xa3,},
{0x4a, 0xa9,},
{0x4b, 0xb0,},
{0x4c, 0xb6,},
{0x4d, 0xbb,},
{0x4e, 0xc5,},
{0x4f, 0xcf,},
{0x50, 0xd7,},
{0x51, 0xe7,},
{0x52, 0xf3,},
{0x53, 0xfa,},
{0x54, 0xff,},
{0x55, 0xff,},
{0x56, 0xff,},
{0x57, 0xff,},
{0x58, 0xff,},
{0x59, 0xff,},
{0x5a, 0xff,},

{0x5b, 0x00,},	//GMA_D2
{0x5c, 0x04,},
{0x5d, 0x08,},
{0x5e, 0x0f,},
{0x5f, 0x1b,},
{0x60, 0x2e,},
{0x61, 0x3e,},
{0x62, 0x4e,},
{0x63, 0x5b,},
{0x64, 0x65,},
{0x65, 0x71,},
{0x66, 0x7b,},
{0x67, 0x85,},
{0x68, 0x8d,},
{0x69, 0x95,},
{0x6a, 0x9b,},
{0x6b, 0xa3,},
{0x6c, 0xa9,},
{0x6d, 0xb0,},
{0x6e, 0xb6,},
{0x6f, 0xbb,},
{0x70, 0xc5,},
{0x71, 0xcf,},
{0x72, 0xd7,},
{0x73, 0xe7,},
{0x74, 0xf3,},
{0x75, 0xfa,},
{0x76, 0xff,},
{0x77, 0xff,},
{0x78, 0xff,},
{0x79, 0xff,},
{0x7a, 0xff,},
{0x7b, 0xff,},
{0x7c, 0xff,},
{0x0e, 0x00,}, // burst end

{0x03, 0xD3,},
{0x11, 0xFE,},	// Adaptive LSC on
{0x10, 0x8d,},	// Adaptive on //B[1] EV with Y off for HD

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E0 page Original.
{0xd0, 0x26,},
{0xd1, 0x54,},

//DMA Outdoor
{0x03, 0xdf,}, //DMA DF Page
{0xb1, 0x83,}, //Outdoor 1310 //Y-NR ENB add  720p

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E0 page.
{0xD0, 0x27,},
{0xD1, 0x42,},

{0x03, 0xe0,}, //DMA E0 Page
{0x94, 0x11,},
{0x95, 0x29,}, //Outdoor 1211 (20130416 for defect)

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E3 page Origianl.
{0xd6, 0x2a,},
{0xd7, 0x0c,},

//DMA Indoor
{0x03, 0xe1,}, //DMA E1 Page
{0x13, 0x7f,}, //Indoor 1111 add 720p
{0x21, 0x01,}, //Indoor 1137 //Pre Flat rate
{0x23, 0x00,}, //Indoor 1138
{0x25, 0xff,}, //Indoor 1139
{0x2d, 0x20,}, //Indoor 113d
{0x35, 0x1e,}, //Indoor 1141
{0xd9, 0x65,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos
{0xf9, 0x00,}, //Indoor 11e2 //Bayer Flat R4 LumL
{0xfb, 0x00,}, //Indoor 11e3

{0x03, 0xe2,}, //DMA E2 Page
{0x11, 0x2a,}, //Indoor 11e5 //Bayer Flat R4 StdH
{0x15, 0x00,}, //Indoor 11e7
{0x1d, 0x00,}, //Indoor 11eb
{0x1f, 0xac,}, //Indoor 11ef //Bayer Flat R3/R4 rate
{0x5b, 0x5f,}, //Indoor 12ae //Bayer Flat off
{0xb1, 0x83,}, //Indoor 1310 //Y-NR ENB add 720p
{0xfd, 0x17,}, //Indoor 1414 //YC2D Low Gain B[5:0]

{0x03, 0xe3,}, //DMA E3 Page
{0x13, 0x17,}, //Indoor 1416 //YC2D Hi Gain B[5:0]
{0x1d, 0x20,}, //Indoor 141b //YC2D Post STD gain Neg
{0x6f, 0x1c,}, //Indoor 1487 //YC2D SP STD Gain1
{0x71, 0x20,}, //Indoor 1488 //YC2D SP STD Gain2
{0x77, 0x22,}, //Indoor 148b //YC2D SP STD Gain5
{0x79, 0x22,}, //Indoor 148c //YC2D SP STD Gain6
{0x7b, 0x1c,}, //Indoor 148d //YC2D SP STD Gain7
{0x7d, 0x18,}, //Indoor 148e //YC2D SP STD Gain8

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E3 page.
{0xD6, 0x2A,},
{0xD7, 0xFA,},

{0x03, 0xe3,}, //DMA E3 Page
{0x94, 0x11,},
{0x95, 0x29,}, //Indoor 1211 (20130416 for defect)

///////////////////////////////////////////////////////////////////////////////
// E4 ~ E6 Page (DMA Dark1)
///////////////////////////////////////////////////////////////////////////////

//I2CD set
{0x03, 0x26,}, //Xdata mapping for I2C direct E6 page Original.
{0xdc, 0x2d,},
{0xdd, 0xc4,},

{0x03, 0xe4,}, //DMA E4 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0xff,}, //Dark1 1111 add 720p
{0x14, 0x14,},
{0x15, 0x00,}, //Dark1 1114 add 720p
{0x16, 0x15,},
{0x17, 0x00,}, //Dark1 1115 add 720p
{0x18, 0x16,},
{0x19, 0x00,}, //Dark1 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x1e,}, //Dark1 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x10,}, //Dark1 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x06,}, //Dark1 1119 add 720p
{0x20, 0x37,},
{0x21, 0x01,}, //Dark1 1137 //Pre Flat rate B[4:1]
{0x22, 0x38,},
{0x23, 0x00,}, //Dark1 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0x03,}, //Dark1 1139 //Pre Flat R1 LumH
{0x26, 0x3a,},
{0x27, 0x03,}, //Dark1 113a
{0x28, 0x3b,},
{0x29, 0xff,}, //Dark1 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Dark1 113c
{0x2c, 0x3d,},
{0x2d, 0x13,}, //Dark1 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark1 113e
{0x30, 0x3f,},
{0x31, 0x10,}, //Dark1 113f
{0x32, 0x40,},
{0x33, 0x00,}, //Dark1 1140
{0x34, 0x41,},
{0x35, 0x10,}, //Dark1 1141
{0x36, 0x42,},
{0x37, 0x00,}, //Dark1 1142
{0x38, 0x43,},
{0x39, 0x18,}, //Dark1 1143
{0x3a, 0x49,},
{0x3b, 0x02,}, //Dark1 1149 add 720p
{0x3c, 0x4a,},
{0x3d, 0x04,}, //Dark1 114a add 720p
{0x3e, 0x4b,},
{0x3f, 0x07,}, //Dark1 114b add 720p
{0x40, 0x4c,},
{0x41, 0x0c,}, //Dark1 114c add 720p
{0x42, 0x4d,},
{0x43, 0x10,}, //Dark1 114d add 720p
{0x44, 0x4e,},
{0x45, 0x18,}, //Dark1 114e add 720p
{0x46, 0x4f,},
{0x47, 0x20,}, //Dark1 114f add 720p
{0x48, 0x50,},
{0x49, 0x1a,}, //Dark1 1150
{0x4a, 0x51,},
{0x4b, 0x1c,}, //Dark1 1151
{0x4c, 0x52,},
{0x4d, 0x1e,}, //Dark1 1152
{0x4e, 0x53,},
{0x4f, 0x24,}, //Dark1 1153
{0x50, 0x54,},
{0x51, 0x28,}, //Dark1 1154
{0x52, 0x55,},
{0x53, 0x26,}, //Dark1 1155
{0x54, 0x56,},
{0x55, 0x22,}, //Dark1 1156
{0x56, 0x57,},
{0x57, 0x1e,}, //Dark1 1157
{0x58, 0x58,},
{0x59, 0x3f,}, //Dark1 1158
{0x5a, 0x59,},
{0x5b, 0x3f,}, //Dark1 1159
{0x5c, 0x5a,},
{0x5d, 0x3f,}, //Dark1 115a
{0x5e, 0x5b,},
{0x5f, 0x3f,}, //Dark1 115b
{0x60, 0x5c,},
{0x61, 0x3f,}, //Dark1 115c
{0x62, 0x5d,},
{0x63, 0x3f,}, //Dark1 115d
{0x64, 0x5e,},
{0x65, 0x3f,}, //Dark1 115e
{0x66, 0x5f,},
{0x67, 0x3f,}, //Dark1 115f
{0x68, 0x6e,},
{0x69, 0x10,}, //Dark1 116e
{0x6a, 0x6f,},
{0x6b, 0x10,}, //Dark1 116f
{0x6c, 0x77,},
{0x6d, 0x20,}, //Dark1 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x1e,}, //Dark1 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x1c,}, //Dark1 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x18,}, //Dark1 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x14,}, //Dark1 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,}, //Dark1 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x08,}, //Dark1 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x08,}, //Dark1 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x1c,}, //Dark1 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x1c,}, //Dark1 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x1c,}, //Dark1 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x18,}, //Dark1 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x14,}, //Dark1 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x10,}, //Dark1 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x08,}, //Dark1 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x08,}, //Dark1 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x20,}, //Dark1 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x1e,}, //Dark1 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x1c,}, //Dark1 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x1a,}, //Dark1 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x16,}, //Dark1 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x14,}, //Dark1 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark1 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x10,}, //Dark1 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x1d,}, //Dark1 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x1d,}, //Dark1 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x1c,}, //Dark1 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x1a,}, //Dark1 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x16,}, //Dark1 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x14,}, //Dark1 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark1 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x10,}, //Dark1 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x18,}, //Dark1 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark1 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark1 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x15,}, //Dark1 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x12,}, //Dark1 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x10,}, //Dark1 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x10,}, //Dark1 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x10,}, //Dark1 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x18,}, //Dark1 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x10,}, //Dark1 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x08,}, //Dark1 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x08,}, //Dark1 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x08,}, //Dark1 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x08,}, //Dark1 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x1c,}, //Dark1 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x1c,}, //Dark1 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x1c,}, //Dark1 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x1a,}, //Dark1 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark1 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x16,}, //Dark1 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x14,}, //Dark1 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x12,}, //Dark1 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x22,}, //Dark1 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark1 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x04,}, //Dark1 11d1
{0xde, 0xd2,},
{0xdf, 0x1a,}, //Dark1 11d2
{0xe0, 0xd3,},
{0xe1, 0x23,}, //Dark1 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark1 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x16,}, //Dark1 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark1 11d6
{0xe8, 0xd7,},
{0xe9, 0x1c,}, //Dark1 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark1 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x08,}, //Dark1 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark1 11da
{0xf0, 0xdb,},
{0xf1, 0x0e,}, //Dark1 11db
{0xf2, 0xdf,},
{0xf3, 0x73,}, //Dark1 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x04,}, //Dark1 11e0
{0xf6, 0xe1,},
{0xf7, 0x1a,}, //Dark1 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark1 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xff,}, //Dark1 11e3
{0xfc, 0xe4,},
{0xfd, 0x00,}, //Dark1 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe5,}, //DMA E5 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x18,}, //Dark1 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark1 11e6
{0x14, 0xe7,},
{0x15, 0x28,}, //Dark1 11e7
{0x16, 0xe8,},
{0x17, 0x00,}, //Dark1 11e8
{0x18, 0xe9,},
{0x19, 0x09,}, //Dark1 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark1 11ea
{0x1c, 0xeb,},
{0x1d, 0x14,}, //Dark1 11eb
{0x1e, 0xef,},
{0x1f, 0x33,}, //Dark1 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,}, //12 Page
{0x22, 0x40,},
{0x23, 0x36,}, //Dark1 1240 add 720p
{0x24, 0x70,},
{0x25, 0x81,}, //Dark1 1270 // Bayer Sharpness ENB add 720p
{0x26, 0x71,},
{0x27, 0x07,}, //Dark1 1271 //Bayer HPF Gain
{0x28, 0x72,},
{0x29, 0x07,}, //Dark1 1272 //Bayer LPF Gain
{0x2a, 0x77,},
{0x2b, 0x00,}, //Dark1 1277
{0x2c, 0x78,},
{0x2d, 0x09,}, //Dark1 1278
{0x2e, 0x79,},
{0x2f, 0x2e,}, //Dark1 1279
{0x30, 0x7a,},
{0x31, 0x50,}, //Dark1 127a
{0x32, 0x7b,},
{0x33, 0x10,}, //Dark1 127b
{0x34, 0x7c,},
{0x35, 0x50,}, //Dark1 127c //skin HPF gain
{0x36, 0x7d,},
{0x37, 0x10,}, //Dark1 127d
{0x38, 0x7f,},
{0x39, 0x50,}, //Dark1 127f
{0x3a, 0x87,},
{0x3b, 0x08,}, //Dark1 1287 add 720p
{0x3c, 0x88,},
{0x3d, 0x08,}, //Dark1 1288 add 720p
{0x3e, 0x89,},
{0x3f, 0x08,}, //Dark1 1289 add 720p
{0x40, 0x8a,},
{0x41, 0x0c,}, //Dark1 128a add 720p
{0x42, 0x8b,},
{0x43, 0x10,}, //Dark1 128b add 720p
{0x44, 0x8c,},
{0x45, 0x14,}, //Dark1 128c add 720p
{0x46, 0x8d,},
{0x47, 0x18,}, //Dark1 128d add 720p
{0x48, 0x8e,},
{0x49, 0x1a,}, //Dark1 128e add 720p
{0x4a, 0x8f,},
{0x4b, 0x08,}, //Dark1 128f add 720p
{0x4c, 0x90,},
{0x4d, 0x0a,}, //Dark1 1290 add 720p
{0x4e, 0x91,},
{0x4f, 0x0e,}, //Dark1 1291 add 720p
{0x50, 0x92,},
{0x51, 0x12,}, //Dark1 1292 add 720p
{0x52, 0x93,},
{0x53, 0x16,}, //Dark1 1293 add 720p
{0x54, 0x94,},
{0x55, 0x1a,}, //Dark1 1294 add 720p
{0x56, 0x95,},
{0x57, 0x20,}, //Dark1 1295 add 720p
{0x58, 0x96,},
{0x59, 0x20,}, //Dark1 1296 add 720p
{0x5a, 0xae,},
{0x5b, 0x20,}, //Dark1 12ae
{0x5c, 0xaf,},
{0x5d, 0x33,}, //Dark1 12af // B[7:4]Blue/B[3:0]Skin
{0x5e, 0xc0,},
{0x5f, 0x23,}, //Dark1 12c0 // CI-LPF ENB add 720p
{0x60, 0xc3,},
{0x61, 0x18,}, //Dark1 12c3 add 720p
{0x62, 0xc4,},
{0x63, 0x0d,}, //Dark1 12c4 add 720p
{0x64, 0xc5,},
{0x65, 0x06,}, //Dark1 12c5 add 720p
{0x66, 0xc6,},
{0x67, 0x11,}, //Dark1 12c6
{0x68, 0xc7,},
{0x69, 0x11,}, //Dark1 12c7
{0x6a, 0xc8,},
{0x6b, 0x04,}, //Dark1 12c8
{0x6c, 0xd0,},
{0x6d, 0x02,}, //Dark1 12d0 add 720p
{0x6e, 0xd1,},
{0x6f, 0x04,}, //Dark1 12d1 add 720p
{0x70, 0xd2,},
{0x71, 0x07,}, //Dark1 12d2 add 720p
{0x72, 0xd3,},
{0x73, 0x0c,}, //Dark1 12d3 add 720p
{0x74, 0xd4,},
{0x75, 0x10,}, //Dark1 12d4 add 720p
{0x76, 0xd5,},
{0x77, 0x18,}, //Dark1 12d5 add 720p
{0x78, 0xd6,},
{0x79, 0x20,}, //Dark1 12d6 add 720p
{0x7a, 0xd7,},
{0x7b, 0x29,}, //Dark1 12d7 //CI LPF Lum offset start
{0x7c, 0xd8,},
{0x7d, 0x2a,}, //Dark1 12d8
{0x7e, 0xd9,},
{0x7f, 0x2c,}, //Dark1 12d9
{0x80, 0xda,},
{0x81, 0x2b,}, //Dark1 12da
{0x82, 0xdb,},
{0x83, 0x2a,}, //Dark1 12db
{0x84, 0xdc,},
{0x85, 0x28,}, //Dark1 12dc
{0x86, 0xdd,},
{0x87, 0x27,}, //Dark1 12dd
{0x88, 0xde,},
{0x89, 0x27,}, //Dark1 12de //CI LPF Lum offset end
{0x8a, 0xe0,},
{0x8b, 0x63,}, //Dark1 12e0 // 20121120 ln dy
{0x8c, 0xe1,},
{0x8d, 0xfc,}, //Dark1 12e1
{0x8e, 0xe2,},
{0x8f, 0x02,}, //Dark1 12e2
{0x90, 0xe3,},
{0x91, 0x10,}, //Dark1 12e3 //PS LN graph Y1
{0x92, 0xe4,},
{0x93, 0x12,}, //Dark1 12e4 //PS LN graph Y2
{0x94, 0xe5,},
{0x95, 0x1a,}, //Dark1 12e5 //PS LN graph Y3
{0x96, 0xe6,},
{0x97, 0x1d,}, //Dark1 12e6 //PS LN graph Y4
{0x98, 0xe7,},
{0x99, 0x1e,}, //Dark1 12e7 //PS LN graph Y5
{0x9a, 0xe8,},
{0x9b, 0x1f,}, //Dark1 12e8 //PS LN graph Y6
{0x9c, 0xe9,},
{0x9d, 0x10,}, //Dark1 12e9 //PS DY graph Y1
{0x9e, 0xea,},
{0x9f, 0x12,}, //Dark1 12ea //PS DY graph Y2
{0xa0, 0xeb,},
{0xa1, 0x18,}, //Dark1 12eb //PS DY graph Y3
{0xa2, 0xec,},
{0xa3, 0x1c,}, //Dark1 12ec //PS DY graph Y4
{0xa4, 0xed,},
{0xa5, 0x1e,}, //Dark1 12ed //PS DY graph Y5
{0xa6, 0xee,},
{0xa7, 0x1f,}, //Dark1 12ee //PS DY graph Y6
{0xa8, 0xf0,},
{0xa9, 0x00,}, //Dark1 12f0
{0xaa, 0xf1,},
{0xab, 0x2a,}, //Dark1 12f1
{0xac, 0xf2,},
{0xad, 0x32,}, //Dark1 12f2
{0xae, 0x03,},
{0xaf, 0x13,}, //13 Page
{0xb0, 0x10,},
{0xb1, 0x80,}, //Dark1 1310 //Y-NR ENB add 720p
{0xb2, 0x30,},
{0xb3, 0x20,}, //Dark1 1330
{0xb4, 0x31,},
{0xb5, 0x20,}, //Dark1 1331
{0xb6, 0x32,},
{0xb7, 0x20,}, //Dark1 1332
{0xb8, 0x33,},
{0xb9, 0x20,}, //Dark1 1333
{0xba, 0x34,},
{0xbb, 0x20,}, //Dark1 1334
{0xbc, 0x35,},
{0xbd, 0x2d,}, //Dark1 1335
{0xbe, 0x36,},
{0xbf, 0x20,}, //Dark1 1336
{0xc0, 0x37,},
{0xc1, 0x20,}, //Dark1 1337
{0xc2, 0x38,},
{0xc3, 0x02,}, //Dark1 1338
{0xc4, 0x40,},
{0xc5, 0x00,}, //Dark1 1340
{0xc6, 0x41,},
{0xc7, 0x13,}, //Dark1 1341
{0xc8, 0x42,},
{0xc9, 0x62,}, //Dark1 1342
{0xca, 0x43,},
{0xcb, 0x63,}, //Dark1 1343
{0xcc, 0x44,},
{0xcd, 0x7e,}, //Dark1 1344
{0xce, 0x45,},
{0xcf, 0x00,}, //Dark1 1345
{0xd0, 0x46,},
{0xd1, 0x6b,}, //Dark1 1346
{0xd2, 0x47,},
{0xd3, 0x00,}, //Dark1 1347
{0xd4, 0x48,},
{0xd5, 0x4a,}, //Dark1 1348
{0xd6, 0x49,},
{0xd7, 0x00,}, //Dark1 1349
{0xd8, 0x4a,},
{0xd9, 0x43,}, //Dark1 134a
{0xda, 0x4b,},
{0xdb, 0x00,}, //Dark1 134b
{0xdc, 0x4c,},
{0xdd, 0x2e,}, //Dark1 134c
{0xde, 0x83,},
{0xdf, 0x08,}, //Dark1 1383
{0xe0, 0x84,},
{0xe1, 0x0a,}, //Dark1 1384
{0xe2, 0xb7,},
{0xe3, 0xff,}, //Dark1 13b7
{0xe4, 0xb8,},
{0xe5, 0xff,}, //Dark1 13b8
{0xe6, 0xb9,},
{0xe7, 0xff,}, //Dark1 13b9 //20121217 DC R1,2 CR
{0xe8, 0xba,},
{0xe9, 0xff,}, //Dark1 13ba //20121217 DC R3,4 CR
{0xea, 0xbd,},
{0xeb, 0x78,}, //Dark1 13bd //20121121 c-filter LumHL DC rate
{0xec, 0xc5,},
{0xed, 0x01,}, //Dark1 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xee, 0xc6,},
{0xef, 0x22,}, //Dark1 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf0, 0xc7,},
{0xf1, 0x33,}, //Dark1 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf2, 0x03,},
{0xf3, 0x14,}, //14 page
{0xf4, 0x10,},
{0xf5, 0x01,}, //Dark1 1410
{0xf6, 0x11,},
{0xf7, 0xd8,}, //Dark1 1411
{0xf8, 0x12,},
{0xf9, 0x10,}, //Dark1 1412
{0xfa, 0x13,},
{0xfb, 0x05,}, //Dark1 1413
{0xfc, 0x14,},
{0xfd, 0x14,}, //Dark1 1414 //YC2D Low Gain B[5:0]
{0x0e, 0x00,}, // burst end

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x15,},
{0x11, 0x7d,}, //Dark1 1415 // Y Hi filter mask 1/16
{0x12, 0x16,},
{0x13, 0x17,}, //Dark1 1416 //YC2D Hi Gain B[5:0]
{0x14, 0x17,},
{0x15, 0x40,}, //Dark1 1417
{0x16, 0x18,},
{0x17, 0x0c,}, //Dark1 1418
{0x18, 0x19,},
{0x19, 0x0c,}, //Dark1 1419
{0x1a, 0x1a,},
{0x1b, 0x1c,}, //Dark1 141a //YC2D Post STD gain Pos
{0x1c, 0x1b,},
{0x1d, 0x1c,}, //Dark1 141b //YC2D Post STD gain Neg
{0x1e, 0x27,},
{0x1f, 0x0f,}, //Dark1 1427 //YC2D SP Lum Gain Pos1
{0x20, 0x28,},
{0x21, 0x10,}, //Dark1 1428 //YC2D SP Lum Gain Pos2
{0x22, 0x29,},
{0x23, 0x11,}, //Dark1 1429 //YC2D SP Lum Gain Pos3
{0x24, 0x2a,},
{0x25, 0x12,}, //Dark1 142a //YC2D SP Lum Gain Pos4
{0x26, 0x2b,},
{0x27, 0x13,}, //Dark1 142b //YC2D SP Lum Gain Pos5
{0x28, 0x2c,},
{0x29, 0x14,}, //Dark1 142c //YC2D SP Lum Gain Pos6
{0x2a, 0x2d,},
{0x2b, 0x13,}, //Dark1 142d //YC2D SP Lum Gain Pos7
{0x2c, 0x2e,},
{0x2d, 0x10,}, //Dark1 142e //YC2D SP Lum Gain Pos8
{0x2e, 0x30,},
{0x2f, 0x0f,}, //Dark1 1430 //YC2D SP Lum Gain Neg1
{0x30, 0x31,},
{0x31, 0x10,}, //Dark1 1431 //YC2D SP Lum Gain Neg2
{0x32, 0x32,},
{0x33, 0x11,}, //Dark1 1432 //YC2D SP Lum Gain Neg3
{0x34, 0x33,},
{0x35, 0x12,}, //Dark1 1433 //YC2D SP Lum Gain Neg4
{0x36, 0x34,},
{0x37, 0x13,}, //Dark1 1434 //YC2D SP Lum Gain Neg5
{0x38, 0x35,},
{0x39, 0x13,}, //Dark1 1435 //YC2D SP Lum Gain Neg6
{0x3a, 0x36,},
{0x3b, 0x12,}, //Dark1 1436 //YC2D SP Lum Gain Neg7
{0x3c, 0x37,},
{0x3d, 0x10,}, //Dark1 1437 //YC2D SP Lum Gain Neg8
{0x3e, 0x47,},
{0x3f, 0x1c,}, //Dark1 1447 //YC2D SP Dy Gain Pos1
{0x40, 0x48,},
{0x41, 0x1b,}, //Dark1 1448 //YC2D SP Dy Gain Pos2
{0x42, 0x49,},
{0x43, 0x1a,}, //Dark1 1449 //YC2D SP Dy Gain Pos3
{0x44, 0x4a,},
{0x45, 0x18,}, //Dark1 144a //YC2D SP Dy Gain Pos4
{0x46, 0x4b,},
{0x47, 0x16,}, //Dark1 144b //YC2D SP Dy Gain Pos5
{0x48, 0x4c,},
{0x49, 0x14,}, //Dark1 144c //YC2D SP Dy Gain Pos6
{0x4a, 0x4d,},
{0x4b, 0x12,}, //Dark1 144d //YC2D SP Dy Gain Pos7
{0x4c, 0x4e,},
{0x4d, 0x10,}, //Dark1 144e //YC2D SP Dy Gain Pos8
{0x4e, 0x50,},
{0x4f, 0x1a,}, //Dark1 1450 //YC2D SP Dy Gain Neg1
{0x50, 0x51,},
{0x51, 0x19,}, //Dark1 1451 //YC2D SP Dy Gain Neg2
{0x52, 0x52,},
{0x53, 0x18,}, //Dark1 1452 //YC2D SP Dy Gain Neg3
{0x54, 0x53,},
{0x55, 0x17,}, //Dark1 1453 //YC2D SP Dy Gain Neg4
{0x56, 0x54,},
{0x57, 0x16,}, //Dark1 1454 //YC2D SP Dy Gain Neg5
{0x58, 0x55,},
{0x59, 0x14,}, //Dark1 1455 //YC2D SP Dy Gain Neg6
{0x5a, 0x56,},
{0x5b, 0x12,}, //Dark1 1456 //YC2D SP Dy Gain Neg7
{0x5c, 0x57,},
{0x5d, 0x10,}, //Dark1 1457 //YC2D SP Dy Gain Neg8
{0x5e, 0x67,},
{0x5f, 0x10,}, //Dark1 1467 //YC2D SP Edge Gain1
{0x60, 0x68,},
{0x61, 0x13,}, //Dark1 1468 //YC2D SP Edge Gain2
{0x62, 0x69,},
{0x63, 0x13,}, //Dark1 1469 //YC2D SP Edge Gain3
{0x64, 0x6a,},
{0x65, 0x14,}, //Dark1 146a //YC2D SP Edge Gain4
{0x66, 0x6b,},
{0x67, 0x16,}, //Dark1 146b //YC2D SP Edge Gain5
{0x68, 0x6c,},
{0x69, 0x16,}, //Dark1 146c //YC2D SP Edge Gain6
{0x6a, 0x6d,},
{0x6b, 0x15,}, //Dark1 146d //YC2D SP Edge Gain7
{0x6c, 0x6e,},
{0x6d, 0x13,}, //Dark1 146e //YC2D SP Edge Gain8
{0x6e, 0x87,},
{0x6f, 0x19,}, //Dark1 1487 //YC2D SP STD Gain1
{0x70, 0x88,},
{0x71, 0x1a,}, //Dark1 1488 //YC2D SP STD Gain2
{0x72, 0x89,},
{0x73, 0x1c,}, //Dark1 1489 //YC2D SP STD Gain3
{0x74, 0x8a,},
{0x75, 0x1b,}, //Dark1 148a //YC2D SP STD Gain4
{0x76, 0x8b,},
{0x77, 0x1a,}, //Dark1 148b //YC2D SP STD Gain5
{0x78, 0x8c,},
{0x79, 0x1c,}, //Dark1 148c //YC2D SP STD Gain6
{0x7a, 0x8d,},
{0x7b, 0x25,}, //Dark1 148d //YC2D SP STD Gain7
{0x7c, 0x8e,},
{0x7d, 0x29,}, //Dark1 148e //YC2D SP STD Gain8
{0x7e, 0x97,},
{0x7f, 0x08,}, //Dark1 1497 add 720p
{0x80, 0x98,},
{0x81, 0x0c,}, //Dark1 1498 add 720p
{0x82, 0x99,},
{0x83, 0x10,}, //Dark1 1499 add 720p
{0x84, 0x9a,},
{0x85, 0x10,}, //Dark1 149a add 720p
{0x86, 0x9b,},
{0x87, 0x10,}, //Dark1 149b add 720p
{0x88, 0xa0,},
{0x89, 0x08,}, //Dark1 14a0 add 720p
{0x8a, 0xa1,},
{0x8b, 0x10,}, //Dark1 14a1 add 720p
{0x8c, 0xa2,},
{0x8d, 0x14,}, //Dark1 14a2 add 720p
{0x8e, 0xa3,},
{0x8f, 0x1a,}, //Dark1 14a3 add 720p
{0x90, 0xa4,},
{0x91, 0x1a,}, //Dark1 14a4 add 720p
{0x92, 0xc9,},
{0x93, 0x13,}, //Dark1 14c9
{0x94, 0xca,},
{0x95, 0x20,}, //Dark1 14ca
{0x96, 0x03,},
{0x97, 0x1a,}, //1A page
{0x98, 0x10,},
{0x99, 0x14,}, //Dark1 1A10 add 720p
{0x9a, 0x18,},
{0x9b, 0x1f,}, //Dark1 1A18
{0x9c, 0x19,},
{0x9d, 0x15,}, //Dark1 1A19
{0x9e, 0x1a,},
{0x9f, 0x0a,}, //Dark1 1A1a
{0xa0, 0x1b,},
{0xa1, 0x07,}, //Dark1 1A1b
{0xa2, 0x1c,},
{0xa3, 0x03,}, //Dark1 1A1c
{0xa4, 0x1d,},
{0xa5, 0x03,}, //Dark1 1A1d
{0xa6, 0x1e,},
{0xa7, 0x03,}, //Dark1 1A1e
{0xa8, 0x1f,},
{0xa9, 0x03,}, //Dark1 1A1f
{0xaa, 0x20,},
{0xab, 0x07,}, //Dark1 1A20 add 720p
{0xac, 0x2f,},
{0xad, 0xf6,}, //Dark1 1A2f add 720p
{0xae, 0x32,},
{0xaf, 0x07,}, //Dark1 1A32 add 720p
{0xb0, 0x34,},
{0xb1, 0xdf,}, //Dark1 1A34 //RGB High Gain B[5:0]
{0xb2, 0x35,},
{0xb3, 0x1b,}, //Dark1 1A35 //RGB Low Gain B[5:0]
{0xb4, 0x36,},
{0xb5, 0xef,}, //Dark1 1A36
{0xb6, 0x37,},
{0xb7, 0x40,}, //Dark1 1A37
{0xb8, 0x38,},
{0xb9, 0xff,}, //Dark1 1A38
{0xba, 0x39,},
{0xbb, 0x2e,}, //Dark1 1A39 //RGB Flat R2_Lum L
{0xbc, 0x3a,},
{0xbd, 0x3f,}, //Dark1 1A3a
{0xbe, 0x3b,},
{0xbf, 0x01,}, //Dark1 1A3b
{0xc0, 0x3c,},
{0xc1, 0x0c,}, //Dark1 1A3c
{0xc2, 0x3d,},
{0xc3, 0x01,}, //Dark1 1A3d
{0xc4, 0x3e,},
{0xc5, 0x07,}, //Dark1 1A3e
{0xc6, 0x3f,},
{0xc7, 0x01,}, //Dark1 1A3f
{0xc8, 0x40,},
{0xc9, 0x0c,}, //Dark1 1A40
{0xca, 0x41,},
{0xcb, 0x01,}, //Dark1 1A41
{0xcc, 0x42,},
{0xcd, 0x07,}, //Dark1 1A42
{0xce, 0x43,},
{0xcf, 0x2b,}, //Dark1 1A43
{0xd0, 0x4d,},
{0xd1, 0x15,}, //Dark1 1A4d //RGB SP Lum Gain Neg1
{0xd2, 0x4e,},
{0xd3, 0x14,}, //Dark1 1A4e //RGB SP Lum Gain Neg2
{0xd4, 0x4f,},
{0xd5, 0x13,}, //Dark1 1A4f //RGB SP Lum Gain Neg3
{0xd6, 0x50,},
{0xd7, 0x12,}, //Dark1 1A50 //RGB SP Lum Gain Neg4
{0xd8, 0x51,},
{0xd9, 0x11,}, //Dark1 1A51 //RGB SP Lum Gain Neg5
{0xda, 0x52,},
{0xdb, 0x10,}, //Dark1 1A52 //RGB SP Lum Gain Neg6
{0xdc, 0x53,},
{0xdd, 0x0f,}, //Dark1 1A53 //RGB SP Lum Gain Neg7
{0xde, 0x54,},
{0xdf, 0x0e,}, //Dark1 1A54 //RGB SP Lum Gain Neg8
{0xe0, 0x55,},
{0xe1, 0x15,}, //Dark1 1A55 //RGB SP Lum Gain Pos1
{0xe2, 0x56,},
{0xe3, 0x14,}, //Dark1 1A56 //RGB SP Lum Gain Pos2
{0xe4, 0x57,},
{0xe5, 0x13,}, //Dark1 1A57 //RGB SP Lum Gain Pos3
{0xe6, 0x58,},
{0xe7, 0x12,}, //Dark1 1A58 //RGB SP Lum Gain Pos4
{0xe8, 0x59,},
{0xe9, 0x11,}, //Dark1 1A59 //RGB SP Lum Gain Pos5
{0xea, 0x5a,},
{0xeb, 0x10,}, //Dark1 1A5a //RGB SP Lum Gain Pos6
{0xec, 0x5b,},
{0xed, 0x0f,}, //Dark1 1A5b //RGB SP Lum Gain Pos7
{0xee, 0x5c,},
{0xef, 0x0e,}, //Dark1 1A5c //RGB SP Lum Gain Pos8
{0xf0, 0x65,},
{0xf1, 0x1e,}, //Dark1 1A65 //RGB SP Dy Gain Neg1
{0xf2, 0x66,},
{0xf3, 0x1d,}, //Dark1 1A66 //RGB SP Dy Gain Neg2
{0xf4, 0x67,},
{0xf5, 0x1c,}, //Dark1 1A67 //RGB SP Dy Gain Neg3
{0xf6, 0x68,},
{0xf7, 0x1a,}, //Dark1 1A68 //RGB SP Dy Gain Neg4
{0xf8, 0x69,},
{0xf9, 0x18,}, //Dark1 1A69 //RGB SP Dy Gain Neg5
{0xfa, 0x6a,},
{0xfb, 0x16,}, //Dark1 1A6a //RGB SP Dy Gain Neg6
{0xfc, 0x6b,},
{0xfd, 0x14,}, //Dark1 1A6b //RGB SP Dy Gain Neg7
{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E6 page.
{0xDC, 0x2E,},
{0xDD, 0xB2,},

{0x03, 0xe6,}, //DMA E6 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x6c,},
{0x11, 0x12,}, //Dark1 1A6c //RGB SP Dy Gain Neg8
{0x12, 0x6d,},
{0x13, 0x1e,}, //Dark1 1A6d //RGB SP Dy Gain Pos1
{0x14, 0x6e,},
{0x15, 0x1d,}, //Dark1 1A6e //RGB SP Dy Gain Pos2
{0x16, 0x6f,},
{0x17, 0x1c,}, //Dark1 1A6f //RGB SP Dy Gain Pos3
{0x18, 0x70,},
{0x19, 0x1a,}, //Dark1 1A70 //RGB SP Dy Gain Pos4
{0x1a, 0x71,},
{0x1b, 0x18,}, //Dark1 1A71 //RGB SP Dy Gain Pos5
{0x1c, 0x72,},
{0x1d, 0x16,}, //Dark1 1A72 //RGB SP Dy Gain Pos6
{0x1e, 0x73,},
{0x1f, 0x14,}, //Dark1 1A73 //RGB SP Dy Gain Pos7
{0x20, 0x74,},
{0x21, 0x12,}, //Dark1 1A74 //RGB SP Dy Gain Pos8
{0x22, 0x7d,},
{0x23, 0x20,}, //Dark1 1A7d //RGB SP Edge Gain1
{0x24, 0x7e,},
{0x25, 0x1f,}, //Dark1 1A7e //RGB SP Edge Gain2
{0x26, 0x7f,},
{0x27, 0x1e,}, //Dark1 1A7f //RGB SP Edge Gain3
{0x28, 0x80,},
{0x29, 0x1c,}, //Dark1 1A80 //RGB SP Edge Gain4
{0x2a, 0x81,},
{0x2b, 0x1a,}, //Dark1 1A81 //RGB SP Edge Gain5
{0x2c, 0x82,},
{0x2d, 0x18,}, //Dark1 1A82 //RGB SP Edge Gain6
{0x2e, 0x83,},
{0x2f, 0x14,}, //Dark1 1A83 //RGB SP Edge Gain7
{0x30, 0x84,},
{0x31, 0x10,}, //Dark1 1A84 //RGB SP Edge Gain8
{0x32, 0x9e,},
{0x33, 0x22,}, //Dark1 1A9e //RGB SP STD Gain1
{0x34, 0x9f,},
{0x35, 0x20,}, //Dark1 1A9f //RGB SP STD Gain2
{0x36, 0xa0,},
{0x37, 0x1e,}, //Dark1 1Aa0 //RGB SP STD Gain3
{0x38, 0xa1,},
{0x39, 0x1c,}, //Dark1 1Aa1 //RGB SP STD Gain4
{0x3a, 0xa2,},
{0x3b, 0x1a,}, //Dark1 1Aa2 //RGB SP STD Gain5
{0x3c, 0xa3,},
{0x3d, 0x18,}, //Dark1 1Aa3 //RGB SP STD Gain6
{0x3e, 0xa4,},
{0x3f, 0x14,}, //Dark1 1Aa4 //RGB SP STD Gain7
{0x40, 0xa5,},
{0x41, 0x10,}, //Dark1 1Aa5 //RGB SP STD Gain8
{0x42, 0xa6,},
{0x43, 0xaa,}, //Dark1 1Aa6 //RGB Post STD Gain Pos/Neg
{0x44, 0xa7,},
{0x45, 0x04,}, //Dark1 1Aa7 add 720p
{0x46, 0xa8,},
{0x47, 0x06,}, //Dark1 1Aa8 add 720p
{0x48, 0xa9,},
{0x49, 0x08,}, //Dark1 1Aa9 add 720p
{0x4a, 0xaa,},
{0x4b, 0x09,}, //Dark1 1Aaa add 720p
{0x4c, 0xab,},
{0x4d, 0x0a,}, //Dark1 1Aab add 720p
{0x4e, 0xaf,},
{0x4f, 0x04,}, //Dark1 1Aaf add 720p
{0x50, 0xb0,},
{0x51, 0x06,}, //Dark1 1Ab0 add 720p
{0x52, 0xb1,},
{0x53, 0x08,}, //Dark1 1Ab1 add 720p
{0x54, 0xb2,},
{0x55, 0x0a,}, //Dark1 1Ab2 add 720p
{0x56, 0xb3,},
{0x57, 0x0c,}, //Dark1 1Ab3 add 720p
{0x58, 0xca,},
{0x59, 0x00,}, //Dark1 1Aca
{0x5a, 0xe3,},
{0x5b, 0x12,}, //Dark1 1Ae3 add 720p
{0x5c, 0xe4,},
{0x5d, 0x12,}, //Dark1 1Ae4 add 720p
{0x5e, 0x03,},
{0x5f, 0x10,}, //10 page
{0x60, 0x70,},
{0x61, 0x0c,}, //Dark1 1070 Trans Func.   130108 Dark1 transFuc Flat graph
{0x62, 0x71,},
{0x63, 0x06,}, //Dark1 1071
{0x64, 0x72,},
{0x65, 0xbe,}, //Dark1 1072
{0x66, 0x73,},
{0x67, 0x99,}, //Dark1 1073
{0x68, 0x74,},
{0x69, 0x00,}, //Dark1 1074
{0x6a, 0x75,},
{0x6b, 0x00,}, //Dark1 1075
{0x6c, 0x76,},
{0x6d, 0x20,}, //Dark1 1076
{0x6e, 0x77,},
{0x6f, 0x33,}, //Dark1 1077
{0x70, 0x78,},
{0x71, 0x33,}, //Dark1 1078
{0x72, 0x79,},
{0x73, 0x40,}, //Dark1 1079
{0x74, 0x7a,},
{0x75, 0x00,}, //Dark1 107a
{0x76, 0x7b,},
{0x77, 0x40,}, //Dark1 107b
{0x78, 0x7c,},
{0x79, 0x00,}, //Dark1 107c
{0x7a, 0x7d,},
{0x7b, 0x07,}, //Dark1 107d
{0x7c, 0x7e,},
{0x7d, 0x0f,}, //Dark1 107e
{0x7e, 0x7f,},
{0x7f, 0x1e,}, //Dark1 107f
{0x80, 0x03,},
{0x81, 0x02,}, // 2 page
{0x82, 0x23,},
{0x83, 0x10,}, //Dark1 0223 (for sun-spot) // normal 3c
{0x84, 0x03,},
{0x85, 0x03,}, // 3 page
{0x86, 0x1a,},
{0x87, 0x06,}, //Dark1 031a (for sun-spot)
{0x88, 0x1b,},
{0x89, 0x7c,}, //Dark1 031b (for sun-spot)
{0x8a, 0x1c,},
{0x8b, 0x00,}, //Dark1 031c (for sun-spot)
{0x8c, 0x1d,},
{0x8d, 0x50,}, //Dark1 031d (for sun-spot)
{0x8e, 0x03,},
{0x8f, 0x11,}, // 11 page
{0x90, 0xf0,},
{0x91, 0x04,}, //Dark1 11f0 (for af bug)
{0x92, 0x03,},
{0x93, 0x12,}, //12 page
{0x94, 0x11,},
{0x95, 0xa9,}, //Dark1 1211 (20130416 for defect)

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////////////////////////////////////////
// E7 ~ E9 Page (DMA Dark2)
///////////////////////////////////////////////////////////////////////////////

//I2CD set
{0x03, 0x26,},//Xdata mapping for I2C direct E9 page Original.
{0xe2, 0x31,},
{0xe3, 0x7c,},

{0x03, 0xe7,}, //DMA E7 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x03,},
{0x11, 0x11,}, //11 page
{0x12, 0x11,},
{0x13, 0xff,}, //Dark2 1111 add 720p
{0x14, 0x14,},
{0x15, 0x00,}, //Dark2 1114 add 720p
{0x16, 0x15,},
{0x17, 0x00,}, //Dark2 1115 add 720p
{0x18, 0x16,},
{0x19, 0x00,}, //Dark2 1116 add 720p
{0x1a, 0x17,},
{0x1b, 0x1e,}, //Dark2 1117 add 720p
{0x1c, 0x18,},
{0x1d, 0x10,}, //Dark2 1118 add 720p
{0x1e, 0x19,},
{0x1f, 0x06,}, //Dark2 1119 add 720p
{0x20, 0x37,},
{0x21, 0x01,}, //Dark2 1137 //Pre Flat rate B[4:1] //04
{0x22, 0x38,},
{0x23, 0x00,}, //Dark2 1138 //Pre Flat R1 LumL
{0x24, 0x39,},
{0x25, 0x03,}, //Dark2 1139
{0x26, 0x3a,},
{0x27, 0x03,}, //Dark2 113a
{0x28, 0x3b,},
{0x29, 0xff,}, //Dark2 113b
{0x2a, 0x3c,},
{0x2b, 0x00,}, //Dark2 113c
{0x2c, 0x3d,},
{0x2d, 0x13,}, //Dark2 113d
{0x2e, 0x3e,},
{0x2f, 0x00,}, //Dark2 113e
{0x30, 0x3f,},
{0x31, 0x10,}, //Dark2 113f
{0x32, 0x40,},
{0x33, 0x00,}, //Dark2 1140
{0x34, 0x41,},
{0x35, 0x10,}, //Dark2 1141
{0x36, 0x42,},
{0x37, 0x00,}, //Dark2 1142
{0x38, 0x43,},
{0x39, 0x18,}, //Dark2 1143
{0x3a, 0x49,},
{0x3b, 0x02,}, //Dark2 1149
{0x3c, 0x4a,},
{0x3d, 0x04,}, //Dark2 114a
{0x3e, 0x4b,},
{0x3f, 0x07,}, //Dark2 114b
{0x40, 0x4c,},
{0x41, 0x0c,}, //Dark2 114c
{0x42, 0x4d,},
{0x43, 0x10,}, //Dark2 114d
{0x44, 0x4e,},
{0x45, 0x18,}, //Dark2 114e
{0x46, 0x4f,},
{0x47, 0x20,}, //Dark2 114f
{0x48, 0x50,},
{0x49, 0x1a,}, //Dark2 1150
{0x4a, 0x51,},
{0x4b, 0x1c,}, //Dark2 1151
{0x4c, 0x52,},
{0x4d, 0x1e,}, //Dark2 1152
{0x4e, 0x53,},
{0x4f, 0x24,}, //Dark2 1153
{0x50, 0x54,},
{0x51, 0x28,}, //Dark2 1154
{0x52, 0x55,},
{0x53, 0x26,}, //Dark2 1155
{0x54, 0x56,},
{0x55, 0x22,}, //Dark2 1156
{0x56, 0x57,},
{0x57, 0x1e,}, //Dark2 1157
{0x58, 0x58,},
{0x59, 0x3f,}, //Dark2 1158
{0x5a, 0x59,},
{0x5b, 0x3f,}, //Dark2 1159
{0x5c, 0x5a,},
{0x5d, 0x3f,}, //Dark2 115a
{0x5e, 0x5b,},
{0x5f, 0x3f,}, //Dark2 115b
{0x60, 0x5c,},
{0x61, 0x3f,}, //Dark2 115c
{0x62, 0x5d,},
{0x63, 0x3f,}, //Dark2 115d
{0x64, 0x5e,},
{0x65, 0x3f,}, //Dark2 115e
{0x66, 0x5f,},
{0x67, 0x3f,}, //Dark2 115f
{0x68, 0x6e,},
{0x69, 0x10,}, //Dark2 116e
{0x6a, 0x6f,},
{0x6b, 0x10,}, //Dark2 116f
{0x6c, 0x77,},
{0x6d, 0x20,}, //Dark2 1177 //Bayer SP Lum Pos1
{0x6e, 0x78,},
{0x6f, 0x1e,}, //Dark2 1178 //Bayer SP Lum Pos2
{0x70, 0x79,},
{0x71, 0x1c,}, //Dark2 1179 //Bayer SP Lum Pos3
{0x72, 0x7a,},
{0x73, 0x18,}, //Dark2 117a //Bayer SP Lum Pos4
{0x74, 0x7b,},
{0x75, 0x14,}, //Dark2 117b //Bayer SP Lum Pos5
{0x76, 0x7c,},
{0x77, 0x10,}, //Dark2 117c //Bayer SP Lum Pos6
{0x78, 0x7d,},
{0x79, 0x08,}, //Dark2 117d //Bayer SP Lum Pos7
{0x7a, 0x7e,},
{0x7b, 0x08,}, //Dark2 117e //Bayer SP Lum Pos8
{0x7c, 0x7f,},
{0x7d, 0x1c,}, //Dark2 117f //Bayer SP Lum Neg1
{0x7e, 0x80,},
{0x7f, 0x1c,}, //Dark2 1180 //Bayer SP Lum Neg2
{0x80, 0x81,},
{0x81, 0x1c,}, //Dark2 1181 //Bayer SP Lum Neg3
{0x82, 0x82,},
{0x83, 0x18,}, //Dark2 1182 //Bayer SP Lum Neg4
{0x84, 0x83,},
{0x85, 0x14,}, //Dark2 1183 //Bayer SP Lum Neg5
{0x86, 0x84,},
{0x87, 0x10,}, //Dark2 1184 //Bayer SP Lum Neg6
{0x88, 0x85,},
{0x89, 0x08,}, //Dark2 1185 //Bayer SP Lum Neg7
{0x8a, 0x86,},
{0x8b, 0x08,}, //Dark2 1186 //Bayer SP Lum Neg8
{0x8c, 0x8f,},
{0x8d, 0x20,}, //Dark2 118f //Bayer SP Dy Pos1
{0x8e, 0x90,},
{0x8f, 0x1e,}, //Dark2 1190 //Bayer SP Dy Pos2
{0x90, 0x91,},
{0x91, 0x1c,}, //Dark2 1191 //Bayer SP Dy Pos3
{0x92, 0x92,},
{0x93, 0x1a,}, //Dark2 1192 //Bayer SP Dy Pos4
{0x94, 0x93,},
{0x95, 0x16,}, //Dark2 1193 //Bayer SP Dy Pos5
{0x96, 0x94,},
{0x97, 0x14,}, //Dark2 1194 //Bayer SP Dy Pos6
{0x98, 0x95,},
{0x99, 0x12,}, //Dark2 1195 //Bayer SP Dy Pos7
{0x9a, 0x96,},
{0x9b, 0x10,}, //Dark2 1196 //Bayer SP Dy Pos8
{0x9c, 0x97,},
{0x9d, 0x1d,}, //Dark2 1197 //Bayer SP Dy Neg1
{0x9e, 0x98,},
{0x9f, 0x1d,}, //Dark2 1198 //Bayer SP Dy Neg2
{0xa0, 0x99,},
{0xa1, 0x1c,}, //Dark2 1199 //Bayer SP Dy Neg3
{0xa2, 0x9a,},
{0xa3, 0x1a,}, //Dark2 119a //Bayer SP Dy Neg4
{0xa4, 0x9b,},
{0xa5, 0x16,}, //Dark2 119b //Bayer SP Dy Neg5
{0xa6, 0x9c,},
{0xa7, 0x14,}, //Dark2 119c //Bayer SP Dy Neg6
{0xa8, 0x9d,},
{0xa9, 0x12,}, //Dark2 119d //Bayer SP Dy Neg7
{0xaa, 0x9e,},
{0xab, 0x10,}, //Dark2 119e //Bayer SP Dy Neg8
{0xac, 0xa7,},
{0xad, 0x18,}, //Dark2 11a7 //Bayer SP Edge1
{0xae, 0xa8,},
{0xaf, 0x18,}, //Dark2 11a8 //Bayer SP Edge2
{0xb0, 0xa9,},
{0xb1, 0x18,}, //Dark2 11a9 //Bayer SP Edge3
{0xb2, 0xaa,},
{0xb3, 0x15,}, //Dark2 11aa //Bayer SP Edge4
{0xb4, 0xab,},
{0xb5, 0x12,}, //Dark2 11ab //Bayer SP Edge5
{0xb6, 0xac,},
{0xb7, 0x10,}, //Dark2 11ac //Bayer SP Edge6
{0xb8, 0xad,},
{0xb9, 0x10,}, //Dark2 11ad //Bayer SP Edge7
{0xba, 0xae,},
{0xbb, 0x10,}, //Dark2 11ae //Bayer SP Edge8
{0xbc, 0xb7,},
{0xbd, 0x18,}, //Dark2 11b7 add 720p
{0xbe, 0xb8,},
{0xbf, 0x10,}, //Dark2 11b8 add 720p
{0xc0, 0xb9,},
{0xc1, 0x08,}, //Dark2 11b9 add 720p
{0xc2, 0xba,},
{0xc3, 0x08,}, //Dark2 11ba add 720p
{0xc4, 0xbb,},
{0xc5, 0x08,}, //Dark2 11bb add 720p
{0xc6, 0xbc,},
{0xc7, 0x08,}, //Dark2 11bc add 720p
{0xc8, 0xc7,},
{0xc9, 0x1c,}, //Dark2 11c7 //Bayer SP STD1
{0xca, 0xc8,},
{0xcb, 0x1c,}, //Dark2 11c8 //Bayer SP STD2
{0xcc, 0xc9,},
{0xcd, 0x1c,}, //Dark2 11c9 //Bayer SP STD3
{0xce, 0xca,},
{0xcf, 0x1a,}, //Dark2 11ca //Bayer SP STD4
{0xd0, 0xcb,},
{0xd1, 0x18,}, //Dark2 11cb //Bayer SP STD5
{0xd2, 0xcc,},
{0xd3, 0x16,}, //Dark2 11cc //Bayer SP STD6
{0xd4, 0xcd,},
{0xd5, 0x14,}, //Dark2 11cd //Bayer SP STD7
{0xd6, 0xce,},
{0xd7, 0x12,}, //Dark2 11ce //Bayer SP STD8
{0xd8, 0xcf,},
{0xd9, 0x22,}, //Dark2 11cf //Bayer Post STD gain Neg/Pos
{0xda, 0xd0,},
{0xdb, 0x00,}, //Dark2 11d0 //Bayer Flat R1 Lum L
{0xdc, 0xd1,},
{0xdd, 0x04,}, //Dark2 11d1
{0xde, 0xd2,},
{0xdf, 0x1a,}, //Dark2 11d2
{0xe0, 0xd3,},
{0xe1, 0x23,}, //Dark2 11d3
{0xe2, 0xd4,},
{0xe3, 0x00,}, //Dark2 11d4 //Bayer Flat R1 STD L
{0xe4, 0xd5,},
{0xe5, 0x16,}, //Dark2 11d5 //Bayer Flat R1 STD H
{0xe6, 0xd6,},
{0xe7, 0x00,}, //Dark2 11d6
{0xe8, 0xd7,},
{0xe9, 0x1c,}, //Dark2 11d7
{0xea, 0xd8,},
{0xeb, 0x00,}, //Dark2 11d8 //Bayer Flat R1 DY L
{0xec, 0xd9,},
{0xed, 0x08,}, //Dark2 11d9 //Bayer Flat R1 DY H
{0xee, 0xda,},
{0xef, 0x00,}, //Dark2 11da
{0xf0, 0xdb,},
{0xf1, 0x0e,}, //Dark2 11db
{0xf2, 0xdf,},
{0xf3, 0x73,}, //Dark2 11df //Bayer Flat R1/R2 rate
{0xf4, 0xe0,},
{0xf5, 0x04,}, //Dark2 11e0
{0xf6, 0xe1,},
{0xf7, 0x1a,}, //Dark2 11e1
{0xf8, 0xe2,},
{0xf9, 0x00,}, //Dark2 11e2 //Bayer Flat R4 LumL
{0xfa, 0xe3,},
{0xfb, 0xff,}, //Dark2 11e3
{0xfc, 0xe4,},
{0xfd, 0x00,}, //Dark2 11e4
{0x0e, 0x00,}, // burst end

{0x03, 0xe8,}, //DMA E8 Page
{0x0e, 0x01,}, // burst start

{0x10, 0xe5,},
{0x11, 0x18,}, //Dark2 11e5
{0x12, 0xe6,},
{0x13, 0x00,}, //Dark2 11e6
{0x14, 0xe7,},
{0x15, 0x28,}, //Dark2 11e7
{0x16, 0xe8,},
{0x17, 0x00,}, //Dark2 11e8
{0x18, 0xe9,},
{0x19, 0x09,}, //Dark2 11e9
{0x1a, 0xea,},
{0x1b, 0x00,}, //Dark2 11ea
{0x1c, 0xeb,},
{0x1d, 0x14,}, //Dark2 11eb
{0x1e, 0xef,},
{0x1f, 0x33,}, //Dark2 11ef //Bayer Flat R3/R4 rate
{0x20, 0x03,},
{0x21, 0x12,}, //12 Page
{0x22, 0x40,},
{0x23, 0x36,}, //Dark2 1240 add 720p
{0x24, 0x70,},
{0x25, 0x81,}, //Dark2 1270 // Bayer Sharpness ENB add 720p
{0x26, 0x71,},
{0x27, 0x07,}, //Dark2 1271 //Bayer HPF Gain
{0x28, 0x72,},
{0x29, 0x07,}, //Dark2 1272 //Bayer LPF Gain
{0x2a, 0x77,},
{0x2b, 0x00,}, //Dark2 1277
{0x2c, 0x78,},
{0x2d, 0x09,}, //Dark2 1278
{0x2e, 0x79,},
{0x2f, 0x2e,}, //Dark2 1279
{0x30, 0x7a,},
{0x31, 0x50,}, //Dark2 127a
{0x32, 0x7b,},
{0x33, 0x10,}, //Dark2 127b
{0x34, 0x7c,},
{0x35, 0x50,}, //Dark2 127c //skin HPF gain
{0x36, 0x7d,},
{0x37, 0x10,}, //Dark2 127d
{0x38, 0x7f,},
{0x39, 0x50,}, //Dark2 127f
{0x3a, 0x87,},
{0x3b, 0x08,}, //Dark2 1287 add 720p
{0x3c, 0x88,},
{0x3d, 0x08,}, //Dark2 1288 add 720p
{0x3e, 0x89,},
{0x3f, 0x08,}, //Dark2 1289 add 720p
{0x40, 0x8a,},
{0x41, 0x0c,}, //Dark2 128a add 720p
{0x42, 0x8b,},
{0x43, 0x10,}, //Dark2 128b add 720p
{0x44, 0x8c,},
{0x45, 0x14,}, //Dark2 128c add 720p
{0x46, 0x8d,},
{0x47, 0x18,}, //Dark2 128d add 720p
{0x48, 0x8e,},
{0x49, 0x1a,}, //Dark2 128e add 720p
{0x4a, 0x8f,},
{0x4b, 0x08,}, //Dark2 128f add 720p
{0x4c, 0x90,},
{0x4d, 0x0a,}, //Dark2 1290 add 720p
{0x4e, 0x91,},
{0x4f, 0x0e,}, //Dark2 1291 add 720p
{0x50, 0x92,},
{0x51, 0x12,}, //Dark2 1292 add 720p
{0x52, 0x93,},
{0x53, 0x16,}, //Dark2 1293 add 720p
{0x54, 0x94,},
{0x55, 0x1a,}, //Dark2 1294 add 720p
{0x56, 0x95,},
{0x57, 0x20,}, //Dark2 1295 add 720p
{0x58, 0x96,},
{0x59, 0x20,}, //Dark2 1296 add 720p
{0x5a, 0xae,},
{0x5b, 0x20,}, //Dark2 12ae
{0x5c, 0xaf,},
{0x5d, 0x33,}, //Dark2 12af // B[7:4]Blue/B[3:0]Skin
{0x5e, 0xc0,},
{0x5f, 0x23,}, //Dark2 12c0 // CI-LPF ENB add 720p
{0x60, 0xc3,},
{0x61, 0x18,}, //Dark2 12c3 add 720p
{0x62, 0xc4,},
{0x63, 0x0d,}, //Dark2 12c4 add 720p
{0x64, 0xc5,},
{0x65, 0x06,}, //Dark2 12c5 add 720p
{0x66, 0xc6,},
{0x67, 0x11,}, //Dark2 12c6
{0x68, 0xc7,},
{0x69, 0x11,}, //Dark2 12c7
{0x6a, 0xc8,},
{0x6b, 0x04,}, //Dark2 12c8
{0x6c, 0xd0,},
{0x6d, 0x02,}, //Dark2 12d0 add 720p
{0x6e, 0xd1,},
{0x6f, 0x04,}, //Dark2 12d1 add 720p
{0x70, 0xd2,},
{0x71, 0x07,}, //Dark2 12d2 add 720p
{0x72, 0xd3,},
{0x73, 0x0c,}, //Dark2 12d3 add 720p
{0x74, 0xd4,},
{0x75, 0x10,}, //Dark2 12d4 add 720p
{0x76, 0xd5,},
{0x77, 0x18,}, //Dark2 12d5 add 720p
{0x78, 0xd6,},
{0x79, 0x20,}, //Dark2 12d6 add 720p
{0x7a, 0xd7,},
{0x7b, 0x29,}, //Dark2 12d7 //CI LPF Lum offset start
{0x7c, 0xd8,},
{0x7d, 0x2a,}, //Dark2 12d8
{0x7e, 0xd9,},
{0x7f, 0x2c,}, //Dark2 12d9
{0x80, 0xda,},
{0x81, 0x2b,}, //Dark2 12da
{0x82, 0xdb,},
{0x83, 0x2a,}, //Dark2 12db
{0x84, 0xdc,},
{0x85, 0x28,}, //Dark2 12dc
{0x86, 0xdd,},
{0x87, 0x27,}, //Dark2 12dd
{0x88, 0xde,},
{0x89, 0x27,}, //Dark2 12de //CI LPF Lum offset end
{0x8a, 0xe0,},
{0x8b, 0x63,}, //Dark2 12e0 // 20121120 ln dy
{0x8c, 0xe1,},
{0x8d, 0xfc,}, //Dark2 12e1
{0x8e, 0xe2,},
{0x8f, 0x02,}, //Dark2 12e2
{0x90, 0xe3,},
{0x91, 0x10,}, //Dark2 12e3 //PS LN graph Y1
{0x92, 0xe4,},
{0x93, 0x12,}, //Dark2 12e4 //PS LN graph Y2
{0x94, 0xe5,},
{0x95, 0x1a,}, //Dark2 12e5 //PS LN graph Y3
{0x96, 0xe6,},
{0x97, 0x1d,}, //Dark2 12e6 //PS LN graph Y4
{0x98, 0xe7,},
{0x99, 0x1e,}, //Dark2 12e7 //PS LN graph Y5
{0x9a, 0xe8,},
{0x9b, 0x1f,}, //Dark2 12e8 //PS LN graph Y6
{0x9c, 0xe9,},
{0x9d, 0x10,}, //Dark2 12e9 //PS DY graph Y1
{0x9e, 0xea,},
{0x9f, 0x12,}, //Dark2 12ea //PS DY graph Y2
{0xa0, 0xeb,},
{0xa1, 0x18,}, //Dark2 12eb //PS DY graph Y3
{0xa2, 0xec,},
{0xa3, 0x1c,}, //Dark2 12ec //PS DY graph Y4
{0xa4, 0xed,},
{0xa5, 0x1e,}, //Dark2 12ed //PS DY graph Y5
{0xa6, 0xee,},
{0xa7, 0x1f,}, //Dark2 12ee //PS DY graph Y6
{0xa8, 0xf0,},
{0xa9, 0x00,}, //Dark2 12f0
{0xaa, 0xf1,},
{0xab, 0x2a,}, //Dark2 12f1
{0xac, 0xf2,},
{0xad, 0x32,}, //Dark2 12f2
{0xae, 0x03,},
{0xaf, 0x13,}, //13 Page
{0xb0, 0x10,},
{0xb1, 0x80,}, //Dark2 1310 //Y-NR ENB add 720p
{0xb2, 0x30,},
{0xb3, 0x20,}, //Dark2 1330
{0xb4, 0x31,},
{0xb5, 0x20,}, //Dark2 1331
{0xb6, 0x32,},
{0xb7, 0x20,}, //Dark2 1332
{0xb8, 0x33,},
{0xb9, 0x20,}, //Dark2 1333
{0xba, 0x34,},
{0xbb, 0x20,}, //Dark2 1334
{0xbc, 0x35,},
{0xbd, 0x2d,}, //Dark2 1335
{0xbe, 0x36,},
{0xbf, 0x20,}, //Dark2 1336
{0xc0, 0x37,},
{0xc1, 0x20,}, //Dark2 1337
{0xc2, 0x38,},
{0xc3, 0x02,}, //Dark2 1338
{0xc4, 0x40,},
{0xc5, 0x00,}, //Dark2 1340
{0xc6, 0x41,},
{0xc7, 0x13,}, //Dark2 1341
{0xc8, 0x42,},
{0xc9, 0x62,}, //Dark2 1342
{0xca, 0x43,},
{0xcb, 0x63,}, //Dark2 1343
{0xcc, 0x44,},
{0xcd, 0x7e,}, //Dark2 1344
{0xce, 0x45,},
{0xcf, 0x00,}, //Dark2 1345
{0xd0, 0x46,},
{0xd1, 0x6b,}, //Dark2 1346
{0xd2, 0x47,},
{0xd3, 0x00,}, //Dark2 1347
{0xd4, 0x48,},
{0xd5, 0x4a,}, //Dark2 1348
{0xd6, 0x49,},
{0xd7, 0x00,}, //Dark2 1349
{0xd8, 0x4a,},
{0xd9, 0x43,}, //Dark2 134a
{0xda, 0x4b,},
{0xdb, 0x00,}, //Dark2 134b
{0xdc, 0x4c,},
{0xdd, 0x2e,}, //Dark2 134c
{0xde, 0x83,},
{0xdf, 0x08,}, //Dark2 1383
{0xe0, 0x84,},
{0xe1, 0x0a,}, //Dark2 1384
{0xe2, 0xb7,},
{0xe3, 0xff,}, //Dark2 13b7
{0xe4, 0xb8,},
{0xe5, 0xff,}, //Dark2 13b8
{0xe6, 0xb9,},
{0xe7, 0xff,}, //Dark2 13b9 //20121217 DC R1,2 CR
{0xe8, 0xba,},
{0xe9, 0xff,}, //Dark2 13ba //20121217 DC R3,4 CR
{0xea, 0xbd,},
{0xeb, 0x78,}, //Dark2 13bd //20121121 c-filter LumHL DC rate
{0xec, 0xc5,},
{0xed, 0x01,}, //Dark2 13c5 //20121121 c-filter DC_STD R1 R2 //20121217
{0xee, 0xc6,},
{0xef, 0x22,}, //Dark2 13c6 //20121121 c-filter DC_STD R3 R4 //20121217
{0xf0, 0xc7,},
{0xf1, 0x33,}, //Dark2 13c7 //20121121 c-filter DC_STD R5 R6 //20121217
{0xf2, 0x03,},
{0xf3, 0x14,}, //14 page
{0xf4, 0x10,},
{0xf5, 0x01,}, //Dark2 1410
{0xf6, 0x11,},
{0xf7, 0xd8,}, //Dark2 1411
{0xf8, 0x12,},
{0xf9, 0x10,}, //Dark2 1412
{0xfa, 0x13,},
{0xfb, 0x05,}, //Dark2 1413
{0xfc, 0x14,},
{0xfd, 0x14,}, //Dark2 1414 //YC2D Low Gain B[5:0]
{0x0e, 0x00,}, // burst end

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x15,},
{0x11, 0x7d,}, //Dark2 1415 // Y Hi filter mask 1/16
{0x12, 0x16,},
{0x13, 0x17,}, //Dark2 1416 //YC2D Hi Gain B[5:0]
{0x14, 0x17,},
{0x15, 0x40,}, //Dark2 1417
{0x16, 0x18,},
{0x17, 0x0c,}, //Dark2 1418
{0x18, 0x19,},
{0x19, 0x0c,}, //Dark2 1419
{0x1a, 0x1a,},
{0x1b, 0x1c,}, //Dark2 141a //YC2D Post STD gain Pos
{0x1c, 0x1b,},
{0x1d, 0x1c,}, //Dark2 141b //YC2D Post STD gain Neg
{0x1e, 0x27,},
{0x1f, 0x0f,}, //Dark2 1427 //YC2D SP Lum Gain Pos1
{0x20, 0x28,},
{0x21, 0x10,}, //Dark2 1428 //YC2D SP Lum Gain Pos2
{0x22, 0x29,},
{0x23, 0x11,}, //Dark2 1429 //YC2D SP Lum Gain Pos3
{0x24, 0x2a,},
{0x25, 0x12,}, //Dark2 142a //YC2D SP Lum Gain Pos4
{0x26, 0x2b,},
{0x27, 0x13,}, //Dark2 142b //YC2D SP Lum Gain Pos5
{0x28, 0x2c,},
{0x29, 0x14,}, //Dark2 142c //YC2D SP Lum Gain Pos6
{0x2a, 0x2d,},
{0x2b, 0x13,}, //Dark2 142d //YC2D SP Lum Gain Pos7
{0x2c, 0x2e,},
{0x2d, 0x10,}, //Dark2 142e //YC2D SP Lum Gain Pos8
{0x2e, 0x30,},
{0x2f, 0x0f,}, //Dark2 1430 //YC2D SP Lum Gain Neg1
{0x30, 0x31,},
{0x31, 0x10,}, //Dark2 1431 //YC2D SP Lum Gain Neg2
{0x32, 0x32,},
{0x33, 0x11,}, //Dark2 1432 //YC2D SP Lum Gain Neg3
{0x34, 0x33,},
{0x35, 0x12,}, //Dark2 1433 //YC2D SP Lum Gain Neg4
{0x36, 0x34,},
{0x37, 0x13,}, //Dark2 1434 //YC2D SP Lum Gain Neg5
{0x38, 0x35,},
{0x39, 0x13,}, //Dark2 1435 //YC2D SP Lum Gain Neg6
{0x3a, 0x36,},
{0x3b, 0x12,}, //Dark2 1436 //YC2D SP Lum Gain Neg7
{0x3c, 0x37,},
{0x3d, 0x10,}, //Dark2 1437 //YC2D SP Lum Gain Neg8
{0x3e, 0x47,},
{0x3f, 0x1c,}, //Dark2 1447 //YC2D SP Dy Gain Pos1
{0x40, 0x48,},
{0x41, 0x1b,}, //Dark2 1448 //YC2D SP Dy Gain Pos2
{0x42, 0x49,},
{0x43, 0x1a,}, //Dark2 1449 //YC2D SP Dy Gain Pos3
{0x44, 0x4a,},
{0x45, 0x18,}, //Dark2 144a //YC2D SP Dy Gain Pos4
{0x46, 0x4b,},
{0x47, 0x16,}, //Dark2 144b //YC2D SP Dy Gain Pos5
{0x48, 0x4c,},
{0x49, 0x14,}, //Dark2 144c //YC2D SP Dy Gain Pos6
{0x4a, 0x4d,},
{0x4b, 0x12,}, //Dark2 144d //YC2D SP Dy Gain Pos7
{0x4c, 0x4e,},
{0x4d, 0x10,}, //Dark2 144e //YC2D SP Dy Gain Pos8
{0x4e, 0x50,},
{0x4f, 0x1a,}, //Dark2 1450 //YC2D SP Dy Gain Neg1
{0x50, 0x51,},
{0x51, 0x19,}, //Dark2 1451 //YC2D SP Dy Gain Neg2
{0x52, 0x52,},
{0x53, 0x18,}, //Dark2 1452 //YC2D SP Dy Gain Neg3
{0x54, 0x53,},
{0x55, 0x17,}, //Dark2 1453 //YC2D SP Dy Gain Neg4
{0x56, 0x54,},
{0x57, 0x16,}, //Dark2 1454 //YC2D SP Dy Gain Neg5
{0x58, 0x55,},
{0x59, 0x14,}, //Dark2 1455 //YC2D SP Dy Gain Neg6
{0x5a, 0x56,},
{0x5b, 0x12,}, //Dark2 1456 //YC2D SP Dy Gain Neg7
{0x5c, 0x57,},
{0x5d, 0x10,}, //Dark2 1457 //YC2D SP Dy Gain Neg8
{0x5e, 0x67,},
{0x5f, 0x10,}, //Dark2 1467 //YC2D SP Edge Gain1
{0x60, 0x68,},
{0x61, 0x23,}, //Dark2 1468 //YC2D SP Edge Gain2
{0x62, 0x69,},
{0x63, 0x26,}, //Dark2 1469 //YC2D SP Edge Gain3
{0x64, 0x6a,},
{0x65, 0x24,}, //Dark2 146a //YC2D SP Edge Gain4
{0x66, 0x6b,},
{0x67, 0x13,}, //Dark2 146b //YC2D SP Edge Gain5
{0x68, 0x6c,},
{0x69, 0x1a,}, //Dark2 146c //YC2D SP Edge Gain6
{0x6a, 0x6d,},
{0x6b, 0x12,}, //Dark2 146d //YC2D SP Edge Gain7
{0x6c, 0x6e,},
{0x6d, 0x12,}, //Dark2 146e //YC2D SP Edge Gain8
{0x6e, 0x87,},
{0x6f, 0x19,}, //Dark2 1487 //YC2D SP STD Gain1
{0x70, 0x88,},
{0x71, 0x1a,}, //Dark2 1488 //YC2D SP STD Gain2
{0x72, 0x89,},
{0x73, 0x1c,}, //Dark2 1489 //YC2D SP STD Gain3
{0x74, 0x8a,},
{0x75, 0x1b,}, //Dark2 148a //YC2D SP STD Gain4
{0x76, 0x8b,},
{0x77, 0x1a,}, //Dark2 148b //YC2D SP STD Gain5
{0x78, 0x8c,},
{0x79, 0x1c,}, //Dark2 148c //YC2D SP STD Gain6
{0x7a, 0x8d,},
{0x7b, 0x25,}, //Dark2 148d //YC2D SP STD Gain7
{0x7c, 0x8e,},
{0x7d, 0x29,}, //Dark2 148e //YC2D SP STD Gain8
{0x7e, 0x97,},
{0x7f, 0x08,}, //Dark2 1497 add 720p
{0x80, 0x98,},
{0x81, 0x0c,}, //Dark2 1498 add 720p
{0x82, 0x99,},
{0x83, 0x10,}, //Dark2 1499 add 720p
{0x84, 0x9a,},
{0x85, 0x10,}, //Dark2 149a add 720p
{0x86, 0x9b,},
{0x87, 0x10,}, //Dark2 149b add 720p
{0x88, 0xa0,},
{0x89, 0x08,}, //Dark2 14a0 add 720p
{0x8a, 0xa1,},
{0x8b, 0x10,}, //Dark2 14a1 add 720p
{0x8c, 0xa2,},
{0x8d, 0x14,}, //Dark2 14a2 add 720p
{0x8e, 0xa3,},
{0x8f, 0x1a,}, //Dark2 14a3 add 720p
{0x90, 0xa4,},
{0x91, 0x1a,}, //Dark2 14a4 add 720p
{0x92, 0xc9,},
{0x93, 0x13,}, //Dark2 14c9
{0x94, 0xca,},
{0x95, 0x20,}, //Dark2 14ca
{0x96, 0x03,},
{0x97, 0x1a,}, //1A page
{0x98, 0x10,},
{0x99, 0x14,}, //Dark2 1A10 add 720p
{0x9a, 0x18,},
{0x9b, 0x1f,}, //Dark2 1A18
{0x9c, 0x19,},
{0x9d, 0x15,}, //Dark2 1A19
{0x9e, 0x1a,},
{0x9f, 0x0a,}, //Dark2 1A1a
{0xa0, 0x1b,},
{0xa1, 0x07,}, //Dark2 1A1b
{0xa2, 0x1c,},
{0xa3, 0x03,}, //Dark2 1A1c
{0xa4, 0x1d,},
{0xa5, 0x03,}, //Dark2 1A1d
{0xa6, 0x1e,},
{0xa7, 0x03,}, //Dark2 1A1e
{0xa8, 0x1f,},
{0xa9, 0x03,}, //Dark2 1A1f
{0xaa, 0x20,},
{0xab, 0x07,}, //Dark2 1A20 add 720p
{0xac, 0x2f,},
{0xad, 0xf6,}, //Dark2 1A2f add 720p
{0xae, 0x32,},
{0xaf, 0x07,}, //Dark2 1A32 add 720p
{0xb0, 0x34,},
{0xb1, 0xdf,}, //Dark2 1A34 //RGB High Gain B[5:0]
{0xb2, 0x35,},
{0xb3, 0x1b,}, //Dark2 1A35 //RGB Low Gain B[5:0]
{0xb4, 0x36,},
{0xb5, 0xef,}, //Dark2 1A36
{0xb6, 0x37,},
{0xb7, 0x40,}, //Dark2 1A37
{0xb8, 0x38,},
{0xb9, 0xff,}, //Dark2 1A38
{0xba, 0x39,},
{0xbb, 0x2e,}, //Dark2 1A39 //RGB Flat R2_Lum L
{0xbc, 0x3a,},
{0xbd, 0x3f,}, //Dark2 1A3a
{0xbe, 0x3b,},
{0xbf, 0x01,}, //Dark2 1A3b
{0xc0, 0x3c,},
{0xc1, 0x0c,}, //Dark2 1A3c
{0xc2, 0x3d,},
{0xc3, 0x01,}, //Dark2 1A3d
{0xc4, 0x3e,},
{0xc5, 0x07,}, //Dark2 1A3e
{0xc6, 0x3f,},
{0xc7, 0x01,}, //Dark2 1A3f
{0xc8, 0x40,},
{0xc9, 0x0c,}, //Dark2 1A40
{0xca, 0x41,},
{0xcb, 0x01,}, //Dark2 1A41
{0xcc, 0x42,},
{0xcd, 0x07,}, //Dark2 1A42
{0xce, 0x43,},
{0xcf, 0x2b,}, //Dark2 1A43
{0xd0, 0x4d,},
{0xd1, 0x15,}, //Dark2 1A4d //RGB SP Lum Gain Neg1
{0xd2, 0x4e,},
{0xd3, 0x14,}, //Dark2 1A4e //RGB SP Lum Gain Neg2
{0xd4, 0x4f,},
{0xd5, 0x13,}, //Dark2 1A4f //RGB SP Lum Gain Neg3
{0xd6, 0x50,},
{0xd7, 0x12,}, //Dark2 1A50 //RGB SP Lum Gain Neg4
{0xd8, 0x51,},
{0xd9, 0x11,}, //Dark2 1A51 //RGB SP Lum Gain Neg5
{0xda, 0x52,},
{0xdb, 0x10,}, //Dark2 1A52 //RGB SP Lum Gain Neg6
{0xdc, 0x53,},
{0xdd, 0x0f,}, //Dark2 1A53 //RGB SP Lum Gain Neg7
{0xde, 0x54,},
{0xdf, 0x0e,}, //Dark2 1A54 //RGB SP Lum Gain Neg8
{0xe0, 0x55,},
{0xe1, 0x15,}, //Dark2 1A55 //RGB SP Lum Gain Pos1
{0xe2, 0x56,},
{0xe3, 0x14,}, //Dark2 1A56 //RGB SP Lum Gain Pos2
{0xe4, 0x57,},
{0xe5, 0x13,}, //Dark2 1A57 //RGB SP Lum Gain Pos3
{0xe6, 0x58,},
{0xe7, 0x12,}, //Dark2 1A58 //RGB SP Lum Gain Pos4
{0xe8, 0x59,},
{0xe9, 0x11,}, //Dark2 1A59 //RGB SP Lum Gain Pos5
{0xea, 0x5a,},
{0xeb, 0x10,}, //Dark2 1A5a //RGB SP Lum Gain Pos6
{0xec, 0x5b,},
{0xed, 0x0f,}, //Dark2 1A5b //RGB SP Lum Gain Pos7
{0xee, 0x5c,},
{0xef, 0x0e,}, //Dark2 1A5c //RGB SP Lum Gain Pos8
{0xf0, 0x65,},
{0xf1, 0x1e,}, //Dark2 1A65 //RGB SP Dy Gain Neg1
{0xf2, 0x66,},
{0xf3, 0x1d,}, //Dark2 1A66 //RGB SP Dy Gain Neg2
{0xf4, 0x67,},
{0xf5, 0x1c,}, //Dark2 1A67 //RGB SP Dy Gain Neg3
{0xf6, 0x68,},
{0xf7, 0x1a,}, //Dark2 1A68 //RGB SP Dy Gain Neg4
{0xf8, 0x69,},
{0xf9, 0x18,}, //Dark2 1A69 //RGB SP Dy Gain Neg5
{0xfa, 0x6a,},
{0xfb, 0x16,}, //Dark2 1A6a //RGB SP Dy Gain Neg6
{0xfc, 0x6b,},
{0xfd, 0x14,}, //Dark2 1A6b //RGB SP Dy Gain Neg7
{0x0e, 0x00,}, // burst end

//I2CD set
{0x03, 0x26,},	//Xdata mapping for I2C direct E9 page.
{0xE2, 0x32,},
{0xE3, 0x6A,},

{0x03, 0xe9,}, //DMA E9 Page
{0x0e, 0x01,}, // burst start

{0x10, 0x6c,},
{0x11, 0x12,}, //Dark2 1A6c //RGB SP Dy Gain Neg8
{0x12, 0x6d,},
{0x13, 0x1e,}, //Dark2 1A6d //RGB SP Dy Gain Pos1
{0x14, 0x6e,},
{0x15, 0x1d,}, //Dark2 1A6e //RGB SP Dy Gain Pos2
{0x16, 0x6f,},
{0x17, 0x1c,}, //Dark2 1A6f //RGB SP Dy Gain Pos3
{0x18, 0x70,},
{0x19, 0x1a,}, //Dark2 1A70 //RGB SP Dy Gain Pos4
{0x1a, 0x71,},
{0x1b, 0x18,}, //Dark2 1A71 //RGB SP Dy Gain Pos5
{0x1c, 0x72,},
{0x1d, 0x16,}, //Dark2 1A72 //RGB SP Dy Gain Pos6
{0x1e, 0x73,},
{0x1f, 0x14,}, //Dark2 1A73 //RGB SP Dy Gain Pos7
{0x20, 0x74,},
{0x21, 0x12,}, //Dark2 1A74 //RGB SP Dy Gain Pos8
{0x22, 0x7d,},
{0x23, 0x20,}, //Dark2 1A7d //RGB SP Edge Gain1
{0x24, 0x7e,},
{0x25, 0x1f,}, //Dark2 1A7e //RGB SP Edge Gain2
{0x26, 0x7f,},
{0x27, 0x1e,}, //Dark2 1A7f //RGB SP Edge Gain3
{0x28, 0x80,},
{0x29, 0x1c,}, //Dark2 1A80 //RGB SP Edge Gain4
{0x2a, 0x81,},
{0x2b, 0x1a,}, //Dark2 1A81 //RGB SP Edge Gain5
{0x2c, 0x82,},
{0x2d, 0x18,}, //Dark2 1A82 //RGB SP Edge Gain6
{0x2e, 0x83,},
{0x2f, 0x14,}, //Dark2 1A83 //RGB SP Edge Gain7
{0x30, 0x84,},
{0x31, 0x10,}, //Dark2 1A84 //RGB SP Edge Gain8
{0x32, 0x9e,},
{0x33, 0x22,}, //Dark2 1A9e //RGB SP STD Gain1
{0x34, 0x9f,},
{0x35, 0x20,}, //Dark2 1A9f //RGB SP STD Gain2
{0x36, 0xa0,},
{0x37, 0x1e,}, //Dark2 1Aa0 //RGB SP STD Gain3
{0x38, 0xa1,},
{0x39, 0x1c,}, //Dark2 1Aa1 //RGB SP STD Gain4
{0x3a, 0xa2,},
{0x3b, 0x1a,}, //Dark2 1Aa2 //RGB SP STD Gain5
{0x3c, 0xa3,},
{0x3d, 0x18,}, //Dark2 1Aa3 //RGB SP STD Gain6
{0x3e, 0xa4,},
{0x3f, 0x14,}, //Dark2 1Aa4 //RGB SP STD Gain7
{0x40, 0xa5,},
{0x41, 0x10,}, //Dark2 1Aa5 //RGB SP STD Gain8
{0x42, 0xa6,},
{0x43, 0xaa,}, //Dark2 1Aa6 //RGB Post STD Gain Pos/Neg
{0x44, 0xa7,},
{0x45, 0x04,}, //Dark2 1Aa7 add 720p
{0x46, 0xa8,},
{0x47, 0x06,}, //Dark2 1Aa8 add 720p
{0x48, 0xa9,},
{0x49, 0x08,}, //Dark2 1Aa9 add 720p
{0x4a, 0xaa,},
{0x4b, 0x09,}, //Dark2 1Aaa add 720p
{0x4c, 0xab,},
{0x4d, 0x0a,}, //Dark2 1Aab add 720p
{0x4e, 0xaf,},
{0x4f, 0x04,}, //Dark2 1Aaf add 720p
{0x50, 0xb0,},
{0x51, 0x06,}, //Dark2 1Ab0 add 720p
{0x52, 0xb1,},
{0x53, 0x08,}, //Dark2 1Ab1 add 720p
{0x54, 0xb2,},
{0x55, 0x0a,}, //Dark2 1Ab2 add 720p
{0x56, 0xb3,},
{0x57, 0x0c,}, //Dark2 1Ab3 add 720p
{0x58, 0xca,},
{0x59, 0x00,}, //Dark2 1Aca
{0x5a, 0xe3,},
{0x5b, 0x12,}, //Dark2 1Ae3 add 720p
{0x5c, 0xe4,},
{0x5d, 0x12,}, //Dark2 1Ae4 add 720p
{0x5e, 0x03,},
{0x5f, 0x10,}, //10 page
{0x60, 0x70,},
{0x61, 0x0c,}, //Dark2 1070 Trans Func.   130108 Dark2 transFuc Flat graph
{0x62, 0x71,},
{0x63, 0x06,}, //Dark2 1071
{0x64, 0x72,},
{0x65, 0xbe,}, //Dark2 1072
{0x66, 0x73,},
{0x67, 0x99,}, //Dark2 1073
{0x68, 0x74,},
{0x69, 0x00,}, //Dark2 1074
{0x6a, 0x75,},
{0x6b, 0x00,}, //Dark2 1075
{0x6c, 0x76,},
{0x6d, 0x20,}, //Dark2 1076
{0x6e, 0x77,},
{0x6f, 0x33,}, //Dark2 1077
{0x70, 0x78,},
{0x71, 0x33,}, //Dark2 1078
{0x72, 0x79,},
{0x73, 0x40,}, //Dark2 1079
{0x74, 0x7a,},
{0x75, 0x00,}, //Dark2 107a
{0x76, 0x7b,},
{0x77, 0x40,}, //Dark2 107b
{0x78, 0x7c,},
{0x79, 0x00,}, //Dark2 107c
{0x7a, 0x7d,},
{0x7b, 0x07,}, //Dark2 107d
{0x7c, 0x7e,},
{0x7d, 0x0f,}, //Dark2 107e
{0x7e, 0x7f,},
{0x7f, 0x1e,}, //Dark2 107f
{0x80, 0x03,},
{0x81, 0x02,}, // 2 page
{0x82, 0x23,},
{0x83, 0x10,}, //Dark2 0223 (for sun-spot) // normal 3c
{0x84, 0x03,},
{0x85, 0x03,}, // 3 page
{0x86, 0x1a,},
{0x87, 0x06,}, //Dark2 031a (for sun-spot)
{0x88, 0x1b,},
{0x89, 0x7c,}, //Dark2 031b (for sun-spot)
{0x8a, 0x1c,},
{0x8b, 0x00,}, //Dark2 031c (for sun-spot)
{0x8c, 0x1d,},
{0x8d, 0x50,}, //Dark2 031d (for sun-spot)
{0x8e, 0x03,},
{0x8f, 0x11,}, // 11 page
{0x90, 0xf0,},
{0x91, 0x05,}, //Dark2 11f0 (for af bug)
{0x92, 0x03,},
{0x93, 0x12,}, //12 page
{0x94, 0x11,},
{0x95, 0xa9,}, //Dark2 1211 (20130416 for defect)

{0x0e, 0x00,}, // burst end

///////////////////////////////////////////
//  Scaler Off
///////////////////////////////////////////
{0x03, 0x19,},
{0x10, 0x00,}, //hw scaler off

//Scaler
{0x03, 0xc0,},
{0xa0, 0x00,}, //fw scaler off

//--------------------------------------------------------------------------//
// MIPI TX Setting  //PCLK 86MHz
//--------------------------------------------------------------------------//
{0x03, 0x05,},  // Page05
{0x1d, 0x0d,},  // tlpx_time_l_dn
{0x1e, 0x0c,},  // hs_zero_time
{0x1f, 0x0c,},  // hs_trail_time
{0x30, 0x0a,},  // l_pkt_wc_h  // Full = 1280 * 2 (YUV)
{0x31, 0x00,},  // l_pkt_wc_l
{0x32, 0x1c,},  // clk_zero_time
{0x33, 0x0e,},  // clk_post_time
{0x34, 0x05,},  // clk_prepare_time
{0x35, 0x08,},  // clk_trail_time
{0x36, 0x01,},  // clk_tlpx_time_dp
{0x37, 0x08,},  // clk_tlpx_time_dn

///////////////////////////////////////////////////////////////////////////////
// sleep off
///////////////////////////////////////////////////////////////////////////////

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,},	// Sleep Off

{0x03, 0xc0,},
{0x7F, 0x80,},	// DMA on
{0x7E, 0x01,},	// DMA set

{0xff, 0x01,},	//delay 10ms

///////////////////////////////////////////////////////////////////////////////
// end of HD set
///////////////////////////////////////////////////////////////////////////////
};

static struct sensor_reg sr352_recording_50Hz_30fps[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	//Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set

{0x03, 0x16,}, // dark color
{0x10, 0x3f,},

//--------------------------------------------------------------------------//
//Fixed mode setting
//--------------------------------------------------------------------------//
///////////////////////////////////////////
// 20 Page(Fuzzy)
///////////////////////////////////////////
{0x03, 0x20,},
{0x3C, 0x00,},	//Fix 30fps @ OPCLK 54MHz(1Line = 2200)
{0x3D, 0x1B,},
{0x3E, 0x75,},
{0x3F, 0xB0,},

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x15, 0x80,},	//Patch Weight Off B[6]
{0x36, 0x1e,},	//Max 30fps
{0x37, 0x1e,},	//Max 30fps

{0x11, 0x01,},	//AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2A, 0x60,},

//--------------------------------------------------------------------------//

///////////////////////////////////////////
// C8 Page(AWB)
///////////////////////////////////////////

{0x03, 0xc8,},
{0x14, 0x8f,},
{0x17, 0x22,}, //AWB Speed
{0x18, 0x44,},
{0x22, 0x20,},
{0x11, 0xC3,},	//AWB reset

{0x03, 0xd3,},
{0x10, 0x8d,},	// Adaptive on //B[1] EV with Y off

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x11, 0x87,},	//Fixed Mode On //XY Flip

{0x03, 0x00,},
{0x1e, 0x01,},  // frame update
{0x01, 0x00,},	// Sleep Off
{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x02,}, //delay 20ms

};

static struct sensor_reg sr352_recording_50Hz_30fps_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	//Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set

{0x03, 0x16,}, // dark color
{0x10, 0x3f,},

//--------------------------------------------------------------------------//
//Fixed mode setting
//--------------------------------------------------------------------------//
///////////////////////////////////////////
// 20 Page(Fuzzy)
///////////////////////////////////////////
{0x03, 0x20,},
{0x3C, 0x00,},	//Fix 30fps @ OPCLK 54MHz(1Line = 2200)
{0x3D, 0x1B,},
{0x3E, 0x75,},
{0x3F, 0xB0,},

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x15, 0x80,},	//Patch Weight Off B[6]
{0x36, 0x1e,},	//Max 30fps
{0x37, 0x1e,},	//Max 30fps

{0x11, 0x01,},	//AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2A, 0x60,},

//--------------------------------------------------------------------------//

///////////////////////////////////////////
// C8 Page(AWB)
///////////////////////////////////////////

{0x03, 0xc8,},
{0x14, 0x8f,},
{0x17, 0x22,}, //AWB Speed
{0x18, 0x44,},
{0x22, 0x20,},
{0x11, 0xC3,},	//AWB reset

{0x03, 0xd3,},
{0x10, 0x8d,},	// Adaptive on //B[1] EV with Y off

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x11, 0x84,},	//Fixed Mode On

{0x03, 0x00,},
{0x1e, 0x01,},  // frame update
{0x01, 0x00,},	// Sleep Off
{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x02,}, //delay 20ms

};

static struct sensor_reg sr352_recording_50Hz_modeOff[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	//Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set

//--------------------------------------------------------------------------//
//Variable mode setting
//--------------------------------------------------------------------------//
{0x03, 0x16,},
{0x10, 0x7f,},

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x15, 0xc0,},	//Patch Weight On B[6]
{0x36, 0x08,},	//Max 8fps
{0x37, 0x08,},	//Max 8fps

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x11, 0x01,},	//AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},
//--------------------------------------------------------------------------//

///////////////////////////////////////////
// C8 Page(AWB)
///////////////////////////////////////////

{0x03, 0xc8,},
{0x14, 0x9f,},
{0x17, 0x34,}, //AWB Speed
{0x18, 0x55,},
{0x22, 0x30,},
{0x11, 0xC3,},	//AWB reset

{0x03, 0xd3,},
{0x10, 0x8F,},	// Adaptive on

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x11, 0x83,},	//Fixed Mode Off //xy flip

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,}, //sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x02,}, //delay 20ms

};

static struct sensor_reg sr352_recording_50Hz_modeOff_01[] = {

{0x03, 0xc1,},
{0x10, 0x06,}, // ssd tranfer disable
{0xff, 0x01,},

{0x03, 0x00,},
{0x01, 0x01,},	//Sleep on

{0x03, 0xc1,},
{0x10, 0x07,}, // ssd tranfer enable

{0x03, 0xc0,},
{0x7f, 0x00,},	// DMA off
{0x7e, 0x01,},	// DMA set

//--------------------------------------------------------------------------//
//Variable mode setting
//--------------------------------------------------------------------------//
{0x03, 0x16,},
{0x10, 0x7f,},

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x15, 0xc0,},	//Patch Weight On B[6]
{0x36, 0x08,},	//Max 8fps
{0x37, 0x08,},	//Max 8fps

///////////////////////////////////////////
// C7 Page(AE)
///////////////////////////////////////////
{0x03, 0xc7,},
{0x11, 0x01,},	//AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},
//--------------------------------------------------------------------------//

///////////////////////////////////////////
// C8 Page(AWB)
///////////////////////////////////////////

{0x03, 0xc8,},
{0x14, 0x9f,},
{0x17, 0x34,}, //AWB Speed
{0x18, 0x55,},
{0x22, 0x30,},
{0x11, 0xC3,},	//AWB reset

{0x03, 0xd3,},
{0x10, 0x8F,},	// Adaptive on

///////////////////////////////////////////
// 00 Page
///////////////////////////////////////////
{0x03, 0x00,},
{0x11, 0x80,},	//Fixed Mode Off

{0x03, 0x00,},
{0x1e, 0x01,}, // frame update
{0x01, 0x00,}, //sleep off

{0x03, 0xc0,},
{0x7f, 0x80,},	// DMA on
{0x7e, 0x01,},	// DMA set

{0xff, 0x02,}, //delay 20ms

};

/*=================================
 *CAMERA_BRIGHTNESS_1 (1/9) M4   *
 ==================================*/
static struct sensor_reg sr352_brightness_M4[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x40,},
{0x5e, 0xf0,},
};

/*=================================
 *CAMERA_BRIGHTNESS_2 (2/9) M3  *
 ==================================*/

static struct sensor_reg sr352_brightness_M3[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x54,},
{0x5e, 0xf0,},
};

/*=================================
  CAMERA_BRIGHTNESS_3 (3/9) M2
  ==================================*/
static struct sensor_reg sr352_brightness_M2[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x67,},
{0x5e, 0xf0,},
};

/*=================================
  CAMERA_BRIGHTNESS_4 (4/9) M1
  ==================================*/

static struct sensor_reg sr352_brightness_M1[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x7b,},
{0x5e, 0xf0,},
};

/*=================================
  CAMERA_BRIGHTNESS_5 (5/9) Default
  ==================================*/
static struct sensor_reg sr352_brightness_default[] =
{
{0x03, 0x10,},
{0x14, 0x02,},
{0x5d, 0x80,},
{0x5e, 0x00,},
};

/*=================================
  CAMERA_BRIGHTNESS_6 (6/9) P1
  ==================================*/
static struct sensor_reg sr352_brightness_P1[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x86,},
{0x5e, 0x70,},
};

/*=================================
  CAMERA_BRIGHTNESS_7 (7/9) P2
  ==================================*/
static struct sensor_reg sr352_brightness_P2[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0x99,},
{0x5e, 0x70,},
};

/*=================================
  CAMERA_BRIGHTNESS_8 (8/9) P3
  ==================================*/
static struct sensor_reg sr352_brightness_P3[] =
{

{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0xae,},
{0x5e, 0x70,},
};

/*=================================
  CAMERA_BRIGHTNESS_9 (9/9) P4
  ==================================*/
static struct sensor_reg sr352_brightness_P4[] =
{
{0x03, 0x10,},
{0x14, 0x03,},
{0x5d, 0xc0,},
{0x5e, 0x70,},
};

static struct sensor_reg sr352_effect_none[] =
{
{0x03, 0x10,},
{0x11, 0x03,},
{0x12, 0x10,},
{0x42, 0x00,},
{0x43, 0x00,},
{0x44, 0x80,},
{0x45, 0x80,},
{0x03, 0x14,},
{0x80, 0x20,},

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};
static struct sensor_reg sr352_effect_none_01[] =
{
{0x03, 0x10,},
{0x11, 0x03,},
{0x12, 0x10,},
{0x42, 0x00,},
{0x43, 0x00,},
{0x44, 0x80,},
{0x45, 0x80,},
{0x03, 0x14,},
{0x80, 0x20,},

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};
static struct sensor_reg sr352_effect_gray[] =
{
{0x03, 0x10,},
{0x11, 0x03,},
{0x12, 0xf3,},
{0x42, 0x00,},
{0x43, 0x00,},
{0x44, 0x80,},
{0x45, 0x80,},
{0x03, 0x14,},
{0x80, 0x20,},

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};

static struct sensor_reg sr352_effect_negative[] =
{
{0x03, 0x10,},
{0x11, 0x03,},
{0x12, 0xf8,},
{0x42, 0x00,},
{0x43, 0x00,},
{0x44, 0x80,},
{0x45, 0x80,},
{0x03, 0x14,},
{0x80, 0x20,},

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};

static struct sensor_reg sr352_effect_sepia[] =
{
{0x03, 0x10,},
{0x11, 0x03,},
{0x12, 0xf3,},
{0x42, 0x00,},
{0x43, 0x00,},
{0x44, 0x60,},
{0x45, 0xa3,},
{0x03, 0x14,},
{0x80, 0x20,},

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};

static struct sensor_reg sr352_wb_auto[] =
{
{0x03, 0xc8,},
{0x10, 0x52,}, //AWB Off
{0x12, 0xe0,}, //Adaptive e0, manual 20
{0x15, 0xc4,},
{0x11, 0xc1,}, //AWB Reset
{0x10, 0xd2,}, //AWB On

//{SENSOR_CONF_SCRIPT_END, {0, 0}}
};

static struct sensor_reg sr352_wb_cloudy[] =
{
{0x03, 0xc8,},
{0x10, 0x52,}, //AWB Off
{0x12, 0x20,}, //Adaptive e0, manual 20
{0x15, 0x04,},
{0x03, 0xca,},
{0x95, 0x06,}, //R Min
{0x96, 0xa0,},
{0x97, 0x06,}, //R Max
{0x98, 0xc0,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x05,}, //B Min
{0x9e, 0xe0,},
{0x9f, 0x06,}, //B Max
{0xa0, 0x00,},
{0x03, 0xc8,},
{0x11, 0xc1,}, //AWB Reset
{0x10, 0xd2,}, //AWB On
};

static struct sensor_reg sr352_wb_fluorescent[] =
{
{0x03, 0xc8,},
{0x10, 0x52,}, //AWB Off
{0x12, 0x20,}, //Adaptive e0, manual 20
{0x15, 0x04,},
{0x03, 0xca,},
{0x95, 0x05,}, //R Min
{0x96, 0x00,},
{0x97, 0x05,}, //R Max
{0x98, 0x20,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x08,}, //B Min
{0x9e, 0x80,},
{0x9f, 0x08,}, //B Max
{0xa0, 0xa0,},
{0x03, 0xc8,},
{0x11, 0xc1,}, //AWB Reset
{0x10, 0xd2,}, //AWB On
};

static struct sensor_reg sr352_wb_incandescent[] =
{
{0x03, 0xc8,},
{0x10, 0x52,}, //AWB Off
{0x12, 0x20,}, //Adaptive e0, manual 20
{0x15, 0x04,},
{0x03, 0xca,},
{0x95, 0x04,}, //R Min
{0x96, 0x00,},
{0x97, 0x04,}, //R Max
{0x98, 0x20,},
{0x99, 0x04,}, //G Min
{0x9a, 0x70,},
{0x9b, 0x04,}, //G Max
{0x9c, 0xb0,},
{0x9d, 0x0a,}, //B Min
{0x9e, 0xc0,},
{0x9f, 0x0b,}, //B Max
{0xa0, 0x00,},
{0x03, 0xc8,},
{0x11, 0xc1,}, //AWB Reset
{0x10, 0xd2,}, //AWB On
};

static struct sensor_reg sr352_wb_sunny[] =
{
{0x03, 0xc8,},
{0x10, 0x52,}, //AWB Off
{0x12, 0x20,}, //Adaptive e0, manual 20
{0x15, 0x04,},
{0x03, 0xca,},
{0x95, 0x05,}, //R Min
{0x96, 0x80,},
{0x97, 0x05,}, //R Max
{0x98, 0xa0,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x06,}, //B Min
{0x9e, 0x60,},
{0x9f, 0x06,}, //B Max
{0xa0, 0x80,},
{0x03, 0xc8,},
{0x11, 0xc1,}, //AWB Reset
{0x10, 0xd2,}, //AWB On
};

/*===========================================*/
/*CAMERA_SCENE_off                         */
/*===========================================*/
static struct sensor_reg sr352_Scene_Off[] =
{
	//Scene Off (FPS Auto/ISO Auto/Center/Br0/AWB Auto/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8f,}, //EV option on
{0x11, 0xfe,}, //Function On

{0x03, 0x10,},
{0x12, 0x10,}, //Y Ofs On

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Band100 Max 8fps
{0x37, 0x08,}, //Band120 Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,}, //cb offset
{0x7c, 0x00,}, //cr offset

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,}, //SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,}, //HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x03,}, //d gain on


{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};

/*===========================================*/
/*CAMERA_SCENE_Landscape                   */
/*===========================================*/
static struct sensor_reg sr352_scene_Landscape[] =
{
	//Scene Landscape (FPS Auto/ISO Auto/Maxtrix/Br0/AWB Auto/Sat1/Sharp+1)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms


{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_Matrix
{0x03, 0xc6,},
{0x9E, 0x11,},	//1 Line
{0x9F, 0x11,},
{0xA0, 0x11,},
{0xA1, 0x11,},
{0xA2, 0x11,},
{0xA3, 0x11,},

{0xA4, 0x11,},	//2 Line
{0xA5, 0x11,},
{0xA6, 0x11,},
{0xA7, 0x11,},
{0xA8, 0x11,},
{0xA9, 0x11,},

{0xAA, 0x11,},//3 Line
{0xAB, 0x12,},
{0xAC, 0x22,},
{0xAD, 0x22,},
{0xAE, 0x21,},
{0xAF, 0x11,},

{0xB0, 0x11,},//4 Line
{0xB1, 0x12,},
{0xB2, 0x22,},
{0xB3, 0x22,},
{0xB4, 0x21,},
{0xB5, 0x11,},

{0xB6, 0x11,},//5 Line
{0xB7, 0x12,},
{0xB8, 0x22,},
{0xB9, 0x22,},
{0xBA, 0x21,},
{0xBB, 0x11,},

{0xBC, 0x11,},//6 Line
{0xBD, 0x12,},
{0xBE, 0x22,},
{0xBF, 0x22,},
{0xC0, 0x21,},
{0xC1, 0x11,},

{0xC2, 0x11,},//7 Line
{0xC3, 0x12,},
{0xC4, 0x22,},
{0xC5, 0x22,},
{0xC6, 0x21,},
{0xC7, 0x11,},

{0xC8, 0x11,},//8 Line
{0xC9, 0x11,},
{0xCA, 0x11,},
{0xCB, 0x11,},
{0xCC, 0x11,},
{0xCD, 0x11,},

{0xCE, 0x11,},//9 Line
{0xCF, 0x11,},
{0xD0, 0x11,},
{0xD1, 0x11,},
{0xD2, 0x11,},
{0xD3, 0x11,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x20,},
{0x7c, 0x20,},

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness +1
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0xcc,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0xcc,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0xcc,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0xcc,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};


/*===========================================*/
/*CAMERA_SCENE_Party                       */
/*===========================================*/
static struct sensor_reg sr352_scene_Party[] =
{
	/*Party/Indoor (FPS Auto/ISO 200/Center/Br0/AWB Auto/Sat1/Sharp0)*/
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0x82,}, //pga_max_total
{0x52, 0x5c,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},


	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x20,},
{0x7c, 0x20,},

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x5c,}, // Band1 Gain 30fps
{0x22, 0x5c,}, // Band2 Gain 15fps
{0x23, 0x5c,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off


{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};


/*===========================================*/
/*CAMERA_SCENE_sunset                      */
/*===========================================*/
static struct sensor_reg sr352_scene_Sunset[] =
{
	//Scene Sunset (FPS Auto/ISO Auto/Center/Br0/AWB cloudy/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms


{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

	//AWB cloudy
{0x03, 0xc8,},
{0x12, 0xa0,}, //Adaptive e0, manual a0

{0x03, 0xca,},
{0x95, 0x06,}, //R Min
{0x96, 0xa0,},
{0x97, 0x06,}, //R Max
{0x98, 0xc0,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x05,}, //B Min
{0x9e, 0xe0,},
{0x9f, 0x06,}, //B Max
{0xa0, 0x00,},


	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};


/*===========================================*/
/*CAMERA_SCENE_Dawn                        */
/*===========================================*/
static struct sensor_reg sr352_scene_Dawn[] =
{
	//Scene sunrise Dawn (FPS Auto/ISO Auto/Center/Br0/AWB CWF/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

	//AWB cwf
{0x03, 0xc8,},
{0x12, 0xa0,}, //Adaptive e0, manual a0

{0x03, 0xca,},
{0x95, 0x05,}, //R Min
{0x96, 0x00,},
{0x97, 0x05,}, //R Max
{0x98, 0x20,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x08,}, //B Min
{0x9e, 0x80,},
{0x9f, 0x08,}, //B Max
{0xa0, 0xa0,},



	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};

/*===========================================*/
/*CAMERA_SCENE_Fall                        */
/*===========================================*/
static struct sensor_reg sr352_scene_Fall[] =
{
	//Scene Fall (FPS Auto/ISO Auto/Center/Br0/AWB Auto/Sat2/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x40,},
{0x7c, 0x40,},

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};



/*===========================================*/
/*CAMERA_SCENE_Nightshot	          */
/*===========================================*/
static struct sensor_reg sr352_scene_Nightshot[] =
{

	//Scene Night (FPS Night/ISO Auto/Center/Br0/AWB Auto/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8f,}, //EV option on
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x10,}, //Y Ofs On

{0x03, 0x20,},
{0x12, 0x60,}, //AE Digital gain On

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0xba,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x04,}, //Max 4fps
{0x37, 0x04,}, //Max 4fps

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//Capture Set
{0x03, 0xD9,},
{0x8C, 0x60,}, //DG On
{0x25, 0xFF,}, //Deshutter AG Max
{0x26, 0x20,}, //Deshutter AG Min
{0x27, 0xba,}, //Deshutter DG Max
{0x28, 0x80,}, //Deshutter DG Min
{0x29, 0x02,}, //Deshutter Max 2Fps
{0x10, 0x06,}, //Deshutter On

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};

/*===========================================*/
/*CAMERA_SCENE_Backlight                        */
/*===========================================*/
static struct sensor_reg sr352_scene_Backlight[] =
{
	//Scene Against (FPS Auto/ISO Auto/Spot/Br0/AWB Auto/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

	//SSD_Spot
{0x03, 0xc6,},//1 Line
{0x9E, 0x00,},
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},
{0xA4, 0x00,},//2 Line
{0xA5, 0x00,},
{0xA6, 0x00,},
{0xA7, 0x00,},
{0xA8, 0x00,},
{0xA9, 0x00,},
{0xAA, 0x00,},//3 Line
{0xAB, 0x01,},
{0xAC, 0x11,},
{0xAD, 0x11,},
{0xAE, 0x10,},
{0xAF, 0x00,},
{0xB0, 0x00,},//4 Line
{0xB1, 0x01,},
{0xB2, 0xff,},
{0xB3, 0xff,},
{0xB4, 0x10,},
{0xB5, 0x00,},
{0xB6, 0x00,},//5 Line
{0xB7, 0x01,},
{0xB8, 0xff,},
{0xB9, 0xff,},
{0xBA, 0x10,},
{0xBB, 0x00,},
{0xBC, 0x00,},//6 Line
{0xBD, 0x01,},
{0xBE, 0xff,},
{0xBF, 0xff,},
{0xC0, 0x10,},
{0xC1, 0x00,},
{0xC2, 0x00,},//7 Line
{0xC3, 0x01,},
{0xC4, 0x11,},
{0xC5, 0x11,},
{0xC6, 0x10,},
{0xC7, 0x00,},
{0xC8, 0x00,},//8 Line
{0xC9, 0x00,},
{0xCA, 0x00,},
{0xCB, 0x00,},
{0xCC, 0x00,},
{0xCD, 0x00,},
{0xCE, 0x00,},//9 Line
{0xCF, 0x00,},
{0xD0, 0x00,},
{0xD1, 0x00,},
{0xD2, 0x00,},
{0xD3, 0x00,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

	//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off
};

/*===========================================*/
/*CAMERA_SCENE_Candle                      */
/*===========================================*/
static struct sensor_reg sr352_scene_Candle[] =
{
	//Scene candle (FPS Auto/ISO Auto/Center/Br0/AWB cloudy/Sat0/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

	//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

	//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

	//AWB cloudy
{0x03, 0xc8,},
{0x12, 0xa0,}, //Adaptive e0, manual a0

{0x03, 0xca,},
{0x95, 0x06,}, //R Min
{0x96, 0xa0,},
{0x97, 0x06,}, //R Max
{0x98, 0xc0,},
{0x99, 0x04,}, //G Min
{0x9a, 0x00,},
{0x9b, 0x04,}, //G Max
{0x9c, 0x80,},
{0x9d, 0x05,}, //B Min
{0x9e, 0xe0,},
{0x9f, 0x06,}, //B Max
{0xa0, 0x00,},



	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};


/*===========================================*/
/*CAMERA_SCENE_Beach      */
/*===========================================*/
static struct sensor_reg sr352_scene_Beach[] =
{
	//Beach(FPS Auto/ISO 50/Center/Br1/AWB Auto/Sat1/Sharp0)
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0xfe,}, //Y target On


{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0x20,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x08,}, //Max 8fps
{0x37, 0x08,}, //Max 8fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

//EV
{0x03, 0xd3,},
{0x7a, 0x10,}, //target offset

//Saturation
{0x03, 0xd3,},
{0x7b, 0x20,},
{0x7c, 0x20,},

//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x20,}, // Band1 Gain 30fps
{0x22, 0x20,}, // Band2 Gain 15fps
{0x23, 0x20,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};

/*===========================================*/
/*CAMERA_SCENE_Sports              */
/*===========================================*/
static struct sensor_reg sr352_scene_Sports[] =
{
	/*Sports (FPS Sports/ISO Auto/Center/Br0/AWB Auto/Sat0/Sharp0)*/
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x48,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x1e,}, //Max 30fps
{0x37, 0x1e,}, //Max 30fps

{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x10, 0x00,}, //Deshutter Off

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};


/*===========================================*/
/*CAMERA_SCENE_Firework                      */
/*===========================================*/
static struct sensor_reg sr352_scene_Firework[] =
{
	/*Firework (FPS Fire/ISO 50/Center/Br0/AWB Auto/Sat0/Sharp0)*/
{0x03, 0x00,},
{0x01, 0x10,}, //frame sleep on
{0xff, 0x19,}, //delay 250ms

{0x03, 0xD3,},
{0x10, 0x8d,}, //EV option off
{0x11, 0x7e,}, //Y target Off

{0x03, 0xd8,},
{0xcc, 0x34,},
{0x03, 0xdd,},
{0xbf, 0x34,},

{0x03, 0x10,},
{0x12, 0x00,}, //Y Ofs Off

{0x03, 0x20,},
{0x12, 0x20,}, //AE Digital gain Off

{0x51, 0xff,}, //pga_max_total
{0x52, 0x20,}, //pga_min_total
{0x71, 0x80,}, //Digital gain max

{0x03, 0xc7,},
{0x36, 0x04,}, //Max 4fps
{0x37, 0x04,}, //Max 4fps

//Capture Set
{0x03, 0xD9,},
{0x8C, 0x20,}, //DG Off
{0x25, 0x20,}, //Deshutter AG Max
{0x26, 0x20,}, //Deshutter AG Min
{0x27, 0x80,}, //Deshutter DG Max
{0x28, 0x80,}, //Deshutter DG Min
{0x29, 0x01,}, //Deshutter Max 1Fps
{0x10, 0x06,}, //Deshutter On

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

//EV
{0x03, 0xd3,},
{0x7a, 0x00,}, //target offset

//Saturation
{0x03, 0xd3,},
{0x7b, 0x00,},
{0x7c, 0x00,},

//AWB
{0x03, 0xc8,},
{0x12, 0xe0,}, //Adaptive e0, manual a0

	//Sharpness 0
{0x03, 0xde,}, //DE Page(Outdoor)
{0xd9, 0x54,}, //Outdoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe1,}, //E1 Page(Indoor)
{0xd9, 0x76,}, //Indoor 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe4,}, //E4 Page(Dark1)
{0xd9, 0x98,},//Dark1 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xe7,}, //E7 Page(Dark2)
{0xd9, 0x98,},//Dark2 11cf //Bayer Post STD gain Neg/Pos

{0x03, 0xc7,},
{0x21, 0x49,}, // Band1 Gain 30fps
{0x22, 0x53,}, // Band2 Gain 15fps
{0x23, 0x78,}, // Band3 Gain 12fps
{0x11, 0x01,}, //AE Reset
{0xff, 0x01,},
{0x4C, 0x00,},//SW ExpMin	 = 8800
{0x4D, 0x00,},
{0x4E, 0x22,},
{0x4F, 0x60,},

{0x03, 0x20,},//HW ExpMin  = 8800
{0x28, 0x00,},
{0x29, 0x22,},
{0x2a, 0x60,},

{0x03, 0x10,},
{0x14, 0x02,}, // d gain off

{0x03, 0x00,},
{0x01, 0x00,}, //sleep off

};

/*=========================================================*/
/*METERING()                                               */
/*=========================================================*/
static struct sensor_reg sr352_metering_matrix[] = {

	//Matrix weight set________________
{0x03, 0xc6,}, //1 line
{0x9E, 0x00,},
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xA4, 0x00,}, //2 line
{0xA5, 0x00,},
{0xA6, 0x00,},
{0xA7, 0x00,},
{0xA8, 0x00,},
{0xA9, 0x00,},

{0xAA, 0x11,}, //3 line
{0xAB, 0x11,},
{0xAC, 0x11,},
{0xAD, 0x11,},
{0xAE, 0x11,},
{0xAF, 0x11,},

{0xB0, 0x11,}, //4 line
{0xB1, 0x11,},
{0xB2, 0x11,},
{0xB3, 0x11,},
{0xB4, 0x11,},
{0xB5, 0x11,},

{0xB6, 0x11,}, //5 line
{0xB7, 0x11,},
{0xB8, 0x11,},
{0xB9, 0x11,},
{0xBA, 0x11,},
{0xBB, 0x11,},

{0xBC, 0x11,}, //6 line
{0xBD, 0x11,},
{0xBE, 0x11,},
{0xBF, 0x11,},
{0xC0, 0x11,},
{0xC1, 0x11,},

{0xC2, 0x11,}, //7 line
{0xC3, 0x11,},
{0xC4, 0x11,},
{0xC5, 0x11,},
{0xC6, 0x11,},
{0xC7, 0x11,},

{0xC8, 0x11,}, //8 line
{0xC9, 0x11,},
{0xCA, 0x11,},
{0xCB, 0x11,},
{0xCC, 0x11,},
{0xCD, 0x11,},

{0xCE, 0x11,}, //9 line
{0xCF, 0x11,},
{0xD0, 0x11,},
{0xD1, 0x11,},
{0xD2, 0x11,},
{0xD3, 0x11,},

};

static struct sensor_reg sr352_metering_center[] = {

//SSD_CenterWeighted
{0x03, 0xc6,},
{0x9E, 0x00,},	//1 Line
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xa4, 0x22,},//2 Line
{0xa5, 0x22,},
{0xa6, 0x22,},
{0xa7, 0x22,},
{0xa8, 0x22,},
{0xa9, 0x22,},

{0xaa, 0x44,},//3 Line
{0xab, 0x44,},
{0xac, 0x88,},
{0xad, 0x88,},
{0xae, 0x44,},
{0xaf, 0x44,},

{0xb0, 0x44,},//4 Line
{0xb1, 0x44,},
{0xb2, 0x8c,},
{0xb3, 0xc8,},
{0xb4, 0x44,},
{0xb5, 0x44,},

{0xb6, 0x44,},//5 Line
{0xb7, 0x8c,},
{0xb8, 0xcc,},
{0xb9, 0xcc,},
{0xba, 0xc8,},
{0xbb, 0x44,},

{0xbc, 0x44,},//6 Line
{0xbd, 0x8c,},
{0xbe, 0xcc,},
{0xbf, 0xcc,},
{0xc0, 0xc8,},
{0xc1, 0x44,},

{0xc2, 0x48,},//7 Line
{0xc3, 0xcc,},
{0xc4, 0xcc,},
{0xc5, 0xcc,},
{0xc6, 0xcc,},
{0xc7, 0x84,},

{0xc8, 0x44,},//8 Line
{0xc9, 0xaa,},
{0xca, 0xaa,},
{0xcb, 0xaa,},
{0xcc, 0xaa,},
{0xcd, 0x44,},

{0xce, 0x44,},//9 Line
{0xcf, 0x44,},
{0xd0, 0x44,},
{0xd1, 0x44,},
{0xd2, 0x44,},
{0xd3, 0x44,},

};

static struct sensor_reg sr352_metering_spot[] = {


	//Spot weight set________________
{0x03, 0xc6,}, //1 line
{0x9E, 0x00,},
{0x9F, 0x00,},
{0xA0, 0x00,},
{0xA1, 0x00,},
{0xA2, 0x00,},
{0xA3, 0x00,},

{0xA4, 0x00,}, //2 line
{0xA5, 0x00,},
{0xA6, 0x00,},
{0xA7, 0x00,},
{0xA8, 0x00,},
{0xA9, 0x00,},

{0xAA, 0x00,}, //3 line
{0xAB, 0x01,},
{0xAC, 0x11,},
{0xAD, 0x11,},
{0xAE, 0x10,},
{0xAF, 0x00,},

{0xB0, 0x00,}, //4 line
{0xB1, 0x01,},
{0xB2, 0xff,},
{0xB3, 0xff,},
{0xB4, 0x10,},
{0xB5, 0x00,},

{0xB6, 0x00,}, //5 line
{0xB7, 0x01,},
{0xB8, 0xff,},
{0xB9, 0xff,},
{0xBA, 0x10,},
{0xBB, 0x00,},

{0xBC, 0x00,}, //6 line
{0xBD, 0x01,},
{0xBE, 0xff,},
{0xBF, 0xff,},
{0xC0, 0x10,},
{0xC1, 0x00,},

{0xC2, 0x00,}, //7 line
{0xC3, 0x01,},
{0xC4, 0x11,},
{0xC5, 0x11,},
{0xC6, 0x10,},
{0xC7, 0x00,},

{0xC8, 0x00,}, //8 line
{0xC9, 0x00,},
{0xCA, 0x00,},
{0xCB, 0x00,},
{0xCC, 0x00,},
{0xCD, 0x00,},

{0xCE, 0x00,}, //9 line
{0xCF, 0x00,},
{0xD0, 0x00,},
{0xD1, 0x00,},
{0xD2, 0x00,},
{0xD3, 0x00,},

};

static struct sensor_reg sr352_AEAWB_Lock_50Hz[] = {
{0x03, 0xc7,},
{0x10, 0x70,},	//AE Off 50hz 70, 60hz 50
{0x03, 0xc8,},	//AWB Off
{0x10, 0x52,},
{0xff, 0x0a,}, //delay 100ms
};

static struct sensor_reg sr352_AEAWB_Unlock_50Hz[] = {
{0x03, 0xc7,},
{0x10, 0xf0,},	//AE On 50hz f0, 60hz d0
{0x03, 0xc8,},
{0x10, 0xd2,}, //AWB On
{0xff, 0x0a,}, //delay 100ms
};

#endif

static const struct sensor_regset_table regset_table = {
	.init		= SENSOR_REGISTER_REGSET(sr352_Init_Reg_01),
	.refresh_50h	= SENSOR_REGISTER_REGSET(sr352_50hz_setting),
	.stop_stream	= SENSOR_REGISTER_REGSET(sr352_stop_stream),
	.resol_640_480	= SENSOR_REGISTER_REGSET(sr352_Enterpreview_640x480_01),
	.resol_1024_768	= SENSOR_REGISTER_REGSET(sr352_Enterpreview_1024x768_01),
	.resol_1024_576	= SENSOR_REGISTER_REGSET(sr352_Enterpreview_1024x576_01),
};

static struct fimc_is_sensor_cfg settle_sr352[] = {
	/* 3264x2448@30fps */
	FIMC_IS_SENSOR_CFG(3264, 2448, 30, 17, 0),
};

static struct fimc_is_vci vci_sr352[] = {
	{
		.pixelformat = V4L2_PIX_FMT_YUYV,
		.vc_map = {0, 1, 2, 3}
	}, {
		.pixelformat = V4L2_PIX_FMT_JPEG,
		.vc_map = {0, 1, 2, 3}
	}
};

static int fimc_is_sr352_read8(struct i2c_client *client,
	u8 addr, u8 *val)
{
	int ret = 0;
	struct i2c_msg msg[2];
	u8 wbuf[2];

	if (!client->adapter) {
		err("Could not find adapter!\n");
		ret = -ENODEV;
		goto p_err;
	}

	/* 1. I2C operation for writing. */
	msg[0].addr = client->addr;
	msg[0].flags = 0; /* write : 0, read : 1 */
	msg[0].len = 1;
	msg[0].buf = wbuf;
	/* TODO : consider other size of buffer */
	wbuf[0] = addr;

	/* 2. I2C operation for reading data. */
	msg[1].addr = client->addr;
	msg[1].flags = I2C_M_RD;
	msg[1].len = 1;
	msg[1].buf = val;

	ret = i2c_transfer(client->adapter, msg, 2);
	if (ret < 0) {
		err("i2c treansfer fail");
		goto p_err;
	}

#ifdef PRINT_I2CCMD
	info("I2CR08(%d) [0x%04X] : 0x%04X\n", client->addr, addr, *val);
#endif

p_err:
	return ret;
}

static int fimc_is_sr352_write8(struct i2c_client *client,
	u8 addr, u8 val)
{
	int ret = 0;
	struct i2c_msg msg[1];
	u8 wbuf[3];

	if (!client->adapter) {
		err("Could not find adapter!\n");
		ret = -ENODEV;
		goto p_err;
	}

	msg->addr = client->addr;
	msg->flags = 0;
	msg->len = 2;
	msg->buf = wbuf;
	wbuf[0] = addr;
	wbuf[1] = val;

	ret = i2c_transfer(client->adapter, msg, 1);
	if (ret < 0) {
		err("i2c treansfer fail(%d)", ret);
		goto p_err;
	}

#ifdef PRINT_I2CCMD
	info("I2CW08(%d) [0x%04X] : 0x%04X\n", client->addr, addr, val);
#endif

p_err:
	return ret;
}

static int sensor_sr352_apply_set(struct i2c_client *client,
	const struct sensor_regset *regset)
{
	int ret = 0;
	u32 i;

	BUG_ON(!client);
	BUG_ON(!regset);

	for (i = 0; i < regset->size; i++) {
		ret = fimc_is_sr352_write8(client, regset->reg[i].addr, regset->reg[i].data);
		if (unlikely(!ret)) {
			err("regs set(addr 0x%08X, size %d) apply is fail(%d)",
				(u32)&regset->reg[i], regset->size, ret);
			goto p_err;
		}
	}

p_err:
	return ret;
}

static int sensor_sr352_s_capture_mode(struct v4l2_subdev *subdev, int value)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

p_err:
	return ret;
}

static int sensor_sr352_s_flash(struct v4l2_subdev *subdev, int value)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

p_err:
	return ret;
}

static int sensor_sr352_s_autofocus(struct v4l2_subdev *subdev)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

p_err:
	return ret;
}

static int sensor_sr352_init(struct v4l2_subdev *subdev, u32 val)
{
	int ret = 0;
	u8 id;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352->system_clock = 146 * 1000 * 1000;
	module_sr352->line_length_pck = 146 * 1000 * 1000;

	sensor_sr352_apply_set(client, &regset_table.init);
	sensor_sr352_apply_set(client, &regset_table.refresh_50h);
	sensor_sr352_apply_set(client, &regset_table.stop_stream);

	fimc_is_sr352_read8(client, 0x4, &id);

	info("[MOD:D] %s(ID%d, ID%d)\n", __func__, val, id);

p_err:
	return ret;
}

static int sensor_sr352_s_ctrl(struct v4l2_subdev *subdev, struct v4l2_control *ctrl)
{
	int ret = 0;

	switch (ctrl->id) {
	case V4L2_CID_SCENEMODE:
	case V4L2_CID_FOCUS_MODE:
	case V4L2_CID_WHITE_BALANCE_PRESET:
	case V4L2_CID_IMAGE_EFFECT:
	case V4L2_CID_CAM_ISO:
	case V4L2_CID_CAM_CONTRAST:
	case V4L2_CID_CAM_SATURATION:
	case V4L2_CID_CAM_SHARPNESS:
	case V4L2_CID_CAM_BRIGHTNESS:
	case V4L2_CID_CAM_METERING:
	case V4L2_CID_CAM_SET_AUTO_FOCUS:
	case V4L2_CID_CAM_OBJECT_POSITION_X:
	case V4L2_CID_CAM_OBJECT_POSITION_Y:
	case V4L2_CID_CAM_FACE_DETECTION:
	case V4L2_CID_CAM_WDR:
	case V4L2_CID_CAM_AUTO_FOCUS_RESULT:
	case V4L2_CID_JPEG_QUALITY:
	case V4L2_CID_CAM_AEAWB_LOCK_UNLOCK:
	case V4L2_CID_CAM_CAF_START_STOP:
	case V4L2_CID_CAM_ZOOM:
		err("invalid ioctl(0x%08X) is requested", ctrl->id);
		break;
	case V4L2_CID_CAM_SINGLE_AUTO_FOCUS:
		ret = sensor_sr352_s_autofocus(subdev);
		if (ret) {
			err("sensor_sr352_s_autofocus is fail(%d)", ret);
			goto p_err;
		}
		break;
	case V4L2_CID_CAPTURE:
		ret = sensor_sr352_s_capture_mode(subdev, ctrl->value);
		if (ret) {
			err("sensor_sr352_s_flash is fail(%d)", ret);
			goto p_err;
		}
		break;
	case V4L2_CID_CAM_FLASH_MODE:
		ret = sensor_sr352_s_flash(subdev, ctrl->value);
		if (ret) {
			err("sensor_sr352_s_flash is fail(%d)", ret);
			goto p_err;
		}
		break;
	default:
		err("invalid ioctl(0x%08X) is requested", ctrl->id);
		ret = -EINVAL;
		break;
	}

p_err:
	return ret;
}

static int sensor_sr352_g_ctrl(struct v4l2_subdev *subdev, struct v4l2_control *ctrl)
{
	int ret = 0;

	switch (ctrl->id) {
	case V4L2_CID_CAMERA_EXIF_EXPTIME:
		ctrl->value = 0;
		break;
	case V4L2_CID_CAMERA_EXIF_FLASH:
		ctrl->value = 0;
		break;
	case V4L2_CID_CAMERA_EXIF_ISO:
		ctrl->value = 0;
		break;
	case V4L2_CID_CAMERA_EXIF_TV:
		ctrl->value = 0;
		break;
	case V4L2_CID_CAMERA_EXIF_BV:
		ctrl->value = 0;
		break;
	default:
		err("invalid ioctl(0x%08X) is requested", ctrl->id);
		ret = -EINVAL;
		break;
	}

	return ret;
}

static const struct v4l2_subdev_core_ops core_ops = {
	.init		= sensor_sr352_init,
	.s_ctrl		= sensor_sr352_s_ctrl,
	.g_ctrl		= sensor_sr352_g_ctrl
};

static int sensor_sr352_s_format(struct v4l2_subdev *subdev, struct v4l2_mbus_framefmt *fmt)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);
	BUG_ON(!fmt);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!module) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352->image.window.offs_h = 0;
	module_sr352->image.window.offs_v = 0;
	module_sr352->image.window.width = fmt->width;
	module_sr352->image.window.height = fmt->height;
	module_sr352->image.window.o_width = fmt->width;
	module_sr352->image.window.o_height = fmt->height;
	module_sr352->image.format.pixelformat = fmt->code;

	info("[352] output size : %d x %d\n", fmt->width, fmt->height);

p_err:
	return ret;
}

static int sensor_sr352_s_stream(struct v4l2_subdev *subdev, int enable)
{
	int ret = 0;
	struct fimc_is_module_enum *module;

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!module) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	if (enable) {
		ret = CALL_MOPS(module, stream_on, subdev);
		if (ret) {
			err("stream_on is fail(%d)", ret);
			goto p_err;
		}
	} else {
		ret = CALL_MOPS(module, stream_off, subdev);
		if (ret) {
			err("stream_off is fail(%d)", ret);
			goto p_err;
		}
	}

p_err:
	return 0;
}

static int sensor_sr352_s_param(struct v4l2_subdev *subdev, struct v4l2_streamparm *param)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct v4l2_captureparm *cp;
	struct v4l2_fract *tpf;
	u64 framerate;

	BUG_ON(!subdev);
	BUG_ON(!param);

	cp = &param->parm.capture;
	tpf = &cp->timeperframe;

	if (!tpf->numerator) {
		err("numerator is 0");
		ret = -EINVAL;
		goto p_err;
	}

	framerate = tpf->denominator;

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!module) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	ret = CALL_MOPS(module, s_duration, subdev, framerate);
	if (ret) {
		err("s_duration is fail(%d)", ret);
		goto p_err;
	}

p_err:
	return ret;
}

static const struct v4l2_subdev_video_ops video_ops = {
	.s_stream = sensor_sr352_s_stream,
	.s_parm = sensor_sr352_s_param,
	.s_mbus_fmt = sensor_sr352_s_format
};

static const struct v4l2_subdev_ops subdev_ops = {
	.core = &core_ops,
	.video = &video_ops
};

int sensor_sr352_stream_on(struct v4l2_subdev *subdev)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;
	u32 width, height;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	width = module_sr352->image.window.width;
	height = module_sr352->image.window.height;

	if ((width == 640) && (height == 480)) {
		sensor_sr352_apply_set(client, &regset_table.resol_640_480);
	} else if ((width == 1024) && (height == 768)) {
		sensor_sr352_apply_set(client, &regset_table.resol_1024_768);
	} else if (((width == 1024) && (height == 576)) || ((width == 1280) && (height == 720))) {
		sensor_sr352_apply_set(client, &regset_table.resol_1024_576);
	} else {
		BUG();
	}

	info("[MOD:D] stream on\n");

p_err:
	return ret;
}

int sensor_sr352_stream_off(struct v4l2_subdev *subdev)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	sensor_sr352_apply_set(client, &regset_table.stop_stream);

	info("[4EC] stream off\n");

p_err:
	return ret;
}

/*
 * @ brief
 * frame duration time
 * @ unit
 * nano second
 * @ remarks
 */
int sensor_sr352_s_duration(struct v4l2_subdev *subdev, u64 duration)
{
	int ret = 0;
	u32 framerate;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_sr352 *module_sr352;
	struct i2c_client *client;

	BUG_ON(!subdev);

	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!module)) {
		err("module is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	module_sr352 = module->private_data;
	if (unlikely(!module_sr352)) {
		err("module_sr352 is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = module->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	framerate = duration;
	if (framerate > FRAME_RATE_MAX) {
		err("framerate is invalid(%d)", framerate);
		ret = -EINVAL;
		goto p_err;
	}

p_err:
	return ret;
}

int sensor_sr352_g_min_duration(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_g_max_duration(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_s_exposure(struct v4l2_subdev *subdev, u64 exposure)
{
	int ret = 0;
	u8 value;
	struct fimc_is_module_enum *sensor;
	struct i2c_client *client;

	BUG_ON(!subdev);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (unlikely(!sensor)) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	client = sensor->client;
	if (unlikely(!client)) {
		err("client is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	value = exposure & 0xFF;


p_err:
	return ret;
}

int sensor_sr352_g_min_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_g_max_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_s_again(struct v4l2_subdev *subdev, u64 sensitivity)
{
	int ret = 0;

	pr_info("%s\n", __func__);

	return ret;
}

int sensor_sr352_g_min_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_g_max_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_s_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_g_min_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

int sensor_sr352_g_max_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
	return ret;
}

struct fimc_is_sensor_ops module_sr352_ops = {
	.stream_on	= sensor_sr352_stream_on,
	.stream_off	= sensor_sr352_stream_off,
	.s_duration	= sensor_sr352_s_duration,
	.g_min_duration	= sensor_sr352_g_min_duration,
	.g_max_duration	= sensor_sr352_g_max_duration,
	.s_exposure	= sensor_sr352_s_exposure,
	.g_min_exposure	= sensor_sr352_g_min_exposure,
	.g_max_exposure	= sensor_sr352_g_max_exposure,
	.s_again	= sensor_sr352_s_again,
	.g_min_again	= sensor_sr352_g_min_again,
	.g_max_again	= sensor_sr352_g_max_again,
	.s_dgain	= sensor_sr352_s_dgain,
	.g_min_dgain	= sensor_sr352_g_min_dgain,
	.g_max_dgain	= sensor_sr352_g_max_dgain
};

int sensor_sr352_probe(struct i2c_client *client,
	const struct i2c_device_id *id)
{
	int ret = 0;
	struct fimc_is_core *core;
	struct v4l2_subdev *subdev_module;
	struct fimc_is_module_enum *module;
	struct fimc_is_device_sensor *device;

	BUG_ON(!fimc_is_dev);

	core = (struct fimc_is_core *)dev_get_drvdata(fimc_is_dev);
	if (!core) {
		err("core device is not yet probed");
		return -EPROBE_DEFER;
	}

	device = &core->sensor[SENSOR_SR352_INSTANCE];

	subdev_module = kzalloc(sizeof(struct v4l2_subdev), GFP_KERNEL);
	if (!subdev_module) {
		err("subdev_module is NULL");
		ret = -ENOMEM;
		goto p_err;
	}

	module = &device->module_enum[atomic_read(&core->resourcemgr.rsccount_module)];
	atomic_inc(&core->resourcemgr.rsccount_module);
	module->id = SENSOR_SR352_NAME;
	module->subdev = subdev_module;
	module->device = SENSOR_SR352_INSTANCE;
	module->ops = &module_sr352_ops;
	module->client = client;
	module->pixel_width = 1920 + 16;
	module->pixel_height = 1080 + 10;
	module->active_width = 1920;
	module->active_height = 1080;
	module->max_framerate = 30;
	module->position = SENSOR_POSITION_REAR;
	module->mode = CSI_MODE_VC_ONLY;
	module->lanes = CSI_DATA_LANES_4;
	module->vcis = ARRAY_SIZE(vci_sr352);
	module->vci = vci_sr352;
	module->setfile_name = "setfile_sr352.bin";
	module->cfgs = ARRAY_SIZE(settle_sr352);
	module->cfg = settle_sr352;
	module->private_data = kzalloc(sizeof(struct fimc_is_module_sr352), GFP_KERNEL);
	if (!module->private_data) {
		err("private_data is NULL");
		ret = -ENOMEM;
		kfree(subdev_module);
		goto p_err;
	}

#ifdef DEFAULT_S5K4EC_DRIVING
	v4l2_i2c_subdev_init(subdev_module, client, &subdev_ops);
#else
	v4l2_subdev_init(subdev_module, &subdev_ops);
#endif
	v4l2_set_subdevdata(subdev_module, module);
	v4l2_set_subdev_hostdata(subdev_module, device);
	snprintf(subdev_module->name, V4L2_SUBDEV_NAME_SIZE, "sensor-subdev.%d", module->id);

p_err:
	info("%s(%d)\n", __func__, ret);
	return ret;
}

static int sensor_sr352_remove(struct i2c_client *client)
{
	int ret = 0;
	return ret;
}

#ifdef CONFIG_OF
static const struct of_device_id exynos_fimc_is_sensor_sr352_match[] = {
	{
		.compatible = "samsung,exynos5-fimc-is-sensor-4ec",
	},
	{},
};
#endif

static const struct i2c_device_id sensor_sr352_idt[] = {
	{ SENSOR_NAME, 0 },
};

static struct i2c_driver sensor_sr352_driver = {
	.driver = {
		.name	= SENSOR_NAME,
		.owner	= THIS_MODULE,
#ifdef CONFIG_OF
		.of_match_table = exynos_fimc_is_sensor_sr352_match
#endif
	},
	.probe	= sensor_sr352_probe,
	.remove	= sensor_sr352_remove,
	.id_table = sensor_sr352_idt
};

static int __init sensor_sr352_load(void)
{
        return i2c_add_driver(&sensor_sr352_driver);
}

static void __exit sensor_sr352_unload(void)
{
        i2c_del_driver(&sensor_sr352_driver);
}

module_init(sensor_sr352_load);
module_exit(sensor_sr352_unload);

MODULE_AUTHOR("Gilyeon lim");
MODULE_DESCRIPTION("Sensor sr352 driver");
MODULE_LICENSE("GPL v2");
