/* linux/arch/arm/mach-exynos/pmu.c
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com/
 *
 * EXYNOS - CPU PMU(Power Management Unit) support
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/io.h>
#include <linux/cpumask.h>
#include <linux/kernel.h>
#include <linux/bug.h>
#include <linux/delay.h>
#include <linux/errno.h>
#include <linux/gpio.h>

#include <plat/gpio-cfg.h>

#include <mach/regs-clock.h>
#include <mach/regs-pmu.h>
#include <mach/pmu.h>
#include <asm/cputype.h>
#include <asm/smp_plat.h>

#define PMU_PREFIX	"PM DOMAIN: "

#ifndef pr_fmt
#define pr_fmt(fmt) fmt
#endif

#define PMU_DEBUG
#ifdef PMU_DEBUG
#define DEBUG_PRINT_INFO(fmt, ...) printk(PMU_PREFIX pr_fmt(fmt), ##__VA_ARGS__)
#else
#define DEBUG_PRINT_INFO(fmt, ...)
#endif

static struct exynos_pmu_conf *exynos_pmu_config;

static struct exynos_pmu_conf exynos4210_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS4_ARM_CORE0_LOWPWR,		{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE0,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL0,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE1_LOWPWR,		{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE1,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL1,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_COMMON_LOWPWR,		{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_L2_0_LOWPWR,			{ 0x2, 0x2, 0x3 } },
	{ EXYNOS4_L2_1_LOWPWR,			{ 0x2, 0x2, 0x3 } },
	{ EXYNOS4_CMU_ACLKSTOP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_SCLKSTOP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_APLL_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_MPLL_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_VPLL_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_EPLL_SYSCLK_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_ALIVE_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPSALIVE_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_CAM_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_TV_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MFC_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_G3D_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_LCD0_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4210_CMU_CLKSTOP_LCD1_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MAUDIO_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_CAM_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_TV_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_MFC_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_G3D_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_LCD0_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4210_CMU_RESET_LCD1_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_MAUDIO_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPS_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_TOP_BUS_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_TOP_RETENTION_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_TOP_PWR_LOWPWR,		{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4_LOGIC_RESET_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_ONENAND_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4210_MODIMIF_MEM_LOWPWR,	{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_G2D_ACP_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_USBOTG_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_HSMMC_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_CSSYS_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_SECSS_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4210_PCIE_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4210_SATA_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_DRAM_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MAUDIO_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_GPIO_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_UART_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCA_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCB_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIA_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIB_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ISOLATION_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ALV_SEL_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_XUSBXTI_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_XXTI_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_EXT_REGULATOR_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_GPIO_MODE_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_GPIO_MODE_MAUDIO_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CAM_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_TV_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MFC_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_G3D_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_LCD0_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4210_LCD1_LOWPWR,		{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MAUDIO_LOWPWR,		{ 0x7, 0x7, 0x0 } },
	{ EXYNOS4_GPS_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_GPS_ALIVE_LOWPWR,		{ 0x7, 0x0, 0x0 } },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos4412_pmu_config[] = {
	{ EXYNOS4_ARM_CORE0_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_ARM_CORE1_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_ARM_CORE2_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_ARM_CORE3_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4X12_ISP_ARM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_LOCAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_CENTRAL_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_ARM_COMMON_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_L2_0_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_0_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_L2_1_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_1_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_CMU_ACLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_SCLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_CMU_ACLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SCLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_COREBLK_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_APLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_MPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_VPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_EPLL_SYSCLK_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_MPLLUSER_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_ALIVE_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPSALIVE_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_CAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_TV_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MFC_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_G3D_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_CLKSTOP_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MAUDIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_CAM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_TV_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MFC_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_G3D_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_ISP_LOWPWR,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MAUDIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPS_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_TOP_BUS_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_TOP_RETENTION_LOWPWR,			{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_TOP_PWR_LOWPWR,			{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4X12_TOP_BUS_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_TOP_RETENTION_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_TOP_PWR_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4_LOGIC_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_OSCCLK_GATE_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_LOGIC_RESET_COREBLK_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_OSCCLK_GATE_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_HSI_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_HSI_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_G2D_ACP_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_G2D_ACP_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_USBOTG_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_USBOTG_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_HSMMC_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_HSMMC_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_CSSYS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_CSSYS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_SECSS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_SECSS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4X12_ROTATOR_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_ROTATOR_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_DRAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_GPIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_UART_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_PAD_RETENTION_GPIO_COREBLK_LOWPWR, { 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ISOLATION_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_PAD_ISOLATION_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ALV_SEL_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_XUSBXTI_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_XXTI_LOWPWR,				{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_EXT_REGULATOR_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_GPIO_MODE_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_GPIO_MODE_COREBLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_GPIO_MODE_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_TOP_ASB_RESET_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_TOP_ASB_ISOLATION_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_CAM_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_TV_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MFC_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_G3D_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_LCD0_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4X12_ISP_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MAUDIO_LOWPWR,			{ 0x7, 0x7, 0x0 } },
	{ EXYNOS4_GPS_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_GPS_ALIVE_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SYSCLK_ISP_LOWPWR,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SYSCLK_GPS_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos4415_pmu_config[] = {
	{ EXYNOS4_ARM_CORE0_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE1_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE1,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL1,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE2_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE2,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL2,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE3_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE3,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL3,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_ISP_ARM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_LOCAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_CENTRAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_COMMON_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_L2_0_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_0_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_L2_1_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_1_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_CMU_ACLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_SCLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_DRAM_FREQ_DOWN_SYS_PWR_REG,	{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4415_DDRPHY_DLLOFF_SYS_PWR_REG,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4415_DDRPHY_DLLLOCK_SYS_PWR_REG,	{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4415_CMU_ACLKSTOP_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_SCLKSTOP_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_COREBLK_SYS_PWR_REG,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_APLL_SYSCLK_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_MPLL_SYSCLK_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_BPLL_SYSCLK_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_VPLL_SYSCLK_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_EPLL_SYSCLK_SYS_PWR_REG,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_ISP_PLL_SYSCLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_DISP_PLL_SYSCLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_MPLLUSER_SYSCLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_BPLLUSER_SYSCLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_CAM_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_TV_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_MFC_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_G3D_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_LCD0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_ISP0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_ISP1_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_CLKSTOP_MAUDIO_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_CAM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_TV_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_MFC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_G3D_SYS_PWR_REG,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_LCD0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_ISP0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_ISP1_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_RESET_MAUDIO_SYS_PWR_REG,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_TOP_BUS_SYS_PWR_REG,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_TOP_RETENTION_SYS_PWR_REG,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4415_TOP_PWR_SYS_PWR_REG,		{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4415_TOP_BUS_COREBLK_SYS_PWR_REG,	{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_TOP_RETENTION_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4415_TOP_PWR_COREBLK_SYS_PWR_REG,	{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4415_LOGIC_RESET_SYS_PWR_REG,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_OSCCLK_GATE_SYS_PWR_REG,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4415_LOGIC_RESET_COREBLK_SYS_PWR_REG,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_OSCCLK_GATE_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4415_G2D_ACP_MEM_SYS_PWR_REG,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_G2D_ACP_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4415_USBOTG_MEM_SYS_PWR_REG,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_USBOTG_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4415_CSSYS_MEM_SYS_PWR_REG,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_CSSYS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4415_SECSS_MEM_SYS_PWR_REG,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4415_SECSS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4415_IRAM_MEM_SYS_PWR_REG,		{ 0x3, 0x3, 0x0 } },
	{ EXYNOS4415_IRAM_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_DRAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_GPIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_UART_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_PAD_RETENTION_MMC0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_PAD_RETENTION_MMC1_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_PAD_RETENTION_MMC2_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_PAD_RETENTION_SPI_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_PAD_RETENTION_JTAG_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ISOLATION_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ALV_SEL_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_XUSBXTI_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_EXT_REGULATOR_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_GPIO_MODE_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_GPIO_MODE_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_TOP_ASB_RESET_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_TOP_ASB_ISOLATION_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4415_TOP_ASB_RESET_COREBLK_SYS_PWR_REG,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4415_TOP_ASB_ISOLATION_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CAM_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_TV_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_MFC_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_G3D_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_LCD0_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_ISP0_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_ISP1_SYS_PWR_REG,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4415_MAUDIO_SYS_PWR_REG,		{ 0x7, 0x7, 0x0 } },
	{ EXYNOS4415_CMU_SYSCLK_ISP0_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4415_CMU_SYSCLK_ISP1_SYS_PWR_REG,	{ 0x1, 0x0, 0x0 } },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos4212_pmu_config[] = {
	{ EXYNOS4_ARM_CORE0_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE1_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE1,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL1,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_ISP_ARM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_LOCAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_CENTRAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_COMMON_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_L2_0_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	/* XXX_OPTION register should be set other field */
	{ EXYNOS4X12_ARM_L2_0_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_L2_1_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_1_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_CMU_ACLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_SCLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_DRAM_FREQ_DOWN_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_DDRPHY_DLLOFF_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_LPDDR_PHY_DLL_LOCK_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_CMU_ACLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SCLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_COREBLK_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_APLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_MPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_VPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_EPLL_SYSCLK_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_MPLLUSER_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_ALIVE_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPSALIVE_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_CAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_TV_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MFC_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_G3D_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_CLKSTOP_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MAUDIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_GPS_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_CAM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_TV_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MFC_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_G3D_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_ISP_LOWPWR,		{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CMU_RESET_GPS_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_TOP_BUS_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_TOP_RETENTION_LOWPWR,			{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_TOP_PWR_LOWPWR,			{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4X12_TOP_BUS_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_TOP_RETENTION_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_TOP_PWR_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4_LOGIC_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_OSCCLK_GATE_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_LOGIC_RESET_COREBLK_LOWPWR,	{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_OSCCLK_GATE_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_ONENAND_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_ONENAND_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4X12_HSI_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_HSI_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_G2D_ACP_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_G2D_ACP_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_USBOTG_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_USBOTG_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_HSMMC_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_HSMMC_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_CSSYS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_CSSYS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_SECSS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_SECSS_MEM_OPTION,			{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4X12_ROTATOR_MEM_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_ROTATOR_MEM_OPTION,		{ 0x10, 0x10, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_DRAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_GPIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_UART_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_PAD_RETENTION_GPIO_COREBLK_LOWPWR, { 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ISOLATION_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_PAD_ISOLATION_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ALV_SEL_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_XUSBXTI_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_XXTI_LOWPWR,				{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_EXT_REGULATOR_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_GPIO_MODE_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_GPIO_MODE_COREBLK_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_GPIO_MODE_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_TOP_ASB_RESET_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_TOP_ASB_ISOLATION_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_CAM_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_TV_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MFC_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_G3D_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_LCD0_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4X12_ISP_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MAUDIO_LOWPWR,			{ 0x7, 0x7, 0x0 } },
	{ EXYNOS4_GPS_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_GPS_ALIVE_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SYSCLK_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SYSCLK_GPS_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos4270_pmu_config[] = {
	{ EXYNOS4_ARM_CORE0_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL0,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE1_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE1,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL1,			{ 0x0, 0x0, 0x0 } },
#ifdef CONFIG_SOC_EXYNOS3470
	{ EXYNOS4_ARM_CORE2_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE2,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL2,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_CORE3_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_DIS_IRQ_CORE3,			{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_DIS_IRQ_CENTRAL3,			{ 0x0, 0x0, 0x0 } },
#endif
	{ EXYNOS4X12_ISP_ARM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_LOCAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4X12_DIS_IRQ_ISP_ARM_CENTRAL_LOWPWR,	{ 0x0, 0x0, 0x0 } },
	{ EXYNOS4_ARM_COMMON_LOWPWR,			{ 0x0, 0x0, 0x2 } },
	{ EXYNOS4_L2_0_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_0_OPTION,			{ 0x1, 0x1, 0x0 } },
#ifdef CONFIG_SOC_EXYNOS4270
	{ EXYNOS4_L2_1_LOWPWR,				{ 0x0, 0x0, 0x3 } },
	{ EXYNOS4X12_ARM_L2_1_OPTION,			{ 0x1, 0x1, 0x0 } },
#endif
	{ EXYNOS4_CMU_ACLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_SCLKSTOP_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_DRAM_FREQ_DOWN_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_DDRPHY_DLLOFF_LOWPWR,		{ 0x1, 0x1, 0x1 } },
	{ EXYNOS4X12_LPDDR_PHY_DLL_LOCK_LOWPWR,		{ 0x1, 0x0, 0x1 } }, /* LPM3 */
	{ EXYNOS4X12_CMU_ACLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_SCLKSTOP_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_COREBLK_LOWPWR,		{ 0x1, 0x1, 0x0 } }, /* LPM3 */
	{ EXYNOS4_APLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_MPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4270_BPLL_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
	{ EXYNOS4_VPLL_SYSCLK_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_EPLL_SYSCLK_LOWPWR,			{ 0x1, 0x1, 0x0 } },
#ifdef CONFIG_SOC_EXYNOS4270
	{ EXYNOS4270_MPHY_PLL_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
#endif
	{ EXYNOS4X12_MPLLUSER_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* LPM3 */
	{ EXYNOS4270_BPLLUSER_SYSCLK_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* LPM3 */
	{ EXYNOS4_CMU_CLKSTOP_CAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_TV_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MFC_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_G3D_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_CLKSTOP_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_CLKSTOP_MAUDIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_CAM_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_TV_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MFC_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_G3D_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_LCD0_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4X12_CMU_RESET_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_CMU_RESET_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_TOP_BUS_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4_TOP_RETENTION_LOWPWR,			{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4_TOP_PWR_LOWPWR,			{ 0x3, 0x0, 0x3 } },
	{ EXYNOS4X12_TOP_BUS_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_TOP_RETENTION_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } }, /* LPM3 */
	{ EXYNOS4X12_TOP_PWR_COREBLK_LOWPWR,		{ 0x3, 0x0, 0x3 } }, /* LPM3 */
	{ EXYNOS4_LOGIC_RESET_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_OSCCLK_GATE_LOWPWR,		{ 0x1, 0x0, 0x1 } },
	{ EXYNOS4X12_LOGIC_RESET_COREBLK_LOWPWR,	{ 0x1, 0x1, 0x0 } }, /* LPM3 */
	{ EXYNOS4X12_OSCCLK_GATE_COREBLK_LOWPWR,	{ 0x1, 0x0, 0x1 } }, /* LPM3 */
	{ EXYNOS4_G2D_ACP_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_G2D_ACP_MEM_OPTION,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_USBOTG_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_USBOTG_MEM_OPTION,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_CSSYS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_CSSYS_MEM_OPTION,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_SECSS_MEM_LOWPWR,			{ 0x3, 0x0, 0x0 } },
	{ EXYNOS4X12_SECSS_MEM_OPTION,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4270_IRAM_MEM_LOWPWR,			{ 0x3, 0x3, 0x0 } }, /* 4270 */
	{ EXYNOS4270_IRAM_MEM_OPTION,			{ 0x1, 0x1, 0x0 } }, /* 4270 */
	{ EXYNOS4_PAD_RETENTION_DRAM_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_GPIO_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_UART_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_MMCB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4270_PAD_RETENTION_MMC2_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
	{ EXYNOS4270_PAD_RETENTION_MMC3_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
	{ EXYNOS4270_PAD_RETENTION_SPI_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
	{ EXYNOS4_PAD_RETENTION_EBIA_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_EBIB_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4270_PAD_RETENTION_JTAG_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* 4270 */
	{ EXYNOS4_PAD_RETENTION_ISOLATION_LOWPWR,	{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_PAD_RETENTION_ALV_SEL_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_XUSBXTI_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_XXTI_LOWPWR,				{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4_EXT_REGULATOR_LOWPWR,			{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4270_EXT_REGULATOR_COREBLK_LOWPWR,	{ 0x1, 0x1, 0x0 } }, /* LPM3 */
	{ EXYNOS4_GPIO_MODE_LOWPWR,			{ 0x1, 0x0, 0x0 } },
	{ EXYNOS4_GPIO_MODE_MAUDIO_LOWPWR,		{ 0x1, 0x1, 0x0 } },
	{ EXYNOS4X12_TOP_ASB_RESET_LOWPWR,		{ 0x1, 0x1, 0x0 } }, /* LPM3 */
	{ EXYNOS4X12_TOP_ASB_ISOLATION_LOWPWR,		{ 0x1, 0x0, 0x0 } }, /* LPM3 */
	{ EXYNOS4270_TOP_ASB_RESET_COREBLK_LOWPWR,	{ 0x1, 0x1, 0x0 } }, /* LPM3 */
	{ EXYNOS4270_TOP_ASB_ISOLATION_COREBLK_LOWPWR,  { 0x1, 0x0, 0x0 } }, /* LPM3 */
	{ EXYNOS4_CAM_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_TV_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MFC_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_G3D_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_LCD0_LOWPWR,				{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4X12_ISP_LOWPWR,			{ 0x7, 0x0, 0x0 } },
	{ EXYNOS4_MAUDIO_LOWPWR,			{ 0x7, 0x7, 0x0 } },
	{ EXYNOS4X12_CMU_SYSCLK_ISP_LOWPWR,		{ 0x1, 0x0, 0x0 } },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos5250_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS5_ARM_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x2} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_ARM_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x2} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_FSYS_ARM_SYS_PWR_REG,				{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_FSYS_ARM_CENTRAL_SYS_PWR_REG,		{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_ISP_ARM_SYS_PWR_REG,				{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_ARM_COMMON_SYS_PWR_REG,			{ 0x0, 0x0, 0x2} },
	{ EXYNOS5_ARM_L2_SYS_PWR_REG,				{ 0x0, 0x0, 0x3} },
	{ EXYNOS5_CMU_ACLKSTOP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SCLKSTOP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_ACLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SCLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_DRAM_FREQ_DOWN_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_DDRPHY_DLLOFF_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_DDRPHY_DLLLOCK_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_APLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_MPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_VPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_EPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_BPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_GPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_MPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_BPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_TOP_BUS_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_TOP_RETENTION_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_TOP_PWR_SYS_PWR_REG,				{ 0x3, 0x0, 0x3} },
	{ EXYNOS5_TOP_BUS_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_TOP_RETENTION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_TOP_PWR_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x3} },
	{ EXYNOS5_LOGIC_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_OSCCLK_GATE_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_LOGIC_RESET_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_OSCCLK_GATE_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_USBOTG_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_G2D_MEM_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_USBDRD_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_SDMMC_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_CSSYS_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_SECSS_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_ROTATOR_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_INTRAM_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_INTROM_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_JPEG_MEM_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_HSI_MEM_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_MCUIOP_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_SATA_MEM_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_DRAM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_MAU_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_PAD_RETENTION_GPIO_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_UART_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_MMCA_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_MMCB_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_EBIA_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_EBIB_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_SPI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_GPIO_SYSMEM_SYS_PWR_REG,	{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_ISOLATION_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_ISOLATION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_ALV_SEL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_XUSBXTI_SYS_PWR_REG,				{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_XXTI_SYS_PWR_REG,				{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_EXT_REGULATOR_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_GPIO_MODE_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_GPIO_MODE_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_GPIO_MODE_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_TOP_ASB_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_TOP_ASB_ISOLATION_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_GSCL_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} },
	{ EXYNOS5_ISP_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} },
	{ EXYNOS5_MFC_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} },
	{ EXYNOS5_G3D_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} },
	{ EXYNOS5_DISP1_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} },
	{ EXYNOS5_MAU_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_ISP_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_DISP1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_ISP_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_DISP1_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_RESET_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_ISP_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_DISP1_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos5410_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS5_ARM_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_ARM_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_ARM_CORE2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE2_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE2_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_ARM_CORE3_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE3_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE3_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE0_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE1_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_CORE2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE2_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE2_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_CORE3_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE3_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE3_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_ISP_ARM_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG,	{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_ARM_COMMON_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_COMMON_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_ARM_L2_SYS_PWR_REG,			        { 0x0, 0x0, 0x0} },
	{ EXYNOS54XX_KFC_L2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_ACLKSTOP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SCLKSTOP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_ACLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SCLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_DRAM_FREQ_DOWN_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_DDRPHY_DLLOFF_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_DDRPHY_DLLLOCK_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_APLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_MPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_VPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_EPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_BPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_DPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_IPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_KPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_MPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_BPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_TOP_BUS_SYS_PWR_REG,			        { 0x3, 0x0, 0x0} },
	{ EXYNOS5_TOP_RETENTION_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_TOP_PWR_SYS_PWR_REG,			        { 0x3, 0x3, 0x0} },
	{ EXYNOS5_TOP_BUS_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_TOP_RETENTION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_TOP_PWR_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} },
	{ EXYNOS5_LOGIC_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_OSCCLK_GATE_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} },
	{ EXYNOS5_LOGIC_RESET_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_OSCCLK_GATE_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} },
	{ EXYNOS5410_ONENANDXL_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5_G2D_MEM_SYS_PWR_REG,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_USBDEV_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5410_USBDEV1_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5410_SDMMC_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_CSSYS_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_SECSS_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_ROTATOR_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5410_INTRAM_MEM_SYS_PWR,			{ 0x3, 0x0, 0x3} },
	{ EXYNOS5410_INTROM_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5410_JPEG_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_SFMC0_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_SFMC1_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_HSI_MEM_SYS_PWR,			        { 0x3, 0x3, 0x3} },
	{ EXYNOS5410_MCUIOP_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ EXYNOS5_PAD_RETENTION_DRAM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_RETENTION_MAU_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} },
	{ EXYNOS5410_PAD_RETENTION_GPIO_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_UART_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_MMC0_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_MMC1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_MMC2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_HSI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_EBIA_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_EBIB_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_SPI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS54XX_PAD_RETENTION_GPIO_COREBLK_SYS_PWR_REG,	{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_ISOLATION_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_PAD_ISOLATION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_PAD_ALV_SEL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_XUSBXTI_SYS_PWR_REG,			        { 0x1, 0x1, 0x0} },
	{ EXYNOS5_XXTI_SYS_PWR_REG,			        { 0x1, 0x1, 0x0} },
	{ EXYNOS5_EXT_REGULATOR_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_GPIO_MODE_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_GPIO_MODE_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_GPIO_MODE_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_TOP_ASB_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_TOP_ASB_ISOLATION_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_GSCL_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5_ISP_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5_MFC_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5_G3D_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5410_DISP0_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5_DISP1_SYS_PWR_REG,			        { 0x7, 0x0, 0x0} },
	{ EXYNOS5_MAU_SYS_PWR_REG,			        { 0x7, 0x7, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_ISP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5410_CMU_CLKSTOP_DISP0_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_DISP1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_CLKSTOP_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_ISP_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5410_CMU_SYSCLK_DISP0_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_DISP1_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_SYSCLK_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ EXYNOS5_CMU_RESET_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_ISP_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5410_CMU_RESET_DISP0_SYS_PWR,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_DISP1_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} },
	{ EXYNOS5_CMU_RESET_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos5410_rev21_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS5_TOP_RETENTION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x1, 0x1} },
	{ EXYNOS5_TOP_PWR_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x3, 0x0} },
	{ EXYNOS5410_INTRAM_MEM_SYS_PWR,			{ 0x3, 0x3, 0x3} },
	{ PMU_TABLE_END,},
};

static struct exynos_pmu_conf exynos5420_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS5_ARM_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1000 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} }, /* 0x1004_1004 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1008 */
	{ EXYNOS5_ARM_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1010 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} }, /* 0x1004_1014 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1018 */
	{ EXYNOS54XX_ARM_CORE2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1020 */
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE2_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1024 */
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE2_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1028 */
	{ EXYNOS54XX_ARM_CORE3_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1030 */
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE3_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1034 */
	{ EXYNOS54XX_DIS_IRQ_ARM_CORE3_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1038 */
	{ EXYNOS54XX_KFC_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1040 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE0_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1044 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1048 */
	{ EXYNOS54XX_KFC_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1050 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE1_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1054 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1058 */
	{ EXYNOS54XX_KFC_CORE2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1060 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE2_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1064 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE2_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1068 */
	{ EXYNOS54XX_KFC_CORE3_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_1070 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE3_LOCAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1074 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE3_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 0x1004_1078 */
	{ EXYNOS54XX_ISP_ARM_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1090 */
	{ EXYNOS54XX_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1094 */
	{ EXYNOS54XX_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG,	{ 0x1, 0x0, 0x0} }, /* 0x1004_1098 */
	{ EXYNOS54XX_ARM_COMMON_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_10A0 */
	{ EXYNOS54XX_KFC_COMMON_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_10B0 */
	{ EXYNOS5_ARM_L2_SYS_PWR_REG,				{ 0x0, 0x0, 0x0} }, /* 0x1004_10C0 */
	{ EXYNOS54XX_KFC_L2_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 0x1004_10D0 */
	{ EXYNOS5420_CMU_CPU_ACLKSTOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_10E0 */
	{ EXYNOS5420_CMU_CPU_SCLKSTOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_10E4 */
	{ EXYNOS5420_CMU_KFC_ACLKSTOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_10F0 */
	{ EXYNOS5_CMU_ACLKSTOP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1100 */
	{ EXYNOS5_CMU_SCLKSTOP_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} }, /* 0x1004_1104 */
	{ EXYNOS5_CMU_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_110C */
	{ EXYNOS5_CMU_ACLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1120 */
	{ EXYNOS5_CMU_SCLKSTOP_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 0x1004_1124 */
	{ EXYNOS5_CMU_RESET_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_112C */
	{ EXYNOS5_DRAM_FREQ_DOWN_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} }, /* 0x1004_1130 */
	{ EXYNOS5_DDRPHY_DLLOFF_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} }, /* 0x1004_1134 */
	{ EXYNOS5_DDRPHY_DLLLOCK_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} }, /* 0x1004_1138 */
	{ EXYNOS5_APLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1140 */
	{ EXYNOS5_MPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1144 */
	{ EXYNOS5_VPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1148 */
	{ EXYNOS5_EPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_114C */
	{ EXYNOS5_BPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1150 */
	{ EXYNOS5_CPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1154 */
	{ EXYNOS54XX_DPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1158 */
	{ EXYNOS54XX_IPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_115C */
	{ EXYNOS54XX_KPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1160 */
	{ EXYNOS5_MPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1164 */
	{ EXYNOS5_BPLLUSER_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1170 */
	{ EXYNOS5420_RPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1174 */
	{ EXYNOS5420_SPLL_SYSCLK_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1178 */
	{ EXYNOS5_TOP_BUS_SYS_PWR_REG,				{ 0x3, 0x0, 0x0} }, /* 0x1004_1180 */
	{ EXYNOS5_TOP_RETENTION_SYS_PWR_REG,			{ 0x1, 0x1, 0x1} }, /* 0x1004_1184 */
	{ EXYNOS5_TOP_PWR_SYS_PWR_REG,				{ 0x3, 0x3, 0x0} }, /* 0x1004_1188 */
	{ EXYNOS5_TOP_BUS_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} }, /* 0x1004_1190 */
	{ EXYNOS5_TOP_RETENTION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 0x1004_1194 EVT1 */
	{ EXYNOS5_TOP_PWR_SYSMEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} }, /* 0x1004_1198 EVT1 */
	{ EXYNOS5_LOGIC_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_11A0 */
	{ EXYNOS5_OSCCLK_GATE_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} }, /* 0x1004_11A4 */
	{ EXYNOS5_LOGIC_RESET_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_11B0 EVT1 */
	{ EXYNOS5_OSCCLK_GATE_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_11B4 */
	{ EXYNOS5420_INTRAM_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x3} }, /* 0x1004_11B8 EVT1 */
	{ EXYNOS5420_INTROM_MEM_SYS_PWR_REG,			{ 0x3, 0x0, 0x3} }, /* 0x1004_11BC EVT1 */
	{ EXYNOS5_PAD_RETENTION_DRAM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1200 */
	{ EXYNOS5_PAD_RETENTION_MAU_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 0x1004_1204 */
	{ EXYNOS5420_PAD_RETENTION_JTAG_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 0x1004_1208 */
	{ EXYNOS5420_PAD_RETENTION_DRAM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1210 */
	{ EXYNOS54XX_PAD_RETENTION_UART_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1214 */
	{ EXYNOS54XX_PAD_RETENTION_MMC0_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1218 */
	{ EXYNOS54XX_PAD_RETENTION_MMC1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_121C */
	{ EXYNOS54XX_PAD_RETENTION_MMC2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1220 */
	{ EXYNOS54XX_PAD_RETENTION_HSI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1224 */
	{ EXYNOS54XX_PAD_RETENTION_EBIA_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1228 */
	{ EXYNOS54XX_PAD_RETENTION_EBIB_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_122C */
	{ EXYNOS54XX_PAD_RETENTION_SPI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1230 */
	{ EXYNOS54XX_PAD_RETENTION_DRAM_SYSMEM_SYS_PWR_REG,	{ 0x1, 0x0, 0x0} }, /* 0x1004_1234 EVT1 */
	{ EXYNOS5_PAD_ISOLATION_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_1240 */
	{ EXYNOS5_PAD_ISOLATION_SYSMEM_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1250 EVT1 */
	{ EXYNOS5_PAD_ALV_SEL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1260 */
	{ EXYNOS5_XUSBXTI_SYS_PWR_REG,				{ 0x1, 0x1, 0x0} }, /* 0x1004_1280 */
	{ EXYNOS5_XXTI_SYS_PWR_REG,				{ 0x1, 0x1, 0x0} }, /* 0x1004_1284 */
	{ EXYNOS5_EXT_REGULATOR_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_12C0 */
	{ EXYNOS5_GPIO_MODE_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1300 */
	{ EXYNOS5_GPIO_MODE_SYSMEM_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_1320 */
	{ EXYNOS5_GPIO_MODE_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_1340 */
	{ EXYNOS5_TOP_ASB_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_1344 */
	{ EXYNOS5_TOP_ASB_ISOLATION_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1348 */
	{ EXYNOS5_GSCL_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_1400 */
	{ EXYNOS5_ISP_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_1404 */
	{ EXYNOS5_MFC_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_1408 */
	{ EXYNOS5_G3D_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_140C */
	{ EXYNOS5420_DISP1_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_1410 */
	{ EXYNOS5420_MAU_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_1414 */
	{ EXYNOS5420_G2D_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_1418 */
	{ EXYNOS5420_MSC_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_141C */
	{ EXYNOS5420_FSYS_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_1420 */
	{ EXYNOS5420_FSYS2_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_1424 */
	{ EXYNOS5420_PSGEN_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_1428 */
	{ EXYNOS5420_PERIC_SYS_PWR_REG,				{ 0x7, 0x7, 0x0} }, /* 0x1004_142C */
	{ EXYNOS5420_WCORE_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 0x1004_1430 */
	{ EXYNOS5_CMU_CLKSTOP_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1480 */
	{ EXYNOS5_CMU_CLKSTOP_ISP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1484 */
	{ EXYNOS5_CMU_CLKSTOP_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1488 */
	{ EXYNOS5_CMU_CLKSTOP_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_148C */
	{ EXYNOS5420_CMU_CLKSTOP_DISP1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1490 */
	{ EXYNOS5420_CMU_CLKSTOP_MAU_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 0x1004_1494 */
	{ EXYNOS5420_CMU_CLKSTOP_G2D_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1498 */
	{ EXYNOS5420_CMU_CLKSTOP_MSC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_149C */
	{ EXYNOS5420_CMU_CLKSTOP_FSYS_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14A0 */
	{ EXYNOS5420_CMU_CLKSTOP_FSYS2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14A4 */
	{ EXYNOS5420_CMU_CLKSTOP_PSGEN_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14A8 */
	{ EXYNOS5420_CMU_CLKSTOP_PERIC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14AC */
	{ EXYNOS5420_CMU_CLKSTOP_WCORE_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14B0 */
	{ EXYNOS5_CMU_SYSCLK_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_14C0 */
	{ EXYNOS5_CMU_SYSCLK_ISP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_14C4 */
	{ EXYNOS5_CMU_SYSCLK_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_14C8 */
	{ EXYNOS5_CMU_SYSCLK_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_14CC */
	{ EXYNOS5420_CMU_SYSCLK_DISP1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14D0 */
	{ EXYNOS5420_CMU_SYSCLK_MAU_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 0x1004_14D4 */
	{ EXYNOS5420_CMU_SYSCLK_G2D_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14D8 */
	{ EXYNOS5420_CMU_SYSCLK_MSC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14DC */
	{ EXYNOS5420_CMU_SYSCLK_FSYS_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14E0 */
	{ EXYNOS5420_CMU_SYSCLK_FSYS2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14E4 */
	{ EXYNOS5420_CMU_SYSCLK_PSGEN_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14E8 */
	{ EXYNOS5420_CMU_SYSCLK_PERIC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14EC */
	{ EXYNOS5420_CMU_SYSCLK_WCORE_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_14F0 */
	{ EXYNOS5420_CMU_RESET_FSYS2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1570 */
	{ EXYNOS5420_CMU_RESET_PSGEN_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1574 */
	{ EXYNOS5420_CMU_RESET_PERIC_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1578 */
	{ EXYNOS5420_CMU_RESET_WCORE_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_157C */
	{ EXYNOS5_CMU_RESET_GSCL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1580 */
	{ EXYNOS5_CMU_RESET_ISP_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1584 */
	{ EXYNOS5_CMU_RESET_MFC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1588 */
	{ EXYNOS5_CMU_RESET_G3D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_158C */
	{ EXYNOS5420_CMU_RESET_DISP1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_1590 */
	{ EXYNOS5420_CMU_RESET_MAU_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 0x1004_1594 */
	{ EXYNOS5420_CMU_RESET_G2D_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_1598 */
	{ EXYNOS5420_CMU_RESET_MSC_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 0x1004_159C */
	{ EXYNOS5420_CMU_RESET_FSYS_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 0x1004_15A0 */
	{ PMU_TABLE_END,},
};

#ifdef CONFIG_SOC_EXYNOS5260
static struct exynos_pmu_conf exynos5260_pmu_config[] = {
	/* { .reg = address, .val = { AFTR, LPA, SLEEP } */
	{ EXYNOS5_ARM_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1000 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1008 */
	{ EXYNOS5_ARM_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1010 */
	{ EXYNOS5_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1018 */
	{ EXYNOS54XX_KFC_CORE0_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1040 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE0_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1048 */
	{ EXYNOS54XX_KFC_CORE1_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1050 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE1_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1058 */
	{ EXYNOS54XX_KFC_CORE2_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1060 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE2_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1068 */
	{ EXYNOS54XX_KFC_CORE3_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1070 */
	{ EXYNOS54XX_DIS_IRQ_KFC_CORE3_CENTRAL_SYS_PWR_REG,	{ 0x0, 0x0, 0x0} }, /* 1078 */
	{ EXYNOS5260_EAGLE_NONCPU_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1080 */
	{ EXYNOS5260_KFC_NONCPU_SYS_PWR_REG,			{ 0x0, 0x0, 0x8} }, /* 1084 */
	{ EXYNOS5260_A5IS_SYS_PWR_REG,				{ 0x0, 0x0, 0x0} }, /* 10B0 */
	{ EXYNOS5260_DIS_IRQ_A5IS_LOCAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} }, /* 10B4 */
	{ EXYNOS5260_DIS_IRQ_A5IS_CENTRAL_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} }, /* 10B8 */
	{ EXYNOS5_ARM_L2_SYS_PWR_REG,				{ 0x0, 0x0, 0x7} }, /* 10C0 */
	{ EXYNOS5260_KFC_L2_SYS_PWR_REG,			{ 0x0, 0x0, 0x7} }, /*_10C4 */
	{ EXYNOS5260_CLKSTOP_CMU_TOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 1100 */
	{ EXYNOS5260_CLKRUN_CMU_TOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1104 */
	{ EXYNOS5260_RESET_CMU_TOP_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 110C */
	{ EXYNOS5260_RESET_CPUCLKSTOP_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 111C */
	{ EXYNOS5260_CLKSTOP_CMU_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 1120 */
	{ EXYNOS5260_CLKRUN_CMU_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1124 */
	{ EXYNOS5260_RESET_CMU_MIF_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 112C */
	{ EXYNOS5_DDRPHY_DLLLOCK_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 1138 */
	{ EXYNOS5260_DISABLE_PLL_CMU_TOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1140 */
	{ EXYNOS5260_DISABLE_PLL_AUD_PLL_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 1144 */
	{ EXYNOS5260_DISABLE_PLL_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1160 */
	{ EXYNOS5_TOP_BUS_SYS_PWR_REG,				{ 0x7, 0x0, 0x0} }, /* 1180 */
	{ EXYNOS5_TOP_RETENTION_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} }, /* 1184 */
	{ EXYNOS5_TOP_PWR_SYS_PWR_REG,				{ 0x3, 0x0, 0x3} }, /* 1188 */
	{ EXYNOS5260_TOP_BUS_MIF_SYS_PWR_REG,			{ 0x7, 0x0, 0x0} }, /* 1190 */
	{ EXYNOS5260_TOP_RETENTION_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 1194 */
	{ EXYNOS5260_TOP_PWR_MIF_SYS_PWR_REG,			{ 0x3, 0x0, 0x3} }, /* 1198 */
	{ EXYNOS5_LOGIC_RESET_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 11A0 */
	{ EXYNOS5_OSCCLK_GATE_SYS_PWR_REG,			{ 0x1, 0x0, 0x1} }, /* 11A4 */
	{ EXYNOS5260_SLEEP_RESET_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 11A8 */
	{ EXYNOS5260_LOGIC_RESET_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 11B0 */
	{ EXYNOS5260_OSCCLK_GATE_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x1} }, /* 11B4 */
	{ EXYNOS5260_SLEEP_RESET_MIF_SYS_PWR_REG,		{ 0x1, 0x1, 0x0} }, /* 11B8 */
	{ EXYNOS5260_MEMORY_TOP_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} }, /* 11C0 */
	{ EXYNOS5260_MEMORY_MIF_SYS_PWR_REG,			{ 0x3, 0x0, 0x0} }, /* 11E0 */
	{ EXYNOS5_PAD_RETENTION_DRAM_SYS_PWR_REG,		{ 0x3, 0x0, 0x0} }, /* 1200 */
	{ EXYNOS5260_PAD_RETENTION_AUD_SYS_PWR_REG,		{ 0x0, 0x0, 0x0} }, /* 1204 */
	{ EXYNOS5260_PAD_RETENTION_JTAG_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1208 */
	{ EXYNOS5260_PAD_RETENTION_MMC2_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1218 */
	{ EXYNOS5260_PAD_RETENTION_TOP_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1220 */
	{ EXYNOS5260_PAD_RETENTION_UART_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1224 */
	{ EXYNOS5260_PAD_RETENTION_MMC0_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1228 */
	{ EXYNOS5260_PAD_RETENTION_MMC1_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 122C */
	{ EXYNOS5260_PAD_RETENTION_SPI_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1238 */
	{ EXYNOS5260_PAD_RETENTION_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 123C */
	{ EXYNOS5_PAD_ISOLATION_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 1240 */
	{ EXYNOS5260_PAD_RETENTION_BOOTLDO_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1248 */
	{ EXYNOS5260_PAD_ISOLATION_MIF_SYS_PWR_REG,		{ 0x1, 0x0, 0x0} }, /* 1250 */
	{ EXYNOS5_PAD_ALV_SEL_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 1260 */
	{ EXYNOS5_XXTI_SYS_PWR_REG,				{ 0x1, 0x1, 0x0} }, /* 1284 */
	{ EXYNOS5_EXT_REGULATOR_SYS_PWR_REG,			{ 0x1, 0x1, 0x0} }, /* 12C0 */
	{ EXYNOS5_GPIO_MODE_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 1300 */
	{ EXYNOS5260_GPIO_MODE_MIF_SYS_PWR_REG,			{ 0x1, 0x0, 0x0} }, /* 1320 */
	{ EXYNOS5260_GPIO_MODE_AUD_SYS_PWR_REG,			{ 0x0, 0x0, 0x0} }, /* 1340 */
	{ EXYNOS5260_GSCL_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 1400 */
	{ EXYNOS5260_G3D_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 140C */
	{ EXYNOS5260_DISP_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 1410 */
	{ EXYNOS5260_AUD_SYS_PWR_REG,				{ 0xF, 0xF, 0x0} }, /* 1418 */
	{ EXYNOS5260_G2D_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 1424 */
	{ EXYNOS5260_ISP_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 1428 */
	{ EXYNOS5260_MFC_SYS_PWR_REG,				{ 0xF, 0x0, 0x0} }, /* 1430 */
	{ EXYNOS5260_MEMORY_G2D_SYS_PWR_REG,			{ 0x0, 0x0, 0xF} }, /* 1564 */
	{ PMU_TABLE_END,},
};
#endif

void __iomem *exynos4_list_disable_pmu_reg[] = {
	EXYNOS4X12_CMU_SYSCLK_ISP_LOWPWR,
	EXYNOS4X12_CMU_RESET_ISP_LOWPWR,
};

void __iomem *exynos3470_list_feed[] = {
	EXYNOS_ARM_CORE_OPTION(0),
	EXYNOS_ARM_CORE_OPTION(1),
	EXYNOS_ARM_CORE_OPTION(2),
	EXYNOS_ARM_CORE_OPTION(3),
	EXYNOS4_ARM_COMMON_OPTION,
	EXYNOS4_TOP_PWR_OPTION,
	EXYNOS4_CORE_TOP_PWR_OPTION,
	EXYNOS4_CAM_OPTION,
	EXYNOS4_TV_OPTION,
	EXYNOS4_MFC_OPTION,
	EXYNOS4_G3D_OPTION,
	EXYNOS4_LCD0_OPTION,
	EXYNOS4_ISP_OPTION,
	EXYNOS4_MAUDIO_OPTION,
};

void __iomem *exynos5_list_feed[] = {
	EXYNOS5_ARM_CORE0_OPTION,
	EXYNOS5_ARM_CORE1_OPTION,
	EXYNOS5_ARM_COMMON_OPTION,
	EXYNOS5_GSCL_OPTION,
	EXYNOS5_ISP_OPTION,
	EXYNOS5_MFC_OPTION,
	EXYNOS5_G3D_OPTION,
	EXYNOS5_DISP1_OPTION,
	EXYNOS5_MAU_OPTION,
	EXYNOS5_TOP_PWR_OPTION,
	EXYNOS5_TOP_PWR_SYSMEM_OPTION,
};

void __iomem *exynos5_list_diable_wfi_wfe[] = {
	EXYNOS5_FSYS_ARM_OPTION,
	EXYNOS5_ISP_ARM_OPTION,
};

void __iomem *exynos5_list_disable_pmu_reg[] = {
	EXYNOS5_CMU_SYSCLK_ISP_SYS_PWR_REG,
	EXYNOS5_CMU_RESET_ISP_SYS_PWR_REG,
};

void __iomem *exynos5410_list_feed[] = {
	EXYNOS_ARM_CORE_OPTION(0),
	EXYNOS_ARM_CORE_OPTION(1),
	EXYNOS_ARM_CORE_OPTION(2),
	EXYNOS_ARM_CORE_OPTION(3),
	EXYNOS_ARM_CORE_OPTION(4),
	EXYNOS_ARM_CORE_OPTION(5),
	EXYNOS_ARM_CORE_OPTION(6),
	EXYNOS_ARM_CORE_OPTION(7),
	EXYNOS54XX_ARM_COMMON_OPTION,
	EXYNOS54XX_KFC_COMMON_OPTION,
	EXYNOS5_GSCL_OPTION,
	EXYNOS5_ISP_OPTION,
	EXYNOS5410_MFC_OPTION,
	EXYNOS5410_G3D_OPTION,
	EXYNOS5410_DISP0_OPTION,
	EXYNOS5410_DISP1_OPTION,
	EXYNOS5410_MAU_OPTION,
	EXYNOS5_TOP_PWR_OPTION,
	EXYNOS5_TOP_PWR_SYSMEM_OPTION,
};

void __iomem *exynos5420_list_feed[] = {
	EXYNOS_ARM_CORE_OPTION(0),
	EXYNOS_ARM_CORE_OPTION(1),
	EXYNOS_ARM_CORE_OPTION(2),
	EXYNOS_ARM_CORE_OPTION(3),
	EXYNOS_ARM_CORE_OPTION(4),
	EXYNOS_ARM_CORE_OPTION(5),
	EXYNOS_ARM_CORE_OPTION(6),
	EXYNOS_ARM_CORE_OPTION(7),
	EXYNOS54XX_ARM_COMMON_OPTION,
	EXYNOS54XX_KFC_COMMON_OPTION,
	EXYNOS5_GSCL_OPTION,
	EXYNOS5_ISP_OPTION,
	EXYNOS5410_MFC_OPTION,
	EXYNOS5410_G3D_OPTION,
	EXYNOS5410_DISP1_OPTION,
	EXYNOS5410_MAU_OPTION,
	EXYNOS5420_G2D_OPTION,
	EXYNOS5420_MSC_OPTION,
	EXYNOS5_TOP_PWR_OPTION,
	EXYNOS5_TOP_PWR_SYSMEM_OPTION,
};

#ifdef CONFIG_SOC_EXYNOS5260
void __iomem *exynos5260_list_feed[] = {
	EXYNOS_ARM_CORE0_OPTION,
	EXYNOS_ARM_CORE1_OPTION,
	EXYNOS_KFC_CORE0_OPTION,
	EXYNOS_KFC_CORE1_OPTION,
	EXYNOS_KFC_CORE2_OPTION,
	EXYNOS_KFC_CORE3_OPTION,
	EXYNOS5260_EAGLE_NONCPU_OPTION,
	EXYNOS5260_KFC_NONCPU_OPTION,
	EXYNOS5260_TOP_PWR_OPTION,
	EXYNOS5260_TOP_PWR_MIF_OPTION,
	EXYNOS5260_GSCL_OPTION,
	EXYNOS5260_G3D_OPTION,
	EXYNOS5260_DISP_OPTION,
	EXYNOS5260_AUD_OPTION,
	EXYNOS5260_G2D_OPTION,
	EXYNOS5260_ISP_OPTION,
	EXYNOS5260_MFC_OPTION,
};

struct exynos_pmu_init_reg exynos5260_pmu_reg[] = {
	/* Enable USE_STANDBY_WFI for all CORE */
	EXYNOS_PMU_REG(EXYNOS_CENTRAL_SEQ_OPTION,
			EXYNOS5260_USE_STANDBY_WFI_ALL | EXYNOS_USE_PROLOGNED_LOGIC_RESET,
			REG_INIT),
	/* Set PSHOLD port for output high */
	EXYNOS_PMU_REG(EXYNOS_PS_HOLD_CONTROL, EXYNOS_PS_HOLD_OUTPUT_HIGH, REG_SET),
	/* Enable signal for PSHOLD port */
	EXYNOS_PMU_REG(EXYNOS_PS_HOLD_CONTROL, EXYNOS_PS_HOLD_EN, REG_SET),
	/* Init core interface reg */
	EXYNOS_PMU_REG(EXYNOS5260_EAGLE_NONCPU_OPTION, (0xF << 16), REG_CLEAR),
	EXYNOS_PMU_REG(EXYNOS5260_KFC_NONCPU_OPTION, (0xF << 16), REG_CLEAR),
	/* Init L2 option */
	EXYNOS_PMU_REG(EXYNOS5260_EAGLE_L2_OPTION, 0x0, REG_INIT),
	EXYNOS_PMU_REG(EXYNOS5260_KFC_L2_OPTION, 0x0, REG_INIT),
	/* Procedure of central sequencer needs to be changed */
	EXYNOS_PMU_REG(EXYNOS5260_SEQ_TRANSITION0, (1<<31 | 0x3a <<16 | 0x3e), REG_INIT),
	EXYNOS_PMU_REG(EXYNOS5260_SEQ_TRANSITION1, (1<<31 | 0x3e <<16 | 0x3b), REG_INIT),
	EXYNOS_PMU_REG(EXYNOS5260_SEQ_TRANSITION2, (1<<31 | 0x3d <<16 | 0x3f), REG_INIT),
	EXYNOS_PMU_REG(NULL, 0, 0)
};
#endif

#ifdef CONFIG_SOC_EXYNOS5260
static int exynos_pmu_reg_set(struct exynos_pmu_init_reg *init_reg)
{
	unsigned int tmp;

	for (; init_reg->reg; init_reg++) {
		switch(init_reg->op) {
		case REG_CLEAR:
			tmp = __raw_readl(init_reg->reg);
			tmp &= ~init_reg->val;
			__raw_writel(tmp, init_reg->reg);
			DEBUG_PRINT_INFO("CLR: %08x - %08x\n", virt_to_phys(init_reg->reg), tmp);
			break;

		case REG_SET:
			tmp = __raw_readl(init_reg->reg);
			tmp |= init_reg->val;
			__raw_writel(tmp, init_reg->reg);
			DEBUG_PRINT_INFO("SET: %08x - %08x\n", virt_to_phys(init_reg->reg), tmp);
			break;

		case REG_INIT:
			__raw_writel(init_reg->val, init_reg->reg);
			DEBUG_PRINT_INFO("INI: %08x - %08x\n", virt_to_phys(init_reg->reg), init_reg->val);
			break;

		case REG_RESET:
			__raw_writel(0x0, init_reg->reg);
			DEBUG_PRINT_INFO("RES: %08x - %08x\n", virt_to_phys(init_reg->reg), 0x0);
			break;

		default:
			pr_err("PMU_REG_SET: undefined operation.\n");
			return -EINVAL;
		}
	}

	return 0;
}
#endif

static void exynos54xx_init_pmu(void)
{
	unsigned int i;
	unsigned int tmp;
	void __iomem **exynos_list_feed;
	unsigned int size = 0;

	if (soc_is_exynos5410()) {
		exynos_list_feed = exynos5410_list_feed;
		size = ARRAY_SIZE(exynos5410_list_feed);
	} else if (soc_is_exynos5420()) {
		exynos_list_feed = exynos5420_list_feed;
		size = ARRAY_SIZE(exynos5420_list_feed);
#ifdef CONFIG_SOC_EXYNOS5260
	} else if (soc_is_exynos5260()) {
		exynos_list_feed = exynos5260_list_feed;
		size = ARRAY_SIZE(exynos5260_list_feed);
#endif
	} else
		pr_err("Unsupported SOC type!\n");

	/*
	 * Enable only SC_FEEDBACK
	 */
	for (i = 0; i < size; i++) {
		tmp = __raw_readl(exynos_list_feed[i]);
		tmp &= ~EXYNOS5_USE_SC_COUNTER;
		tmp |= EXYNOS5_USE_SC_FEEDBACK;
		__raw_writel(tmp, exynos_list_feed[i]);
	}
}

static void exynos5_init_pmu(void)
{
	unsigned int i;
	unsigned int tmp;

	/* Enable only SC_FEEDBACK */
	for (i = 0 ; i < ARRAY_SIZE(exynos5_list_feed) ; i++) {
		tmp = __raw_readl(exynos5_list_feed[i]);
		tmp &= ~(EXYNOS5_USE_SC_COUNTER);
		tmp |= EXYNOS5_USE_SC_FEEDBACK;
		__raw_writel(tmp, exynos5_list_feed[i]);
	}

	/*
	 * SKIP_DEACTIVATE_ACEACP_IN_PWDN_BITFIELD Enable
	 */
	tmp = __raw_readl(EXYNOS5_ARM_COMMON_OPTION);
	tmp |= EXYNOS5_SKIP_DEACTIVATE_ACEACP_IN_PWDN;
	__raw_writel(tmp, EXYNOS5_ARM_COMMON_OPTION);

	/*
	 * Disable WFI/WFE on XXX_OPTION
	 */
	for (i = 0 ; i < ARRAY_SIZE(exynos5_list_diable_wfi_wfe) ; i++) {
		tmp = __raw_readl(exynos5_list_diable_wfi_wfe[i]);
		tmp &= ~(EXYNOS5_OPTION_USE_STANDBYWFE |
			 EXYNOS5_OPTION_USE_STANDBYWFI);
		__raw_writel(tmp, exynos5_list_diable_wfi_wfe[i]);
	}
}

static void exynos3470_init_pmu(void)
{
	unsigned int i;
	unsigned int tmp;

	/* Enable only SC_FEEDBACK */
	for (i = 0 ; i < ARRAY_SIZE(exynos3470_list_feed) ; i++) {
		tmp = __raw_readl(exynos3470_list_feed[i]);
		tmp &= ~(EXYNOS5_USE_SC_COUNTER);
		tmp |= EXYNOS5_USE_SC_FEEDBACK;
		__raw_writel(tmp, exynos3470_list_feed[i]);
	}
}

void exynos_sys_powerdown_conf(enum sys_powerdown mode)
{
	unsigned int i;

	if (soc_is_exynos5250())
		exynos5_init_pmu();

	/* Setting SEQ_OPTION register */
	if (soc_is_exynos5410() || soc_is_exynos5420())
		exynos_set_core_flag();

	for (i = 0; (exynos_pmu_config[i].reg != PMU_TABLE_END) ; i++)
		__raw_writel(exynos_pmu_config[i].val[mode],
				exynos_pmu_config[i].reg);

	if (soc_is_exynos3470()) {
		exynos3470_init_pmu();

		if (mode == SYS_SLEEP) {
			__raw_writel(0x00000BB8, EXYNOS4270_XUSBXTI_DURATION);
			__raw_writel(0x00000BB8, EXYNOS4270_XXTI_DURATION);
			__raw_writel(0x00001D4C, EXYNOS4270_EXT_REGULATOR_DURATION);
			__raw_writel(0x00001D4C, EXYNOS4270_EXT_REGULATOR_COREBLK_DURATION);
			__raw_writel(0x00015F90, EXYNOS4270_LOGIC_RESET_CPBLK_DURATION);
			__raw_writel(0x000005DC, EXYNOS4270_REGULATOR_CPBLK_DURATION);
		}
	}
}

void exynos_xxti_sys_powerdown(bool enable)
{
	unsigned int value;
	void __iomem *base;

	base = soc_is_exynos5250() ? EXYNOS5_XXTI_SYS_PWR_REG :
				     EXYNOS4_XXTI_LOWPWR;

	value = __raw_readl(base);

	if (enable)
		value |= EXYNOS_SYS_PWR_CFG;
	else
		value &= ~EXYNOS_SYS_PWR_CFG;

	__raw_writel(value, base);
}

void exynos_reset_assert_ctrl(bool on)
{
	unsigned int i;
	unsigned int option;

	for (i = 0; i < num_possible_cpus(); i++) {
		option = __raw_readl(EXYNOS_ARM_CORE_OPTION(i));
		option = on ? (option | EXYNOS_USE_DELAYED_RESET_ASSERTION) :
				   (option & ~EXYNOS_USE_DELAYED_RESET_ASSERTION);
		__raw_writel(option, EXYNOS_ARM_CORE_OPTION(i));
	}

	if (soc_is_exynos5420())
		on = true;

	if (soc_is_exynos5410() || soc_is_exynos5420()) {
		option = __raw_readl(EXYNOS54XX_ARM_COMMON_OPTION);
		option = on ? (option | EXYNOS_USE_DELAYED_RESET_ASSERTION) :
				(option & ~EXYNOS_USE_DELAYED_RESET_ASSERTION);
		__raw_writel(option, EXYNOS54XX_ARM_COMMON_OPTION);

		option = __raw_readl(EXYNOS54XX_KFC_COMMON_OPTION);
		option = on ? (option | EXYNOS_USE_DELAYED_RESET_ASSERTION) :
				(option & ~EXYNOS_USE_DELAYED_RESET_ASSERTION);
		__raw_writel(option, EXYNOS54XX_KFC_COMMON_OPTION);
	}
}

#ifdef CONFIG_SOC_EXYNOS5260
static void exynos5260_reset_assert_ctrl(bool on, enum running_cpu cluster)
{
	unsigned int i;
	unsigned int option;
	unsigned int cpu_s, cpu_f;

	if (cluster == KFC) {
		cpu_s = CPUS_PER_CLUSTER;
		cpu_f = cpu_s + CPUS_PER_CLUSTER;
	} else {
		cpu_s = 0;
		cpu_f = 2;
	}

	for (i = cpu_s; i < cpu_f; i++) {
		option = __raw_readl(EXYNOS_ARM_CORE_OPTION(i));
		option = on ? (option | EXYNOS_USE_DELAYED_RESET_ASSERTION) :
				(option & ~EXYNOS_USE_DELAYED_RESET_ASSERTION);
		__raw_writel(option, EXYNOS_ARM_CORE_OPTION(i));
	}

}

extern struct cpumask hmp_slow_cpu_mask;
extern struct cpumask hmp_fast_cpu_mask;

#define cpu_online_hmp(cpu, mask)      cpumask_test_cpu((cpu), mask)

static unsigned int mpidr[NR_CPUS] = {
	0x80000100,
	0x80000101,
	0x80000102,
	0x80000103,
	0x80000000,
	0x80000001,
};

bool exynos5260_is_last_core(unsigned int cpu)
{
	unsigned int cluster = (mpidr[cpu] >> 8) & 0xf;
	unsigned int cpu_id;
        struct cpumask mask, mask_and_online;

        if (cluster)
                cpumask_copy(&mask, &hmp_slow_cpu_mask);
        else
                cpumask_copy(&mask, &hmp_fast_cpu_mask);

        cpumask_and(&mask_and_online, &mask, cpu_online_mask);

        for_each_cpu(cpu_id, &mask) {
                if (cpu_id == cpu)
                        continue;
                if (cpu_online_hmp(cpu_id, &mask_and_online))
                        return false;
        }

        return true;
}
#endif

void exynos_l2_common_pwr_ctrl(void)
{
	unsigned int i;
	unsigned int option;

	for (i = 0; i < CLUSTER_NUM; i++) {
		if ((__raw_readl(EXYNOS_COMMON_STATUS(i)) & 0x3) == 0) {
			option = __raw_readl(EXYNOS_COMMON_CONFIGURATION(i));
			option |= EXYNOS_L2_COMMON_PWR_EN;
			__raw_writel(option, EXYNOS_COMMON_CONFIGURATION(i));
		}
	}
}

void exynos_set_core_flag(void)
{
	int cluster_id = (read_cpuid_mpidr() >> 8) & 0xf;

	if (cluster_id)
		__raw_writel(ARM, EXYNOS_IROM_DATA2);
	else
		__raw_writel(KFC, EXYNOS_IROM_DATA2);
}

void exynos_lpi_mask_ctrl(bool on)
{
	if (on) {
		__raw_writel(0xFFFFFFFF, EXYNOS54XX_LPI_MASK0);
		__raw_writel(0xFFFFFFFF, EXYNOS54XX_LPI_MASK1);
		__raw_writel(0xFFFFFFFC, EXYNOS54XX_LPI_MASK2);
		__raw_writel(0xFFFFFFFF, EXYNOS5410_LPI_NOC_MASK0);
		__raw_writel(0xFFFFFFFF, EXYNOS5410_LPI_NOC_MASK1);
		__raw_writel(0xFFFFFFFF, EXYNOS5410_LPI_NOC_MASK2);
	} else {
		__raw_writel((ATB_ISP_ARM | ATB_KFC | ATB_NOC), EXYNOS54XX_LPI_MASK0);
		__raw_writel(0x30, EXYNOS54XX_LPI_MASK1);
		__raw_writel(0x0, EXYNOS54XX_LPI_MASK2);
		__raw_writel(0x0, EXYNOS5410_LPI_NOC_MASK0);
		__raw_writel(0x0, EXYNOS5410_LPI_NOC_MASK1);
		__raw_writel(0x0, EXYNOS5410_LPI_NOC_MASK2);
	}
}

void exynos_pmu_wdt_control(bool on, unsigned int pmu_wdt_reset_type)
{
	unsigned int value;
	unsigned int wdt_auto_reset_dis;
	unsigned int wdt_reset_mask;

	/*
	 * When SYS_WDTRESET is set, watchdog timer reset request is ignored
	 * by power management unit.
	 */
	if (pmu_wdt_reset_type == PMU_WDT_RESET_TYPE0) {
		wdt_auto_reset_dis = EXYNOS_SYS_WDTRESET;
		wdt_reset_mask = EXYNOS_SYS_WDTRESET;
	} else if (pmu_wdt_reset_type == PMU_WDT_RESET_TYPE1) {
		wdt_auto_reset_dis = EXYNOS5410_SYS_WDTRESET;
		wdt_reset_mask = EXYNOS5410_SYS_WDTRESET;
	} else if (pmu_wdt_reset_type == PMU_WDT_RESET_TYPE2) {
		wdt_auto_reset_dis = EXYNOS5260_SYS_WDTRESET_EGL |
			EXYNOS5260_SYS_WDTRESET_KFC;
		wdt_reset_mask = EXYNOS5260_SYS_WDTRESET_EGL;
	} else {
		pr_err("Failed to %s pmu wdt reset\n",
				on ? "enable" : "disable");
		return;
	}
	value = __raw_readl(EXYNOS_AUTOMATIC_WDT_RESET_DISABLE);
	if (on)
		value &= ~wdt_auto_reset_dis;
	else
		value |= wdt_auto_reset_dis;
	__raw_writel(value, EXYNOS_AUTOMATIC_WDT_RESET_DISABLE);
	value = __raw_readl(EXYNOS_MASK_WDT_RESET_REQUEST);
	if (on)
		value &= ~wdt_reset_mask;
	else
		value |= wdt_reset_mask;
	__raw_writel(value, EXYNOS_MASK_WDT_RESET_REQUEST);
}

static int __init exynos_pmu_init(void)
{
	unsigned int value, i, j;

	if (soc_is_exynos4210()) {
		exynos_pmu_config = exynos4210_pmu_config;
		pr_info("EXYNOS4210 PMU Initialize\n");
	} else if (soc_is_exynos4212()) {
		exynos_pmu_config = exynos4212_pmu_config;
		pr_info("EXYNOS4212 PMU Initialize\n");
	} else if (soc_is_exynos4412()) {

		/* Follow registers should be set with 0x0 */
		for (i = 0; i < ARRAY_SIZE(exynos4_list_disable_pmu_reg); i++)
			__raw_writel(0x0, exynos4_list_disable_pmu_reg[i]);

		exynos_pmu_config = exynos4412_pmu_config;
		pr_info("EXYNOS4412 PMU Initialize\n");
	} else if (soc_is_exynos3470()) {
#ifdef CONFIG_REGULATOR_S2MPU01A
		/* Set GPM0(1) PDCFG register for PMIC */
		s5p_gpio_set_pd_cfg(EXYNOS4_GPM0(1), 0x1);
#endif
		value = (EXYNOS4_USE_STANDBY_WFI0 |\
				EXYNOS4_USE_STANDBY_WFI1 |\
				EXYNOS4_USE_STANDBY_WFI2 |\
				EXYNOS4_USE_STANDBY_WFI3 |\
				EXYNOS4_USE_STANDBY_WFE0 |\
				EXYNOS4_USE_STANDBY_WFE1 |\
				EXYNOS4_USE_STANDBY_WFE2 |\
				EXYNOS4_USE_STANDBY_WFE3);
		__raw_writel(value, EXYNOS_CENTRAL_SEQ_OPTION);

		/*
		* Set PSHOLD port for ouput high
		*/
		value = __raw_readl(EXYNOS_PS_HOLD_CONTROL);
		value |= EXYNOS_PS_HOLD_OUTPUT_HIGH;
		__raw_writel(value, EXYNOS_PS_HOLD_CONTROL);
		/*
		 * Enable signal for PSHOLD port
		 */
		value = __raw_readl(EXYNOS_PS_HOLD_CONTROL);
		value |= EXYNOS_PS_HOLD_EN;
		__raw_writel(value, EXYNOS_PS_HOLD_CONTROL);

		exynos_pmu_config = exynos4270_pmu_config;
		pr_info("EXYNOS3470 PMU Initialize\n");
	} else if (soc_is_exynos4415()) {
		exynos_pmu_config = exynos4415_pmu_config;
		pr_info("EXYNOS4415 PMU Initialize\n");
	} else if (soc_is_exynos5250()) {

		/* Initialize for using delay reset assertion */
		exynos_reset_assert_ctrl(true);

		/*
		 * Set logic reset duration
		 */
		value = __raw_readl(EXYNOS5_LOGIC_RESET_DURATION3);
		value &= ~EXYNOS5_DUR_WAIT_RESET_MASK;
		value |= EXYNOS5_DUR_WAIT_RESET_MIN;
		__raw_writel(value, EXYNOS5_LOGIC_RESET_DURATION3);


		/*
		 * Follow registers should be set with 0x0
		 */
		for (i = 0; i < ARRAY_SIZE(exynos5_list_disable_pmu_reg); i++)
			__raw_writel(0x0, exynos5_list_disable_pmu_reg[i]);

		exynos_pmu_config = exynos5250_pmu_config;
		pr_info("EXYNOS5250 PMU Initialize\n");
	} else if (soc_is_exynos5410()) {
		/* Set Stable counter */
		__raw_writel(0x3a98, EXYNOS5_XXTI_DURATION3);
		__raw_writel(0x3fff, EXYNOS5_EXT_REGULATOR_DURATION3);

		/* Enable USE_STANDBY_WFI for all CORE */
		__raw_writel(EXYNOS5410_USE_STANDBY_WFI_ALL,
				EXYNOS_CENTRAL_SEQ_OPTION);

		value = __raw_readl(EXYNOS_L2_OPTION(0));
		value &= ~EXYNOS5_USE_RETENTION;
		__raw_writel(value, EXYNOS_L2_OPTION(0));

		value = __raw_readl(EXYNOS_L2_OPTION(1));
		value &= ~EXYNOS5_USE_RETENTION;
		__raw_writel(value, EXYNOS_L2_OPTION(1));

		/*
		* If turn L2_COMMON off, clocks relating ATB async bridge is gated.
		* So when ISP power is gated, LPI is stucked.
		*/
		value = __raw_readl(EXYNOS54XX_LPI_MASK0);
		value |= (ATB_ISP_ARM | ATB_KFC | ATB_NOC);
		__raw_writel(value, EXYNOS54XX_LPI_MASK0);

		/*
		* To prevent form issuing new bus request form L2 memory system
		* If core status is power down, should be set '1' to L2  power down
		*/
		value = __raw_readl(EXYNOS54XX_ARM_COMMON_OPTION);
		value |= EXYNOS5_SKIP_DEACTIVATE_ACEACP_IN_PWDN;
		__raw_writel(value, EXYNOS54XX_ARM_COMMON_OPTION);

		/*
		* DUR_WAIT_RESET : 0xF
		* This setting is to reduce suspend/resume time.
		*/
		__raw_writel(DUR_WAIT_RESET, EXYNOS5410_LOGIC_RESET_DURATION3);

		/* Serialized CPU wakeup of Eagle */
		__raw_writel(SPREAD_ENABLE, EXYNOS5410_ARM_INTR_SPREAD_ENABLE);
		__raw_writel(SPREAD_USE_STANDWFI, EXYNOS5410_ARM_INTR_SPREAD_USE_STANDBYWFI);
		__raw_writel(0x1, EXYNOS5410_UP_SCHEDULER);

		/*
		 * Set measure power on/off duration
		 * Use SC_USE_FEEDBACK
		 */
		exynos54xx_init_pmu();

		exynos_reset_assert_ctrl(true);

		if (samsung_rev() < EXYNOS5410_REV_2_3) {
			for (i = 0, j = 0; (exynos5410_pmu_config[i].reg != PMU_TABLE_END); i++) {
				if (exynos5410_pmu_config[i].reg ==
					exynos5410_rev21_pmu_config[j].reg) {
					exynos5410_pmu_config[i].val[SYS_AFTR] =
						exynos5410_rev21_pmu_config[j].val[SYS_AFTR];
					exynos5410_pmu_config[i].val[SYS_LPA] =
						exynos5410_rev21_pmu_config[j].val[SYS_LPA];
					exynos5410_pmu_config[i].val[SYS_SLEEP] =
						exynos5410_rev21_pmu_config[j].val[SYS_SLEEP];

					if (exynos5410_rev21_pmu_config[++j].reg == PMU_TABLE_END)
						break;
				}
			}
		}

		/* Follow registers should be set with 0x0 */
		for (i = 0; i < ARRAY_SIZE(exynos5_list_disable_pmu_reg); i++)
			__raw_writel(0x0, exynos5_list_disable_pmu_reg[i]);

		exynos_pmu_config = exynos5410_pmu_config;
		pr_info("EXYNOS5410 PMU Initialize\n");
	} else if (soc_is_exynos5420()) {

		/* Enable USE_STANDBY_WFI for all CORE */
		__raw_writel(EXYNOS5410_USE_STANDBY_WFI_ALL,
				EXYNOS_CENTRAL_SEQ_OPTION);

		value = __raw_readl(EXYNOS_L2_OPTION(0));
		value &= ~EXYNOS5_USE_RETENTION;
		__raw_writel(value, EXYNOS_L2_OPTION(0));

		value = __raw_readl(EXYNOS_L2_OPTION(1));
		value &= ~EXYNOS5_USE_RETENTION;
		__raw_writel(value, EXYNOS_L2_OPTION(1));

		/*
		 * To skip to control L2 commont at resume and DFT logic,
		 * set the #0 and #1 bit of PMU_SPARE3.
		 */
		__raw_writel(0x3, EXYNOS_PMU_SPARE3);

		/*
		 * If turn L2_COMMON off, clocks relating ATB async bridge is gated.
		 * So when ISP power is gated, LPI is stucked.
		 */
		value = __raw_readl(EXYNOS54XX_LPI_MASK0);
		value |= EXYNOS5420_ATB_ISP_ARM;
		__raw_writel(value, EXYNOS54XX_LPI_MASK0);

		value = __raw_readl(EXYNOS54XX_LPI_MASK1);
		value |= EXYNOS5420_ATB_KFC;
		__raw_writel(value, EXYNOS54XX_LPI_MASK1);

		/*
		 * To prevent form issuing new bus request form L2 memory system
		 * If core status is power down, should be set '1' to L2  power down
		 */
		value = __raw_readl(EXYNOS54XX_ARM_COMMON_OPTION);
		value |= EXYNOS5_SKIP_DEACTIVATE_ACEACP_IN_PWDN;
		__raw_writel(value, EXYNOS54XX_ARM_COMMON_OPTION);

		/*
		* Set PSHOLD port for ouput high
		*/
		value = __raw_readl(EXYNOS_PS_HOLD_CONTROL);
		value |= EXYNOS_PS_HOLD_OUTPUT_HIGH;
		__raw_writel(value, EXYNOS_PS_HOLD_CONTROL);

		/*
		* Enable signal for PSHOLD port
		*/
		value = __raw_readl(EXYNOS_PS_HOLD_CONTROL);
		value |= EXYNOS_PS_HOLD_EN;
		__raw_writel(value, EXYNOS_PS_HOLD_CONTROL);

		/*
		 * DUR_WAIT_RESET : 0xF
		 * This setting is to reduce suspend/resume time.
		 */
		__raw_writel(DUR_WAIT_RESET, EXYNOS5410_LOGIC_RESET_DURATION3);

		/* Serialized CPU wakeup of Eagle */
		__raw_writel(SPREAD_ENABLE, EXYNOS5410_ARM_INTR_SPREAD_ENABLE);
		__raw_writel(SPREAD_USE_STANDWFI, EXYNOS5410_ARM_INTR_SPREAD_USE_STANDBYWFI);
		__raw_writel(0x1, EXYNOS5410_UP_SCHEDULER);

		exynos_reset_assert_ctrl(false);

		for (i = 0; i < 8; i++) {
			value = __raw_readl(EXYNOS_ARM_CORE_OPTION(i));
#if defined CONFIG_EXYNOS_CPUIDLE_C2
			if (i > 3)
				value &= ~EXYNOS_ENABLE_AUTOMATIC_WAKEUP;
			else
				value |= EXYNOS_ENABLE_AUTOMATIC_WAKEUP;
#else
				value &= ~EXYNOS_ENABLE_AUTOMATIC_WAKEUP;
#endif
			__raw_writel(value, EXYNOS_ARM_CORE_OPTION(i));
		}

		/*
		 * Set measure power on/off duration
		 * Use SC_USE_FEEDBACK
		 */
		exynos54xx_init_pmu();

		exynos_pmu_config = exynos5420_pmu_config;
		pr_info("EXYNOS5420 PMU Initialize\n");
#ifdef CONFIG_SOC_EXYNOS5260
	} else if (soc_is_exynos5260()) {
		exynos_pmu_reg_set(exynos5260_pmu_reg);
		exynos5260_reset_assert_ctrl(true, ARM);

		/*
		 * Set power on/off notification method
		 * This function can be used for exynos5260 inspite of its name.
		 * Use SC_USE_FEEDBACK
		 */
		exynos54xx_init_pmu();

		__raw_writel(0x3, EXYNOS5260_UP_SCHEDULER);

		exynos_pmu_config = exynos5260_pmu_config;
		pr_info("EXYNOS5260 PMU Initialized\n");
#endif
	} else {
		pr_info("EXYNOS: PMU not supported\n");
	}

	return 0;
}
arch_initcall(exynos_pmu_init);
