/* linux/arch/arm/mach-exynos4/include/mach/regs-clock-exynos4415.h
 *
 * Copyright (c) 2010-2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * EXYNOS4415 - Clock register definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_CLOCK_EXYNOS4415_H
#define __ASM_ARCH_REGS_CLOCK_EXYNOS4415_ __FILE__

#include <plat/cpu.h>
#include <mach/map.h>
#include <mach/regs-pmu.h>

void wait_clkdiv_stable_time(void __iomem *reg,
			unsigned int mask, unsigned int val);

#define EXYNOS_CLKREG_TOP(x)			(S5P_VA_CMU + (x))	/*0x10030000*/
#define EXYNOS_CLKREG_RIGHTBUS(x)		(S5P_VA_CMU + (x))	/*0x10030000*/
#define EXYNOS_CLKREG_LEFTBUS(x)		(S5P_VA_CMU + (x))	/*0x10030000*/
#define EXYNOS_CLKREG_CPU(x)			(S5P_VA_CMU + (x))	/*0x10040000*/
#define EXYNOS_CLKREG_DMC(x)			(S5P_VA_CMU_DMC + (x))	/*0x105C0000*/
#define EXYNOS_CLKREG_ACP(x)			(S5P_VA_CMU_ACP + (x))	/*0x10450000*/
#define EXYNOS_CLKREG_ISP0(x)			(S5P_VA_CMU_ISP0 + (x))	/*0x12060000*/
#define EXYNOS_CLKREG_ISP1(x)			(S5P_VA_CMU_ISP1 + (x))	/*0x12070000*/

#define EXYNOS4415_EPLL_LOCK			EXYNOS_CLKREG_TOP(0xC010)
#define EXYNOS4415_EPLL_CON0			EXYNOS_CLKREG_TOP(0xC110)
#define EXYNOS4415_EPLL_CON1			EXYNOS_CLKREG_TOP(0xC114)
#define EXYNOS4415_EPLL_CON2			EXYNOS_CLKREG_TOP(0xC118)
#define EXYNOS4415_G3DPLL_LOCK			EXYNOS_CLKREG_TOP(0xC020)
#define EXYNOS4415_G3DPLL_CON0			EXYNOS_CLKREG_TOP(0xC120)
#define EXYNOS4415_G3DPLL_CON1			EXYNOS_CLKREG_TOP(0xC124)
#define EXYNOS4415_G3DPLL_CON2			EXYNOS_CLKREG_TOP(0xC128)
#define EXYNOS4415_DPLL_LOCK			EXYNOS_CLKREG_TOP(0xC030)
#define EXYNOS4415_DPLL_CON0			EXYNOS_CLKREG_TOP(0xC140)
#define EXYNOS4415_DPLL_CON1			EXYNOS_CLKREG_TOP(0xC144)
#define EXYNOS4415_DPLL_CON2			EXYNOS_CLKREG_TOP(0xC148)
#define EXYNOS4415_ISPPLL_LOCK			EXYNOS_CLKREG_TOP(0xC040)
#define EXYNOS4415_ISPPLL_CON0			EXYNOS_CLKREG_TOP(0xC130)
#define EXYNOS4415_ISPPLL_CON1			EXYNOS_CLKREG_TOP(0xC134)
#define EXYNOS4415_ISPPLL_CON2			EXYNOS_CLKREG_TOP(0xC138)
#define EXYNOS4415_MPLL_LOCK			EXYNOS_CLKREG_DMC(0x0008)
#define EXYNOS4415_MPLL_CON0			EXYNOS_CLKREG_DMC(0x0108)
#define EXYNOS4415_MPLL_CON1			EXYNOS_CLKREG_DMC(0x010C)
#define EXYNOS4415_MPLL_CON2			EXYNOS_CLKREG_DMC(0x0110)
#define EXYNOS4415_BPLL_LOCK			EXYNOS_CLKREG_DMC(0x0118)
#define EXYNOS4415_BPLL_CON0			EXYNOS_CLKREG_DMC(0x0218)
#define EXYNOS4415_BPLL_CON1			EXYNOS_CLKREG_DMC(0x021C)
#define EXYNOS4415_BPLL_CON2			EXYNOS_CLKREG_DMC(0x0220)
#define EXYNOS4415_APLL_LOCK			EXYNOS_CLKREG_CPU(0x14000)
#define EXYNOS4415_APLL_CON0			EXYNOS_CLKREG_CPU(0x14100)
#define EXYNOS4415_APLL_CON1			EXYNOS_CLKREG_CPU(0x14104)
#define EXYNOS4415_APLL_CON2			EXYNOS_CLKREG_CPU(0x14108)
#define EXYNOS4415_APLL_CON0_L8			EXYNOS_CLKREG_CPU(0x15100)
#define EXYNOS4415_APLL_CON0_L7			EXYNOS_CLKREG_CPU(0x15104)
#define EXYNOS4415_APLL_CON0_L6			EXYNOS_CLKREG_CPU(0x15108)
#define EXYNOS4415_APLL_CON0_L5			EXYNOS_CLKREG_CPU(0x1510C)
#define EXYNOS4415_APLL_CON0_L4			EXYNOS_CLKREG_CPU(0x15110)
#define EXYNOS4415_APLL_CON0_L3			EXYNOS_CLKREG_CPU(0x15114)
#define EXYNOS4415_APLL_CON0_L2			EXYNOS_CLKREG_CPU(0x15118)
#define EXYNOS4415_APLL_CON0_L1			EXYNOS_CLKREG_CPU(0x1511C)
#define EXYNOS4415_APLL_CON1_L8			EXYNOS_CLKREG_CPU(0x15200)
#define EXYNOS4415_APLL_CON1_L7			EXYNOS_CLKREG_CPU(0x15204)
#define EXYNOS4415_APLL_CON1_L6			EXYNOS_CLKREG_CPU(0x15208)
#define EXYNOS4415_APLL_CON1_L5			EXYNOS_CLKREG_CPU(0x1520C)
#define EXYNOS4415_APLL_CON1_L4			EXYNOS_CLKREG_CPU(0x15210)
#define EXYNOS4415_APLL_CON1_L3			EXYNOS_CLKREG_CPU(0x15214)
#define EXYNOS4415_APLL_CON1_L2			EXYNOS_CLKREG_CPU(0x15218)
#define EXYNOS4415_APLL_CON1_L1			EXYNOS_CLKREG_CPU(0x1521C)
#define EXYNOS4415_CLKSRC_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4200)
#define EXYNOS4415_CLKSRC_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8200)
#define EXYNOS4415_CLKSRC_TOP0			EXYNOS_CLKREG_TOP(0xC210)
#define EXYNOS4415_CLKSRC_TOP1			EXYNOS_CLKREG_TOP(0xC214)
#define EXYNOS4415_CLKSRC_CAM			EXYNOS_CLKREG_TOP(0xC220)
#define EXYNOS4415_CLKSRC_TV			EXYNOS_CLKREG_TOP(0xC224)
#define EXYNOS4415_CLKSRC_MFC			EXYNOS_CLKREG_TOP(0xC228)
#define EXYNOS4415_CLKSRC_G3D			EXYNOS_CLKREG_TOP(0xC22C)
#define EXYNOS4415_CLKSRC_LCD			EXYNOS_CLKREG_TOP(0xC234)
#define EXYNOS4415_CLKSRC_ISP			EXYNOS_CLKREG_TOP(0xC238)
#define EXYNOS4415_CLKSRC_MAUDIO		EXYNOS_CLKREG_TOP(0xC23C)
#define EXYNOS4415_CLKSRC_FSYS			EXYNOS_CLKREG_TOP(0xC240)
#define EXYNOS4415_CLKSRC_PERIL0		EXYNOS_CLKREG_TOP(0xC250)
#define EXYNOS4415_CLKSRC_PERIL1		EXYNOS_CLKREG_TOP(0xC254)
#define EXYNOS4415_CLKSRC_CAM1			EXYNOS_CLKREG_TOP(0xC258)
#define EXYNOS4415_CLKSRC_ISP0			EXYNOS_CLKREG_TOP(0xC25C)
#define EXYNOS4415_CLKSRC_ISP1			EXYNOS_CLKREG_TOP(0xC260)
#define EXYNOS4415_CLKSRC_MASK_TOP		EXYNOS_CLKREG_TOP(0xC310)
#define EXYNOS4415_CLKSRC_MASK_CAM		EXYNOS_CLKREG_TOP(0xC320)
#define EXYNOS4415_CLKSRC_MASK_TV		EXYNOS_CLKREG_TOP(0xC324)
#define EXYNOS4415_CLKSRC_MASK_LCD		EXYNOS_CLKREG_TOP(0xC334)
#define EXYNOS4415_CLKSRC_MASK_ISP		EXYNOS_CLKREG_TOP(0xC338)
#define EXYNOS4415_CLKSRC_MASK_MAUDIO		EXYNOS_CLKREG_TOP(0xC33C)
#define EXYNOS4415_CLKSRC_MASK_FSYS		EXYNOS_CLKREG_TOP(0xC340)
#define EXYNOS4415_CLKSRC_MASK_PERIL0		EXYNOS_CLKREG_TOP(0xC350)
#define EXYNOS4415_CLKSRC_MASK_PERIL1		EXYNOS_CLKREG_TOP(0xC354)
#define EXYNOS4415_CLKSRC_DMC			EXYNOS_CLKREG_DMC(0x0300)
#define EXYNOS4415_CLKSRC_CPU			EXYNOS_CLKREG_CPU(0x14200)
#define EXYNOS4415_CLKSRC_ACP			EXYNOS_CLKREG_ACP(0x0300)
#define EXYNOS4415_CLKSRC_MASK_ACP		EXYNOS_CLKREG_ACP(0x0304)
#define EXYNOS4415_CLKDIV_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4500)
#define EXYNOS4415_CLKDIV_STAT_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4600)
#define EXYNOS4415_CLKDIV_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8500)
#define EXYNOS4415_CLKDIV_STAT_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8600)
#define EXYNOS4415_CLKMUX_STAT_G3D0		EXYNOS_CLKREG_TOP(0xC42C)
#define EXYNOS4415_CLKDIV_TOP			EXYNOS_CLKREG_TOP(0xC510)
#define EXYNOS4415_CLKDIV_CAM			EXYNOS_CLKREG_TOP(0xC520)
#define EXYNOS4415_CLKDIV_TV			EXYNOS_CLKREG_TOP(0xC524)
#define EXYNOS4415_CLKDIV_MFC			EXYNOS_CLKREG_TOP(0xC528)
#define EXYNOS4415_CLKDIV_G3D			EXYNOS_CLKREG_TOP(0xC52C)
#define EXYNOS4415_CLKDIV_LCD			EXYNOS_CLKREG_TOP(0xC534)
#define EXYNOS4415_CLKDIV_ISP			EXYNOS_CLKREG_TOP(0xC538)
#define EXYNOS4415_CLKDIV_MAUDIO		EXYNOS_CLKREG_TOP(0xC53C)
#define EXYNOS4415_CLKDIV_FSYS0			EXYNOS_CLKREG_TOP(0xC540)
#define EXYNOS4415_CLKDIV_FSYS1			EXYNOS_CLKREG_TOP(0xC544)
#define EXYNOS4415_CLKDIV_FSYS2			EXYNOS_CLKREG_TOP(0xC548)
#define EXYNOS4415_CLKDIV_FSYS3			EXYNOS_CLKREG_TOP(0xC54C)
#define EXYNOS4415_CLKDIV_PERIL0		EXYNOS_CLKREG_TOP(0xC550)
#define EXYNOS4415_CLKDIV_PERIL1		EXYNOS_CLKREG_TOP(0xC554)
#define EXYNOS4415_CLKDIV_PERIL2		EXYNOS_CLKREG_TOP(0xC558)
#define EXYNOS4415_CLKDIV_PERIL3		EXYNOS_CLKREG_TOP(0xC55C)
#define EXYNOS4415_CLKDIV_PERIL4		EXYNOS_CLKREG_TOP(0xC560)
#define EXYNOS4415_CLKDIV_PERIL5		EXYNOS_CLKREG_TOP(0xC564)
#define EXYNOS4415_CLKDIV_CAM1			EXYNOS_CLKREG_TOP(0xC568)
#define EXYNOS4415_CLKDIV_ISP1			EXYNOS_CLKREG_TOP(0xC56C)
#define EXYNOS4415_CLKDIV_ISP0			EXYNOS_CLKREG_TOP(0xC570)
#define EXYNOS4415_CLKDIV_STAT_TOP		EXYNOS_CLKREG_TOP(0xC610)
#define EXYNOS4415_CLKDIV_STAT_CAM		EXYNOS_CLKREG_TOP(0xC620)
#define EXYNOS4415_CLKDIV_STAT_TV		EXYNOS_CLKREG_TOP(0xC624)
#define EXYNOS4415_CLKDIV_STAT_MFC		EXYNOS_CLKREG_TOP(0xC628)
#define EXYNOS4415_CLKDIV_STAT_G3D		EXYNOS_CLKREG_TOP(0xC62C)
#define EXYNOS4415_CLKDIV_STAT_LCD		EXYNOS_CLKREG_TOP(0xC634)
#define EXYNOS4415_CLKDIV_STAT_ISP		EXYNOS_CLKREG_TOP(0xC638)
#define EXYNOS4415_CLKDIV_STAT_MAUDIO		EXYNOS_CLKREG_TOP(0xC63C)
#define EXYNOS4415_CLKDIV_STAT_FSYS0		EXYNOS_CLKREG_TOP(0xC640)
#define EXYNOS4415_CLKDIV_STAT_FSYS1		EXYNOS_CLKREG_TOP(0xC644)
#define EXYNOS4415_CLKDIV_STAT_FSYS2		EXYNOS_CLKREG_TOP(0xC648)
#define EXYNOS4415_CLKDIV_STAT_PERIL0		EXYNOS_CLKREG_TOP(0xC650)
#define EXYNOS4415_CLKDIV_STAT_PERIL1		EXYNOS_CLKREG_TOP(0xC654)
#define EXYNOS4415_CLKDIV_STAT_PERIL2		EXYNOS_CLKREG_TOP(0xC658)
#define EXYNOS4415_CLKDIV_STAT_PERIL3		EXYNOS_CLKREG_TOP(0xC65C)
#define EXYNOS4415_CLKDIV_STAT_PERIL4		EXYNOS_CLKREG_TOP(0xC660)
#define EXYNOS4415_CLKDIV_STAT_PERIL5		EXYNOS_CLKREG_TOP(0xC664)
#define EXYNOS4415_CLKDIV_STAT_CAM1		EXYNOS_CLKREG_TOP(0xC668)
#define EXYNOS4415_CLKDIV_STAT_ISP1		EXYNOS_CLKREG_TOP(0xC66C)
#define EXYNOS4415_CLKDIV_STAT_ISP0		EXYNOS_CLKREG_TOP(0xC670)
#define EXYNOS4415_CLKDIV_DYN_FREQ_SCALE	EXYNOS_CLKREG_DMC(0x0500)
#define EXYNOS4415_CLKDIV_DMC1			EXYNOS_CLKREG_DMC(0x0504)
#define EXYNOS4415_CLKDIV_STAT_DMC		EXYNOS_CLKREG_DMC(0x0600)
#define EXYNOS4415_CLKDIV_CPU0			EXYNOS_CLKREG_CPU(0x14500)
#define EXYNOS4415_CLKDIV_CPU1			EXYNOS_CLKREG_CPU(0x14504)
#define EXYNOS4415_CLKDIV_STAT_CPU0		EXYNOS_CLKREG_CPU(0x14600)
#define EXYNOS4415_CLKDIV_STAT_CPU1		EXYNOS_CLKREG_CPU(0x14604)
#define EXYNOS4415_CLKMUX_STATCPU		EXYNOS_CLKREG_CPU(0x14400)
#define EXYNOS4415_CLKDIV_ACP0			EXYNOS_CLKREG_ACP(0x0500)
#define EXYNOS4415_CLKDIV_ACP1			EXYNOS_CLKREG_ACP(0x0504)
#define EXYNOS4415_CLKDIV_STAT_ACP0		EXYNOS_CLKREG_ACP(0x0600)
#define EXYNOS4415_CLKDIV_STAT_ACP1		EXYNOS_CLKREG_ACP(0x0604)
#define EXYNOS4415_CLKGATE_BUS_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4700)
#define EXYNOS4415_CLKGATE_BUS_IMAGE		EXYNOS_CLKREG_LEFTBUS(0x4730)
#define EXYNOS4415_CLKGATE_IP_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4800)
#define EXYNOS4415_CLKGATE_IP_IMAGE		EXYNOS_CLKREG_LEFTBUS(0x4930)
#define EXYNOS4415_CLKGATE_BUS_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8700)
#define EXYNOS4415_CLKGATE_BUS_PERIR		EXYNOS_CLKREG_RIGHTBUS(0x8760)
#define EXYNOS4415_CLKGATE_IP_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8800)
#define EXYNOS4415_CLKGATE_IP_PERIR		EXYNOS_CLKREG_RIGHTBUS(0x8960)
#define EXYNOS4415_CLKGATE_BUS_CAM0		EXYNOS_CLKREG_TOP(0xC720)
#define EXYNOS4415_CLKGATE_BUS_TV		EXYNOS_CLKREG_TOP(0xC724)
#define EXYNOS4415_CLKGATE_BUS_MFC		EXYNOS_CLKREG_TOP(0xC728)
#define EXYNOS4415_CLKGATE_BUS_G3D		EXYNOS_CLKREG_TOP(0xC72C)
#define EXYNOS4415_CLKGATE_BUS_LCD		EXYNOS_CLKREG_TOP(0xC734)
#define EXYNOS4415_CLKGATE_BUS_CAM1		EXYNOS_CLKREG_TOP(0xC738)
#define EXYNOS4415_CLKGATE_BUS_FSYS0		EXYNOS_CLKREG_TOP(0xC740)
#define EXYNOS4415_CLKGATE_BUS_FSYS1		EXYNOS_CLKREG_TOP(0xC744)
#define EXYNOS4415_CLKGATE_BUS_PERIL		EXYNOS_CLKREG_TOP(0xC750)
#define EXYNOS4415_CLKGATE_SCLK_CAM		EXYNOS_CLKREG_TOP(0xC820)
#define EXYNOS4415_CLKGATE_SCLK_TV		EXYNOS_CLKREG_TOP(0xC824)
#define EXYNOS4415_CLKGATE_SCLK_MFC		EXYNOS_CLKREG_TOP(0xC828)
#define EXYNOS4415_CLKGATE_SCLK_G3D		EXYNOS_CLKREG_TOP(0xC82C)
#define EXYNOS4415_CLKGATE_SCLK_LCD		EXYNOS_CLKREG_TOP(0xC834)
#define EXYNOS4415_CLKGATE_SCLK_MAUDIO		EXYNOS_CLKREG_TOP(0xC83C)
#define EXYNOS4415_CLKGATE_SCLK_FSYS		EXYNOS_CLKREG_TOP(0xC840)
#define EXYNOS4415_CLKGATE_SCLK_PERIL		EXYNOS_CLKREG_TOP(0xC850)
#define EXYNOS4415_CLKGATE_IP_CAM		EXYNOS_CLKREG_TOP(0xC920)
#define EXYNOS4415_CLKGATE_IP_TV		EXYNOS_CLKREG_TOP(0xC924)
#define EXYNOS4415_CLKGATE_IP_MFC		EXYNOS_CLKREG_TOP(0xC928)
#define EXYNOS4415_CLKGATE_IP_G3D		EXYNOS_CLKREG_TOP(0xC92C)
#define EXYNOS4415_CLKGATE_IP_LCD		EXYNOS_CLKREG_TOP(0xC934)
#define EXYNOS4415_CLKGATE_IP_MAUDIO		EXYNOS_CLKREG_TOP(0xC93C)
#define EXYNOS4415_CLKGATE_IP_FSYS		EXYNOS_CLKREG_TOP(0xC940)
#define EXYNOS4415_CLKGATE_IP_PERIL		EXYNOS_CLKREG_TOP(0xC950)
#define EXYNOS4415_CLKGATE_BLOCK		EXYNOS_CLKREG_TOP(0xC970)
#define EXYNOS4415_CLKGATE_BUS_DMC		EXYNOS_CLKREG_DMC(0x0700)
#define EXYNOS4415_CLKGATE_BUS_DMC1		EXYNOS_CLKREG_DMC(0x0704)
#define EXYNOS4415_CLKGATE_SCLK_DMC		EXYNOS_CLKREG_DMC(0x0800)
#define EXYNOS4415_CLKGATE_IP_DMC0		EXYNOS_CLKREG_DMC(0x0900)
#define EXYNOS4415_CLKGATE_IP_DMC1		EXYNOS_CLKREG_DMC(0x0904)
#define EXYNOS4415_CLKGATE_BUS_CPU		EXYNOS_CLKREG_CPU(0x14700)
#define EXYNOS4415_CLKGATE_SCLK_CPU		EXYNOS_CLKREG_CPU(0x14800)
#define EXYNOS4415_CLKGATE_IP_CPU		EXYNOS_CLKREG_CPU(0x14900)
#define EXYNOS4415_CLKGATE_BUS_ACP0		EXYNOS_CLKREG_ACP(0x0700)
#define EXYNOS4415_CLKGATE_BUS_ACP1		EXYNOS_CLKREG_ACP(0x0704)
#define EXYNOS4415_CLKGATE_SCLK_ACP		EXYNOS_CLKREG_ACP(0x0800)
#define EXYNOS4415_CLKGATE_IP_ACP0		EXYNOS_CLKREG_ACP(0x0900)
#define EXYNOS4415_CLKGATE_IP_ACP1		EXYNOS_CLKREG_ACP(0x0904)
#define EXYNOS4415_CLKOUT_CMU_LEFTBUS		EXYNOS_CLKREG_LEFTBUS(0x4A00)
#define EXYNOS4415_CLKOUT_CMU_LEFTBUS_DIV_STAT	EXYNOS_CLKREG_LEFTBUS(0x4A04)
#define EXYNOS4415_CLKOUT_CMU_RIGHTBUS		EXYNOS_CLKREG_RIGHTBUS(0x8A00)
#define EXYNOS4415_CLKOUT_CMU_RIGHTBUS_DIV_STAT	EXYNOS_CLKREG_RIGHTBUS(0x8A04)
#define EXYNOS4415_CLKOUT_CMU_TOP		EXYNOS_CLKREG_TOP(0xCA00)
#define EXYNOS4415_CLKOUT_CMU_TOP_DIV_STAT	EXYNOS_CLKREG_TOP(0xCA04)
#define EXYNOS4415_CLKOUT_CMU_DMC		EXYNOS_CLKREG_DMC(0x0A00)
#define EXYNOS4415_CLKOUT_CMU_DMC_DIV_STAT	EXYNOS_CLKREG_DMC(0x0A04)
#define EXYNOS4415_CLKOUT_CMU_CPU		EXYNOS_CLKREG_CPU(0x14A00)
#define EXYNOS4415_CLKOUT_CMU_CPU_DIV_STAT	EXYNOS_CLKREG_CPU(0x14A04)
#define EXYNOS4415_CLKOUT_CMU_ACP		EXYNOS_CLKREG_ACP(0x0A00)
#define EXYNOS4415_CLKOUT_CMU_ACP_DIV_STAT	EXYNOS_CLKREG_ACP(0x0A04)
#define EXYNOS4415_CLK_DMC_PAUSE_CTR		EXYNOS_CLKREG_DMC(0x1094)
#define EXYNOS4415_DMC_PAUSE_ENABLE		(1 << 0)
#define EXYNOS4415_CLK_DDRPHY_LOCK_CTRL		EXYNOS_CLKREG_DMC(0x1098)
#define EXYNOS4415_CLKGATE_IP_ISP0_SUB0		EXYNOS_CLKREG_ISP0(0x0900)
#define EXYNOS4415_CLKGATE_IP_ISP0_SUB1		EXYNOS_CLKREG_ISP0(0x0904)
#define EXYNOS4415_CLKGATE_IP_ISP0_SUB2		EXYNOS_CLKREG_ISP0(0x0908)
#define EXYNOS4415_CLKGATE_IP_ISP0_SUB3		EXYNOS_CLKREG_ISP0(0x090C)
#define EXYNOS4415_CLKGATE_IP_ISP0_SUB4		EXYNOS_CLKREG_ISP0(0x0910)
#define EXYNOS4415_CLKGATE_IP_ISP1_SUB0		EXYNOS_CLKREG_ISP1(0x0900)
#define EXYNOS4415_CLKGATE_IP_ISP2_SUB1		EXYNOS_CLKREG_ISP1(0x0904)
#define EXYNOS4415_CLKDIV_CMU_ISP0		EXYNOS_CLKREG_ISP0(0x0500)
#define EXYNOS4415_CLKDIV_CMU_ISP0_SUB0		EXYNOS_CLKREG_ISP0(0x0504)
#define EXYNOS4415_CLKDIV_CMU_ISP1		EXYNOS_CLKREG_ISP1(0x0500)
#define EXYNOS4415_CLKSRC_CMU_ISP0		EXYNOS_CLKREG_ISP0(0x0200)
#define EXYNOS4415_CLKSRC_CMU_ISP1		EXYNOS_CLKREG_ISP1(0x0200)
#define EXYNOS4415_CLKSRC_MASK_CMU_ISP0		EXYNOS_CLKREG_ISP0(0x0300)
#define EXYNOS4415_CLKSRC_MASK_CMU_ISP1		EXYNOS_CLKREG_ISP1(0x0300)



#define EXYNOS4_APLL_LOCKTIME			(0x1C20)	/* 300us */

#define EXYNOS4_APLLCON0_ENABLE_SHIFT		(31)
#define EXYNOS4_APLLCON0_LOCKED_SHIFT		(29)
#define EXYNOS4_APLL_VAL_1000			((250 << 16) | (6 << 8) | 1)
#define EXYNOS4_APLL_VAL_800			((200 << 16) | (6 << 8) | 1)

#define EXYNOS4_EPLLCON0_ENABLE_SHIFT		(31)
#define EXYNOS4_EPLLCON0_LOCKED_SHIFT		(29)

#define EXYNOS4_VPLLCON0_ENABLE_SHIFT		(31)
#define EXYNOS4_VPLLCON0_LOCKED_SHIFT		(29)

#define EXYNOS4_CLKSRC_CPU_MUXCORE_SHIFT	(16)
#define EXYNOS4_CLKMUX_STATCPU_MUXCORE_MASK	(0x7 << EXYNOS4_CLKSRC_CPU_MUXCORE_SHIFT)

#define EXYNOS4_CLKDIV_CPU0_CORE_SHIFT		(0)
#define EXYNOS4_CLKDIV_CPU0_CORE_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_CORE_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_COREM0_SHIFT	(4)
#define EXYNOS4_CLKDIV_CPU0_COREM0_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_COREM0_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_COREM1_SHIFT	(8)
#define EXYNOS4_CLKDIV_CPU0_COREM1_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_COREM1_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_PERIPH_SHIFT	(12)
#define EXYNOS4_CLKDIV_CPU0_PERIPH_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_PERIPH_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_ATB_SHIFT		(16)
#define EXYNOS4_CLKDIV_CPU0_ATB_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_ATB_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_PCLKDBG_SHIFT	(20)
#define EXYNOS4_CLKDIV_CPU0_PCLKDBG_MASK	(0x7 << EXYNOS4_CLKDIV_CPU0_PCLKDBG_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_APLL_SHIFT		(24)
#define EXYNOS4_CLKDIV_CPU0_APLL_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_APLL_SHIFT)
#define EXYNOS4_CLKDIV_CPU0_CORE2_SHIFT		28
#define EXYNOS4_CLKDIV_CPU0_CORE2_MASK		(0x7 << EXYNOS4_CLKDIV_CPU0_CORE2_SHIFT)

#define EXYNOS4_CLKDIV_CPU1_COPY_SHIFT		0
#define EXYNOS4_CLKDIV_CPU1_COPY_MASK		(0x7 << EXYNOS4_CLKDIV_CPU1_COPY_SHIFT)
#define EXYNOS4_CLKDIV_CPU1_HPM_SHIFT		4
#define EXYNOS4_CLKDIV_CPU1_HPM_MASK		(0x7 << EXYNOS4_CLKDIV_CPU1_HPM_SHIFT)
#define EXYNOS4_CLKDIV_CPU1_CORES_SHIFT		8
#define EXYNOS4_CLKDIV_CPU1_CORES_MASK		(0x7 << EXYNOS4_CLKDIV_CPU1_CORES_SHIFT)

#define EXYNOS4_CLKDIV_DMC0_ACP_SHIFT		(0)
#define EXYNOS4_CLKDIV_DMC0_ACP_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_ACP_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_ACPPCLK_SHIFT	(4)
#define EXYNOS4_CLKDIV_DMC0_ACPPCLK_MASK	(0x7 << EXYNOS4_CLKDIV_DMC0_ACPPCLK_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_DPHY_SHIFT		(8)
#define EXYNOS4_CLKDIV_DMC0_DPHY_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_DPHY_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_DMC_SHIFT		(12)
#define EXYNOS4_CLKDIV_DMC0_DMC_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_DMC_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_DMCD_SHIFT		(16)
#define EXYNOS4_CLKDIV_DMC0_DMCD_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_DMCD_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_DMCP_SHIFT		(20)
#define EXYNOS4_CLKDIV_DMC0_DMCP_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_DMCP_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_COPY2_SHIFT		(24)
#define EXYNOS4_CLKDIV_DMC0_COPY2_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_COPY2_SHIFT)
#define EXYNOS4_CLKDIV_DMC0_CORETI_SHIFT	(28)
#define EXYNOS4_CLKDIV_DMC0_CORETI_MASK		(0x7 << EXYNOS4_CLKDIV_DMC0_CORETI_SHIFT)

#define EXYNOS4_CLKDIV_DMC1_G2D_ACP_SHIFT	(0)
#define EXYNOS4_CLKDIV_DMC1_G2D_ACP_MASK	(0xf << EXYNOS4_CLKDIV_DMC1_G2D_ACP_SHIFT)
#define EXYNOS4_CLKDIV_DMC1_C2C_SHIFT		(4)
#define EXYNOS4_CLKDIV_DMC1_C2C_MASK		(0x7 << EXYNOS4_CLKDIV_DMC1_C2C_SHIFT)
#define EXYNOS4_CLKDIV_DMC1_PWI_SHIFT		(8)
#define EXYNOS4_CLKDIV_DMC1_PWI_MASK		(0xf << EXYNOS4_CLKDIV_DMC1_PWI_SHIFT)
#define EXYNOS4_CLKDIV_DMC1_C2CACLK_SHIFT	(12)
#define EXYNOS4_CLKDIV_DMC1_C2CACLK_MASK	(0x7 << EXYNOS4_CLKDIV_DMC1_C2CACLK_SHIFT)
#define EXYNOS4_CLKDIV_DMC1_DVSEM_SHIFT		(16)
#define EXYNOS4_CLKDIV_DMC1_DVSEM_MASK		(0x7f << EXYNOS4_CLKDIV_DMC1_DVSEM_SHIFT)
#define EXYNOS4_CLKDIV_DMC1_DPM_SHIFT		(24)
#define EXYNOS4_CLKDIV_DMC1_DPM_MASK		(0x7f << EXYNOS4_CLKDIV_DMC1_DPM_SHIFT)

#define EXYNOS4415_CLKDIV_MFC_SHIFT		(0)
#define EXYNOS4415_CLKDIV_MFC_MASK		(0xf << EXYNOS4415_CLKDIV_MFC_SHIFT)

#define EXYNOS4415_CLKDIV_STAT_MFC_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_MFC_MASK		(0x1 << EXYNOS4415_CLKDIV_STAT_MFC_SHIFT)

#define EXYNOS4415_CLKDIV_TOP_ACLK266_SHIFT	(0)
#define EXYNOS4415_CLKDIV_TOP_ACLK266_MASK	(0x7 << EXYNOS4415_CLKDIV_TOP_ACLK266_SHIFT)
#define EXYNOS4_CLKDIV_TOP_ACLK100_SHIFT	(4)
#define EXYNOS4_CLKDIV_TOP_ACLK100_MASK		(0xF << EXYNOS4_CLKDIV_TOP_ACLK100_SHIFT)
#define EXYNOS4_CLKDIV_TOP_ACLK160_SHIFT	(8)
#define EXYNOS4_CLKDIV_TOP_ACLK160_MASK		(0x7 << EXYNOS4_CLKDIV_TOP_ACLK160_SHIFT)
#define EXYNOS4415_CLKDIV_TOP_ACLK200_SHIFT	(12)
#define EXYNOS4415_CLKDIV_TOP_ACLK200_MASK	(0x7 << EXYNOS4415_CLKDIV_TOP_ACLK200_SHIFT)
#define EXYNOS4_CLKDIV_TOP_ONENAND_SHIFT	(16)
#define EXYNOS4_CLKDIV_TOP_ONENAND_MASK		(0x7 << EXYNOS4_CLKDIV_TOP_ONENAND_SHIFT)
#define EXYNOS4_CLKDIV_TOP_ACLK400_MCUISP_SHIFT	(24)
#define EXYNOS4_CLKDIV_TOP_ACLK400_MCUISP_MASK	(0x7 << EXYNOS4_CLKDIV_TOP_ACLK400_MCUISP_SHIFT)

#define EXYNOS4415_CLKDIV_STAT_TOP_ACLK266_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_TOP_ACLK266_MASK	(0x1 << EXYNOS4415_CLKDIV_TOP_ACLK266_SHIFT)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK100_SHIFT	(4)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK100_MASK	(0x1 << EXYNOS4_CLKDIV_TOP_ACLK100_SHIFT)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK160_SHIFT	(8)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK160_MASK	(0x1 << EXYNOS4_CLKDIV_TOP_ACLK160_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_TOP_ACLK200_SHIFT	(12)
#define EXYNOS4415_CLKDIV_STAT_TOP_ACLK200_MASK	(0x1 << EXYNOS4415_CLKDIV_TOP_ACLK200_SHIFT)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK400_MCUISP_SHIFT	(24)
#define EXYNOS4_CLKDIV_STAT_TOP_ACLK400_MCUISP_MASK	(0x1 << EXYNOS4_CLKDIV_TOP_ACLK400_MCUISP_SHIFT)

#define EXYNOS4415_CLKDIV_TOP_ISP0_300_SHIFT		(0)
#define EXYNOS4415_CLKDIV_TOP_ISP0_300_MASK		(0x7 << EXYNOS4415_CLKDIV_TOP_ISP0_300_SHIFT)
#define EXYNOS4415_CLKDIV_TOP_ISP1_300_SHIFT		(4)
#define EXYNOS4415_CLKDIV_TOP_ISP1_300_MASK		(0x7 << EXYNOS4415_CLKDIV_TOP_ISP1_300_SHIFT)

#define EXYNOS4_CLKDIV_BUS_GDLR_SHIFT		(0)
#define EXYNOS4_CLKDIV_BUS_GDLR_MASK		(0x7 << EXYNOS4_CLKDIV_BUS_GDLR_SHIFT)
#define EXYNOS4_CLKDIV_BUS_GPLR_SHIFT		(4)
#define EXYNOS4_CLKDIV_BUS_GPLR_MASK		(0x7 << EXYNOS4_CLKDIV_BUS_GPLR_SHIFT)
#define EXYNOS4_CLKDIV_STAT_BUS_GDLR_SHIFT		(0)
#define EXYNOS4_CLKDIV_STAT_BUS_GDLR_MASK		(0x1 << EXYNOS4_CLKDIV_BUS_GDLR_SHIFT)
#define EXYNOS4_CLKDIV_STAT_BUS_GPLR_SHIFT		(4)
#define EXYNOS4_CLKDIV_STAT_BUS_GPLR_MASK		(0x1 << EXYNOS4_CLKDIV_BUS_GPLR_SHIFT)

#define EXYNOS4_CLKDIV_CAM_FIMC0_SHIFT		(0)
#define EXYNOS4_CLKDIV_CAM_FIMC0_MASK		(0xf << EXYNOS4_CLKDIV_CAM_FIMC0_SHIFT)
#define EXYNOS4_CLKDIV_CAM_FIMC1_SHIFT		(4)
#define EXYNOS4_CLKDIV_CAM_FIMC1_MASK		(0xf << EXYNOS4_CLKDIV_CAM_FIMC1_SHIFT)
#define EXYNOS4_CLKDIV_CAM_FIMC2_SHIFT		(8)
#define EXYNOS4_CLKDIV_CAM_FIMC2_MASK		(0xf << EXYNOS4_CLKDIV_CAM_FIMC2_SHIFT)
#define EXYNOS4_CLKDIV_CAM_FIMC3_SHIFT		(12)
#define EXYNOS4_CLKDIV_CAM_FIMC3_MASK		(0xf << EXYNOS4_CLKDIV_CAM_FIMC3_SHIFT)
#define EXYNOS4415_CLKDIV_CSIS0_SHIFT		(24)
#define EXYNOS4415_CLKDIV_CSIS0_MASK		(0xF << EXYNOS4415_CLKDIV_CSIS0_SHIFT)
#define EXYNOS4415_CLKDIV_CSIS1_SHIFT		(28)
#define EXYNOS4415_CLKDIV_CSIS1_MASK		(0xF << EXYNOS4415_CLKDIV_CSIS1_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_CSIS0_SHIFT	(24)
#define EXYNOS4415_CLKDIV_STAT_CSIS0_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_CSIS0_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_CSIS1_SHIFT	(28)
#define EXYNOS4415_CLKDIV_STAT_CSIS1_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_CSIS1_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_FIMC3_SHIFT	(12)
#define EXYNOS4415_CLKDIV_STAT_FIMC3_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_FIMC3_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_FIMC2_SHIFT	(8)
#define EXYNOS4415_CLKDIV_STAT_FIMC2_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_FIMC2_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_FIMC1_SHIFT	(4)
#define EXYNOS4415_CLKDIV_STAT_FIMC1_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_FIMC1_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_FIMC0_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_FIMC0_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_FIMC0_SHIFT)

#define EXYNOS4_CLKDIV_CAM1_JPEG_SHIFT		(0)
#define EXYNOS4_CLKDIV_CAM1_JPEG_MASK		(0xf << EXYNOS4_CLKDIV_CAM1_JPEG_SHIFT)
#define EXYNOS4_CLKDIV_STAT_CAM1_JPEG_SHIFT	(0)
#define EXYNOS4_CLKDIV_STAT_CAM1_JPEG_MASK	(0x1 << EXYNOS4_CLKDIV_STAT_CAM1_JPEG_SHIFT)

#define EXYNOS4415_CLKDIV_ISP0_300_SHIFT	(0)
#define EXYNOS4415_CLKDIV_ISP0_300_MASK		(0xf << EXYNOS4415_CLKDIV_ISP0_300_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ISP0_300_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_ISP0_300_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ISP0_300_SHIFT)
#define EXYNOS4415_CLKDIV_ISP1_300_SHIFT	(16)
#define EXYNOS4415_CLKDIV_ISP1_300_MASK		(0xf << EXYNOS4415_CLKDIV_ISP1_300_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ISP1_300_SHIFT	(16)
#define EXYNOS4415_CLKDIV_STAT_ISP1_300_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ISP1_300_SHIFT)

#define EXYNOS4_CLKDIV_TOP1_ACLK200_SUB_SHIFT		(20)
#define EXYNOS4_CLKDIV_TOP1_ACLK400_MCUISP_SUB_SHIFT	(24)

#define EXYNOS4_CLKDIV_ISP_PWMISP_SHIFT		(0)
#define EXYNOS4_CLKDIV_ISP_PWMISP_MASK		(0xf << EXYNOS4_CLKDIV_ISP_PWMISP_SHIFT)
#define EXYNOS4_CLKDIV_ISP_SPI0ISP_SHIFT	(4)
#define EXYNOS4_CLKDIV_ISP_SPI0ISP_MASK		(0xf << EXYNOS4_CLKDIV_ISP_SPI0ISP_SHIFT)
#define EXYNOS4_CLKDIV_ISP_SPI0ISP_PRE_SHIFT	(8)
#define EXYNOS4_CLKDIV_ISP_SPI0ISP_PRE_MASK	(0xff << EXYNOS4_CLKDIV_ISP_SPI0ISP_PRE_SHIFT)
#define EXYNOS4_CLKDIV_ISP_SPI1ISP_SHIFT	(16)
#define EXYNOS4_CLKDIV_ISP_SPI1ISP_MASK		(0xf << EXYNOS4_CLKDIV_ISP_SPI1ISP_SHIFT)
#define EXYNOS4_CLKDIV_ISP_SPI1ISP_PRE_SHIFT	(20)
#define EXYNOS4_CLKDIV_ISP_SPI1ISP_PRE_MASK	(0xff << EXYNOS4_CLKDIV_ISP_SPI1ISP_PRE_SHIFT)
#define EXYNOS4_CLKDIV_ISP_UARTISP_SHIFT	(28)
#define EXYNOS4_CLKDIV_ISP_UARTISP_MASK		(0xf << EXYNOS4_CLKDIV_ISP_SPI1ISP_SHIFT)

#define EXYNOS4_CLKDIV_ISP0_ISP0_SHIFT		(0)
#define EXYNOS4_CLKDIV_ISP0_ISP0_MASK		(0x7 << EXYNOS4_CLKDIV_ISP0_ISP0_SHIFT)
#define EXYNOS4_CLKDIV_ISP0_ISP1_SHIFT		(4)
#define EXYNOS4_CLKDIV_ISP0_ISP1_MASK		(0x7 << EXYNOS4_CLKDIV_ISP0_ISP1_SHIFT)
#define EXYNOS4_CLKDIV_ISP1_MPWM_SHIFT		(0)
#define EXYNOS4_CLKDIV_ISP1_MPWM_MASK		(0x7 << EXYNOS4_CLKDIV_ISP1_MPWM_SHIFT)
#define EXYNOS4_CLKDIV_ISP1_MCUISP0_SHIFT	(4)
#define EXYNOS4_CLKDIV_ISP1_MCUISP0_MASK	(0x7 << EXYNOS4_CLKDIV_ISP1_MCUISP0_SHIFT)
#define EXYNOS4_CLKDIV_ISP1_MCUISP1_SHIFT	(8)
#define EXYNOS4_CLKDIV_ISP1_MCUISP1_MASK	(0x7 << EXYNOS4_CLKDIV_ISP1_MCUISP1_SHIFT)

#define EXYNOS4415_PLL_ENABLE_SHIFT		(31)
#define EXYNOS4415_PLL_LOCKED_SHIFT		(29)

#define EXYNOS4415_CLKDIV_DMC1_DMCD_SHIFT	(11)
#define EXYNOS4415_CLKDIV_DMC1_DMCD_MASK		\
					(0x7 << EXYNOS4415_CLKDIV_DMC1_DMCD_SHIFT)
#define EXYNOS4415_CLKDIV_DMC1_DMCP_SHIFT	(15)
#define EXYNOS4415_CLKDIV_DMC1_DMCP_MASK		\
					(0x7 << EXYNOS4415_CLKDIV_DMC1_DMCP_SHIFT)
#define EXYNOS4415_CLKDIV_DMC1_DMCPRE_SHIFT	(19)
#define EXYNOS4415_CLKDIV_DMC1_DMCPRE_MASK		\
					(0x7 << EXYNOS4415_CLKDIV_DMC1_DMCPRE_SHIFT)
#define EXYNOS4415_CLKDIV_DMC1_DMCPHY_SHIFT	(23)
#define EXYNOS4415_CLKDIV_DMC1_DMCPHY_MASK		\
					(0x7 << EXYNOS4415_CLKDIV_DMC1_DMCPHY_SHIFT)
#define EXYNOS4415_CLKDIV_DMC1_DMC_SHIFT	(27)
#define EXYNOS4415_CLKDIV_DMC1_DMC_MASK			\
					(0x7 << EXYNOS4415_CLKDIV_DMC1_DMC_SHIFT)

#define EXYNOS4415_CLKDIV_STAT_DMC_SHIFT	(4)
#define EXYNOS4415_CLKDIV_STAT_DMC_MASK			\
					(1 << EXYNOS4415_CLKDIV_STAT_DMC_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_DMCD_SHIFT	(8)
#define EXYNOS4415_CLKDIV_STAT_DMCD_MASK		\
					(1 << EXYNOS4415_CLKDIV_STAT_DMCD_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_DMCP_SHIFT	(12)
#define EXYNOS4415_CLKDIV_STAT_DMCP_MASK		\
					(1 << EXYNOS4415_CLKDIV_STAT_DMCP_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_DMCPRE_SHIFT	(16)
#define EXYNOS4415_CLKDIV_STAT_DMCPRE_MASK		\
					(1 << EXYNOS4415_CLKDIV_STAT_DMCPRE_SHIFT)

#define EXYNOS4415_CLKDIV_ACP_SHIFT		(0)
#define EXYNOS4415_CLKDIV_ACP_MASK		(0x7 << EXYNOS4415_CLKDIV_ACP_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_PCLK_SHIFT	(4)
#define EXYNOS4415_CLKDIV_ACP_PCLK_MASK		(0x7 << EXYNOS4415_CLKDIV_ACP_PCLK_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_DMC_SHIFT		(8)
#define EXYNOS4415_CLKDIV_ACP_DMC_MASK		(0x7 << EXYNOS4415_CLKDIV_ACP_DMC_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_DMCD_SHIFT	(12)
#define EXYNOS4415_CLKDIV_ACP_DMCD_MASK		(0x7 << EXYNOS4415_CLKDIV_ACP_DMCD_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_DMCP_SHIFT	(16)
#define EXYNOS4415_CLKDIV_ACP_DMCP_MASK		(0x7 << EXYNOS4415_CLKDIV_ACP_DMCP_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_DMC_PRE_SHIFT	(20)
#define EXYNOS4415_CLKDIV_ACP_DMC_PRE_MASK	(0x7 << EXYNOS4415_CLKDIV_ACP_DMC_PRE_SHIFT)
#define EXYNOS4415_CLKDIV_ACP_G2D_SHIFT		(0)
#define EXYNOS4415_CLKDIV_ACP_G2D_MASK		(0xF << EXYNOS4415_CLKDIV_ACP_G2D_SHIFT)

#define EXYNOS4415_CLKDIV_STAT_ACP_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_ACP_MASK		(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_PCLK_SHIFT	(4)
#define EXYNOS4415_CLKDIV_STAT_ACP_PCLK_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_PCLK_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMC_SHIFT	(8)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMC_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_DMC_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCD_SHIFT	(12)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCD_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_DMCD_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCP_SHIFT	(16)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCP_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_DMCP_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCPRE_SHIFT	(20)
#define EXYNOS4415_CLKDIV_STAT_ACP_DMCPRE_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_DMCPRE_SHIFT)
#define EXYNOS4415_CLKDIV_STAT_ACP_G2D_SHIFT	(0)
#define EXYNOS4415_CLKDIV_STAT_ACP_G2D_MASK	(0x1 << EXYNOS4415_CLKDIV_STAT_ACP_G2D_SHIFT)

#endif /* __ASM_ARCH_REGS_CLOCK_EXYNOS4415_H */
