/*
 * Copyright (c) 2010-2012 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * EXYNOS - IRQ definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H __FILE__

#include <plat/irqs.h>

/* SGI: Software Generated Interrupt */

#define IRQ_SGI(x)		(x)

/* PPI: Private Peripheral Interrupt */

#define IRQ_PPI(x)			(x + 16)

/* SPI: Shared Peripheral Interrupt */

#define IRQ_SPI(x)			(x + 32)

/* COMBINER */

#define MAX_IRQ_IN_COMBINER		8

#if defined(CONFIG_SOC_EXYNOS5410) || defined (CONFIG_SOC_EXYNOS5420)
#define COMBINER_GROUP(x)		((x) * MAX_IRQ_IN_COMBINER + IRQ_SPI(224))
#else
#define COMBINER_GROUP(x)		((x) * MAX_IRQ_IN_COMBINER + IRQ_SPI(128))
#endif

#define COMBINER_IRQ(x, y)		(COMBINER_GROUP(x) + y)

/* For EXYNOS4 and EXYNOS5 */

#define EXYNOS_IRQ_MCT_LOCALTIMER	IRQ_PPI(12)


/* For EXYNOS3 */
/*KFC*/
#define EXYNOS3_IRQ_KFC_PMU0		IRQ_SPI(18)
#define EXYNOS3_IRQ_KFC_PMU1    	IRQ_SPI(19)
#define EXYNOS3_IRQ_KFC_PMU2    	IRQ_SPI(20)
#define EXYNOS3_IRQ_KFC_PMU3    	IRQ_SPI(21)
#define EXYNOS3_IRQ_KFC_CTI0    	IRQ_SPI(22)
#define EXYNOS3_IRQ_KFC_CTI1    	IRQ_SPI(23)
#define EXYNOS3_IRQ_KFC_CTI2    	IRQ_SPI(24)
#define EXYNOS3_IRQ_KFC_CTI3    	IRQ_SPI(25)

/*EINT0~16*/
#define EXYNOS3_IRQ_EINT0               IRQ_SPI(32)
#define EXYNOS3_IRQ_EINT1               IRQ_SPI(33)
#define EXYNOS3_IRQ_EINT2               IRQ_SPI(34)
#define EXYNOS3_IRQ_EINT3               IRQ_SPI(35)
#define EXYNOS3_IRQ_EINT4               IRQ_SPI(36)
#define EXYNOS3_IRQ_EINT5               IRQ_SPI(37)
#define EXYNOS3_IRQ_EINT6               IRQ_SPI(38)
#define EXYNOS3_IRQ_EINT7               IRQ_SPI(39)
#define EXYNOS3_IRQ_EINT8               IRQ_SPI(40)
#define EXYNOS3_IRQ_EINT9               IRQ_SPI(41)
#define EXYNOS3_IRQ_EINT10              IRQ_SPI(42)
#define EXYNOS3_IRQ_EINT11              IRQ_SPI(43)
#define EXYNOS3_IRQ_EINT12              IRQ_SPI(44)
#define EXYNOS3_IRQ_EINT13              IRQ_SPI(45)
#define EXYNOS3_IRQ_EINT14              IRQ_SPI(46)
#define EXYNOS3_IRQ_EINT15              IRQ_SPI(47)
#define EXYNOS3_IRQ_EINT16_31   	IRQ_SPI(48)

#define EXYNOS3_IRQ_CEC         	IRQ_SPI(49)
#define EXYNOS3_IRQ_PMU         	IRQ_SPI(50)

#define EXYNOS3_IRQ_CP2AP_RESET_REQ	IRQ_SPI(52)
#define EXYNOS3_IRQ_CP_ACTIVE           IRQ_SPI(53)

#define EXYNOS3_IRQ_IEM_APC             IRQ_SPI(54)
#define EXYNOS3_IRQ_IEM_IEC             IRQ_SPI(55)

#define EXYNOS3_IRQ_TZASC00             IRQ_SPI(56)
#define EXYNOS3_IRQ_TZASC01             IRQ_SPI(57)
#define EXYNOS3_IRQ_TZASC10             IRQ_SPI(58)
#define EXYNOS3_IRQ_TZASC11             IRQ_SPI(59)

#define EXYNOS3_IRQ_PPMU_XIU_L          IRQ_SPI(64)
#define EXYNOS3_IRQ_PPMU_XIU_R  	IRQ_SPI(65)
#define EXYNOS3_IRQ_PPMU_XIU_R_S1	IRQ_SPI(66)
#define EXYNOS3_IRQ_PPMU_ACP0_M0	IRQ_SPI(67)

#define EXYNOS3_IRQ_DMC0_PPC_PEREV_A    IRQ_SPI(68)
#define EXYNOS3_IRQ_DMC0_PPC_PEREV_M    IRQ_SPI(69)
#define EXYNOS3_IRQ_DMC1_PPC_PEREV_A    IRQ_SPI(70)
#define EXYNOS3_IRQ_DMC1_PPC_PEREV_M    IRQ_SPI(71)
#define EXYNOS3_IRQ_MCUCTL_MIF_L_INT_COMBO  IRQ_SPI(72)

#define EXYNOS3_IRQ_RTC_ALARM           IRQ_SPI(73)
#define EXYNOS3_IRQ_RTC_TIC             IRQ_SPI(74)
#define EXYNOS3_IRQ_SSS 		IRQ_SPI(75)
#define EXYNOS3_IRQ_G2D         	IRQ_SPI(76)

#define EXYNOS3_IRQ_PPMU_LCD0           IRQ_SPI(82)
#define EXYNOS3_IRQ_MIPI_DSI_2LANE      IRQ_SPI(83)

#define EXYNOS3_IRQ_FIMD00              IRQ_SPI(84)
#define EXYNOS3_IRQ_FIMD01              IRQ_SPI(85)
#define EXYNOS3_IRQ_FIMD10              IRQ_SPI(86)
#define EXYNOS3_IRQ_FIMD11              IRQ_SPI(87)

#define EXYNOS3_IRQ_PPMU_TV_M0          IRQ_SPI(90)
#define EXYNOS3_IRQ_MIXER               IRQ_SPI(91)
#define EXYNOS3_IRQ_HDMI                IRQ_SPI(92)

#define EXYNOS3_IRQ_PPMU_MFC_M0 	IRQ_SPI(100)
#define EXYNOS3_IRQ_PPMU_MFC_M1         IRQ_SPI(101)
#define EXYNOS3_IRQ_MFC         	IRQ_SPI(102)

#define EXYNOS3_IRQ_TIMER0              IRQ_SPI(104)
#define EXYNOS3_IRQ_TIMER1              IRQ_SPI(105)
#define EXYNOS3_IRQ_TIMER2              IRQ_SPI(106)
#define EXYNOS3_IRQ_TIMER3              IRQ_SPI(107)
#define EXYNOS3_IRQ_TIMER4              IRQ_SPI(108)
#define EXYNOS3_IRQ_UART0               IRQ_SPI(109)
#define EXYNOS3_IRQ_UART1               IRQ_SPI(110)
#define EXYNOS3_IRQ_UART2               IRQ_SPI(111)
#define EXYNOS3_IRQ_UART3               IRQ_SPI(112)

#define EXYNOS3_IRQ_IIC0                IRQ_SPI(113)
#define EXYNOS3_IRQ_IIC1                IRQ_SPI(114)
#define EXYNOS3_IRQ_IIC2                IRQ_SPI(115)
#define EXYNOS3_IRQ_IIC3                IRQ_SPI(116)
#define EXYNOS3_IRQ_IIC4                IRQ_SPI(117)
#define EXYNOS3_IRQ_IIC5                IRQ_SPI(118)
#define EXYNOS3_IRQ_IIC6                IRQ_SPI(119)
#define EXYNOS3_IRQ_IIC7                IRQ_SPI(120)
#define EXYNOS3_IRQ_SPI0                IRQ_SPI(121)
#define EXYNOS3_IRQ_SPI1                IRQ_SPI(122)
#define EXYNOS3_IRQ_SPI2                IRQ_SPI(123)
#define EXYNOS3_IRQ_I2S0                IRQ_SPI(124)
#define EXYNOS3_IRQ_I2S1                IRQ_SPI(125)

#define EXYNOS3_IRQ_PCM0                IRQ_SPI(128)
#define EXYNOS3_IRQ_PCM1                IRQ_SPI(129)
#define EXYNOS3_IRQ_PCM2                IRQ_SPI(130)
#define EXYNOS3_IRQ_SPDIF               IRQ_SPI(131)

#define EXYNOS3_IRQ_PPMU_FILE_D_M0      IRQ_SPI(136)
#define EXYNOS3_IRQ_ADC			IRQ_SPI(137)
#define EXYNOS3_IRQ_PDMA0		IRQ_SPI(138)
#define EXYNOS3_IRQ_PDMA1		IRQ_SPI(139)

#define EXYNOS3_IRQ_UHOST		IRQ_SPI(140)
#define EXYNOS3_IRQ_HSOTG		IRQ_SPI(141)
#define EXYNOS3_IRQ_HSMMC0		IRQ_SPI(142)
#define EXYNOS3_IRQ_HSMMC1		IRQ_SPI(143)
#define EXYNOS3_IRQ_HSMMC2		IRQ_SPI(144)

#define EXYNOS3_IRQ_SYSMMU_GSC0_0	IRQ_SPI(152)
#define EXYNOS3_IRQ_SYSMMU_GSC1_0	IRQ_SPI(153)
#define EXYNOS3_IRQ_SYSMMU_MSCL0_0	IRQ_SPI(154)
#define EXYNOS3_IRQ_SYSMMU_FIMC30	IRQ_SPI(155)
#define EXYNOS3_IRQ_SYSMMU_JPEG_0	IRQ_SPI(156)
#define EXYNOS3_IRQ_SYSMMU_GSC0_1	IRQ_SPI(157)
#define EXYNOS3_IRQ_SYSMMU_GSC1_1	IRQ_SPI(158)
#define EXYNOS3_IRQ_SYSMMU_MSCL0_1	IRQ_SPI(159)
#define EXYNOS3_IRQ_SYSMMU_FIMC31	IRQ_SPI(160)
#define EXYNOS3_IRQ_SYSMMU_JPEG_1	IRQ_SPI(161)
#define EXYNOS3_IRQ_PPMU_CAMIF_M0		IRQ_SPI(162)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE20	IRQ_SPI(163)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE21	IRQ_SPI(164)
#define EXYNOS3_IRQ_MIPI_CSI_4LANE		IRQ_SPI(165)
#define EXYNOS3_IRQ_MIPI_CSI_2LANE		IRQ_SPI(166)
#define EXYNOS3_IRQ_GSC0		IRQ_SPI(167)
#define EXYNOS3_IRQ_GSC1		IRQ_SPI(168)
#define EXYNOS3_IRQ_MSCL0		IRQ_SPI(169)
#define EXYNOS3_IRQ_FIMC3	IRQ_SPI(170)
#define EXYNOS3_IRQ_JPEG	IRQ_SPI(171)
#define EXYNOS3_IRQ_FIMC_LITE2_C	IRQ_SPI(172)

#define EXYNOS3_IRQ_PPMU_3D		IRQ_SPI(176)
#define EXYNOS3_IRQ_3D_PMU		IRQ_SPI(177)
#define EXYNOS3_IRQ_3D_PPMMU0		IRQ_SPI(178)
#define EXYNOS3_IRQ_3D_PPMMU1		IRQ_SPI(179)
#define EXYNOS3_IRQ_3D_PPMMU2		IRQ_SPI(180)
#define EXYNOS3_IRQ_3D_PPMMU3		IRQ_SPI(181)
#define EXYNOS3_IRQ_3D_GPMMU		IRQ_SPI(182)
#define EXYNOS3_IRQ_3D_PP0		IRQ_SPI(183)
#define EXYNOS3_IRQ_3D_PP1		IRQ_SPI(184)
#define EXYNOS3_IRQ_3D_PP2		IRQ_SPI(185)
#define EXYNOS3_IRQ_3D_PP3		IRQ_SPI(186)
#define EXYNOS3_IRQ_3D_GP		IRQ_SPI(187)
#define EXYNOS3_IRQ_PMU_ISP		IRQ_SPI(192)
#define EXYNOS3_IRQ_CTI_ISP		IRQ_SPI(193)
#define EXYNOS3_IRQ_PPMU_ISP_MX		IRQ_SPI(194)
#define EXYNOS3_IRQ_PPMU_ISP_X		IRQ_SPI(195)
#define EXYNOS3_IRQ_COMB_ARMISP_GIC		IRQ_SPI(196)
#define EXYNOS3_IRQ_COMB_ISP_GIC		IRQ_SPI(197)
#define EXYNOS3_IRQ_FIMC_LITE0		IRQ_SPI(198)
#define EXYNOS3_IRQ_FIMC_LITE1		IRQ_SPI(199)
#define EXYNOS3_IRQ_SYSMMU_LITE0_0		IRQ_SPI(200)
#define EXYNOS3_IRQ_SYSMMU_LITE1_0		IRQ_SPI(201)
#define EXYNOS3_IRQ_SYSMMU_ISP_0	IRQ_SPI(202)
#define EXYNOS3_IRQ_SYSMMU_DRC_0		IRQ_SPI(203)
#define EXYNOS3_IRQ_SYSMMU_FD_0		IRQ_SPI(204)
#define EXYNOS3_IRQ_SYSMMU_ISPCPU_0		IRQ_SPI(205)
#define EXYNOS3_IRQ_SYSMMU_SCALERP0	IRQ_SPI(206)
#define EXYNOS3_IRQ_SYSMMU_SCALERC_0	IRQ_SPI(207)
#define EXYNOS3_IRQ_SYSMMU_LITE0_1		IRQ_SPI(208)
#define EXYNOS3_IRQ_SYSMMU_LITE1_1		IRQ_SPI(209)
#define EXYNOS3_IRQ_SYSMMU_ISP_1	IRQ_SPI(210)
#define EXYNOS3_IRQ_SYSMMU_DRC_1		IRQ_SPI(211)
#define EXYNOS3_IRQ_SYSMMU_FD_1		IRQ_SPI(212)
#define EXYNOS3_IRQ_SYSMMU_ISPCPU_1		IRQ_SPI(213)
#define EXYNOS3_IRQ_SYSMMU_SCALERC_1	IRQ_SPI(215)
#define EXYNOS3_IRQ_TMU			IRQ_SPI(216)
#define EXYNOS3_IRQ_PPMU_D_RIGHT_M0	IRQ_SPI(217)
#define EXYNOS3_IRQ_MCT_G0		IRQ_SPI(218)
#define EXYNOS3_IRQ_MCT_G1		IRQ_SPI(219)
#define EXYNOS3_IRQ_MCT_G2		IRQ_SPI(220)
#define EXYNOS3_IRQ_MCT_G3		IRQ_SPI(221)

#define EXYNOS3_IRQ_MCT_L0		IRQ_SPI(223)
#define EXYNOS3_IRQ_WDT			IRQ_SPI(224)
#define EXYNOS3_IRQ_GPIO_RT		IRQ_SPI(225)
#define EXYNOS3_IRQ_MCT_L1		IRQ_SPI(226)
#define EXYNOS3_IRQ_MCT_L2		IRQ_SPI(227)
#define EXYNOS3_IRQ_MCT_L3		IRQ_SPI(228)
#define EXYNOS3_IRQ_KEYPAD              IRQ_SPI(229)
#define EXYNOS3_IRQ_MONOCNT             IRQ_SPI(230)

#define EXYNOS3_IRQ_PPMU_D_LEFT_M0	IRQ_SPI(237)
#define EXYNOS3_IRQ_PPMU_IMAGE_M0	IRQ_SPI(238)
#define EXYNOS3_IRQ_MDMA                IRQ_SPI(239)
#define EXYNOS3_IRQ_GPIO_LB             IRQ_SPI(240)
#define EXYNOS3_IRQ_AUDIO_SS            IRQ_SPI(241)
#define EXYNOS3_IRQ_GPIO_AUDIO		IRQ_SPI(242)
#define EXYNOS3_IRQ_RP_TIMER            IRQ_SPI(243)

#define EXYNOS3_IRQ_SYSMMU_FIMD0_0 	IRQ_SPI(80)
#define EXYNOS3_IRQ_SYSMMU_FIMD0_1 	IRQ_SPI(81)
#define EXYNOS3_IRQ_SYSMMU_MFC_M0_0     IRQ_SPI(96)
#define EXYNOS3_IRQ_SYSMMU_MFC_M0_1     IRQ_SPI(98)
#define EXYNOS3_IRQ_SYSMMU_GSC0_0	IRQ_SPI(152)
#define EXYNOS3_IRQ_SYSMMU_GSC0_1	IRQ_SPI(157)
#define EXYNOS3_IRQ_SYSMMU_GSC1_0	IRQ_SPI(153)
#define EXYNOS3_IRQ_SYSMMU_GSC1_1	IRQ_SPI(158)
#define EXYNOS3_IRQ_SYSMMU_SCALER_0	IRQ_SPI(154)
#define EXYNOS3_IRQ_SYSMMU_SCALER_1	IRQ_SPI(159)
#define EXYNOS3_IRQ_SYSMMU_JPEG_0	IRQ_SPI(156)
#define EXYNOS3_IRQ_SYSMMU_JPEG_1	IRQ_SPI(161)
#define EXYNOS3_IRQ_JPEG		IRQ_SPI(171)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE0_0	IRQ_SPI(200)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE0_1	IRQ_SPI(208)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE1_0	IRQ_SPI(201)
#define EXYNOS3_IRQ_SYSMMU_FIMC_LITE1_1	IRQ_SPI(209)
#define EXYNOS3_IRQ_SYSMMU_FIMC_ISP_0	IRQ_SPI(202)
#define EXYNOS3_IRQ_SYSMMU_FIMC_ISP_1	IRQ_SPI(210)
#define EXYNOS3_IRQ_SYSMMU_FIMC_DRC_0	IRQ_SPI(203)
#define EXYNOS3_IRQ_SYSMMU_FIMC_DRC_1	IRQ_SPI(211)
#define EXYNOS3_IRQ_SYSMMU_FIMC_FD_0	IRQ_SPI(204)
#define EXYNOS3_IRQ_SYSMMU_FIMC_FD_1	IRQ_SPI(212)
#define EXYNOS3_IRQ_SYSMMU_FIMC_CX_0	IRQ_SPI(205)
#define EXYNOS3_IRQ_SYSMMU_FIMC_CX_1	IRQ_SPI(213)
#define EXYNOS3_IRQ_SYSMMU_FIMC_SCALERC_0 IRQ_SPI(207)
#define EXYNOS3_IRQ_SYSMMU_FIMC_SCALERC_1 IRQ_SPI(215)

/* G3D */
#define EXYNOS3_IRQ_PMU_3D      IRQ_SPI(177)
#define EXYNOS3_IRQ_PPMMU0_3D   IRQ_SPI(178)
#define EXYNOS3_IRQ_PPMMU1_3D   IRQ_SPI(179)
#define EXYNOS3_IRQ_PPMMU2_3D   IRQ_SPI(180)
#define EXYNOS3_IRQ_PPMMU3_3D   IRQ_SPI(181)
#define EXYNOS3_IRQ_GPMMU_3D    IRQ_SPI(182)
#define EXYNOS3_IRQ_PP0_3D      IRQ_SPI(183)
#define EXYNOS3_IRQ_PP1_3D      IRQ_SPI(184)
#define EXYNOS3_IRQ_PP2_3D      IRQ_SPI(185)
#define EXYNOS3_IRQ_PP3_3D      IRQ_SPI(186)
#define EXYNOS3_IRQ_GP_3D       IRQ_SPI(187)

#define EXYNOS3_IRQ_GPIO1_NR_GROUPS     12
#define EXYNOS3_IRQ_GPIO2_NR_GROUPS     16

#define EXYNOS3_IRQ_PPI_MAX		IRQ_SPI(256)


#ifdef CONFIG_SOC_EXYNOS4415
#include <mach/irqs-exynos4415.h>
#elif defined(CONFIG_SOC_EXYNOS3470)
#include <mach/irqs-exynos3470.h>
#else
/* For EXYNOS4 and EXYNOS5 */
#define EXYNOS4_IRQ_ADMA		IRQ_SPI(231)
#define EXYNOS4_IRQ_MCT_L2		IRQ_SPI(227)
#define EXYNOS4_IRQ_MCT_L3		IRQ_SPI(228)

#define EXYNOS_IRQ_EINT16_31		IRQ_SPI(32)

/* For EXYNOS4 SoCs */

#define EXYNOS4_IRQ_EINT0		IRQ_SPI(16)
#define EXYNOS4_IRQ_EINT1		IRQ_SPI(17)
#define EXYNOS4_IRQ_EINT2		IRQ_SPI(18)
#define EXYNOS4_IRQ_EINT3		IRQ_SPI(19)
#define EXYNOS4_IRQ_EINT4		IRQ_SPI(20)
#define EXYNOS4_IRQ_EINT5		IRQ_SPI(21)
#define EXYNOS4_IRQ_EINT6		IRQ_SPI(22)
#define EXYNOS4_IRQ_EINT7		IRQ_SPI(23)
#define EXYNOS4_IRQ_EINT8		IRQ_SPI(24)
#define EXYNOS4_IRQ_EINT9		IRQ_SPI(25)
#define EXYNOS4_IRQ_EINT10		IRQ_SPI(26)
#define EXYNOS4_IRQ_EINT11		IRQ_SPI(27)
#define EXYNOS4_IRQ_EINT12		IRQ_SPI(28)
#define EXYNOS4_IRQ_EINT13		IRQ_SPI(29)
#define EXYNOS4_IRQ_EINT14		IRQ_SPI(30)
#define EXYNOS4_IRQ_EINT15		IRQ_SPI(31)

#define EXYNOS4_IRQ_MDMA0		IRQ_SPI(33)
#define EXYNOS4_IRQ_MDMA1		IRQ_SPI(34)
#define EXYNOS4_IRQ_PDMA0		IRQ_SPI(35)
#define EXYNOS4_IRQ_PDMA1		IRQ_SPI(36)
#define EXYNOS4_IRQ_TIMER0_VIC		IRQ_SPI(37)
#define EXYNOS4_IRQ_TIMER1_VIC		IRQ_SPI(38)
#define EXYNOS4_IRQ_TIMER2_VIC		IRQ_SPI(39)
#define EXYNOS4_IRQ_TIMER3_VIC		IRQ_SPI(40)
#define EXYNOS4_IRQ_TIMER4_VIC		IRQ_SPI(41)
#define EXYNOS4_IRQ_MCT_L0		IRQ_SPI(42)
#define EXYNOS4_IRQ_COMBINER_G19	IRQ_SPI(42)
#define EXYNOS4_IRQ_WDT			IRQ_SPI(43)
#define EXYNOS4_IRQ_RTC_ALARM		IRQ_SPI(44)
#define EXYNOS4_IRQ_RTC_TIC		IRQ_SPI(45)
#define EXYNOS4_IRQ_GPIO_XB		IRQ_SPI(46)
#define EXYNOS4_IRQ_GPIO_XA		IRQ_SPI(47)
#define EXYNOS4_IRQ_MCT_L1		IRQ_SPI(48)
#define EXYNOS4_IRQ_COMBINER_G18	IRQ_SPI(48)

#define EXYNOS4_IRQ_UART0		IRQ_SPI(52)
#define EXYNOS4_IRQ_UART1		IRQ_SPI(53)
#define EXYNOS4_IRQ_UART2		IRQ_SPI(54)
#define EXYNOS4_IRQ_UART3		IRQ_SPI(55)
#define EXYNOS4_IRQ_UART4		IRQ_SPI(56)
#define EXYNOS4_IRQ_MCT_G0		IRQ_SPI(57)
#define EXYNOS4_IRQ_IIC			IRQ_SPI(58)
#define EXYNOS4_IRQ_IIC1		IRQ_SPI(59)
#define EXYNOS4_IRQ_IIC2		IRQ_SPI(60)
#define EXYNOS4_IRQ_IIC3		IRQ_SPI(61)
#define EXYNOS4_IRQ_IIC4		IRQ_SPI(62)
#define EXYNOS4_IRQ_IIC5		IRQ_SPI(63)
#define EXYNOS4_IRQ_IIC6		IRQ_SPI(64)
#define EXYNOS4_IRQ_IIC7		IRQ_SPI(65)
#define EXYNOS4_IRQ_SPI0		IRQ_SPI(66)
#define EXYNOS4_IRQ_SPI1		IRQ_SPI(67)
#define EXYNOS4_IRQ_SPI2		IRQ_SPI(68)

#define EXYNOS4_IRQ_USB_HOST		IRQ_SPI(70)
#define EXYNOS4_IRQ_OTG			IRQ_SPI(71)
#define EXYNOS4_IRQ_MODEM_IF		IRQ_SPI(72)
#define EXYNOS4_IRQ_HSMMC0		IRQ_SPI(73)
#define EXYNOS4_IRQ_HSMMC1		IRQ_SPI(74)
#define EXYNOS4_IRQ_HSMMC2		IRQ_SPI(75)
#define EXYNOS4_IRQ_HSMMC3		IRQ_SPI(76)
#define EXYNOS4_IRQ_DWMCI		IRQ_SPI(77)

#define EXYNOS4_IRQ_MIPI_CSIS0		IRQ_SPI(78)
#define EXYNOS4_IRQ_MIPI_CSIS1		IRQ_SPI(80)

#define EXYNOS4_IRQ_ONENAND_AUDI	IRQ_SPI(82)
#define EXYNOS4_IRQ_ROTATOR		IRQ_SPI(83)
#define EXYNOS4_IRQ_FIMC0		IRQ_SPI(84)
#define EXYNOS4_IRQ_FIMC1		IRQ_SPI(85)
#define EXYNOS4_IRQ_FIMC2		IRQ_SPI(86)
#define EXYNOS4_IRQ_FIMC3		IRQ_SPI(87)
#define EXYNOS4_IRQ_JPEG		IRQ_SPI(88)
#define EXYNOS4_IRQ_2D			IRQ_SPI(89)
#define EXYNOS4_IRQ_PCIE		IRQ_SPI(90)
#define EXYNOS4_IRQ_ARMISP_GIC		IRQ_SPI(90)

#define EXYNOS4_IRQ_MIXER		IRQ_SPI(91)
#define EXYNOS4_IRQ_HDMI		IRQ_SPI(92)
#define EXYNOS4_IRQ_IIC_HDMIPHY		IRQ_SPI(93)
#define EXYNOS4_IRQ_MFC			IRQ_SPI(94)
#define EXYNOS4_IRQ_SDO			IRQ_SPI(95)
#define EXYNOS4_IRQ_ISP_GIC		IRQ_SPI(95)

#define EXYNOS4_IRQ_AUDIO_SS		IRQ_SPI(96)
#define EXYNOS4_IRQ_I2S0		IRQ_SPI(97)
#define EXYNOS4_IRQ_I2S1		IRQ_SPI(98)
#define EXYNOS4_IRQ_I2S2		IRQ_SPI(99)
#define EXYNOS4_IRQ_AC97		IRQ_SPI(100)

#define EXYNOS4_IRQ_SPDIF		IRQ_SPI(104)
#define EXYNOS4_IRQ_ADC0		IRQ_SPI(105)
#define EXYNOS4_IRQ_PEN0		IRQ_SPI(106)
#define EXYNOS4_IRQ_FIMC_LITE0		IRQ_SPI(105)
#define EXYNOS4_IRQ_FIMC_LITE1		IRQ_SPI(106)
#define EXYNOS4_IRQ_ADC1		IRQ_SPI(107)
#define EXYNOS4_IRQ_COMBINER_G16	IRQ_SPI(107)
#define EXYNOS4_IRQ_PEN1		IRQ_SPI(108)
#define EXYNOS4_IRQ_COMBINER_G17	IRQ_SPI(108)
#define EXYNOS4_IRQ_KEYPAD		IRQ_SPI(109)
#define EXYNOS4_IRQ_GPS			IRQ_SPI(111)
#define EXYNOS4_IRQ_INTFEEDCTRL_SSS	IRQ_SPI(112)
#define EXYNOS4_IRQ_SLIMBUS		IRQ_SPI(113)

#define EXYNOS4_IRQ_CEC			IRQ_SPI(114)
#define EXYNOS4_IRQ_TSI			IRQ_SPI(115)
#define EXYNOS4_IRQ_SATA		IRQ_SPI(116)

#define EXYNOS4_IRQ_PMU_3D		IRQ_SPI(117)
#define EXYNOS4_IRQ_PPMMU0_3D		IRQ_SPI(118)
#define EXYNOS4_IRQ_PPMMU1_3D		IRQ_SPI(119)
#define EXYNOS4_IRQ_PPMMU2_3D		IRQ_SPI(120)
#define EXYNOS4_IRQ_PPMMU3_3D		IRQ_SPI(121)
#define EXYNOS4_IRQ_GPMMU_3D		IRQ_SPI(122)

#define EXYNOS4_IRQ_PP0_3D		IRQ_SPI(123)
#define EXYNOS4_IRQ_PP1_3D		IRQ_SPI(124)
#define EXYNOS4_IRQ_PP2_3D		IRQ_SPI(125)
#define EXYNOS4_IRQ_PP3_3D		IRQ_SPI(126)
#define EXYNOS4_IRQ_GP_3D		IRQ_SPI(127)

#define EXYNOS4_IRQ_PMU_CPU0		COMBINER_IRQ(2, 2)
#define EXYNOS4_IRQ_PMU_CPU1		COMBINER_IRQ(3, 2)

#define EXYNOS4_IRQ_SYSMMU_MDMA0_0	COMBINER_IRQ(4, 0)
#define EXYNOS4_IRQ_SYSMMU_SSS_0	COMBINER_IRQ(4, 1)
#define EXYNOS4_IRQ_SYSMMU_FIMC0_0	COMBINER_IRQ(4, 2)
#define EXYNOS4_IRQ_SYSMMU_FIMC1_0	COMBINER_IRQ(4, 3)
#define EXYNOS4_IRQ_SYSMMU_FIMC2_0	COMBINER_IRQ(4, 4)
#define EXYNOS4_IRQ_SYSMMU_FIMC3_0	COMBINER_IRQ(4, 5)
#define EXYNOS4_IRQ_SYSMMU_JPEG_0	COMBINER_IRQ(4, 6)
#define EXYNOS4_IRQ_SYSMMU_2D_0		COMBINER_IRQ(4, 7)

#define EXYNOS4_IRQ_SYSMMU_ROTATOR_0	COMBINER_IRQ(5, 0)
#define EXYNOS4_IRQ_SYSMMU_MDMA1_0	COMBINER_IRQ(5, 1)
#define EXYNOS4_IRQ_SYSMMU_LCD0_M0_0	COMBINER_IRQ(5, 2)
#define EXYNOS4_IRQ_SYSMMU_LCD1_M1_0	COMBINER_IRQ(5, 3)
#define EXYNOS4_IRQ_SYSMMU_TV_M0_0	COMBINER_IRQ(5, 4)
#define EXYNOS4_IRQ_SYSMMU_MFC_M0_0	COMBINER_IRQ(5, 5)
#define EXYNOS4_IRQ_SYSMMU_MFC_M1_0	COMBINER_IRQ(5, 6)
#define EXYNOS4_IRQ_SYSMMU_PCIE_0	COMBINER_IRQ(5, 7)
#define EXYNOS4_IRQ_SYSMMU_FIMC_LITE0_0	COMBINER_IRQ(16, 0)
#define EXYNOS4_IRQ_SYSMMU_FIMC_LITE1_0	COMBINER_IRQ(16, 1)
#define EXYNOS4_IRQ_SYSMMU_FIMC_ISP_0	COMBINER_IRQ(16, 2)
#define EXYNOS4_IRQ_SYSMMU_FIMC_DRC_0	COMBINER_IRQ(16, 3)
#define EXYNOS4_IRQ_SYSMMU_FIMC_FD_0	COMBINER_IRQ(16, 4)
#define EXYNOS4_IRQ_SYSMMU_FIMC_CX_0	COMBINER_IRQ(16, 5)

#define EXYNOS4X12_IRQ_ADC0		COMBINER_IRQ(10, 3)

#define EXYNOS4_IRQ_FIMD0_FIFO		COMBINER_IRQ(11, 0)
#define EXYNOS4_IRQ_FIMD0_VSYNC		COMBINER_IRQ(11, 1)
#define EXYNOS4_IRQ_FIMD0_SYSTEM	COMBINER_IRQ(11, 2)

#define EXYNOS4_IRQ_PMU_CPU2		COMBINER_IRQ(18, 2)
#define EXYNOS4_IRQ_PMU_CPU3		COMBINER_IRQ(19, 2)
#endif

#ifdef CONFIG_SOC_EXYNOS4412
#define EXYNOS4_MAX_COMBINER_NR		20
#else
#define EXYNOS4_MAX_COMBINER_NR		18
#endif
#define EXYNOS4_MAX_COMBINER_COMMON_NR	16

#define EXYNOS4_IRQ_GPIO1_NR_GROUPS	16
#define EXYNOS4_IRQ_GPIO2_NR_GROUPS	9
#define EXYNOS4X12_IRQ_GPIO1_NR_GROUPS	13
#define EXYNOS4X12_IRQ_GPIO2_NR_GROUPS	12

/* For EXYNOS5 SoCs */

#define EXYNOS5_IRQ_MDMA0		IRQ_SPI(33)
#define EXYNOS5_IRQ_PDMA0		IRQ_SPI(34)
#define EXYNOS5_IRQ_PDMA1		IRQ_SPI(35)
#define EXYNOS5_IRQ_TIMER0_VIC		IRQ_SPI(36)
#define EXYNOS5_IRQ_TIMER1_VIC		IRQ_SPI(37)
#define EXYNOS5_IRQ_TIMER2_VIC		IRQ_SPI(38)
#define EXYNOS5_IRQ_TIMER3_VIC		IRQ_SPI(39)
#define EXYNOS5_IRQ_TIMER4_VIC		IRQ_SPI(40)
#define EXYNOS5_IRQ_RTIC		IRQ_SPI(41)
#define EXYNOS5_IRQ_WDT			IRQ_SPI(42)
#define EXYNOS5_IRQ_RTC_ALARM		IRQ_SPI(43)
#define EXYNOS5_IRQ_RTC_TIC		IRQ_SPI(44)
#define EXYNOS5_IRQ_GPIO_XB		IRQ_SPI(45)
#define EXYNOS5_IRQ_GPIO_RT		IRQ_SPI(45)
#define EXYNOS5_IRQ_GPIO_XA		IRQ_SPI(46)
#define EXYNOS5_IRQ_GPIO_LB		IRQ_SPI(46)
#define EXYNOS5_IRQ_GPIO		IRQ_SPI(47)
#define EXYNOS5_IRQ_IEM_IEC		IRQ_SPI(48)
#define EXYNOS5_IRQ_IEM_APC		IRQ_SPI(49)
#define EXYNOS5_IRQ_GPIO_B		IRQ_SPI(50)
#define EXYNOS5_IRQ_GPIO_C2C		IRQ_SPI(50)
#if defined(CONFIG_SOC_EXYNOS5260)
#define EXYNOS5_IRQ_UART0		IRQ_SPI(146)
#define EXYNOS5_IRQ_UART1		IRQ_SPI(147)
#define EXYNOS5_IRQ_UART2		IRQ_SPI(148)
#define EXYNOS5_IRQ_UART3		IRQ_SPI(246)
#else
#define EXYNOS5_IRQ_UART0		IRQ_SPI(51)
#define EXYNOS5_IRQ_UART1		IRQ_SPI(52)
#define EXYNOS5_IRQ_UART2		IRQ_SPI(53)
#define EXYNOS5_IRQ_UART3		IRQ_SPI(54)
#endif
#define EXYNOS5_MONOCNT			IRQ_SPI(55)
#define EXYNOS5_IRQ_IIC			IRQ_SPI(56)
#define EXYNOS5_IRQ_IIC1		IRQ_SPI(57)
#define EXYNOS5_IRQ_IIC2		IRQ_SPI(58)
#define EXYNOS5_IRQ_IIC3		IRQ_SPI(59)
#define EXYNOS5_IRQ_IIC4		IRQ_SPI(60)
#define EXYNOS5_IRQ_IIC5		IRQ_SPI(61)
#define EXYNOS5_IRQ_IIC6		IRQ_SPI(62)
#define EXYNOS5_IRQ_IIC7		IRQ_SPI(63)
#define EXYNOS5_IRQ_IIC_HDMIPHY		IRQ_SPI(64)
#define EXYNOS5_IRQ_TMU			IRQ_SPI(65)
#define EXYNOS5_IRQ_FIQ_0		IRQ_SPI(66)
#define EXYNOS5_IRQ_FIQ_1		IRQ_SPI(67)
#define EXYNOS5_IRQ_SPI0		IRQ_SPI(68)
#define EXYNOS5_IRQ_SPI1		IRQ_SPI(69)
#define EXYNOS5_IRQ_SPI2		IRQ_SPI(70)
#if defined(CONFIG_SOC_EXYNOS5260)
#define EXYNOS5_IRQ_USB_HOST		EXYNOS5260_IRQ_USB_HOST
#define EXYNOS5_IRQ_USB3_DRD0		EXYNOS5260_IRQ_USB3_DRD
#else
#define EXYNOS5_IRQ_USB_HOST		IRQ_SPI(71)
#define EXYNOS5_IRQ_USB3_DRD0		IRQ_SPI(72)
#endif
#define EXYNOS5_IRQ_MIPI_HSI		IRQ_SPI(73)
#if defined(CONFIG_SOC_EXYNOS5420)
#define EXYNOS5_IRQ_USB3_DRD1		IRQ_SPI(73)
#else
#define EXYNOS5_IRQ_USB3_DRD1		IRQ_SPI(200)
#endif
#define EXYNOS5_IRQ_OTG			IRQ_SPI(74)
#define EXYNOS5_IRQ_HSMMC0		IRQ_SPI(75)
#define EXYNOS5_IRQ_HSMMC1		IRQ_SPI(76)
#define EXYNOS5_IRQ_HSMMC2		IRQ_SPI(77)
#define EXYNOS5_IRQ_GPIO_T		IRQ_SPI(78)
#define EXYNOS5_IRQ_HSMMC3		IRQ_SPI(78)
#define EXYNOS5_IRQ_MIPICSI0		IRQ_SPI(79)
#define EXYNOS5_IRQ_MIPICSI1		IRQ_SPI(80)
#define EXYNOS5_IRQ_MIPICSI2		IRQ_SPI(193)
#define EXYNOS5_IRQ_EFNFCON_DMA_ABORT	IRQ_SPI(81)
#define EXYNOS5_IRQ_JPEG_HX		IRQ_SPI(89)
#define EXYNOS5_IRQ_JPEG		IRQ_SPI(168)
#ifdef CONFIG_SOC_EXYNOS5250
#define EXYNOS5_IRQ_MIPIDSI0		IRQ_SPI(82)
#else
#define EXYNOS5_IRQ_MIPIDSI0		IRQ_SPI(81)
#endif
#define EXYNOS5_IRQ_MIPIDSI1		IRQ_SPI(82)
#define EXYNOS5_IRQ_WDT_IOP		IRQ_SPI(83)
#define EXYNOS5_IRQ_ROTATOR		IRQ_SPI(84)
#define EXYNOS5_IRQ_GSC0		IRQ_SPI(85)
#define EXYNOS5_IRQ_GSC1		IRQ_SPI(86)
#define EXYNOS5_IRQ_IIC8		IRQ_SPI(87)
#define EXYNOS5_IRQ_IIC9		IRQ_SPI(88)
#define EXYNOS5_IRQ_GSC2		IRQ_SPI(87)
#define EXYNOS5_IRQ_GSC3		IRQ_SPI(88)
#define EXYNOS5_IRQ_EFNFCON_DMA		IRQ_SPI(90)
#if defined(CONFIG_SOC_EXYNOS5410)
#define EXYNOS5_IRQ_MSCL0		IRQ_SPI(90)
#define EXYNOS5_IRQ_MSCL1		IRQ_SPI(221)
#elif defined(CONFIG_SOC_EXYNOS5420)
#define EXYNOS5_IRQ_MSCL0		IRQ_SPI(220)
#define EXYNOS5_IRQ_MSCL1		IRQ_SPI(221)
#elif defined(CONFIG_SOC_EXYNOS5260)
#define EXYNOS5_IRQ_MSCL0		IRQ_SPI(170)
#define EXYNOS5_IRQ_MSCL1		IRQ_SPI(171)
#elif defined(CONFIG_SOC_EXYNOS3250)
#define EXYNOS5_IRQ_MSCL0		IRQ_SPI(169)
#define EXYNOS5_IRQ_MSCL1		IRQ_SPI(169)
#endif

#define EXYNOS5_IRQ_MSCL2		IRQ_SPI(222)
#define EXYNOS5_IRQ_2D			IRQ_SPI(91)
#define EXYNOS5_IRQ_EFNFCON_0		IRQ_SPI(92)
#define EXYNOS5_IRQ_EFNFCON_1		IRQ_SPI(93)
#define EXYNOS5_IRQ_MIXER		IRQ_SPI(94)
#define EXYNOS5_IRQ_HDMI		IRQ_SPI(95)
#define EXYNOS5_IRQ_MFC			IRQ_SPI(96)
#define EXYNOS5_IRQ_AUDIO_SS		IRQ_SPI(97)
#if defined(CONFIG_SOC_EXYNOS5410) || defined(CONFIG_SOC_EXYNOS5420)
#define EXYNOS5_IRQ_I2S0		IRQ_SPI(115)
#elif defined(CONFIG_SOC_EXYNOS5250)
#define EXYNOS5_IRQ_I2S0		IRQ_SPI(98)
#endif
#define EXYNOS5_IRQ_I2S1		IRQ_SPI(99)
#define EXYNOS5_IRQ_I2S2		IRQ_SPI(100)
#define EXYNOS5_IRQ_AC97		IRQ_SPI(101)
#define EXYNOS5_IRQ_PCM0		IRQ_SPI(102)
#define EXYNOS5_IRQ_PCM1		IRQ_SPI(103)
#define EXYNOS5_IRQ_PCM2		IRQ_SPI(104)
#define EXYNOS5_IRQ_SPDIF		IRQ_SPI(105)
#define EXYNOS5_IRQ_ADC0		IRQ_SPI(106)
#define EXYNOS5_IRQ_ADC1		IRQ_SPI(107)
#define EXYNOS5_IRQ_SATA_PHY		IRQ_SPI(108)
#define EXYNOS5_IRQ_SATA_PMEMREQ	IRQ_SPI(109)

#define EXYNOS5_IRQ_ADMA0		IRQ_SPI(110)
#if defined(CONFIG_SOC_EXYNOS5250) || defined(CONFIG_SOC_EXYNOS5410)
#define EXYNOS5_IRQ_FIMC_LITE2		IRQ_SPI(110)
#elif defined(CONFIG_SOC_EXYNOS5420)
#define EXYNOS5_IRQ_FIMC_LITE2		IRQ_SPI(90)
#endif
#define EXYNOS5_IRQ_EAGLE_PMU		IRQ_SPI(111)
#define EXYNOS5_IRQ_INTFEEDCTRL_SSS	IRQ_SPI(112)
#define EXYNOS5_IRQ_DP1_INTP1		IRQ_SPI(113)
#define EXYNOS5_IRQ_CEC			IRQ_SPI(114)
#define EXYNOS5_IRQ_SATA		IRQ_SPI(115)

#define EXYNOS5_GPU_IRQ_NUMBER		IRQ_SPI(117)
#if defined(CONFIG_SOC_EXYNOS5420)
#define EXYNOS5_JOB_IRQ_NUMBER		IRQ_SPI(219)
#define EXYNOS5_MMU_IRQ_NUMBER		IRQ_SPI(74)
#else
#define EXYNOS5_JOB_IRQ_NUMBER		IRQ_SPI(118)
#define EXYNOS5_MMU_IRQ_NUMBER		IRQ_SPI(119)
#endif

#define EXYNOS5_IRQ_MCT_L0		IRQ_SPI(120)
#define EXYNOS5_IRQ_MCT_L1		IRQ_SPI(121)
#define EXYNOS5_IRQ_MCT_L2		IRQ_SPI(122)
#define EXYNOS5_IRQ_MCT_L3		IRQ_SPI(123)
#define EXYNOS5_IRQ_MCT_L4		IRQ_SPI(128)
#define EXYNOS5_IRQ_MCT_L5		IRQ_SPI(129)
#define EXYNOS5_IRQ_MCT_L6		IRQ_SPI(130)
#define EXYNOS5_IRQ_MCT_L7		IRQ_SPI(131)

#define EXYNOS5_IRQ_DWMCI		IRQ_SPI(123)

#define EXYNOS5_IRQ_MDMA1		IRQ_SPI(124)
#define EXYNOS5_IRQ_FIMC_LITE0		IRQ_SPI(125)
#define EXYNOS5_IRQ_FIMC_LITE1		IRQ_SPI(126)
#define EXYNOS5_IRQ_RP_TIMER		IRQ_SPI(127)
#define EXYNOS54XX_IRQ_TMU1		IRQ_SPI(183)
#define EXYNOS54XX_IRQ_TMU2		IRQ_SPI(184)
#define EXYNOS54XX_IRQ_TMU3		IRQ_SPI(185)
#define EXYNOS5420_IRQ_TMU_GPU		IRQ_SPI(215)

#define EXYNOS5_IRQ_MIPICSI2		IRQ_SPI(193)

#define EXYNOS5_IRQ_INTFEEDCTRL_SLIMSSS	IRQ_SPI(196)

#define EXYNOS5_IRQ_IIC10		IRQ_SPI(203)

#define EXYNOS5_IRQ_PMU_CPU0		COMBINER_IRQ(1, 2)

#define EXYNOS5_IRQ_SYSMMU_GSC0_0	COMBINER_IRQ(2, 0)
#define EXYNOS5_IRQ_SYSMMU_GSC0_1	COMBINER_IRQ(2, 1)
#define EXYNOS5_IRQ_SYSMMU_GSC1_0	COMBINER_IRQ(2, 2)
#define EXYNOS5_IRQ_SYSMMU_GSC1_1	COMBINER_IRQ(2, 3)
#define EXYNOS5_IRQ_SYSMMU_LITE3_0	COMBINER_IRQ(2, 4)
#define EXYNOS5_IRQ_SYSMMU_LITE3_1	COMBINER_IRQ(2, 5)
#define EXYNOS5_IRQ_SYSMMU_GSC2_0	COMBINER_IRQ(2, 4)
#define EXYNOS5_IRQ_SYSMMU_GSC2_1	COMBINER_IRQ(2, 5)
#define EXYNOS5_IRQ_SYSMMU_GSC3_0	COMBINER_IRQ(2, 6)
#define EXYNOS5_IRQ_SYSMMU_GSC3_1	COMBINER_IRQ(2, 7)

#define EXYNOS5_IRQ_SYSMMU_LITE2_0	COMBINER_IRQ(3, 0)
#define EXYNOS5_IRQ_SYSMMU_LITE2_1	COMBINER_IRQ(3, 1)
#define EXYNOS5_IRQ_SYSMMU_FIMD1_0	COMBINER_IRQ(3, 2)
#define EXYNOS5_IRQ_SYSMMU_FIMD1_1	COMBINER_IRQ(3, 3)
#define EXYNOS5_IRQ_SYSMMU_FIMD1A_0	COMBINER_IRQ(3, 0)
#define EXYNOS5_IRQ_SYSMMU_FIMD1A_1	COMBINER_IRQ(3, 1)
#define EXYNOS5_IRQ_SYSMMU_LITE0_0	COMBINER_IRQ(3, 4)
#define EXYNOS5_IRQ_SYSMMU_LITE0_1	COMBINER_IRQ(3, 5)
#define EXYNOS5_IRQ_SYSMMU_SCALERPISP_0	COMBINER_IRQ(3, 6)
#define EXYNOS5_IRQ_SYSMMU_SCALERPISP_1	COMBINER_IRQ(3, 7)

#define EXYNOS5_IRQ_SYSMMU_ROTATOR_0	COMBINER_IRQ(4, 0)
#define EXYNOS5_IRQ_SYSMMU_ROTATOR_1	COMBINER_IRQ(4, 1)
#define EXYNOS5_IRQ_SYSMMU_JPEG_0	COMBINER_IRQ(4, 2)
#define EXYNOS5_IRQ_SYSMMU_JPEG_1	COMBINER_IRQ(4, 3)

#define EXYNOS5_IRQ_SYSMMU_FD_0		COMBINER_IRQ(5, 0)
#define EXYNOS5_IRQ_SYSMMU_FD_1		COMBINER_IRQ(5, 1)
#define EXYNOS5_IRQ_SYSMMU_SCALERCISP_0	COMBINER_IRQ(5, 2)
#define EXYNOS5_IRQ_SYSMMU_SCALERCISP_1	COMBINER_IRQ(5, 3)
#define EXYNOS5_IRQ_SYSMMU_MCUISP_0	COMBINER_IRQ(5, 4)
#define EXYNOS5_IRQ_SYSMMU_MCUISP_1	COMBINER_IRQ(5, 5)
#define EXYNOS5_IRQ_SYSMMU_3DNR_0	COMBINER_IRQ(5, 6)
#define EXYNOS5_IRQ_SYSMMU_3DNR_1	COMBINER_IRQ(5, 7)

#define EXYNOS5_IRQ_SYSMMU_ARM_0	COMBINER_IRQ(6, 0)
#define EXYNOS5_IRQ_SYSMMU_ARM_1	COMBINER_IRQ(6, 1)
#define EXYNOS5_IRQ_SYSMMU_MFC_R_0	COMBINER_IRQ(6, 2)
#define EXYNOS5_IRQ_SYSMMU_MFC_R_1	COMBINER_IRQ(6, 3)
#define EXYNOS5_IRQ_SYSMMU_RTIC_0	COMBINER_IRQ(6, 4)
#define EXYNOS5_IRQ_SYSMMU_RTIC_1	COMBINER_IRQ(6, 5)
#define EXYNOS5_IRQ_SYSMMU_SSS_0	COMBINER_IRQ(6, 6)
#define EXYNOS5_IRQ_SYSMMU_SSS_1	COMBINER_IRQ(6, 7)

#define EXYNOS5_IRQ_SYSMMU_MDMA0_0	COMBINER_IRQ(7, 0)
#define EXYNOS5_IRQ_SYSMMU_MDMA0_1	COMBINER_IRQ(7, 1)
#define EXYNOS5_IRQ_SYSMMU_MDMA1_0	COMBINER_IRQ(7, 2)
#define EXYNOS5_IRQ_SYSMMU_MDMA1_1	COMBINER_IRQ(7, 3)
#define EXYNOS5_IRQ_SYSMMU_TV_0		COMBINER_IRQ(7, 4)
#define EXYNOS5_IRQ_SYSMMU_TV_1		COMBINER_IRQ(7, 5)

#define EXYNOS5_IRQ_SYSMMU_MFC_L_0	COMBINER_IRQ(8, 5)
#define EXYNOS5_IRQ_SYSMMU_MFC_L_1	COMBINER_IRQ(8, 6)

#define EXYNOS5_IRQ_SYSMMU_DIS1_0	COMBINER_IRQ(9, 4)
#define EXYNOS5_IRQ_SYSMMU_DIS1_1	COMBINER_IRQ(9, 5)

#define EXYNOS5_IRQ_DP			COMBINER_IRQ(10, 3)
#define EXYNOS5_IRQ_SYSMMU_DIS0_0	COMBINER_IRQ(10, 4)
#define EXYNOS5_IRQ_SYSMMU_DIS0_1	COMBINER_IRQ(10, 5)
#define EXYNOS5_IRQ_SYSMMU_ISP_0	COMBINER_IRQ(10, 6)
#define EXYNOS5_IRQ_SYSMMU_ISP_1	COMBINER_IRQ(10, 7)

#define EXYNOS5_IRQ_SYSMMU_ODC_0	COMBINER_IRQ(11, 0)
#define EXYNOS5_IRQ_SYSMMU_ODC_1	COMBINER_IRQ(11, 1)
#define EXYNOS5_IRQ_SYSMMU_DRC_0	COMBINER_IRQ(11, 6)
#define EXYNOS5_IRQ_SYSMMU_DRC_1	COMBINER_IRQ(11, 7)

/* Exynos5 variation */
#define EXYNOS5_IRQ_SYSMMU_MDMA_1	IRQ_SPI(199)
#define EXYNOS5_IRQ_SYSMMU_MDMA_0	IRQ_SPI(198)
#define EXYNOS5_IRQ_SYSMMU_S3D_0	IRQ_SPI(192)
#define EXYNOS5_IRQ_SYSMMU_S3D_1	IRQ_SPI(191)
#define EXYNOS5_IRQ_SYSMMU_JPEGA_0	IRQ_SPI(169)
#define EXYNOS5_IRQ_SYSMMU_JPEGA_1	IRQ_SPI(170)
#define EXYNOS5_IRQ_SYSMMU_DRCA_0	COMBINER_IRQ(4, 6)
#define EXYNOS5_IRQ_SYSMMU_DRCA_1	COMBINER_IRQ(4, 7)
#define EXYNOS5_IRQ_SYSMMU_FIMD0_0	COMBINER_IRQ(11, 6)
#define EXYNOS5_IRQ_SYSMMU_FIMD0_1	COMBINER_IRQ(11, 7)
#define EXYNOS5_IRQ_SYSMMU_3AA_0	COMBINER_IRQ(23, 6)
#define EXYNOS5_IRQ_SYSMMU_3AA_1	COMBINER_IRQ(23, 7)
#define EXYNOS5_IRQ_SYSMMU_SCALER_0	COMBINER_IRQ(10, 0)
#define EXYNOS5_IRQ_SYSMMU_SCALER_1	COMBINER_IRQ(10, 1)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL0_0	COMBINER_IRQ(22, 4)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL0_1	COMBINER_IRQ(22, 5)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL0_0	COMBINER_IRQ(27, 2)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL0_1	COMBINER_IRQ(27, 3)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL1_0	IRQ_SPI(186)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL1_1	IRQ_SPI(187)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL1_0	COMBINER_IRQ(22, 6)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL1_1	COMBINER_IRQ(22, 7)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL2_0	IRQ_SPI(188)
#define EXYNOS5_IRQ_SYSMMU_R_MSCL2_1	IRQ_SPI(189)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL2_0	COMBINER_IRQ(19, 6)
#define EXYNOS5_IRQ_SYSMMU_W_MSCL2_1	COMBINER_IRQ(19, 7)
#define EXYNOS5_IRQ_MDMA1_ABORT		COMBINER_IRQ(13, 1)

#define EXYNOS5_IRQ_MDMA0_ABORT		COMBINER_IRQ(15, 3)

#define EXYNOS5_IRQ_PMU_CPU2		COMBINER_IRQ(16, 6)

#define EXYNOS5_IRQ_FIMD1_FIFO		COMBINER_IRQ(18, 4)
#define EXYNOS5_IRQ_FIMD1_VSYNC		COMBINER_IRQ(18, 5)
#define EXYNOS5_IRQ_FIMD1_SYSTEM	COMBINER_IRQ(18, 6)

#define EXYNOS5_IRQ_ARMIOP_GIC		COMBINER_IRQ(19, 0)
#define EXYNOS5_IRQ_ARMISP_GIC		COMBINER_IRQ(19, 1)
#define EXYNOS5_IRQ_PMU_CPU3		COMBINER_IRQ(19, 2)
#define EXYNOS5_IRQ_IOP_GIC		COMBINER_IRQ(19, 3)
#define EXYNOS5_IRQ_ISP_GIC		COMBINER_IRQ(19, 4)

#define EXYNOS5_IRQ_PMU_CPU1		COMBINER_IRQ(22, 4)

#define EXYNOS5_IRQ_EINT0		COMBINER_IRQ(23, 0)
#define EXYNOS5_IRQ_MCT_G0		COMBINER_IRQ(23, 3)
#define EXYNOS5_IRQ_MCT_G1		COMBINER_IRQ(23, 4)

#define EXYNOS5_IRQ_EINT1		COMBINER_IRQ(24, 0)
#define EXYNOS5_IRQ_SYSMMU_LITE1_0	COMBINER_IRQ(24, 1)
#define EXYNOS5_IRQ_SYSMMU_LITE1_1	COMBINER_IRQ(24, 2)
#define EXYNOS5_IRQ_SYSMMU_2D_0		COMBINER_IRQ(24, 5)
#define EXYNOS5_IRQ_SYSMMU_2D_1		COMBINER_IRQ(24, 6)
#define EXYNOS5_IRQ_SYSMMU_2DV_0	COMBINER_IRQ(22, 2)
#define EXYNOS5_IRQ_SYSMMU_2DV_1	COMBINER_IRQ(22, 3)

#define EXYNOS5_IRQ_EINT2		COMBINER_IRQ(25, 0)
#define EXYNOS5_IRQ_EINT3		COMBINER_IRQ(25, 1)

#define EXYNOS5_IRQ_EINT4		COMBINER_IRQ(26, 0)
#define EXYNOS5_IRQ_EINT5		COMBINER_IRQ(26, 1)

#define EXYNOS5_IRQ_EINT6		COMBINER_IRQ(27, 0)
#define EXYNOS5_IRQ_EINT7		COMBINER_IRQ(27, 1)

#define EXYNOS5_IRQ_EINT8		COMBINER_IRQ(28, 0)
#define EXYNOS5_IRQ_EINT9		COMBINER_IRQ(28, 1)

#define EXYNOS5_IRQ_EINT10		COMBINER_IRQ(29, 0)
#define EXYNOS5_IRQ_EINT11		COMBINER_IRQ(29, 1)

#define EXYNOS5_IRQ_EINT12		COMBINER_IRQ(30, 0)
#define EXYNOS5_IRQ_EINT13		COMBINER_IRQ(30, 1)

#define EXYNOS5_IRQ_EINT14		COMBINER_IRQ(31, 0)
#define EXYNOS5_IRQ_EINT15		COMBINER_IRQ(31, 1)

#define EXYNOS5_MAX_COMBINER_NR		32

#define EXYNOS5_IRQ_GPIO1_NR_GROUPS	14
#define EXYNOS5_IRQ_GPIO2_NR_GROUPS	9
#define EXYNOS5_IRQ_GPIO3_NR_GROUPS	5
#define EXYNOS5_IRQ_GPIO4_NR_GROUPS	1

#define EXYNOS5_IRQ_GPIO_LB_NR_GROUPS	9
#define EXYNOS5_IRQ_GPIO_RT_NR_GROUPS	21
#define EXYNOS5_IRQ_GPIO_C2C_NR_GROUPS	5
#define EXYNOS5_IRQ_GPIO_NR_GROUPS	1

#define EXYNOS5420_IRQ_GPIO_LB_NR_GROUPS	8
#define EXYNOS5420_IRQ_GPIO_T_NR_GROUPS		6
#define EXYNOS5420_IRQ_GPIO_RT_NR_GROUPS	1
#define EXYNOS5420_IRQ_GPIO_B_NR_GROUPS		9
#define EXYNOS5420_IRQ_GPIO_NR_GROUPS		1

/* Exynos5260 Part */

#define EXYNOS5260_IRQ_EINT0		IRQ_SPI(32)
#define EXYNOS5260_IRQ_EINT1		IRQ_SPI(33)
#define EXYNOS5260_IRQ_EINT2		IRQ_SPI(34)
#define EXYNOS5260_IRQ_EINT3		IRQ_SPI(35)
#define EXYNOS5260_IRQ_EINT4		IRQ_SPI(36)
#define EXYNOS5260_IRQ_EINT5		IRQ_SPI(37)
#define EXYNOS5260_IRQ_EINT6		IRQ_SPI(38)
#define EXYNOS5260_IRQ_EINT7		IRQ_SPI(39)
#define EXYNOS5260_IRQ_EINT8		IRQ_SPI(40)
#define EXYNOS5260_IRQ_EINT9		IRQ_SPI(41)
#define EXYNOS5260_IRQ_EINT10		IRQ_SPI(42)
#define EXYNOS5260_IRQ_EINT11		IRQ_SPI(43)
#define EXYNOS5260_IRQ_EINT12		IRQ_SPI(44)
#define EXYNOS5260_IRQ_EINT13		IRQ_SPI(45)
#define EXYNOS5260_IRQ_EINT14		IRQ_SPI(46)
#define EXYNOS5260_IRQ_EINT15		IRQ_SPI(47)
#define EXYNOS5260_IRQ_EINT16_31	IRQ_SPI(48)

#define EXYNOS5260_IRQ_CEC		IRQ_SPI(49)
#define EXYNOS5260_IRQ_PMU_EGL		IRQ_SPI(50)
#define EXYNOS5260_IRQ_PMU_KFC		IRQ_SPI(51)
#define EXYNOS5260_IRQ_A5IS		IRQ_SPI(52)
#define EXYNOS5260_IRQ_MONOCNT		IRQ_SPI(66)
#define EXYNOS5260_IRQ_RTC_ALARM	IRQ_SPI(73)
#define EXYNOS5260_IRQ_RTC_TIC		IRQ_SPI(74)
#define EXYNOS5260_IRQ_GPIO_RT		IRQ_SPI(79)

#define EXYNOS5260_IRQ_MCT_G0		IRQ_SPI(104)
#define EXYNOS5260_IRQ_MCT_G1		IRQ_SPI(105)
#define EXYNOS5260_IRQ_MCT_G2		IRQ_SPI(106)
#define EXYNOS5260_IRQ_MCT_G3		IRQ_SPI(107)

#define EXYNOS5260_IRQ_IIC0		IRQ_SPI(108)	/* HSI2C0 */
#define EXYNOS5260_IRQ_IIC1		IRQ_SPI(109)	/* HSI2C1 */
#define EXYNOS5260_IRQ_IIC2		IRQ_SPI(110)	/* HSI2C2 */
#define EXYNOS5260_IRQ_IIC3		IRQ_SPI(111)	/* HSI2C3 */
#define EXYNOS5260_IRQ_IIC10		IRQ_SPI(112)	/* HSI2C4 */
#define EXYNOS5260_IRQ_IIC11		IRQ_SPI(113)
#define EXYNOS5260_IRQ_IIC4		IRQ_SPI(114)
#define EXYNOS5260_IRQ_IIC5		IRQ_SPI(115)
#define EXYNOS5260_IRQ_IIC6		IRQ_SPI(116)
#define EXYNOS5260_IRQ_IIC7		IRQ_SPI(117)
#define EXYNOS5260_IRQ_IIC8		IRQ_SPI(118)
#define EXYNOS5260_IRQ_IIC9		IRQ_SPI(119)

#define EXYNOS5260_IRQ_I2S1		IRQ_SPI(121)
#define EXYNOS5260_IRQ_MCT_L0		IRQ_SPI(122)
#define EXYNOS5260_IRQ_MCT_L1		IRQ_SPI(123)
#define EXYNOS5260_IRQ_MCT_L2		IRQ_SPI(124)
#define EXYNOS5260_IRQ_MCT_L3		IRQ_SPI(125)
#define EXYNOS5260_IRQ_MCT_L4		IRQ_SPI(126)
#define EXYNOS5260_IRQ_MCT_L5		IRQ_SPI(127)
#define EXYNOS5260_IRQ_MCT_L6		IRQ_SPI(128)
#define EXYNOS5260_IRQ_MCT_L7		IRQ_SPI(129)

#define EXYNOS5260_IRQ_PCM1		IRQ_SPI(130)

#define EXYNOS5260_IRQ_TIMER0_VIC	IRQ_SPI(131)
#define EXYNOS5260_IRQ_TIMER1_VIC	IRQ_SPI(132)
#define EXYNOS5260_IRQ_TIMER2_VIC	IRQ_SPI(133)
#define EXYNOS5260_IRQ_TIMER3_VIC	IRQ_SPI(134)
#define EXYNOS5260_IRQ_TIMER4_VIC	IRQ_SPI(135)

#define EXYNOS5260_IRQ_SPDIF		IRQ_SPI(136)

#define EXYNOS5260_IRQ_SPI0		IRQ_SPI(137)
#define EXYNOS5260_IRQ_SPI1		IRQ_SPI(138)
#define EXYNOS5260_IRQ_SPI2		IRQ_SPI(139)

#define EXYNOS5260_IRQ_TMU_EGL0		IRQ_SPI(140)
#define EXYNOS5260_IRQ_TMU_EGL1		IRQ_SPI(141)
#define EXYNOS5260_IRQ_TMU_KFC		IRQ_SPI(142)
#define EXYNOS5260_IRQ_TMU_G3D0		IRQ_SPI(143)
#define EXYNOS5260_IRQ_TMU_G3D1		IRQ_SPI(144)

#define EXYNOS5260_IRQ_ADC		IRQ_SPI(145)
#define EXYNOS5260_IRQ_UART0		IRQ_SPI(146)
#define EXYNOS5260_IRQ_UART1		IRQ_SPI(147)
#define EXYNOS5260_IRQ_UART2		IRQ_SPI(148)

#define EXYNOS5260_IRQ_WDT_KFC		IRQ_SPI(149)
#define EXYNOS5260_IRQ_WDT_EGL		IRQ_SPI(150)
#define EXYNOS5260_IRQ_TOP_RTC_ALARM	IRQ_SPI(151)
#define EXYNOS5260_IRQ_TOP_RTC_TIC	IRQ_SPI(152)

#define EXYNOS5260_IRQ_HSMMC0		IRQ_SPI(156)
#define EXYNOS5260_IRQ_GPIO_FSYS	IRQ_SPI(157)
#define EXYNOS5260_IRQ_HSMMC1		IRQ_SPI(158)
#define EXYNOS5260_IRQ_HSMMC2		IRQ_SPI(159)

#define EXYNOS5260_IRQ_PDMA0		IRQ_SPI(160)

#define EXYNOS5260_IRQ_RTIC		IRQ_SPI(162)
#define EXYNOS5260_IRQ_SYSMMU_RTIC0	IRQ_SPI(163)
#define EXYNOS5260_IRQ_SYSMMU_RTIC1	IRQ_SPI(164)

#define EXYNOS5260_IRQ_USB3_DRD		IRQ_SPI(165)
#define EXYNOS5260_IRQ_USB_HOST		IRQ_SPI(166)

#define EXYNOS5260_IRQ_TSI		IRQ_SPI(167)
#define EXYNOS5260_IRQ_GSCL0		IRQ_SPI(168)
#define EXYNOS5260_IRQ_GSCL1		IRQ_SPI(169)

#define EXYNOS5260_IRQ_PPMU_GSCL	IRQ_SPI(172)
#define EXYNOS5260_IRQ_PPMU_MSCL	IRQ_SPI(173)

#define EXYNOS5260_IRQ_SYSMMU_GSC0_0	IRQ_SPI(174)
#define EXYNOS5260_IRQ_SYSMMU_GSC0_1	IRQ_SPI(175)
#define EXYNOS5260_IRQ_SYSMMU_GSC1_0	IRQ_SPI(176)
#define EXYNOS5260_IRQ_SYSMMU_GSC1_1	IRQ_SPI(177)

#define EXYNOS5260_IRQ_SYSMMU_SCALER_0	IRQ_SPI(178)
#define EXYNOS5260_IRQ_SYSMMU_SCALER_1	IRQ_SPI(179)
#define EXYNOS5260_IRQ_SYSMMU_SCALER1_0	IRQ_SPI(180)
#define EXYNOS5260_IRQ_SYSMMU_SCALER1_1	IRQ_SPI(181)

#define EXYNOS5260_IRQ_MIPI_CSIS0	IRQ_SPI(182)
#define EXYNOS5260_IRQ_MIPI_CSIS1	IRQ_SPI(183)

#define EXYNOS5260_IRQ_FIMC_LITE0	IRQ_SPI(184)
#define EXYNOS5260_IRQ_FIMC_LITE1	IRQ_SPI(185)
#define EXYNOS5260_IRQ_FIMC_LITE2	IRQ_SPI(186)

#define EXYNOS5260_IRQ_PPMU_FIMC_LITE	IRQ_SPI(187)

#define EXYNOS5260_IRQ_SYSMMU_LITE0_0	IRQ_SPI(188)
#define EXYNOS5260_IRQ_SYSMMU_LITE0_1	IRQ_SPI(189)
#define EXYNOS5260_IRQ_SYSMMU_LITE1_0	IRQ_SPI(190)
#define EXYNOS5260_IRQ_SYSMMU_LITE1_1	IRQ_SPI(191)
#define EXYNOS5260_IRQ_SYSMMU_LITE3_0	IRQ_SPI(192)
#define EXYNOS5260_IRQ_SYSMMU_LITE3_1	IRQ_SPI(193)

#define EXYNOS5260_IRQ_DP1_1		IRQ_SPI(200)
#define EXYNOS5260_IRQ_FIMD1_0		IRQ_SPI(201)
#define EXYNOS5260_IRQ_FIMD1_1		IRQ_SPI(202)
#define EXYNOS5260_IRQ_FIMD1_2		IRQ_SPI(203)

#define EXYNOS5260_IRQ_HDMI_LINK	IRQ_SPI(205)
#define EXYNOS5260_IRQ_MIPI_DSI		IRQ_SPI(206)
#define EXYNOS5260_IRQ_MIXER		IRQ_SPI(207)

#define EXYNOS5260_IRQ_PPMU_FIMD1X	IRQ_SPI(208)
#define EXYNOS5260_IRQ_PPMU_FIMD0X	IRQ_SPI(209)

#define EXYNOS5260_IRQ_SYSMMU_FIMD1_0 IRQ_SPI(210)
#define EXYNOS5260_IRQ_SYSMMU_FIMD1_1 IRQ_SPI(211)
#define EXYNOS5260_IRQ_SYSMMU_FIMD1A_0 IRQ_SPI(212)
#define EXYNOS5260_IRQ_SYSMMU_FIMD1A_1 IRQ_SPI(213)

#define EXYNOS5260_IRQ_SYSMMU_TV_0	IRQ_SPI(214)
#define EXYNOS5260_IRQ_SYSMMU_TV_1	IRQ_SPI(215)

#define EXYNOS5260_IRQ_MFC		IRQ_SPI(216)
#define EXYNOS5260_IRQ_PPMU_MFC		IRQ_SPI(217)

#define EXYNOS5260_IRQ_SYSMMU_MFC_R_0	IRQ_SPI(218)
#define EXYNOS5260_IRQ_SYSMMU_MFC_R_1	IRQ_SPI(219)
#define EXYNOS5260_IRQ_SYSMMU_MFC_L_0	IRQ_SPI(220)
#define EXYNOS5260_IRQ_SYSMMU_MFC_L_1	IRQ_SPI(221)

#define EXYNOS5260_IRQ_SGI		IRQ_SPI(223)
#define EXYNOS5260_IRQ_2D		IRQ_SPI(224)

#define EXYNOS5260_IRQ_JPEG		IRQ_SPI(225)

#define EXYNOS5260_IRQ_MDMA_0		IRQ_SPI(226)
#define EXYNOS5260_IRQ_MDMA_1		IRQ_SPI(227)

#define EXYNOS5260_IRQ_PPMU_2D		IRQ_SPI(228)
#define EXYNOS5260_IRQ_SLIMSSS		IRQ_SPI(229)
#define EXYNOS5260_IRQ_SYSMMU_2D_0	IRQ_SPI(230)
#define EXYNOS5260_IRQ_SYSMMU_2D_1	IRQ_SPI(231)
#define EXYNOS5260_IRQ_SYSMMU_JPEG_0	IRQ_SPI(232)
#define EXYNOS5260_IRQ_SYSMMU_JPEG_1	IRQ_SPI(233)

#define EXYNOS5260_IRQ_SYSMMU_MDMA_0	IRQ_SPI(234)
#define EXYNOS5260_IRQ_SYSMMU_MDMA_1	IRQ_SPI(235)
#define EXYNOS5260_IRQ_SYSMMU_SLIMSSS_0	IRQ_SPI(236)
#define EXYNOS5260_IRQ_SYSMMU_SLIMSSS_1	IRQ_SPI(237)
#define EXYNOS5260_IRQ_SYSMMU_SSS_0	IRQ_SPI(238)
#define EXYNOS5260_IRQ_SYSMMU_SSS_1	IRQ_SPI(239)
#define EXYNOS5260_IRQ_SSS		IRQ_SPI(240)

#define EXYNOS5260_IRQ_ADMA		IRQ_SPI(242)
#define EXYNOS5260_IRQ_GPIO_AUDIO	IRQ_SPI(243)
#define EXYNOS5260_IRQ_AUDIO_MI2S	IRQ_SPI(244)
#define EXYNOS5260_IRQ_AUDIO_PCM	IRQ_SPI(245)
#define EXYNOS5260_IRQ_AUDIO_UART	IRQ_SPI(246)

#define EXYNOS5260_IRQ_PPMU_G3D		IRQ_SPI(248)
#define EXYNOS5260_IRQ_G3D_MMU		IRQ_SPI(249)
#define EXYNOS5260_IRQ_G3D_GPU		IRQ_SPI(250)
#define EXYNOS5260_IRQ_G3D_JOB		IRQ_SPI(251)

#define EXYNOS5260_IRQ_ARMISP_GIC	IRQ_SPI(256)
#define EXYNOS5260_IRQ_ISP_GIC		IRQ_SPI(257)

#define EXYNOS5260_IRQ_MCUISP_CTI	IRQ_SPI(258)
#define EXYNOS5260_IRQ_PPMU_MCUISP	IRQ_SPI(259)
#define EXYNOS5260_IRQ_PPMU_ISPX	IRQ_SPI(260)

#define EXYNOS5260_IRQ_SYSMMU_DRC_0	IRQ_SPI(261)
#define EXYNOS5260_IRQ_SYSMMU_DRC_1	IRQ_SPI(262)

#define EXYNOS5260_IRQ_SYSMMU_FD_0	IRQ_SPI(263)
#define EXYNOS5260_IRQ_SYSMMU_FD_1	IRQ_SPI(264)

#define EXYNOS5260_IRQ_SYSMMU_ISP_0	IRQ_SPI(265)
#define EXYNOS5260_IRQ_SYSMMU_ISP_1	IRQ_SPI(266)

#define EXYNOS5260_IRQ_SYSMMU_SCALERCISP_0	IRQ_SPI(267)
#define EXYNOS5260_IRQ_SYSMMU_SCALERCISP_1	IRQ_SPI(268)
#define EXYNOS5260_IRQ_SYSMMU_SCALERPISP_0	IRQ_SPI(269)
#define EXYNOS5260_IRQ_SYSMMU_SCALERPISP_1	IRQ_SPI(270)

#define EXYNOS5260_IRQ_SYSMMU_MCUISP_0	IRQ_SPI(271)
#define EXYNOS5260_IRQ_SYSMMU_MCUISP_1	IRQ_SPI(272)

#define EXYNOS5260_IRQ_PPMU_ISP		IRQ_SPI(273)

#define EXYNOS5260_IRQ_GPIO_RT_NR_GROUPS	17
#define EXYNOS5260_IRQ_GPIO_FSYS_NR_GROUPS	5
#define EXYNOS5260_IRQ_GPIO_AUDIO_NR_GROUPS	2

/* For Compatibility */

#if defined(CONFIG_ARCH_EXYNOS3)

#define IRQ_TIMER0_VIC                  EXYNOS3_IRQ_TIMER0
#define IRQ_TIMER1_VIC                  EXYNOS3_IRQ_TIMER1
#define IRQ_TIMER2_VIC                  EXYNOS3_IRQ_TIMER2
#define IRQ_TIMER3_VIC                  EXYNOS3_IRQ_TIMER3
#define IRQ_TIMER4_VIC                  EXYNOS3_IRQ_TIMER4

#define IRQ_WDT                         EXYNOS3_IRQ_WDT
#define IRQ_RTC_ALARM                   EXYNOS3_IRQ_RTC_ALARM
#define IRQ_RTC_TIC                     EXYNOS3_IRQ_RTC_TIC

#define IRQ_IIC                         EXYNOS3_IRQ_IIC0
#define IRQ_IIC1                        EXYNOS3_IRQ_IIC1
#define IRQ_IIC2                        EXYNOS3_IRQ_IIC2
#define IRQ_IIC3                        EXYNOS3_IRQ_IIC3
#define IRQ_IIC4                        EXYNOS3_IRQ_IIC4
#define IRQ_IIC5                        EXYNOS3_IRQ_IIC5
#define IRQ_IIC6                        EXYNOS3_IRQ_IIC6
#define IRQ_IIC7                        EXYNOS3_IRQ_IIC7

#define IRQ_I2S0                        EXYNOS3_IRQ_I2S0
#define IRQ_AUDIO_SS                    EXYNOS3_IRQ_AUDIO_SS

#define IRQ_USB_HOST                    EXYNOS3_IRQ_UHOST
#define IRQ_OTG                         EXYNOS3_IRQ_HSOTG

#define IRQ_HSMMC0                      EXYNOS3_IRQ_HSMMC0
#define IRQ_HSMMC1                      EXYNOS3_IRQ_HSMMC1
#define IRQ_HSMMC2                      EXYNOS3_IRQ_HSMMC2

#define IRQ_SPI0                        EXYNOS3_IRQ_SPI0
#define IRQ_SPI1                        EXYNOS3_IRQ_SPI1
#define IRQ_SPI2                        EXYNOS3_IRQ_SPI2

#define IRQ_MIPICSI0                    EXYNOS3_IRQ_MIPI_CSI_4LANE
#define IRQ_MIPICSI1                    EXYNOS3_IRQ_MIPI_CSI_2LANE
#define IRQ_ISP_I2C                     EXYNOS3_IRQ_COMB_ISP_GIC

#define IRQ_FIMC0                       EXYNOS3_IRQ_FIMC0
#define IRQ_FIMC1                       EXYNOS3_IRQ_FIMC1
#define IRQ_FIMC2                       EXYNOS3_IRQ_FIMC2
#define IRQ_FIMC3                       EXYNOS3_IRQ_FIMC3
#define IRQ_FIMC_LITE0                  EXYNOS3_IRQ_FIMC_LITE0
#define IRQ_FIMC_LITE1                  EXYNOS3_IRQ_FIMC_LITE1

#define IRQ_JPEG                        EXYNOS3_IRQ_JPEG
#define IRQ_2D                          EXYNOS3_IRQ_G2D

#define IRQ_MIXER                       EXYNOS3_IRQ_MIXER
#define IRQ_HDMI                        EXYNOS3_IRQ_HDMI
#define IRQ_MFC                         EXYNOS3_IRQ_MFC

#define IRQ_ADC                         EXYNOS3_IRQ_ADC
#define IRQ_KEYPAD                      EXYNOS3_IRQ_KEYPAD

#define IRQ_GSC0                        EXYNOS3_IRQ_GSC0
#define IRQ_GSC1                        EXYNOS3_IRQ_GSC1
#define IRQ_GSC2                        EXYNOS3_IRQ_GSC0
#define IRQ_GSC3                        EXYNOS3_IRQ_GSC1

#define IRQ_PMU		                EXYNOS3_IRQ_KFC_PMU0
#define IRQ_PMU_CPU1                    EXYNOS3_IRQ_KFC_PMU1
#define IRQ_PMU_CPU2                    EXYNOS3_IRQ_KFC_PMU2
#define IRQ_PMU_CPU3                    EXYNOS3_IRQ_KFC_PMU3

#define IRQ_SYSMMU_MDMA0                EXYNOS3_IRQ_SYSMMU_MDMA0
#define IRQ_SYSMMU_MDMA1                EXYNOS3_IRQ_SYSMMU_MDMA1

#define IRQ_SYSMMU_FIMC0_0              EXYNOS3_IRQ_SYSMMU_FIMC00
#define IRQ_SYSMMU_FIMC1_0              EXYNOS3_IRQ_SYSMMU_FIMC10
#define IRQ_SYSMMU_FIMC2_0              EXYNOS3_IRQ_SYSMMU_FIMC20
#define IRQ_SYSMMU_FIMC3_0              EXYNOS3_IRQ_SYSMMU_FIMC30
#define IRQ_SYSMMU_JPEG_0               EXYNOS3_IRQ_SYSMMU_JPEG_0
#define IRQ_SYSMMU_2D_0                 EXYNOS3_IRQ_SYSMMU_2D0


#define IRQ_SYSMMU_LCD0_M0_0            EXYNOS3_IRQ_SYSMMU_LCD0_M00
#define IRQ_SYSMMU_LCD0_M0_1            EXYNOS3_IRQ_SYSMMU_LCD0_M01
#define IRQ_SYSMMU_TV_M0_0              EXYNOS3_IRQ_SYSMMU_TV_M00
#define IRQ_SYSMMU_MFC_M0_0             EXYNOS3_IRQ_SYSMMU_MFC_M00
#define IRQ_SYSMMU_MFC_M1_0             EXYNOS3_IRQ_SYSMMU_MFC_M10

#define IRQ_USB_HSOTG                   EXYNOS3_IRQ_HSOTG

#define IRQ_GPIO1_NR_GROUPS             EXYNOS3_IRQ_GPIO1_NR_GROUPS
#define IRQ_GPIO2_NR_GROUPS             EXYNOS3_IRQ_GPIO2_NR_GROUPS

#define EXYNOS_IRQ_UARTx(x)             (EXYNOS3_IRQ_UART0 + x)


#define EXYNOS_IRQ_UART0                EXYNOS3_IRQ_UART0
#define EXYNOS_IRQ_UART1                EXYNOS3_IRQ_UART1
#define EXYNOS_IRQ_UART2                EXYNOS3_IRQ_UART2
#define EXYNOS_IRQ_UART3                EXYNOS3_IRQ_UART3

#define EXYNOS_IRQ_MCT_L0               EXYNOS3_IRQ_MCT_L0
#define EXYNOS_IRQ_MCT_L1               EXYNOS3_IRQ_MCT_L1
#define EXYNOS_IRQ_MCT_L2               EXYNOS3_IRQ_MCT_L2
#define EXYNOS_IRQ_MCT_L3               EXYNOS3_IRQ_MCT_L3

#define EXYNOS_IRQ_MCT_G0               EXYNOS3_IRQ_MCT_G0
#define EXYNOS_IRQ_MCT_G1               EXYNOS3_IRQ_MCT_G1
#define EXYNOS_IRQ_MCT_G2               EXYNOS3_IRQ_MCT_G2
#define EXYNOS_IRQ_MCT_G3               EXYNOS3_IRQ_MCT_G3

#define S5P_EINT_BASE1                  (EXYNOS3_IRQ_PPI_MAX)

#define IRQ_FIMD0_FIFO			EXYNOS3_IRQ_FIMD00
#define IRQ_FIMD0_VSYNC			EXYNOS3_IRQ_FIMD01
#define IRQ_FIMD0_SYSTEM		EXYNOS3_IRQ_FIMD10

#define IRQ_MIPIDSI0			EXYNOS3_IRQ_MIPI_DSI_2LANE
#define IRQ_MIPIDSI1			EXYNOS3_IRQ_MIPI_DSI_2LANE

#elif defined(CONFIG_ARCH_EXYNOS4)

#define IRQ_TIMER0_VIC			EXYNOS4_IRQ_TIMER0_VIC
#define IRQ_TIMER1_VIC			EXYNOS4_IRQ_TIMER1_VIC
#define IRQ_TIMER2_VIC			EXYNOS4_IRQ_TIMER2_VIC
#define IRQ_TIMER3_VIC			EXYNOS4_IRQ_TIMER3_VIC
#define IRQ_TIMER4_VIC			EXYNOS4_IRQ_TIMER4_VIC

#define IRQ_WDT				EXYNOS4_IRQ_WDT
#define IRQ_RTC_ALARM			EXYNOS4_IRQ_RTC_ALARM
#define IRQ_RTC_TIC			EXYNOS4_IRQ_RTC_TIC
#define IRQ_GPIO_XB			EXYNOS4_IRQ_GPIO_XB
#define IRQ_GPIO_XA			EXYNOS4_IRQ_GPIO_XA

#define IRQ_IIC				EXYNOS4_IRQ_IIC
#define IRQ_IIC1			EXYNOS4_IRQ_IIC1
#define IRQ_IIC2			EXYNOS4_IRQ_IIC2
#define IRQ_IIC3			EXYNOS4_IRQ_IIC3
#define IRQ_IIC4			EXYNOS4_IRQ_IIC4
#define IRQ_IIC5			EXYNOS4_IRQ_IIC5
#define IRQ_IIC6			EXYNOS4_IRQ_IIC6
#define IRQ_IIC7			EXYNOS4_IRQ_IIC7

#define IRQ_I2S0			EXYNOS4_IRQ_I2S0
#define IRQ_AUDIO_SS			EXYNOS4_IRQ_AUDIO_SS

#define IRQ_USB_HOST			EXYNOS4_IRQ_USB_HOST
#define IRQ_OTG				EXYNOS4_IRQ_OTG

#define IRQ_HSMMC0			EXYNOS4_IRQ_HSMMC0
#define IRQ_HSMMC1			EXYNOS4_IRQ_HSMMC1
#define IRQ_HSMMC2			EXYNOS4_IRQ_HSMMC2
#define IRQ_HSMMC3			EXYNOS4_IRQ_HSMMC3

#define IRQ_SPI0			EXYNOS4_IRQ_SPI0
#define IRQ_SPI1			EXYNOS4_IRQ_SPI1
#define IRQ_SPI2			EXYNOS4_IRQ_SPI2

#define IRQ_MIPICSI0			EXYNOS4_IRQ_MIPI_CSIS0
#define IRQ_MIPICSI1			EXYNOS4_IRQ_MIPI_CSIS1

#define IRQ_MIPIDSI0			EXYNOS4_IRQ_MIPIDSI0
#define IRQ_MIPIDSI1			EXYNOS4_IRQ_MIPIDSI0

#define IRQ_ONENAND_AUDI		EXYNOS4_IRQ_ONENAND_AUDI

#define IRQ_FIMC0			EXYNOS4_IRQ_FIMC0
#define IRQ_FIMC1			EXYNOS4_IRQ_FIMC1
#define IRQ_FIMC2			EXYNOS4_IRQ_FIMC2
#define IRQ_FIMC3			EXYNOS4_IRQ_FIMC3
#define IRQ_FIMC_LITE0			EXYNOS4_IRQ_FIMC_LITE0
#define IRQ_FIMC_LITE1			EXYNOS4_IRQ_FIMC_LITE1

#define IRQ_JPEG			EXYNOS4_IRQ_JPEG
#define IRQ_2D				EXYNOS4_IRQ_2D

#define IRQ_MIXER			EXYNOS4_IRQ_MIXER
#define IRQ_HDMI			EXYNOS4_IRQ_HDMI
#define IRQ_IIC_HDMIPHY			EXYNOS4_IRQ_IIC_HDMIPHY
#define IRQ_MFC				EXYNOS4_IRQ_MFC
#define IRQ_SDO				EXYNOS4_IRQ_SDO

#ifdef CONFIG_SOC_EXYNOS4210
#define IRQ_ADC				EXYNOS4_IRQ_ADC0
#define IRQ_TC				EXYNOS4_IRQ_PEN0
#else /* CONFIG_SOC_EXYNOS4212 || CONFIG_SOC_EXYNOS4412 */
#define IRQ_ADC				EXYNOS4X12_IRQ_ADC0
#endif

#define IRQ_KEYPAD			EXYNOS4_IRQ_KEYPAD

#define IRQ_INTFEEDCTRL_SSS		EXYNOS4_IRQ_INTFEEDCTRL_SSS

#define IRQ_CEC				EXYNOS4_IRQ_CEC
#define IRQ_PMU				EXYNOS4_IRQ_PMU_CPU0
#define IRQ_PMU_CPU1			EXYNOS4_IRQ_PMU_CPU1

#define IRQ_SYSMMU_MDMA0_0		EXYNOS4_IRQ_SYSMMU_MDMA0_0
#define IRQ_SYSMMU_SSS_0		EXYNOS4_IRQ_SYSMMU_SSS_0
#define IRQ_SYSMMU_FIMC0_0		EXYNOS4_IRQ_SYSMMU_FIMC0_0
#define IRQ_SYSMMU_FIMC1_0		EXYNOS4_IRQ_SYSMMU_FIMC1_0
#define IRQ_SYSMMU_FIMC2_0		EXYNOS4_IRQ_SYSMMU_FIMC2_0
#define IRQ_SYSMMU_FIMC3_0		EXYNOS4_IRQ_SYSMMU_FIMC3_0
#define IRQ_SYSMMU_JPEG_0		EXYNOS4_IRQ_SYSMMU_JPEG_0
#define IRQ_SYSMMU_2D_0			EXYNOS4_IRQ_SYSMMU_2D_0

#define IRQ_SYSMMU_ROTATOR_0		EXYNOS4_IRQ_SYSMMU_ROTATOR_0
#define IRQ_SYSMMU_MDMA1_0		EXYNOS4_IRQ_SYSMMU_MDMA1_0
#define IRQ_SYSMMU_LCD0_M0_0		EXYNOS4_IRQ_SYSMMU_LCD0_M0_0
#define IRQ_SYSMMU_LCD1_M1_0		EXYNOS4_IRQ_SYSMMU_LCD1_M1_0
#define IRQ_SYSMMU_TV_M0_0		EXYNOS4_IRQ_SYSMMU_TV_M0_0
#define IRQ_SYSMMU_MFC_M0_0		EXYNOS4_IRQ_SYSMMU_MFC_M0_0
#define IRQ_SYSMMU_MFC_M1_0		EXYNOS4_IRQ_SYSMMU_MFC_M1_0
#define IRQ_SYSMMU_PCIE_0		EXYNOS4_IRQ_SYSMMU_PCIE_0

#ifdef CONFIG_SOC_EXYNOS4415
#define IRQ_FIMD1_FIFO			IRQ_SPI(84)
#define IRQ_FIMD1_VSYNC			IRQ_SPI(85)
#define IRQ_FIMD1_SYSTEM		IRQ_SPI(86)
#else
#define IRQ_FIMD0_FIFO			EXYNOS4_IRQ_FIMD0_FIFO
#define IRQ_FIMD0_VSYNC			EXYNOS4_IRQ_FIMD0_VSYNC
#define IRQ_FIMD0_SYSTEM		EXYNOS4_IRQ_FIMD0_SYSTEM
#ifdef CONFIG_SOC_EXYNOS3470
#define IRQ_FIMD1_FIFO			IRQ_FIMD0_FIFO
#define IRQ_FIMD1_VSYNC			IRQ_FIMD0_VSYNC
#define IRQ_FIMD1_SYSTEM		IRQ_FIMD0_SYSTEM
#endif
#endif

#define IRQ_PMU_CPU2			EXYNOS4_IRQ_PMU_CPU2
#define IRQ_PMU_CPU3			EXYNOS4_IRQ_PMU_CPU3

#define IRQ_GPIO1_NR_GROUPS		EXYNOS4_IRQ_GPIO1_NR_GROUPS
#define IRQ_GPIO2_NR_GROUPS		EXYNOS4_IRQ_GPIO2_NR_GROUPS

#define EXYNOS_IRQ_UARTx(x)		(EXYNOS4_IRQ_UART0 + x)

#elif defined(CONFIG_SOC_EXYNOS5260)

#define IRQ_TIMER0_VIC			EXYNOS5260_IRQ_TIMER0_VIC
#define IRQ_TIMER1_VIC			EXYNOS5260_IRQ_TIMER1_VIC
#define IRQ_TIMER2_VIC			EXYNOS5260_IRQ_TIMER2_VIC
#define IRQ_TIMER3_VIC			EXYNOS5260_IRQ_TIMER3_VIC
#define IRQ_TIMER4_VIC			EXYNOS5260_IRQ_TIMER4_VIC

#define IRQ_WDT				EXYNOS5260_IRQ_WDT_EGL
#define IRQ_RTC_ALARM			EXYNOS5260_IRQ_RTC_ALARM
#define IRQ_RTC_TIC			EXYNOS5260_IRQ_RTC_TIC

#define IRQ_IIC				EXYNOS5260_IRQ_IIC0
#define IRQ_IIC1			EXYNOS5260_IRQ_IIC1
#define IRQ_IIC2			EXYNOS5260_IRQ_IIC2
#define IRQ_IIC3			EXYNOS5260_IRQ_IIC3
#define IRQ_IIC4			EXYNOS5260_IRQ_IIC4
#define IRQ_IIC5			EXYNOS5260_IRQ_IIC5
#define IRQ_IIC6			EXYNOS5260_IRQ_IIC6
#define IRQ_IIC7			EXYNOS5260_IRQ_IIC7
#define IRQ_IIC8			EXYNOS5260_IRQ_IIC8
#define IRQ_IIC9			EXYNOS5260_IRQ_IIC9
#define IRQ_IIC10			EXYNOS5260_IRQ_IIC10

#define IRQ_I2S0			EXYNOS5260_IRQ_AUDIO_MI2S

#define IRQ_USB_HOST			EXYNOS5260_IRQ_USB_HOST
#define IRQ_USB3_DRD			EXYNOS5260_IRQ_USB3_DRD

#define IRQ_HSMMC0			EXYNOS5260_IRQ_HSMMC0
#define IRQ_HSMMC1			EXYNOS5260_IRQ_HSMMC1
#define IRQ_HSMMC2			EXYNOS5260_IRQ_HSMMC2

#define IRQ_SPI0			EXYNOS5260_IRQ_SPI0
#define IRQ_SPI1			EXYNOS5260_IRQ_SPI1
#define IRQ_SPI2			EXYNOS5260_IRQ_SPI2

#define IRQ_MIPICSI0			EXYNOS5260_IRQ_CSI_0
#define IRQ_MIPICSI1			EXYNOS5260_IRQ_CSI_1

#define IRQ_MIPIDSI0			EXYNOS5260_IRQ_MIPI_DSI
#define IRQ_MIPIDSI1			EXYNOS5260_IRQ_MIPI_DSI

#define IRQ_GSC0			EXYNOS5260_IRQ_GSCL0
#define IRQ_GSC1			EXYNOS5260_IRQ_GSCL1
#define IRQ_GSC2			0
#define IRQ_GSC3			0

#define IRQ_JPEG			EXYNOS5260_IRQ_JPEG
#define IRQ_2D				EXYNOS5260_IRQ_2D

#define IRQ_MIXER			EXYNOS5260_IRQ_MIXER
#define IRQ_HDMI			EXYNOS5260_IRQ_HDMI_LINK
#define IRQ_MFC				EXYNOS5260_IRQ_MFC

#define IRQ_ADC				EXYNOS5260_IRQ_ADC

#define IRQ_INTFEEDCTRL_SSS		EXYNOS5260_IRQ_SSS
#define IRQ_INTFEEDCTRL_SLIMSSS		EXYNOS5260_IRQ_SLIMSSS

#define IRQ_PMU				EXYNOS5260_IRQ_PMU_EGL
#define IRQ_PMU_CPU1			EXYNOS5260_IRQ_PMU_KFC
#define IRQ_PMU_CPU2			EXYNOS5_IRQ_PMU_CPU2
#define IRQ_PMU_CPU3			EXYNOS5_IRQ_PMU_CPU3

#define IRQ_CEC				EXYNOS5260_IRQ_CEC

#define GPU_IRQ_NUMBER			EXYNOS5260_IRQ_G3D_GPU
#define JOB_IRQ_NUMBER			EXYNOS5260_IRQ_G3D_JOB
#define MMU_IRQ_NUMBER			EXYNOS5260_IRQ_G3D_MMU

#define IRQ_FIMC_LITE0			EXYNOS5260_IRQ_FIMC_LITE0
#define IRQ_FIMC_LITE1			EXYNOS5260_IRQ_FIMC_LITE1
#define IRQ_FIMC_LITE2			EXYNOS5260_IRQ_FIMC_LITE2

#define IRQ_DP				EXYNOS5260_IRQ_DP1_1

#define IRQ_SYSMMU_MDMA0_0		EXYNOS5260_IRQ_SYSMMU_MDMA0_0
#define IRQ_SYSMMU_MDMA1_0		EXYNOS5260_IRQ_SYSMMU_MDMA1_0
#define IRQ_SYSMMU_SSS_0		EXYNOS5260_IRQ_SYSMMU_SSS_0
#define IRQ_SYSMMU_SSS_1		EXYNOS5260_IRQ_SYSMMU_SSS_1

#define IRQ_SYSMMU_JPEG_0		EXYNOS5260_IRQ_SYSMMU_JPEG_0
#define IRQ_SYSMMU_2D_0			EXYNOS5260_IRQ_SYSMMU_2D_0

#define IRQ_FIMD1_FIFO			EXYNOS5260_IRQ_FIMD1_0
#define IRQ_FIMD1_VSYNC			EXYNOS5260_IRQ_FIMD1_1
#define IRQ_FIMD1_SYSTEM		EXYNOS5260_IRQ_FIMD1_2

#define IRQ_ARMISP_GIC			EXYNOS5260_IRQ_ARMISP_GIC
#define IRQ_ISP_GIC			EXYNOS5260_IRQ_ISP_GIC

#define IRQ_GPIO1_NR_GROUPS		EXYNOS5_IRQ_GPIO1_NR_GROUPS
#define IRQ_GPIO2_NR_GROUPS		EXYNOS5_IRQ_GPIO2_NR_GROUPS

#define EXYNOS_IRQ_UARTx(x)		(EXYNOS5260_IRQ_UART0 + x)

#elif defined(CONFIG_ARCH_EXYNOS5)

#define IRQ_TIMER0_VIC			EXYNOS5_IRQ_TIMER0_VIC
#define IRQ_TIMER1_VIC			EXYNOS5_IRQ_TIMER1_VIC
#define IRQ_TIMER2_VIC			EXYNOS5_IRQ_TIMER2_VIC
#define IRQ_TIMER3_VIC			EXYNOS5_IRQ_TIMER3_VIC
#define IRQ_TIMER4_VIC			EXYNOS5_IRQ_TIMER4_VIC

#define IRQ_WDT				EXYNOS5_IRQ_WDT
#define IRQ_RTC_ALARM			EXYNOS5_IRQ_RTC_ALARM
#define IRQ_RTC_TIC			EXYNOS5_IRQ_RTC_TIC
#define IRQ_GPIO_XB			EXYNOS5_IRQ_GPIO_XB
#define IRQ_GPIO_XA			EXYNOS5_IRQ_GPIO_XA

#define IRQ_IIC				EXYNOS5_IRQ_IIC
#define IRQ_IIC1			EXYNOS5_IRQ_IIC1
#define IRQ_IIC2			EXYNOS5_IRQ_IIC2
#define IRQ_IIC3			EXYNOS5_IRQ_IIC3
#define IRQ_IIC4			EXYNOS5_IRQ_IIC4
#define IRQ_IIC5			EXYNOS5_IRQ_IIC5
#define IRQ_IIC6			EXYNOS5_IRQ_IIC6
#define IRQ_IIC7			EXYNOS5_IRQ_IIC7
#define IRQ_IIC8			EXYNOS5_IRQ_IIC8
#define IRQ_IIC9			EXYNOS5_IRQ_IIC9
#define IRQ_IIC10			EXYNOS5_IRQ_IIC10

#define IRQ_AUDIO_SS			EXYNOS5_IRQ_AUDIO_SS

#define IRQ_I2S0			EXYNOS5_IRQ_I2S0

#define IRQ_USB_HOST			EXYNOS5_IRQ_USB_HOST
#define IRQ_USB3_DRD			EXYNOS5_IRQ_USB3_DRD
#define IRQ_OTG				EXYNOS5_IRQ_OTG

#define IRQ_HSMMC0			EXYNOS5_IRQ_HSMMC0
#define IRQ_HSMMC1			EXYNOS5_IRQ_HSMMC1
#define IRQ_HSMMC2			EXYNOS5_IRQ_HSMMC2
#define IRQ_HSMMC3			EXYNOS5_IRQ_HSMMC3

#define IRQ_SPI0			EXYNOS5_IRQ_SPI0
#define IRQ_SPI1			EXYNOS5_IRQ_SPI1
#define IRQ_SPI2			EXYNOS5_IRQ_SPI2

#define IRQ_MIPICSI0			EXYNOS5_IRQ_MIPICSI0
#define IRQ_MIPICSI1			EXYNOS5_IRQ_MIPICSI1
#define IRQ_MIPICSI2			EXYNOS5_IRQ_MIPICSI2

#define IRQ_MIPIDSI0			EXYNOS5_IRQ_MIPIDSI0
#define IRQ_MIPIDSI1			EXYNOS5_IRQ_MIPIDSI1

#define IRQ_ROTATOR			EXYNOS5_IRQ_ROTATOR
#define IRQ_GSC0			EXYNOS5_IRQ_GSC0
#define IRQ_GSC1			EXYNOS5_IRQ_GSC1
#define IRQ_GSC2			EXYNOS5_IRQ_GSC2
#define IRQ_GSC3			EXYNOS5_IRQ_GSC3
#define IRQ_JPEG			EXYNOS5_IRQ_JPEG
#define IRQ_JPEG_HX			EXYNOS5_IRQ_JPEG_HX
#define IRQ_2D				EXYNOS5_IRQ_2D

#define IRQ_MIXER			EXYNOS5_IRQ_MIXER
#define IRQ_HDMI			EXYNOS5_IRQ_HDMI
#define IRQ_IIC_HDMIPHY			EXYNOS5_IRQ_IIC_HDMIPHY
#define IRQ_MFC				EXYNOS5_IRQ_MFC

#define IRQ_ADC				EXYNOS5_IRQ_ADC0

#define IRQ_INTFEEDCTRL_SSS		EXYNOS5_IRQ_INTFEEDCTRL_SSS

#define IRQ_PMU				EXYNOS5_IRQ_PMU_CPU0
#define IRQ_PMU_CPU1			EXYNOS5_IRQ_PMU_CPU1
#define IRQ_PMU_CPU2			EXYNOS5_IRQ_PMU_CPU2
#define IRQ_PMU_CPU3			EXYNOS5_IRQ_PMU_CPU3

#define IRQ_CEC				EXYNOS5_IRQ_CEC

#define GPU_IRQ_NUMBER			EXYNOS5_GPU_IRQ_NUMBER
#define JOB_IRQ_NUMBER			EXYNOS5_JOB_IRQ_NUMBER
#define MMU_IRQ_NUMBER			EXYNOS5_MMU_IRQ_NUMBER

#define IRQ_FIMC_LITE0			EXYNOS5_IRQ_FIMC_LITE0
#define IRQ_FIMC_LITE1			EXYNOS5_IRQ_FIMC_LITE1
#define IRQ_FIMC_LITE2			EXYNOS5_IRQ_FIMC_LITE2

#define IRQ_DP				EXYNOS5_IRQ_DP

#define IRQ_SYSMMU_MDMA0_0		EXYNOS5_IRQ_SYSMMU_MDMA0_0
#define IRQ_SYSMMU_SSS_0		EXYNOS5_IRQ_SYSMMU_SSS_0
#define IRQ_INTFEEDCTRL_SLIMSSS		EXYNOS5_IRQ_INTFEEDCTRL_SLIMSSS

#define IRQ_SYSMMU_JPEG_0		EXYNOS5_IRQ_SYSMMU_JPEG_0
#define IRQ_SYSMMU_2D_0			EXYNOS5_IRQ_SYSMMU_2D_0

#define IRQ_SYSMMU_ROTATOR_0		EXYNOS5_IRQ_SYSMMU_ROTATOR_0
#define IRQ_SYSMMU_MDMA1_0		EXYNOS5_IRQ_SYSMMU_MDMA1_0

#define IRQ_FIMD1_FIFO			EXYNOS5_IRQ_FIMD1_FIFO
#define IRQ_FIMD1_VSYNC			EXYNOS5_IRQ_FIMD1_VSYNC
#define IRQ_FIMD1_SYSTEM		EXYNOS5_IRQ_FIMD1_SYSTEM

#define IRQ_ARMIOP_GIC			EXYNOS5_IRQ_ARMIOP_GIC
#define IRQ_ARMISP_GIC			EXYNOS5_IRQ_ARMISP_GIC
#define IRQ_IOP_GIC			EXYNOS5_IRQ_IOP_GIC
#define IRQ_ISP_GIC			EXYNOS5_IRQ_ISP_GIC

#define IRQ_GPIO1_NR_GROUPS		EXYNOS5_IRQ_GPIO1_NR_GROUPS
#define IRQ_GPIO2_NR_GROUPS		EXYNOS5_IRQ_GPIO2_NR_GROUPS

#define EXYNOS_IRQ_UARTx(x)		(EXYNOS5_IRQ_UART0 + x)

#endif

#if defined(CONFIG_ARCH_EXYNOS3)
#define S5P_EINT_BASE2                  (S5P_EINT_BASE1 + 16)
#define S5P_GPIOINT_BASE                (S5P_EINT_BASE1 + 32)
#define IRQ_GPIO_END                    (S5P_GPIOINT_BASE + S5P_GPIOINT_COUNT)
#define IRQ_TIMER_BASE                  (IRQ_GPIO_END + 64)

#define IRQ_EXYNOS_END                  IRQ_BOARD_START
#define MAX_COMBINER_NR			0
#else

#if defined(CONFIG_ARCH_EXYNOS4)
#define MAX_COMBINER_NR			(EXYNOS4_MAX_COMBINER_NR)
#else
#define MAX_COMBINER_NR			(EXYNOS5_MAX_COMBINER_NR)
#endif

#if defined (CONFIG_SOC_EXYNOS5260)
#define S5P_EINT_BASE1			IRQ_SPI(279)
#else
#define S5P_EINT_BASE1			COMBINER_IRQ(MAX_COMBINER_NR, 0)
#endif
#define S5P_EINT_BASE2			(S5P_EINT_BASE1 + 16)
#define IRQ_TVOUT_EXT_HPD		(S5P_EINT_BASE1 + 31)
#define S5P_GPIOINT_BASE		(S5P_EINT_BASE1 + 32)
#define IRQ_GPIO_END			(S5P_GPIOINT_BASE + S5P_GPIOINT_COUNT)
#define IRQ_TIMER_BASE			(IRQ_GPIO_END + 64)

#endif
#define IRQ_BOARD_START			(IRQ_TIMER_BASE + IRQ_TIMER_COUNT)
#define IRQ_BOARD_RESERVED_NR		48
#define IRQ_BOARD_CODEC_START		(IRQ_BOARD_START + IRQ_BOARD_RESERVED_NR)
#define IRQ_BOARD_CODEC_NR		128
#define IRQ_NR_BOARD			(IRQ_BOARD_RESERVED_NR + IRQ_BOARD_CODEC_NR)

#define IRQ_BOARD_AUDIO_START		(IRQ_BOARD_START + IRQ_NR_BOARD)
#define IRQ_BOARD_AUDIO_NR		130

#define IRQ_BOARD_IFIC_START    (IRQ_BOARD_AUDIO_START + IRQ_BOARD_AUDIO_NR)
#define IRQ_BOARD_IFIC_NR               32

/* Set the default NR_IRQS */
#define NR_IRQS				(IRQ_BOARD_START + IRQ_NR_BOARD + IRQ_BOARD_AUDIO_NR + IRQ_BOARD_IFIC_NR)

#define FIQ_START			0

#endif /* __ASM_ARCH_IRQS_H */
