/*
 * Copyright (C) 2010-2013 Samsung Electronics Co., Ltd.
 *
 * Exynos series device definition for JPEG HX
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <linux/dma-mapping.h>
#include <mach/map.h>
#include <mach/irqs.h>


static u64 exynos5_jpeg_hx_dma_mask = DMA_BIT_MASK(32);

static struct resource exynos5_jpeg_hx_resource[] = {
#if defined(CONFIG_SOC_EXYNOS5410) || defined(CONFIG_SOC_EXYNOS5420)
	[0] = DEFINE_RES_MEM(EXYNOS5_PA_JPEG_HX, SZ_4K),
	[1] = DEFINE_RES_IRQ(IRQ_JPEG_HX),
#elif defined(CONFIG_SOC_EXYNOS5260)
	[0] = DEFINE_RES_MEM(EXYNOS5260_PA_JPEG, SZ_4K),
	[1] = DEFINE_RES_IRQ(EXYNOS5260_IRQ_JPEG),
#elif defined(CONFIG_SOC_EXYNOS3250)
	[0] = DEFINE_RES_MEM(EXYNOS3_PA_JPEG, SZ_4K),
	[1] = DEFINE_RES_IRQ(EXYNOS3_IRQ_JPEG),
#endif
};

struct platform_device exynos5_device_jpeg_hx = {
	.name		= "exynos5-jpeg-hx",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(exynos5_jpeg_hx_resource),
	.resource	= exynos5_jpeg_hx_resource,
	.dev		= {
		.dma_mask		= &exynos5_jpeg_hx_dma_mask,
		.coherent_dma_mask	= DMA_BIT_MASK(32),
	},
};

#if defined(CONFIG_SOC_EXYNOS5420)
static struct resource exynos5_jpeg2_hx_resource[] = {
	[0] = DEFINE_RES_MEM(EXYNOS5_PA_JPEG2_HX, SZ_4K),
	[1] = DEFINE_RES_IRQ(IRQ_JPEG),
};

struct platform_device exynos5_device_jpeg2_hx = {
	.name		= "exynos5-jpeg-hx",
	.id		= 1,
	.num_resources	= ARRAY_SIZE(exynos5_jpeg2_hx_resource),
	.resource	= exynos5_jpeg2_hx_resource,
	.dev		= {
		.dma_mask		= &exynos5_jpeg_hx_dma_mask,
		.coherent_dma_mask	= DMA_BIT_MASK(32),
	},
};
#endif
