/* linux/arch/arm/mach-exynos/board-universal5420-gpio.c
 *
 * Copyright (c) 2013 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/gpio.h>
#include <plat/gpio-cfg.h>
#include <asm/system_info.h>
#include <mach/gpio-exynos.h>

#include "board-universal5260.h"

#define GPIO_LV_L	0	/* GPIO level low */
#define GPIO_LV_H	1	/* GPIO level high */
#define GPIO_LV_N	2	/* GPIO level none */

struct gpio_init_data {
	u32 num;
	u32 cfg;
	u32 val;
	u32 pud;
};

struct gpio_sleep_data {
	u32 num;
	u32 cfg;
	u32 pud;
};

struct sleep_gpio_tables {
	struct gpio_sleep_data *table;
	u32 arr_size;
};

#define MAX_BOARD_REV	0xf
static struct sleep_gpio_tables hl3g_sleep_gpio_tables[MAX_BOARD_REV];
static int nr_hl3g_sleep_gpio_table;

static struct gpio_init_data __initdata init_gpio_table[] = {
	{ EXYNOS5260_GPA1(2), S3C_GPIO_OUTPUT, GPIO_LV_H, S3C_GPIO_PULL_NONE }, /* PROX_LED_EN */
	{ EXYNOS5260_GPA1(4), S3C_GPIO_OUTPUT, GPIO_LV_L, S3C_GPIO_PULL_NONE }, /* PDA_ACTIVE */

	{ EXYNOS5260_GPB2(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* COVER_ID */
	{ EXYNOS5260_GPB4(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* PEN_SDA_1.8V */
	{ EXYNOS5260_GPB4(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* PEN_SCL_1.8V */

	{ EXYNOS5260_GPC0(2), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(0) */
	{ EXYNOS5260_GPC0(3), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(1) */
	{ EXYNOS5260_GPC0(4), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(2) */
	{ EXYNOS5260_GPC0(5), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(3) */
	{ EXYNOS5260_GPC1(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* WLAN_SDIO_CLK */
	{ EXYNOS5260_GPC1(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WLAN_SDIO_CMD */
	{ EXYNOS5260_GPC1(2), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WLAN_SDIO_D(0) */
	{ EXYNOS5260_GPC1(3), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WLAN_SDIO_D(1) */
	{ EXYNOS5260_GPC1(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WLAN_SDIO_D(2) */
	{ EXYNOS5260_GPC1(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WLAN_SDIO_D(3) */
	{ EXYNOS5260_GPC3(0), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(4) */
	{ EXYNOS5260_GPC3(1), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(5) */
	{ EXYNOS5260_GPC3(2), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(6) */
	{ EXYNOS5260_GPC3(3), S3C_GPIO_SFN(2), GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* NAND_D(7) */

	{ EXYNOS5260_GPC4(3), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* 2_TOUCH_ID */
	{ EXYNOS5260_GPD0(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* OLED_ID */

	{ EXYNOS5260_GPF1(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* CAM_SPI_SSN */

	{ EXYNOS5260_GPX0(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* WACOM_SENSE */
	{ EXYNOS5260_GPX1(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_NONE }, /* FUEL_ALERT */
	{ EXYNOS5260_GPX2(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* WLAN_WAKE_WAKE */
	{ EXYNOS5260_GPX2(1), S3C_GPIO_OUTPUT, GPIO_LV_L, S3C_GPIO_PULL_NONE }, /* BT_WAKE */

	/********** NC PIN CONFIG ****************************************************/
	{ EXYNOS5260_GPA1(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPA1(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPA2(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPA2(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPA2(6), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPA2(7), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB0(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB0(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB0(2), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB0(3), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB0(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB1(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB1(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB1(2), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB1(3), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPB2(2), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPD2(0), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPE0(7), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPE1(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPF1(4), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPF1(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPC2(2), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPZ0(1), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPZ0(5), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
	{ EXYNOS5260_GPZ0(6), S3C_GPIO_INPUT, GPIO_LV_N, S3C_GPIO_PULL_DOWN }, /* NC */
};


/*EVT1 Rev0.0 (HW_REV 00) */
static struct gpio_sleep_data sleep_gpio_table_default[] = {
	{ EXYNOS5260_GPA0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* GPS_UART_RXD */
	{ EXYNOS5260_GPA0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* GPS_UART_TXD */
	{ EXYNOS5260_GPA0(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE },	/* GPS_UART_CTS */
	{ EXYNOS5260_GPA0(3), S5P_GPIO_PD_OUTPUT1, S5P_GPIO_PD_UPDOWN_DISABLE },/* GPS_UART_RTS */

	{ EXYNOS5260_GPA1(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE },	/* AP_RXD */
	{ EXYNOS5260_GPA1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE },	/* AP_TXD */
	{ EXYNOS5260_GPA1(2), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE},	/* PROX_LED_EN */
	{ EXYNOS5260_GPA1(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE },	/* GPS_EN */
	{ EXYNOS5260_GPA1(4), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE },	/* PDA_ACTIVE */
	{ EXYNOS5260_GPA1(6), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* TF_EN */

	{ EXYNOS5260_GPA2(0), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },/* CODEC_SPI_SCK */
	{ EXYNOS5260_GPA2(1), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },/* CODEC_SPI_SS_N */
	{ EXYNOS5260_GPA2(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE },	/* CODEC_SPI_MISO */
	{ EXYNOS5260_GPA2(3), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },/* CODEC_SPI_MOSI */

	{ EXYNOS5260_GPB2(0), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE }, /* VIBTONE_PWM */
	{ EXYNOS5260_GPB2(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* COVER_ID */
	{ EXYNOS5260_GPB2(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE },	   /* ACTIVE_STATE_HSIC */

	{ EXYNOS5260_GPB3(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* AP_PMIC_SDA */
	{ EXYNOS5260_GPB3(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* AP_PMIC_SCL */
	{ EXYNOS5260_GPB3(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* VT_CAM_SDA_1.8V */
	{ EXYNOS5260_GPB3(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* VT_CAM_SCL_1.8V */
	{ EXYNOS5260_GPB3(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* SENSOR_SDA_1.8V */
	{ EXYNOS5260_GPB3(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* SENSOR_SCL_1.8V */
	{ EXYNOS5260_GPB3(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NFC_SDA_1.8V */
	{ EXYNOS5260_GPB3(7), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NFC_SCL_1.8V */

	{ EXYNOS5260_GPB4(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* IRDA_SDA */
	{ EXYNOS5260_GPB4(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* IRDA_SCL */
	{ EXYNOS5260_GPB4(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* TSP_SDA_1.8V */
	{ EXYNOS5260_GPB4(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* TSP_SCL_1.8V */
	{ EXYNOS5260_GPB4(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* PEN_SDA_1.8V */
	{ EXYNOS5260_GPB4(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* PEN_SCL_1.8V */
	{ EXYNOS5260_GPB4(6), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* e_FUSE_ON */

	{ EXYNOS5260_GPB5(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* IF_PMIC_SDA */
	{ EXYNOS5260_GPB5(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* IF_PMIC_SCL */
	{ EXYNOS5260_GPB5(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* FUEL_SDA_1.8V */
	{ EXYNOS5260_GPB5(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* FUEL_SCL_1.8V */
	{ EXYNOS5260_GPB5(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* 2TOUCH_SDA */
	{ EXYNOS5260_GPB5(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* 2TOUCH_SCL */
	{ EXYNOS5260_GPB5(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* S_LED_I2C_SCL */
	{ EXYNOS5260_GPB5(7), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* S_LED_I2C_SDA */

	{ EXYNOS5260_GPD0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* HW_REV0 */
	{ EXYNOS5260_GPD0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* HW_REV1 */
	{ EXYNOS5260_GPD0(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* HW_REV2 */
	{ EXYNOS5260_GPD0(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* HW_REV3 */
	{ EXYNOS5260_GPD0(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* OLED_ID */
	{ EXYNOS5260_GPD0(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* OLED_DET */
	{ EXYNOS5260_GPD0(6), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* MAIN_MICBIAS_EN */
	{ EXYNOS5260_GPD0(7), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CODEC_LDO_EN */

	{ EXYNOS5260_GPD1(0), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CAM_SENSOR_A2.8V_EN */
	{ EXYNOS5260_GPD1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* 2TOUCH_INT */
	{ EXYNOS5260_GPD1(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* VT_CAM_ID */
	{ EXYNOS5260_GPD1(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CCI_MODE */
	{ EXYNOS5260_GPD1(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* MLCD_RST */
	{ EXYNOS5260_GPD1(5), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE }, /* FPGA_RST_N */
	{ EXYNOS5260_GPD1(6), S5P_GPIO_PD_OUTPUT1, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CRESET_B */

	{ EXYNOS5260_GPD2(1), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* VTOUCH_LDO_EN */
	{ EXYNOS5260_GPD2(2), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* TSP_LDO_EN */
	{ EXYNOS5260_GPD2(3), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },   /* CP_ON */
	{ EXYNOS5260_GPD2(4), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE },/* AP_DUMP_INT */

	{ EXYNOS5260_GPE0(0), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CAM_FLASH_EN */
	{ EXYNOS5260_GPE0(1), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CAM_FLASH_SET */
	{ EXYNOS5260_GPE0(2), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },    /* CAM_VT_STBY */
	{ EXYNOS5260_GPE0(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE },    /* CAM_IO_EN */
	{ EXYNOS5260_GPE0(4), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },    /* CAM_VT_nRST */
	{ EXYNOS5260_GPE0(5), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },    /* CAM_RESET */
	{ EXYNOS5260_GPE0(6), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },   /* SUSPEND_REQUEST_HSIC */

	{ EXYNOS5260_GPE1(0), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE },/* IPC_SLAVE_WAKEUP */
	{ EXYNOS5260_GPE1(1), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* IRDA_EN */
	{ EXYNOS5260_GPE1(2), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE }, /* CAM_MCLK */
	{ EXYNOS5260_GPE1(3), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE }, /* VTCAM_MCLK */

	{ EXYNOS5260_GPF0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SDA_1.8V */
	{ EXYNOS5260_GPF0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SCL_1.8V */
	{ EXYNOS5260_GPF0(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* VT_CAM_SDA_1.8V */
	{ EXYNOS5260_GPF0(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* VT_CAM_SCL_1.8V */

	{ EXYNOS5260_GPF1(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SPI_SCLK */
	{ EXYNOS5260_GPF1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SPI_SSN */
	{ EXYNOS5260_GPF1(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SPI_MISO */
	{ EXYNOS5260_GPF1(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* CAM_SPI_MOSI */
	{ EXYNOS5260_GPF1(6), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* WRSTBI_EN */
	{ EXYNOS5260_GPF1(7), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* ERR_FG */

	{ EXYNOS5260_GPK0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* TP404 */
	{ EXYNOS5260_GPK0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* TP403 */

	{ EXYNOS5260_GPC0(0), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_CLK */
	{ EXYNOS5260_GPC0(1), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_CMD */
	{ EXYNOS5260_GPC0(2), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(0) */
	{ EXYNOS5260_GPC0(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(1) */
	{ EXYNOS5260_GPC0(4), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(2) */
	{ EXYNOS5260_GPC0(5), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(3) */
	{ EXYNOS5260_GPC0(6), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* EMMC_RCLK */

	{ EXYNOS5260_GPC3(0), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(4) */
	{ EXYNOS5260_GPC3(1), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(5) */
	{ EXYNOS5260_GPC3(2), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(6) */
	{ EXYNOS5260_GPC3(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NAND_D(7) */

	{ EXYNOS5260_GPC1(0), S5P_GPIO_PD_OUTPUT0, S5P_GPIO_PD_UPDOWN_DISABLE },/* WLAN_SDIO_CLK */
	{ EXYNOS5260_GPC1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* WLAN_SDIO_CMD */
	{ EXYNOS5260_GPC1(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* WLAN_SDIO_D(0) */
	{ EXYNOS5260_GPC1(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* WLAN_SDIO_D(1) */
	{ EXYNOS5260_GPC1(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* WLAN_SDIO_D(2) */
	{ EXYNOS5260_GPC1(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* WLAN_SDIO_D(3) */

	{ EXYNOS5260_GPC2(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_CLK */
	{ EXYNOS5260_GPC2(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_CMD */
	{ EXYNOS5260_GPC2(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_D(0) */
	{ EXYNOS5260_GPC2(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_D(1) */
	{ EXYNOS5260_GPC2(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_D(2) */
	{ EXYNOS5260_GPC2(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* T_FLASH_D(3) */

	{ EXYNOS5260_GPC4(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* PEN_RESET_N_1.8V */
	{ EXYNOS5260_GPC4(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* PEN_PDCT_1.8V */
	{ EXYNOS5260_GPC4(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* PEN_FWE1_1.8V */
	{ EXYNOS5260_GPC4(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* 2_TOUCH_ID */

	{ EXYNOS5260_GPX0(4), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NFC_FIRMWARE */
#if 0
	{ EXYNOS5260_GPX1(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NFC_IRQ */
#endif
	{ EXYNOS5260_GPX2(3), S5P_GPIO_PD_PREV_STATE, S5P_GPIO_PD_UPDOWN_DISABLE }, /* NFC_EN */
#if 0
	{ EXYNOS5260_GPZ0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* MM_I2S_CLK */
	{ EXYNOS5260_GPZ0(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* MM_I2S_SYNC */
	{ EXYNOS5260_GPZ0(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* MM_I2S_DI */
	{ EXYNOS5260_GPZ0(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* MM_I2S_DO */

	{ EXYNOS5260_GPZ1(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* BT_UART_RXD */
	{ EXYNOS5260_GPZ1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* BT_UART_TXD */
	{ EXYNOS5260_GPZ1(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UPDOWN_DISABLE },	/* BT_UART_CTS */
	{ EXYNOS5260_GPZ1(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_UP_ENABLE },	/* BT_UART_RTS */
#endif
	/********** NC PIN CONFIG ****************************************************/
	{ EXYNOS5260_GPA1(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPA1(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPA2(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPA2(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPA2(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPA2(7), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB0(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB0(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB0(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB0(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB1(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB1(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB1(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB1(3), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB2(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPB4(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPD2(0), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPE0(7), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPE1(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPF1(4), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPF1(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPC2(2), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
#if 0
        { EXYNOS5260_GPZ0(1), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPZ0(5), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
	{ EXYNOS5260_GPZ0(6), S5P_GPIO_PD_INPUT, S5P_GPIO_PD_DOWN_ENABLE }, /* NC */
#endif
};

/* This funtion will be init breakpoint for GPIO verification */
void gpio_init_done(void)
{
	pr_info("%s\n", __func__);
#ifdef CONFIG_SEC_GPIO_DVS
	/************************ Caution !!! ****************************/
	/* This function must be located in appropriate INIT position
	 * in accordance with the specification of each BB vendor.
	 */
	/************************ Caution !!! ****************************/
	gpio_dvs_check_initgpio();
#endif
}

static void __init config_init_gpio(void)
{
	u32 i;

	for (i = 0; i < ARRAY_SIZE(init_gpio_table); i++) {
		u32 gpio = init_gpio_table[i].num;
		s3c_gpio_setpull(gpio, init_gpio_table[i].pud);
		s3c_gpio_cfgpin(gpio, init_gpio_table[i].cfg);

		if (init_gpio_table[i].cfg == S3C_GPIO_OUTPUT)
			gpio_set_value(gpio, init_gpio_table[i].val);
	}

	gpio_init_done();
}


static void config_sleep_gpio(struct gpio_sleep_data *table, u32 arr_size)
{
	u32 i;

	for (i = 0; i < arr_size; i++) {
		s5p_gpio_set_pd_pull(table[i].num, table[i].pud);
		s5p_gpio_set_pd_cfg(table[i].num, table[i].cfg);
	}
}

static void config_sleep_gpio_tables(void)
{
	int i;

	for (i = nr_hl3g_sleep_gpio_table - 1; i >= 0; i--)
		config_sleep_gpio(hl3g_sleep_gpio_tables[i].table,
				hl3g_sleep_gpio_tables[i].arr_size);
}

void __init board_hl3g_gpio_init(void)
{
	int i = 0;

	if (system_rev > MAX_BOARD_REV)
		panic("Invalid Board Revision: %d", system_rev);

    /* initialize init gpios */
	config_init_gpio();

    /* set function for sleep gpio config */
    switch (system_rev) {
	case 0:
	default:
        /* hl3g h/w revision start from rev 1 */
		hl3g_sleep_gpio_tables[i].table = sleep_gpio_table_default;
		hl3g_sleep_gpio_tables[i].arr_size =
			ARRAY_SIZE(sleep_gpio_table_default);
		i++;
		break;
	}

	nr_hl3g_sleep_gpio_table = i;

	exynos_config_sleep_gpio = config_sleep_gpio_tables;
}
