#ifndef CMC624_REG_HEADER
#define CMC624_REG_HEADER
#endif

#define CMC624_SERVICE_EXTEND

/** CMC624 registers **/

/* SFR Bank selection */
#define CMC624_REG_SELBANK   0x00

/* A stage configuration */
#define CMC624_REG_DNRHDTROVE 0x01
#define CMC624_REG_DITHEROFF 0x06
#define CMC624_REG_CLKCONT 0x10
#define CMC624_REG_CLKGATINGOFF 0x0a
#define CMC624_REG_INPUTIFCON 0x24
#define CMC624_REG_CLKMONCONT   0x11
#define CMC624_REG_HDRTCEOFF 0x3a
#define CMC624_REG_I2C 0x0d
#define CMC624_REG_BSTAGE 0x0e
#define CMC624_REG_CABCCTRL 0x7c
#define CMC624_REG_PWMCTRL 0xb4
#define CMC624_REG_OVEMAX 0x54

/* A stage image size */
#define CMC624_REG_1280 0x22
#define CMC624_REG_800 0x23

/* B stage image size */
#define CMC624_REG_SCALERINPH 0x09
#define CMC624_REG_SCALERINPV 0x0a
#define CMC624_REG_SCALEROUTH 0x0b
#define CMC624_REG_SCALEROUTV 0x0c

/* EDRAM configuration */
#define CMC624_REG_EDRBFOUT40 0x01
#define CMC624_REG_EDRAUTOREF 0x06
#define CMC624_REG_EDRACPARAMTIM 0x07

/* Vsync Calibartion */
#define CMC624_REG_CALVAL10 0x65

/* tcon output polarity */
#define CMC624_REG_TCONOUTPOL 0x68

/* tcon RGB configuration */
#define CMC624_REG_TCONRGB1 0x6c
#define CMC624_REG_TCONRGB2 0x6d
#define CMC624_REG_TCONRGB3 0x6e

/* Reg update */
#define CMC624_REG_REGMASK 0x28
#define CMC624_REG_SWRESET 0x09
#define CMC624_REG_RGBIFEN 0x26

/*////////////////////////////////////////////////////////*/
/* CMC624 Register Setting*/
/*////////////////////////////////////////////////////////*/
static struct cmc624RegisterSet cmc624_init[] = {
	 /* CLOCK_TOP */
	 {0x00, 0x0002}, /* BANK 2 */
	 {0x30, 0x0007}, /* S.PLL DISEN, NORMAL, P = 7   (Fout = 340.11MHz) */
	 {0x31, 0x20F8}, /* S = 2, M = 248               (Fout = 340.11MHz) */
	 {0x30, 0x1007}, /* S.PLL EN, NORMAL, P = 7      (Fout = 340.11MHz) */
	 {0x3A, 0x0C04}, /* CLOCK DIVIDER VALUE (I2C = 12[28.34MHz], A = 4) */
	 {0x3B, 0x040D}, /* CLOCK DIVIDER VALUE (M1 = 4, M2 = 13) */
	 {0x3C, 0x0103}, /* CLOCK DIVIDER VALUE (B = 1, P = 3) */
	 {0x3D, 0x0005}, /* CLOCK DIVIDER VALUE (PWM = 5) */
	 {0x39, 0x007F}, /* CLOCK DIVIDER ENABLE */
	 {0x3E, 0x2223}, /* CLOCK MUX SEL */

	 {0x00, 0x0000}, /* BANK 0 */
	 {0xFD, 0x0000}, /* MODULE REG MASK RELEASE */
	 {0xFE, 0x0004}, /* MODULE REG MASK RELEASE */

	 {0xFF, 0x0000}, /* REG MASK RELEASE */

	 /* INPUT IF */
	 {0x00, 0x0002}, /* BANK 2 */
	 /* RGB BOTTOM ALIGNMENT, VSYNC/HSYNC LOW ACTIVE, DE HIHG ACTIVE */
	 {0x50, 0x0061},

	 /* TCON */
	 {0x00, 0x0002}, /* BANK 2 */
	 {0x60, 0x5400}, /* TCON VSYNC DELAY */
	 {0x3F, 0x011B}, /* mon_clk 50.4MHz */
	 {0x63, 0x0810}, /* OUTPUT COLOR MAP, TCON OUTPUT POL(LLH) */

	 {0x67, 0x0002}, /* VSYNC PULSE WIDTH = 2 */
	 {0x68, 0x005A}, /* HSYNC PULSE WIDTH = 90 */
	 {0x69, 0x0006}, /* VBP = 6 */
	 {0x6A, 0x0008}, /* VFP = 8 */
	 {0x6B, 0x007E}, /* HBP = 126 */
	 {0x6C, 0x007C}, /* HFP = 124 */
	 {0x66, 0x8000}, /* CDC */

	 /* IP */
	 {0x00, 0x0000}, /* BANK 0 */
	 {0x01, 0x0077}, /* HSYNC/DE MASK RELEASE */
	 {0x03, 0x02D0}, /* WIDTH = 720 */
	 {0x04, 0x0500}, /* HEIGHT = 1280 */
	 {0x08, 0x0000}, /* ALGO MODULE OFF */
	 {0x09, 0x0000}, /* ALGO MODULE OFF */
	 {0x0A, 0x0000}, /* ALGO MODULE OFF */

	 /* PWM */
	 {0x00, 0x0001}, /* BANK 1 */
	 {0xF8, 0x0011}, /* PWM HIGH ACTIVE, USE REGISTER VALUE */
	 {0xF9, 0x07FF}, /* ALWAYS ON */

	 /* CONV */
	 {0x00, 0x0003}, /* BANK 3 */
	 {0x01, 0x0000}, /* I2C TO MIPI */
	 {0x43, 0x8000}, /* M_BAND_CTL */
	 {0x42, 0x2339}, /* M_PLL SETTING (Fout = 494.40MHz) */
	 {0x41, 0x8000}, /* M_PLL SETTING & M_PLL ENABLE */
	 {0x44, 0x000A}, /* S_HSSETTLE */
	 {0x40, 0x0030}, /* M/S CLOCK LANE ENABLE */

	 {0x00, 0x0000}, /* BANK 0 */
	 {0xFD, 0xFFFF}, /* MODULE REG MASK RELEASE */
	 {0xFE, 0xFFFF}, /* MODULE REG MASK RELEASE */
	 {0xFF, 0x0000}, /* MASK RELEASE */

	 /* DSI HOST */
	 {0x00, 0x0003}, /* BANK 3 */
	 {0x84, 0xFFFF}, /* INTERRUPT ENABLE */

	 {0x85, 0x1FEF}, /* INTERRUPT ENABLE */
	 /* DSI FUNCTION(CMD  8 BIT DATA, RGB888,
	    CMD VC 0, VIDEO VC 0, 4 LANE) */
	 {0x86, 0x6204},
	 {0x88, 0xFFFF}, /* HIGH SPEED RECEIVE TIMEOUT */
	 {0x89, 0x00FF}, /* HIGH SPEED RECEIVE TIMEOUT */
	 {0x8A, 0xFFFF}, /* LOW POWER RECEIVE TIMEOUT */
	 {0x8B, 0x00FF}, /* LOW POWER RECEIVE TIMEOUT */
	 {0x8C, 0x001F}, /* TURN AROUND TIMEOUT */
	 {0x8E, 0x00FF}, /* DEVICE RESET TIMER */
	 {0x90, 0x02D0}, /* HORIZANTAL RESOLUTION = 720 */
	 {0x91, 0x0500}, /* VERTICAL RESOLUTION = 1280 */

	 {0x94, 0x0044}, /* HORIZANTAL SYNC PADDING COUNT */
	 {0x96, 0x005F}, /* HORIZANTAL BACK PORCH COUNT */
	 {0x98, 0x005D}, /* HORIZANTAL FRONT FORCH COUNT */
	 {0x9A, 0x021C}, /* HORIZANTAL ACTIVE AREA */

	 {0x9C, 0x0002}, /* VERTICAL SYNC PADDING COUNT */
	 {0x9E, 0x0006}, /* VERTICAL BACK PORCH COUNT */
	 {0xA0, 0x0008}, /* VERTICAL FRONT FORCH COUNT */
	 {0xA8, 0x0d07}, /* MASTER INIT TIME */
	 {0xAC, 0x0002}, /* VIDEO MODE FORMAT = NON BURST SYNC EVENT */
	 {0xB0, 0x0008}, /* VSYNC, HSYNC, COLOR MODE, SHUT DOWN POLARITY */

	 {0xB4, 0x0004}, /* LP EQUIVALENT BYTECLK */
	 /* HIGH SPEED <-> LOW POWER SWITCHING COUNTER FOR DATA LANE */
	 {0xA2, 0x0015},
	 /* HIGH SPEED -> LOW POWER SWITCHING COUNTER FOR CLOCK LANE */
	 {0xB2, 0x000B},
	 /* HIGH SPEED <- LOW POWER SWITCHING COUNTER FOR CLOCK LANE */
	 {0xB3, 0x001D},
	 {0x80, 0x0001}, /* DEVICE READY */
	 {0xA4, 0x0002}, /* COLOR MODE OFF, DPI ON */

	 /* DSI DEVICE */
	 {0x00, 0x0003}, /* BANK 3 */
	 {0xC4, 0xFFFF}, /* INTERRUPT ENABLE */
	 {0xC5, 0x01FF}, /* INTERRUPT ENABLE */
	 {0xC6, 0x0064}, /* DSI FUNCTION : BURST & NON BURST SYNC EVENT */
	 {0xC8, 0xFFFF}, /* HIGH SPEED RECEIVE TIMEOUT */
	 {0xC9, 0xFFFF}, /* HIGH SPEED RECEIVE TIMEOUT */
	 {0xCA, 0x005E}, /* LOW POWER RECEIVE TIMEOUT */
	 {0xCB, 0x0000}, /* LOW POWER RECEIVE TIMEOUT */
	 {0xCC, 0x0025}, /* TURN AROUND TIMEOUT */
	 {0xCE, 0x07D0}, /* DEVICE RESET TIMER */
	 {0xD2, 0x0000}, /* CRC, ECC, EOT ENABLE */
	 {0xD4, 0x005A}, /* HSYNC COUNT = 90 */
	 {0xD5, 0x0002}, /* VSYNC COUNT = 2 */
	 {0xC0, 0x0001}, /* DEVICE READY */

	 // Command Operation
	 {0x00, 0x0003},		// BANK 3
	 {0x07, 0x1000},		// Interrupt Mask, Data Valid Only

};

static const struct cmc624RegisterSet cmc624_wakeup[] = {
	// CLOCK_TOP
	{0x00, 0x0002},		// BANK 2
	{0x30, 0x0004},		// S.PLL DISEN, NORMAL, P = 4  (Fout = 420MHz)
	{0x31, 0x20AF},		// S = 2, M = 175              (Fout = 420MHz)
	{0x30, 0x1004},		// S.PLL EN, NORMAL, P = 4     (Fout = 420MHz)
	{0x3A, 0x0F05},		// CLOCK DIVIDER VALUE (I2C = 15[28MHz], A = 5)
	{0x3B, 0x0418},		// CLOCK DIVIDER VALUE (M1 = 4, M2 = 24)
	{0x3C, 0x1203},		// CLOCK DIVIDER VALUE (B = 18, P = 3)
	{0x3D, 0x0400},		// CLOCK DIVIDER VALUE (PWM = 1024)
	{0x39, 0x007F},		// CLOCK DIVIDER ENABLE
	{0x3E, 0x2223},		// CLOCK MUX SEL

	{0x00, 0x0000},		// BANK 0
	{0xFD, 0x0000},		// MODULE REG MASK RELEASE
	{0xFE, 0x0004},		// MODULE REG MASK RELEASE

	{0xFF, 0x0000},		// REG MASK RELEASE

	// INPUT IF
	{0x00, 0x0002},		// BANK 2
	{0x50, 0x0061},		// RGB BOTTOM ALIGNMENT, VSYNC/HSYNC LOW ACTIVE, DE HIHG ACTIVE

	// TCON
	{0x00, 0x0002},		// BANK 2
	{0x60, 0x5400},		// TCON VSYNC DELAY
	{0x63, 0x0810},		// OUTPUT COLOR MAP, TCON OUTPUT POL(LLH)
	{0x67, 0x0002},		// VSYNC PULSE WIDTH = 2
	{0x68, 0x0040},		// HSYNC PULSE WIDTH = 64
	{0x69, 0x0003},		// VBP = 3
	{0x6A, 0x000D},		// VFP = 13
	{0x6B, 0x008C},		// HBP = 140
	{0x6C, 0x0092},		// HFP = 146
	{0x66, 0x8000},		// CDC

	// IP
	{0x00, 0x0000},		// BANK 0
	{0x01, 0x0077},		// HSYNC/DE MASK RELEASE
	{0x03, 0x0500},		// WIDTH = 720 
	{0x04, 0x0320},		// HEIGHT = 1280
	{0x08, 0x0000},		// ALGO MODULE OFF
	{0x09, 0x0000},		// ALGO MODULE OFF
	{0x0A, 0x0000},		// ALGO MODULE OFF

	// CONV
	{0x00, 0x0003},		// BANK 3
	{0x01, 0x0000},		// MIPI TO MIPI
	{0x43, 0x8000},		// M_BAND_CTL
	{0x42, 0x4641},		// M_PLL SETTING (Fout = 480MHz)
	{0x41, 0x8000},		// M_PLL SETTING & M_PLL ENABLE
	{0x44, 0x000A},		// S_HSSETTLE
	{0x40, 0x0030},		// M/S CLOCK LANE ENABLE

	{0x00, 0x0000},		// BANK 0
	{0xFD, 0xFFFF},		// MODULE REG MASK RELEASE
	{0xFE, 0xFFFF},		// MODULE REG MASK RELEASE
	{0xFF, 0x0000},		// MASK RELEASE

	// DSI HOST
	{0x00, 0x0003},		// BANK 3
	{0x84, 0xFFFF},		// INTERRUPT ENABLE
	{0x85, 0x1FEF},		// INTERRUPT ENABLE
	{0x86, 0x6204},		// DSI FUNCTION (CMD  8 BIT DATA, RGB888, CMD VC 0, VIDEO VC 0, 4 LANE)
	{0x88, 0xFFFF},		// HIGH SPEED RECEIVE TIMEOUT
	{0x89, 0x00FF},		// HIGH SPEED RECEIVE TIMEOUT
	{0x8A, 0xFFFF},		// LOW POWER RECEIVE TIMEOUT
	{0x8B, 0x00FF},		// LOW POWER RECEIVE TIMEOUT
	{0x8C, 0x001F},		// TURN AROUND TIMEOUT
	{0x8E, 0x00FF},		// DEVICE RESET TIMER
	{0x90, 0x0500},		// HORIZANTAL RESOLUTION = 1280
	{0x91, 0x0320},		// VERTICAL RESOLUTION = 800

	{0x94, 0x0030},		// HORIZANTAL SYNC PADDING COUNT
	{0x96, 0x0069},		// HORIZANTAL BACK PORCH COUNT
	{0x98, 0x006E},		// HORIZANTAL FRONT FORCH COUNT
	{0x9A, 0x03C0},		// HORIZANTAL ACTIVE AREA

	{0x9C, 0x0002},		// VERTICAL SYNC PADDING COUNT
	{0x9E, 0x0003},		// VERTICAL BACK PORCH COUNT
	{0xA0, 0x000D},		// VERTICAL FRONT FORCH COUNT
	{0xA8, 0x0d07},		// MASTER INIT TIME
	{0xAC, 0x0002},		// VIDEO MODE FORMAT = NON BURST SYNC EVENT
	{0xB0, 0x0008},		// VSYNC, HSYNC, COLOR MODE, SHUT DOWN POLARITY

	{0xB4, 0x000A},		// LP EQUIVALENT BYTECLK
	{0xA2, 0x0014},		// HIGH SPEED <-> LOW POWER SWITCHING COUNTER FOR DATA LANE
	{0xB2, 0x000B},		// HIGH SPEED -> LOW POWER SWITCHING COUNTER FOR CLOCK LANE
	{0xB3, 0x001C},		// HIGH SPEED <- LOW POWER SWITCHING COUNTER FOR CLOCK LANE

	{0x80, 0x0001},		// DEVICE READY
	{0xA4, 0x0002},		// COLOR MODE OFF, DPI ON

	// DSI DEVICE
	{0x00, 0x0003},		// BANK 3
	{0xC4, 0xFFFF},		// INTERRUPT ENABLE
	{0xC5, 0x01FF},		// INTERRUPT ENABLE
	{0xC6, 0x0064},		// DSI FUNCTION : BURST & NON BURST SYNC EVENT
	{0xC8, 0xFFFF},		// HIGH SPEED RECEIVE TIMEOUT
	{0xC9, 0x0FFF},		// HIGH SPEED RECEIVE TIMEOUT
	{0xCA, 0x005E},		// LOW POWER RECEIVE TIMEOUT
	{0xCB, 0x0000},		// LOW POWER RECEIVE TIMEOUT
	{0xCC, 0x0025},		// TURN AROUND TIMEOUT
	{0xCE, 0x07D0},		// DEVICE RESET TIMER
	{0xD2, 0x0000},		// CRC, ECC, EOT ENABLE
	{0xD4, 0x0040},		// HSYNC COUNT = 64
	{0xD5, 0x0002},		// VSYNC COUNT = 2
	{0xC0, 0x0001},		// DEVICE READY

	{0x00, 0x0002},		// BANK 2
	{0x52, 0x0001},		// RGB IF ENABLE

	{0x3f, 0x011B},		// MON_CLK : TXBYTECLKHS (60MHz)
};

static const struct cmc624RegisterSet auto_browser_cabcoff[] = {
	//start Melius auto browser cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_browser_cabcon[] = {
	//start Melius auto browser cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0820},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_gallery_cabcoff[] = {
	//start Melius auto gallery cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0030},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0020},	//DE pe
	{0x00b3,0x0020},	//DE pf
	{0x00b4,0x0020},	//DE pb
	{0x00b5,0x0020},	//DE ne
	{0x00b6,0x0020},	//DE nf
	{0x00b7,0x0020},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end

};

static const struct cmc624RegisterSet auto_gallery_cabcon[] = {
	//start Melius auto gallery cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0830},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0020},	//DE pe
	{0x00b3,0x0020},	//DE pf
	{0x00b4,0x0020},	//DE pb
	{0x00b5,0x0020},	//DE ne
	{0x00b6,0x0020},	//DE nf
	{0x00b7,0x0020},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_ui_cabcoff[] = {
	//start Melius auto ui cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_ui_cabcon[] = {
	//start Melius auto ui cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0820},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_video_cabcoff[] = {
	//start Melius auto video cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0030},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0030},	//DE pe
	{0x00b3,0x0030},	//DE pf
	{0x00b4,0x0030},	//DE pb
	{0x00b5,0x0030},	//DE ne
	{0x00b6,0x0030},	//DE nf
	{0x00b7,0x0030},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_video_cabcon[] = {
	//start Melius auto video cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0830},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0030},	//DE pe
	{0x00b3,0x0030},	//DE pf
	{0x00b4,0x0030},	//DE pb
	{0x00b5,0x0030},	//DE ne
	{0x00b6,0x0030},	//DE nf
	{0x00b7,0x0030},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_vtcall_cabcoff[] = {
	//start Melius auto vtcall cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0032},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_vtcall_cabcon[] = {
	//start Melius auto vtcall cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0832},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_dmb_cabcoff[] = {
 //start Melius auto dmb cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0032},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

static const struct cmc624RegisterSet auto_dmb_cabcon[] = {
//start Melius auto dmb cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0832},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

static const struct cmc624RegisterSet cmc624_bypass[] = {
	//start Melius bypass
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0000},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet camera_cabcoff[] = {
	//start Melius camera cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_browser_cabcoff[] = {
	//start Melius dynamic browser cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0120},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_browser_cabcon[] = {
	//start Melius dynamic browser cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0920},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end

};

static const struct cmc624RegisterSet dynamic_gallery_cabcoff[] = {
	//start Melius dynamic gallery cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0130},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end

};

static const struct cmc624RegisterSet dynamic_gallery_cabcon[] = {
	//start Melius dynamic gallery cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0930},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_ui_cabcoff[] = {
	//start Melius dynamic ui cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0120},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_ui_cabcon[] = {
	//start Melius dynamic ui cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0920},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_video_cabcoff[] = {
	//start Melius dynamic video cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0130},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0050},	//DE pe
	{0x00b3,0x0050},	//DE pf
	{0x00b4,0x0050},	//DE pb
	{0x00b5,0x0050},	//DE ne
	{0x00b6,0x0050},	//DE nf
	{0x00b7,0x0050},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_video_cabcon[] = {
	//start Melius dynamic video cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0930},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0050},	//DE pe
	{0x00b3,0x0050},	//DE pf
	{0x00b4,0x0050},	//DE pb
	{0x00b5,0x0050},	//DE ne
	{0x00b6,0x0050},	//DE nf
	{0x00b7,0x0050},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_vtcall_cabcoff[] = {
	//start Melius dynamic vtcall cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0132},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00e0},	//DE pe
	{0x00b3,0x00e0},	//DE pf
	{0x00b4,0x00e0},	//DE pb
	{0x00b5,0x00e0},	//DE ne
	{0x00b6,0x00e0},	//DE nf
	{0x00b7,0x00e0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_vtcall_cabcon[] = {
	//start Melius dynamic vtcall cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0932},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00e0},	//DE pe
	{0x00b3,0x00e0},	//DE pf
	{0x00b4,0x00e0},	//DE pb
	{0x00b5,0x00e0},	//DE ne
	{0x00b6,0x00e0},	//DE nf
	{0x00b7,0x00e0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end

};

static const struct cmc624RegisterSet auto_ebook_cabcoff[] = {
	//start Melius auto ebook cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0220},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ee},	//SCR KgWg
	{0x007c,0x00dc},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet auto_ebook_cabcon[] = {
	//start Melius auto ebook cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a20},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ee},	//SCR KgWg
	{0x007c,0x00dc},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_ebook_cabcoff[] = {
	//start Melius dynamic ebook cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0120},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet dynamic_ebook_cabcon[] = {
	//start Melius dynamic ebook cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0920},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x0910},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r	 0
	{0x0041,0x0b94},	//CC lut r	16 144
	{0x0042,0x18a6},	//CC lut r	32 160
	{0x0043,0x28b8},	//CC lut r	48 176
	{0x0044,0x3ac9},	//CC lut r	64 192
	{0x0045,0x4cd9},	//CC lut r	80 208
	{0x0046,0x5ee7},	//CC lut r	96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};


static const struct cmc624RegisterSet movie_ebook_cabcoff[] = {
	//start Melius movie ebook cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_ebook_cabcon[] = {
	//start Melius movie ebook cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_ebook_cabcoff[] = {
	//start Melius standard ebook cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_ebook_cabcon[] = {
	//start Melius standard ebook cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0820},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};


static const struct cmc624RegisterSet dynamic_dmb_cabcoff[] = {
//start Melius dynamic dmb cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0132},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00e0},	//DE pe
	{0x00b3,0x00e0},	//DE pf
	{0x00b4,0x00e0},	//DE pb
	{0x00b5,0x00e0},	//DE ne	
	{0x00b6,0x00e0},	//DE nf
	{0x00b7,0x00e0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};


static const struct cmc624RegisterSet dynamic_dmb_cabcon[] = {
//start Melius dynamic dmb cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0932},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00e0},	//DE pe
	{0x00b3,0x00e0},	//DE pf
	{0x00b4,0x00e0},	//DE pb
	{0x00b5,0x00e0},	//DE ne
	{0x00b6,0x00e0},	//DE nf
	{0x00b7,0x00e0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x003f,0x0080},	//CC chsel strength
	{0x0040,0x0000},	//CC lut r   0
	{0x0041,0x0b94},	//CC lut r  16 144
	{0x0042,0x18a6},	//CC lut r  32 160
	{0x0043,0x28b8},	//CC lut r  48 176
	{0x0044,0x3ac9},	//CC lut r  64 192
	{0x0045,0x4cd9},	//CC lut r  80 208
	{0x0046,0x5ee7},	//CC lut r  96 224
	{0x0047,0x70f4},	//CC lut r 112 240
	{0x0048,0x82ff},	//CC lut r 128 255
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

static const struct cmc624RegisterSet movie_browser_cabcoff[] = {
	//start Melius movie browser cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_browser_cabcon[] = {
	//start Melius movie browser cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_gallery_cabcoff[] = {
	//start Melius movie gallery cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_gallery_cabcon[] = {
	//start Melius movie gallery cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_ui_cabcoff[] = {
	//start Melius movie ui cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_ui_cabcon[] = {
	//start Melius movie ui cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_video_cabcoff[] = {
	//start Melius movie video cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_video_cabcon[] = {
	//start Melius movie video cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_vtcall_cabcoff[] = {
	//start Melius movie vtcall cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0232},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x1010},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x1204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_vtcall_cabcon[] = {
	//start Melius movie vtcall cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a32},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x1010},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x1204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet movie_dmb_cabcoff[] = {
//start Melius movie dmb cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0232},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x1010},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x1204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

static const struct cmc624RegisterSet movie_dmb_cabcon[] = {
//start Melius movie dmb cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a32},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x0040},	//DE pe
	{0x00b3,0x0040},	//DE pf
	{0x00b4,0x0040},	//DE pb
	{0x00b5,0x0040},	//DE ne
	{0x00b6,0x0040},	//DE nf
	{0x00b7,0x0040},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x1010},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x1204},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00f1},	//SCR KgWg
	{0x007c,0x00e5},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

struct cmc624RegisterSet cmc624_tune_color_blind_cabcon[] = {
	//start Melius color blind cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

struct cmc624RegisterSet cmc624_tune_color_blind_cabcoff[] = {
	//start Melius color blind cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};



static const struct cmc624RegisterSet negative_cabcoff[] = {
	//start Melius negative cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0200},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0x00ff},	//SCR RrCr
	{0x0072,0xff00},	//SCR RgCg
	{0x0073,0xff00},	//SCR RbCb
	{0x0074,0xff00},	//SCR GrMr
	{0x0075,0x00ff},	//SCR GgMg
	{0x0076,0xff00},	//SCR GbMb
	{0x0077,0xff00},	//SCR BrYr
	{0x0078,0xff00},	//SCR BgYg
	{0x0079,0x00ff},	//SCR BbYb
	{0x007a,0xff00},	//SCR KrWr
	{0x007b,0xff00},	//SCR KgWg
	{0x007c,0xff00},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet negative_cabcon[] = {
	//start Melius negative cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0a00},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0000,0x0001},	//BANK 1
	{0x0071,0x00ff},	//SCR RrCr
	{0x0072,0xff00},	//SCR RgCg
	{0x0073,0xff00},	//SCR RbCb
	{0x0074,0xff00},	//SCR GrMr
	{0x0075,0x00ff},	//SCR GgMg
	{0x0076,0xff00},	//SCR GbMb
	{0x0077,0xff00},	//SCR BrYr
	{0x0078,0xff00},	//SCR BgYg
	{0x0079,0x00ff},	//SCR BbYb
	{0x007a,0xff00},	//SCR KrWr
	{0x007b,0xff00},	//SCR KgWg
	{0x007c,0xff00},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_browser_cabcoff[] = {
	//start Melius standard browser cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_browser_cabcon[] = {
	//start Melius standard browser cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0820},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_gallery_cabcoff[] = {
	//start Melius standard gallery cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0030},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0020},	//DE pe
	{0x00b3,0x0020},	//DE pf
	{0x00b4,0x0020},	//DE pb
	{0x00b5,0x0020},	//DE ne
	{0x00b6,0x0020},	//DE nf
	{0x00b7,0x0020},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end

};

static const struct cmc624RegisterSet standard_gallery_cabcon[] = {
	//start Melius standard gallery cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0830},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0020},	//DE pe
	{0x00b3,0x0020},	//DE pf
	{0x00b4,0x0020},	//DE pb
	{0x00b5,0x0020},	//DE ne
	{0x00b6,0x0020},	//DE nf
	{0x00b7,0x0020},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_ui_cabcoff[] = {
	//start Melius standard ui cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0020},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_ui_cabcon[] = {
	//start Melius standard ui cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0820},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_video_cabcoff[] = {
	//start Melius standard video cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0030},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0030},	//DE pe
	{0x00b3,0x0030},	//DE pf
	{0x00b4,0x0030},	//DE pb
	{0x00b5,0x0030},	//DE ne
	{0x00b6,0x0030},	//DE nf
	{0x00b7,0x0030},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_video_cabcon[] = {
	//start Melius standard video cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0830},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x00b0,0x0080},	//DE egth
	{0x00b2,0x0030},	//DE pe
	{0x00b3,0x0030},	//DE pf
	{0x00b4,0x0030},	//DE pb
	{0x00b5,0x0030},	//DE ne
	{0x00b6,0x0030},	//DE nf
	{0x00b7,0x0030},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_vtcall_cabcoff[] = {
	//start Melius standard vtcall cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0032},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_vtcall_cabcon[] = {
	//start Melius standard vtcall cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0832},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1111},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x0908},	//CS hg ry
	{0x00c1,0x0810},	//CS hg gc
	{0x00c2,0x0b10},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
	//end
};

static const struct cmc624RegisterSet standard_dmb_cabcoff[] = {
//start Melius standard dmb cabcoff
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0032},	//SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};

static const struct cmc624RegisterSet standard_dmb_cabcon[] = {
//start Melius standard dmb cabcon
	{0x0000,0x0000},	//BANK 0
	{0x0008,0x0832},	//ABC8 CP4 SCR2 CC1 | CS2 DE1 | LoG8 WIENER4 NR2 HDR1
	{0x0009,0x0000},	//MCM off
	{0x000a,0x0000},	//UC off
	{0x0030,0x0000},	//FA cs1 de8 hdr2 fa1
	{0x0080,0x1001},	//NR col con ring bl
	{0x0081,0x3f04},	//NR blRedTH maxmin
	{0x0082,0x1006},	//NR edgeTH blDecTH
	{0x0083,0x3f04},	//NR conRedTH maxmin
	{0x00b2,0x00c0},	//DE pe
	{0x00b3,0x00c0},	//DE pf
	{0x00b4,0x00c0},	//DE pb
	{0x00b5,0x00c0},	//DE ne
	{0x00b6,0x00c0},	//DE nf
	{0x00b7,0x00c0},	//DE nb
	{0x00b8,0x1000},	//DE max ratio
	{0x00b9,0x0100},	//DE min ratio
	{0x00c0,0x100a},	//CS hg ry
	{0x00c1,0x1010},	//CS hg gc
	{0x00c2,0x1010},	//CS hg bm
	{0x00c3,0x2004},	//CS weight grayTH
	{0x0000,0x0001},	//BANK 1
	{0x0071,0xff00},	//SCR RrCr
	{0x0072,0x00ff},	//SCR RgCg
	{0x0073,0x00ff},	//SCR RbCb
	{0x0074,0x00ff},	//SCR GrMr
	{0x0075,0xff00},	//SCR GgMg
	{0x0076,0x00ff},	//SCR GbMb
	{0x0077,0x00ff},	//SCR BrYr
	{0x0078,0x00ff},	//SCR BgYg
	{0x0079,0xff00},	//SCR BbYb
	{0x007a,0x00ff},	//SCR KrWr
	{0x007b,0x00ff},	//SCR KgWg
	{0x007c,0x00ff},	//SCR KbWb
	{0x00ff,0x0000},	//Mask Release
//end
};
