/* Copyright (c) 2009-2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#ifndef _MDNIE_LITE_TUNING_DATA_H_
#define _MDNIE_LITE_TUNING_DATA_H_

////////////////// UI /// /////////////////////

static char STANDARD_UI_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

static char STANDARD_UI_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

static char DYNAMIC_UI_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

static char DYNAMIC_UI_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

static char MOVIE_UI_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

static char MOVIE_UI_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

char AUTO_UI_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char AUTO_UI_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

////////////////// GALLERY /////////////////////
static char STANDARD_GALLERY_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

static char STANDARD_GALLERY_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

static char DYNAMIC_GALLERY_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

static char DYNAMIC_GALLERY_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

static char MOVIE_GALLERY_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

static char MOVIE_GALLERY_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

char AUTO_GALLERY_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

char AUTO_GALLERY_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

////////////////// VIDEO /////////////////////

static char STANDARD_VIDEO_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x07, //sharpen cc gamma 00 0 0
};

static char STANDARD_VIDEO_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

static char DYNAMIC_VIDEO_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

static char DYNAMIC_VIDEO_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

static char MOVIE_VIDEO_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

static char MOVIE_VIDEO_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

char AUTO_VIDEO_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x07, //sharpen cc gamma 00 0 0
};

char AUTO_VIDEO_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

////////////////// VT /////////////////////

static char STANDARD_VT_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

static char STANDARD_VT_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

static char DYNAMIC_VT_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

static char DYNAMIC_VT_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

static char MOVIE_VT_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

static char MOVIE_VT_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

char AUTO_VT_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x0b, //sharpen cc gamma 00 0 0
};

char AUTO_VT_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

////////////////// CAMERA /////////////////////

static char CAMERA_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

static char CAMERA_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

char AUTO_CAMERA_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x01, //sharpen cc gamma 00 0 0
};

char AUTO_CAMERA_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x0f, //curve 1 a
	0x00, //curve 2 b
	0x0f, //curve 2 a
	0x00, //curve 3 b
	0x0f, //curve 3 a
	0x00, //curve 4 b
	0x0f, //curve 4 a
	0x10, //curve 5 b
	0xb0, //curve 5 a
	0x10, //curve 6 b
	0xb0, //curve 6 a
	0x10, //curve 7 b
	0xb0, //curve 7 a
	0x10, //curve 8 b
	0xb0, //curve 8 a
	0x00, //curve 9 b
	0x20, //curve 9 a
	0x00, //curve10 b
	0x20, //curve10 a
	0x00, //curve11 b
	0x20, //curve11 a
	0x00, //curve12 b
	0x20, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};


static char CAMERA_OUTDOOR_1[] = {
	0xEB,
	0x01, 0x00, 0x03,
	0x0b,
};

static char CAMERA_OUTDOOR_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xff,
	0x00, 0xff, 0x00,
	0xff, 0x00, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x26, 0xbe,
	0x26, 0xbe, 0x26,
	0xbe, 0x26, 0xbe,
	0x0f, 0xb4, 0x05,
	0x2c, 0x48, 0x1b,
	0x6d, 0x14, 0x99,
	0x0d, 0xaf, 0x0a,
	0x00, 0xFF, 0x04,
	0x90, 0x1f, 0x88,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x04, 0x55,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x1f, 0x88,
	0x04, 0xb5,
};

static char COLD_1[] = {
	0xEB,
	0x01, 0x00, 0x33,
	0x08,
};

static char COLD_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xee,
	0x00, 0xf3, 0x00,
	0xff, 0x00, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x14, 0xA4,
	0x14, 0xA4, 0x14,
	0xA4, 0x14, 0xA4,
	0x14, 0xA4, 0x05,
	0x20, 0x1B, 0x1D,
	0x00, 0xFF, 0x04,
	0x2b, 0x1f, 0xdc,
	0x1f, 0xf9, 0x1f,
	0xee, 0x04, 0x19,
	0x1f, 0xf9, 0x1f,
	0xee, 0x1f, 0xdc,
	0x04, 0x36,
};

static char COLD_OUTDOOR_1[] = {
	0xEB,
	0x01, 0x00, 0x33,
	0x0b,
};

static char COLD_OUTDOOR_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xee,
	0x00, 0xf3, 0x00,
	0xff, 0x00, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x26, 0xbe,
	0x26, 0xbe, 0x26,
	0xbe, 0x26, 0xbe,
	0x0f, 0xb4, 0x05,
	0x2c, 0x48, 0x1b,
	0x6d, 0x14, 0x99,
	0x0d, 0xaf, 0x0a,
	0x00, 0xFF, 0x04,
	0x90, 0x1f, 0x88,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x04, 0x55,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x1f, 0x88,
	0x04, 0xb5,
};

static char WARM_1[] = {
	0xEB,
	0x01, 0x00, 0x33,
	0x08,
};

static char WARM_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xff,
	0x00, 0xf5, 0x00,
	0xe4, 0x00, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x00, 0x1A,
	0x00, 0x1A, 0x00,
	0x1A, 0x14, 0xA4,
	0x14, 0xA4, 0x14,
	0xA4, 0x14, 0xA4,
	0x14, 0xA4, 0x05,
	0x20, 0x1B, 0x1D,
	0x00, 0xFF, 0x04,
	0x2b, 0x1f, 0xdc,
	0x1f, 0xf9, 0x1f,
	0xee, 0x04, 0x19,
	0x1f, 0xf9, 0x1f,
	0xee, 0x1f, 0xdc,
	0x04, 0x36,
};

static char WARM_OUTDOOR_1[] = {
	0xEB,
	0x01, 0x00, 0x33,
	0x0b,
};

static char WARM_OUTDOOR_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xff,
	0x00, 0xf5, 0x00,
	0xe4, 0x00, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x26, 0xbe,
	0x26, 0xbe, 0x26,
	0xbe, 0x26, 0xbe,
	0x0f, 0xb4, 0x05,
	0x2c, 0x48, 0x1b,
	0x6d, 0x14, 0x99,
	0x0d, 0xaf, 0x0a,
	0x00, 0xFF, 0x04,
	0x90, 0x1f, 0x88,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x04, 0x55,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x1f, 0x88,
	0x04, 0xb5,
};

static char NEGATIVE_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x30, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

static char NEGATIVE_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0xff, //scr Cr Yb
	0x00, //scr Rr Bb
	0x00, //scr Cg Yg
	0xff, //scr Rg Bg
	0x00, //scr Cb Yr
	0xff, //scr Rb Br
	0x00, //scr Mr Mb
	0xff, //scr Gr Gb
	0xff, //scr Mg Mg
	0x00, //scr Gg Gg
	0x00, //scr Mb Mr
	0xff, //scr Gb Gr
	0x00, //scr Yr Cb
	0xff, //scr Br Rb
	0x00, //scr Yg Cg
	0xff, //scr Bg Rg
	0xff, //scr Yb Cr
	0x00, //scr Bb Rr
	0x00, //scr Wr Wb
	0xff, //scr Kr Kb
	0x00, //scr Wg Wg
	0xff, //scr Kg Kg
	0x00, //scr Wb Wr
	0xff, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1
	0x00,
	0x00, //cc r2
	0x00,
	0x00, //cc r3
	0x00,
	0x00, //cc g1
	0x00,
	0x04, //cc g2
	0x00,
	0x00, //cc g3
	0x00,
	0x00, //cc b1
	0x00,
	0x00, //cc b2
	0x00,
	0x04, //cc b3
	0x00,
};

static char OUTDOOR_VIDEO_1[] = {
	0xEB,
	0x01, 0x00, 0x03,
	0x0b,
};

static char OUTDOOR_VIDEO_2[] = {
	0xEC,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0xff, 0xff, 0x00,
	0xff, 0x00, 0xff,
	0x00, 0x00, 0xff,
	0xff, 0x00, 0xff,
	0x00, 0xff, 0x00,
	0x00, 0xff, 0xff,
	0x00, 0xff, 0x00,
	0xff, 0x00, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x00, 0x20,
	0x00, 0x20, 0x00,
	0x20, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x0c, 0xae,
	0x0c, 0xae, 0x0c,
	0xae, 0x26, 0xbe,
	0x26, 0xbe, 0x26,
	0xbe, 0x26, 0xbe,
	0x0f, 0xb4, 0x05,
	0x2c, 0x48, 0x1b,
	0x6d, 0x14, 0x99,
	0x0d, 0xaf, 0x0a,
	0x00, 0xFF, 0x04,
	0x90, 0x1f, 0x88,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x04, 0x55,
	0x1f, 0xe8, 0x1f,
	0xc3, 0x1f, 0x88,
	0x04, 0xb5,
};

char COLOR_BLIND_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x30, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

char COLOR_BLIND_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1A, //curve 1 a
	0x00, //curve 2 b
	0x1A, //curve 2 a
	0x00, //curve 3 b
	0x1A, //curve 3 a
	0x00, //curve 4 b
	0x1A, //curve 4 a
	0x00, //curve 5 b
	0x1A, //curve 5 a
	0x00, //curve 6 b
	0x1A, //curve 6 a
	0x00, //curve 7 b
	0x1A, //curve 7 a
	0x00, //curve 8 b
	0x1A, //curve 8 a
	0x00, //curve 9 b
	0x1A, //curve 9 a
	0x00, //curve10 b
	0x1A, //curve10 a
	0x00, //curve11 b
	0x1A, //curve11 a
	0x00, //curve12 b
	0x1A, //curve12 a
	0x00, //curve13 b
	0x1A, //curve13 a
	0x00, //curve14 b
	0x1A, //curve14 a
	0x00, //curve15 b
	0x1A, //curve15 a
	0x00, //curve16 b
	0x1A, //curve16 a
	0x14, //curve17 b
	0xA4, //curve17 a
	0x14, //curve18 b
	0xA4, //curve18 a
	0x14, //curve19 b
	0xA4, //curve19 a
	0x14, //curve20 b
	0xA4, //curve20 a
	0x14, //curve21 b
	0xA4, //curve21 a
	0x05, //curve22 b
	0x20, //curve22 a
	0x1B, //curve23 b
	0x1D, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06x
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

////////////////// BROWSER /////////////////////

char STANDARD_BROWSER_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char STANDARD_BROWSER_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

char DYNAMIC_BROWSER_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char DYNAMIC_BROWSER_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

char MOVIE_BROWSER_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

char MOVIE_BROWSER_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

char AUTO_BROWSER_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char AUTO_BROWSER_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

////////////////// eBOOK /////////////////////

char AUTO_EBOOK_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char AUTO_EBOOK_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

char STANDARD_EBOOK_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char STANDARD_EBOOK_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1b, //curve 1 a
	0x00, //curve 2 b
	0x1b, //curve 2 a
	0x00, //curve 3 b
	0x1b, //curve 3 a
	0x00, //curve 4 b
	0x1b, //curve 4 a
	0x00, //curve 5 b
	0x1b, //curve 5 a
	0x00, //curve 6 b
	0x1b, //curve 6 a
	0x00, //curve 7 b
	0x1b, //curve 7 a
	0x00, //curve 8 b
	0x1b, //curve 8 a
	0x00, //curve 9 b
	0x1b, //curve 9 a
	0x00, //curve10 b
	0x1b, //curve10 a
	0x05, //curve11 b
	0x9f, //curve11 a
	0x05, //curve12 b
	0x9f, //curve12 a
	0x05, //curve13 b
	0x9f, //curve13 a
	0x05, //curve14 b
	0x9f, //curve14 a
	0x05, //curve15 b
	0x9f, //curve15 a
	0x05, //curve16 b
	0x9f, //curve16 a
	0x05, //curve17 b
	0x9f, //curve17 a
	0x05, //curve18 b
	0x9f, //curve18 a
	0x08, //curve19 b
	0xa0, //curve19 a
	0x10, //curve20 b
	0xa2, //curve20 a
	0x10, //curve21 b
	0xa2, //curve21 a
	0x10, //curve22 b
	0xa2, //curve22 a
	0x10, //curve23 b
	0xa2, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.1
	0x48,
	0x1f, //cc r2
	0xc4,
	0x1f, //cc r3
	0xf4,
	0x1f, //cc g1
	0xe1,
	0x04, //cc g2
	0x2b,
	0x1f, //cc g3
	0xf4,
	0x1f, //cc b1
	0xe1,
	0x1f, //cc b2
	0xc4,
	0x04, //cc b3
	0x5b,
};

char DYNAMIC_EBOOK_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x03, //sharpen cc gamma 00 0 0
};

char DYNAMIC_EBOOK_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xff, //scr Wg Wg
	0x00, //scr Kg Kg
	0xff, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x1c, //curve 1 a
	0x00, //curve 2 b
	0x1c, //curve 2 a
	0x00, //curve 3 b
	0x1c, //curve 3 a
	0x00, //curve 4 b
	0x1c, //curve 4 a
	0x00, //curve 5 b
	0x1c, //curve 5 a
	0x00, //curve 6 b
	0x1c, //curve 6 a
	0x00, //curve 7 b
	0x1c, //curve 7 a
	0x00, //curve 8 b
	0x1c, //curve 8 a
	0x00, //curve 9 b
	0x1c, //curve 9 a
	0x00, //curve10 b
	0x1c, //curve10 a
	0x00, //curve11 b
	0x1c, //curve11 a
	0x00, //curve12 b
	0x1c, //curve12 a
	0x00, //curve13 b
	0x1c, //curve13 a
	0x0d, //curve14 b
	0xa4, //curve14 a
	0x0d, //curve15 b
	0xa4, //curve15 a
	0x0d, //curve16 b
	0xa4, //curve16 a
	0x0d, //curve17 b
	0xa4, //curve17 a
	0x0d, //curve18 b
	0xa4, //curve18 a
	0x0d, //curve19 b
	0xa4, //curve19 a
	0x0d, //curve20 b
	0xa4, //curve20 a
	0x0d, //curve21 b
	0xa4, //curve21 a
	0x25, //curve22 b
	0x1c, //curve22 a
	0x4a, //curve23 b
	0x17, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.18
	0x81,
	0x1f, //cc r2
	0x94,
	0x1f, //cc r3
	0xeb,
	0x1f, //cc g1
	0xc9,
	0x04, //cc g2
	0x4c,
	0x1f, //cc g3
	0xeb,
	0x1f, //cc b1
	0xc9,
	0x1f, //cc b2
	0x94,
	0x04, //cc b3
	0xa3,
};

char MOVIE_EBOOK_1[] = {
	0xEB,
	0x01, //mdnie_en
	0x00, //data_width mask 00 000
	0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
	0x00, //sharpen cc gamma 00 0 0
};

char MOVIE_EBOOK_2[] = {
	0xEC,
	0x00, //roi ctrl
	0x00, //roi0 x start
	0x00,
	0x00, //roi0 x end
	0x00,
	0x00, //roi0 y start
	0x00,
	0x00, //roi0 y end
	0x00,
	0x00, //roi1 x strat
	0x00,
	0x00, //roi1 x end
	0x00,
	0x00, //roi1 y start
	0x00,
	0x00, //roi1 y end
	0x00,
	0x00, //scr Cr Yb
	0xff, //scr Rr Bb
	0xff, //scr Cg Yg
	0x00, //scr Rg Bg
	0xff, //scr Cb Yr
	0x00, //scr Rb Br
	0xff, //scr Mr Mb
	0x00, //scr Gr Gb
	0x00, //scr Mg Mg
	0xff, //scr Gg Gg
	0xff, //scr Mb Mr
	0x00, //scr Gb Gr
	0xff, //scr Yr Cb
	0x00, //scr Br Rb
	0xff, //scr Yg Cg
	0x00, //scr Bg Rg
	0x00, //scr Yb Cr
	0xff, //scr Bb Rr
	0xff, //scr Wr Wb
	0x00, //scr Kr Kb
	0xf8, //scr Wg Wg
	0x00, //scr Kg Kg
	0xec, //scr Wb Wr
	0x00, //scr Kb Kr
	0x00, //curve 1 b
	0x20, //curve 1 a
	0x00, //curve 2 b
	0x20, //curve 2 a
	0x00, //curve 3 b
	0x20, //curve 3 a
	0x00, //curve 4 b
	0x20, //curve 4 a
	0x02, //curve 5 b
	0x1b, //curve 5 a
	0x02, //curve 6 b
	0x1b, //curve 6 a
	0x02, //curve 7 b
	0x1b, //curve 7 a
	0x02, //curve 8 b
	0x1b, //curve 8 a
	0x09, //curve 9 b
	0xa6, //curve 9 a
	0x09, //curve10 b
	0xa6, //curve10 a
	0x09, //curve11 b
	0xa6, //curve11 a
	0x09, //curve12 b
	0xa6, //curve12 a
	0x00, //curve13 b
	0x20, //curve13 a
	0x00, //curve14 b
	0x20, //curve14 a
	0x00, //curve15 b
	0x20, //curve15 a
	0x00, //curve16 b
	0x20, //curve16 a
	0x00, //curve17 b
	0x20, //curve17 a
	0x00, //curve18 b
	0x20, //curve18 a
	0x00, //curve19 b
	0x20, //curve19 a
	0x00, //curve20 b
	0x20, //curve20 a
	0x00, //curve21 b
	0x20, //curve21 a
	0x00, //curve22 b
	0x20, //curve22 a
	0x00, //curve23 b
	0x20, //curve23 a
	0x00, //curve24 b
	0xFF, //curve24 a
	0x04, //cc r1 0.06
	0x2b,
	0x1f, //cc r2
	0xdc,
	0x1f, //cc r3
	0xf9,
	0x1f, //cc g1
	0xee,
	0x04, //cc g2
	0x19,
	0x1f, //cc g3
	0xf9,
	0x1f, //cc b1
	0xee,
	0x1f, //cc b2
	0xdc,
	0x04, //cc b3
	0x36,
};

#endif

