/* Copyright (c) 2009-2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#ifndef _MDNIE_LITE_TUNING_DATA_DMB_H_
#define _MDNIE_LITE_TUNING_DATA_DMB_H_

static char STANDARD_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char STANDARD_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xff, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x1c, //curve 1 a
0x00, //curve 2 b
0x1c, //curve 2 a
0x00, //curve 3 b
0x1c, //curve 3 a
0x00, //curve 4 b
0x1c, //curve 4 a
0x00, //curve 5 b
0x1c, //curve 5 a
0x00, //curve 6 b
0x1c, //curve 6 a
0x00, //curve 7 b
0x1c, //curve 7 a
0x00, //curve 8 b
0x1c, //curve 8 a
0x00, //curve 9 b
0x1c, //curve 9 a
0x00, //curve10 b
0x1c, //curve10 a
0x00, //curve11 b
0x1c, //curve11 a
0x00, //curve12 b
0x1c, //curve12 a
0x00, //curve13 b
0x1c, //curve13 a
0x0d, //curve14 b
0xa4, //curve14 a
0x0d, //curve15 b
0xa4, //curve15 a
0x0d, //curve16 b
0xa4, //curve16 a
0x0d, //curve17 b
0xa4, //curve17 a
0x0d, //curve18 b
0xa4, //curve18 a
0x0d, //curve19 b
0xa4, //curve19 a
0x0d, //curve20 b
0xa4, //curve20 a
0x0d, //curve21 b
0xa4, //curve21 a
0x25, //curve22 b
0x1c, //curve22 a
0x4a, //curve23 b
0x17, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

static char NATURAL_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char NATURAL_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xf5, //scr Rr Bb
0xfc, //scr Cg Yg
0x14, //scr Rg Bg
0xe2, //scr Cb Yr
0x24, //scr Rb Br
0xff, //scr Mr Mb
0x04, //scr Gr Gb
0x2d, //scr Mg Mg
0xdb, //scr Gg Gg
0xea, //scr Mb Mr
0x23, //scr Gb Gr
0xf6, //scr Yr Cb
0x38, //scr Br Rb
0xfb, //scr Yg Cg
0x1c, //scr Bg Rg
0x4e, //scr Yb Cr
0xe5, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xfb, //scr Wg Wg
0x00, //scr Kg Kg
0xf3, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x20, //curve 1 a
0x00, //curve 2 b
0x20, //curve 2 a
0x00, //curve 3 b
0x20, //curve 3 a
0x00, //curve 4 b
0x20, //curve 4 a
0x02, //curve 5 b
0x1b, //curve 5 a
0x02, //curve 6 b
0x1b, //curve 6 a
0x02, //curve 7 b
0x1b, //curve 7 a
0x02, //curve 8 b
0x1b, //curve 8 a
0x09, //curve 9 b
0xa6, //curve 9 a
0x09, //curve10 b
0xa6, //curve10 a
0x09, //curve11 b
0xa6, //curve11 a
0x09, //curve12 b
0xa6, //curve12 a
0x00, //curve13 b
0x20, //curve13 a
0x00, //curve14 b
0x20, //curve14 a
0x00, //curve15 b
0x20, //curve15 a
0x00, //curve16 b
0x20, //curve16 a
0x00, //curve17 b
0x20, //curve17 a
0x00, //curve18 b
0x20, //curve18 a
0x00, //curve19 b
0x20, //curve19 a
0x00, //curve20 b
0x20, //curve20 a
0x00, //curve21 b
0x20, //curve21 a
0x00, //curve22 b
0x20, //curve22 a
0x00, //curve23 b
0x20, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.2
0x90,
0x1f, //cc r2
0x88,
0x1f, //cc r3
0xe8,
0x1f, //cc g1
0xc3,
0x04, //cc g2
0x55,
0x1f, //cc g3
0xe8,
0x1f, //cc b1
0xc3,
0x1f, //cc b2
0x88,
0x04, //cc b3
0xb5,
};

static char DYNAMIC_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char DYNAMIC_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xff, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x1c, //curve 1 a
0x00, //curve 2 b
0x1c, //curve 2 a
0x00, //curve 3 b
0x1c, //curve 3 a
0x00, //curve 4 b
0x1c, //curve 4 a
0x00, //curve 5 b
0x1c, //curve 5 a
0x00, //curve 6 b
0x1c, //curve 6 a
0x00, //curve 7 b
0x1c, //curve 7 a
0x00, //curve 8 b
0x1c, //curve 8 a
0x00, //curve 9 b
0x1c, //curve 9 a
0x00, //curve10 b
0x1c, //curve10 a
0x00, //curve11 b
0x1c, //curve11 a
0x00, //curve12 b
0x1c, //curve12 a
0x00, //curve13 b
0x1c, //curve13 a
0x0d, //curve14 b
0xa4, //curve14 a
0x0d, //curve15 b
0xa4, //curve15 a
0x0d, //curve16 b
0xa4, //curve16 a
0x0d, //curve17 b
0xa4, //curve17 a
0x0d, //curve18 b
0xa4, //curve18 a
0x0d, //curve19 b
0xa4, //curve19 a
0x0d, //curve20 b
0xa4, //curve20 a
0x0d, //curve21 b
0xa4, //curve21 a
0x25, //curve22 b
0x1c, //curve22 a
0x4a, //curve23 b
0x17, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.32
0xe5,
0x1f, //cc r2
0x40,
0x1f, //cc r3
0xdb,
0x1f, //cc g1
0x9e,
0x04, //cc g2
0x87,
0x1f, //cc g3
0xdb,
0x1f, //cc b1
0x9e,
0x1f, //cc b2
0x40,
0x05, //cc b3
0x22,
};

static char MOVIE_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x03, //sharpen cc gamma 00 0 0
};

static char MOVIE_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x90, //scr Cr Yb
0xd8, //scr Rr Bb
0xfc, //scr Cg Yg
0x22, //scr Rg Bg
0xea, //scr Cb Yr
0x2a, //scr Rb Br
0xe3, //scr Mr Mb
0x68, //scr Gr Gb
0x34, //scr Mg Mg
0xeb, //scr Gg Gg
0xe6, //scr Mb Mr
0x44, //scr Gb Gr
0xec, //scr Yr Cb
0x2e, //scr Br Rb
0xf6, //scr Yg Cg
0x26, //scr Bg Rg
0x60, //scr Yb Cr
0xe2, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xfb, //scr Wg Wg
0x00, //scr Kg Kg
0xf3, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x20, //curve 1 a
0x00, //curve 2 b
0x20, //curve 2 a
0x00, //curve 3 b
0x20, //curve 3 a
0x00, //curve 4 b
0x20, //curve 4 a
0x02, //curve 5 b
0x1b, //curve 5 a
0x02, //curve 6 b
0x1b, //curve 6 a
0x02, //curve 7 b
0x1b, //curve 7 a
0x02, //curve 8 b
0x1b, //curve 8 a
0x09, //curve 9 b
0xa6, //curve 9 a
0x09, //curve10 b
0xa6, //curve10 a
0x09, //curve11 b
0xa6, //curve11 a
0x09, //curve12 b
0xa6, //curve12 a
0x00, //curve13 b
0x20, //curve13 a
0x00, //curve14 b
0x20, //curve14 a
0x00, //curve15 b
0x20, //curve15 a
0x00, //curve16 b
0x20, //curve16 a
0x00, //curve17 b
0x20, //curve17 a
0x00, //curve18 b
0x20, //curve18 a
0x00, //curve19 b
0x20, //curve19 a
0x00, //curve20 b
0x20, //curve20 a
0x00, //curve21 b
0x20, //curve21 a
0x00, //curve22 b
0x20, //curve22 a
0x00, //curve23 b
0x20, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.2
0x90,
0x1f, //cc r2
0x88,
0x1f, //cc r3
0xe8,
0x1f, //cc g1
0xc3,
0x04, //cc g2
0x55,
0x1f, //cc g3
0xe8,
0x1f, //cc b1
0xc3,
0x1f, //cc b2
0x88,
0x04, //cc b3
0xb5,
};

static char COLD_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char COLD_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xed, //scr Wr Wb
0x00, //scr Kr Kb
0xf2, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x1c, //curve 1 a
0x00, //curve 2 b
0x1c, //curve 2 a
0x00, //curve 3 b
0x1c, //curve 3 a
0x00, //curve 4 b
0x1c, //curve 4 a
0x00, //curve 5 b
0x1c, //curve 5 a
0x00, //curve 6 b
0x1c, //curve 6 a
0x00, //curve 7 b
0x1c, //curve 7 a
0x00, //curve 8 b
0x1c, //curve 8 a
0x00, //curve 9 b
0x1c, //curve 9 a
0x00, //curve10 b
0x1c, //curve10 a
0x00, //curve11 b
0x1c, //curve11 a
0x00, //curve12 b
0x1c, //curve12 a
0x00, //curve13 b
0x1c, //curve13 a
0x0d, //curve14 b
0xa4, //curve14 a
0x0d, //curve15 b
0xa4, //curve15 a
0x0d, //curve16 b
0xa4, //curve16 a
0x0d, //curve17 b
0xa4, //curve17 a
0x0d, //curve18 b
0xa4, //curve18 a
0x0d, //curve19 b
0xa4, //curve19 a
0x0d, //curve20 b
0xa4, //curve20 a
0x0d, //curve21 b
0xa4, //curve21 a
0x25, //curve22 b
0x1c, //curve22 a
0x4a, //curve23 b
0x17, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

static char COLD_OUTDOOR_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char COLD_OUTDOOR_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xed, //scr Wr Wb
0x00, //scr Kr Kb
0xf2, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x20, //curve 1 a
0x00, //curve 2 b
0x20, //curve 2 a
0x00, //curve 3 b
0x20, //curve 3 a
0x00, //curve 4 b
0x20, //curve 4 a
0x00, //curve 5 b
0x20, //curve 5 a
0x00, //curve 6 b
0x20, //curve 6 a
0x00, //curve 7 b
0x20, //curve 7 a
0x0c, //curve 8 b
0xae, //curve 8 a
0x0c, //curve 9 b
0xae, //curve 9 a
0x0c, //curve10 b
0xae, //curve10 a
0x0c, //curve11 b
0xae, //curve11 a
0x0c, //curve12 b
0xae, //curve12 a
0x0c, //curve13 b
0xae, //curve13 a
0x26, //curve14 b
0xbe, //curve14 a
0x26, //curve15 b
0xbe, //curve15 a
0x26, //curve16 b
0xbe, //curve16 a
0x26, //curve17 b
0xbe, //curve17 a
0x0f, //curve18 b
0xb4, //curve18 a
0x05, //curve19 b
0x2c, //curve19 a
0x48, //curve20 b
0x1b, //curve20 a
0x6d, //curve21 b
0x14, //curve21 a
0x99, //curve22 b
0x0d, //curve22 a
0xaf, //curve23 b
0x0a, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

static char WARM_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0

};

static char WARM_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xf6, //scr Wg Wg
0x00, //scr Kg Kg
0xe5, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x1c, //curve 1 a
0x00, //curve 2 b
0x1c, //curve 2 a
0x00, //curve 3 b
0x1c, //curve 3 a
0x00, //curve 4 b
0x1c, //curve 4 a
0x00, //curve 5 b
0x1c, //curve 5 a
0x00, //curve 6 b
0x1c, //curve 6 a
0x00, //curve 7 b
0x1c, //curve 7 a
0x00, //curve 8 b
0x1c, //curve 8 a
0x00, //curve 9 b
0x1c, //curve 9 a
0x00, //curve10 b
0x1c, //curve10 a
0x00, //curve11 b
0x1c, //curve11 a
0x00, //curve12 b
0x1c, //curve12 a
0x00, //curve13 b
0x1c, //curve13 a
0x0d, //curve14 b
0xa4, //curve14 a
0x0d, //curve15 b
0xa4, //curve15 a
0x0d, //curve16 b
0xa4, //curve16 a
0x0d, //curve17 b
0xa4, //curve17 a
0x0d, //curve18 b
0xa4, //curve18 a
0x0d, //curve19 b
0xa4, //curve19 a
0x0d, //curve20 b
0xa4, //curve20 a
0x0d, //curve21 b
0xa4, //curve21 a
0x25, //curve22 b
0x1c, //curve22 a
0x4a, //curve23 b
0x17, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

static char WARM_OUTDOOR_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char WARM_OUTDOOR_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xf6, //scr Wg Wg
0x00, //scr Kg Kg
0xe5, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x20, //curve 1 a
0x00, //curve 2 b
0x20, //curve 2 a
0x00, //curve 3 b
0x20, //curve 3 a
0x00, //curve 4 b
0x20, //curve 4 a
0x00, //curve 5 b
0x20, //curve 5 a
0x00, //curve 6 b
0x20, //curve 6 a
0x00, //curve 7 b
0x20, //curve 7 a
0x0c, //curve 8 b
0xae, //curve 8 a
0x0c, //curve 9 b
0xae, //curve 9 a
0x0c, //curve10 b
0xae, //curve10 a
0x0c, //curve11 b
0xae, //curve11 a
0x0c, //curve12 b
0xae, //curve12 a
0x0c, //curve13 b
0xae, //curve13 a
0x26, //curve14 b
0xbe, //curve14 a
0x26, //curve15 b
0xbe, //curve15 a
0x26, //curve16 b
0xbe, //curve16 a
0x26, //curve17 b
0xbe, //curve17 a
0x0f, //curve18 b
0xb4, //curve18 a
0x05, //curve19 b
0x2c, //curve19 a
0x48, //curve20 b
0x1b, //curve20 a
0x6d, //curve21 b
0x14, //curve21 a
0x99, //curve22 b
0x0d, //curve22 a
0xaf, //curve23 b
0x0a, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

static char OUTDOOR_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

static char OUTDOOR_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xff, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x20, //curve 1 a
0x00, //curve 2 b
0x20, //curve 2 a
0x00, //curve 3 b
0x20, //curve 3 a
0x00, //curve 4 b
0x20, //curve 4 a
0x00, //curve 5 b
0x20, //curve 5 a
0x00, //curve 6 b
0x20, //curve 6 a
0x00, //curve 7 b
0x20, //curve 7 a
0x0c, //curve 8 b
0xae, //curve 8 a
0x0c, //curve 9 b
0xae, //curve 9 a
0x0c, //curve10 b
0xae, //curve10 a
0x0c, //curve11 b
0xae, //curve11 a
0x0c, //curve12 b
0xae, //curve12 a
0x0c, //curve13 b
0xae, //curve13 a
0x26, //curve14 b
0xbe, //curve14 a
0x26, //curve15 b
0xbe, //curve15 a
0x26, //curve16 b
0xbe, //curve16 a
0x26, //curve17 b
0xbe, //curve17 a
0x0f, //curve18 b
0xb4, //curve18 a
0x05, //curve19 b
0x2c, //curve19 a
0x48, //curve20 b
0x1b, //curve20 a
0x6d, //curve21 b
0x14, //curve21 a
0x99, //curve22 b
0x0d, //curve22 a
0xaf, //curve23 b
0x0a, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};


char AUTO_DMB_1[] = {
0xEB,
0x01, //mdnie_en
0x00, //data_width mask 00 000
0x33, //scr_roi 1 scr algo_roi 1 algo 00 1 0 00 1 0
0x0f, //sharpen cc gamma 00 0 0
};

char AUTO_DMB_2[] = {
0xEC,
0x00, //roi ctrl
0x00, //roi0 x start
0x00,
0x00, //roi0 x end
0x00,
0x00, //roi0 y start
0x00,
0x00, //roi0 y end
0x00,
0x00, //roi1 x strat
0x00,
0x00, //roi1 x end
0x00,
0x00, //roi1 y start
0x00,
0x00, //roi1 y end
0x00,
0x00, //scr Cr Yb
0xff, //scr Rr Bb
0xff, //scr Cg Yg
0x30, //scr Rg Bg
0xff, //scr Cb Yr
0x30, //scr Rb Br
0xff, //scr Mr Mb
0x00, //scr Gr Gb
0x00, //scr Mg Mg
0xff, //scr Gg Gg
0xff, //scr Mb Mr
0x00, //scr Gb Gr
0xff, //scr Yr Cb
0x00, //scr Br Rb
0xff, //scr Yg Cg
0x00, //scr Bg Rg
0x30, //scr Yb Cr
0xff, //scr Bb Rr
0xff, //scr Wr Wb
0x00, //scr Kr Kb
0xff, //scr Wg Wg
0x00, //scr Kg Kg
0xff, //scr Wb Wr
0x00, //scr Kb Kr
0x00, //curve 1 b
0x1c, //curve 1 a
0x00, //curve 2 b
0x1c, //curve 2 a
0x00, //curve 3 b
0x1c, //curve 3 a
0x00, //curve 4 b
0x1c, //curve 4 a
0x00, //curve 5 b
0x1c, //curve 5 a
0x00, //curve 6 b
0x1c, //curve 6 a
0x00, //curve 7 b
0x1c, //curve 7 a
0x00, //curve 8 b
0x1c, //curve 8 a
0x00, //curve 9 b
0x1c, //curve 9 a
0x00, //curve10 b
0x1c, //curve10 a
0x00, //curve11 b
0x1c, //curve11 a
0x00, //curve12 b
0x1c, //curve12 a
0x00, //curve13 b
0x1c, //curve13 a
0x0d, //curve14 b
0xa4, //curve14 a
0x0d, //curve15 b
0xa4, //curve15 a
0x0d, //curve16 b
0xa4, //curve16 a
0x0d, //curve17 b
0xa4, //curve17 a
0x0d, //curve18 b
0xa4, //curve18 a
0x0d, //curve19 b
0xa4, //curve19 a
0x0d, //curve20 b
0xa4, //curve20 a
0x0d, //curve21 b
0xa4, //curve21 a
0x25, //curve22 b
0x1c, //curve22 a
0x4a, //curve23 b
0x17, //curve23 a
0x00, //curve24 b
0xFF, //curve24 a
0x04, //cc r1 0.3
0xd7,
0x1f, //cc r2
0x4c,
0x1f, //cc r3
0xdd,
0x1f, //cc g1
0xa4,
0x04, //cc g2
0x7f,
0x1f, //cc g3
0xdd,
0x1f, //cc b1
0xa4,
0x1f, //cc b2
0x4c,
0x05, //cc b3
0x10,
};

#endif

