/* Copyright (c) 2011-2012, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/mfd/pm8xxx/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1802, 1816, 1813, 1813, 1800},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1161, 282, 100, 80, 71},
				{1107, 284, 100, 80, 72},
				{1052, 287, 101, 81, 72},
				{989, 287, 105, 83, 74},
				{968, 295, 108, 85, 76},
				{881, 292, 116, 92, 78},
				{870, 252, 116, 91, 80},
				{861, 255, 125, 97, 82},
				{868, 252, 118, 100, 86},
				{895, 249, 101, 88, 81},
				{933, 248, 97, 80, 73},
				{971, 249, 98, 81, 73},
				{1011, 256, 99, 83, 77},
				{1054, 274, 100, 83, 79},
				{1104, 298, 103, 83, 78},
				{1161, 324, 107, 83, 72},
				{1243, 347, 107, 83, 73},
				{1383, 366, 104, 83, 74},
				{1496, 390, 102, 80, 72},
				{1423, 387, 101, 82, 74},
				{1262, 380, 101, 83, 75},
				{1284, 387, 104, 84, 77},
				{1400, 405, 107, 87, 79},
				{1523, 426, 112, 90, 81},
				{1666, 446, 115, 92, 82},
				{1854, 462, 116, 90, 79},
				{2118, 491, 111, 87, 78},
				{2512, 546, 116, 92, 82},
				{3210, 664, 134, 107, 95},
				{7092, 150448, 13159, 13954, 143},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4323, 4320, 4317, 4315, 4307},
				{4218, 4240, 4247, 4247, 4243},
				{4155, 4184, 4190, 4190, 4187},
				{4100, 4132, 4137, 4137, 4133},
				{4058, 4084, 4086, 4086, 4082},
				{3955, 4026, 4044, 4043, 4035},
				{3911, 3946, 3979, 3988, 3991},
				{3869, 3913, 3952, 3955, 3952},
				{3840, 3882, 3909, 3916, 3915},
				{3821, 3851, 3864, 3870, 3871},
				{3808, 3825, 3833, 3834, 3835},
				{3796, 3804, 3811, 3812, 3812},
				{3784, 3789, 3794, 3794, 3794},
				{3771, 3780, 3780, 3779, 3779},
				{3758, 3771, 3771, 3767, 3763},
				{3744, 3758, 3762, 3754, 3740},
				{3728, 3736, 3744, 3734, 3720},
				{3714, 3714, 3715, 3707, 3694},
				{3700, 3703, 3692, 3684, 3673},
				{3689, 3698, 3688, 3680, 3669},
				{3682, 3695, 3688, 3680, 3669},
				{3674, 3692, 3686, 3679, 3668},
				{3664, 3689, 3685, 3678, 3666},
				{3652, 3684, 3684, 3676, 3664},
				{3635, 3672, 3678, 3670, 3658},
				{3612, 3646, 3661, 3650, 3634},
				{3580, 3600, 3616, 3603, 3589},
				{3535, 3528, 3550, 3538, 3526},
				{3470, 3415, 3459, 3449, 3442},
				{3361, 3248, 3309, 3300, 3302},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data Samsung_8930_Serrano_1900mAh_data = {
	.fcc				= 1800,
	.fcc_temp_lut		= &fcc_temp,
	.fcc_sf_lut			= &fcc_sf,
	.pc_temp_ocv_lut	= &pc_temp_ocv,
	.rbatt_sf_lut		= &rbatt_sf,
	.default_rbatt_mohm		= 206,
};
