/**
 * Filename :$File:$
 *
 * Revision :$Revision:$
 *
 * Copyright (c) LG Electronics Inc. YYYY
 *
 * Description : Example
 *
 * Date                Author                        Change
 * ----------       ----------------    ------------------------------------------
 *
 */


#ifndef        _DSA_SHA1_H_
#define        _DSA_SHA1_H_

/*************** Header files *********************************************/
//#include <stdlib.h>
//#include <memory.h>
//#include <string.h>

/*************** Assertions ***********************************************/
////////    Define the Endianness    ////////
#undef DSA_BIG_ENDIAN
#undef DSA_LITTLE_ENDIAN

#if defined(USER_BIG_ENDIAN)
    #define DSA_BIG_ENDIAN
#elif defined(USER_LITTLE_ENDIAN)
    #define DSA_LITTLE_ENDIAN
#else
    #if 1
        #define DSA_BIG_ENDIAN        //    Big-Endian machine with pointer casting
    #elif defined(_MSC_VER)
        //#define DSA_LITTLE_ENDIAN    //    Little-Endian machine with pointer casting
    #else
        #error
    #endif
#endif

/*************** Macros ***************************************************/
////////    rotate by using shift operations    ////////
#if /*defined(_MSC_VER)*/0
    #define DSA_ROTL_DWORD(x, n) _lrotl((x), (n))
    #define DSA_ROTR_DWORD(x, n) _lrotr((x), (n))
#else
    #define DSA_ROTL_DWORD(x, n) ( (DWORD)((x) << (n)) | (DWORD)((x) >> (32-(n))) )
    #define DSA_ROTR_DWORD(x, n) ( (DWORD)((x) >> (n)) | (DWORD)((x) << (32-(n))) )
#endif

////////    reverse the byte order of DWORD(DWORD:4-bytes integer) and WORD.
#define DSA_ENDIAN_REVERSE_DWORD(dwS)    ( (DSA_ROTL_DWORD((dwS),  8) & 0x00ff00ff)    \
                                     | (DSA_ROTL_DWORD((dwS), 24) & 0xff00ff00) )

////////    move DWORD type to BYTE type and BYTE type to DWORD type
#if defined(DSA_BIG_ENDIAN)        ////    Big-Endian machine
    #define DSA_BIG_B2D(B, D)        D = *(DWORD *)(B)
    #define DSA_BIG_D2B(D, B)        *(DWORD *)(B) = (DWORD)(D)
    #define DSA_LITTLE_B2D(B, D)    D = DSA_ENDIAN_REVERSE_DWORD(*(DWORD *)(B))
    #define DSA_LITTLE_D2B(D, B)    *(DWORD *)(B) = DSA_ENDIAN_REVERSE_DWORD(D)
#elif defined(DSA_LITTLE_ENDIAN)    ////    Little-Endian machine
    #define DSA_BIG_B2D(B, D)        D = DSA_ENDIAN_REVERSE_DWORD(*(DWORD *)(B))
    #define DSA_BIG_D2B(D, B)        *(DWORD *)(B) = DSA_ENDIAN_REVERSE_DWORD(D)
    #define DSA_LITTLE_B2D(B, D)    D = *(DWORD *)(B)
    #define DSA_LITTLE_D2B(D, B)    *(DWORD *)(B) = (DWORD)(D)
#else
    #error ERROR : Invalid DataChangeType
#endif

/*************** Definitions / Macros  ************************************/
////    SHA1 õ 
#define DSA_SHA1_DIGEST_BLOCKLEN    64        //    in bytes
#define DSA_SHA1_DIGEST_VALUELEN    20        //    in bytes

/*************** New Data Types *******************************************/
////////    Determine data types depand on the processor and compiler.
#define BOOL    int                    //    1-bit data type
#define BYTE    unsigned char        //    unsigned 1-byte data type
#define WORD    unsigned short int    //    unsigned 2-bytes data type
#define DWORD    unsigned int        //    unsigned 4-bytes data type
#define TRUE    1                        //
#define FALSE    0                        //
#define RET_VAL        DWORD                //    return values

////    SHA1..
typedef struct{
    DWORD        ChainVar[DSA_SHA1_DIGEST_VALUELEN/4];    //    Chaining Variable 
    DWORD        Count[4];                            //
    BYTE        Buffer[DSA_SHA1_DIGEST_BLOCKLEN];        //    Buffer for unfilled block
} DSA_SHA1_ALG_INFO;

/*************** Constant (Error Code) ************************************/
////    Error Code - ϰ,  ؾ .
//#define DSA_CTR_SUCCESS                    0

/*************** Prototypes ***********************************************/
////    Init/Update/Final  ȣȭ.
void    DSA_SHA1_Init(
        DSA_SHA1_ALG_INFO    *AlgInfo);
void    DSA_SHA1_Update(
        DSA_SHA1_ALG_INFO    *AlgInfo,
        BYTE            *Message,        //    Ÿ Էµ
        DWORD            MessageLen);
void    DSA_SHA1_Final(
        DSA_SHA1_ALG_INFO    *AlgInfo,
        BYTE            *Digest);        //    ؽ µ

/*************** END OF FILE **********************************************/
#endif    //    _SHA1_H
