/**
 * Copyright(c) 2015 by LG Electronics. Confidential and Proprietary
 * All Rights Reserved.
 *
 * Filename :$File:$
 *
 * Revision :$Revision:$
 *
 * Description : Example
 *
 * Date                Author                        Change
 * ----------       ----------------    ------------------------------------------
 *
 */

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE 1
#endif

//#include <stdlib.h>
#include <string.h>
//#include <stdio.h>

#include    "lge_fota_std.h"

#include "rsa_core.h"
#include "rsa_sha1.h"
#include    "bio.h"
#include    "rsa.h"
#include    "evp.h"
#include    "objects.h"
#include    "x509.h"

//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
#define        TEMP_RSA_SIG_SIZE        256


//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
ua_s32             (*pfSeek)(ua_s32);
ua_s32             (*pfRead)(ua_u8 *, ua_s32);


//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
static X509*    _ReadCertificate(ua_u8 *pCertBuf, ua_file hKey);
static ua_s32    _VerifySignature(ua_u32 uiObjLen, ua_u8 *pSigBuf, ua_u32 uiSigLen, EVP_PKEY *pPkey, ua_s32 (*Seek)(ua_u32), ua_u32 (*Read)(ua_u8 *, ua_u32));


static X509*    _ReadCertificate(ua_u8 *pCertBuf, ua_file hKey)
{
    ua_u32             uiCertLen;
    BIO                *pCert;
    EVP_PKEY           *pKey;
    X509               *pX509;

    uiCertLen = DevFS_GetFileSize(hKey);

    DevFS_Read(hKey, pCertBuf, uiCertLen);

    pCert = BIO_new_mem_buf(pCertBuf, uiCertLen);
    pX509 = d2i_X509_bio(pCert, NULL);
    BIO_free(pCert);

    if (pX509 == NULL) {
        FOTALOG_PRINT("_ReadCertificate : fail");
    }

    return pX509;
}


static ua_s32    _VerifySignature(ua_u32 uiObjLen, ua_u8 *pSigBuf, ua_u32 uiSigLen, EVP_PKEY *pPkey, ua_s32 (*Seek)(ua_u32), ua_u32 (*Read)(ua_u8 *, ua_u32))
{
    EVP_MD_CTX        md_ctx;
    ua_u8            uiObjBuf[1024+32];
    ua_u32            uiObjOffset = TEMP_RSA_SIG_SIZE;

    EVP_VerifyInit   (&md_ctx, EVP_sha256());

    for(;;) {
        if(uiObjLen < 1024 ) {
            Seek(uiObjOffset);
            Read(uiObjBuf, uiObjLen);

            EVP_VerifyUpdate (&md_ctx, uiObjBuf, uiObjLen);

            break;
        }
        else {
            Seek(uiObjOffset);
            Read(uiObjBuf, 1024);

            EVP_VerifyUpdate (&md_ctx, uiObjBuf, 1024);

            uiObjLen    -= 1024;
            uiObjOffset    += 1024;
        }
    }

    return EVP_VerifyFinal (&md_ctx, pSigBuf, uiSigLen, pPkey);
}


ua_bool    RSA2048_CheckSign(ua_u32 obj_len, ua_u32 *SIG_LENGTH, ua_s32 (*Seek)(ua_u32), ua_u32 (*Read)(ua_u8 *, ua_u32))
{
    ua_s32            iErr;
    ua_u8            *pucCertBuf;
    ua_u8            *pucSigBuf;
    ua_u32            uiSigLen;
    ua_u16              usaBuffer[128];
    EVP_PKEY         *pKey;
    X509             *pX509;
    ua_file           hKey = -1;
    ua_bool           bResult;

    pucCertBuf  = ua_null;
    pucSigBuf   = ua_null;
    bResult     = ua_false;

    UtilBasic_UTF8ToUCS2(LGE_FOTA_RSA_KEY_PATH, usaBuffer);

    hKey = DevFS_Open(usaBuffer, FS_ACCESS_MODE_READONLY);
    if (hKey < 0) {
        return ua_false;
    }

#ifdef    FEATURE_LGE_FOTA_FIPS
    if(FIPS_mode() != 1)
    {
        if (!FIPS_mode_set(1))
        {
            printf("result error fips \n");
            FOTALOG_PRINT("result error fips");
            goto rsa_err;
        }
        FOTALOG_PRINT("FIPS_mode success");
    }
    else
    {
        printf("Already in FIPS mode \n");
        FOTALOG_PRINT("Already in FIPS mode");
    }
#endif

    /* load signature */
    uiSigLen = TEMP_RSA_SIG_SIZE;
    pucSigBuf = (ua_u8 *)FOTA_HEAP_ALLOC(TEMP_RSA_SIG_SIZE + 1);
    if (pucSigBuf == ua_null) {
        goto rsa_err;
    }

    Seek(0);
    Read(pucSigBuf, uiSigLen);

    (*SIG_LENGTH) = uiSigLen;
    obj_len -= (*SIG_LENGTH);

    /* Read certificate */
    pucCertBuf = (ua_u8 *)FOTA_HEAP_ALLOC(DevFS_GetFileSize(hKey) + 1);
    if (pucCertBuf == ua_null) {
        goto rsa_err;
    }

    pX509 = _ReadCertificate(pucCertBuf, hKey);

    /* Get public key - eay */
    pKey = X509_get_pubkey(pX509);
    if (pKey == ua_null) {
        FOTALOG_PRINT("Get public key : fail");
        goto rsa_err;
    }

    /* Verify the signature */
    iErr = _VerifySignature(obj_len, pucSigBuf, uiSigLen, pKey, Seek, Read);
    if (iErr != 1) {
        FOTALOG_PRINT("Signature Verification fail");
        goto rsa_err;
    }

    bResult = ua_true;

rsa_err:
    DevFS_Close(hKey);

    FOTA_HEAP_FREE(pucCertBuf);
    FOTA_HEAP_FREE(pucSigBuf);
    FOTALOG_PRINT("[CCAudit] Signature verification for software updates = %s\n", bResult ? "Success" : "Failure");
    return bResult;
}
